<?php

namespace PHPMaker2023\co;

// Page object
$TanamBibitList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { tanam_bibit: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ftanam_bibitsrch" id="ftanam_bibitsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="on">
<div id="ftanam_bibitsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { tanam_bibit: currentTable } });
var currentForm;
var ftanam_bibitsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ftanam_bibitsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [], fields.id.isInvalid],
            ["tgl_tanam", [ew.Validators.datetime(fields.tgl_tanam.clientFormatPattern)], fields.tgl_tanam.isInvalid],
            ["y_tgl_tanam", [ew.Validators.between], false],
            ["jenis_lahan", [], fields.jenis_lahan.isInvalid],
            ["varietas", [], fields.varietas.isInvalid],
            ["jumlah_tanam", [], fields.jumlah_tanam.isInvalid],
            ["ket", [], fields.ket.isInvalid],
            ["id_kontrak_tanam", [], fields.id_kontrak_tanam.isInvalid],
            ["gen_bibit", [], fields.gen_bibit.isInvalid],
            ["id_asal_bibit", [], fields.id_asal_bibit.isInvalid],
            ["jumlah_panen_stek", [], fields.jumlah_panen_stek.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "jenis_lahan": <?= $Page->jenis_lahan->toClientList($Page) ?>,
            "varietas": <?= $Page->varietas->toClientList($Page) ?>,
            "id_kontrak_tanam": <?= $Page->id_kontrak_tanam->toClientList($Page) ?>,
            "gen_bibit": <?= $Page->gen_bibit->toClientList($Page) ?>,
            "id_asal_bibit": <?= $Page->id_asal_bibit->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->tgl_tanam->Visible) { // tgl_tanam ?>
<?php
if (!$Page->tgl_tanam->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_tgl_tanam" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->tgl_tanam->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_tgl_tanam" class="ew-search-caption ew-label"><?= $Page->tgl_tanam->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_tgl_tanam" id="z_tgl_tanam" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->tgl_tanam->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->tgl_tanam->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_tanam_bibit_tgl_tanam" class="ew-search-field">
<input type="<?= $Page->tgl_tanam->getInputTextType() ?>" name="x_tgl_tanam" id="x_tgl_tanam" data-table="tanam_bibit" data-field="x_tgl_tanam" value="<?= $Page->tgl_tanam->EditValue ?>" placeholder="<?= HtmlEncode($Page->tgl_tanam->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tgl_tanam->formatPattern()) ?>"<?= $Page->tgl_tanam->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tgl_tanam->getErrorMessage(false) ?></div>
<?php if (!$Page->tgl_tanam->ReadOnly && !$Page->tgl_tanam->Disabled && !isset($Page->tgl_tanam->EditAttrs["readonly"]) && !isset($Page->tgl_tanam->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftanam_bibitsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("ftanam_bibitsrch", "x_tgl_tanam", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_tanam_bibit_tgl_tanam" class="ew-search-field2 d-none">
<input type="<?= $Page->tgl_tanam->getInputTextType() ?>" name="y_tgl_tanam" id="y_tgl_tanam" data-table="tanam_bibit" data-field="x_tgl_tanam" value="<?= $Page->tgl_tanam->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->tgl_tanam->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tgl_tanam->formatPattern()) ?>"<?= $Page->tgl_tanam->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tgl_tanam->getErrorMessage(false) ?></div>
<?php if (!$Page->tgl_tanam->ReadOnly && !$Page->tgl_tanam->Disabled && !isset($Page->tgl_tanam->EditAttrs["readonly"]) && !isset($Page->tgl_tanam->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftanam_bibitsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("ftanam_bibitsrch", "y_tgl_tanam", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->jenis_lahan->Visible) { // jenis_lahan ?>
<?php
if (!$Page->jenis_lahan->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_jenis_lahan" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->jenis_lahan->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->jenis_lahan->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_jenis_lahan" id="z_jenis_lahan" value="LIKE">
</div>
        </div>
        <div id="el_tanam_bibit_jenis_lahan" class="ew-search-field">
<template id="tp_x_jenis_lahan">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="tanam_bibit" data-field="x_jenis_lahan" name="x_jenis_lahan" id="x_jenis_lahan"<?= $Page->jenis_lahan->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_jenis_lahan" class="ew-item-list"></div>
<selection-list hidden
    id="x_jenis_lahan"
    name="x_jenis_lahan"
    value="<?= HtmlEncode($Page->jenis_lahan->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_jenis_lahan"
    data-target="dsl_x_jenis_lahan"
    data-repeatcolumn="5"
    class="form-control<?= $Page->jenis_lahan->isInvalidClass() ?>"
    data-table="tanam_bibit"
    data-field="x_jenis_lahan"
    data-value-separator="<?= $Page->jenis_lahan->displayValueSeparatorAttribute() ?>"
    <?= $Page->jenis_lahan->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->jenis_lahan->getErrorMessage(false) ?></div>
<?= $Page->jenis_lahan->Lookup->getParamTag($Page, "p_x_jenis_lahan") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->varietas->Visible) { // varietas ?>
<?php
if (!$Page->varietas->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_varietas" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->varietas->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_varietas" class="ew-search-caption ew-label"><?= $Page->varietas->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_varietas" id="z_varietas" value="=">
</div>
        </div>
        <div id="el_tanam_bibit_varietas" class="ew-search-field">
    <select
        id="x_varietas"
        name="x_varietas"
        class="form-select ew-select<?= $Page->varietas->isInvalidClass() ?>"
        <?php if (!$Page->varietas->IsNativeSelect) { ?>
        data-select2-id="ftanam_bibitsrch_x_varietas"
        <?php } ?>
        data-table="tanam_bibit"
        data-field="x_varietas"
        data-value-separator="<?= $Page->varietas->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->varietas->getPlaceHolder()) ?>"
        <?= $Page->varietas->editAttributes() ?>>
        <?= $Page->varietas->selectOptionListHtml("x_varietas") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->varietas->getErrorMessage(false) ?></div>
<?= $Page->varietas->Lookup->getParamTag($Page, "p_x_varietas") ?>
<?php if (!$Page->varietas->IsNativeSelect) { ?>
<script>
loadjs.ready("ftanam_bibitsrch", function() {
    var options = { name: "x_varietas", selectId: "ftanam_bibitsrch_x_varietas" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftanam_bibitsrch.lists.varietas?.lookupOptions.length) {
        options.data = { id: "x_varietas", form: "ftanam_bibitsrch" };
    } else {
        options.ajax = { id: "x_varietas", form: "ftanam_bibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.tanam_bibit.fields.varietas.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->id_kontrak_tanam->Visible) { // id_kontrak_tanam ?>
<?php
if (!$Page->id_kontrak_tanam->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_id_kontrak_tanam" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->id_kontrak_tanam->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_id_kontrak_tanam" class="ew-search-caption ew-label"><?= $Page->id_kontrak_tanam->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_id_kontrak_tanam" id="z_id_kontrak_tanam" value="LIKE">
</div>
        </div>
        <div id="el_tanam_bibit_id_kontrak_tanam" class="ew-search-field">
    <select
        id="x_id_kontrak_tanam"
        name="x_id_kontrak_tanam"
        class="form-select ew-select<?= $Page->id_kontrak_tanam->isInvalidClass() ?>"
        <?php if (!$Page->id_kontrak_tanam->IsNativeSelect) { ?>
        data-select2-id="ftanam_bibitsrch_x_id_kontrak_tanam"
        <?php } ?>
        data-table="tanam_bibit"
        data-field="x_id_kontrak_tanam"
        data-value-separator="<?= $Page->id_kontrak_tanam->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->id_kontrak_tanam->getPlaceHolder()) ?>"
        <?= $Page->id_kontrak_tanam->editAttributes() ?>>
        <?= $Page->id_kontrak_tanam->selectOptionListHtml("x_id_kontrak_tanam") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->id_kontrak_tanam->getErrorMessage(false) ?></div>
<?= $Page->id_kontrak_tanam->Lookup->getParamTag($Page, "p_x_id_kontrak_tanam") ?>
<?php if (!$Page->id_kontrak_tanam->IsNativeSelect) { ?>
<script>
loadjs.ready("ftanam_bibitsrch", function() {
    var options = { name: "x_id_kontrak_tanam", selectId: "ftanam_bibitsrch_x_id_kontrak_tanam" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftanam_bibitsrch.lists.id_kontrak_tanam?.lookupOptions.length) {
        options.data = { id: "x_id_kontrak_tanam", form: "ftanam_bibitsrch" };
    } else {
        options.ajax = { id: "x_id_kontrak_tanam", form: "ftanam_bibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.tanam_bibit.fields.id_kontrak_tanam.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->gen_bibit->Visible) { // gen_bibit ?>
<?php
if (!$Page->gen_bibit->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_gen_bibit" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->gen_bibit->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_gen_bibit" class="ew-search-caption ew-label"><?= $Page->gen_bibit->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gen_bibit" id="z_gen_bibit" value="LIKE">
</div>
        </div>
        <div id="el_tanam_bibit_gen_bibit" class="ew-search-field">
    <select
        id="x_gen_bibit"
        name="x_gen_bibit"
        class="form-select ew-select<?= $Page->gen_bibit->isInvalidClass() ?>"
        <?php if (!$Page->gen_bibit->IsNativeSelect) { ?>
        data-select2-id="ftanam_bibitsrch_x_gen_bibit"
        <?php } ?>
        data-table="tanam_bibit"
        data-field="x_gen_bibit"
        data-value-separator="<?= $Page->gen_bibit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gen_bibit->getPlaceHolder()) ?>"
        <?= $Page->gen_bibit->editAttributes() ?>>
        <?= $Page->gen_bibit->selectOptionListHtml("x_gen_bibit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gen_bibit->getErrorMessage(false) ?></div>
<?= $Page->gen_bibit->Lookup->getParamTag($Page, "p_x_gen_bibit") ?>
<?php if (!$Page->gen_bibit->IsNativeSelect) { ?>
<script>
loadjs.ready("ftanam_bibitsrch", function() {
    var options = { name: "x_gen_bibit", selectId: "ftanam_bibitsrch_x_gen_bibit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftanam_bibitsrch.lists.gen_bibit?.lookupOptions.length) {
        options.data = { id: "x_gen_bibit", form: "ftanam_bibitsrch" };
    } else {
        options.ajax = { id: "x_gen_bibit", form: "ftanam_bibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.tanam_bibit.fields.gen_bibit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->id_asal_bibit->Visible) { // id_asal_bibit ?>
<?php
if (!$Page->id_asal_bibit->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_id_asal_bibit" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->id_asal_bibit->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_id_asal_bibit" class="ew-search-caption ew-label"><?= $Page->id_asal_bibit->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id_asal_bibit" id="z_id_asal_bibit" value="=">
</div>
        </div>
        <div id="el_tanam_bibit_id_asal_bibit" class="ew-search-field">
    <select
        id="x_id_asal_bibit"
        name="x_id_asal_bibit"
        class="form-select ew-select<?= $Page->id_asal_bibit->isInvalidClass() ?>"
        <?php if (!$Page->id_asal_bibit->IsNativeSelect) { ?>
        data-select2-id="ftanam_bibitsrch_x_id_asal_bibit"
        <?php } ?>
        data-table="tanam_bibit"
        data-field="x_id_asal_bibit"
        data-value-separator="<?= $Page->id_asal_bibit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->id_asal_bibit->getPlaceHolder()) ?>"
        <?= $Page->id_asal_bibit->editAttributes() ?>>
        <?= $Page->id_asal_bibit->selectOptionListHtml("x_id_asal_bibit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->id_asal_bibit->getErrorMessage(false) ?></div>
<?= $Page->id_asal_bibit->Lookup->getParamTag($Page, "p_x_id_asal_bibit") ?>
<?php if (!$Page->id_asal_bibit->IsNativeSelect) { ?>
<script>
loadjs.ready("ftanam_bibitsrch", function() {
    var options = { name: "x_id_asal_bibit", selectId: "ftanam_bibitsrch_x_id_asal_bibit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftanam_bibitsrch.lists.id_asal_bibit?.lookupOptions.length) {
        options.data = { id: "x_id_asal_bibit", form: "ftanam_bibitsrch" };
    } else {
        options.ajax = { id: "x_id_asal_bibit", form: "ftanam_bibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.tanam_bibit.fields.id_asal_bibit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ftanam_bibitsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ftanam_bibitsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ftanam_bibitsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ftanam_bibitsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="on">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="tanam_bibit">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_tanam_bibit" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_tanam_bibitlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = ROWTYPE_HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_tanam_bibit_id" class="tanam_bibit_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->tgl_tanam->Visible) { // tgl_tanam ?>
        <th data-name="tgl_tanam" class="<?= $Page->tgl_tanam->headerCellClass() ?>"><div id="elh_tanam_bibit_tgl_tanam" class="tanam_bibit_tgl_tanam"><?= $Page->renderFieldHeader($Page->tgl_tanam) ?></div></th>
<?php } ?>
<?php if ($Page->jenis_lahan->Visible) { // jenis_lahan ?>
        <th data-name="jenis_lahan" class="<?= $Page->jenis_lahan->headerCellClass() ?>"><div id="elh_tanam_bibit_jenis_lahan" class="tanam_bibit_jenis_lahan"><?= $Page->renderFieldHeader($Page->jenis_lahan) ?></div></th>
<?php } ?>
<?php if ($Page->varietas->Visible) { // varietas ?>
        <th data-name="varietas" class="<?= $Page->varietas->headerCellClass() ?>"><div id="elh_tanam_bibit_varietas" class="tanam_bibit_varietas"><?= $Page->renderFieldHeader($Page->varietas) ?></div></th>
<?php } ?>
<?php if ($Page->jumlah_tanam->Visible) { // jumlah_tanam ?>
        <th data-name="jumlah_tanam" class="<?= $Page->jumlah_tanam->headerCellClass() ?>"><div id="elh_tanam_bibit_jumlah_tanam" class="tanam_bibit_jumlah_tanam"><?= $Page->renderFieldHeader($Page->jumlah_tanam) ?></div></th>
<?php } ?>
<?php if ($Page->ket->Visible) { // ket ?>
        <th data-name="ket" class="<?= $Page->ket->headerCellClass() ?>"><div id="elh_tanam_bibit_ket" class="tanam_bibit_ket"><?= $Page->renderFieldHeader($Page->ket) ?></div></th>
<?php } ?>
<?php if ($Page->id_kontrak_tanam->Visible) { // id_kontrak_tanam ?>
        <th data-name="id_kontrak_tanam" class="<?= $Page->id_kontrak_tanam->headerCellClass() ?>"><div id="elh_tanam_bibit_id_kontrak_tanam" class="tanam_bibit_id_kontrak_tanam"><?= $Page->renderFieldHeader($Page->id_kontrak_tanam) ?></div></th>
<?php } ?>
<?php if ($Page->gen_bibit->Visible) { // gen_bibit ?>
        <th data-name="gen_bibit" class="<?= $Page->gen_bibit->headerCellClass() ?>"><div id="elh_tanam_bibit_gen_bibit" class="tanam_bibit_gen_bibit"><?= $Page->renderFieldHeader($Page->gen_bibit) ?></div></th>
<?php } ?>
<?php if ($Page->id_asal_bibit->Visible) { // id_asal_bibit ?>
        <th data-name="id_asal_bibit" class="<?= $Page->id_asal_bibit->headerCellClass() ?>"><div id="elh_tanam_bibit_id_asal_bibit" class="tanam_bibit_id_asal_bibit"><?= $Page->renderFieldHeader($Page->id_asal_bibit) ?></div></th>
<?php } ?>
<?php if ($Page->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
        <th data-name="jumlah_panen_stek" class="<?= $Page->jumlah_panen_stek->headerCellClass() ?>"><div id="elh_tanam_bibit_jumlah_panen_stek" class="tanam_bibit_jumlah_panen_stek"><?= $Page->renderFieldHeader($Page->jumlah_panen_stek) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_id" class="el_tanam_bibit_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tgl_tanam->Visible) { // tgl_tanam ?>
        <td data-name="tgl_tanam"<?= $Page->tgl_tanam->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_tgl_tanam" class="el_tanam_bibit_tgl_tanam">
<span<?= $Page->tgl_tanam->viewAttributes() ?>>
<?= $Page->tgl_tanam->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jenis_lahan->Visible) { // jenis_lahan ?>
        <td data-name="jenis_lahan"<?= $Page->jenis_lahan->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_jenis_lahan" class="el_tanam_bibit_jenis_lahan">
<span<?= $Page->jenis_lahan->viewAttributes() ?>>
<?= $Page->jenis_lahan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->varietas->Visible) { // varietas ?>
        <td data-name="varietas"<?= $Page->varietas->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_varietas" class="el_tanam_bibit_varietas">
<span<?= $Page->varietas->viewAttributes() ?>>
<?= $Page->varietas->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jumlah_tanam->Visible) { // jumlah_tanam ?>
        <td data-name="jumlah_tanam"<?= $Page->jumlah_tanam->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_jumlah_tanam" class="el_tanam_bibit_jumlah_tanam">
<span<?= $Page->jumlah_tanam->viewAttributes() ?>>
<?= $Page->jumlah_tanam->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ket->Visible) { // ket ?>
        <td data-name="ket"<?= $Page->ket->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_ket" class="el_tanam_bibit_ket">
<span<?= $Page->ket->viewAttributes() ?>>
<?= $Page->ket->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->id_kontrak_tanam->Visible) { // id_kontrak_tanam ?>
        <td data-name="id_kontrak_tanam"<?= $Page->id_kontrak_tanam->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_id_kontrak_tanam" class="el_tanam_bibit_id_kontrak_tanam">
<span<?= $Page->id_kontrak_tanam->viewAttributes() ?>>
<?= $Page->id_kontrak_tanam->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gen_bibit->Visible) { // gen_bibit ?>
        <td data-name="gen_bibit"<?= $Page->gen_bibit->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_gen_bibit" class="el_tanam_bibit_gen_bibit">
<span<?= $Page->gen_bibit->viewAttributes() ?>>
<?= $Page->gen_bibit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->id_asal_bibit->Visible) { // id_asal_bibit ?>
        <td data-name="id_asal_bibit"<?= $Page->id_asal_bibit->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_id_asal_bibit" class="el_tanam_bibit_id_asal_bibit">
<span<?= $Page->id_asal_bibit->viewAttributes() ?>>
<?= $Page->id_asal_bibit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
        <td data-name="jumlah_panen_stek"<?= $Page->jumlah_panen_stek->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_tanam_bibit_jumlah_panen_stek" class="el_tanam_bibit_jumlah_panen_stek">
<span<?= $Page->jumlah_panen_stek->viewAttributes() ?>>
<?= $Page->jumlah_panen_stek->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }
    if (
        $Page->Recordset &&
        !$Page->Recordset->EOF &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->Recordset->moveNext();
    }
    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = ROWTYPE_AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_tanam_bibit_id" class="tanam_bibit_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->tgl_tanam->Visible) { // tgl_tanam ?>
        <td data-name="tgl_tanam" class="<?= $Page->tgl_tanam->footerCellClass() ?>"><span id="elf_tanam_bibit_tgl_tanam" class="tanam_bibit_tgl_tanam">
        </span></td>
    <?php } ?>
    <?php if ($Page->jenis_lahan->Visible) { // jenis_lahan ?>
        <td data-name="jenis_lahan" class="<?= $Page->jenis_lahan->footerCellClass() ?>"><span id="elf_tanam_bibit_jenis_lahan" class="tanam_bibit_jenis_lahan">
        </span></td>
    <?php } ?>
    <?php if ($Page->varietas->Visible) { // varietas ?>
        <td data-name="varietas" class="<?= $Page->varietas->footerCellClass() ?>"><span id="elf_tanam_bibit_varietas" class="tanam_bibit_varietas">
        </span></td>
    <?php } ?>
    <?php if ($Page->jumlah_tanam->Visible) { // jumlah_tanam ?>
        <td data-name="jumlah_tanam" class="<?= $Page->jumlah_tanam->footerCellClass() ?>"><span id="elf_tanam_bibit_jumlah_tanam" class="tanam_bibit_jumlah_tanam">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->jumlah_tanam->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->ket->Visible) { // ket ?>
        <td data-name="ket" class="<?= $Page->ket->footerCellClass() ?>"><span id="elf_tanam_bibit_ket" class="tanam_bibit_ket">
        </span></td>
    <?php } ?>
    <?php if ($Page->id_kontrak_tanam->Visible) { // id_kontrak_tanam ?>
        <td data-name="id_kontrak_tanam" class="<?= $Page->id_kontrak_tanam->footerCellClass() ?>"><span id="elf_tanam_bibit_id_kontrak_tanam" class="tanam_bibit_id_kontrak_tanam">
        </span></td>
    <?php } ?>
    <?php if ($Page->gen_bibit->Visible) { // gen_bibit ?>
        <td data-name="gen_bibit" class="<?= $Page->gen_bibit->footerCellClass() ?>"><span id="elf_tanam_bibit_gen_bibit" class="tanam_bibit_gen_bibit">
        </span></td>
    <?php } ?>
    <?php if ($Page->id_asal_bibit->Visible) { // id_asal_bibit ?>
        <td data-name="id_asal_bibit" class="<?= $Page->id_asal_bibit->footerCellClass() ?>"><span id="elf_tanam_bibit_id_asal_bibit" class="tanam_bibit_id_asal_bibit">
        </span></td>
    <?php } ?>
    <?php if ($Page->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
        <td data-name="jumlah_panen_stek" class="<?= $Page->jumlah_panen_stek->footerCellClass() ?>"><span id="elf_tanam_bibit_jumlah_panen_stek" class="tanam_bibit_jumlah_panen_stek">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Page->Recordset) {
    $Page->Recordset->close();
}
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("tanam_bibit");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
