<?php

namespace PHPMaker2023\co;

// Page object
$KontrakList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { kontrak: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fkontraksrch" id="fkontraksrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="on">
<div id="fkontraksrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { kontrak: currentTable } });
var currentForm;
var fkontraksrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fkontraksrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["k_id_kontrak", [], fields.k_id_kontrak.isInvalid],
            ["k_luas_lahan", [ew.Validators.integer], fields.k_luas_lahan.isInvalid],
            ["pet_id", [], fields.pet_id.isInvalid],
            ["koord_id", [], fields.koord_id.isInvalid],
            ["kk_id", [], fields.kk_id.isInvalid],
            ["prov_id", [], fields.prov_id.isInvalid],
            ["kab_id", [], fields.kab_id.isInvalid],
            ["kec_id", [], fields.kec_id.isInvalid],
            ["desa_id", [], fields.desa_id.isInvalid],
            ["blok_id", [], fields.blok_id.isInvalid],
            ["sos_id", [], fields.sos_id.isInvalid],
            ["var_id", [], fields.var_id.isInvalid],
            ["co_id", [], fields.co_id.isInvalid],
            ["k_jumlah_bibit", [], fields.k_jumlah_bibit.isInvalid],
            ["k_asal_bibit", [], fields.k_asal_bibit.isInvalid],
            ["k_tgl_tanam", [ew.Validators.datetime(fields.k_tgl_tanam.clientFormatPattern)], fields.k_tgl_tanam.isInvalid],
            ["y_k_tgl_tanam", [ew.Validators.between], false],
            ["k_es_tgl_panen", [ew.Validators.datetime(fields.k_es_tgl_panen.clientFormatPattern)], fields.k_es_tgl_panen.isInvalid],
            ["y_k_es_tgl_panen", [ew.Validators.between], false],
            ["k_ak_tgl_datang", [ew.Validators.datetime(fields.k_ak_tgl_datang.clientFormatPattern)], fields.k_ak_tgl_datang.isInvalid],
            ["y_k_ak_tgl_datang", [ew.Validators.between], false],
            ["k_es_qty", [], fields.k_es_qty.isInvalid],
            ["k_ak_qty", [], fields.k_ak_qty.isInvalid],
            ["k_es_perhektar", [], fields.k_es_perhektar.isInvalid],
            ["k_ak_perhektar", [], fields.k_ak_perhektar.isInvalid],
            ["k_skor", [], fields.k_skor.isInvalid],
            ["k_ket", [], fields.k_ket.isInvalid],
            ["k_cat", [], fields.k_cat.isInvalid],
            ["k_titik_koordinat", [], fields.k_titik_koordinat.isInvalid],
            ["k_foto_lahan", [], fields.k_foto_lahan.isInvalid],
            ["k_dok", [], fields.k_dok.isInvalid],
            ["k_harga_bibit", [], fields.k_harga_bibit.isInvalid],
            ["k_bayar_bibit", [], fields.k_bayar_bibit.isInvalid],
            ["k_pinjaman", [], fields.k_pinjaman.isInvalid],
            ["k_bayar_pinjaman", [], fields.k_bayar_pinjaman.isInvalid],
            ["k_sisa_hutang", [], fields.k_sisa_hutang.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "koord_id": <?= $Page->koord_id->toClientList($Page) ?>,
            "prov_id": <?= $Page->prov_id->toClientList($Page) ?>,
            "kab_id": <?= $Page->kab_id->toClientList($Page) ?>,
            "kec_id": <?= $Page->kec_id->toClientList($Page) ?>,
            "desa_id": <?= $Page->desa_id->toClientList($Page) ?>,
            "var_id": <?= $Page->var_id->toClientList($Page) ?>,
            "co_id": <?= $Page->co_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->k_luas_lahan->Visible) { // k_luas_lahan ?>
<?php
if (!$Page->k_luas_lahan->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_k_luas_lahan" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->k_luas_lahan->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_k_luas_lahan" class="ew-search-caption ew-label"><?= $Page->k_luas_lahan->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_k_luas_lahan" id="z_k_luas_lahan" value="=">
</div>
        </div>
        <div id="el_kontrak_k_luas_lahan" class="ew-search-field">
<input type="<?= $Page->k_luas_lahan->getInputTextType() ?>" name="x_k_luas_lahan" id="x_k_luas_lahan" data-table="kontrak" data-field="x_k_luas_lahan" value="<?= $Page->k_luas_lahan->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->k_luas_lahan->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_luas_lahan->formatPattern()) ?>"<?= $Page->k_luas_lahan->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_luas_lahan->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->koord_id->Visible) { // koord_id ?>
<?php
if (!$Page->koord_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_koord_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->koord_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->koord_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_koord_id" id="z_koord_id" value="=">
</div>
        </div>
        <div id="el_kontrak_koord_id" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->koord_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_koord_id" class="ew-auto-suggest">
    <input type="<?= $Page->koord_id->getInputTextType() ?>" class="form-control" name="sv_x_koord_id" id="sv_x_koord_id" value="<?= RemoveHtml($Page->koord_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->koord_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->koord_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->koord_id->formatPattern()) ?>"<?= $Page->koord_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="kontrak" data-field="x_koord_id" data-input="sv_x_koord_id" data-value-separator="<?= $Page->koord_id->displayValueSeparatorAttribute() ?>" name="x_koord_id" id="x_koord_id" value="<?= HtmlEncode($Page->koord_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->koord_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fkontraksrch", function() {
    fkontraksrch.createAutoSuggest(Object.assign({"id":"x_koord_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->koord_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.kontrak.fields.koord_id.autoSuggestOptions));
});
</script>
<?= $Page->koord_id->Lookup->getParamTag($Page, "p_x_koord_id") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->prov_id->Visible) { // prov_id ?>
<?php
if (!$Page->prov_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_prov_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->prov_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_prov_id" class="ew-search-caption ew-label"><?= $Page->prov_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_prov_id" id="z_prov_id" value="=">
</div>
        </div>
        <div id="el_kontrak_prov_id" class="ew-search-field">
    <select
        id="x_prov_id"
        name="x_prov_id"
        class="form-select ew-select<?= $Page->prov_id->isInvalidClass() ?>"
        <?php if (!$Page->prov_id->IsNativeSelect) { ?>
        data-select2-id="fkontraksrch_x_prov_id"
        <?php } ?>
        data-table="kontrak"
        data-field="x_prov_id"
        data-value-separator="<?= $Page->prov_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->prov_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->prov_id->editAttributes() ?>>
        <?= $Page->prov_id->selectOptionListHtml("x_prov_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->prov_id->getErrorMessage(false) ?></div>
<?= $Page->prov_id->Lookup->getParamTag($Page, "p_x_prov_id") ?>
<?php if (!$Page->prov_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fkontraksrch", function() {
    var options = { name: "x_prov_id", selectId: "fkontraksrch_x_prov_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fkontraksrch.lists.prov_id?.lookupOptions.length) {
        options.data = { id: "x_prov_id", form: "fkontraksrch" };
    } else {
        options.ajax = { id: "x_prov_id", form: "fkontraksrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.kontrak.fields.prov_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->kab_id->Visible) { // kab_id ?>
<?php
if (!$Page->kab_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_kab_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->kab_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_kab_id" class="ew-search-caption ew-label"><?= $Page->kab_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_kab_id" id="z_kab_id" value="=">
</div>
        </div>
        <div id="el_kontrak_kab_id" class="ew-search-field">
    <select
        id="x_kab_id"
        name="x_kab_id"
        class="form-select ew-select<?= $Page->kab_id->isInvalidClass() ?>"
        <?php if (!$Page->kab_id->IsNativeSelect) { ?>
        data-select2-id="fkontraksrch_x_kab_id"
        <?php } ?>
        data-table="kontrak"
        data-field="x_kab_id"
        data-value-separator="<?= $Page->kab_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->kab_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->kab_id->editAttributes() ?>>
        <?= $Page->kab_id->selectOptionListHtml("x_kab_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->kab_id->getErrorMessage(false) ?></div>
<?= $Page->kab_id->Lookup->getParamTag($Page, "p_x_kab_id") ?>
<?php if (!$Page->kab_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fkontraksrch", function() {
    var options = { name: "x_kab_id", selectId: "fkontraksrch_x_kab_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fkontraksrch.lists.kab_id?.lookupOptions.length) {
        options.data = { id: "x_kab_id", form: "fkontraksrch" };
    } else {
        options.ajax = { id: "x_kab_id", form: "fkontraksrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.kontrak.fields.kab_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->kec_id->Visible) { // kec_id ?>
<?php
if (!$Page->kec_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_kec_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->kec_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_kec_id" class="ew-search-caption ew-label"><?= $Page->kec_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_kec_id" id="z_kec_id" value="=">
</div>
        </div>
        <div id="el_kontrak_kec_id" class="ew-search-field">
    <select
        id="x_kec_id"
        name="x_kec_id"
        class="form-select ew-select<?= $Page->kec_id->isInvalidClass() ?>"
        <?php if (!$Page->kec_id->IsNativeSelect) { ?>
        data-select2-id="fkontraksrch_x_kec_id"
        <?php } ?>
        data-table="kontrak"
        data-field="x_kec_id"
        data-value-separator="<?= $Page->kec_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->kec_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->kec_id->editAttributes() ?>>
        <?= $Page->kec_id->selectOptionListHtml("x_kec_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->kec_id->getErrorMessage(false) ?></div>
<?= $Page->kec_id->Lookup->getParamTag($Page, "p_x_kec_id") ?>
<?php if (!$Page->kec_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fkontraksrch", function() {
    var options = { name: "x_kec_id", selectId: "fkontraksrch_x_kec_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fkontraksrch.lists.kec_id?.lookupOptions.length) {
        options.data = { id: "x_kec_id", form: "fkontraksrch" };
    } else {
        options.ajax = { id: "x_kec_id", form: "fkontraksrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.kontrak.fields.kec_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->desa_id->Visible) { // desa_id ?>
<?php
if (!$Page->desa_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_desa_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->desa_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_desa_id" class="ew-search-caption ew-label"><?= $Page->desa_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_desa_id" id="z_desa_id" value="=">
</div>
        </div>
        <div id="el_kontrak_desa_id" class="ew-search-field">
    <select
        id="x_desa_id"
        name="x_desa_id"
        class="form-select ew-select<?= $Page->desa_id->isInvalidClass() ?>"
        <?php if (!$Page->desa_id->IsNativeSelect) { ?>
        data-select2-id="fkontraksrch_x_desa_id"
        <?php } ?>
        data-table="kontrak"
        data-field="x_desa_id"
        data-value-separator="<?= $Page->desa_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->desa_id->getPlaceHolder()) ?>"
        <?= $Page->desa_id->editAttributes() ?>>
        <?= $Page->desa_id->selectOptionListHtml("x_desa_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->desa_id->getErrorMessage(false) ?></div>
<?= $Page->desa_id->Lookup->getParamTag($Page, "p_x_desa_id") ?>
<?php if (!$Page->desa_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fkontraksrch", function() {
    var options = { name: "x_desa_id", selectId: "fkontraksrch_x_desa_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fkontraksrch.lists.desa_id?.lookupOptions.length) {
        options.data = { id: "x_desa_id", form: "fkontraksrch" };
    } else {
        options.ajax = { id: "x_desa_id", form: "fkontraksrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.kontrak.fields.desa_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->var_id->Visible) { // var_id ?>
<?php
if (!$Page->var_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_var_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->var_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_var_id" class="ew-search-caption ew-label"><?= $Page->var_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_var_id" id="z_var_id" value="=">
</div>
        </div>
        <div id="el_kontrak_var_id" class="ew-search-field">
    <select
        id="x_var_id"
        name="x_var_id"
        class="form-select ew-select<?= $Page->var_id->isInvalidClass() ?>"
        <?php if (!$Page->var_id->IsNativeSelect) { ?>
        data-select2-id="fkontraksrch_x_var_id"
        <?php } ?>
        data-table="kontrak"
        data-field="x_var_id"
        data-value-separator="<?= $Page->var_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->var_id->getPlaceHolder()) ?>"
        <?= $Page->var_id->editAttributes() ?>>
        <?= $Page->var_id->selectOptionListHtml("x_var_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->var_id->getErrorMessage(false) ?></div>
<?= $Page->var_id->Lookup->getParamTag($Page, "p_x_var_id") ?>
<?php if (!$Page->var_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fkontraksrch", function() {
    var options = { name: "x_var_id", selectId: "fkontraksrch_x_var_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fkontraksrch.lists.var_id?.lookupOptions.length) {
        options.data = { id: "x_var_id", form: "fkontraksrch" };
    } else {
        options.ajax = { id: "x_var_id", form: "fkontraksrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.kontrak.fields.var_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->co_id->Visible) { // co_id ?>
<?php
if (!$Page->co_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_co_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->co_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_co_id" class="ew-search-caption ew-label"><?= $Page->co_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_co_id" id="z_co_id" value="=">
</div>
        </div>
        <div id="el_kontrak_co_id" class="ew-search-field">
    <select
        id="x_co_id"
        name="x_co_id"
        class="form-select ew-select<?= $Page->co_id->isInvalidClass() ?>"
        <?php if (!$Page->co_id->IsNativeSelect) { ?>
        data-select2-id="fkontraksrch_x_co_id"
        <?php } ?>
        data-table="kontrak"
        data-field="x_co_id"
        data-value-separator="<?= $Page->co_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->co_id->getPlaceHolder()) ?>"
        <?= $Page->co_id->editAttributes() ?>>
        <?= $Page->co_id->selectOptionListHtml("x_co_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->co_id->getErrorMessage(false) ?></div>
<?= $Page->co_id->Lookup->getParamTag($Page, "p_x_co_id") ?>
<?php if (!$Page->co_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fkontraksrch", function() {
    var options = { name: "x_co_id", selectId: "fkontraksrch_x_co_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fkontraksrch.lists.co_id?.lookupOptions.length) {
        options.data = { id: "x_co_id", form: "fkontraksrch" };
    } else {
        options.ajax = { id: "x_co_id", form: "fkontraksrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.kontrak.fields.co_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
<?php
if (!$Page->k_tgl_tanam->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_k_tgl_tanam" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->k_tgl_tanam->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_k_tgl_tanam" class="ew-search-caption ew-label"><?= $Page->k_tgl_tanam->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_k_tgl_tanam" id="z_k_tgl_tanam" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->k_tgl_tanam->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->k_tgl_tanam->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_kontrak_k_tgl_tanam" class="ew-search-field">
<input type="<?= $Page->k_tgl_tanam->getInputTextType() ?>" name="x_k_tgl_tanam" id="x_k_tgl_tanam" data-table="kontrak" data-field="x_k_tgl_tanam" value="<?= $Page->k_tgl_tanam->EditValue ?>" placeholder="<?= HtmlEncode($Page->k_tgl_tanam->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_tgl_tanam->formatPattern()) ?>"<?= $Page->k_tgl_tanam->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_tgl_tanam->getErrorMessage(false) ?></div>
<?php if (!$Page->k_tgl_tanam->ReadOnly && !$Page->k_tgl_tanam->Disabled && !isset($Page->k_tgl_tanam->EditAttrs["readonly"]) && !isset($Page->k_tgl_tanam->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontraksrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontraksrch", "x_k_tgl_tanam", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_kontrak_k_tgl_tanam" class="ew-search-field2 d-none">
<input type="<?= $Page->k_tgl_tanam->getInputTextType() ?>" name="y_k_tgl_tanam" id="y_k_tgl_tanam" data-table="kontrak" data-field="x_k_tgl_tanam" value="<?= $Page->k_tgl_tanam->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->k_tgl_tanam->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_tgl_tanam->formatPattern()) ?>"<?= $Page->k_tgl_tanam->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_tgl_tanam->getErrorMessage(false) ?></div>
<?php if (!$Page->k_tgl_tanam->ReadOnly && !$Page->k_tgl_tanam->Disabled && !isset($Page->k_tgl_tanam->EditAttrs["readonly"]) && !isset($Page->k_tgl_tanam->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontraksrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontraksrch", "y_k_tgl_tanam", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
<?php
if (!$Page->k_es_tgl_panen->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_k_es_tgl_panen" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->k_es_tgl_panen->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_k_es_tgl_panen" class="ew-search-caption ew-label"><?= $Page->k_es_tgl_panen->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_k_es_tgl_panen" id="z_k_es_tgl_panen" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->k_es_tgl_panen->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->k_es_tgl_panen->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_kontrak_k_es_tgl_panen" class="ew-search-field">
<input type="<?= $Page->k_es_tgl_panen->getInputTextType() ?>" name="x_k_es_tgl_panen" id="x_k_es_tgl_panen" data-table="kontrak" data-field="x_k_es_tgl_panen" value="<?= $Page->k_es_tgl_panen->EditValue ?>" placeholder="<?= HtmlEncode($Page->k_es_tgl_panen->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_es_tgl_panen->formatPattern()) ?>"<?= $Page->k_es_tgl_panen->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_es_tgl_panen->getErrorMessage(false) ?></div>
<?php if (!$Page->k_es_tgl_panen->ReadOnly && !$Page->k_es_tgl_panen->Disabled && !isset($Page->k_es_tgl_panen->EditAttrs["readonly"]) && !isset($Page->k_es_tgl_panen->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontraksrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontraksrch", "x_k_es_tgl_panen", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_kontrak_k_es_tgl_panen" class="ew-search-field2 d-none">
<input type="<?= $Page->k_es_tgl_panen->getInputTextType() ?>" name="y_k_es_tgl_panen" id="y_k_es_tgl_panen" data-table="kontrak" data-field="x_k_es_tgl_panen" value="<?= $Page->k_es_tgl_panen->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->k_es_tgl_panen->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_es_tgl_panen->formatPattern()) ?>"<?= $Page->k_es_tgl_panen->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_es_tgl_panen->getErrorMessage(false) ?></div>
<?php if (!$Page->k_es_tgl_panen->ReadOnly && !$Page->k_es_tgl_panen->Disabled && !isset($Page->k_es_tgl_panen->EditAttrs["readonly"]) && !isset($Page->k_es_tgl_panen->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontraksrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontraksrch", "y_k_es_tgl_panen", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
<?php
if (!$Page->k_ak_tgl_datang->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_k_ak_tgl_datang" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->k_ak_tgl_datang->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_k_ak_tgl_datang" class="ew-search-caption ew-label"><?= $Page->k_ak_tgl_datang->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_k_ak_tgl_datang" id="z_k_ak_tgl_datang" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->k_ak_tgl_datang->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->k_ak_tgl_datang->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_kontrak_k_ak_tgl_datang" class="ew-search-field">
<input type="<?= $Page->k_ak_tgl_datang->getInputTextType() ?>" name="x_k_ak_tgl_datang" id="x_k_ak_tgl_datang" data-table="kontrak" data-field="x_k_ak_tgl_datang" value="<?= $Page->k_ak_tgl_datang->EditValue ?>" placeholder="<?= HtmlEncode($Page->k_ak_tgl_datang->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_ak_tgl_datang->formatPattern()) ?>"<?= $Page->k_ak_tgl_datang->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_ak_tgl_datang->getErrorMessage(false) ?></div>
<?php if (!$Page->k_ak_tgl_datang->ReadOnly && !$Page->k_ak_tgl_datang->Disabled && !isset($Page->k_ak_tgl_datang->EditAttrs["readonly"]) && !isset($Page->k_ak_tgl_datang->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontraksrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontraksrch", "x_k_ak_tgl_datang", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_kontrak_k_ak_tgl_datang" class="ew-search-field2 d-none">
<input type="<?= $Page->k_ak_tgl_datang->getInputTextType() ?>" name="y_k_ak_tgl_datang" id="y_k_ak_tgl_datang" data-table="kontrak" data-field="x_k_ak_tgl_datang" value="<?= $Page->k_ak_tgl_datang->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->k_ak_tgl_datang->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_ak_tgl_datang->formatPattern()) ?>"<?= $Page->k_ak_tgl_datang->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_ak_tgl_datang->getErrorMessage(false) ?></div>
<?php if (!$Page->k_ak_tgl_datang->ReadOnly && !$Page->k_ak_tgl_datang->Disabled && !isset($Page->k_ak_tgl_datang->EditAttrs["readonly"]) && !isset($Page->k_ak_tgl_datang->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontraksrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontraksrch", "y_k_ak_tgl_datang", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fkontraksrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fkontraksrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fkontraksrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fkontraksrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="on">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="kontrak">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_kontrak" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_kontraklist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = ROWTYPE_HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->k_id_kontrak->Visible) { // k_id_kontrak ?>
        <th data-name="k_id_kontrak" class="<?= $Page->k_id_kontrak->headerCellClass() ?>"><div id="elh_kontrak_k_id_kontrak" class="kontrak_k_id_kontrak"><?= $Page->renderFieldHeader($Page->k_id_kontrak) ?></div></th>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { // k_luas_lahan ?>
        <th data-name="k_luas_lahan" class="<?= $Page->k_luas_lahan->headerCellClass() ?>"><div id="elh_kontrak_k_luas_lahan" class="kontrak_k_luas_lahan"><?= $Page->renderFieldHeader($Page->k_luas_lahan) ?></div></th>
<?php } ?>
<?php if ($Page->pet_id->Visible) { // pet_id ?>
        <th data-name="pet_id" class="<?= $Page->pet_id->headerCellClass() ?>"><div id="elh_kontrak_pet_id" class="kontrak_pet_id"><?= $Page->renderFieldHeader($Page->pet_id) ?></div></th>
<?php } ?>
<?php if ($Page->koord_id->Visible) { // koord_id ?>
        <th data-name="koord_id" class="<?= $Page->koord_id->headerCellClass() ?>"><div id="elh_kontrak_koord_id" class="kontrak_koord_id"><?= $Page->renderFieldHeader($Page->koord_id) ?></div></th>
<?php } ?>
<?php if ($Page->kk_id->Visible) { // kk_id ?>
        <th data-name="kk_id" class="<?= $Page->kk_id->headerCellClass() ?>"><div id="elh_kontrak_kk_id" class="kontrak_kk_id"><?= $Page->renderFieldHeader($Page->kk_id) ?></div></th>
<?php } ?>
<?php if ($Page->prov_id->Visible) { // prov_id ?>
        <th data-name="prov_id" class="<?= $Page->prov_id->headerCellClass() ?>"><div id="elh_kontrak_prov_id" class="kontrak_prov_id"><?= $Page->renderFieldHeader($Page->prov_id) ?></div></th>
<?php } ?>
<?php if ($Page->kab_id->Visible) { // kab_id ?>
        <th data-name="kab_id" class="<?= $Page->kab_id->headerCellClass() ?>"><div id="elh_kontrak_kab_id" class="kontrak_kab_id"><?= $Page->renderFieldHeader($Page->kab_id) ?></div></th>
<?php } ?>
<?php if ($Page->kec_id->Visible) { // kec_id ?>
        <th data-name="kec_id" class="<?= $Page->kec_id->headerCellClass() ?>"><div id="elh_kontrak_kec_id" class="kontrak_kec_id"><?= $Page->renderFieldHeader($Page->kec_id) ?></div></th>
<?php } ?>
<?php if ($Page->desa_id->Visible) { // desa_id ?>
        <th data-name="desa_id" class="<?= $Page->desa_id->headerCellClass() ?>"><div id="elh_kontrak_desa_id" class="kontrak_desa_id"><?= $Page->renderFieldHeader($Page->desa_id) ?></div></th>
<?php } ?>
<?php if ($Page->blok_id->Visible) { // blok_id ?>
        <th data-name="blok_id" class="<?= $Page->blok_id->headerCellClass() ?>"><div id="elh_kontrak_blok_id" class="kontrak_blok_id"><?= $Page->renderFieldHeader($Page->blok_id) ?></div></th>
<?php } ?>
<?php if ($Page->sos_id->Visible) { // sos_id ?>
        <th data-name="sos_id" class="<?= $Page->sos_id->headerCellClass() ?>"><div id="elh_kontrak_sos_id" class="kontrak_sos_id"><?= $Page->renderFieldHeader($Page->sos_id) ?></div></th>
<?php } ?>
<?php if ($Page->var_id->Visible) { // var_id ?>
        <th data-name="var_id" class="<?= $Page->var_id->headerCellClass() ?>"><div id="elh_kontrak_var_id" class="kontrak_var_id"><?= $Page->renderFieldHeader($Page->var_id) ?></div></th>
<?php } ?>
<?php if ($Page->co_id->Visible) { // co_id ?>
        <th data-name="co_id" class="<?= $Page->co_id->headerCellClass() ?>"><div id="elh_kontrak_co_id" class="kontrak_co_id"><?= $Page->renderFieldHeader($Page->co_id) ?></div></th>
<?php } ?>
<?php if ($Page->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
        <th data-name="k_jumlah_bibit" class="<?= $Page->k_jumlah_bibit->headerCellClass() ?>"><div id="elh_kontrak_k_jumlah_bibit" class="kontrak_k_jumlah_bibit"><?= $Page->renderFieldHeader($Page->k_jumlah_bibit) ?></div></th>
<?php } ?>
<?php if ($Page->k_asal_bibit->Visible) { // k_asal_bibit ?>
        <th data-name="k_asal_bibit" class="<?= $Page->k_asal_bibit->headerCellClass() ?>"><div id="elh_kontrak_k_asal_bibit" class="kontrak_k_asal_bibit"><?= $Page->renderFieldHeader($Page->k_asal_bibit) ?></div></th>
<?php } ?>
<?php if ($Page->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
        <th data-name="k_tgl_tanam" class="<?= $Page->k_tgl_tanam->headerCellClass() ?>"><div id="elh_kontrak_k_tgl_tanam" class="kontrak_k_tgl_tanam"><?= $Page->renderFieldHeader($Page->k_tgl_tanam) ?></div></th>
<?php } ?>
<?php if ($Page->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
        <th data-name="k_es_tgl_panen" class="<?= $Page->k_es_tgl_panen->headerCellClass() ?>"><div id="elh_kontrak_k_es_tgl_panen" class="kontrak_k_es_tgl_panen"><?= $Page->renderFieldHeader($Page->k_es_tgl_panen) ?></div></th>
<?php } ?>
<?php if ($Page->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
        <th data-name="k_ak_tgl_datang" class="<?= $Page->k_ak_tgl_datang->headerCellClass() ?>"><div id="elh_kontrak_k_ak_tgl_datang" class="kontrak_k_ak_tgl_datang"><?= $Page->renderFieldHeader($Page->k_ak_tgl_datang) ?></div></th>
<?php } ?>
<?php if ($Page->k_es_qty->Visible) { // k_es_qty ?>
        <th data-name="k_es_qty" class="<?= $Page->k_es_qty->headerCellClass() ?>"><div id="elh_kontrak_k_es_qty" class="kontrak_k_es_qty"><?= $Page->renderFieldHeader($Page->k_es_qty) ?></div></th>
<?php } ?>
<?php if ($Page->k_ak_qty->Visible) { // k_ak_qty ?>
        <th data-name="k_ak_qty" class="<?= $Page->k_ak_qty->headerCellClass() ?>"><div id="elh_kontrak_k_ak_qty" class="kontrak_k_ak_qty"><?= $Page->renderFieldHeader($Page->k_ak_qty) ?></div></th>
<?php } ?>
<?php if ($Page->k_es_perhektar->Visible) { // k_es_perhektar ?>
        <th data-name="k_es_perhektar" class="<?= $Page->k_es_perhektar->headerCellClass() ?>"><div id="elh_kontrak_k_es_perhektar" class="kontrak_k_es_perhektar"><?= $Page->renderFieldHeader($Page->k_es_perhektar) ?></div></th>
<?php } ?>
<?php if ($Page->k_ak_perhektar->Visible) { // k_ak_perhektar ?>
        <th data-name="k_ak_perhektar" class="<?= $Page->k_ak_perhektar->headerCellClass() ?>"><div id="elh_kontrak_k_ak_perhektar" class="kontrak_k_ak_perhektar"><?= $Page->renderFieldHeader($Page->k_ak_perhektar) ?></div></th>
<?php } ?>
<?php if ($Page->k_skor->Visible) { // k_skor ?>
        <th data-name="k_skor" class="<?= $Page->k_skor->headerCellClass() ?>"><div id="elh_kontrak_k_skor" class="kontrak_k_skor"><?= $Page->renderFieldHeader($Page->k_skor) ?></div></th>
<?php } ?>
<?php if ($Page->k_ket->Visible) { // k_ket ?>
        <th data-name="k_ket" class="<?= $Page->k_ket->headerCellClass() ?>"><div id="elh_kontrak_k_ket" class="kontrak_k_ket"><?= $Page->renderFieldHeader($Page->k_ket) ?></div></th>
<?php } ?>
<?php if ($Page->k_cat->Visible) { // k_cat ?>
        <th data-name="k_cat" class="<?= $Page->k_cat->headerCellClass() ?>"><div id="elh_kontrak_k_cat" class="kontrak_k_cat"><?= $Page->renderFieldHeader($Page->k_cat) ?></div></th>
<?php } ?>
<?php if ($Page->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
        <th data-name="k_titik_koordinat" class="<?= $Page->k_titik_koordinat->headerCellClass() ?>"><div id="elh_kontrak_k_titik_koordinat" class="kontrak_k_titik_koordinat"><?= $Page->renderFieldHeader($Page->k_titik_koordinat) ?></div></th>
<?php } ?>
<?php if ($Page->k_foto_lahan->Visible) { // k_foto_lahan ?>
        <th data-name="k_foto_lahan" class="<?= $Page->k_foto_lahan->headerCellClass() ?>"><div id="elh_kontrak_k_foto_lahan" class="kontrak_k_foto_lahan"><?= $Page->renderFieldHeader($Page->k_foto_lahan) ?></div></th>
<?php } ?>
<?php if ($Page->k_dok->Visible) { // k_dok ?>
        <th data-name="k_dok" class="<?= $Page->k_dok->headerCellClass() ?>"><div id="elh_kontrak_k_dok" class="kontrak_k_dok"><?= $Page->renderFieldHeader($Page->k_dok) ?></div></th>
<?php } ?>
<?php if ($Page->k_harga_bibit->Visible) { // k_harga_bibit ?>
        <th data-name="k_harga_bibit" class="<?= $Page->k_harga_bibit->headerCellClass() ?>"><div id="elh_kontrak_k_harga_bibit" class="kontrak_k_harga_bibit"><?= $Page->renderFieldHeader($Page->k_harga_bibit) ?></div></th>
<?php } ?>
<?php if ($Page->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
        <th data-name="k_bayar_bibit" class="<?= $Page->k_bayar_bibit->headerCellClass() ?>"><div id="elh_kontrak_k_bayar_bibit" class="kontrak_k_bayar_bibit"><?= $Page->renderFieldHeader($Page->k_bayar_bibit) ?></div></th>
<?php } ?>
<?php if ($Page->k_pinjaman->Visible) { // k_pinjaman ?>
        <th data-name="k_pinjaman" class="<?= $Page->k_pinjaman->headerCellClass() ?>"><div id="elh_kontrak_k_pinjaman" class="kontrak_k_pinjaman"><?= $Page->renderFieldHeader($Page->k_pinjaman) ?></div></th>
<?php } ?>
<?php if ($Page->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
        <th data-name="k_bayar_pinjaman" class="<?= $Page->k_bayar_pinjaman->headerCellClass() ?>"><div id="elh_kontrak_k_bayar_pinjaman" class="kontrak_k_bayar_pinjaman"><?= $Page->renderFieldHeader($Page->k_bayar_pinjaman) ?></div></th>
<?php } ?>
<?php if ($Page->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
        <th data-name="k_sisa_hutang" class="<?= $Page->k_sisa_hutang->headerCellClass() ?>"><div id="elh_kontrak_k_sisa_hutang" class="kontrak_k_sisa_hutang"><?= $Page->renderFieldHeader($Page->k_sisa_hutang) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->k_id_kontrak->Visible) { // k_id_kontrak ?>
        <td data-name="k_id_kontrak"<?= $Page->k_id_kontrak->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_id_kontrak" class="el_kontrak_k_id_kontrak">
<span<?= $Page->k_id_kontrak->viewAttributes() ?>>
<?= $Page->k_id_kontrak->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_luas_lahan->Visible) { // k_luas_lahan ?>
        <td data-name="k_luas_lahan"<?= $Page->k_luas_lahan->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_luas_lahan" class="el_kontrak_k_luas_lahan">
<span<?= $Page->k_luas_lahan->viewAttributes() ?>>
<?= $Page->k_luas_lahan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pet_id->Visible) { // pet_id ?>
        <td data-name="pet_id"<?= $Page->pet_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_pet_id" class="el_kontrak_pet_id">
<span<?= $Page->pet_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->pet_id->getViewValue()) && $Page->pet_id->linkAttributes() != "") { ?>
<a<?= $Page->pet_id->linkAttributes() ?>><?= $Page->pet_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->pet_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->koord_id->Visible) { // koord_id ?>
        <td data-name="koord_id"<?= $Page->koord_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_id" class="el_kontrak_koord_id">
<span<?= $Page->koord_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->koord_id->getViewValue()) && $Page->koord_id->linkAttributes() != "") { ?>
<a<?= $Page->koord_id->linkAttributes() ?>><?= $Page->koord_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->koord_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kk_id->Visible) { // kk_id ?>
        <td data-name="kk_id"<?= $Page->kk_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_kk_id" class="el_kontrak_kk_id">
<span<?= $Page->kk_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->kk_id->getViewValue()) && $Page->kk_id->linkAttributes() != "") { ?>
<a<?= $Page->kk_id->linkAttributes() ?>><?= $Page->kk_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->kk_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->prov_id->Visible) { // prov_id ?>
        <td data-name="prov_id"<?= $Page->prov_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_prov_id" class="el_kontrak_prov_id">
<span<?= $Page->prov_id->viewAttributes() ?>>
<?= $Page->prov_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kab_id->Visible) { // kab_id ?>
        <td data-name="kab_id"<?= $Page->kab_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_kab_id" class="el_kontrak_kab_id">
<span<?= $Page->kab_id->viewAttributes() ?>>
<?= $Page->kab_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kec_id->Visible) { // kec_id ?>
        <td data-name="kec_id"<?= $Page->kec_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_kec_id" class="el_kontrak_kec_id">
<span<?= $Page->kec_id->viewAttributes() ?>>
<?= $Page->kec_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->desa_id->Visible) { // desa_id ?>
        <td data-name="desa_id"<?= $Page->desa_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_desa_id" class="el_kontrak_desa_id">
<span<?= $Page->desa_id->viewAttributes() ?>>
<?= $Page->desa_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->blok_id->Visible) { // blok_id ?>
        <td data-name="blok_id"<?= $Page->blok_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_blok_id" class="el_kontrak_blok_id">
<span<?= $Page->blok_id->viewAttributes() ?>>
<?= $Page->blok_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_id->Visible) { // sos_id ?>
        <td data-name="sos_id"<?= $Page->sos_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_sos_id" class="el_kontrak_sos_id">
<span<?= $Page->sos_id->viewAttributes() ?>>
<?= $Page->sos_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->var_id->Visible) { // var_id ?>
        <td data-name="var_id"<?= $Page->var_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_var_id" class="el_kontrak_var_id">
<span<?= $Page->var_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->var_id->getViewValue()) && $Page->var_id->linkAttributes() != "") { ?>
<a<?= $Page->var_id->linkAttributes() ?>><?= $Page->var_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->var_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->co_id->Visible) { // co_id ?>
        <td data-name="co_id"<?= $Page->co_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_co_id" class="el_kontrak_co_id">
<span<?= $Page->co_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->co_id->getViewValue()) && $Page->co_id->linkAttributes() != "") { ?>
<a<?= $Page->co_id->linkAttributes() ?>><?= $Page->co_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->co_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
        <td data-name="k_jumlah_bibit"<?= $Page->k_jumlah_bibit->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_jumlah_bibit" class="el_kontrak_k_jumlah_bibit">
<span<?= $Page->k_jumlah_bibit->viewAttributes() ?>>
<?= $Page->k_jumlah_bibit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_asal_bibit->Visible) { // k_asal_bibit ?>
        <td data-name="k_asal_bibit"<?= $Page->k_asal_bibit->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_asal_bibit" class="el_kontrak_k_asal_bibit">
<span<?= $Page->k_asal_bibit->viewAttributes() ?>>
<?= $Page->k_asal_bibit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
        <td data-name="k_tgl_tanam"<?= $Page->k_tgl_tanam->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_tgl_tanam" class="el_kontrak_k_tgl_tanam">
<span<?= $Page->k_tgl_tanam->viewAttributes() ?>>
<?= $Page->k_tgl_tanam->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
        <td data-name="k_es_tgl_panen"<?= $Page->k_es_tgl_panen->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_es_tgl_panen" class="el_kontrak_k_es_tgl_panen">
<span<?= $Page->k_es_tgl_panen->viewAttributes() ?>>
<?= $Page->k_es_tgl_panen->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
        <td data-name="k_ak_tgl_datang"<?= $Page->k_ak_tgl_datang->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_ak_tgl_datang" class="el_kontrak_k_ak_tgl_datang">
<span<?= $Page->k_ak_tgl_datang->viewAttributes() ?>>
<?= $Page->k_ak_tgl_datang->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_es_qty->Visible) { // k_es_qty ?>
        <td data-name="k_es_qty"<?= $Page->k_es_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_es_qty" class="el_kontrak_k_es_qty">
<span<?= $Page->k_es_qty->viewAttributes() ?>>
<?= $Page->k_es_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_ak_qty->Visible) { // k_ak_qty ?>
        <td data-name="k_ak_qty"<?= $Page->k_ak_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_ak_qty" class="el_kontrak_k_ak_qty">
<span<?= $Page->k_ak_qty->viewAttributes() ?>>
<?= $Page->k_ak_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_es_perhektar->Visible) { // k_es_perhektar ?>
        <td data-name="k_es_perhektar"<?= $Page->k_es_perhektar->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_es_perhektar" class="el_kontrak_k_es_perhektar">
<span<?= $Page->k_es_perhektar->viewAttributes() ?>>
<?= $Page->k_es_perhektar->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_ak_perhektar->Visible) { // k_ak_perhektar ?>
        <td data-name="k_ak_perhektar"<?= $Page->k_ak_perhektar->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_ak_perhektar" class="el_kontrak_k_ak_perhektar">
<span<?= $Page->k_ak_perhektar->viewAttributes() ?>>
<?= $Page->k_ak_perhektar->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_skor->Visible) { // k_skor ?>
        <td data-name="k_skor"<?= $Page->k_skor->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_skor" class="el_kontrak_k_skor">
<span<?= $Page->k_skor->viewAttributes() ?>>
<?= $Page->k_skor->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_ket->Visible) { // k_ket ?>
        <td data-name="k_ket"<?= $Page->k_ket->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_ket" class="el_kontrak_k_ket">
<span<?= $Page->k_ket->viewAttributes() ?>>
<?= $Page->k_ket->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_cat->Visible) { // k_cat ?>
        <td data-name="k_cat"<?= $Page->k_cat->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_cat" class="el_kontrak_k_cat">
<span<?= $Page->k_cat->viewAttributes() ?>>
<?= $Page->k_cat->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
        <td data-name="k_titik_koordinat"<?= $Page->k_titik_koordinat->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_titik_koordinat" class="el_kontrak_k_titik_koordinat">
<span<?= $Page->k_titik_koordinat->viewAttributes() ?>>
<?php if (!EmptyString($Page->k_titik_koordinat->getViewValue()) && $Page->k_titik_koordinat->linkAttributes() != "") { ?>
<a<?= $Page->k_titik_koordinat->linkAttributes() ?>><?= $Page->k_titik_koordinat->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->k_titik_koordinat->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_foto_lahan->Visible) { // k_foto_lahan ?>
        <td data-name="k_foto_lahan"<?= $Page->k_foto_lahan->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_foto_lahan" class="el_kontrak_k_foto_lahan">
<span>
<?= GetFileViewTag($Page->k_foto_lahan, $Page->k_foto_lahan->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_dok->Visible) { // k_dok ?>
        <td data-name="k_dok"<?= $Page->k_dok->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_dok" class="el_kontrak_k_dok">
<span>
<?= GetFileViewTag($Page->k_dok, $Page->k_dok->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_harga_bibit->Visible) { // k_harga_bibit ?>
        <td data-name="k_harga_bibit"<?= $Page->k_harga_bibit->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_harga_bibit" class="el_kontrak_k_harga_bibit">
<span<?= $Page->k_harga_bibit->viewAttributes() ?>>
<?= $Page->k_harga_bibit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
        <td data-name="k_bayar_bibit"<?= $Page->k_bayar_bibit->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_bayar_bibit" class="el_kontrak_k_bayar_bibit">
<span<?= $Page->k_bayar_bibit->viewAttributes() ?>>
<?= $Page->k_bayar_bibit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_pinjaman->Visible) { // k_pinjaman ?>
        <td data-name="k_pinjaman"<?= $Page->k_pinjaman->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_pinjaman" class="el_kontrak_k_pinjaman">
<span<?= $Page->k_pinjaman->viewAttributes() ?>>
<?= $Page->k_pinjaman->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
        <td data-name="k_bayar_pinjaman"<?= $Page->k_bayar_pinjaman->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_bayar_pinjaman" class="el_kontrak_k_bayar_pinjaman">
<span<?= $Page->k_bayar_pinjaman->viewAttributes() ?>>
<?= $Page->k_bayar_pinjaman->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
        <td data-name="k_sisa_hutang"<?= $Page->k_sisa_hutang->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_k_sisa_hutang" class="el_kontrak_k_sisa_hutang">
<span<?= $Page->k_sisa_hutang->viewAttributes() ?>>
<?= $Page->k_sisa_hutang->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }
    if (
        $Page->Recordset &&
        !$Page->Recordset->EOF &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->Recordset->moveNext();
    }
    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = ROWTYPE_AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->k_id_kontrak->Visible) { // k_id_kontrak ?>
        <td data-name="k_id_kontrak" class="<?= $Page->k_id_kontrak->footerCellClass() ?>"><span id="elf_kontrak_k_id_kontrak" class="kontrak_k_id_kontrak">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_luas_lahan->Visible) { // k_luas_lahan ?>
        <td data-name="k_luas_lahan" class="<?= $Page->k_luas_lahan->footerCellClass() ?>"><span id="elf_kontrak_k_luas_lahan" class="kontrak_k_luas_lahan">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->k_luas_lahan->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pet_id->Visible) { // pet_id ?>
        <td data-name="pet_id" class="<?= $Page->pet_id->footerCellClass() ?>"><span id="elf_kontrak_pet_id" class="kontrak_pet_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->koord_id->Visible) { // koord_id ?>
        <td data-name="koord_id" class="<?= $Page->koord_id->footerCellClass() ?>"><span id="elf_kontrak_koord_id" class="kontrak_koord_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->kk_id->Visible) { // kk_id ?>
        <td data-name="kk_id" class="<?= $Page->kk_id->footerCellClass() ?>"><span id="elf_kontrak_kk_id" class="kontrak_kk_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->prov_id->Visible) { // prov_id ?>
        <td data-name="prov_id" class="<?= $Page->prov_id->footerCellClass() ?>"><span id="elf_kontrak_prov_id" class="kontrak_prov_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->kab_id->Visible) { // kab_id ?>
        <td data-name="kab_id" class="<?= $Page->kab_id->footerCellClass() ?>"><span id="elf_kontrak_kab_id" class="kontrak_kab_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->kec_id->Visible) { // kec_id ?>
        <td data-name="kec_id" class="<?= $Page->kec_id->footerCellClass() ?>"><span id="elf_kontrak_kec_id" class="kontrak_kec_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->desa_id->Visible) { // desa_id ?>
        <td data-name="desa_id" class="<?= $Page->desa_id->footerCellClass() ?>"><span id="elf_kontrak_desa_id" class="kontrak_desa_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->blok_id->Visible) { // blok_id ?>
        <td data-name="blok_id" class="<?= $Page->blok_id->footerCellClass() ?>"><span id="elf_kontrak_blok_id" class="kontrak_blok_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->sos_id->Visible) { // sos_id ?>
        <td data-name="sos_id" class="<?= $Page->sos_id->footerCellClass() ?>"><span id="elf_kontrak_sos_id" class="kontrak_sos_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->var_id->Visible) { // var_id ?>
        <td data-name="var_id" class="<?= $Page->var_id->footerCellClass() ?>"><span id="elf_kontrak_var_id" class="kontrak_var_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->co_id->Visible) { // co_id ?>
        <td data-name="co_id" class="<?= $Page->co_id->footerCellClass() ?>"><span id="elf_kontrak_co_id" class="kontrak_co_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_jumlah_bibit->Visible) { // k_jumlah_bibit ?>
        <td data-name="k_jumlah_bibit" class="<?= $Page->k_jumlah_bibit->footerCellClass() ?>"><span id="elf_kontrak_k_jumlah_bibit" class="kontrak_k_jumlah_bibit">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_asal_bibit->Visible) { // k_asal_bibit ?>
        <td data-name="k_asal_bibit" class="<?= $Page->k_asal_bibit->footerCellClass() ?>"><span id="elf_kontrak_k_asal_bibit" class="kontrak_k_asal_bibit">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
        <td data-name="k_tgl_tanam" class="<?= $Page->k_tgl_tanam->footerCellClass() ?>"><span id="elf_kontrak_k_tgl_tanam" class="kontrak_k_tgl_tanam">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_es_tgl_panen->Visible) { // k_es_tgl_panen ?>
        <td data-name="k_es_tgl_panen" class="<?= $Page->k_es_tgl_panen->footerCellClass() ?>"><span id="elf_kontrak_k_es_tgl_panen" class="kontrak_k_es_tgl_panen">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_ak_tgl_datang->Visible) { // k_ak_tgl_datang ?>
        <td data-name="k_ak_tgl_datang" class="<?= $Page->k_ak_tgl_datang->footerCellClass() ?>"><span id="elf_kontrak_k_ak_tgl_datang" class="kontrak_k_ak_tgl_datang">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_es_qty->Visible) { // k_es_qty ?>
        <td data-name="k_es_qty" class="<?= $Page->k_es_qty->footerCellClass() ?>"><span id="elf_kontrak_k_es_qty" class="kontrak_k_es_qty">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_ak_qty->Visible) { // k_ak_qty ?>
        <td data-name="k_ak_qty" class="<?= $Page->k_ak_qty->footerCellClass() ?>"><span id="elf_kontrak_k_ak_qty" class="kontrak_k_ak_qty">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_es_perhektar->Visible) { // k_es_perhektar ?>
        <td data-name="k_es_perhektar" class="<?= $Page->k_es_perhektar->footerCellClass() ?>"><span id="elf_kontrak_k_es_perhektar" class="kontrak_k_es_perhektar">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_ak_perhektar->Visible) { // k_ak_perhektar ?>
        <td data-name="k_ak_perhektar" class="<?= $Page->k_ak_perhektar->footerCellClass() ?>"><span id="elf_kontrak_k_ak_perhektar" class="kontrak_k_ak_perhektar">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_skor->Visible) { // k_skor ?>
        <td data-name="k_skor" class="<?= $Page->k_skor->footerCellClass() ?>"><span id="elf_kontrak_k_skor" class="kontrak_k_skor">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_ket->Visible) { // k_ket ?>
        <td data-name="k_ket" class="<?= $Page->k_ket->footerCellClass() ?>"><span id="elf_kontrak_k_ket" class="kontrak_k_ket">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_cat->Visible) { // k_cat ?>
        <td data-name="k_cat" class="<?= $Page->k_cat->footerCellClass() ?>"><span id="elf_kontrak_k_cat" class="kontrak_k_cat">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_titik_koordinat->Visible) { // k_titik_koordinat ?>
        <td data-name="k_titik_koordinat" class="<?= $Page->k_titik_koordinat->footerCellClass() ?>"><span id="elf_kontrak_k_titik_koordinat" class="kontrak_k_titik_koordinat">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_foto_lahan->Visible) { // k_foto_lahan ?>
        <td data-name="k_foto_lahan" class="<?= $Page->k_foto_lahan->footerCellClass() ?>"><span id="elf_kontrak_k_foto_lahan" class="kontrak_k_foto_lahan">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_dok->Visible) { // k_dok ?>
        <td data-name="k_dok" class="<?= $Page->k_dok->footerCellClass() ?>"><span id="elf_kontrak_k_dok" class="kontrak_k_dok">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_harga_bibit->Visible) { // k_harga_bibit ?>
        <td data-name="k_harga_bibit" class="<?= $Page->k_harga_bibit->footerCellClass() ?>"><span id="elf_kontrak_k_harga_bibit" class="kontrak_k_harga_bibit">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_bayar_bibit->Visible) { // k_bayar_bibit ?>
        <td data-name="k_bayar_bibit" class="<?= $Page->k_bayar_bibit->footerCellClass() ?>"><span id="elf_kontrak_k_bayar_bibit" class="kontrak_k_bayar_bibit">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_pinjaman->Visible) { // k_pinjaman ?>
        <td data-name="k_pinjaman" class="<?= $Page->k_pinjaman->footerCellClass() ?>"><span id="elf_kontrak_k_pinjaman" class="kontrak_k_pinjaman">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_bayar_pinjaman->Visible) { // k_bayar_pinjaman ?>
        <td data-name="k_bayar_pinjaman" class="<?= $Page->k_bayar_pinjaman->footerCellClass() ?>"><span id="elf_kontrak_k_bayar_pinjaman" class="kontrak_k_bayar_pinjaman">
        </span></td>
    <?php } ?>
    <?php if ($Page->k_sisa_hutang->Visible) { // k_sisa_hutang ?>
        <td data-name="k_sisa_hutang" class="<?= $Page->k_sisa_hutang->footerCellClass() ?>"><span id="elf_kontrak_k_sisa_hutang" class="kontrak_k_sisa_hutang">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Page->Recordset) {
    $Page->Recordset->close();
}
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("kontrak");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
