<?php

namespace PHPMaker2023\co;

use Slim\Views\PhpRenderer;
use Slim\Csrf\Guard;
use Slim\HttpCache\CacheProvider;
use Slim\Flash\Messages;
use Psr\Container\ContainerInterface;
use Monolog\Logger;
use Monolog\Handler\RotatingFileHandler;
use Doctrine\DBAL\Logging\LoggerChain;
use Doctrine\DBAL\Logging\DebugStack;

return [
    "cache" => \DI\create(CacheProvider::class),
    "flash" => fn(ContainerInterface $c) => new Messages(),
    "view" => fn(ContainerInterface $c) => new PhpRenderer($GLOBALS["RELATIVE_PATH"] . "views/"),
    "audit" => fn(ContainerInterface $c) => (new Logger("audit"))->pushHandler(new AuditTrailHandler("audit.log")), // For audit trail
    "log" => fn(ContainerInterface $c) => (new Logger("log"))->pushHandler(new RotatingFileHandler($GLOBALS["RELATIVE_PATH"] . "log.log")),
    "sqllogger" => function (ContainerInterface $c) {
        $loggers = [];
        if (Config("DEBUG")) {
            $loggers[] = $c->get("debugstack");
        }
        return (count($loggers) > 0) ? new LoggerChain($loggers) : null;
    },
    "csrf" => fn(ContainerInterface $c) => new Guard($GLOBALS["ResponseFactory"], Config("CSRF_PREFIX")),
    "debugstack" => \DI\create(DebugStack::class),
    "debugsqllogger" => \DI\create(DebugSqlLogger::class),
    "security" => \DI\create(AdvancedSecurity::class),
    "profile" => \DI\create(UserProfile::class),
    "language" => \DI\create(Language::class),
    "timer" => \DI\create(Timer::class),
    "session" => \DI\create(HttpSession::class),

    // Tables
    "blok" => \DI\create(Blok::class),
    "co" => \DI\create(Co::class),
    "desa" => \DI\create(Desa::class),
    "kab" => \DI\create(Kab::class),
    "kec" => \DI\create(Kec::class),
    "kontrak" => \DI\create(Kontrak::class),
    "koord" => \DI\create(Koord::class),
    "petani" => \DI\create(Petani::class),
    "prov" => \DI\create(Prov::class),
    "varietas" => \DI\create(Varietas::class),
    "employees" => \DI\create(Employees::class),
    "kontrak_koord" => \DI\create(KontrakKoord::class),
    "userlevelpermissions" => \DI\create(Userlevelpermissions::class),
    "userlevels" => \DI\create(Userlevels::class),
    "luasview" => \DI\create(Luasview::class),
    "bulan" => \DI\create(Bulan::class),
    "peserta" => \DI\create(Peserta::class),
    "sosialisasi" => \DI\create(Sosialisasi::class),
    "kegiatan_harian" => \DI\create(KegiatanHarian::class),
    "order_bibit" => \DI\create(OrderBibit::class),
    "estimasi_bibit" => \DI\create(EstimasiBibit::class),
    "tanam_bibit" => \DI\create(TanamBibit::class),
    "status_order_bibit" => \DI\create(StatusOrderBibit::class),
    "jenis_lahan_bibit" => \DI\create(JenisLahanBibit::class),
    "generasi_bibit" => \DI\create(GenerasiBibit::class),
    "bibit" => \DI\create(Bibit::class),
    "hirarki_bibit" => \DI\create(HirarkiBibit::class),
    "datang_sumber" => \DI\create(DatangSumber::class),
    "kedatangan" => \DI\create(Kedatangan::class),
    "qc" => \DI\create(Qc::class),
    "suplaiyer_ubi" => \DI\create(SuplaiyerUbi::class),
    "tingkat_resiko" => \DI\create(TingkatResiko::class),
    "verifikasi" => \DI\create(Verifikasi::class),
    "verifikasi_hasil" => \DI\create(VerifikasiHasil::class),
    "tema_sosialisasi" => \DI\create(TemaSosialisasi::class),
    "penggunaan_pestisida" => \DI\create(PenggunaanPestisida::class),
    "view5" => \DI\create(View5::class),
    "bahan_aktif_pestisida" => \DI\create(BahanAktifPestisida::class),
    "merek_pestisida" => \DI\create(MerekPestisida::class),

    // User table
    "usertable" => \DI\get("employees"),
];
