<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for sosialisasi
 */
class Sosialisasi extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $sos_id;
    public $sos_tgl;
    public $ts_id;
    public $sos_co;
    public $sos_peserta;
    public $sos_prov;
    public $sos_kab;
    public $sos_kec;
    public $sos_desa;
    public $sos_alamat;
    public $sos_pot_lahan;
    public $sos_katinggian;
    public $sos_biaya;
    public $sos_kesimpulan;
    public $sos_foto;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "sosialisasi";
        $this->TableName = 'sosialisasi';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "sosialisasi";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // sos_id
        $this->sos_id = new DbField(
            $this, // Table
            'x_sos_id', // Variable name
            'sos_id', // Name
            '`sos_id`', // Expression
            '`sos_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->sos_id->InputTextType = "text";
        $this->sos_id->IsAutoIncrement = true; // Autoincrement field
        $this->sos_id->IsPrimaryKey = true; // Primary key field
        $this->sos_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_id'] = &$this->sos_id;

        // sos_tgl
        $this->sos_tgl = new DbField(
            $this, // Table
            'x_sos_tgl', // Variable name
            'sos_tgl', // Name
            '`sos_tgl`', // Expression
            CastDateFieldForLike("`sos_tgl`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`sos_tgl`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sos_tgl->InputTextType = "text";
        $this->sos_tgl->Required = true; // Required field
        $this->sos_tgl->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->sos_tgl->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_tgl'] = &$this->sos_tgl;

        // ts_id
        $this->ts_id = new DbField(
            $this, // Table
            'x_ts_id', // Variable name
            'ts_id', // Name
            '`ts_id`', // Expression
            '`ts_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ts_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ts_id->InputTextType = "text";
        $this->ts_id->setSelectMultiple(false); // Select one
        $this->ts_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ts_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ts_id->Lookup = new Lookup('ts_id', 'tema_sosialisasi', false, 'ts_id', ["ts_judul","","",""], '', '', [], [], [], [], [], [], '', '', "`ts_judul`");
        $this->ts_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ts_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ts_id'] = &$this->ts_id;

        // sos_co
        $this->sos_co = new DbField(
            $this, // Table
            'x_sos_co', // Variable name
            'sos_co', // Name
            '`sos_co`', // Expression
            '`sos_co`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_co`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sos_co->InputTextType = "text";
        $this->sos_co->Required = true; // Required field
        $this->sos_co->setSelectMultiple(false); // Select one
        $this->sos_co->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sos_co->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sos_co->Lookup = new Lookup('sos_co', 'co', false, 'co_id', ["co_nama","","",""], '', '', [], [], [], [], [], [], '`co_nama` ASC', '', "`co_nama`");
        $this->sos_co->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_co->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_co'] = &$this->sos_co;

        // sos_peserta
        $this->sos_peserta = new DbField(
            $this, // Table
            'x_sos_peserta', // Variable name
            'sos_peserta', // Name
            '`sos_peserta`', // Expression
            '`sos_peserta`', // Basic search expression
            201, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_peserta`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sos_peserta->InputTextType = "text";
        $this->sos_peserta->setSelectMultiple(true); // Select multiple
        $this->sos_peserta->Lookup = new Lookup('sos_peserta', 'peserta', false, 'pes_id', ["pes_nama","kab_id","kec_id","desa_id"], '', '', [], [], [], [], [], [], '`pes_id` DESC', '', "CONCAT(COALESCE(`pes_nama`, ''),'" . ValueSeparator(1, $this->sos_peserta) . "',COALESCE(`kab_id`,''),'" . ValueSeparator(2, $this->sos_peserta) . "',COALESCE(`kec_id`,''),'" . ValueSeparator(3, $this->sos_peserta) . "',COALESCE(`desa_id`,''))");
        $this->sos_peserta->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_peserta'] = &$this->sos_peserta;

        // sos_prov
        $this->sos_prov = new DbField(
            $this, // Table
            'x_sos_prov', // Variable name
            'sos_prov', // Name
            '`sos_prov`', // Expression
            '`sos_prov`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_prov`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sos_prov->InputTextType = "text";
        $this->sos_prov->setSelectMultiple(false); // Select one
        $this->sos_prov->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sos_prov->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sos_prov->Lookup = new Lookup('sos_prov', 'prov', false, 'prov_id', ["prov_nama","","",""], '', '', [], ["x_sos_kab","x_sos_kec","x_sos_desa"], [], [], [], [], '`prov_nama` ASC', '', "`prov_nama`");
        $this->sos_prov->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_prov->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_prov'] = &$this->sos_prov;

        // sos_kab
        $this->sos_kab = new DbField(
            $this, // Table
            'x_sos_kab', // Variable name
            'sos_kab', // Name
            '`sos_kab`', // Expression
            '`sos_kab`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_kab`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sos_kab->InputTextType = "text";
        $this->sos_kab->setSelectMultiple(false); // Select one
        $this->sos_kab->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sos_kab->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sos_kab->Lookup = new Lookup('sos_kab', 'kab', false, 'kab_id', ["kab_nama","","",""], '', '', ["x_sos_prov"], ["x_sos_kec","x_sos_desa"], ["kab_prov_id"], ["x_kab_prov_id"], [], [], '`kab_nama` ASC', '', "`kab_nama`");
        $this->sos_kab->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_kab->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_kab'] = &$this->sos_kab;

        // sos_kec
        $this->sos_kec = new DbField(
            $this, // Table
            'x_sos_kec', // Variable name
            'sos_kec', // Name
            '`sos_kec`', // Expression
            '`sos_kec`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_kec`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sos_kec->InputTextType = "text";
        $this->sos_kec->setSelectMultiple(false); // Select one
        $this->sos_kec->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sos_kec->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sos_kec->Lookup = new Lookup('sos_kec', 'kec', false, 'kec_id', ["kec_nama","","",""], '', '', ["x_sos_prov","x_sos_kab"], ["x_sos_desa"], ["kec_prov_id","kec_kab_id"], ["x_kec_prov_id","x_kec_kab_id"], [], [], '`kec_nama` ASC', '', "`kec_nama`");
        $this->sos_kec->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_kec->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_kec'] = &$this->sos_kec;

        // sos_desa
        $this->sos_desa = new DbField(
            $this, // Table
            'x_sos_desa', // Variable name
            'sos_desa', // Name
            '`sos_desa`', // Expression
            '`sos_desa`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_desa`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sos_desa->InputTextType = "text";
        $this->sos_desa->setSelectMultiple(false); // Select one
        $this->sos_desa->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sos_desa->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sos_desa->Lookup = new Lookup('sos_desa', 'desa', false, 'desa_id', ["desa_nama","","",""], '', '', ["x_sos_prov","x_sos_kab","x_sos_kec"], [], ["desa_prov_id","desa_kab_id","desa_kec_id"], ["x_desa_prov_id","x_desa_kab_id","x_desa_kec_id"], [], [], '`desa_nama` ASC', '', "`desa_nama`");
        $this->sos_desa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_desa->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_desa'] = &$this->sos_desa;

        // sos_alamat
        $this->sos_alamat = new DbField(
            $this, // Table
            'x_sos_alamat', // Variable name
            'sos_alamat', // Name
            '`sos_alamat`', // Expression
            '`sos_alamat`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_alamat`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->sos_alamat->InputTextType = "text";
        $this->sos_alamat->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_alamat'] = &$this->sos_alamat;

        // sos_pot_lahan
        $this->sos_pot_lahan = new DbField(
            $this, // Table
            'x_sos_pot_lahan', // Variable name
            'sos_pot_lahan', // Name
            '`sos_pot_lahan`', // Expression
            '`sos_pot_lahan`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_pot_lahan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sos_pot_lahan->InputTextType = "text";
        $this->sos_pot_lahan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_pot_lahan->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_pot_lahan'] = &$this->sos_pot_lahan;

        // sos_katinggian
        $this->sos_katinggian = new DbField(
            $this, // Table
            'x_sos_katinggian', // Variable name
            'sos_katinggian', // Name
            '`sos_katinggian`', // Expression
            '`sos_katinggian`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_katinggian`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sos_katinggian->InputTextType = "text";
        $this->sos_katinggian->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_katinggian->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_katinggian'] = &$this->sos_katinggian;

        // sos_biaya
        $this->sos_biaya = new DbField(
            $this, // Table
            'x_sos_biaya', // Variable name
            'sos_biaya', // Name
            '`sos_biaya`', // Expression
            '`sos_biaya`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_biaya`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sos_biaya->InputTextType = "text";
        $this->sos_biaya->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_biaya->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_biaya'] = &$this->sos_biaya;

        // sos_kesimpulan
        $this->sos_kesimpulan = new DbField(
            $this, // Table
            'x_sos_kesimpulan', // Variable name
            'sos_kesimpulan', // Name
            '`sos_kesimpulan`', // Expression
            '`sos_kesimpulan`', // Basic search expression
            201, // Type
            65535, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sos_kesimpulan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->sos_kesimpulan->InputTextType = "text";
        $this->sos_kesimpulan->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_kesimpulan'] = &$this->sos_kesimpulan;

        // sos_foto
        $this->sos_foto = new DbField(
            $this, // Table
            'x_sos_foto', // Variable name
            'sos_foto', // Name
            '`sos_foto`', // Expression
            '`sos_foto`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`sos_foto`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->sos_foto->addMethod("getUploadPath", fn() => "foto_sosialisasi");
        $this->sos_foto->InputTextType = "text";
        $this->sos_foto->ImageResize = true;
        $this->sos_foto->UploadMultiple = true;
        $this->sos_foto->Upload->UploadMultiple = true;
        $this->sos_foto->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_foto'] = &$this->sos_foto;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "sosialisasi";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
            // Get insert id if necessary
            $this->sos_id->setDbValue($conn->lastInsertId());
            $rs['sos_id'] = $this->sos_id->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['sos_id']) && !EmptyValue($this->sos_id->CurrentValue)) {
                $rs['sos_id'] = $this->sos_id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('sos_id', $rs)) {
                AddFilter($where, QuotedName('sos_id', $this->Dbid) . '=' . QuotedValue($rs['sos_id'], $this->sos_id->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->sos_id->DbValue = $row['sos_id'];
        $this->sos_tgl->DbValue = $row['sos_tgl'];
        $this->ts_id->DbValue = $row['ts_id'];
        $this->sos_co->DbValue = $row['sos_co'];
        $this->sos_peserta->DbValue = $row['sos_peserta'];
        $this->sos_prov->DbValue = $row['sos_prov'];
        $this->sos_kab->DbValue = $row['sos_kab'];
        $this->sos_kec->DbValue = $row['sos_kec'];
        $this->sos_desa->DbValue = $row['sos_desa'];
        $this->sos_alamat->DbValue = $row['sos_alamat'];
        $this->sos_pot_lahan->DbValue = $row['sos_pot_lahan'];
        $this->sos_katinggian->DbValue = $row['sos_katinggian'];
        $this->sos_biaya->DbValue = $row['sos_biaya'];
        $this->sos_kesimpulan->DbValue = $row['sos_kesimpulan'];
        $this->sos_foto->Upload->DbValue = $row['sos_foto'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->sos_foto->OldUploadPath = $this->sos_foto->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['sos_foto']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['sos_foto']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->sos_foto->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->sos_foto->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`sos_id` = @sos_id@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->sos_id->CurrentValue : $this->sos_id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->sos_id->CurrentValue = $keys[0];
            } else {
                $this->sos_id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('sos_id', $row) ? $row['sos_id'] : null;
        } else {
            $val = !EmptyValue($this->sos_id->OldValue) && !$current ? $this->sos_id->OldValue : $this->sos_id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@sos_id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("SosialisasiList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "SosialisasiView") {
            return $Language->phrase("View");
        } elseif ($pageName == "SosialisasiEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "SosialisasiAdd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "SosialisasiView";
            case Config("API_ADD_ACTION"):
                return "SosialisasiAdd";
            case Config("API_EDIT_ACTION"):
                return "SosialisasiEdit";
            case Config("API_DELETE_ACTION"):
                return "SosialisasiDelete";
            case Config("API_LIST_ACTION"):
                return "SosialisasiList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "SosialisasiList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("SosialisasiView", $parm);
        } else {
            $url = $this->keyUrl("SosialisasiView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "SosialisasiAdd?" . $parm;
        } else {
            $url = "SosialisasiAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("SosialisasiEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("SosialisasiList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("SosialisasiAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("SosialisasiList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("SosialisasiDelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"sos_id\":" . JsonEncode($this->sos_id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->sos_id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->sos_id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("sos_id") ?? Route("sos_id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->sos_id->CurrentValue = $key;
            } else {
                $this->sos_id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->sos_id->setDbValue($row['sos_id']);
        $this->sos_tgl->setDbValue($row['sos_tgl']);
        $this->ts_id->setDbValue($row['ts_id']);
        $this->sos_co->setDbValue($row['sos_co']);
        $this->sos_peserta->setDbValue($row['sos_peserta']);
        $this->sos_prov->setDbValue($row['sos_prov']);
        $this->sos_kab->setDbValue($row['sos_kab']);
        $this->sos_kec->setDbValue($row['sos_kec']);
        $this->sos_desa->setDbValue($row['sos_desa']);
        $this->sos_alamat->setDbValue($row['sos_alamat']);
        $this->sos_pot_lahan->setDbValue($row['sos_pot_lahan']);
        $this->sos_katinggian->setDbValue($row['sos_katinggian']);
        $this->sos_biaya->setDbValue($row['sos_biaya']);
        $this->sos_kesimpulan->setDbValue($row['sos_kesimpulan']);
        $this->sos_foto->Upload->DbValue = $row['sos_foto'];
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "SosialisasiList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // sos_id

        // sos_tgl

        // ts_id

        // sos_co

        // sos_peserta

        // sos_prov

        // sos_kab

        // sos_kec

        // sos_desa

        // sos_alamat

        // sos_pot_lahan

        // sos_katinggian

        // sos_biaya

        // sos_kesimpulan

        // sos_foto

        // sos_id
        $this->sos_id->ViewValue = $this->sos_id->CurrentValue;

        // sos_tgl
        $this->sos_tgl->ViewValue = $this->sos_tgl->CurrentValue;
        $this->sos_tgl->ViewValue = FormatDateTime($this->sos_tgl->ViewValue, $this->sos_tgl->formatPattern());

        // ts_id
        $curVal = strval($this->ts_id->CurrentValue);
        if ($curVal != "") {
            $this->ts_id->ViewValue = $this->ts_id->lookupCacheOption($curVal);
            if ($this->ts_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`ts_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->ts_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ts_id->Lookup->renderViewRow($rswrk[0]);
                    $this->ts_id->ViewValue = $this->ts_id->displayValue($arwrk);
                } else {
                    $this->ts_id->ViewValue = $this->ts_id->CurrentValue;
                }
            }
        } else {
            $this->ts_id->ViewValue = null;
        }

        // sos_co
        $curVal = strval($this->sos_co->CurrentValue);
        if ($curVal != "") {
            $this->sos_co->ViewValue = $this->sos_co->lookupCacheOption($curVal);
            if ($this->sos_co->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_co->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_co->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_co->ViewValue = $this->sos_co->displayValue($arwrk);
                } else {
                    $this->sos_co->ViewValue = $this->sos_co->CurrentValue;
                }
            }
        } else {
            $this->sos_co->ViewValue = null;
        }

        // sos_peserta
        $curVal = strval($this->sos_peserta->CurrentValue);
        if ($curVal != "") {
            $this->sos_peserta->ViewValue = $this->sos_peserta->lookupCacheOption($curVal);
            if ($this->sos_peserta->ViewValue === null) { // Lookup from database
                $arwrk = explode(",", $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    if ($filterWrk != "") {
                        $filterWrk .= " OR ";
                    }
                    $filterWrk .= SearchFilter("`pes_id`", "=", trim($wrk), DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sos_peserta->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->sos_peserta->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->sos_peserta->Lookup->renderViewRow($row);
                        $this->sos_peserta->ViewValue->add($this->sos_peserta->displayValue($arwrk));
                    }
                } else {
                    $this->sos_peserta->ViewValue = $this->sos_peserta->CurrentValue;
                }
            }
        } else {
            $this->sos_peserta->ViewValue = null;
        }
        $this->sos_peserta->CellCssStyle .= "text-align: left;";

        // sos_prov
        $curVal = strval($this->sos_prov->CurrentValue);
        if ($curVal != "") {
            $this->sos_prov->ViewValue = $this->sos_prov->lookupCacheOption($curVal);
            if ($this->sos_prov->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_prov->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_prov->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_prov->ViewValue = $this->sos_prov->displayValue($arwrk);
                } else {
                    $this->sos_prov->ViewValue = $this->sos_prov->CurrentValue;
                }
            }
        } else {
            $this->sos_prov->ViewValue = null;
        }

        // sos_kab
        $curVal = strval($this->sos_kab->CurrentValue);
        if ($curVal != "") {
            $this->sos_kab->ViewValue = $this->sos_kab->lookupCacheOption($curVal);
            if ($this->sos_kab->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_kab->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_kab->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_kab->ViewValue = $this->sos_kab->displayValue($arwrk);
                } else {
                    $this->sos_kab->ViewValue = $this->sos_kab->CurrentValue;
                }
            }
        } else {
            $this->sos_kab->ViewValue = null;
        }

        // sos_kec
        $curVal = strval($this->sos_kec->CurrentValue);
        if ($curVal != "") {
            $this->sos_kec->ViewValue = $this->sos_kec->lookupCacheOption($curVal);
            if ($this->sos_kec->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_kec->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_kec->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_kec->ViewValue = $this->sos_kec->displayValue($arwrk);
                } else {
                    $this->sos_kec->ViewValue = $this->sos_kec->CurrentValue;
                }
            }
        } else {
            $this->sos_kec->ViewValue = null;
        }

        // sos_desa
        $curVal = strval($this->sos_desa->CurrentValue);
        if ($curVal != "") {
            $this->sos_desa->ViewValue = $this->sos_desa->lookupCacheOption($curVal);
            if ($this->sos_desa->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_desa->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_desa->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_desa->ViewValue = $this->sos_desa->displayValue($arwrk);
                } else {
                    $this->sos_desa->ViewValue = $this->sos_desa->CurrentValue;
                }
            }
        } else {
            $this->sos_desa->ViewValue = null;
        }

        // sos_alamat
        $this->sos_alamat->ViewValue = $this->sos_alamat->CurrentValue;

        // sos_pot_lahan
        $this->sos_pot_lahan->ViewValue = $this->sos_pot_lahan->CurrentValue;
        $this->sos_pot_lahan->CellCssStyle .= "text-align: right;";

        // sos_katinggian
        $this->sos_katinggian->ViewValue = $this->sos_katinggian->CurrentValue;
        $this->sos_katinggian->CellCssStyle .= "text-align: right;";

        // sos_biaya
        $this->sos_biaya->ViewValue = $this->sos_biaya->CurrentValue;

        // sos_kesimpulan
        $this->sos_kesimpulan->ViewValue = $this->sos_kesimpulan->CurrentValue;

        // sos_foto
        $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
        if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
            $this->sos_foto->ImageWidth = 80;
            $this->sos_foto->ImageHeight = 60;
            $this->sos_foto->ImageAlt = $this->sos_foto->alt();
            $this->sos_foto->ImageCssClass = "ew-image";
            $this->sos_foto->ViewValue = $this->sos_foto->Upload->DbValue;
        } else {
            $this->sos_foto->ViewValue = "";
        }
        $this->sos_foto->CellCssStyle .= "text-align: center;";

        // sos_id
        $this->sos_id->HrefValue = "";
        $this->sos_id->TooltipValue = "";

        // sos_tgl
        $this->sos_tgl->HrefValue = "";
        $this->sos_tgl->TooltipValue = "";

        // ts_id
        $this->ts_id->HrefValue = "";
        $this->ts_id->TooltipValue = "";

        // sos_co
        $this->sos_co->HrefValue = "";
        $this->sos_co->TooltipValue = "";

        // sos_peserta
        $this->sos_peserta->HrefValue = "";
        $this->sos_peserta->TooltipValue = "";

        // sos_prov
        $this->sos_prov->HrefValue = "";
        $this->sos_prov->TooltipValue = "";

        // sos_kab
        $this->sos_kab->HrefValue = "";
        $this->sos_kab->TooltipValue = "";

        // sos_kec
        $this->sos_kec->HrefValue = "";
        $this->sos_kec->TooltipValue = "";

        // sos_desa
        $this->sos_desa->HrefValue = "";
        $this->sos_desa->TooltipValue = "";

        // sos_alamat
        $this->sos_alamat->HrefValue = "";
        $this->sos_alamat->TooltipValue = "";

        // sos_pot_lahan
        $this->sos_pot_lahan->HrefValue = "";
        $this->sos_pot_lahan->TooltipValue = "";

        // sos_katinggian
        $this->sos_katinggian->HrefValue = "";
        $this->sos_katinggian->TooltipValue = "";

        // sos_biaya
        $this->sos_biaya->HrefValue = "";
        $this->sos_biaya->TooltipValue = "";

        // sos_kesimpulan
        $this->sos_kesimpulan->HrefValue = "";
        $this->sos_kesimpulan->TooltipValue = "";

        // sos_foto
        $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
        if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
            $this->sos_foto->HrefValue = "%u"; // Add prefix/suffix
            $this->sos_foto->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->sos_foto->HrefValue = FullUrl($this->sos_foto->HrefValue, "href");
            }
        } else {
            $this->sos_foto->HrefValue = "";
        }
        $this->sos_foto->ExportHrefValue = $this->sos_foto->UploadPath . $this->sos_foto->Upload->DbValue;
        $this->sos_foto->TooltipValue = "";
        if ($this->sos_foto->UseColorbox) {
            if (EmptyValue($this->sos_foto->TooltipValue)) {
                $this->sos_foto->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->sos_foto->LinkAttrs["data-rel"] = "sosialisasi_x_sos_foto";
            $this->sos_foto->LinkAttrs->appendClass("ew-lightbox");
        }

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // sos_id
        $this->sos_id->setupEditAttributes();
        $this->sos_id->EditValue = $this->sos_id->CurrentValue;

        // sos_tgl
        $this->sos_tgl->setupEditAttributes();
        $this->sos_tgl->EditValue = FormatDateTime($this->sos_tgl->CurrentValue, $this->sos_tgl->formatPattern());
        $this->sos_tgl->PlaceHolder = RemoveHtml($this->sos_tgl->caption());

        // ts_id
        $this->ts_id->setupEditAttributes();
        $this->ts_id->PlaceHolder = RemoveHtml($this->ts_id->caption());

        // sos_co
        $this->sos_co->setupEditAttributes();
        $this->sos_co->PlaceHolder = RemoveHtml($this->sos_co->caption());

        // sos_peserta
        $this->sos_peserta->PlaceHolder = RemoveHtml($this->sos_peserta->caption());

        // sos_prov
        $this->sos_prov->setupEditAttributes();
        $this->sos_prov->PlaceHolder = RemoveHtml($this->sos_prov->caption());

        // sos_kab
        $this->sos_kab->setupEditAttributes();
        $this->sos_kab->PlaceHolder = RemoveHtml($this->sos_kab->caption());

        // sos_kec
        $this->sos_kec->setupEditAttributes();
        $this->sos_kec->PlaceHolder = RemoveHtml($this->sos_kec->caption());

        // sos_desa
        $this->sos_desa->setupEditAttributes();
        $this->sos_desa->PlaceHolder = RemoveHtml($this->sos_desa->caption());

        // sos_alamat
        $this->sos_alamat->setupEditAttributes();
        $this->sos_alamat->EditValue = $this->sos_alamat->CurrentValue;
        $this->sos_alamat->PlaceHolder = RemoveHtml($this->sos_alamat->caption());

        // sos_pot_lahan
        $this->sos_pot_lahan->setupEditAttributes();
        $this->sos_pot_lahan->EditValue = $this->sos_pot_lahan->CurrentValue;
        $this->sos_pot_lahan->PlaceHolder = RemoveHtml($this->sos_pot_lahan->caption());
        if (strval($this->sos_pot_lahan->EditValue) != "" && is_numeric($this->sos_pot_lahan->EditValue)) {
            $this->sos_pot_lahan->EditValue = $this->sos_pot_lahan->EditValue;
        }

        // sos_katinggian
        $this->sos_katinggian->setupEditAttributes();
        $this->sos_katinggian->EditValue = $this->sos_katinggian->CurrentValue;
        $this->sos_katinggian->PlaceHolder = RemoveHtml($this->sos_katinggian->caption());
        if (strval($this->sos_katinggian->EditValue) != "" && is_numeric($this->sos_katinggian->EditValue)) {
            $this->sos_katinggian->EditValue = $this->sos_katinggian->EditValue;
        }

        // sos_biaya
        $this->sos_biaya->setupEditAttributes();
        $this->sos_biaya->EditValue = $this->sos_biaya->CurrentValue;
        $this->sos_biaya->PlaceHolder = RemoveHtml($this->sos_biaya->caption());
        if (strval($this->sos_biaya->EditValue) != "" && is_numeric($this->sos_biaya->EditValue)) {
            $this->sos_biaya->EditValue = $this->sos_biaya->EditValue;
        }

        // sos_kesimpulan
        $this->sos_kesimpulan->setupEditAttributes();
        $this->sos_kesimpulan->EditValue = $this->sos_kesimpulan->CurrentValue;
        $this->sos_kesimpulan->PlaceHolder = RemoveHtml($this->sos_kesimpulan->caption());

        // sos_foto
        $this->sos_foto->setupEditAttributes();
        $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
        if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
            $this->sos_foto->ImageWidth = 80;
            $this->sos_foto->ImageHeight = 60;
            $this->sos_foto->ImageAlt = $this->sos_foto->alt();
            $this->sos_foto->ImageCssClass = "ew-image";
            $this->sos_foto->EditValue = $this->sos_foto->Upload->DbValue;
        } else {
            $this->sos_foto->EditValue = "";
        }
        if (!EmptyValue($this->sos_foto->CurrentValue)) {
            $this->sos_foto->Upload->FileName = $this->sos_foto->CurrentValue;
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->sos_id);
                    $doc->exportCaption($this->sos_tgl);
                    $doc->exportCaption($this->ts_id);
                    $doc->exportCaption($this->sos_co);
                    $doc->exportCaption($this->sos_peserta);
                    $doc->exportCaption($this->sos_prov);
                    $doc->exportCaption($this->sos_kab);
                    $doc->exportCaption($this->sos_kec);
                    $doc->exportCaption($this->sos_desa);
                    $doc->exportCaption($this->sos_alamat);
                    $doc->exportCaption($this->sos_pot_lahan);
                    $doc->exportCaption($this->sos_katinggian);
                    $doc->exportCaption($this->sos_biaya);
                    $doc->exportCaption($this->sos_kesimpulan);
                    $doc->exportCaption($this->sos_foto);
                } else {
                    $doc->exportCaption($this->sos_id);
                    $doc->exportCaption($this->sos_tgl);
                    $doc->exportCaption($this->ts_id);
                    $doc->exportCaption($this->sos_co);
                    $doc->exportCaption($this->sos_peserta);
                    $doc->exportCaption($this->sos_prov);
                    $doc->exportCaption($this->sos_kab);
                    $doc->exportCaption($this->sos_kec);
                    $doc->exportCaption($this->sos_desa);
                    $doc->exportCaption($this->sos_alamat);
                    $doc->exportCaption($this->sos_pot_lahan);
                    $doc->exportCaption($this->sos_katinggian);
                    $doc->exportCaption($this->sos_biaya);
                    $doc->exportCaption($this->sos_kesimpulan);
                    $doc->exportCaption($this->sos_foto);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->sos_id);
                        $doc->exportField($this->sos_tgl);
                        $doc->exportField($this->ts_id);
                        $doc->exportField($this->sos_co);
                        $doc->exportField($this->sos_peserta);
                        $doc->exportField($this->sos_prov);
                        $doc->exportField($this->sos_kab);
                        $doc->exportField($this->sos_kec);
                        $doc->exportField($this->sos_desa);
                        $doc->exportField($this->sos_alamat);
                        $doc->exportField($this->sos_pot_lahan);
                        $doc->exportField($this->sos_katinggian);
                        $doc->exportField($this->sos_biaya);
                        $doc->exportField($this->sos_kesimpulan);
                        $doc->exportField($this->sos_foto);
                    } else {
                        $doc->exportField($this->sos_id);
                        $doc->exportField($this->sos_tgl);
                        $doc->exportField($this->ts_id);
                        $doc->exportField($this->sos_co);
                        $doc->exportField($this->sos_peserta);
                        $doc->exportField($this->sos_prov);
                        $doc->exportField($this->sos_kab);
                        $doc->exportField($this->sos_kec);
                        $doc->exportField($this->sos_desa);
                        $doc->exportField($this->sos_alamat);
                        $doc->exportField($this->sos_pot_lahan);
                        $doc->exportField($this->sos_katinggian);
                        $doc->exportField($this->sos_biaya);
                        $doc->exportField($this->sos_kesimpulan);
                        $doc->exportField($this->sos_foto);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'sos_foto') {
            $fldName = "sos_foto";
            $fileNameFld = "sos_foto";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->sos_id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DATATYPE_BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
