<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for order_bibit
 */
class OrderBibit extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $ob_id;
    public $ob_co;
    public $ob_k_tanam;
    public $ob_pembeli;
    public $ob_tgl_kirim;
    public $ob_var;
    public $ob_jumlah;
    public $status;
    public $ob_tgl_real_kirim;
    public $ob_jumlah_real_kirim;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "order_bibit";
        $this->TableName = 'order_bibit';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "order_bibit";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ob_id
        $this->ob_id = new DbField(
            $this, // Table
            'x_ob_id', // Variable name
            'ob_id', // Name
            '`ob_id`', // Expression
            '`ob_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ob_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->ob_id->InputTextType = "text";
        $this->ob_id->IsAutoIncrement = true; // Autoincrement field
        $this->ob_id->IsPrimaryKey = true; // Primary key field
        $this->ob_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ob_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ob_id'] = &$this->ob_id;

        // ob_co
        $this->ob_co = new DbField(
            $this, // Table
            'x_ob_co', // Variable name
            'ob_co', // Name
            '`ob_co`', // Expression
            '`ob_co`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ob_co`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ob_co->InputTextType = "text";
        $this->ob_co->setSelectMultiple(false); // Select one
        $this->ob_co->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ob_co->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ob_co->Lookup = new Lookup('ob_co', 'co', false, 'co_id', ["co_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`co_nama`");
        $this->ob_co->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ob_co->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ob_co'] = &$this->ob_co;

        // ob_k_tanam
        $this->ob_k_tanam = new DbField(
            $this, // Table
            'x_ob_k_tanam', // Variable name
            'ob_k_tanam', // Name
            '`ob_k_tanam`', // Expression
            '`ob_k_tanam`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ob_k_tanam`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ob_k_tanam->InputTextType = "text";
        $this->ob_k_tanam->setSelectMultiple(false); // Select one
        $this->ob_k_tanam->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ob_k_tanam->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ob_k_tanam->Lookup = new Lookup('ob_k_tanam', 'kontrak', false, 'k_id', ["k_id_kontrak","k_luas_lahan","",""], '', '', [], [], [], [], [], [], '', '', "CONCAT(COALESCE(`k_id_kontrak`, ''),'" . ValueSeparator(1, $this->ob_k_tanam) . "',COALESCE(`k_luas_lahan`,''))");
        $this->ob_k_tanam->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ob_k_tanam->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ob_k_tanam'] = &$this->ob_k_tanam;

        // ob_pembeli
        $this->ob_pembeli = new DbField(
            $this, // Table
            'x_ob_pembeli', // Variable name
            'ob_pembeli', // Name
            '`ob_pembeli`', // Expression
            '`ob_pembeli`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ob_pembeli`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ob_pembeli->InputTextType = "text";
        $this->ob_pembeli->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ob_pembeli'] = &$this->ob_pembeli;

        // ob_tgl_kirim
        $this->ob_tgl_kirim = new DbField(
            $this, // Table
            'x_ob_tgl_kirim', // Variable name
            'ob_tgl_kirim', // Name
            '`ob_tgl_kirim`', // Expression
            CastDateFieldForLike("`ob_tgl_kirim`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`ob_tgl_kirim`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ob_tgl_kirim->InputTextType = "text";
        $this->ob_tgl_kirim->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->ob_tgl_kirim->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ob_tgl_kirim'] = &$this->ob_tgl_kirim;

        // ob_var
        $this->ob_var = new DbField(
            $this, // Table
            'x_ob_var', // Variable name
            'ob_var', // Name
            '`ob_var`', // Expression
            '`ob_var`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ob_var`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ob_var->InputTextType = "text";
        $this->ob_var->setSelectMultiple(false); // Select one
        $this->ob_var->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ob_var->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ob_var->Lookup = new Lookup('ob_var', 'varietas', false, 'var_id', ["var_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`var_nama`");
        $this->ob_var->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ob_var->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ob_var'] = &$this->ob_var;

        // ob_jumlah
        $this->ob_jumlah = new DbField(
            $this, // Table
            'x_ob_jumlah', // Variable name
            'ob_jumlah', // Name
            '`ob_jumlah`', // Expression
            '`ob_jumlah`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ob_jumlah`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ob_jumlah->InputTextType = "text";
        $this->ob_jumlah->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ob_jumlah->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ob_jumlah'] = &$this->ob_jumlah;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->status->InputTextType = "text";
        $this->status->Lookup = new Lookup('status', 'status_order_bibit', false, 'status_order_bibit', ["status_order_bibit","","",""], '', '', [], [], [], [], [], [], '', '', "`status_order_bibit`");
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // ob_tgl_real_kirim
        $this->ob_tgl_real_kirim = new DbField(
            $this, // Table
            'x_ob_tgl_real_kirim', // Variable name
            'ob_tgl_real_kirim', // Name
            '`ob_tgl_real_kirim`', // Expression
            CastDateFieldForLike("`ob_tgl_real_kirim`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`ob_tgl_real_kirim`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ob_tgl_real_kirim->InputTextType = "text";
        $this->ob_tgl_real_kirim->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->ob_tgl_real_kirim->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ob_tgl_real_kirim'] = &$this->ob_tgl_real_kirim;

        // ob_jumlah_real_kirim
        $this->ob_jumlah_real_kirim = new DbField(
            $this, // Table
            'x_ob_jumlah_real_kirim', // Variable name
            'ob_jumlah_real_kirim', // Name
            '`ob_jumlah_real_kirim`', // Expression
            '`ob_jumlah_real_kirim`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ob_jumlah_real_kirim`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ob_jumlah_real_kirim->InputTextType = "text";
        $this->ob_jumlah_real_kirim->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ob_jumlah_real_kirim->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ob_jumlah_real_kirim'] = &$this->ob_jumlah_real_kirim;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "order_bibit";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
            // Get insert id if necessary
            $this->ob_id->setDbValue($conn->lastInsertId());
            $rs['ob_id'] = $this->ob_id->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['ob_id']) && !EmptyValue($this->ob_id->CurrentValue)) {
                $rs['ob_id'] = $this->ob_id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('ob_id', $rs)) {
                AddFilter($where, QuotedName('ob_id', $this->Dbid) . '=' . QuotedValue($rs['ob_id'], $this->ob_id->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ob_id->DbValue = $row['ob_id'];
        $this->ob_co->DbValue = $row['ob_co'];
        $this->ob_k_tanam->DbValue = $row['ob_k_tanam'];
        $this->ob_pembeli->DbValue = $row['ob_pembeli'];
        $this->ob_tgl_kirim->DbValue = $row['ob_tgl_kirim'];
        $this->ob_var->DbValue = $row['ob_var'];
        $this->ob_jumlah->DbValue = $row['ob_jumlah'];
        $this->status->DbValue = $row['status'];
        $this->ob_tgl_real_kirim->DbValue = $row['ob_tgl_real_kirim'];
        $this->ob_jumlah_real_kirim->DbValue = $row['ob_jumlah_real_kirim'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`ob_id` = @ob_id@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->ob_id->CurrentValue : $this->ob_id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->ob_id->CurrentValue = $keys[0];
            } else {
                $this->ob_id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('ob_id', $row) ? $row['ob_id'] : null;
        } else {
            $val = !EmptyValue($this->ob_id->OldValue) && !$current ? $this->ob_id->OldValue : $this->ob_id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@ob_id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("OrderBibitList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "OrderBibitView") {
            return $Language->phrase("View");
        } elseif ($pageName == "OrderBibitEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "OrderBibitAdd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "OrderBibitView";
            case Config("API_ADD_ACTION"):
                return "OrderBibitAdd";
            case Config("API_EDIT_ACTION"):
                return "OrderBibitEdit";
            case Config("API_DELETE_ACTION"):
                return "OrderBibitDelete";
            case Config("API_LIST_ACTION"):
                return "OrderBibitList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "OrderBibitList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("OrderBibitView", $parm);
        } else {
            $url = $this->keyUrl("OrderBibitView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "OrderBibitAdd?" . $parm;
        } else {
            $url = "OrderBibitAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("OrderBibitEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("OrderBibitList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("OrderBibitAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("OrderBibitList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("OrderBibitDelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"ob_id\":" . JsonEncode($this->ob_id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->ob_id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->ob_id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("ob_id") ?? Route("ob_id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->ob_id->CurrentValue = $key;
            } else {
                $this->ob_id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ob_id->setDbValue($row['ob_id']);
        $this->ob_co->setDbValue($row['ob_co']);
        $this->ob_k_tanam->setDbValue($row['ob_k_tanam']);
        $this->ob_pembeli->setDbValue($row['ob_pembeli']);
        $this->ob_tgl_kirim->setDbValue($row['ob_tgl_kirim']);
        $this->ob_var->setDbValue($row['ob_var']);
        $this->ob_jumlah->setDbValue($row['ob_jumlah']);
        $this->status->setDbValue($row['status']);
        $this->ob_tgl_real_kirim->setDbValue($row['ob_tgl_real_kirim']);
        $this->ob_jumlah_real_kirim->setDbValue($row['ob_jumlah_real_kirim']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "OrderBibitList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ob_id

        // ob_co

        // ob_k_tanam

        // ob_pembeli

        // ob_tgl_kirim

        // ob_var

        // ob_jumlah

        // status

        // ob_tgl_real_kirim

        // ob_jumlah_real_kirim

        // ob_id
        $this->ob_id->ViewValue = $this->ob_id->CurrentValue;

        // ob_co
        $curVal = strval($this->ob_co->CurrentValue);
        if ($curVal != "") {
            $this->ob_co->ViewValue = $this->ob_co->lookupCacheOption($curVal);
            if ($this->ob_co->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->ob_co->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ob_co->Lookup->renderViewRow($rswrk[0]);
                    $this->ob_co->ViewValue = $this->ob_co->displayValue($arwrk);
                } else {
                    $this->ob_co->ViewValue = $this->ob_co->CurrentValue;
                }
            }
        } else {
            $this->ob_co->ViewValue = null;
        }

        // ob_k_tanam
        $curVal = strval($this->ob_k_tanam->CurrentValue);
        if ($curVal != "") {
            $this->ob_k_tanam->ViewValue = $this->ob_k_tanam->lookupCacheOption($curVal);
            if ($this->ob_k_tanam->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`k_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->ob_k_tanam->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ob_k_tanam->Lookup->renderViewRow($rswrk[0]);
                    $this->ob_k_tanam->ViewValue = $this->ob_k_tanam->displayValue($arwrk);
                } else {
                    $this->ob_k_tanam->ViewValue = $this->ob_k_tanam->CurrentValue;
                }
            }
        } else {
            $this->ob_k_tanam->ViewValue = null;
        }

        // ob_pembeli
        $this->ob_pembeli->ViewValue = $this->ob_pembeli->CurrentValue;

        // ob_tgl_kirim
        $this->ob_tgl_kirim->ViewValue = $this->ob_tgl_kirim->CurrentValue;
        $this->ob_tgl_kirim->ViewValue = FormatDateTime($this->ob_tgl_kirim->ViewValue, $this->ob_tgl_kirim->formatPattern());

        // ob_var
        $curVal = strval($this->ob_var->CurrentValue);
        if ($curVal != "") {
            $this->ob_var->ViewValue = $this->ob_var->lookupCacheOption($curVal);
            if ($this->ob_var->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->ob_var->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ob_var->Lookup->renderViewRow($rswrk[0]);
                    $this->ob_var->ViewValue = $this->ob_var->displayValue($arwrk);
                } else {
                    $this->ob_var->ViewValue = $this->ob_var->CurrentValue;
                }
            }
        } else {
            $this->ob_var->ViewValue = null;
        }

        // ob_jumlah
        $this->ob_jumlah->ViewValue = $this->ob_jumlah->CurrentValue;

        // status
        $curVal = strval($this->status->CurrentValue);
        if ($curVal != "") {
            $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            if ($this->status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`status_order_bibit`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                    $this->status->ViewValue = $this->status->displayValue($arwrk);
                } else {
                    $this->status->ViewValue = $this->status->CurrentValue;
                }
            }
        } else {
            $this->status->ViewValue = null;
        }

        // ob_tgl_real_kirim
        $this->ob_tgl_real_kirim->ViewValue = $this->ob_tgl_real_kirim->CurrentValue;
        $this->ob_tgl_real_kirim->ViewValue = FormatDateTime($this->ob_tgl_real_kirim->ViewValue, $this->ob_tgl_real_kirim->formatPattern());

        // ob_jumlah_real_kirim
        $this->ob_jumlah_real_kirim->ViewValue = $this->ob_jumlah_real_kirim->CurrentValue;

        // ob_id
        $this->ob_id->HrefValue = "";
        $this->ob_id->TooltipValue = "";

        // ob_co
        $this->ob_co->HrefValue = "";
        $this->ob_co->TooltipValue = "";

        // ob_k_tanam
        $this->ob_k_tanam->HrefValue = "";
        $this->ob_k_tanam->TooltipValue = "";

        // ob_pembeli
        $this->ob_pembeli->HrefValue = "";
        $this->ob_pembeli->TooltipValue = "";

        // ob_tgl_kirim
        $this->ob_tgl_kirim->HrefValue = "";
        $this->ob_tgl_kirim->TooltipValue = "";

        // ob_var
        $this->ob_var->HrefValue = "";
        $this->ob_var->TooltipValue = "";

        // ob_jumlah
        $this->ob_jumlah->HrefValue = "";
        $this->ob_jumlah->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // ob_tgl_real_kirim
        $this->ob_tgl_real_kirim->HrefValue = "";
        $this->ob_tgl_real_kirim->TooltipValue = "";

        // ob_jumlah_real_kirim
        $this->ob_jumlah_real_kirim->HrefValue = "";
        $this->ob_jumlah_real_kirim->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ob_id
        $this->ob_id->setupEditAttributes();
        $this->ob_id->EditValue = $this->ob_id->CurrentValue;

        // ob_co
        $this->ob_co->setupEditAttributes();
        $curVal = strval($this->ob_co->CurrentValue);
        if ($curVal != "") {
            $this->ob_co->EditValue = $this->ob_co->lookupCacheOption($curVal);
            if ($this->ob_co->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->ob_co->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ob_co->Lookup->renderViewRow($rswrk[0]);
                    $this->ob_co->EditValue = $this->ob_co->displayValue($arwrk);
                } else {
                    $this->ob_co->EditValue = $this->ob_co->CurrentValue;
                }
            }
        } else {
            $this->ob_co->EditValue = null;
        }

        // ob_k_tanam
        $this->ob_k_tanam->setupEditAttributes();
        $this->ob_k_tanam->PlaceHolder = RemoveHtml($this->ob_k_tanam->caption());

        // ob_pembeli
        $this->ob_pembeli->setupEditAttributes();
        if (!$this->ob_pembeli->Raw) {
            $this->ob_pembeli->CurrentValue = HtmlDecode($this->ob_pembeli->CurrentValue);
        }
        $this->ob_pembeli->EditValue = $this->ob_pembeli->CurrentValue;
        $this->ob_pembeli->PlaceHolder = RemoveHtml($this->ob_pembeli->caption());

        // ob_tgl_kirim
        $this->ob_tgl_kirim->setupEditAttributes();
        $this->ob_tgl_kirim->EditValue = $this->ob_tgl_kirim->CurrentValue;
        $this->ob_tgl_kirim->EditValue = FormatDateTime($this->ob_tgl_kirim->EditValue, $this->ob_tgl_kirim->formatPattern());

        // ob_var
        $this->ob_var->setupEditAttributes();
        $curVal = strval($this->ob_var->CurrentValue);
        if ($curVal != "") {
            $this->ob_var->EditValue = $this->ob_var->lookupCacheOption($curVal);
            if ($this->ob_var->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->ob_var->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ob_var->Lookup->renderViewRow($rswrk[0]);
                    $this->ob_var->EditValue = $this->ob_var->displayValue($arwrk);
                } else {
                    $this->ob_var->EditValue = $this->ob_var->CurrentValue;
                }
            }
        } else {
            $this->ob_var->EditValue = null;
        }

        // ob_jumlah
        $this->ob_jumlah->setupEditAttributes();
        $this->ob_jumlah->EditValue = $this->ob_jumlah->CurrentValue;
        $this->ob_jumlah->PlaceHolder = RemoveHtml($this->ob_jumlah->caption());
        if (strval($this->ob_jumlah->EditValue) != "" && is_numeric($this->ob_jumlah->EditValue)) {
            $this->ob_jumlah->EditValue = $this->ob_jumlah->EditValue;
        }

        // status
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // ob_tgl_real_kirim
        $this->ob_tgl_real_kirim->setupEditAttributes();
        $this->ob_tgl_real_kirim->EditValue = FormatDateTime($this->ob_tgl_real_kirim->CurrentValue, $this->ob_tgl_real_kirim->formatPattern());
        $this->ob_tgl_real_kirim->PlaceHolder = RemoveHtml($this->ob_tgl_real_kirim->caption());

        // ob_jumlah_real_kirim
        $this->ob_jumlah_real_kirim->setupEditAttributes();
        $this->ob_jumlah_real_kirim->EditValue = $this->ob_jumlah_real_kirim->CurrentValue;
        $this->ob_jumlah_real_kirim->PlaceHolder = RemoveHtml($this->ob_jumlah_real_kirim->caption());
        if (strval($this->ob_jumlah_real_kirim->EditValue) != "" && is_numeric($this->ob_jumlah_real_kirim->EditValue)) {
            $this->ob_jumlah_real_kirim->EditValue = $this->ob_jumlah_real_kirim->EditValue;
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->ob_jumlah->CurrentValue)) {
                $this->ob_jumlah->Total += $this->ob_jumlah->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->ob_jumlah_real_kirim->CurrentValue)) {
                $this->ob_jumlah_real_kirim->Total += $this->ob_jumlah_real_kirim->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->ob_jumlah->CurrentValue = $this->ob_jumlah->Total;
            $this->ob_jumlah->ViewValue = $this->ob_jumlah->CurrentValue;
            $this->ob_jumlah->HrefValue = ""; // Clear href value
            $this->ob_jumlah_real_kirim->CurrentValue = $this->ob_jumlah_real_kirim->Total;
            $this->ob_jumlah_real_kirim->ViewValue = $this->ob_jumlah_real_kirim->CurrentValue;
            $this->ob_jumlah_real_kirim->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ob_id);
                    $doc->exportCaption($this->ob_co);
                    $doc->exportCaption($this->ob_k_tanam);
                    $doc->exportCaption($this->ob_pembeli);
                    $doc->exportCaption($this->ob_tgl_kirim);
                    $doc->exportCaption($this->ob_var);
                    $doc->exportCaption($this->ob_jumlah);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->ob_tgl_real_kirim);
                    $doc->exportCaption($this->ob_jumlah_real_kirim);
                } else {
                    $doc->exportCaption($this->ob_id);
                    $doc->exportCaption($this->ob_co);
                    $doc->exportCaption($this->ob_k_tanam);
                    $doc->exportCaption($this->ob_pembeli);
                    $doc->exportCaption($this->ob_tgl_kirim);
                    $doc->exportCaption($this->ob_var);
                    $doc->exportCaption($this->ob_jumlah);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->ob_tgl_real_kirim);
                    $doc->exportCaption($this->ob_jumlah_real_kirim);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ob_id);
                        $doc->exportField($this->ob_co);
                        $doc->exportField($this->ob_k_tanam);
                        $doc->exportField($this->ob_pembeli);
                        $doc->exportField($this->ob_tgl_kirim);
                        $doc->exportField($this->ob_var);
                        $doc->exportField($this->ob_jumlah);
                        $doc->exportField($this->status);
                        $doc->exportField($this->ob_tgl_real_kirim);
                        $doc->exportField($this->ob_jumlah_real_kirim);
                    } else {
                        $doc->exportField($this->ob_id);
                        $doc->exportField($this->ob_co);
                        $doc->exportField($this->ob_k_tanam);
                        $doc->exportField($this->ob_pembeli);
                        $doc->exportField($this->ob_tgl_kirim);
                        $doc->exportField($this->ob_var);
                        $doc->exportField($this->ob_jumlah);
                        $doc->exportField($this->status);
                        $doc->exportField($this->ob_tgl_real_kirim);
                        $doc->exportField($this->ob_jumlah_real_kirim);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = ROWTYPE_AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->ob_id, '');
                $doc->exportAggregate($this->ob_co, '');
                $doc->exportAggregate($this->ob_k_tanam, '');
                $doc->exportAggregate($this->ob_pembeli, '');
                $doc->exportAggregate($this->ob_tgl_kirim, '');
                $doc->exportAggregate($this->ob_var, '');
                $doc->exportAggregate($this->ob_jumlah, 'TOTAL');
                $doc->exportAggregate($this->status, '');
                $doc->exportAggregate($this->ob_tgl_real_kirim, '');
                $doc->exportAggregate($this->ob_jumlah_real_kirim, 'TOTAL');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
