<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for luasview
 */
class Luasview extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;
    public $Chart1;
    public $Chart2;

    // Fields
    public $Pic;
    public $varietas;
    public $Provinsi;
    public $Kabupaten;
    public $Koordinator;
    public $Tahun;
    public $Bulan;
    public $Luas;
    public $Estimasi_Panen;
    public $Aktual_Panen;
    public $Rata_rata_Skor;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "luasview";
        $this->TableName = 'luasview';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "luasview";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // Pic
        $this->Pic = new DbField(
            $this, // Table
            'x_Pic', // Variable name
            'Pic', // Name
            '`Pic`', // Expression
            '`Pic`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Pic`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Pic->InputTextType = "text";
        $this->Pic->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Pic'] = &$this->Pic;

        // varietas
        $this->varietas = new DbField(
            $this, // Table
            'x_varietas', // Variable name
            'varietas', // Name
            '`varietas`', // Expression
            '`varietas`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`varietas`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->varietas->InputTextType = "text";
        $this->varietas->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['varietas'] = &$this->varietas;

        // Provinsi
        $this->Provinsi = new DbField(
            $this, // Table
            'x_Provinsi', // Variable name
            'Provinsi', // Name
            '`Provinsi`', // Expression
            '`Provinsi`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Provinsi`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Provinsi->InputTextType = "text";
        $this->Provinsi->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Provinsi'] = &$this->Provinsi;

        // Kabupaten
        $this->Kabupaten = new DbField(
            $this, // Table
            'x_Kabupaten', // Variable name
            'Kabupaten', // Name
            '`Kabupaten`', // Expression
            '`Kabupaten`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Kabupaten`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Kabupaten->InputTextType = "text";
        $this->Kabupaten->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Kabupaten'] = &$this->Kabupaten;

        // Koordinator
        $this->Koordinator = new DbField(
            $this, // Table
            'x_Koordinator', // Variable name
            'Koordinator', // Name
            '`Koordinator`', // Expression
            '`Koordinator`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Koordinator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Koordinator->InputTextType = "text";
        $this->Koordinator->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Koordinator'] = &$this->Koordinator;

        // Tahun
        $this->Tahun = new DbField(
            $this, // Table
            'x_Tahun', // Variable name
            'Tahun', // Name
            '`Tahun`', // Expression
            '`Tahun`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Tahun`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Tahun->InputTextType = "text";
        $this->Tahun->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Tahun->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Tahun'] = &$this->Tahun;

        // Bulan
        $this->Bulan = new DbField(
            $this, // Table
            'x_Bulan', // Variable name
            'Bulan', // Name
            '`Bulan`', // Expression
            '`Bulan`', // Basic search expression
            3, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Bulan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Bulan->InputTextType = "text";
        $this->Bulan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Bulan->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Bulan'] = &$this->Bulan;

        // Luas
        $this->Luas = new DbField(
            $this, // Table
            'x_Luas', // Variable name
            'Luas', // Name
            '`Luas`', // Expression
            '`Luas`', // Basic search expression
            131, // Type
            32, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Luas`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Luas->InputTextType = "text";
        $this->Luas->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Luas->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Luas'] = &$this->Luas;

        // Estimasi_Panen
        $this->Estimasi_Panen = new DbField(
            $this, // Table
            'x_Estimasi_Panen', // Variable name
            'Estimasi_Panen', // Name
            '`Estimasi_Panen`', // Expression
            '`Estimasi_Panen`', // Basic search expression
            131, // Type
            32, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Estimasi_Panen`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Estimasi_Panen->InputTextType = "text";
        $this->Estimasi_Panen->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Estimasi_Panen->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Estimasi_Panen'] = &$this->Estimasi_Panen;

        // Aktual_Panen
        $this->Aktual_Panen = new DbField(
            $this, // Table
            'x_Aktual_Panen', // Variable name
            'Aktual_Panen', // Name
            '`Aktual_Panen`', // Expression
            '`Aktual_Panen`', // Basic search expression
            131, // Type
            32, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Aktual_Panen`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Aktual_Panen->InputTextType = "text";
        $this->Aktual_Panen->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Aktual_Panen->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Aktual_Panen'] = &$this->Aktual_Panen;

        // Rata_rata_Skor
        $this->Rata_rata_Skor = new DbField(
            $this, // Table
            'x_Rata_rata_Skor', // Variable name
            'Rata_rata_Skor', // Name
            '`Rata_rata_Skor`', // Expression
            '`Rata_rata_Skor`', // Basic search expression
            5, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Rata_rata_Skor`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Rata_rata_Skor->InputTextType = "text";
        $this->Rata_rata_Skor->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Rata_rata_Skor->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Rata_rata_Skor'] = &$this->Rata_rata_Skor;

        // Chart1
        $this->Chart1 = new DbChart($this, 'Chart1', 'Chart1', 'Pic', 'Luas', 1001, '', 0, 'SUM', 800, 440);
        $this->Chart1->Position = 4;
        $this->Chart1->PageBreakType = "before";
        $this->Chart1->YAxisFormat = ["None"];
        $this->Chart1->YFieldFormat = ["None"];
        $this->Chart1->SortType = 0;
        $this->Chart1->SortSequence = "";
        $this->Chart1->SqlSelect = $this->getQueryBuilder()->select("`Pic`", "''", "SUM(`Luas`)");
        $this->Chart1->SqlGroupBy = "`Pic`";
        $this->Chart1->SqlOrderBy = "";
        $this->Chart1->SeriesDateType = "";
        $this->Chart1->ID = "luasview_Chart1"; // Chart ID
        $this->Chart1->setParameters([
            ["type", "1001"],
            ["seriestype", "0"]
        ]); // Chart type / Chart series type
        $this->Chart1->setParameters([
            ["caption", $this->Chart1->caption()],
            ["xaxisname", $this->Chart1->xAxisName()]
        ]); // Chart caption / X axis name
        $this->Chart1->setParameter("yaxisname", $this->Chart1->yAxisName()); // Y axis name
        $this->Chart1->setParameters([
            ["shownames", "1"],
            ["showvalues", "1"],
            ["showhovercap", "1"]
        ]); // Show names / Show values / Show hover
        $this->Chart1->setParameter("alpha", "50"); // Chart alpha
        $this->Chart1->setParameter("colorpalette", "#FF0000|#FF0080|#FF00FF|#8000FF|#FF8000|#FF3D3D|#7AFFFF|#0000FF|#FFFF00|#FF7A7A|#3DFFFF|#0080FF|#80FF00|#00FF00|#00FF80|#00FFFF"); // Chart color palette
        $this->Charts[$this->Chart1->ID] = &$this->Chart1;

        // Chart2
        $this->Chart2 = new DbChart($this, 'Chart2', 'Chart2', 'Pic', 'Estimasi_Panen', 4031, 'Estimasi_Panen|Aktual_Panen', 1, 'SUM', 800, 440);
        $this->Chart2->Position = 4;
        $this->Chart2->PageBreakType = "before";
        $this->Chart2->SeriesRenderAs = ',';
        $this->Chart2->SeriesYAxis = '1,2';
        $this->Chart2->YAxisFormat = ["",""];
        $this->Chart2->YFieldFormat = ["None","None"];
        $this->Chart2->SortType = 0;
        $this->Chart2->SortSequence = "";
        $this->Chart2->SqlSelect = $this->getQueryBuilder()->select("`Pic`", "''", "SUM(`Estimasi_Panen`), SUM(`Aktual_Panen`)");
        $this->Chart2->SqlGroupBy = "`Pic`";
        $this->Chart2->SqlOrderBy = "";
        $this->Chart2->SeriesDateType = "";
        $this->Chart2->ID = "luasview_Chart2"; // Chart ID
        $this->Chart2->setParameters([
            ["type", "4031"],
            ["seriestype", "1"]
        ]); // Chart type / Chart series type
        $this->Chart2->setParameters([
            ["caption", $this->Chart2->caption()],
            ["xaxisname", $this->Chart2->xAxisName()]
        ]); // Chart caption / X axis name
        $this->Chart2->setParameters([
            ["PYAxisName", $this->Chart2->primaryYAxisName()],
            ["SYAxisName", $this->Chart2->secondaryYAxisName()]
        ]); // Primary Y axis name / Secondary Y axis name
        $this->Chart2->setParameters([
            ["shownames", "1"],
            ["showvalues", "1"],
            ["showhovercap", "1"]
        ]); // Show names / Show values / Show hover
        $this->Chart2->setParameter("alpha", "50"); // Chart alpha
        $this->Chart2->setParameter("colorpalette", "#FF0000|#FF0080|#FF00FF|#8000FF|#FF8000|#FF3D3D|#7AFFFF|#0000FF|#FFFF00|#FF7A7A|#3DFFFF|#0080FF|#80FF00|#00FF00|#00FF80|#00FFFF"); // Chart color palette
        $this->Charts[$this->Chart2->ID] = &$this->Chart2;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "luasview";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->Pic->DbValue = $row['Pic'];
        $this->varietas->DbValue = $row['varietas'];
        $this->Provinsi->DbValue = $row['Provinsi'];
        $this->Kabupaten->DbValue = $row['Kabupaten'];
        $this->Koordinator->DbValue = $row['Koordinator'];
        $this->Tahun->DbValue = $row['Tahun'];
        $this->Bulan->DbValue = $row['Bulan'];
        $this->Luas->DbValue = $row['Luas'];
        $this->Estimasi_Panen->DbValue = $row['Estimasi_Panen'];
        $this->Aktual_Panen->DbValue = $row['Aktual_Panen'];
        $this->Rata_rata_Skor->DbValue = $row['Rata_rata_Skor'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("LuasviewList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "LuasviewView") {
            return $Language->phrase("View");
        } elseif ($pageName == "LuasviewEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "LuasviewAdd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "LuasviewView";
            case Config("API_ADD_ACTION"):
                return "LuasviewAdd";
            case Config("API_EDIT_ACTION"):
                return "LuasviewEdit";
            case Config("API_DELETE_ACTION"):
                return "LuasviewDelete";
            case Config("API_LIST_ACTION"):
                return "LuasviewList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "LuasviewList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("LuasviewView", $parm);
        } else {
            $url = $this->keyUrl("LuasviewView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "LuasviewAdd?" . $parm;
        } else {
            $url = "LuasviewAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("LuasviewEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("LuasviewList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("LuasviewAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("LuasviewList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("LuasviewDelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->Pic->setDbValue($row['Pic']);
        $this->varietas->setDbValue($row['varietas']);
        $this->Provinsi->setDbValue($row['Provinsi']);
        $this->Kabupaten->setDbValue($row['Kabupaten']);
        $this->Koordinator->setDbValue($row['Koordinator']);
        $this->Tahun->setDbValue($row['Tahun']);
        $this->Bulan->setDbValue($row['Bulan']);
        $this->Luas->setDbValue($row['Luas']);
        $this->Estimasi_Panen->setDbValue($row['Estimasi_Panen']);
        $this->Aktual_Panen->setDbValue($row['Aktual_Panen']);
        $this->Rata_rata_Skor->setDbValue($row['Rata_rata_Skor']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "LuasviewList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // Pic

        // varietas

        // Provinsi

        // Kabupaten

        // Koordinator

        // Tahun

        // Bulan

        // Luas

        // Estimasi_Panen

        // Aktual_Panen

        // Rata_rata_Skor

        // Pic
        $this->Pic->ViewValue = $this->Pic->CurrentValue;

        // varietas
        $this->varietas->ViewValue = $this->varietas->CurrentValue;

        // Provinsi
        $this->Provinsi->ViewValue = $this->Provinsi->CurrentValue;

        // Kabupaten
        $this->Kabupaten->ViewValue = $this->Kabupaten->CurrentValue;

        // Koordinator
        $this->Koordinator->ViewValue = $this->Koordinator->CurrentValue;

        // Tahun
        $this->Tahun->ViewValue = $this->Tahun->CurrentValue;

        // Bulan
        $this->Bulan->ViewValue = $this->Bulan->CurrentValue;

        // Luas
        $this->Luas->ViewValue = $this->Luas->CurrentValue;
        $this->Luas->ViewValue = FormatNumber($this->Luas->ViewValue, $this->Luas->formatPattern());

        // Estimasi_Panen
        $this->Estimasi_Panen->ViewValue = $this->Estimasi_Panen->CurrentValue;
        $this->Estimasi_Panen->ViewValue = FormatNumber($this->Estimasi_Panen->ViewValue, $this->Estimasi_Panen->formatPattern());

        // Aktual_Panen
        $this->Aktual_Panen->ViewValue = $this->Aktual_Panen->CurrentValue;
        $this->Aktual_Panen->ViewValue = FormatNumber($this->Aktual_Panen->ViewValue, $this->Aktual_Panen->formatPattern());

        // Rata_rata_Skor
        $this->Rata_rata_Skor->ViewValue = $this->Rata_rata_Skor->CurrentValue;
        $this->Rata_rata_Skor->ViewValue = FormatNumber($this->Rata_rata_Skor->ViewValue, $this->Rata_rata_Skor->formatPattern());

        // Pic
        $this->Pic->HrefValue = "";
        $this->Pic->TooltipValue = "";

        // varietas
        $this->varietas->HrefValue = "";
        $this->varietas->TooltipValue = "";

        // Provinsi
        $this->Provinsi->HrefValue = "";
        $this->Provinsi->TooltipValue = "";

        // Kabupaten
        $this->Kabupaten->HrefValue = "";
        $this->Kabupaten->TooltipValue = "";

        // Koordinator
        $this->Koordinator->HrefValue = "";
        $this->Koordinator->TooltipValue = "";

        // Tahun
        $this->Tahun->HrefValue = "";
        $this->Tahun->TooltipValue = "";

        // Bulan
        $this->Bulan->HrefValue = "";
        $this->Bulan->TooltipValue = "";

        // Luas
        $this->Luas->HrefValue = "";
        $this->Luas->TooltipValue = "";

        // Estimasi_Panen
        $this->Estimasi_Panen->HrefValue = "";
        $this->Estimasi_Panen->TooltipValue = "";

        // Aktual_Panen
        $this->Aktual_Panen->HrefValue = "";
        $this->Aktual_Panen->TooltipValue = "";

        // Rata_rata_Skor
        $this->Rata_rata_Skor->HrefValue = "";
        $this->Rata_rata_Skor->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Pic
        $this->Pic->setupEditAttributes();
        if (!$this->Pic->Raw) {
            $this->Pic->CurrentValue = HtmlDecode($this->Pic->CurrentValue);
        }
        $this->Pic->EditValue = $this->Pic->CurrentValue;
        $this->Pic->PlaceHolder = RemoveHtml($this->Pic->caption());

        // varietas
        $this->varietas->setupEditAttributes();
        if (!$this->varietas->Raw) {
            $this->varietas->CurrentValue = HtmlDecode($this->varietas->CurrentValue);
        }
        $this->varietas->EditValue = $this->varietas->CurrentValue;
        $this->varietas->PlaceHolder = RemoveHtml($this->varietas->caption());

        // Provinsi
        $this->Provinsi->setupEditAttributes();
        if (!$this->Provinsi->Raw) {
            $this->Provinsi->CurrentValue = HtmlDecode($this->Provinsi->CurrentValue);
        }
        $this->Provinsi->EditValue = $this->Provinsi->CurrentValue;
        $this->Provinsi->PlaceHolder = RemoveHtml($this->Provinsi->caption());

        // Kabupaten
        $this->Kabupaten->setupEditAttributes();
        if (!$this->Kabupaten->Raw) {
            $this->Kabupaten->CurrentValue = HtmlDecode($this->Kabupaten->CurrentValue);
        }
        $this->Kabupaten->EditValue = $this->Kabupaten->CurrentValue;
        $this->Kabupaten->PlaceHolder = RemoveHtml($this->Kabupaten->caption());

        // Koordinator
        $this->Koordinator->setupEditAttributes();
        if (!$this->Koordinator->Raw) {
            $this->Koordinator->CurrentValue = HtmlDecode($this->Koordinator->CurrentValue);
        }
        $this->Koordinator->EditValue = $this->Koordinator->CurrentValue;
        $this->Koordinator->PlaceHolder = RemoveHtml($this->Koordinator->caption());

        // Tahun
        $this->Tahun->setupEditAttributes();
        $this->Tahun->EditValue = $this->Tahun->CurrentValue;
        $this->Tahun->PlaceHolder = RemoveHtml($this->Tahun->caption());
        if (strval($this->Tahun->EditValue) != "" && is_numeric($this->Tahun->EditValue)) {
            $this->Tahun->EditValue = $this->Tahun->EditValue;
        }

        // Bulan
        $this->Bulan->setupEditAttributes();
        $this->Bulan->EditValue = $this->Bulan->CurrentValue;
        $this->Bulan->PlaceHolder = RemoveHtml($this->Bulan->caption());
        if (strval($this->Bulan->EditValue) != "" && is_numeric($this->Bulan->EditValue)) {
            $this->Bulan->EditValue = $this->Bulan->EditValue;
        }

        // Luas
        $this->Luas->setupEditAttributes();
        $this->Luas->EditValue = $this->Luas->CurrentValue;
        $this->Luas->PlaceHolder = RemoveHtml($this->Luas->caption());
        if (strval($this->Luas->EditValue) != "" && is_numeric($this->Luas->EditValue)) {
            $this->Luas->EditValue = FormatNumber($this->Luas->EditValue, null);
        }

        // Estimasi_Panen
        $this->Estimasi_Panen->setupEditAttributes();
        $this->Estimasi_Panen->EditValue = $this->Estimasi_Panen->CurrentValue;
        $this->Estimasi_Panen->PlaceHolder = RemoveHtml($this->Estimasi_Panen->caption());
        if (strval($this->Estimasi_Panen->EditValue) != "" && is_numeric($this->Estimasi_Panen->EditValue)) {
            $this->Estimasi_Panen->EditValue = FormatNumber($this->Estimasi_Panen->EditValue, null);
        }

        // Aktual_Panen
        $this->Aktual_Panen->setupEditAttributes();
        $this->Aktual_Panen->EditValue = $this->Aktual_Panen->CurrentValue;
        $this->Aktual_Panen->PlaceHolder = RemoveHtml($this->Aktual_Panen->caption());
        if (strval($this->Aktual_Panen->EditValue) != "" && is_numeric($this->Aktual_Panen->EditValue)) {
            $this->Aktual_Panen->EditValue = FormatNumber($this->Aktual_Panen->EditValue, null);
        }

        // Rata_rata_Skor
        $this->Rata_rata_Skor->setupEditAttributes();
        $this->Rata_rata_Skor->EditValue = $this->Rata_rata_Skor->CurrentValue;
        $this->Rata_rata_Skor->PlaceHolder = RemoveHtml($this->Rata_rata_Skor->caption());
        if (strval($this->Rata_rata_Skor->EditValue) != "" && is_numeric($this->Rata_rata_Skor->EditValue)) {
            $this->Rata_rata_Skor->EditValue = FormatNumber($this->Rata_rata_Skor->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Pic);
                    $doc->exportCaption($this->varietas);
                    $doc->exportCaption($this->Provinsi);
                    $doc->exportCaption($this->Kabupaten);
                    $doc->exportCaption($this->Koordinator);
                    $doc->exportCaption($this->Tahun);
                    $doc->exportCaption($this->Bulan);
                    $doc->exportCaption($this->Luas);
                    $doc->exportCaption($this->Estimasi_Panen);
                    $doc->exportCaption($this->Aktual_Panen);
                    $doc->exportCaption($this->Rata_rata_Skor);
                } else {
                    $doc->exportCaption($this->Pic);
                    $doc->exportCaption($this->varietas);
                    $doc->exportCaption($this->Provinsi);
                    $doc->exportCaption($this->Kabupaten);
                    $doc->exportCaption($this->Koordinator);
                    $doc->exportCaption($this->Tahun);
                    $doc->exportCaption($this->Bulan);
                    $doc->exportCaption($this->Luas);
                    $doc->exportCaption($this->Estimasi_Panen);
                    $doc->exportCaption($this->Aktual_Panen);
                    $doc->exportCaption($this->Rata_rata_Skor);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Pic);
                        $doc->exportField($this->varietas);
                        $doc->exportField($this->Provinsi);
                        $doc->exportField($this->Kabupaten);
                        $doc->exportField($this->Koordinator);
                        $doc->exportField($this->Tahun);
                        $doc->exportField($this->Bulan);
                        $doc->exportField($this->Luas);
                        $doc->exportField($this->Estimasi_Panen);
                        $doc->exportField($this->Aktual_Panen);
                        $doc->exportField($this->Rata_rata_Skor);
                    } else {
                        $doc->exportField($this->Pic);
                        $doc->exportField($this->varietas);
                        $doc->exportField($this->Provinsi);
                        $doc->exportField($this->Kabupaten);
                        $doc->exportField($this->Koordinator);
                        $doc->exportField($this->Tahun);
                        $doc->exportField($this->Bulan);
                        $doc->exportField($this->Luas);
                        $doc->exportField($this->Estimasi_Panen);
                        $doc->exportField($this->Aktual_Panen);
                        $doc->exportField($this->Rata_rata_Skor);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
