<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for luasdetail
 */
class Luasdetail extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $ID_Kontrak;
    public $Pic;
    public $varietas;
    public $Provinsi;
    public $Kabupaten;
    public $Kecamatan;
    public $Desa;
    public $Koordinator;
    public $Nama_Petani;
    public $Tanggal;
    public $Luas;
    public $Estimasi_Tanggal_Panen;
    public $Estimasi_Panen;
    public $Tanggal_datang;
    public $Aktual_Panen;
    public $Rata_rata_Skor;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "luasdetail";
        $this->TableName = 'luasdetail';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "luasdetail";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ID_Kontrak
        $this->ID_Kontrak = new DbField(
            $this, // Table
            'x_ID_Kontrak', // Variable name
            'ID_Kontrak', // Name
            '`ID_Kontrak`', // Expression
            '`ID_Kontrak`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ID_Kontrak`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ID_Kontrak->InputTextType = "text";
        $this->ID_Kontrak->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ID_Kontrak'] = &$this->ID_Kontrak;

        // Pic
        $this->Pic = new DbField(
            $this, // Table
            'x_Pic', // Variable name
            'Pic', // Name
            '`Pic`', // Expression
            '`Pic`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Pic`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Pic->InputTextType = "text";
        $this->Pic->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Pic'] = &$this->Pic;

        // varietas
        $this->varietas = new DbField(
            $this, // Table
            'x_varietas', // Variable name
            'varietas', // Name
            '`varietas`', // Expression
            '`varietas`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`varietas`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->varietas->InputTextType = "text";
        $this->varietas->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['varietas'] = &$this->varietas;

        // Provinsi
        $this->Provinsi = new DbField(
            $this, // Table
            'x_Provinsi', // Variable name
            'Provinsi', // Name
            '`Provinsi`', // Expression
            '`Provinsi`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Provinsi`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Provinsi->InputTextType = "text";
        $this->Provinsi->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Provinsi'] = &$this->Provinsi;

        // Kabupaten
        $this->Kabupaten = new DbField(
            $this, // Table
            'x_Kabupaten', // Variable name
            'Kabupaten', // Name
            '`Kabupaten`', // Expression
            '`Kabupaten`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Kabupaten`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Kabupaten->InputTextType = "text";
        $this->Kabupaten->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Kabupaten'] = &$this->Kabupaten;

        // Kecamatan
        $this->Kecamatan = new DbField(
            $this, // Table
            'x_Kecamatan', // Variable name
            'Kecamatan', // Name
            '`Kecamatan`', // Expression
            '`Kecamatan`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Kecamatan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Kecamatan->InputTextType = "text";
        $this->Kecamatan->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Kecamatan'] = &$this->Kecamatan;

        // Desa
        $this->Desa = new DbField(
            $this, // Table
            'x_Desa', // Variable name
            'Desa', // Name
            '`Desa`', // Expression
            '`Desa`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Desa`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Desa->InputTextType = "text";
        $this->Desa->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Desa'] = &$this->Desa;

        // Koordinator
        $this->Koordinator = new DbField(
            $this, // Table
            'x_Koordinator', // Variable name
            'Koordinator', // Name
            '`Koordinator`', // Expression
            '`Koordinator`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Koordinator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Koordinator->InputTextType = "text";
        $this->Koordinator->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Koordinator'] = &$this->Koordinator;

        // Nama_Petani
        $this->Nama_Petani = new DbField(
            $this, // Table
            'x_Nama_Petani', // Variable name
            'Nama_Petani', // Name
            '`Nama_Petani`', // Expression
            '`Nama_Petani`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Nama_Petani`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Nama_Petani->InputTextType = "text";
        $this->Nama_Petani->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Nama_Petani'] = &$this->Nama_Petani;

        // Tanggal
        $this->Tanggal = new DbField(
            $this, // Table
            'x_Tanggal', // Variable name
            'Tanggal', // Name
            '`Tanggal`', // Expression
            CastDateFieldForLike("`Tanggal`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`Tanggal`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Tanggal->InputTextType = "text";
        $this->Tanggal->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Tanggal->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Tanggal'] = &$this->Tanggal;

        // Luas
        $this->Luas = new DbField(
            $this, // Table
            'x_Luas', // Variable name
            'Luas', // Name
            '`Luas`', // Expression
            '`Luas`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Luas`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Luas->InputTextType = "text";
        $this->Luas->Nullable = false; // NOT NULL field
        $this->Luas->Required = true; // Required field
        $this->Luas->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Luas->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Luas'] = &$this->Luas;

        // Estimasi_Tanggal_Panen
        $this->Estimasi_Tanggal_Panen = new DbField(
            $this, // Table
            'x_Estimasi_Tanggal_Panen', // Variable name
            'Estimasi_Tanggal_Panen', // Name
            '`Estimasi_Tanggal_Panen`', // Expression
            CastDateFieldForLike("`Estimasi_Tanggal_Panen`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`Estimasi_Tanggal_Panen`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Estimasi_Tanggal_Panen->InputTextType = "text";
        $this->Estimasi_Tanggal_Panen->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Estimasi_Tanggal_Panen->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Estimasi_Tanggal_Panen'] = &$this->Estimasi_Tanggal_Panen;

        // Estimasi_Panen
        $this->Estimasi_Panen = new DbField(
            $this, // Table
            'x_Estimasi_Panen', // Variable name
            'Estimasi_Panen', // Name
            '`Estimasi_Panen`', // Expression
            '`Estimasi_Panen`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Estimasi_Panen`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Estimasi_Panen->InputTextType = "text";
        $this->Estimasi_Panen->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Estimasi_Panen->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Estimasi_Panen'] = &$this->Estimasi_Panen;

        // Tanggal_datang
        $this->Tanggal_datang = new DbField(
            $this, // Table
            'x_Tanggal_datang', // Variable name
            'Tanggal_datang', // Name
            '`Tanggal_datang`', // Expression
            CastDateFieldForLike("`Tanggal_datang`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`Tanggal_datang`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Tanggal_datang->InputTextType = "text";
        $this->Tanggal_datang->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Tanggal_datang->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Tanggal_datang'] = &$this->Tanggal_datang;

        // Aktual_Panen
        $this->Aktual_Panen = new DbField(
            $this, // Table
            'x_Aktual_Panen', // Variable name
            'Aktual_Panen', // Name
            '`Aktual_Panen`', // Expression
            '`Aktual_Panen`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Aktual_Panen`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Aktual_Panen->InputTextType = "text";
        $this->Aktual_Panen->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Aktual_Panen->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Aktual_Panen'] = &$this->Aktual_Panen;

        // Rata_rata_Skor
        $this->Rata_rata_Skor = new DbField(
            $this, // Table
            'x_Rata_rata_Skor', // Variable name
            'Rata_rata_Skor', // Name
            '`Rata_rata_Skor`', // Expression
            '`Rata_rata_Skor`', // Basic search expression
            5, // Type
            15, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Rata_rata_Skor`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Rata_rata_Skor->InputTextType = "text";
        $this->Rata_rata_Skor->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Rata_rata_Skor->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Rata_rata_Skor'] = &$this->Rata_rata_Skor;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "luasdetail";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ID_Kontrak->DbValue = $row['ID_Kontrak'];
        $this->Pic->DbValue = $row['Pic'];
        $this->varietas->DbValue = $row['varietas'];
        $this->Provinsi->DbValue = $row['Provinsi'];
        $this->Kabupaten->DbValue = $row['Kabupaten'];
        $this->Kecamatan->DbValue = $row['Kecamatan'];
        $this->Desa->DbValue = $row['Desa'];
        $this->Koordinator->DbValue = $row['Koordinator'];
        $this->Nama_Petani->DbValue = $row['Nama_Petani'];
        $this->Tanggal->DbValue = $row['Tanggal'];
        $this->Luas->DbValue = $row['Luas'];
        $this->Estimasi_Tanggal_Panen->DbValue = $row['Estimasi_Tanggal_Panen'];
        $this->Estimasi_Panen->DbValue = $row['Estimasi_Panen'];
        $this->Tanggal_datang->DbValue = $row['Tanggal_datang'];
        $this->Aktual_Panen->DbValue = $row['Aktual_Panen'];
        $this->Rata_rata_Skor->DbValue = $row['Rata_rata_Skor'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("LuasdetailList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "LuasdetailView") {
            return $Language->phrase("View");
        } elseif ($pageName == "LuasdetailEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "LuasdetailAdd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "LuasdetailView";
            case Config("API_ADD_ACTION"):
                return "LuasdetailAdd";
            case Config("API_EDIT_ACTION"):
                return "LuasdetailEdit";
            case Config("API_DELETE_ACTION"):
                return "LuasdetailDelete";
            case Config("API_LIST_ACTION"):
                return "LuasdetailList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "LuasdetailList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("LuasdetailView", $parm);
        } else {
            $url = $this->keyUrl("LuasdetailView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "LuasdetailAdd?" . $parm;
        } else {
            $url = "LuasdetailAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("LuasdetailEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("LuasdetailList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("LuasdetailAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("LuasdetailList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("LuasdetailDelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ID_Kontrak->setDbValue($row['ID_Kontrak']);
        $this->Pic->setDbValue($row['Pic']);
        $this->varietas->setDbValue($row['varietas']);
        $this->Provinsi->setDbValue($row['Provinsi']);
        $this->Kabupaten->setDbValue($row['Kabupaten']);
        $this->Kecamatan->setDbValue($row['Kecamatan']);
        $this->Desa->setDbValue($row['Desa']);
        $this->Koordinator->setDbValue($row['Koordinator']);
        $this->Nama_Petani->setDbValue($row['Nama_Petani']);
        $this->Tanggal->setDbValue($row['Tanggal']);
        $this->Luas->setDbValue($row['Luas']);
        $this->Estimasi_Tanggal_Panen->setDbValue($row['Estimasi_Tanggal_Panen']);
        $this->Estimasi_Panen->setDbValue($row['Estimasi_Panen']);
        $this->Tanggal_datang->setDbValue($row['Tanggal_datang']);
        $this->Aktual_Panen->setDbValue($row['Aktual_Panen']);
        $this->Rata_rata_Skor->setDbValue($row['Rata_rata_Skor']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "LuasdetailList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ID_Kontrak

        // Pic

        // varietas

        // Provinsi

        // Kabupaten

        // Kecamatan

        // Desa

        // Koordinator

        // Nama_Petani

        // Tanggal

        // Luas

        // Estimasi_Tanggal_Panen

        // Estimasi_Panen

        // Tanggal_datang

        // Aktual_Panen

        // Rata_rata_Skor

        // ID_Kontrak
        $this->ID_Kontrak->ViewValue = $this->ID_Kontrak->CurrentValue;

        // Pic
        $this->Pic->ViewValue = $this->Pic->CurrentValue;

        // varietas
        $this->varietas->ViewValue = $this->varietas->CurrentValue;

        // Provinsi
        $this->Provinsi->ViewValue = $this->Provinsi->CurrentValue;

        // Kabupaten
        $this->Kabupaten->ViewValue = $this->Kabupaten->CurrentValue;

        // Kecamatan
        $this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;

        // Desa
        $this->Desa->ViewValue = $this->Desa->CurrentValue;

        // Koordinator
        $this->Koordinator->ViewValue = $this->Koordinator->CurrentValue;

        // Nama_Petani
        $this->Nama_Petani->ViewValue = $this->Nama_Petani->CurrentValue;

        // Tanggal
        $this->Tanggal->ViewValue = $this->Tanggal->CurrentValue;
        $this->Tanggal->ViewValue = FormatDateTime($this->Tanggal->ViewValue, $this->Tanggal->formatPattern());

        // Luas
        $this->Luas->ViewValue = $this->Luas->CurrentValue;

        // Estimasi_Tanggal_Panen
        $this->Estimasi_Tanggal_Panen->ViewValue = $this->Estimasi_Tanggal_Panen->CurrentValue;
        $this->Estimasi_Tanggal_Panen->ViewValue = FormatDateTime($this->Estimasi_Tanggal_Panen->ViewValue, $this->Estimasi_Tanggal_Panen->formatPattern());

        // Estimasi_Panen
        $this->Estimasi_Panen->ViewValue = $this->Estimasi_Panen->CurrentValue;

        // Tanggal_datang
        $this->Tanggal_datang->ViewValue = $this->Tanggal_datang->CurrentValue;
        $this->Tanggal_datang->ViewValue = FormatDateTime($this->Tanggal_datang->ViewValue, $this->Tanggal_datang->formatPattern());

        // Aktual_Panen
        $this->Aktual_Panen->ViewValue = $this->Aktual_Panen->CurrentValue;

        // Rata_rata_Skor
        $this->Rata_rata_Skor->ViewValue = $this->Rata_rata_Skor->CurrentValue;
        $this->Rata_rata_Skor->ViewValue = FormatNumber($this->Rata_rata_Skor->ViewValue, $this->Rata_rata_Skor->formatPattern());

        // ID_Kontrak
        $this->ID_Kontrak->HrefValue = "";
        $this->ID_Kontrak->TooltipValue = "";

        // Pic
        $this->Pic->HrefValue = "";
        $this->Pic->TooltipValue = "";

        // varietas
        $this->varietas->HrefValue = "";
        $this->varietas->TooltipValue = "";

        // Provinsi
        $this->Provinsi->HrefValue = "";
        $this->Provinsi->TooltipValue = "";

        // Kabupaten
        $this->Kabupaten->HrefValue = "";
        $this->Kabupaten->TooltipValue = "";

        // Kecamatan
        $this->Kecamatan->HrefValue = "";
        $this->Kecamatan->TooltipValue = "";

        // Desa
        $this->Desa->HrefValue = "";
        $this->Desa->TooltipValue = "";

        // Koordinator
        $this->Koordinator->HrefValue = "";
        $this->Koordinator->TooltipValue = "";

        // Nama_Petani
        $this->Nama_Petani->HrefValue = "";
        $this->Nama_Petani->TooltipValue = "";

        // Tanggal
        $this->Tanggal->HrefValue = "";
        $this->Tanggal->TooltipValue = "";

        // Luas
        $this->Luas->HrefValue = "";
        $this->Luas->TooltipValue = "";

        // Estimasi_Tanggal_Panen
        $this->Estimasi_Tanggal_Panen->HrefValue = "";
        $this->Estimasi_Tanggal_Panen->TooltipValue = "";

        // Estimasi_Panen
        $this->Estimasi_Panen->HrefValue = "";
        $this->Estimasi_Panen->TooltipValue = "";

        // Tanggal_datang
        $this->Tanggal_datang->HrefValue = "";
        $this->Tanggal_datang->TooltipValue = "";

        // Aktual_Panen
        $this->Aktual_Panen->HrefValue = "";
        $this->Aktual_Panen->TooltipValue = "";

        // Rata_rata_Skor
        $this->Rata_rata_Skor->HrefValue = "";
        $this->Rata_rata_Skor->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ID_Kontrak
        $this->ID_Kontrak->setupEditAttributes();
        if (!$this->ID_Kontrak->Raw) {
            $this->ID_Kontrak->CurrentValue = HtmlDecode($this->ID_Kontrak->CurrentValue);
        }
        $this->ID_Kontrak->EditValue = $this->ID_Kontrak->CurrentValue;
        $this->ID_Kontrak->PlaceHolder = RemoveHtml($this->ID_Kontrak->caption());

        // Pic
        $this->Pic->setupEditAttributes();
        if (!$this->Pic->Raw) {
            $this->Pic->CurrentValue = HtmlDecode($this->Pic->CurrentValue);
        }
        $this->Pic->EditValue = $this->Pic->CurrentValue;
        $this->Pic->PlaceHolder = RemoveHtml($this->Pic->caption());

        // varietas
        $this->varietas->setupEditAttributes();
        if (!$this->varietas->Raw) {
            $this->varietas->CurrentValue = HtmlDecode($this->varietas->CurrentValue);
        }
        $this->varietas->EditValue = $this->varietas->CurrentValue;
        $this->varietas->PlaceHolder = RemoveHtml($this->varietas->caption());

        // Provinsi
        $this->Provinsi->setupEditAttributes();
        if (!$this->Provinsi->Raw) {
            $this->Provinsi->CurrentValue = HtmlDecode($this->Provinsi->CurrentValue);
        }
        $this->Provinsi->EditValue = $this->Provinsi->CurrentValue;
        $this->Provinsi->PlaceHolder = RemoveHtml($this->Provinsi->caption());

        // Kabupaten
        $this->Kabupaten->setupEditAttributes();
        if (!$this->Kabupaten->Raw) {
            $this->Kabupaten->CurrentValue = HtmlDecode($this->Kabupaten->CurrentValue);
        }
        $this->Kabupaten->EditValue = $this->Kabupaten->CurrentValue;
        $this->Kabupaten->PlaceHolder = RemoveHtml($this->Kabupaten->caption());

        // Kecamatan
        $this->Kecamatan->setupEditAttributes();
        if (!$this->Kecamatan->Raw) {
            $this->Kecamatan->CurrentValue = HtmlDecode($this->Kecamatan->CurrentValue);
        }
        $this->Kecamatan->EditValue = $this->Kecamatan->CurrentValue;
        $this->Kecamatan->PlaceHolder = RemoveHtml($this->Kecamatan->caption());

        // Desa
        $this->Desa->setupEditAttributes();
        if (!$this->Desa->Raw) {
            $this->Desa->CurrentValue = HtmlDecode($this->Desa->CurrentValue);
        }
        $this->Desa->EditValue = $this->Desa->CurrentValue;
        $this->Desa->PlaceHolder = RemoveHtml($this->Desa->caption());

        // Koordinator
        $this->Koordinator->setupEditAttributes();
        if (!$this->Koordinator->Raw) {
            $this->Koordinator->CurrentValue = HtmlDecode($this->Koordinator->CurrentValue);
        }
        $this->Koordinator->EditValue = $this->Koordinator->CurrentValue;
        $this->Koordinator->PlaceHolder = RemoveHtml($this->Koordinator->caption());

        // Nama_Petani
        $this->Nama_Petani->setupEditAttributes();
        if (!$this->Nama_Petani->Raw) {
            $this->Nama_Petani->CurrentValue = HtmlDecode($this->Nama_Petani->CurrentValue);
        }
        $this->Nama_Petani->EditValue = $this->Nama_Petani->CurrentValue;
        $this->Nama_Petani->PlaceHolder = RemoveHtml($this->Nama_Petani->caption());

        // Tanggal
        $this->Tanggal->setupEditAttributes();
        $this->Tanggal->EditValue = FormatDateTime($this->Tanggal->CurrentValue, $this->Tanggal->formatPattern());
        $this->Tanggal->PlaceHolder = RemoveHtml($this->Tanggal->caption());

        // Luas
        $this->Luas->setupEditAttributes();
        $this->Luas->EditValue = $this->Luas->CurrentValue;
        $this->Luas->PlaceHolder = RemoveHtml($this->Luas->caption());
        if (strval($this->Luas->EditValue) != "" && is_numeric($this->Luas->EditValue)) {
            $this->Luas->EditValue = $this->Luas->EditValue;
        }

        // Estimasi_Tanggal_Panen
        $this->Estimasi_Tanggal_Panen->setupEditAttributes();
        $this->Estimasi_Tanggal_Panen->EditValue = FormatDateTime($this->Estimasi_Tanggal_Panen->CurrentValue, $this->Estimasi_Tanggal_Panen->formatPattern());
        $this->Estimasi_Tanggal_Panen->PlaceHolder = RemoveHtml($this->Estimasi_Tanggal_Panen->caption());

        // Estimasi_Panen
        $this->Estimasi_Panen->setupEditAttributes();
        $this->Estimasi_Panen->EditValue = $this->Estimasi_Panen->CurrentValue;
        $this->Estimasi_Panen->PlaceHolder = RemoveHtml($this->Estimasi_Panen->caption());
        if (strval($this->Estimasi_Panen->EditValue) != "" && is_numeric($this->Estimasi_Panen->EditValue)) {
            $this->Estimasi_Panen->EditValue = $this->Estimasi_Panen->EditValue;
        }

        // Tanggal_datang
        $this->Tanggal_datang->setupEditAttributes();
        $this->Tanggal_datang->EditValue = FormatDateTime($this->Tanggal_datang->CurrentValue, $this->Tanggal_datang->formatPattern());
        $this->Tanggal_datang->PlaceHolder = RemoveHtml($this->Tanggal_datang->caption());

        // Aktual_Panen
        $this->Aktual_Panen->setupEditAttributes();
        $this->Aktual_Panen->EditValue = $this->Aktual_Panen->CurrentValue;
        $this->Aktual_Panen->PlaceHolder = RemoveHtml($this->Aktual_Panen->caption());
        if (strval($this->Aktual_Panen->EditValue) != "" && is_numeric($this->Aktual_Panen->EditValue)) {
            $this->Aktual_Panen->EditValue = $this->Aktual_Panen->EditValue;
        }

        // Rata_rata_Skor
        $this->Rata_rata_Skor->setupEditAttributes();
        $this->Rata_rata_Skor->EditValue = $this->Rata_rata_Skor->CurrentValue;
        $this->Rata_rata_Skor->PlaceHolder = RemoveHtml($this->Rata_rata_Skor->caption());
        if (strval($this->Rata_rata_Skor->EditValue) != "" && is_numeric($this->Rata_rata_Skor->EditValue)) {
            $this->Rata_rata_Skor->EditValue = FormatNumber($this->Rata_rata_Skor->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ID_Kontrak);
                    $doc->exportCaption($this->Pic);
                    $doc->exportCaption($this->varietas);
                    $doc->exportCaption($this->Provinsi);
                    $doc->exportCaption($this->Kabupaten);
                    $doc->exportCaption($this->Kecamatan);
                    $doc->exportCaption($this->Desa);
                    $doc->exportCaption($this->Koordinator);
                    $doc->exportCaption($this->Nama_Petani);
                    $doc->exportCaption($this->Tanggal);
                    $doc->exportCaption($this->Luas);
                    $doc->exportCaption($this->Estimasi_Tanggal_Panen);
                    $doc->exportCaption($this->Estimasi_Panen);
                    $doc->exportCaption($this->Tanggal_datang);
                    $doc->exportCaption($this->Aktual_Panen);
                    $doc->exportCaption($this->Rata_rata_Skor);
                } else {
                    $doc->exportCaption($this->ID_Kontrak);
                    $doc->exportCaption($this->Pic);
                    $doc->exportCaption($this->varietas);
                    $doc->exportCaption($this->Provinsi);
                    $doc->exportCaption($this->Kabupaten);
                    $doc->exportCaption($this->Kecamatan);
                    $doc->exportCaption($this->Desa);
                    $doc->exportCaption($this->Koordinator);
                    $doc->exportCaption($this->Nama_Petani);
                    $doc->exportCaption($this->Tanggal);
                    $doc->exportCaption($this->Luas);
                    $doc->exportCaption($this->Estimasi_Tanggal_Panen);
                    $doc->exportCaption($this->Estimasi_Panen);
                    $doc->exportCaption($this->Tanggal_datang);
                    $doc->exportCaption($this->Aktual_Panen);
                    $doc->exportCaption($this->Rata_rata_Skor);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ID_Kontrak);
                        $doc->exportField($this->Pic);
                        $doc->exportField($this->varietas);
                        $doc->exportField($this->Provinsi);
                        $doc->exportField($this->Kabupaten);
                        $doc->exportField($this->Kecamatan);
                        $doc->exportField($this->Desa);
                        $doc->exportField($this->Koordinator);
                        $doc->exportField($this->Nama_Petani);
                        $doc->exportField($this->Tanggal);
                        $doc->exportField($this->Luas);
                        $doc->exportField($this->Estimasi_Tanggal_Panen);
                        $doc->exportField($this->Estimasi_Panen);
                        $doc->exportField($this->Tanggal_datang);
                        $doc->exportField($this->Aktual_Panen);
                        $doc->exportField($this->Rata_rata_Skor);
                    } else {
                        $doc->exportField($this->ID_Kontrak);
                        $doc->exportField($this->Pic);
                        $doc->exportField($this->varietas);
                        $doc->exportField($this->Provinsi);
                        $doc->exportField($this->Kabupaten);
                        $doc->exportField($this->Kecamatan);
                        $doc->exportField($this->Desa);
                        $doc->exportField($this->Koordinator);
                        $doc->exportField($this->Nama_Petani);
                        $doc->exportField($this->Tanggal);
                        $doc->exportField($this->Luas);
                        $doc->exportField($this->Estimasi_Tanggal_Panen);
                        $doc->exportField($this->Estimasi_Panen);
                        $doc->exportField($this->Tanggal_datang);
                        $doc->exportField($this->Aktual_Panen);
                        $doc->exportField($this->Rata_rata_Skor);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
