<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for bibit
 */
class Bibit extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $tgl_tanam;
    public $jumlah_tanam;
    public $jumlah_panen_stek;
    public $ket;
    public $var_nama;
    public $id_gen;
    public $k_id_kontrak;
    public $co_nama;
    public $koord_nama;
    public $pet_nama;
    public $prov_nama;
    public $kab_nama;
    public $kec_nama;
    public $desa_nama;
    public $id_asal_bibit;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "bibit";
        $this->TableName = 'bibit';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "bibit";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // tgl_tanam
        $this->tgl_tanam = new DbField(
            $this, // Table
            'x_tgl_tanam', // Variable name
            'tgl_tanam', // Name
            '`tgl_tanam`', // Expression
            CastDateFieldForLike("`tgl_tanam`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`tgl_tanam`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tgl_tanam->InputTextType = "text";
        $this->tgl_tanam->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->tgl_tanam->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tgl_tanam'] = &$this->tgl_tanam;

        // jumlah_tanam
        $this->jumlah_tanam = new DbField(
            $this, // Table
            'x_jumlah_tanam', // Variable name
            'jumlah_tanam', // Name
            '`jumlah_tanam`', // Expression
            '`jumlah_tanam`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jumlah_tanam`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jumlah_tanam->InputTextType = "text";
        $this->jumlah_tanam->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jumlah_tanam->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jumlah_tanam'] = &$this->jumlah_tanam;

        // jumlah_panen_stek
        $this->jumlah_panen_stek = new DbField(
            $this, // Table
            'x_jumlah_panen_stek', // Variable name
            'jumlah_panen_stek', // Name
            '`jumlah_panen_stek`', // Expression
            '`jumlah_panen_stek`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jumlah_panen_stek`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jumlah_panen_stek->InputTextType = "text";
        $this->jumlah_panen_stek->Nullable = false; // NOT NULL field
        $this->jumlah_panen_stek->Required = true; // Required field
        $this->jumlah_panen_stek->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jumlah_panen_stek->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['jumlah_panen_stek'] = &$this->jumlah_panen_stek;

        // ket
        $this->ket = new DbField(
            $this, // Table
            'x_ket', // Variable name
            'ket', // Name
            '`ket`', // Expression
            '`ket`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ket`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ket->InputTextType = "text";
        $this->ket->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ket'] = &$this->ket;

        // var_nama
        $this->var_nama = new DbField(
            $this, // Table
            'x_var_nama', // Variable name
            'var_nama', // Name
            '`var_nama`', // Expression
            '`var_nama`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`var_nama`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->var_nama->InputTextType = "text";
        $this->var_nama->setSelectMultiple(false); // Select one
        $this->var_nama->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->var_nama->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->var_nama->Lookup = new Lookup('var_nama', 'varietas', false, 'var_nama', ["var_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`var_nama`");
        $this->var_nama->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['var_nama'] = &$this->var_nama;

        // id_gen
        $this->id_gen = new DbField(
            $this, // Table
            'x_id_gen', // Variable name
            'id_gen', // Name
            '`id_gen`', // Expression
            '`id_gen`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id_gen`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->id_gen->InputTextType = "text";
        $this->id_gen->setSelectMultiple(false); // Select one
        $this->id_gen->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->id_gen->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->id_gen->Lookup = new Lookup('id_gen', 'generasi_bibit', false, 'id_gen', ["id_gen","","",""], '', '', [], [], [], [], [], [], '', '', "`id_gen`");
        $this->id_gen->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['id_gen'] = &$this->id_gen;

        // k_id_kontrak
        $this->k_id_kontrak = new DbField(
            $this, // Table
            'x_k_id_kontrak', // Variable name
            'k_id_kontrak', // Name
            '`k_id_kontrak`', // Expression
            '`k_id_kontrak`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_id_kontrak`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->k_id_kontrak->InputTextType = "text";
        $this->k_id_kontrak->setSelectMultiple(false); // Select one
        $this->k_id_kontrak->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->k_id_kontrak->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->k_id_kontrak->Lookup = new Lookup('k_id_kontrak', 'kontrak', false, 'k_id_kontrak', ["k_id_kontrak","","",""], '', '', [], [], [], [], [], [], '', '', "`k_id_kontrak`");
        $this->k_id_kontrak->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_id_kontrak'] = &$this->k_id_kontrak;

        // co_nama
        $this->co_nama = new DbField(
            $this, // Table
            'x_co_nama', // Variable name
            'co_nama', // Name
            '`co_nama`', // Expression
            '`co_nama`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`co_nama`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->co_nama->InputTextType = "text";
        $this->co_nama->setSelectMultiple(false); // Select one
        $this->co_nama->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->co_nama->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->co_nama->Lookup = new Lookup('co_nama', 'co', false, 'co_nama', ["co_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`co_nama`");
        $this->co_nama->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['co_nama'] = &$this->co_nama;

        // koord_nama
        $this->koord_nama = new DbField(
            $this, // Table
            'x_koord_nama', // Variable name
            'koord_nama', // Name
            '`koord_nama`', // Expression
            '`koord_nama`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`koord_nama`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->koord_nama->InputTextType = "text";
        $this->koord_nama->Lookup = new Lookup('koord_nama', 'koord', false, 'koord_nama', ["koord_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`koord_nama`");
        $this->koord_nama->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['koord_nama'] = &$this->koord_nama;

        // pet_nama
        $this->pet_nama = new DbField(
            $this, // Table
            'x_pet_nama', // Variable name
            'pet_nama', // Name
            '`pet_nama`', // Expression
            '`pet_nama`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pet_nama`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pet_nama->InputTextType = "text";
        $this->pet_nama->Lookup = new Lookup('pet_nama', 'petani', false, 'pet_nama', ["pet_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`pet_nama`");
        $this->pet_nama->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pet_nama'] = &$this->pet_nama;

        // prov_nama
        $this->prov_nama = new DbField(
            $this, // Table
            'x_prov_nama', // Variable name
            'prov_nama', // Name
            '`prov_nama`', // Expression
            '`prov_nama`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`prov_nama`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->prov_nama->InputTextType = "text";
        $this->prov_nama->Lookup = new Lookup('prov_nama', 'prov', false, 'prov_nama', ["prov_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`prov_nama`");
        $this->prov_nama->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['prov_nama'] = &$this->prov_nama;

        // kab_nama
        $this->kab_nama = new DbField(
            $this, // Table
            'x_kab_nama', // Variable name
            'kab_nama', // Name
            '`kab_nama`', // Expression
            '`kab_nama`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`kab_nama`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->kab_nama->InputTextType = "text";
        $this->kab_nama->Lookup = new Lookup('kab_nama', 'kab', false, 'kab_nama', ["kab_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`kab_nama`");
        $this->kab_nama->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['kab_nama'] = &$this->kab_nama;

        // kec_nama
        $this->kec_nama = new DbField(
            $this, // Table
            'x_kec_nama', // Variable name
            'kec_nama', // Name
            '`kec_nama`', // Expression
            '`kec_nama`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`kec_nama`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->kec_nama->InputTextType = "text";
        $this->kec_nama->Lookup = new Lookup('kec_nama', 'kec', false, 'kec_nama', ["kec_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`kec_nama`");
        $this->kec_nama->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['kec_nama'] = &$this->kec_nama;

        // desa_nama
        $this->desa_nama = new DbField(
            $this, // Table
            'x_desa_nama', // Variable name
            'desa_nama', // Name
            '`desa_nama`', // Expression
            '`desa_nama`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`desa_nama`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->desa_nama->InputTextType = "text";
        $this->desa_nama->Lookup = new Lookup('desa_nama', 'desa', false, 'desa_nama', ["desa_nama","","",""], '', '', [], [], [], [], [], [], '', '', "`desa_nama`");
        $this->desa_nama->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['desa_nama'] = &$this->desa_nama;

        // id_asal_bibit
        $this->id_asal_bibit = new DbField(
            $this, // Table
            'x_id_asal_bibit', // Variable name
            'id_asal_bibit', // Name
            '`id_asal_bibit`', // Expression
            '`id_asal_bibit`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id_asal_bibit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id_asal_bibit->InputTextType = "text";
        $this->id_asal_bibit->Nullable = false; // NOT NULL field
        $this->id_asal_bibit->Required = true; // Required field
        $this->id_asal_bibit->Lookup = new Lookup('id_asal_bibit', 'tanam_bibit', false, 'id', ["tgl_tanam","gen_bibit","",""], '', '', [], [], [], [], [], [], '', '', "CONCAT(COALESCE(" . CastDateFieldForLike("`tgl_tanam`", 0, "DB") . ", ''),'" . ValueSeparator(1, $this->id_asal_bibit) . "',COALESCE(`gen_bibit`,''))");
        $this->id_asal_bibit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id_asal_bibit->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id_asal_bibit'] = &$this->id_asal_bibit;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "bibit";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
            // Get insert id if necessary
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->tgl_tanam->DbValue = $row['tgl_tanam'];
        $this->jumlah_tanam->DbValue = $row['jumlah_tanam'];
        $this->jumlah_panen_stek->DbValue = $row['jumlah_panen_stek'];
        $this->ket->DbValue = $row['ket'];
        $this->var_nama->DbValue = $row['var_nama'];
        $this->id_gen->DbValue = $row['id_gen'];
        $this->k_id_kontrak->DbValue = $row['k_id_kontrak'];
        $this->co_nama->DbValue = $row['co_nama'];
        $this->koord_nama->DbValue = $row['koord_nama'];
        $this->pet_nama->DbValue = $row['pet_nama'];
        $this->prov_nama->DbValue = $row['prov_nama'];
        $this->kab_nama->DbValue = $row['kab_nama'];
        $this->kec_nama->DbValue = $row['kec_nama'];
        $this->desa_nama->DbValue = $row['desa_nama'];
        $this->id_asal_bibit->DbValue = $row['id_asal_bibit'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("BibitList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "BibitView") {
            return $Language->phrase("View");
        } elseif ($pageName == "BibitEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "BibitAdd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "BibitView";
            case Config("API_ADD_ACTION"):
                return "BibitAdd";
            case Config("API_EDIT_ACTION"):
                return "BibitEdit";
            case Config("API_DELETE_ACTION"):
                return "BibitDelete";
            case Config("API_LIST_ACTION"):
                return "BibitList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "BibitList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("BibitView", $parm);
        } else {
            $url = $this->keyUrl("BibitView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "BibitAdd?" . $parm;
        } else {
            $url = "BibitAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("BibitEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("BibitList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("BibitAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("BibitList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("BibitDelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . JsonEncode($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->tgl_tanam->setDbValue($row['tgl_tanam']);
        $this->jumlah_tanam->setDbValue($row['jumlah_tanam']);
        $this->jumlah_panen_stek->setDbValue($row['jumlah_panen_stek']);
        $this->ket->setDbValue($row['ket']);
        $this->var_nama->setDbValue($row['var_nama']);
        $this->id_gen->setDbValue($row['id_gen']);
        $this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
        $this->co_nama->setDbValue($row['co_nama']);
        $this->koord_nama->setDbValue($row['koord_nama']);
        $this->pet_nama->setDbValue($row['pet_nama']);
        $this->prov_nama->setDbValue($row['prov_nama']);
        $this->kab_nama->setDbValue($row['kab_nama']);
        $this->kec_nama->setDbValue($row['kec_nama']);
        $this->desa_nama->setDbValue($row['desa_nama']);
        $this->id_asal_bibit->setDbValue($row['id_asal_bibit']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "BibitList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // tgl_tanam

        // jumlah_tanam

        // jumlah_panen_stek

        // ket

        // var_nama

        // id_gen

        // k_id_kontrak

        // co_nama

        // koord_nama

        // pet_nama

        // prov_nama

        // kab_nama

        // kec_nama

        // desa_nama

        // id_asal_bibit

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // tgl_tanam
        $this->tgl_tanam->ViewValue = $this->tgl_tanam->CurrentValue;
        $this->tgl_tanam->ViewValue = FormatDateTime($this->tgl_tanam->ViewValue, $this->tgl_tanam->formatPattern());

        // jumlah_tanam
        $this->jumlah_tanam->ViewValue = $this->jumlah_tanam->CurrentValue;

        // jumlah_panen_stek
        $this->jumlah_panen_stek->ViewValue = $this->jumlah_panen_stek->CurrentValue;

        // ket
        $this->ket->ViewValue = $this->ket->CurrentValue;

        // var_nama
        $curVal = strval($this->var_nama->CurrentValue);
        if ($curVal != "") {
            $this->var_nama->ViewValue = $this->var_nama->lookupCacheOption($curVal);
            if ($this->var_nama->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`var_nama`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->var_nama->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->var_nama->Lookup->renderViewRow($rswrk[0]);
                    $this->var_nama->ViewValue = $this->var_nama->displayValue($arwrk);
                } else {
                    $this->var_nama->ViewValue = $this->var_nama->CurrentValue;
                }
            }
        } else {
            $this->var_nama->ViewValue = null;
        }

        // id_gen
        $curVal = strval($this->id_gen->CurrentValue);
        if ($curVal != "") {
            $this->id_gen->ViewValue = $this->id_gen->lookupCacheOption($curVal);
            if ($this->id_gen->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`id_gen`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->id_gen->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->id_gen->Lookup->renderViewRow($rswrk[0]);
                    $this->id_gen->ViewValue = $this->id_gen->displayValue($arwrk);
                } else {
                    $this->id_gen->ViewValue = $this->id_gen->CurrentValue;
                }
            }
        } else {
            $this->id_gen->ViewValue = null;
        }

        // k_id_kontrak
        $curVal = strval($this->k_id_kontrak->CurrentValue);
        if ($curVal != "") {
            $this->k_id_kontrak->ViewValue = $this->k_id_kontrak->lookupCacheOption($curVal);
            if ($this->k_id_kontrak->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`k_id_kontrak`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->k_id_kontrak->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->k_id_kontrak->Lookup->renderViewRow($rswrk[0]);
                    $this->k_id_kontrak->ViewValue = $this->k_id_kontrak->displayValue($arwrk);
                } else {
                    $this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
                }
            }
        } else {
            $this->k_id_kontrak->ViewValue = null;
        }

        // co_nama
        $curVal = strval($this->co_nama->CurrentValue);
        if ($curVal != "") {
            $this->co_nama->ViewValue = $this->co_nama->lookupCacheOption($curVal);
            if ($this->co_nama->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`co_nama`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->co_nama->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->co_nama->Lookup->renderViewRow($rswrk[0]);
                    $this->co_nama->ViewValue = $this->co_nama->displayValue($arwrk);
                } else {
                    $this->co_nama->ViewValue = $this->co_nama->CurrentValue;
                }
            }
        } else {
            $this->co_nama->ViewValue = null;
        }

        // koord_nama
        $this->koord_nama->ViewValue = $this->koord_nama->CurrentValue;
        $curVal = strval($this->koord_nama->CurrentValue);
        if ($curVal != "") {
            $this->koord_nama->ViewValue = $this->koord_nama->lookupCacheOption($curVal);
            if ($this->koord_nama->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`koord_nama`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->koord_nama->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->koord_nama->Lookup->renderViewRow($rswrk[0]);
                    $this->koord_nama->ViewValue = $this->koord_nama->displayValue($arwrk);
                } else {
                    $this->koord_nama->ViewValue = $this->koord_nama->CurrentValue;
                }
            }
        } else {
            $this->koord_nama->ViewValue = null;
        }

        // pet_nama
        $this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
        $curVal = strval($this->pet_nama->CurrentValue);
        if ($curVal != "") {
            $this->pet_nama->ViewValue = $this->pet_nama->lookupCacheOption($curVal);
            if ($this->pet_nama->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`pet_nama`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->pet_nama->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pet_nama->Lookup->renderViewRow($rswrk[0]);
                    $this->pet_nama->ViewValue = $this->pet_nama->displayValue($arwrk);
                } else {
                    $this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
                }
            }
        } else {
            $this->pet_nama->ViewValue = null;
        }

        // prov_nama
        $this->prov_nama->ViewValue = $this->prov_nama->CurrentValue;
        $curVal = strval($this->prov_nama->CurrentValue);
        if ($curVal != "") {
            $this->prov_nama->ViewValue = $this->prov_nama->lookupCacheOption($curVal);
            if ($this->prov_nama->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`prov_nama`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->prov_nama->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->prov_nama->Lookup->renderViewRow($rswrk[0]);
                    $this->prov_nama->ViewValue = $this->prov_nama->displayValue($arwrk);
                } else {
                    $this->prov_nama->ViewValue = $this->prov_nama->CurrentValue;
                }
            }
        } else {
            $this->prov_nama->ViewValue = null;
        }

        // kab_nama
        $this->kab_nama->ViewValue = $this->kab_nama->CurrentValue;
        $curVal = strval($this->kab_nama->CurrentValue);
        if ($curVal != "") {
            $this->kab_nama->ViewValue = $this->kab_nama->lookupCacheOption($curVal);
            if ($this->kab_nama->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`kab_nama`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->kab_nama->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->kab_nama->Lookup->renderViewRow($rswrk[0]);
                    $this->kab_nama->ViewValue = $this->kab_nama->displayValue($arwrk);
                } else {
                    $this->kab_nama->ViewValue = $this->kab_nama->CurrentValue;
                }
            }
        } else {
            $this->kab_nama->ViewValue = null;
        }

        // kec_nama
        $this->kec_nama->ViewValue = $this->kec_nama->CurrentValue;
        $curVal = strval($this->kec_nama->CurrentValue);
        if ($curVal != "") {
            $this->kec_nama->ViewValue = $this->kec_nama->lookupCacheOption($curVal);
            if ($this->kec_nama->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`kec_nama`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->kec_nama->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->kec_nama->Lookup->renderViewRow($rswrk[0]);
                    $this->kec_nama->ViewValue = $this->kec_nama->displayValue($arwrk);
                } else {
                    $this->kec_nama->ViewValue = $this->kec_nama->CurrentValue;
                }
            }
        } else {
            $this->kec_nama->ViewValue = null;
        }

        // desa_nama
        $this->desa_nama->ViewValue = $this->desa_nama->CurrentValue;
        $curVal = strval($this->desa_nama->CurrentValue);
        if ($curVal != "") {
            $this->desa_nama->ViewValue = $this->desa_nama->lookupCacheOption($curVal);
            if ($this->desa_nama->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`desa_nama`", "=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->desa_nama->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->desa_nama->Lookup->renderViewRow($rswrk[0]);
                    $this->desa_nama->ViewValue = $this->desa_nama->displayValue($arwrk);
                } else {
                    $this->desa_nama->ViewValue = $this->desa_nama->CurrentValue;
                }
            }
        } else {
            $this->desa_nama->ViewValue = null;
        }

        // id_asal_bibit
        $this->id_asal_bibit->ViewValue = $this->id_asal_bibit->CurrentValue;
        $curVal = strval($this->id_asal_bibit->CurrentValue);
        if ($curVal != "") {
            $this->id_asal_bibit->ViewValue = $this->id_asal_bibit->lookupCacheOption($curVal);
            if ($this->id_asal_bibit->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->id_asal_bibit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->id_asal_bibit->Lookup->renderViewRow($rswrk[0]);
                    $this->id_asal_bibit->ViewValue = $this->id_asal_bibit->displayValue($arwrk);
                } else {
                    $this->id_asal_bibit->ViewValue = $this->id_asal_bibit->CurrentValue;
                }
            }
        } else {
            $this->id_asal_bibit->ViewValue = null;
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // tgl_tanam
        $this->tgl_tanam->HrefValue = "";
        $this->tgl_tanam->TooltipValue = "";

        // jumlah_tanam
        $this->jumlah_tanam->HrefValue = "";
        $this->jumlah_tanam->TooltipValue = "";

        // jumlah_panen_stek
        $this->jumlah_panen_stek->HrefValue = "";
        $this->jumlah_panen_stek->TooltipValue = "";

        // ket
        $this->ket->HrefValue = "";
        $this->ket->TooltipValue = "";

        // var_nama
        $this->var_nama->HrefValue = "";
        $this->var_nama->TooltipValue = "";

        // id_gen
        $this->id_gen->HrefValue = "";
        $this->id_gen->TooltipValue = "";

        // k_id_kontrak
        $this->k_id_kontrak->HrefValue = "";
        $this->k_id_kontrak->TooltipValue = "";

        // co_nama
        $this->co_nama->HrefValue = "";
        $this->co_nama->TooltipValue = "";

        // koord_nama
        $this->koord_nama->HrefValue = "";
        $this->koord_nama->TooltipValue = "";

        // pet_nama
        $this->pet_nama->HrefValue = "";
        $this->pet_nama->TooltipValue = "";

        // prov_nama
        $this->prov_nama->HrefValue = "";
        $this->prov_nama->TooltipValue = "";

        // kab_nama
        $this->kab_nama->HrefValue = "";
        $this->kab_nama->TooltipValue = "";

        // kec_nama
        $this->kec_nama->HrefValue = "";
        $this->kec_nama->TooltipValue = "";

        // desa_nama
        $this->desa_nama->HrefValue = "";
        $this->desa_nama->TooltipValue = "";

        // id_asal_bibit
        $this->id_asal_bibit->HrefValue = "";
        $this->id_asal_bibit->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // tgl_tanam
        $this->tgl_tanam->setupEditAttributes();
        $this->tgl_tanam->EditValue = FormatDateTime($this->tgl_tanam->CurrentValue, $this->tgl_tanam->formatPattern());
        $this->tgl_tanam->PlaceHolder = RemoveHtml($this->tgl_tanam->caption());

        // jumlah_tanam
        $this->jumlah_tanam->setupEditAttributes();
        $this->jumlah_tanam->EditValue = $this->jumlah_tanam->CurrentValue;
        $this->jumlah_tanam->PlaceHolder = RemoveHtml($this->jumlah_tanam->caption());
        if (strval($this->jumlah_tanam->EditValue) != "" && is_numeric($this->jumlah_tanam->EditValue)) {
            $this->jumlah_tanam->EditValue = $this->jumlah_tanam->EditValue;
        }

        // jumlah_panen_stek
        $this->jumlah_panen_stek->setupEditAttributes();
        $this->jumlah_panen_stek->EditValue = $this->jumlah_panen_stek->CurrentValue;
        $this->jumlah_panen_stek->PlaceHolder = RemoveHtml($this->jumlah_panen_stek->caption());
        if (strval($this->jumlah_panen_stek->EditValue) != "" && is_numeric($this->jumlah_panen_stek->EditValue)) {
            $this->jumlah_panen_stek->EditValue = $this->jumlah_panen_stek->EditValue;
        }

        // ket
        $this->ket->setupEditAttributes();
        if (!$this->ket->Raw) {
            $this->ket->CurrentValue = HtmlDecode($this->ket->CurrentValue);
        }
        $this->ket->EditValue = $this->ket->CurrentValue;
        $this->ket->PlaceHolder = RemoveHtml($this->ket->caption());

        // var_nama
        $this->var_nama->setupEditAttributes();
        $this->var_nama->PlaceHolder = RemoveHtml($this->var_nama->caption());

        // id_gen
        $this->id_gen->setupEditAttributes();
        $this->id_gen->PlaceHolder = RemoveHtml($this->id_gen->caption());

        // k_id_kontrak
        $this->k_id_kontrak->setupEditAttributes();
        $this->k_id_kontrak->PlaceHolder = RemoveHtml($this->k_id_kontrak->caption());

        // co_nama
        $this->co_nama->setupEditAttributes();
        $this->co_nama->PlaceHolder = RemoveHtml($this->co_nama->caption());

        // koord_nama
        $this->koord_nama->setupEditAttributes();
        if (!$this->koord_nama->Raw) {
            $this->koord_nama->CurrentValue = HtmlDecode($this->koord_nama->CurrentValue);
        }
        $this->koord_nama->EditValue = $this->koord_nama->CurrentValue;
        $this->koord_nama->PlaceHolder = RemoveHtml($this->koord_nama->caption());

        // pet_nama
        $this->pet_nama->setupEditAttributes();
        if (!$this->pet_nama->Raw) {
            $this->pet_nama->CurrentValue = HtmlDecode($this->pet_nama->CurrentValue);
        }
        $this->pet_nama->EditValue = $this->pet_nama->CurrentValue;
        $this->pet_nama->PlaceHolder = RemoveHtml($this->pet_nama->caption());

        // prov_nama
        $this->prov_nama->setupEditAttributes();
        if (!$this->prov_nama->Raw) {
            $this->prov_nama->CurrentValue = HtmlDecode($this->prov_nama->CurrentValue);
        }
        $this->prov_nama->EditValue = $this->prov_nama->CurrentValue;
        $this->prov_nama->PlaceHolder = RemoveHtml($this->prov_nama->caption());

        // kab_nama
        $this->kab_nama->setupEditAttributes();
        if (!$this->kab_nama->Raw) {
            $this->kab_nama->CurrentValue = HtmlDecode($this->kab_nama->CurrentValue);
        }
        $this->kab_nama->EditValue = $this->kab_nama->CurrentValue;
        $this->kab_nama->PlaceHolder = RemoveHtml($this->kab_nama->caption());

        // kec_nama
        $this->kec_nama->setupEditAttributes();
        if (!$this->kec_nama->Raw) {
            $this->kec_nama->CurrentValue = HtmlDecode($this->kec_nama->CurrentValue);
        }
        $this->kec_nama->EditValue = $this->kec_nama->CurrentValue;
        $this->kec_nama->PlaceHolder = RemoveHtml($this->kec_nama->caption());

        // desa_nama
        $this->desa_nama->setupEditAttributes();
        if (!$this->desa_nama->Raw) {
            $this->desa_nama->CurrentValue = HtmlDecode($this->desa_nama->CurrentValue);
        }
        $this->desa_nama->EditValue = $this->desa_nama->CurrentValue;
        $this->desa_nama->PlaceHolder = RemoveHtml($this->desa_nama->caption());

        // id_asal_bibit
        $this->id_asal_bibit->setupEditAttributes();
        $this->id_asal_bibit->EditValue = $this->id_asal_bibit->CurrentValue;
        $this->id_asal_bibit->PlaceHolder = RemoveHtml($this->id_asal_bibit->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->tgl_tanam);
                    $doc->exportCaption($this->jumlah_tanam);
                    $doc->exportCaption($this->jumlah_panen_stek);
                    $doc->exportCaption($this->ket);
                    $doc->exportCaption($this->var_nama);
                    $doc->exportCaption($this->id_gen);
                    $doc->exportCaption($this->k_id_kontrak);
                    $doc->exportCaption($this->co_nama);
                    $doc->exportCaption($this->koord_nama);
                    $doc->exportCaption($this->pet_nama);
                    $doc->exportCaption($this->prov_nama);
                    $doc->exportCaption($this->kab_nama);
                    $doc->exportCaption($this->kec_nama);
                    $doc->exportCaption($this->desa_nama);
                    $doc->exportCaption($this->id_asal_bibit);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->tgl_tanam);
                    $doc->exportCaption($this->jumlah_tanam);
                    $doc->exportCaption($this->jumlah_panen_stek);
                    $doc->exportCaption($this->ket);
                    $doc->exportCaption($this->var_nama);
                    $doc->exportCaption($this->id_gen);
                    $doc->exportCaption($this->k_id_kontrak);
                    $doc->exportCaption($this->co_nama);
                    $doc->exportCaption($this->koord_nama);
                    $doc->exportCaption($this->pet_nama);
                    $doc->exportCaption($this->prov_nama);
                    $doc->exportCaption($this->kab_nama);
                    $doc->exportCaption($this->kec_nama);
                    $doc->exportCaption($this->desa_nama);
                    $doc->exportCaption($this->id_asal_bibit);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->tgl_tanam);
                        $doc->exportField($this->jumlah_tanam);
                        $doc->exportField($this->jumlah_panen_stek);
                        $doc->exportField($this->ket);
                        $doc->exportField($this->var_nama);
                        $doc->exportField($this->id_gen);
                        $doc->exportField($this->k_id_kontrak);
                        $doc->exportField($this->co_nama);
                        $doc->exportField($this->koord_nama);
                        $doc->exportField($this->pet_nama);
                        $doc->exportField($this->prov_nama);
                        $doc->exportField($this->kab_nama);
                        $doc->exportField($this->kec_nama);
                        $doc->exportField($this->desa_nama);
                        $doc->exportField($this->id_asal_bibit);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->tgl_tanam);
                        $doc->exportField($this->jumlah_tanam);
                        $doc->exportField($this->jumlah_panen_stek);
                        $doc->exportField($this->ket);
                        $doc->exportField($this->var_nama);
                        $doc->exportField($this->id_gen);
                        $doc->exportField($this->k_id_kontrak);
                        $doc->exportField($this->co_nama);
                        $doc->exportField($this->koord_nama);
                        $doc->exportField($this->pet_nama);
                        $doc->exportField($this->prov_nama);
                        $doc->exportField($this->kab_nama);
                        $doc->exportField($this->kec_nama);
                        $doc->exportField($this->desa_nama);
                        $doc->exportField($this->id_asal_bibit);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
