<?php

namespace PHPMaker2023\co;

// Page object
$View5List = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { view5: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fview5srch" id="fview5srch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="on">
<div id="fview5srch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { view5: currentTable } });
var currentForm;
var fview5srch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fview5srch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["k_id_kontrak", [], fields.k_id_kontrak.isInvalid],
            ["k_tgl_tanam", [ew.Validators.datetime(fields.k_tgl_tanam.clientFormatPattern)], fields.k_tgl_tanam.isInvalid],
            ["y_k_tgl_tanam", [ew.Validators.between], false],
            ["k_luas_lahan", [], fields.k_luas_lahan.isInvalid],
            ["Jenis_Pestisida", [], fields.Jenis_Pestisida.isInvalid],
            ["Merek_Pestisida", [], fields.Merek_Pestisida.isInvalid],
            ["Bahan_Aktif", [], fields.Bahan_Aktif.isInvalid],
            ["Dosis_Pemakaian", [], fields.Dosis_Pemakaian.isInvalid],
            ["Waktu_Aplikasi", [], fields.Waktu_Aplikasi.isInvalid],
            ["co_nama", [], fields.co_nama.isInvalid],
            ["koord_nama", [], fields.koord_nama.isInvalid],
            ["pet_nama", [], fields.pet_nama.isInvalid],
            ["var_nama", [], fields.var_nama.isInvalid],
            ["blok_nama", [], fields.blok_nama.isInvalid],
            ["desa_nama", [], fields.desa_nama.isInvalid],
            ["kec_nama", [], fields.kec_nama.isInvalid],
            ["kab_nama", [], fields.kab_nama.isInvalid],
            ["prov_nama", [], fields.prov_nama.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->k_id_kontrak->Visible) { // k_id_kontrak ?>
<?php
if (!$Page->k_id_kontrak->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_k_id_kontrak" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->k_id_kontrak->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_k_id_kontrak" class="ew-search-caption ew-label"><?= $Page->k_id_kontrak->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_k_id_kontrak" id="z_k_id_kontrak" value="LIKE">
</div>
        </div>
        <div id="el_view5_k_id_kontrak" class="ew-search-field">
<input type="<?= $Page->k_id_kontrak->getInputTextType() ?>" name="x_k_id_kontrak" id="x_k_id_kontrak" data-table="view5" data-field="x_k_id_kontrak" value="<?= $Page->k_id_kontrak->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->k_id_kontrak->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_id_kontrak->formatPattern()) ?>"<?= $Page->k_id_kontrak->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_id_kontrak->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
<?php
if (!$Page->k_tgl_tanam->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_k_tgl_tanam" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->k_tgl_tanam->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_k_tgl_tanam" class="ew-search-caption ew-label"><?= $Page->k_tgl_tanam->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_k_tgl_tanam" id="z_k_tgl_tanam" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->k_tgl_tanam->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->k_tgl_tanam->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_view5_k_tgl_tanam" class="ew-search-field">
<input type="<?= $Page->k_tgl_tanam->getInputTextType() ?>" name="x_k_tgl_tanam" id="x_k_tgl_tanam" data-table="view5" data-field="x_k_tgl_tanam" value="<?= $Page->k_tgl_tanam->EditValue ?>" placeholder="<?= HtmlEncode($Page->k_tgl_tanam->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_tgl_tanam->formatPattern()) ?>"<?= $Page->k_tgl_tanam->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_tgl_tanam->getErrorMessage(false) ?></div>
<?php if (!$Page->k_tgl_tanam->ReadOnly && !$Page->k_tgl_tanam->Disabled && !isset($Page->k_tgl_tanam->EditAttrs["readonly"]) && !isset($Page->k_tgl_tanam->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fview5srch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fview5srch", "x_k_tgl_tanam", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_view5_k_tgl_tanam" class="ew-search-field2 d-none">
<input type="<?= $Page->k_tgl_tanam->getInputTextType() ?>" name="y_k_tgl_tanam" id="y_k_tgl_tanam" data-table="view5" data-field="x_k_tgl_tanam" value="<?= $Page->k_tgl_tanam->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->k_tgl_tanam->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->k_tgl_tanam->formatPattern()) ?>"<?= $Page->k_tgl_tanam->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->k_tgl_tanam->getErrorMessage(false) ?></div>
<?php if (!$Page->k_tgl_tanam->ReadOnly && !$Page->k_tgl_tanam->Disabled && !isset($Page->k_tgl_tanam->EditAttrs["readonly"]) && !isset($Page->k_tgl_tanam->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fview5srch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fview5srch", "y_k_tgl_tanam", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Jenis_Pestisida->Visible) { // Jenis_Pestisida ?>
<?php
if (!$Page->Jenis_Pestisida->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Jenis_Pestisida" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Jenis_Pestisida->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Jenis_Pestisida" class="ew-search-caption ew-label"><?= $Page->Jenis_Pestisida->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Jenis_Pestisida" id="z_Jenis_Pestisida" value="LIKE">
</div>
        </div>
        <div id="el_view5_Jenis_Pestisida" class="ew-search-field">
<input type="<?= $Page->Jenis_Pestisida->getInputTextType() ?>" name="x_Jenis_Pestisida" id="x_Jenis_Pestisida" data-table="view5" data-field="x_Jenis_Pestisida" value="<?= $Page->Jenis_Pestisida->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Jenis_Pestisida->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Jenis_Pestisida->formatPattern()) ?>"<?= $Page->Jenis_Pestisida->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Jenis_Pestisida->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Bahan_Aktif->Visible) { // Bahan_Aktif ?>
<?php
if (!$Page->Bahan_Aktif->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Bahan_Aktif" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Bahan_Aktif->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Bahan_Aktif" class="ew-search-caption ew-label"><?= $Page->Bahan_Aktif->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Bahan_Aktif" id="z_Bahan_Aktif" value="LIKE">
</div>
        </div>
        <div id="el_view5_Bahan_Aktif" class="ew-search-field">
<input type="<?= $Page->Bahan_Aktif->getInputTextType() ?>" name="x_Bahan_Aktif" id="x_Bahan_Aktif" data-table="view5" data-field="x_Bahan_Aktif" value="<?= $Page->Bahan_Aktif->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Bahan_Aktif->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Bahan_Aktif->formatPattern()) ?>"<?= $Page->Bahan_Aktif->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Bahan_Aktif->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->co_nama->Visible) { // co_nama ?>
<?php
if (!$Page->co_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_co_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->co_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_co_nama" class="ew-search-caption ew-label"><?= $Page->co_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_co_nama" id="z_co_nama" value="LIKE">
</div>
        </div>
        <div id="el_view5_co_nama" class="ew-search-field">
<input type="<?= $Page->co_nama->getInputTextType() ?>" name="x_co_nama" id="x_co_nama" data-table="view5" data-field="x_co_nama" value="<?= $Page->co_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->co_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->co_nama->formatPattern()) ?>"<?= $Page->co_nama->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->co_nama->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->koord_nama->Visible) { // koord_nama ?>
<?php
if (!$Page->koord_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_koord_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->koord_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_koord_nama" class="ew-search-caption ew-label"><?= $Page->koord_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_koord_nama" id="z_koord_nama" value="LIKE">
</div>
        </div>
        <div id="el_view5_koord_nama" class="ew-search-field">
<input type="<?= $Page->koord_nama->getInputTextType() ?>" name="x_koord_nama" id="x_koord_nama" data-table="view5" data-field="x_koord_nama" value="<?= $Page->koord_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->koord_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->koord_nama->formatPattern()) ?>"<?= $Page->koord_nama->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->koord_nama->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pet_nama->Visible) { // pet_nama ?>
<?php
if (!$Page->pet_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pet_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pet_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pet_nama" class="ew-search-caption ew-label"><?= $Page->pet_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pet_nama" id="z_pet_nama" value="LIKE">
</div>
        </div>
        <div id="el_view5_pet_nama" class="ew-search-field">
<input type="<?= $Page->pet_nama->getInputTextType() ?>" name="x_pet_nama" id="x_pet_nama" data-table="view5" data-field="x_pet_nama" value="<?= $Page->pet_nama->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->pet_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pet_nama->formatPattern()) ?>"<?= $Page->pet_nama->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pet_nama->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->var_nama->Visible) { // var_nama ?>
<?php
if (!$Page->var_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_var_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->var_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_var_nama" class="ew-search-caption ew-label"><?= $Page->var_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_var_nama" id="z_var_nama" value="LIKE">
</div>
        </div>
        <div id="el_view5_var_nama" class="ew-search-field">
<input type="<?= $Page->var_nama->getInputTextType() ?>" name="x_var_nama" id="x_var_nama" data-table="view5" data-field="x_var_nama" value="<?= $Page->var_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->var_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->var_nama->formatPattern()) ?>"<?= $Page->var_nama->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->var_nama->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->desa_nama->Visible) { // desa_nama ?>
<?php
if (!$Page->desa_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_desa_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->desa_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_desa_nama" class="ew-search-caption ew-label"><?= $Page->desa_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_desa_nama" id="z_desa_nama" value="LIKE">
</div>
        </div>
        <div id="el_view5_desa_nama" class="ew-search-field">
<input type="<?= $Page->desa_nama->getInputTextType() ?>" name="x_desa_nama" id="x_desa_nama" data-table="view5" data-field="x_desa_nama" value="<?= $Page->desa_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->desa_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->desa_nama->formatPattern()) ?>"<?= $Page->desa_nama->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->desa_nama->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->kec_nama->Visible) { // kec_nama ?>
<?php
if (!$Page->kec_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_kec_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->kec_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_kec_nama" class="ew-search-caption ew-label"><?= $Page->kec_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_kec_nama" id="z_kec_nama" value="LIKE">
</div>
        </div>
        <div id="el_view5_kec_nama" class="ew-search-field">
<input type="<?= $Page->kec_nama->getInputTextType() ?>" name="x_kec_nama" id="x_kec_nama" data-table="view5" data-field="x_kec_nama" value="<?= $Page->kec_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->kec_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->kec_nama->formatPattern()) ?>"<?= $Page->kec_nama->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->kec_nama->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->kab_nama->Visible) { // kab_nama ?>
<?php
if (!$Page->kab_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_kab_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->kab_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_kab_nama" class="ew-search-caption ew-label"><?= $Page->kab_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_kab_nama" id="z_kab_nama" value="LIKE">
</div>
        </div>
        <div id="el_view5_kab_nama" class="ew-search-field">
<input type="<?= $Page->kab_nama->getInputTextType() ?>" name="x_kab_nama" id="x_kab_nama" data-table="view5" data-field="x_kab_nama" value="<?= $Page->kab_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->kab_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->kab_nama->formatPattern()) ?>"<?= $Page->kab_nama->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->kab_nama->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->prov_nama->Visible) { // prov_nama ?>
<?php
if (!$Page->prov_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_prov_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->prov_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_prov_nama" class="ew-search-caption ew-label"><?= $Page->prov_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_prov_nama" id="z_prov_nama" value="LIKE">
</div>
        </div>
        <div id="el_view5_prov_nama" class="ew-search-field">
<input type="<?= $Page->prov_nama->getInputTextType() ?>" name="x_prov_nama" id="x_prov_nama" data-table="view5" data-field="x_prov_nama" value="<?= $Page->prov_nama->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->prov_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->prov_nama->formatPattern()) ?>"<?= $Page->prov_nama->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->prov_nama->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fview5srch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fview5srch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fview5srch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fview5srch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="on">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="view5">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_view5" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_view5list" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = ROWTYPE_HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->k_id_kontrak->Visible) { // k_id_kontrak ?>
        <th data-name="k_id_kontrak" class="<?= $Page->k_id_kontrak->headerCellClass() ?>"><div id="elh_view5_k_id_kontrak" class="view5_k_id_kontrak"><?= $Page->renderFieldHeader($Page->k_id_kontrak) ?></div></th>
<?php } ?>
<?php if ($Page->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
        <th data-name="k_tgl_tanam" class="<?= $Page->k_tgl_tanam->headerCellClass() ?>"><div id="elh_view5_k_tgl_tanam" class="view5_k_tgl_tanam"><?= $Page->renderFieldHeader($Page->k_tgl_tanam) ?></div></th>
<?php } ?>
<?php if ($Page->k_luas_lahan->Visible) { // k_luas_lahan ?>
        <th data-name="k_luas_lahan" class="<?= $Page->k_luas_lahan->headerCellClass() ?>"><div id="elh_view5_k_luas_lahan" class="view5_k_luas_lahan"><?= $Page->renderFieldHeader($Page->k_luas_lahan) ?></div></th>
<?php } ?>
<?php if ($Page->Jenis_Pestisida->Visible) { // Jenis_Pestisida ?>
        <th data-name="Jenis_Pestisida" class="<?= $Page->Jenis_Pestisida->headerCellClass() ?>"><div id="elh_view5_Jenis_Pestisida" class="view5_Jenis_Pestisida"><?= $Page->renderFieldHeader($Page->Jenis_Pestisida) ?></div></th>
<?php } ?>
<?php if ($Page->Merek_Pestisida->Visible) { // Merek_Pestisida ?>
        <th data-name="Merek_Pestisida" class="<?= $Page->Merek_Pestisida->headerCellClass() ?>"><div id="elh_view5_Merek_Pestisida" class="view5_Merek_Pestisida"><?= $Page->renderFieldHeader($Page->Merek_Pestisida) ?></div></th>
<?php } ?>
<?php if ($Page->Bahan_Aktif->Visible) { // Bahan_Aktif ?>
        <th data-name="Bahan_Aktif" class="<?= $Page->Bahan_Aktif->headerCellClass() ?>"><div id="elh_view5_Bahan_Aktif" class="view5_Bahan_Aktif"><?= $Page->renderFieldHeader($Page->Bahan_Aktif) ?></div></th>
<?php } ?>
<?php if ($Page->Dosis_Pemakaian->Visible) { // Dosis_Pemakaian ?>
        <th data-name="Dosis_Pemakaian" class="<?= $Page->Dosis_Pemakaian->headerCellClass() ?>"><div id="elh_view5_Dosis_Pemakaian" class="view5_Dosis_Pemakaian"><?= $Page->renderFieldHeader($Page->Dosis_Pemakaian) ?></div></th>
<?php } ?>
<?php if ($Page->Waktu_Aplikasi->Visible) { // Waktu_Aplikasi ?>
        <th data-name="Waktu_Aplikasi" class="<?= $Page->Waktu_Aplikasi->headerCellClass() ?>"><div id="elh_view5_Waktu_Aplikasi" class="view5_Waktu_Aplikasi"><?= $Page->renderFieldHeader($Page->Waktu_Aplikasi) ?></div></th>
<?php } ?>
<?php if ($Page->co_nama->Visible) { // co_nama ?>
        <th data-name="co_nama" class="<?= $Page->co_nama->headerCellClass() ?>"><div id="elh_view5_co_nama" class="view5_co_nama"><?= $Page->renderFieldHeader($Page->co_nama) ?></div></th>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { // koord_nama ?>
        <th data-name="koord_nama" class="<?= $Page->koord_nama->headerCellClass() ?>"><div id="elh_view5_koord_nama" class="view5_koord_nama"><?= $Page->renderFieldHeader($Page->koord_nama) ?></div></th>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { // pet_nama ?>
        <th data-name="pet_nama" class="<?= $Page->pet_nama->headerCellClass() ?>"><div id="elh_view5_pet_nama" class="view5_pet_nama"><?= $Page->renderFieldHeader($Page->pet_nama) ?></div></th>
<?php } ?>
<?php if ($Page->var_nama->Visible) { // var_nama ?>
        <th data-name="var_nama" class="<?= $Page->var_nama->headerCellClass() ?>"><div id="elh_view5_var_nama" class="view5_var_nama"><?= $Page->renderFieldHeader($Page->var_nama) ?></div></th>
<?php } ?>
<?php if ($Page->blok_nama->Visible) { // blok_nama ?>
        <th data-name="blok_nama" class="<?= $Page->blok_nama->headerCellClass() ?>"><div id="elh_view5_blok_nama" class="view5_blok_nama"><?= $Page->renderFieldHeader($Page->blok_nama) ?></div></th>
<?php } ?>
<?php if ($Page->desa_nama->Visible) { // desa_nama ?>
        <th data-name="desa_nama" class="<?= $Page->desa_nama->headerCellClass() ?>"><div id="elh_view5_desa_nama" class="view5_desa_nama"><?= $Page->renderFieldHeader($Page->desa_nama) ?></div></th>
<?php } ?>
<?php if ($Page->kec_nama->Visible) { // kec_nama ?>
        <th data-name="kec_nama" class="<?= $Page->kec_nama->headerCellClass() ?>"><div id="elh_view5_kec_nama" class="view5_kec_nama"><?= $Page->renderFieldHeader($Page->kec_nama) ?></div></th>
<?php } ?>
<?php if ($Page->kab_nama->Visible) { // kab_nama ?>
        <th data-name="kab_nama" class="<?= $Page->kab_nama->headerCellClass() ?>"><div id="elh_view5_kab_nama" class="view5_kab_nama"><?= $Page->renderFieldHeader($Page->kab_nama) ?></div></th>
<?php } ?>
<?php if ($Page->prov_nama->Visible) { // prov_nama ?>
        <th data-name="prov_nama" class="<?= $Page->prov_nama->headerCellClass() ?>"><div id="elh_view5_prov_nama" class="view5_prov_nama"><?= $Page->renderFieldHeader($Page->prov_nama) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->k_id_kontrak->Visible) { // k_id_kontrak ?>
        <td data-name="k_id_kontrak"<?= $Page->k_id_kontrak->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_k_id_kontrak" class="el_view5_k_id_kontrak">
<span<?= $Page->k_id_kontrak->viewAttributes() ?>>
<?= $Page->k_id_kontrak->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_tgl_tanam->Visible) { // k_tgl_tanam ?>
        <td data-name="k_tgl_tanam"<?= $Page->k_tgl_tanam->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_k_tgl_tanam" class="el_view5_k_tgl_tanam">
<span<?= $Page->k_tgl_tanam->viewAttributes() ?>>
<?= $Page->k_tgl_tanam->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_luas_lahan->Visible) { // k_luas_lahan ?>
        <td data-name="k_luas_lahan"<?= $Page->k_luas_lahan->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_k_luas_lahan" class="el_view5_k_luas_lahan">
<span<?= $Page->k_luas_lahan->viewAttributes() ?>>
<?= $Page->k_luas_lahan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Jenis_Pestisida->Visible) { // Jenis_Pestisida ?>
        <td data-name="Jenis_Pestisida"<?= $Page->Jenis_Pestisida->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_Jenis_Pestisida" class="el_view5_Jenis_Pestisida">
<span<?= $Page->Jenis_Pestisida->viewAttributes() ?>>
<?= $Page->Jenis_Pestisida->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Merek_Pestisida->Visible) { // Merek_Pestisida ?>
        <td data-name="Merek_Pestisida"<?= $Page->Merek_Pestisida->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_Merek_Pestisida" class="el_view5_Merek_Pestisida">
<span<?= $Page->Merek_Pestisida->viewAttributes() ?>>
<?= $Page->Merek_Pestisida->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Bahan_Aktif->Visible) { // Bahan_Aktif ?>
        <td data-name="Bahan_Aktif"<?= $Page->Bahan_Aktif->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_Bahan_Aktif" class="el_view5_Bahan_Aktif">
<span<?= $Page->Bahan_Aktif->viewAttributes() ?>>
<?= $Page->Bahan_Aktif->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Dosis_Pemakaian->Visible) { // Dosis_Pemakaian ?>
        <td data-name="Dosis_Pemakaian"<?= $Page->Dosis_Pemakaian->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_Dosis_Pemakaian" class="el_view5_Dosis_Pemakaian">
<span<?= $Page->Dosis_Pemakaian->viewAttributes() ?>>
<?= $Page->Dosis_Pemakaian->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Waktu_Aplikasi->Visible) { // Waktu_Aplikasi ?>
        <td data-name="Waktu_Aplikasi"<?= $Page->Waktu_Aplikasi->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_Waktu_Aplikasi" class="el_view5_Waktu_Aplikasi">
<span<?= $Page->Waktu_Aplikasi->viewAttributes() ?>>
<?= $Page->Waktu_Aplikasi->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->co_nama->Visible) { // co_nama ?>
        <td data-name="co_nama"<?= $Page->co_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_co_nama" class="el_view5_co_nama">
<span<?= $Page->co_nama->viewAttributes() ?>>
<?= $Page->co_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->koord_nama->Visible) { // koord_nama ?>
        <td data-name="koord_nama"<?= $Page->koord_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_koord_nama" class="el_view5_koord_nama">
<span<?= $Page->koord_nama->viewAttributes() ?>>
<?= $Page->koord_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pet_nama->Visible) { // pet_nama ?>
        <td data-name="pet_nama"<?= $Page->pet_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_pet_nama" class="el_view5_pet_nama">
<span<?= $Page->pet_nama->viewAttributes() ?>>
<?= $Page->pet_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->var_nama->Visible) { // var_nama ?>
        <td data-name="var_nama"<?= $Page->var_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_var_nama" class="el_view5_var_nama">
<span<?= $Page->var_nama->viewAttributes() ?>>
<?= $Page->var_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->blok_nama->Visible) { // blok_nama ?>
        <td data-name="blok_nama"<?= $Page->blok_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_blok_nama" class="el_view5_blok_nama">
<span<?= $Page->blok_nama->viewAttributes() ?>>
<?= $Page->blok_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->desa_nama->Visible) { // desa_nama ?>
        <td data-name="desa_nama"<?= $Page->desa_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_desa_nama" class="el_view5_desa_nama">
<span<?= $Page->desa_nama->viewAttributes() ?>>
<?= $Page->desa_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kec_nama->Visible) { // kec_nama ?>
        <td data-name="kec_nama"<?= $Page->kec_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_kec_nama" class="el_view5_kec_nama">
<span<?= $Page->kec_nama->viewAttributes() ?>>
<?= $Page->kec_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kab_nama->Visible) { // kab_nama ?>
        <td data-name="kab_nama"<?= $Page->kab_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_kab_nama" class="el_view5_kab_nama">
<span<?= $Page->kab_nama->viewAttributes() ?>>
<?= $Page->kab_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->prov_nama->Visible) { // prov_nama ?>
        <td data-name="prov_nama"<?= $Page->prov_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_view5_prov_nama" class="el_view5_prov_nama">
<span<?= $Page->prov_nama->viewAttributes() ?>>
<?= $Page->prov_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }
    if (
        $Page->Recordset &&
        !$Page->Recordset->EOF &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->Recordset->moveNext();
    }
    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Page->Recordset) {
    $Page->Recordset->close();
}
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("view5");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
