<?php

namespace PHPMaker2023\co;

// Page object
$OrderBibitList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { order_bibit: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="forder_bibitsrch" id="forder_bibitsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="on">
<div id="forder_bibitsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { order_bibit: currentTable } });
var currentForm;
var forder_bibitsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("forder_bibitsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ob_id", [], fields.ob_id.isInvalid],
            ["ob_co", [], fields.ob_co.isInvalid],
            ["ob_k_tanam", [], fields.ob_k_tanam.isInvalid],
            ["ob_pembeli", [], fields.ob_pembeli.isInvalid],
            ["ob_tgl_kirim", [ew.Validators.datetime(fields.ob_tgl_kirim.clientFormatPattern)], fields.ob_tgl_kirim.isInvalid],
            ["y_ob_tgl_kirim", [ew.Validators.between], false],
            ["ob_var", [], fields.ob_var.isInvalid],
            ["ob_jumlah", [], fields.ob_jumlah.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["ob_tgl_real_kirim", [ew.Validators.datetime(fields.ob_tgl_real_kirim.clientFormatPattern)], fields.ob_tgl_real_kirim.isInvalid],
            ["y_ob_tgl_real_kirim", [ew.Validators.between], false],
            ["ob_jumlah_real_kirim", [], fields.ob_jumlah_real_kirim.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ob_co": <?= $Page->ob_co->toClientList($Page) ?>,
            "ob_k_tanam": <?= $Page->ob_k_tanam->toClientList($Page) ?>,
            "ob_var": <?= $Page->ob_var->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->ob_co->Visible) { // ob_co ?>
<?php
if (!$Page->ob_co->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ob_co" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ob_co->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_ob_co" class="ew-search-caption ew-label"><?= $Page->ob_co->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ob_co" id="z_ob_co" value="=">
</div>
        </div>
        <div id="el_order_bibit_ob_co" class="ew-search-field">
    <select
        id="x_ob_co"
        name="x_ob_co"
        class="form-select ew-select<?= $Page->ob_co->isInvalidClass() ?>"
        <?php if (!$Page->ob_co->IsNativeSelect) { ?>
        data-select2-id="forder_bibitsrch_x_ob_co"
        <?php } ?>
        data-table="order_bibit"
        data-field="x_ob_co"
        data-value-separator="<?= $Page->ob_co->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ob_co->getPlaceHolder()) ?>"
        <?= $Page->ob_co->editAttributes() ?>>
        <?= $Page->ob_co->selectOptionListHtml("x_ob_co") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ob_co->getErrorMessage(false) ?></div>
<?= $Page->ob_co->Lookup->getParamTag($Page, "p_x_ob_co") ?>
<?php if (!$Page->ob_co->IsNativeSelect) { ?>
<script>
loadjs.ready("forder_bibitsrch", function() {
    var options = { name: "x_ob_co", selectId: "forder_bibitsrch_x_ob_co" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (forder_bibitsrch.lists.ob_co?.lookupOptions.length) {
        options.data = { id: "x_ob_co", form: "forder_bibitsrch" };
    } else {
        options.ajax = { id: "x_ob_co", form: "forder_bibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.order_bibit.fields.ob_co.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ob_k_tanam->Visible) { // ob_k_tanam ?>
<?php
if (!$Page->ob_k_tanam->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ob_k_tanam" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ob_k_tanam->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_ob_k_tanam" class="ew-search-caption ew-label"><?= $Page->ob_k_tanam->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ob_k_tanam" id="z_ob_k_tanam" value="=">
</div>
        </div>
        <div id="el_order_bibit_ob_k_tanam" class="ew-search-field">
    <select
        id="x_ob_k_tanam"
        name="x_ob_k_tanam"
        class="form-select ew-select<?= $Page->ob_k_tanam->isInvalidClass() ?>"
        <?php if (!$Page->ob_k_tanam->IsNativeSelect) { ?>
        data-select2-id="forder_bibitsrch_x_ob_k_tanam"
        <?php } ?>
        data-table="order_bibit"
        data-field="x_ob_k_tanam"
        data-value-separator="<?= $Page->ob_k_tanam->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ob_k_tanam->getPlaceHolder()) ?>"
        <?= $Page->ob_k_tanam->editAttributes() ?>>
        <?= $Page->ob_k_tanam->selectOptionListHtml("x_ob_k_tanam") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ob_k_tanam->getErrorMessage(false) ?></div>
<?= $Page->ob_k_tanam->Lookup->getParamTag($Page, "p_x_ob_k_tanam") ?>
<?php if (!$Page->ob_k_tanam->IsNativeSelect) { ?>
<script>
loadjs.ready("forder_bibitsrch", function() {
    var options = { name: "x_ob_k_tanam", selectId: "forder_bibitsrch_x_ob_k_tanam" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (forder_bibitsrch.lists.ob_k_tanam?.lookupOptions.length) {
        options.data = { id: "x_ob_k_tanam", form: "forder_bibitsrch" };
    } else {
        options.ajax = { id: "x_ob_k_tanam", form: "forder_bibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.order_bibit.fields.ob_k_tanam.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ob_pembeli->Visible) { // ob_pembeli ?>
<?php
if (!$Page->ob_pembeli->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ob_pembeli" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ob_pembeli->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_ob_pembeli" class="ew-search-caption ew-label"><?= $Page->ob_pembeli->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ob_pembeli" id="z_ob_pembeli" value="LIKE">
</div>
        </div>
        <div id="el_order_bibit_ob_pembeli" class="ew-search-field">
<input type="<?= $Page->ob_pembeli->getInputTextType() ?>" name="x_ob_pembeli" id="x_ob_pembeli" data-table="order_bibit" data-field="x_ob_pembeli" value="<?= $Page->ob_pembeli->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->ob_pembeli->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ob_pembeli->formatPattern()) ?>"<?= $Page->ob_pembeli->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ob_pembeli->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ob_tgl_kirim->Visible) { // ob_tgl_kirim ?>
<?php
if (!$Page->ob_tgl_kirim->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ob_tgl_kirim" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ob_tgl_kirim->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_ob_tgl_kirim" class="ew-search-caption ew-label"><?= $Page->ob_tgl_kirim->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_ob_tgl_kirim" id="z_ob_tgl_kirim" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->ob_tgl_kirim->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->ob_tgl_kirim->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_order_bibit_ob_tgl_kirim" class="ew-search-field">
<input type="<?= $Page->ob_tgl_kirim->getInputTextType() ?>" name="x_ob_tgl_kirim" id="x_ob_tgl_kirim" data-table="order_bibit" data-field="x_ob_tgl_kirim" value="<?= $Page->ob_tgl_kirim->EditValue ?>" placeholder="<?= HtmlEncode($Page->ob_tgl_kirim->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ob_tgl_kirim->formatPattern()) ?>"<?= $Page->ob_tgl_kirim->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ob_tgl_kirim->getErrorMessage(false) ?></div>
<?php if (!$Page->ob_tgl_kirim->ReadOnly && !$Page->ob_tgl_kirim->Disabled && !isset($Page->ob_tgl_kirim->EditAttrs["readonly"]) && !isset($Page->ob_tgl_kirim->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["forder_bibitsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("forder_bibitsrch", "x_ob_tgl_kirim", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_order_bibit_ob_tgl_kirim" class="ew-search-field2 d-none">
<input type="<?= $Page->ob_tgl_kirim->getInputTextType() ?>" name="y_ob_tgl_kirim" id="y_ob_tgl_kirim" data-table="order_bibit" data-field="x_ob_tgl_kirim" value="<?= $Page->ob_tgl_kirim->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->ob_tgl_kirim->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ob_tgl_kirim->formatPattern()) ?>"<?= $Page->ob_tgl_kirim->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ob_tgl_kirim->getErrorMessage(false) ?></div>
<?php if (!$Page->ob_tgl_kirim->ReadOnly && !$Page->ob_tgl_kirim->Disabled && !isset($Page->ob_tgl_kirim->EditAttrs["readonly"]) && !isset($Page->ob_tgl_kirim->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["forder_bibitsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("forder_bibitsrch", "y_ob_tgl_kirim", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ob_var->Visible) { // ob_var ?>
<?php
if (!$Page->ob_var->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ob_var" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ob_var->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_ob_var" class="ew-search-caption ew-label"><?= $Page->ob_var->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ob_var" id="z_ob_var" value="=">
</div>
        </div>
        <div id="el_order_bibit_ob_var" class="ew-search-field">
    <select
        id="x_ob_var"
        name="x_ob_var"
        class="form-select ew-select<?= $Page->ob_var->isInvalidClass() ?>"
        <?php if (!$Page->ob_var->IsNativeSelect) { ?>
        data-select2-id="forder_bibitsrch_x_ob_var"
        <?php } ?>
        data-table="order_bibit"
        data-field="x_ob_var"
        data-value-separator="<?= $Page->ob_var->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ob_var->getPlaceHolder()) ?>"
        <?= $Page->ob_var->editAttributes() ?>>
        <?= $Page->ob_var->selectOptionListHtml("x_ob_var") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ob_var->getErrorMessage(false) ?></div>
<?= $Page->ob_var->Lookup->getParamTag($Page, "p_x_ob_var") ?>
<?php if (!$Page->ob_var->IsNativeSelect) { ?>
<script>
loadjs.ready("forder_bibitsrch", function() {
    var options = { name: "x_ob_var", selectId: "forder_bibitsrch_x_ob_var" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (forder_bibitsrch.lists.ob_var?.lookupOptions.length) {
        options.data = { id: "x_ob_var", form: "forder_bibitsrch" };
    } else {
        options.ajax = { id: "x_ob_var", form: "forder_bibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.order_bibit.fields.ob_var.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_order_bibit_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-control ew-select<?= $Page->status->isInvalidClass() ?>"
        data-select2-id="forder_bibitsrch_x_status"
        data-table="order_bibit"
        data-field="x_status"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->status->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<script>
loadjs.ready("forder_bibitsrch", function() {
    var options = { name: "x_status", selectId: "forder_bibitsrch_x_status" };
    if (forder_bibitsrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "forder_bibitsrch" };
    } else {
        options.ajax = { id: "x_status", form: "forder_bibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.order_bibit.fields.status.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ob_tgl_real_kirim->Visible) { // ob_tgl_real_kirim ?>
<?php
if (!$Page->ob_tgl_real_kirim->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ob_tgl_real_kirim" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ob_tgl_real_kirim->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_ob_tgl_real_kirim" class="ew-search-caption ew-label"><?= $Page->ob_tgl_real_kirim->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_ob_tgl_real_kirim" id="z_ob_tgl_real_kirim" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->ob_tgl_real_kirim->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_order_bibit_ob_tgl_real_kirim" class="ew-search-field">
<input type="<?= $Page->ob_tgl_real_kirim->getInputTextType() ?>" name="x_ob_tgl_real_kirim" id="x_ob_tgl_real_kirim" data-table="order_bibit" data-field="x_ob_tgl_real_kirim" value="<?= $Page->ob_tgl_real_kirim->EditValue ?>" placeholder="<?= HtmlEncode($Page->ob_tgl_real_kirim->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ob_tgl_real_kirim->formatPattern()) ?>"<?= $Page->ob_tgl_real_kirim->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ob_tgl_real_kirim->getErrorMessage(false) ?></div>
<?php if (!$Page->ob_tgl_real_kirim->ReadOnly && !$Page->ob_tgl_real_kirim->Disabled && !isset($Page->ob_tgl_real_kirim->EditAttrs["readonly"]) && !isset($Page->ob_tgl_real_kirim->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["forder_bibitsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("forder_bibitsrch", "x_ob_tgl_real_kirim", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_order_bibit_ob_tgl_real_kirim" class="ew-search-field2 d-none">
<input type="<?= $Page->ob_tgl_real_kirim->getInputTextType() ?>" name="y_ob_tgl_real_kirim" id="y_ob_tgl_real_kirim" data-table="order_bibit" data-field="x_ob_tgl_real_kirim" value="<?= $Page->ob_tgl_real_kirim->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->ob_tgl_real_kirim->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ob_tgl_real_kirim->formatPattern()) ?>"<?= $Page->ob_tgl_real_kirim->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ob_tgl_real_kirim->getErrorMessage(false) ?></div>
<?php if (!$Page->ob_tgl_real_kirim->ReadOnly && !$Page->ob_tgl_real_kirim->Disabled && !isset($Page->ob_tgl_real_kirim->EditAttrs["readonly"]) && !isset($Page->ob_tgl_real_kirim->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["forder_bibitsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("forder_bibitsrch", "y_ob_tgl_real_kirim", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="forder_bibitsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="forder_bibitsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="forder_bibitsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="forder_bibitsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="on">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="order_bibit">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_order_bibit" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_order_bibitlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = ROWTYPE_HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ob_id->Visible) { // ob_id ?>
        <th data-name="ob_id" class="<?= $Page->ob_id->headerCellClass() ?>"><div id="elh_order_bibit_ob_id" class="order_bibit_ob_id"><?= $Page->renderFieldHeader($Page->ob_id) ?></div></th>
<?php } ?>
<?php if ($Page->ob_co->Visible) { // ob_co ?>
        <th data-name="ob_co" class="<?= $Page->ob_co->headerCellClass() ?>"><div id="elh_order_bibit_ob_co" class="order_bibit_ob_co"><?= $Page->renderFieldHeader($Page->ob_co) ?></div></th>
<?php } ?>
<?php if ($Page->ob_k_tanam->Visible) { // ob_k_tanam ?>
        <th data-name="ob_k_tanam" class="<?= $Page->ob_k_tanam->headerCellClass() ?>"><div id="elh_order_bibit_ob_k_tanam" class="order_bibit_ob_k_tanam"><?= $Page->renderFieldHeader($Page->ob_k_tanam) ?></div></th>
<?php } ?>
<?php if ($Page->ob_pembeli->Visible) { // ob_pembeli ?>
        <th data-name="ob_pembeli" class="<?= $Page->ob_pembeli->headerCellClass() ?>"><div id="elh_order_bibit_ob_pembeli" class="order_bibit_ob_pembeli"><?= $Page->renderFieldHeader($Page->ob_pembeli) ?></div></th>
<?php } ?>
<?php if ($Page->ob_tgl_kirim->Visible) { // ob_tgl_kirim ?>
        <th data-name="ob_tgl_kirim" class="<?= $Page->ob_tgl_kirim->headerCellClass() ?>"><div id="elh_order_bibit_ob_tgl_kirim" class="order_bibit_ob_tgl_kirim"><?= $Page->renderFieldHeader($Page->ob_tgl_kirim) ?></div></th>
<?php } ?>
<?php if ($Page->ob_var->Visible) { // ob_var ?>
        <th data-name="ob_var" class="<?= $Page->ob_var->headerCellClass() ?>"><div id="elh_order_bibit_ob_var" class="order_bibit_ob_var"><?= $Page->renderFieldHeader($Page->ob_var) ?></div></th>
<?php } ?>
<?php if ($Page->ob_jumlah->Visible) { // ob_jumlah ?>
        <th data-name="ob_jumlah" class="<?= $Page->ob_jumlah->headerCellClass() ?>"><div id="elh_order_bibit_ob_jumlah" class="order_bibit_ob_jumlah"><?= $Page->renderFieldHeader($Page->ob_jumlah) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_order_bibit_status" class="order_bibit_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->ob_tgl_real_kirim->Visible) { // ob_tgl_real_kirim ?>
        <th data-name="ob_tgl_real_kirim" class="<?= $Page->ob_tgl_real_kirim->headerCellClass() ?>"><div id="elh_order_bibit_ob_tgl_real_kirim" class="order_bibit_ob_tgl_real_kirim"><?= $Page->renderFieldHeader($Page->ob_tgl_real_kirim) ?></div></th>
<?php } ?>
<?php if ($Page->ob_jumlah_real_kirim->Visible) { // ob_jumlah_real_kirim ?>
        <th data-name="ob_jumlah_real_kirim" class="<?= $Page->ob_jumlah_real_kirim->headerCellClass() ?>"><div id="elh_order_bibit_ob_jumlah_real_kirim" class="order_bibit_ob_jumlah_real_kirim"><?= $Page->renderFieldHeader($Page->ob_jumlah_real_kirim) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ob_id->Visible) { // ob_id ?>
        <td data-name="ob_id"<?= $Page->ob_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_ob_id" class="el_order_bibit_ob_id">
<span<?= $Page->ob_id->viewAttributes() ?>>
<?= $Page->ob_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ob_co->Visible) { // ob_co ?>
        <td data-name="ob_co"<?= $Page->ob_co->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_ob_co" class="el_order_bibit_ob_co">
<span<?= $Page->ob_co->viewAttributes() ?>>
<?= $Page->ob_co->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ob_k_tanam->Visible) { // ob_k_tanam ?>
        <td data-name="ob_k_tanam"<?= $Page->ob_k_tanam->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_ob_k_tanam" class="el_order_bibit_ob_k_tanam">
<span<?= $Page->ob_k_tanam->viewAttributes() ?>>
<?= $Page->ob_k_tanam->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ob_pembeli->Visible) { // ob_pembeli ?>
        <td data-name="ob_pembeli"<?= $Page->ob_pembeli->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_ob_pembeli" class="el_order_bibit_ob_pembeli">
<span<?= $Page->ob_pembeli->viewAttributes() ?>>
<?= $Page->ob_pembeli->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ob_tgl_kirim->Visible) { // ob_tgl_kirim ?>
        <td data-name="ob_tgl_kirim"<?= $Page->ob_tgl_kirim->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_ob_tgl_kirim" class="el_order_bibit_ob_tgl_kirim">
<span<?= $Page->ob_tgl_kirim->viewAttributes() ?>>
<?= $Page->ob_tgl_kirim->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ob_var->Visible) { // ob_var ?>
        <td data-name="ob_var"<?= $Page->ob_var->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_ob_var" class="el_order_bibit_ob_var">
<span<?= $Page->ob_var->viewAttributes() ?>>
<?= $Page->ob_var->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ob_jumlah->Visible) { // ob_jumlah ?>
        <td data-name="ob_jumlah"<?= $Page->ob_jumlah->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_ob_jumlah" class="el_order_bibit_ob_jumlah">
<span<?= $Page->ob_jumlah->viewAttributes() ?>>
<?= $Page->ob_jumlah->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_status" class="el_order_bibit_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ob_tgl_real_kirim->Visible) { // ob_tgl_real_kirim ?>
        <td data-name="ob_tgl_real_kirim"<?= $Page->ob_tgl_real_kirim->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_ob_tgl_real_kirim" class="el_order_bibit_ob_tgl_real_kirim">
<span<?= $Page->ob_tgl_real_kirim->viewAttributes() ?>>
<?= $Page->ob_tgl_real_kirim->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ob_jumlah_real_kirim->Visible) { // ob_jumlah_real_kirim ?>
        <td data-name="ob_jumlah_real_kirim"<?= $Page->ob_jumlah_real_kirim->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_order_bibit_ob_jumlah_real_kirim" class="el_order_bibit_ob_jumlah_real_kirim">
<span<?= $Page->ob_jumlah_real_kirim->viewAttributes() ?>>
<?= $Page->ob_jumlah_real_kirim->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }
    if (
        $Page->Recordset &&
        !$Page->Recordset->EOF &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->Recordset->moveNext();
    }
    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = ROWTYPE_AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->ob_id->Visible) { // ob_id ?>
        <td data-name="ob_id" class="<?= $Page->ob_id->footerCellClass() ?>"><span id="elf_order_bibit_ob_id" class="order_bibit_ob_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->ob_co->Visible) { // ob_co ?>
        <td data-name="ob_co" class="<?= $Page->ob_co->footerCellClass() ?>"><span id="elf_order_bibit_ob_co" class="order_bibit_ob_co">
        </span></td>
    <?php } ?>
    <?php if ($Page->ob_k_tanam->Visible) { // ob_k_tanam ?>
        <td data-name="ob_k_tanam" class="<?= $Page->ob_k_tanam->footerCellClass() ?>"><span id="elf_order_bibit_ob_k_tanam" class="order_bibit_ob_k_tanam">
        </span></td>
    <?php } ?>
    <?php if ($Page->ob_pembeli->Visible) { // ob_pembeli ?>
        <td data-name="ob_pembeli" class="<?= $Page->ob_pembeli->footerCellClass() ?>"><span id="elf_order_bibit_ob_pembeli" class="order_bibit_ob_pembeli">
        </span></td>
    <?php } ?>
    <?php if ($Page->ob_tgl_kirim->Visible) { // ob_tgl_kirim ?>
        <td data-name="ob_tgl_kirim" class="<?= $Page->ob_tgl_kirim->footerCellClass() ?>"><span id="elf_order_bibit_ob_tgl_kirim" class="order_bibit_ob_tgl_kirim">
        </span></td>
    <?php } ?>
    <?php if ($Page->ob_var->Visible) { // ob_var ?>
        <td data-name="ob_var" class="<?= $Page->ob_var->footerCellClass() ?>"><span id="elf_order_bibit_ob_var" class="order_bibit_ob_var">
        </span></td>
    <?php } ?>
    <?php if ($Page->ob_jumlah->Visible) { // ob_jumlah ?>
        <td data-name="ob_jumlah" class="<?= $Page->ob_jumlah->footerCellClass() ?>"><span id="elf_order_bibit_ob_jumlah" class="order_bibit_ob_jumlah">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->ob_jumlah->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status" class="<?= $Page->status->footerCellClass() ?>"><span id="elf_order_bibit_status" class="order_bibit_status">
        </span></td>
    <?php } ?>
    <?php if ($Page->ob_tgl_real_kirim->Visible) { // ob_tgl_real_kirim ?>
        <td data-name="ob_tgl_real_kirim" class="<?= $Page->ob_tgl_real_kirim->footerCellClass() ?>"><span id="elf_order_bibit_ob_tgl_real_kirim" class="order_bibit_ob_tgl_real_kirim">
        </span></td>
    <?php } ?>
    <?php if ($Page->ob_jumlah_real_kirim->Visible) { // ob_jumlah_real_kirim ?>
        <td data-name="ob_jumlah_real_kirim" class="<?= $Page->ob_jumlah_real_kirim->footerCellClass() ?>"><span id="elf_order_bibit_ob_jumlah_real_kirim" class="order_bibit_ob_jumlah_real_kirim">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->ob_jumlah_real_kirim->ViewValue ?></span>
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Page->Recordset) {
    $Page->Recordset->close();
}
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("order_bibit");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
