<?php

namespace PHPMaker2023\co;

use Slim\App;
use Slim\Routing\RouteCollectorProxy;
use Slim\Exception\HttpNotFoundException;

// Handle Routes
return function (App $app) {
    // blok
    $app->map(["GET","POST","OPTIONS"], '/BlokList[/{blok_id}]', BlokController::class . ':list')->add(PermissionMiddleware::class)->setName('BlokList-blok-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/BlokAdd[/{blok_id}]', BlokController::class . ':add')->add(PermissionMiddleware::class)->setName('BlokAdd-blok-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/BlokAddopt', BlokController::class . ':addopt')->add(PermissionMiddleware::class)->setName('BlokAddopt-blok-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/BlokView[/{blok_id}]', BlokController::class . ':view')->add(PermissionMiddleware::class)->setName('BlokView-blok-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/BlokEdit[/{blok_id}]', BlokController::class . ':edit')->add(PermissionMiddleware::class)->setName('BlokEdit-blok-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/BlokDelete[/{blok_id}]', BlokController::class . ':delete')->add(PermissionMiddleware::class)->setName('BlokDelete-blok-delete'); // delete
    $app->group(
        '/blok',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{blok_id}]', BlokController::class . ':list')->add(PermissionMiddleware::class)->setName('blok/list-blok-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{blok_id}]', BlokController::class . ':add')->add(PermissionMiddleware::class)->setName('blok/add-blok-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', BlokController::class . ':addopt')->add(PermissionMiddleware::class)->setName('blok/addopt-blok-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{blok_id}]', BlokController::class . ':view')->add(PermissionMiddleware::class)->setName('blok/view-blok-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{blok_id}]', BlokController::class . ':edit')->add(PermissionMiddleware::class)->setName('blok/edit-blok-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{blok_id}]', BlokController::class . ':delete')->add(PermissionMiddleware::class)->setName('blok/delete-blok-delete-2'); // delete
        }
    );

    // co
    $app->map(["GET","POST","OPTIONS"], '/CoList[/{co_id}]', CoController::class . ':list')->add(PermissionMiddleware::class)->setName('CoList-co-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/CoAdd[/{co_id}]', CoController::class . ':add')->add(PermissionMiddleware::class)->setName('CoAdd-co-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/CoAddopt', CoController::class . ':addopt')->add(PermissionMiddleware::class)->setName('CoAddopt-co-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/CoView[/{co_id}]', CoController::class . ':view')->add(PermissionMiddleware::class)->setName('CoView-co-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/CoEdit[/{co_id}]', CoController::class . ':edit')->add(PermissionMiddleware::class)->setName('CoEdit-co-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/CoDelete[/{co_id}]', CoController::class . ':delete')->add(PermissionMiddleware::class)->setName('CoDelete-co-delete'); // delete
    $app->group(
        '/co',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{co_id}]', CoController::class . ':list')->add(PermissionMiddleware::class)->setName('co/list-co-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{co_id}]', CoController::class . ':add')->add(PermissionMiddleware::class)->setName('co/add-co-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', CoController::class . ':addopt')->add(PermissionMiddleware::class)->setName('co/addopt-co-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{co_id}]', CoController::class . ':view')->add(PermissionMiddleware::class)->setName('co/view-co-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{co_id}]', CoController::class . ':edit')->add(PermissionMiddleware::class)->setName('co/edit-co-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{co_id}]', CoController::class . ':delete')->add(PermissionMiddleware::class)->setName('co/delete-co-delete-2'); // delete
        }
    );

    // desa
    $app->map(["GET","POST","OPTIONS"], '/DesaList[/{desa_id}]', DesaController::class . ':list')->add(PermissionMiddleware::class)->setName('DesaList-desa-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/DesaAdd[/{desa_id}]', DesaController::class . ':add')->add(PermissionMiddleware::class)->setName('DesaAdd-desa-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/DesaAddopt', DesaController::class . ':addopt')->add(PermissionMiddleware::class)->setName('DesaAddopt-desa-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/DesaView[/{desa_id}]', DesaController::class . ':view')->add(PermissionMiddleware::class)->setName('DesaView-desa-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/DesaEdit[/{desa_id}]', DesaController::class . ':edit')->add(PermissionMiddleware::class)->setName('DesaEdit-desa-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/DesaDelete[/{desa_id}]', DesaController::class . ':delete')->add(PermissionMiddleware::class)->setName('DesaDelete-desa-delete'); // delete
    $app->group(
        '/desa',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{desa_id}]', DesaController::class . ':list')->add(PermissionMiddleware::class)->setName('desa/list-desa-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{desa_id}]', DesaController::class . ':add')->add(PermissionMiddleware::class)->setName('desa/add-desa-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', DesaController::class . ':addopt')->add(PermissionMiddleware::class)->setName('desa/addopt-desa-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{desa_id}]', DesaController::class . ':view')->add(PermissionMiddleware::class)->setName('desa/view-desa-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{desa_id}]', DesaController::class . ':edit')->add(PermissionMiddleware::class)->setName('desa/edit-desa-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{desa_id}]', DesaController::class . ':delete')->add(PermissionMiddleware::class)->setName('desa/delete-desa-delete-2'); // delete
        }
    );

    // kab
    $app->map(["GET","POST","OPTIONS"], '/KabList[/{kab_id}]', KabController::class . ':list')->add(PermissionMiddleware::class)->setName('KabList-kab-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/KabAdd[/{kab_id}]', KabController::class . ':add')->add(PermissionMiddleware::class)->setName('KabAdd-kab-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/KabAddopt', KabController::class . ':addopt')->add(PermissionMiddleware::class)->setName('KabAddopt-kab-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/KabView[/{kab_id}]', KabController::class . ':view')->add(PermissionMiddleware::class)->setName('KabView-kab-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/KabEdit[/{kab_id}]', KabController::class . ':edit')->add(PermissionMiddleware::class)->setName('KabEdit-kab-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/KabDelete[/{kab_id}]', KabController::class . ':delete')->add(PermissionMiddleware::class)->setName('KabDelete-kab-delete'); // delete
    $app->group(
        '/kab',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{kab_id}]', KabController::class . ':list')->add(PermissionMiddleware::class)->setName('kab/list-kab-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{kab_id}]', KabController::class . ':add')->add(PermissionMiddleware::class)->setName('kab/add-kab-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', KabController::class . ':addopt')->add(PermissionMiddleware::class)->setName('kab/addopt-kab-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{kab_id}]', KabController::class . ':view')->add(PermissionMiddleware::class)->setName('kab/view-kab-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{kab_id}]', KabController::class . ':edit')->add(PermissionMiddleware::class)->setName('kab/edit-kab-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{kab_id}]', KabController::class . ':delete')->add(PermissionMiddleware::class)->setName('kab/delete-kab-delete-2'); // delete
        }
    );

    // kec
    $app->map(["GET","POST","OPTIONS"], '/KecList[/{kec_id}]', KecController::class . ':list')->add(PermissionMiddleware::class)->setName('KecList-kec-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/KecAdd[/{kec_id}]', KecController::class . ':add')->add(PermissionMiddleware::class)->setName('KecAdd-kec-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/KecAddopt', KecController::class . ':addopt')->add(PermissionMiddleware::class)->setName('KecAddopt-kec-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/KecView[/{kec_id}]', KecController::class . ':view')->add(PermissionMiddleware::class)->setName('KecView-kec-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/KecEdit[/{kec_id}]', KecController::class . ':edit')->add(PermissionMiddleware::class)->setName('KecEdit-kec-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/KecDelete[/{kec_id}]', KecController::class . ':delete')->add(PermissionMiddleware::class)->setName('KecDelete-kec-delete'); // delete
    $app->group(
        '/kec',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{kec_id}]', KecController::class . ':list')->add(PermissionMiddleware::class)->setName('kec/list-kec-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{kec_id}]', KecController::class . ':add')->add(PermissionMiddleware::class)->setName('kec/add-kec-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', KecController::class . ':addopt')->add(PermissionMiddleware::class)->setName('kec/addopt-kec-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{kec_id}]', KecController::class . ':view')->add(PermissionMiddleware::class)->setName('kec/view-kec-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{kec_id}]', KecController::class . ':edit')->add(PermissionMiddleware::class)->setName('kec/edit-kec-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{kec_id}]', KecController::class . ':delete')->add(PermissionMiddleware::class)->setName('kec/delete-kec-delete-2'); // delete
        }
    );

    // kontrak
    $app->map(["GET","POST","OPTIONS"], '/KontrakList[/{k_id}]', KontrakController::class . ':list')->add(PermissionMiddleware::class)->setName('KontrakList-kontrak-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/KontrakAdd[/{k_id}]', KontrakController::class . ':add')->add(PermissionMiddleware::class)->setName('KontrakAdd-kontrak-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/KontrakView[/{k_id}]', KontrakController::class . ':view')->add(PermissionMiddleware::class)->setName('KontrakView-kontrak-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/KontrakEdit[/{k_id}]', KontrakController::class . ':edit')->add(PermissionMiddleware::class)->setName('KontrakEdit-kontrak-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/KontrakDelete[/{k_id}]', KontrakController::class . ':delete')->add(PermissionMiddleware::class)->setName('KontrakDelete-kontrak-delete'); // delete
    $app->group(
        '/kontrak',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{k_id}]', KontrakController::class . ':list')->add(PermissionMiddleware::class)->setName('kontrak/list-kontrak-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{k_id}]', KontrakController::class . ':add')->add(PermissionMiddleware::class)->setName('kontrak/add-kontrak-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{k_id}]', KontrakController::class . ':view')->add(PermissionMiddleware::class)->setName('kontrak/view-kontrak-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{k_id}]', KontrakController::class . ':edit')->add(PermissionMiddleware::class)->setName('kontrak/edit-kontrak-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{k_id}]', KontrakController::class . ':delete')->add(PermissionMiddleware::class)->setName('kontrak/delete-kontrak-delete-2'); // delete
        }
    );

    // koord
    $app->map(["GET","POST","OPTIONS"], '/KoordList[/{koord_id}]', KoordController::class . ':list')->add(PermissionMiddleware::class)->setName('KoordList-koord-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/KoordAdd[/{koord_id}]', KoordController::class . ':add')->add(PermissionMiddleware::class)->setName('KoordAdd-koord-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/KoordAddopt', KoordController::class . ':addopt')->add(PermissionMiddleware::class)->setName('KoordAddopt-koord-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/KoordView[/{koord_id}]', KoordController::class . ':view')->add(PermissionMiddleware::class)->setName('KoordView-koord-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/KoordEdit[/{koord_id}]', KoordController::class . ':edit')->add(PermissionMiddleware::class)->setName('KoordEdit-koord-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/KoordDelete[/{koord_id}]', KoordController::class . ':delete')->add(PermissionMiddleware::class)->setName('KoordDelete-koord-delete'); // delete
    $app->group(
        '/koord',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{koord_id}]', KoordController::class . ':list')->add(PermissionMiddleware::class)->setName('koord/list-koord-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{koord_id}]', KoordController::class . ':add')->add(PermissionMiddleware::class)->setName('koord/add-koord-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', KoordController::class . ':addopt')->add(PermissionMiddleware::class)->setName('koord/addopt-koord-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{koord_id}]', KoordController::class . ':view')->add(PermissionMiddleware::class)->setName('koord/view-koord-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{koord_id}]', KoordController::class . ':edit')->add(PermissionMiddleware::class)->setName('koord/edit-koord-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{koord_id}]', KoordController::class . ':delete')->add(PermissionMiddleware::class)->setName('koord/delete-koord-delete-2'); // delete
        }
    );

    // petani
    $app->map(["GET","POST","OPTIONS"], '/PetaniList[/{pet_id}]', PetaniController::class . ':list')->add(PermissionMiddleware::class)->setName('PetaniList-petani-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/PetaniAdd[/{pet_id}]', PetaniController::class . ':add')->add(PermissionMiddleware::class)->setName('PetaniAdd-petani-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/PetaniAddopt', PetaniController::class . ':addopt')->add(PermissionMiddleware::class)->setName('PetaniAddopt-petani-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/PetaniView[/{pet_id}]', PetaniController::class . ':view')->add(PermissionMiddleware::class)->setName('PetaniView-petani-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/PetaniEdit[/{pet_id}]', PetaniController::class . ':edit')->add(PermissionMiddleware::class)->setName('PetaniEdit-petani-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/PetaniDelete[/{pet_id}]', PetaniController::class . ':delete')->add(PermissionMiddleware::class)->setName('PetaniDelete-petani-delete'); // delete
    $app->group(
        '/petani',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{pet_id}]', PetaniController::class . ':list')->add(PermissionMiddleware::class)->setName('petani/list-petani-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{pet_id}]', PetaniController::class . ':add')->add(PermissionMiddleware::class)->setName('petani/add-petani-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', PetaniController::class . ':addopt')->add(PermissionMiddleware::class)->setName('petani/addopt-petani-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{pet_id}]', PetaniController::class . ':view')->add(PermissionMiddleware::class)->setName('petani/view-petani-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{pet_id}]', PetaniController::class . ':edit')->add(PermissionMiddleware::class)->setName('petani/edit-petani-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{pet_id}]', PetaniController::class . ':delete')->add(PermissionMiddleware::class)->setName('petani/delete-petani-delete-2'); // delete
        }
    );

    // prov
    $app->map(["GET","POST","OPTIONS"], '/ProvList[/{prov_id}]', ProvController::class . ':list')->add(PermissionMiddleware::class)->setName('ProvList-prov-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/ProvAdd[/{prov_id}]', ProvController::class . ':add')->add(PermissionMiddleware::class)->setName('ProvAdd-prov-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/ProvAddopt', ProvController::class . ':addopt')->add(PermissionMiddleware::class)->setName('ProvAddopt-prov-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/ProvView[/{prov_id}]', ProvController::class . ':view')->add(PermissionMiddleware::class)->setName('ProvView-prov-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/ProvEdit[/{prov_id}]', ProvController::class . ':edit')->add(PermissionMiddleware::class)->setName('ProvEdit-prov-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/ProvDelete[/{prov_id}]', ProvController::class . ':delete')->add(PermissionMiddleware::class)->setName('ProvDelete-prov-delete'); // delete
    $app->group(
        '/prov',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{prov_id}]', ProvController::class . ':list')->add(PermissionMiddleware::class)->setName('prov/list-prov-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{prov_id}]', ProvController::class . ':add')->add(PermissionMiddleware::class)->setName('prov/add-prov-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', ProvController::class . ':addopt')->add(PermissionMiddleware::class)->setName('prov/addopt-prov-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{prov_id}]', ProvController::class . ':view')->add(PermissionMiddleware::class)->setName('prov/view-prov-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{prov_id}]', ProvController::class . ':edit')->add(PermissionMiddleware::class)->setName('prov/edit-prov-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{prov_id}]', ProvController::class . ':delete')->add(PermissionMiddleware::class)->setName('prov/delete-prov-delete-2'); // delete
        }
    );

    // varietas
    $app->map(["GET","POST","OPTIONS"], '/VarietasList[/{var_id}]', VarietasController::class . ':list')->add(PermissionMiddleware::class)->setName('VarietasList-varietas-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/VarietasAdd[/{var_id}]', VarietasController::class . ':add')->add(PermissionMiddleware::class)->setName('VarietasAdd-varietas-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/VarietasAddopt', VarietasController::class . ':addopt')->add(PermissionMiddleware::class)->setName('VarietasAddopt-varietas-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/VarietasView[/{var_id}]', VarietasController::class . ':view')->add(PermissionMiddleware::class)->setName('VarietasView-varietas-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/VarietasEdit[/{var_id}]', VarietasController::class . ':edit')->add(PermissionMiddleware::class)->setName('VarietasEdit-varietas-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/VarietasDelete[/{var_id}]', VarietasController::class . ':delete')->add(PermissionMiddleware::class)->setName('VarietasDelete-varietas-delete'); // delete
    $app->group(
        '/varietas',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{var_id}]', VarietasController::class . ':list')->add(PermissionMiddleware::class)->setName('varietas/list-varietas-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{var_id}]', VarietasController::class . ':add')->add(PermissionMiddleware::class)->setName('varietas/add-varietas-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', VarietasController::class . ':addopt')->add(PermissionMiddleware::class)->setName('varietas/addopt-varietas-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{var_id}]', VarietasController::class . ':view')->add(PermissionMiddleware::class)->setName('varietas/view-varietas-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{var_id}]', VarietasController::class . ':edit')->add(PermissionMiddleware::class)->setName('varietas/edit-varietas-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{var_id}]', VarietasController::class . ':delete')->add(PermissionMiddleware::class)->setName('varietas/delete-varietas-delete-2'); // delete
        }
    );

    // employees
    $app->map(["GET","POST","OPTIONS"], '/EmployeesList[/{EmployeeID}]', EmployeesController::class . ':list')->add(PermissionMiddleware::class)->setName('EmployeesList-employees-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/EmployeesAdd[/{EmployeeID}]', EmployeesController::class . ':add')->add(PermissionMiddleware::class)->setName('EmployeesAdd-employees-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/EmployeesView[/{EmployeeID}]', EmployeesController::class . ':view')->add(PermissionMiddleware::class)->setName('EmployeesView-employees-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/EmployeesEdit[/{EmployeeID}]', EmployeesController::class . ':edit')->add(PermissionMiddleware::class)->setName('EmployeesEdit-employees-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/EmployeesDelete[/{EmployeeID}]', EmployeesController::class . ':delete')->add(PermissionMiddleware::class)->setName('EmployeesDelete-employees-delete'); // delete
    $app->group(
        '/employees',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{EmployeeID}]', EmployeesController::class . ':list')->add(PermissionMiddleware::class)->setName('employees/list-employees-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{EmployeeID}]', EmployeesController::class . ':add')->add(PermissionMiddleware::class)->setName('employees/add-employees-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{EmployeeID}]', EmployeesController::class . ':view')->add(PermissionMiddleware::class)->setName('employees/view-employees-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{EmployeeID}]', EmployeesController::class . ':edit')->add(PermissionMiddleware::class)->setName('employees/edit-employees-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{EmployeeID}]', EmployeesController::class . ':delete')->add(PermissionMiddleware::class)->setName('employees/delete-employees-delete-2'); // delete
        }
    );

    // kontrak_koord
    $app->map(["GET","POST","OPTIONS"], '/KontrakKoordList[/{kk_id}]', KontrakKoordController::class . ':list')->add(PermissionMiddleware::class)->setName('KontrakKoordList-kontrak_koord-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/KontrakKoordAdd[/{kk_id}]', KontrakKoordController::class . ':add')->add(PermissionMiddleware::class)->setName('KontrakKoordAdd-kontrak_koord-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/KontrakKoordView[/{kk_id}]', KontrakKoordController::class . ':view')->add(PermissionMiddleware::class)->setName('KontrakKoordView-kontrak_koord-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/KontrakKoordEdit[/{kk_id}]', KontrakKoordController::class . ':edit')->add(PermissionMiddleware::class)->setName('KontrakKoordEdit-kontrak_koord-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/KontrakKoordDelete[/{kk_id}]', KontrakKoordController::class . ':delete')->add(PermissionMiddleware::class)->setName('KontrakKoordDelete-kontrak_koord-delete'); // delete
    $app->group(
        '/kontrak_koord',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{kk_id}]', KontrakKoordController::class . ':list')->add(PermissionMiddleware::class)->setName('kontrak_koord/list-kontrak_koord-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{kk_id}]', KontrakKoordController::class . ':add')->add(PermissionMiddleware::class)->setName('kontrak_koord/add-kontrak_koord-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{kk_id}]', KontrakKoordController::class . ':view')->add(PermissionMiddleware::class)->setName('kontrak_koord/view-kontrak_koord-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{kk_id}]', KontrakKoordController::class . ':edit')->add(PermissionMiddleware::class)->setName('kontrak_koord/edit-kontrak_koord-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{kk_id}]', KontrakKoordController::class . ':delete')->add(PermissionMiddleware::class)->setName('kontrak_koord/delete-kontrak_koord-delete-2'); // delete
        }
    );

    // userlevelpermissions
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsList[/{keys:.*}]', UserlevelpermissionsController::class . ':list')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsList-userlevelpermissions-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsAdd[/{keys:.*}]', UserlevelpermissionsController::class . ':add')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsAdd-userlevelpermissions-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsView[/{keys:.*}]', UserlevelpermissionsController::class . ':view')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsView-userlevelpermissions-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsEdit[/{keys:.*}]', UserlevelpermissionsController::class . ':edit')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsEdit-userlevelpermissions-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/UserlevelpermissionsDelete[/{keys:.*}]', UserlevelpermissionsController::class . ':delete')->add(PermissionMiddleware::class)->setName('UserlevelpermissionsDelete-userlevelpermissions-delete'); // delete
    $app->group(
        '/userlevelpermissions',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{keys:.*}]', UserlevelpermissionsController::class . ':list')->add(PermissionMiddleware::class)->setName('userlevelpermissions/list-userlevelpermissions-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{keys:.*}]', UserlevelpermissionsController::class . ':add')->add(PermissionMiddleware::class)->setName('userlevelpermissions/add-userlevelpermissions-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{keys:.*}]', UserlevelpermissionsController::class . ':view')->add(PermissionMiddleware::class)->setName('userlevelpermissions/view-userlevelpermissions-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{keys:.*}]', UserlevelpermissionsController::class . ':edit')->add(PermissionMiddleware::class)->setName('userlevelpermissions/edit-userlevelpermissions-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{keys:.*}]', UserlevelpermissionsController::class . ':delete')->add(PermissionMiddleware::class)->setName('userlevelpermissions/delete-userlevelpermissions-delete-2'); // delete
        }
    );

    // userlevels
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsList[/{userlevelid}]', UserlevelsController::class . ':list')->add(PermissionMiddleware::class)->setName('UserlevelsList-userlevels-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsAdd[/{userlevelid}]', UserlevelsController::class . ':add')->add(PermissionMiddleware::class)->setName('UserlevelsAdd-userlevels-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsView[/{userlevelid}]', UserlevelsController::class . ':view')->add(PermissionMiddleware::class)->setName('UserlevelsView-userlevels-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsEdit[/{userlevelid}]', UserlevelsController::class . ':edit')->add(PermissionMiddleware::class)->setName('UserlevelsEdit-userlevels-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/UserlevelsDelete[/{userlevelid}]', UserlevelsController::class . ':delete')->add(PermissionMiddleware::class)->setName('UserlevelsDelete-userlevels-delete'); // delete
    $app->group(
        '/userlevels',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{userlevelid}]', UserlevelsController::class . ':list')->add(PermissionMiddleware::class)->setName('userlevels/list-userlevels-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{userlevelid}]', UserlevelsController::class . ':add')->add(PermissionMiddleware::class)->setName('userlevels/add-userlevels-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{userlevelid}]', UserlevelsController::class . ':view')->add(PermissionMiddleware::class)->setName('userlevels/view-userlevels-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{userlevelid}]', UserlevelsController::class . ':edit')->add(PermissionMiddleware::class)->setName('userlevels/edit-userlevels-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{userlevelid}]', UserlevelsController::class . ':delete')->add(PermissionMiddleware::class)->setName('userlevels/delete-userlevels-delete-2'); // delete
        }
    );

    // luasview
    $app->map(["GET", "POST", "OPTIONS"], '/LuasviewList/Chart1', LuasviewController::class . ':Chart1')->add(PermissionMiddleware::class)->setName('LuasviewList-luasview-list-Chart1'); // Chart1
    $app->map(["GET", "POST", "OPTIONS"], '/LuasviewList/Chart2', LuasviewController::class . ':Chart2')->add(PermissionMiddleware::class)->setName('LuasviewList-luasview-list-Chart2'); // Chart2
    $app->map(["GET","POST","OPTIONS"], '/LuasviewList', LuasviewController::class . ':list')->add(PermissionMiddleware::class)->setName('LuasviewList-luasview-list'); // list
    $app->group(
        '/luasview',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '', LuasviewController::class . ':list')->add(PermissionMiddleware::class)->setName('luasview/list-luasview-list-2'); // list
        }
    );

    // bulan
    $app->map(["GET","POST","OPTIONS"], '/BulanList[/{id}]', BulanController::class . ':list')->add(PermissionMiddleware::class)->setName('BulanList-bulan-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/BulanAdd[/{id}]', BulanController::class . ':add')->add(PermissionMiddleware::class)->setName('BulanAdd-bulan-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/BulanView[/{id}]', BulanController::class . ':view')->add(PermissionMiddleware::class)->setName('BulanView-bulan-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/BulanEdit[/{id}]', BulanController::class . ':edit')->add(PermissionMiddleware::class)->setName('BulanEdit-bulan-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/BulanDelete[/{id}]', BulanController::class . ':delete')->add(PermissionMiddleware::class)->setName('BulanDelete-bulan-delete'); // delete
    $app->group(
        '/bulan',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{id}]', BulanController::class . ':list')->add(PermissionMiddleware::class)->setName('bulan/list-bulan-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{id}]', BulanController::class . ':add')->add(PermissionMiddleware::class)->setName('bulan/add-bulan-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{id}]', BulanController::class . ':view')->add(PermissionMiddleware::class)->setName('bulan/view-bulan-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{id}]', BulanController::class . ':edit')->add(PermissionMiddleware::class)->setName('bulan/edit-bulan-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{id}]', BulanController::class . ':delete')->add(PermissionMiddleware::class)->setName('bulan/delete-bulan-delete-2'); // delete
        }
    );

    // peserta
    $app->map(["GET","POST","OPTIONS"], '/PesertaList[/{pes_id}]', PesertaController::class . ':list')->add(PermissionMiddleware::class)->setName('PesertaList-peserta-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/PesertaAdd[/{pes_id}]', PesertaController::class . ':add')->add(PermissionMiddleware::class)->setName('PesertaAdd-peserta-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/PesertaAddopt', PesertaController::class . ':addopt')->add(PermissionMiddleware::class)->setName('PesertaAddopt-peserta-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/PesertaView[/{pes_id}]', PesertaController::class . ':view')->add(PermissionMiddleware::class)->setName('PesertaView-peserta-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/PesertaEdit[/{pes_id}]', PesertaController::class . ':edit')->add(PermissionMiddleware::class)->setName('PesertaEdit-peserta-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/PesertaDelete[/{pes_id}]', PesertaController::class . ':delete')->add(PermissionMiddleware::class)->setName('PesertaDelete-peserta-delete'); // delete
    $app->group(
        '/peserta',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{pes_id}]', PesertaController::class . ':list')->add(PermissionMiddleware::class)->setName('peserta/list-peserta-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{pes_id}]', PesertaController::class . ':add')->add(PermissionMiddleware::class)->setName('peserta/add-peserta-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', PesertaController::class . ':addopt')->add(PermissionMiddleware::class)->setName('peserta/addopt-peserta-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{pes_id}]', PesertaController::class . ':view')->add(PermissionMiddleware::class)->setName('peserta/view-peserta-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{pes_id}]', PesertaController::class . ':edit')->add(PermissionMiddleware::class)->setName('peserta/edit-peserta-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{pes_id}]', PesertaController::class . ':delete')->add(PermissionMiddleware::class)->setName('peserta/delete-peserta-delete-2'); // delete
        }
    );

    // sosialisasi
    $app->map(["GET","POST","OPTIONS"], '/SosialisasiList[/{sos_id}]', SosialisasiController::class . ':list')->add(PermissionMiddleware::class)->setName('SosialisasiList-sosialisasi-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/SosialisasiAdd[/{sos_id}]', SosialisasiController::class . ':add')->add(PermissionMiddleware::class)->setName('SosialisasiAdd-sosialisasi-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/SosialisasiAddopt', SosialisasiController::class . ':addopt')->add(PermissionMiddleware::class)->setName('SosialisasiAddopt-sosialisasi-addopt'); // addopt
    $app->map(["GET","POST","OPTIONS"], '/SosialisasiView[/{sos_id}]', SosialisasiController::class . ':view')->add(PermissionMiddleware::class)->setName('SosialisasiView-sosialisasi-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/SosialisasiEdit[/{sos_id}]', SosialisasiController::class . ':edit')->add(PermissionMiddleware::class)->setName('SosialisasiEdit-sosialisasi-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/SosialisasiDelete[/{sos_id}]', SosialisasiController::class . ':delete')->add(PermissionMiddleware::class)->setName('SosialisasiDelete-sosialisasi-delete'); // delete
    $app->group(
        '/sosialisasi',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{sos_id}]', SosialisasiController::class . ':list')->add(PermissionMiddleware::class)->setName('sosialisasi/list-sosialisasi-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{sos_id}]', SosialisasiController::class . ':add')->add(PermissionMiddleware::class)->setName('sosialisasi/add-sosialisasi-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADDOPT_ACTION') . '', SosialisasiController::class . ':addopt')->add(PermissionMiddleware::class)->setName('sosialisasi/addopt-sosialisasi-addopt-2'); // addopt
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{sos_id}]', SosialisasiController::class . ':view')->add(PermissionMiddleware::class)->setName('sosialisasi/view-sosialisasi-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{sos_id}]', SosialisasiController::class . ':edit')->add(PermissionMiddleware::class)->setName('sosialisasi/edit-sosialisasi-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{sos_id}]', SosialisasiController::class . ':delete')->add(PermissionMiddleware::class)->setName('sosialisasi/delete-sosialisasi-delete-2'); // delete
        }
    );

    // kegiatan_harian
    $app->map(["GET","POST","OPTIONS"], '/KegiatanHarianList[/{kh_id}]', KegiatanHarianController::class . ':list')->add(PermissionMiddleware::class)->setName('KegiatanHarianList-kegiatan_harian-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/KegiatanHarianAdd[/{kh_id}]', KegiatanHarianController::class . ':add')->add(PermissionMiddleware::class)->setName('KegiatanHarianAdd-kegiatan_harian-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/KegiatanHarianView[/{kh_id}]', KegiatanHarianController::class . ':view')->add(PermissionMiddleware::class)->setName('KegiatanHarianView-kegiatan_harian-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/KegiatanHarianEdit[/{kh_id}]', KegiatanHarianController::class . ':edit')->add(PermissionMiddleware::class)->setName('KegiatanHarianEdit-kegiatan_harian-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/KegiatanHarianDelete[/{kh_id}]', KegiatanHarianController::class . ':delete')->add(PermissionMiddleware::class)->setName('KegiatanHarianDelete-kegiatan_harian-delete'); // delete
    $app->group(
        '/kegiatan_harian',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{kh_id}]', KegiatanHarianController::class . ':list')->add(PermissionMiddleware::class)->setName('kegiatan_harian/list-kegiatan_harian-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{kh_id}]', KegiatanHarianController::class . ':add')->add(PermissionMiddleware::class)->setName('kegiatan_harian/add-kegiatan_harian-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{kh_id}]', KegiatanHarianController::class . ':view')->add(PermissionMiddleware::class)->setName('kegiatan_harian/view-kegiatan_harian-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{kh_id}]', KegiatanHarianController::class . ':edit')->add(PermissionMiddleware::class)->setName('kegiatan_harian/edit-kegiatan_harian-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{kh_id}]', KegiatanHarianController::class . ':delete')->add(PermissionMiddleware::class)->setName('kegiatan_harian/delete-kegiatan_harian-delete-2'); // delete
        }
    );

    // order_bibit
    $app->map(["GET","POST","OPTIONS"], '/OrderBibitList[/{ob_id}]', OrderBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('OrderBibitList-order_bibit-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/OrderBibitAdd[/{ob_id}]', OrderBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('OrderBibitAdd-order_bibit-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/OrderBibitView[/{ob_id}]', OrderBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('OrderBibitView-order_bibit-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/OrderBibitEdit[/{ob_id}]', OrderBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('OrderBibitEdit-order_bibit-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/OrderBibitDelete[/{ob_id}]', OrderBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('OrderBibitDelete-order_bibit-delete'); // delete
    $app->group(
        '/order_bibit',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{ob_id}]', OrderBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('order_bibit/list-order_bibit-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{ob_id}]', OrderBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('order_bibit/add-order_bibit-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{ob_id}]', OrderBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('order_bibit/view-order_bibit-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{ob_id}]', OrderBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('order_bibit/edit-order_bibit-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{ob_id}]', OrderBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('order_bibit/delete-order_bibit-delete-2'); // delete
        }
    );

    // estimasi_bibit
    $app->map(["GET","POST","OPTIONS"], '/EstimasiBibitList[/{id}]', EstimasiBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('EstimasiBibitList-estimasi_bibit-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/EstimasiBibitAdd[/{id}]', EstimasiBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('EstimasiBibitAdd-estimasi_bibit-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/EstimasiBibitView[/{id}]', EstimasiBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('EstimasiBibitView-estimasi_bibit-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/EstimasiBibitEdit[/{id}]', EstimasiBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('EstimasiBibitEdit-estimasi_bibit-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/EstimasiBibitDelete[/{id}]', EstimasiBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('EstimasiBibitDelete-estimasi_bibit-delete'); // delete
    $app->group(
        '/estimasi_bibit',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{id}]', EstimasiBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('estimasi_bibit/list-estimasi_bibit-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{id}]', EstimasiBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('estimasi_bibit/add-estimasi_bibit-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{id}]', EstimasiBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('estimasi_bibit/view-estimasi_bibit-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{id}]', EstimasiBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('estimasi_bibit/edit-estimasi_bibit-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{id}]', EstimasiBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('estimasi_bibit/delete-estimasi_bibit-delete-2'); // delete
        }
    );

    // tanam_bibit
    $app->map(["GET","POST","OPTIONS"], '/TanamBibitList[/{id}]', TanamBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('TanamBibitList-tanam_bibit-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/TanamBibitAdd[/{id}]', TanamBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('TanamBibitAdd-tanam_bibit-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/TanamBibitView[/{id}]', TanamBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('TanamBibitView-tanam_bibit-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/TanamBibitEdit[/{id}]', TanamBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('TanamBibitEdit-tanam_bibit-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/TanamBibitDelete[/{id}]', TanamBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('TanamBibitDelete-tanam_bibit-delete'); // delete
    $app->group(
        '/tanam_bibit',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{id}]', TanamBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('tanam_bibit/list-tanam_bibit-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{id}]', TanamBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('tanam_bibit/add-tanam_bibit-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{id}]', TanamBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('tanam_bibit/view-tanam_bibit-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{id}]', TanamBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('tanam_bibit/edit-tanam_bibit-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{id}]', TanamBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('tanam_bibit/delete-tanam_bibit-delete-2'); // delete
        }
    );

    // status_order_bibit
    $app->map(["GET","POST","OPTIONS"], '/StatusOrderBibitList[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('StatusOrderBibitList-status_order_bibit-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/StatusOrderBibitAdd[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('StatusOrderBibitAdd-status_order_bibit-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/StatusOrderBibitView[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('StatusOrderBibitView-status_order_bibit-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/StatusOrderBibitEdit[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('StatusOrderBibitEdit-status_order_bibit-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/StatusOrderBibitDelete[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('StatusOrderBibitDelete-status_order_bibit-delete'); // delete
    $app->group(
        '/status_order_bibit',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('status_order_bibit/list-status_order_bibit-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('status_order_bibit/add-status_order_bibit-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('status_order_bibit/view-status_order_bibit-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('status_order_bibit/edit-status_order_bibit-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{status_order_bibit:.*}]', StatusOrderBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('status_order_bibit/delete-status_order_bibit-delete-2'); // delete
        }
    );

    // jenis_lahan_bibit
    $app->map(["GET","POST","OPTIONS"], '/JenisLahanBibitList[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('JenisLahanBibitList-jenis_lahan_bibit-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/JenisLahanBibitAdd[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('JenisLahanBibitAdd-jenis_lahan_bibit-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/JenisLahanBibitView[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('JenisLahanBibitView-jenis_lahan_bibit-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/JenisLahanBibitEdit[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('JenisLahanBibitEdit-jenis_lahan_bibit-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/JenisLahanBibitDelete[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('JenisLahanBibitDelete-jenis_lahan_bibit-delete'); // delete
    $app->group(
        '/jenis_lahan_bibit',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('jenis_lahan_bibit/list-jenis_lahan_bibit-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('jenis_lahan_bibit/add-jenis_lahan_bibit-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('jenis_lahan_bibit/view-jenis_lahan_bibit-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('jenis_lahan_bibit/edit-jenis_lahan_bibit-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{jenis_lahan_bibit:.*}]', JenisLahanBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('jenis_lahan_bibit/delete-jenis_lahan_bibit-delete-2'); // delete
        }
    );

    // generasi_bibit
    $app->map(["GET","POST","OPTIONS"], '/GenerasiBibitList[/{id_gen:.*}]', GenerasiBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('GenerasiBibitList-generasi_bibit-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/GenerasiBibitAdd[/{id_gen:.*}]', GenerasiBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('GenerasiBibitAdd-generasi_bibit-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/GenerasiBibitView[/{id_gen:.*}]', GenerasiBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('GenerasiBibitView-generasi_bibit-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/GenerasiBibitEdit[/{id_gen:.*}]', GenerasiBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('GenerasiBibitEdit-generasi_bibit-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/GenerasiBibitDelete[/{id_gen:.*}]', GenerasiBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('GenerasiBibitDelete-generasi_bibit-delete'); // delete
    $app->group(
        '/generasi_bibit',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{id_gen:.*}]', GenerasiBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('generasi_bibit/list-generasi_bibit-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{id_gen:.*}]', GenerasiBibitController::class . ':add')->add(PermissionMiddleware::class)->setName('generasi_bibit/add-generasi_bibit-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{id_gen:.*}]', GenerasiBibitController::class . ':view')->add(PermissionMiddleware::class)->setName('generasi_bibit/view-generasi_bibit-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{id_gen:.*}]', GenerasiBibitController::class . ':edit')->add(PermissionMiddleware::class)->setName('generasi_bibit/edit-generasi_bibit-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{id_gen:.*}]', GenerasiBibitController::class . ':delete')->add(PermissionMiddleware::class)->setName('generasi_bibit/delete-generasi_bibit-delete-2'); // delete
        }
    );

    // bibit
    $app->map(["GET","POST","OPTIONS"], '/BibitList[/{id}]', BibitController::class . ':list')->add(PermissionMiddleware::class)->setName('BibitList-bibit-list'); // list
    $app->group(
        '/bibit',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{id}]', BibitController::class . ':list')->add(PermissionMiddleware::class)->setName('bibit/list-bibit-list-2'); // list
        }
    );

    // hirarki_bibit
    $app->map(["GET","POST","OPTIONS"], '/HirarkiBibitList', HirarkiBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('HirarkiBibitList-hirarki_bibit-list'); // list
    $app->group(
        '/hirarki_bibit',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '', HirarkiBibitController::class . ':list')->add(PermissionMiddleware::class)->setName('hirarki_bibit/list-hirarki_bibit-list-2'); // list
        }
    );

    // datang_sumber
    $app->map(["GET","POST","OPTIONS"], '/DatangSumberList[/{ds_id}]', DatangSumberController::class . ':list')->add(PermissionMiddleware::class)->setName('DatangSumberList-datang_sumber-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/DatangSumberAdd[/{ds_id}]', DatangSumberController::class . ':add')->add(PermissionMiddleware::class)->setName('DatangSumberAdd-datang_sumber-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/DatangSumberView[/{ds_id}]', DatangSumberController::class . ':view')->add(PermissionMiddleware::class)->setName('DatangSumberView-datang_sumber-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/DatangSumberEdit[/{ds_id}]', DatangSumberController::class . ':edit')->add(PermissionMiddleware::class)->setName('DatangSumberEdit-datang_sumber-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/DatangSumberDelete[/{ds_id}]', DatangSumberController::class . ':delete')->add(PermissionMiddleware::class)->setName('DatangSumberDelete-datang_sumber-delete'); // delete
    $app->group(
        '/datang_sumber',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{ds_id}]', DatangSumberController::class . ':list')->add(PermissionMiddleware::class)->setName('datang_sumber/list-datang_sumber-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{ds_id}]', DatangSumberController::class . ':add')->add(PermissionMiddleware::class)->setName('datang_sumber/add-datang_sumber-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{ds_id}]', DatangSumberController::class . ':view')->add(PermissionMiddleware::class)->setName('datang_sumber/view-datang_sumber-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{ds_id}]', DatangSumberController::class . ':edit')->add(PermissionMiddleware::class)->setName('datang_sumber/edit-datang_sumber-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{ds_id}]', DatangSumberController::class . ':delete')->add(PermissionMiddleware::class)->setName('datang_sumber/delete-datang_sumber-delete-2'); // delete
        }
    );

    // kedatangan
    $app->map(["GET","POST","OPTIONS"], '/KedatanganList[/{datang_id}]', KedatanganController::class . ':list')->add(PermissionMiddleware::class)->setName('KedatanganList-kedatangan-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/KedatanganAdd[/{datang_id}]', KedatanganController::class . ':add')->add(PermissionMiddleware::class)->setName('KedatanganAdd-kedatangan-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/KedatanganView[/{datang_id}]', KedatanganController::class . ':view')->add(PermissionMiddleware::class)->setName('KedatanganView-kedatangan-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/KedatanganEdit[/{datang_id}]', KedatanganController::class . ':edit')->add(PermissionMiddleware::class)->setName('KedatanganEdit-kedatangan-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/KedatanganDelete[/{datang_id}]', KedatanganController::class . ':delete')->add(PermissionMiddleware::class)->setName('KedatanganDelete-kedatangan-delete'); // delete
    $app->group(
        '/kedatangan',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{datang_id}]', KedatanganController::class . ':list')->add(PermissionMiddleware::class)->setName('kedatangan/list-kedatangan-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{datang_id}]', KedatanganController::class . ':add')->add(PermissionMiddleware::class)->setName('kedatangan/add-kedatangan-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{datang_id}]', KedatanganController::class . ':view')->add(PermissionMiddleware::class)->setName('kedatangan/view-kedatangan-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{datang_id}]', KedatanganController::class . ':edit')->add(PermissionMiddleware::class)->setName('kedatangan/edit-kedatangan-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{datang_id}]', KedatanganController::class . ':delete')->add(PermissionMiddleware::class)->setName('kedatangan/delete-kedatangan-delete-2'); // delete
        }
    );

    // qc
    $app->map(["GET","POST","OPTIONS"], '/QcList[/{qc_id}]', QcController::class . ':list')->add(PermissionMiddleware::class)->setName('QcList-qc-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/QcAdd[/{qc_id}]', QcController::class . ':add')->add(PermissionMiddleware::class)->setName('QcAdd-qc-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/QcView[/{qc_id}]', QcController::class . ':view')->add(PermissionMiddleware::class)->setName('QcView-qc-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/QcEdit[/{qc_id}]', QcController::class . ':edit')->add(PermissionMiddleware::class)->setName('QcEdit-qc-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/QcDelete[/{qc_id}]', QcController::class . ':delete')->add(PermissionMiddleware::class)->setName('QcDelete-qc-delete'); // delete
    $app->group(
        '/qc',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{qc_id}]', QcController::class . ':list')->add(PermissionMiddleware::class)->setName('qc/list-qc-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{qc_id}]', QcController::class . ':add')->add(PermissionMiddleware::class)->setName('qc/add-qc-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{qc_id}]', QcController::class . ':view')->add(PermissionMiddleware::class)->setName('qc/view-qc-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{qc_id}]', QcController::class . ':edit')->add(PermissionMiddleware::class)->setName('qc/edit-qc-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{qc_id}]', QcController::class . ':delete')->add(PermissionMiddleware::class)->setName('qc/delete-qc-delete-2'); // delete
        }
    );

    // suplaiyer_ubi
    $app->map(["GET","POST","OPTIONS"], '/SuplaiyerUbiList[/{sup_id}]', SuplaiyerUbiController::class . ':list')->add(PermissionMiddleware::class)->setName('SuplaiyerUbiList-suplaiyer_ubi-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/SuplaiyerUbiAdd[/{sup_id}]', SuplaiyerUbiController::class . ':add')->add(PermissionMiddleware::class)->setName('SuplaiyerUbiAdd-suplaiyer_ubi-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/SuplaiyerUbiView[/{sup_id}]', SuplaiyerUbiController::class . ':view')->add(PermissionMiddleware::class)->setName('SuplaiyerUbiView-suplaiyer_ubi-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/SuplaiyerUbiEdit[/{sup_id}]', SuplaiyerUbiController::class . ':edit')->add(PermissionMiddleware::class)->setName('SuplaiyerUbiEdit-suplaiyer_ubi-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/SuplaiyerUbiDelete[/{sup_id}]', SuplaiyerUbiController::class . ':delete')->add(PermissionMiddleware::class)->setName('SuplaiyerUbiDelete-suplaiyer_ubi-delete'); // delete
    $app->group(
        '/suplaiyer_ubi',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{sup_id}]', SuplaiyerUbiController::class . ':list')->add(PermissionMiddleware::class)->setName('suplaiyer_ubi/list-suplaiyer_ubi-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{sup_id}]', SuplaiyerUbiController::class . ':add')->add(PermissionMiddleware::class)->setName('suplaiyer_ubi/add-suplaiyer_ubi-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{sup_id}]', SuplaiyerUbiController::class . ':view')->add(PermissionMiddleware::class)->setName('suplaiyer_ubi/view-suplaiyer_ubi-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{sup_id}]', SuplaiyerUbiController::class . ':edit')->add(PermissionMiddleware::class)->setName('suplaiyer_ubi/edit-suplaiyer_ubi-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{sup_id}]', SuplaiyerUbiController::class . ':delete')->add(PermissionMiddleware::class)->setName('suplaiyer_ubi/delete-suplaiyer_ubi-delete-2'); // delete
        }
    );

    // tingkat_resiko
    $app->map(["GET","POST","OPTIONS"], '/TingkatResikoList[/{tr_id}]', TingkatResikoController::class . ':list')->add(PermissionMiddleware::class)->setName('TingkatResikoList-tingkat_resiko-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/TingkatResikoAdd[/{tr_id}]', TingkatResikoController::class . ':add')->add(PermissionMiddleware::class)->setName('TingkatResikoAdd-tingkat_resiko-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/TingkatResikoView[/{tr_id}]', TingkatResikoController::class . ':view')->add(PermissionMiddleware::class)->setName('TingkatResikoView-tingkat_resiko-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/TingkatResikoEdit[/{tr_id}]', TingkatResikoController::class . ':edit')->add(PermissionMiddleware::class)->setName('TingkatResikoEdit-tingkat_resiko-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/TingkatResikoDelete[/{tr_id}]', TingkatResikoController::class . ':delete')->add(PermissionMiddleware::class)->setName('TingkatResikoDelete-tingkat_resiko-delete'); // delete
    $app->group(
        '/tingkat_resiko',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{tr_id}]', TingkatResikoController::class . ':list')->add(PermissionMiddleware::class)->setName('tingkat_resiko/list-tingkat_resiko-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{tr_id}]', TingkatResikoController::class . ':add')->add(PermissionMiddleware::class)->setName('tingkat_resiko/add-tingkat_resiko-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{tr_id}]', TingkatResikoController::class . ':view')->add(PermissionMiddleware::class)->setName('tingkat_resiko/view-tingkat_resiko-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{tr_id}]', TingkatResikoController::class . ':edit')->add(PermissionMiddleware::class)->setName('tingkat_resiko/edit-tingkat_resiko-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{tr_id}]', TingkatResikoController::class . ':delete')->add(PermissionMiddleware::class)->setName('tingkat_resiko/delete-tingkat_resiko-delete-2'); // delete
        }
    );

    // verifikasi
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiList[/{ver_id}]', VerifikasiController::class . ':list')->add(PermissionMiddleware::class)->setName('VerifikasiList-verifikasi-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiAdd[/{ver_id}]', VerifikasiController::class . ':add')->add(PermissionMiddleware::class)->setName('VerifikasiAdd-verifikasi-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiView[/{ver_id}]', VerifikasiController::class . ':view')->add(PermissionMiddleware::class)->setName('VerifikasiView-verifikasi-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiEdit[/{ver_id}]', VerifikasiController::class . ':edit')->add(PermissionMiddleware::class)->setName('VerifikasiEdit-verifikasi-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiDelete[/{ver_id}]', VerifikasiController::class . ':delete')->add(PermissionMiddleware::class)->setName('VerifikasiDelete-verifikasi-delete'); // delete
    $app->group(
        '/verifikasi',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{ver_id}]', VerifikasiController::class . ':list')->add(PermissionMiddleware::class)->setName('verifikasi/list-verifikasi-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{ver_id}]', VerifikasiController::class . ':add')->add(PermissionMiddleware::class)->setName('verifikasi/add-verifikasi-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{ver_id}]', VerifikasiController::class . ':view')->add(PermissionMiddleware::class)->setName('verifikasi/view-verifikasi-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{ver_id}]', VerifikasiController::class . ':edit')->add(PermissionMiddleware::class)->setName('verifikasi/edit-verifikasi-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{ver_id}]', VerifikasiController::class . ':delete')->add(PermissionMiddleware::class)->setName('verifikasi/delete-verifikasi-delete-2'); // delete
        }
    );

    // verifikasi_hasil
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiHasilList[/{vh_id:.*}]', VerifikasiHasilController::class . ':list')->add(PermissionMiddleware::class)->setName('VerifikasiHasilList-verifikasi_hasil-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiHasilAdd[/{vh_id:.*}]', VerifikasiHasilController::class . ':add')->add(PermissionMiddleware::class)->setName('VerifikasiHasilAdd-verifikasi_hasil-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiHasilView[/{vh_id:.*}]', VerifikasiHasilController::class . ':view')->add(PermissionMiddleware::class)->setName('VerifikasiHasilView-verifikasi_hasil-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiHasilEdit[/{vh_id:.*}]', VerifikasiHasilController::class . ':edit')->add(PermissionMiddleware::class)->setName('VerifikasiHasilEdit-verifikasi_hasil-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/VerifikasiHasilDelete[/{vh_id:.*}]', VerifikasiHasilController::class . ':delete')->add(PermissionMiddleware::class)->setName('VerifikasiHasilDelete-verifikasi_hasil-delete'); // delete
    $app->group(
        '/verifikasi_hasil',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{vh_id:.*}]', VerifikasiHasilController::class . ':list')->add(PermissionMiddleware::class)->setName('verifikasi_hasil/list-verifikasi_hasil-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{vh_id:.*}]', VerifikasiHasilController::class . ':add')->add(PermissionMiddleware::class)->setName('verifikasi_hasil/add-verifikasi_hasil-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{vh_id:.*}]', VerifikasiHasilController::class . ':view')->add(PermissionMiddleware::class)->setName('verifikasi_hasil/view-verifikasi_hasil-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{vh_id:.*}]', VerifikasiHasilController::class . ':edit')->add(PermissionMiddleware::class)->setName('verifikasi_hasil/edit-verifikasi_hasil-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{vh_id:.*}]', VerifikasiHasilController::class . ':delete')->add(PermissionMiddleware::class)->setName('verifikasi_hasil/delete-verifikasi_hasil-delete-2'); // delete
        }
    );

    // tema_sosialisasi
    $app->map(["GET","POST","OPTIONS"], '/TemaSosialisasiList[/{ts_id}]', TemaSosialisasiController::class . ':list')->add(PermissionMiddleware::class)->setName('TemaSosialisasiList-tema_sosialisasi-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/TemaSosialisasiAdd[/{ts_id}]', TemaSosialisasiController::class . ':add')->add(PermissionMiddleware::class)->setName('TemaSosialisasiAdd-tema_sosialisasi-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/TemaSosialisasiView[/{ts_id}]', TemaSosialisasiController::class . ':view')->add(PermissionMiddleware::class)->setName('TemaSosialisasiView-tema_sosialisasi-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/TemaSosialisasiEdit[/{ts_id}]', TemaSosialisasiController::class . ':edit')->add(PermissionMiddleware::class)->setName('TemaSosialisasiEdit-tema_sosialisasi-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/TemaSosialisasiDelete[/{ts_id}]', TemaSosialisasiController::class . ':delete')->add(PermissionMiddleware::class)->setName('TemaSosialisasiDelete-tema_sosialisasi-delete'); // delete
    $app->group(
        '/tema_sosialisasi',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{ts_id}]', TemaSosialisasiController::class . ':list')->add(PermissionMiddleware::class)->setName('tema_sosialisasi/list-tema_sosialisasi-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{ts_id}]', TemaSosialisasiController::class . ':add')->add(PermissionMiddleware::class)->setName('tema_sosialisasi/add-tema_sosialisasi-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{ts_id}]', TemaSosialisasiController::class . ':view')->add(PermissionMiddleware::class)->setName('tema_sosialisasi/view-tema_sosialisasi-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{ts_id}]', TemaSosialisasiController::class . ':edit')->add(PermissionMiddleware::class)->setName('tema_sosialisasi/edit-tema_sosialisasi-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{ts_id}]', TemaSosialisasiController::class . ':delete')->add(PermissionMiddleware::class)->setName('tema_sosialisasi/delete-tema_sosialisasi-delete-2'); // delete
        }
    );

    // penggunaan_pestisida
    $app->map(["GET","POST","OPTIONS"], '/PenggunaanPestisidaList[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':list')->add(PermissionMiddleware::class)->setName('PenggunaanPestisidaList-penggunaan_pestisida-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/PenggunaanPestisidaAdd[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':add')->add(PermissionMiddleware::class)->setName('PenggunaanPestisidaAdd-penggunaan_pestisida-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/PenggunaanPestisidaView[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':view')->add(PermissionMiddleware::class)->setName('PenggunaanPestisidaView-penggunaan_pestisida-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/PenggunaanPestisidaEdit[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':edit')->add(PermissionMiddleware::class)->setName('PenggunaanPestisidaEdit-penggunaan_pestisida-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/PenggunaanPestisidaDelete[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':delete')->add(PermissionMiddleware::class)->setName('PenggunaanPestisidaDelete-penggunaan_pestisida-delete'); // delete
    $app->group(
        '/penggunaan_pestisida',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':list')->add(PermissionMiddleware::class)->setName('penggunaan_pestisida/list-penggunaan_pestisida-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':add')->add(PermissionMiddleware::class)->setName('penggunaan_pestisida/add-penggunaan_pestisida-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':view')->add(PermissionMiddleware::class)->setName('penggunaan_pestisida/view-penggunaan_pestisida-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':edit')->add(PermissionMiddleware::class)->setName('penggunaan_pestisida/edit-penggunaan_pestisida-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{ID_Penggunan}]', PenggunaanPestisidaController::class . ':delete')->add(PermissionMiddleware::class)->setName('penggunaan_pestisida/delete-penggunaan_pestisida-delete-2'); // delete
        }
    );

    // view5
    $app->map(["GET","POST","OPTIONS"], '/View5List', View5Controller::class . ':list')->add(PermissionMiddleware::class)->setName('View5List-view5-list'); // list
    $app->group(
        '/view5',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '', View5Controller::class . ':list')->add(PermissionMiddleware::class)->setName('view5/list-view5-list-2'); // list
        }
    );

    // merek_pestisida
    $app->map(["GET","POST","OPTIONS"], '/MerekPestisidaList[/{mp_id}]', MerekPestisidaController::class . ':list')->add(PermissionMiddleware::class)->setName('MerekPestisidaList-merek_pestisida-list'); // list
    $app->map(["GET","POST","OPTIONS"], '/MerekPestisidaAdd[/{mp_id}]', MerekPestisidaController::class . ':add')->add(PermissionMiddleware::class)->setName('MerekPestisidaAdd-merek_pestisida-add'); // add
    $app->map(["GET","POST","OPTIONS"], '/MerekPestisidaView[/{mp_id}]', MerekPestisidaController::class . ':view')->add(PermissionMiddleware::class)->setName('MerekPestisidaView-merek_pestisida-view'); // view
    $app->map(["GET","POST","OPTIONS"], '/MerekPestisidaEdit[/{mp_id}]', MerekPestisidaController::class . ':edit')->add(PermissionMiddleware::class)->setName('MerekPestisidaEdit-merek_pestisida-edit'); // edit
    $app->map(["GET","POST","OPTIONS"], '/MerekPestisidaDelete[/{mp_id}]', MerekPestisidaController::class . ':delete')->add(PermissionMiddleware::class)->setName('MerekPestisidaDelete-merek_pestisida-delete'); // delete
    $app->group(
        '/merek_pestisida',
        function (RouteCollectorProxy $group) {
            $group->map(["GET","POST","OPTIONS"], '/' . Config('LIST_ACTION') . '[/{mp_id}]', MerekPestisidaController::class . ':list')->add(PermissionMiddleware::class)->setName('merek_pestisida/list-merek_pestisida-list-2'); // list
            $group->map(["GET","POST","OPTIONS"], '/' . Config('ADD_ACTION') . '[/{mp_id}]', MerekPestisidaController::class . ':add')->add(PermissionMiddleware::class)->setName('merek_pestisida/add-merek_pestisida-add-2'); // add
            $group->map(["GET","POST","OPTIONS"], '/' . Config('VIEW_ACTION') . '[/{mp_id}]', MerekPestisidaController::class . ':view')->add(PermissionMiddleware::class)->setName('merek_pestisida/view-merek_pestisida-view-2'); // view
            $group->map(["GET","POST","OPTIONS"], '/' . Config('EDIT_ACTION') . '[/{mp_id}]', MerekPestisidaController::class . ':edit')->add(PermissionMiddleware::class)->setName('merek_pestisida/edit-merek_pestisida-edit-2'); // edit
            $group->map(["GET","POST","OPTIONS"], '/' . Config('DELETE_ACTION') . '[/{mp_id}]', MerekPestisidaController::class . ':delete')->add(PermissionMiddleware::class)->setName('merek_pestisida/delete-merek_pestisida-delete-2'); // delete
        }
    );

    // personal_data
    $app->map(["GET","POST","OPTIONS"], '/personaldata', OthersController::class . ':personaldata')->add(PermissionMiddleware::class)->setName('personaldata');

    // login
    $app->map(["GET","POST","OPTIONS"], '/login[/{provider}]', OthersController::class . ':login')->add(PermissionMiddleware::class)->setName('login');

    // change_password
    $app->map(["GET","POST","OPTIONS"], '/changepassword', OthersController::class . ':changepassword')->add(PermissionMiddleware::class)->setName('changepassword');

    // register
    $app->map(["GET","POST","OPTIONS"], '/register', OthersController::class . ':register')->add(PermissionMiddleware::class)->setName('register');

    // userpriv
    $app->map(["GET","POST","OPTIONS"], '/userpriv', OthersController::class . ':userpriv')->add(PermissionMiddleware::class)->setName('userpriv');

    // logout
    $app->map(["GET","POST","OPTIONS"], '/logout', OthersController::class . ':logout')->add(PermissionMiddleware::class)->setName('logout');

    // Swagger
    $app->get('/' . Config("SWAGGER_ACTION"), OthersController::class . ':swagger')->setName(Config("SWAGGER_ACTION")); // Swagger

    // Index
    $app->get('/[index]', OthersController::class . ':index')->add(PermissionMiddleware::class)->setName('index');

    // Route Action event
    if (function_exists(PROJECT_NAMESPACE . "Route_Action")) {
        if (Route_Action($app) === false) {
            return;
        }
    }

    /**
     * Catch-all route to serve a 404 Not Found page if none of the routes match
     * NOTE: Make sure this route is defined last.
     */
    $app->map(
        ['GET', 'POST', 'PUT', 'DELETE', 'PATCH'],
        '/{routes:.+}',
        function ($request, $response, $params) {
            throw new HttpNotFoundException($request, str_replace("%p", $params["routes"], Container("language")->phrase("PageNotFound")));
        }
    );
};
