<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for stok_bibit
 */
class StokBibit extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $tipe_akses;
    public $tanggal_akses;
    public $id_estimasi;
    public $id_lahan;
    public $tanggal_panen;
    public $varietas_stok;
    public $jenis_lahan;
    public $jumlah_estimasi;
    public $id_order_bibit;
    public $order_id_co;
    public $varietas;
    public $tanggal_kirim;
    public $jumlah_order;
    public $stok;
    public $tanggal_stok;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "stok_bibit";
        $this->TableName = 'stok_bibit';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "stok_bibit";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // tipe_akses
        $this->tipe_akses = new DbField(
            $this, // Table
            'x_tipe_akses', // Variable name
            'tipe_akses', // Name
            '`tipe_akses`', // Expression
            '`tipe_akses`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`tipe_akses`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tipe_akses->InputTextType = "text";
        $this->tipe_akses->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['tipe_akses'] = &$this->tipe_akses;

        // tanggal_akses
        $this->tanggal_akses = new DbField(
            $this, // Table
            'x_tanggal_akses', // Variable name
            'tanggal_akses', // Name
            '`tanggal_akses`', // Expression
            CastDateFieldForLike("`tanggal_akses`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`tanggal_akses`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tanggal_akses->InputTextType = "text";
        $this->tanggal_akses->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->tanggal_akses->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tanggal_akses'] = &$this->tanggal_akses;

        // id_estimasi
        $this->id_estimasi = new DbField(
            $this, // Table
            'x_id_estimasi', // Variable name
            'id_estimasi', // Name
            '`id_estimasi`', // Expression
            '`id_estimasi`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id_estimasi`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id_estimasi->InputTextType = "text";
        $this->id_estimasi->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id_estimasi->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id_estimasi'] = &$this->id_estimasi;

        // id_lahan
        $this->id_lahan = new DbField(
            $this, // Table
            'x_id_lahan', // Variable name
            'id_lahan', // Name
            '`id_lahan`', // Expression
            '`id_lahan`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id_lahan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id_lahan->InputTextType = "text";
        $this->id_lahan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id_lahan->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id_lahan'] = &$this->id_lahan;

        // tanggal_panen
        $this->tanggal_panen = new DbField(
            $this, // Table
            'x_tanggal_panen', // Variable name
            'tanggal_panen', // Name
            '`tanggal_panen`', // Expression
            CastDateFieldForLike("`tanggal_panen`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`tanggal_panen`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tanggal_panen->InputTextType = "text";
        $this->tanggal_panen->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->tanggal_panen->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tanggal_panen'] = &$this->tanggal_panen;

        // varietas_stok
        $this->varietas_stok = new DbField(
            $this, // Table
            'x_varietas_stok', // Variable name
            'varietas_stok', // Name
            '`varietas_stok`', // Expression
            '`varietas_stok`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`varietas_stok`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->varietas_stok->InputTextType = "text";
        $this->varietas_stok->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['varietas_stok'] = &$this->varietas_stok;

        // jenis_lahan
        $this->jenis_lahan = new DbField(
            $this, // Table
            'x_jenis_lahan', // Variable name
            'jenis_lahan', // Name
            '`jenis_lahan`', // Expression
            '`jenis_lahan`', // Basic search expression
            200, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jenis_lahan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jenis_lahan->InputTextType = "text";
        $this->jenis_lahan->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['jenis_lahan'] = &$this->jenis_lahan;

        // jumlah_estimasi
        $this->jumlah_estimasi = new DbField(
            $this, // Table
            'x_jumlah_estimasi', // Variable name
            'jumlah_estimasi', // Name
            '`jumlah_estimasi`', // Expression
            '`jumlah_estimasi`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jumlah_estimasi`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jumlah_estimasi->InputTextType = "text";
        $this->jumlah_estimasi->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jumlah_estimasi->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jumlah_estimasi'] = &$this->jumlah_estimasi;

        // id_order_bibit
        $this->id_order_bibit = new DbField(
            $this, // Table
            'x_id_order_bibit', // Variable name
            'id_order_bibit', // Name
            '`id_order_bibit`', // Expression
            '`id_order_bibit`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id_order_bibit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id_order_bibit->InputTextType = "text";
        $this->id_order_bibit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id_order_bibit->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id_order_bibit'] = &$this->id_order_bibit;

        // order_id_co
        $this->order_id_co = new DbField(
            $this, // Table
            'x_order_id_co', // Variable name
            'order_id_co', // Name
            '`order_id_co`', // Expression
            '`order_id_co`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`order_id_co`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->order_id_co->InputTextType = "text";
        $this->order_id_co->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->order_id_co->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['order_id_co'] = &$this->order_id_co;

        // varietas
        $this->varietas = new DbField(
            $this, // Table
            'x_varietas', // Variable name
            'varietas', // Name
            '`varietas`', // Expression
            '`varietas`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`varietas`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->varietas->InputTextType = "text";
        $this->varietas->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->varietas->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['varietas'] = &$this->varietas;

        // tanggal_kirim
        $this->tanggal_kirim = new DbField(
            $this, // Table
            'x_tanggal_kirim', // Variable name
            'tanggal_kirim', // Name
            '`tanggal_kirim`', // Expression
            CastDateFieldForLike("`tanggal_kirim`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`tanggal_kirim`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tanggal_kirim->InputTextType = "text";
        $this->tanggal_kirim->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->tanggal_kirim->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tanggal_kirim'] = &$this->tanggal_kirim;

        // jumlah_order
        $this->jumlah_order = new DbField(
            $this, // Table
            'x_jumlah_order', // Variable name
            'jumlah_order', // Name
            '`jumlah_order`', // Expression
            '`jumlah_order`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`jumlah_order`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->jumlah_order->InputTextType = "text";
        $this->jumlah_order->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->jumlah_order->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['jumlah_order'] = &$this->jumlah_order;

        // stok
        $this->stok = new DbField(
            $this, // Table
            'x_stok', // Variable name
            'stok', // Name
            '`stok`', // Expression
            '`stok`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`stok`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->stok->InputTextType = "text";
        $this->stok->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->stok->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['stok'] = &$this->stok;

        // tanggal_stok
        $this->tanggal_stok = new DbField(
            $this, // Table
            'x_tanggal_stok', // Variable name
            'tanggal_stok', // Name
            '`tanggal_stok`', // Expression
            CastDateFieldForLike("`tanggal_stok`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`tanggal_stok`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->tanggal_stok->InputTextType = "text";
        $this->tanggal_stok->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->tanggal_stok->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['tanggal_stok'] = &$this->tanggal_stok;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "stok_bibit";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
            // Get insert id if necessary
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->tipe_akses->DbValue = $row['tipe_akses'];
        $this->tanggal_akses->DbValue = $row['tanggal_akses'];
        $this->id_estimasi->DbValue = $row['id_estimasi'];
        $this->id_lahan->DbValue = $row['id_lahan'];
        $this->tanggal_panen->DbValue = $row['tanggal_panen'];
        $this->varietas_stok->DbValue = $row['varietas_stok'];
        $this->jenis_lahan->DbValue = $row['jenis_lahan'];
        $this->jumlah_estimasi->DbValue = $row['jumlah_estimasi'];
        $this->id_order_bibit->DbValue = $row['id_order_bibit'];
        $this->order_id_co->DbValue = $row['order_id_co'];
        $this->varietas->DbValue = $row['varietas'];
        $this->tanggal_kirim->DbValue = $row['tanggal_kirim'];
        $this->jumlah_order->DbValue = $row['jumlah_order'];
        $this->stok->DbValue = $row['stok'];
        $this->tanggal_stok->DbValue = $row['tanggal_stok'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("StokBibitList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "StokBibitView") {
            return $Language->phrase("View");
        } elseif ($pageName == "StokBibitEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "StokBibitAdd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "StokBibitView";
            case Config("API_ADD_ACTION"):
                return "StokBibitAdd";
            case Config("API_EDIT_ACTION"):
                return "StokBibitEdit";
            case Config("API_DELETE_ACTION"):
                return "StokBibitDelete";
            case Config("API_LIST_ACTION"):
                return "StokBibitList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "StokBibitList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("StokBibitView", $parm);
        } else {
            $url = $this->keyUrl("StokBibitView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "StokBibitAdd?" . $parm;
        } else {
            $url = "StokBibitAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("StokBibitEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("StokBibitList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("StokBibitAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("StokBibitList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("StokBibitDelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . JsonEncode($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->tipe_akses->setDbValue($row['tipe_akses']);
        $this->tanggal_akses->setDbValue($row['tanggal_akses']);
        $this->id_estimasi->setDbValue($row['id_estimasi']);
        $this->id_lahan->setDbValue($row['id_lahan']);
        $this->tanggal_panen->setDbValue($row['tanggal_panen']);
        $this->varietas_stok->setDbValue($row['varietas_stok']);
        $this->jenis_lahan->setDbValue($row['jenis_lahan']);
        $this->jumlah_estimasi->setDbValue($row['jumlah_estimasi']);
        $this->id_order_bibit->setDbValue($row['id_order_bibit']);
        $this->order_id_co->setDbValue($row['order_id_co']);
        $this->varietas->setDbValue($row['varietas']);
        $this->tanggal_kirim->setDbValue($row['tanggal_kirim']);
        $this->jumlah_order->setDbValue($row['jumlah_order']);
        $this->stok->setDbValue($row['stok']);
        $this->tanggal_stok->setDbValue($row['tanggal_stok']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "StokBibitList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // tipe_akses

        // tanggal_akses

        // id_estimasi

        // id_lahan

        // tanggal_panen

        // varietas_stok

        // jenis_lahan

        // jumlah_estimasi

        // id_order_bibit

        // order_id_co

        // varietas

        // tanggal_kirim

        // jumlah_order

        // stok

        // tanggal_stok

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // tipe_akses
        $this->tipe_akses->ViewValue = $this->tipe_akses->CurrentValue;

        // tanggal_akses
        $this->tanggal_akses->ViewValue = $this->tanggal_akses->CurrentValue;
        $this->tanggal_akses->ViewValue = FormatDateTime($this->tanggal_akses->ViewValue, $this->tanggal_akses->formatPattern());

        // id_estimasi
        $this->id_estimasi->ViewValue = $this->id_estimasi->CurrentValue;

        // id_lahan
        $this->id_lahan->ViewValue = $this->id_lahan->CurrentValue;

        // tanggal_panen
        $this->tanggal_panen->ViewValue = $this->tanggal_panen->CurrentValue;
        $this->tanggal_panen->ViewValue = FormatDateTime($this->tanggal_panen->ViewValue, $this->tanggal_panen->formatPattern());

        // varietas_stok
        $this->varietas_stok->ViewValue = $this->varietas_stok->CurrentValue;

        // jenis_lahan
        $this->jenis_lahan->ViewValue = $this->jenis_lahan->CurrentValue;

        // jumlah_estimasi
        $this->jumlah_estimasi->ViewValue = $this->jumlah_estimasi->CurrentValue;

        // id_order_bibit
        $this->id_order_bibit->ViewValue = $this->id_order_bibit->CurrentValue;

        // order_id_co
        $this->order_id_co->ViewValue = $this->order_id_co->CurrentValue;

        // varietas
        $this->varietas->ViewValue = $this->varietas->CurrentValue;

        // tanggal_kirim
        $this->tanggal_kirim->ViewValue = $this->tanggal_kirim->CurrentValue;
        $this->tanggal_kirim->ViewValue = FormatDateTime($this->tanggal_kirim->ViewValue, $this->tanggal_kirim->formatPattern());

        // jumlah_order
        $this->jumlah_order->ViewValue = $this->jumlah_order->CurrentValue;

        // stok
        $this->stok->ViewValue = $this->stok->CurrentValue;

        // tanggal_stok
        $this->tanggal_stok->ViewValue = $this->tanggal_stok->CurrentValue;
        $this->tanggal_stok->ViewValue = FormatDateTime($this->tanggal_stok->ViewValue, $this->tanggal_stok->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // tipe_akses
        $this->tipe_akses->HrefValue = "";
        $this->tipe_akses->TooltipValue = "";

        // tanggal_akses
        $this->tanggal_akses->HrefValue = "";
        $this->tanggal_akses->TooltipValue = "";

        // id_estimasi
        $this->id_estimasi->HrefValue = "";
        $this->id_estimasi->TooltipValue = "";

        // id_lahan
        $this->id_lahan->HrefValue = "";
        $this->id_lahan->TooltipValue = "";

        // tanggal_panen
        $this->tanggal_panen->HrefValue = "";
        $this->tanggal_panen->TooltipValue = "";

        // varietas_stok
        $this->varietas_stok->HrefValue = "";
        $this->varietas_stok->TooltipValue = "";

        // jenis_lahan
        $this->jenis_lahan->HrefValue = "";
        $this->jenis_lahan->TooltipValue = "";

        // jumlah_estimasi
        $this->jumlah_estimasi->HrefValue = "";
        $this->jumlah_estimasi->TooltipValue = "";

        // id_order_bibit
        $this->id_order_bibit->HrefValue = "";
        $this->id_order_bibit->TooltipValue = "";

        // order_id_co
        $this->order_id_co->HrefValue = "";
        $this->order_id_co->TooltipValue = "";

        // varietas
        $this->varietas->HrefValue = "";
        $this->varietas->TooltipValue = "";

        // tanggal_kirim
        $this->tanggal_kirim->HrefValue = "";
        $this->tanggal_kirim->TooltipValue = "";

        // jumlah_order
        $this->jumlah_order->HrefValue = "";
        $this->jumlah_order->TooltipValue = "";

        // stok
        $this->stok->HrefValue = "";
        $this->stok->TooltipValue = "";

        // tanggal_stok
        $this->tanggal_stok->HrefValue = "";
        $this->tanggal_stok->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // tipe_akses
        $this->tipe_akses->setupEditAttributes();
        if (!$this->tipe_akses->Raw) {
            $this->tipe_akses->CurrentValue = HtmlDecode($this->tipe_akses->CurrentValue);
        }
        $this->tipe_akses->EditValue = $this->tipe_akses->CurrentValue;
        $this->tipe_akses->PlaceHolder = RemoveHtml($this->tipe_akses->caption());

        // tanggal_akses
        $this->tanggal_akses->setupEditAttributes();
        $this->tanggal_akses->EditValue = FormatDateTime($this->tanggal_akses->CurrentValue, $this->tanggal_akses->formatPattern());
        $this->tanggal_akses->PlaceHolder = RemoveHtml($this->tanggal_akses->caption());

        // id_estimasi
        $this->id_estimasi->setupEditAttributes();
        $this->id_estimasi->EditValue = $this->id_estimasi->CurrentValue;
        $this->id_estimasi->PlaceHolder = RemoveHtml($this->id_estimasi->caption());
        if (strval($this->id_estimasi->EditValue) != "" && is_numeric($this->id_estimasi->EditValue)) {
            $this->id_estimasi->EditValue = $this->id_estimasi->EditValue;
        }

        // id_lahan
        $this->id_lahan->setupEditAttributes();
        $this->id_lahan->EditValue = $this->id_lahan->CurrentValue;
        $this->id_lahan->PlaceHolder = RemoveHtml($this->id_lahan->caption());
        if (strval($this->id_lahan->EditValue) != "" && is_numeric($this->id_lahan->EditValue)) {
            $this->id_lahan->EditValue = $this->id_lahan->EditValue;
        }

        // tanggal_panen
        $this->tanggal_panen->setupEditAttributes();
        $this->tanggal_panen->EditValue = FormatDateTime($this->tanggal_panen->CurrentValue, $this->tanggal_panen->formatPattern());
        $this->tanggal_panen->PlaceHolder = RemoveHtml($this->tanggal_panen->caption());

        // varietas_stok
        $this->varietas_stok->setupEditAttributes();
        if (!$this->varietas_stok->Raw) {
            $this->varietas_stok->CurrentValue = HtmlDecode($this->varietas_stok->CurrentValue);
        }
        $this->varietas_stok->EditValue = $this->varietas_stok->CurrentValue;
        $this->varietas_stok->PlaceHolder = RemoveHtml($this->varietas_stok->caption());

        // jenis_lahan
        $this->jenis_lahan->setupEditAttributes();
        if (!$this->jenis_lahan->Raw) {
            $this->jenis_lahan->CurrentValue = HtmlDecode($this->jenis_lahan->CurrentValue);
        }
        $this->jenis_lahan->EditValue = $this->jenis_lahan->CurrentValue;
        $this->jenis_lahan->PlaceHolder = RemoveHtml($this->jenis_lahan->caption());

        // jumlah_estimasi
        $this->jumlah_estimasi->setupEditAttributes();
        $this->jumlah_estimasi->EditValue = $this->jumlah_estimasi->CurrentValue;
        $this->jumlah_estimasi->PlaceHolder = RemoveHtml($this->jumlah_estimasi->caption());
        if (strval($this->jumlah_estimasi->EditValue) != "" && is_numeric($this->jumlah_estimasi->EditValue)) {
            $this->jumlah_estimasi->EditValue = $this->jumlah_estimasi->EditValue;
        }

        // id_order_bibit
        $this->id_order_bibit->setupEditAttributes();
        $this->id_order_bibit->EditValue = $this->id_order_bibit->CurrentValue;
        $this->id_order_bibit->PlaceHolder = RemoveHtml($this->id_order_bibit->caption());
        if (strval($this->id_order_bibit->EditValue) != "" && is_numeric($this->id_order_bibit->EditValue)) {
            $this->id_order_bibit->EditValue = $this->id_order_bibit->EditValue;
        }

        // order_id_co
        $this->order_id_co->setupEditAttributes();
        $this->order_id_co->EditValue = $this->order_id_co->CurrentValue;
        $this->order_id_co->PlaceHolder = RemoveHtml($this->order_id_co->caption());
        if (strval($this->order_id_co->EditValue) != "" && is_numeric($this->order_id_co->EditValue)) {
            $this->order_id_co->EditValue = $this->order_id_co->EditValue;
        }

        // varietas
        $this->varietas->setupEditAttributes();
        $this->varietas->EditValue = $this->varietas->CurrentValue;
        $this->varietas->PlaceHolder = RemoveHtml($this->varietas->caption());
        if (strval($this->varietas->EditValue) != "" && is_numeric($this->varietas->EditValue)) {
            $this->varietas->EditValue = $this->varietas->EditValue;
        }

        // tanggal_kirim
        $this->tanggal_kirim->setupEditAttributes();
        $this->tanggal_kirim->EditValue = FormatDateTime($this->tanggal_kirim->CurrentValue, $this->tanggal_kirim->formatPattern());
        $this->tanggal_kirim->PlaceHolder = RemoveHtml($this->tanggal_kirim->caption());

        // jumlah_order
        $this->jumlah_order->setupEditAttributes();
        $this->jumlah_order->EditValue = $this->jumlah_order->CurrentValue;
        $this->jumlah_order->PlaceHolder = RemoveHtml($this->jumlah_order->caption());
        if (strval($this->jumlah_order->EditValue) != "" && is_numeric($this->jumlah_order->EditValue)) {
            $this->jumlah_order->EditValue = $this->jumlah_order->EditValue;
        }

        // stok
        $this->stok->setupEditAttributes();
        $this->stok->EditValue = $this->stok->CurrentValue;
        $this->stok->PlaceHolder = RemoveHtml($this->stok->caption());
        if (strval($this->stok->EditValue) != "" && is_numeric($this->stok->EditValue)) {
            $this->stok->EditValue = $this->stok->EditValue;
        }

        // tanggal_stok
        $this->tanggal_stok->setupEditAttributes();
        $this->tanggal_stok->EditValue = FormatDateTime($this->tanggal_stok->CurrentValue, $this->tanggal_stok->formatPattern());
        $this->tanggal_stok->PlaceHolder = RemoveHtml($this->tanggal_stok->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->tipe_akses);
                    $doc->exportCaption($this->tanggal_akses);
                    $doc->exportCaption($this->id_estimasi);
                    $doc->exportCaption($this->id_lahan);
                    $doc->exportCaption($this->tanggal_panen);
                    $doc->exportCaption($this->varietas_stok);
                    $doc->exportCaption($this->jenis_lahan);
                    $doc->exportCaption($this->jumlah_estimasi);
                    $doc->exportCaption($this->id_order_bibit);
                    $doc->exportCaption($this->order_id_co);
                    $doc->exportCaption($this->varietas);
                    $doc->exportCaption($this->tanggal_kirim);
                    $doc->exportCaption($this->jumlah_order);
                    $doc->exportCaption($this->stok);
                    $doc->exportCaption($this->tanggal_stok);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->tipe_akses);
                    $doc->exportCaption($this->tanggal_akses);
                    $doc->exportCaption($this->id_estimasi);
                    $doc->exportCaption($this->id_lahan);
                    $doc->exportCaption($this->tanggal_panen);
                    $doc->exportCaption($this->varietas_stok);
                    $doc->exportCaption($this->jenis_lahan);
                    $doc->exportCaption($this->jumlah_estimasi);
                    $doc->exportCaption($this->id_order_bibit);
                    $doc->exportCaption($this->order_id_co);
                    $doc->exportCaption($this->varietas);
                    $doc->exportCaption($this->tanggal_kirim);
                    $doc->exportCaption($this->jumlah_order);
                    $doc->exportCaption($this->stok);
                    $doc->exportCaption($this->tanggal_stok);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->tipe_akses);
                        $doc->exportField($this->tanggal_akses);
                        $doc->exportField($this->id_estimasi);
                        $doc->exportField($this->id_lahan);
                        $doc->exportField($this->tanggal_panen);
                        $doc->exportField($this->varietas_stok);
                        $doc->exportField($this->jenis_lahan);
                        $doc->exportField($this->jumlah_estimasi);
                        $doc->exportField($this->id_order_bibit);
                        $doc->exportField($this->order_id_co);
                        $doc->exportField($this->varietas);
                        $doc->exportField($this->tanggal_kirim);
                        $doc->exportField($this->jumlah_order);
                        $doc->exportField($this->stok);
                        $doc->exportField($this->tanggal_stok);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->tipe_akses);
                        $doc->exportField($this->tanggal_akses);
                        $doc->exportField($this->id_estimasi);
                        $doc->exportField($this->id_lahan);
                        $doc->exportField($this->tanggal_panen);
                        $doc->exportField($this->varietas_stok);
                        $doc->exportField($this->jenis_lahan);
                        $doc->exportField($this->jumlah_estimasi);
                        $doc->exportField($this->id_order_bibit);
                        $doc->exportField($this->order_id_co);
                        $doc->exportField($this->varietas);
                        $doc->exportField($this->tanggal_kirim);
                        $doc->exportField($this->jumlah_order);
                        $doc->exportField($this->stok);
                        $doc->exportField($this->tanggal_stok);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
