<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class SosialisasiDelete extends Sosialisasi
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SosialisasiDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "SosialisasiDelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->sos_id->setVisibility();
        $this->sos_tgl->setVisibility();
        $this->ts_id->setVisibility();
        $this->sos_co->setVisibility();
        $this->sos_peserta->setVisibility();
        $this->sos_prov->setVisibility();
        $this->sos_kab->setVisibility();
        $this->sos_kec->setVisibility();
        $this->sos_desa->setVisibility();
        $this->sos_alamat->setVisibility();
        $this->sos_pot_lahan->setVisibility();
        $this->sos_katinggian->setVisibility();
        $this->sos_biaya->setVisibility();
        $this->sos_kesimpulan->setVisibility();
        $this->sos_foto->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'sosialisasi';
        $this->TableName = 'sosialisasi';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (sosialisasi)
        if (!isset($GLOBALS["sosialisasi"]) || get_class($GLOBALS["sosialisasi"]) == PROJECT_NAMESPACE . "sosialisasi") {
            $GLOBALS["sosialisasi"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sosialisasi');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->sos_foto->OldUploadPath = $this->sos_foto->getUploadPath(); // PHP
                $this->sos_foto->UploadPath = $this->sos_foto->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['sos_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->sos_id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;
    public $RowCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ts_id);
        $this->setupLookupOptions($this->sos_co);
        $this->setupLookupOptions($this->sos_peserta);
        $this->setupLookupOptions($this->sos_prov);
        $this->setupLookupOptions($this->sos_kab);
        $this->setupLookupOptions($this->sos_kec);
        $this->setupLookupOptions($this->sos_desa);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("SosialisasiList"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson([ "success" => false, "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;                    
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            if ($this->Recordset = $this->loadRecordset()) {
                $this->TotalRecords = $this->Recordset->recordCount(); // Get record count
            }
            if ($this->TotalRecords <= 0) { // No record found, exit
                if ($this->Recordset) {
                    $this->Recordset->close();
                }
                $this->terminate("SosialisasiList"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->sos_id->setDbValue($row['sos_id']);
        $this->sos_tgl->setDbValue($row['sos_tgl']);
        $this->ts_id->setDbValue($row['ts_id']);
        $this->sos_co->setDbValue($row['sos_co']);
        $this->sos_peserta->setDbValue($row['sos_peserta']);
        $this->sos_prov->setDbValue($row['sos_prov']);
        $this->sos_kab->setDbValue($row['sos_kab']);
        $this->sos_kec->setDbValue($row['sos_kec']);
        $this->sos_desa->setDbValue($row['sos_desa']);
        $this->sos_alamat->setDbValue($row['sos_alamat']);
        $this->sos_pot_lahan->setDbValue($row['sos_pot_lahan']);
        $this->sos_katinggian->setDbValue($row['sos_katinggian']);
        $this->sos_biaya->setDbValue($row['sos_biaya']);
        $this->sos_kesimpulan->setDbValue($row['sos_kesimpulan']);
        $this->sos_foto->Upload->DbValue = $row['sos_foto'];
        $this->sos_foto->setDbValue($this->sos_foto->Upload->DbValue);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['sos_id'] = $this->sos_id->DefaultValue;
        $row['sos_tgl'] = $this->sos_tgl->DefaultValue;
        $row['ts_id'] = $this->ts_id->DefaultValue;
        $row['sos_co'] = $this->sos_co->DefaultValue;
        $row['sos_peserta'] = $this->sos_peserta->DefaultValue;
        $row['sos_prov'] = $this->sos_prov->DefaultValue;
        $row['sos_kab'] = $this->sos_kab->DefaultValue;
        $row['sos_kec'] = $this->sos_kec->DefaultValue;
        $row['sos_desa'] = $this->sos_desa->DefaultValue;
        $row['sos_alamat'] = $this->sos_alamat->DefaultValue;
        $row['sos_pot_lahan'] = $this->sos_pot_lahan->DefaultValue;
        $row['sos_katinggian'] = $this->sos_katinggian->DefaultValue;
        $row['sos_biaya'] = $this->sos_biaya->DefaultValue;
        $row['sos_kesimpulan'] = $this->sos_kesimpulan->DefaultValue;
        $row['sos_foto'] = $this->sos_foto->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // sos_id

        // sos_tgl

        // ts_id

        // sos_co

        // sos_peserta

        // sos_prov

        // sos_kab

        // sos_kec

        // sos_desa

        // sos_alamat

        // sos_pot_lahan

        // sos_katinggian

        // sos_biaya

        // sos_kesimpulan

        // sos_foto

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // sos_id
            $this->sos_id->ViewValue = $this->sos_id->CurrentValue;

            // sos_tgl
            $this->sos_tgl->ViewValue = $this->sos_tgl->CurrentValue;
            $this->sos_tgl->ViewValue = FormatDateTime($this->sos_tgl->ViewValue, $this->sos_tgl->formatPattern());

            // ts_id
            $curVal = strval($this->ts_id->CurrentValue);
            if ($curVal != "") {
                $this->ts_id->ViewValue = $this->ts_id->lookupCacheOption($curVal);
                if ($this->ts_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`ts_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->ts_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ts_id->Lookup->renderViewRow($rswrk[0]);
                        $this->ts_id->ViewValue = $this->ts_id->displayValue($arwrk);
                    } else {
                        $this->ts_id->ViewValue = $this->ts_id->CurrentValue;
                    }
                }
            } else {
                $this->ts_id->ViewValue = null;
            }

            // sos_co
            $curVal = strval($this->sos_co->CurrentValue);
            if ($curVal != "") {
                $this->sos_co->ViewValue = $this->sos_co->lookupCacheOption($curVal);
                if ($this->sos_co->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_co->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_co->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_co->ViewValue = $this->sos_co->displayValue($arwrk);
                    } else {
                        $this->sos_co->ViewValue = $this->sos_co->CurrentValue;
                    }
                }
            } else {
                $this->sos_co->ViewValue = null;
            }

            // sos_peserta
            $curVal = strval($this->sos_peserta->CurrentValue);
            if ($curVal != "") {
                $this->sos_peserta->ViewValue = $this->sos_peserta->lookupCacheOption($curVal);
                if ($this->sos_peserta->ViewValue === null) { // Lookup from database
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= SearchFilter("`pes_id`", "=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->sos_peserta->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->sos_peserta->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->sos_peserta->Lookup->renderViewRow($row);
                            $this->sos_peserta->ViewValue->add($this->sos_peserta->displayValue($arwrk));
                        }
                    } else {
                        $this->sos_peserta->ViewValue = $this->sos_peserta->CurrentValue;
                    }
                }
            } else {
                $this->sos_peserta->ViewValue = null;
            }
            $this->sos_peserta->CellCssStyle .= "text-align: left;";

            // sos_prov
            $curVal = strval($this->sos_prov->CurrentValue);
            if ($curVal != "") {
                $this->sos_prov->ViewValue = $this->sos_prov->lookupCacheOption($curVal);
                if ($this->sos_prov->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_prov->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_prov->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_prov->ViewValue = $this->sos_prov->displayValue($arwrk);
                    } else {
                        $this->sos_prov->ViewValue = $this->sos_prov->CurrentValue;
                    }
                }
            } else {
                $this->sos_prov->ViewValue = null;
            }

            // sos_kab
            $curVal = strval($this->sos_kab->CurrentValue);
            if ($curVal != "") {
                $this->sos_kab->ViewValue = $this->sos_kab->lookupCacheOption($curVal);
                if ($this->sos_kab->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_kab->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_kab->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_kab->ViewValue = $this->sos_kab->displayValue($arwrk);
                    } else {
                        $this->sos_kab->ViewValue = $this->sos_kab->CurrentValue;
                    }
                }
            } else {
                $this->sos_kab->ViewValue = null;
            }

            // sos_kec
            $curVal = strval($this->sos_kec->CurrentValue);
            if ($curVal != "") {
                $this->sos_kec->ViewValue = $this->sos_kec->lookupCacheOption($curVal);
                if ($this->sos_kec->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_kec->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_kec->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_kec->ViewValue = $this->sos_kec->displayValue($arwrk);
                    } else {
                        $this->sos_kec->ViewValue = $this->sos_kec->CurrentValue;
                    }
                }
            } else {
                $this->sos_kec->ViewValue = null;
            }

            // sos_desa
            $curVal = strval($this->sos_desa->CurrentValue);
            if ($curVal != "") {
                $this->sos_desa->ViewValue = $this->sos_desa->lookupCacheOption($curVal);
                if ($this->sos_desa->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_desa->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_desa->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_desa->ViewValue = $this->sos_desa->displayValue($arwrk);
                    } else {
                        $this->sos_desa->ViewValue = $this->sos_desa->CurrentValue;
                    }
                }
            } else {
                $this->sos_desa->ViewValue = null;
            }

            // sos_alamat
            $this->sos_alamat->ViewValue = $this->sos_alamat->CurrentValue;

            // sos_pot_lahan
            $this->sos_pot_lahan->ViewValue = $this->sos_pot_lahan->CurrentValue;
            $this->sos_pot_lahan->CellCssStyle .= "text-align: right;";

            // sos_katinggian
            $this->sos_katinggian->ViewValue = $this->sos_katinggian->CurrentValue;
            $this->sos_katinggian->CellCssStyle .= "text-align: right;";

            // sos_biaya
            $this->sos_biaya->ViewValue = $this->sos_biaya->CurrentValue;

            // sos_kesimpulan
            $this->sos_kesimpulan->ViewValue = $this->sos_kesimpulan->CurrentValue;

            // sos_foto
            $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
                $this->sos_foto->ImageWidth = 80;
                $this->sos_foto->ImageHeight = 60;
                $this->sos_foto->ImageAlt = $this->sos_foto->alt();
                $this->sos_foto->ImageCssClass = "ew-image";
                $this->sos_foto->ViewValue = $this->sos_foto->Upload->DbValue;
            } else {
                $this->sos_foto->ViewValue = "";
            }
            $this->sos_foto->CellCssStyle .= "text-align: center;";

            // sos_id
            $this->sos_id->HrefValue = "";
            $this->sos_id->TooltipValue = "";

            // sos_tgl
            $this->sos_tgl->HrefValue = "";
            $this->sos_tgl->TooltipValue = "";

            // ts_id
            $this->ts_id->HrefValue = "";
            $this->ts_id->TooltipValue = "";

            // sos_co
            $this->sos_co->HrefValue = "";
            $this->sos_co->TooltipValue = "";

            // sos_peserta
            $this->sos_peserta->HrefValue = "";
            $this->sos_peserta->TooltipValue = "";

            // sos_prov
            $this->sos_prov->HrefValue = "";
            $this->sos_prov->TooltipValue = "";

            // sos_kab
            $this->sos_kab->HrefValue = "";
            $this->sos_kab->TooltipValue = "";

            // sos_kec
            $this->sos_kec->HrefValue = "";
            $this->sos_kec->TooltipValue = "";

            // sos_desa
            $this->sos_desa->HrefValue = "";
            $this->sos_desa->TooltipValue = "";

            // sos_alamat
            $this->sos_alamat->HrefValue = "";
            $this->sos_alamat->TooltipValue = "";

            // sos_pot_lahan
            $this->sos_pot_lahan->HrefValue = "";
            $this->sos_pot_lahan->TooltipValue = "";

            // sos_katinggian
            $this->sos_katinggian->HrefValue = "";
            $this->sos_katinggian->TooltipValue = "";

            // sos_biaya
            $this->sos_biaya->HrefValue = "";
            $this->sos_biaya->TooltipValue = "";

            // sos_kesimpulan
            $this->sos_kesimpulan->HrefValue = "";
            $this->sos_kesimpulan->TooltipValue = "";

            // sos_foto
            $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
                $this->sos_foto->HrefValue = "%u"; // Add prefix/suffix
                $this->sos_foto->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->sos_foto->HrefValue = FullUrl($this->sos_foto->HrefValue, "href");
                }
            } else {
                $this->sos_foto->HrefValue = "";
            }
            $this->sos_foto->ExportHrefValue = $this->sos_foto->UploadPath . $this->sos_foto->Upload->DbValue;
            $this->sos_foto->TooltipValue = "";
            if ($this->sos_foto->UseColorbox) {
                if (EmptyValue($this->sos_foto->TooltipValue)) {
                    $this->sos_foto->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->sos_foto->LinkAttrs["data-rel"] = "sosialisasi_x_sos_foto";
                $this->sos_foto->LinkAttrs->appendClass("ew-lightbox");
            }
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['sos_id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                $conn->commit();
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                $conn->rollback();
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Route(2) !== null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KontrakList");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("SosialisasiList"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ts_id":
                    break;
                case "x_sos_co":
                    break;
                case "x_sos_peserta":
                    break;
                case "x_sos_prov":
                    break;
                case "x_sos_kab":
                    break;
                case "x_sos_kec":
                    break;
                case "x_sos_desa":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
