<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class PetaniAddopt extends Petani
{
    use MessagesTrait;

    // Page ID
    public $PageID = "addopt";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PetaniAddopt";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "PetaniAddopt";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->pet_id->setVisibility();
        $this->pet_nama->setVisibility();
        $this->pet_hp->setVisibility();
        $this->prov_id->setVisibility();
        $this->kab_id->setVisibility();
        $this->kec_id->setVisibility();
        $this->desa_id->setVisibility();
        $this->pet_alamat->setVisibility();
        $this->pet_foto->setVisibility();
        $this->co_id->setVisibility();
        $this->koord_id->setVisibility();
        $this->tr_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'petani';
        $this->TableName = 'petani';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (petani)
        if (!isset($GLOBALS["petani"]) || get_class($GLOBALS["petani"]) == PROJECT_NAMESPACE . "petani") {
            $GLOBALS["petani"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'petani');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->pet_foto->OldUploadPath = $this->pet_foto->getUploadPath(); // PHP
                $this->pet_foto->UploadPath = $this->pet_foto->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['pet_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->pet_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $IsModal = false;
    public $IsMobileOrModal = true; // Add option page is always modal

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->prov_id);
        $this->setupLookupOptions($this->kab_id);
        $this->setupLookupOptions($this->kec_id);
        $this->setupLookupOptions($this->desa_id);
        $this->setupLookupOptions($this->co_id);
        $this->setupLookupOptions($this->koord_id);
        $this->setupLookupOptions($this->tr_id);

        // Load default values for add
        $this->loadDefaultValues();

        // Set up Breadcrumb
        // $this->setupBreadcrumb(); // Not used
        $this->loadRowValues(); // Load default values

        // Render row
        $this->RowType = ROWTYPE_ADD; // Render add type
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->pet_foto->Upload->Index = $CurrentForm->Index;
        $this->pet_foto->Upload->uploadFile();
        $this->pet_foto->CurrentValue = $this->pet_foto->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'pet_id' first before field var 'x_pet_id'
        $val = $CurrentForm->hasValue("pet_id") ? $CurrentForm->getValue("pet_id") : $CurrentForm->getValue("x_pet_id");

        // Check field name 'pet_nama' first before field var 'x_pet_nama'
        $val = $CurrentForm->hasValue("pet_nama") ? $CurrentForm->getValue("pet_nama") : $CurrentForm->getValue("x_pet_nama");
        if (!$this->pet_nama->IsDetailKey) {
            $this->pet_nama->setFormValue($val);
        }

        // Check field name 'pet_hp' first before field var 'x_pet_hp'
        $val = $CurrentForm->hasValue("pet_hp") ? $CurrentForm->getValue("pet_hp") : $CurrentForm->getValue("x_pet_hp");
        if (!$this->pet_hp->IsDetailKey) {
            $this->pet_hp->setFormValue($val, true, $validate);
        }

        // Check field name 'prov_id' first before field var 'x_prov_id'
        $val = $CurrentForm->hasValue("prov_id") ? $CurrentForm->getValue("prov_id") : $CurrentForm->getValue("x_prov_id");
        if (!$this->prov_id->IsDetailKey) {
            $this->prov_id->setFormValue($val);
        }

        // Check field name 'kab_id' first before field var 'x_kab_id'
        $val = $CurrentForm->hasValue("kab_id") ? $CurrentForm->getValue("kab_id") : $CurrentForm->getValue("x_kab_id");
        if (!$this->kab_id->IsDetailKey) {
            $this->kab_id->setFormValue($val);
        }

        // Check field name 'kec_id' first before field var 'x_kec_id'
        $val = $CurrentForm->hasValue("kec_id") ? $CurrentForm->getValue("kec_id") : $CurrentForm->getValue("x_kec_id");
        if (!$this->kec_id->IsDetailKey) {
            $this->kec_id->setFormValue($val);
        }

        // Check field name 'desa_id' first before field var 'x_desa_id'
        $val = $CurrentForm->hasValue("desa_id") ? $CurrentForm->getValue("desa_id") : $CurrentForm->getValue("x_desa_id");
        if (!$this->desa_id->IsDetailKey) {
            $this->desa_id->setFormValue($val);
        }

        // Check field name 'pet_alamat' first before field var 'x_pet_alamat'
        $val = $CurrentForm->hasValue("pet_alamat") ? $CurrentForm->getValue("pet_alamat") : $CurrentForm->getValue("x_pet_alamat");
        if (!$this->pet_alamat->IsDetailKey) {
            $this->pet_alamat->setFormValue($val);
        }

        // Check field name 'co_id' first before field var 'x_co_id'
        $val = $CurrentForm->hasValue("co_id") ? $CurrentForm->getValue("co_id") : $CurrentForm->getValue("x_co_id");
        if (!$this->co_id->IsDetailKey) {
            $this->co_id->setFormValue($val);
        }

        // Check field name 'koord_id' first before field var 'x_koord_id'
        $val = $CurrentForm->hasValue("koord_id") ? $CurrentForm->getValue("koord_id") : $CurrentForm->getValue("x_koord_id");
        if (!$this->koord_id->IsDetailKey) {
            $this->koord_id->setFormValue($val);
        }

        // Check field name 'tr_id' first before field var 'x_tr_id'
        $val = $CurrentForm->hasValue("tr_id") ? $CurrentForm->getValue("tr_id") : $CurrentForm->getValue("x_tr_id");
        if (!$this->tr_id->IsDetailKey) {
            $this->tr_id->setFormValue($val);
        }
		$this->pet_foto->OldUploadPath = $this->pet_foto->getUploadPath(); // PHP
		$this->pet_foto->UploadPath = $this->pet_foto->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->pet_nama->CurrentValue = ConvertToUtf8($this->pet_nama->FormValue);
        $this->pet_hp->CurrentValue = ConvertToUtf8($this->pet_hp->FormValue);
        $this->prov_id->CurrentValue = ConvertToUtf8($this->prov_id->FormValue);
        $this->kab_id->CurrentValue = ConvertToUtf8($this->kab_id->FormValue);
        $this->kec_id->CurrentValue = ConvertToUtf8($this->kec_id->FormValue);
        $this->desa_id->CurrentValue = ConvertToUtf8($this->desa_id->FormValue);
        $this->pet_alamat->CurrentValue = ConvertToUtf8($this->pet_alamat->FormValue);
        $this->co_id->CurrentValue = ConvertToUtf8($this->co_id->FormValue);
        $this->koord_id->CurrentValue = ConvertToUtf8($this->koord_id->FormValue);
        $this->tr_id->CurrentValue = ConvertToUtf8($this->tr_id->FormValue);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->pet_id->setDbValue($row['pet_id']);
        $this->pet_nama->setDbValue($row['pet_nama']);
        $this->pet_hp->setDbValue($row['pet_hp']);
        $this->prov_id->setDbValue($row['prov_id']);
        $this->kab_id->setDbValue($row['kab_id']);
        $this->kec_id->setDbValue($row['kec_id']);
        $this->desa_id->setDbValue($row['desa_id']);
        $this->pet_alamat->setDbValue($row['pet_alamat']);
        $this->pet_foto->Upload->DbValue = $row['pet_foto'];
        $this->pet_foto->setDbValue($this->pet_foto->Upload->DbValue);
        $this->co_id->setDbValue($row['co_id']);
        $this->koord_id->setDbValue($row['koord_id']);
        if (array_key_exists('EV__koord_id', $row)) {
            $this->koord_id->VirtualValue = $row['EV__koord_id']; // Set up virtual field value
        } else {
            $this->koord_id->VirtualValue = ""; // Clear value
        }
        $this->tr_id->setDbValue($row['tr_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['pet_id'] = $this->pet_id->DefaultValue;
        $row['pet_nama'] = $this->pet_nama->DefaultValue;
        $row['pet_hp'] = $this->pet_hp->DefaultValue;
        $row['prov_id'] = $this->prov_id->DefaultValue;
        $row['kab_id'] = $this->kab_id->DefaultValue;
        $row['kec_id'] = $this->kec_id->DefaultValue;
        $row['desa_id'] = $this->desa_id->DefaultValue;
        $row['pet_alamat'] = $this->pet_alamat->DefaultValue;
        $row['pet_foto'] = $this->pet_foto->DefaultValue;
        $row['co_id'] = $this->co_id->DefaultValue;
        $row['koord_id'] = $this->koord_id->DefaultValue;
        $row['tr_id'] = $this->tr_id->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // pet_id
        $this->pet_id->RowCssClass = "row";

        // pet_nama
        $this->pet_nama->RowCssClass = "row";

        // pet_hp
        $this->pet_hp->RowCssClass = "row";

        // prov_id
        $this->prov_id->RowCssClass = "row";

        // kab_id
        $this->kab_id->RowCssClass = "row";

        // kec_id
        $this->kec_id->RowCssClass = "row";

        // desa_id
        $this->desa_id->RowCssClass = "row";

        // pet_alamat
        $this->pet_alamat->RowCssClass = "row";

        // pet_foto
        $this->pet_foto->RowCssClass = "row";

        // co_id
        $this->co_id->RowCssClass = "row";

        // koord_id
        $this->koord_id->RowCssClass = "row";

        // tr_id
        $this->tr_id->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // pet_id
            $this->pet_id->ViewValue = $this->pet_id->CurrentValue;

            // pet_nama
            $this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;

            // pet_hp
            $this->pet_hp->ViewValue = $this->pet_hp->CurrentValue;

            // prov_id
            $curVal = strval($this->prov_id->CurrentValue);
            if ($curVal != "") {
                $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
                if ($this->prov_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->prov_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->prov_id->Lookup->renderViewRow($rswrk[0]);
                        $this->prov_id->ViewValue = $this->prov_id->displayValue($arwrk);
                    } else {
                        $this->prov_id->ViewValue = $this->prov_id->CurrentValue;
                    }
                }
            } else {
                $this->prov_id->ViewValue = null;
            }

            // kab_id
            $curVal = strval($this->kab_id->CurrentValue);
            if ($curVal != "") {
                $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
                if ($this->kab_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->kab_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->kab_id->Lookup->renderViewRow($rswrk[0]);
                        $this->kab_id->ViewValue = $this->kab_id->displayValue($arwrk);
                    } else {
                        $this->kab_id->ViewValue = $this->kab_id->CurrentValue;
                    }
                }
            } else {
                $this->kab_id->ViewValue = null;
            }

            // kec_id
            $curVal = strval($this->kec_id->CurrentValue);
            if ($curVal != "") {
                $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
                if ($this->kec_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->kec_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->kec_id->Lookup->renderViewRow($rswrk[0]);
                        $this->kec_id->ViewValue = $this->kec_id->displayValue($arwrk);
                    } else {
                        $this->kec_id->ViewValue = $this->kec_id->CurrentValue;
                    }
                }
            } else {
                $this->kec_id->ViewValue = null;
            }

            // desa_id
            $curVal = strval($this->desa_id->CurrentValue);
            if ($curVal != "") {
                $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
                if ($this->desa_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->desa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->desa_id->Lookup->renderViewRow($rswrk[0]);
                        $this->desa_id->ViewValue = $this->desa_id->displayValue($arwrk);
                    } else {
                        $this->desa_id->ViewValue = $this->desa_id->CurrentValue;
                    }
                }
            } else {
                $this->desa_id->ViewValue = null;
            }

            // pet_alamat
            $this->pet_alamat->ViewValue = $this->pet_alamat->CurrentValue;

            // pet_foto
            $this->pet_foto->UploadPath = $this->pet_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->pet_foto->Upload->DbValue)) {
                $this->pet_foto->ImageWidth = 30;
                $this->pet_foto->ImageHeight = 40;
                $this->pet_foto->ImageAlt = $this->pet_foto->alt();
                $this->pet_foto->ImageCssClass = "ew-image";
                $this->pet_foto->ViewValue = $this->pet_foto->Upload->DbValue;
            } else {
                $this->pet_foto->ViewValue = "";
            }

            // co_id
            $curVal = strval($this->co_id->CurrentValue);
            if ($curVal != "") {
                $this->co_id->ViewValue = $this->co_id->lookupCacheOption($curVal);
                if ($this->co_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->co_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->co_id->Lookup->renderViewRow($rswrk[0]);
                        $this->co_id->ViewValue = $this->co_id->displayValue($arwrk);
                    } else {
                        $this->co_id->ViewValue = $this->co_id->CurrentValue;
                    }
                }
            } else {
                $this->co_id->ViewValue = null;
            }

            // koord_id
            if ($this->koord_id->VirtualValue != "") {
                $this->koord_id->ViewValue = $this->koord_id->VirtualValue;
            } else {
                $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                $curVal = strval($this->koord_id->CurrentValue);
                if ($curVal != "") {
                    $this->koord_id->ViewValue = $this->koord_id->lookupCacheOption($curVal);
                    if ($this->koord_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`koord_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->koord_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->koord_id->Lookup->renderViewRow($rswrk[0]);
                            $this->koord_id->ViewValue = $this->koord_id->displayValue($arwrk);
                        } else {
                            $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                        }
                    }
                } else {
                    $this->koord_id->ViewValue = null;
                }
            }

            // tr_id
            $curVal = strval($this->tr_id->CurrentValue);
            if ($curVal != "") {
                $this->tr_id->ViewValue = $this->tr_id->lookupCacheOption($curVal);
                if ($this->tr_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`tr_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->tr_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->tr_id->Lookup->renderViewRow($rswrk[0]);
                        $this->tr_id->ViewValue = $this->tr_id->displayValue($arwrk);
                    } else {
                        $this->tr_id->ViewValue = $this->tr_id->CurrentValue;
                    }
                }
            } else {
                $this->tr_id->ViewValue = null;
            }

            // pet_id
            $this->pet_id->HrefValue = "";
            $this->pet_id->TooltipValue = "";

            // pet_nama
            $this->pet_nama->HrefValue = "";
            $this->pet_nama->TooltipValue = "";

            // pet_hp
            $this->pet_hp->HrefValue = "";
            $this->pet_hp->TooltipValue = "";

            // prov_id
            $this->prov_id->HrefValue = "";
            $this->prov_id->TooltipValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";
            $this->kab_id->TooltipValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";
            $this->kec_id->TooltipValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";
            $this->desa_id->TooltipValue = "";

            // pet_alamat
            $this->pet_alamat->HrefValue = "";
            $this->pet_alamat->TooltipValue = "";

            // pet_foto
            $this->pet_foto->UploadPath = $this->pet_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->pet_foto->Upload->DbValue)) {
                $this->pet_foto->HrefValue = GetFileUploadUrl($this->pet_foto, $this->pet_foto->htmlDecode($this->pet_foto->Upload->DbValue)); // Add prefix/suffix
                $this->pet_foto->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->pet_foto->HrefValue = FullUrl($this->pet_foto->HrefValue, "href");
                }
            } else {
                $this->pet_foto->HrefValue = "";
            }
            $this->pet_foto->ExportHrefValue = $this->pet_foto->UploadPath . $this->pet_foto->Upload->DbValue;
            $this->pet_foto->TooltipValue = "";
            if ($this->pet_foto->UseColorbox) {
                if (EmptyValue($this->pet_foto->TooltipValue)) {
                    $this->pet_foto->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->pet_foto->LinkAttrs["data-rel"] = "petani_x_pet_foto";
                $this->pet_foto->LinkAttrs->appendClass("ew-lightbox");
            }

            // co_id
            $this->co_id->HrefValue = "";
            $this->co_id->TooltipValue = "";

            // koord_id
            $this->koord_id->HrefValue = "";
            $this->koord_id->TooltipValue = "";

            // tr_id
            $this->tr_id->HrefValue = "";
            $this->tr_id->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // pet_id

            // pet_nama
            $this->pet_nama->setupEditAttributes();
            if (!$this->pet_nama->Raw) {
                $this->pet_nama->CurrentValue = HtmlDecode($this->pet_nama->CurrentValue);
            }
            $this->pet_nama->EditValue = HtmlEncode($this->pet_nama->CurrentValue);
            $this->pet_nama->PlaceHolder = RemoveHtml($this->pet_nama->caption());

            // pet_hp
            $this->pet_hp->setupEditAttributes();
            if (!$this->pet_hp->Raw) {
                $this->pet_hp->CurrentValue = HtmlDecode($this->pet_hp->CurrentValue);
            }
            $this->pet_hp->EditValue = HtmlEncode($this->pet_hp->CurrentValue);
            $this->pet_hp->PlaceHolder = RemoveHtml($this->pet_hp->caption());

            // prov_id
            $this->prov_id->setupEditAttributes();
            $curVal = trim(strval($this->prov_id->CurrentValue));
            if ($curVal != "") {
                $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
            } else {
                $this->prov_id->ViewValue = $this->prov_id->Lookup !== null && is_array($this->prov_id->lookupOptions()) && count($this->prov_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->prov_id->ViewValue !== null) { // Load from cache
                $this->prov_id->EditValue = array_values($this->prov_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`prov_id`", "=", $this->prov_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->prov_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->prov_id->EditValue = $arwrk;
            }
            $this->prov_id->PlaceHolder = RemoveHtml($this->prov_id->caption());

            // kab_id
            $this->kab_id->setupEditAttributes();
            $curVal = trim(strval($this->kab_id->CurrentValue));
            if ($curVal != "") {
                $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
            } else {
                $this->kab_id->ViewValue = $this->kab_id->Lookup !== null && is_array($this->kab_id->lookupOptions()) && count($this->kab_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->kab_id->ViewValue !== null) { // Load from cache
                $this->kab_id->EditValue = array_values($this->kab_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kab_id`", "=", $this->kab_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->kab_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->kab_id->EditValue = $arwrk;
            }
            $this->kab_id->PlaceHolder = RemoveHtml($this->kab_id->caption());

            // kec_id
            $this->kec_id->setupEditAttributes();
            $curVal = trim(strval($this->kec_id->CurrentValue));
            if ($curVal != "") {
                $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
            } else {
                $this->kec_id->ViewValue = $this->kec_id->Lookup !== null && is_array($this->kec_id->lookupOptions()) && count($this->kec_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->kec_id->ViewValue !== null) { // Load from cache
                $this->kec_id->EditValue = array_values($this->kec_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kec_id`", "=", $this->kec_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->kec_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->kec_id->EditValue = $arwrk;
            }
            $this->kec_id->PlaceHolder = RemoveHtml($this->kec_id->caption());

            // desa_id
            $this->desa_id->setupEditAttributes();
            $curVal = trim(strval($this->desa_id->CurrentValue));
            if ($curVal != "") {
                $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
            } else {
                $this->desa_id->ViewValue = $this->desa_id->Lookup !== null && is_array($this->desa_id->lookupOptions()) && count($this->desa_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->desa_id->ViewValue !== null) { // Load from cache
                $this->desa_id->EditValue = array_values($this->desa_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`desa_id`", "=", $this->desa_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->desa_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->desa_id->EditValue = $arwrk;
            }
            $this->desa_id->PlaceHolder = RemoveHtml($this->desa_id->caption());

            // pet_alamat
            $this->pet_alamat->setupEditAttributes();
            if (!$this->pet_alamat->Raw) {
                $this->pet_alamat->CurrentValue = HtmlDecode($this->pet_alamat->CurrentValue);
            }
            $this->pet_alamat->EditValue = HtmlEncode($this->pet_alamat->CurrentValue);
            $this->pet_alamat->PlaceHolder = RemoveHtml($this->pet_alamat->caption());

            // pet_foto
            $this->pet_foto->setupEditAttributes();
            $this->pet_foto->UploadPath = $this->pet_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->pet_foto->Upload->DbValue)) {
                $this->pet_foto->ImageWidth = 30;
                $this->pet_foto->ImageHeight = 40;
                $this->pet_foto->ImageAlt = $this->pet_foto->alt();
                $this->pet_foto->ImageCssClass = "ew-image";
                $this->pet_foto->EditValue = $this->pet_foto->Upload->DbValue;
            } else {
                $this->pet_foto->EditValue = "";
            }
            if (!EmptyValue($this->pet_foto->CurrentValue)) {
                $this->pet_foto->Upload->FileName = $this->pet_foto->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->pet_foto);
            }

            // co_id
            $this->co_id->setupEditAttributes();
            $curVal = trim(strval($this->co_id->CurrentValue));
            if ($curVal != "") {
                $this->co_id->ViewValue = $this->co_id->lookupCacheOption($curVal);
            } else {
                $this->co_id->ViewValue = $this->co_id->Lookup !== null && is_array($this->co_id->lookupOptions()) && count($this->co_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->co_id->ViewValue !== null) { // Load from cache
                $this->co_id->EditValue = array_values($this->co_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`co_id`", "=", $this->co_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->co_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->co_id->EditValue = $arwrk;
            }
            $this->co_id->PlaceHolder = RemoveHtml($this->co_id->caption());

            // koord_id
            $this->koord_id->setupEditAttributes();
            $this->koord_id->EditValue = HtmlEncode($this->koord_id->CurrentValue);
            $this->koord_id->PlaceHolder = RemoveHtml($this->koord_id->caption());

            // tr_id
            $this->tr_id->setupEditAttributes();
            $curVal = trim(strval($this->tr_id->CurrentValue));
            if ($curVal != "") {
                $this->tr_id->ViewValue = $this->tr_id->lookupCacheOption($curVal);
            } else {
                $this->tr_id->ViewValue = $this->tr_id->Lookup !== null && is_array($this->tr_id->lookupOptions()) && count($this->tr_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->tr_id->ViewValue !== null) { // Load from cache
                $this->tr_id->EditValue = array_values($this->tr_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`tr_id`", "=", $this->tr_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->tr_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->tr_id->EditValue = $arwrk;
            }
            $this->tr_id->PlaceHolder = RemoveHtml($this->tr_id->caption());

            // Add refer script

            // pet_id
            $this->pet_id->HrefValue = "";

            // pet_nama
            $this->pet_nama->HrefValue = "";

            // pet_hp
            $this->pet_hp->HrefValue = "";

            // prov_id
            $this->prov_id->HrefValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";

            // pet_alamat
            $this->pet_alamat->HrefValue = "";

            // pet_foto
            $this->pet_foto->UploadPath = $this->pet_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->pet_foto->Upload->DbValue)) {
                $this->pet_foto->HrefValue = GetFileUploadUrl($this->pet_foto, $this->pet_foto->htmlDecode($this->pet_foto->Upload->DbValue)); // Add prefix/suffix
                $this->pet_foto->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->pet_foto->HrefValue = FullUrl($this->pet_foto->HrefValue, "href");
                }
            } else {
                $this->pet_foto->HrefValue = "";
            }
            $this->pet_foto->ExportHrefValue = $this->pet_foto->UploadPath . $this->pet_foto->Upload->DbValue;

            // co_id
            $this->co_id->HrefValue = "";

            // koord_id
            $this->koord_id->HrefValue = "";

            // tr_id
            $this->tr_id->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->pet_id->Visible && $this->pet_id->Required) {
            if (!$this->pet_id->IsDetailKey && EmptyValue($this->pet_id->FormValue)) {
                $this->pet_id->addErrorMessage(str_replace("%s", $this->pet_id->caption(), $this->pet_id->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->pet_id->FormValue)) {
            $this->pet_id->addErrorMessage($this->pet_id->getErrorMessage(false));
        }
        if ($this->pet_nama->Visible && $this->pet_nama->Required) {
            if (!$this->pet_nama->IsDetailKey && EmptyValue($this->pet_nama->FormValue)) {
                $this->pet_nama->addErrorMessage(str_replace("%s", $this->pet_nama->caption(), $this->pet_nama->RequiredErrorMessage));
            }
        }
        if ($this->pet_hp->Visible && $this->pet_hp->Required) {
            if (!$this->pet_hp->IsDetailKey && EmptyValue($this->pet_hp->FormValue)) {
                $this->pet_hp->addErrorMessage(str_replace("%s", $this->pet_hp->caption(), $this->pet_hp->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->pet_hp->FormValue)) {
            $this->pet_hp->addErrorMessage($this->pet_hp->getErrorMessage(false));
        }
        if ($this->prov_id->Visible && $this->prov_id->Required) {
            if (!$this->prov_id->IsDetailKey && EmptyValue($this->prov_id->FormValue)) {
                $this->prov_id->addErrorMessage(str_replace("%s", $this->prov_id->caption(), $this->prov_id->RequiredErrorMessage));
            }
        }
        if ($this->kab_id->Visible && $this->kab_id->Required) {
            if (!$this->kab_id->IsDetailKey && EmptyValue($this->kab_id->FormValue)) {
                $this->kab_id->addErrorMessage(str_replace("%s", $this->kab_id->caption(), $this->kab_id->RequiredErrorMessage));
            }
        }
        if ($this->kec_id->Visible && $this->kec_id->Required) {
            if (!$this->kec_id->IsDetailKey && EmptyValue($this->kec_id->FormValue)) {
                $this->kec_id->addErrorMessage(str_replace("%s", $this->kec_id->caption(), $this->kec_id->RequiredErrorMessage));
            }
        }
        if ($this->desa_id->Visible && $this->desa_id->Required) {
            if (!$this->desa_id->IsDetailKey && EmptyValue($this->desa_id->FormValue)) {
                $this->desa_id->addErrorMessage(str_replace("%s", $this->desa_id->caption(), $this->desa_id->RequiredErrorMessage));
            }
        }
        if ($this->pet_alamat->Visible && $this->pet_alamat->Required) {
            if (!$this->pet_alamat->IsDetailKey && EmptyValue($this->pet_alamat->FormValue)) {
                $this->pet_alamat->addErrorMessage(str_replace("%s", $this->pet_alamat->caption(), $this->pet_alamat->RequiredErrorMessage));
            }
        }
        if ($this->pet_foto->Visible && $this->pet_foto->Required) {
            if ($this->pet_foto->Upload->FileName == "" && !$this->pet_foto->Upload->KeepFile) {
                $this->pet_foto->addErrorMessage(str_replace("%s", $this->pet_foto->caption(), $this->pet_foto->RequiredErrorMessage));
            }
        }
        if ($this->co_id->Visible && $this->co_id->Required) {
            if (!$this->co_id->IsDetailKey && EmptyValue($this->co_id->FormValue)) {
                $this->co_id->addErrorMessage(str_replace("%s", $this->co_id->caption(), $this->co_id->RequiredErrorMessage));
            }
        }
        if ($this->koord_id->Visible && $this->koord_id->Required) {
            if (!$this->koord_id->IsDetailKey && EmptyValue($this->koord_id->FormValue)) {
                $this->koord_id->addErrorMessage(str_replace("%s", $this->koord_id->caption(), $this->koord_id->RequiredErrorMessage));
            }
        }
        if ($this->tr_id->Visible && $this->tr_id->Required) {
            if (!$this->tr_id->IsDetailKey && EmptyValue($this->tr_id->FormValue)) {
                $this->tr_id->addErrorMessage(str_replace("%s", $this->tr_id->caption(), $this->tr_id->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KontrakList");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("PetaniList"), "", $this->TableVar, true);
        $pageId = "addopt";
        $Breadcrumb->add("addopt", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_prov_id":
                    break;
                case "x_kab_id":
                    break;
                case "x_kec_id":
                    break;
                case "x_desa_id":
                    break;
                case "x_co_id":
                    break;
                case "x_koord_id":
                    break;
                case "x_tr_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
