<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class PesertaList extends Peserta
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PesertaList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fpesertalist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "PesertaList";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->pes_id->setVisibility();
        $this->pes_nama->setVisibility();
        $this->sos_id->setVisibility();
        $this->co_id->setVisibility();
        $this->prov_id->setVisibility();
        $this->kab_id->setVisibility();
        $this->kec_id->setVisibility();
        $this->desa_id->setVisibility();
        $this->pes_alamat->setVisibility();
        $this->pes_hp->setVisibility();
        $this->pes_foto->setVisibility();
        $this->pes_luas_lahan->setVisibility();
        $this->pes_r_tanam_tgl->setVisibility();
        $this->pes_foto_lahan->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'peserta';
        $this->TableName = 'peserta';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (peserta)
        if (!isset($GLOBALS["peserta"]) || get_class($GLOBALS["peserta"]) == PROJECT_NAMESPACE . "peserta") {
            $GLOBALS["peserta"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "PesertaAdd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "PesertaDelete";
        $this->MultiUpdateUrl = "PesertaUpdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'peserta');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(["Tag" => "td", "TableVar" => $this->TableVar]);

        // Export options
        $this->ExportOptions = new ListOptions(["TagClassName" => "ew-export-option"]);

        // Import options
        $this->ImportOptions = new ListOptions(["TagClassName" => "ew-import-option"]);

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions([
            "TagClassName" => "ew-add-edit-option",
            "UseDropDownButton" => false,
            "DropDownButtonPhrase" => $Language->phrase("ButtonAddEdit"),
            "UseButtonGroup" => true
        ]);

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(["TagClassName" => "ew-detail-option"]);
        // Actions
        $this->OtherOptions["action"] = new ListOptions(["TagClassName" => "ew-action-option"]);

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions([
            "TableVar" => $this->TableVar,
            "TagClassName" => "ew-column-option",
            "ButtonGroupClass" => "ew-column-dropdown",
            "UseDropDownButton" => true,
            "DropDownButtonPhrase" => $Language->phrase("Columns"),
            "DropDownAutoClose" => "outside",
            "UseButtonGroup" => false
        ]);

        // Filter options
        $this->FilterOptions = new ListOptions(["TagClassName" => "ew-filter-option"]);

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "PesertaView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->pes_foto->OldUploadPath = $this->pes_foto->getUploadPath(); // PHP
                $this->pes_foto->UploadPath = $this->pes_foto->OldUploadPath;
                $this->pes_foto_lahan->OldUploadPath = $this->pes_foto_lahan->getUploadPath(); // PHP
                $this->pes_foto_lahan->UploadPath = $this->pes_foto_lahan->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['pes_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->pes_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 100;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $RowCount = 0;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load recordset from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load recordset
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new NumericPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport = $DashboardReport || ConvertToBool(Param(Config("PAGE_DASHBOARD"), false));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up custom action (compatible with old version)
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions->add($name, $action);
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->sos_id);
        $this->setupLookupOptions($this->co_id);
        $this->setupLookupOptions($this->prov_id);
        $this->setupLookupOptions($this->kab_id);
        $this->setupLookupOptions($this->kec_id);
        $this->setupLookupOptions($this->desa_id);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fpesertagrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $filter = ""; // Filter
        $query = ""; // Query builder

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 100; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        $filter = "";
        if (!$Security->canList()) {
            $filter = "(0=1)"; // Filter all records
        }
        AddFilter($filter, $this->DbDetailFilter);
        AddFilter($filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $filter;
        } else {
            $this->setSessionWhere($filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Allow) {
                if ($listaction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listaction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset->close();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new NumericPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 100; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";
        $filterList = Concat($filterList, $this->pes_id->AdvancedSearch->toJson(), ","); // Field pes_id
        $filterList = Concat($filterList, $this->pes_nama->AdvancedSearch->toJson(), ","); // Field pes_nama
        $filterList = Concat($filterList, $this->sos_id->AdvancedSearch->toJson(), ","); // Field sos_id
        $filterList = Concat($filterList, $this->co_id->AdvancedSearch->toJson(), ","); // Field co_id
        $filterList = Concat($filterList, $this->prov_id->AdvancedSearch->toJson(), ","); // Field prov_id
        $filterList = Concat($filterList, $this->kab_id->AdvancedSearch->toJson(), ","); // Field kab_id
        $filterList = Concat($filterList, $this->kec_id->AdvancedSearch->toJson(), ","); // Field kec_id
        $filterList = Concat($filterList, $this->desa_id->AdvancedSearch->toJson(), ","); // Field desa_id
        $filterList = Concat($filterList, $this->pes_alamat->AdvancedSearch->toJson(), ","); // Field pes_alamat
        $filterList = Concat($filterList, $this->pes_hp->AdvancedSearch->toJson(), ","); // Field pes_hp
        $filterList = Concat($filterList, $this->pes_foto->AdvancedSearch->toJson(), ","); // Field pes_foto
        $filterList = Concat($filterList, $this->pes_luas_lahan->AdvancedSearch->toJson(), ","); // Field pes_luas_lahan
        $filterList = Concat($filterList, $this->pes_r_tanam_tgl->AdvancedSearch->toJson(), ","); // Field pes_r_tanam_tgl
        $filterList = Concat($filterList, $this->pes_foto_lahan->AdvancedSearch->toJson(), ","); // Field pes_foto_lahan
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fpesertasrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field pes_id
        $this->pes_id->AdvancedSearch->SearchValue = @$filter["x_pes_id"];
        $this->pes_id->AdvancedSearch->SearchOperator = @$filter["z_pes_id"];
        $this->pes_id->AdvancedSearch->SearchCondition = @$filter["v_pes_id"];
        $this->pes_id->AdvancedSearch->SearchValue2 = @$filter["y_pes_id"];
        $this->pes_id->AdvancedSearch->SearchOperator2 = @$filter["w_pes_id"];
        $this->pes_id->AdvancedSearch->save();

        // Field pes_nama
        $this->pes_nama->AdvancedSearch->SearchValue = @$filter["x_pes_nama"];
        $this->pes_nama->AdvancedSearch->SearchOperator = @$filter["z_pes_nama"];
        $this->pes_nama->AdvancedSearch->SearchCondition = @$filter["v_pes_nama"];
        $this->pes_nama->AdvancedSearch->SearchValue2 = @$filter["y_pes_nama"];
        $this->pes_nama->AdvancedSearch->SearchOperator2 = @$filter["w_pes_nama"];
        $this->pes_nama->AdvancedSearch->save();

        // Field sos_id
        $this->sos_id->AdvancedSearch->SearchValue = @$filter["x_sos_id"];
        $this->sos_id->AdvancedSearch->SearchOperator = @$filter["z_sos_id"];
        $this->sos_id->AdvancedSearch->SearchCondition = @$filter["v_sos_id"];
        $this->sos_id->AdvancedSearch->SearchValue2 = @$filter["y_sos_id"];
        $this->sos_id->AdvancedSearch->SearchOperator2 = @$filter["w_sos_id"];
        $this->sos_id->AdvancedSearch->save();

        // Field co_id
        $this->co_id->AdvancedSearch->SearchValue = @$filter["x_co_id"];
        $this->co_id->AdvancedSearch->SearchOperator = @$filter["z_co_id"];
        $this->co_id->AdvancedSearch->SearchCondition = @$filter["v_co_id"];
        $this->co_id->AdvancedSearch->SearchValue2 = @$filter["y_co_id"];
        $this->co_id->AdvancedSearch->SearchOperator2 = @$filter["w_co_id"];
        $this->co_id->AdvancedSearch->save();

        // Field prov_id
        $this->prov_id->AdvancedSearch->SearchValue = @$filter["x_prov_id"];
        $this->prov_id->AdvancedSearch->SearchOperator = @$filter["z_prov_id"];
        $this->prov_id->AdvancedSearch->SearchCondition = @$filter["v_prov_id"];
        $this->prov_id->AdvancedSearch->SearchValue2 = @$filter["y_prov_id"];
        $this->prov_id->AdvancedSearch->SearchOperator2 = @$filter["w_prov_id"];
        $this->prov_id->AdvancedSearch->save();

        // Field kab_id
        $this->kab_id->AdvancedSearch->SearchValue = @$filter["x_kab_id"];
        $this->kab_id->AdvancedSearch->SearchOperator = @$filter["z_kab_id"];
        $this->kab_id->AdvancedSearch->SearchCondition = @$filter["v_kab_id"];
        $this->kab_id->AdvancedSearch->SearchValue2 = @$filter["y_kab_id"];
        $this->kab_id->AdvancedSearch->SearchOperator2 = @$filter["w_kab_id"];
        $this->kab_id->AdvancedSearch->save();

        // Field kec_id
        $this->kec_id->AdvancedSearch->SearchValue = @$filter["x_kec_id"];
        $this->kec_id->AdvancedSearch->SearchOperator = @$filter["z_kec_id"];
        $this->kec_id->AdvancedSearch->SearchCondition = @$filter["v_kec_id"];
        $this->kec_id->AdvancedSearch->SearchValue2 = @$filter["y_kec_id"];
        $this->kec_id->AdvancedSearch->SearchOperator2 = @$filter["w_kec_id"];
        $this->kec_id->AdvancedSearch->save();

        // Field desa_id
        $this->desa_id->AdvancedSearch->SearchValue = @$filter["x_desa_id"];
        $this->desa_id->AdvancedSearch->SearchOperator = @$filter["z_desa_id"];
        $this->desa_id->AdvancedSearch->SearchCondition = @$filter["v_desa_id"];
        $this->desa_id->AdvancedSearch->SearchValue2 = @$filter["y_desa_id"];
        $this->desa_id->AdvancedSearch->SearchOperator2 = @$filter["w_desa_id"];
        $this->desa_id->AdvancedSearch->save();

        // Field pes_alamat
        $this->pes_alamat->AdvancedSearch->SearchValue = @$filter["x_pes_alamat"];
        $this->pes_alamat->AdvancedSearch->SearchOperator = @$filter["z_pes_alamat"];
        $this->pes_alamat->AdvancedSearch->SearchCondition = @$filter["v_pes_alamat"];
        $this->pes_alamat->AdvancedSearch->SearchValue2 = @$filter["y_pes_alamat"];
        $this->pes_alamat->AdvancedSearch->SearchOperator2 = @$filter["w_pes_alamat"];
        $this->pes_alamat->AdvancedSearch->save();

        // Field pes_hp
        $this->pes_hp->AdvancedSearch->SearchValue = @$filter["x_pes_hp"];
        $this->pes_hp->AdvancedSearch->SearchOperator = @$filter["z_pes_hp"];
        $this->pes_hp->AdvancedSearch->SearchCondition = @$filter["v_pes_hp"];
        $this->pes_hp->AdvancedSearch->SearchValue2 = @$filter["y_pes_hp"];
        $this->pes_hp->AdvancedSearch->SearchOperator2 = @$filter["w_pes_hp"];
        $this->pes_hp->AdvancedSearch->save();

        // Field pes_foto
        $this->pes_foto->AdvancedSearch->SearchValue = @$filter["x_pes_foto"];
        $this->pes_foto->AdvancedSearch->SearchOperator = @$filter["z_pes_foto"];
        $this->pes_foto->AdvancedSearch->SearchCondition = @$filter["v_pes_foto"];
        $this->pes_foto->AdvancedSearch->SearchValue2 = @$filter["y_pes_foto"];
        $this->pes_foto->AdvancedSearch->SearchOperator2 = @$filter["w_pes_foto"];
        $this->pes_foto->AdvancedSearch->save();

        // Field pes_luas_lahan
        $this->pes_luas_lahan->AdvancedSearch->SearchValue = @$filter["x_pes_luas_lahan"];
        $this->pes_luas_lahan->AdvancedSearch->SearchOperator = @$filter["z_pes_luas_lahan"];
        $this->pes_luas_lahan->AdvancedSearch->SearchCondition = @$filter["v_pes_luas_lahan"];
        $this->pes_luas_lahan->AdvancedSearch->SearchValue2 = @$filter["y_pes_luas_lahan"];
        $this->pes_luas_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_pes_luas_lahan"];
        $this->pes_luas_lahan->AdvancedSearch->save();

        // Field pes_r_tanam_tgl
        $this->pes_r_tanam_tgl->AdvancedSearch->SearchValue = @$filter["x_pes_r_tanam_tgl"];
        $this->pes_r_tanam_tgl->AdvancedSearch->SearchOperator = @$filter["z_pes_r_tanam_tgl"];
        $this->pes_r_tanam_tgl->AdvancedSearch->SearchCondition = @$filter["v_pes_r_tanam_tgl"];
        $this->pes_r_tanam_tgl->AdvancedSearch->SearchValue2 = @$filter["y_pes_r_tanam_tgl"];
        $this->pes_r_tanam_tgl->AdvancedSearch->SearchOperator2 = @$filter["w_pes_r_tanam_tgl"];
        $this->pes_r_tanam_tgl->AdvancedSearch->save();

        // Field pes_foto_lahan
        $this->pes_foto_lahan->AdvancedSearch->SearchValue = @$filter["x_pes_foto_lahan"];
        $this->pes_foto_lahan->AdvancedSearch->SearchOperator = @$filter["z_pes_foto_lahan"];
        $this->pes_foto_lahan->AdvancedSearch->SearchCondition = @$filter["v_pes_foto_lahan"];
        $this->pes_foto_lahan->AdvancedSearch->SearchValue2 = @$filter["y_pes_foto_lahan"];
        $this->pes_foto_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_pes_foto_lahan"];
        $this->pes_foto_lahan->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->pes_id, $default, false); // pes_id
        $this->buildSearchSql($where, $this->pes_nama, $default, false); // pes_nama
        $this->buildSearchSql($where, $this->sos_id, $default, false); // sos_id
        $this->buildSearchSql($where, $this->co_id, $default, false); // co_id
        $this->buildSearchSql($where, $this->prov_id, $default, false); // prov_id
        $this->buildSearchSql($where, $this->kab_id, $default, false); // kab_id
        $this->buildSearchSql($where, $this->kec_id, $default, false); // kec_id
        $this->buildSearchSql($where, $this->desa_id, $default, false); // desa_id
        $this->buildSearchSql($where, $this->pes_alamat, $default, false); // pes_alamat
        $this->buildSearchSql($where, $this->pes_hp, $default, false); // pes_hp
        $this->buildSearchSql($where, $this->pes_foto, $default, false); // pes_foto
        $this->buildSearchSql($where, $this->pes_luas_lahan, $default, false); // pes_luas_lahan
        $this->buildSearchSql($where, $this->pes_r_tanam_tgl, $default, false); // pes_r_tanam_tgl
        $this->buildSearchSql($where, $this->pes_foto_lahan, $default, false); // pes_foto_lahan

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->pes_id->AdvancedSearch->save(); // pes_id
            $this->pes_nama->AdvancedSearch->save(); // pes_nama
            $this->sos_id->AdvancedSearch->save(); // sos_id
            $this->co_id->AdvancedSearch->save(); // co_id
            $this->prov_id->AdvancedSearch->save(); // prov_id
            $this->kab_id->AdvancedSearch->save(); // kab_id
            $this->kec_id->AdvancedSearch->save(); // kec_id
            $this->desa_id->AdvancedSearch->save(); // desa_id
            $this->pes_alamat->AdvancedSearch->save(); // pes_alamat
            $this->pes_hp->AdvancedSearch->save(); // pes_hp
            $this->pes_foto->AdvancedSearch->save(); // pes_foto
            $this->pes_luas_lahan->AdvancedSearch->save(); // pes_luas_lahan
            $this->pes_r_tanam_tgl->AdvancedSearch->save(); // pes_r_tanam_tgl
            $this->pes_foto_lahan->AdvancedSearch->save(); // pes_foto_lahan

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Parse query builder rule function
    protected function parseRules($group, $fieldName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $parts[] = "(" . " " . $this->parseRules($rule, $fieldName) . " " . ")" . " ";
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                if (!$fld) {
                    throw new \Exception("Failed to find field '" . $field . "'");
                }
                if ($fieldName == "" || $fld->Name == $fieldName) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && ($rule["value"] ?? false) || IsNullOrEmptyOperator($fldOpr)) {
                        $rule["value"] = !is_array($rule["value"]) ? [$rule["value"]] : $rule["value"];
                        $fldVal = $rule["value"][0];
                        if (is_array($fldVal)) {
                            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld->isMultiSelect()) {
                                $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                            } else {
                                $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                if (is_array($fldVal2)) {
                                    $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                }
                                $parts[] = GetSearchSql(
                                    $fld,
                                    ConvertSearchValue($fldVal, $fldOpr, $fld), // $fldVal
                                    $fldOpr,
                                    "", // $fldCond not used
                                    ConvertSearchValue($fldVal2, $fldOpr, $fld), // $fldVal2
                                    "", // $fldOpr2 not used
                                    $this->Dbid
                                );
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = implode(" " . $group["condition"] . " ", array_filter($parts));
        if ($group["not"] ?? false) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = Post("rules") ?? $this->getSessionRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field pes_id
        $filter = $this->queryBuilderWhere("pes_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pes_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pes_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pes_nama
        $filter = $this->queryBuilderWhere("pes_nama");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pes_nama, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pes_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sos_id
        $filter = $this->queryBuilderWhere("sos_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sos_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sos_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field co_id
        $filter = $this->queryBuilderWhere("co_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->co_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->co_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field prov_id
        $filter = $this->queryBuilderWhere("prov_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->prov_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->prov_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field kab_id
        $filter = $this->queryBuilderWhere("kab_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->kab_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->kab_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field kec_id
        $filter = $this->queryBuilderWhere("kec_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->kec_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->kec_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field desa_id
        $filter = $this->queryBuilderWhere("desa_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->desa_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->desa_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pes_alamat
        $filter = $this->queryBuilderWhere("pes_alamat");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pes_alamat, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pes_alamat->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pes_hp
        $filter = $this->queryBuilderWhere("pes_hp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pes_hp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pes_hp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pes_foto
        $filter = $this->queryBuilderWhere("pes_foto");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pes_foto, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pes_foto->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pes_luas_lahan
        $filter = $this->queryBuilderWhere("pes_luas_lahan");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pes_luas_lahan, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pes_luas_lahan->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pes_r_tanam_tgl
        $filter = $this->queryBuilderWhere("pes_r_tanam_tgl");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pes_r_tanam_tgl, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pes_r_tanam_tgl->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pes_foto_lahan
        $filter = $this->queryBuilderWhere("pes_foto_lahan");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pes_foto_lahan, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pes_foto_lahan->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->pes_nama;
        $searchFlds[] = &$this->pes_alamat;
        $searchFlds[] = &$this->pes_hp;
        $searchFlds[] = &$this->pes_foto;
        $searchFlds[] = &$this->pes_foto_lahan;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->pes_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pes_nama->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sos_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->co_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->prov_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->kab_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->kec_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->desa_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pes_alamat->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pes_hp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pes_foto->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pes_luas_lahan->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pes_r_tanam_tgl->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pes_foto_lahan->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->pes_id->AdvancedSearch->unsetSession();
        $this->pes_nama->AdvancedSearch->unsetSession();
        $this->sos_id->AdvancedSearch->unsetSession();
        $this->co_id->AdvancedSearch->unsetSession();
        $this->prov_id->AdvancedSearch->unsetSession();
        $this->kab_id->AdvancedSearch->unsetSession();
        $this->kec_id->AdvancedSearch->unsetSession();
        $this->desa_id->AdvancedSearch->unsetSession();
        $this->pes_alamat->AdvancedSearch->unsetSession();
        $this->pes_hp->AdvancedSearch->unsetSession();
        $this->pes_foto->AdvancedSearch->unsetSession();
        $this->pes_luas_lahan->AdvancedSearch->unsetSession();
        $this->pes_r_tanam_tgl->AdvancedSearch->unsetSession();
        $this->pes_foto_lahan->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->pes_id->AdvancedSearch->load();
        $this->pes_nama->AdvancedSearch->load();
        $this->sos_id->AdvancedSearch->load();
        $this->co_id->AdvancedSearch->load();
        $this->prov_id->AdvancedSearch->load();
        $this->kab_id->AdvancedSearch->load();
        $this->kec_id->AdvancedSearch->load();
        $this->desa_id->AdvancedSearch->load();
        $this->pes_alamat->AdvancedSearch->load();
        $this->pes_hp->AdvancedSearch->load();
        $this->pes_foto->AdvancedSearch->load();
        $this->pes_luas_lahan->AdvancedSearch->load();
        $this->pes_r_tanam_tgl->AdvancedSearch->load();
        $this->pes_foto_lahan->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
            $defaultSortList = ""; // Set up default sort
            if ($this->getSessionOrderByList() == "" && $defaultSortList != "") {
                $this->setSessionOrderByList($defaultSortList);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->pes_id); // pes_id
            $this->updateSort($this->pes_nama); // pes_nama
            $this->updateSort($this->sos_id); // sos_id
            $this->updateSort($this->co_id); // co_id
            $this->updateSort($this->prov_id); // prov_id
            $this->updateSort($this->kab_id); // kab_id
            $this->updateSort($this->kec_id); // kec_id
            $this->updateSort($this->desa_id); // desa_id
            $this->updateSort($this->pes_alamat); // pes_alamat
            $this->updateSort($this->pes_hp); // pes_hp
            $this->updateSort($this->pes_foto); // pes_foto
            $this->updateSort($this->pes_luas_lahan); // pes_luas_lahan
            $this->updateSort($this->pes_r_tanam_tgl); // pes_r_tanam_tgl
            $this->updateSort($this->pes_foto_lahan); // pes_foto_lahan
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->setSessionOrderByList($orderBy);
                $this->pes_id->setSort("");
                $this->pes_nama->setSort("");
                $this->sos_id->setSort("");
                $this->co_id->setSort("");
                $this->prov_id->setSort("");
                $this->kab_id->setSort("");
                $this->kec_id->setSort("");
                $this->desa_id->setSort("");
                $this->pes_alamat->setSort("");
                $this->pes_hp->setSort("");
                $this->pes_foto->setSort("");
                $this->pes_luas_lahan->setSort("");
                $this->pes_r_tanam_tgl->setSort("");
                $this->pes_foto_lahan->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = false;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
            // Set up list options (to be implemented by extensions)
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm, $UserProfile;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"peserta\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"peserta\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"peserta\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions->Items as $listaction) {
                $action = $listaction->Action;
                $allowed = $listaction->Allow;
                if ($listaction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
                    $link = "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . HtmlTitle($caption) . "\" data-ew-action=\"submit\" form=\"fpesertalist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listaction->toDataAttrs() . ">" . $icon . " " . $listaction->Caption . "</button></li>";
                    if ($link != "") {
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" data-ew-action=\"submit\" form=\"fpesertalist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listaction->toDataAttrs() . ">" . $icon . " " . $listaction->Caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->pes_id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"peserta\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Add multi delete
        $item = &$option->add("multidelete");
        $item->Body = "<button type=\"button\" class=\"ew-action ew-multi-delete\" title=\"" .
            HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" data-caption=\"" .
            HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" form=\"fpesertalist\"" .
            " data-ew-action=\"" . ($this->UseAjaxActions ? "inline" : "submit") . "\"" .
            ($this->UseAjaxActions ? " data-action=\"delete\"" : "") .
            " data-url=\"" . GetUrl($this->MultiDeleteUrl) . "\"" .
            ($this->InlineDelete ? " data-msg=\"" . HtmlEncode($Language->phrase("DeleteConfirm")) . "\" data-data='{\"action\":\"delete\"}'" : " data-data='{\"action\":\"show\"}'") .
            ">" . $Language->phrase("DeleteSelectedLink") . "</button>";
        $item->Visible = $Security->canDelete();

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $option->add("pes_id", $this->createColumnOption("pes_id"));
            $option->add("pes_nama", $this->createColumnOption("pes_nama"));
            $option->add("sos_id", $this->createColumnOption("sos_id"));
            $option->add("co_id", $this->createColumnOption("co_id"));
            $option->add("prov_id", $this->createColumnOption("prov_id"));
            $option->add("kab_id", $this->createColumnOption("kab_id"));
            $option->add("kec_id", $this->createColumnOption("kec_id"));
            $option->add("desa_id", $this->createColumnOption("desa_id"));
            $option->add("pes_alamat", $this->createColumnOption("pes_alamat"));
            $option->add("pes_hp", $this->createColumnOption("pes_hp"));
            $option->add("pes_foto", $this->createColumnOption("pes_foto"));
            $option->add("pes_luas_lahan", $this->createColumnOption("pes_luas_lahan"));
            $option->add("pes_r_tanam_tgl", $this->createColumnOption("pes_r_tanam_tgl"));
            $option->add("pes_foto_lahan", $this->createColumnOption("pes_foto_lahan"));
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = false;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fpesertasrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fpesertasrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Create new column option
    public function createColumnOption($name)
    {
        $field = $this->Fields[$name] ?? false;
        if ($field && $field->Visible) {
            $item = new ListOption($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
            return $item;
        }
        return null;
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listaction->Action);
                $caption = $listaction->Caption;
                $icon = ($listaction->Icon != "") ? '<i class="' . HtmlEncode($listaction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fpesertalist"' . $listaction->toDataAttrs() . '>' . $icon . '</button>';
                $item->Visible = $listaction->Allow;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $userlist = "";
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            if (array_key_exists($userAction, $this->ListActions->Items)) {
                $this->UserAction = $userAction;
                $actionCaption = $this->ListActions[$userAction]->Caption;
                if (!$this->ListActions[$userAction]->Allow) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            }
            $this->CurrentFilter = $filter;
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rows = ExecuteRows($sql, $conn);
            $count = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($count > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedCount = $count;
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        $conn->commit();
                    }
                    if ($this->getSuccessMessage() == "" && !ob_get_length() && !$Response->getBody()->getSize()) { // No output
                        $this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        $conn->rollback();
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if ($this->getSuccessMessage() != "") {
                    echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                    $this->clearSuccessMessage(); // Clear message
                }
                if ($this->getFailureMessage() != "") {
                    echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                    $this->clearFailureMessage(); // Clear message
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->Recordset && !$this->Recordset->EOF) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = ROWTYPE_AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_peserta", "data-rowtype" => ROWTYPE_ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = ROWTYPE_ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->Recordset); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = ROWTYPE_VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = ROWTYPE_ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == ROWTYPE_ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == ROWTYPE_EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_peserta",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == ROWTYPE_ADD || $this->isEdit() && $this->RowType == ROWTYPE_EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // pes_id
        if ($this->pes_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pes_id->AdvancedSearch->SearchValue != "" || $this->pes_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pes_nama
        if ($this->pes_nama->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pes_nama->AdvancedSearch->SearchValue != "" || $this->pes_nama->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sos_id
        if ($this->sos_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sos_id->AdvancedSearch->SearchValue != "" || $this->sos_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // co_id
        if ($this->co_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->co_id->AdvancedSearch->SearchValue != "" || $this->co_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // prov_id
        if ($this->prov_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->prov_id->AdvancedSearch->SearchValue != "" || $this->prov_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // kab_id
        if ($this->kab_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->kab_id->AdvancedSearch->SearchValue != "" || $this->kab_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // kec_id
        if ($this->kec_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->kec_id->AdvancedSearch->SearchValue != "" || $this->kec_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // desa_id
        if ($this->desa_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->desa_id->AdvancedSearch->SearchValue != "" || $this->desa_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pes_alamat
        if ($this->pes_alamat->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pes_alamat->AdvancedSearch->SearchValue != "" || $this->pes_alamat->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pes_hp
        if ($this->pes_hp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pes_hp->AdvancedSearch->SearchValue != "" || $this->pes_hp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pes_foto
        if ($this->pes_foto->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pes_foto->AdvancedSearch->SearchValue != "" || $this->pes_foto->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pes_luas_lahan
        if ($this->pes_luas_lahan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pes_luas_lahan->AdvancedSearch->SearchValue != "" || $this->pes_luas_lahan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pes_r_tanam_tgl
        if ($this->pes_r_tanam_tgl->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pes_r_tanam_tgl->AdvancedSearch->SearchValue != "" || $this->pes_r_tanam_tgl->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pes_foto_lahan
        if ($this->pes_foto_lahan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pes_foto_lahan->AdvancedSearch->SearchValue != "" || $this->pes_foto_lahan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->pes_id->setDbValue($row['pes_id']);
        $this->pes_nama->setDbValue($row['pes_nama']);
        $this->sos_id->setDbValue($row['sos_id']);
        $this->co_id->setDbValue($row['co_id']);
        $this->prov_id->setDbValue($row['prov_id']);
        if (array_key_exists('EV__prov_id', $row)) {
            $this->prov_id->VirtualValue = $row['EV__prov_id']; // Set up virtual field value
        } else {
            $this->prov_id->VirtualValue = ""; // Clear value
        }
        $this->kab_id->setDbValue($row['kab_id']);
        if (array_key_exists('EV__kab_id', $row)) {
            $this->kab_id->VirtualValue = $row['EV__kab_id']; // Set up virtual field value
        } else {
            $this->kab_id->VirtualValue = ""; // Clear value
        }
        $this->kec_id->setDbValue($row['kec_id']);
        if (array_key_exists('EV__kec_id', $row)) {
            $this->kec_id->VirtualValue = $row['EV__kec_id']; // Set up virtual field value
        } else {
            $this->kec_id->VirtualValue = ""; // Clear value
        }
        $this->desa_id->setDbValue($row['desa_id']);
        if (array_key_exists('EV__desa_id', $row)) {
            $this->desa_id->VirtualValue = $row['EV__desa_id']; // Set up virtual field value
        } else {
            $this->desa_id->VirtualValue = ""; // Clear value
        }
        $this->pes_alamat->setDbValue($row['pes_alamat']);
        $this->pes_hp->setDbValue($row['pes_hp']);
        $this->pes_foto->Upload->DbValue = $row['pes_foto'];
        $this->pes_foto->setDbValue($this->pes_foto->Upload->DbValue);
        $this->pes_luas_lahan->setDbValue($row['pes_luas_lahan']);
        $this->pes_r_tanam_tgl->setDbValue($row['pes_r_tanam_tgl']);
        $this->pes_foto_lahan->Upload->DbValue = $row['pes_foto_lahan'];
        $this->pes_foto_lahan->setDbValue($this->pes_foto_lahan->Upload->DbValue);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['pes_id'] = $this->pes_id->DefaultValue;
        $row['pes_nama'] = $this->pes_nama->DefaultValue;
        $row['sos_id'] = $this->sos_id->DefaultValue;
        $row['co_id'] = $this->co_id->DefaultValue;
        $row['prov_id'] = $this->prov_id->DefaultValue;
        $row['kab_id'] = $this->kab_id->DefaultValue;
        $row['kec_id'] = $this->kec_id->DefaultValue;
        $row['desa_id'] = $this->desa_id->DefaultValue;
        $row['pes_alamat'] = $this->pes_alamat->DefaultValue;
        $row['pes_hp'] = $this->pes_hp->DefaultValue;
        $row['pes_foto'] = $this->pes_foto->DefaultValue;
        $row['pes_luas_lahan'] = $this->pes_luas_lahan->DefaultValue;
        $row['pes_r_tanam_tgl'] = $this->pes_r_tanam_tgl->DefaultValue;
        $row['pes_foto_lahan'] = $this->pes_foto_lahan->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // pes_id

        // pes_nama

        // sos_id

        // co_id

        // prov_id

        // kab_id

        // kec_id

        // desa_id

        // pes_alamat

        // pes_hp

        // pes_foto

        // pes_luas_lahan

        // pes_r_tanam_tgl

        // pes_foto_lahan

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // pes_id
            $this->pes_id->ViewValue = $this->pes_id->CurrentValue;

            // pes_nama
            $this->pes_nama->ViewValue = $this->pes_nama->CurrentValue;

            // sos_id
            $curVal = strval($this->sos_id->CurrentValue);
            if ($curVal != "") {
                $this->sos_id->ViewValue = $this->sos_id->lookupCacheOption($curVal);
                if ($this->sos_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`sos_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_id->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_id->ViewValue = $this->sos_id->displayValue($arwrk);
                    } else {
                        $this->sos_id->ViewValue = $this->sos_id->CurrentValue;
                    }
                }
            } else {
                $this->sos_id->ViewValue = null;
            }

            // co_id
            $curVal = strval($this->co_id->CurrentValue);
            if ($curVal != "") {
                $this->co_id->ViewValue = $this->co_id->lookupCacheOption($curVal);
                if ($this->co_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->co_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->co_id->Lookup->renderViewRow($rswrk[0]);
                        $this->co_id->ViewValue = $this->co_id->displayValue($arwrk);
                    } else {
                        $this->co_id->ViewValue = $this->co_id->CurrentValue;
                    }
                }
            } else {
                $this->co_id->ViewValue = null;
            }

            // prov_id
            if ($this->prov_id->VirtualValue != "") {
                $this->prov_id->ViewValue = $this->prov_id->VirtualValue;
            } else {
                $curVal = strval($this->prov_id->CurrentValue);
                if ($curVal != "") {
                    $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
                    if ($this->prov_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->prov_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->prov_id->Lookup->renderViewRow($rswrk[0]);
                            $this->prov_id->ViewValue = $this->prov_id->displayValue($arwrk);
                        } else {
                            $this->prov_id->ViewValue = $this->prov_id->CurrentValue;
                        }
                    }
                } else {
                    $this->prov_id->ViewValue = null;
                }
            }

            // kab_id
            if ($this->kab_id->VirtualValue != "") {
                $this->kab_id->ViewValue = $this->kab_id->VirtualValue;
            } else {
                $curVal = strval($this->kab_id->CurrentValue);
                if ($curVal != "") {
                    $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
                    if ($this->kab_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kab_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kab_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kab_id->ViewValue = $this->kab_id->displayValue($arwrk);
                        } else {
                            $this->kab_id->ViewValue = $this->kab_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kab_id->ViewValue = null;
                }
            }

            // kec_id
            if ($this->kec_id->VirtualValue != "") {
                $this->kec_id->ViewValue = $this->kec_id->VirtualValue;
            } else {
                $curVal = strval($this->kec_id->CurrentValue);
                if ($curVal != "") {
                    $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
                    if ($this->kec_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kec_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kec_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kec_id->ViewValue = $this->kec_id->displayValue($arwrk);
                        } else {
                            $this->kec_id->ViewValue = $this->kec_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kec_id->ViewValue = null;
                }
            }

            // desa_id
            if ($this->desa_id->VirtualValue != "") {
                $this->desa_id->ViewValue = $this->desa_id->VirtualValue;
            } else {
                $curVal = strval($this->desa_id->CurrentValue);
                if ($curVal != "") {
                    $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
                    if ($this->desa_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->desa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->desa_id->Lookup->renderViewRow($rswrk[0]);
                            $this->desa_id->ViewValue = $this->desa_id->displayValue($arwrk);
                        } else {
                            $this->desa_id->ViewValue = $this->desa_id->CurrentValue;
                        }
                    }
                } else {
                    $this->desa_id->ViewValue = null;
                }
            }

            // pes_alamat
            $this->pes_alamat->ViewValue = $this->pes_alamat->CurrentValue;

            // pes_hp
            $this->pes_hp->ViewValue = $this->pes_hp->CurrentValue;

            // pes_foto
            $this->pes_foto->UploadPath = $this->pes_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->pes_foto->Upload->DbValue)) {
                $this->pes_foto->ImageWidth = 60;
                $this->pes_foto->ImageHeight = 60;
                $this->pes_foto->ImageAlt = $this->pes_foto->alt();
                $this->pes_foto->ImageCssClass = "ew-image";
                $this->pes_foto->ViewValue = $this->pes_foto->Upload->DbValue;
            } else {
                $this->pes_foto->ViewValue = "";
            }

            // pes_luas_lahan
            $this->pes_luas_lahan->ViewValue = $this->pes_luas_lahan->CurrentValue;
            $this->pes_luas_lahan->CellCssStyle .= "text-align: right;";

            // pes_r_tanam_tgl
            $this->pes_r_tanam_tgl->ViewValue = $this->pes_r_tanam_tgl->CurrentValue;
            $this->pes_r_tanam_tgl->ViewValue = FormatDateTime($this->pes_r_tanam_tgl->ViewValue, $this->pes_r_tanam_tgl->formatPattern());

            // pes_foto_lahan
            $this->pes_foto_lahan->UploadPath = $this->pes_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->pes_foto_lahan->Upload->DbValue)) {
                $this->pes_foto_lahan->ImageWidth = 80;
                $this->pes_foto_lahan->ImageHeight = 60;
                $this->pes_foto_lahan->ImageAlt = $this->pes_foto_lahan->alt();
                $this->pes_foto_lahan->ImageCssClass = "ew-image";
                $this->pes_foto_lahan->ViewValue = $this->pes_foto_lahan->Upload->DbValue;
            } else {
                $this->pes_foto_lahan->ViewValue = "";
            }

            // pes_id
            $this->pes_id->HrefValue = "";
            $this->pes_id->TooltipValue = "";

            // pes_nama
            $this->pes_nama->HrefValue = "";
            $this->pes_nama->TooltipValue = "";

            // sos_id
            $this->sos_id->HrefValue = "";
            $this->sos_id->TooltipValue = "";

            // co_id
            $this->co_id->HrefValue = "";
            $this->co_id->TooltipValue = "";

            // prov_id
            $this->prov_id->HrefValue = "";
            $this->prov_id->TooltipValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";
            $this->kab_id->TooltipValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";
            $this->kec_id->TooltipValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";
            $this->desa_id->TooltipValue = "";

            // pes_alamat
            $this->pes_alamat->HrefValue = "";
            $this->pes_alamat->TooltipValue = "";

            // pes_hp
            $this->pes_hp->HrefValue = "";
            $this->pes_hp->TooltipValue = "";

            // pes_foto
            $this->pes_foto->UploadPath = $this->pes_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->pes_foto->Upload->DbValue)) {
                $this->pes_foto->HrefValue = GetFileUploadUrl($this->pes_foto, $this->pes_foto->htmlDecode($this->pes_foto->Upload->DbValue)); // Add prefix/suffix
                $this->pes_foto->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->pes_foto->HrefValue = FullUrl($this->pes_foto->HrefValue, "href");
                }
            } else {
                $this->pes_foto->HrefValue = "";
            }
            $this->pes_foto->ExportHrefValue = $this->pes_foto->UploadPath . $this->pes_foto->Upload->DbValue;
            $this->pes_foto->TooltipValue = "";
            if ($this->pes_foto->UseColorbox) {
                if (EmptyValue($this->pes_foto->TooltipValue)) {
                    $this->pes_foto->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->pes_foto->LinkAttrs["data-rel"] = "peserta_x" . $this->RowCount . "_pes_foto";
                $this->pes_foto->LinkAttrs->appendClass("ew-lightbox");
            }

            // pes_luas_lahan
            $this->pes_luas_lahan->HrefValue = "";
            $this->pes_luas_lahan->TooltipValue = "";

            // pes_r_tanam_tgl
            $this->pes_r_tanam_tgl->HrefValue = "";
            $this->pes_r_tanam_tgl->TooltipValue = "";

            // pes_foto_lahan
            $this->pes_foto_lahan->UploadPath = $this->pes_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->pes_foto_lahan->Upload->DbValue)) {
                $this->pes_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
                $this->pes_foto_lahan->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->pes_foto_lahan->HrefValue = FullUrl($this->pes_foto_lahan->HrefValue, "href");
                }
            } else {
                $this->pes_foto_lahan->HrefValue = "";
            }
            $this->pes_foto_lahan->ExportHrefValue = $this->pes_foto_lahan->UploadPath . $this->pes_foto_lahan->Upload->DbValue;
            $this->pes_foto_lahan->TooltipValue = "";
            if ($this->pes_foto_lahan->UseColorbox) {
                if (EmptyValue($this->pes_foto_lahan->TooltipValue)) {
                    $this->pes_foto_lahan->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->pes_foto_lahan->LinkAttrs["data-rel"] = "peserta_x" . $this->RowCount . "_pes_foto_lahan";
                $this->pes_foto_lahan->LinkAttrs->appendClass("ew-lightbox");
            }
        } elseif ($this->RowType == ROWTYPE_SEARCH) {
            // pes_id
            $this->pes_id->setupEditAttributes();
            $this->pes_id->EditValue = HtmlEncode($this->pes_id->AdvancedSearch->SearchValue);
            $this->pes_id->PlaceHolder = RemoveHtml($this->pes_id->caption());

            // pes_nama
            $this->pes_nama->setupEditAttributes();
            if (!$this->pes_nama->Raw) {
                $this->pes_nama->AdvancedSearch->SearchValue = HtmlDecode($this->pes_nama->AdvancedSearch->SearchValue);
            }
            $this->pes_nama->EditValue = HtmlEncode($this->pes_nama->AdvancedSearch->SearchValue);
            $this->pes_nama->PlaceHolder = RemoveHtml($this->pes_nama->caption());

            // sos_id
            $this->sos_id->setupEditAttributes();
            $this->sos_id->PlaceHolder = RemoveHtml($this->sos_id->caption());

            // co_id
            $this->co_id->setupEditAttributes();
            $this->co_id->PlaceHolder = RemoveHtml($this->co_id->caption());

            // prov_id
            $this->prov_id->setupEditAttributes();
            $this->prov_id->EditValue = HtmlEncode($this->prov_id->AdvancedSearch->SearchValue);
            $this->prov_id->PlaceHolder = RemoveHtml($this->prov_id->caption());

            // kab_id
            $this->kab_id->setupEditAttributes();
            $this->kab_id->EditValue = HtmlEncode($this->kab_id->AdvancedSearch->SearchValue);
            $this->kab_id->PlaceHolder = RemoveHtml($this->kab_id->caption());

            // kec_id
            $this->kec_id->setupEditAttributes();
            $this->kec_id->EditValue = HtmlEncode($this->kec_id->AdvancedSearch->SearchValue);
            $this->kec_id->PlaceHolder = RemoveHtml($this->kec_id->caption());

            // desa_id
            $this->desa_id->setupEditAttributes();
            $this->desa_id->EditValue = HtmlEncode($this->desa_id->AdvancedSearch->SearchValue);
            $this->desa_id->PlaceHolder = RemoveHtml($this->desa_id->caption());

            // pes_alamat
            $this->pes_alamat->setupEditAttributes();
            if (!$this->pes_alamat->Raw) {
                $this->pes_alamat->AdvancedSearch->SearchValue = HtmlDecode($this->pes_alamat->AdvancedSearch->SearchValue);
            }
            $this->pes_alamat->EditValue = HtmlEncode($this->pes_alamat->AdvancedSearch->SearchValue);
            $this->pes_alamat->PlaceHolder = RemoveHtml($this->pes_alamat->caption());

            // pes_hp
            $this->pes_hp->setupEditAttributes();
            if (!$this->pes_hp->Raw) {
                $this->pes_hp->AdvancedSearch->SearchValue = HtmlDecode($this->pes_hp->AdvancedSearch->SearchValue);
            }
            $this->pes_hp->EditValue = HtmlEncode($this->pes_hp->AdvancedSearch->SearchValue);
            $this->pes_hp->PlaceHolder = RemoveHtml($this->pes_hp->caption());

            // pes_foto
            $this->pes_foto->setupEditAttributes();
            if (!$this->pes_foto->Raw) {
                $this->pes_foto->AdvancedSearch->SearchValue = HtmlDecode($this->pes_foto->AdvancedSearch->SearchValue);
            }
            $this->pes_foto->EditValue = HtmlEncode($this->pes_foto->AdvancedSearch->SearchValue);
            $this->pes_foto->PlaceHolder = RemoveHtml($this->pes_foto->caption());

            // pes_luas_lahan
            $this->pes_luas_lahan->setupEditAttributes();
            $this->pes_luas_lahan->EditValue = HtmlEncode($this->pes_luas_lahan->AdvancedSearch->SearchValue);
            $this->pes_luas_lahan->PlaceHolder = RemoveHtml($this->pes_luas_lahan->caption());

            // pes_r_tanam_tgl
            $this->pes_r_tanam_tgl->setupEditAttributes();
            $this->pes_r_tanam_tgl->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->pes_r_tanam_tgl->AdvancedSearch->SearchValue, $this->pes_r_tanam_tgl->formatPattern()), $this->pes_r_tanam_tgl->formatPattern()));
            $this->pes_r_tanam_tgl->PlaceHolder = RemoveHtml($this->pes_r_tanam_tgl->caption());

            // pes_foto_lahan
            $this->pes_foto_lahan->setupEditAttributes();
            if (!$this->pes_foto_lahan->Raw) {
                $this->pes_foto_lahan->AdvancedSearch->SearchValue = HtmlDecode($this->pes_foto_lahan->AdvancedSearch->SearchValue);
            }
            $this->pes_foto_lahan->EditValue = HtmlEncode($this->pes_foto_lahan->AdvancedSearch->SearchValue);
            $this->pes_foto_lahan->PlaceHolder = RemoveHtml($this->pes_foto_lahan->caption());
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckDate($this->pes_r_tanam_tgl->AdvancedSearch->SearchValue, $this->pes_r_tanam_tgl->formatPattern())) {
            $this->pes_r_tanam_tgl->addErrorMessage($this->pes_r_tanam_tgl->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->pes_id->AdvancedSearch->load();
        $this->pes_nama->AdvancedSearch->load();
        $this->sos_id->AdvancedSearch->load();
        $this->co_id->AdvancedSearch->load();
        $this->prov_id->AdvancedSearch->load();
        $this->kab_id->AdvancedSearch->load();
        $this->kec_id->AdvancedSearch->load();
        $this->desa_id->AdvancedSearch->load();
        $this->pes_alamat->AdvancedSearch->load();
        $this->pes_hp->AdvancedSearch->load();
        $this->pes_foto->AdvancedSearch->load();
        $this->pes_luas_lahan->AdvancedSearch->load();
        $this->pes_r_tanam_tgl->AdvancedSearch->load();
        $this->pes_foto_lahan->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fpesertalist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fpesertalist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fpesertalist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fpesertalist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = false;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(["TagClassName" => "ew-search-option"]);

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fpesertasrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");

        // Load recordset
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");

        // Close recordset
        $rs->close();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KontrakList");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_sos_id":
                    break;
                case "x_co_id":
                    break;
                case "x_prov_id":
                    break;
                case "x_kab_id":
                    break;
                case "x_kec_id":
                    break;
                case "x_desa_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->Add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->MoveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
