<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class KontrakAdd extends Kontrak
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "KontrakAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "KontrakAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->k_id->Visible = false;
        $this->k_id_kontrak->Visible = false;
        $this->k_id_lama->Visible = false;
        $this->k_no_kontrak->Visible = false;
        $this->k_luas_lahan->setVisibility();
        $this->pet_id->setVisibility();
        $this->koord_id->setVisibility();
        $this->kk_id->setVisibility();
        $this->prov_id->setVisibility();
        $this->kab_id->setVisibility();
        $this->kec_id->setVisibility();
        $this->desa_id->setVisibility();
        $this->blok_id->setVisibility();
        $this->sos_id->setVisibility();
        $this->var_id->setVisibility();
        $this->co_id->setVisibility();
        $this->k_jumlah_bibit->setVisibility();
        $this->k_asal_bibit->setVisibility();
        $this->k_tgl_tanam->setVisibility();
        $this->k_es_tgl_panen->setVisibility();
        $this->k_ak_tgl_datang->Visible = false;
        $this->k_es_qty->Visible = false;
        $this->k_ak_qty->Visible = false;
        $this->k_es_perhektar->setVisibility();
        $this->k_ak_perhektar->Visible = false;
        $this->k_skor->Visible = false;
        $this->k_ket->setVisibility();
        $this->k_cat->setVisibility();
        $this->k_titik_koordinat->setVisibility();
        $this->k_foto_lahan->setVisibility();
        $this->k_dok->setVisibility();
        $this->k_harga_bibit->setVisibility();
        $this->k_bayar_bibit->setVisibility();
        $this->k_pinjaman->setVisibility();
        $this->k_bayar_pinjaman->setVisibility();
        $this->k_sisa_hutang->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'kontrak';
        $this->TableName = 'kontrak';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (kontrak)
        if (!isset($GLOBALS["kontrak"]) || get_class($GLOBALS["kontrak"]) == PROJECT_NAMESPACE . "kontrak") {
            $GLOBALS["kontrak"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'kontrak');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "KontrakView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->k_foto_lahan->OldUploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
                $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->OldUploadPath;
                $this->k_dok->OldUploadPath = $this->k_dok->getUploadPath(); // PHP
                $this->k_dok->UploadPath = $this->k_dok->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['k_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->k_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->pet_id);
        $this->setupLookupOptions($this->koord_id);
        $this->setupLookupOptions($this->kk_id);
        $this->setupLookupOptions($this->prov_id);
        $this->setupLookupOptions($this->kab_id);
        $this->setupLookupOptions($this->kec_id);
        $this->setupLookupOptions($this->desa_id);
        $this->setupLookupOptions($this->blok_id);
        $this->setupLookupOptions($this->sos_id);
        $this->setupLookupOptions($this->var_id);
        $this->setupLookupOptions($this->co_id);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("k_id") ?? Route("k_id")) !== null) {
                $this->k_id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("KontrakList"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "KontrakList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "KontrakView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "KontrakList") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "KontrakList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->k_foto_lahan->Upload->Index = $CurrentForm->Index;
        $this->k_foto_lahan->Upload->uploadFile();
        $this->k_foto_lahan->CurrentValue = $this->k_foto_lahan->Upload->FileName;
        $this->k_dok->Upload->Index = $CurrentForm->Index;
        $this->k_dok->Upload->uploadFile();
        $this->k_dok->CurrentValue = $this->k_dok->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->k_titik_koordinat->DefaultValue = $this->k_titik_koordinat->getDefault(); // PHP
        $this->k_titik_koordinat->OldValue = $this->k_titik_koordinat->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'k_luas_lahan' first before field var 'x_k_luas_lahan'
        $val = $CurrentForm->hasValue("k_luas_lahan") ? $CurrentForm->getValue("k_luas_lahan") : $CurrentForm->getValue("x_k_luas_lahan");
        if (!$this->k_luas_lahan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_luas_lahan->Visible = false; // Disable update for API request
            } else {
                $this->k_luas_lahan->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'pet_id' first before field var 'x_pet_id'
        $val = $CurrentForm->hasValue("pet_id") ? $CurrentForm->getValue("pet_id") : $CurrentForm->getValue("x_pet_id");
        if (!$this->pet_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pet_id->Visible = false; // Disable update for API request
            } else {
                $this->pet_id->setFormValue($val);
            }
        }

        // Check field name 'koord_id' first before field var 'x_koord_id'
        $val = $CurrentForm->hasValue("koord_id") ? $CurrentForm->getValue("koord_id") : $CurrentForm->getValue("x_koord_id");
        if (!$this->koord_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->koord_id->Visible = false; // Disable update for API request
            } else {
                $this->koord_id->setFormValue($val);
            }
        }

        // Check field name 'kk_id' first before field var 'x_kk_id'
        $val = $CurrentForm->hasValue("kk_id") ? $CurrentForm->getValue("kk_id") : $CurrentForm->getValue("x_kk_id");
        if (!$this->kk_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kk_id->Visible = false; // Disable update for API request
            } else {
                $this->kk_id->setFormValue($val);
            }
        }

        // Check field name 'prov_id' first before field var 'x_prov_id'
        $val = $CurrentForm->hasValue("prov_id") ? $CurrentForm->getValue("prov_id") : $CurrentForm->getValue("x_prov_id");
        if (!$this->prov_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->prov_id->Visible = false; // Disable update for API request
            } else {
                $this->prov_id->setFormValue($val);
            }
        }

        // Check field name 'kab_id' first before field var 'x_kab_id'
        $val = $CurrentForm->hasValue("kab_id") ? $CurrentForm->getValue("kab_id") : $CurrentForm->getValue("x_kab_id");
        if (!$this->kab_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kab_id->Visible = false; // Disable update for API request
            } else {
                $this->kab_id->setFormValue($val);
            }
        }

        // Check field name 'kec_id' first before field var 'x_kec_id'
        $val = $CurrentForm->hasValue("kec_id") ? $CurrentForm->getValue("kec_id") : $CurrentForm->getValue("x_kec_id");
        if (!$this->kec_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kec_id->Visible = false; // Disable update for API request
            } else {
                $this->kec_id->setFormValue($val);
            }
        }

        // Check field name 'desa_id' first before field var 'x_desa_id'
        $val = $CurrentForm->hasValue("desa_id") ? $CurrentForm->getValue("desa_id") : $CurrentForm->getValue("x_desa_id");
        if (!$this->desa_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->desa_id->Visible = false; // Disable update for API request
            } else {
                $this->desa_id->setFormValue($val);
            }
        }

        // Check field name 'blok_id' first before field var 'x_blok_id'
        $val = $CurrentForm->hasValue("blok_id") ? $CurrentForm->getValue("blok_id") : $CurrentForm->getValue("x_blok_id");
        if (!$this->blok_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->blok_id->Visible = false; // Disable update for API request
            } else {
                $this->blok_id->setFormValue($val);
            }
        }

        // Check field name 'sos_id' first before field var 'x_sos_id'
        $val = $CurrentForm->hasValue("sos_id") ? $CurrentForm->getValue("sos_id") : $CurrentForm->getValue("x_sos_id");
        if (!$this->sos_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_id->Visible = false; // Disable update for API request
            } else {
                $this->sos_id->setFormValue($val);
            }
        }

        // Check field name 'var_id' first before field var 'x_var_id'
        $val = $CurrentForm->hasValue("var_id") ? $CurrentForm->getValue("var_id") : $CurrentForm->getValue("x_var_id");
        if (!$this->var_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->var_id->Visible = false; // Disable update for API request
            } else {
                $this->var_id->setFormValue($val);
            }
        }

        // Check field name 'co_id' first before field var 'x_co_id'
        $val = $CurrentForm->hasValue("co_id") ? $CurrentForm->getValue("co_id") : $CurrentForm->getValue("x_co_id");
        if (!$this->co_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->co_id->Visible = false; // Disable update for API request
            } else {
                $this->co_id->setFormValue($val);
            }
        }

        // Check field name 'k_jumlah_bibit' first before field var 'x_k_jumlah_bibit'
        $val = $CurrentForm->hasValue("k_jumlah_bibit") ? $CurrentForm->getValue("k_jumlah_bibit") : $CurrentForm->getValue("x_k_jumlah_bibit");
        if (!$this->k_jumlah_bibit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_jumlah_bibit->Visible = false; // Disable update for API request
            } else {
                $this->k_jumlah_bibit->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'k_asal_bibit' first before field var 'x_k_asal_bibit'
        $val = $CurrentForm->hasValue("k_asal_bibit") ? $CurrentForm->getValue("k_asal_bibit") : $CurrentForm->getValue("x_k_asal_bibit");
        if (!$this->k_asal_bibit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_asal_bibit->Visible = false; // Disable update for API request
            } else {
                $this->k_asal_bibit->setFormValue($val);
            }
        }

        // Check field name 'k_tgl_tanam' first before field var 'x_k_tgl_tanam'
        $val = $CurrentForm->hasValue("k_tgl_tanam") ? $CurrentForm->getValue("k_tgl_tanam") : $CurrentForm->getValue("x_k_tgl_tanam");
        if (!$this->k_tgl_tanam->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_tgl_tanam->Visible = false; // Disable update for API request
            } else {
                $this->k_tgl_tanam->setFormValue($val, true, $validate);
            }
            $this->k_tgl_tanam->CurrentValue = UnFormatDateTime($this->k_tgl_tanam->CurrentValue, $this->k_tgl_tanam->formatPattern());
        }

        // Check field name 'k_es_tgl_panen' first before field var 'x_k_es_tgl_panen'
        $val = $CurrentForm->hasValue("k_es_tgl_panen") ? $CurrentForm->getValue("k_es_tgl_panen") : $CurrentForm->getValue("x_k_es_tgl_panen");
        if (!$this->k_es_tgl_panen->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_es_tgl_panen->Visible = false; // Disable update for API request
            } else {
                $this->k_es_tgl_panen->setFormValue($val, true, $validate);
            }
            $this->k_es_tgl_panen->CurrentValue = UnFormatDateTime($this->k_es_tgl_panen->CurrentValue, $this->k_es_tgl_panen->formatPattern());
        }

        // Check field name 'k_es_perhektar' first before field var 'x_k_es_perhektar'
        $val = $CurrentForm->hasValue("k_es_perhektar") ? $CurrentForm->getValue("k_es_perhektar") : $CurrentForm->getValue("x_k_es_perhektar");
        if (!$this->k_es_perhektar->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_es_perhektar->Visible = false; // Disable update for API request
            } else {
                $this->k_es_perhektar->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'k_ket' first before field var 'x_k_ket'
        $val = $CurrentForm->hasValue("k_ket") ? $CurrentForm->getValue("k_ket") : $CurrentForm->getValue("x_k_ket");
        if (!$this->k_ket->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_ket->Visible = false; // Disable update for API request
            } else {
                $this->k_ket->setFormValue($val);
            }
        }

        // Check field name 'k_cat' first before field var 'x_k_cat'
        $val = $CurrentForm->hasValue("k_cat") ? $CurrentForm->getValue("k_cat") : $CurrentForm->getValue("x_k_cat");
        if (!$this->k_cat->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_cat->Visible = false; // Disable update for API request
            } else {
                $this->k_cat->setFormValue($val);
            }
        }

        // Check field name 'k_titik_koordinat' first before field var 'x_k_titik_koordinat'
        $val = $CurrentForm->hasValue("k_titik_koordinat") ? $CurrentForm->getValue("k_titik_koordinat") : $CurrentForm->getValue("x_k_titik_koordinat");
        if (!$this->k_titik_koordinat->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_titik_koordinat->Visible = false; // Disable update for API request
            } else {
                $this->k_titik_koordinat->setFormValue($val);
            }
        }

        // Check field name 'k_harga_bibit' first before field var 'x_k_harga_bibit'
        $val = $CurrentForm->hasValue("k_harga_bibit") ? $CurrentForm->getValue("k_harga_bibit") : $CurrentForm->getValue("x_k_harga_bibit");
        if (!$this->k_harga_bibit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_harga_bibit->Visible = false; // Disable update for API request
            } else {
                $this->k_harga_bibit->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'k_bayar_bibit' first before field var 'x_k_bayar_bibit'
        $val = $CurrentForm->hasValue("k_bayar_bibit") ? $CurrentForm->getValue("k_bayar_bibit") : $CurrentForm->getValue("x_k_bayar_bibit");
        if (!$this->k_bayar_bibit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_bayar_bibit->Visible = false; // Disable update for API request
            } else {
                $this->k_bayar_bibit->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'k_pinjaman' first before field var 'x_k_pinjaman'
        $val = $CurrentForm->hasValue("k_pinjaman") ? $CurrentForm->getValue("k_pinjaman") : $CurrentForm->getValue("x_k_pinjaman");
        if (!$this->k_pinjaman->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_pinjaman->Visible = false; // Disable update for API request
            } else {
                $this->k_pinjaman->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'k_bayar_pinjaman' first before field var 'x_k_bayar_pinjaman'
        $val = $CurrentForm->hasValue("k_bayar_pinjaman") ? $CurrentForm->getValue("k_bayar_pinjaman") : $CurrentForm->getValue("x_k_bayar_pinjaman");
        if (!$this->k_bayar_pinjaman->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_bayar_pinjaman->Visible = false; // Disable update for API request
            } else {
                $this->k_bayar_pinjaman->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'k_sisa_hutang' first before field var 'x_k_sisa_hutang'
        $val = $CurrentForm->hasValue("k_sisa_hutang") ? $CurrentForm->getValue("k_sisa_hutang") : $CurrentForm->getValue("x_k_sisa_hutang");
        if (!$this->k_sisa_hutang->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_sisa_hutang->Visible = false; // Disable update for API request
            } else {
                $this->k_sisa_hutang->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'k_id' first before field var 'x_k_id'
        $val = $CurrentForm->hasValue("k_id") ? $CurrentForm->getValue("k_id") : $CurrentForm->getValue("x_k_id");
		$this->k_foto_lahan->OldUploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
		$this->k_foto_lahan->UploadPath = $this->k_foto_lahan->OldUploadPath;
		$this->k_dok->OldUploadPath = $this->k_dok->getUploadPath(); // PHP
		$this->k_dok->UploadPath = $this->k_dok->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->k_luas_lahan->CurrentValue = $this->k_luas_lahan->FormValue;
        $this->pet_id->CurrentValue = $this->pet_id->FormValue;
        $this->koord_id->CurrentValue = $this->koord_id->FormValue;
        $this->kk_id->CurrentValue = $this->kk_id->FormValue;
        $this->prov_id->CurrentValue = $this->prov_id->FormValue;
        $this->kab_id->CurrentValue = $this->kab_id->FormValue;
        $this->kec_id->CurrentValue = $this->kec_id->FormValue;
        $this->desa_id->CurrentValue = $this->desa_id->FormValue;
        $this->blok_id->CurrentValue = $this->blok_id->FormValue;
        $this->sos_id->CurrentValue = $this->sos_id->FormValue;
        $this->var_id->CurrentValue = $this->var_id->FormValue;
        $this->co_id->CurrentValue = $this->co_id->FormValue;
        $this->k_jumlah_bibit->CurrentValue = $this->k_jumlah_bibit->FormValue;
        $this->k_asal_bibit->CurrentValue = $this->k_asal_bibit->FormValue;
        $this->k_tgl_tanam->CurrentValue = $this->k_tgl_tanam->FormValue;
        $this->k_tgl_tanam->CurrentValue = UnFormatDateTime($this->k_tgl_tanam->CurrentValue, $this->k_tgl_tanam->formatPattern());
        $this->k_es_tgl_panen->CurrentValue = $this->k_es_tgl_panen->FormValue;
        $this->k_es_tgl_panen->CurrentValue = UnFormatDateTime($this->k_es_tgl_panen->CurrentValue, $this->k_es_tgl_panen->formatPattern());
        $this->k_es_perhektar->CurrentValue = $this->k_es_perhektar->FormValue;
        $this->k_ket->CurrentValue = $this->k_ket->FormValue;
        $this->k_cat->CurrentValue = $this->k_cat->FormValue;
        $this->k_titik_koordinat->CurrentValue = $this->k_titik_koordinat->FormValue;
        $this->k_harga_bibit->CurrentValue = $this->k_harga_bibit->FormValue;
        $this->k_bayar_bibit->CurrentValue = $this->k_bayar_bibit->FormValue;
        $this->k_pinjaman->CurrentValue = $this->k_pinjaman->FormValue;
        $this->k_bayar_pinjaman->CurrentValue = $this->k_bayar_pinjaman->FormValue;
        $this->k_sisa_hutang->CurrentValue = $this->k_sisa_hutang->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->k_id->setDbValue($row['k_id']);
        $this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
        $this->k_id_lama->setDbValue($row['k_id_lama']);
        $this->k_no_kontrak->setDbValue($row['k_no_kontrak']);
        $this->k_luas_lahan->setDbValue($row['k_luas_lahan']);
        $this->pet_id->setDbValue($row['pet_id']);
        if (array_key_exists('EV__pet_id', $row)) {
            $this->pet_id->VirtualValue = $row['EV__pet_id']; // Set up virtual field value
        } else {
            $this->pet_id->VirtualValue = ""; // Clear value
        }
        $this->koord_id->setDbValue($row['koord_id']);
        if (array_key_exists('EV__koord_id', $row)) {
            $this->koord_id->VirtualValue = $row['EV__koord_id']; // Set up virtual field value
        } else {
            $this->koord_id->VirtualValue = ""; // Clear value
        }
        $this->kk_id->setDbValue($row['kk_id']);
        $this->prov_id->setDbValue($row['prov_id']);
        if (array_key_exists('EV__prov_id', $row)) {
            $this->prov_id->VirtualValue = $row['EV__prov_id']; // Set up virtual field value
        } else {
            $this->prov_id->VirtualValue = ""; // Clear value
        }
        $this->kab_id->setDbValue($row['kab_id']);
        if (array_key_exists('EV__kab_id', $row)) {
            $this->kab_id->VirtualValue = $row['EV__kab_id']; // Set up virtual field value
        } else {
            $this->kab_id->VirtualValue = ""; // Clear value
        }
        $this->kec_id->setDbValue($row['kec_id']);
        if (array_key_exists('EV__kec_id', $row)) {
            $this->kec_id->VirtualValue = $row['EV__kec_id']; // Set up virtual field value
        } else {
            $this->kec_id->VirtualValue = ""; // Clear value
        }
        $this->desa_id->setDbValue($row['desa_id']);
        if (array_key_exists('EV__desa_id', $row)) {
            $this->desa_id->VirtualValue = $row['EV__desa_id']; // Set up virtual field value
        } else {
            $this->desa_id->VirtualValue = ""; // Clear value
        }
        $this->blok_id->setDbValue($row['blok_id']);
        if (array_key_exists('EV__blok_id', $row)) {
            $this->blok_id->VirtualValue = $row['EV__blok_id']; // Set up virtual field value
        } else {
            $this->blok_id->VirtualValue = ""; // Clear value
        }
        $this->sos_id->setDbValue($row['sos_id']);
        if (array_key_exists('EV__sos_id', $row)) {
            $this->sos_id->VirtualValue = $row['EV__sos_id']; // Set up virtual field value
        } else {
            $this->sos_id->VirtualValue = ""; // Clear value
        }
        $this->var_id->setDbValue($row['var_id']);
        $this->co_id->setDbValue($row['co_id']);
        $this->k_jumlah_bibit->setDbValue($row['k_jumlah_bibit']);
        $this->k_asal_bibit->setDbValue($row['k_asal_bibit']);
        $this->k_tgl_tanam->setDbValue($row['k_tgl_tanam']);
        $this->k_es_tgl_panen->setDbValue($row['k_es_tgl_panen']);
        $this->k_ak_tgl_datang->setDbValue($row['k_ak_tgl_datang']);
        $this->k_es_qty->setDbValue($row['k_es_qty']);
        $this->k_ak_qty->setDbValue($row['k_ak_qty']);
        $this->k_es_perhektar->setDbValue($row['k_es_perhektar']);
        $this->k_ak_perhektar->setDbValue($row['k_ak_perhektar']);
        $this->k_skor->setDbValue($row['k_skor']);
        $this->k_ket->setDbValue($row['k_ket']);
        $this->k_cat->setDbValue($row['k_cat']);
        $this->k_titik_koordinat->setDbValue($row['k_titik_koordinat']);
        $this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
        $this->k_foto_lahan->setDbValue($this->k_foto_lahan->Upload->DbValue);
        $this->k_dok->Upload->DbValue = $row['k_dok'];
        $this->k_dok->setDbValue($this->k_dok->Upload->DbValue);
        $this->k_harga_bibit->setDbValue($row['k_harga_bibit']);
        $this->k_bayar_bibit->setDbValue($row['k_bayar_bibit']);
        $this->k_pinjaman->setDbValue($row['k_pinjaman']);
        $this->k_bayar_pinjaman->setDbValue($row['k_bayar_pinjaman']);
        $this->k_sisa_hutang->setDbValue($row['k_sisa_hutang']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['k_id'] = $this->k_id->DefaultValue;
        $row['k_id_kontrak'] = $this->k_id_kontrak->DefaultValue;
        $row['k_id_lama'] = $this->k_id_lama->DefaultValue;
        $row['k_no_kontrak'] = $this->k_no_kontrak->DefaultValue;
        $row['k_luas_lahan'] = $this->k_luas_lahan->DefaultValue;
        $row['pet_id'] = $this->pet_id->DefaultValue;
        $row['koord_id'] = $this->koord_id->DefaultValue;
        $row['kk_id'] = $this->kk_id->DefaultValue;
        $row['prov_id'] = $this->prov_id->DefaultValue;
        $row['kab_id'] = $this->kab_id->DefaultValue;
        $row['kec_id'] = $this->kec_id->DefaultValue;
        $row['desa_id'] = $this->desa_id->DefaultValue;
        $row['blok_id'] = $this->blok_id->DefaultValue;
        $row['sos_id'] = $this->sos_id->DefaultValue;
        $row['var_id'] = $this->var_id->DefaultValue;
        $row['co_id'] = $this->co_id->DefaultValue;
        $row['k_jumlah_bibit'] = $this->k_jumlah_bibit->DefaultValue;
        $row['k_asal_bibit'] = $this->k_asal_bibit->DefaultValue;
        $row['k_tgl_tanam'] = $this->k_tgl_tanam->DefaultValue;
        $row['k_es_tgl_panen'] = $this->k_es_tgl_panen->DefaultValue;
        $row['k_ak_tgl_datang'] = $this->k_ak_tgl_datang->DefaultValue;
        $row['k_es_qty'] = $this->k_es_qty->DefaultValue;
        $row['k_ak_qty'] = $this->k_ak_qty->DefaultValue;
        $row['k_es_perhektar'] = $this->k_es_perhektar->DefaultValue;
        $row['k_ak_perhektar'] = $this->k_ak_perhektar->DefaultValue;
        $row['k_skor'] = $this->k_skor->DefaultValue;
        $row['k_ket'] = $this->k_ket->DefaultValue;
        $row['k_cat'] = $this->k_cat->DefaultValue;
        $row['k_titik_koordinat'] = $this->k_titik_koordinat->DefaultValue;
        $row['k_foto_lahan'] = $this->k_foto_lahan->DefaultValue;
        $row['k_dok'] = $this->k_dok->DefaultValue;
        $row['k_harga_bibit'] = $this->k_harga_bibit->DefaultValue;
        $row['k_bayar_bibit'] = $this->k_bayar_bibit->DefaultValue;
        $row['k_pinjaman'] = $this->k_pinjaman->DefaultValue;
        $row['k_bayar_pinjaman'] = $this->k_bayar_pinjaman->DefaultValue;
        $row['k_sisa_hutang'] = $this->k_sisa_hutang->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // k_id
        $this->k_id->RowCssClass = "row";

        // k_id_kontrak
        $this->k_id_kontrak->RowCssClass = "row";

        // k_id_lama
        $this->k_id_lama->RowCssClass = "row";

        // k_no_kontrak
        $this->k_no_kontrak->RowCssClass = "row";

        // k_luas_lahan
        $this->k_luas_lahan->RowCssClass = "row";

        // pet_id
        $this->pet_id->RowCssClass = "row";

        // koord_id
        $this->koord_id->RowCssClass = "row";

        // kk_id
        $this->kk_id->RowCssClass = "row";

        // prov_id
        $this->prov_id->RowCssClass = "row";

        // kab_id
        $this->kab_id->RowCssClass = "row";

        // kec_id
        $this->kec_id->RowCssClass = "row";

        // desa_id
        $this->desa_id->RowCssClass = "row";

        // blok_id
        $this->blok_id->RowCssClass = "row";

        // sos_id
        $this->sos_id->RowCssClass = "row";

        // var_id
        $this->var_id->RowCssClass = "row";

        // co_id
        $this->co_id->RowCssClass = "row";

        // k_jumlah_bibit
        $this->k_jumlah_bibit->RowCssClass = "row";

        // k_asal_bibit
        $this->k_asal_bibit->RowCssClass = "row";

        // k_tgl_tanam
        $this->k_tgl_tanam->RowCssClass = "row";

        // k_es_tgl_panen
        $this->k_es_tgl_panen->RowCssClass = "row";

        // k_ak_tgl_datang
        $this->k_ak_tgl_datang->RowCssClass = "row";

        // k_es_qty
        $this->k_es_qty->RowCssClass = "row";

        // k_ak_qty
        $this->k_ak_qty->RowCssClass = "row";

        // k_es_perhektar
        $this->k_es_perhektar->RowCssClass = "row";

        // k_ak_perhektar
        $this->k_ak_perhektar->RowCssClass = "row";

        // k_skor
        $this->k_skor->RowCssClass = "row";

        // k_ket
        $this->k_ket->RowCssClass = "row";

        // k_cat
        $this->k_cat->RowCssClass = "row";

        // k_titik_koordinat
        $this->k_titik_koordinat->RowCssClass = "row";

        // k_foto_lahan
        $this->k_foto_lahan->RowCssClass = "row";

        // k_dok
        $this->k_dok->RowCssClass = "row";

        // k_harga_bibit
        $this->k_harga_bibit->RowCssClass = "row";

        // k_bayar_bibit
        $this->k_bayar_bibit->RowCssClass = "row";

        // k_pinjaman
        $this->k_pinjaman->RowCssClass = "row";

        // k_bayar_pinjaman
        $this->k_bayar_pinjaman->RowCssClass = "row";

        // k_sisa_hutang
        $this->k_sisa_hutang->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // k_id
            $this->k_id->ViewValue = $this->k_id->CurrentValue;

            // k_id_kontrak
            $this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;

            // k_luas_lahan
            $this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;

            // pet_id
            if ($this->pet_id->VirtualValue != "") {
                $this->pet_id->ViewValue = $this->pet_id->VirtualValue;
            } else {
                $this->pet_id->ViewValue = $this->pet_id->CurrentValue;
                $curVal = strval($this->pet_id->CurrentValue);
                if ($curVal != "") {
                    $this->pet_id->ViewValue = $this->pet_id->lookupCacheOption($curVal);
                    if ($this->pet_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`pet_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->pet_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->pet_id->Lookup->renderViewRow($rswrk[0]);
                            $this->pet_id->ViewValue = $this->pet_id->displayValue($arwrk);
                        } else {
                            $this->pet_id->ViewValue = $this->pet_id->CurrentValue;
                        }
                    }
                } else {
                    $this->pet_id->ViewValue = null;
                }
            }

            // koord_id
            if ($this->koord_id->VirtualValue != "") {
                $this->koord_id->ViewValue = $this->koord_id->VirtualValue;
            } else {
                $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                $curVal = strval($this->koord_id->CurrentValue);
                if ($curVal != "") {
                    $this->koord_id->ViewValue = $this->koord_id->lookupCacheOption($curVal);
                    if ($this->koord_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`koord_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->koord_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->koord_id->Lookup->renderViewRow($rswrk[0]);
                            $this->koord_id->ViewValue = $this->koord_id->displayValue($arwrk);
                        } else {
                            $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                        }
                    }
                } else {
                    $this->koord_id->ViewValue = null;
                }
            }

            // kk_id
            $curVal = strval($this->kk_id->CurrentValue);
            if ($curVal != "") {
                $this->kk_id->ViewValue = $this->kk_id->lookupCacheOption($curVal);
                if ($this->kk_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kk_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->kk_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->kk_id->Lookup->renderViewRow($rswrk[0]);
                        $this->kk_id->ViewValue = $this->kk_id->displayValue($arwrk);
                    } else {
                        $this->kk_id->ViewValue = $this->kk_id->CurrentValue;
                    }
                }
            } else {
                $this->kk_id->ViewValue = null;
            }

            // prov_id
            if ($this->prov_id->VirtualValue != "") {
                $this->prov_id->ViewValue = $this->prov_id->VirtualValue;
            } else {
                $curVal = strval($this->prov_id->CurrentValue);
                if ($curVal != "") {
                    $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
                    if ($this->prov_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->prov_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->prov_id->Lookup->renderViewRow($rswrk[0]);
                            $this->prov_id->ViewValue = $this->prov_id->displayValue($arwrk);
                        } else {
                            $this->prov_id->ViewValue = $this->prov_id->CurrentValue;
                        }
                    }
                } else {
                    $this->prov_id->ViewValue = null;
                }
            }

            // kab_id
            if ($this->kab_id->VirtualValue != "") {
                $this->kab_id->ViewValue = $this->kab_id->VirtualValue;
            } else {
                $curVal = strval($this->kab_id->CurrentValue);
                if ($curVal != "") {
                    $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
                    if ($this->kab_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kab_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kab_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kab_id->ViewValue = $this->kab_id->displayValue($arwrk);
                        } else {
                            $this->kab_id->ViewValue = $this->kab_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kab_id->ViewValue = null;
                }
            }

            // kec_id
            if ($this->kec_id->VirtualValue != "") {
                $this->kec_id->ViewValue = $this->kec_id->VirtualValue;
            } else {
                $curVal = strval($this->kec_id->CurrentValue);
                if ($curVal != "") {
                    $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
                    if ($this->kec_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kec_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kec_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kec_id->ViewValue = $this->kec_id->displayValue($arwrk);
                        } else {
                            $this->kec_id->ViewValue = $this->kec_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kec_id->ViewValue = null;
                }
            }

            // desa_id
            if ($this->desa_id->VirtualValue != "") {
                $this->desa_id->ViewValue = $this->desa_id->VirtualValue;
            } else {
                $curVal = strval($this->desa_id->CurrentValue);
                if ($curVal != "") {
                    $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
                    if ($this->desa_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->desa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->desa_id->Lookup->renderViewRow($rswrk[0]);
                            $this->desa_id->ViewValue = $this->desa_id->displayValue($arwrk);
                        } else {
                            $this->desa_id->ViewValue = $this->desa_id->CurrentValue;
                        }
                    }
                } else {
                    $this->desa_id->ViewValue = null;
                }
            }

            // blok_id
            if ($this->blok_id->VirtualValue != "") {
                $this->blok_id->ViewValue = $this->blok_id->VirtualValue;
            } else {
                $this->blok_id->ViewValue = $this->blok_id->CurrentValue;
                $curVal = strval($this->blok_id->CurrentValue);
                if ($curVal != "") {
                    $this->blok_id->ViewValue = $this->blok_id->lookupCacheOption($curVal);
                    if ($this->blok_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`blok_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->blok_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->blok_id->Lookup->renderViewRow($rswrk[0]);
                            $this->blok_id->ViewValue = $this->blok_id->displayValue($arwrk);
                        } else {
                            $this->blok_id->ViewValue = $this->blok_id->CurrentValue;
                        }
                    }
                } else {
                    $this->blok_id->ViewValue = null;
                }
            }

            // sos_id
            if ($this->sos_id->VirtualValue != "") {
                $this->sos_id->ViewValue = $this->sos_id->VirtualValue;
            } else {
                $curVal = strval($this->sos_id->CurrentValue);
                if ($curVal != "") {
                    $this->sos_id->ViewValue = $this->sos_id->lookupCacheOption($curVal);
                    if ($this->sos_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`sos_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->sos_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->sos_id->Lookup->renderViewRow($rswrk[0]);
                            $this->sos_id->ViewValue = $this->sos_id->displayValue($arwrk);
                        } else {
                            $this->sos_id->ViewValue = $this->sos_id->CurrentValue;
                        }
                    }
                } else {
                    $this->sos_id->ViewValue = null;
                }
            }

            // var_id
            $curVal = strval($this->var_id->CurrentValue);
            if ($curVal != "") {
                $this->var_id->ViewValue = $this->var_id->lookupCacheOption($curVal);
                if ($this->var_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->var_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->var_id->Lookup->renderViewRow($rswrk[0]);
                        $this->var_id->ViewValue = $this->var_id->displayValue($arwrk);
                    } else {
                        $this->var_id->ViewValue = $this->var_id->CurrentValue;
                    }
                }
            } else {
                $this->var_id->ViewValue = null;
            }

            // co_id
            $curVal = strval($this->co_id->CurrentValue);
            if ($curVal != "") {
                $this->co_id->ViewValue = $this->co_id->lookupCacheOption($curVal);
                if ($this->co_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->co_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->co_id->Lookup->renderViewRow($rswrk[0]);
                        $this->co_id->ViewValue = $this->co_id->displayValue($arwrk);
                    } else {
                        $this->co_id->ViewValue = $this->co_id->CurrentValue;
                    }
                }
            } else {
                $this->co_id->ViewValue = null;
            }

            // k_jumlah_bibit
            $this->k_jumlah_bibit->ViewValue = $this->k_jumlah_bibit->CurrentValue;

            // k_asal_bibit
            $this->k_asal_bibit->ViewValue = $this->k_asal_bibit->CurrentValue;

            // k_tgl_tanam
            $this->k_tgl_tanam->ViewValue = $this->k_tgl_tanam->CurrentValue;
            $this->k_tgl_tanam->ViewValue = FormatDateTime($this->k_tgl_tanam->ViewValue, $this->k_tgl_tanam->formatPattern());

            // k_es_tgl_panen
            $this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
            $this->k_es_tgl_panen->ViewValue = FormatDateTime($this->k_es_tgl_panen->ViewValue, $this->k_es_tgl_panen->formatPattern());

            // k_ak_tgl_datang
            $this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
            $this->k_ak_tgl_datang->ViewValue = FormatDateTime($this->k_ak_tgl_datang->ViewValue, $this->k_ak_tgl_datang->formatPattern());

            // k_es_qty
            $this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;

            // k_ak_qty
            $this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;

            // k_es_perhektar
            $this->k_es_perhektar->ViewValue = $this->k_es_perhektar->CurrentValue;

            // k_ak_perhektar
            $this->k_ak_perhektar->ViewValue = $this->k_ak_perhektar->CurrentValue;
            $this->k_ak_perhektar->ViewValue = FormatNumber($this->k_ak_perhektar->ViewValue, $this->k_ak_perhektar->formatPattern());

            // k_skor
            $this->k_skor->ViewValue = $this->k_skor->CurrentValue;
            $this->k_skor->ViewValue = FormatNumber($this->k_skor->ViewValue, $this->k_skor->formatPattern());

            // k_ket
            $this->k_ket->ViewValue = $this->k_ket->CurrentValue;

            // k_cat
            $this->k_cat->ViewValue = $this->k_cat->CurrentValue;

            // k_titik_koordinat
            $this->k_titik_koordinat->ViewValue = $this->k_titik_koordinat->CurrentValue;
            $this->k_titik_koordinat->CellCssStyle .= "text-align: left;";

            // k_foto_lahan
            $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
                $this->k_foto_lahan->ImageWidth = 40;
                $this->k_foto_lahan->ImageHeight = 30;
                $this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->alt();
                $this->k_foto_lahan->ImageCssClass = "ew-image";
                $this->k_foto_lahan->ViewValue = $this->k_foto_lahan->Upload->DbValue;
            } else {
                $this->k_foto_lahan->ViewValue = "";
            }
            $this->k_foto_lahan->CellCssStyle .= "text-align: left;";

            // k_dok
            $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->k_dok->Upload->DbValue)) {
                $this->k_dok->ImageWidth = 42;
                $this->k_dok->ImageHeight = 70;
                $this->k_dok->ImageAlt = $this->k_dok->alt();
                $this->k_dok->ImageCssClass = "ew-image";
                $this->k_dok->ViewValue = $this->k_dok->Upload->DbValue;
            } else {
                $this->k_dok->ViewValue = "";
            }

            // k_harga_bibit
            $this->k_harga_bibit->ViewValue = $this->k_harga_bibit->CurrentValue;

            // k_bayar_bibit
            $this->k_bayar_bibit->ViewValue = $this->k_bayar_bibit->CurrentValue;

            // k_pinjaman
            $this->k_pinjaman->ViewValue = $this->k_pinjaman->CurrentValue;

            // k_bayar_pinjaman
            $this->k_bayar_pinjaman->ViewValue = $this->k_bayar_pinjaman->CurrentValue;

            // k_sisa_hutang
            $this->k_sisa_hutang->ViewValue = $this->k_sisa_hutang->CurrentValue;

            // k_luas_lahan
            $this->k_luas_lahan->HrefValue = "";

            // pet_id
            if (!EmptyValue($this->pet_id->CurrentValue)) {
                $this->pet_id->HrefValue = $this->pet_id->getLinkPrefix() . $this->pet_id->CurrentValue; // Add prefix/suffix
                $this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->pet_id->HrefValue = FullUrl($this->pet_id->HrefValue, "href");
                }
            } else {
                $this->pet_id->HrefValue = "";
            }

            // koord_id
            if (!EmptyValue($this->koord_id->CurrentValue)) {
                $this->koord_id->HrefValue = $this->koord_id->getLinkPrefix() . $this->koord_id->CurrentValue; // Add prefix/suffix
                $this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->koord_id->HrefValue = FullUrl($this->koord_id->HrefValue, "href");
                }
            } else {
                $this->koord_id->HrefValue = "";
            }

            // kk_id
            if (!EmptyValue($this->kk_id->CurrentValue)) {
                $this->kk_id->HrefValue = $this->kk_id->getLinkPrefix() . $this->kk_id->CurrentValue; // Add prefix/suffix
                $this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->kk_id->HrefValue = FullUrl($this->kk_id->HrefValue, "href");
                }
            } else {
                $this->kk_id->HrefValue = "";
            }

            // prov_id
            $this->prov_id->HrefValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";

            // blok_id
            $this->blok_id->HrefValue = "";
            $this->blok_id->TooltipValue = "";

            // sos_id
            $this->sos_id->HrefValue = "";

            // var_id
            if (!EmptyValue($this->var_id->CurrentValue)) {
                $this->var_id->HrefValue = $this->var_id->getLinkPrefix() . $this->var_id->CurrentValue; // Add prefix/suffix
                $this->var_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->var_id->HrefValue = FullUrl($this->var_id->HrefValue, "href");
                }
            } else {
                $this->var_id->HrefValue = "";
            }

            // co_id
            if (!EmptyValue($this->co_id->CurrentValue)) {
                $this->co_id->HrefValue = $this->co_id->getLinkPrefix() . $this->co_id->CurrentValue; // Add prefix/suffix
                $this->co_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->co_id->HrefValue = FullUrl($this->co_id->HrefValue, "href");
                }
            } else {
                $this->co_id->HrefValue = "";
            }

            // k_jumlah_bibit
            $this->k_jumlah_bibit->HrefValue = "";

            // k_asal_bibit
            $this->k_asal_bibit->HrefValue = "";

            // k_tgl_tanam
            $this->k_tgl_tanam->HrefValue = "";

            // k_es_tgl_panen
            $this->k_es_tgl_panen->HrefValue = "";

            // k_es_perhektar
            $this->k_es_perhektar->HrefValue = "";

            // k_ket
            $this->k_ket->HrefValue = "";

            // k_cat
            $this->k_cat->HrefValue = "";

            // k_titik_koordinat
            if (!EmptyValue($this->k_titik_koordinat->CurrentValue)) {
                $this->k_titik_koordinat->HrefValue = (!empty($this->k_titik_koordinat->EditValue) && !is_array($this->k_titik_koordinat->EditValue) ? RemoveHtml($this->k_titik_koordinat->EditValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
                $this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_titik_koordinat->HrefValue = FullUrl($this->k_titik_koordinat->HrefValue, "href");
                }
            } else {
                $this->k_titik_koordinat->HrefValue = "";
            }

            // k_foto_lahan
            $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
                $this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
                $this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_foto_lahan->HrefValue = FullUrl($this->k_foto_lahan->HrefValue, "href");
                }
            } else {
                $this->k_foto_lahan->HrefValue = "";
            }
            $this->k_foto_lahan->ExportHrefValue = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;

            // k_dok
            $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->k_dok->Upload->DbValue)) {
                $this->k_dok->HrefValue = "%u"; // Add prefix/suffix
                $this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_dok->HrefValue = FullUrl($this->k_dok->HrefValue, "href");
                }
            } else {
                $this->k_dok->HrefValue = "";
            }
            $this->k_dok->ExportHrefValue = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;

            // k_harga_bibit
            $this->k_harga_bibit->HrefValue = "";

            // k_bayar_bibit
            $this->k_bayar_bibit->HrefValue = "";

            // k_pinjaman
            $this->k_pinjaman->HrefValue = "";

            // k_bayar_pinjaman
            $this->k_bayar_pinjaman->HrefValue = "";

            // k_sisa_hutang
            $this->k_sisa_hutang->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // k_luas_lahan
            $this->k_luas_lahan->setupEditAttributes();
            $this->k_luas_lahan->EditValue = HtmlEncode($this->k_luas_lahan->CurrentValue);
            $this->k_luas_lahan->PlaceHolder = RemoveHtml($this->k_luas_lahan->caption());
            if (strval($this->k_luas_lahan->EditValue) != "" && is_numeric($this->k_luas_lahan->EditValue)) {
                $this->k_luas_lahan->EditValue = $this->k_luas_lahan->EditValue;
            }

            // pet_id
            $this->pet_id->setupEditAttributes();
            $this->pet_id->EditValue = HtmlEncode($this->pet_id->CurrentValue);
            $this->pet_id->PlaceHolder = RemoveHtml($this->pet_id->caption());

            // koord_id
            $this->koord_id->setupEditAttributes();
            $this->koord_id->EditValue = HtmlEncode($this->koord_id->CurrentValue);
            $this->koord_id->PlaceHolder = RemoveHtml($this->koord_id->caption());

            // kk_id
            $this->kk_id->setupEditAttributes();
            $curVal = trim(strval($this->kk_id->CurrentValue));
            if ($curVal != "") {
                $this->kk_id->ViewValue = $this->kk_id->lookupCacheOption($curVal);
            } else {
                $this->kk_id->ViewValue = $this->kk_id->Lookup !== null && is_array($this->kk_id->lookupOptions()) && count($this->kk_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->kk_id->ViewValue !== null) { // Load from cache
                $this->kk_id->EditValue = array_values($this->kk_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kk_id`", "=", $this->kk_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->kk_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->kk_id->Lookup->renderViewRow($row);
                }
                $this->kk_id->EditValue = $arwrk;
            }
            $this->kk_id->PlaceHolder = RemoveHtml($this->kk_id->caption());

            // prov_id
            $this->prov_id->setupEditAttributes();
            $curVal = trim(strval($this->prov_id->CurrentValue));
            if ($curVal != "") {
                $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
            } else {
                $this->prov_id->ViewValue = $this->prov_id->Lookup !== null && is_array($this->prov_id->lookupOptions()) && count($this->prov_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->prov_id->ViewValue !== null) { // Load from cache
                $this->prov_id->EditValue = array_values($this->prov_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`prov_id`", "=", $this->prov_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->prov_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->prov_id->EditValue = $arwrk;
            }
            $this->prov_id->PlaceHolder = RemoveHtml($this->prov_id->caption());

            // kab_id
            $this->kab_id->setupEditAttributes();
            $curVal = trim(strval($this->kab_id->CurrentValue));
            if ($curVal != "") {
                $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
            } else {
                $this->kab_id->ViewValue = $this->kab_id->Lookup !== null && is_array($this->kab_id->lookupOptions()) && count($this->kab_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->kab_id->ViewValue !== null) { // Load from cache
                $this->kab_id->EditValue = array_values($this->kab_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kab_id`", "=", $this->kab_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->kab_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->kab_id->EditValue = $arwrk;
            }
            $this->kab_id->PlaceHolder = RemoveHtml($this->kab_id->caption());

            // kec_id
            $this->kec_id->setupEditAttributes();
            $curVal = trim(strval($this->kec_id->CurrentValue));
            if ($curVal != "") {
                $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
            } else {
                $this->kec_id->ViewValue = $this->kec_id->Lookup !== null && is_array($this->kec_id->lookupOptions()) && count($this->kec_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->kec_id->ViewValue !== null) { // Load from cache
                $this->kec_id->EditValue = array_values($this->kec_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kec_id`", "=", $this->kec_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->kec_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->kec_id->EditValue = $arwrk;
            }
            $this->kec_id->PlaceHolder = RemoveHtml($this->kec_id->caption());

            // desa_id
            $this->desa_id->setupEditAttributes();
            $curVal = trim(strval($this->desa_id->CurrentValue));
            if ($curVal != "") {
                $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
            } else {
                $this->desa_id->ViewValue = $this->desa_id->Lookup !== null && is_array($this->desa_id->lookupOptions()) && count($this->desa_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->desa_id->ViewValue !== null) { // Load from cache
                $this->desa_id->EditValue = array_values($this->desa_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`desa_id`", "=", $this->desa_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->desa_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->desa_id->EditValue = $arwrk;
            }
            $this->desa_id->PlaceHolder = RemoveHtml($this->desa_id->caption());

            // blok_id
            $this->blok_id->setupEditAttributes();
            $this->blok_id->EditValue = HtmlEncode($this->blok_id->CurrentValue);
            $this->blok_id->PlaceHolder = RemoveHtml($this->blok_id->caption());

            // sos_id
            $this->sos_id->setupEditAttributes();
            $curVal = trim(strval($this->sos_id->CurrentValue));
            if ($curVal != "") {
                $this->sos_id->ViewValue = $this->sos_id->lookupCacheOption($curVal);
            } else {
                $this->sos_id->ViewValue = $this->sos_id->Lookup !== null && is_array($this->sos_id->lookupOptions()) && count($this->sos_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sos_id->ViewValue !== null) { // Load from cache
                $this->sos_id->EditValue = array_values($this->sos_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`sos_id`", "=", $this->sos_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sos_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->sos_id->Lookup->renderViewRow($row);
                }
                $this->sos_id->EditValue = $arwrk;
            }
            $this->sos_id->PlaceHolder = RemoveHtml($this->sos_id->caption());

            // var_id
            $this->var_id->setupEditAttributes();
            $curVal = trim(strval($this->var_id->CurrentValue));
            if ($curVal != "") {
                $this->var_id->ViewValue = $this->var_id->lookupCacheOption($curVal);
            } else {
                $this->var_id->ViewValue = $this->var_id->Lookup !== null && is_array($this->var_id->lookupOptions()) && count($this->var_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->var_id->ViewValue !== null) { // Load from cache
                $this->var_id->EditValue = array_values($this->var_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`var_id`", "=", $this->var_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->var_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->var_id->EditValue = $arwrk;
            }
            $this->var_id->PlaceHolder = RemoveHtml($this->var_id->caption());

            // co_id
            $this->co_id->setupEditAttributes();
            $curVal = trim(strval($this->co_id->CurrentValue));
            if ($curVal != "") {
                $this->co_id->ViewValue = $this->co_id->lookupCacheOption($curVal);
            } else {
                $this->co_id->ViewValue = $this->co_id->Lookup !== null && is_array($this->co_id->lookupOptions()) && count($this->co_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->co_id->ViewValue !== null) { // Load from cache
                $this->co_id->EditValue = array_values($this->co_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`co_id`", "=", $this->co_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->co_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->co_id->EditValue = $arwrk;
            }
            $this->co_id->PlaceHolder = RemoveHtml($this->co_id->caption());

            // k_jumlah_bibit
            $this->k_jumlah_bibit->setupEditAttributes();
            $this->k_jumlah_bibit->EditValue = HtmlEncode($this->k_jumlah_bibit->CurrentValue);
            $this->k_jumlah_bibit->PlaceHolder = RemoveHtml($this->k_jumlah_bibit->caption());
            if (strval($this->k_jumlah_bibit->EditValue) != "" && is_numeric($this->k_jumlah_bibit->EditValue)) {
                $this->k_jumlah_bibit->EditValue = $this->k_jumlah_bibit->EditValue;
            }

            // k_asal_bibit
            $this->k_asal_bibit->setupEditAttributes();
            if (!$this->k_asal_bibit->Raw) {
                $this->k_asal_bibit->CurrentValue = HtmlDecode($this->k_asal_bibit->CurrentValue);
            }
            $this->k_asal_bibit->EditValue = HtmlEncode($this->k_asal_bibit->CurrentValue);
            $this->k_asal_bibit->PlaceHolder = RemoveHtml($this->k_asal_bibit->caption());

            // k_tgl_tanam
            $this->k_tgl_tanam->setupEditAttributes();
            $this->k_tgl_tanam->EditValue = HtmlEncode(FormatDateTime($this->k_tgl_tanam->CurrentValue, $this->k_tgl_tanam->formatPattern()));
            $this->k_tgl_tanam->PlaceHolder = RemoveHtml($this->k_tgl_tanam->caption());

            // k_es_tgl_panen
            $this->k_es_tgl_panen->setupEditAttributes();
            $this->k_es_tgl_panen->EditValue = HtmlEncode(FormatDateTime($this->k_es_tgl_panen->CurrentValue, $this->k_es_tgl_panen->formatPattern()));
            $this->k_es_tgl_panen->PlaceHolder = RemoveHtml($this->k_es_tgl_panen->caption());

            // k_es_perhektar
            $this->k_es_perhektar->setupEditAttributes();
            $this->k_es_perhektar->EditValue = HtmlEncode($this->k_es_perhektar->CurrentValue);
            $this->k_es_perhektar->PlaceHolder = RemoveHtml($this->k_es_perhektar->caption());
            if (strval($this->k_es_perhektar->EditValue) != "" && is_numeric($this->k_es_perhektar->EditValue)) {
                $this->k_es_perhektar->EditValue = $this->k_es_perhektar->EditValue;
            }

            // k_ket
            $this->k_ket->setupEditAttributes();
            $this->k_ket->EditValue = HtmlEncode($this->k_ket->CurrentValue);
            $this->k_ket->PlaceHolder = RemoveHtml($this->k_ket->caption());

            // k_cat
            $this->k_cat->setupEditAttributes();
            $this->k_cat->EditValue = HtmlEncode($this->k_cat->CurrentValue);
            $this->k_cat->PlaceHolder = RemoveHtml($this->k_cat->caption());

            // k_titik_koordinat
            $this->k_titik_koordinat->setupEditAttributes();
            if (!$this->k_titik_koordinat->Raw) {
                $this->k_titik_koordinat->CurrentValue = HtmlDecode($this->k_titik_koordinat->CurrentValue);
            }
            $this->k_titik_koordinat->EditValue = HtmlEncode($this->k_titik_koordinat->CurrentValue);
            $this->k_titik_koordinat->PlaceHolder = RemoveHtml($this->k_titik_koordinat->caption());

            // k_foto_lahan
            $this->k_foto_lahan->setupEditAttributes();
            $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
                $this->k_foto_lahan->ImageWidth = 40;
                $this->k_foto_lahan->ImageHeight = 30;
                $this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->alt();
                $this->k_foto_lahan->ImageCssClass = "ew-image";
                $this->k_foto_lahan->EditValue = $this->k_foto_lahan->Upload->DbValue;
            } else {
                $this->k_foto_lahan->EditValue = "";
            }
            if (!EmptyValue($this->k_foto_lahan->CurrentValue)) {
                $this->k_foto_lahan->Upload->FileName = $this->k_foto_lahan->CurrentValue;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->k_foto_lahan);
            }

            // k_dok
            $this->k_dok->setupEditAttributes();
            $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->k_dok->Upload->DbValue)) {
                $this->k_dok->ImageWidth = 42;
                $this->k_dok->ImageHeight = 70;
                $this->k_dok->ImageAlt = $this->k_dok->alt();
                $this->k_dok->ImageCssClass = "ew-image";
                $this->k_dok->EditValue = $this->k_dok->Upload->DbValue;
            } else {
                $this->k_dok->EditValue = "";
            }
            if (!EmptyValue($this->k_dok->CurrentValue)) {
                $this->k_dok->Upload->FileName = $this->k_dok->CurrentValue;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->k_dok);
            }

            // k_harga_bibit
            $this->k_harga_bibit->setupEditAttributes();
            $this->k_harga_bibit->EditValue = HtmlEncode($this->k_harga_bibit->CurrentValue);
            $this->k_harga_bibit->PlaceHolder = RemoveHtml($this->k_harga_bibit->caption());
            if (strval($this->k_harga_bibit->EditValue) != "" && is_numeric($this->k_harga_bibit->EditValue)) {
                $this->k_harga_bibit->EditValue = $this->k_harga_bibit->EditValue;
            }

            // k_bayar_bibit
            $this->k_bayar_bibit->setupEditAttributes();
            $this->k_bayar_bibit->EditValue = HtmlEncode($this->k_bayar_bibit->CurrentValue);
            $this->k_bayar_bibit->PlaceHolder = RemoveHtml($this->k_bayar_bibit->caption());
            if (strval($this->k_bayar_bibit->EditValue) != "" && is_numeric($this->k_bayar_bibit->EditValue)) {
                $this->k_bayar_bibit->EditValue = $this->k_bayar_bibit->EditValue;
            }

            // k_pinjaman
            $this->k_pinjaman->setupEditAttributes();
            $this->k_pinjaman->EditValue = HtmlEncode($this->k_pinjaman->CurrentValue);
            $this->k_pinjaman->PlaceHolder = RemoveHtml($this->k_pinjaman->caption());
            if (strval($this->k_pinjaman->EditValue) != "" && is_numeric($this->k_pinjaman->EditValue)) {
                $this->k_pinjaman->EditValue = $this->k_pinjaman->EditValue;
            }

            // k_bayar_pinjaman
            $this->k_bayar_pinjaman->setupEditAttributes();
            $this->k_bayar_pinjaman->EditValue = HtmlEncode($this->k_bayar_pinjaman->CurrentValue);
            $this->k_bayar_pinjaman->PlaceHolder = RemoveHtml($this->k_bayar_pinjaman->caption());
            if (strval($this->k_bayar_pinjaman->EditValue) != "" && is_numeric($this->k_bayar_pinjaman->EditValue)) {
                $this->k_bayar_pinjaman->EditValue = $this->k_bayar_pinjaman->EditValue;
            }

            // k_sisa_hutang
            $this->k_sisa_hutang->setupEditAttributes();
            $this->k_sisa_hutang->EditValue = HtmlEncode($this->k_sisa_hutang->CurrentValue);
            $this->k_sisa_hutang->PlaceHolder = RemoveHtml($this->k_sisa_hutang->caption());
            if (strval($this->k_sisa_hutang->EditValue) != "" && is_numeric($this->k_sisa_hutang->EditValue)) {
                $this->k_sisa_hutang->EditValue = $this->k_sisa_hutang->EditValue;
            }

            // Add refer script

            // k_luas_lahan
            $this->k_luas_lahan->HrefValue = "";

            // pet_id
            if (!EmptyValue($this->pet_id->CurrentValue)) {
                $this->pet_id->HrefValue = $this->pet_id->getLinkPrefix() . $this->pet_id->CurrentValue; // Add prefix/suffix
                $this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->pet_id->HrefValue = FullUrl($this->pet_id->HrefValue, "href");
                }
            } else {
                $this->pet_id->HrefValue = "";
            }

            // koord_id
            if (!EmptyValue($this->koord_id->CurrentValue)) {
                $this->koord_id->HrefValue = $this->koord_id->getLinkPrefix() . $this->koord_id->CurrentValue; // Add prefix/suffix
                $this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->koord_id->HrefValue = FullUrl($this->koord_id->HrefValue, "href");
                }
            } else {
                $this->koord_id->HrefValue = "";
            }

            // kk_id
            if (!EmptyValue($this->kk_id->CurrentValue)) {
                $this->kk_id->HrefValue = $this->kk_id->getLinkPrefix() . $this->kk_id->CurrentValue; // Add prefix/suffix
                $this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->kk_id->HrefValue = FullUrl($this->kk_id->HrefValue, "href");
                }
            } else {
                $this->kk_id->HrefValue = "";
            }

            // prov_id
            $this->prov_id->HrefValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";

            // blok_id
            $this->blok_id->HrefValue = "";

            // sos_id
            $this->sos_id->HrefValue = "";

            // var_id
            if (!EmptyValue($this->var_id->CurrentValue)) {
                $this->var_id->HrefValue = $this->var_id->getLinkPrefix() . $this->var_id->CurrentValue; // Add prefix/suffix
                $this->var_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->var_id->HrefValue = FullUrl($this->var_id->HrefValue, "href");
                }
            } else {
                $this->var_id->HrefValue = "";
            }

            // co_id
            if (!EmptyValue($this->co_id->CurrentValue)) {
                $this->co_id->HrefValue = $this->co_id->getLinkPrefix() . $this->co_id->CurrentValue; // Add prefix/suffix
                $this->co_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->co_id->HrefValue = FullUrl($this->co_id->HrefValue, "href");
                }
            } else {
                $this->co_id->HrefValue = "";
            }

            // k_jumlah_bibit
            $this->k_jumlah_bibit->HrefValue = "";

            // k_asal_bibit
            $this->k_asal_bibit->HrefValue = "";

            // k_tgl_tanam
            $this->k_tgl_tanam->HrefValue = "";

            // k_es_tgl_panen
            $this->k_es_tgl_panen->HrefValue = "";

            // k_es_perhektar
            $this->k_es_perhektar->HrefValue = "";

            // k_ket
            $this->k_ket->HrefValue = "";

            // k_cat
            $this->k_cat->HrefValue = "";

            // k_titik_koordinat
            if (!EmptyValue($this->k_titik_koordinat->CurrentValue)) {
                $this->k_titik_koordinat->HrefValue = (!empty($this->k_titik_koordinat->EditValue) && !is_array($this->k_titik_koordinat->EditValue) ? RemoveHtml($this->k_titik_koordinat->EditValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
                $this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_titik_koordinat->HrefValue = FullUrl($this->k_titik_koordinat->HrefValue, "href");
                }
            } else {
                $this->k_titik_koordinat->HrefValue = "";
            }

            // k_foto_lahan
            $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
                $this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
                $this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_foto_lahan->HrefValue = FullUrl($this->k_foto_lahan->HrefValue, "href");
                }
            } else {
                $this->k_foto_lahan->HrefValue = "";
            }
            $this->k_foto_lahan->ExportHrefValue = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;

            // k_dok
            $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->k_dok->Upload->DbValue)) {
                $this->k_dok->HrefValue = "%u"; // Add prefix/suffix
                $this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_dok->HrefValue = FullUrl($this->k_dok->HrefValue, "href");
                }
            } else {
                $this->k_dok->HrefValue = "";
            }
            $this->k_dok->ExportHrefValue = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;

            // k_harga_bibit
            $this->k_harga_bibit->HrefValue = "";

            // k_bayar_bibit
            $this->k_bayar_bibit->HrefValue = "";

            // k_pinjaman
            $this->k_pinjaman->HrefValue = "";

            // k_bayar_pinjaman
            $this->k_bayar_pinjaman->HrefValue = "";

            // k_sisa_hutang
            $this->k_sisa_hutang->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->k_luas_lahan->Visible && $this->k_luas_lahan->Required) {
            if (!$this->k_luas_lahan->IsDetailKey && EmptyValue($this->k_luas_lahan->FormValue)) {
                $this->k_luas_lahan->addErrorMessage(str_replace("%s", $this->k_luas_lahan->caption(), $this->k_luas_lahan->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->k_luas_lahan->FormValue)) {
            $this->k_luas_lahan->addErrorMessage($this->k_luas_lahan->getErrorMessage(false));
        }
        if ($this->pet_id->Visible && $this->pet_id->Required) {
            if (!$this->pet_id->IsDetailKey && EmptyValue($this->pet_id->FormValue)) {
                $this->pet_id->addErrorMessage(str_replace("%s", $this->pet_id->caption(), $this->pet_id->RequiredErrorMessage));
            }
        }
        if ($this->koord_id->Visible && $this->koord_id->Required) {
            if (!$this->koord_id->IsDetailKey && EmptyValue($this->koord_id->FormValue)) {
                $this->koord_id->addErrorMessage(str_replace("%s", $this->koord_id->caption(), $this->koord_id->RequiredErrorMessage));
            }
        }
        if ($this->kk_id->Visible && $this->kk_id->Required) {
            if (!$this->kk_id->IsDetailKey && EmptyValue($this->kk_id->FormValue)) {
                $this->kk_id->addErrorMessage(str_replace("%s", $this->kk_id->caption(), $this->kk_id->RequiredErrorMessage));
            }
        }
        if ($this->prov_id->Visible && $this->prov_id->Required) {
            if (!$this->prov_id->IsDetailKey && EmptyValue($this->prov_id->FormValue)) {
                $this->prov_id->addErrorMessage(str_replace("%s", $this->prov_id->caption(), $this->prov_id->RequiredErrorMessage));
            }
        }
        if ($this->kab_id->Visible && $this->kab_id->Required) {
            if (!$this->kab_id->IsDetailKey && EmptyValue($this->kab_id->FormValue)) {
                $this->kab_id->addErrorMessage(str_replace("%s", $this->kab_id->caption(), $this->kab_id->RequiredErrorMessage));
            }
        }
        if ($this->kec_id->Visible && $this->kec_id->Required) {
            if (!$this->kec_id->IsDetailKey && EmptyValue($this->kec_id->FormValue)) {
                $this->kec_id->addErrorMessage(str_replace("%s", $this->kec_id->caption(), $this->kec_id->RequiredErrorMessage));
            }
        }
        if ($this->desa_id->Visible && $this->desa_id->Required) {
            if (!$this->desa_id->IsDetailKey && EmptyValue($this->desa_id->FormValue)) {
                $this->desa_id->addErrorMessage(str_replace("%s", $this->desa_id->caption(), $this->desa_id->RequiredErrorMessage));
            }
        }
        if ($this->blok_id->Visible && $this->blok_id->Required) {
            if (!$this->blok_id->IsDetailKey && EmptyValue($this->blok_id->FormValue)) {
                $this->blok_id->addErrorMessage(str_replace("%s", $this->blok_id->caption(), $this->blok_id->RequiredErrorMessage));
            }
        }
        if ($this->sos_id->Visible && $this->sos_id->Required) {
            if (!$this->sos_id->IsDetailKey && EmptyValue($this->sos_id->FormValue)) {
                $this->sos_id->addErrorMessage(str_replace("%s", $this->sos_id->caption(), $this->sos_id->RequiredErrorMessage));
            }
        }
        if ($this->var_id->Visible && $this->var_id->Required) {
            if (!$this->var_id->IsDetailKey && EmptyValue($this->var_id->FormValue)) {
                $this->var_id->addErrorMessage(str_replace("%s", $this->var_id->caption(), $this->var_id->RequiredErrorMessage));
            }
        }
        if ($this->co_id->Visible && $this->co_id->Required) {
            if (!$this->co_id->IsDetailKey && EmptyValue($this->co_id->FormValue)) {
                $this->co_id->addErrorMessage(str_replace("%s", $this->co_id->caption(), $this->co_id->RequiredErrorMessage));
            }
        }
        if ($this->k_jumlah_bibit->Visible && $this->k_jumlah_bibit->Required) {
            if (!$this->k_jumlah_bibit->IsDetailKey && EmptyValue($this->k_jumlah_bibit->FormValue)) {
                $this->k_jumlah_bibit->addErrorMessage(str_replace("%s", $this->k_jumlah_bibit->caption(), $this->k_jumlah_bibit->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->k_jumlah_bibit->FormValue)) {
            $this->k_jumlah_bibit->addErrorMessage($this->k_jumlah_bibit->getErrorMessage(false));
        }
        if ($this->k_asal_bibit->Visible && $this->k_asal_bibit->Required) {
            if (!$this->k_asal_bibit->IsDetailKey && EmptyValue($this->k_asal_bibit->FormValue)) {
                $this->k_asal_bibit->addErrorMessage(str_replace("%s", $this->k_asal_bibit->caption(), $this->k_asal_bibit->RequiredErrorMessage));
            }
        }
        if ($this->k_tgl_tanam->Visible && $this->k_tgl_tanam->Required) {
            if (!$this->k_tgl_tanam->IsDetailKey && EmptyValue($this->k_tgl_tanam->FormValue)) {
                $this->k_tgl_tanam->addErrorMessage(str_replace("%s", $this->k_tgl_tanam->caption(), $this->k_tgl_tanam->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->k_tgl_tanam->FormValue, $this->k_tgl_tanam->formatPattern())) {
            $this->k_tgl_tanam->addErrorMessage($this->k_tgl_tanam->getErrorMessage(false));
        }
        if ($this->k_es_tgl_panen->Visible && $this->k_es_tgl_panen->Required) {
            if (!$this->k_es_tgl_panen->IsDetailKey && EmptyValue($this->k_es_tgl_panen->FormValue)) {
                $this->k_es_tgl_panen->addErrorMessage(str_replace("%s", $this->k_es_tgl_panen->caption(), $this->k_es_tgl_panen->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->k_es_tgl_panen->FormValue, $this->k_es_tgl_panen->formatPattern())) {
            $this->k_es_tgl_panen->addErrorMessage($this->k_es_tgl_panen->getErrorMessage(false));
        }
        if ($this->k_es_perhektar->Visible && $this->k_es_perhektar->Required) {
            if (!$this->k_es_perhektar->IsDetailKey && EmptyValue($this->k_es_perhektar->FormValue)) {
                $this->k_es_perhektar->addErrorMessage(str_replace("%s", $this->k_es_perhektar->caption(), $this->k_es_perhektar->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->k_es_perhektar->FormValue)) {
            $this->k_es_perhektar->addErrorMessage($this->k_es_perhektar->getErrorMessage(false));
        }
        if ($this->k_ket->Visible && $this->k_ket->Required) {
            if (!$this->k_ket->IsDetailKey && EmptyValue($this->k_ket->FormValue)) {
                $this->k_ket->addErrorMessage(str_replace("%s", $this->k_ket->caption(), $this->k_ket->RequiredErrorMessage));
            }
        }
        if ($this->k_cat->Visible && $this->k_cat->Required) {
            if (!$this->k_cat->IsDetailKey && EmptyValue($this->k_cat->FormValue)) {
                $this->k_cat->addErrorMessage(str_replace("%s", $this->k_cat->caption(), $this->k_cat->RequiredErrorMessage));
            }
        }
        if ($this->k_titik_koordinat->Visible && $this->k_titik_koordinat->Required) {
            if (!$this->k_titik_koordinat->IsDetailKey && EmptyValue($this->k_titik_koordinat->FormValue)) {
                $this->k_titik_koordinat->addErrorMessage(str_replace("%s", $this->k_titik_koordinat->caption(), $this->k_titik_koordinat->RequiredErrorMessage));
            }
        }
        if ($this->k_foto_lahan->Visible && $this->k_foto_lahan->Required) {
            if ($this->k_foto_lahan->Upload->FileName == "" && !$this->k_foto_lahan->Upload->KeepFile) {
                $this->k_foto_lahan->addErrorMessage(str_replace("%s", $this->k_foto_lahan->caption(), $this->k_foto_lahan->RequiredErrorMessage));
            }
        }
        if ($this->k_dok->Visible && $this->k_dok->Required) {
            if ($this->k_dok->Upload->FileName == "" && !$this->k_dok->Upload->KeepFile) {
                $this->k_dok->addErrorMessage(str_replace("%s", $this->k_dok->caption(), $this->k_dok->RequiredErrorMessage));
            }
        }
        if ($this->k_harga_bibit->Visible && $this->k_harga_bibit->Required) {
            if (!$this->k_harga_bibit->IsDetailKey && EmptyValue($this->k_harga_bibit->FormValue)) {
                $this->k_harga_bibit->addErrorMessage(str_replace("%s", $this->k_harga_bibit->caption(), $this->k_harga_bibit->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->k_harga_bibit->FormValue)) {
            $this->k_harga_bibit->addErrorMessage($this->k_harga_bibit->getErrorMessage(false));
        }
        if ($this->k_bayar_bibit->Visible && $this->k_bayar_bibit->Required) {
            if (!$this->k_bayar_bibit->IsDetailKey && EmptyValue($this->k_bayar_bibit->FormValue)) {
                $this->k_bayar_bibit->addErrorMessage(str_replace("%s", $this->k_bayar_bibit->caption(), $this->k_bayar_bibit->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->k_bayar_bibit->FormValue)) {
            $this->k_bayar_bibit->addErrorMessage($this->k_bayar_bibit->getErrorMessage(false));
        }
        if ($this->k_pinjaman->Visible && $this->k_pinjaman->Required) {
            if (!$this->k_pinjaman->IsDetailKey && EmptyValue($this->k_pinjaman->FormValue)) {
                $this->k_pinjaman->addErrorMessage(str_replace("%s", $this->k_pinjaman->caption(), $this->k_pinjaman->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->k_pinjaman->FormValue)) {
            $this->k_pinjaman->addErrorMessage($this->k_pinjaman->getErrorMessage(false));
        }
        if ($this->k_bayar_pinjaman->Visible && $this->k_bayar_pinjaman->Required) {
            if (!$this->k_bayar_pinjaman->IsDetailKey && EmptyValue($this->k_bayar_pinjaman->FormValue)) {
                $this->k_bayar_pinjaman->addErrorMessage(str_replace("%s", $this->k_bayar_pinjaman->caption(), $this->k_bayar_pinjaman->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->k_bayar_pinjaman->FormValue)) {
            $this->k_bayar_pinjaman->addErrorMessage($this->k_bayar_pinjaman->getErrorMessage(false));
        }
        if ($this->k_sisa_hutang->Visible && $this->k_sisa_hutang->Required) {
            if (!$this->k_sisa_hutang->IsDetailKey && EmptyValue($this->k_sisa_hutang->FormValue)) {
                $this->k_sisa_hutang->addErrorMessage(str_replace("%s", $this->k_sisa_hutang->caption(), $this->k_sisa_hutang->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->k_sisa_hutang->FormValue)) {
            $this->k_sisa_hutang->addErrorMessage($this->k_sisa_hutang->getErrorMessage(false));
        }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("PenggunaanPestisidaGrid");
        if (in_array("penggunaan_pestisida", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set new row
        $rsnew = [];

        // k_luas_lahan
        $this->k_luas_lahan->setDbValueDef($rsnew, $this->k_luas_lahan->CurrentValue, false);

        // pet_id
        $this->pet_id->setDbValueDef($rsnew, $this->pet_id->CurrentValue, false);

        // koord_id
        $this->koord_id->setDbValueDef($rsnew, $this->koord_id->CurrentValue, false);

        // kk_id
        $this->kk_id->setDbValueDef($rsnew, $this->kk_id->CurrentValue, false);

        // prov_id
        $this->prov_id->setDbValueDef($rsnew, $this->prov_id->CurrentValue, false);

        // kab_id
        $this->kab_id->setDbValueDef($rsnew, $this->kab_id->CurrentValue, false);

        // kec_id
        $this->kec_id->setDbValueDef($rsnew, $this->kec_id->CurrentValue, false);

        // desa_id
        $this->desa_id->setDbValueDef($rsnew, $this->desa_id->CurrentValue, false);

        // blok_id
        $this->blok_id->setDbValueDef($rsnew, $this->blok_id->CurrentValue, false);

        // sos_id
        $this->sos_id->setDbValueDef($rsnew, $this->sos_id->CurrentValue, false);

        // var_id
        $this->var_id->setDbValueDef($rsnew, $this->var_id->CurrentValue, false);

        // co_id
        $this->co_id->setDbValueDef($rsnew, $this->co_id->CurrentValue, false);

        // k_jumlah_bibit
        $this->k_jumlah_bibit->setDbValueDef($rsnew, $this->k_jumlah_bibit->CurrentValue, false);

        // k_asal_bibit
        $this->k_asal_bibit->setDbValueDef($rsnew, $this->k_asal_bibit->CurrentValue, false);

        // k_tgl_tanam
        $this->k_tgl_tanam->setDbValueDef($rsnew, UnFormatDateTime($this->k_tgl_tanam->CurrentValue, $this->k_tgl_tanam->formatPattern()), false);

        // k_es_tgl_panen
        $this->k_es_tgl_panen->setDbValueDef($rsnew, UnFormatDateTime($this->k_es_tgl_panen->CurrentValue, $this->k_es_tgl_panen->formatPattern()), false);

        // k_es_perhektar
        $this->k_es_perhektar->setDbValueDef($rsnew, $this->k_es_perhektar->CurrentValue, false);

        // k_ket
        $this->k_ket->setDbValueDef($rsnew, $this->k_ket->CurrentValue, false);

        // k_cat
        $this->k_cat->setDbValueDef($rsnew, $this->k_cat->CurrentValue, false);

        // k_titik_koordinat
        $this->k_titik_koordinat->setDbValueDef($rsnew, $this->k_titik_koordinat->CurrentValue, false);

        // k_foto_lahan
        if ($this->k_foto_lahan->Visible && !$this->k_foto_lahan->Upload->KeepFile) {
            $this->k_foto_lahan->Upload->DbValue = ""; // No need to delete old file
            if ($this->k_foto_lahan->Upload->FileName == "") {
                $rsnew['k_foto_lahan'] = null;
            } else {
                $rsnew['k_foto_lahan'] = $this->k_foto_lahan->Upload->FileName;
            }
            $this->k_foto_lahan->ImageWidth = 400; // Resize width
            $this->k_foto_lahan->ImageHeight = 300; // Resize height
        }

        // k_dok
        if ($this->k_dok->Visible && !$this->k_dok->Upload->KeepFile) {
            $this->k_dok->Upload->DbValue = ""; // No need to delete old file
            if ($this->k_dok->Upload->FileName == "") {
                $rsnew['k_dok'] = null;
            } else {
                $rsnew['k_dok'] = $this->k_dok->Upload->FileName;
            }
            $this->k_dok->ImageWidth = 420; // Resize width
            $this->k_dok->ImageHeight = 700; // Resize height
        }

        // k_harga_bibit
        $this->k_harga_bibit->setDbValueDef($rsnew, $this->k_harga_bibit->CurrentValue, false);

        // k_bayar_bibit
        $this->k_bayar_bibit->setDbValueDef($rsnew, $this->k_bayar_bibit->CurrentValue, false);

        // k_pinjaman
        $this->k_pinjaman->setDbValueDef($rsnew, $this->k_pinjaman->CurrentValue, false);

        // k_bayar_pinjaman
        $this->k_bayar_pinjaman->setDbValueDef($rsnew, $this->k_bayar_pinjaman->CurrentValue, false);

        // k_sisa_hutang
        $this->k_sisa_hutang->setDbValueDef($rsnew, $this->k_sisa_hutang->CurrentValue, false);
        if ($this->k_foto_lahan->Visible && !$this->k_foto_lahan->Upload->KeepFile) {
            $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
            $oldFiles = EmptyValue($this->k_foto_lahan->Upload->DbValue) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->k_foto_lahan->htmlDecode(strval($this->k_foto_lahan->Upload->DbValue)));
            if (!EmptyValue($this->k_foto_lahan->Upload->FileName)) {
                $newFiles = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), strval($this->k_foto_lahan->Upload->FileName));
                $NewFileCount = count($newFiles);
                for ($i = 0; $i < $NewFileCount; $i++) {
                    if ($newFiles[$i] != "") {
                        $file = $newFiles[$i];
                        $tempPath = UploadTempPath($this->k_foto_lahan, $this->k_foto_lahan->Upload->Index);
                        if (file_exists($tempPath . $file)) {
                            if (Config("DELETE_UPLOADED_FILES")) {
                                $oldFileFound = false;
                                $oldFileCount = count($oldFiles);
                                for ($j = 0; $j < $oldFileCount; $j++) {
                                    $oldFile = $oldFiles[$j];
                                    if ($oldFile == $file) { // Old file found, no need to delete anymore
                                        array_splice($oldFiles, $j, 1);
                                        $oldFileFound = true;
                                        break;
                                    }
                                }
                                if ($oldFileFound) { // No need to check if file exists further
                                    continue;
                                }
                            }
                            $file1 = UniqueFilename($this->k_foto_lahan->physicalUploadPath(), $file); // Get new file name
                            if ($file1 != $file) { // Rename temp file
                                while (file_exists($tempPath . $file1) || file_exists($this->k_foto_lahan->physicalUploadPath() . $file1)) { // Make sure no file name clash
                                    $file1 = UniqueFilename([$this->k_foto_lahan->physicalUploadPath(), $tempPath], $file1, true); // Use indexed name
                                }
                                rename($tempPath . $file, $tempPath . $file1);
                                $newFiles[$i] = $file1;
                            }
                        }
                    }
                }
                $this->k_foto_lahan->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
                $this->k_foto_lahan->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
                $this->k_foto_lahan->setDbValueDef($rsnew, $this->k_foto_lahan->Upload->FileName, false);
            }
        }
        if ($this->k_dok->Visible && !$this->k_dok->Upload->KeepFile) {
            $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
            $oldFiles = EmptyValue($this->k_dok->Upload->DbValue) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->k_dok->htmlDecode(strval($this->k_dok->Upload->DbValue)));
            if (!EmptyValue($this->k_dok->Upload->FileName)) {
                $newFiles = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), strval($this->k_dok->Upload->FileName));
                $NewFileCount = count($newFiles);
                for ($i = 0; $i < $NewFileCount; $i++) {
                    if ($newFiles[$i] != "") {
                        $file = $newFiles[$i];
                        $tempPath = UploadTempPath($this->k_dok, $this->k_dok->Upload->Index);
                        if (file_exists($tempPath . $file)) {
                            if (Config("DELETE_UPLOADED_FILES")) {
                                $oldFileFound = false;
                                $oldFileCount = count($oldFiles);
                                for ($j = 0; $j < $oldFileCount; $j++) {
                                    $oldFile = $oldFiles[$j];
                                    if ($oldFile == $file) { // Old file found, no need to delete anymore
                                        array_splice($oldFiles, $j, 1);
                                        $oldFileFound = true;
                                        break;
                                    }
                                }
                                if ($oldFileFound) { // No need to check if file exists further
                                    continue;
                                }
                            }
                            $file1 = UniqueFilename($this->k_dok->physicalUploadPath(), $file); // Get new file name
                            if ($file1 != $file) { // Rename temp file
                                while (file_exists($tempPath . $file1) || file_exists($this->k_dok->physicalUploadPath() . $file1)) { // Make sure no file name clash
                                    $file1 = UniqueFilename([$this->k_dok->physicalUploadPath(), $tempPath], $file1, true); // Use indexed name
                                }
                                rename($tempPath . $file, $tempPath . $file1);
                                $newFiles[$i] = $file1;
                            }
                        }
                    }
                }
                $this->k_dok->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
                $this->k_dok->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
                $this->k_dok->setDbValueDef($rsnew, $this->k_dok->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->k_foto_lahan->OldUploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
        $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->OldUploadPath;
        $this->k_dok->OldUploadPath = $this->k_dok->getUploadPath(); // PHP
        $this->k_dok->UploadPath = $this->k_dok->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->k_foto_lahan->Visible && !$this->k_foto_lahan->Upload->KeepFile) {
                    $oldFiles = EmptyValue($this->k_foto_lahan->Upload->DbValue) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->k_foto_lahan->htmlDecode(strval($this->k_foto_lahan->Upload->DbValue)));
                    if (!EmptyValue($this->k_foto_lahan->Upload->FileName)) {
                        $newFiles = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->k_foto_lahan->Upload->FileName);
                        $newFiles2 = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->k_foto_lahan->htmlDecode($rsnew['k_foto_lahan']));
                        $newFileCount = count($newFiles);
                        for ($i = 0; $i < $newFileCount; $i++) {
                            if ($newFiles[$i] != "") {
                                $file = UploadTempPath($this->k_foto_lahan, $this->k_foto_lahan->Upload->Index) . $newFiles[$i];
                                if (file_exists($file)) {
                                    if (@$newFiles2[$i] != "") { // Use correct file name
                                        $newFiles[$i] = $newFiles2[$i];
                                    }
                                    if (!$this->k_foto_lahan->Upload->ResizeAndSaveToFile($this->k_foto_lahan->ImageWidth, $this->k_foto_lahan->ImageHeight, 100, $newFiles[$i], true, $i)) {
                                        $this->setFailureMessage($Language->phrase("UploadError7"));
                                        return false;
                                    }
                                }
                            }
                        }
                    } else {
                        $newFiles = [];
                    }
                }
                if ($this->k_dok->Visible && !$this->k_dok->Upload->KeepFile) {
                    $oldFiles = EmptyValue($this->k_dok->Upload->DbValue) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->k_dok->htmlDecode(strval($this->k_dok->Upload->DbValue)));
                    if (!EmptyValue($this->k_dok->Upload->FileName)) {
                        $newFiles = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->k_dok->Upload->FileName);
                        $newFiles2 = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->k_dok->htmlDecode($rsnew['k_dok']));
                        $newFileCount = count($newFiles);
                        for ($i = 0; $i < $newFileCount; $i++) {
                            if ($newFiles[$i] != "") {
                                $file = UploadTempPath($this->k_dok, $this->k_dok->Upload->Index) . $newFiles[$i];
                                if (file_exists($file)) {
                                    if (@$newFiles2[$i] != "") { // Use correct file name
                                        $newFiles[$i] = $newFiles2[$i];
                                    }
                                    if (!$this->k_dok->Upload->ResizeAndSaveToFile($this->k_dok->ImageWidth, $this->k_dok->ImageHeight, 100, $newFiles[$i], true, $i)) {
                                        $this->setFailureMessage($Language->phrase("UploadError7"));
                                        return false;
                                    }
                                }
                            }
                        }
                    } else {
                        $newFiles = [];
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("PenggunaanPestisidaGrid");
            if (in_array("penggunaan_pestisida", $detailTblVar) && $detailPage->DetailAdd) {
                $detailPage->ID_Kontrak->setSessionValue($this->k_id->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "penggunaan_pestisida"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->ID_Kontrak->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                if ($this->UseTransaction) { // Commit transaction
                    $conn->commit();
                }
            } else {
                if ($this->UseTransaction) { // Rollback transaction
                    $conn->rollback();
                }
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("penggunaan_pestisida", $detailTblVar)) {
                $detailPageObj = Container("PenggunaanPestisidaGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->ID_Kontrak->IsDetailKey = true;
                    $detailPageObj->ID_Kontrak->CurrentValue = $this->k_id->CurrentValue;
                    $detailPageObj->ID_Kontrak->setSessionValue($detailPageObj->ID_Kontrak->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KontrakList");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("KontrakList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_pet_id":
                    break;
                case "x_koord_id":
                    break;
                case "x_kk_id":
                    break;
                case "x_prov_id":
                    break;
                case "x_kab_id":
                    break;
                case "x_kec_id":
                    break;
                case "x_desa_id":
                    break;
                case "x_blok_id":
                    break;
                case "x_sos_id":
                    break;
                case "x_var_id":
                    break;
                case "x_co_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
