<?php
namespace PHPMaker2019\co;

/**
 * Table class for real_kirim
 */
class real_kirim extends CrosstabTable
{
	public $var_nama;
	public $ob_tgl_real_kirim;
	public $ob_jumlah_real_kirim;
	public $co_nama;
	public $kab_nama;
	public $YEAR__ob_tgl_real_kirim;

	// Constructor
	public function __construct()
	{
		global $ReportLanguage, $CurrentLanguage;

		// Language object
		if (!isset($ReportLanguage))
			$ReportLanguage = new ReportLanguage();
		$this->TableVar = 'real_kirim';
		$this->TableName = 'real_kirim';
		$this->TableType = 'REPORT';
		$this->TableReportType = 'crosstab';
		$this->SourceTableIsCustomView = FALSE;
		$this->Dbid = 'DB';
		$this->ColumnFieldName = 'ob_tgl_real_kirim';
		$this->ColumnDateSelection = TRUE;
		$this->ColumnDateType = 'm';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0;

		// var_nama
		$this->var_nama = new ReportField('real_kirim', 'real_kirim', 'x_var_nama', 'var_nama', '`var_nama`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->var_nama->Sortable = TRUE; // Allow sort
		$this->var_nama->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->var_nama->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->var_nama->GroupingFieldId = 1;
		$this->var_nama->DateFilter = "";
		$this->var_nama->Lookup = new ReportLookup('var_nama', 'real_kirim', TRUE, 'var_nama', ["var_nama","","",""], [], [], [], [], [], [], '`var_nama` ASC', '');
		$this->var_nama->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['var_nama'] = &$this->var_nama;

		// ob_tgl_real_kirim
		$this->ob_tgl_real_kirim = new ReportField('real_kirim', 'real_kirim', 'x_ob_tgl_real_kirim', 'ob_tgl_real_kirim', '`ob_tgl_real_kirim`', 133, 0, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ob_tgl_real_kirim->Sortable = TRUE; // Allow sort
		$this->ob_tgl_real_kirim->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $ReportLanguage->phrase("IncorrectDate"));
		$this->ob_tgl_real_kirim->DateFilter = "";
		$this->ob_tgl_real_kirim->LookupExpression = "YEAR(`ob_tgl_real_kirim`)";
		$this->fields['ob_tgl_real_kirim'] = &$this->ob_tgl_real_kirim;

		// ob_jumlah_real_kirim
		$this->ob_jumlah_real_kirim = new ReportField('real_kirim', 'real_kirim', 'x_ob_jumlah_real_kirim', 'ob_jumlah_real_kirim', '`ob_jumlah_real_kirim`', 3, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ob_jumlah_real_kirim->Sortable = TRUE; // Allow sort
		$this->ob_jumlah_real_kirim->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectInteger");
		$this->ob_jumlah_real_kirim->DateFilter = "";
		$this->fields['ob_jumlah_real_kirim'] = &$this->ob_jumlah_real_kirim;

		// co_nama
		$this->co_nama = new ReportField('real_kirim', 'real_kirim', 'x_co_nama', 'co_nama', '`co_nama`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->co_nama->Sortable = TRUE; // Allow sort
		$this->co_nama->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->co_nama->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->co_nama->GroupingFieldId = 2;
		$this->co_nama->DateFilter = "";
		$this->co_nama->Lookup = new ReportLookup('co_nama', 'real_kirim', TRUE, 'co_nama', ["co_nama","","",""], [], [], [], [], [], [], '`co_nama` ASC', '');
		$this->co_nama->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['co_nama'] = &$this->co_nama;

		// kab_nama
		$this->kab_nama = new ReportField('real_kirim', 'real_kirim', 'x_kab_nama', 'kab_nama', '`kab_nama`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->kab_nama->Sortable = TRUE; // Allow sort
		$this->kab_nama->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->kab_nama->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->kab_nama->GroupingFieldId = 3;
		$this->kab_nama->DateFilter = "";
		$this->kab_nama->Lookup = new ReportLookup('kab_nama', 'real_kirim', TRUE, 'kab_nama', ["kab_nama","","",""], [], [], [], [], [], [], '`kab_nama` ASC', '');
		$this->kab_nama->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['kab_nama'] = &$this->kab_nama;

		// YEAR__ob_tgl_real_kirim
		$this->YEAR__ob_tgl_real_kirim = new ReportField('real_kirim', 'real_kirim', 'x_YEAR__ob_tgl_real_kirim', 'YEAR__ob_tgl_real_kirim', 'YEAR(`ob_tgl_real_kirim`)', 3);
		$this->fields['YEAR__ob_tgl_real_kirim'] = &$this->YEAR__ob_tgl_real_kirim;
	}

	// Render for popup
	public function renderPopup()
	{
		global $ReportLanguage;
	}

	// Render for lookup
	public function renderLookup()
	{
		$this->var_nama->ViewValue = GetDropDownDisplayValue($this->var_nama->CurrentValue, "", 0);
		$this->ob_tgl_real_kirim->ViewValue = $this->ob_tgl_real_kirim->CurrentValue;
		$this->co_nama->ViewValue = GetDropDownDisplayValue($this->co_nama->CurrentValue, "", 0);
		$this->kab_nama->ViewValue = GetDropDownDisplayValue($this->kab_nama->CurrentValue, "", 0);
	}

	// Get Field Visibility
	public function getFieldVisibility($fldparm)
	{
		global $Security;
		return $this->$fldparm->Visible; // Returns original value
	}

	// Single column sort
	protected function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($fld->GroupingFieldId == 0)
				$this->setDetailOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			if ($fld->GroupingFieldId == 0) $fld->setSort("");
		}
	}

	// Get Sort SQL
	protected function sortSql()
	{
		$dtlSortSql = $this->getDetailOrderBy(); // Get ORDER BY for detail fields from session
		$argrps = [];
		foreach ($this->fields as $fld) {
			if ($fld->getSort() <> "") {
				$fldsql = $fld->Expression;
				if ($fld->GroupingFieldId > 0) {
					if ($fld->GroupSql <> "")
						$argrps[$fld->GroupingFieldId] = str_replace("%s", $fldsql, $fld->GroupSql) . " " . $fld->getSort();
					else
						$argrps[$fld->GroupingFieldId] = $fldsql . " " . $fld->getSort();
				}
			}
		}
		$sortSql = "";
		foreach ($argrps as $grp) {
			if ($sortSql <> "") $sortSql .= ", ";
			$sortSql .= $grp;
		}
		if ($dtlSortSql <> "") {
			if ($sortSql <> "") $sortSql .= ", ";
			$sortSql .= $dtlSortSql;
		}
		return $sortSql;
	}

	// Table level SQL
	private $_sqlFrom = "";
	private $_sqlSelect = "";
	private $_sqlWhere = "";
	private $_sqlGroupBy = "";
	private $_sqlHaving = "";
	private $_sqlOrderBy = "";

	// From
	public function getSqlFrom()
	{
		return ($this->_sqlFrom <> "") ? $this->_sqlFrom : "`view4`";
	}
	public function setSqlFrom($v)
	{
		$this->_sqlFrom = $v;
	}

	// Select
	public function getSqlSelect()
	{
		return ($this->_sqlSelect <> "") ? $this->_sqlSelect : "SELECT `var_nama`, `co_nama`, `kab_nama`, YEAR(`ob_tgl_real_kirim`) AS `YEAR__ob_tgl_real_kirim`, <DistinctColumnFields> FROM " . $this->getSqlFrom();
	}
	public function setSqlSelect($v)
	{
		$this->_sqlSelect = $v;
	}

	// Where
	public function getSqlWhere()
	{
		$where = ($this->_sqlWhere <> "") ? $this->_sqlWhere : "";
		$filter = "";
		AddFilter($where, $filter);
		return $where;
	}
	public function setSqlWhere($v)
	{
		$this->_sqlWhere = $v;
	}

	// Group By
	public function getSqlGroupBy()
	{
		return ($this->_sqlGroupBy <> "") ? $this->_sqlGroupBy : "`var_nama`, `co_nama`, `kab_nama`, YEAR(`ob_tgl_real_kirim`)";
	}
	public function setSqlGroupBy($v)
	{
		$this->_sqlGroupBy = $v;
	}

	// Having
	public function getSqlHaving()
	{
		return ($this->_sqlHaving <> "") ? $this->_sqlHaving : "";
	}
	public function setSqlHaving($v)
	{
		$this->_sqlHaving = $v;
	}

	// Order By
	public function getSqlOrderBy()
	{
		return ($this->_sqlOrderBy <> "") ? $this->_sqlOrderBy : "`var_nama` ASC, `co_nama` ASC, `kab_nama` ASC, YEAR(`ob_tgl_real_kirim`)";
	}
	public function setSqlOrderBy($v)
	{
		$this->_sqlOrderBy = $v;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table level SQL
	private $_columnField = "";
	private $_columnDateType = "";
	private $_columnCaptions = "";
	private $_columnNames = "";
	private $_columnValues = "";
	private $_sqlCrosstabYear = "";
	public $ColumnCount;
	public $Col;
	public $DistinctColumnFields = "";
	private $_columnLoaded = FALSE;

	// Column field
	public function getColumnField()
	{
		return ($this->_columnField <> "") ? $this->_columnField : "`ob_tgl_real_kirim`";
	}
	public function setColumnField($v)
	{
		$this->_columnField = $v;
	}

	// Column date type
	public function getColumnDateType()
	{
		return ($this->_columnDateType <> "") ? $this->_columnDateType : "m";
	}
	public function setColumnDateType($v)
	{
		$this->_columnDateType = $v;
	}

	// Column captions
	public function getColumnCaptions()
	{
		global $ReportLanguage;
		return ($this->_columnCaptions <> "") ? $this->_columnCaptions : $ReportLanguage->phrase("MonthJan") . "," . $ReportLanguage->phrase("MonthFeb") . "," . $ReportLanguage->phrase("MonthMar") . "," . $ReportLanguage->phrase("MonthApr") . "," . $ReportLanguage->phrase("MonthMay") . "," . $ReportLanguage->phrase("MonthJun") . "," . $ReportLanguage->phrase("MonthJul") . "," . $ReportLanguage->phrase("MonthAug") . "," . $ReportLanguage->phrase("MonthSep") . "," . $ReportLanguage->phrase("MonthOct") . "," . $ReportLanguage->phrase("MonthNov") . "," . $ReportLanguage->phrase("MonthDec");
	}
	public function setColumnCaptions($v)
	{
		$this->_columnCaptions = $v;
	}

	// Column names
	public function getColumnNames()
	{
		return ($this->_columnNames <> "") ? $this->_columnNames : "MonthJan,MonthFeb,MonthMar,MonthApr,MonthMay,MonthJun,MonthJul,MonthAug,MonthSep,MonthOct,MonthNov,MonthDec";
	}
	public function setColumnNames($v)
	{
		$this->_columnNames = $v;
	}

	// Column values
	public function getColumnValues()
	{
		return ($this->_columnValues <> "") ? $this->_columnValues : "1,2,3,4,5,6,7,8,9,10,11,12";
	}
	public function setColumnValues($v)
	{
		$this->_columnValues = $v;
	}

	// Crosstab Year
	public function getSqlCrosstabYear()
	{
		return ($this->_sqlCrosstabYear <> "") ? $this->_sqlCrosstabYear : "SELECT DISTINCT YEAR(`ob_tgl_real_kirim`) AS `YEAR__ob_tgl_real_kirim` FROM `view4` ORDER BY YEAR(`ob_tgl_real_kirim`)";
	}
	public function setSqlCrosstabYear($v)
	{
		$this->_sqlCrosstabYear = $v;
	}

	// Load column values
	public function loadColumnValues($filter = "")
	{
		global $ReportLanguage;

		// Data already loaded, return
		if ($this->_columnLoaded)
			return;
		$conn = &$this->getConnection();
		$arColumnCaptions = explode(",", $this->getColumnCaptions());
		$arColumnNames = explode(",", $this->getColumnNames());
		$arColumnValues = explode(",", $this->getColumnValues());

		// Get distinct column count
		$this->ColumnCount = count($arColumnNames);
		$this->Columns = &Init2DArray($this->ColumnCount + 1, 4, NULL);
		for ($colcnt = 1; $colcnt <= $this->ColumnCount; $colcnt++) {
			$this->Columns[$colcnt] = new CrosstabColumn($arColumnValues[$colcnt-1], $arColumnCaptions[$colcnt-1], TRUE);
		}

		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of distinct values

		$groupCount = 3;
		$this->SummaryFields[0] = new SummaryField('x_ob_jumlah_real_kirim', 'ob_jumlah_real_kirim', '`ob_jumlah_real_kirim`', 'SUM');
		$this->SummaryFields[0]->SummaryCaption = $ReportLanguage->phrase("RptSum");
		$this->SummaryFields[0]->SummaryValues = &InitArray($this->ColumnCount+1, NULL);
		$this->SummaryFields[0]->SummaryValueCounts = &InitArray($this->ColumnCount+1, NULL);
		$this->SummaryFields[0]->SummaryCounts = &Init2DArray($this->ColumnCount+1, $groupCount+1, NULL);
		$this->SummaryFields[0]->SummarySummaries = &Init2DArray($this->ColumnCount+1, $groupCount+1, NULL);
		$this->SummaryFields[0]->SummarySummaryCounts = &Init2DArray($this->ColumnCount+1, $groupCount+1, NULL);
		$this->SummaryFields[0]->SummaryInitValue = 0;

		// Update crosstab SQL
		$sqlFlds = "";
		$cnt = count($this->SummaryFields);
		for ($is = 0; $is < $cnt; $is++) {
			$smry = &$this->SummaryFields[$is];
			for ($i = 0; $i < $this->ColumnCount; $i++) {
				$fld = CrosstabFieldExpression($smry->SummaryType, $smry->Expression,
					$this->getColumnField(), $this->getColumnDateType(), $arColumnValues[$i], "", $arColumnNames[$i] . $is, $this->Dbid);
				if ($sqlFlds <> "")
					$sqlFlds .= ", ";
				$sqlFlds .= $fld;
			}
		}
		$this->DistinctColumnFields = $sqlFlds;
		$this->_columnLoaded = TRUE;
	}

	// Table Level Group SQL
	private $_sqlFirstGroupField = "";
	private $_sqlSelectGroup = "";
	private $_sqlOrderByGroup = "";

	// First Group Field
	public function getSqlFirstGroupField()
	{
		return ($this->_sqlFirstGroupField <> "") ? $this->_sqlFirstGroupField : "`var_nama`";
	}
	public function setSqlFirstGroupField($v)
	{
		$this->_sqlFirstGroupField = $v;
	}

	// Select Group
	public function getSqlSelectGroup()
	{
		return ($this->_sqlSelectGroup <> "") ? $this->_sqlSelectGroup : "SELECT DISTINCT " . $this->getSqlFirstGroupField() . " FROM " . $this->getSqlFrom();
	}
	public function setSqlSelectGroup($v)
	{
		$this->_sqlSelectGroup = $v;
	}

	// Order By Group
	public function getSqlOrderByGroup()
	{
		return ($this->_sqlOrderByGroup <> "") ? $this->_sqlOrderByGroup : "`var_nama` ASC";
	}
	public function setSqlOrderByGroup($v)
	{
		$this->_sqlOrderByGroup = $v;
	}

	// Crosstab properties
	private $_sqlSelectAggregate = "";
	private $_sqlGroupByAggregate = "";

	// Select Aggregate
	public function getSqlSelectAggregate()
	{
		return ($this->_sqlSelectAggregate <> "") ? $this->_sqlSelectAggregate : "SELECT YEAR(`ob_tgl_real_kirim`) AS `YEAR__ob_tgl_real_kirim`, <DistinctColumnFields> FROM " . $this->getSqlFrom();
	}
	public function setSqlSelectAggregate($v)
	{
		$this->_sqlSelectAggregate = $v;
	}

	// Group By Aggregate
	public function getSqlGroupByAggregate()
	{
		return ($this->_sqlGroupByAggregate <> "") ? $this->_sqlGroupByAggregate : "YEAR(`ob_tgl_real_kirim`)";
	}
	public function setSqlGroupByAggregate($v)
	{
		$this->_sqlGroupByAggregate = $v;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = '';
		return $rs;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		global $DashboardReport;
		return "";
	}

	// Lookup data from table
	public function lookup()
	{
		global $Security, $RequestSecurity, $PROJECT_ID, $RELATED_PROJECT_ID;
		$projectId = $RELATED_PROJECT_ID;

		// Check token first
		$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($projectId . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($projectId . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));

		// Create lookup object and output JSON
		$lookup = new ReportLookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if (Post("keys") !== NULL) { // Selected records from modal
			$keys = Post("keys");
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Page Selecting event
	function Page_Selecting(&$filter) {

		// Enter your code here
	}

	// Page Breaking event
	function Page_Breaking(&$break, &$content) {

		// Example:
		//$break = FALSE; // Skip page break, or
		//$content = "<div style=\"page-break-after:always;\">&nbsp;</div>"; // Modify page break content

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Cell Rendered event
	function Cell_Rendered(&$Field, $CurrentValue, &$ViewValue, &$ViewAttrs, &$CellAttrs, &$HrefValue, &$LinkAttrs) {

		//$ViewValue = "xxx";
		//$ViewAttrs["class"] = "xxx";

	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}

	// Load Filters event
	function Page_FilterLoad() {

		// Enter your code here
		// Example: Register/Unregister Custom Extended Filter
		//RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A', PROJECT_NAMESPACE . 'GetStartsWithAFilter'); // With function, or
		//RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A'); // No function, use Page_Filtering event
		//UnregisterFilter($this-><Field>, 'StartsWithA');

	}

	// Page Filter Validated event
	function Page_FilterValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Page Filtering event
	function Page_Filtering(&$fld, &$filter, $typ, $opr = "", $val = "", $cond = "", $opr2 = "", $val2 = "") {

		// Note: ALWAYS CHECK THE FILTER TYPE ($typ)! Example:
		//if ($typ == "dropdown" && $fld->Name == "MyField") // Dropdown filter
		//	$filter = "..."; // Modify the filter
		//if ($typ == "extended" && $fld->Name == "MyField") // Extended filter
		//	$filter = "..."; // Modify the filter
		//if ($typ == "popup" && $fld->Name == "MyField") // Popup filter
		//	$filter = "..."; // Modify the filter
		//if ($typ == "custom" && $opr == "..." && $fld->Name == "MyField") // Custom filter, $opr is the custom filter ID
		//	$filter = "..."; // Modify the filter

	}

	// Email Sending event
	function Email_Sending(&$email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		// Enter your code here
	}
}
?>