<?php
namespace PHPMaker2019\co;

/**
 * Page class (luasview_rpt)
 */
class luasview_rpt extends luasview_base
{

	// Page ID
	public $PageID = 'rpt';

	// Project ID
	public $ProjectID = "{FAF953E4-B026-4CC4-8D1E-0CFAFEB15236}";

	// Page object name
	public $PageObjName = 'luasview_rpt';
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Page headings
	public $Heading = '';
	public $Subheading = '';
	public $PageHeader;
	public $PageFooter;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportPdfUrl;
	public $ExportEmailUrl;

	// CSS
	public $ReportTableClass = "";
	public $ReportTableStyle = "";

	// Custom export
	public $ExportPrintCustom = FALSE;
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Page heading
	public function pageHeading()
	{
		global $ReportLanguage;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $ReportLanguage;
		if ($this->Subheading <> "")
			return $this->Subheading;
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$pageUrl = CurrentPageName() . "?";
		if ($this->UseTokenInUrl) $pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return @$_SESSION[SESSION_MESSAGE];
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($_SESSION[SESSION_MESSAGE], $v);
	}

	// Get failure message
	public function getFailureMessage()
	{
		return @$_SESSION[SESSION_FAILURE_MESSAGE];
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($_SESSION[SESSION_FAILURE_MESSAGE], $v);
	}

	// Get success message
	public function getSuccessMessage()
	{
		return @$_SESSION[SESSION_SUCCESS_MESSAGE];
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($_SESSION[SESSION_SUCCESS_MESSAGE], $v);
	}

	// Get warning message
	public function getWarningMessage()
	{
		return @$_SESSION[SESSION_WARNING_MESSAGE];
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($_SESSION[SESSION_WARNING_MESSAGE], $v);
	}

	// Clear message
	public function clearMessage()
	{
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$_SESSION[SESSION_MESSAGE] = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") // Fotoer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
	}

	// Validate page request
	public function isPageRequest()
	{
		if ($this->UseTokenInUrl) {
			if (IsPost())
				return ($this->TableVar == Post("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $ReportLanguage, $DashboardReport;
		global $UserTable, $UserTableConn;

		// Initialize
		if (!$DashboardReport)
			$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		$ReportLanguage = new ReportLanguage();
		if ($Language === NULL)
			$Language = $ReportLanguage;

		// Parent constuctor
		parent::__construct();

		// Table object (luasview_base)
		if (!isset($GLOBALS["luasview_base"])) {
			$GLOBALS["luasview_base"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["luasview_base"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportEmailUrl = $this->pageUrl() . "export=email";

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'rpt');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'luasview');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees_base)
		if (!isset($UserTable)) {
			$UserTable = new employees_base();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Search options
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fluasviewrpt";

		// Generate report options
		$this->GenerateOptions = new ListOptions();
		$this->GenerateOptions->Tag = "div";
		$this->GenerateOptions->TagClassName = "ew-generate-option";
	}

	// Get export HTML tag
	public function getExportTag($type, $custom = FALSE)
	{
		global $ReportLanguage;
		$exportId = session_id();
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportExcelUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("ExportToExcel") . "</a>";
			else
				return "<a class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportWordUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("ExportToWord") . "</a>";
			else
				return "<a class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "print")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportPrintUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("PrinterFriendly") . "</a>";
			else
				return "<a class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly"), TRUE) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->phrase("PrinterFriendly") . "</a>";
		} elseif (SameText($type, "pdf")) {
			return "<a class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "email")) {
			return "<a class=\"ew-export-link ew-email\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToEmail", TRUE)) . "\" id=\"emf_luasview\" href=\"#\" onclick=\"ew.emailDialogShow({ lnk: 'emf_luasview', hdr: ew.language.phrase('ExportToEmail'), url: '$this->ExportEmailUrl', exportid: '$exportId', el: this }); return false;\">" . $ReportLanguage->phrase("ExportToEmail") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Security, $ReportLanguage, $ReportOptions;
		$exportId = session_id();
		$reportTypes = [];

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;
		$reportTypes["print"] = $item->Visible ? $ReportLanguage->phrase("ReportFormPrint") : "";

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;
		$reportTypes["excel"] = $item->Visible ? $ReportLanguage->phrase("ReportFormExcel") : "";

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = TRUE;
		$reportTypes["word"] = $item->Visible ? $ReportLanguage->phrase("ReportFormWord") : "";

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;
		$item->Visible = TRUE;
		$reportTypes["pdf"] = $item->Visible ? $ReportLanguage->phrase("ReportFormPdf") : "";

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;
		$reportTypes["email"] = $item->Visible ? $ReportLanguage->phrase("ReportFormEmail") : "";

		// Report types
		$ReportOptions["ReportTypes"] = $reportTypes;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fluasviewrpt\" href=\"#\">" . $ReportLanguage->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fluasviewrpt\" href=\"#\">" . $ReportLanguage->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up export options (extended)
		$this->setupExportOptionsExt();

		// Hide options for export
		if ($this->isExport()) {
			$this->ExportOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}

		// Set up table class
		if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf"))
			$this->ReportTableClass = "ew-table";
		else
			$this->ReportTableClass = "table ew-table";
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $ReportLanguage;

		// Filter panel button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = $this->FilterApplied ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $ReportLanguage->phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fluasviewrpt\">" . $ReportLanguage->phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Reset filter
		$item = &$this->SearchOptions->add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlEncode($ReportLanguage->phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . CurrentPageName() . "?cmd=reset'\">" . $ReportLanguage->phrase("ResetAllFilter") . "</button>";
		$item->Visible = TRUE && $this->FilterApplied;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->isExport())
			$this->SearchOptions->hideAllOptions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ReportLanguage, $EXPORT_REPORT, $ExportFileName, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->isExport() && array_key_exists($this->Export, $EXPORT_REPORT)) {
			$content = ob_get_contents();
			if (ob_get_length())
				ob_end_clean();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $content, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$content = str_replace($divmatch[0], "", $content);
				}
			}
			$fn = $EXPORT_REPORT[$this->Export];
			$saveResponse = $this->$fn($content);
			if (ReportParam("generaterequest") === TRUE) { // Generate report request
				$this->writeGenResponse($saveResponse);
				$url = ""; // Avoid redirect
			}
		}

		// Close connection if not in dashboard
		if (!$DashboardReport)
			CloseConnections();

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			header("Location: " . $url);
		}
		if (!$DashboardReport)
			exit();
	}

	// Initialize common variables
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $FilterOptions; // Filter options

	// Recordset
	public $GroupRecordset = NULL;
	public $Recordset = NULL;
	public $DetailRecordCount = 0;

	// Paging variables
	public $RecordIndex = 0; // Record index
	public $RecordCount = 0; // Record count
	public $StartGroup = 0; // Start group
	public $StopGroup = 0; // Stop group
	public $TotalGroups = 0; // Total groups
	public $GroupCount = 0; // Group count
	public $GroupCounter = []; // Group counter
	public $DisplayGroups = 50; // Groups per page
	public $GroupRange = 10;
	public $Sort = "";
	public $Filter = "";
	public $PageFirstGroupFilter = "";
	public $UserIDFilter = "";
	public $DrillDown = FALSE;
	public $DrillDownInPanel = FALSE;
	public $DrillDownList = "";

	// Clear field for ext filter
	public $ExpiredExtendedFilter = "";
	public $PopupName = "";
	public $PopupValue = "";
	public $FilterApplied;
	public $SearchCommand = FALSE;
	public $ShowHeader;
	public $GroupColumnCount = 0;
	public $SubGroupColumnCount = 0;
	public $DetailColumnCount = 0;
	public $Counts;
	public $Columns;
	public $Values;
	public $Summaries;
	public $Minimums;
	public $Maximums;
	public $GrandCounts;
	public $GrandSummaries;
	public $GrandMinimums;
	public $GrandMaximums;
	public $TotalCount;
	public $GrandSummarySetup = FALSE;
	public $GroupIndexes;
	public $DetailRows = [];
	public $TopContentClass = "col-sm-12 ew-top";
	public $LeftContentClass = "ew-left";
	public $CenterContentClass = "col-sm-12 ew-center";
	public $RightContentClass = "ew-right";
	public $BottomContentClass = "col-sm-12 ew-bottom";

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $ExportFileName, $ReportLanguage, $Security, $UserProfile,
			$Security, $FormError, $DrillDownInPanel, $Breadcrumb, $ReportLanguage,
			$DashboardReport, $CustomExportType;
		global $ReportLanguage;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		if (!$Security->isLoggedIn()) $Security->autoLogin(); // Auto login
		$Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel($this->ProjectID . 'luasview');
		$Security->TablePermission_Loaded();
		if (!$Security->canList()) {
			$Security->saveLastUrl();
			$this->setFailureMessage(DeniedMessage()); // Set no permission
			$this->terminate(GetUrl("index.php"));
		}

		// Get export parameters
		if (ReportParam("export") !== NULL)
			$this->Export = strtolower(ReportParam("export"));
		$ExportType = $this->Export; // Get export parameter, used in header
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Setup placeholder
		// Setup export options

		$this->setupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			echo $ReportLanguage->phrase("InvalidPostRequest");
			$this->terminate();
			exit();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Pic);
		$this->setupLookupOptions($this->varietas);
		$this->setupLookupOptions($this->Provinsi);
		$this->setupLookupOptions($this->Kabupaten);
		$this->setupLookupOptions($this->Koordinator);
		$this->setupLookupOptions($this->Tahun);
		$this->setupLookupOptions($this->Bulan);

		// Set field visibility for detail fields
		$this->Pic->setVisibility();
		$this->varietas->setVisibility();
		$this->Provinsi->setVisibility();
		$this->Kabupaten->setVisibility();
		$this->Koordinator->setVisibility();
		$this->Tahun->setVisibility();
		$this->Bulan->setVisibility();
		$this->Luas->setVisibility();
		$this->Estimasi_Panen->setVisibility();
		$this->Aktual_Panen->setVisibility();
		$this->Rata_rata_Skor->setVisibility();

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$fieldCount = 12;
		$groupCount = 1;
		$this->Values = &InitArray($fieldCount, 0);
		$this->Counts = &Init2DArray($groupCount, $fieldCount, 0);
		$this->Summaries = &Init2DArray($groupCount, $fieldCount, 0);
		$this->Minimums = &Init2DArray($groupCount, $fieldCount, NULL);
		$this->Maximums = &Init2DArray($groupCount, $fieldCount, NULL);
		$this->GrandCounts = &InitArray($fieldCount, 0);
		$this->GrandSummaries = &InitArray($fieldCount, 0);
		$this->GrandMinimums = &InitArray($fieldCount, NULL);
		$this->GrandMaximums = &InitArray($fieldCount, NULL);

		// Set up array if accumulation required: [Accum, SkipNullOrZero]
		$this->Columns = [[FALSE, FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [TRUE,FALSE], [TRUE,FALSE], [TRUE,FALSE], [TRUE,FALSE]];

		// Set up groups per page dynamically
		$this->setupDisplayGroups();

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Check if search command
		$this->SearchCommand = (Get("cmd", "") == "search");

		// Load default filter values
		$this->loadDefaultFilters();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->setupPopup();

		// Load group db values if necessary
		$this->loadGroupDbValues();

		// Extended filter
		$extendedFilter = "";

		// Restore filter list
		$this->restoreFilterList();

		// Build extended filter
		$extendedFilter = $this->getExtendedFilter();
		AddFilter($this->Filter, $extendedFilter);

		// Build popup filter
		$popupFilter = $this->getPopupFilter();
		AddFilter($this->Filter, $popupFilter);

		// Check if filter applied
		$this->FilterApplied = $this->checkFilter();

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);

		// Search options
		$this->setupSearchOptions();

		// Get sort
		$this->Sort = $this->getSort();

		// Get total count
		$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
		$this->TotalGroups = $this->getRecordCount($sql);
		if ($this->DisplayGroups <= 0 || $this->DrillDown || $DashboardReport) // Display all groups
			$this->DisplayGroups = $this->TotalGroups;
		$this->StartGroup = 1;

		// Show header
		$this->ShowHeader = ($this->TotalGroups > 0);

		// Set up start position if not export all
		if ($this->ExportAll && $this->isExport())
			$this->DisplayGroups = $this->TotalGroups;
		else
			$this->setupStartGroup();

		// Set no record found message
		if ($this->TotalGroups == 0) {
			if ($Security->canList()) {
				if ($this->Filter == "0=101") {
					$this->setWarningMessage($ReportLanguage->phrase("EnterSearchCriteria"));
				} else {
					$this->setWarningMessage($ReportLanguage->phrase("NoRecord"));
				}
			} else {
				$this->setWarningMessage(DeniedMessage());
			}
		}

		// Hide export options if export/dashboard report
		if ($this->isExport() || $DashboardReport)
			$this->ExportOptions->hideAllOptions();

		// Hide search/filter options if export/drilldown/dashboard report
		if ($this->isExport() || $this->DrillDown || $DashboardReport) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
			$this->GenerateOptions->hideAllOptions();
		}

		// Get current page records
		$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $this->Filter, $this->Sort);
		$this->Recordset = $this->getRecordset($sql, $this->DisplayGroups, $this->StartGroup - 1);
		$this->setupFieldCount();
	}

	// Accummulate summary
	public function accumulateSummary()
	{
		$cntx = count($this->Summaries);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Summaries[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Columns[$iy][0]) { // Accumulate required
					$valwrk = $this->Values[$iy];
					if ($valwrk === NULL) {
						if (!$this->Columns[$iy][1])
							$this->Counts[$ix][$iy]++;
					} else {
						$accum = (!$this->Columns[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Counts[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Summaries[$ix][$iy] += $valwrk;
								if ($this->Minimums[$ix][$iy] === NULL) {
									$this->Minimums[$ix][$iy] = $valwrk;
									$this->Maximums[$ix][$iy] = $valwrk;
								} else {
									if ($this->Minimums[$ix][$iy] > $valwrk)
										$this->Minimums[$ix][$iy] = $valwrk;
									if ($this->Maximums[$ix][$iy] < $valwrk)
										$this->Maximums[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Summaries);
		for ($ix = 0; $ix < $cntx; $ix++)
			$this->Counts[$ix][0]++;
	}

	// Reset level summary
	public function resetLevelSummary($lvl)
	{

		// Clear summary values
		$cntx = count($this->Summaries);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Summaries[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Counts[$ix][$iy] = 0;
				if ($this->Columns[$iy][0]) {
					$this->Summaries[$ix][$iy] = 0;
					$this->Minimums[$ix][$iy] = NULL;
					$this->Maximums[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Summaries);
		for ($ix = $lvl; $ix < $cntx; $ix++)
			$this->Counts[$ix][0] = 0;

		// Reset record count
		$this->RecordCount = 0;
	}

	// Load row values
	public function loadRowValues($firstRow = FALSE)
	{
		if (!$this->Recordset)
			return;
		if ($firstRow) { // Get first row
				$this->FirstRowData = [];
				$this->FirstRowData["Pic"] = $this->Recordset->fields('Pic');
				$this->FirstRowData["varietas"] = $this->Recordset->fields('varietas');
				$this->FirstRowData["Provinsi"] = $this->Recordset->fields('Provinsi');
				$this->FirstRowData["Kabupaten"] = $this->Recordset->fields('Kabupaten');
				$this->FirstRowData["Koordinator"] = $this->Recordset->fields('Koordinator');
				$this->FirstRowData["Tahun"] = $this->Recordset->fields('Tahun');
				$this->FirstRowData["Bulan"] = $this->Recordset->fields('Bulan');
				$this->FirstRowData["Luas"] = $this->Recordset->fields('Luas');
				$this->FirstRowData["Estimasi_Panen"] = $this->Recordset->fields('Estimasi_Panen');
				$this->FirstRowData["Aktual_Panen"] = $this->Recordset->fields('Aktual_Panen');
				$this->FirstRowData["Rata_rata_Skor"] = $this->Recordset->fields('Rata_rata_Skor');
		} else { // Get next row
			$this->Recordset->moveNext();
		}
		if (!$this->Recordset->EOF) {
			$this->Pic->setDbValue($this->Recordset->fields('Pic'));
			$this->varietas->setDbValue($this->Recordset->fields('varietas'));
			$this->Provinsi->setDbValue($this->Recordset->fields('Provinsi'));
			$this->Kabupaten->setDbValue($this->Recordset->fields('Kabupaten'));
			$this->Koordinator->setDbValue($this->Recordset->fields('Koordinator'));
			$this->Tahun->setDbValue($this->Recordset->fields('Tahun'));
			$this->Bulan->setDbValue($this->Recordset->fields('Bulan'));
			$this->Luas->setDbValue($this->Recordset->fields('Luas'));
			$this->Estimasi_Panen->setDbValue($this->Recordset->fields('Estimasi_Panen'));
			$this->Aktual_Panen->setDbValue($this->Recordset->fields('Aktual_Panen'));
			$this->Rata_rata_Skor->setDbValue($this->Recordset->fields('Rata_rata_Skor'));
			$this->Values[1] = $this->Pic->CurrentValue;
			$this->Values[2] = $this->varietas->CurrentValue;
			$this->Values[3] = $this->Provinsi->CurrentValue;
			$this->Values[4] = $this->Kabupaten->CurrentValue;
			$this->Values[5] = $this->Koordinator->CurrentValue;
			$this->Values[6] = $this->Tahun->CurrentValue;
			$this->Values[7] = $this->Bulan->CurrentValue;
			$this->Values[8] = $this->Luas->CurrentValue;
			$this->Values[9] = $this->Estimasi_Panen->CurrentValue;
			$this->Values[10] = $this->Aktual_Panen->CurrentValue;
			$this->Values[11] = $this->Rata_rata_Skor->CurrentValue;
		} else {
			$this->Pic->setDbValue("");
			$this->varietas->setDbValue("");
			$this->Provinsi->setDbValue("");
			$this->Kabupaten->setDbValue("");
			$this->Koordinator->setDbValue("");
			$this->Tahun->setDbValue("");
			$this->Bulan->setDbValue("");
			$this->Luas->setDbValue("");
			$this->Estimasi_Panen->setDbValue("");
			$this->Aktual_Panen->setDbValue("");
			$this->Rata_rata_Skor->setDbValue("");
		}
	}

	// Render row
	public function renderRow()
	{
		global $Security, $ReportLanguage, $Language;
		$conn = &$this->getConnection();
		if (!$this->GrandSummarySetup) { // Get Grand total
			$hasCount = FALSE;
			$hasSummary = FALSE;

			// Get total count from SQL directly
			$sql = BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->execute($sql);
			if ($rstot) {
				$this->TotalCount = ($rstot->recordCount() > 1) ? $rstot->recordCount() : $rstot->fields[0];
				$rstot->close();
				$hasCount = TRUE;
			} else {
				$this->TotalCount = 0;
			}

			// Get total from SQL directly
			$sql = BuildReportSql($this->getSqlSelectAggregate(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$sql = $this->getSqlAggregatePrefix() . $sql . $this->getSqlAggregateSuffix();
			$rsagg = $conn->execute($sql);
			if ($rsagg) {
				$this->GrandCounts[1] = $this->TotalCount;
				$this->GrandCounts[2] = $this->TotalCount;
				$this->GrandCounts[3] = $this->TotalCount;
				$this->GrandCounts[4] = $this->TotalCount;
				$this->GrandCounts[5] = $this->TotalCount;
				$this->GrandCounts[6] = $this->TotalCount;
				$this->GrandCounts[7] = $this->TotalCount;
				$this->GrandCounts[8] = $this->TotalCount;
				$this->GrandSummaries[8] = $rsagg->fields("sum_luas");
				$this->GrandCounts[9] = $this->TotalCount;
				$this->GrandSummaries[9] = $rsagg->fields("sum_estimasi_panen");
				$this->GrandCounts[10] = $this->TotalCount;
				$this->GrandSummaries[10] = $rsagg->fields("sum_aktual_panen");
				$this->GrandCounts[11] = $this->TotalCount;
				$this->GrandSummaries[11] = $rsagg->fields("sum_rata_rata_skor");
				$rsagg->close();
				$hasSummary = TRUE;
			}

			// Accumulate grand summary from detail records
			if (!$hasCount || !$hasSummary) {
				$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$this->Recordset = $conn->execute($sql);
				if ($this->Recordset) {
					$this->loadRowValues(TRUE);
					while (!$this->Recordset->EOF) {
						$this->accumulateGrandSummary();
						$this->loadRowValues();
					}
					$this->Recordset->close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();
		if ($this->RowType == ROWTYPE_SEARCH) { // Search row
			$ar = [];
			if (is_array($this->Pic->AdvancedFilters)) {
				foreach ($this->Pic->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->Pic->DropDownList)) {
				foreach ($this->Pic->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->Pic->EditValue = $ar;
			$this->Pic->AdvancedSearch->SearchValue = is_array($this->Pic->DropDownValue) ? implode(",", $this->Pic->DropDownValue) : $this->Pic->DropDownValue;
			$ar = [];
			if (is_array($this->varietas->AdvancedFilters)) {
				foreach ($this->varietas->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->varietas->DropDownList)) {
				foreach ($this->varietas->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->varietas->EditValue = $ar;
			$this->varietas->AdvancedSearch->SearchValue = is_array($this->varietas->DropDownValue) ? implode(",", $this->varietas->DropDownValue) : $this->varietas->DropDownValue;
			$ar = [];
			if (is_array($this->Provinsi->AdvancedFilters)) {
				foreach ($this->Provinsi->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->Provinsi->DropDownList)) {
				foreach ($this->Provinsi->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->Provinsi->EditValue = $ar;
			$this->Provinsi->AdvancedSearch->SearchValue = is_array($this->Provinsi->DropDownValue) ? implode(",", $this->Provinsi->DropDownValue) : $this->Provinsi->DropDownValue;
			$ar = [];
			if (is_array($this->Kabupaten->AdvancedFilters)) {
				foreach ($this->Kabupaten->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->Kabupaten->DropDownList)) {
				foreach ($this->Kabupaten->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->Kabupaten->EditValue = $ar;
			$this->Kabupaten->AdvancedSearch->SearchValue = is_array($this->Kabupaten->DropDownValue) ? implode(",", $this->Kabupaten->DropDownValue) : $this->Kabupaten->DropDownValue;
			$ar = [];
			if (is_array($this->Koordinator->AdvancedFilters)) {
				foreach ($this->Koordinator->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->Koordinator->DropDownList)) {
				foreach ($this->Koordinator->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->Koordinator->EditValue = $ar;
			$this->Koordinator->AdvancedSearch->SearchValue = is_array($this->Koordinator->DropDownValue) ? implode(",", $this->Koordinator->DropDownValue) : $this->Koordinator->DropDownValue;
			$ar = [];
			if (is_array($this->Tahun->AdvancedFilters)) {
				foreach ($this->Tahun->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->Tahun->DropDownList)) {
				foreach ($this->Tahun->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->Tahun->EditValue = $ar;
			$this->Tahun->AdvancedSearch->SearchValue = is_array($this->Tahun->DropDownValue) ? implode(",", $this->Tahun->DropDownValue) : $this->Tahun->DropDownValue;
			$ar = [];
			if (is_array($this->Bulan->AdvancedFilters)) {
				foreach ($this->Bulan->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->Bulan->DropDownList)) {
				foreach ($this->Bulan->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->Bulan->EditValue = $ar;
			$this->Bulan->AdvancedSearch->SearchValue = is_array($this->Bulan->DropDownValue) ? implode(",", $this->Bulan->DropDownValue) : $this->Bulan->DropDownValue;
		} elseif ($this->RowType == ROWTYPE_TOTAL && !($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER)) { // Summary row
			PrependClass($this->RowAttrs["class"], ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class

			// Luas
			$this->Luas->SumViewValue = $this->Luas->SumValue;
			$this->Luas->SumViewValue = FormatNumber($this->Luas->SumViewValue, 0, -2, -2, 0);
			$this->Luas->CellAttrs["class"] = "text-right";
			$this->Luas->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// Estimasi_Panen
			$this->Estimasi_Panen->SumViewValue = $this->Estimasi_Panen->SumValue;
			$this->Estimasi_Panen->SumViewValue = FormatNumber($this->Estimasi_Panen->SumViewValue, 0, -2, -2, -1);
			$this->Estimasi_Panen->CellAttrs["class"] = "text-right";
			$this->Estimasi_Panen->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// Aktual_Panen
			$this->Aktual_Panen->SumViewValue = $this->Aktual_Panen->SumValue;
			$this->Aktual_Panen->SumViewValue = FormatNumber($this->Aktual_Panen->SumViewValue, 0, -2, -2, -1);
			$this->Aktual_Panen->CellAttrs["class"] = "text-right";
			$this->Aktual_Panen->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// Rata_rata_Skor
			$this->Rata_rata_Skor->AvgViewValue = $this->Rata_rata_Skor->AvgValue;
			$this->Rata_rata_Skor->AvgViewValue = FormatNumber($this->Rata_rata_Skor->AvgViewValue, -2, -2, -2, -2);
			$this->Rata_rata_Skor->CellAttrs["class"] = "text-right";
			$this->Rata_rata_Skor->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// Pic
			$this->Pic->HrefValue = "";

			// varietas
			$this->varietas->HrefValue = "";

			// Provinsi
			$this->Provinsi->HrefValue = "";

			// Kabupaten
			$this->Kabupaten->HrefValue = "";

			// Koordinator
			$this->Koordinator->HrefValue = "";

			// Tahun
			$this->Tahun->HrefValue = "";

			// Bulan
			$this->Bulan->HrefValue = "";

			// Luas
			$this->Luas->HrefValue = "";

			// Estimasi_Panen
			$this->Estimasi_Panen->HrefValue = "";

			// Aktual_Panen
			$this->Aktual_Panen->HrefValue = "";

			// Rata_rata_Skor
			$this->Rata_rata_Skor->HrefValue = "";
		} else {
			if ($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER) {
			} else {
			}

			// Pic
			$this->Pic->ViewValue = $this->Pic->CurrentValue;
			$this->Pic->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// varietas
			$this->varietas->ViewValue = $this->varietas->CurrentValue;
			$this->varietas->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Provinsi
			$this->Provinsi->ViewValue = $this->Provinsi->CurrentValue;
			$this->Provinsi->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Kabupaten
			$this->Kabupaten->ViewValue = $this->Kabupaten->CurrentValue;
			$this->Kabupaten->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Koordinator
			$this->Koordinator->ViewValue = $this->Koordinator->CurrentValue;
			$this->Koordinator->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Tahun
			$this->Tahun->ViewValue = $this->Tahun->CurrentValue;
			$this->Tahun->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Bulan
			$this->Bulan->ViewValue = $this->Bulan->CurrentValue;
			$this->Bulan->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Luas
			$this->Luas->ViewValue = $this->Luas->CurrentValue;
			$this->Luas->ViewValue = FormatNumber($this->Luas->ViewValue, 0, -2, -2, 0);
			$this->Luas->CellAttrs["class"] = "text-right " . ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Estimasi_Panen
			$this->Estimasi_Panen->ViewValue = $this->Estimasi_Panen->CurrentValue;
			$this->Estimasi_Panen->ViewValue = FormatNumber($this->Estimasi_Panen->ViewValue, 0, -2, -2, -1);
			$this->Estimasi_Panen->CellAttrs["class"] = "text-right " . ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Aktual_Panen
			$this->Aktual_Panen->ViewValue = $this->Aktual_Panen->CurrentValue;
			$this->Aktual_Panen->ViewValue = FormatNumber($this->Aktual_Panen->ViewValue, 0, -2, -2, -1);
			$this->Aktual_Panen->CellAttrs["class"] = "text-right " . ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Rata_rata_Skor
			$this->Rata_rata_Skor->ViewValue = $this->Rata_rata_Skor->CurrentValue;
			$this->Rata_rata_Skor->ViewValue = FormatNumber($this->Rata_rata_Skor->ViewValue, -2, -2, -2, -2);
			$this->Rata_rata_Skor->CellAttrs["class"] = "text-right " . ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Pic
			$this->Pic->HrefValue = "";

			// varietas
			$this->varietas->HrefValue = "";

			// Provinsi
			$this->Provinsi->HrefValue = "";

			// Kabupaten
			$this->Kabupaten->HrefValue = "";

			// Koordinator
			$this->Koordinator->HrefValue = "";

			// Tahun
			$this->Tahun->HrefValue = "";

			// Bulan
			$this->Bulan->HrefValue = "";

			// Luas
			$this->Luas->HrefValue = "";

			// Estimasi_Panen
			$this->Estimasi_Panen->HrefValue = "";

			// Aktual_Panen
			$this->Aktual_Panen->HrefValue = "";

			// Rata_rata_Skor
			$this->Rata_rata_Skor->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == ROWTYPE_TOTAL) { // Summary row

			// Luas
			$currentValue = $this->Luas->SumValue;
			$viewValue = &$this->Luas->SumViewValue;
			$viewAttrs = &$this->Luas->ViewAttrs;
			$cellAttrs = &$this->Luas->CellAttrs;
			$hrefValue = &$this->Luas->HrefValue;
			$linkAttrs = &$this->Luas->LinkAttrs;
			$this->Cell_Rendered($this->Luas, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Estimasi_Panen
			$currentValue = $this->Estimasi_Panen->SumValue;
			$viewValue = &$this->Estimasi_Panen->SumViewValue;
			$viewAttrs = &$this->Estimasi_Panen->ViewAttrs;
			$cellAttrs = &$this->Estimasi_Panen->CellAttrs;
			$hrefValue = &$this->Estimasi_Panen->HrefValue;
			$linkAttrs = &$this->Estimasi_Panen->LinkAttrs;
			$this->Cell_Rendered($this->Estimasi_Panen, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Aktual_Panen
			$currentValue = $this->Aktual_Panen->SumValue;
			$viewValue = &$this->Aktual_Panen->SumViewValue;
			$viewAttrs = &$this->Aktual_Panen->ViewAttrs;
			$cellAttrs = &$this->Aktual_Panen->CellAttrs;
			$hrefValue = &$this->Aktual_Panen->HrefValue;
			$linkAttrs = &$this->Aktual_Panen->LinkAttrs;
			$this->Cell_Rendered($this->Aktual_Panen, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Rata_rata_Skor
			$currentValue = $this->Rata_rata_Skor->AvgValue;
			$viewValue = &$this->Rata_rata_Skor->AvgViewValue;
			$viewAttrs = &$this->Rata_rata_Skor->ViewAttrs;
			$cellAttrs = &$this->Rata_rata_Skor->CellAttrs;
			$hrefValue = &$this->Rata_rata_Skor->HrefValue;
			$linkAttrs = &$this->Rata_rata_Skor->LinkAttrs;
			$this->Cell_Rendered($this->Rata_rata_Skor, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
		} else {

			// Pic
			$currentValue = $this->Pic->CurrentValue;
			$viewValue = &$this->Pic->ViewValue;
			$viewAttrs = &$this->Pic->ViewAttrs;
			$cellAttrs = &$this->Pic->CellAttrs;
			$hrefValue = &$this->Pic->HrefValue;
			$linkAttrs = &$this->Pic->LinkAttrs;
			$this->Cell_Rendered($this->Pic, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// varietas
			$currentValue = $this->varietas->CurrentValue;
			$viewValue = &$this->varietas->ViewValue;
			$viewAttrs = &$this->varietas->ViewAttrs;
			$cellAttrs = &$this->varietas->CellAttrs;
			$hrefValue = &$this->varietas->HrefValue;
			$linkAttrs = &$this->varietas->LinkAttrs;
			$this->Cell_Rendered($this->varietas, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Provinsi
			$currentValue = $this->Provinsi->CurrentValue;
			$viewValue = &$this->Provinsi->ViewValue;
			$viewAttrs = &$this->Provinsi->ViewAttrs;
			$cellAttrs = &$this->Provinsi->CellAttrs;
			$hrefValue = &$this->Provinsi->HrefValue;
			$linkAttrs = &$this->Provinsi->LinkAttrs;
			$this->Cell_Rendered($this->Provinsi, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Kabupaten
			$currentValue = $this->Kabupaten->CurrentValue;
			$viewValue = &$this->Kabupaten->ViewValue;
			$viewAttrs = &$this->Kabupaten->ViewAttrs;
			$cellAttrs = &$this->Kabupaten->CellAttrs;
			$hrefValue = &$this->Kabupaten->HrefValue;
			$linkAttrs = &$this->Kabupaten->LinkAttrs;
			$this->Cell_Rendered($this->Kabupaten, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Koordinator
			$currentValue = $this->Koordinator->CurrentValue;
			$viewValue = &$this->Koordinator->ViewValue;
			$viewAttrs = &$this->Koordinator->ViewAttrs;
			$cellAttrs = &$this->Koordinator->CellAttrs;
			$hrefValue = &$this->Koordinator->HrefValue;
			$linkAttrs = &$this->Koordinator->LinkAttrs;
			$this->Cell_Rendered($this->Koordinator, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Tahun
			$currentValue = $this->Tahun->CurrentValue;
			$viewValue = &$this->Tahun->ViewValue;
			$viewAttrs = &$this->Tahun->ViewAttrs;
			$cellAttrs = &$this->Tahun->CellAttrs;
			$hrefValue = &$this->Tahun->HrefValue;
			$linkAttrs = &$this->Tahun->LinkAttrs;
			$this->Cell_Rendered($this->Tahun, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Bulan
			$currentValue = $this->Bulan->CurrentValue;
			$viewValue = &$this->Bulan->ViewValue;
			$viewAttrs = &$this->Bulan->ViewAttrs;
			$cellAttrs = &$this->Bulan->CellAttrs;
			$hrefValue = &$this->Bulan->HrefValue;
			$linkAttrs = &$this->Bulan->LinkAttrs;
			$this->Cell_Rendered($this->Bulan, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Luas
			$currentValue = $this->Luas->CurrentValue;
			$viewValue = &$this->Luas->ViewValue;
			$viewAttrs = &$this->Luas->ViewAttrs;
			$cellAttrs = &$this->Luas->CellAttrs;
			$hrefValue = &$this->Luas->HrefValue;
			$linkAttrs = &$this->Luas->LinkAttrs;
			$this->Cell_Rendered($this->Luas, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Estimasi_Panen
			$currentValue = $this->Estimasi_Panen->CurrentValue;
			$viewValue = &$this->Estimasi_Panen->ViewValue;
			$viewAttrs = &$this->Estimasi_Panen->ViewAttrs;
			$cellAttrs = &$this->Estimasi_Panen->CellAttrs;
			$hrefValue = &$this->Estimasi_Panen->HrefValue;
			$linkAttrs = &$this->Estimasi_Panen->LinkAttrs;
			$this->Cell_Rendered($this->Estimasi_Panen, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Aktual_Panen
			$currentValue = $this->Aktual_Panen->CurrentValue;
			$viewValue = &$this->Aktual_Panen->ViewValue;
			$viewAttrs = &$this->Aktual_Panen->ViewAttrs;
			$cellAttrs = &$this->Aktual_Panen->CellAttrs;
			$hrefValue = &$this->Aktual_Panen->HrefValue;
			$linkAttrs = &$this->Aktual_Panen->LinkAttrs;
			$this->Cell_Rendered($this->Aktual_Panen, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Rata_rata_Skor
			$currentValue = $this->Rata_rata_Skor->CurrentValue;
			$viewValue = &$this->Rata_rata_Skor->ViewValue;
			$viewAttrs = &$this->Rata_rata_Skor->ViewAttrs;
			$cellAttrs = &$this->Rata_rata_Skor->CellAttrs;
			$hrefValue = &$this->Rata_rata_Skor->HrefValue;
			$linkAttrs = &$this->Rata_rata_Skor->LinkAttrs;
			$this->Cell_Rendered($this->Rata_rata_Skor, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->setupFieldCount();
	}

	// Accummulate grand summary
	protected function accumulateGrandSummary()
	{
		$this->TotalCount++;
		$cntgs = count($this->GrandSummaries);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Columns[$iy][0]) {
				$valwrk = $this->Values[$iy];
				if ($valwrk === NULL || !is_numeric($valwrk)) {
					if (!$this->Columns[$iy][1])
						$this->GrandCounts[$iy]++;
				} else {
					if (!$this->Columns[$iy][1] || $valwrk <> 0) {
						$this->GrandCounts[$iy]++;
						$this->GrandSummaries[$iy] += $valwrk;
						if ($this->GrandMinimums[$iy] === NULL) {
							$this->GrandMinimums[$iy] = $valwrk;
							$this->GrandMaximums[$iy] = $valwrk;
						} else {
							if ($this->GrandMinimums[$iy] > $valwrk)
								$this->GrandMinimums[$iy] = $valwrk;
							if ($this->GrandMaximums[$iy] < $valwrk)
								$this->GrandMaximums[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Load group db values if necessary
	protected function loadGroupDbValues()
	{
		$conn = &$this->getConnection();
	}

	// Set up popup
	protected function setupPopup()
	{
		global $ReportLanguage;
		$conn = &$this->getConnection();
		if ($this->DrillDown)
			return;

		// Process post back form
		if (IsPost()) {
			$name = Post("popup", ""); // Get popup form name
			if ($name <> "") {
				$arValues = Post("sel_$name");
				$cntValues = is_array($arValues) ? count($arValues) : 0;
				if ($cntValues > 0) {
					if (trim($arValues[0]) == "") // Select all
						$arValues = INIT_VALUE;
					$this->PopupName = $name;
					if (IsAdvancedFilterValue($arValues) || $arValues == INIT_VALUE)
						$this->PopupValue = $arValues;
					if (!MatchedArray($arValues, @$_SESSION["sel_$name"])) {
						if ($this->hasSessionFilterValues($name))
							$this->ExpiredExtendedFilter = $name; // Clear extended filter for this field
					}
					$_SESSION["sel_$name"] = $arValues;
					$_SESSION["rf_$name"] = Post("rf_$name", "");
					$_SESSION["rt_$name"] = Post("rt_$name", "");
					$this->resetPager();
				}
			}

		// Get 'reset' command
		} elseif (Get("cmd") !== NULL) {
			$cmd = Get("cmd");
			if (SameText($cmd, "reset")) {
				$this->resetPager();
			}
		}

		// Load selection criteria to array
	}

	// Setup field count
	protected function setupFieldCount()
	{
		$this->GroupColumnCount = 0;
		$this->SubGroupColumnCount = 0;
		$this->DetailColumnCount = 0;
		if ($this->Pic->Visible)
			$this->DetailColumnCount += 1;
		if ($this->varietas->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Provinsi->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Kabupaten->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Koordinator->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Tahun->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Bulan->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Luas->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Estimasi_Panen->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Aktual_Panen->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Rata_rata_Skor->Visible)
			$this->DetailColumnCount += 1;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/") + 1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', "", $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("rpt", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Set up export options (extended)
	protected function setupExportOptionsExt()
	{
		global $ReportLanguage, $ReportOptions;
		$reportTypes = $ReportOptions["ReportTypes"];
		$item = &$this->ExportOptions->getItem("pdf");
		$item->Visible = TRUE;
		if ($item->Visible)
			$reportTypes["pdf"] = $ReportLanguage->phrase("ReportFormPdf");
		$item->Body = "<a class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportPdfUrl . "', '" . session_id() . "');\">" . $ReportLanguage->phrase("ExportToPDF") . "</a>";
		$ReportOptions["ReportTypes"] = $reportTypes;
	}

	// Export to HTML
	public function exportHtml($html)
	{

		//global $ExportFileName;
		//header('Content-Type: text/html' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
		//header('Content-Disposition: attachment; filename=' . $ExportFileName . '.html');

		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";

		// Save generate file for print
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
			$baseTag = "<base href=\"" . BaseUrl() . "\">";
			$html = preg_replace('/<head>/', '<head>' . $baseTag, $html);
			SaveFile($folder, $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file")
			Write($html);
		return $saveToFile;
	}

	// Export to Word
	public function exportWord($html)
	{
		global $ExportFileName;
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	SaveFile(ServerMapPath($folder), $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			AddHeader('Content-Type', 'application/vnd.ms-word' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
			AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.doc');
			Write($html);
		}
		return $saveToFile;
	}

	// Export to Excel
	public function exportExcel($html)
	{
		global $ExportFileName;
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	SaveFile(ServerMapPath($folder), $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			AddHeader('Content-Type', 'application/vnd.ms-excel' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
			AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.xls');
			Write($html);
		}
		return $saveToFile;
	}

	// Export PDF
	public function exportPdf($html)
	{
		global $ExportFileName, $PDF_MEMORY_LIMIT, $PDF_TIME_LIMIT, $PDF_IMAGE_SCALE_FACTOR;
		@ini_set("memory_limit", $PDF_MEMORY_LIMIT);
		set_time_limit($PDF_TIME_LIMIT);
		$html = CheckHtml($html);
		if (DEBUG_ENABLED) // Add debug message
			$html = str_replace("</body>", GetDebugMessage() . "</body>", $html);
		$dompdf = new \Dompdf\Dompdf(["pdf_backend" => "Cpdf"]);
		$doc = new \DOMDocument("1.0", "utf-8");
		@$doc->loadHTML('<?xml encoding="uft-8">' . ConvertToUtf8($html)); // Convert to utf-8
		$spans = $doc->getElementsByTagName("span");
		foreach ($spans as $span) {
			$classNames = $span->getAttribute("class");
			if ($classNames == "ew-filter-caption") // Insert colon
				$span->parentNode->insertBefore($doc->createElement("span", ":&nbsp;"), $span->nextSibling);
			elseif (preg_match('/\bicon\-\w+\b/', $classNames)) // Remove icons
				$span->parentNode->removeChild($span);
		}
		$images = $doc->getElementsByTagName("img");
		$pageSize = "a4";
		$pageOrientation = "portrait";
		$this->ExportPageOrientation = $pageOrientation;
		$portrait = SameText($pageOrientation, "portrait");
		foreach ($images as $image) {
			$imagefn = $image->getAttribute("src");
			if (file_exists($imagefn)) {
				$imagefn = realpath($imagefn);
				$size = getimagesize($imagefn); // Get image size
				if ($size[0] <> 0) {
					if (SameText($pageSize, "letter")) { // Letter paper (8.5 in. by 11 in.)
						$w = $portrait ? 216 : 279;
					} elseif (SameText($pageSize, "legal")) { // Legal paper (8.5 in. by 14 in.)
						$w = $portrait ? 216 : 356;
					} else {
						$w = $portrait ? 210 : 297; // A4 paper (210 mm by 297 mm)
					}
					$w = min($size[0], ($w - 20 * 2) / 25.4 * 72 * $PDF_IMAGE_SCALE_FACTOR); // Resize image, adjust the scale factor if necessary
					$h = $w / $size[0] * $size[1];
					$image->setAttribute("width", $w);
					$image->setAttribute("height", $h);
				}
			}
		}
		$html = $doc->saveHTML();
		$html = ConvertFromUtf8($html);
		$dompdf->load_html($html);
		$dompdf->set_paper($pageSize, $pageOrientation);
		$dompdf->render();
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
			SaveFile(ServerMapPath($folder), $fileName, $dompdf->output());
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			$exportFile = EndsText(".pdf", $ExportFileName) ? $ExportFileName : $ExportFileName . ".pdf";
			$dompdf->stream($exportFile, ["Attachment" => 1]); // 0 to open in browser, 1 to download
		}
		DeleteTempImages($html);
		return $saveToFile;
	}

	// Set up starting group
	protected function setupStartGroup()
	{

		// Exit if no groups
		if ($this->DisplayGroups == 0)
			return;
		$startGrp = ReportParam(TABLE_START_GROUP, "");
		$pageNo = ReportParam("pageno", "");

		// Check for a 'start' parameter
		if ($startGrp != "") {
			$this->StartGroup = $startGrp;
			$this->setStartGroup($this->StartGroup);
		} elseif ($pageNo != "") {
			if (is_numeric($pageNo)) {
				$this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
				if ($this->StartGroup <= 0) {
					$this->StartGroup = 1;
				} elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
					$this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
				}
				$this->setStartGroup($this->StartGroup);
			} else {
				$this->StartGroup = $this->getStartGroup();
			}
		} else {
			$this->StartGroup = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGroup) || $this->StartGroup == "") { // Avoid invalid start group counter
			$this->StartGroup = 1; // Reset start group counter
			$this->setStartGroup($this->StartGroup);
		} elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
			$this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
			$this->setStartGroup($this->StartGroup);
		} elseif (($this->StartGroup-1) % $this->DisplayGroups <> 0) {
			$this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
			$this->setStartGroup($this->StartGroup);
		}
	}

	// Reset pager
	protected function resetPager()
	{

		// Reset start position (reset command)
		$this->StartGroup = 1;
		$this->setStartGroup($this->StartGroup);
	}

	// Set up number of groups displayed per page
	protected function setupDisplayGroups()
	{
		if (ReportParam(TABLE_GROUP_PER_PAGE) !== NULL) {
			$wrk = ReportParam(TABLE_GROUP_PER_PAGE);
			if (is_numeric($wrk)) {
				$this->DisplayGroups = intval($wrk);
			} else {
				if (strtoupper($wrk) == "ALL") { // Display all groups
					$this->DisplayGroups = -1;
				} else {
					$this->DisplayGroups = 50; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGroups); // Save to session

			// Reset start position (reset command)
			$this->StartGroup = 1;
			$this->setStartGroup($this->StartGroup);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGroups = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGroups = 50; // Load default
			}
		}
	}

	// Get sort parameters based on sort links clicked
	protected function getSort()
	{
		if ($this->DrillDown)
			return "";
		$resetSort = ReportParam("cmd") === "resetsort";
		$orderBy = ReportParam("order", "");
		$orderType = ReportParam("ordertype", "");

		// Check for a resetsort command
		if ($resetSort) {
			$this->setOrderBy("");
			$this->setStartGroup(1);
			$this->Pic->setSort("");
			$this->varietas->setSort("");
			$this->Provinsi->setSort("");
			$this->Kabupaten->setSort("");
			$this->Koordinator->setSort("");
			$this->Tahun->setSort("");
			$this->Bulan->setSort("");
			$this->Luas->setSort("");
			$this->Estimasi_Panen->setSort("");
			$this->Aktual_Panen->setSort("");
			$this->Rata_rata_Skor->setSort("");

		// Check for an Order parameter
		} elseif ($orderBy <> "") {
			$this->CurrentOrder = $orderBy;
			$this->CurrentOrderType = $orderType;
			$sortSql = $this->sortSql();
			$this->setOrderBy($sortSql);
			$this->setStartGroup(1);
		}
		return $this->getOrderBy();
	}

	// Return extended filter
	protected function getExtendedFilter()
	{
		global $FormError;
		$filter = "";
		if ($this->DrillDown)
			return "";
		$postBack = IsPost();
		$restoreSession = TRUE;
		$setupFilter = FALSE;

		// Reset extended filter if filter changed
		if ($postBack) {

		// Reset search command
		} elseif (Get("cmd", "") == "reset") {

			// Load default values
			$this->setSessionDropDownValue($this->Pic->DropDownValue, $this->Pic->AdvancedSearch->SearchOperator, "Pic"); // Field Pic
			$this->setSessionDropDownValue($this->varietas->DropDownValue, $this->varietas->AdvancedSearch->SearchOperator, "varietas"); // Field varietas
			$this->setSessionDropDownValue($this->Provinsi->DropDownValue, $this->Provinsi->AdvancedSearch->SearchOperator, "Provinsi"); // Field Provinsi
			$this->setSessionDropDownValue($this->Kabupaten->DropDownValue, $this->Kabupaten->AdvancedSearch->SearchOperator, "Kabupaten"); // Field Kabupaten
			$this->setSessionDropDownValue($this->Koordinator->DropDownValue, $this->Koordinator->AdvancedSearch->SearchOperator, "Koordinator"); // Field Koordinator
			$this->setSessionDropDownValue($this->Tahun->DropDownValue, $this->Tahun->AdvancedSearch->SearchOperator, "Tahun"); // Field Tahun
			$this->setSessionDropDownValue($this->Bulan->DropDownValue, $this->Bulan->AdvancedSearch->SearchOperator, "Bulan"); // Field Bulan

			//$setupFilter = TRUE; // No need to set up, just use default
		} else {
			$restoreSession = !$this->SearchCommand;

			// Field Pic
			if ($this->getDropDownValue($this->Pic)) {
				$setupFilter = TRUE;
			} elseif ($this->Pic->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_luasview_Pic"])) {
				$setupFilter = TRUE;
			}

			// Field varietas
			if ($this->getDropDownValue($this->varietas)) {
				$setupFilter = TRUE;
			} elseif ($this->varietas->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_luasview_varietas"])) {
				$setupFilter = TRUE;
			}

			// Field Provinsi
			if ($this->getDropDownValue($this->Provinsi)) {
				$setupFilter = TRUE;
			} elseif ($this->Provinsi->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_luasview_Provinsi"])) {
				$setupFilter = TRUE;
			}

			// Field Kabupaten
			if ($this->getDropDownValue($this->Kabupaten)) {
				$setupFilter = TRUE;
			} elseif ($this->Kabupaten->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_luasview_Kabupaten"])) {
				$setupFilter = TRUE;
			}

			// Field Koordinator
			if ($this->getDropDownValue($this->Koordinator)) {
				$setupFilter = TRUE;
			} elseif ($this->Koordinator->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_luasview_Koordinator"])) {
				$setupFilter = TRUE;
			}

			// Field Tahun
			if ($this->getDropDownValue($this->Tahun)) {
				$setupFilter = TRUE;
			} elseif ($this->Tahun->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_luasview_Tahun"])) {
				$setupFilter = TRUE;
			}

			// Field Bulan
			if ($this->getDropDownValue($this->Bulan)) {
				$setupFilter = TRUE;
			} elseif ($this->Bulan->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_luasview_Bulan"])) {
				$setupFilter = TRUE;
			}
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				return $filter;
			}
		}

		// Restore session
		if ($restoreSession) {
			$this->getSessionDropDownValue($this->Pic); // Field Pic
			$this->getSessionDropDownValue($this->varietas); // Field varietas
			$this->getSessionDropDownValue($this->Provinsi); // Field Provinsi
			$this->getSessionDropDownValue($this->Kabupaten); // Field Kabupaten
			$this->getSessionDropDownValue($this->Koordinator); // Field Koordinator
			$this->getSessionDropDownValue($this->Tahun); // Field Tahun
			$this->getSessionDropDownValue($this->Bulan); // Field Bulan
		}

		// Call page filter validated event
		$this->Page_FilterValidated();

		// Build SQL
		$this->buildDropDownFilter($this->Pic, $filter, $this->Pic->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field Pic
		$this->buildDropDownFilter($this->varietas, $filter, $this->varietas->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field varietas
		$this->buildDropDownFilter($this->Provinsi, $filter, $this->Provinsi->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field Provinsi
		$this->buildDropDownFilter($this->Kabupaten, $filter, $this->Kabupaten->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field Kabupaten
		$this->buildDropDownFilter($this->Koordinator, $filter, $this->Koordinator->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field Koordinator
		$this->buildDropDownFilter($this->Tahun, $filter, $this->Tahun->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field Tahun
		$this->buildDropDownFilter($this->Bulan, $filter, $this->Bulan->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field Bulan

		// Save parms to session
		$this->setSessionDropDownValue($this->Pic->DropDownValue, $this->Pic->AdvancedSearch->SearchOperator, "Pic"); // Field Pic
		$this->setSessionDropDownValue($this->varietas->DropDownValue, $this->varietas->AdvancedSearch->SearchOperator, "varietas"); // Field varietas
		$this->setSessionDropDownValue($this->Provinsi->DropDownValue, $this->Provinsi->AdvancedSearch->SearchOperator, "Provinsi"); // Field Provinsi
		$this->setSessionDropDownValue($this->Kabupaten->DropDownValue, $this->Kabupaten->AdvancedSearch->SearchOperator, "Kabupaten"); // Field Kabupaten
		$this->setSessionDropDownValue($this->Koordinator->DropDownValue, $this->Koordinator->AdvancedSearch->SearchOperator, "Koordinator"); // Field Koordinator
		$this->setSessionDropDownValue($this->Tahun->DropDownValue, $this->Tahun->AdvancedSearch->SearchOperator, "Tahun"); // Field Tahun
		$this->setSessionDropDownValue($this->Bulan->DropDownValue, $this->Bulan->AdvancedSearch->SearchOperator, "Bulan"); // Field Bulan

		// Setup filter
		if ($setupFilter) {
		}

		// Field Pic
		LoadDropDownList($this->Pic->DropDownList, $this->Pic->DropDownValue);

		// Field varietas
		LoadDropDownList($this->varietas->DropDownList, $this->varietas->DropDownValue);

		// Field Provinsi
		LoadDropDownList($this->Provinsi->DropDownList, $this->Provinsi->DropDownValue);

		// Field Kabupaten
		LoadDropDownList($this->Kabupaten->DropDownList, $this->Kabupaten->DropDownValue);

		// Field Koordinator
		LoadDropDownList($this->Koordinator->DropDownList, $this->Koordinator->DropDownValue);

		// Field Tahun
		LoadDropDownList($this->Tahun->DropDownList, $this->Tahun->DropDownValue);

		// Field Bulan
		LoadDropDownList($this->Bulan->DropDownList, $this->Bulan->DropDownValue);
		return $filter;
	}

	// Build dropdown filter
	protected function buildDropDownFilter(&$fld, &$filterClause, $fldOpr, $default = FALSE, $saveFilter = FALSE)
	{
		$fldVal = ($default) ? $fld->DefaultDropDownValue : $fld->DropDownValue;
		$sql = "";
		if (is_array($fldVal)) {
			foreach ($fldVal as $val) {
				$wrk = $this->getDropDownFilter($fld, $val, $fldOpr);

				// Call Page Filtering event
				if (!StartsString("@@", $val))
					$this->Page_Filtering($fld, $wrk, "dropdown", $fldOpr, $val);
				if ($wrk <> "") {
					if ($sql <> "")
						$sql .= " OR " . $wrk;
					else
						$sql = $wrk;
				}
			}
		} else {
			$sql = $this->getDropDownFilter($fld, $fldVal, $fldOpr);

			// Call Page Filtering event
			if (!StartsString("@@", $fldVal))
				$this->Page_Filtering($fld, $sql, "dropdown", $fldOpr, $fldVal);
		}
		if ($sql <> "") {
			AddFilter($filterClause, $sql);
			if ($saveFilter) $fld->CurrentFilter = $sql;
		}
	}

	// Get dropdown filter
	protected function getDropDownFilter(&$fld, $fldVal, $fldOpr)
	{
		$fldName = $fld->Name;
		$fldExpression = $fld->Expression;
		$fldDataType = $fld->DataType;
		$fldDelimiter = $fld->Delimiter;
		$fldVal = strval($fldVal);
		if ($fldOpr == "") $fldOpr = "=";
		$wrk = "";
		if (SameString($fldVal, NULL_VALUE)) {
			$wrk = $fldExpression . " IS NULL";
		} elseif (SameString($fldVal, NOT_NULL_VALUE)) {
			$wrk = $fldExpression . " IS NOT NULL";
		} elseif (SameString($fldVal, EMPTY_VALUE)) {
			$wrk = $fldExpression . " = ''";
		} elseif (SameString($fldVal, ALL_VALUE)) {
			$wrk = "1 = 1";
		} else {
			if (StartsString("@@", $fldVal)) {
				$wrk = $this->getCustomFilter($fld, $fldVal, $this->Dbid);
			} elseif ($fldDelimiter <> "" && trim($fldVal) <> "" && ($fldDataType == DATATYPE_STRING || $fldDataType == DATATYPE_MEMO)) {
				$wrk = GetMultiValueSearchSql($fldExpression, trim($fldVal), $this->Dbid);
			} else {
				if ($fldVal <> "" && $fldVal <> INIT_VALUE) {
					if ($fldDataType == DATATYPE_DATE && $fldOpr <> "") {
						$wrk = GetDateFilterSql($fldExpression, $fldOpr, $fldVal, $fldDataType, $this->Dbid);
					} else {
						$wrk = GetFilterSql($fldOpr, $fldVal, $fldDataType, $this->Dbid);
						if ($wrk <> "") $wrk = $fldExpression . $wrk;
					}
				}
			}
		}
		return $wrk;
	}

	// Get custom filter
	protected function getCustomFilter(&$fld, $fldVal, $dbid = 0)
	{
		$wrk = "";
		if (is_array($fld->AdvancedFilters)) {
			foreach ($fld->AdvancedFilters as $filter) {
				if ($filter->ID == $fldVal && $filter->Enabled) {
					$fldExpr = $fld->Expression;
					$fn = $filter->FunctionName;
					$wrkid = StartsString("@@", $filter->ID) ? substr($filter->ID, 2) : $filter->ID;
					if ($fn <> "") {
						$fn = PROJECT_NAMESPACE . $fn;
						$wrk = $fn($fldExpr, $dbid);
					} else
						$wrk = "";
					$this->Page_Filtering($fld, $wrk, "custom", $wrkid);
					break;
				}
			}
		}
		return $wrk;
	}

	// Build extended filter
	protected function buildExtendedFilter(&$fld, &$filterClause, $default = FALSE, $saveFilter = FALSE)
	{
		$wrk = GetExtendedFilter($fld, $default, $this->Dbid);
		if (!$default)
			$this->Page_Filtering($fld, $wrk, "extended", $fld->AdvancedSearch->SearchOperator, $fld->AdvancedSearch->SearchValue, $fld->AdvancedSearch->SearchCondition, $fld->AdvancedSearch->SearchOperator2, $fld->AdvancedSearch->SearchValue2);
		if ($wrk <> "") {
			AddFilter($filterClause, $wrk);
			if ($saveFilter) $fld->CurrentFilter = $wrk;
		}
	}

	// Get drop down value from querystring
	protected function getDropDownValue(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		if (IsPost())
			return FALSE; // Skip post back
		$opr = Get("z_$parm");
		if ($opr !== NULL)
			$fld->AdvancedSearch->SearchOperator = $opr;
		$val = Get("x_$parm");
		if ($val !== NULL) {
			if ($fld->isMultiSelect() && !is_array($val)) // Split values for modal lookup
				$fld->DropDownValue = explode(LOOKUP_FILTER_VALUE_SEPARATOR, $val);
			else
				$fld->DropDownValue = $val;
			return TRUE;
		}
		return FALSE;
	}

	// Get filter values from querystring
	protected function getFilterValues(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		if (IsPost())
			return; // Skip post back
		$got = FALSE;
		if (Get("x_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchValue = Get("x_$parm");
			$got = TRUE;
		}
		if (Get("z_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchOperator = Get("z_$parm");
			$got = TRUE;
		}
		if (Get("v_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchCondition = Get("v_$parm");
			$got = TRUE;
		}
		if (Get("y_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchValue2 = Get("y_$parm");
			$got = TRUE;
		}
		if (Get("w_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchOperator2 = Get("w_$parm");
			$got = TRUE;
		}
		return $got;
	}

	// Set default ext filter
	protected function setDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
	{
		$fld->AdvancedSearch->SearchValueDefault = $sv1; // Default ext filter value 1
		$fld->AdvancedSearch->SearchValue2Default = $sv2; // Default ext filter value 2 (if operator 2 is enabled)
		$fld->AdvancedSearch->SearchOperatorDefault = $so1; // Default search operator 1
		$fld->AdvancedSearch->SearchOperator2Default = $so2; // Default search operator 2 (if operator 2 is enabled)
		$fld->AdvancedSearch->SearchConditionDefault = $sc; // Default search condition (if operator 2 is enabled)
	}

	// Apply default ext filter
	protected function applyDefaultExtFilter(&$fld)
	{
		$fld->AdvancedSearch->SearchValue = $fld->AdvancedSearch->SearchValueDefault;
		$fld->AdvancedSearch->SearchValue2 = $fld->AdvancedSearch->SearchValue2Default;
		$fld->AdvancedSearch->SearchOperator = $fld->AdvancedSearch->SearchOperatorDefault;
		$fld->AdvancedSearch->SearchOperator2 = $fld->AdvancedSearch->SearchOperator2Default;
		$fld->AdvancedSearch->SearchCondition = $fld->AdvancedSearch->SearchConditionDefault;
	}

	// Check if Text Filter applied
	protected function textFilterApplied(&$fld)
	{
		return (strval($fld->AdvancedSearch->SearchValue) <> strval($fld->AdvancedSearch->SearchValueDefault) ||
			strval($fld->AdvancedSearch->SearchValue2) <> strval($fld->AdvancedSearch->SearchValue2Default) ||
			(strval($fld->AdvancedSearch->SearchValue) <> "" &&
				strval($fld->AdvancedSearch->SearchOperator) <> strval($fld->AdvancedSearch->SearchOperatorDefault)) ||
			(strval($fld->AdvancedSearch->SearchValue2) <> "" &&
				strval($fld->AdvancedSearch->SearchOperator2) <> strval($fld->AdvancedSearch->SearchOperator2Default)) ||
			strval($fld->AdvancedSearch->SearchCondition) <> strval($fld->AdvancedSearch->SearchConditionDefault));
	}

	// Check if Non-Text Filter applied
	protected function nonTextFilterApplied(&$fld)
	{
		if (is_array($fld->DropDownValue)) {
			if (is_array($fld->DefaultDropDownValue)) {
				if (count($fld->DefaultDropDownValue) <> count($fld->DropDownValue))
					return TRUE;
				else
					return (count(array_diff($fld->DefaultDropDownValue, $fld->DropDownValue)) <> 0);
			} else {
				return TRUE;
			}
		} else {
			if (is_array($fld->DefaultDropDownValue))
				return TRUE;
			else
				$v1 = strval($fld->DefaultDropDownValue);
			if ($v1 == INIT_VALUE)
				$v1 = "";
			$v2 = strval($fld->DropDownValue);
			if ($v2 == INIT_VALUE || $v2 == ALL_VALUE)
				$v2 = "";
			return ($v1 <> $v2);
		}
	}

	// Get dropdown value from session
	protected function getSessionDropDownValue(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		$this->getSessionValue($fld->DropDownValue, 'x_luasview_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator, 'z_luasview_' . $parm);
	}

	// Get filter values from session
	protected function getSessionFilterValues(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		$this->getSessionValue($fld->AdvancedSearch->SearchValue, 'x_luasview_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator, 'z_luasview_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchCondition, 'v_luasview_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchValue2, 'y_luasview_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator2, 'w_luasview_' . $parm);
	}

	// Get value from session
	protected function getSessionValue(&$sv, $sn)
	{
		if (array_key_exists($sn, $_SESSION))
			$sv = $_SESSION[$sn];
	}

	// Set dropdown value to session
	protected function setSessionDropDownValue($sv, $so, $parm)
	{
		$_SESSION['x_luasview_' . $parm] = $sv;
		$_SESSION['z_luasview_' . $parm] = $so;
	}

	// Set filter values to session
	protected function setSessionFilterValues($sv1, $so1, $sc, $sv2, $so2, $parm)
	{
		$_SESSION['x_luasview_' . $parm] = $sv1;
		$_SESSION['z_luasview_' . $parm] = $so1;
		$_SESSION['v_luasview_' . $parm] = $sc;
		$_SESSION['y_luasview_' . $parm] = $sv2;
		$_SESSION['w_luasview_' . $parm] = $so2;
	}

	// Check if has session filter values
	protected function hasSessionFilterValues($parm)
	{
		return (@$_SESSION['x_' . $parm] <> "" && @$_SESSION['x_' . $parm] <> INIT_VALUE ||
			@$_SESSION['x_' . $parm] <> "" && @$_SESSION['x_' . $parm] <> INIT_VALUE ||
			@$_SESSION['y_' . $parm] <> "" && @$_SESSION['y_' . $parm] <> INIT_VALUE);
	}

	// Dropdown filter exist
	protected function dropDownFilterExist(&$fld, $fldOpr)
	{
		$wrk = "";
		$this->buildDropDownFilter($fld, $wrk, $fldOpr);
		return ($wrk <> "");
	}

	// Extended filter exist
	protected function extendedFilterExist(&$fld)
	{
		$extWrk = "";
		$this->buildExtendedFilter($fld, $extWrk);
		return ($extWrk <> "");
	}

	// Validate form
	protected function validateForm()
	{
		global $ReportLanguage, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			$FormError .= ($FormError <> "") ? "<p>&nbsp;</p>" : "";
			$FormError .= $formCustomError;
		}
		return $validateForm;
	}

	// Clear selection stored in session
	protected function clearSessionSelection($parm)
	{
		$_SESSION["sel_luasview_$parm"] = "";
		$_SESSION["rf_luasview_$parm"] = "";
		$_SESSION["rt_luasview_$parm"] = "";
	}

	// Load selection from session
	protected function loadSelectionFromSession($parm)
	{
		foreach ($this->fields as $fld) {
			if ($fld->Param == $parm) {
				$fld->SelectionList = @$_SESSION["sel_luasview_$parm"];
				$fld->RangeFrom = @$_SESSION["rf_luasview_$parm"];
				$fld->RangeTo = @$_SESSION["rt_luasview_$parm"];
				break;
			}
		}
	}

	// Load default value for filters
	protected function loadDefaultFilters()
	{

		/**
		* Set up default values for non Text filters
		*/
		// Field Pic

		$this->Pic->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->Pic->DropDownValue = $this->Pic->DefaultDropDownValue;

		// Field varietas
		$this->varietas->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->varietas->DropDownValue = $this->varietas->DefaultDropDownValue;

		// Field Provinsi
		$this->Provinsi->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->Provinsi->DropDownValue = $this->Provinsi->DefaultDropDownValue;

		// Field Kabupaten
		$this->Kabupaten->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->Kabupaten->DropDownValue = $this->Kabupaten->DefaultDropDownValue;

		// Field Koordinator
		$this->Koordinator->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->Koordinator->DropDownValue = $this->Koordinator->DefaultDropDownValue;

		// Field Tahun
		$this->Tahun->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->Tahun->DropDownValue = $this->Tahun->DefaultDropDownValue;

		// Field Bulan
		$this->Bulan->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->Bulan->DropDownValue = $this->Bulan->DefaultDropDownValue;

		/**
		* Set up default values for extended filters
		* function setDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
		* Parameters:
		* $fld - Field object
		* $so1 - Default search operator 1
		* $sv1 - Default ext filter value 1
		* $sc - Default search condition (if operator 2 is enabled)
		* $so2 - Default search operator 2 (if operator 2 is enabled)
		* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
		*/

		/**
		* Set up default values for popup filters
		*/
	}

	// Check if filter applied
	protected function checkFilter()
	{

		// Check Pic extended filter
		if ($this->nonTextFilterApplied($this->Pic))
			return TRUE;

		// Check varietas extended filter
		if ($this->nonTextFilterApplied($this->varietas))
			return TRUE;

		// Check Provinsi extended filter
		if ($this->nonTextFilterApplied($this->Provinsi))
			return TRUE;

		// Check Kabupaten extended filter
		if ($this->nonTextFilterApplied($this->Kabupaten))
			return TRUE;

		// Check Koordinator extended filter
		if ($this->nonTextFilterApplied($this->Koordinator))
			return TRUE;

		// Check Tahun extended filter
		if ($this->nonTextFilterApplied($this->Tahun))
			return TRUE;

		// Check Bulan extended filter
		if ($this->nonTextFilterApplied($this->Bulan))
			return TRUE;
		return FALSE;
	}

	// Show list of filters
	public function showFilterList($showDate = FALSE)
	{
		global $ReportLanguage;

		// Initialize
		$filterList = "";
		$captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
		$captionSuffix = $this->isExport("email") ? ": " : "";

		// Field Pic
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->Pic, $extWrk, $this->Pic->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Pic->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field varietas
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->varietas, $extWrk, $this->varietas->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->varietas->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field Provinsi
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->Provinsi, $extWrk, $this->Provinsi->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Provinsi->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field Kabupaten
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->Kabupaten, $extWrk, $this->Kabupaten->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Kabupaten->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field Koordinator
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->Koordinator, $extWrk, $this->Koordinator->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Koordinator->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field Tahun
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->Tahun, $extWrk, $this->Tahun->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Tahun->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field Bulan
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->Bulan, $extWrk, $this->Bulan->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Bulan->caption() . "</span>" . $captionSuffix . $filter . "</div>";
		$divdataclass = "";

		// Show Filters
		if ($filterList <> "" || $showDate) {
			$message = "<div" . $divdataclass . "><div id=\"ew-filter-list\" class=\"alert alert-info d-table\">";
			if ($showDate)
				$message .= "<div id=\"ew-current-date\">" . $ReportLanguage->phrase("ReportGeneratedDate") . FormatDateTime(date("Y-m-d H:i:s"), 1) . "</div>";
			if ($filterList <> "")
				$message .= "<div id=\"ew-current-filters\">" . $ReportLanguage->phrase("CurrentFilters") . "</div>" . $filterList;
			$message .= "</div></div>";
			$this->Message_Showing($message, "");
			Write($message);
		}
	}

	// Get list of filters
	public function getFilterList()
	{

		// Initialize
		$filterList = "";

		// Field Pic
		$wrk = "";
		$wrk = ($this->Pic->DropDownValue <> INIT_VALUE) ? $this->Pic->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_Pic\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field varietas
		$wrk = "";
		$wrk = ($this->varietas->DropDownValue <> INIT_VALUE) ? $this->varietas->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_varietas\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field Provinsi
		$wrk = "";
		$wrk = ($this->Provinsi->DropDownValue <> INIT_VALUE) ? $this->Provinsi->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_Provinsi\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field Kabupaten
		$wrk = "";
		$wrk = ($this->Kabupaten->DropDownValue <> INIT_VALUE) ? $this->Kabupaten->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_Kabupaten\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field Koordinator
		$wrk = "";
		$wrk = ($this->Koordinator->DropDownValue <> INIT_VALUE) ? $this->Koordinator->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_Koordinator\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field Tahun
		$wrk = "";
		$wrk = ($this->Tahun->DropDownValue <> INIT_VALUE) ? $this->Tahun->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_Tahun\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field Bulan
		$wrk = "";
		$wrk = ($this->Bulan->DropDownValue <> INIT_VALUE) ? $this->Bulan->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_Bulan\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Return filter list in json
		if ($filterList <> "")
			return "{\"data\":{" . $filterList . "}}";
		else
			return "null";
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd", "") <> "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter", ""), TRUE);
		return $this->setupFilterList($filter);
	}

	// Setup list of filters
	protected function setupFilterList($filter)
	{
		if (!is_array($filter))
			return FALSE;

		// Field Pic
		$restoreFilter = FALSE;
		if (array_key_exists("x_Pic", $filter)) {
			$wrk = $filter["x_Pic"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_Pic"], "Pic");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "Pic");
		}

		// Field varietas
		$restoreFilter = FALSE;
		if (array_key_exists("x_varietas", $filter)) {
			$wrk = $filter["x_varietas"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_varietas"], "varietas");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "varietas");
		}

		// Field Provinsi
		$restoreFilter = FALSE;
		if (array_key_exists("x_Provinsi", $filter)) {
			$wrk = $filter["x_Provinsi"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_Provinsi"], "Provinsi");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "Provinsi");
		}

		// Field Kabupaten
		$restoreFilter = FALSE;
		if (array_key_exists("x_Kabupaten", $filter)) {
			$wrk = $filter["x_Kabupaten"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_Kabupaten"], "Kabupaten");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "Kabupaten");
		}

		// Field Koordinator
		$restoreFilter = FALSE;
		if (array_key_exists("x_Koordinator", $filter)) {
			$wrk = $filter["x_Koordinator"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_Koordinator"], "Koordinator");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "Koordinator");
		}

		// Field Tahun
		$restoreFilter = FALSE;
		if (array_key_exists("x_Tahun", $filter)) {
			$wrk = $filter["x_Tahun"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_Tahun"], "Tahun");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "Tahun");
		}

		// Field Bulan
		$restoreFilter = FALSE;
		if (array_key_exists("x_Bulan", $filter)) {
			$wrk = $filter["x_Bulan"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_Bulan"], "Bulan");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "Bulan");
		}
		return TRUE;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Render lookup
					$this->RowType == ROWTYPE_VIEW;
					$fn = $fld->Lookup->RenderViewFunc;
					$render = method_exists($this, $fn);

					// Format the field values
					$fld->setDbValue($row[1]);
					if ($render) {
						$this->$fn();
						$row[1] = $fld->ViewValue;
						$row['df'] = $row[1];
					} elseif ($fld->isEncrypt()) {
						$row[1] = $fld->CurrentValue;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Return popup filter
	protected function getPopupFilter()
	{
		$wrk = "";
		if ($this->DrillDown)
			return "";
		return $wrk;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>