<?php
namespace PHPMaker2019\co;

/**
 * Table class for luasview
 */
class luasview_base extends ReportTable
{
	public $ShowGroupHeaderAsRow = FALSE;
	public $ShowCompactSummaryFooter = TRUE;
	public $Chart1;
	public $Chart2;
	public $Chart3;
	public $Pic;
	public $varietas;
	public $Provinsi;
	public $Kabupaten;
	public $Koordinator;
	public $Tahun;
	public $Bulan;
	public $Luas;
	public $Estimasi_Panen;
	public $Aktual_Panen;
	public $Rata_rata_Skor;

	// Constructor
	public function __construct()
	{
		global $ReportLanguage, $CurrentLanguage;

		// Language object
		if (!isset($ReportLanguage))
			$ReportLanguage = new ReportLanguage();
		$this->TableVar = 'luasview_base';
		$this->TableName = 'luasview';
		$this->TableType = 'VIEW';
		$this->TableReportType = 'rpt';
		$this->SourceTableIsCustomView = FALSE;
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0;

		// Pic
		$this->Pic = new ReportField('luasview_base', 'luasview', 'x_Pic', 'Pic', '`Pic`', 200, -1, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->Pic->Sortable = TRUE; // Allow sort
		$this->Pic->DateFilter = "";
		$this->Pic->Lookup = new ReportLookup('Pic', 'luasview_base', TRUE, 'Pic', ["Pic","","",""], [], [], [], [], [], [], '`Pic` ASC', '');
		$this->Pic->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['Pic'] = &$this->Pic;

		// varietas
		$this->varietas = new ReportField('luasview_base', 'luasview', 'x_varietas', 'varietas', '`varietas`', 200, -1, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->varietas->Sortable = TRUE; // Allow sort
		$this->varietas->DateFilter = "";
		$this->varietas->Lookup = new ReportLookup('varietas', 'luasview_base', TRUE, 'varietas', ["varietas","","",""], [], [], [], [], [], [], '`varietas` ASC', '');
		$this->varietas->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['varietas'] = &$this->varietas;

		// Provinsi
		$this->Provinsi = new ReportField('luasview_base', 'luasview', 'x_Provinsi', 'Provinsi', '`Provinsi`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Provinsi->Sortable = TRUE; // Allow sort
		$this->Provinsi->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Provinsi->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->Provinsi->DateFilter = "";
		$this->Provinsi->Lookup = new ReportLookup('Provinsi', 'luasview_base', TRUE, 'Provinsi', ["Provinsi","","",""], [], [], [], [], [], [], '`Provinsi` ASC', '');
		$this->Provinsi->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['Provinsi'] = &$this->Provinsi;

		// Kabupaten
		$this->Kabupaten = new ReportField('luasview_base', 'luasview', 'x_Kabupaten', 'Kabupaten', '`Kabupaten`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kabupaten->Sortable = TRUE; // Allow sort
		$this->Kabupaten->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kabupaten->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->Kabupaten->DateFilter = "";
		$this->Kabupaten->Lookup = new ReportLookup('Kabupaten', 'luasview_base', TRUE, 'Kabupaten', ["Kabupaten","","",""], [], [], [], [], [], [], '`Kabupaten` ASC', '');
		$this->Kabupaten->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['Kabupaten'] = &$this->Kabupaten;

		// Koordinator
		$this->Koordinator = new ReportField('luasview_base', 'luasview', 'x_Koordinator', 'Koordinator', '`Koordinator`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Koordinator->Sortable = TRUE; // Allow sort
		$this->Koordinator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Koordinator->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->Koordinator->DateFilter = "";
		$this->Koordinator->Lookup = new ReportLookup('Koordinator', 'luasview_base', TRUE, 'Koordinator', ["Koordinator","","",""], [], [], [], [], [], [], '`Koordinator` ASC', '');
		$this->Koordinator->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['Koordinator'] = &$this->Koordinator;

		// Tahun
		$this->Tahun = new ReportField('luasview_base', 'luasview', 'x_Tahun', 'Tahun', '`Tahun`', 3, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Tahun->Sortable = TRUE; // Allow sort
		$this->Tahun->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Tahun->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->Tahun->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectInteger");
		$this->Tahun->DateFilter = "";
		$this->Tahun->Lookup = new ReportLookup('Tahun', 'luasview_base', TRUE, 'Tahun', ["Tahun","","",""], [], [], [], [], [], [], '`Tahun` ASC', '');
		$this->Tahun->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['Tahun'] = &$this->Tahun;

		// Bulan
		$this->Bulan = new ReportField('luasview_base', 'luasview', 'x_Bulan', 'Bulan', '`Bulan`', 3, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Bulan->Sortable = TRUE; // Allow sort
		$this->Bulan->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Bulan->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->Bulan->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectInteger");
		$this->Bulan->DateFilter = "";
		$this->Bulan->Lookup = new ReportLookup('Bulan', 'luasview_base', TRUE, 'Bulan', ["Bulan","","",""], [], [], [], [], [], [], '`Bulan` ASC', '');
		$this->Bulan->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['Bulan'] = &$this->Bulan;

		// Luas
		$this->Luas = new ReportField('luasview_base', 'luasview', 'x_Luas', 'Luas', '`Luas`', 131, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Luas->Sortable = TRUE; // Allow sort
		$this->Luas->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectFloat");
		$this->Luas->DateFilter = "";
		$this->fields['Luas'] = &$this->Luas;

		// Estimasi_Panen
		$this->Estimasi_Panen = new ReportField('luasview_base', 'luasview', 'x_Estimasi_Panen', 'Estimasi_Panen', '`Estimasi_Panen`', 131, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Estimasi_Panen->Sortable = TRUE; // Allow sort
		$this->Estimasi_Panen->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectFloat");
		$this->Estimasi_Panen->DateFilter = "";
		$this->fields['Estimasi_Panen'] = &$this->Estimasi_Panen;

		// Aktual_Panen
		$this->Aktual_Panen = new ReportField('luasview_base', 'luasview', 'x_Aktual_Panen', 'Aktual_Panen', '`Aktual_Panen`', 131, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Aktual_Panen->Sortable = TRUE; // Allow sort
		$this->Aktual_Panen->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectFloat");
		$this->Aktual_Panen->DateFilter = "";
		$this->fields['Aktual_Panen'] = &$this->Aktual_Panen;

		// Rata_rata_Skor
		$this->Rata_rata_Skor = new ReportField('luasview_base', 'luasview', 'x_Rata_rata_Skor', 'Rata_rata_Skor', '`Rata_rata_Skor`', 5, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Rata_rata_Skor->Sortable = TRUE; // Allow sort
		$this->Rata_rata_Skor->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectFloat");
		$this->Rata_rata_Skor->DateFilter = "";
		$this->fields['Rata_rata_Skor'] = &$this->Rata_rata_Skor;

		// Chart1
		$this->Chart1 = new DbChart($this, 'Chart1', 'Chart1', 'Pic', 'Luas', 1101, '', 0, 'SUM', 800, 440);
		$this->Chart1->SeriesYAxis = '1';
		$this->Chart1->SortType = 0;
		$this->Chart1->SortSequence = "";
		$this->Chart1->SqlSelect = "SELECT `Pic`, '', SUM(`Luas`) FROM ";
		$this->Chart1->SqlGroupBy = "`Pic`";
		$this->Chart1->SqlOrderBy = "";
		$this->Chart1->SeriesDateType = "";
		$this->Chart1->DefaultDecimalPrecision = 0;
		$this->Chart1->ID = "luasview_base_Chart1"; // Chart ID
		$this->Chart1->setParameters([new ChartParameter("type", "1101", FALSE),
			new ChartParameter("seriestype", "0", FALSE)]);  // Chart type / Chart series type
		$this->Chart1->setParameter("bgcolor", "FCFCFC", TRUE); // Background color
		$this->Chart1->setParameters([new ChartParameter("caption", $this->Chart1->caption()),
			new ChartParameter("xaxisname", $this->Chart1->xAxisName())]); // Chart caption / X axis name
		$this->Chart1->setParameter("yaxisname", $this->Chart1->yAxisName(), TRUE); // Y axis name
		$this->Chart1->setParameters([new ChartParameter("shownames", "1"),
			new ChartParameter("showvalues", "1"),
			new ChartParameter("showhovercap", "1")]); // Show names / Show values / Show hover
		$this->Chart1->setParameter("alpha", "50", FALSE); // Chart alpha
		$this->Chart1->setParameter("colorpalette", "#FF0000|#FF0080|#FF00FF|#8000FF|#FF8000|#FF3D3D|#7AFFFF|#0000FF|#FFFF00|#FF7A7A|#3DFFFF|#0080FF|#80FF00|#00FF00|#00FF80|#00FFFF", FALSE); // Chart color palette
		$this->Chart1->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, ""];
		$this->Chart1->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, ""];
		$this->Chart1->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, ""];
		$this->Chart1->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, ""];

		// Chart2
		$this->Chart2 = new DbChart($this, 'Chart2', 'Chart2', 'Pic', 'Estimasi_Panen', 4131, 'Estimasi_Panen|Aktual_Panen', 1, 'SUM', 800, 440);
		$this->Chart2->SeriesYAxis = '1';
		$this->Chart2->SortType = 0;
		$this->Chart2->SortSequence = "";
		$this->Chart2->SqlSelect = "SELECT `Pic`, '', SUM(`Estimasi_Panen`), SUM(`Aktual_Panen`) FROM ";
		$this->Chart2->SqlGroupBy = "`Pic`";
		$this->Chart2->SqlOrderBy = "";
		$this->Chart2->SeriesDateType = "";
		$this->Chart2->ID = "luasview_base_Chart2"; // Chart ID
		$this->Chart2->setParameters([new ChartParameter("type", "4131", FALSE),
			new ChartParameter("seriestype", "1", FALSE)]);  // Chart type / Chart series type
		$this->Chart2->setParameter("bgcolor", "FCFCFC", TRUE); // Background color
		$this->Chart2->setParameters([new ChartParameter("caption", $this->Chart2->caption()),
			new ChartParameter("xaxisname", $this->Chart2->xAxisName())]); // Chart caption / X axis name
		$this->Chart2->setParameters([new ChartParameter("PYAxisName", $this->Chart2->primaryYAxisName()),
			new ChartParameter("SYAxisName", $this->Chart2->secondaryYAxisName())]); // Primary Y axis name / Secondary Y axis name
		$this->Chart2->setParameters([new ChartParameter("shownames", "1"),
			new ChartParameter("showvalues", "1"),
			new ChartParameter("showhovercap", "1")]); // Show names / Show values / Show hover
		$this->Chart2->setParameter("alpha", "50", FALSE); // Chart alpha
		$this->Chart2->setParameter("colorpalette", "#4169e1|#228b22|#FF00FF|#8000FF|#FF8000|#FF3D3D|#7AFFFF|#0000FF|#FFFF00|#FF7A7A|#3DFFFF|#0080FF|#80FF00|#00FF00|#00FF80|#00FFFF", FALSE); // Chart color palette
		$this->Chart2->setParameters([new ChartParameter("showLimits", "1"),
	new ChartParameter("showDivLineValues", "1"),
	new ChartParameter("yAxisMinValue", "0"),
	new ChartParameter("yAxisMaxValue", "0"),
	new ChartParameter("gridComponentHeight", "200"),
	new ChartParameter("showAlternateVGridColor", "0"),
	new ChartParameter("isSliced", "1"),
	new ChartParameter("showAsBars", "0"),
	]);
		$this->Chart2->Trends[] = [0, 0, "4169E1", "", 1, "0", "1", 100, "", "0", "0", 0, 0, "S"];
		$this->Chart2->Trends[] = [0, 0, "228B22", "", 1, "0", "1", 100, "", "0", "0", 0, 0, "S"];
		$this->Chart2->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, "S"];
		$this->Chart2->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, "S"];

		// Chart3
		$this->Chart3 = new DbChart($this, 'Chart3', 'Chart3', 'Pic', 'Rata_rata_Skor', 1101, '', 0, 'AVG', 800, 440);
		$this->Chart3->SortType = 0;
		$this->Chart3->SortSequence = "";
		$this->Chart3->SqlSelect = "SELECT `Pic`, '', AVG(`Rata_rata_Skor`) FROM ";
		$this->Chart3->SqlGroupBy = "`Pic`";
		$this->Chart3->SqlOrderBy = "";
		$this->Chart3->SeriesDateType = "";
		$this->Chart3->ID = "luasview_base_Chart3"; // Chart ID
		$this->Chart3->setParameters([new ChartParameter("type", "1101", FALSE),
			new ChartParameter("seriestype", "0", FALSE)]);  // Chart type / Chart series type
		$this->Chart3->setParameter("bgcolor", "FCFCFC", TRUE); // Background color
		$this->Chart3->setParameters([new ChartParameter("caption", $this->Chart3->caption()),
			new ChartParameter("xaxisname", $this->Chart3->xAxisName())]); // Chart caption / X axis name
		$this->Chart3->setParameter("yaxisname", $this->Chart3->yAxisName(), TRUE); // Y axis name
		$this->Chart3->setParameters([new ChartParameter("shownames", "1"),
			new ChartParameter("showvalues", "1"),
			new ChartParameter("showhovercap", "0")]); // Show names / Show values / Show hover
		$this->Chart3->setParameter("alpha", "50", FALSE); // Chart alpha
		$this->Chart3->setParameter("colorpalette", "#FF0000|#FF0080|#FF00FF|#8000FF|#FF8000|#FF3D3D|#7AFFFF|#0000FF|#FFFF00|#FF7A7A|#3DFFFF|#0080FF|#80FF00|#00FF00|#00FF80|#00FFFF", FALSE); // Chart color palette
		$this->Chart3->setParameters([new ChartParameter("showLimits", "1"),
	new ChartParameter("showDivLineValues", "1"),
	new ChartParameter("yAxisMinValue", "0"),
	new ChartParameter("yAxisMaxValue", "0"),
	new ChartParameter("gridComponentHeight", "200"),
	new ChartParameter("showAlternateVGridColor", "0"),
	new ChartParameter("isSliced", "1"),
	new ChartParameter("showAsBars", "0"),
	]);
		$this->Chart3->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, ""];
		$this->Chart3->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, ""];
		$this->Chart3->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, ""];
		$this->Chart3->Trends[] = [0, 0, "FF0000", "", 1, "0", "1", 100, "", "0", "0", 0, 0, ""];
	}

	// Render for popup
	public function renderPopup()
	{
		global $ReportLanguage;
	}

	// Render for lookup
	public function renderLookup()
	{
		$this->Pic->ViewValue = GetDropDownDisplayValue($this->Pic->CurrentValue, "", 0);
		$this->varietas->ViewValue = GetDropDownDisplayValue($this->varietas->CurrentValue, "", 0);
		$this->Provinsi->ViewValue = GetDropDownDisplayValue($this->Provinsi->CurrentValue, "", 0);
		$this->Kabupaten->ViewValue = GetDropDownDisplayValue($this->Kabupaten->CurrentValue, "", 0);
		$this->Koordinator->ViewValue = GetDropDownDisplayValue($this->Koordinator->CurrentValue, "", 0);
		$this->Tahun->ViewValue = GetDropDownDisplayValue($this->Tahun->CurrentValue, "", 0);
		$this->Bulan->ViewValue = GetDropDownDisplayValue($this->Bulan->CurrentValue, "", 0);
	}

	// Get Field Visibility
	public function getFieldVisibility($fldparm)
	{
		global $Security;
		return $this->$fldparm->Visible; // Returns original value
	}

	// Single column sort
	protected function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($fld->GroupingFieldId == 0)
				$this->setDetailOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			if ($fld->GroupingFieldId == 0) $fld->setSort("");
		}
	}

	// Get Sort SQL
	protected function sortSql()
	{
		$dtlSortSql = $this->getDetailOrderBy(); // Get ORDER BY for detail fields from session
		$argrps = [];
		foreach ($this->fields as $fld) {
			if ($fld->getSort() <> "") {
				$fldsql = $fld->Expression;
				if ($fld->GroupingFieldId > 0) {
					if ($fld->GroupSql <> "")
						$argrps[$fld->GroupingFieldId] = str_replace("%s", $fldsql, $fld->GroupSql) . " " . $fld->getSort();
					else
						$argrps[$fld->GroupingFieldId] = $fldsql . " " . $fld->getSort();
				}
			}
		}
		$sortSql = "";
		foreach ($argrps as $grp) {
			if ($sortSql <> "") $sortSql .= ", ";
			$sortSql .= $grp;
		}
		if ($dtlSortSql <> "") {
			if ($sortSql <> "") $sortSql .= ", ";
			$sortSql .= $dtlSortSql;
		}
		return $sortSql;
	}

	// Table level SQL
	private $_sqlFrom = "";
	private $_sqlSelect = "";
	private $_sqlWhere = "";
	private $_sqlGroupBy = "";
	private $_sqlHaving = "";
	private $_sqlOrderBy = "";

	// From
	public function getSqlFrom()
	{
		return ($this->_sqlFrom <> "") ? $this->_sqlFrom : "`luasview`";
	}
	public function setSqlFrom($v)
	{
		$this->_sqlFrom = $v;
	}

	// Select
	public function getSqlSelect()
	{
		return ($this->_sqlSelect <> "") ? $this->_sqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function setSqlSelect($v)
	{
		$this->_sqlSelect = $v;
	}

	// Where
	public function getSqlWhere()
	{
		$where = ($this->_sqlWhere <> "") ? $this->_sqlWhere : "";
		$filter = "";
		AddFilter($where, $filter);
		return $where;
	}
	public function setSqlWhere($v)
	{
		$this->_sqlWhere = $v;
	}

	// Group By
	public function getSqlGroupBy()
	{
		return ($this->_sqlGroupBy <> "") ? $this->_sqlGroupBy : "";
	}
	public function setSqlGroupBy($v)
	{
		$this->_sqlGroupBy = $v;
	}

	// Having
	public function getSqlHaving()
	{
		return ($this->_sqlHaving <> "") ? $this->_sqlHaving : "";
	}
	public function setSqlHaving($v)
	{
		$this->_sqlHaving = $v;
	}

	// Order By
	public function getSqlOrderBy()
	{
		return ($this->_sqlOrderBy <> "") ? $this->_sqlOrderBy : "";
	}
	public function setSqlOrderBy($v)
	{
		$this->_sqlOrderBy = $v;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Summary properties
	private $_sqlSelectAggregate = "";
	private $_sqlAggregatePrefix = "";
	private $_sqlAggregateSuffix = "";
	private $_sqlSelectCount = "";

	// Select Aggregate
	public function getSqlSelectAggregate()
	{
		return ($this->_sqlSelectAggregate <> "") ? $this->_sqlSelectAggregate : "SELECT SUM(`Luas`) AS `sum_luas`, SUM(`Estimasi_Panen`) AS `sum_estimasi_panen`, SUM(`Aktual_Panen`) AS `sum_aktual_panen`, SUM(`Rata_rata_Skor`) AS `sum_rata_rata_skor` FROM " . $this->getSqlFrom();
	}
	public function setSqlSelectAggregate($v)
	{
		$this->_sqlSelectAggregate = $v;
	}

	// Aggregate Prefix
	public function getSqlAggregatePrefix()
	{
		return ($this->_sqlAggregatePrefix <> "") ? $this->_sqlAggregatePrefix : "";
	}
	public function setSqlAggregatePrefix($v)
	{
		$this->_sqlAggregatePrefix = $v;
	}

	// Aggregate Suffix
	public function getSqlAggregateSuffix()
	{
		return ($this->_sqlAggregateSuffix <> "") ? $this->_sqlAggregateSuffix : "";
	}
	public function setSqlAggregateSuffix($v)
	{
		$this->_sqlAggregateSuffix = $v;
	}

	// Select Count
	public function getSqlSelectCount()
	{
		return ($this->_sqlSelectCount <> "") ? $this->_sqlSelectCount : "SELECT COUNT(*) FROM " . $this->getSqlFrom();
	}
	public function setSqlSelectCount($v)
	{
		$this->_sqlSelectCount = $v;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = '';
		return $rs;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		global $DashboardReport;
		return "";
	}

	// Lookup data from table
	public function lookup()
	{
		global $Security, $RequestSecurity, $PROJECT_ID, $RELATED_PROJECT_ID;
		$projectId = $RELATED_PROJECT_ID;

		// Check token first
		$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($projectId . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($projectId . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));

		// Create lookup object and output JSON
		$lookup = new ReportLookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if (Post("keys") !== NULL) { // Selected records from modal
			$keys = Post("keys");
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Page Selecting event
	function Page_Selecting(&$filter) {

		// Enter your code here
	}

	// Page Breaking event
	function Page_Breaking(&$break, &$content) {

		// Example:
		//$break = FALSE; // Skip page break, or
		//$content = "<div style=\"page-break-after:always;\">&nbsp;</div>"; // Modify page break content

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Cell Rendered event
	function Cell_Rendered(&$Field, $CurrentValue, &$ViewValue, &$ViewAttrs, &$CellAttrs, &$HrefValue, &$LinkAttrs) {

		//$ViewValue = "xxx";
		//$ViewAttrs["class"] = "xxx";

	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}

	// Load Filters event
	function Page_FilterLoad() {

		// Enter your code here
		// Example: Register/Unregister Custom Extended Filter
		//RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A', PROJECT_NAMESPACE . 'GetStartsWithAFilter'); // With function, or
		//RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A'); // No function, use Page_Filtering event
		//UnregisterFilter($this-><Field>, 'StartsWithA');

	}

	// Page Filter Validated event
	function Page_FilterValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Page Filtering event
	function Page_Filtering(&$fld, &$filter, $typ, $opr = "", $val = "", $cond = "", $opr2 = "", $val2 = "") {

		// Note: ALWAYS CHECK THE FILTER TYPE ($typ)! Example:
		//if ($typ == "dropdown" && $fld->Name == "MyField") // Dropdown filter
		//	$filter = "..."; // Modify the filter
		//if ($typ == "extended" && $fld->Name == "MyField") // Extended filter
		//	$filter = "..."; // Modify the filter
		//if ($typ == "popup" && $fld->Name == "MyField") // Popup filter
		//	$filter = "..."; // Modify the filter
		//if ($typ == "custom" && $opr == "..." && $fld->Name == "MyField") // Custom filter, $opr is the custom filter ID
		//	$filter = "..."; // Modify the filter

	}

	// Email Sending event
	function Email_Sending(&$email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		// Enter your code here
	}
}
?>