<?php
namespace PHPMaker2019\co;

/**
 * Page class (Kedatangan_Ubi_summary)
 */
class Kedatangan_Ubi_summary extends Kedatangan_Ubi
{

	// Page ID
	public $PageID = 'summary';

	// Project ID
	public $ProjectID = "{FAF953E4-B026-4CC4-8D1E-0CFAFEB15236}";

	// Page object name
	public $PageObjName = 'Kedatangan_Ubi_summary';
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Page headings
	public $Heading = '';
	public $Subheading = '';
	public $PageHeader;
	public $PageFooter;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportPdfUrl;
	public $ExportEmailUrl;

	// CSS
	public $ReportTableClass = "";
	public $ReportTableStyle = "";

	// Custom export
	public $ExportPrintCustom = FALSE;
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Page heading
	public function pageHeading()
	{
		global $ReportLanguage;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $ReportLanguage;
		if ($this->Subheading <> "")
			return $this->Subheading;
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$pageUrl = CurrentPageName() . "?";
		if ($this->UseTokenInUrl) $pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return @$_SESSION[SESSION_MESSAGE];
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($_SESSION[SESSION_MESSAGE], $v);
	}

	// Get failure message
	public function getFailureMessage()
	{
		return @$_SESSION[SESSION_FAILURE_MESSAGE];
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($_SESSION[SESSION_FAILURE_MESSAGE], $v);
	}

	// Get success message
	public function getSuccessMessage()
	{
		return @$_SESSION[SESSION_SUCCESS_MESSAGE];
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($_SESSION[SESSION_SUCCESS_MESSAGE], $v);
	}

	// Get warning message
	public function getWarningMessage()
	{
		return @$_SESSION[SESSION_WARNING_MESSAGE];
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($_SESSION[SESSION_WARNING_MESSAGE], $v);
	}

	// Clear message
	public function clearMessage()
	{
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$_SESSION[SESSION_MESSAGE] = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") // Fotoer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
	}

	// Validate page request
	public function isPageRequest()
	{
		if ($this->UseTokenInUrl) {
			if (IsPost())
				return ($this->TableVar == Post("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $ReportLanguage, $DashboardReport;
		global $UserTable, $UserTableConn;

		// Initialize
		if (!$DashboardReport)
			$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		$ReportLanguage = new ReportLanguage();
		if ($Language === NULL)
			$Language = $ReportLanguage;

		// Parent constuctor
		parent::__construct();

		// Table object (Kedatangan_Ubi)
		if (!isset($GLOBALS["Kedatangan_Ubi"])) {
			$GLOBALS["Kedatangan_Ubi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Kedatangan_Ubi"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportEmailUrl = $this->pageUrl() . "export=email";

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'summary');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'Kedatangan Ubi');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees_base)
		if (!isset($UserTable)) {
			$UserTable = new employees_base();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Search options
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fKedatangan_Ubisummary";

		// Generate report options
		$this->GenerateOptions = new ListOptions();
		$this->GenerateOptions->Tag = "div";
		$this->GenerateOptions->TagClassName = "ew-generate-option";
	}

	// Get export HTML tag
	public function getExportTag($type, $custom = FALSE)
	{
		global $ReportLanguage;
		$exportId = session_id();
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportExcelUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("ExportToExcel") . "</a>";
			else
				return "<a class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportWordUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("ExportToWord") . "</a>";
			else
				return "<a class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "print")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportPrintUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("PrinterFriendly") . "</a>";
			else
				return "<a class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly"), TRUE) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->phrase("PrinterFriendly") . "</a>";
		} elseif (SameText($type, "pdf")) {
			return "<a class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "email")) {
			return "<a class=\"ew-export-link ew-email\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToEmail", TRUE)) . "\" id=\"emf_Kedatangan_Ubi\" href=\"#\" onclick=\"ew.emailDialogShow({ lnk: 'emf_Kedatangan_Ubi', hdr: ew.language.phrase('ExportToEmail'), url: '$this->ExportEmailUrl', exportid: '$exportId', el: this }); return false;\">" . $ReportLanguage->phrase("ExportToEmail") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Security, $ReportLanguage, $ReportOptions;
		$exportId = session_id();
		$reportTypes = [];

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;
		$reportTypes["print"] = $item->Visible ? $ReportLanguage->phrase("ReportFormPrint") : "";

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;
		$reportTypes["excel"] = $item->Visible ? $ReportLanguage->phrase("ReportFormExcel") : "";

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = TRUE;
		$reportTypes["word"] = $item->Visible ? $ReportLanguage->phrase("ReportFormWord") : "";

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;
		$item->Visible = TRUE;
		$reportTypes["pdf"] = $item->Visible ? $ReportLanguage->phrase("ReportFormPdf") : "";

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;
		$reportTypes["email"] = $item->Visible ? $ReportLanguage->phrase("ReportFormEmail") : "";

		// Report types
		$ReportOptions["ReportTypes"] = $reportTypes;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fKedatangan_Ubisummary\" href=\"#\">" . $ReportLanguage->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fKedatangan_Ubisummary\" href=\"#\">" . $ReportLanguage->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up export options (extended)
		$this->setupExportOptionsExt();

		// Hide options for export
		if ($this->isExport()) {
			$this->ExportOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}

		// Set up table class
		if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf"))
			$this->ReportTableClass = "ew-table";
		else
			$this->ReportTableClass = "table ew-table";
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $ReportLanguage;

		// Filter panel button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = $this->FilterApplied ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $ReportLanguage->phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fKedatangan_Ubisummary\">" . $ReportLanguage->phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Reset filter
		$item = &$this->SearchOptions->add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlEncode($ReportLanguage->phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . CurrentPageName() . "?cmd=reset'\">" . $ReportLanguage->phrase("ResetAllFilter") . "</button>";
		$item->Visible = TRUE && $this->FilterApplied;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->isExport())
			$this->SearchOptions->hideAllOptions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ReportLanguage, $EXPORT_REPORT, $ExportFileName, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->isExport() && array_key_exists($this->Export, $EXPORT_REPORT)) {
			$content = ob_get_contents();
			if (ob_get_length())
				ob_end_clean();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $content, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$content = str_replace($divmatch[0], "", $content);
				}
			}
			$fn = $EXPORT_REPORT[$this->Export];
			$saveResponse = $this->$fn($content);
			if (ReportParam("generaterequest") === TRUE) { // Generate report request
				$this->writeGenResponse($saveResponse);
				$url = ""; // Avoid redirect
			}
		}

		// Close connection if not in dashboard
		if (!$DashboardReport)
			CloseConnections();

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			header("Location: " . $url);
		}
		if (!$DashboardReport)
			exit();
	}

	// Initialize common variables
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $FilterOptions; // Filter options

	// Recordset
	public $GroupRecordset = NULL;
	public $Recordset = NULL;
	public $DetailRecordCount = 0;

	// Paging variables
	public $RecordIndex = 0; // Record index
	public $RecordCount = 0; // Record count
	public $StartGroup = 0; // Start group
	public $StopGroup = 0; // Stop group
	public $TotalGroups = 0; // Total groups
	public $GroupCount = 0; // Group count
	public $GroupCounter = []; // Group counter
	public $DisplayGroups = 50; // Groups per page
	public $GroupRange = 10;
	public $Sort = "";
	public $Filter = "";
	public $PageFirstGroupFilter = "";
	public $UserIDFilter = "";
	public $DrillDown = FALSE;
	public $DrillDownInPanel = FALSE;
	public $DrillDownList = "";

	// Clear field for ext filter
	public $ExpiredExtendedFilter = "";
	public $PopupName = "";
	public $PopupValue = "";
	public $FilterApplied;
	public $SearchCommand = FALSE;
	public $ShowHeader;
	public $GroupColumnCount = 0;
	public $SubGroupColumnCount = 0;
	public $DetailColumnCount = 0;
	public $Counts;
	public $Columns;
	public $Values;
	public $Summaries;
	public $Minimums;
	public $Maximums;
	public $GrandCounts;
	public $GrandSummaries;
	public $GrandMinimums;
	public $GrandMaximums;
	public $TotalCount;
	public $GrandSummarySetup = FALSE;
	public $GroupIndexes;
	public $DetailRows = [];
	public $TopContentClass = "col-sm-12 ew-top";
	public $LeftContentClass = "ew-left";
	public $CenterContentClass = "col-sm-12 ew-center";
	public $RightContentClass = "ew-right";
	public $BottomContentClass = "col-sm-12 ew-bottom";

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $ExportFileName, $ReportLanguage, $Security, $UserProfile,
			$Security, $FormError, $DrillDownInPanel, $Breadcrumb, $ReportLanguage,
			$DashboardReport, $CustomExportType;
		global $ReportLanguage;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		if (!$Security->isLoggedIn()) $Security->autoLogin(); // Auto login
		$Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel($this->ProjectID . 'Kedatangan Ubi');
		$Security->TablePermission_Loaded();
		if (!$Security->canList()) {
			$Security->saveLastUrl();
			$this->setFailureMessage(DeniedMessage()); // Set no permission
			$this->terminate(GetUrl("index.php"));
		}

		// Get export parameters
		if (ReportParam("export") !== NULL)
			$this->Export = strtolower(ReportParam("export"));
		$ExportType = $this->Export; // Get export parameter, used in header
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Setup placeholder
		// Setup export options

		$this->setupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			echo $ReportLanguage->phrase("InvalidPostRequest");
			$this->terminate();
			exit();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->co_nama);
		$this->setupLookupOptions($this->var_nama);
		$this->setupLookupOptions($this->k_es_tgl_panen);
		$this->setupLookupOptions($this->k_ak_tgl_datang);

		// Set field visibility for detail fields
		$this->koord_nama->setVisibility();
		$this->pet_nama->setVisibility();
		$this->k_id_kontrak->setVisibility();
		$this->k_luas_lahan->setVisibility();
		$this->k_es_tgl_panen->setVisibility();
		$this->k_es_qty->setVisibility();
		$this->k_ak_tgl_datang->setVisibility();
		$this->k_ak_qty->setVisibility();

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$fieldCount = 9;
		$groupCount = 3;
		$this->Values = &InitArray($fieldCount, 0);
		$this->Counts = &Init2DArray($groupCount, $fieldCount, 0);
		$this->Summaries = &Init2DArray($groupCount, $fieldCount, 0);
		$this->Minimums = &Init2DArray($groupCount, $fieldCount, NULL);
		$this->Maximums = &Init2DArray($groupCount, $fieldCount, NULL);
		$this->GrandCounts = &InitArray($fieldCount, 0);
		$this->GrandSummaries = &InitArray($fieldCount, 0);
		$this->GrandMinimums = &InitArray($fieldCount, NULL);
		$this->GrandMaximums = &InitArray($fieldCount, NULL);

		// Set up array if accumulation required: [Accum, SkipNullOrZero]
		$this->Columns = [[FALSE, FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [TRUE,FALSE], [FALSE,FALSE], [TRUE,TRUE], [FALSE,FALSE], [TRUE,TRUE]];

		// Set up groups per page dynamically
		$this->setupDisplayGroups();

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Check if search command
		$this->SearchCommand = (Get("cmd", "") == "search");

		// Load default filter values
		$this->loadDefaultFilters();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->setupPopup();

		// Load group db values if necessary
		$this->loadGroupDbValues();

		// Extended filter
		$extendedFilter = "";

		// Restore filter list
		$this->restoreFilterList();

		// Build extended filter
		$extendedFilter = $this->getExtendedFilter();
		AddFilter($this->Filter, $extendedFilter);

		// Build popup filter
		$popupFilter = $this->getPopupFilter();
		AddFilter($this->Filter, $popupFilter);

		// Check if filter applied
		$this->FilterApplied = $this->checkFilter();

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);

		// Search options
		$this->setupSearchOptions();

		// Get sort
		$this->Sort = $this->getSort();

		// Get total group count
		$sql = BuildReportSql($this->getSqlSelectGroup(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
		$this->TotalGroups = $this->getRecordCount($sql);
		if ($this->DisplayGroups <= 0 || $this->DrillDown || $DashboardReport) // Display all groups
			$this->DisplayGroups = $this->TotalGroups;
		$this->StartGroup = 1;

		// Show header
		$this->ShowHeader = ($this->TotalGroups > 0);

		// Set up start position if not export all
		if ($this->ExportAll && $this->isExport())
			$this->DisplayGroups = $this->TotalGroups;
		else
			$this->setupStartGroup();

		// Set no record found message
		if ($this->TotalGroups == 0) {
			if ($Security->canList()) {
				if ($this->Filter == "0=101") {
					$this->setWarningMessage($ReportLanguage->phrase("EnterSearchCriteria"));
				} else {
					$this->setWarningMessage($ReportLanguage->phrase("NoRecord"));
				}
			} else {
				$this->setWarningMessage(DeniedMessage());
			}
		}

		// Hide export options if export/dashboard report
		if ($this->isExport() || $DashboardReport)
			$this->ExportOptions->hideAllOptions();

		// Hide search/filter options if export/drilldown/dashboard report
		if ($this->isExport() || $this->DrillDown || $DashboardReport) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
			$this->GenerateOptions->hideAllOptions();
		}

		// Get current page groups
		$grpSort = UpdateSortFields($this->getSqlOrderByGroup(), $this->Sort, 2); // Get grouping field only
		$sql = BuildReportSql($this->getSqlSelectGroup(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderByGroup(), $this->Filter, $grpSort);
		$this->GroupRecordset = $this->getRecordset($sql, $this->DisplayGroups, $this->StartGroup - 1);

		// Init detail recordset
		$this->Recordset = NULL;
		$this->setupFieldCount();
	}

	// Get summary count
	public function getSummaryCount($lvl, $curValue = TRUE)
	{
		$cnt = 0;
		foreach ($this->DetailRows as $row) {
			$wrkco_nama = $row["co_nama"];
			$wrkvar_nama = $row["var_nama"];
			if ($lvl >= 1) {
				$val = $curValue ? $this->co_nama->CurrentValue : $this->co_nama->OldValue;
				$grpval = $curValue ? $this->co_nama->groupValue() : $this->co_nama->groupOldValue();
				if ($val === NULL && $wrkco_nama !== NULL || $val !== NULL && $wrkco_nama === NULL ||
					$grpval <> $this->co_nama->getGroupValueBase($wrkco_nama))
				continue;
			}
			if ($lvl >= 2) {
				$val = $curValue ? $this->var_nama->CurrentValue : $this->var_nama->OldValue;
				$grpval = $curValue ? $this->var_nama->groupValue() : $this->var_nama->groupOldValue();
				if ($val === NULL && $wrkvar_nama !== NULL || $val !== NULL && $wrkvar_nama === NULL ||
					$grpval <> $this->var_nama->getGroupValueBase($wrkvar_nama))
				continue;
			}
			$cnt++;
		}
		return $cnt;
	}

	// Check level break
	public function checkLevelBreak($lvl)
	{
		switch ($lvl) {
			case 1:
				return ($this->co_nama->CurrentValue === NULL && $this->co_nama->OldValue !== NULL) ||
					($this->co_nama->CurrentValue !== NULL && $this->co_nama->OldValue === NULL) ||
					($this->co_nama->groupValue() <> $this->co_nama->groupOldValue());
			case 2:
				return ($this->var_nama->CurrentValue === NULL && $this->var_nama->OldValue !== NULL) ||
					($this->var_nama->CurrentValue !== NULL && $this->var_nama->OldValue === NULL) ||
					($this->var_nama->groupValue() <> $this->var_nama->groupOldValue()) || $this->checkLevelBreak(1); // Recurse upper level
		}
	}

	// Accummulate summary
	public function accumulateSummary()
	{
		$cntx = count($this->Summaries);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Summaries[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Columns[$iy][0]) { // Accumulate required
					$valwrk = $this->Values[$iy];
					if ($valwrk === NULL) {
						if (!$this->Columns[$iy][1])
							$this->Counts[$ix][$iy]++;
					} else {
						$accum = (!$this->Columns[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Counts[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Summaries[$ix][$iy] += $valwrk;
								if ($this->Minimums[$ix][$iy] === NULL) {
									$this->Minimums[$ix][$iy] = $valwrk;
									$this->Maximums[$ix][$iy] = $valwrk;
								} else {
									if ($this->Minimums[$ix][$iy] > $valwrk)
										$this->Minimums[$ix][$iy] = $valwrk;
									if ($this->Maximums[$ix][$iy] < $valwrk)
										$this->Maximums[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Summaries);
		for ($ix = 0; $ix < $cntx; $ix++)
			$this->Counts[$ix][0]++;
	}

	// Reset level summary
	public function resetLevelSummary($lvl)
	{

		// Clear summary values
		$cntx = count($this->Summaries);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Summaries[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Counts[$ix][$iy] = 0;
				if ($this->Columns[$iy][0]) {
					$this->Summaries[$ix][$iy] = 0;
					$this->Minimums[$ix][$iy] = NULL;
					$this->Maximums[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Summaries);
		for ($ix = $lvl; $ix < $cntx; $ix++)
			$this->Counts[$ix][0] = 0;

		// Reset record count
		$this->RecordCount = 0;
	}

	// Load group row values
	public function loadGroupRowValues($firstRow = FALSE)
	{
		if (!$this->GroupRecordset)
			return;
		if ($firstRow) // Get first group

			//$this->GroupRecordset->moveFirst(); // NOTE: no need to move position
			$this->co_nama->setDbValue(""); // Init first value
		else // Get next group
			$this->GroupRecordset->moveNext();
		if (!$this->GroupRecordset->EOF)
			$this->co_nama->setDbValue($this->GroupRecordset->fields[0]);
		else
			$this->co_nama->setDbValue("");
	}

	// Load row values
	public function loadRowValues($firstRow = FALSE)
	{
		if (!$this->Recordset)
			return;
		if ($firstRow) { // Get first row
			$this->Recordset->moveFirst(); // Move first
			if ($this->GroupCount == 1) {
				$this->FirstRowData = [];
				$this->FirstRowData["co_nama"] = $this->Recordset->fields('co_nama');
				$this->FirstRowData["var_nama"] = $this->Recordset->fields('var_nama');
				$this->FirstRowData["koord_nama"] = $this->Recordset->fields('koord_nama');
				$this->FirstRowData["pet_nama"] = $this->Recordset->fields('pet_nama');
				$this->FirstRowData["k_id_kontrak"] = $this->Recordset->fields('k_id_kontrak');
				$this->FirstRowData["k_luas_lahan"] = $this->Recordset->fields('k_luas_lahan');
				$this->FirstRowData["k_es_tgl_panen"] = $this->Recordset->fields('k_es_tgl_panen');
				$this->FirstRowData["k_es_qty"] = $this->Recordset->fields('k_es_qty');
				$this->FirstRowData["k_ak_tgl_datang"] = $this->Recordset->fields('k_ak_tgl_datang');
				$this->FirstRowData["k_ak_qty"] = $this->Recordset->fields('k_ak_qty');
			}
		} else { // Get next row
			$this->Recordset->moveNext();
		}
		if (!$this->Recordset->EOF) {
			if (!$firstRow) {
				if (is_array($this->co_nama->GroupDbValues))
					$this->co_nama->setDbValue(@$this->co_nama->GroupDbValues[$this->Recordset->fields('co_nama')]);
				else
					$this->co_nama->setDbValue(GroupValue($this->co_nama, $this->Recordset->fields('co_nama')));
			}
			$this->var_nama->setDbValue($this->Recordset->fields('var_nama'));
			$this->koord_nama->setDbValue($this->Recordset->fields('koord_nama'));
			$this->pet_nama->setDbValue($this->Recordset->fields('pet_nama'));
			$this->k_id_kontrak->setDbValue($this->Recordset->fields('k_id_kontrak'));
			$this->k_luas_lahan->setDbValue($this->Recordset->fields('k_luas_lahan'));
			$this->k_es_tgl_panen->setDbValue($this->Recordset->fields('k_es_tgl_panen'));
			$this->k_es_qty->setDbValue($this->Recordset->fields('k_es_qty'));
			$this->k_ak_tgl_datang->setDbValue($this->Recordset->fields('k_ak_tgl_datang'));
			$this->k_ak_qty->setDbValue($this->Recordset->fields('k_ak_qty'));
			$this->Values[1] = $this->koord_nama->CurrentValue;
			$this->Values[2] = $this->pet_nama->CurrentValue;
			$this->Values[3] = $this->k_id_kontrak->CurrentValue;
			$this->Values[4] = $this->k_luas_lahan->CurrentValue;
			$this->Values[5] = $this->k_es_tgl_panen->CurrentValue;
			$this->Values[6] = $this->k_es_qty->CurrentValue;
			$this->Values[7] = $this->k_ak_tgl_datang->CurrentValue;
			$this->Values[8] = $this->k_ak_qty->CurrentValue;
		} else {
			$this->co_nama->setDbValue("");
			$this->var_nama->setDbValue("");
			$this->koord_nama->setDbValue("");
			$this->pet_nama->setDbValue("");
			$this->k_id_kontrak->setDbValue("");
			$this->k_luas_lahan->setDbValue("");
			$this->k_es_tgl_panen->setDbValue("");
			$this->k_es_qty->setDbValue("");
			$this->k_ak_tgl_datang->setDbValue("");
			$this->k_ak_qty->setDbValue("");
		}
	}

	// Render row
	public function renderRow()
	{
		global $Security, $ReportLanguage, $Language;
		$conn = &$this->getConnection();
		if (!$this->GrandSummarySetup) { // Get Grand total
			$hasCount = FALSE;
			$hasSummary = FALSE;

			// Get total count from SQL directly
			$sql = BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->execute($sql);
			if ($rstot) {
				$this->TotalCount = ($rstot->recordCount() > 1) ? $rstot->recordCount() : $rstot->fields[0];
				$rstot->close();
				$hasCount = TRUE;
			} else {
				$this->TotalCount = 0;
			}

			// Get total from SQL directly
			$sql = BuildReportSql($this->getSqlSelectAggregate(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$sql = $this->getSqlAggregatePrefix() . $sql . $this->getSqlAggregateSuffix();
			$rsagg = $conn->execute($sql);
			if ($rsagg) {
				$this->GrandCounts[1] = $this->TotalCount;
				$this->GrandCounts[2] = $this->TotalCount;
				$this->GrandCounts[3] = $this->TotalCount;
				$this->GrandCounts[4] = $this->TotalCount;
				$this->GrandSummaries[4] = $rsagg->fields("sum_k_luas_lahan");
				$this->GrandCounts[5] = $this->TotalCount;
				$this->GrandCounts[6] = $this->TotalCount;
				$this->GrandSummaries[6] = $rsagg->fields("sum_k_es_qty");
				$this->GrandCounts[6] = $rsagg->fields("cnt_k_es_qty");
				$this->GrandCounts[7] = $this->TotalCount;
				$this->GrandCounts[8] = $this->TotalCount;
				$this->GrandSummaries[8] = $rsagg->fields("sum_k_ak_qty");
				$this->GrandCounts[8] = $rsagg->fields("cnt_k_ak_qty");
				$rsagg->close();
				$hasSummary = TRUE;
			}

			// Accumulate grand summary from detail records
			if (!$hasCount || !$hasSummary) {
				$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$this->Recordset = $conn->execute($sql);
				if ($this->Recordset) {
					$this->loadRowValues(TRUE);
					while (!$this->Recordset->EOF) {
						$this->accumulateGrandSummary();
						$this->loadRowValues();
					}
					$this->Recordset->close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();
		if ($this->RowType == ROWTYPE_SEARCH) { // Search row
			$ar = [];
			if (is_array($this->co_nama->AdvancedFilters)) {
				foreach ($this->co_nama->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->co_nama->DropDownList)) {
				foreach ($this->co_nama->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->co_nama->EditValue = $ar;
			$this->co_nama->AdvancedSearch->SearchValue = is_array($this->co_nama->DropDownValue) ? implode(",", $this->co_nama->DropDownValue) : $this->co_nama->DropDownValue;
			$ar = [];
			if (is_array($this->var_nama->AdvancedFilters)) {
				foreach ($this->var_nama->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->var_nama->DropDownList)) {
				foreach ($this->var_nama->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->var_nama->EditValue = $ar;
			$this->var_nama->AdvancedSearch->SearchValue = is_array($this->var_nama->DropDownValue) ? implode(",", $this->var_nama->DropDownValue) : $this->var_nama->DropDownValue;
			$ar = [];
			if (is_array($this->k_es_tgl_panen->AdvancedFilters)) {
				foreach ($this->k_es_tgl_panen->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->k_es_tgl_panen->DropDownList)) {
				foreach ($this->k_es_tgl_panen->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, $this->k_es_tgl_panen->DateFilter, 0)];
			}
			$this->k_es_tgl_panen->EditValue = $ar;
			$this->k_es_tgl_panen->AdvancedSearch->SearchValue = is_array($this->k_es_tgl_panen->DropDownValue) ? implode(",", $this->k_es_tgl_panen->DropDownValue) : $this->k_es_tgl_panen->DropDownValue;
			$ar = [];
			if (is_array($this->k_ak_tgl_datang->AdvancedFilters)) {
				foreach ($this->k_ak_tgl_datang->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->k_ak_tgl_datang->DropDownList)) {
				foreach ($this->k_ak_tgl_datang->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, $this->k_ak_tgl_datang->DateFilter, 0)];
			}
			$this->k_ak_tgl_datang->EditValue = $ar;
			$this->k_ak_tgl_datang->AdvancedSearch->SearchValue = is_array($this->k_ak_tgl_datang->DropDownValue) ? implode(",", $this->k_ak_tgl_datang->DropDownValue) : $this->k_ak_tgl_datang->DropDownValue;
		} elseif ($this->RowType == ROWTYPE_TOTAL && !($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER)) { // Summary row
			PrependClass($this->RowAttrs["class"], ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class
			if ($this->RowTotalType == ROWTOTAL_GROUP) $this->RowAttrs["data-group"] = $this->co_nama->groupOldValue(); // Set up group attribute
			if ($this->RowTotalType == ROWTOTAL_GROUP && $this->RowGroupLevel >= 2) $this->RowAttrs["data-group-2"] = $this->var_nama->groupOldValue(); // Set up group attribute 2

			// co_nama
			$this->co_nama->GroupViewValue = $this->co_nama->groupOldValue();
			$this->co_nama->CellAttrs["class"] = ($this->RowGroupLevel == 1 ? "ew-rpt-grp-summary-1" : "ew-rpt-grp-field-1");
			$this->co_nama->GroupViewValue = DisplayGroupValue($this->co_nama, $this->co_nama->GroupViewValue);
			$this->co_nama->GroupSummaryOldValue = $this->co_nama->GroupSummaryValue;
			$this->co_nama->GroupSummaryValue = $this->co_nama->GroupViewValue;
			$this->co_nama->GroupSummaryViewValue = ($this->co_nama->GroupSummaryOldValue <> $this->co_nama->GroupSummaryValue) ? $this->co_nama->GroupSummaryValue : "&nbsp;";

			// var_nama
			$this->var_nama->GroupViewValue = $this->var_nama->groupOldValue();
			$this->var_nama->CellAttrs["class"] = ($this->RowGroupLevel == 2 ? "ew-rpt-grp-summary-2" : "ew-rpt-grp-field-2");
			$this->var_nama->GroupViewValue = DisplayGroupValue($this->var_nama, $this->var_nama->GroupViewValue);
			$this->var_nama->GroupSummaryOldValue = $this->var_nama->GroupSummaryValue;
			$this->var_nama->GroupSummaryValue = $this->var_nama->GroupViewValue;
			$this->var_nama->GroupSummaryViewValue = ($this->var_nama->GroupSummaryOldValue <> $this->var_nama->GroupSummaryValue) ? $this->var_nama->GroupSummaryValue : "&nbsp;";

			// k_luas_lahan
			$this->k_luas_lahan->SumViewValue = $this->k_luas_lahan->SumValue;
			$this->k_luas_lahan->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// k_es_qty
			$this->k_es_qty->SumViewValue = $this->k_es_qty->SumValue;
			$this->k_es_qty->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// k_es_qty
			$this->k_es_qty->CntViewValue = $this->k_es_qty->CntValue;
			$this->k_es_qty->CntViewValue = FormatNumber($this->k_es_qty->CntViewValue, 0, -2, -2, -2);
			$this->k_es_qty->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// k_ak_qty
			$this->k_ak_qty->SumViewValue = $this->k_ak_qty->SumValue;
			$this->k_ak_qty->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// k_ak_qty
			$this->k_ak_qty->CntViewValue = $this->k_ak_qty->CntValue;
			$this->k_ak_qty->CntViewValue = FormatNumber($this->k_ak_qty->CntViewValue, 0, -2, -2, -2);
			$this->k_ak_qty->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// co_nama
			$this->co_nama->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// koord_nama
			$this->koord_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->HrefValue = "";

			// k_es_qty
			$this->k_es_qty->HrefValue = "";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->HrefValue = "";

			// k_ak_qty
			$this->k_ak_qty->HrefValue = "";
		} else {
			if ($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER) {
			$this->RowAttrs["data-group"] = $this->co_nama->groupValue(); // Set up group attribute
			if ($this->RowGroupLevel >= 2) $this->RowAttrs["data-group-2"] = $this->var_nama->groupValue(); // Set up group attribute 2
			} else {
			$this->RowAttrs["data-group"] = $this->co_nama->groupValue(); // Set up group attribute
			$this->RowAttrs["data-group-2"] = $this->var_nama->groupValue(); // Set up group attribute 2
			}

			// co_nama
			$this->co_nama->GroupViewValue = $this->co_nama->groupValue();
			$this->co_nama->CellAttrs["class"] = "ew-rpt-grp-field-1";
			$this->co_nama->GroupViewValue = DisplayGroupValue($this->co_nama, $this->co_nama->GroupViewValue);
			if ($this->co_nama->groupValue() == $this->co_nama->groupOldValue() && !$this->checkLevelBreak(1))
				$this->co_nama->GroupViewValue = "&nbsp;";

			// var_nama
			$this->var_nama->GroupViewValue = $this->var_nama->groupValue();
			$this->var_nama->CellAttrs["class"] = "ew-rpt-grp-field-2";
			$this->var_nama->GroupViewValue = DisplayGroupValue($this->var_nama, $this->var_nama->GroupViewValue);
			if ($this->var_nama->groupValue() == $this->var_nama->groupOldValue() && !$this->checkLevelBreak(2))
				$this->var_nama->GroupViewValue = "&nbsp;";

			// koord_nama
			$this->koord_nama->ViewValue = $this->koord_nama->CurrentValue;
			$this->koord_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// pet_nama
			$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
			$this->pet_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_id_kontrak
			$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
			$this->k_id_kontrak->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_luas_lahan
			$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
			$this->k_luas_lahan->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_es_tgl_panen
			$this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
			$this->k_es_tgl_panen->ViewValue = FormatDateTime($this->k_es_tgl_panen->ViewValue, 0);
			$this->k_es_tgl_panen->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_es_qty
			$this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;
			$this->k_es_qty->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
			$this->k_ak_tgl_datang->ViewValue = FormatDateTime($this->k_ak_tgl_datang->ViewValue, 0);
			$this->k_ak_tgl_datang->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_ak_qty
			$this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;
			$this->k_ak_qty->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// co_nama
			$this->co_nama->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// koord_nama
			$this->koord_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->HrefValue = "";

			// k_es_qty
			$this->k_es_qty->HrefValue = "";

			// k_ak_tgl_datang
			$this->k_ak_tgl_datang->HrefValue = "";

			// k_ak_qty
			$this->k_ak_qty->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == ROWTYPE_TOTAL) { // Summary row

			// co_nama
			$currentValue = $this->co_nama->GroupViewValue;
			$viewValue = &$this->co_nama->GroupViewValue;
			$viewAttrs = &$this->co_nama->ViewAttrs;
			$cellAttrs = &$this->co_nama->CellAttrs;
			$hrefValue = &$this->co_nama->HrefValue;
			$linkAttrs = &$this->co_nama->LinkAttrs;
			$this->Cell_Rendered($this->co_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// var_nama
			$currentValue = $this->var_nama->GroupViewValue;
			$viewValue = &$this->var_nama->GroupViewValue;
			$viewAttrs = &$this->var_nama->ViewAttrs;
			$cellAttrs = &$this->var_nama->CellAttrs;
			$hrefValue = &$this->var_nama->HrefValue;
			$linkAttrs = &$this->var_nama->LinkAttrs;
			$this->Cell_Rendered($this->var_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_luas_lahan
			$currentValue = $this->k_luas_lahan->SumValue;
			$viewValue = &$this->k_luas_lahan->SumViewValue;
			$viewAttrs = &$this->k_luas_lahan->ViewAttrs;
			$cellAttrs = &$this->k_luas_lahan->CellAttrs;
			$hrefValue = &$this->k_luas_lahan->HrefValue;
			$linkAttrs = &$this->k_luas_lahan->LinkAttrs;
			$this->Cell_Rendered($this->k_luas_lahan, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_es_qty
			$currentValue = $this->k_es_qty->SumValue;
			$viewValue = &$this->k_es_qty->SumViewValue;
			$viewAttrs = &$this->k_es_qty->ViewAttrs;
			$cellAttrs = &$this->k_es_qty->CellAttrs;
			$hrefValue = &$this->k_es_qty->HrefValue;
			$linkAttrs = &$this->k_es_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_es_qty, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_es_qty
			$currentValue = $this->k_es_qty->CntValue;
			$viewValue = &$this->k_es_qty->CntViewValue;
			$viewAttrs = &$this->k_es_qty->ViewAttrs;
			$cellAttrs = &$this->k_es_qty->CellAttrs;
			$hrefValue = &$this->k_es_qty->HrefValue;
			$linkAttrs = &$this->k_es_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_es_qty, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_ak_qty
			$currentValue = $this->k_ak_qty->SumValue;
			$viewValue = &$this->k_ak_qty->SumViewValue;
			$viewAttrs = &$this->k_ak_qty->ViewAttrs;
			$cellAttrs = &$this->k_ak_qty->CellAttrs;
			$hrefValue = &$this->k_ak_qty->HrefValue;
			$linkAttrs = &$this->k_ak_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_ak_qty, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_ak_qty
			$currentValue = $this->k_ak_qty->CntValue;
			$viewValue = &$this->k_ak_qty->CntViewValue;
			$viewAttrs = &$this->k_ak_qty->ViewAttrs;
			$cellAttrs = &$this->k_ak_qty->CellAttrs;
			$hrefValue = &$this->k_ak_qty->HrefValue;
			$linkAttrs = &$this->k_ak_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_ak_qty, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
		} else {

			// co_nama
			$currentValue = $this->co_nama->groupValue();
			$viewValue = &$this->co_nama->GroupViewValue;
			$viewAttrs = &$this->co_nama->ViewAttrs;
			$cellAttrs = &$this->co_nama->CellAttrs;
			$hrefValue = &$this->co_nama->HrefValue;
			$linkAttrs = &$this->co_nama->LinkAttrs;
			$this->Cell_Rendered($this->co_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// var_nama
			$currentValue = $this->var_nama->groupValue();
			$viewValue = &$this->var_nama->GroupViewValue;
			$viewAttrs = &$this->var_nama->ViewAttrs;
			$cellAttrs = &$this->var_nama->CellAttrs;
			$hrefValue = &$this->var_nama->HrefValue;
			$linkAttrs = &$this->var_nama->LinkAttrs;
			$this->Cell_Rendered($this->var_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// koord_nama
			$currentValue = $this->koord_nama->CurrentValue;
			$viewValue = &$this->koord_nama->ViewValue;
			$viewAttrs = &$this->koord_nama->ViewAttrs;
			$cellAttrs = &$this->koord_nama->CellAttrs;
			$hrefValue = &$this->koord_nama->HrefValue;
			$linkAttrs = &$this->koord_nama->LinkAttrs;
			$this->Cell_Rendered($this->koord_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// pet_nama
			$currentValue = $this->pet_nama->CurrentValue;
			$viewValue = &$this->pet_nama->ViewValue;
			$viewAttrs = &$this->pet_nama->ViewAttrs;
			$cellAttrs = &$this->pet_nama->CellAttrs;
			$hrefValue = &$this->pet_nama->HrefValue;
			$linkAttrs = &$this->pet_nama->LinkAttrs;
			$this->Cell_Rendered($this->pet_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_id_kontrak
			$currentValue = $this->k_id_kontrak->CurrentValue;
			$viewValue = &$this->k_id_kontrak->ViewValue;
			$viewAttrs = &$this->k_id_kontrak->ViewAttrs;
			$cellAttrs = &$this->k_id_kontrak->CellAttrs;
			$hrefValue = &$this->k_id_kontrak->HrefValue;
			$linkAttrs = &$this->k_id_kontrak->LinkAttrs;
			$this->Cell_Rendered($this->k_id_kontrak, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_luas_lahan
			$currentValue = $this->k_luas_lahan->CurrentValue;
			$viewValue = &$this->k_luas_lahan->ViewValue;
			$viewAttrs = &$this->k_luas_lahan->ViewAttrs;
			$cellAttrs = &$this->k_luas_lahan->CellAttrs;
			$hrefValue = &$this->k_luas_lahan->HrefValue;
			$linkAttrs = &$this->k_luas_lahan->LinkAttrs;
			$this->Cell_Rendered($this->k_luas_lahan, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_es_tgl_panen
			$currentValue = $this->k_es_tgl_panen->CurrentValue;
			$viewValue = &$this->k_es_tgl_panen->ViewValue;
			$viewAttrs = &$this->k_es_tgl_panen->ViewAttrs;
			$cellAttrs = &$this->k_es_tgl_panen->CellAttrs;
			$hrefValue = &$this->k_es_tgl_panen->HrefValue;
			$linkAttrs = &$this->k_es_tgl_panen->LinkAttrs;
			$this->Cell_Rendered($this->k_es_tgl_panen, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_es_qty
			$currentValue = $this->k_es_qty->CurrentValue;
			$viewValue = &$this->k_es_qty->ViewValue;
			$viewAttrs = &$this->k_es_qty->ViewAttrs;
			$cellAttrs = &$this->k_es_qty->CellAttrs;
			$hrefValue = &$this->k_es_qty->HrefValue;
			$linkAttrs = &$this->k_es_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_es_qty, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_ak_tgl_datang
			$currentValue = $this->k_ak_tgl_datang->CurrentValue;
			$viewValue = &$this->k_ak_tgl_datang->ViewValue;
			$viewAttrs = &$this->k_ak_tgl_datang->ViewAttrs;
			$cellAttrs = &$this->k_ak_tgl_datang->CellAttrs;
			$hrefValue = &$this->k_ak_tgl_datang->HrefValue;
			$linkAttrs = &$this->k_ak_tgl_datang->LinkAttrs;
			$this->Cell_Rendered($this->k_ak_tgl_datang, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_ak_qty
			$currentValue = $this->k_ak_qty->CurrentValue;
			$viewValue = &$this->k_ak_qty->ViewValue;
			$viewAttrs = &$this->k_ak_qty->ViewAttrs;
			$cellAttrs = &$this->k_ak_qty->CellAttrs;
			$hrefValue = &$this->k_ak_qty->HrefValue;
			$linkAttrs = &$this->k_ak_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_ak_qty, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->setupFieldCount();
	}

	// Accummulate grand summary
	protected function accumulateGrandSummary()
	{
		$this->TotalCount++;
		$cntgs = count($this->GrandSummaries);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Columns[$iy][0]) {
				$valwrk = $this->Values[$iy];
				if ($valwrk === NULL || !is_numeric($valwrk)) {
					if (!$this->Columns[$iy][1])
						$this->GrandCounts[$iy]++;
				} else {
					if (!$this->Columns[$iy][1] || $valwrk <> 0) {
						$this->GrandCounts[$iy]++;
						$this->GrandSummaries[$iy] += $valwrk;
						if ($this->GrandMinimums[$iy] === NULL) {
							$this->GrandMinimums[$iy] = $valwrk;
							$this->GrandMaximums[$iy] = $valwrk;
						} else {
							if ($this->GrandMinimums[$iy] > $valwrk)
								$this->GrandMinimums[$iy] = $valwrk;
							if ($this->GrandMaximums[$iy] < $valwrk)
								$this->GrandMaximums[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Load group db values if necessary
	protected function loadGroupDbValues()
	{
		$conn = &$this->getConnection();
	}

	// Set up popup
	protected function setupPopup()
	{
		global $ReportLanguage;
		$conn = &$this->getConnection();
		if ($this->DrillDown)
			return;

		// Process post back form
		if (IsPost()) {
			$name = Post("popup", ""); // Get popup form name
			if ($name <> "") {
				$arValues = Post("sel_$name");
				$cntValues = is_array($arValues) ? count($arValues) : 0;
				if ($cntValues > 0) {
					if (trim($arValues[0]) == "") // Select all
						$arValues = INIT_VALUE;
					$this->PopupName = $name;
					if (IsAdvancedFilterValue($arValues) || $arValues == INIT_VALUE)
						$this->PopupValue = $arValues;
					if (!MatchedArray($arValues, @$_SESSION["sel_$name"])) {
						if ($this->hasSessionFilterValues($name))
							$this->ExpiredExtendedFilter = $name; // Clear extended filter for this field
					}
					$_SESSION["sel_$name"] = $arValues;
					$_SESSION["rf_$name"] = Post("rf_$name", "");
					$_SESSION["rt_$name"] = Post("rt_$name", "");
					$this->resetPager();
				}
			}

		// Get 'reset' command
		} elseif (Get("cmd") !== NULL) {
			$cmd = Get("cmd");
			if (SameText($cmd, "reset")) {
				$this->resetPager();
			}
		}

		// Load selection criteria to array
	}

	// Setup field count
	protected function setupFieldCount()
	{
		$this->GroupColumnCount = 0;
		$this->SubGroupColumnCount = 0;
		$this->DetailColumnCount = 0;
		if ($this->co_nama->Visible)
			$this->GroupColumnCount += 1;
		if ($this->var_nama->Visible) {
			$this->GroupColumnCount += 1;
			$this->SubGroupColumnCount += 1;
		}
		if ($this->koord_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->pet_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_id_kontrak->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_luas_lahan->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_es_tgl_panen->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_es_qty->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_ak_tgl_datang->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_ak_qty->Visible)
			$this->DetailColumnCount += 1;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/") + 1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', "", $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("summary", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Set up export options (extended)
	protected function setupExportOptionsExt()
	{
		global $ReportLanguage, $ReportOptions;
		$reportTypes = $ReportOptions["ReportTypes"];
		$item = &$this->ExportOptions->getItem("pdf");
		$item->Visible = TRUE;
		if ($item->Visible)
			$reportTypes["pdf"] = $ReportLanguage->phrase("ReportFormPdf");
		$item->Body = "<a class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportPdfUrl . "', '" . session_id() . "');\">" . $ReportLanguage->phrase("ExportToPDF") . "</a>";
		$ReportOptions["ReportTypes"] = $reportTypes;
	}

	// Export to HTML
	public function exportHtml($html)
	{

		//global $ExportFileName;
		//header('Content-Type: text/html' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
		//header('Content-Disposition: attachment; filename=' . $ExportFileName . '.html');

		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";

		// Save generate file for print
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
			$baseTag = "<base href=\"" . BaseUrl() . "\">";
			$html = preg_replace('/<head>/', '<head>' . $baseTag, $html);
			SaveFile($folder, $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file")
			Write($html);
		return $saveToFile;
	}

	// Export to Word
	public function exportWord($html)
	{
		global $ExportFileName;
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	SaveFile(ServerMapPath($folder), $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			AddHeader('Content-Type', 'application/vnd.ms-word' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
			AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.doc');
			Write($html);
		}
		return $saveToFile;
	}

	// Export to Excel
	public function exportExcel($html)
	{
		global $ExportFileName;
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	SaveFile(ServerMapPath($folder), $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			AddHeader('Content-Type', 'application/vnd.ms-excel' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
			AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.xls');
			Write($html);
		}
		return $saveToFile;
	}

	// Export PDF
	public function exportPdf($html)
	{
		global $ExportFileName, $PDF_MEMORY_LIMIT, $PDF_TIME_LIMIT, $PDF_IMAGE_SCALE_FACTOR;
		@ini_set("memory_limit", $PDF_MEMORY_LIMIT);
		set_time_limit($PDF_TIME_LIMIT);
		$html = CheckHtml($html);
		if (DEBUG_ENABLED) // Add debug message
			$html = str_replace("</body>", GetDebugMessage() . "</body>", $html);
		$dompdf = new \Dompdf\Dompdf(["pdf_backend" => "Cpdf"]);
		$doc = new \DOMDocument("1.0", "utf-8");
		@$doc->loadHTML('<?xml encoding="uft-8">' . ConvertToUtf8($html)); // Convert to utf-8
		$spans = $doc->getElementsByTagName("span");
		foreach ($spans as $span) {
			$classNames = $span->getAttribute("class");
			if ($classNames == "ew-filter-caption") // Insert colon
				$span->parentNode->insertBefore($doc->createElement("span", ":&nbsp;"), $span->nextSibling);
			elseif (preg_match('/\bicon\-\w+\b/', $classNames)) // Remove icons
				$span->parentNode->removeChild($span);
		}
		$images = $doc->getElementsByTagName("img");
		$pageSize = "a4";
		$pageOrientation = "portrait";
		$this->ExportPageOrientation = $pageOrientation;
		$portrait = SameText($pageOrientation, "portrait");
		foreach ($images as $image) {
			$imagefn = $image->getAttribute("src");
			if (file_exists($imagefn)) {
				$imagefn = realpath($imagefn);
				$size = getimagesize($imagefn); // Get image size
				if ($size[0] <> 0) {
					if (SameText($pageSize, "letter")) { // Letter paper (8.5 in. by 11 in.)
						$w = $portrait ? 216 : 279;
					} elseif (SameText($pageSize, "legal")) { // Legal paper (8.5 in. by 14 in.)
						$w = $portrait ? 216 : 356;
					} else {
						$w = $portrait ? 210 : 297; // A4 paper (210 mm by 297 mm)
					}
					$w = min($size[0], ($w - 20 * 2) / 25.4 * 72 * $PDF_IMAGE_SCALE_FACTOR); // Resize image, adjust the scale factor if necessary
					$h = $w / $size[0] * $size[1];
					$image->setAttribute("width", $w);
					$image->setAttribute("height", $h);
				}
			}
		}
		$html = $doc->saveHTML();
		$html = ConvertFromUtf8($html);
		$dompdf->load_html($html);
		$dompdf->set_paper($pageSize, $pageOrientation);
		$dompdf->render();
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
			SaveFile(ServerMapPath($folder), $fileName, $dompdf->output());
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			$exportFile = EndsText(".pdf", $ExportFileName) ? $ExportFileName : $ExportFileName . ".pdf";
			$dompdf->stream($exportFile, ["Attachment" => 1]); // 0 to open in browser, 1 to download
		}
		DeleteTempImages($html);
		return $saveToFile;
	}

	// Set up starting group
	protected function setupStartGroup()
	{

		// Exit if no groups
		if ($this->DisplayGroups == 0)
			return;
		$startGrp = ReportParam(TABLE_START_GROUP, "");
		$pageNo = ReportParam("pageno", "");

		// Check for a 'start' parameter
		if ($startGrp != "") {
			$this->StartGroup = $startGrp;
			$this->setStartGroup($this->StartGroup);
		} elseif ($pageNo != "") {
			if (is_numeric($pageNo)) {
				$this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
				if ($this->StartGroup <= 0) {
					$this->StartGroup = 1;
				} elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
					$this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
				}
				$this->setStartGroup($this->StartGroup);
			} else {
				$this->StartGroup = $this->getStartGroup();
			}
		} else {
			$this->StartGroup = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGroup) || $this->StartGroup == "") { // Avoid invalid start group counter
			$this->StartGroup = 1; // Reset start group counter
			$this->setStartGroup($this->StartGroup);
		} elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
			$this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
			$this->setStartGroup($this->StartGroup);
		} elseif (($this->StartGroup-1) % $this->DisplayGroups <> 0) {
			$this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
			$this->setStartGroup($this->StartGroup);
		}
	}

	// Reset pager
	protected function resetPager()
	{

		// Reset start position (reset command)
		$this->StartGroup = 1;
		$this->setStartGroup($this->StartGroup);
	}

	// Set up number of groups displayed per page
	protected function setupDisplayGroups()
	{
		if (ReportParam(TABLE_GROUP_PER_PAGE) !== NULL) {
			$wrk = ReportParam(TABLE_GROUP_PER_PAGE);
			if (is_numeric($wrk)) {
				$this->DisplayGroups = intval($wrk);
			} else {
				if (strtoupper($wrk) == "ALL") { // Display all groups
					$this->DisplayGroups = -1;
				} else {
					$this->DisplayGroups = 50; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGroups); // Save to session

			// Reset start position (reset command)
			$this->StartGroup = 1;
			$this->setStartGroup($this->StartGroup);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGroups = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGroups = 50; // Load default
			}
		}
	}

	// Get sort parameters based on sort links clicked
	protected function getSort()
	{
		if ($this->DrillDown)
			return "`k_id_kontrak` ASC";
		$resetSort = ReportParam("cmd") === "resetsort";
		$orderBy = ReportParam("order", "");
		$orderType = ReportParam("ordertype", "");

		// Check for a resetsort command
		if ($resetSort) {
			$this->setOrderBy("");
			$this->setStartGroup(1);
			$this->co_nama->setSort("");
			$this->var_nama->setSort("");
			$this->koord_nama->setSort("");
			$this->pet_nama->setSort("");
			$this->k_id_kontrak->setSort("");
			$this->k_luas_lahan->setSort("");
			$this->k_es_tgl_panen->setSort("");
			$this->k_es_qty->setSort("");
			$this->k_ak_tgl_datang->setSort("");
			$this->k_ak_qty->setSort("");

		// Check for an Order parameter
		} elseif ($orderBy <> "") {
			$this->CurrentOrder = $orderBy;
			$this->CurrentOrderType = $orderType;
			$sortSql = $this->sortSql();
			$this->setOrderBy($sortSql);
			$this->setStartGroup(1);
		}

		// Set up default sort
		if ($this->getOrderBy() == "") {
			$this->setOrderBy("`k_id_kontrak` ASC");
			$this->k_id_kontrak->setSort("ASC");
		}
		return $this->getOrderBy();
	}

	// Return extended filter
	protected function getExtendedFilter()
	{
		global $FormError;
		$filter = "";
		if ($this->DrillDown)
			return "";
		$postBack = IsPost();
		$restoreSession = TRUE;
		$setupFilter = FALSE;

		// Reset extended filter if filter changed
		if ($postBack) {

		// Reset search command
		} elseif (Get("cmd", "") == "reset") {

			// Load default values
			$this->setSessionDropDownValue($this->co_nama->DropDownValue, $this->co_nama->AdvancedSearch->SearchOperator, "co_nama"); // Field co_nama
			$this->setSessionDropDownValue($this->var_nama->DropDownValue, $this->var_nama->AdvancedSearch->SearchOperator, "var_nama"); // Field var_nama
			$this->setSessionDropDownValue($this->k_es_tgl_panen->DropDownValue, $this->k_es_tgl_panen->AdvancedSearch->SearchOperator, "k_es_tgl_panen"); // Field k_es_tgl_panen
			$this->setSessionDropDownValue($this->k_ak_tgl_datang->DropDownValue, $this->k_ak_tgl_datang->AdvancedSearch->SearchOperator, "k_ak_tgl_datang"); // Field k_ak_tgl_datang

			//$setupFilter = TRUE; // No need to set up, just use default
		} else {
			$restoreSession = !$this->SearchCommand;

			// Field co_nama
			if ($this->getDropDownValue($this->co_nama)) {
				$setupFilter = TRUE;
			} elseif ($this->co_nama->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Ubi_co_nama"])) {
				$setupFilter = TRUE;
			}

			// Field var_nama
			if ($this->getDropDownValue($this->var_nama)) {
				$setupFilter = TRUE;
			} elseif ($this->var_nama->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Ubi_var_nama"])) {
				$setupFilter = TRUE;
			}

			// Field k_es_tgl_panen
			if ($this->getDropDownValue($this->k_es_tgl_panen)) {
				$setupFilter = TRUE;
			} elseif ($this->k_es_tgl_panen->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Ubi_k_es_tgl_panen"])) {
				$setupFilter = TRUE;
			}

			// Field k_ak_tgl_datang
			if ($this->getDropDownValue($this->k_ak_tgl_datang)) {
				$setupFilter = TRUE;
			} elseif ($this->k_ak_tgl_datang->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Ubi_k_ak_tgl_datang"])) {
				$setupFilter = TRUE;
			}
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				return $filter;
			}
		}

		// Restore session
		if ($restoreSession) {
			$this->getSessionDropDownValue($this->co_nama); // Field co_nama
			$this->getSessionDropDownValue($this->var_nama); // Field var_nama
			$this->getSessionDropDownValue($this->k_es_tgl_panen); // Field k_es_tgl_panen
			$this->getSessionDropDownValue($this->k_ak_tgl_datang); // Field k_ak_tgl_datang
		}

		// Call page filter validated event
		$this->Page_FilterValidated();

		// Build SQL
		$this->buildDropDownFilter($this->co_nama, $filter, $this->co_nama->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field co_nama
		$this->buildDropDownFilter($this->var_nama, $filter, $this->var_nama->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field var_nama
		$this->buildDropDownFilter($this->k_es_tgl_panen, $filter, $this->k_es_tgl_panen->DateFilter, FALSE, TRUE); // Field k_es_tgl_panen
		$this->buildDropDownFilter($this->k_ak_tgl_datang, $filter, $this->k_ak_tgl_datang->DateFilter, FALSE, TRUE); // Field k_ak_tgl_datang

		// Save parms to session
		$this->setSessionDropDownValue($this->co_nama->DropDownValue, $this->co_nama->AdvancedSearch->SearchOperator, "co_nama"); // Field co_nama
		$this->setSessionDropDownValue($this->var_nama->DropDownValue, $this->var_nama->AdvancedSearch->SearchOperator, "var_nama"); // Field var_nama
		$this->setSessionDropDownValue($this->k_es_tgl_panen->DropDownValue, $this->k_es_tgl_panen->AdvancedSearch->SearchOperator, "k_es_tgl_panen"); // Field k_es_tgl_panen
		$this->setSessionDropDownValue($this->k_ak_tgl_datang->DropDownValue, $this->k_ak_tgl_datang->AdvancedSearch->SearchOperator, "k_ak_tgl_datang"); // Field k_ak_tgl_datang

		// Setup filter
		if ($setupFilter) {
		}

		// Field co_nama
		LoadDropDownList($this->co_nama->DropDownList, $this->co_nama->DropDownValue);

		// Field var_nama
		LoadDropDownList($this->var_nama->DropDownList, $this->var_nama->DropDownValue);

		// Field k_es_tgl_panen
		LoadDropDownList($this->k_es_tgl_panen->DropDownList, $this->k_es_tgl_panen->DropDownValue);

		// Field k_ak_tgl_datang
		LoadDropDownList($this->k_ak_tgl_datang->DropDownList, $this->k_ak_tgl_datang->DropDownValue);
		return $filter;
	}

	// Build dropdown filter
	protected function buildDropDownFilter(&$fld, &$filterClause, $fldOpr, $default = FALSE, $saveFilter = FALSE)
	{
		$fldVal = ($default) ? $fld->DefaultDropDownValue : $fld->DropDownValue;
		$sql = "";
		if (is_array($fldVal)) {
			foreach ($fldVal as $val) {
				$wrk = $this->getDropDownFilter($fld, $val, $fldOpr);

				// Call Page Filtering event
				if (!StartsString("@@", $val))
					$this->Page_Filtering($fld, $wrk, "dropdown", $fldOpr, $val);
				if ($wrk <> "") {
					if ($sql <> "")
						$sql .= " OR " . $wrk;
					else
						$sql = $wrk;
				}
			}
		} else {
			$sql = $this->getDropDownFilter($fld, $fldVal, $fldOpr);

			// Call Page Filtering event
			if (!StartsString("@@", $fldVal))
				$this->Page_Filtering($fld, $sql, "dropdown", $fldOpr, $fldVal);
		}
		if ($sql <> "") {
			AddFilter($filterClause, $sql);
			if ($saveFilter) $fld->CurrentFilter = $sql;
		}
	}

	// Get dropdown filter
	protected function getDropDownFilter(&$fld, $fldVal, $fldOpr)
	{
		$fldName = $fld->Name;
		$fldExpression = $fld->Expression;
		$fldDataType = $fld->DataType;
		$fldDelimiter = $fld->Delimiter;
		$fldVal = strval($fldVal);
		if ($fldOpr == "") $fldOpr = "=";
		$wrk = "";
		if (SameString($fldVal, NULL_VALUE)) {
			$wrk = $fldExpression . " IS NULL";
		} elseif (SameString($fldVal, NOT_NULL_VALUE)) {
			$wrk = $fldExpression . " IS NOT NULL";
		} elseif (SameString($fldVal, EMPTY_VALUE)) {
			$wrk = $fldExpression . " = ''";
		} elseif (SameString($fldVal, ALL_VALUE)) {
			$wrk = "1 = 1";
		} else {
			if (StartsString("@@", $fldVal)) {
				$wrk = $this->getCustomFilter($fld, $fldVal, $this->Dbid);
			} elseif ($fldDelimiter <> "" && trim($fldVal) <> "" && ($fldDataType == DATATYPE_STRING || $fldDataType == DATATYPE_MEMO)) {
				$wrk = GetMultiValueSearchSql($fldExpression, trim($fldVal), $this->Dbid);
			} else {
				if ($fldVal <> "" && $fldVal <> INIT_VALUE) {
					if ($fldDataType == DATATYPE_DATE && $fldOpr <> "") {
						$wrk = GetDateFilterSql($fldExpression, $fldOpr, $fldVal, $fldDataType, $this->Dbid);
					} else {
						$wrk = GetFilterSql($fldOpr, $fldVal, $fldDataType, $this->Dbid);
						if ($wrk <> "") $wrk = $fldExpression . $wrk;
					}
				}
			}
		}
		return $wrk;
	}

	// Get custom filter
	protected function getCustomFilter(&$fld, $fldVal, $dbid = 0)
	{
		$wrk = "";
		if (is_array($fld->AdvancedFilters)) {
			foreach ($fld->AdvancedFilters as $filter) {
				if ($filter->ID == $fldVal && $filter->Enabled) {
					$fldExpr = $fld->Expression;
					$fn = $filter->FunctionName;
					$wrkid = StartsString("@@", $filter->ID) ? substr($filter->ID, 2) : $filter->ID;
					if ($fn <> "") {
						$fn = PROJECT_NAMESPACE . $fn;
						$wrk = $fn($fldExpr, $dbid);
					} else
						$wrk = "";
					$this->Page_Filtering($fld, $wrk, "custom", $wrkid);
					break;
				}
			}
		}
		return $wrk;
	}

	// Build extended filter
	protected function buildExtendedFilter(&$fld, &$filterClause, $default = FALSE, $saveFilter = FALSE)
	{
		$wrk = GetExtendedFilter($fld, $default, $this->Dbid);
		if (!$default)
			$this->Page_Filtering($fld, $wrk, "extended", $fld->AdvancedSearch->SearchOperator, $fld->AdvancedSearch->SearchValue, $fld->AdvancedSearch->SearchCondition, $fld->AdvancedSearch->SearchOperator2, $fld->AdvancedSearch->SearchValue2);
		if ($wrk <> "") {
			AddFilter($filterClause, $wrk);
			if ($saveFilter) $fld->CurrentFilter = $wrk;
		}
	}

	// Get drop down value from querystring
	protected function getDropDownValue(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		if (IsPost())
			return FALSE; // Skip post back
		$opr = Get("z_$parm");
		if ($opr !== NULL)
			$fld->AdvancedSearch->SearchOperator = $opr;
		$val = Get("x_$parm");
		if ($val !== NULL) {
			if ($fld->isMultiSelect() && !is_array($val)) // Split values for modal lookup
				$fld->DropDownValue = explode(LOOKUP_FILTER_VALUE_SEPARATOR, $val);
			else
				$fld->DropDownValue = $val;
			return TRUE;
		}
		return FALSE;
	}

	// Get filter values from querystring
	protected function getFilterValues(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		if (IsPost())
			return; // Skip post back
		$got = FALSE;
		if (Get("x_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchValue = Get("x_$parm");
			$got = TRUE;
		}
		if (Get("z_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchOperator = Get("z_$parm");
			$got = TRUE;
		}
		if (Get("v_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchCondition = Get("v_$parm");
			$got = TRUE;
		}
		if (Get("y_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchValue2 = Get("y_$parm");
			$got = TRUE;
		}
		if (Get("w_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchOperator2 = Get("w_$parm");
			$got = TRUE;
		}
		return $got;
	}

	// Set default ext filter
	protected function setDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
	{
		$fld->AdvancedSearch->SearchValueDefault = $sv1; // Default ext filter value 1
		$fld->AdvancedSearch->SearchValue2Default = $sv2; // Default ext filter value 2 (if operator 2 is enabled)
		$fld->AdvancedSearch->SearchOperatorDefault = $so1; // Default search operator 1
		$fld->AdvancedSearch->SearchOperator2Default = $so2; // Default search operator 2 (if operator 2 is enabled)
		$fld->AdvancedSearch->SearchConditionDefault = $sc; // Default search condition (if operator 2 is enabled)
	}

	// Apply default ext filter
	protected function applyDefaultExtFilter(&$fld)
	{
		$fld->AdvancedSearch->SearchValue = $fld->AdvancedSearch->SearchValueDefault;
		$fld->AdvancedSearch->SearchValue2 = $fld->AdvancedSearch->SearchValue2Default;
		$fld->AdvancedSearch->SearchOperator = $fld->AdvancedSearch->SearchOperatorDefault;
		$fld->AdvancedSearch->SearchOperator2 = $fld->AdvancedSearch->SearchOperator2Default;
		$fld->AdvancedSearch->SearchCondition = $fld->AdvancedSearch->SearchConditionDefault;
	}

	// Check if Text Filter applied
	protected function textFilterApplied(&$fld)
	{
		return (strval($fld->AdvancedSearch->SearchValue) <> strval($fld->AdvancedSearch->SearchValueDefault) ||
			strval($fld->AdvancedSearch->SearchValue2) <> strval($fld->AdvancedSearch->SearchValue2Default) ||
			(strval($fld->AdvancedSearch->SearchValue) <> "" &&
				strval($fld->AdvancedSearch->SearchOperator) <> strval($fld->AdvancedSearch->SearchOperatorDefault)) ||
			(strval($fld->AdvancedSearch->SearchValue2) <> "" &&
				strval($fld->AdvancedSearch->SearchOperator2) <> strval($fld->AdvancedSearch->SearchOperator2Default)) ||
			strval($fld->AdvancedSearch->SearchCondition) <> strval($fld->AdvancedSearch->SearchConditionDefault));
	}

	// Check if Non-Text Filter applied
	protected function nonTextFilterApplied(&$fld)
	{
		if (is_array($fld->DropDownValue)) {
			if (is_array($fld->DefaultDropDownValue)) {
				if (count($fld->DefaultDropDownValue) <> count($fld->DropDownValue))
					return TRUE;
				else
					return (count(array_diff($fld->DefaultDropDownValue, $fld->DropDownValue)) <> 0);
			} else {
				return TRUE;
			}
		} else {
			if (is_array($fld->DefaultDropDownValue))
				return TRUE;
			else
				$v1 = strval($fld->DefaultDropDownValue);
			if ($v1 == INIT_VALUE)
				$v1 = "";
			$v2 = strval($fld->DropDownValue);
			if ($v2 == INIT_VALUE || $v2 == ALL_VALUE)
				$v2 = "";
			return ($v1 <> $v2);
		}
	}

	// Get dropdown value from session
	protected function getSessionDropDownValue(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		$this->getSessionValue($fld->DropDownValue, 'x_Kedatangan_Ubi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator, 'z_Kedatangan_Ubi_' . $parm);
	}

	// Get filter values from session
	protected function getSessionFilterValues(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		$this->getSessionValue($fld->AdvancedSearch->SearchValue, 'x_Kedatangan_Ubi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator, 'z_Kedatangan_Ubi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchCondition, 'v_Kedatangan_Ubi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchValue2, 'y_Kedatangan_Ubi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator2, 'w_Kedatangan_Ubi_' . $parm);
	}

	// Get value from session
	protected function getSessionValue(&$sv, $sn)
	{
		if (array_key_exists($sn, $_SESSION))
			$sv = $_SESSION[$sn];
	}

	// Set dropdown value to session
	protected function setSessionDropDownValue($sv, $so, $parm)
	{
		$_SESSION['x_Kedatangan_Ubi_' . $parm] = $sv;
		$_SESSION['z_Kedatangan_Ubi_' . $parm] = $so;
	}

	// Set filter values to session
	protected function setSessionFilterValues($sv1, $so1, $sc, $sv2, $so2, $parm)
	{
		$_SESSION['x_Kedatangan_Ubi_' . $parm] = $sv1;
		$_SESSION['z_Kedatangan_Ubi_' . $parm] = $so1;
		$_SESSION['v_Kedatangan_Ubi_' . $parm] = $sc;
		$_SESSION['y_Kedatangan_Ubi_' . $parm] = $sv2;
		$_SESSION['w_Kedatangan_Ubi_' . $parm] = $so2;
	}

	// Check if has session filter values
	protected function hasSessionFilterValues($parm)
	{
		return (@$_SESSION['x_' . $parm] <> "" && @$_SESSION['x_' . $parm] <> INIT_VALUE ||
			@$_SESSION['x_' . $parm] <> "" && @$_SESSION['x_' . $parm] <> INIT_VALUE ||
			@$_SESSION['y_' . $parm] <> "" && @$_SESSION['y_' . $parm] <> INIT_VALUE);
	}

	// Dropdown filter exist
	protected function dropDownFilterExist(&$fld, $fldOpr)
	{
		$wrk = "";
		$this->buildDropDownFilter($fld, $wrk, $fldOpr);
		return ($wrk <> "");
	}

	// Extended filter exist
	protected function extendedFilterExist(&$fld)
	{
		$extWrk = "";
		$this->buildExtendedFilter($fld, $extWrk);
		return ($extWrk <> "");
	}

	// Validate form
	protected function validateForm()
	{
		global $ReportLanguage, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			$FormError .= ($FormError <> "") ? "<p>&nbsp;</p>" : "";
			$FormError .= $formCustomError;
		}
		return $validateForm;
	}

	// Clear selection stored in session
	protected function clearSessionSelection($parm)
	{
		$_SESSION["sel_Kedatangan_Ubi_$parm"] = "";
		$_SESSION["rf_Kedatangan_Ubi_$parm"] = "";
		$_SESSION["rt_Kedatangan_Ubi_$parm"] = "";
	}

	// Load selection from session
	protected function loadSelectionFromSession($parm)
	{
		foreach ($this->fields as $fld) {
			if ($fld->Param == $parm) {
				$fld->SelectionList = @$_SESSION["sel_Kedatangan_Ubi_$parm"];
				$fld->RangeFrom = @$_SESSION["rf_Kedatangan_Ubi_$parm"];
				$fld->RangeTo = @$_SESSION["rt_Kedatangan_Ubi_$parm"];
				break;
			}
		}
	}

	// Load default value for filters
	protected function loadDefaultFilters()
	{

		/**
		* Set up default values for non Text filters
		*/
		// Field co_nama

		$this->co_nama->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->co_nama->DropDownValue = $this->co_nama->DefaultDropDownValue;

		// Field var_nama
		$this->var_nama->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->var_nama->DropDownValue = $this->var_nama->DefaultDropDownValue;

		// Field k_es_tgl_panen
		$this->k_es_tgl_panen->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->k_es_tgl_panen->DropDownValue = $this->k_es_tgl_panen->DefaultDropDownValue;

		// Field k_ak_tgl_datang
		$this->k_ak_tgl_datang->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->k_ak_tgl_datang->DropDownValue = $this->k_ak_tgl_datang->DefaultDropDownValue;

		/**
		* Set up default values for extended filters
		* function setDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
		* Parameters:
		* $fld - Field object
		* $so1 - Default search operator 1
		* $sv1 - Default ext filter value 1
		* $sc - Default search condition (if operator 2 is enabled)
		* $so2 - Default search operator 2 (if operator 2 is enabled)
		* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
		*/

		/**
		* Set up default values for popup filters
		*/
	}

	// Check if filter applied
	protected function checkFilter()
	{

		// Check co_nama extended filter
		if ($this->nonTextFilterApplied($this->co_nama))
			return TRUE;

		// Check var_nama extended filter
		if ($this->nonTextFilterApplied($this->var_nama))
			return TRUE;

		// Check k_es_tgl_panen extended filter
		if ($this->nonTextFilterApplied($this->k_es_tgl_panen))
			return TRUE;

		// Check k_ak_tgl_datang extended filter
		if ($this->nonTextFilterApplied($this->k_ak_tgl_datang))
			return TRUE;
		return FALSE;
	}

	// Show list of filters
	public function showFilterList($showDate = FALSE)
	{
		global $ReportLanguage;

		// Initialize
		$filterList = "";
		$captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
		$captionSuffix = $this->isExport("email") ? ": " : "";

		// Field co_nama
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->co_nama, $extWrk, $this->co_nama->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->co_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field var_nama
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->var_nama, $extWrk, $this->var_nama->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->var_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field k_es_tgl_panen
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->k_es_tgl_panen, $extWrk, $this->k_es_tgl_panen->DateFilter);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_es_tgl_panen->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field k_ak_tgl_datang
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->k_ak_tgl_datang, $extWrk, $this->k_ak_tgl_datang->DateFilter);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_ak_tgl_datang->caption() . "</span>" . $captionSuffix . $filter . "</div>";
		$divdataclass = "";

		// Show Filters
		if ($filterList <> "" || $showDate) {
			$message = "<div" . $divdataclass . "><div id=\"ew-filter-list\" class=\"alert alert-info d-table\">";
			if ($showDate)
				$message .= "<div id=\"ew-current-date\">" . $ReportLanguage->phrase("ReportGeneratedDate") . FormatDateTime(date("Y-m-d H:i:s"), 1) . "</div>";
			if ($filterList <> "")
				$message .= "<div id=\"ew-current-filters\">" . $ReportLanguage->phrase("CurrentFilters") . "</div>" . $filterList;
			$message .= "</div></div>";
			$this->Message_Showing($message, "");
			Write($message);
		}
	}

	// Get list of filters
	public function getFilterList()
	{

		// Initialize
		$filterList = "";

		// Field co_nama
		$wrk = "";
		$wrk = ($this->co_nama->DropDownValue <> INIT_VALUE) ? $this->co_nama->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_co_nama\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field var_nama
		$wrk = "";
		$wrk = ($this->var_nama->DropDownValue <> INIT_VALUE) ? $this->var_nama->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_var_nama\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field k_es_tgl_panen
		$wrk = "";
		$wrk = ($this->k_es_tgl_panen->DropDownValue <> INIT_VALUE) ? $this->k_es_tgl_panen->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_k_es_tgl_panen\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field k_ak_tgl_datang
		$wrk = "";
		$wrk = ($this->k_ak_tgl_datang->DropDownValue <> INIT_VALUE) ? $this->k_ak_tgl_datang->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_k_ak_tgl_datang\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Return filter list in json
		if ($filterList <> "")
			return "{\"data\":{" . $filterList . "}}";
		else
			return "null";
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd", "") <> "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter", ""), TRUE);
		return $this->setupFilterList($filter);
	}

	// Setup list of filters
	protected function setupFilterList($filter)
	{
		if (!is_array($filter))
			return FALSE;

		// Field co_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_co_nama", $filter)) {
			$wrk = $filter["x_co_nama"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_co_nama"], "co_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "co_nama");
		}

		// Field var_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_var_nama", $filter)) {
			$wrk = $filter["x_var_nama"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_var_nama"], "var_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "var_nama");
		}

		// Field k_es_tgl_panen
		$restoreFilter = FALSE;
		if (array_key_exists("x_k_es_tgl_panen", $filter)) {
			$wrk = $filter["x_k_es_tgl_panen"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_k_es_tgl_panen"], "k_es_tgl_panen");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "k_es_tgl_panen");
		}

		// Field k_ak_tgl_datang
		$restoreFilter = FALSE;
		if (array_key_exists("x_k_ak_tgl_datang", $filter)) {
			$wrk = $filter["x_k_ak_tgl_datang"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_k_ak_tgl_datang"], "k_ak_tgl_datang");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "k_ak_tgl_datang");
		}
		return TRUE;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Render lookup
					$this->RowType == ROWTYPE_VIEW;
					$fn = $fld->Lookup->RenderViewFunc;
					$render = method_exists($this, $fn);

					// Format the field values
					$fld->setDbValue($row[1]);
					if ($render) {
						$this->$fn();
						$row[1] = $fld->ViewValue;
						$row['df'] = $row[1];
					} elseif ($fld->isEncrypt()) {
						$row[1] = $fld->CurrentValue;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Return popup filter
	protected function getPopupFilter()
	{
		$wrk = "";
		if ($this->DrillDown)
			return "";
		return $wrk;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>