<?php
namespace PHPMaker2019\co;

/**
 * Table class for Kedatangan Dan Verifikasi
 */
class Kedatangan_Dan_Verifikasi extends ReportTable
{
	public $ShowGroupHeaderAsRow = FALSE;
	public $ShowCompactSummaryFooter = TRUE;
	public $datang_id;
	public $datang_tgl;
	public $datang_jumlah;
	public $ds_nama;
	public $datang_terpakai;
	public $var_nama;
	public $sup_nama;
	public $pet_nama;
	public $co_nama;
	public $k_id_kontrak;
	public $k_luas_lahan;
	public $k_es_tgl_panen;
	public $k_es_qty;
	public $ver_tgl;
	public $ver_presentasi_rijek;
	public $ver_hasil_id;
	public $ver_foto;
	public $qc_nama;
	public $ver_catatan;

	// Constructor
	public function __construct()
	{
		global $ReportLanguage, $CurrentLanguage;

		// Language object
		if (!isset($ReportLanguage))
			$ReportLanguage = new ReportLanguage();
		$this->TableVar = 'Kedatangan_Dan_Verifikasi';
		$this->TableName = 'Kedatangan Dan Verifikasi';
		$this->TableType = 'REPORT';
		$this->TableReportType = 'summary';
		$this->SourceTableIsCustomView = FALSE;
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0;

		// datang_id
		$this->datang_id = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_datang_id', 'datang_id', '`datang_id`', 3, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datang_id->Sortable = TRUE; // Allow sort
		$this->datang_id->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectInteger");
		$this->datang_id->DateFilter = "";
		$this->fields['datang_id'] = &$this->datang_id;

		// datang_tgl
		$this->datang_tgl = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_datang_tgl', 'datang_tgl', '`datang_tgl`', 135, 0, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datang_tgl->Sortable = TRUE; // Allow sort
		$this->datang_tgl->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $ReportLanguage->phrase("IncorrectDate"));
		$this->datang_tgl->DateFilter = "";
		RegisterFilter($this->datang_tgl, "@@Last30Days", $ReportLanguage->phrase("Last30Days"), "IsLast30Days");
		RegisterFilter($this->datang_tgl, "@@Last14Days", $ReportLanguage->phrase("Last14Days"), "IsLast14Days");
		RegisterFilter($this->datang_tgl, "@@Last7Days", $ReportLanguage->phrase("Last7Days"), "IsLast7Days");
		RegisterFilter($this->datang_tgl, "@@Next7Days", $ReportLanguage->phrase("Next7Days"), "IsNext7Days");
		RegisterFilter($this->datang_tgl, "@@Next14Days", $ReportLanguage->phrase("Next14Days"), "IsNext14Days");
		RegisterFilter($this->datang_tgl, "@@Next30Days", $ReportLanguage->phrase("Next30Days"), "IsNext30Days");
		RegisterFilter($this->datang_tgl, "@@LastMonth", $ReportLanguage->phrase("LastMonth"), "IsLastMonth");
		RegisterFilter($this->datang_tgl, "@@ThisMonth", $ReportLanguage->phrase("ThisMonth"), "IsThisMonth");
		RegisterFilter($this->datang_tgl, "@@NextMonth", $ReportLanguage->phrase("NextMonth"), "IsNextMonth");
		RegisterFilter($this->datang_tgl, "@@LastTwoWeeks", $ReportLanguage->phrase("LastTwoWeeks"), "IsLast2Weeks");
		RegisterFilter($this->datang_tgl, "@@LastWeek", $ReportLanguage->phrase("LastWeek"), "IsLastWeek");
		RegisterFilter($this->datang_tgl, "@@ThisWeek", $ReportLanguage->phrase("ThisWeek"), "IsThisWeek");
		RegisterFilter($this->datang_tgl, "@@NextWeek", $ReportLanguage->phrase("NextWeek"), "IsNextWeek");
		RegisterFilter($this->datang_tgl, "@@NextTwoWeeks", $ReportLanguage->phrase("NextTwoWeeks"), "IsNext2Weeks");
		RegisterFilter($this->datang_tgl, "@@LastYear", $ReportLanguage->phrase("LastYear"), "IsLastYear");
		RegisterFilter($this->datang_tgl, "@@ThisYear", $ReportLanguage->phrase("ThisYear"), "IsThisYear");
		RegisterFilter($this->datang_tgl, "@@NextYear", $ReportLanguage->phrase("NextYear"), "IsNextYear");
		$this->fields['datang_tgl'] = &$this->datang_tgl;

		// datang_jumlah
		$this->datang_jumlah = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_datang_jumlah', 'datang_jumlah', '`datang_jumlah`', 3, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datang_jumlah->Sortable = TRUE; // Allow sort
		$this->datang_jumlah->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectInteger");
		$this->datang_jumlah->DateFilter = "";
		$this->fields['datang_jumlah'] = &$this->datang_jumlah;

		// ds_nama
		$this->ds_nama = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_ds_nama', 'ds_nama', '`ds_nama`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ds_nama->Sortable = TRUE; // Allow sort
		$this->ds_nama->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ds_nama->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->ds_nama->DateFilter = "";
		$this->ds_nama->Lookup = new ReportLookup('ds_nama', 'Kedatangan_Dan_Verifikasi', TRUE, 'ds_nama', ["ds_nama","","",""], [], [], [], [], [], [], '`ds_nama` ASC', '');
		$this->ds_nama->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['ds_nama'] = &$this->ds_nama;

		// datang_terpakai
		$this->datang_terpakai = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_datang_terpakai', 'datang_terpakai', '`datang_terpakai`', 3, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datang_terpakai->Sortable = TRUE; // Allow sort
		$this->datang_terpakai->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectInteger");
		$this->datang_terpakai->DateFilter = "";
		$this->fields['datang_terpakai'] = &$this->datang_terpakai;

		// var_nama
		$this->var_nama = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_var_nama', 'var_nama', '`var_nama`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->var_nama->Sortable = TRUE; // Allow sort
		$this->var_nama->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->var_nama->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->var_nama->DateFilter = "";
		$this->var_nama->Lookup = new ReportLookup('var_nama', 'Kedatangan_Dan_Verifikasi', TRUE, 'var_nama', ["var_nama","","",""], [], [], [], [], [], [], '`var_nama` ASC', '');
		$this->var_nama->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['var_nama'] = &$this->var_nama;

		// sup_nama
		$this->sup_nama = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_sup_nama', 'sup_nama', '`sup_nama`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->sup_nama->Sortable = TRUE; // Allow sort
		$this->sup_nama->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->sup_nama->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->sup_nama->DateFilter = "";
		$this->sup_nama->Lookup = new ReportLookup('sup_nama', 'Kedatangan_Dan_Verifikasi', TRUE, 'sup_nama', ["sup_nama","","",""], [], [], [], [], [], [], '`sup_nama` ASC', '');
		$this->sup_nama->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['sup_nama'] = &$this->sup_nama;

		// pet_nama
		$this->pet_nama = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_pet_nama', 'pet_nama', '`pet_nama`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->pet_nama->Sortable = TRUE; // Allow sort
		$this->pet_nama->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->pet_nama->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->pet_nama->DateFilter = "";
		$this->pet_nama->Lookup = new ReportLookup('pet_nama', 'Kedatangan_Dan_Verifikasi', TRUE, 'pet_nama', ["pet_nama","","",""], [], [], [], [], [], [], '`pet_nama` ASC', '');
		$this->pet_nama->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['pet_nama'] = &$this->pet_nama;

		// co_nama
		$this->co_nama = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_co_nama', 'co_nama', '`co_nama`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->co_nama->Sortable = TRUE; // Allow sort
		$this->co_nama->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->co_nama->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->co_nama->DateFilter = "";
		$this->co_nama->Lookup = new ReportLookup('co_nama', 'Kedatangan_Dan_Verifikasi', TRUE, 'co_nama', ["co_nama","","",""], [], [], [], [], [], [], '`co_nama` ASC', '');
		$this->co_nama->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['co_nama'] = &$this->co_nama;

		// k_id_kontrak
		$this->k_id_kontrak = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_k_id_kontrak', 'k_id_kontrak', '`k_id_kontrak`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->k_id_kontrak->Sortable = TRUE; // Allow sort
		$this->k_id_kontrak->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->k_id_kontrak->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->k_id_kontrak->DateFilter = "";
		$this->k_id_kontrak->Lookup = new ReportLookup('k_id_kontrak', 'Kedatangan_Dan_Verifikasi', TRUE, 'k_id_kontrak', ["k_id_kontrak","","",""], [], [], [], [], [], [], '`k_id_kontrak` ASC', '');
		$this->k_id_kontrak->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['k_id_kontrak'] = &$this->k_id_kontrak;

		// k_luas_lahan
		$this->k_luas_lahan = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_k_luas_lahan', 'k_luas_lahan', '`k_luas_lahan`', 3, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->k_luas_lahan->Sortable = TRUE; // Allow sort
		$this->k_luas_lahan->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectInteger");
		$this->k_luas_lahan->DateFilter = "";
		$this->fields['k_luas_lahan'] = &$this->k_luas_lahan;

		// k_es_tgl_panen
		$this->k_es_tgl_panen = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_k_es_tgl_panen', 'k_es_tgl_panen', '`k_es_tgl_panen`', 133, 0, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->k_es_tgl_panen->Sortable = TRUE; // Allow sort
		$this->k_es_tgl_panen->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $ReportLanguage->phrase("IncorrectDate"));
		$this->k_es_tgl_panen->DateFilter = "";
		RegisterFilter($this->k_es_tgl_panen, "@@Last30Days", $ReportLanguage->phrase("Last30Days"), "IsLast30Days");
		RegisterFilter($this->k_es_tgl_panen, "@@Last14Days", $ReportLanguage->phrase("Last14Days"), "IsLast14Days");
		RegisterFilter($this->k_es_tgl_panen, "@@Last7Days", $ReportLanguage->phrase("Last7Days"), "IsLast7Days");
		RegisterFilter($this->k_es_tgl_panen, "@@Next7Days", $ReportLanguage->phrase("Next7Days"), "IsNext7Days");
		RegisterFilter($this->k_es_tgl_panen, "@@Next14Days", $ReportLanguage->phrase("Next14Days"), "IsNext14Days");
		RegisterFilter($this->k_es_tgl_panen, "@@Next30Days", $ReportLanguage->phrase("Next30Days"), "IsNext30Days");
		RegisterFilter($this->k_es_tgl_panen, "@@LastMonth", $ReportLanguage->phrase("LastMonth"), "IsLastMonth");
		RegisterFilter($this->k_es_tgl_panen, "@@ThisMonth", $ReportLanguage->phrase("ThisMonth"), "IsThisMonth");
		RegisterFilter($this->k_es_tgl_panen, "@@NextMonth", $ReportLanguage->phrase("NextMonth"), "IsNextMonth");
		RegisterFilter($this->k_es_tgl_panen, "@@LastTwoWeeks", $ReportLanguage->phrase("LastTwoWeeks"), "IsLast2Weeks");
		RegisterFilter($this->k_es_tgl_panen, "@@LastWeek", $ReportLanguage->phrase("LastWeek"), "IsLastWeek");
		RegisterFilter($this->k_es_tgl_panen, "@@ThisWeek", $ReportLanguage->phrase("ThisWeek"), "IsThisWeek");
		RegisterFilter($this->k_es_tgl_panen, "@@NextWeek", $ReportLanguage->phrase("NextWeek"), "IsNextWeek");
		RegisterFilter($this->k_es_tgl_panen, "@@NextTwoWeeks", $ReportLanguage->phrase("NextTwoWeeks"), "IsNext2Weeks");
		RegisterFilter($this->k_es_tgl_panen, "@@LastYear", $ReportLanguage->phrase("LastYear"), "IsLastYear");
		RegisterFilter($this->k_es_tgl_panen, "@@ThisYear", $ReportLanguage->phrase("ThisYear"), "IsThisYear");
		RegisterFilter($this->k_es_tgl_panen, "@@NextYear", $ReportLanguage->phrase("NextYear"), "IsNextYear");
		$this->fields['k_es_tgl_panen'] = &$this->k_es_tgl_panen;

		// k_es_qty
		$this->k_es_qty = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_k_es_qty', 'k_es_qty', '`k_es_qty`', 3, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->k_es_qty->Sortable = TRUE; // Allow sort
		$this->k_es_qty->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectInteger");
		$this->k_es_qty->DateFilter = "";
		$this->fields['k_es_qty'] = &$this->k_es_qty;

		// ver_tgl
		$this->ver_tgl = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_ver_tgl', 'ver_tgl', '`ver_tgl`', 135, 0, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ver_tgl->Sortable = TRUE; // Allow sort
		$this->ver_tgl->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $ReportLanguage->phrase("IncorrectDate"));
		$this->ver_tgl->DateFilter = "";
		$this->fields['ver_tgl'] = &$this->ver_tgl;

		// ver_presentasi_rijek
		$this->ver_presentasi_rijek = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_ver_presentasi_rijek', 'ver_presentasi_rijek', '`ver_presentasi_rijek`', 3, -1, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ver_presentasi_rijek->Sortable = TRUE; // Allow sort
		$this->ver_presentasi_rijek->DefaultErrorMessage = $ReportLanguage->phrase("IncorrectInteger");
		$this->ver_presentasi_rijek->DateFilter = "";
		$this->fields['ver_presentasi_rijek'] = &$this->ver_presentasi_rijek;

		// ver_hasil_id
		$this->ver_hasil_id = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_ver_hasil_id', 'ver_hasil_id', '`ver_hasil_id`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ver_hasil_id->Sortable = TRUE; // Allow sort
		$this->ver_hasil_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ver_hasil_id->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->ver_hasil_id->DateFilter = "";
		$this->ver_hasil_id->Lookup = new ReportLookup('ver_hasil_id', 'Kedatangan_Dan_Verifikasi', TRUE, 'ver_hasil_id', ["ver_hasil_id","","",""], [], [], [], [], [], [], '`ver_hasil_id` ASC', '');
		$this->ver_hasil_id->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['ver_hasil_id'] = &$this->ver_hasil_id;

		// ver_foto
		$this->ver_foto = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_ver_foto', 'ver_foto', '`ver_foto`', 200, -1, TRUE, 'IMAGE', 'TEXT');
		$this->ver_foto->Sortable = FALSE; // Allow sort
		$this->ver_foto->UploadPath = UPLOAD_DEST_PATH;
		$this->ver_foto->UploadMultiple = TRUE; // Always show as multiple
		$this->ver_foto->ImageResize = TRUE;
		$this->ver_foto->DateFilter = "";
		$this->fields['ver_foto'] = &$this->ver_foto;

		// qc_nama
		$this->qc_nama = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_qc_nama', 'qc_nama', '`qc_nama`', 200, -1, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->qc_nama->Sortable = TRUE; // Allow sort
		$this->qc_nama->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->qc_nama->PleaseSelectText = $ReportLanguage->phrase("PleaseSelect"); // PleaseSelect text
		$this->qc_nama->DateFilter = "";
		$this->qc_nama->Lookup = new ReportLookup('qc_nama', 'Kedatangan_Dan_Verifikasi', TRUE, 'qc_nama', ["qc_nama","","",""], [], [], [], [], [], [], '`qc_nama` ASC', '');
		$this->qc_nama->Lookup->RenderViewFunc = "renderLookup";
		$this->fields['qc_nama'] = &$this->qc_nama;

		// ver_catatan
		$this->ver_catatan = new ReportField('Kedatangan_Dan_Verifikasi', 'Kedatangan Dan Verifikasi', 'x_ver_catatan', 'ver_catatan', '`ver_catatan`', 201, -1, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->ver_catatan->Sortable = TRUE; // Allow sort
		$this->ver_catatan->DateFilter = "";
		$this->fields['ver_catatan'] = &$this->ver_catatan;
	}

	// Render for popup
	public function renderPopup()
	{
		global $ReportLanguage;
		if ($this->qc_nama->CurrentValue === NULL) // Handle null value
			$this->qc_nama->ViewValue = $ReportLanguage->phrase("NullLabel");
		elseif ($this->qc_nama->CurrentValue == "") // Handle empty value
			$this->qc_nama->ViewValue = $ReportLanguage->phrase("EmptyLabel");
		else
			$this->qc_nama->ViewValue = $this->qc_nama->CurrentValue;
	}

	// Render for lookup
	public function renderLookup()
	{
		$this->datang_tgl->ViewValue = $this->datang_tgl->CurrentValue;
		$this->ds_nama->ViewValue = GetDropDownDisplayValue($this->ds_nama->CurrentValue, "", 0);
		$this->var_nama->ViewValue = GetDropDownDisplayValue($this->var_nama->CurrentValue, "", 0);
		$this->sup_nama->ViewValue = GetDropDownDisplayValue($this->sup_nama->CurrentValue, "", 0);
		$this->pet_nama->ViewValue = GetDropDownDisplayValue($this->pet_nama->CurrentValue, "", 0);
		$this->co_nama->ViewValue = GetDropDownDisplayValue($this->co_nama->CurrentValue, "", 0);
		$this->k_id_kontrak->ViewValue = GetDropDownDisplayValue($this->k_id_kontrak->CurrentValue, "", 0);
		$this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
		$this->ver_tgl->ViewValue = $this->ver_tgl->CurrentValue;
		$this->ver_hasil_id->ViewValue = GetDropDownDisplayValue($this->ver_hasil_id->CurrentValue, "", 0);
		$this->qc_nama->ViewValue = GetDropDownDisplayValue($this->qc_nama->CurrentValue, "", 0);
	}

	// Get Field Visibility
	public function getFieldVisibility($fldparm)
	{
		global $Security;
		return $this->$fldparm->Visible; // Returns original value
	}

	// Single column sort
	protected function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($fld->GroupingFieldId == 0)
				$this->setDetailOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			if ($fld->GroupingFieldId == 0) $fld->setSort("");
		}
	}

	// Get Sort SQL
	protected function sortSql()
	{
		$dtlSortSql = $this->getDetailOrderBy(); // Get ORDER BY for detail fields from session
		$argrps = [];
		foreach ($this->fields as $fld) {
			if ($fld->getSort() <> "") {
				$fldsql = $fld->Expression;
				if ($fld->GroupingFieldId > 0) {
					if ($fld->GroupSql <> "")
						$argrps[$fld->GroupingFieldId] = str_replace("%s", $fldsql, $fld->GroupSql) . " " . $fld->getSort();
					else
						$argrps[$fld->GroupingFieldId] = $fldsql . " " . $fld->getSort();
				}
			}
		}
		$sortSql = "";
		foreach ($argrps as $grp) {
			if ($sortSql <> "") $sortSql .= ", ";
			$sortSql .= $grp;
		}
		if ($dtlSortSql <> "") {
			if ($sortSql <> "") $sortSql .= ", ";
			$sortSql .= $dtlSortSql;
		}
		return $sortSql;
	}

	// Table level SQL
	private $_sqlFrom = "";
	private $_sqlSelect = "";
	private $_sqlWhere = "";
	private $_sqlGroupBy = "";
	private $_sqlHaving = "";
	private $_sqlOrderBy = "";

	// From
	public function getSqlFrom()
	{
		return ($this->_sqlFrom <> "") ? $this->_sqlFrom : "`view_datang`";
	}
	public function setSqlFrom($v)
	{
		$this->_sqlFrom = $v;
	}

	// Select
	public function getSqlSelect()
	{
		return ($this->_sqlSelect <> "") ? $this->_sqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function setSqlSelect($v)
	{
		$this->_sqlSelect = $v;
	}

	// Where
	public function getSqlWhere()
	{
		$where = ($this->_sqlWhere <> "") ? $this->_sqlWhere : "";
		$filter = "";
		AddFilter($where, $filter);
		return $where;
	}
	public function setSqlWhere($v)
	{
		$this->_sqlWhere = $v;
	}

	// Group By
	public function getSqlGroupBy()
	{
		return ($this->_sqlGroupBy <> "") ? $this->_sqlGroupBy : "";
	}
	public function setSqlGroupBy($v)
	{
		$this->_sqlGroupBy = $v;
	}

	// Having
	public function getSqlHaving()
	{
		return ($this->_sqlHaving <> "") ? $this->_sqlHaving : "";
	}
	public function setSqlHaving($v)
	{
		$this->_sqlHaving = $v;
	}

	// Order By
	public function getSqlOrderBy()
	{
		return ($this->_sqlOrderBy <> "") ? $this->_sqlOrderBy : "";
	}
	public function setSqlOrderBy($v)
	{
		$this->_sqlOrderBy = $v;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table Level Group SQL
	private $_sqlFirstGroupField = "";
	private $_sqlSelectGroup = "";
	private $_sqlOrderByGroup = "";

	// First Group Field
	public function getSqlFirstGroupField()
	{
		return ($this->_sqlFirstGroupField <> "") ? $this->_sqlFirstGroupField : "";
	}
	public function setSqlFirstGroupField($v)
	{
		$this->_sqlFirstGroupField = $v;
	}

	// Select Group
	public function getSqlSelectGroup()
	{
		return ($this->_sqlSelectGroup <> "") ? $this->_sqlSelectGroup : "SELECT DISTINCT " . $this->getSqlFirstGroupField() . " FROM " . $this->getSqlFrom();
	}
	public function setSqlSelectGroup($v)
	{
		$this->_sqlSelectGroup = $v;
	}

	// Order By Group
	public function getSqlOrderByGroup()
	{
		return ($this->_sqlOrderByGroup <> "") ? $this->_sqlOrderByGroup : "";
	}
	public function setSqlOrderByGroup($v)
	{
		$this->_sqlOrderByGroup = $v;
	}

	// Summary properties
	private $_sqlSelectAggregate = "";
	private $_sqlAggregatePrefix = "";
	private $_sqlAggregateSuffix = "";
	private $_sqlSelectCount = "";

	// Select Aggregate
	public function getSqlSelectAggregate()
	{
		return ($this->_sqlSelectAggregate <> "") ? $this->_sqlSelectAggregate : "SELECT SUM(`datang_jumlah`) AS `sum_datang_jumlah`, SUM(`datang_terpakai`) AS `sum_datang_terpakai`, SUM(`ver_presentasi_rijek`) AS `sum_ver_presentasi_rijek` FROM " . $this->getSqlFrom();
	}
	public function setSqlSelectAggregate($v)
	{
		$this->_sqlSelectAggregate = $v;
	}

	// Aggregate Prefix
	public function getSqlAggregatePrefix()
	{
		return ($this->_sqlAggregatePrefix <> "") ? $this->_sqlAggregatePrefix : "";
	}
	public function setSqlAggregatePrefix($v)
	{
		$this->_sqlAggregatePrefix = $v;
	}

	// Aggregate Suffix
	public function getSqlAggregateSuffix()
	{
		return ($this->_sqlAggregateSuffix <> "") ? $this->_sqlAggregateSuffix : "";
	}
	public function setSqlAggregateSuffix($v)
	{
		$this->_sqlAggregateSuffix = $v;
	}

	// Select Count
	public function getSqlSelectCount()
	{
		return ($this->_sqlSelectCount <> "") ? $this->_sqlSelectCount : "SELECT COUNT(*) FROM " . $this->getSqlFrom();
	}
	public function setSqlSelectCount($v)
	{
		$this->_sqlSelectCount = $v;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = '';
		return $rs;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		global $DashboardReport;
		return "";
	}

	// Lookup data from table
	public function lookup()
	{
		global $Security, $RequestSecurity, $PROJECT_ID, $RELATED_PROJECT_ID;
		$projectId = $RELATED_PROJECT_ID;

		// Check token first
		$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($projectId . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($projectId . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));

		// Create lookup object and output JSON
		$lookup = new ReportLookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if (Post("keys") !== NULL) { // Selected records from modal
			$keys = Post("keys");
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'ver_foto') {
			$fldName = "ver_foto";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up filter (WHERE clause)
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		$filter = "";
		if (count($ar) == 1) {
			$this->datang_id->CurrentValue = $ar[0];
			if ($filter <> "") $filter .= " AND ";
			$filter .= "`datang_id` = " . QuotedValue($this->datang_id->CurrentValue, DATATYPE_NUMBER, $this->Dbid);
		} else {
			return FALSE; // Incorrect key
		}
		$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), "", "", "", $filter, "");
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear any debug message
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Page Selecting event
	function Page_Selecting(&$filter) {

		// Enter your code here
	}

	// Page Breaking event
	function Page_Breaking(&$break, &$content) {

		// Example:
		//$break = FALSE; // Skip page break, or
		//$content = "<div style=\"page-break-after:always;\">&nbsp;</div>"; // Modify page break content

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Cell Rendered event
	function Cell_Rendered(&$Field, $CurrentValue, &$ViewValue, &$ViewAttrs, &$CellAttrs, &$HrefValue, &$LinkAttrs) {

		//$ViewValue = "xxx";
		//$ViewAttrs["class"] = "xxx";

	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}

	// Load Filters event
	function Page_FilterLoad() {

		// Enter your code here
		// Example: Register/Unregister Custom Extended Filter
		//RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A', PROJECT_NAMESPACE . 'GetStartsWithAFilter'); // With function, or
		//RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A'); // No function, use Page_Filtering event
		//UnregisterFilter($this-><Field>, 'StartsWithA');

	}

	// Page Filter Validated event
	function Page_FilterValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Page Filtering event
	function Page_Filtering(&$fld, &$filter, $typ, $opr = "", $val = "", $cond = "", $opr2 = "", $val2 = "") {

		// Note: ALWAYS CHECK THE FILTER TYPE ($typ)! Example:
		//if ($typ == "dropdown" && $fld->Name == "MyField") // Dropdown filter
		//	$filter = "..."; // Modify the filter
		//if ($typ == "extended" && $fld->Name == "MyField") // Extended filter
		//	$filter = "..."; // Modify the filter
		//if ($typ == "popup" && $fld->Name == "MyField") // Popup filter
		//	$filter = "..."; // Modify the filter
		//if ($typ == "custom" && $opr == "..." && $fld->Name == "MyField") // Custom filter, $opr is the custom filter ID
		//	$filter = "..."; // Modify the filter

	}

	// Email Sending event
	function Email_Sending(&$email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		// Enter your code here
	}
}
?>