<?php

namespace PHPMaker2023\co;

// Page object
$SosialisasiList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { sosialisasi: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fsosialisasisrch" id="fsosialisasisrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="on">
<div id="fsosialisasisrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { sosialisasi: currentTable } });
var currentForm;
var fsosialisasisrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fsosialisasisrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["sos_id", [], fields.sos_id.isInvalid],
            ["sos_tgl", [ew.Validators.datetime(fields.sos_tgl.clientFormatPattern)], fields.sos_tgl.isInvalid],
            ["y_sos_tgl", [ew.Validators.between], false],
            ["ts_id", [], fields.ts_id.isInvalid],
            ["sos_co", [], fields.sos_co.isInvalid],
            ["sos_peserta", [], fields.sos_peserta.isInvalid],
            ["sos_prov", [], fields.sos_prov.isInvalid],
            ["sos_kab", [], fields.sos_kab.isInvalid],
            ["sos_kec", [], fields.sos_kec.isInvalid],
            ["sos_desa", [], fields.sos_desa.isInvalid],
            ["sos_alamat", [], fields.sos_alamat.isInvalid],
            ["sos_pot_lahan", [], fields.sos_pot_lahan.isInvalid],
            ["sos_katinggian", [], fields.sos_katinggian.isInvalid],
            ["sos_biaya", [], fields.sos_biaya.isInvalid],
            ["sos_kesimpulan", [], fields.sos_kesimpulan.isInvalid],
            ["sos_foto", [], fields.sos_foto.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "sos_co": <?= $Page->sos_co->toClientList($Page) ?>,
            "sos_prov": <?= $Page->sos_prov->toClientList($Page) ?>,
            "sos_kab": <?= $Page->sos_kab->toClientList($Page) ?>,
            "sos_kec": <?= $Page->sos_kec->toClientList($Page) ?>,
            "sos_desa": <?= $Page->sos_desa->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->sos_tgl->Visible) { // sos_tgl ?>
<?php
if (!$Page->sos_tgl->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_sos_tgl" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->sos_tgl->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_sos_tgl" class="ew-search-caption ew-label"><?= $Page->sos_tgl->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_sos_tgl" id="z_sos_tgl" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->sos_tgl->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->sos_tgl->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_sosialisasi_sos_tgl" class="ew-search-field">
<input type="<?= $Page->sos_tgl->getInputTextType() ?>" name="x_sos_tgl" id="x_sos_tgl" data-table="sosialisasi" data-field="x_sos_tgl" value="<?= $Page->sos_tgl->EditValue ?>" placeholder="<?= HtmlEncode($Page->sos_tgl->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sos_tgl->formatPattern()) ?>"<?= $Page->sos_tgl->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sos_tgl->getErrorMessage(false) ?></div>
<?php if (!$Page->sos_tgl->ReadOnly && !$Page->sos_tgl->Disabled && !isset($Page->sos_tgl->EditAttrs["readonly"]) && !isset($Page->sos_tgl->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsosialisasisrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fsosialisasisrch", "x_sos_tgl", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_sosialisasi_sos_tgl" class="ew-search-field2 d-none">
<input type="<?= $Page->sos_tgl->getInputTextType() ?>" name="y_sos_tgl" id="y_sos_tgl" data-table="sosialisasi" data-field="x_sos_tgl" value="<?= $Page->sos_tgl->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->sos_tgl->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sos_tgl->formatPattern()) ?>"<?= $Page->sos_tgl->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sos_tgl->getErrorMessage(false) ?></div>
<?php if (!$Page->sos_tgl->ReadOnly && !$Page->sos_tgl->Disabled && !isset($Page->sos_tgl->EditAttrs["readonly"]) && !isset($Page->sos_tgl->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsosialisasisrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fsosialisasisrch", "y_sos_tgl", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->sos_co->Visible) { // sos_co ?>
<?php
if (!$Page->sos_co->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_sos_co" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->sos_co->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_sos_co" class="ew-search-caption ew-label"><?= $Page->sos_co->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sos_co" id="z_sos_co" value="=">
</div>
        </div>
        <div id="el_sosialisasi_sos_co" class="ew-search-field">
    <select
        id="x_sos_co"
        name="x_sos_co"
        class="form-select ew-select<?= $Page->sos_co->isInvalidClass() ?>"
        <?php if (!$Page->sos_co->IsNativeSelect) { ?>
        data-select2-id="fsosialisasisrch_x_sos_co"
        <?php } ?>
        data-table="sosialisasi"
        data-field="x_sos_co"
        data-value-separator="<?= $Page->sos_co->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sos_co->getPlaceHolder()) ?>"
        <?= $Page->sos_co->editAttributes() ?>>
        <?= $Page->sos_co->selectOptionListHtml("x_sos_co") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sos_co->getErrorMessage(false) ?></div>
<?= $Page->sos_co->Lookup->getParamTag($Page, "p_x_sos_co") ?>
<?php if (!$Page->sos_co->IsNativeSelect) { ?>
<script>
loadjs.ready("fsosialisasisrch", function() {
    var options = { name: "x_sos_co", selectId: "fsosialisasisrch_x_sos_co" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsosialisasisrch.lists.sos_co?.lookupOptions.length) {
        options.data = { id: "x_sos_co", form: "fsosialisasisrch" };
    } else {
        options.ajax = { id: "x_sos_co", form: "fsosialisasisrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sosialisasi.fields.sos_co.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->sos_prov->Visible) { // sos_prov ?>
<?php
if (!$Page->sos_prov->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_sos_prov" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->sos_prov->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_sos_prov" class="ew-search-caption ew-label"><?= $Page->sos_prov->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sos_prov" id="z_sos_prov" value="=">
</div>
        </div>
        <div id="el_sosialisasi_sos_prov" class="ew-search-field">
    <select
        id="x_sos_prov"
        name="x_sos_prov"
        class="form-select ew-select<?= $Page->sos_prov->isInvalidClass() ?>"
        <?php if (!$Page->sos_prov->IsNativeSelect) { ?>
        data-select2-id="fsosialisasisrch_x_sos_prov"
        <?php } ?>
        data-table="sosialisasi"
        data-field="x_sos_prov"
        data-value-separator="<?= $Page->sos_prov->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sos_prov->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->sos_prov->editAttributes() ?>>
        <?= $Page->sos_prov->selectOptionListHtml("x_sos_prov") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sos_prov->getErrorMessage(false) ?></div>
<?= $Page->sos_prov->Lookup->getParamTag($Page, "p_x_sos_prov") ?>
<?php if (!$Page->sos_prov->IsNativeSelect) { ?>
<script>
loadjs.ready("fsosialisasisrch", function() {
    var options = { name: "x_sos_prov", selectId: "fsosialisasisrch_x_sos_prov" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsosialisasisrch.lists.sos_prov?.lookupOptions.length) {
        options.data = { id: "x_sos_prov", form: "fsosialisasisrch" };
    } else {
        options.ajax = { id: "x_sos_prov", form: "fsosialisasisrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sosialisasi.fields.sos_prov.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->sos_kab->Visible) { // sos_kab ?>
<?php
if (!$Page->sos_kab->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_sos_kab" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->sos_kab->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_sos_kab" class="ew-search-caption ew-label"><?= $Page->sos_kab->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sos_kab" id="z_sos_kab" value="=">
</div>
        </div>
        <div id="el_sosialisasi_sos_kab" class="ew-search-field">
    <select
        id="x_sos_kab"
        name="x_sos_kab"
        class="form-select ew-select<?= $Page->sos_kab->isInvalidClass() ?>"
        <?php if (!$Page->sos_kab->IsNativeSelect) { ?>
        data-select2-id="fsosialisasisrch_x_sos_kab"
        <?php } ?>
        data-table="sosialisasi"
        data-field="x_sos_kab"
        data-value-separator="<?= $Page->sos_kab->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sos_kab->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->sos_kab->editAttributes() ?>>
        <?= $Page->sos_kab->selectOptionListHtml("x_sos_kab") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sos_kab->getErrorMessage(false) ?></div>
<?= $Page->sos_kab->Lookup->getParamTag($Page, "p_x_sos_kab") ?>
<?php if (!$Page->sos_kab->IsNativeSelect) { ?>
<script>
loadjs.ready("fsosialisasisrch", function() {
    var options = { name: "x_sos_kab", selectId: "fsosialisasisrch_x_sos_kab" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsosialisasisrch.lists.sos_kab?.lookupOptions.length) {
        options.data = { id: "x_sos_kab", form: "fsosialisasisrch" };
    } else {
        options.ajax = { id: "x_sos_kab", form: "fsosialisasisrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sosialisasi.fields.sos_kab.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->sos_kec->Visible) { // sos_kec ?>
<?php
if (!$Page->sos_kec->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_sos_kec" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->sos_kec->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_sos_kec" class="ew-search-caption ew-label"><?= $Page->sos_kec->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sos_kec" id="z_sos_kec" value="=">
</div>
        </div>
        <div id="el_sosialisasi_sos_kec" class="ew-search-field">
    <select
        id="x_sos_kec"
        name="x_sos_kec"
        class="form-select ew-select<?= $Page->sos_kec->isInvalidClass() ?>"
        <?php if (!$Page->sos_kec->IsNativeSelect) { ?>
        data-select2-id="fsosialisasisrch_x_sos_kec"
        <?php } ?>
        data-table="sosialisasi"
        data-field="x_sos_kec"
        data-value-separator="<?= $Page->sos_kec->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sos_kec->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->sos_kec->editAttributes() ?>>
        <?= $Page->sos_kec->selectOptionListHtml("x_sos_kec") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sos_kec->getErrorMessage(false) ?></div>
<?= $Page->sos_kec->Lookup->getParamTag($Page, "p_x_sos_kec") ?>
<?php if (!$Page->sos_kec->IsNativeSelect) { ?>
<script>
loadjs.ready("fsosialisasisrch", function() {
    var options = { name: "x_sos_kec", selectId: "fsosialisasisrch_x_sos_kec" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsosialisasisrch.lists.sos_kec?.lookupOptions.length) {
        options.data = { id: "x_sos_kec", form: "fsosialisasisrch" };
    } else {
        options.ajax = { id: "x_sos_kec", form: "fsosialisasisrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sosialisasi.fields.sos_kec.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->sos_desa->Visible) { // sos_desa ?>
<?php
if (!$Page->sos_desa->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_sos_desa" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->sos_desa->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_sos_desa" class="ew-search-caption ew-label"><?= $Page->sos_desa->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sos_desa" id="z_sos_desa" value="=">
</div>
        </div>
        <div id="el_sosialisasi_sos_desa" class="ew-search-field">
    <select
        id="x_sos_desa"
        name="x_sos_desa"
        class="form-select ew-select<?= $Page->sos_desa->isInvalidClass() ?>"
        <?php if (!$Page->sos_desa->IsNativeSelect) { ?>
        data-select2-id="fsosialisasisrch_x_sos_desa"
        <?php } ?>
        data-table="sosialisasi"
        data-field="x_sos_desa"
        data-value-separator="<?= $Page->sos_desa->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sos_desa->getPlaceHolder()) ?>"
        <?= $Page->sos_desa->editAttributes() ?>>
        <?= $Page->sos_desa->selectOptionListHtml("x_sos_desa") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sos_desa->getErrorMessage(false) ?></div>
<?= $Page->sos_desa->Lookup->getParamTag($Page, "p_x_sos_desa") ?>
<?php if (!$Page->sos_desa->IsNativeSelect) { ?>
<script>
loadjs.ready("fsosialisasisrch", function() {
    var options = { name: "x_sos_desa", selectId: "fsosialisasisrch_x_sos_desa" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsosialisasisrch.lists.sos_desa?.lookupOptions.length) {
        options.data = { id: "x_sos_desa", form: "fsosialisasisrch" };
    } else {
        options.ajax = { id: "x_sos_desa", form: "fsosialisasisrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sosialisasi.fields.sos_desa.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fsosialisasisrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fsosialisasisrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fsosialisasisrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fsosialisasisrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="on">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="sosialisasi">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_sosialisasi" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_sosialisasilist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = ROWTYPE_HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->sos_id->Visible) { // sos_id ?>
        <th data-name="sos_id" class="<?= $Page->sos_id->headerCellClass() ?>"><div id="elh_sosialisasi_sos_id" class="sosialisasi_sos_id"><?= $Page->renderFieldHeader($Page->sos_id) ?></div></th>
<?php } ?>
<?php if ($Page->sos_tgl->Visible) { // sos_tgl ?>
        <th data-name="sos_tgl" class="<?= $Page->sos_tgl->headerCellClass() ?>"><div id="elh_sosialisasi_sos_tgl" class="sosialisasi_sos_tgl"><?= $Page->renderFieldHeader($Page->sos_tgl) ?></div></th>
<?php } ?>
<?php if ($Page->ts_id->Visible) { // ts_id ?>
        <th data-name="ts_id" class="<?= $Page->ts_id->headerCellClass() ?>"><div id="elh_sosialisasi_ts_id" class="sosialisasi_ts_id"><?= $Page->renderFieldHeader($Page->ts_id) ?></div></th>
<?php } ?>
<?php if ($Page->sos_co->Visible) { // sos_co ?>
        <th data-name="sos_co" class="<?= $Page->sos_co->headerCellClass() ?>"><div id="elh_sosialisasi_sos_co" class="sosialisasi_sos_co"><?= $Page->renderFieldHeader($Page->sos_co) ?></div></th>
<?php } ?>
<?php if ($Page->sos_peserta->Visible) { // sos_peserta ?>
        <th data-name="sos_peserta" class="<?= $Page->sos_peserta->headerCellClass() ?>"><div id="elh_sosialisasi_sos_peserta" class="sosialisasi_sos_peserta"><?= $Page->renderFieldHeader($Page->sos_peserta) ?></div></th>
<?php } ?>
<?php if ($Page->sos_prov->Visible) { // sos_prov ?>
        <th data-name="sos_prov" class="<?= $Page->sos_prov->headerCellClass() ?>"><div id="elh_sosialisasi_sos_prov" class="sosialisasi_sos_prov"><?= $Page->renderFieldHeader($Page->sos_prov) ?></div></th>
<?php } ?>
<?php if ($Page->sos_kab->Visible) { // sos_kab ?>
        <th data-name="sos_kab" class="<?= $Page->sos_kab->headerCellClass() ?>"><div id="elh_sosialisasi_sos_kab" class="sosialisasi_sos_kab"><?= $Page->renderFieldHeader($Page->sos_kab) ?></div></th>
<?php } ?>
<?php if ($Page->sos_kec->Visible) { // sos_kec ?>
        <th data-name="sos_kec" class="<?= $Page->sos_kec->headerCellClass() ?>"><div id="elh_sosialisasi_sos_kec" class="sosialisasi_sos_kec"><?= $Page->renderFieldHeader($Page->sos_kec) ?></div></th>
<?php } ?>
<?php if ($Page->sos_desa->Visible) { // sos_desa ?>
        <th data-name="sos_desa" class="<?= $Page->sos_desa->headerCellClass() ?>"><div id="elh_sosialisasi_sos_desa" class="sosialisasi_sos_desa"><?= $Page->renderFieldHeader($Page->sos_desa) ?></div></th>
<?php } ?>
<?php if ($Page->sos_alamat->Visible) { // sos_alamat ?>
        <th data-name="sos_alamat" class="<?= $Page->sos_alamat->headerCellClass() ?>"><div id="elh_sosialisasi_sos_alamat" class="sosialisasi_sos_alamat"><?= $Page->renderFieldHeader($Page->sos_alamat) ?></div></th>
<?php } ?>
<?php if ($Page->sos_pot_lahan->Visible) { // sos_pot_lahan ?>
        <th data-name="sos_pot_lahan" class="<?= $Page->sos_pot_lahan->headerCellClass() ?>"><div id="elh_sosialisasi_sos_pot_lahan" class="sosialisasi_sos_pot_lahan"><?= $Page->renderFieldHeader($Page->sos_pot_lahan) ?></div></th>
<?php } ?>
<?php if ($Page->sos_katinggian->Visible) { // sos_katinggian ?>
        <th data-name="sos_katinggian" class="<?= $Page->sos_katinggian->headerCellClass() ?>"><div id="elh_sosialisasi_sos_katinggian" class="sosialisasi_sos_katinggian"><?= $Page->renderFieldHeader($Page->sos_katinggian) ?></div></th>
<?php } ?>
<?php if ($Page->sos_biaya->Visible) { // sos_biaya ?>
        <th data-name="sos_biaya" class="<?= $Page->sos_biaya->headerCellClass() ?>"><div id="elh_sosialisasi_sos_biaya" class="sosialisasi_sos_biaya"><?= $Page->renderFieldHeader($Page->sos_biaya) ?></div></th>
<?php } ?>
<?php if ($Page->sos_kesimpulan->Visible) { // sos_kesimpulan ?>
        <th data-name="sos_kesimpulan" class="<?= $Page->sos_kesimpulan->headerCellClass() ?>"><div id="elh_sosialisasi_sos_kesimpulan" class="sosialisasi_sos_kesimpulan"><?= $Page->renderFieldHeader($Page->sos_kesimpulan) ?></div></th>
<?php } ?>
<?php if ($Page->sos_foto->Visible) { // sos_foto ?>
        <th data-name="sos_foto" class="<?= $Page->sos_foto->headerCellClass() ?>"><div id="elh_sosialisasi_sos_foto" class="sosialisasi_sos_foto"><?= $Page->renderFieldHeader($Page->sos_foto) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->sos_id->Visible) { // sos_id ?>
        <td data-name="sos_id"<?= $Page->sos_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_id" class="el_sosialisasi_sos_id">
<span<?= $Page->sos_id->viewAttributes() ?>>
<?= $Page->sos_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_tgl->Visible) { // sos_tgl ?>
        <td data-name="sos_tgl"<?= $Page->sos_tgl->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_tgl" class="el_sosialisasi_sos_tgl">
<span<?= $Page->sos_tgl->viewAttributes() ?>>
<?= $Page->sos_tgl->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ts_id->Visible) { // ts_id ?>
        <td data-name="ts_id"<?= $Page->ts_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_ts_id" class="el_sosialisasi_ts_id">
<span<?= $Page->ts_id->viewAttributes() ?>>
<?= $Page->ts_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_co->Visible) { // sos_co ?>
        <td data-name="sos_co"<?= $Page->sos_co->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_co" class="el_sosialisasi_sos_co">
<span<?= $Page->sos_co->viewAttributes() ?>>
<?= $Page->sos_co->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_peserta->Visible) { // sos_peserta ?>
        <td data-name="sos_peserta"<?= $Page->sos_peserta->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_peserta" class="el_sosialisasi_sos_peserta">
<span<?= $Page->sos_peserta->viewAttributes() ?>>
<?= $Page->sos_peserta->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_prov->Visible) { // sos_prov ?>
        <td data-name="sos_prov"<?= $Page->sos_prov->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_prov" class="el_sosialisasi_sos_prov">
<span<?= $Page->sos_prov->viewAttributes() ?>>
<?= $Page->sos_prov->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_kab->Visible) { // sos_kab ?>
        <td data-name="sos_kab"<?= $Page->sos_kab->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_kab" class="el_sosialisasi_sos_kab">
<span<?= $Page->sos_kab->viewAttributes() ?>>
<?= $Page->sos_kab->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_kec->Visible) { // sos_kec ?>
        <td data-name="sos_kec"<?= $Page->sos_kec->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_kec" class="el_sosialisasi_sos_kec">
<span<?= $Page->sos_kec->viewAttributes() ?>>
<?= $Page->sos_kec->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_desa->Visible) { // sos_desa ?>
        <td data-name="sos_desa"<?= $Page->sos_desa->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_desa" class="el_sosialisasi_sos_desa">
<span<?= $Page->sos_desa->viewAttributes() ?>>
<?= $Page->sos_desa->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_alamat->Visible) { // sos_alamat ?>
        <td data-name="sos_alamat"<?= $Page->sos_alamat->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_alamat" class="el_sosialisasi_sos_alamat">
<span<?= $Page->sos_alamat->viewAttributes() ?>>
<?= $Page->sos_alamat->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_pot_lahan->Visible) { // sos_pot_lahan ?>
        <td data-name="sos_pot_lahan"<?= $Page->sos_pot_lahan->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_pot_lahan" class="el_sosialisasi_sos_pot_lahan">
<span<?= $Page->sos_pot_lahan->viewAttributes() ?>>
<?= $Page->sos_pot_lahan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_katinggian->Visible) { // sos_katinggian ?>
        <td data-name="sos_katinggian"<?= $Page->sos_katinggian->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_katinggian" class="el_sosialisasi_sos_katinggian">
<span<?= $Page->sos_katinggian->viewAttributes() ?>>
<?= $Page->sos_katinggian->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_biaya->Visible) { // sos_biaya ?>
        <td data-name="sos_biaya"<?= $Page->sos_biaya->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_biaya" class="el_sosialisasi_sos_biaya">
<span<?= $Page->sos_biaya->viewAttributes() ?>>
<?= $Page->sos_biaya->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_kesimpulan->Visible) { // sos_kesimpulan ?>
        <td data-name="sos_kesimpulan"<?= $Page->sos_kesimpulan->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_kesimpulan" class="el_sosialisasi_sos_kesimpulan">
<span<?= $Page->sos_kesimpulan->viewAttributes() ?>>
<?= $Page->sos_kesimpulan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sos_foto->Visible) { // sos_foto ?>
        <td data-name="sos_foto"<?= $Page->sos_foto->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_sosialisasi_sos_foto" class="el_sosialisasi_sos_foto">
<span>
<?= GetFileViewTag($Page->sos_foto, $Page->sos_foto->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }
    if (
        $Page->Recordset &&
        !$Page->Recordset->EOF &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->Recordset->moveNext();
    }
    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Page->Recordset) {
    $Page->Recordset->close();
}
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("sosialisasi");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
