<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class KontrakKoordAdd extends KontrakKoord
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "KontrakKoordAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "KontrakKoordAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->kk_id->Visible = false;
        $this->kk_no_kontrak->setVisibility();
        $this->koord_id->setVisibility();
        $this->kk_tgl_mulai->setVisibility();
        $this->kk_tgl_akhir->setVisibility();
        $this->kk_periode->setVisibility();
        $this->var_id->setVisibility();
        $this->kk_harga->setVisibility();
        $this->kk_luas->setVisibility();
        $this->kk_dok->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'kontrak_koord';
        $this->TableName = 'kontrak_koord';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (kontrak_koord)
        if (!isset($GLOBALS["kontrak_koord"]) || get_class($GLOBALS["kontrak_koord"]) == PROJECT_NAMESPACE . "kontrak_koord") {
            $GLOBALS["kontrak_koord"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'kontrak_koord');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "KontrakKoordView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->kk_dok->OldUploadPath = $this->kk_dok->getUploadPath(); // PHP
                $this->kk_dok->UploadPath = $this->kk_dok->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['kk_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->kk_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->koord_id);
        $this->setupLookupOptions($this->var_id);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("kk_id") ?? Route("kk_id")) !== null) {
                $this->kk_id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("KontrakKoordList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "KontrakKoordList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "KontrakKoordView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "KontrakKoordList") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "KontrakKoordList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->kk_dok->Upload->Index = $CurrentForm->Index;
        $this->kk_dok->Upload->uploadFile();
        $this->kk_dok->CurrentValue = $this->kk_dok->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'kk_no_kontrak' first before field var 'x_kk_no_kontrak'
        $val = $CurrentForm->hasValue("kk_no_kontrak") ? $CurrentForm->getValue("kk_no_kontrak") : $CurrentForm->getValue("x_kk_no_kontrak");
        if (!$this->kk_no_kontrak->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kk_no_kontrak->Visible = false; // Disable update for API request
            } else {
                $this->kk_no_kontrak->setFormValue($val);
            }
        }

        // Check field name 'koord_id' first before field var 'x_koord_id'
        $val = $CurrentForm->hasValue("koord_id") ? $CurrentForm->getValue("koord_id") : $CurrentForm->getValue("x_koord_id");
        if (!$this->koord_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->koord_id->Visible = false; // Disable update for API request
            } else {
                $this->koord_id->setFormValue($val);
            }
        }

        // Check field name 'kk_tgl_mulai' first before field var 'x_kk_tgl_mulai'
        $val = $CurrentForm->hasValue("kk_tgl_mulai") ? $CurrentForm->getValue("kk_tgl_mulai") : $CurrentForm->getValue("x_kk_tgl_mulai");
        if (!$this->kk_tgl_mulai->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kk_tgl_mulai->Visible = false; // Disable update for API request
            } else {
                $this->kk_tgl_mulai->setFormValue($val, true, $validate);
            }
            $this->kk_tgl_mulai->CurrentValue = UnFormatDateTime($this->kk_tgl_mulai->CurrentValue, $this->kk_tgl_mulai->formatPattern());
        }

        // Check field name 'kk_tgl_akhir' first before field var 'x_kk_tgl_akhir'
        $val = $CurrentForm->hasValue("kk_tgl_akhir") ? $CurrentForm->getValue("kk_tgl_akhir") : $CurrentForm->getValue("x_kk_tgl_akhir");
        if (!$this->kk_tgl_akhir->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kk_tgl_akhir->Visible = false; // Disable update for API request
            } else {
                $this->kk_tgl_akhir->setFormValue($val, true, $validate);
            }
            $this->kk_tgl_akhir->CurrentValue = UnFormatDateTime($this->kk_tgl_akhir->CurrentValue, $this->kk_tgl_akhir->formatPattern());
        }

        // Check field name 'kk_periode' first before field var 'x_kk_periode'
        $val = $CurrentForm->hasValue("kk_periode") ? $CurrentForm->getValue("kk_periode") : $CurrentForm->getValue("x_kk_periode");
        if (!$this->kk_periode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kk_periode->Visible = false; // Disable update for API request
            } else {
                $this->kk_periode->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'var_id' first before field var 'x_var_id'
        $val = $CurrentForm->hasValue("var_id") ? $CurrentForm->getValue("var_id") : $CurrentForm->getValue("x_var_id");
        if (!$this->var_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->var_id->Visible = false; // Disable update for API request
            } else {
                $this->var_id->setFormValue($val);
            }
        }

        // Check field name 'kk_harga' first before field var 'x_kk_harga'
        $val = $CurrentForm->hasValue("kk_harga") ? $CurrentForm->getValue("kk_harga") : $CurrentForm->getValue("x_kk_harga");
        if (!$this->kk_harga->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kk_harga->Visible = false; // Disable update for API request
            } else {
                $this->kk_harga->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'kk_luas' first before field var 'x_kk_luas'
        $val = $CurrentForm->hasValue("kk_luas") ? $CurrentForm->getValue("kk_luas") : $CurrentForm->getValue("x_kk_luas");
        if (!$this->kk_luas->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kk_luas->Visible = false; // Disable update for API request
            } else {
                $this->kk_luas->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'kk_id' first before field var 'x_kk_id'
        $val = $CurrentForm->hasValue("kk_id") ? $CurrentForm->getValue("kk_id") : $CurrentForm->getValue("x_kk_id");
		$this->kk_dok->OldUploadPath = $this->kk_dok->getUploadPath(); // PHP
		$this->kk_dok->UploadPath = $this->kk_dok->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->kk_no_kontrak->CurrentValue = $this->kk_no_kontrak->FormValue;
        $this->koord_id->CurrentValue = $this->koord_id->FormValue;
        $this->kk_tgl_mulai->CurrentValue = $this->kk_tgl_mulai->FormValue;
        $this->kk_tgl_mulai->CurrentValue = UnFormatDateTime($this->kk_tgl_mulai->CurrentValue, $this->kk_tgl_mulai->formatPattern());
        $this->kk_tgl_akhir->CurrentValue = $this->kk_tgl_akhir->FormValue;
        $this->kk_tgl_akhir->CurrentValue = UnFormatDateTime($this->kk_tgl_akhir->CurrentValue, $this->kk_tgl_akhir->formatPattern());
        $this->kk_periode->CurrentValue = $this->kk_periode->FormValue;
        $this->var_id->CurrentValue = $this->var_id->FormValue;
        $this->kk_harga->CurrentValue = $this->kk_harga->FormValue;
        $this->kk_luas->CurrentValue = $this->kk_luas->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->kk_id->setDbValue($row['kk_id']);
        $this->kk_no_kontrak->setDbValue($row['kk_no_kontrak']);
        $this->koord_id->setDbValue($row['koord_id']);
        $this->kk_tgl_mulai->setDbValue($row['kk_tgl_mulai']);
        $this->kk_tgl_akhir->setDbValue($row['kk_tgl_akhir']);
        $this->kk_periode->setDbValue($row['kk_periode']);
        $this->var_id->setDbValue($row['var_id']);
        $this->kk_harga->setDbValue($row['kk_harga']);
        $this->kk_luas->setDbValue($row['kk_luas']);
        $this->kk_dok->Upload->DbValue = $row['kk_dok'];
        $this->kk_dok->setDbValue($this->kk_dok->Upload->DbValue);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['kk_id'] = $this->kk_id->DefaultValue;
        $row['kk_no_kontrak'] = $this->kk_no_kontrak->DefaultValue;
        $row['koord_id'] = $this->koord_id->DefaultValue;
        $row['kk_tgl_mulai'] = $this->kk_tgl_mulai->DefaultValue;
        $row['kk_tgl_akhir'] = $this->kk_tgl_akhir->DefaultValue;
        $row['kk_periode'] = $this->kk_periode->DefaultValue;
        $row['var_id'] = $this->var_id->DefaultValue;
        $row['kk_harga'] = $this->kk_harga->DefaultValue;
        $row['kk_luas'] = $this->kk_luas->DefaultValue;
        $row['kk_dok'] = $this->kk_dok->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // kk_id
        $this->kk_id->RowCssClass = "row";

        // kk_no_kontrak
        $this->kk_no_kontrak->RowCssClass = "row";

        // koord_id
        $this->koord_id->RowCssClass = "row";

        // kk_tgl_mulai
        $this->kk_tgl_mulai->RowCssClass = "row";

        // kk_tgl_akhir
        $this->kk_tgl_akhir->RowCssClass = "row";

        // kk_periode
        $this->kk_periode->RowCssClass = "row";

        // var_id
        $this->var_id->RowCssClass = "row";

        // kk_harga
        $this->kk_harga->RowCssClass = "row";

        // kk_luas
        $this->kk_luas->RowCssClass = "row";

        // kk_dok
        $this->kk_dok->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // kk_id
            $this->kk_id->ViewValue = $this->kk_id->CurrentValue;

            // kk_no_kontrak
            $this->kk_no_kontrak->ViewValue = $this->kk_no_kontrak->CurrentValue;

            // koord_id
            $curVal = strval($this->koord_id->CurrentValue);
            if ($curVal != "") {
                $this->koord_id->ViewValue = $this->koord_id->lookupCacheOption($curVal);
                if ($this->koord_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`koord_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->koord_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->koord_id->Lookup->renderViewRow($rswrk[0]);
                        $this->koord_id->ViewValue = $this->koord_id->displayValue($arwrk);
                    } else {
                        $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                    }
                }
            } else {
                $this->koord_id->ViewValue = null;
            }

            // kk_tgl_mulai
            $this->kk_tgl_mulai->ViewValue = $this->kk_tgl_mulai->CurrentValue;
            $this->kk_tgl_mulai->ViewValue = FormatDateTime($this->kk_tgl_mulai->ViewValue, $this->kk_tgl_mulai->formatPattern());

            // kk_tgl_akhir
            $this->kk_tgl_akhir->ViewValue = $this->kk_tgl_akhir->CurrentValue;
            $this->kk_tgl_akhir->ViewValue = FormatDateTime($this->kk_tgl_akhir->ViewValue, $this->kk_tgl_akhir->formatPattern());

            // kk_periode
            $this->kk_periode->ViewValue = $this->kk_periode->CurrentValue;

            // var_id
            $curVal = strval($this->var_id->CurrentValue);
            if ($curVal != "") {
                $this->var_id->ViewValue = $this->var_id->lookupCacheOption($curVal);
                if ($this->var_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->var_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->var_id->Lookup->renderViewRow($rswrk[0]);
                        $this->var_id->ViewValue = $this->var_id->displayValue($arwrk);
                    } else {
                        $this->var_id->ViewValue = $this->var_id->CurrentValue;
                    }
                }
            } else {
                $this->var_id->ViewValue = null;
            }

            // kk_harga
            $this->kk_harga->ViewValue = $this->kk_harga->CurrentValue;

            // kk_luas
            $this->kk_luas->ViewValue = $this->kk_luas->CurrentValue;

            // kk_dok
            $this->kk_dok->UploadPath = $this->kk_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->kk_dok->Upload->DbValue)) {
                $this->kk_dok->ImageWidth = 42;
                $this->kk_dok->ImageHeight = 70;
                $this->kk_dok->ImageAlt = $this->kk_dok->alt();
                $this->kk_dok->ImageCssClass = "ew-image";
                $this->kk_dok->ViewValue = $this->kk_dok->Upload->DbValue;
            } else {
                $this->kk_dok->ViewValue = "";
            }

            // kk_no_kontrak
            $this->kk_no_kontrak->HrefValue = "";

            // koord_id
            if (!EmptyValue($this->koord_id->CurrentValue)) {
                $this->koord_id->HrefValue = $this->koord_id->getLinkPrefix() . $this->koord_id->CurrentValue; // Add prefix/suffix
                $this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->koord_id->HrefValue = FullUrl($this->koord_id->HrefValue, "href");
                }
            } else {
                $this->koord_id->HrefValue = "";
            }

            // kk_tgl_mulai
            $this->kk_tgl_mulai->HrefValue = "";

            // kk_tgl_akhir
            $this->kk_tgl_akhir->HrefValue = "";

            // kk_periode
            $this->kk_periode->HrefValue = "";

            // var_id
            $this->var_id->HrefValue = "";

            // kk_harga
            $this->kk_harga->HrefValue = "";

            // kk_luas
            $this->kk_luas->HrefValue = "";

            // kk_dok
            $this->kk_dok->UploadPath = $this->kk_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->kk_dok->Upload->DbValue)) {
                $this->kk_dok->HrefValue = GetFileUploadUrl($this->kk_dok, $this->kk_dok->htmlDecode($this->kk_dok->Upload->DbValue)); // Add prefix/suffix
                $this->kk_dok->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->kk_dok->HrefValue = FullUrl($this->kk_dok->HrefValue, "href");
                }
            } else {
                $this->kk_dok->HrefValue = "";
            }
            $this->kk_dok->ExportHrefValue = $this->kk_dok->UploadPath . $this->kk_dok->Upload->DbValue;
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // kk_no_kontrak
            $this->kk_no_kontrak->setupEditAttributes();
            if (!$this->kk_no_kontrak->Raw) {
                $this->kk_no_kontrak->CurrentValue = HtmlDecode($this->kk_no_kontrak->CurrentValue);
            }
            $this->kk_no_kontrak->EditValue = HtmlEncode($this->kk_no_kontrak->CurrentValue);
            $this->kk_no_kontrak->PlaceHolder = RemoveHtml($this->kk_no_kontrak->caption());

            // koord_id
            $this->koord_id->setupEditAttributes();
            $curVal = trim(strval($this->koord_id->CurrentValue));
            if ($curVal != "") {
                $this->koord_id->ViewValue = $this->koord_id->lookupCacheOption($curVal);
            } else {
                $this->koord_id->ViewValue = $this->koord_id->Lookup !== null && is_array($this->koord_id->lookupOptions()) && count($this->koord_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->koord_id->ViewValue !== null) { // Load from cache
                $this->koord_id->EditValue = array_values($this->koord_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`koord_id`", "=", $this->koord_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->koord_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->koord_id->EditValue = $arwrk;
            }
            $this->koord_id->PlaceHolder = RemoveHtml($this->koord_id->caption());

            // kk_tgl_mulai
            $this->kk_tgl_mulai->setupEditAttributes();
            $this->kk_tgl_mulai->EditValue = HtmlEncode(FormatDateTime($this->kk_tgl_mulai->CurrentValue, $this->kk_tgl_mulai->formatPattern()));
            $this->kk_tgl_mulai->PlaceHolder = RemoveHtml($this->kk_tgl_mulai->caption());

            // kk_tgl_akhir
            $this->kk_tgl_akhir->setupEditAttributes();
            $this->kk_tgl_akhir->EditValue = HtmlEncode(FormatDateTime($this->kk_tgl_akhir->CurrentValue, $this->kk_tgl_akhir->formatPattern()));
            $this->kk_tgl_akhir->PlaceHolder = RemoveHtml($this->kk_tgl_akhir->caption());

            // kk_periode
            $this->kk_periode->setupEditAttributes();
            $this->kk_periode->EditValue = HtmlEncode($this->kk_periode->CurrentValue);
            $this->kk_periode->PlaceHolder = RemoveHtml($this->kk_periode->caption());
            if (strval($this->kk_periode->EditValue) != "" && is_numeric($this->kk_periode->EditValue)) {
                $this->kk_periode->EditValue = $this->kk_periode->EditValue;
            }

            // var_id
            $this->var_id->setupEditAttributes();
            $curVal = trim(strval($this->var_id->CurrentValue));
            if ($curVal != "") {
                $this->var_id->ViewValue = $this->var_id->lookupCacheOption($curVal);
            } else {
                $this->var_id->ViewValue = $this->var_id->Lookup !== null && is_array($this->var_id->lookupOptions()) && count($this->var_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->var_id->ViewValue !== null) { // Load from cache
                $this->var_id->EditValue = array_values($this->var_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`var_id`", "=", $this->var_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->var_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->var_id->EditValue = $arwrk;
            }
            $this->var_id->PlaceHolder = RemoveHtml($this->var_id->caption());

            // kk_harga
            $this->kk_harga->setupEditAttributes();
            $this->kk_harga->EditValue = HtmlEncode($this->kk_harga->CurrentValue);
            $this->kk_harga->PlaceHolder = RemoveHtml($this->kk_harga->caption());
            if (strval($this->kk_harga->EditValue) != "" && is_numeric($this->kk_harga->EditValue)) {
                $this->kk_harga->EditValue = $this->kk_harga->EditValue;
            }

            // kk_luas
            $this->kk_luas->setupEditAttributes();
            $this->kk_luas->EditValue = HtmlEncode($this->kk_luas->CurrentValue);
            $this->kk_luas->PlaceHolder = RemoveHtml($this->kk_luas->caption());
            if (strval($this->kk_luas->EditValue) != "" && is_numeric($this->kk_luas->EditValue)) {
                $this->kk_luas->EditValue = $this->kk_luas->EditValue;
            }

            // kk_dok
            $this->kk_dok->setupEditAttributes();
            $this->kk_dok->UploadPath = $this->kk_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->kk_dok->Upload->DbValue)) {
                $this->kk_dok->ImageWidth = 42;
                $this->kk_dok->ImageHeight = 70;
                $this->kk_dok->ImageAlt = $this->kk_dok->alt();
                $this->kk_dok->ImageCssClass = "ew-image";
                $this->kk_dok->EditValue = $this->kk_dok->Upload->DbValue;
            } else {
                $this->kk_dok->EditValue = "";
            }
            if (!EmptyValue($this->kk_dok->CurrentValue)) {
                $this->kk_dok->Upload->FileName = $this->kk_dok->CurrentValue;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->kk_dok);
            }

            // Add refer script

            // kk_no_kontrak
            $this->kk_no_kontrak->HrefValue = "";

            // koord_id
            if (!EmptyValue($this->koord_id->CurrentValue)) {
                $this->koord_id->HrefValue = $this->koord_id->getLinkPrefix() . $this->koord_id->CurrentValue; // Add prefix/suffix
                $this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->koord_id->HrefValue = FullUrl($this->koord_id->HrefValue, "href");
                }
            } else {
                $this->koord_id->HrefValue = "";
            }

            // kk_tgl_mulai
            $this->kk_tgl_mulai->HrefValue = "";

            // kk_tgl_akhir
            $this->kk_tgl_akhir->HrefValue = "";

            // kk_periode
            $this->kk_periode->HrefValue = "";

            // var_id
            $this->var_id->HrefValue = "";

            // kk_harga
            $this->kk_harga->HrefValue = "";

            // kk_luas
            $this->kk_luas->HrefValue = "";

            // kk_dok
            $this->kk_dok->UploadPath = $this->kk_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->kk_dok->Upload->DbValue)) {
                $this->kk_dok->HrefValue = GetFileUploadUrl($this->kk_dok, $this->kk_dok->htmlDecode($this->kk_dok->Upload->DbValue)); // Add prefix/suffix
                $this->kk_dok->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->kk_dok->HrefValue = FullUrl($this->kk_dok->HrefValue, "href");
                }
            } else {
                $this->kk_dok->HrefValue = "";
            }
            $this->kk_dok->ExportHrefValue = $this->kk_dok->UploadPath . $this->kk_dok->Upload->DbValue;
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->kk_no_kontrak->Visible && $this->kk_no_kontrak->Required) {
            if (!$this->kk_no_kontrak->IsDetailKey && EmptyValue($this->kk_no_kontrak->FormValue)) {
                $this->kk_no_kontrak->addErrorMessage(str_replace("%s", $this->kk_no_kontrak->caption(), $this->kk_no_kontrak->RequiredErrorMessage));
            }
        }
        if ($this->koord_id->Visible && $this->koord_id->Required) {
            if (!$this->koord_id->IsDetailKey && EmptyValue($this->koord_id->FormValue)) {
                $this->koord_id->addErrorMessage(str_replace("%s", $this->koord_id->caption(), $this->koord_id->RequiredErrorMessage));
            }
        }
        if ($this->kk_tgl_mulai->Visible && $this->kk_tgl_mulai->Required) {
            if (!$this->kk_tgl_mulai->IsDetailKey && EmptyValue($this->kk_tgl_mulai->FormValue)) {
                $this->kk_tgl_mulai->addErrorMessage(str_replace("%s", $this->kk_tgl_mulai->caption(), $this->kk_tgl_mulai->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->kk_tgl_mulai->FormValue, $this->kk_tgl_mulai->formatPattern())) {
            $this->kk_tgl_mulai->addErrorMessage($this->kk_tgl_mulai->getErrorMessage(false));
        }
        if ($this->kk_tgl_akhir->Visible && $this->kk_tgl_akhir->Required) {
            if (!$this->kk_tgl_akhir->IsDetailKey && EmptyValue($this->kk_tgl_akhir->FormValue)) {
                $this->kk_tgl_akhir->addErrorMessage(str_replace("%s", $this->kk_tgl_akhir->caption(), $this->kk_tgl_akhir->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->kk_tgl_akhir->FormValue, $this->kk_tgl_akhir->formatPattern())) {
            $this->kk_tgl_akhir->addErrorMessage($this->kk_tgl_akhir->getErrorMessage(false));
        }
        if ($this->kk_periode->Visible && $this->kk_periode->Required) {
            if (!$this->kk_periode->IsDetailKey && EmptyValue($this->kk_periode->FormValue)) {
                $this->kk_periode->addErrorMessage(str_replace("%s", $this->kk_periode->caption(), $this->kk_periode->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->kk_periode->FormValue)) {
            $this->kk_periode->addErrorMessage($this->kk_periode->getErrorMessage(false));
        }
        if ($this->var_id->Visible && $this->var_id->Required) {
            if (!$this->var_id->IsDetailKey && EmptyValue($this->var_id->FormValue)) {
                $this->var_id->addErrorMessage(str_replace("%s", $this->var_id->caption(), $this->var_id->RequiredErrorMessage));
            }
        }
        if ($this->kk_harga->Visible && $this->kk_harga->Required) {
            if (!$this->kk_harga->IsDetailKey && EmptyValue($this->kk_harga->FormValue)) {
                $this->kk_harga->addErrorMessage(str_replace("%s", $this->kk_harga->caption(), $this->kk_harga->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->kk_harga->FormValue)) {
            $this->kk_harga->addErrorMessage($this->kk_harga->getErrorMessage(false));
        }
        if ($this->kk_luas->Visible && $this->kk_luas->Required) {
            if (!$this->kk_luas->IsDetailKey && EmptyValue($this->kk_luas->FormValue)) {
                $this->kk_luas->addErrorMessage(str_replace("%s", $this->kk_luas->caption(), $this->kk_luas->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->kk_luas->FormValue)) {
            $this->kk_luas->addErrorMessage($this->kk_luas->getErrorMessage(false));
        }
        if ($this->kk_dok->Visible && $this->kk_dok->Required) {
            if ($this->kk_dok->Upload->FileName == "" && !$this->kk_dok->Upload->KeepFile) {
                $this->kk_dok->addErrorMessage(str_replace("%s", $this->kk_dok->caption(), $this->kk_dok->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set new row
        $rsnew = [];

        // kk_no_kontrak
        $this->kk_no_kontrak->setDbValueDef($rsnew, $this->kk_no_kontrak->CurrentValue, false);

        // koord_id
        $this->koord_id->setDbValueDef($rsnew, $this->koord_id->CurrentValue, false);

        // kk_tgl_mulai
        $this->kk_tgl_mulai->setDbValueDef($rsnew, UnFormatDateTime($this->kk_tgl_mulai->CurrentValue, $this->kk_tgl_mulai->formatPattern()), false);

        // kk_tgl_akhir
        $this->kk_tgl_akhir->setDbValueDef($rsnew, UnFormatDateTime($this->kk_tgl_akhir->CurrentValue, $this->kk_tgl_akhir->formatPattern()), false);

        // kk_periode
        $this->kk_periode->setDbValueDef($rsnew, $this->kk_periode->CurrentValue, false);

        // var_id
        $this->var_id->setDbValueDef($rsnew, $this->var_id->CurrentValue, false);

        // kk_harga
        $this->kk_harga->setDbValueDef($rsnew, $this->kk_harga->CurrentValue, false);

        // kk_luas
        $this->kk_luas->setDbValueDef($rsnew, $this->kk_luas->CurrentValue, false);

        // kk_dok
        if ($this->kk_dok->Visible && !$this->kk_dok->Upload->KeepFile) {
            $this->kk_dok->Upload->DbValue = ""; // No need to delete old file
            if ($this->kk_dok->Upload->FileName == "") {
                $rsnew['kk_dok'] = null;
            } else {
                $rsnew['kk_dok'] = $this->kk_dok->Upload->FileName;
            }
            $this->kk_dok->ImageWidth = 420; // Resize width
            $this->kk_dok->ImageHeight = 700; // Resize height
        }
        if ($this->kk_dok->Visible && !$this->kk_dok->Upload->KeepFile) {
            $this->kk_dok->UploadPath = $this->kk_dok->getUploadPath(); // PHP
            $oldFiles = EmptyValue($this->kk_dok->Upload->DbValue) ? [] : [$this->kk_dok->htmlDecode($this->kk_dok->Upload->DbValue)];
            if (!EmptyValue($this->kk_dok->Upload->FileName)) {
                $newFiles = [$this->kk_dok->Upload->FileName];
                $NewFileCount = count($newFiles);
                for ($i = 0; $i < $NewFileCount; $i++) {
                    if ($newFiles[$i] != "") {
                        $file = $newFiles[$i];
                        $tempPath = UploadTempPath($this->kk_dok, $this->kk_dok->Upload->Index);
                        if (file_exists($tempPath . $file)) {
                            if (Config("DELETE_UPLOADED_FILES")) {
                                $oldFileFound = false;
                                $oldFileCount = count($oldFiles);
                                for ($j = 0; $j < $oldFileCount; $j++) {
                                    $oldFile = $oldFiles[$j];
                                    if ($oldFile == $file) { // Old file found, no need to delete anymore
                                        array_splice($oldFiles, $j, 1);
                                        $oldFileFound = true;
                                        break;
                                    }
                                }
                                if ($oldFileFound) { // No need to check if file exists further
                                    continue;
                                }
                            }
                            $file1 = UniqueFilename($this->kk_dok->physicalUploadPath(), $file); // Get new file name
                            if ($file1 != $file) { // Rename temp file
                                while (file_exists($tempPath . $file1) || file_exists($this->kk_dok->physicalUploadPath() . $file1)) { // Make sure no file name clash
                                    $file1 = UniqueFilename([$this->kk_dok->physicalUploadPath(), $tempPath], $file1, true); // Use indexed name
                                }
                                rename($tempPath . $file, $tempPath . $file1);
                                $newFiles[$i] = $file1;
                            }
                        }
                    }
                }
                $this->kk_dok->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
                $this->kk_dok->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
                $this->kk_dok->setDbValueDef($rsnew, $this->kk_dok->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->kk_dok->OldUploadPath = $this->kk_dok->getUploadPath(); // PHP
        $this->kk_dok->UploadPath = $this->kk_dok->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->kk_dok->Visible && !$this->kk_dok->Upload->KeepFile) {
                    $oldFiles = EmptyValue($this->kk_dok->Upload->DbValue) ? [] : [$this->kk_dok->htmlDecode($this->kk_dok->Upload->DbValue)];
                    if (!EmptyValue($this->kk_dok->Upload->FileName)) {
                        $newFiles = [$this->kk_dok->Upload->FileName];
                        $newFiles2 = [$this->kk_dok->htmlDecode($rsnew['kk_dok'])];
                        $newFileCount = count($newFiles);
                        for ($i = 0; $i < $newFileCount; $i++) {
                            if ($newFiles[$i] != "") {
                                $file = UploadTempPath($this->kk_dok, $this->kk_dok->Upload->Index) . $newFiles[$i];
                                if (file_exists($file)) {
                                    if (@$newFiles2[$i] != "") { // Use correct file name
                                        $newFiles[$i] = $newFiles2[$i];
                                    }
                                    if (!$this->kk_dok->Upload->ResizeAndSaveToFile($this->kk_dok->ImageWidth, $this->kk_dok->ImageHeight, 100, $newFiles[$i], true, $i)) {
                                        $this->setFailureMessage($Language->phrase("UploadError7"));
                                        return false;
                                    }
                                }
                            }
                        }
                    } else {
                        $newFiles = [];
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KontrakList");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("KontrakKoordList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_koord_id":
                    break;
                case "x_var_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
