<?php
namespace PHPMaker2019\co;

/**
 * Page class (view5_rpt)
 */
class view5_rpt extends view5_base
{

	// Page ID
	public $PageID = 'rpt';

	// Project ID
	public $ProjectID = "{FAF953E4-B026-4CC4-8D1E-0CFAFEB15236}";

	// Page object name
	public $PageObjName = 'view5_rpt';
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Page headings
	public $Heading = '';
	public $Subheading = '';
	public $PageHeader;
	public $PageFooter;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportPdfUrl;
	public $ExportEmailUrl;

	// CSS
	public $ReportTableClass = "";
	public $ReportTableStyle = "";

	// Custom export
	public $ExportPrintCustom = FALSE;
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Page heading
	public function pageHeading()
	{
		global $ReportLanguage;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $ReportLanguage;
		if ($this->Subheading <> "")
			return $this->Subheading;
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$pageUrl = CurrentPageName() . "?";
		if ($this->UseTokenInUrl) $pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return @$_SESSION[SESSION_MESSAGE];
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($_SESSION[SESSION_MESSAGE], $v);
	}

	// Get failure message
	public function getFailureMessage()
	{
		return @$_SESSION[SESSION_FAILURE_MESSAGE];
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($_SESSION[SESSION_FAILURE_MESSAGE], $v);
	}

	// Get success message
	public function getSuccessMessage()
	{
		return @$_SESSION[SESSION_SUCCESS_MESSAGE];
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($_SESSION[SESSION_SUCCESS_MESSAGE], $v);
	}

	// Get warning message
	public function getWarningMessage()
	{
		return @$_SESSION[SESSION_WARNING_MESSAGE];
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($_SESSION[SESSION_WARNING_MESSAGE], $v);
	}

	// Clear message
	public function clearMessage()
	{
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$_SESSION[SESSION_MESSAGE] = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") // Fotoer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
	}

	// Validate page request
	public function isPageRequest()
	{
		if ($this->UseTokenInUrl) {
			if (IsPost())
				return ($this->TableVar == Post("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $ReportLanguage, $DashboardReport;
		global $UserTable, $UserTableConn;

		// Initialize
		if (!$DashboardReport)
			$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		$ReportLanguage = new ReportLanguage();
		if ($Language === NULL)
			$Language = $ReportLanguage;

		// Parent constuctor
		parent::__construct();

		// Table object (view5_base)
		if (!isset($GLOBALS["view5_base"])) {
			$GLOBALS["view5_base"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["view5_base"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportEmailUrl = $this->pageUrl() . "export=email";

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'rpt');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'view5');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees_base)
		if (!isset($UserTable)) {
			$UserTable = new employees_base();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Search options
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fview5rpt";

		// Generate report options
		$this->GenerateOptions = new ListOptions();
		$this->GenerateOptions->Tag = "div";
		$this->GenerateOptions->TagClassName = "ew-generate-option";
	}

	// Get export HTML tag
	public function getExportTag($type, $custom = FALSE)
	{
		global $ReportLanguage;
		$exportId = session_id();
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportExcelUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("ExportToExcel") . "</a>";
			else
				return "<a class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportWordUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("ExportToWord") . "</a>";
			else
				return "<a class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "print")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportPrintUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("PrinterFriendly") . "</a>";
			else
				return "<a class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly"), TRUE) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->phrase("PrinterFriendly") . "</a>";
		} elseif (SameText($type, "pdf")) {
			return "<a class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "email")) {
			return "<a class=\"ew-export-link ew-email\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToEmail", TRUE)) . "\" id=\"emf_view5\" href=\"#\" onclick=\"ew.emailDialogShow({ lnk: 'emf_view5', hdr: ew.language.phrase('ExportToEmail'), url: '$this->ExportEmailUrl', exportid: '$exportId', el: this }); return false;\">" . $ReportLanguage->phrase("ExportToEmail") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Security, $ReportLanguage, $ReportOptions;
		$exportId = session_id();
		$reportTypes = [];

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;
		$reportTypes["print"] = $item->Visible ? $ReportLanguage->phrase("ReportFormPrint") : "";

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;
		$reportTypes["excel"] = $item->Visible ? $ReportLanguage->phrase("ReportFormExcel") : "";

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = TRUE;
		$reportTypes["word"] = $item->Visible ? $ReportLanguage->phrase("ReportFormWord") : "";

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;
		$item->Visible = TRUE;
		$reportTypes["pdf"] = $item->Visible ? $ReportLanguage->phrase("ReportFormPdf") : "";

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;
		$reportTypes["email"] = $item->Visible ? $ReportLanguage->phrase("ReportFormEmail") : "";

		// Report types
		$ReportOptions["ReportTypes"] = $reportTypes;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fview5rpt\" href=\"#\">" . $ReportLanguage->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fview5rpt\" href=\"#\">" . $ReportLanguage->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up export options (extended)
		$this->setupExportOptionsExt();

		// Hide options for export
		if ($this->isExport()) {
			$this->ExportOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}

		// Set up table class
		if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf"))
			$this->ReportTableClass = "ew-table";
		else
			$this->ReportTableClass = "table ew-table";
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $ReportLanguage;

		// Filter panel button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = $this->FilterApplied ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $ReportLanguage->phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fview5rpt\">" . $ReportLanguage->phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Reset filter
		$item = &$this->SearchOptions->add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlEncode($ReportLanguage->phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . CurrentPageName() . "?cmd=reset'\">" . $ReportLanguage->phrase("ResetAllFilter") . "</button>";
		$item->Visible = TRUE && $this->FilterApplied;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->isExport())
			$this->SearchOptions->hideAllOptions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ReportLanguage, $EXPORT_REPORT, $ExportFileName, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->isExport() && array_key_exists($this->Export, $EXPORT_REPORT)) {
			$content = ob_get_contents();
			if (ob_get_length())
				ob_end_clean();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $content, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$content = str_replace($divmatch[0], "", $content);
				}
			}
			$fn = $EXPORT_REPORT[$this->Export];
			$saveResponse = $this->$fn($content);
			if (ReportParam("generaterequest") === TRUE) { // Generate report request
				$this->writeGenResponse($saveResponse);
				$url = ""; // Avoid redirect
			}
		}

		// Close connection if not in dashboard
		if (!$DashboardReport)
			CloseConnections();

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			header("Location: " . $url);
		}
		if (!$DashboardReport)
			exit();
	}

	// Initialize common variables
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $FilterOptions; // Filter options

	// Recordset
	public $GroupRecordset = NULL;
	public $Recordset = NULL;
	public $DetailRecordCount = 0;

	// Paging variables
	public $RecordIndex = 0; // Record index
	public $RecordCount = 0; // Record count
	public $StartGroup = 0; // Start group
	public $StopGroup = 0; // Stop group
	public $TotalGroups = 0; // Total groups
	public $GroupCount = 0; // Group count
	public $GroupCounter = []; // Group counter
	public $DisplayGroups = 50; // Groups per page
	public $GroupRange = 10;
	public $Sort = "";
	public $Filter = "";
	public $PageFirstGroupFilter = "";
	public $UserIDFilter = "";
	public $DrillDown = FALSE;
	public $DrillDownInPanel = FALSE;
	public $DrillDownList = "";

	// Clear field for ext filter
	public $ExpiredExtendedFilter = "";
	public $PopupName = "";
	public $PopupValue = "";
	public $FilterApplied;
	public $SearchCommand = FALSE;
	public $ShowHeader;
	public $GroupColumnCount = 0;
	public $SubGroupColumnCount = 0;
	public $DetailColumnCount = 0;
	public $Counts;
	public $Columns;
	public $Values;
	public $Summaries;
	public $Minimums;
	public $Maximums;
	public $GrandCounts;
	public $GrandSummaries;
	public $GrandMinimums;
	public $GrandMaximums;
	public $TotalCount;
	public $GrandSummarySetup = FALSE;
	public $GroupIndexes;
	public $DetailRows = [];
	public $TopContentClass = "col-sm-12 ew-top";
	public $LeftContentClass = "ew-left";
	public $CenterContentClass = "col-sm-12 ew-center";
	public $RightContentClass = "ew-right";
	public $BottomContentClass = "col-sm-12 ew-bottom";

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $ExportFileName, $ReportLanguage, $Security, $UserProfile,
			$Security, $FormError, $DrillDownInPanel, $Breadcrumb, $ReportLanguage,
			$DashboardReport, $CustomExportType;
		global $ReportLanguage;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		if (!$Security->isLoggedIn()) $Security->autoLogin(); // Auto login
		$Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel($this->ProjectID . 'view5');
		$Security->TablePermission_Loaded();
		if (!$Security->canList()) {
			$Security->saveLastUrl();
			$this->setFailureMessage(DeniedMessage()); // Set no permission
			$this->terminate(GetUrl("index.php"));
		}

		// Get export parameters
		if (ReportParam("export") !== NULL)
			$this->Export = strtolower(ReportParam("export"));
		$ExportType = $this->Export; // Get export parameter, used in header
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Setup placeholder
		$this->k_id_kontrak->PlaceHolder = $this->k_id_kontrak->caption();
		$this->k_tgl_tanam->PlaceHolder = $this->k_tgl_tanam->caption();
		$this->Jenis_Pestisida->PlaceHolder = $this->Jenis_Pestisida->caption();
		$this->co_nama->PlaceHolder = $this->co_nama->caption();
		$this->var_nama->PlaceHolder = $this->var_nama->caption();
		$this->desa_nama->PlaceHolder = $this->desa_nama->caption();
		$this->kec_nama->PlaceHolder = $this->kec_nama->caption();
		$this->kab_nama->PlaceHolder = $this->kab_nama->caption();
		$this->prov_nama->PlaceHolder = $this->prov_nama->caption();
		$this->pet_nama->PlaceHolder = $this->pet_nama->caption();

		// Setup export options
		$this->setupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			echo $ReportLanguage->phrase("InvalidPostRequest");
			$this->terminate();
			exit();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Set field visibility for detail fields

		$this->k_id_kontrak->setVisibility();
		$this->k_tgl_tanam->setVisibility();
		$this->k_luas_lahan->setVisibility();
		$this->Jenis_Pestisida->setVisibility();
		$this->Merek->setVisibility();
		$this->Bahan_Aktif->setVisibility();
		$this->Dosis_Pemakaian->setVisibility();
		$this->Waktu_Aplikasi->setVisibility();
		$this->co_nama->setVisibility();
		$this->var_nama->setVisibility();
		$this->blok_nama->setVisibility();
		$this->desa_nama->setVisibility();
		$this->kec_nama->setVisibility();
		$this->kab_nama->setVisibility();
		$this->prov_nama->setVisibility();
		$this->koord_nama->setVisibility();
		$this->pet_nama->setVisibility();

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$fieldCount = 18;
		$groupCount = 1;
		$this->Values = &InitArray($fieldCount, 0);
		$this->Counts = &Init2DArray($groupCount, $fieldCount, 0);
		$this->Summaries = &Init2DArray($groupCount, $fieldCount, 0);
		$this->Minimums = &Init2DArray($groupCount, $fieldCount, NULL);
		$this->Maximums = &Init2DArray($groupCount, $fieldCount, NULL);
		$this->GrandCounts = &InitArray($fieldCount, 0);
		$this->GrandSummaries = &InitArray($fieldCount, 0);
		$this->GrandMinimums = &InitArray($fieldCount, NULL);
		$this->GrandMaximums = &InitArray($fieldCount, NULL);

		// Set up array if accumulation required: [Accum, SkipNullOrZero]
		$this->Columns = [[FALSE, FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE]];

		// Set up groups per page dynamically
		$this->setupDisplayGroups();

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Check if search command
		$this->SearchCommand = (Get("cmd", "") == "search");

		// Load default filter values
		$this->loadDefaultFilters();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->setupPopup();

		// Load group db values if necessary
		$this->loadGroupDbValues();

		// Extended filter
		$extendedFilter = "";

		// Restore filter list
		$this->restoreFilterList();

		// Build extended filter
		$extendedFilter = $this->getExtendedFilter();
		AddFilter($this->Filter, $extendedFilter);

		// Build popup filter
		$popupFilter = $this->getPopupFilter();
		AddFilter($this->Filter, $popupFilter);

		// Check if filter applied
		$this->FilterApplied = $this->checkFilter();

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);

		// Search options
		$this->setupSearchOptions();

		// Get sort
		$this->Sort = $this->getSort();

		// Get total count
		$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
		$this->TotalGroups = $this->getRecordCount($sql);
		if ($this->DisplayGroups <= 0 || $this->DrillDown || $DashboardReport) // Display all groups
			$this->DisplayGroups = $this->TotalGroups;
		$this->StartGroup = 1;

		// Show header
		$this->ShowHeader = ($this->TotalGroups > 0);

		// Set up start position if not export all
		if ($this->ExportAll && $this->isExport())
			$this->DisplayGroups = $this->TotalGroups;
		else
			$this->setupStartGroup();

		// Set no record found message
		if ($this->TotalGroups == 0) {
			if ($Security->canList()) {
				if ($this->Filter == "0=101") {
					$this->setWarningMessage($ReportLanguage->phrase("EnterSearchCriteria"));
				} else {
					$this->setWarningMessage($ReportLanguage->phrase("NoRecord"));
				}
			} else {
				$this->setWarningMessage(DeniedMessage());
			}
		}

		// Hide export options if export/dashboard report
		if ($this->isExport() || $DashboardReport)
			$this->ExportOptions->hideAllOptions();

		// Hide search/filter options if export/drilldown/dashboard report
		if ($this->isExport() || $this->DrillDown || $DashboardReport) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
			$this->GenerateOptions->hideAllOptions();
		}

		// Get current page records
		$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $this->Filter, $this->Sort);
		$this->Recordset = $this->getRecordset($sql, $this->DisplayGroups, $this->StartGroup - 1);
		$this->setupFieldCount();
	}

	// Accummulate summary
	public function accumulateSummary()
	{
		$cntx = count($this->Summaries);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Summaries[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Columns[$iy][0]) { // Accumulate required
					$valwrk = $this->Values[$iy];
					if ($valwrk === NULL) {
						if (!$this->Columns[$iy][1])
							$this->Counts[$ix][$iy]++;
					} else {
						$accum = (!$this->Columns[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Counts[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Summaries[$ix][$iy] += $valwrk;
								if ($this->Minimums[$ix][$iy] === NULL) {
									$this->Minimums[$ix][$iy] = $valwrk;
									$this->Maximums[$ix][$iy] = $valwrk;
								} else {
									if ($this->Minimums[$ix][$iy] > $valwrk)
										$this->Minimums[$ix][$iy] = $valwrk;
									if ($this->Maximums[$ix][$iy] < $valwrk)
										$this->Maximums[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Summaries);
		for ($ix = 0; $ix < $cntx; $ix++)
			$this->Counts[$ix][0]++;
	}

	// Reset level summary
	public function resetLevelSummary($lvl)
	{

		// Clear summary values
		$cntx = count($this->Summaries);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Summaries[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Counts[$ix][$iy] = 0;
				if ($this->Columns[$iy][0]) {
					$this->Summaries[$ix][$iy] = 0;
					$this->Minimums[$ix][$iy] = NULL;
					$this->Maximums[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Summaries);
		for ($ix = $lvl; $ix < $cntx; $ix++)
			$this->Counts[$ix][0] = 0;

		// Reset record count
		$this->RecordCount = 0;
	}

	// Load row values
	public function loadRowValues($firstRow = FALSE)
	{
		if (!$this->Recordset)
			return;
		if ($firstRow) { // Get first row
				$this->FirstRowData = [];
				$this->FirstRowData["k_id_kontrak"] = $this->Recordset->fields('k_id_kontrak');
				$this->FirstRowData["k_tgl_tanam"] = $this->Recordset->fields('k_tgl_tanam');
				$this->FirstRowData["k_luas_lahan"] = $this->Recordset->fields('k_luas_lahan');
				$this->FirstRowData["Jenis_Pestisida"] = $this->Recordset->fields('Jenis_Pestisida');
				$this->FirstRowData["Merek"] = $this->Recordset->fields('Merek');
				$this->FirstRowData["Bahan_Aktif"] = $this->Recordset->fields('Bahan_Aktif');
				$this->FirstRowData["Dosis_Pemakaian"] = $this->Recordset->fields('Dosis_Pemakaian');
				$this->FirstRowData["Waktu_Aplikasi"] = $this->Recordset->fields('Waktu_Aplikasi');
				$this->FirstRowData["co_nama"] = $this->Recordset->fields('co_nama');
				$this->FirstRowData["var_nama"] = $this->Recordset->fields('var_nama');
				$this->FirstRowData["blok_nama"] = $this->Recordset->fields('blok_nama');
				$this->FirstRowData["desa_nama"] = $this->Recordset->fields('desa_nama');
				$this->FirstRowData["kec_nama"] = $this->Recordset->fields('kec_nama');
				$this->FirstRowData["kab_nama"] = $this->Recordset->fields('kab_nama');
				$this->FirstRowData["prov_nama"] = $this->Recordset->fields('prov_nama');
				$this->FirstRowData["koord_nama"] = $this->Recordset->fields('koord_nama');
				$this->FirstRowData["pet_nama"] = $this->Recordset->fields('pet_nama');
		} else { // Get next row
			$this->Recordset->moveNext();
		}
		if (!$this->Recordset->EOF) {
			$this->k_id_kontrak->setDbValue($this->Recordset->fields('k_id_kontrak'));
			$this->k_tgl_tanam->setDbValue($this->Recordset->fields('k_tgl_tanam'));
			$this->k_luas_lahan->setDbValue($this->Recordset->fields('k_luas_lahan'));
			$this->Jenis_Pestisida->setDbValue($this->Recordset->fields('Jenis_Pestisida'));
			$this->Merek->setDbValue($this->Recordset->fields('Merek'));
			$this->Bahan_Aktif->setDbValue($this->Recordset->fields('Bahan_Aktif'));
			$this->Dosis_Pemakaian->setDbValue($this->Recordset->fields('Dosis_Pemakaian'));
			$this->Waktu_Aplikasi->setDbValue($this->Recordset->fields('Waktu_Aplikasi'));
			$this->Keterangan->setDbValue($this->Recordset->fields('Keterangan'));
			$this->co_nama->setDbValue($this->Recordset->fields('co_nama'));
			$this->var_nama->setDbValue($this->Recordset->fields('var_nama'));
			$this->blok_nama->setDbValue($this->Recordset->fields('blok_nama'));
			$this->desa_nama->setDbValue($this->Recordset->fields('desa_nama'));
			$this->kec_nama->setDbValue($this->Recordset->fields('kec_nama'));
			$this->kab_nama->setDbValue($this->Recordset->fields('kab_nama'));
			$this->prov_nama->setDbValue($this->Recordset->fields('prov_nama'));
			$this->koord_nama->setDbValue($this->Recordset->fields('koord_nama'));
			$this->pet_nama->setDbValue($this->Recordset->fields('pet_nama'));
			$this->Values[1] = $this->k_id_kontrak->CurrentValue;
			$this->Values[2] = $this->k_tgl_tanam->CurrentValue;
			$this->Values[3] = $this->k_luas_lahan->CurrentValue;
			$this->Values[4] = $this->Jenis_Pestisida->CurrentValue;
			$this->Values[5] = $this->Merek->CurrentValue;
			$this->Values[6] = $this->Bahan_Aktif->CurrentValue;
			$this->Values[7] = $this->Dosis_Pemakaian->CurrentValue;
			$this->Values[8] = $this->Waktu_Aplikasi->CurrentValue;
			$this->Values[9] = $this->co_nama->CurrentValue;
			$this->Values[10] = $this->var_nama->CurrentValue;
			$this->Values[11] = $this->blok_nama->CurrentValue;
			$this->Values[12] = $this->desa_nama->CurrentValue;
			$this->Values[13] = $this->kec_nama->CurrentValue;
			$this->Values[14] = $this->kab_nama->CurrentValue;
			$this->Values[15] = $this->prov_nama->CurrentValue;
			$this->Values[16] = $this->koord_nama->CurrentValue;
			$this->Values[17] = $this->pet_nama->CurrentValue;
		} else {
			$this->k_id_kontrak->setDbValue("");
			$this->k_tgl_tanam->setDbValue("");
			$this->k_luas_lahan->setDbValue("");
			$this->Jenis_Pestisida->setDbValue("");
			$this->Merek->setDbValue("");
			$this->Bahan_Aktif->setDbValue("");
			$this->Dosis_Pemakaian->setDbValue("");
			$this->Waktu_Aplikasi->setDbValue("");
			$this->Keterangan->setDbValue("");
			$this->co_nama->setDbValue("");
			$this->var_nama->setDbValue("");
			$this->blok_nama->setDbValue("");
			$this->desa_nama->setDbValue("");
			$this->kec_nama->setDbValue("");
			$this->kab_nama->setDbValue("");
			$this->prov_nama->setDbValue("");
			$this->koord_nama->setDbValue("");
			$this->pet_nama->setDbValue("");
		}
	}

	// Render row
	public function renderRow()
	{
		global $Security, $ReportLanguage, $Language;
		$conn = &$this->getConnection();
		if (!$this->GrandSummarySetup) { // Get Grand total
			$hasCount = FALSE;
			$hasSummary = FALSE;

			// Get total count from SQL directly
			$sql = BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->execute($sql);
			if ($rstot) {
				$this->TotalCount = ($rstot->recordCount() > 1) ? $rstot->recordCount() : $rstot->fields[0];
				$rstot->close();
				$hasCount = TRUE;
			} else {
				$this->TotalCount = 0;
			}
			$hasSummary = TRUE;

			// Accumulate grand summary from detail records
			if (!$hasCount || !$hasSummary) {
				$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$this->Recordset = $conn->execute($sql);
				if ($this->Recordset) {
					$this->loadRowValues(TRUE);
					while (!$this->Recordset->EOF) {
						$this->accumulateGrandSummary();
						$this->loadRowValues();
					}
					$this->Recordset->close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();
		if ($this->RowType == ROWTYPE_SEARCH) { // Search row
		} elseif ($this->RowType == ROWTYPE_TOTAL && !($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER)) { // Summary row
			PrependClass($this->RowAttrs["class"], ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_tgl_tanam
			$this->k_tgl_tanam->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// Jenis_Pestisida
			$this->Jenis_Pestisida->HrefValue = "";

			// Merek
			$this->Merek->HrefValue = "";

			// Bahan_Aktif
			$this->Bahan_Aktif->HrefValue = "";

			// Dosis_Pemakaian
			$this->Dosis_Pemakaian->HrefValue = "";

			// Waktu_Aplikasi
			$this->Waktu_Aplikasi->HrefValue = "";

			// co_nama
			$this->co_nama->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// blok_nama
			$this->blok_nama->HrefValue = "";

			// desa_nama
			$this->desa_nama->HrefValue = "";

			// kec_nama
			$this->kec_nama->HrefValue = "";

			// kab_nama
			$this->kab_nama->HrefValue = "";

			// prov_nama
			$this->prov_nama->HrefValue = "";

			// koord_nama
			$this->koord_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";
		} else {
			if ($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER) {
			} else {
			}

			// k_id_kontrak
			$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
			$this->k_id_kontrak->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_tgl_tanam
			$this->k_tgl_tanam->ViewValue = $this->k_tgl_tanam->CurrentValue;
			$this->k_tgl_tanam->ViewValue = FormatDateTime($this->k_tgl_tanam->ViewValue, 0);
			$this->k_tgl_tanam->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_luas_lahan
			$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
			$this->k_luas_lahan->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Jenis_Pestisida
			$this->Jenis_Pestisida->ViewValue = $this->Jenis_Pestisida->CurrentValue;
			$this->Jenis_Pestisida->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Merek
			$this->Merek->ViewValue = $this->Merek->CurrentValue;
			$this->Merek->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Bahan_Aktif
			$this->Bahan_Aktif->ViewValue = $this->Bahan_Aktif->CurrentValue;
			$this->Bahan_Aktif->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Dosis_Pemakaian
			$this->Dosis_Pemakaian->ViewValue = $this->Dosis_Pemakaian->CurrentValue;
			$this->Dosis_Pemakaian->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// Waktu_Aplikasi
			$this->Waktu_Aplikasi->ViewValue = $this->Waktu_Aplikasi->CurrentValue;
			$this->Waktu_Aplikasi->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// co_nama
			$this->co_nama->ViewValue = $this->co_nama->CurrentValue;
			$this->co_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// var_nama
			$this->var_nama->ViewValue = $this->var_nama->CurrentValue;
			$this->var_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// blok_nama
			$this->blok_nama->ViewValue = $this->blok_nama->CurrentValue;
			$this->blok_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// desa_nama
			$this->desa_nama->ViewValue = $this->desa_nama->CurrentValue;
			$this->desa_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// kec_nama
			$this->kec_nama->ViewValue = $this->kec_nama->CurrentValue;
			$this->kec_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// kab_nama
			$this->kab_nama->ViewValue = $this->kab_nama->CurrentValue;
			$this->kab_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// prov_nama
			$this->prov_nama->ViewValue = $this->prov_nama->CurrentValue;
			$this->prov_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// koord_nama
			$this->koord_nama->ViewValue = $this->koord_nama->CurrentValue;
			$this->koord_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// pet_nama
			$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
			$this->pet_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_tgl_tanam
			$this->k_tgl_tanam->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// Jenis_Pestisida
			$this->Jenis_Pestisida->HrefValue = "";

			// Merek
			$this->Merek->HrefValue = "";

			// Bahan_Aktif
			$this->Bahan_Aktif->HrefValue = "";

			// Dosis_Pemakaian
			$this->Dosis_Pemakaian->HrefValue = "";

			// Waktu_Aplikasi
			$this->Waktu_Aplikasi->HrefValue = "";

			// co_nama
			$this->co_nama->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// blok_nama
			$this->blok_nama->HrefValue = "";

			// desa_nama
			$this->desa_nama->HrefValue = "";

			// kec_nama
			$this->kec_nama->HrefValue = "";

			// kab_nama
			$this->kab_nama->HrefValue = "";

			// prov_nama
			$this->prov_nama->HrefValue = "";

			// koord_nama
			$this->koord_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == ROWTYPE_TOTAL) { // Summary row
		} else {

			// k_id_kontrak
			$currentValue = $this->k_id_kontrak->CurrentValue;
			$viewValue = &$this->k_id_kontrak->ViewValue;
			$viewAttrs = &$this->k_id_kontrak->ViewAttrs;
			$cellAttrs = &$this->k_id_kontrak->CellAttrs;
			$hrefValue = &$this->k_id_kontrak->HrefValue;
			$linkAttrs = &$this->k_id_kontrak->LinkAttrs;
			$this->Cell_Rendered($this->k_id_kontrak, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_tgl_tanam
			$currentValue = $this->k_tgl_tanam->CurrentValue;
			$viewValue = &$this->k_tgl_tanam->ViewValue;
			$viewAttrs = &$this->k_tgl_tanam->ViewAttrs;
			$cellAttrs = &$this->k_tgl_tanam->CellAttrs;
			$hrefValue = &$this->k_tgl_tanam->HrefValue;
			$linkAttrs = &$this->k_tgl_tanam->LinkAttrs;
			$this->Cell_Rendered($this->k_tgl_tanam, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_luas_lahan
			$currentValue = $this->k_luas_lahan->CurrentValue;
			$viewValue = &$this->k_luas_lahan->ViewValue;
			$viewAttrs = &$this->k_luas_lahan->ViewAttrs;
			$cellAttrs = &$this->k_luas_lahan->CellAttrs;
			$hrefValue = &$this->k_luas_lahan->HrefValue;
			$linkAttrs = &$this->k_luas_lahan->LinkAttrs;
			$this->Cell_Rendered($this->k_luas_lahan, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Jenis_Pestisida
			$currentValue = $this->Jenis_Pestisida->CurrentValue;
			$viewValue = &$this->Jenis_Pestisida->ViewValue;
			$viewAttrs = &$this->Jenis_Pestisida->ViewAttrs;
			$cellAttrs = &$this->Jenis_Pestisida->CellAttrs;
			$hrefValue = &$this->Jenis_Pestisida->HrefValue;
			$linkAttrs = &$this->Jenis_Pestisida->LinkAttrs;
			$this->Cell_Rendered($this->Jenis_Pestisida, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Merek
			$currentValue = $this->Merek->CurrentValue;
			$viewValue = &$this->Merek->ViewValue;
			$viewAttrs = &$this->Merek->ViewAttrs;
			$cellAttrs = &$this->Merek->CellAttrs;
			$hrefValue = &$this->Merek->HrefValue;
			$linkAttrs = &$this->Merek->LinkAttrs;
			$this->Cell_Rendered($this->Merek, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Bahan_Aktif
			$currentValue = $this->Bahan_Aktif->CurrentValue;
			$viewValue = &$this->Bahan_Aktif->ViewValue;
			$viewAttrs = &$this->Bahan_Aktif->ViewAttrs;
			$cellAttrs = &$this->Bahan_Aktif->CellAttrs;
			$hrefValue = &$this->Bahan_Aktif->HrefValue;
			$linkAttrs = &$this->Bahan_Aktif->LinkAttrs;
			$this->Cell_Rendered($this->Bahan_Aktif, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Dosis_Pemakaian
			$currentValue = $this->Dosis_Pemakaian->CurrentValue;
			$viewValue = &$this->Dosis_Pemakaian->ViewValue;
			$viewAttrs = &$this->Dosis_Pemakaian->ViewAttrs;
			$cellAttrs = &$this->Dosis_Pemakaian->CellAttrs;
			$hrefValue = &$this->Dosis_Pemakaian->HrefValue;
			$linkAttrs = &$this->Dosis_Pemakaian->LinkAttrs;
			$this->Cell_Rendered($this->Dosis_Pemakaian, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// Waktu_Aplikasi
			$currentValue = $this->Waktu_Aplikasi->CurrentValue;
			$viewValue = &$this->Waktu_Aplikasi->ViewValue;
			$viewAttrs = &$this->Waktu_Aplikasi->ViewAttrs;
			$cellAttrs = &$this->Waktu_Aplikasi->CellAttrs;
			$hrefValue = &$this->Waktu_Aplikasi->HrefValue;
			$linkAttrs = &$this->Waktu_Aplikasi->LinkAttrs;
			$this->Cell_Rendered($this->Waktu_Aplikasi, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// co_nama
			$currentValue = $this->co_nama->CurrentValue;
			$viewValue = &$this->co_nama->ViewValue;
			$viewAttrs = &$this->co_nama->ViewAttrs;
			$cellAttrs = &$this->co_nama->CellAttrs;
			$hrefValue = &$this->co_nama->HrefValue;
			$linkAttrs = &$this->co_nama->LinkAttrs;
			$this->Cell_Rendered($this->co_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// var_nama
			$currentValue = $this->var_nama->CurrentValue;
			$viewValue = &$this->var_nama->ViewValue;
			$viewAttrs = &$this->var_nama->ViewAttrs;
			$cellAttrs = &$this->var_nama->CellAttrs;
			$hrefValue = &$this->var_nama->HrefValue;
			$linkAttrs = &$this->var_nama->LinkAttrs;
			$this->Cell_Rendered($this->var_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// blok_nama
			$currentValue = $this->blok_nama->CurrentValue;
			$viewValue = &$this->blok_nama->ViewValue;
			$viewAttrs = &$this->blok_nama->ViewAttrs;
			$cellAttrs = &$this->blok_nama->CellAttrs;
			$hrefValue = &$this->blok_nama->HrefValue;
			$linkAttrs = &$this->blok_nama->LinkAttrs;
			$this->Cell_Rendered($this->blok_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// desa_nama
			$currentValue = $this->desa_nama->CurrentValue;
			$viewValue = &$this->desa_nama->ViewValue;
			$viewAttrs = &$this->desa_nama->ViewAttrs;
			$cellAttrs = &$this->desa_nama->CellAttrs;
			$hrefValue = &$this->desa_nama->HrefValue;
			$linkAttrs = &$this->desa_nama->LinkAttrs;
			$this->Cell_Rendered($this->desa_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// kec_nama
			$currentValue = $this->kec_nama->CurrentValue;
			$viewValue = &$this->kec_nama->ViewValue;
			$viewAttrs = &$this->kec_nama->ViewAttrs;
			$cellAttrs = &$this->kec_nama->CellAttrs;
			$hrefValue = &$this->kec_nama->HrefValue;
			$linkAttrs = &$this->kec_nama->LinkAttrs;
			$this->Cell_Rendered($this->kec_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// kab_nama
			$currentValue = $this->kab_nama->CurrentValue;
			$viewValue = &$this->kab_nama->ViewValue;
			$viewAttrs = &$this->kab_nama->ViewAttrs;
			$cellAttrs = &$this->kab_nama->CellAttrs;
			$hrefValue = &$this->kab_nama->HrefValue;
			$linkAttrs = &$this->kab_nama->LinkAttrs;
			$this->Cell_Rendered($this->kab_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// prov_nama
			$currentValue = $this->prov_nama->CurrentValue;
			$viewValue = &$this->prov_nama->ViewValue;
			$viewAttrs = &$this->prov_nama->ViewAttrs;
			$cellAttrs = &$this->prov_nama->CellAttrs;
			$hrefValue = &$this->prov_nama->HrefValue;
			$linkAttrs = &$this->prov_nama->LinkAttrs;
			$this->Cell_Rendered($this->prov_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// koord_nama
			$currentValue = $this->koord_nama->CurrentValue;
			$viewValue = &$this->koord_nama->ViewValue;
			$viewAttrs = &$this->koord_nama->ViewAttrs;
			$cellAttrs = &$this->koord_nama->CellAttrs;
			$hrefValue = &$this->koord_nama->HrefValue;
			$linkAttrs = &$this->koord_nama->LinkAttrs;
			$this->Cell_Rendered($this->koord_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// pet_nama
			$currentValue = $this->pet_nama->CurrentValue;
			$viewValue = &$this->pet_nama->ViewValue;
			$viewAttrs = &$this->pet_nama->ViewAttrs;
			$cellAttrs = &$this->pet_nama->CellAttrs;
			$hrefValue = &$this->pet_nama->HrefValue;
			$linkAttrs = &$this->pet_nama->LinkAttrs;
			$this->Cell_Rendered($this->pet_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->setupFieldCount();
	}

	// Accummulate grand summary
	protected function accumulateGrandSummary()
	{
		$this->TotalCount++;
		$cntgs = count($this->GrandSummaries);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Columns[$iy][0]) {
				$valwrk = $this->Values[$iy];
				if ($valwrk === NULL || !is_numeric($valwrk)) {
					if (!$this->Columns[$iy][1])
						$this->GrandCounts[$iy]++;
				} else {
					if (!$this->Columns[$iy][1] || $valwrk <> 0) {
						$this->GrandCounts[$iy]++;
						$this->GrandSummaries[$iy] += $valwrk;
						if ($this->GrandMinimums[$iy] === NULL) {
							$this->GrandMinimums[$iy] = $valwrk;
							$this->GrandMaximums[$iy] = $valwrk;
						} else {
							if ($this->GrandMinimums[$iy] > $valwrk)
								$this->GrandMinimums[$iy] = $valwrk;
							if ($this->GrandMaximums[$iy] < $valwrk)
								$this->GrandMaximums[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Load group db values if necessary
	protected function loadGroupDbValues()
	{
		$conn = &$this->getConnection();
	}

	// Set up popup
	protected function setupPopup()
	{
		global $ReportLanguage;
		$conn = &$this->getConnection();
		if ($this->DrillDown)
			return;

		// Process post back form
		if (IsPost()) {
			$name = Post("popup", ""); // Get popup form name
			if ($name <> "") {
				$arValues = Post("sel_$name");
				$cntValues = is_array($arValues) ? count($arValues) : 0;
				if ($cntValues > 0) {
					if (trim($arValues[0]) == "") // Select all
						$arValues = INIT_VALUE;
					$this->PopupName = $name;
					if (IsAdvancedFilterValue($arValues) || $arValues == INIT_VALUE)
						$this->PopupValue = $arValues;
					if (!MatchedArray($arValues, @$_SESSION["sel_$name"])) {
						if ($this->hasSessionFilterValues($name))
							$this->ExpiredExtendedFilter = $name; // Clear extended filter for this field
					}
					$_SESSION["sel_$name"] = $arValues;
					$_SESSION["rf_$name"] = Post("rf_$name", "");
					$_SESSION["rt_$name"] = Post("rt_$name", "");
					$this->resetPager();
				}
			}

		// Get 'reset' command
		} elseif (Get("cmd") !== NULL) {
			$cmd = Get("cmd");
			if (SameText($cmd, "reset")) {
				$this->resetPager();
			}
		}

		// Load selection criteria to array
	}

	// Setup field count
	protected function setupFieldCount()
	{
		$this->GroupColumnCount = 0;
		$this->SubGroupColumnCount = 0;
		$this->DetailColumnCount = 0;
		if ($this->k_id_kontrak->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_tgl_tanam->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_luas_lahan->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Jenis_Pestisida->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Merek->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Bahan_Aktif->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Dosis_Pemakaian->Visible)
			$this->DetailColumnCount += 1;
		if ($this->Waktu_Aplikasi->Visible)
			$this->DetailColumnCount += 1;
		if ($this->co_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->var_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->blok_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->desa_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->kec_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->kab_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->prov_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->koord_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->pet_nama->Visible)
			$this->DetailColumnCount += 1;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/") + 1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', "", $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("rpt", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Set up export options (extended)
	protected function setupExportOptionsExt()
	{
		global $ReportLanguage, $ReportOptions;
		$reportTypes = $ReportOptions["ReportTypes"];
		$item = &$this->ExportOptions->getItem("pdf");
		$item->Visible = TRUE;
		if ($item->Visible)
			$reportTypes["pdf"] = $ReportLanguage->phrase("ReportFormPdf");
		$item->Body = "<a class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportPdfUrl . "', '" . session_id() . "');\">" . $ReportLanguage->phrase("ExportToPDF") . "</a>";
		$ReportOptions["ReportTypes"] = $reportTypes;
	}

	// Export to HTML
	public function exportHtml($html)
	{

		//global $ExportFileName;
		//header('Content-Type: text/html' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
		//header('Content-Disposition: attachment; filename=' . $ExportFileName . '.html');

		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";

		// Save generate file for print
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
			$baseTag = "<base href=\"" . BaseUrl() . "\">";
			$html = preg_replace('/<head>/', '<head>' . $baseTag, $html);
			SaveFile($folder, $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file")
			Write($html);
		return $saveToFile;
	}

	// Export to Word
	public function exportWord($html)
	{
		global $ExportFileName;
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	SaveFile(ServerMapPath($folder), $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			AddHeader('Content-Type', 'application/vnd.ms-word' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
			AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.doc');
			Write($html);
		}
		return $saveToFile;
	}

	// Export to Excel
	public function exportExcel($html)
	{
		global $ExportFileName;
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	SaveFile(ServerMapPath($folder), $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			AddHeader('Content-Type', 'application/vnd.ms-excel' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
			AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.xls');
			Write($html);
		}
		return $saveToFile;
	}

	// Export PDF
	public function exportPdf($html)
	{
		global $ExportFileName, $PDF_MEMORY_LIMIT, $PDF_TIME_LIMIT, $PDF_IMAGE_SCALE_FACTOR;
		@ini_set("memory_limit", $PDF_MEMORY_LIMIT);
		set_time_limit($PDF_TIME_LIMIT);
		$html = CheckHtml($html);
		if (DEBUG_ENABLED) // Add debug message
			$html = str_replace("</body>", GetDebugMessage() . "</body>", $html);
		$dompdf = new \Dompdf\Dompdf(["pdf_backend" => "Cpdf"]);
		$doc = new \DOMDocument("1.0", "utf-8");
		@$doc->loadHTML('<?xml encoding="uft-8">' . ConvertToUtf8($html)); // Convert to utf-8
		$spans = $doc->getElementsByTagName("span");
		foreach ($spans as $span) {
			$classNames = $span->getAttribute("class");
			if ($classNames == "ew-filter-caption") // Insert colon
				$span->parentNode->insertBefore($doc->createElement("span", ":&nbsp;"), $span->nextSibling);
			elseif (preg_match('/\bicon\-\w+\b/', $classNames)) // Remove icons
				$span->parentNode->removeChild($span);
		}
		$images = $doc->getElementsByTagName("img");
		$pageSize = "a4";
		$pageOrientation = "portrait";
		$this->ExportPageOrientation = $pageOrientation;
		$portrait = SameText($pageOrientation, "portrait");
		foreach ($images as $image) {
			$imagefn = $image->getAttribute("src");
			if (file_exists($imagefn)) {
				$imagefn = realpath($imagefn);
				$size = getimagesize($imagefn); // Get image size
				if ($size[0] <> 0) {
					if (SameText($pageSize, "letter")) { // Letter paper (8.5 in. by 11 in.)
						$w = $portrait ? 216 : 279;
					} elseif (SameText($pageSize, "legal")) { // Legal paper (8.5 in. by 14 in.)
						$w = $portrait ? 216 : 356;
					} else {
						$w = $portrait ? 210 : 297; // A4 paper (210 mm by 297 mm)
					}
					$w = min($size[0], ($w - 20 * 2) / 25.4 * 72 * $PDF_IMAGE_SCALE_FACTOR); // Resize image, adjust the scale factor if necessary
					$h = $w / $size[0] * $size[1];
					$image->setAttribute("width", $w);
					$image->setAttribute("height", $h);
				}
			}
		}
		$html = $doc->saveHTML();
		$html = ConvertFromUtf8($html);
		$dompdf->load_html($html);
		$dompdf->set_paper($pageSize, $pageOrientation);
		$dompdf->render();
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
			SaveFile(ServerMapPath($folder), $fileName, $dompdf->output());
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			$exportFile = EndsText(".pdf", $ExportFileName) ? $ExportFileName : $ExportFileName . ".pdf";
			$dompdf->stream($exportFile, ["Attachment" => 1]); // 0 to open in browser, 1 to download
		}
		DeleteTempImages($html);
		return $saveToFile;
	}

	// Set up starting group
	protected function setupStartGroup()
	{

		// Exit if no groups
		if ($this->DisplayGroups == 0)
			return;
		$startGrp = ReportParam(TABLE_START_GROUP, "");
		$pageNo = ReportParam("pageno", "");

		// Check for a 'start' parameter
		if ($startGrp != "") {
			$this->StartGroup = $startGrp;
			$this->setStartGroup($this->StartGroup);
		} elseif ($pageNo != "") {
			if (is_numeric($pageNo)) {
				$this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
				if ($this->StartGroup <= 0) {
					$this->StartGroup = 1;
				} elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
					$this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
				}
				$this->setStartGroup($this->StartGroup);
			} else {
				$this->StartGroup = $this->getStartGroup();
			}
		} else {
			$this->StartGroup = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGroup) || $this->StartGroup == "") { // Avoid invalid start group counter
			$this->StartGroup = 1; // Reset start group counter
			$this->setStartGroup($this->StartGroup);
		} elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
			$this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
			$this->setStartGroup($this->StartGroup);
		} elseif (($this->StartGroup-1) % $this->DisplayGroups <> 0) {
			$this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
			$this->setStartGroup($this->StartGroup);
		}
	}

	// Reset pager
	protected function resetPager()
	{

		// Reset start position (reset command)
		$this->StartGroup = 1;
		$this->setStartGroup($this->StartGroup);
	}

	// Set up number of groups displayed per page
	protected function setupDisplayGroups()
	{
		if (ReportParam(TABLE_GROUP_PER_PAGE) !== NULL) {
			$wrk = ReportParam(TABLE_GROUP_PER_PAGE);
			if (is_numeric($wrk)) {
				$this->DisplayGroups = intval($wrk);
			} else {
				if (strtoupper($wrk) == "ALL") { // Display all groups
					$this->DisplayGroups = -1;
				} else {
					$this->DisplayGroups = 50; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGroups); // Save to session

			// Reset start position (reset command)
			$this->StartGroup = 1;
			$this->setStartGroup($this->StartGroup);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGroups = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGroups = 50; // Load default
			}
		}
	}

	// Get sort parameters based on sort links clicked
	protected function getSort()
	{
		if ($this->DrillDown)
			return "";
		$resetSort = ReportParam("cmd") === "resetsort";
		$orderBy = ReportParam("order", "");
		$orderType = ReportParam("ordertype", "");

		// Check for a resetsort command
		if ($resetSort) {
			$this->setOrderBy("");
			$this->setStartGroup(1);
			$this->k_id_kontrak->setSort("");
			$this->k_tgl_tanam->setSort("");
			$this->k_luas_lahan->setSort("");
			$this->Jenis_Pestisida->setSort("");
			$this->Merek->setSort("");
			$this->Bahan_Aktif->setSort("");
			$this->Dosis_Pemakaian->setSort("");
			$this->Waktu_Aplikasi->setSort("");
			$this->co_nama->setSort("");
			$this->var_nama->setSort("");
			$this->blok_nama->setSort("");
			$this->desa_nama->setSort("");
			$this->kec_nama->setSort("");
			$this->kab_nama->setSort("");
			$this->prov_nama->setSort("");
			$this->koord_nama->setSort("");
			$this->pet_nama->setSort("");

		// Check for an Order parameter
		} elseif ($orderBy <> "") {
			$this->CurrentOrder = $orderBy;
			$this->CurrentOrderType = $orderType;
			$sortSql = $this->sortSql();
			$this->setOrderBy($sortSql);
			$this->setStartGroup(1);
		}
		return $this->getOrderBy();
	}

	// Return extended filter
	protected function getExtendedFilter()
	{
		global $FormError;
		$filter = "";
		if ($this->DrillDown)
			return "";
		$postBack = IsPost();
		$restoreSession = TRUE;
		$setupFilter = FALSE;

		// Reset extended filter if filter changed
		if ($postBack) {

		// Reset search command
		} elseif (Get("cmd", "") == "reset") {

			// Load default values
			$this->setSessionFilterValues($this->k_id_kontrak->AdvancedSearch->SearchValue, $this->k_id_kontrak->AdvancedSearch->SearchOperator, $this->k_id_kontrak->AdvancedSearch->SearchCondition, $this->k_id_kontrak->AdvancedSearch->SearchValue2, $this->k_id_kontrak->AdvancedSearch->SearchOperator2, "k_id_kontrak"); // Field k_id_kontrak
			$this->setSessionFilterValues($this->k_tgl_tanam->AdvancedSearch->SearchValue, $this->k_tgl_tanam->AdvancedSearch->SearchOperator, $this->k_tgl_tanam->AdvancedSearch->SearchCondition, $this->k_tgl_tanam->AdvancedSearch->SearchValue2, $this->k_tgl_tanam->AdvancedSearch->SearchOperator2, "k_tgl_tanam"); // Field k_tgl_tanam
			$this->setSessionFilterValues($this->Jenis_Pestisida->AdvancedSearch->SearchValue, $this->Jenis_Pestisida->AdvancedSearch->SearchOperator, $this->Jenis_Pestisida->AdvancedSearch->SearchCondition, $this->Jenis_Pestisida->AdvancedSearch->SearchValue2, $this->Jenis_Pestisida->AdvancedSearch->SearchOperator2, "Jenis_Pestisida"); // Field Jenis_Pestisida
			$this->setSessionFilterValues($this->co_nama->AdvancedSearch->SearchValue, $this->co_nama->AdvancedSearch->SearchOperator, $this->co_nama->AdvancedSearch->SearchCondition, $this->co_nama->AdvancedSearch->SearchValue2, $this->co_nama->AdvancedSearch->SearchOperator2, "co_nama"); // Field co_nama
			$this->setSessionFilterValues($this->var_nama->AdvancedSearch->SearchValue, $this->var_nama->AdvancedSearch->SearchOperator, $this->var_nama->AdvancedSearch->SearchCondition, $this->var_nama->AdvancedSearch->SearchValue2, $this->var_nama->AdvancedSearch->SearchOperator2, "var_nama"); // Field var_nama
			$this->setSessionFilterValues($this->desa_nama->AdvancedSearch->SearchValue, $this->desa_nama->AdvancedSearch->SearchOperator, $this->desa_nama->AdvancedSearch->SearchCondition, $this->desa_nama->AdvancedSearch->SearchValue2, $this->desa_nama->AdvancedSearch->SearchOperator2, "desa_nama"); // Field desa_nama
			$this->setSessionFilterValues($this->kec_nama->AdvancedSearch->SearchValue, $this->kec_nama->AdvancedSearch->SearchOperator, $this->kec_nama->AdvancedSearch->SearchCondition, $this->kec_nama->AdvancedSearch->SearchValue2, $this->kec_nama->AdvancedSearch->SearchOperator2, "kec_nama"); // Field kec_nama
			$this->setSessionFilterValues($this->kab_nama->AdvancedSearch->SearchValue, $this->kab_nama->AdvancedSearch->SearchOperator, $this->kab_nama->AdvancedSearch->SearchCondition, $this->kab_nama->AdvancedSearch->SearchValue2, $this->kab_nama->AdvancedSearch->SearchOperator2, "kab_nama"); // Field kab_nama
			$this->setSessionFilterValues($this->prov_nama->AdvancedSearch->SearchValue, $this->prov_nama->AdvancedSearch->SearchOperator, $this->prov_nama->AdvancedSearch->SearchCondition, $this->prov_nama->AdvancedSearch->SearchValue2, $this->prov_nama->AdvancedSearch->SearchOperator2, "prov_nama"); // Field prov_nama
			$this->setSessionFilterValues($this->pet_nama->AdvancedSearch->SearchValue, $this->pet_nama->AdvancedSearch->SearchOperator, $this->pet_nama->AdvancedSearch->SearchCondition, $this->pet_nama->AdvancedSearch->SearchValue2, $this->pet_nama->AdvancedSearch->SearchOperator2, "pet_nama"); // Field pet_nama

			//$setupFilter = TRUE; // No need to set up, just use default
		} else {
			$restoreSession = !$this->SearchCommand;

			// Field k_id_kontrak
			if ($this->getFilterValues($this->k_id_kontrak)) {
				$setupFilter = TRUE;
			}

			// Field k_tgl_tanam
			if ($this->getFilterValues($this->k_tgl_tanam)) {
				$setupFilter = TRUE;
			}

			// Field Jenis_Pestisida
			if ($this->getFilterValues($this->Jenis_Pestisida)) {
				$setupFilter = TRUE;
			}

			// Field co_nama
			if ($this->getFilterValues($this->co_nama)) {
				$setupFilter = TRUE;
			}

			// Field var_nama
			if ($this->getFilterValues($this->var_nama)) {
				$setupFilter = TRUE;
			}

			// Field desa_nama
			if ($this->getFilterValues($this->desa_nama)) {
				$setupFilter = TRUE;
			}

			// Field kec_nama
			if ($this->getFilterValues($this->kec_nama)) {
				$setupFilter = TRUE;
			}

			// Field kab_nama
			if ($this->getFilterValues($this->kab_nama)) {
				$setupFilter = TRUE;
			}

			// Field prov_nama
			if ($this->getFilterValues($this->prov_nama)) {
				$setupFilter = TRUE;
			}

			// Field pet_nama
			if ($this->getFilterValues($this->pet_nama)) {
				$setupFilter = TRUE;
			}
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				return $filter;
			}
		}

		// Restore session
		if ($restoreSession) {
			$this->getSessionFilterValues($this->k_id_kontrak); // Field k_id_kontrak
			$this->getSessionFilterValues($this->k_tgl_tanam); // Field k_tgl_tanam
			$this->getSessionFilterValues($this->Jenis_Pestisida); // Field Jenis_Pestisida
			$this->getSessionFilterValues($this->co_nama); // Field co_nama
			$this->getSessionFilterValues($this->var_nama); // Field var_nama
			$this->getSessionFilterValues($this->desa_nama); // Field desa_nama
			$this->getSessionFilterValues($this->kec_nama); // Field kec_nama
			$this->getSessionFilterValues($this->kab_nama); // Field kab_nama
			$this->getSessionFilterValues($this->prov_nama); // Field prov_nama
			$this->getSessionFilterValues($this->pet_nama); // Field pet_nama
		}

		// Call page filter validated event
		$this->Page_FilterValidated();

		// Build SQL
		$this->buildExtendedFilter($this->k_id_kontrak, $filter, FALSE, TRUE); // Field k_id_kontrak
		$this->buildExtendedFilter($this->k_tgl_tanam, $filter, FALSE, TRUE); // Field k_tgl_tanam
		$this->buildExtendedFilter($this->Jenis_Pestisida, $filter, FALSE, TRUE); // Field Jenis_Pestisida
		$this->buildExtendedFilter($this->co_nama, $filter, FALSE, TRUE); // Field co_nama
		$this->buildExtendedFilter($this->var_nama, $filter, FALSE, TRUE); // Field var_nama
		$this->buildExtendedFilter($this->desa_nama, $filter, FALSE, TRUE); // Field desa_nama
		$this->buildExtendedFilter($this->kec_nama, $filter, FALSE, TRUE); // Field kec_nama
		$this->buildExtendedFilter($this->kab_nama, $filter, FALSE, TRUE); // Field kab_nama
		$this->buildExtendedFilter($this->prov_nama, $filter, FALSE, TRUE); // Field prov_nama
		$this->buildExtendedFilter($this->pet_nama, $filter, FALSE, TRUE); // Field pet_nama

		// Save parms to session
		$this->setSessionFilterValues($this->k_id_kontrak->AdvancedSearch->SearchValue, $this->k_id_kontrak->AdvancedSearch->SearchOperator, $this->k_id_kontrak->AdvancedSearch->SearchCondition, $this->k_id_kontrak->AdvancedSearch->SearchValue2, $this->k_id_kontrak->AdvancedSearch->SearchOperator2, "k_id_kontrak"); // Field k_id_kontrak
		$this->setSessionFilterValues($this->k_tgl_tanam->AdvancedSearch->SearchValue, $this->k_tgl_tanam->AdvancedSearch->SearchOperator, $this->k_tgl_tanam->AdvancedSearch->SearchCondition, $this->k_tgl_tanam->AdvancedSearch->SearchValue2, $this->k_tgl_tanam->AdvancedSearch->SearchOperator2, "k_tgl_tanam"); // Field k_tgl_tanam
		$this->setSessionFilterValues($this->Jenis_Pestisida->AdvancedSearch->SearchValue, $this->Jenis_Pestisida->AdvancedSearch->SearchOperator, $this->Jenis_Pestisida->AdvancedSearch->SearchCondition, $this->Jenis_Pestisida->AdvancedSearch->SearchValue2, $this->Jenis_Pestisida->AdvancedSearch->SearchOperator2, "Jenis_Pestisida"); // Field Jenis_Pestisida
		$this->setSessionFilterValues($this->co_nama->AdvancedSearch->SearchValue, $this->co_nama->AdvancedSearch->SearchOperator, $this->co_nama->AdvancedSearch->SearchCondition, $this->co_nama->AdvancedSearch->SearchValue2, $this->co_nama->AdvancedSearch->SearchOperator2, "co_nama"); // Field co_nama
		$this->setSessionFilterValues($this->var_nama->AdvancedSearch->SearchValue, $this->var_nama->AdvancedSearch->SearchOperator, $this->var_nama->AdvancedSearch->SearchCondition, $this->var_nama->AdvancedSearch->SearchValue2, $this->var_nama->AdvancedSearch->SearchOperator2, "var_nama"); // Field var_nama
		$this->setSessionFilterValues($this->desa_nama->AdvancedSearch->SearchValue, $this->desa_nama->AdvancedSearch->SearchOperator, $this->desa_nama->AdvancedSearch->SearchCondition, $this->desa_nama->AdvancedSearch->SearchValue2, $this->desa_nama->AdvancedSearch->SearchOperator2, "desa_nama"); // Field desa_nama
		$this->setSessionFilterValues($this->kec_nama->AdvancedSearch->SearchValue, $this->kec_nama->AdvancedSearch->SearchOperator, $this->kec_nama->AdvancedSearch->SearchCondition, $this->kec_nama->AdvancedSearch->SearchValue2, $this->kec_nama->AdvancedSearch->SearchOperator2, "kec_nama"); // Field kec_nama
		$this->setSessionFilterValues($this->kab_nama->AdvancedSearch->SearchValue, $this->kab_nama->AdvancedSearch->SearchOperator, $this->kab_nama->AdvancedSearch->SearchCondition, $this->kab_nama->AdvancedSearch->SearchValue2, $this->kab_nama->AdvancedSearch->SearchOperator2, "kab_nama"); // Field kab_nama
		$this->setSessionFilterValues($this->prov_nama->AdvancedSearch->SearchValue, $this->prov_nama->AdvancedSearch->SearchOperator, $this->prov_nama->AdvancedSearch->SearchCondition, $this->prov_nama->AdvancedSearch->SearchValue2, $this->prov_nama->AdvancedSearch->SearchOperator2, "prov_nama"); // Field prov_nama
		$this->setSessionFilterValues($this->pet_nama->AdvancedSearch->SearchValue, $this->pet_nama->AdvancedSearch->SearchOperator, $this->pet_nama->AdvancedSearch->SearchCondition, $this->pet_nama->AdvancedSearch->SearchValue2, $this->pet_nama->AdvancedSearch->SearchOperator2, "pet_nama"); // Field pet_nama

		// Setup filter
		if ($setupFilter) {
		}
		return $filter;
	}

	// Build dropdown filter
	protected function buildDropDownFilter(&$fld, &$filterClause, $fldOpr, $default = FALSE, $saveFilter = FALSE)
	{
		$fldVal = ($default) ? $fld->DefaultDropDownValue : $fld->DropDownValue;
		$sql = "";
		if (is_array($fldVal)) {
			foreach ($fldVal as $val) {
				$wrk = $this->getDropDownFilter($fld, $val, $fldOpr);

				// Call Page Filtering event
				if (!StartsString("@@", $val))
					$this->Page_Filtering($fld, $wrk, "dropdown", $fldOpr, $val);
				if ($wrk <> "") {
					if ($sql <> "")
						$sql .= " OR " . $wrk;
					else
						$sql = $wrk;
				}
			}
		} else {
			$sql = $this->getDropDownFilter($fld, $fldVal, $fldOpr);

			// Call Page Filtering event
			if (!StartsString("@@", $fldVal))
				$this->Page_Filtering($fld, $sql, "dropdown", $fldOpr, $fldVal);
		}
		if ($sql <> "") {
			AddFilter($filterClause, $sql);
			if ($saveFilter) $fld->CurrentFilter = $sql;
		}
	}

	// Get dropdown filter
	protected function getDropDownFilter(&$fld, $fldVal, $fldOpr)
	{
		$fldName = $fld->Name;
		$fldExpression = $fld->Expression;
		$fldDataType = $fld->DataType;
		$fldDelimiter = $fld->Delimiter;
		$fldVal = strval($fldVal);
		if ($fldOpr == "") $fldOpr = "=";
		$wrk = "";
		if (SameString($fldVal, NULL_VALUE)) {
			$wrk = $fldExpression . " IS NULL";
		} elseif (SameString($fldVal, NOT_NULL_VALUE)) {
			$wrk = $fldExpression . " IS NOT NULL";
		} elseif (SameString($fldVal, EMPTY_VALUE)) {
			$wrk = $fldExpression . " = ''";
		} elseif (SameString($fldVal, ALL_VALUE)) {
			$wrk = "1 = 1";
		} else {
			if (StartsString("@@", $fldVal)) {
				$wrk = $this->getCustomFilter($fld, $fldVal, $this->Dbid);
			} elseif ($fldDelimiter <> "" && trim($fldVal) <> "" && ($fldDataType == DATATYPE_STRING || $fldDataType == DATATYPE_MEMO)) {
				$wrk = GetMultiValueSearchSql($fldExpression, trim($fldVal), $this->Dbid);
			} else {
				if ($fldVal <> "" && $fldVal <> INIT_VALUE) {
					if ($fldDataType == DATATYPE_DATE && $fldOpr <> "") {
						$wrk = GetDateFilterSql($fldExpression, $fldOpr, $fldVal, $fldDataType, $this->Dbid);
					} else {
						$wrk = GetFilterSql($fldOpr, $fldVal, $fldDataType, $this->Dbid);
						if ($wrk <> "") $wrk = $fldExpression . $wrk;
					}
				}
			}
		}
		return $wrk;
	}

	// Get custom filter
	protected function getCustomFilter(&$fld, $fldVal, $dbid = 0)
	{
		$wrk = "";
		if (is_array($fld->AdvancedFilters)) {
			foreach ($fld->AdvancedFilters as $filter) {
				if ($filter->ID == $fldVal && $filter->Enabled) {
					$fldExpr = $fld->Expression;
					$fn = $filter->FunctionName;
					$wrkid = StartsString("@@", $filter->ID) ? substr($filter->ID, 2) : $filter->ID;
					if ($fn <> "") {
						$fn = PROJECT_NAMESPACE . $fn;
						$wrk = $fn($fldExpr, $dbid);
					} else
						$wrk = "";
					$this->Page_Filtering($fld, $wrk, "custom", $wrkid);
					break;
				}
			}
		}
		return $wrk;
	}

	// Build extended filter
	protected function buildExtendedFilter(&$fld, &$filterClause, $default = FALSE, $saveFilter = FALSE)
	{
		$wrk = GetExtendedFilter($fld, $default, $this->Dbid);
		if (!$default)
			$this->Page_Filtering($fld, $wrk, "extended", $fld->AdvancedSearch->SearchOperator, $fld->AdvancedSearch->SearchValue, $fld->AdvancedSearch->SearchCondition, $fld->AdvancedSearch->SearchOperator2, $fld->AdvancedSearch->SearchValue2);
		if ($wrk <> "") {
			AddFilter($filterClause, $wrk);
			if ($saveFilter) $fld->CurrentFilter = $wrk;
		}
	}

	// Get drop down value from querystring
	protected function getDropDownValue(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		if (IsPost())
			return FALSE; // Skip post back
		$opr = Get("z_$parm");
		if ($opr !== NULL)
			$fld->AdvancedSearch->SearchOperator = $opr;
		$val = Get("x_$parm");
		if ($val !== NULL) {
			if ($fld->isMultiSelect() && !is_array($val)) // Split values for modal lookup
				$fld->DropDownValue = explode(LOOKUP_FILTER_VALUE_SEPARATOR, $val);
			else
				$fld->DropDownValue = $val;
			return TRUE;
		}
		return FALSE;
	}

	// Get filter values from querystring
	protected function getFilterValues(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		if (IsPost())
			return; // Skip post back
		$got = FALSE;
		if (Get("x_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchValue = Get("x_$parm");
			$got = TRUE;
		}
		if (Get("z_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchOperator = Get("z_$parm");
			$got = TRUE;
		}
		if (Get("v_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchCondition = Get("v_$parm");
			$got = TRUE;
		}
		if (Get("y_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchValue2 = Get("y_$parm");
			$got = TRUE;
		}
		if (Get("w_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchOperator2 = Get("w_$parm");
			$got = TRUE;
		}
		return $got;
	}

	// Set default ext filter
	protected function setDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
	{
		$fld->AdvancedSearch->SearchValueDefault = $sv1; // Default ext filter value 1
		$fld->AdvancedSearch->SearchValue2Default = $sv2; // Default ext filter value 2 (if operator 2 is enabled)
		$fld->AdvancedSearch->SearchOperatorDefault = $so1; // Default search operator 1
		$fld->AdvancedSearch->SearchOperator2Default = $so2; // Default search operator 2 (if operator 2 is enabled)
		$fld->AdvancedSearch->SearchConditionDefault = $sc; // Default search condition (if operator 2 is enabled)
	}

	// Apply default ext filter
	protected function applyDefaultExtFilter(&$fld)
	{
		$fld->AdvancedSearch->SearchValue = $fld->AdvancedSearch->SearchValueDefault;
		$fld->AdvancedSearch->SearchValue2 = $fld->AdvancedSearch->SearchValue2Default;
		$fld->AdvancedSearch->SearchOperator = $fld->AdvancedSearch->SearchOperatorDefault;
		$fld->AdvancedSearch->SearchOperator2 = $fld->AdvancedSearch->SearchOperator2Default;
		$fld->AdvancedSearch->SearchCondition = $fld->AdvancedSearch->SearchConditionDefault;
	}

	// Check if Text Filter applied
	protected function textFilterApplied(&$fld)
	{
		return (strval($fld->AdvancedSearch->SearchValue) <> strval($fld->AdvancedSearch->SearchValueDefault) ||
			strval($fld->AdvancedSearch->SearchValue2) <> strval($fld->AdvancedSearch->SearchValue2Default) ||
			(strval($fld->AdvancedSearch->SearchValue) <> "" &&
				strval($fld->AdvancedSearch->SearchOperator) <> strval($fld->AdvancedSearch->SearchOperatorDefault)) ||
			(strval($fld->AdvancedSearch->SearchValue2) <> "" &&
				strval($fld->AdvancedSearch->SearchOperator2) <> strval($fld->AdvancedSearch->SearchOperator2Default)) ||
			strval($fld->AdvancedSearch->SearchCondition) <> strval($fld->AdvancedSearch->SearchConditionDefault));
	}

	// Check if Non-Text Filter applied
	protected function nonTextFilterApplied(&$fld)
	{
		if (is_array($fld->DropDownValue)) {
			if (is_array($fld->DefaultDropDownValue)) {
				if (count($fld->DefaultDropDownValue) <> count($fld->DropDownValue))
					return TRUE;
				else
					return (count(array_diff($fld->DefaultDropDownValue, $fld->DropDownValue)) <> 0);
			} else {
				return TRUE;
			}
		} else {
			if (is_array($fld->DefaultDropDownValue))
				return TRUE;
			else
				$v1 = strval($fld->DefaultDropDownValue);
			if ($v1 == INIT_VALUE)
				$v1 = "";
			$v2 = strval($fld->DropDownValue);
			if ($v2 == INIT_VALUE || $v2 == ALL_VALUE)
				$v2 = "";
			return ($v1 <> $v2);
		}
	}

	// Get dropdown value from session
	protected function getSessionDropDownValue(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		$this->getSessionValue($fld->DropDownValue, 'x_view5_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator, 'z_view5_' . $parm);
	}

	// Get filter values from session
	protected function getSessionFilterValues(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		$this->getSessionValue($fld->AdvancedSearch->SearchValue, 'x_view5_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator, 'z_view5_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchCondition, 'v_view5_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchValue2, 'y_view5_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator2, 'w_view5_' . $parm);
	}

	// Get value from session
	protected function getSessionValue(&$sv, $sn)
	{
		if (array_key_exists($sn, $_SESSION))
			$sv = $_SESSION[$sn];
	}

	// Set dropdown value to session
	protected function setSessionDropDownValue($sv, $so, $parm)
	{
		$_SESSION['x_view5_' . $parm] = $sv;
		$_SESSION['z_view5_' . $parm] = $so;
	}

	// Set filter values to session
	protected function setSessionFilterValues($sv1, $so1, $sc, $sv2, $so2, $parm)
	{
		$_SESSION['x_view5_' . $parm] = $sv1;
		$_SESSION['z_view5_' . $parm] = $so1;
		$_SESSION['v_view5_' . $parm] = $sc;
		$_SESSION['y_view5_' . $parm] = $sv2;
		$_SESSION['w_view5_' . $parm] = $so2;
	}

	// Check if has session filter values
	protected function hasSessionFilterValues($parm)
	{
		return (@$_SESSION['x_' . $parm] <> "" && @$_SESSION['x_' . $parm] <> INIT_VALUE ||
			@$_SESSION['x_' . $parm] <> "" && @$_SESSION['x_' . $parm] <> INIT_VALUE ||
			@$_SESSION['y_' . $parm] <> "" && @$_SESSION['y_' . $parm] <> INIT_VALUE);
	}

	// Dropdown filter exist
	protected function dropDownFilterExist(&$fld, $fldOpr)
	{
		$wrk = "";
		$this->buildDropDownFilter($fld, $wrk, $fldOpr);
		return ($wrk <> "");
	}

	// Extended filter exist
	protected function extendedFilterExist(&$fld)
	{
		$extWrk = "";
		$this->buildExtendedFilter($fld, $extWrk);
		return ($extWrk <> "");
	}

	// Validate form
	protected function validateForm()
	{
		global $ReportLanguage, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if (!CheckDate($this->k_tgl_tanam->AdvancedSearch->SearchValue)) {
			AddMessage($FormError, $this->k_tgl_tanam->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			$FormError .= ($FormError <> "") ? "<p>&nbsp;</p>" : "";
			$FormError .= $formCustomError;
		}
		return $validateForm;
	}

	// Clear selection stored in session
	protected function clearSessionSelection($parm)
	{
		$_SESSION["sel_view5_$parm"] = "";
		$_SESSION["rf_view5_$parm"] = "";
		$_SESSION["rt_view5_$parm"] = "";
	}

	// Load selection from session
	protected function loadSelectionFromSession($parm)
	{
		foreach ($this->fields as $fld) {
			if ($fld->Param == $parm) {
				$fld->SelectionList = @$_SESSION["sel_view5_$parm"];
				$fld->RangeFrom = @$_SESSION["rf_view5_$parm"];
				$fld->RangeTo = @$_SESSION["rt_view5_$parm"];
				break;
			}
		}
	}

	// Load default value for filters
	protected function loadDefaultFilters()
	{

		/**
		* Set up default values for non Text filters
		*/

		/**
		* Set up default values for extended filters
		* function setDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
		* Parameters:
		* $fld - Field object
		* $so1 - Default search operator 1
		* $sv1 - Default ext filter value 1
		* $sc - Default search condition (if operator 2 is enabled)
		* $so2 - Default search operator 2 (if operator 2 is enabled)
		* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
		*/
		// Field k_id_kontrak

		$this->setDefaultExtFilter($this->k_id_kontrak, "LIKE", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->k_id_kontrak);

		// Field k_tgl_tanam
		$this->setDefaultExtFilter($this->k_tgl_tanam, "=", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->k_tgl_tanam);

		// Field Jenis_Pestisida
		$this->setDefaultExtFilter($this->Jenis_Pestisida, "LIKE", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->Jenis_Pestisida);

		// Field co_nama
		$this->setDefaultExtFilter($this->co_nama, "LIKE", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->co_nama);

		// Field var_nama
		$this->setDefaultExtFilter($this->var_nama, "LIKE", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->var_nama);

		// Field desa_nama
		$this->setDefaultExtFilter($this->desa_nama, "LIKE", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->desa_nama);

		// Field kec_nama
		$this->setDefaultExtFilter($this->kec_nama, "LIKE", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->kec_nama);

		// Field kab_nama
		$this->setDefaultExtFilter($this->kab_nama, "LIKE", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->kab_nama);

		// Field prov_nama
		$this->setDefaultExtFilter($this->prov_nama, "LIKE", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->prov_nama);

		// Field pet_nama
		$this->setDefaultExtFilter($this->pet_nama, "LIKE", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->pet_nama);

		/**
		* Set up default values for popup filters
		*/
	}

	// Check if filter applied
	protected function checkFilter()
	{

		// Check k_id_kontrak text filter
		if ($this->textFilterApplied($this->k_id_kontrak))
			return TRUE;

		// Check k_tgl_tanam text filter
		if ($this->textFilterApplied($this->k_tgl_tanam))
			return TRUE;

		// Check Jenis_Pestisida text filter
		if ($this->textFilterApplied($this->Jenis_Pestisida))
			return TRUE;

		// Check co_nama text filter
		if ($this->textFilterApplied($this->co_nama))
			return TRUE;

		// Check var_nama text filter
		if ($this->textFilterApplied($this->var_nama))
			return TRUE;

		// Check desa_nama text filter
		if ($this->textFilterApplied($this->desa_nama))
			return TRUE;

		// Check kec_nama text filter
		if ($this->textFilterApplied($this->kec_nama))
			return TRUE;

		// Check kab_nama text filter
		if ($this->textFilterApplied($this->kab_nama))
			return TRUE;

		// Check prov_nama text filter
		if ($this->textFilterApplied($this->prov_nama))
			return TRUE;

		// Check pet_nama text filter
		if ($this->textFilterApplied($this->pet_nama))
			return TRUE;
		return FALSE;
	}

	// Show list of filters
	public function showFilterList($showDate = FALSE)
	{
		global $ReportLanguage;

		// Initialize
		$filterList = "";
		$captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
		$captionSuffix = $this->isExport("email") ? ": " : "";

		// Field k_id_kontrak
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->k_id_kontrak, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_id_kontrak->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field k_tgl_tanam
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->k_tgl_tanam, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_tgl_tanam->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field Jenis_Pestisida
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->Jenis_Pestisida, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Jenis_Pestisida->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field co_nama
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->co_nama, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->co_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field var_nama
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->var_nama, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->var_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field desa_nama
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->desa_nama, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->desa_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field kec_nama
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->kec_nama, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->kec_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field kab_nama
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->kab_nama, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->kab_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field prov_nama
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->prov_nama, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->prov_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field pet_nama
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->pet_nama, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pet_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";
		$divdataclass = "";

		// Show Filters
		if ($filterList <> "" || $showDate) {
			$message = "<div" . $divdataclass . "><div id=\"ew-filter-list\" class=\"alert alert-info d-table\">";
			if ($showDate)
				$message .= "<div id=\"ew-current-date\">" . $ReportLanguage->phrase("ReportGeneratedDate") . FormatDateTime(date("Y-m-d H:i:s"), 1) . "</div>";
			if ($filterList <> "")
				$message .= "<div id=\"ew-current-filters\">" . $ReportLanguage->phrase("CurrentFilters") . "</div>" . $filterList;
			$message .= "</div></div>";
			$this->Message_Showing($message, "");
			Write($message);
		}
	}

	// Get list of filters
	public function getFilterList()
	{

		// Initialize
		$filterList = "";

		// Field k_id_kontrak
		$wrk = "";
		if ($this->k_id_kontrak->AdvancedSearch->SearchValue <> "" || $this->k_id_kontrak->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_k_id_kontrak\":\"" . JsEncode($this->k_id_kontrak->AdvancedSearch->SearchValue) . "\"," .
				"\"z_k_id_kontrak\":\"" . JsEncode($this->k_id_kontrak->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_k_id_kontrak\":\"" . JsEncode($this->k_id_kontrak->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_k_id_kontrak\":\"" . JsEncode($this->k_id_kontrak->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_k_id_kontrak\":\"" . JsEncode($this->k_id_kontrak->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field k_tgl_tanam
		$wrk = "";
		if ($this->k_tgl_tanam->AdvancedSearch->SearchValue <> "" || $this->k_tgl_tanam->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_k_tgl_tanam\":\"" . JsEncode($this->k_tgl_tanam->AdvancedSearch->SearchValue) . "\"," .
				"\"z_k_tgl_tanam\":\"" . JsEncode($this->k_tgl_tanam->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_k_tgl_tanam\":\"" . JsEncode($this->k_tgl_tanam->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_k_tgl_tanam\":\"" . JsEncode($this->k_tgl_tanam->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_k_tgl_tanam\":\"" . JsEncode($this->k_tgl_tanam->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field Jenis_Pestisida
		$wrk = "";
		if ($this->Jenis_Pestisida->AdvancedSearch->SearchValue <> "" || $this->Jenis_Pestisida->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_Jenis_Pestisida\":\"" . JsEncode($this->Jenis_Pestisida->AdvancedSearch->SearchValue) . "\"," .
				"\"z_Jenis_Pestisida\":\"" . JsEncode($this->Jenis_Pestisida->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_Jenis_Pestisida\":\"" . JsEncode($this->Jenis_Pestisida->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_Jenis_Pestisida\":\"" . JsEncode($this->Jenis_Pestisida->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_Jenis_Pestisida\":\"" . JsEncode($this->Jenis_Pestisida->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field co_nama
		$wrk = "";
		if ($this->co_nama->AdvancedSearch->SearchValue <> "" || $this->co_nama->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_co_nama\":\"" . JsEncode($this->co_nama->AdvancedSearch->SearchValue) . "\"," .
				"\"z_co_nama\":\"" . JsEncode($this->co_nama->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_co_nama\":\"" . JsEncode($this->co_nama->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_co_nama\":\"" . JsEncode($this->co_nama->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_co_nama\":\"" . JsEncode($this->co_nama->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field var_nama
		$wrk = "";
		if ($this->var_nama->AdvancedSearch->SearchValue <> "" || $this->var_nama->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_var_nama\":\"" . JsEncode($this->var_nama->AdvancedSearch->SearchValue) . "\"," .
				"\"z_var_nama\":\"" . JsEncode($this->var_nama->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_var_nama\":\"" . JsEncode($this->var_nama->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_var_nama\":\"" . JsEncode($this->var_nama->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_var_nama\":\"" . JsEncode($this->var_nama->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field desa_nama
		$wrk = "";
		if ($this->desa_nama->AdvancedSearch->SearchValue <> "" || $this->desa_nama->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_desa_nama\":\"" . JsEncode($this->desa_nama->AdvancedSearch->SearchValue) . "\"," .
				"\"z_desa_nama\":\"" . JsEncode($this->desa_nama->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_desa_nama\":\"" . JsEncode($this->desa_nama->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_desa_nama\":\"" . JsEncode($this->desa_nama->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_desa_nama\":\"" . JsEncode($this->desa_nama->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field kec_nama
		$wrk = "";
		if ($this->kec_nama->AdvancedSearch->SearchValue <> "" || $this->kec_nama->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_kec_nama\":\"" . JsEncode($this->kec_nama->AdvancedSearch->SearchValue) . "\"," .
				"\"z_kec_nama\":\"" . JsEncode($this->kec_nama->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_kec_nama\":\"" . JsEncode($this->kec_nama->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_kec_nama\":\"" . JsEncode($this->kec_nama->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_kec_nama\":\"" . JsEncode($this->kec_nama->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field kab_nama
		$wrk = "";
		if ($this->kab_nama->AdvancedSearch->SearchValue <> "" || $this->kab_nama->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_kab_nama\":\"" . JsEncode($this->kab_nama->AdvancedSearch->SearchValue) . "\"," .
				"\"z_kab_nama\":\"" . JsEncode($this->kab_nama->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_kab_nama\":\"" . JsEncode($this->kab_nama->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_kab_nama\":\"" . JsEncode($this->kab_nama->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_kab_nama\":\"" . JsEncode($this->kab_nama->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field prov_nama
		$wrk = "";
		if ($this->prov_nama->AdvancedSearch->SearchValue <> "" || $this->prov_nama->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_prov_nama\":\"" . JsEncode($this->prov_nama->AdvancedSearch->SearchValue) . "\"," .
				"\"z_prov_nama\":\"" . JsEncode($this->prov_nama->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_prov_nama\":\"" . JsEncode($this->prov_nama->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_prov_nama\":\"" . JsEncode($this->prov_nama->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_prov_nama\":\"" . JsEncode($this->prov_nama->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field pet_nama
		$wrk = "";
		if ($this->pet_nama->AdvancedSearch->SearchValue <> "" || $this->pet_nama->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_pet_nama\":\"" . JsEncode($this->pet_nama->AdvancedSearch->SearchValue) . "\"," .
				"\"z_pet_nama\":\"" . JsEncode($this->pet_nama->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_pet_nama\":\"" . JsEncode($this->pet_nama->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_pet_nama\":\"" . JsEncode($this->pet_nama->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_pet_nama\":\"" . JsEncode($this->pet_nama->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Return filter list in json
		if ($filterList <> "")
			return "{\"data\":{" . $filterList . "}}";
		else
			return "null";
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd", "") <> "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter", ""), TRUE);
		return $this->setupFilterList($filter);
	}

	// Setup list of filters
	protected function setupFilterList($filter)
	{
		if (!is_array($filter))
			return FALSE;

		// Field k_id_kontrak
		$restoreFilter = FALSE;
		if (array_key_exists("x_k_id_kontrak", $filter) || array_key_exists("z_k_id_kontrak", $filter) ||
			array_key_exists("v_k_id_kontrak", $filter) ||
			array_key_exists("y_k_id_kontrak", $filter) || array_key_exists("w_k_id_kontrak", $filter)) {
			$this->setSessionFilterValues(@$filter["x_k_id_kontrak"], @$filter["z_k_id_kontrak"], @$filter["v_k_id_kontrak"], @$filter["y_k_id_kontrak"], @$filter["w_k_id_kontrak"], "k_id_kontrak");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "k_id_kontrak");
		}

		// Field k_tgl_tanam
		$restoreFilter = FALSE;
		if (array_key_exists("x_k_tgl_tanam", $filter) || array_key_exists("z_k_tgl_tanam", $filter) ||
			array_key_exists("v_k_tgl_tanam", $filter) ||
			array_key_exists("y_k_tgl_tanam", $filter) || array_key_exists("w_k_tgl_tanam", $filter)) {
			$this->setSessionFilterValues(@$filter["x_k_tgl_tanam"], @$filter["z_k_tgl_tanam"], @$filter["v_k_tgl_tanam"], @$filter["y_k_tgl_tanam"], @$filter["w_k_tgl_tanam"], "k_tgl_tanam");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "k_tgl_tanam");
		}

		// Field Jenis_Pestisida
		$restoreFilter = FALSE;
		if (array_key_exists("x_Jenis_Pestisida", $filter) || array_key_exists("z_Jenis_Pestisida", $filter) ||
			array_key_exists("v_Jenis_Pestisida", $filter) ||
			array_key_exists("y_Jenis_Pestisida", $filter) || array_key_exists("w_Jenis_Pestisida", $filter)) {
			$this->setSessionFilterValues(@$filter["x_Jenis_Pestisida"], @$filter["z_Jenis_Pestisida"], @$filter["v_Jenis_Pestisida"], @$filter["y_Jenis_Pestisida"], @$filter["w_Jenis_Pestisida"], "Jenis_Pestisida");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "Jenis_Pestisida");
		}

		// Field co_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_co_nama", $filter) || array_key_exists("z_co_nama", $filter) ||
			array_key_exists("v_co_nama", $filter) ||
			array_key_exists("y_co_nama", $filter) || array_key_exists("w_co_nama", $filter)) {
			$this->setSessionFilterValues(@$filter["x_co_nama"], @$filter["z_co_nama"], @$filter["v_co_nama"], @$filter["y_co_nama"], @$filter["w_co_nama"], "co_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "co_nama");
		}

		// Field var_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_var_nama", $filter) || array_key_exists("z_var_nama", $filter) ||
			array_key_exists("v_var_nama", $filter) ||
			array_key_exists("y_var_nama", $filter) || array_key_exists("w_var_nama", $filter)) {
			$this->setSessionFilterValues(@$filter["x_var_nama"], @$filter["z_var_nama"], @$filter["v_var_nama"], @$filter["y_var_nama"], @$filter["w_var_nama"], "var_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "var_nama");
		}

		// Field desa_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_desa_nama", $filter) || array_key_exists("z_desa_nama", $filter) ||
			array_key_exists("v_desa_nama", $filter) ||
			array_key_exists("y_desa_nama", $filter) || array_key_exists("w_desa_nama", $filter)) {
			$this->setSessionFilterValues(@$filter["x_desa_nama"], @$filter["z_desa_nama"], @$filter["v_desa_nama"], @$filter["y_desa_nama"], @$filter["w_desa_nama"], "desa_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "desa_nama");
		}

		// Field kec_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_kec_nama", $filter) || array_key_exists("z_kec_nama", $filter) ||
			array_key_exists("v_kec_nama", $filter) ||
			array_key_exists("y_kec_nama", $filter) || array_key_exists("w_kec_nama", $filter)) {
			$this->setSessionFilterValues(@$filter["x_kec_nama"], @$filter["z_kec_nama"], @$filter["v_kec_nama"], @$filter["y_kec_nama"], @$filter["w_kec_nama"], "kec_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "kec_nama");
		}

		// Field kab_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_kab_nama", $filter) || array_key_exists("z_kab_nama", $filter) ||
			array_key_exists("v_kab_nama", $filter) ||
			array_key_exists("y_kab_nama", $filter) || array_key_exists("w_kab_nama", $filter)) {
			$this->setSessionFilterValues(@$filter["x_kab_nama"], @$filter["z_kab_nama"], @$filter["v_kab_nama"], @$filter["y_kab_nama"], @$filter["w_kab_nama"], "kab_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "kab_nama");
		}

		// Field prov_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_prov_nama", $filter) || array_key_exists("z_prov_nama", $filter) ||
			array_key_exists("v_prov_nama", $filter) ||
			array_key_exists("y_prov_nama", $filter) || array_key_exists("w_prov_nama", $filter)) {
			$this->setSessionFilterValues(@$filter["x_prov_nama"], @$filter["z_prov_nama"], @$filter["v_prov_nama"], @$filter["y_prov_nama"], @$filter["w_prov_nama"], "prov_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "prov_nama");
		}

		// Field pet_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_pet_nama", $filter) || array_key_exists("z_pet_nama", $filter) ||
			array_key_exists("v_pet_nama", $filter) ||
			array_key_exists("y_pet_nama", $filter) || array_key_exists("w_pet_nama", $filter)) {
			$this->setSessionFilterValues(@$filter["x_pet_nama"], @$filter["z_pet_nama"], @$filter["v_pet_nama"], @$filter["y_pet_nama"], @$filter["w_pet_nama"], "pet_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "pet_nama");
		}
		return TRUE;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Render lookup
					$this->RowType == ROWTYPE_VIEW;
					$fn = $fld->Lookup->RenderViewFunc;
					$render = method_exists($this, $fn);

					// Format the field values
					$fld->setDbValue($row[1]);
					if ($render) {
						$this->$fn();
						$row[1] = $fld->ViewValue;
						$row['df'] = $row[1];
					} elseif ($fld->isEncrypt()) {
						$row[1] = $fld->CurrentValue;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Return popup filter
	protected function getPopupFilter()
	{
		$wrk = "";
		if ($this->DrillDown)
			return "";
		return $wrk;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>