<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class PesertaDelete extends Peserta
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PesertaDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "PesertaDelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->pes_id->setVisibility();
        $this->pes_nama->setVisibility();
        $this->sos_id->setVisibility();
        $this->co_id->setVisibility();
        $this->prov_id->setVisibility();
        $this->kab_id->setVisibility();
        $this->kec_id->setVisibility();
        $this->desa_id->setVisibility();
        $this->pes_alamat->setVisibility();
        $this->pes_hp->setVisibility();
        $this->pes_foto->setVisibility();
        $this->pes_luas_lahan->setVisibility();
        $this->pes_r_tanam_tgl->setVisibility();
        $this->pes_foto_lahan->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'peserta';
        $this->TableName = 'peserta';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (peserta)
        if (!isset($GLOBALS["peserta"]) || get_class($GLOBALS["peserta"]) == PROJECT_NAMESPACE . "peserta") {
            $GLOBALS["peserta"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'peserta');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->pes_foto->OldUploadPath = $this->pes_foto->getUploadPath(); // PHP
                $this->pes_foto->UploadPath = $this->pes_foto->OldUploadPath;
                $this->pes_foto_lahan->OldUploadPath = $this->pes_foto_lahan->getUploadPath(); // PHP
                $this->pes_foto_lahan->UploadPath = $this->pes_foto_lahan->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['pes_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->pes_id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;
    public $RowCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->sos_id);
        $this->setupLookupOptions($this->co_id);
        $this->setupLookupOptions($this->prov_id);
        $this->setupLookupOptions($this->kab_id);
        $this->setupLookupOptions($this->kec_id);
        $this->setupLookupOptions($this->desa_id);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("PesertaList"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson([ "success" => false, "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;                    
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            if ($this->Recordset = $this->loadRecordset()) {
                $this->TotalRecords = $this->Recordset->recordCount(); // Get record count
            }
            if ($this->TotalRecords <= 0) { // No record found, exit
                if ($this->Recordset) {
                    $this->Recordset->close();
                }
                $this->terminate("PesertaList"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->pes_id->setDbValue($row['pes_id']);
        $this->pes_nama->setDbValue($row['pes_nama']);
        $this->sos_id->setDbValue($row['sos_id']);
        $this->co_id->setDbValue($row['co_id']);
        $this->prov_id->setDbValue($row['prov_id']);
        if (array_key_exists('EV__prov_id', $row)) {
            $this->prov_id->VirtualValue = $row['EV__prov_id']; // Set up virtual field value
        } else {
            $this->prov_id->VirtualValue = ""; // Clear value
        }
        $this->kab_id->setDbValue($row['kab_id']);
        if (array_key_exists('EV__kab_id', $row)) {
            $this->kab_id->VirtualValue = $row['EV__kab_id']; // Set up virtual field value
        } else {
            $this->kab_id->VirtualValue = ""; // Clear value
        }
        $this->kec_id->setDbValue($row['kec_id']);
        if (array_key_exists('EV__kec_id', $row)) {
            $this->kec_id->VirtualValue = $row['EV__kec_id']; // Set up virtual field value
        } else {
            $this->kec_id->VirtualValue = ""; // Clear value
        }
        $this->desa_id->setDbValue($row['desa_id']);
        if (array_key_exists('EV__desa_id', $row)) {
            $this->desa_id->VirtualValue = $row['EV__desa_id']; // Set up virtual field value
        } else {
            $this->desa_id->VirtualValue = ""; // Clear value
        }
        $this->pes_alamat->setDbValue($row['pes_alamat']);
        $this->pes_hp->setDbValue($row['pes_hp']);
        $this->pes_foto->Upload->DbValue = $row['pes_foto'];
        $this->pes_foto->setDbValue($this->pes_foto->Upload->DbValue);
        $this->pes_luas_lahan->setDbValue($row['pes_luas_lahan']);
        $this->pes_r_tanam_tgl->setDbValue($row['pes_r_tanam_tgl']);
        $this->pes_foto_lahan->Upload->DbValue = $row['pes_foto_lahan'];
        $this->pes_foto_lahan->setDbValue($this->pes_foto_lahan->Upload->DbValue);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['pes_id'] = $this->pes_id->DefaultValue;
        $row['pes_nama'] = $this->pes_nama->DefaultValue;
        $row['sos_id'] = $this->sos_id->DefaultValue;
        $row['co_id'] = $this->co_id->DefaultValue;
        $row['prov_id'] = $this->prov_id->DefaultValue;
        $row['kab_id'] = $this->kab_id->DefaultValue;
        $row['kec_id'] = $this->kec_id->DefaultValue;
        $row['desa_id'] = $this->desa_id->DefaultValue;
        $row['pes_alamat'] = $this->pes_alamat->DefaultValue;
        $row['pes_hp'] = $this->pes_hp->DefaultValue;
        $row['pes_foto'] = $this->pes_foto->DefaultValue;
        $row['pes_luas_lahan'] = $this->pes_luas_lahan->DefaultValue;
        $row['pes_r_tanam_tgl'] = $this->pes_r_tanam_tgl->DefaultValue;
        $row['pes_foto_lahan'] = $this->pes_foto_lahan->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // pes_id

        // pes_nama

        // sos_id

        // co_id

        // prov_id

        // kab_id

        // kec_id

        // desa_id

        // pes_alamat

        // pes_hp

        // pes_foto

        // pes_luas_lahan

        // pes_r_tanam_tgl

        // pes_foto_lahan

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // pes_id
            $this->pes_id->ViewValue = $this->pes_id->CurrentValue;

            // pes_nama
            $this->pes_nama->ViewValue = $this->pes_nama->CurrentValue;

            // sos_id
            $curVal = strval($this->sos_id->CurrentValue);
            if ($curVal != "") {
                $this->sos_id->ViewValue = $this->sos_id->lookupCacheOption($curVal);
                if ($this->sos_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`sos_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_id->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_id->ViewValue = $this->sos_id->displayValue($arwrk);
                    } else {
                        $this->sos_id->ViewValue = $this->sos_id->CurrentValue;
                    }
                }
            } else {
                $this->sos_id->ViewValue = null;
            }

            // co_id
            $curVal = strval($this->co_id->CurrentValue);
            if ($curVal != "") {
                $this->co_id->ViewValue = $this->co_id->lookupCacheOption($curVal);
                if ($this->co_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->co_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->co_id->Lookup->renderViewRow($rswrk[0]);
                        $this->co_id->ViewValue = $this->co_id->displayValue($arwrk);
                    } else {
                        $this->co_id->ViewValue = $this->co_id->CurrentValue;
                    }
                }
            } else {
                $this->co_id->ViewValue = null;
            }

            // prov_id
            if ($this->prov_id->VirtualValue != "") {
                $this->prov_id->ViewValue = $this->prov_id->VirtualValue;
            } else {
                $curVal = strval($this->prov_id->CurrentValue);
                if ($curVal != "") {
                    $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
                    if ($this->prov_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->prov_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->prov_id->Lookup->renderViewRow($rswrk[0]);
                            $this->prov_id->ViewValue = $this->prov_id->displayValue($arwrk);
                        } else {
                            $this->prov_id->ViewValue = $this->prov_id->CurrentValue;
                        }
                    }
                } else {
                    $this->prov_id->ViewValue = null;
                }
            }

            // kab_id
            if ($this->kab_id->VirtualValue != "") {
                $this->kab_id->ViewValue = $this->kab_id->VirtualValue;
            } else {
                $curVal = strval($this->kab_id->CurrentValue);
                if ($curVal != "") {
                    $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
                    if ($this->kab_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kab_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kab_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kab_id->ViewValue = $this->kab_id->displayValue($arwrk);
                        } else {
                            $this->kab_id->ViewValue = $this->kab_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kab_id->ViewValue = null;
                }
            }

            // kec_id
            if ($this->kec_id->VirtualValue != "") {
                $this->kec_id->ViewValue = $this->kec_id->VirtualValue;
            } else {
                $curVal = strval($this->kec_id->CurrentValue);
                if ($curVal != "") {
                    $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
                    if ($this->kec_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kec_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kec_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kec_id->ViewValue = $this->kec_id->displayValue($arwrk);
                        } else {
                            $this->kec_id->ViewValue = $this->kec_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kec_id->ViewValue = null;
                }
            }

            // desa_id
            if ($this->desa_id->VirtualValue != "") {
                $this->desa_id->ViewValue = $this->desa_id->VirtualValue;
            } else {
                $curVal = strval($this->desa_id->CurrentValue);
                if ($curVal != "") {
                    $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
                    if ($this->desa_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->desa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->desa_id->Lookup->renderViewRow($rswrk[0]);
                            $this->desa_id->ViewValue = $this->desa_id->displayValue($arwrk);
                        } else {
                            $this->desa_id->ViewValue = $this->desa_id->CurrentValue;
                        }
                    }
                } else {
                    $this->desa_id->ViewValue = null;
                }
            }

            // pes_alamat
            $this->pes_alamat->ViewValue = $this->pes_alamat->CurrentValue;

            // pes_hp
            $this->pes_hp->ViewValue = $this->pes_hp->CurrentValue;

            // pes_foto
            $this->pes_foto->UploadPath = $this->pes_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->pes_foto->Upload->DbValue)) {
                $this->pes_foto->ImageWidth = 60;
                $this->pes_foto->ImageHeight = 60;
                $this->pes_foto->ImageAlt = $this->pes_foto->alt();
                $this->pes_foto->ImageCssClass = "ew-image";
                $this->pes_foto->ViewValue = $this->pes_foto->Upload->DbValue;
            } else {
                $this->pes_foto->ViewValue = "";
            }

            // pes_luas_lahan
            $this->pes_luas_lahan->ViewValue = $this->pes_luas_lahan->CurrentValue;
            $this->pes_luas_lahan->CellCssStyle .= "text-align: right;";

            // pes_r_tanam_tgl
            $this->pes_r_tanam_tgl->ViewValue = $this->pes_r_tanam_tgl->CurrentValue;
            $this->pes_r_tanam_tgl->ViewValue = FormatDateTime($this->pes_r_tanam_tgl->ViewValue, $this->pes_r_tanam_tgl->formatPattern());

            // pes_foto_lahan
            $this->pes_foto_lahan->UploadPath = $this->pes_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->pes_foto_lahan->Upload->DbValue)) {
                $this->pes_foto_lahan->ImageWidth = 80;
                $this->pes_foto_lahan->ImageHeight = 60;
                $this->pes_foto_lahan->ImageAlt = $this->pes_foto_lahan->alt();
                $this->pes_foto_lahan->ImageCssClass = "ew-image";
                $this->pes_foto_lahan->ViewValue = $this->pes_foto_lahan->Upload->DbValue;
            } else {
                $this->pes_foto_lahan->ViewValue = "";
            }

            // pes_id
            $this->pes_id->HrefValue = "";
            $this->pes_id->TooltipValue = "";

            // pes_nama
            $this->pes_nama->HrefValue = "";
            $this->pes_nama->TooltipValue = "";

            // sos_id
            $this->sos_id->HrefValue = "";
            $this->sos_id->TooltipValue = "";

            // co_id
            $this->co_id->HrefValue = "";
            $this->co_id->TooltipValue = "";

            // prov_id
            $this->prov_id->HrefValue = "";
            $this->prov_id->TooltipValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";
            $this->kab_id->TooltipValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";
            $this->kec_id->TooltipValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";
            $this->desa_id->TooltipValue = "";

            // pes_alamat
            $this->pes_alamat->HrefValue = "";
            $this->pes_alamat->TooltipValue = "";

            // pes_hp
            $this->pes_hp->HrefValue = "";
            $this->pes_hp->TooltipValue = "";

            // pes_foto
            $this->pes_foto->UploadPath = $this->pes_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->pes_foto->Upload->DbValue)) {
                $this->pes_foto->HrefValue = GetFileUploadUrl($this->pes_foto, $this->pes_foto->htmlDecode($this->pes_foto->Upload->DbValue)); // Add prefix/suffix
                $this->pes_foto->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->pes_foto->HrefValue = FullUrl($this->pes_foto->HrefValue, "href");
                }
            } else {
                $this->pes_foto->HrefValue = "";
            }
            $this->pes_foto->ExportHrefValue = $this->pes_foto->UploadPath . $this->pes_foto->Upload->DbValue;
            $this->pes_foto->TooltipValue = "";
            if ($this->pes_foto->UseColorbox) {
                if (EmptyValue($this->pes_foto->TooltipValue)) {
                    $this->pes_foto->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->pes_foto->LinkAttrs["data-rel"] = "peserta_x_pes_foto";
                $this->pes_foto->LinkAttrs->appendClass("ew-lightbox");
            }

            // pes_luas_lahan
            $this->pes_luas_lahan->HrefValue = "";
            $this->pes_luas_lahan->TooltipValue = "";

            // pes_r_tanam_tgl
            $this->pes_r_tanam_tgl->HrefValue = "";
            $this->pes_r_tanam_tgl->TooltipValue = "";

            // pes_foto_lahan
            $this->pes_foto_lahan->UploadPath = $this->pes_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->pes_foto_lahan->Upload->DbValue)) {
                $this->pes_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
                $this->pes_foto_lahan->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->pes_foto_lahan->HrefValue = FullUrl($this->pes_foto_lahan->HrefValue, "href");
                }
            } else {
                $this->pes_foto_lahan->HrefValue = "";
            }
            $this->pes_foto_lahan->ExportHrefValue = $this->pes_foto_lahan->UploadPath . $this->pes_foto_lahan->Upload->DbValue;
            $this->pes_foto_lahan->TooltipValue = "";
            if ($this->pes_foto_lahan->UseColorbox) {
                if (EmptyValue($this->pes_foto_lahan->TooltipValue)) {
                    $this->pes_foto_lahan->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->pes_foto_lahan->LinkAttrs["data-rel"] = "peserta_x_pes_foto_lahan";
                $this->pes_foto_lahan->LinkAttrs->appendClass("ew-lightbox");
            }
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['pes_id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                $conn->commit();
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                $conn->rollback();
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Route(2) !== null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KontrakList");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("PesertaList"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_sos_id":
                    break;
                case "x_co_id":
                    break;
                case "x_prov_id":
                    break;
                case "x_kab_id":
                    break;
                case "x_kec_id":
                    break;
                case "x_desa_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
