<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class PenggunaanPestisidaGrid extends PenggunaanPestisida
{
    use MessagesTrait;

    // Page ID
    public $PageID = "grid";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PenggunaanPestisidaGrid";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fpenggunaan_pestisidagrid";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "PenggunaanPestisidaGrid";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ID_Penggunan->setVisibility();
        $this->ID_Kontrak->setVisibility();
        $this->Jenis_Pestisida->setVisibility();
        $this->Merek->setVisibility();
        $this->Bahan_Aktif->setVisibility();
        $this->Dosis_Pemakaian->setVisibility();
        $this->Waktu_Aplikasi->setVisibility();
        $this->Keterangan->Visible = false;
        $this->Petugas_Update->setVisibility();
        $this->Tanggal_Update->setVisibility();
        $this->Petugas_Add->setVisibility();
        $this->Tanggal_Add->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'penggunaan_pestisida';
        $this->TableName = 'penggunaan_pestisida';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $this->FormActionName .= "_" . $this->FormName;
        $this->OldKeyName .= "_" . $this->FormName;
        $this->FormBlankRowName .= "_" . $this->FormName;
        $this->FormKeyCountName .= "_" . $this->FormName;
        $GLOBALS["Grid"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (penggunaan_pestisida)
        if (!isset($GLOBALS["penggunaan_pestisida"]) || get_class($GLOBALS["penggunaan_pestisida"]) == PROJECT_NAMESPACE . "penggunaan_pestisida") {
            $GLOBALS["penggunaan_pestisida"] = &$this;
        }
        $this->AddUrl = "PenggunaanPestisidaAdd";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'penggunaan_pestisida');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(["Tag" => "td", "TableVar" => $this->TableVar]);

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions([
            "TagClassName" => "ew-add-edit-option",
            "UseDropDownButton" => false,
            "DropDownButtonPhrase" => $Language->phrase("ButtonAddEdit"),
            "UseButtonGroup" => true
        ]);
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;
        unset($GLOBALS["Grid"]);
        if ($url === "") {
            return;
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ID_Penggunan'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ID_Penggunan->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Petugas_Update->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Tanggal_Update->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $ShowOtherOptions = false;
    public $DisplayRecords = 100;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $RowCount = 0;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load recordset from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load recordset
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new NumericPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport = $DashboardReport || ConvertToBool(Param(Config("PAGE_DASHBOARD"), false));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->Jenis_Pestisida);
        $this->setupLookupOptions($this->Merek);
        $this->setupLookupOptions($this->Bahan_Aktif);

        // Load default values for add
        $this->loadDefaultValues();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fpenggunaan_pestisidagrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $filter = ""; // Filter
        $query = ""; // Query builder

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Show grid delete link for grid add / grid edit
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $item = $this->ListOptions["griddelete"];
                if ($item) {
                    $item->Visible = $Security->allowDelete(CurrentProjectID() . $this->TableName);
                }
            }
        }

        // Set up sorting order
        $this->setupSortOrder();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 100; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Build filter
        $filter = "";
        if (!$Security->canList()) {
            $filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($filter, $this->DbDetailFilter);
        AddFilter($filter, $this->SearchWhere);

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "kontrak") {
            $masterTbl = Container("kontrak");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("KontrakList"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = ROWTYPE_MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $filter;
        } else {
            $this->setSessionWhere($filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($filter);
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->TotalRecords = $this->listRecordCount();
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->TotalRecords;
                $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
            } else {
                $this->CurrentFilter = "0=1";
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->GridAddRowCount;
            }
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->TotalRecords; // Display all records
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset->close();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new NumericPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 100; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to grid add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to grid edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old recordset
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAllAssociative();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();
        $wrkfilter = "";
        $key = "";

        // Update row index and get row key
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete" && $rowaction != "hide") { // Skip insert then deleted rows / hidden rows for grid edit
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                        if ($gridUpdate) { // Get inserted or updated filter
                            AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                        }
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $this->FilterForModalActions = $wrkfilter;

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Perform grid add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        $key = "";

        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $rsold = null;
            if ($rowaction == "insert") {
                $this->OldKey = strval($CurrentForm->getValue($this->OldKeyName));
                $rsold = $this->loadOldRecord(); // Load old record
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success
                $gridInsert = $this->addRow($rsold); // Insert row (already validated by validateGridForm())
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->ID_Penggunan->CurrentValue;

                    // Add filter for this record
                    AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->clearInlineMode(); // Clear grid add mode and return
            return true;
        }
        if ($gridInsert) {
            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $this->FilterForModalActions = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if ($CurrentForm->hasValue("x_ID_Kontrak") && $CurrentForm->hasValue("o_ID_Kontrak") && $this->ID_Kontrak->CurrentValue != $this->ID_Kontrak->DefaultValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Jenis_Pestisida") && $CurrentForm->hasValue("o_Jenis_Pestisida") && $this->Jenis_Pestisida->CurrentValue != $this->Jenis_Pestisida->DefaultValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Merek") && $CurrentForm->hasValue("o_Merek") && $this->Merek->CurrentValue != $this->Merek->DefaultValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Bahan_Aktif") && $CurrentForm->hasValue("o_Bahan_Aktif") && $this->Bahan_Aktif->CurrentValue != $this->Bahan_Aktif->DefaultValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Dosis_Pemakaian") && $CurrentForm->hasValue("o_Dosis_Pemakaian") && $this->Dosis_Pemakaian->CurrentValue != $this->Dosis_Pemakaian->DefaultValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Waktu_Aplikasi") && $CurrentForm->hasValue("o_Waktu_Aplikasi") && $this->Waktu_Aplikasi->CurrentValue != $this->Waktu_Aplikasi->DefaultValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Petugas_Add") && $CurrentForm->hasValue("o_Petugas_Add") && $this->Petugas_Add->CurrentValue != $this->Petugas_Add->DefaultValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Tanggal_Add") && $CurrentForm->hasValue("o_Tanggal_Add") && $this->Tanggal_Add->CurrentValue != $this->Tanggal_Add->DefaultValue) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;

        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Load default values for emptyRow checking
        $this->loadDefaultValues();

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete" && $rowaction != "hide") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    $this->ValidationErrors[$rowindex] = $this->getValidationErrors();
                    $this->EventCancelled = true;
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        foreach ($this->Fields as $field) {
            $field->clearErrorMessage();
        }
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->ID_Kontrak->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = false;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
            // Set up list options (to be implemented by extensions)
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm, $UserProfile;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (!$Security->allowDelete(CurrentProjectID() . $this->TableName) && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-ew-action=\"delete-grid-row\" data-rowindex=\"" . $this->RowIndex . "\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"penggunaan_pestisida\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"penggunaan_pestisida\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"penggunaan_pestisida\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $option = $this->OtherOptions["addedit"];
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Add
        if ($this->CurrentMode == "view") { // Check view mode
            $item = &$option->add("add");
            $addcaption = HtmlTitle($Language->phrase("AddLink"));
            $this->AddUrl = $this->getAddUrl();
            if ($this->ModalAdd && !IsMobile()) {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"penggunaan_pestisida\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
            } else {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
            }
            $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        }
    }

    // Create new column option
    public function createColumnOption($name)
    {
        $field = $this->Fields[$name] ?? false;
        if ($field && $field->Visible) {
            $item = new ListOption($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
            return $item;
        }
        return null;
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
            if (in_array($this->CurrentMode, ["add", "copy", "edit"]) && !$this->isConfirm()) { // Check add/copy/edit mode
                if ($this->AllowAddDeleteRow) {
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                    $this->ShowOtherOptions = $item->Visible;
                }
            }
            if ($this->CurrentMode == "view") { // Check view mode
                $option = $options["addedit"];
                $item = $option["add"];
                $this->ShowOtherOptions = $item && $item->Visible;
            }
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        $this->StartRecord = 1;
        $this->StopRecord = $this->TotalRecords; // Show all records

        // Restore number of post back records
        if ($CurrentForm && ($this->isConfirm() || $this->EventCancelled)) {
            $CurrentForm->Index = -1;
            if ($CurrentForm->hasValue($this->FormKeyCountName) && ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm())) {
                $this->KeyCount = $CurrentForm->getValue($this->FormKeyCountName);
                $this->StopRecord = $this->StartRecord + $this->KeyCount - 1;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->Recordset && !$this->Recordset->EOF) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = ROWTYPE_AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_penggunaan_pestisida", "data-rowtype" => ROWTYPE_ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = ROWTYPE_ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }
        if ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm() || $this->isMultiEdit()) {
            $this->RowIndex++;
            $CurrentForm->Index = $this->RowIndex;
            if ($CurrentForm->hasValue($this->FormActionName) && ($this->isConfirm() || $this->EventCancelled)) {
                $this->RowAction = strval($CurrentForm->getValue($this->FormActionName));
            } elseif ($this->isGridAdd()) {
                $this->RowAction = "insert";
            } else {
                $this->RowAction = "";
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->loadRowValues($this->Recordset); // Load row values
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
            } else {
                $this->loadRowValues(); // Load default values
                $this->OldKey = "";
            }
        } else {
            $this->loadRowValues($this->Recordset); // Load row values
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
        }
        $this->setKey($this->OldKey);
        $this->RowType = ROWTYPE_VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = ROWTYPE_ADD; // Render add
        }
        if ($this->isGridAdd() && $this->EventCancelled && !$CurrentForm->hasValue($this->FormBlankRowName)) { // Insert failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isGridEdit()) { // Grid edit
            if ($this->EventCancelled) {
                $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
            }
            if ($this->RowAction == "insert") {
                $this->RowType = ROWTYPE_ADD; // Render add
            } else {
                $this->RowType = ROWTYPE_EDIT; // Render edit
            }
        }
        if ($this->isGridEdit() && ($this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_ADD) && $this->EventCancelled) { // Update failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isConfirm()) { // Confirm row
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == ROWTYPE_ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == ROWTYPE_EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_penggunaan_pestisida",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == ROWTYPE_ADD || $this->isEdit() && $this->RowType == ROWTYPE_EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->Petugas_Add->DefaultValue = $this->Petugas_Add->getDefault(); // PHP
        $this->Petugas_Add->OldValue = $this->Petugas_Add->DefaultValue;
        $this->Tanggal_Add->DefaultValue = $this->Tanggal_Add->getDefault(); // PHP
        $this->Tanggal_Add->OldValue = $this->Tanggal_Add->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $CurrentForm->FormName = $this->FormName;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ID_Penggunan' first before field var 'x_ID_Penggunan'
        $val = $CurrentForm->hasValue("ID_Penggunan") ? $CurrentForm->getValue("ID_Penggunan") : $CurrentForm->getValue("x_ID_Penggunan");
        if (!$this->ID_Penggunan->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->ID_Penggunan->setFormValue($val);
        }

        // Check field name 'ID_Kontrak' first before field var 'x_ID_Kontrak'
        $val = $CurrentForm->hasValue("ID_Kontrak") ? $CurrentForm->getValue("ID_Kontrak") : $CurrentForm->getValue("x_ID_Kontrak");
        if (!$this->ID_Kontrak->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ID_Kontrak->Visible = false; // Disable update for API request
            } else {
                $this->ID_Kontrak->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_ID_Kontrak")) {
            $this->ID_Kontrak->setOldValue($CurrentForm->getValue("o_ID_Kontrak"));
        }

        // Check field name 'Jenis_Pestisida' first before field var 'x_Jenis_Pestisida'
        $val = $CurrentForm->hasValue("Jenis_Pestisida") ? $CurrentForm->getValue("Jenis_Pestisida") : $CurrentForm->getValue("x_Jenis_Pestisida");
        if (!$this->Jenis_Pestisida->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Jenis_Pestisida->Visible = false; // Disable update for API request
            } else {
                $this->Jenis_Pestisida->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Jenis_Pestisida")) {
            $this->Jenis_Pestisida->setOldValue($CurrentForm->getValue("o_Jenis_Pestisida"));
        }

        // Check field name 'Merek' first before field var 'x_Merek'
        $val = $CurrentForm->hasValue("Merek") ? $CurrentForm->getValue("Merek") : $CurrentForm->getValue("x_Merek");
        if (!$this->Merek->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Merek->Visible = false; // Disable update for API request
            } else {
                $this->Merek->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Merek")) {
            $this->Merek->setOldValue($CurrentForm->getValue("o_Merek"));
        }

        // Check field name 'Bahan_Aktif' first before field var 'x_Bahan_Aktif'
        $val = $CurrentForm->hasValue("Bahan_Aktif") ? $CurrentForm->getValue("Bahan_Aktif") : $CurrentForm->getValue("x_Bahan_Aktif");
        if (!$this->Bahan_Aktif->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Bahan_Aktif->Visible = false; // Disable update for API request
            } else {
                $this->Bahan_Aktif->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Bahan_Aktif")) {
            $this->Bahan_Aktif->setOldValue($CurrentForm->getValue("o_Bahan_Aktif"));
        }

        // Check field name 'Dosis_Pemakaian' first before field var 'x_Dosis_Pemakaian'
        $val = $CurrentForm->hasValue("Dosis_Pemakaian") ? $CurrentForm->getValue("Dosis_Pemakaian") : $CurrentForm->getValue("x_Dosis_Pemakaian");
        if (!$this->Dosis_Pemakaian->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Dosis_Pemakaian->Visible = false; // Disable update for API request
            } else {
                $this->Dosis_Pemakaian->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Dosis_Pemakaian")) {
            $this->Dosis_Pemakaian->setOldValue($CurrentForm->getValue("o_Dosis_Pemakaian"));
        }

        // Check field name 'Waktu_Aplikasi' first before field var 'x_Waktu_Aplikasi'
        $val = $CurrentForm->hasValue("Waktu_Aplikasi") ? $CurrentForm->getValue("Waktu_Aplikasi") : $CurrentForm->getValue("x_Waktu_Aplikasi");
        if (!$this->Waktu_Aplikasi->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Waktu_Aplikasi->Visible = false; // Disable update for API request
            } else {
                $this->Waktu_Aplikasi->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Waktu_Aplikasi")) {
            $this->Waktu_Aplikasi->setOldValue($CurrentForm->getValue("o_Waktu_Aplikasi"));
        }

        // Check field name 'Petugas_Update' first before field var 'x_Petugas_Update'
        $val = $CurrentForm->hasValue("Petugas_Update") ? $CurrentForm->getValue("Petugas_Update") : $CurrentForm->getValue("x_Petugas_Update");
        if (!$this->Petugas_Update->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Petugas_Update->Visible = false; // Disable update for API request
            } else {
                $this->Petugas_Update->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Petugas_Update")) {
            $this->Petugas_Update->setOldValue($CurrentForm->getValue("o_Petugas_Update"));
        }

        // Check field name 'Tanggal_Update' first before field var 'x_Tanggal_Update'
        $val = $CurrentForm->hasValue("Tanggal_Update") ? $CurrentForm->getValue("Tanggal_Update") : $CurrentForm->getValue("x_Tanggal_Update");
        if (!$this->Tanggal_Update->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Tanggal_Update->Visible = false; // Disable update for API request
            } else {
                $this->Tanggal_Update->setFormValue($val);
            }
            $this->Tanggal_Update->CurrentValue = UnFormatDateTime($this->Tanggal_Update->CurrentValue, $this->Tanggal_Update->formatPattern());
        }
        if ($CurrentForm->hasValue("o_Tanggal_Update")) {
            $this->Tanggal_Update->setOldValue($CurrentForm->getValue("o_Tanggal_Update"));
        }

        // Check field name 'Petugas_Add' first before field var 'x_Petugas_Add'
        $val = $CurrentForm->hasValue("Petugas_Add") ? $CurrentForm->getValue("Petugas_Add") : $CurrentForm->getValue("x_Petugas_Add");
        if (!$this->Petugas_Add->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Petugas_Add->Visible = false; // Disable update for API request
            } else {
                $this->Petugas_Add->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Petugas_Add")) {
            $this->Petugas_Add->setOldValue($CurrentForm->getValue("o_Petugas_Add"));
        }

        // Check field name 'Tanggal_Add' first before field var 'x_Tanggal_Add'
        $val = $CurrentForm->hasValue("Tanggal_Add") ? $CurrentForm->getValue("Tanggal_Add") : $CurrentForm->getValue("x_Tanggal_Add");
        if (!$this->Tanggal_Add->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Tanggal_Add->Visible = false; // Disable update for API request
            } else {
                $this->Tanggal_Add->setFormValue($val);
            }
            $this->Tanggal_Add->CurrentValue = UnFormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern());
        }
        if ($CurrentForm->hasValue("o_Tanggal_Add")) {
            $this->Tanggal_Add->setOldValue($CurrentForm->getValue("o_Tanggal_Add"));
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->ID_Penggunan->CurrentValue = $this->ID_Penggunan->FormValue;
        }
        $this->ID_Kontrak->CurrentValue = $this->ID_Kontrak->FormValue;
        $this->Jenis_Pestisida->CurrentValue = $this->Jenis_Pestisida->FormValue;
        $this->Merek->CurrentValue = $this->Merek->FormValue;
        $this->Bahan_Aktif->CurrentValue = $this->Bahan_Aktif->FormValue;
        $this->Dosis_Pemakaian->CurrentValue = $this->Dosis_Pemakaian->FormValue;
        $this->Waktu_Aplikasi->CurrentValue = $this->Waktu_Aplikasi->FormValue;
        $this->Petugas_Update->CurrentValue = $this->Petugas_Update->FormValue;
        $this->Tanggal_Update->CurrentValue = $this->Tanggal_Update->FormValue;
        $this->Tanggal_Update->CurrentValue = UnFormatDateTime($this->Tanggal_Update->CurrentValue, $this->Tanggal_Update->formatPattern());
        $this->Petugas_Add->CurrentValue = $this->Petugas_Add->FormValue;
        $this->Tanggal_Add->CurrentValue = $this->Tanggal_Add->FormValue;
        $this->Tanggal_Add->CurrentValue = UnFormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern());
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ID_Penggunan->setDbValue($row['ID_Penggunan']);
        $this->ID_Kontrak->setDbValue($row['ID_Kontrak']);
        $this->Jenis_Pestisida->setDbValue($row['Jenis_Pestisida']);
        $this->Merek->setDbValue($row['Merek']);
        $this->Bahan_Aktif->setDbValue($row['Bahan_Aktif']);
        $this->Dosis_Pemakaian->setDbValue($row['Dosis_Pemakaian']);
        $this->Waktu_Aplikasi->setDbValue($row['Waktu_Aplikasi']);
        $this->Keterangan->setDbValue($row['Keterangan']);
        $this->Petugas_Update->setDbValue($row['Petugas_Update']);
        $this->Tanggal_Update->setDbValue($row['Tanggal_Update']);
        $this->Petugas_Add->setDbValue($row['Petugas_Add']);
        $this->Tanggal_Add->setDbValue($row['Tanggal_Add']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ID_Penggunan'] = $this->ID_Penggunan->DefaultValue;
        $row['ID_Kontrak'] = $this->ID_Kontrak->DefaultValue;
        $row['Jenis_Pestisida'] = $this->Jenis_Pestisida->DefaultValue;
        $row['Merek'] = $this->Merek->DefaultValue;
        $row['Bahan_Aktif'] = $this->Bahan_Aktif->DefaultValue;
        $row['Dosis_Pemakaian'] = $this->Dosis_Pemakaian->DefaultValue;
        $row['Waktu_Aplikasi'] = $this->Waktu_Aplikasi->DefaultValue;
        $row['Keterangan'] = $this->Keterangan->DefaultValue;
        $row['Petugas_Update'] = $this->Petugas_Update->DefaultValue;
        $row['Tanggal_Update'] = $this->Tanggal_Update->DefaultValue;
        $row['Petugas_Add'] = $this->Petugas_Add->DefaultValue;
        $row['Tanggal_Add'] = $this->Tanggal_Add->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ID_Penggunan

        // ID_Kontrak

        // Jenis_Pestisida

        // Merek

        // Bahan_Aktif

        // Dosis_Pemakaian

        // Waktu_Aplikasi

        // Keterangan

        // Petugas_Update

        // Tanggal_Update

        // Petugas_Add

        // Tanggal_Add

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // ID_Penggunan
            $this->ID_Penggunan->ViewValue = $this->ID_Penggunan->CurrentValue;

            // ID_Kontrak
            $this->ID_Kontrak->ViewValue = $this->ID_Kontrak->CurrentValue;
            $this->ID_Kontrak->ViewValue = FormatNumber($this->ID_Kontrak->ViewValue, $this->ID_Kontrak->formatPattern());

            // Jenis_Pestisida
            if (strval($this->Jenis_Pestisida->CurrentValue) != "") {
                $this->Jenis_Pestisida->ViewValue = $this->Jenis_Pestisida->optionCaption($this->Jenis_Pestisida->CurrentValue);
            } else {
                $this->Jenis_Pestisida->ViewValue = null;
            }

            // Merek
            $curVal = strval($this->Merek->CurrentValue);
            if ($curVal != "") {
                $this->Merek->ViewValue = $this->Merek->lookupCacheOption($curVal);
                if ($this->Merek->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`mp_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Merek->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Merek->Lookup->renderViewRow($rswrk[0]);
                        $this->Merek->ViewValue = $this->Merek->displayValue($arwrk);
                    } else {
                        $this->Merek->ViewValue = FormatNumber($this->Merek->CurrentValue, $this->Merek->formatPattern());
                    }
                }
            } else {
                $this->Merek->ViewValue = null;
            }

            // Bahan_Aktif
            $curVal = strval($this->Bahan_Aktif->CurrentValue);
            if ($curVal != "") {
                $this->Bahan_Aktif->ViewValue = $this->Bahan_Aktif->lookupCacheOption($curVal);
                if ($this->Bahan_Aktif->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`bap_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Bahan_Aktif->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Bahan_Aktif->Lookup->renderViewRow($rswrk[0]);
                        $this->Bahan_Aktif->ViewValue = $this->Bahan_Aktif->displayValue($arwrk);
                    } else {
                        $this->Bahan_Aktif->ViewValue = FormatNumber($this->Bahan_Aktif->CurrentValue, $this->Bahan_Aktif->formatPattern());
                    }
                }
            } else {
                $this->Bahan_Aktif->ViewValue = null;
            }

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->ViewValue = $this->Dosis_Pemakaian->CurrentValue;

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->ViewValue = $this->Waktu_Aplikasi->CurrentValue;

            // Petugas_Update
            $this->Petugas_Update->ViewValue = $this->Petugas_Update->CurrentValue;

            // Tanggal_Update
            $this->Tanggal_Update->ViewValue = $this->Tanggal_Update->CurrentValue;
            $this->Tanggal_Update->ViewValue = FormatDateTime($this->Tanggal_Update->ViewValue, $this->Tanggal_Update->formatPattern());

            // Petugas_Add
            $this->Petugas_Add->ViewValue = $this->Petugas_Add->CurrentValue;

            // Tanggal_Add
            $this->Tanggal_Add->ViewValue = $this->Tanggal_Add->CurrentValue;
            $this->Tanggal_Add->ViewValue = FormatDateTime($this->Tanggal_Add->ViewValue, $this->Tanggal_Add->formatPattern());

            // ID_Penggunan
            $this->ID_Penggunan->HrefValue = "";
            $this->ID_Penggunan->TooltipValue = "";

            // ID_Kontrak
            $this->ID_Kontrak->HrefValue = "";
            $this->ID_Kontrak->TooltipValue = "";

            // Jenis_Pestisida
            $this->Jenis_Pestisida->HrefValue = "";
            $this->Jenis_Pestisida->TooltipValue = "";

            // Merek
            $this->Merek->HrefValue = "";
            $this->Merek->TooltipValue = "";

            // Bahan_Aktif
            $this->Bahan_Aktif->HrefValue = "";
            $this->Bahan_Aktif->TooltipValue = "";

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->HrefValue = "";
            $this->Dosis_Pemakaian->TooltipValue = "";

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->HrefValue = "";
            $this->Waktu_Aplikasi->TooltipValue = "";

            // Petugas_Update
            $this->Petugas_Update->HrefValue = "";
            $this->Petugas_Update->TooltipValue = "";

            // Tanggal_Update
            $this->Tanggal_Update->HrefValue = "";
            $this->Tanggal_Update->TooltipValue = "";

            // Petugas_Add
            $this->Petugas_Add->HrefValue = "";
            $this->Petugas_Add->TooltipValue = "";

            // Tanggal_Add
            $this->Tanggal_Add->HrefValue = "";
            $this->Tanggal_Add->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // ID_Penggunan

            // ID_Kontrak
            $this->ID_Kontrak->setupEditAttributes();
            if ($this->ID_Kontrak->getSessionValue() != "") {
                $this->ID_Kontrak->CurrentValue = GetForeignKeyValue($this->ID_Kontrak->getSessionValue());
                $this->ID_Kontrak->OldValue = $this->ID_Kontrak->CurrentValue;
                $this->ID_Kontrak->ViewValue = $this->ID_Kontrak->CurrentValue;
                $this->ID_Kontrak->ViewValue = FormatNumber($this->ID_Kontrak->ViewValue, $this->ID_Kontrak->formatPattern());
            } else {
                $this->ID_Kontrak->EditValue = HtmlEncode($this->ID_Kontrak->CurrentValue);
                $this->ID_Kontrak->PlaceHolder = RemoveHtml($this->ID_Kontrak->caption());
                if (strval($this->ID_Kontrak->EditValue) != "" && is_numeric($this->ID_Kontrak->EditValue)) {
                    $this->ID_Kontrak->EditValue = FormatNumber($this->ID_Kontrak->EditValue, null);
                }
            }

            // Jenis_Pestisida
            $this->Jenis_Pestisida->setupEditAttributes();
            $this->Jenis_Pestisida->EditValue = $this->Jenis_Pestisida->options(true);
            $this->Jenis_Pestisida->PlaceHolder = RemoveHtml($this->Jenis_Pestisida->caption());

            // Merek
            $this->Merek->setupEditAttributes();
            $curVal = trim(strval($this->Merek->CurrentValue));
            if ($curVal != "") {
                $this->Merek->ViewValue = $this->Merek->lookupCacheOption($curVal);
            } else {
                $this->Merek->ViewValue = $this->Merek->Lookup !== null && is_array($this->Merek->lookupOptions()) && count($this->Merek->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Merek->ViewValue !== null) { // Load from cache
                $this->Merek->EditValue = array_values($this->Merek->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`mp_id`", "=", $this->Merek->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Merek->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Merek->EditValue = $arwrk;
            }
            $this->Merek->PlaceHolder = RemoveHtml($this->Merek->caption());

            // Bahan_Aktif
            $this->Bahan_Aktif->setupEditAttributes();
            $curVal = trim(strval($this->Bahan_Aktif->CurrentValue));
            if ($curVal != "") {
                $this->Bahan_Aktif->ViewValue = $this->Bahan_Aktif->lookupCacheOption($curVal);
            } else {
                $this->Bahan_Aktif->ViewValue = $this->Bahan_Aktif->Lookup !== null && is_array($this->Bahan_Aktif->lookupOptions()) && count($this->Bahan_Aktif->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Bahan_Aktif->ViewValue !== null) { // Load from cache
                $this->Bahan_Aktif->EditValue = array_values($this->Bahan_Aktif->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`bap_id`", "=", $this->Bahan_Aktif->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Bahan_Aktif->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Bahan_Aktif->EditValue = $arwrk;
            }
            $this->Bahan_Aktif->PlaceHolder = RemoveHtml($this->Bahan_Aktif->caption());

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->setupEditAttributes();
            if (!$this->Dosis_Pemakaian->Raw) {
                $this->Dosis_Pemakaian->CurrentValue = HtmlDecode($this->Dosis_Pemakaian->CurrentValue);
            }
            $this->Dosis_Pemakaian->EditValue = HtmlEncode($this->Dosis_Pemakaian->CurrentValue);
            $this->Dosis_Pemakaian->PlaceHolder = RemoveHtml($this->Dosis_Pemakaian->caption());

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->setupEditAttributes();
            if (!$this->Waktu_Aplikasi->Raw) {
                $this->Waktu_Aplikasi->CurrentValue = HtmlDecode($this->Waktu_Aplikasi->CurrentValue);
            }
            $this->Waktu_Aplikasi->EditValue = HtmlEncode($this->Waktu_Aplikasi->CurrentValue);
            $this->Waktu_Aplikasi->PlaceHolder = RemoveHtml($this->Waktu_Aplikasi->caption());

            // Petugas_Update

            // Tanggal_Update

            // Petugas_Add
            $this->Petugas_Add->setupEditAttributes();
            $this->Petugas_Add->CurrentValue = $this->Petugas_Add->getDefault();

            // Tanggal_Add
            $this->Tanggal_Add->setupEditAttributes();
            $this->Tanggal_Add->CurrentValue = FormatDateTime($this->Tanggal_Add->getDefault(), $this->Tanggal_Add->formatPattern());

            // Add refer script

            // ID_Penggunan
            $this->ID_Penggunan->HrefValue = "";

            // ID_Kontrak
            $this->ID_Kontrak->HrefValue = "";

            // Jenis_Pestisida
            $this->Jenis_Pestisida->HrefValue = "";

            // Merek
            $this->Merek->HrefValue = "";

            // Bahan_Aktif
            $this->Bahan_Aktif->HrefValue = "";

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->HrefValue = "";

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->HrefValue = "";

            // Petugas_Update
            $this->Petugas_Update->HrefValue = "";

            // Tanggal_Update
            $this->Tanggal_Update->HrefValue = "";

            // Petugas_Add
            $this->Petugas_Add->HrefValue = "";

            // Tanggal_Add
            $this->Tanggal_Add->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // ID_Penggunan
            $this->ID_Penggunan->setupEditAttributes();
            $this->ID_Penggunan->EditValue = $this->ID_Penggunan->CurrentValue;

            // ID_Kontrak
            $this->ID_Kontrak->setupEditAttributes();
            if ($this->ID_Kontrak->getSessionValue() != "") {
                $this->ID_Kontrak->CurrentValue = GetForeignKeyValue($this->ID_Kontrak->getSessionValue());
                $this->ID_Kontrak->OldValue = $this->ID_Kontrak->CurrentValue;
                $this->ID_Kontrak->ViewValue = $this->ID_Kontrak->CurrentValue;
                $this->ID_Kontrak->ViewValue = FormatNumber($this->ID_Kontrak->ViewValue, $this->ID_Kontrak->formatPattern());
            } else {
                $this->ID_Kontrak->EditValue = HtmlEncode($this->ID_Kontrak->CurrentValue);
                $this->ID_Kontrak->PlaceHolder = RemoveHtml($this->ID_Kontrak->caption());
                if (strval($this->ID_Kontrak->EditValue) != "" && is_numeric($this->ID_Kontrak->EditValue)) {
                    $this->ID_Kontrak->EditValue = FormatNumber($this->ID_Kontrak->EditValue, null);
                }
            }

            // Jenis_Pestisida
            $this->Jenis_Pestisida->setupEditAttributes();
            $this->Jenis_Pestisida->EditValue = $this->Jenis_Pestisida->options(true);
            $this->Jenis_Pestisida->PlaceHolder = RemoveHtml($this->Jenis_Pestisida->caption());

            // Merek
            $this->Merek->setupEditAttributes();
            $curVal = trim(strval($this->Merek->CurrentValue));
            if ($curVal != "") {
                $this->Merek->ViewValue = $this->Merek->lookupCacheOption($curVal);
            } else {
                $this->Merek->ViewValue = $this->Merek->Lookup !== null && is_array($this->Merek->lookupOptions()) && count($this->Merek->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Merek->ViewValue !== null) { // Load from cache
                $this->Merek->EditValue = array_values($this->Merek->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`mp_id`", "=", $this->Merek->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Merek->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Merek->EditValue = $arwrk;
            }
            $this->Merek->PlaceHolder = RemoveHtml($this->Merek->caption());

            // Bahan_Aktif
            $this->Bahan_Aktif->setupEditAttributes();
            $curVal = trim(strval($this->Bahan_Aktif->CurrentValue));
            if ($curVal != "") {
                $this->Bahan_Aktif->ViewValue = $this->Bahan_Aktif->lookupCacheOption($curVal);
            } else {
                $this->Bahan_Aktif->ViewValue = $this->Bahan_Aktif->Lookup !== null && is_array($this->Bahan_Aktif->lookupOptions()) && count($this->Bahan_Aktif->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Bahan_Aktif->ViewValue !== null) { // Load from cache
                $this->Bahan_Aktif->EditValue = array_values($this->Bahan_Aktif->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`bap_id`", "=", $this->Bahan_Aktif->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Bahan_Aktif->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Bahan_Aktif->EditValue = $arwrk;
            }
            $this->Bahan_Aktif->PlaceHolder = RemoveHtml($this->Bahan_Aktif->caption());

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->setupEditAttributes();
            if (!$this->Dosis_Pemakaian->Raw) {
                $this->Dosis_Pemakaian->CurrentValue = HtmlDecode($this->Dosis_Pemakaian->CurrentValue);
            }
            $this->Dosis_Pemakaian->EditValue = HtmlEncode($this->Dosis_Pemakaian->CurrentValue);
            $this->Dosis_Pemakaian->PlaceHolder = RemoveHtml($this->Dosis_Pemakaian->caption());

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->setupEditAttributes();
            if (!$this->Waktu_Aplikasi->Raw) {
                $this->Waktu_Aplikasi->CurrentValue = HtmlDecode($this->Waktu_Aplikasi->CurrentValue);
            }
            $this->Waktu_Aplikasi->EditValue = HtmlEncode($this->Waktu_Aplikasi->CurrentValue);
            $this->Waktu_Aplikasi->PlaceHolder = RemoveHtml($this->Waktu_Aplikasi->caption());

            // Petugas_Update

            // Tanggal_Update

            // Petugas_Add
            $this->Petugas_Add->setupEditAttributes();

            // Tanggal_Add
            $this->Tanggal_Add->setupEditAttributes();
            $this->Tanggal_Add->CurrentValue = FormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern());

            // Edit refer script

            // ID_Penggunan
            $this->ID_Penggunan->HrefValue = "";

            // ID_Kontrak
            $this->ID_Kontrak->HrefValue = "";

            // Jenis_Pestisida
            $this->Jenis_Pestisida->HrefValue = "";

            // Merek
            $this->Merek->HrefValue = "";

            // Bahan_Aktif
            $this->Bahan_Aktif->HrefValue = "";

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->HrefValue = "";

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->HrefValue = "";

            // Petugas_Update
            $this->Petugas_Update->HrefValue = "";

            // Tanggal_Update
            $this->Tanggal_Update->HrefValue = "";

            // Petugas_Add
            $this->Petugas_Add->HrefValue = "";

            // Tanggal_Add
            $this->Tanggal_Add->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->ID_Penggunan->Visible && $this->ID_Penggunan->Required) {
            if (!$this->ID_Penggunan->IsDetailKey && EmptyValue($this->ID_Penggunan->FormValue)) {
                $this->ID_Penggunan->addErrorMessage(str_replace("%s", $this->ID_Penggunan->caption(), $this->ID_Penggunan->RequiredErrorMessage));
            }
        }
        if ($this->ID_Kontrak->Visible && $this->ID_Kontrak->Required) {
            if (!$this->ID_Kontrak->IsDetailKey && EmptyValue($this->ID_Kontrak->FormValue)) {
                $this->ID_Kontrak->addErrorMessage(str_replace("%s", $this->ID_Kontrak->caption(), $this->ID_Kontrak->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ID_Kontrak->FormValue)) {
            $this->ID_Kontrak->addErrorMessage($this->ID_Kontrak->getErrorMessage(false));
        }
        if ($this->Jenis_Pestisida->Visible && $this->Jenis_Pestisida->Required) {
            if (!$this->Jenis_Pestisida->IsDetailKey && EmptyValue($this->Jenis_Pestisida->FormValue)) {
                $this->Jenis_Pestisida->addErrorMessage(str_replace("%s", $this->Jenis_Pestisida->caption(), $this->Jenis_Pestisida->RequiredErrorMessage));
            }
        }
        if ($this->Merek->Visible && $this->Merek->Required) {
            if (!$this->Merek->IsDetailKey && EmptyValue($this->Merek->FormValue)) {
                $this->Merek->addErrorMessage(str_replace("%s", $this->Merek->caption(), $this->Merek->RequiredErrorMessage));
            }
        }
        if ($this->Bahan_Aktif->Visible && $this->Bahan_Aktif->Required) {
            if (!$this->Bahan_Aktif->IsDetailKey && EmptyValue($this->Bahan_Aktif->FormValue)) {
                $this->Bahan_Aktif->addErrorMessage(str_replace("%s", $this->Bahan_Aktif->caption(), $this->Bahan_Aktif->RequiredErrorMessage));
            }
        }
        if ($this->Dosis_Pemakaian->Visible && $this->Dosis_Pemakaian->Required) {
            if (!$this->Dosis_Pemakaian->IsDetailKey && EmptyValue($this->Dosis_Pemakaian->FormValue)) {
                $this->Dosis_Pemakaian->addErrorMessage(str_replace("%s", $this->Dosis_Pemakaian->caption(), $this->Dosis_Pemakaian->RequiredErrorMessage));
            }
        }
        if ($this->Waktu_Aplikasi->Visible && $this->Waktu_Aplikasi->Required) {
            if (!$this->Waktu_Aplikasi->IsDetailKey && EmptyValue($this->Waktu_Aplikasi->FormValue)) {
                $this->Waktu_Aplikasi->addErrorMessage(str_replace("%s", $this->Waktu_Aplikasi->caption(), $this->Waktu_Aplikasi->RequiredErrorMessage));
            }
        }
        if ($this->Petugas_Update->Visible && $this->Petugas_Update->Required) {
            if (!$this->Petugas_Update->IsDetailKey && EmptyValue($this->Petugas_Update->FormValue)) {
                $this->Petugas_Update->addErrorMessage(str_replace("%s", $this->Petugas_Update->caption(), $this->Petugas_Update->RequiredErrorMessage));
            }
        }
        if ($this->Tanggal_Update->Visible && $this->Tanggal_Update->Required) {
            if (!$this->Tanggal_Update->IsDetailKey && EmptyValue($this->Tanggal_Update->FormValue)) {
                $this->Tanggal_Update->addErrorMessage(str_replace("%s", $this->Tanggal_Update->caption(), $this->Tanggal_Update->RequiredErrorMessage));
            }
        }
        if ($this->Petugas_Add->Visible && $this->Petugas_Add->Required) {
            if (!$this->Petugas_Add->IsDetailKey && EmptyValue($this->Petugas_Add->FormValue)) {
                $this->Petugas_Add->addErrorMessage(str_replace("%s", $this->Petugas_Add->caption(), $this->Petugas_Add->RequiredErrorMessage));
            }
        }
        if ($this->Tanggal_Add->Visible && $this->Tanggal_Add->Required) {
            if (!$this->Tanggal_Add->IsDetailKey && EmptyValue($this->Tanggal_Add->FormValue)) {
                $this->Tanggal_Add->addErrorMessage(str_replace("%s", $this->Tanggal_Add->caption(), $this->Tanggal_Add->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['ID_Penggunan'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
        }

        // Set new row
        $rsnew = [];

        // ID_Kontrak
        if ($this->ID_Kontrak->getSessionValue() != "") {
            $this->ID_Kontrak->ReadOnly = true;
        }
        $this->ID_Kontrak->setDbValueDef($rsnew, $this->ID_Kontrak->CurrentValue, $this->ID_Kontrak->ReadOnly);

        // Jenis_Pestisida
        $this->Jenis_Pestisida->setDbValueDef($rsnew, $this->Jenis_Pestisida->CurrentValue, $this->Jenis_Pestisida->ReadOnly);

        // Merek
        $this->Merek->setDbValueDef($rsnew, $this->Merek->CurrentValue, $this->Merek->ReadOnly);

        // Bahan_Aktif
        $this->Bahan_Aktif->setDbValueDef($rsnew, $this->Bahan_Aktif->CurrentValue, $this->Bahan_Aktif->ReadOnly);

        // Dosis_Pemakaian
        $this->Dosis_Pemakaian->setDbValueDef($rsnew, $this->Dosis_Pemakaian->CurrentValue, $this->Dosis_Pemakaian->ReadOnly);

        // Waktu_Aplikasi
        $this->Waktu_Aplikasi->setDbValueDef($rsnew, $this->Waktu_Aplikasi->CurrentValue, $this->Waktu_Aplikasi->ReadOnly);

        // Petugas_Update
        $this->Petugas_Update->CurrentValue = $this->Petugas_Update->getAutoUpdateValue(); // PHP
        $this->Petugas_Update->setDbValueDef($rsnew, $this->Petugas_Update->CurrentValue);

        // Tanggal_Update
        $this->Tanggal_Update->CurrentValue = $this->Tanggal_Update->getAutoUpdateValue(); // PHP
        $this->Tanggal_Update->setDbValueDef($rsnew, $this->Tanggal_Update->CurrentValue);

        // Petugas_Add
        $this->Petugas_Add->setDbValueDef($rsnew, $this->Petugas_Add->CurrentValue, $this->Petugas_Add->ReadOnly);

        // Tanggal_Add
        $this->Tanggal_Add->setDbValueDef($rsnew, UnFormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern()), $this->Tanggal_Add->ReadOnly);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set up foreign key field value from Session
        if ($this->getCurrentMasterTable() == "kontrak") {
            $this->ID_Kontrak->Visible = true; // Need to insert foreign key
            $this->ID_Kontrak->CurrentValue = $this->ID_Kontrak->getSessionValue();
        }

        // Set new row
        $rsnew = [];

        // ID_Kontrak
        $this->ID_Kontrak->setDbValueDef($rsnew, $this->ID_Kontrak->CurrentValue, false);

        // Jenis_Pestisida
        $this->Jenis_Pestisida->setDbValueDef($rsnew, $this->Jenis_Pestisida->CurrentValue, false);

        // Merek
        $this->Merek->setDbValueDef($rsnew, $this->Merek->CurrentValue, false);

        // Bahan_Aktif
        $this->Bahan_Aktif->setDbValueDef($rsnew, $this->Bahan_Aktif->CurrentValue, false);

        // Dosis_Pemakaian
        $this->Dosis_Pemakaian->setDbValueDef($rsnew, $this->Dosis_Pemakaian->CurrentValue, false);

        // Waktu_Aplikasi
        $this->Waktu_Aplikasi->setDbValueDef($rsnew, $this->Waktu_Aplikasi->CurrentValue, false);

        // Petugas_Update
        $this->Petugas_Update->CurrentValue = $this->Petugas_Update->getAutoUpdateValue(); // PHP
        $this->Petugas_Update->setDbValueDef($rsnew, $this->Petugas_Update->CurrentValue);

        // Tanggal_Update
        $this->Tanggal_Update->CurrentValue = $this->Tanggal_Update->getAutoUpdateValue(); // PHP
        $this->Tanggal_Update->setDbValueDef($rsnew, $this->Tanggal_Update->CurrentValue);

        // Petugas_Add
        $this->Petugas_Add->setDbValueDef($rsnew, $this->Petugas_Add->CurrentValue, false);

        // Tanggal_Add
        $this->Tanggal_Add->setDbValueDef($rsnew, UnFormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern()), false);

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }
        return $addRow;
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        // Hide foreign keys
        $masterTblVar = $this->getCurrentMasterTable();
        if ($masterTblVar == "kontrak") {
            $masterTbl = Container("kontrak");
            $this->ID_Kontrak->Visible = false;
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Jenis_Pestisida":
                    break;
                case "x_Merek":
                    break;
                case "x_Bahan_Aktif":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->Add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->MoveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }
}
