<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for kontrak
 */
class Kontrak extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $k_id;
    public $k_id_kontrak;
    public $k_id_lama;
    public $k_no_kontrak;
    public $k_luas_lahan;
    public $pet_id;
    public $koord_id;
    public $kk_id;
    public $prov_id;
    public $kab_id;
    public $kec_id;
    public $desa_id;
    public $blok_id;
    public $sos_id;
    public $var_id;
    public $co_id;
    public $k_jumlah_bibit;
    public $k_asal_bibit;
    public $k_tgl_tanam;
    public $k_es_tgl_panen;
    public $k_ak_tgl_datang;
    public $k_es_qty;
    public $k_ak_qty;
    public $k_es_perhektar;
    public $k_ak_perhektar;
    public $k_skor;
    public $k_ket;
    public $k_cat;
    public $k_titik_koordinat;
    public $k_foto_lahan;
    public $k_dok;
    public $k_harga_bibit;
    public $k_bayar_bibit;
    public $k_pinjaman;
    public $k_bayar_pinjaman;
    public $k_sisa_hutang;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "kontrak";
        $this->TableName = 'kontrak';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "kontrak";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // k_id
        $this->k_id = new DbField(
            $this, // Table
            'x_k_id', // Variable name
            'k_id', // Name
            '`k_id`', // Expression
            '`k_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_id->InputTextType = "text";
        $this->k_id->IsAutoIncrement = true; // Autoincrement field
        $this->k_id->IsPrimaryKey = true; // Primary key field
        $this->k_id->IsForeignKey = true; // Foreign key field
        $this->k_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_id'] = &$this->k_id;

        // k_id_kontrak
        $this->k_id_kontrak = new DbField(
            $this, // Table
            'x_k_id_kontrak', // Variable name
            'k_id_kontrak', // Name
            '`k_id_kontrak`', // Expression
            '`k_id_kontrak`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_id_kontrak`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_id_kontrak->InputTextType = "text";
        $this->k_id_kontrak->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_id_kontrak'] = &$this->k_id_kontrak;

        // k_id_lama
        $this->k_id_lama = new DbField(
            $this, // Table
            'x_k_id_lama', // Variable name
            'k_id_lama', // Name
            '`k_id_lama`', // Expression
            '`k_id_lama`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_id_lama`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_id_lama->InputTextType = "text";
        $this->k_id_lama->Sortable = false; // Allow sort
        $this->k_id_lama->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_id_lama'] = &$this->k_id_lama;

        // k_no_kontrak
        $this->k_no_kontrak = new DbField(
            $this, // Table
            'x_k_no_kontrak', // Variable name
            'k_no_kontrak', // Name
            '`k_no_kontrak`', // Expression
            '`k_no_kontrak`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_no_kontrak`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_no_kontrak->InputTextType = "text";
        $this->k_no_kontrak->Sortable = false; // Allow sort
        $this->k_no_kontrak->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_no_kontrak'] = &$this->k_no_kontrak;

        // k_luas_lahan
        $this->k_luas_lahan = new DbField(
            $this, // Table
            'x_k_luas_lahan', // Variable name
            'k_luas_lahan', // Name
            '`k_luas_lahan`', // Expression
            '`k_luas_lahan`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_luas_lahan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_luas_lahan->InputTextType = "text";
        $this->k_luas_lahan->Nullable = false; // NOT NULL field
        $this->k_luas_lahan->Required = true; // Required field
        $this->k_luas_lahan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_luas_lahan->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['k_luas_lahan'] = &$this->k_luas_lahan;

        // pet_id
        $this->pet_id = new DbField(
            $this, // Table
            'x_pet_id', // Variable name
            'pet_id', // Name
            '`pet_id`', // Expression
            '`pet_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__pet_id', // Virtual expression
            true, // Is virtual
            false, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pet_id->addMethod("getLinkPrefix", fn() => "PetaniView/");
        $this->pet_id->InputTextType = "text";
        $this->pet_id->Required = true; // Required field
        $this->pet_id->Lookup = new Lookup('pet_id', 'petani', false, 'pet_id', ["pet_nama","pet_alamat","",""], '', '', [], [], [], [], [], [], '`pet_nama` ASC', '', "CONCAT(COALESCE(`pet_nama`, ''),'" . ValueSeparator(1, $this->pet_id) . "',COALESCE(`pet_alamat`,''))");
        $this->pet_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pet_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pet_id'] = &$this->pet_id;

        // koord_id
        $this->koord_id = new DbField(
            $this, // Table
            'x_koord_id', // Variable name
            'koord_id', // Name
            '`koord_id`', // Expression
            '`koord_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__koord_id', // Virtual expression
            true, // Is virtual
            false, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->koord_id->addMethod("getLinkPrefix", fn() => "KoordView/");
        $this->koord_id->InputTextType = "text";
        $this->koord_id->Lookup = new Lookup('koord_id', 'koord', false, 'koord_id', ["koord_nama","koord_alamat","",""], '', '', [], ["x_kk_id"], [], [], [], [], '`koord_nama` ASC', '', "CONCAT(COALESCE(`koord_nama`, ''),'" . ValueSeparator(1, $this->koord_id) . "',COALESCE(`koord_alamat`,''))");
        $this->koord_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->koord_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['koord_id'] = &$this->koord_id;

        // kk_id
        $this->kk_id = new DbField(
            $this, // Table
            'x_kk_id', // Variable name
            'kk_id', // Name
            '`kk_id`', // Expression
            '`kk_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`kk_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->kk_id->addMethod("getLinkPrefix", fn() => "kontrak_koordview.php?showdetail=&kk_id=");
        $this->kk_id->InputTextType = "text";
        $this->kk_id->setSelectMultiple(false); // Select one
        $this->kk_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->kk_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->kk_id->Lookup = new Lookup('kk_id', 'kontrak_koord', false, 'kk_id', ["kk_periode","kk_tgl_mulai","kk_tgl_akhir",""], '', '', ["x_koord_id"], [], ["koord_id"], ["x_koord_id"], [], [], '', '', "CONCAT(COALESCE(`kk_periode`, ''),'" . ValueSeparator(1, $this->kk_id) . "',COALESCE(" . CastDateFieldForLike("`kk_tgl_mulai`", 5, "DB") . ",''),'" . ValueSeparator(2, $this->kk_id) . "',COALESCE(" . CastDateFieldForLike("`kk_tgl_akhir`", 5, "DB") . ",''))");
        $this->kk_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->kk_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['kk_id'] = &$this->kk_id;

        // prov_id
        $this->prov_id = new DbField(
            $this, // Table
            'x_prov_id', // Variable name
            'prov_id', // Name
            '`prov_id`', // Expression
            '`prov_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__prov_id', // Virtual expression
            true, // Is virtual
            true, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->prov_id->InputTextType = "text";
        $this->prov_id->Required = true; // Required field
        $this->prov_id->setSelectMultiple(false); // Select one
        $this->prov_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->prov_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->prov_id->Lookup = new Lookup('prov_id', 'prov', false, 'prov_id', ["prov_nama","","",""], '', '', [], ["x_kab_id","x_kec_id","x_desa_id"], [], [], [], [], '`prov_nama` ASC', '', "`prov_nama`");
        $this->prov_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->prov_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['prov_id'] = &$this->prov_id;

        // kab_id
        $this->kab_id = new DbField(
            $this, // Table
            'x_kab_id', // Variable name
            'kab_id', // Name
            '`kab_id`', // Expression
            '`kab_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__kab_id', // Virtual expression
            true, // Is virtual
            true, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->kab_id->InputTextType = "text";
        $this->kab_id->Required = true; // Required field
        $this->kab_id->setSelectMultiple(false); // Select one
        $this->kab_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->kab_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->kab_id->Lookup = new Lookup('kab_id', 'kab', false, 'kab_id', ["kab_nama","","",""], '', '', ["x_prov_id"], ["x_kec_id","x_desa_id"], ["kab_prov_id"], ["x_kab_prov_id"], [], [], '`kab_nama` ASC', '', "`kab_nama`");
        $this->kab_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->kab_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['kab_id'] = &$this->kab_id;

        // kec_id
        $this->kec_id = new DbField(
            $this, // Table
            'x_kec_id', // Variable name
            'kec_id', // Name
            '`kec_id`', // Expression
            '`kec_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__kec_id', // Virtual expression
            true, // Is virtual
            true, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->kec_id->InputTextType = "text";
        $this->kec_id->Required = true; // Required field
        $this->kec_id->setSelectMultiple(false); // Select one
        $this->kec_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->kec_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->kec_id->Lookup = new Lookup('kec_id', 'kec', false, 'kec_id', ["kec_nama","","",""], '', '', ["x_prov_id","x_kab_id"], ["x_desa_id"], ["kec_prov_id","kec_kab_id"], ["x_kec_prov_id","x_kec_kab_id"], [], [], '`kec_nama` ASC', '', "`kec_nama`");
        $this->kec_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->kec_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['kec_id'] = &$this->kec_id;

        // desa_id
        $this->desa_id = new DbField(
            $this, // Table
            'x_desa_id', // Variable name
            'desa_id', // Name
            '`desa_id`', // Expression
            '`desa_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__desa_id', // Virtual expression
            true, // Is virtual
            true, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->desa_id->InputTextType = "text";
        $this->desa_id->Required = true; // Required field
        $this->desa_id->setSelectMultiple(false); // Select one
        $this->desa_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->desa_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->desa_id->Lookup = new Lookup('desa_id', 'desa', false, 'desa_id', ["desa_nama","","",""], '', '', ["x_prov_id","x_kab_id","x_kec_id"], [], ["desa_prov_id","desa_kab_id","desa_kec_id"], ["x_desa_prov_id","x_desa_kab_id","x_desa_kec_id"], [], [], '`desa_nama` ASC', '', "`desa_nama`");
        $this->desa_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->desa_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['desa_id'] = &$this->desa_id;

        // blok_id
        $this->blok_id = new DbField(
            $this, // Table
            'x_blok_id', // Variable name
            'blok_id', // Name
            '`blok_id`', // Expression
            '`blok_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__blok_id', // Virtual expression
            true, // Is virtual
            false, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->blok_id->InputTextType = "text";
        $this->blok_id->Lookup = new Lookup('blok_id', 'blok', false, 'blok_id', ["blok_nama","","",""], '', '', [], [], [], [], [], [], '`blok_nama` ASC', '', "`blok_nama`");
        $this->blok_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->blok_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['blok_id'] = &$this->blok_id;

        // sos_id
        $this->sos_id = new DbField(
            $this, // Table
            'x_sos_id', // Variable name
            'sos_id', // Name
            '`sos_id`', // Expression
            '`sos_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__sos_id', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->sos_id->InputTextType = "text";
        $this->sos_id->setSelectMultiple(false); // Select one
        $this->sos_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->sos_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->sos_id->Lookup = new Lookup('sos_id', 'sosialisasi', false, 'sos_id', ["sos_id","sos_tgl","sos_alamat",""], '', '', [], [], [], [], [], [], '`sos_tgl` DESC', '', "CONCAT(COALESCE(`sos_id`, ''),'" . ValueSeparator(1, $this->sos_id) . "',COALESCE(" . CastDateFieldForLike("`sos_tgl`", 0, "DB") . ",''),'" . ValueSeparator(2, $this->sos_id) . "',COALESCE(`sos_alamat`,''))");
        $this->sos_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->sos_id->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sos_id'] = &$this->sos_id;

        // var_id
        $this->var_id = new DbField(
            $this, // Table
            'x_var_id', // Variable name
            'var_id', // Name
            '`var_id`', // Expression
            '`var_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`var_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->var_id->addMethod("getLinkPrefix", fn() => "VarietasView/");
        $this->var_id->InputTextType = "text";
        $this->var_id->Required = true; // Required field
        $this->var_id->setSelectMultiple(false); // Select one
        $this->var_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->var_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->var_id->Lookup = new Lookup('var_id', 'varietas', false, 'var_id', ["var_nama","","",""], '', '', [], [], [], [], [], [], '`var_nama` ASC', '', "`var_nama`");
        $this->var_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->var_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['var_id'] = &$this->var_id;

        // co_id
        $this->co_id = new DbField(
            $this, // Table
            'x_co_id', // Variable name
            'co_id', // Name
            '`co_id`', // Expression
            '`co_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`co_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->co_id->addMethod("getLinkPrefix", fn() => "CoView/");
        $this->co_id->InputTextType = "text";
        $this->co_id->Required = true; // Required field
        $this->co_id->setSelectMultiple(false); // Select one
        $this->co_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->co_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->co_id->Lookup = new Lookup('co_id', 'co', false, 'co_id', ["co_nama","","",""], '', '', [], [], [], [], [], [], '`co_nama` ASC', '', "`co_nama`");
        $this->co_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->co_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['co_id'] = &$this->co_id;

        // k_jumlah_bibit
        $this->k_jumlah_bibit = new DbField(
            $this, // Table
            'x_k_jumlah_bibit', // Variable name
            'k_jumlah_bibit', // Name
            '`k_jumlah_bibit`', // Expression
            '`k_jumlah_bibit`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_jumlah_bibit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_jumlah_bibit->InputTextType = "text";
        $this->k_jumlah_bibit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_jumlah_bibit->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_jumlah_bibit'] = &$this->k_jumlah_bibit;

        // k_asal_bibit
        $this->k_asal_bibit = new DbField(
            $this, // Table
            'x_k_asal_bibit', // Variable name
            'k_asal_bibit', // Name
            '`k_asal_bibit`', // Expression
            '`k_asal_bibit`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_asal_bibit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_asal_bibit->InputTextType = "text";
        $this->k_asal_bibit->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_asal_bibit'] = &$this->k_asal_bibit;

        // k_tgl_tanam
        $this->k_tgl_tanam = new DbField(
            $this, // Table
            'x_k_tgl_tanam', // Variable name
            'k_tgl_tanam', // Name
            '`k_tgl_tanam`', // Expression
            CastDateFieldForLike("`k_tgl_tanam`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`k_tgl_tanam`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_tgl_tanam->InputTextType = "text";
        $this->k_tgl_tanam->Required = true; // Required field
        $this->k_tgl_tanam->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->k_tgl_tanam->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_tgl_tanam'] = &$this->k_tgl_tanam;

        // k_es_tgl_panen
        $this->k_es_tgl_panen = new DbField(
            $this, // Table
            'x_k_es_tgl_panen', // Variable name
            'k_es_tgl_panen', // Name
            '`k_es_tgl_panen`', // Expression
            CastDateFieldForLike("`k_es_tgl_panen`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`k_es_tgl_panen`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_es_tgl_panen->InputTextType = "text";
        $this->k_es_tgl_panen->Required = true; // Required field
        $this->k_es_tgl_panen->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->k_es_tgl_panen->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_es_tgl_panen'] = &$this->k_es_tgl_panen;

        // k_ak_tgl_datang
        $this->k_ak_tgl_datang = new DbField(
            $this, // Table
            'x_k_ak_tgl_datang', // Variable name
            'k_ak_tgl_datang', // Name
            '`k_ak_tgl_datang`', // Expression
            CastDateFieldForLike("`k_ak_tgl_datang`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`k_ak_tgl_datang`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_ak_tgl_datang->InputTextType = "text";
        $this->k_ak_tgl_datang->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->k_ak_tgl_datang->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_ak_tgl_datang'] = &$this->k_ak_tgl_datang;

        // k_es_qty
        $this->k_es_qty = new DbField(
            $this, // Table
            'x_k_es_qty', // Variable name
            'k_es_qty', // Name
            '`k_es_qty`', // Expression
            '`k_es_qty`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_es_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_es_qty->InputTextType = "text";
        $this->k_es_qty->Required = true; // Required field
        $this->k_es_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_es_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_es_qty'] = &$this->k_es_qty;

        // k_ak_qty
        $this->k_ak_qty = new DbField(
            $this, // Table
            'x_k_ak_qty', // Variable name
            'k_ak_qty', // Name
            '`k_ak_qty`', // Expression
            '`k_ak_qty`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_ak_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_ak_qty->InputTextType = "text";
        $this->k_ak_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_ak_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_ak_qty'] = &$this->k_ak_qty;

        // k_es_perhektar
        $this->k_es_perhektar = new DbField(
            $this, // Table
            'x_k_es_perhektar', // Variable name
            'k_es_perhektar', // Name
            '`k_es_perhektar`', // Expression
            '`k_es_perhektar`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_es_perhektar`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_es_perhektar->InputTextType = "text";
        $this->k_es_perhektar->Required = true; // Required field
        $this->k_es_perhektar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_es_perhektar->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_es_perhektar'] = &$this->k_es_perhektar;

        // k_ak_perhektar
        $this->k_ak_perhektar = new DbField(
            $this, // Table
            'x_k_ak_perhektar', // Variable name
            'k_ak_perhektar', // Name
            '`k_ak_perhektar`', // Expression
            '`k_ak_perhektar`', // Basic search expression
            5, // Type
            15, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_ak_perhektar`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_ak_perhektar->InputTextType = "text";
        $this->k_ak_perhektar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_ak_perhektar->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_ak_perhektar'] = &$this->k_ak_perhektar;

        // k_skor
        $this->k_skor = new DbField(
            $this, // Table
            'x_k_skor', // Variable name
            'k_skor', // Name
            '`k_skor`', // Expression
            '`k_skor`', // Basic search expression
            5, // Type
            15, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_skor`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_skor->InputTextType = "text";
        $this->k_skor->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_skor->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_skor'] = &$this->k_skor;

        // k_ket
        $this->k_ket = new DbField(
            $this, // Table
            'x_k_ket', // Variable name
            'k_ket', // Name
            '`k_ket`', // Expression
            '`k_ket`', // Basic search expression
            201, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_ket`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->k_ket->InputTextType = "text";
        $this->k_ket->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_ket'] = &$this->k_ket;

        // k_cat
        $this->k_cat = new DbField(
            $this, // Table
            'x_k_cat', // Variable name
            'k_cat', // Name
            '`k_cat`', // Expression
            '`k_cat`', // Basic search expression
            201, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_cat`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->k_cat->InputTextType = "text";
        $this->k_cat->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_cat'] = &$this->k_cat;

        // k_titik_koordinat
        $this->k_titik_koordinat = new DbField(
            $this, // Table
            'x_k_titik_koordinat', // Variable name
            'k_titik_koordinat', // Name
            '`k_titik_koordinat`', // Expression
            '`k_titik_koordinat`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_titik_koordinat`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_titik_koordinat->addMethod("getDefault", fn() => "https://www.google.com/maps/place/");
        $this->k_titik_koordinat->InputTextType = "text";
        $this->k_titik_koordinat->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_titik_koordinat'] = &$this->k_titik_koordinat;

        // k_foto_lahan
        $this->k_foto_lahan = new DbField(
            $this, // Table
            'x_k_foto_lahan', // Variable name
            'k_foto_lahan', // Name
            '`k_foto_lahan`', // Expression
            '`k_foto_lahan`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`k_foto_lahan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->k_foto_lahan->addMethod("getUploadPath", fn() => "foto_lahan");
        $this->k_foto_lahan->InputTextType = "text";
        $this->k_foto_lahan->ImageResize = true;
        $this->k_foto_lahan->UploadMultiple = true;
        $this->k_foto_lahan->Upload->UploadMultiple = true;
        $this->k_foto_lahan->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_foto_lahan'] = &$this->k_foto_lahan;

        // k_dok
        $this->k_dok = new DbField(
            $this, // Table
            'x_k_dok', // Variable name
            'k_dok', // Name
            '`k_dok`', // Expression
            '`k_dok`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`k_dok`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->k_dok->addMethod("getUploadPath", fn() => "dokumen_kontrak_lahan");
        $this->k_dok->InputTextType = "text";
        $this->k_dok->ImageResize = true;
        $this->k_dok->UploadMultiple = true;
        $this->k_dok->Upload->UploadMultiple = true;
        $this->k_dok->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['k_dok'] = &$this->k_dok;

        // k_harga_bibit
        $this->k_harga_bibit = new DbField(
            $this, // Table
            'x_k_harga_bibit', // Variable name
            'k_harga_bibit', // Name
            '`k_harga_bibit`', // Expression
            '`k_harga_bibit`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_harga_bibit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_harga_bibit->InputTextType = "text";
        $this->k_harga_bibit->Nullable = false; // NOT NULL field
        $this->k_harga_bibit->Required = true; // Required field
        $this->k_harga_bibit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_harga_bibit->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['k_harga_bibit'] = &$this->k_harga_bibit;

        // k_bayar_bibit
        $this->k_bayar_bibit = new DbField(
            $this, // Table
            'x_k_bayar_bibit', // Variable name
            'k_bayar_bibit', // Name
            '`k_bayar_bibit`', // Expression
            '`k_bayar_bibit`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_bayar_bibit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_bayar_bibit->InputTextType = "text";
        $this->k_bayar_bibit->Nullable = false; // NOT NULL field
        $this->k_bayar_bibit->Required = true; // Required field
        $this->k_bayar_bibit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_bayar_bibit->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['k_bayar_bibit'] = &$this->k_bayar_bibit;

        // k_pinjaman
        $this->k_pinjaman = new DbField(
            $this, // Table
            'x_k_pinjaman', // Variable name
            'k_pinjaman', // Name
            '`k_pinjaman`', // Expression
            '`k_pinjaman`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_pinjaman`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_pinjaman->InputTextType = "text";
        $this->k_pinjaman->Nullable = false; // NOT NULL field
        $this->k_pinjaman->Required = true; // Required field
        $this->k_pinjaman->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_pinjaman->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['k_pinjaman'] = &$this->k_pinjaman;

        // k_bayar_pinjaman
        $this->k_bayar_pinjaman = new DbField(
            $this, // Table
            'x_k_bayar_pinjaman', // Variable name
            'k_bayar_pinjaman', // Name
            '`k_bayar_pinjaman`', // Expression
            '`k_bayar_pinjaman`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_bayar_pinjaman`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_bayar_pinjaman->InputTextType = "text";
        $this->k_bayar_pinjaman->Nullable = false; // NOT NULL field
        $this->k_bayar_pinjaman->Required = true; // Required field
        $this->k_bayar_pinjaman->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_bayar_pinjaman->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['k_bayar_pinjaman'] = &$this->k_bayar_pinjaman;

        // k_sisa_hutang
        $this->k_sisa_hutang = new DbField(
            $this, // Table
            'x_k_sisa_hutang', // Variable name
            'k_sisa_hutang', // Name
            '`k_sisa_hutang`', // Expression
            '`k_sisa_hutang`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`k_sisa_hutang`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->k_sisa_hutang->InputTextType = "text";
        $this->k_sisa_hutang->Nullable = false; // NOT NULL field
        $this->k_sisa_hutang->Required = true; // Required field
        $this->k_sisa_hutang->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->k_sisa_hutang->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['k_sisa_hutang'] = &$this->k_sisa_hutang;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            $this->setSessionOrderByList($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "penggunaan_pestisida") {
            $detailUrl = Container("penggunaan_pestisida")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_k_id", $this->k_id->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "KontrakList";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "kontrak";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlSelectList() // Select for List page
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT *, (SELECT CONCAT(COALESCE(`pet_nama`, ''),'" . ValueSeparator(1, $this->pet_id) . "',COALESCE(`pet_alamat`,'')) FROM petani TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.pet_id = kontrak.pet_id LIMIT 1) AS EV__pet_id, (SELECT CONCAT(COALESCE(`koord_nama`, ''),'" . ValueSeparator(1, $this->koord_id) . "',COALESCE(`koord_alamat`,'')) FROM koord TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.koord_id = kontrak.koord_id LIMIT 1) AS EV__koord_id, (SELECT `prov_nama` FROM prov TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.prov_id = kontrak.prov_id LIMIT 1) AS EV__prov_id, (SELECT `kab_nama` FROM kab TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.kab_id = kontrak.kab_id LIMIT 1) AS EV__kab_id, (SELECT `kec_nama` FROM kec TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.kec_id = kontrak.kec_id LIMIT 1) AS EV__kec_id, (SELECT `desa_nama` FROM desa TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.desa_id = kontrak.desa_id LIMIT 1) AS EV__desa_id, (SELECT `blok_nama` FROM blok TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.blok_id = kontrak.blok_id LIMIT 1) AS EV__blok_id, (SELECT CONCAT(COALESCE(`sos_id`, ''),'" . ValueSeparator(1, $this->sos_id) . "',COALESCE(" . CastDateFieldForLike("`sos_tgl`", 0, "DB") . ",''),'" . ValueSeparator(2, $this->sos_id) . "',COALESCE(`sos_alamat`,'')) FROM sosialisasi TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.sos_id = kontrak.sos_id LIMIT 1) AS EV__sos_id FROM kontrak)";
        return $from . " TMP_TABLE";
    }

    public function sqlSelectList() // For backward compatibility
    {
        return $this->getSqlSelectList();
    }

    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->pet_id->AdvancedSearch->SearchValue != "" ||
            $this->pet_id->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->pet_id->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->pet_id->VirtualExpression . " ")) {
            return true;
        }
        if (
            $this->koord_id->AdvancedSearch->SearchValue != "" ||
            $this->koord_id->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->koord_id->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->koord_id->VirtualExpression . " ")) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->prov_id->VirtualExpression . " ")) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->kab_id->VirtualExpression . " ")) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->kec_id->VirtualExpression . " ")) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->desa_id->VirtualExpression . " ")) {
            return true;
        }
        if (
            $this->blok_id->AdvancedSearch->SearchValue != "" ||
            $this->blok_id->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->blok_id->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->blok_id->VirtualExpression . " ")) {
            return true;
        }
        if (
            $this->sos_id->AdvancedSearch->SearchValue != "" ||
            $this->sos_id->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->sos_id->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->sos_id->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
            // Get insert id if necessary
            $this->k_id->setDbValue($conn->lastInsertId());
            $rs['k_id'] = $this->k_id->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['k_id']) && !EmptyValue($this->k_id->CurrentValue)) {
                $rs['k_id'] = $this->k_id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('k_id', $rs)) {
                AddFilter($where, QuotedName('k_id', $this->Dbid) . '=' . QuotedValue($rs['k_id'], $this->k_id->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->k_id->DbValue = $row['k_id'];
        $this->k_id_kontrak->DbValue = $row['k_id_kontrak'];
        $this->k_id_lama->DbValue = $row['k_id_lama'];
        $this->k_no_kontrak->DbValue = $row['k_no_kontrak'];
        $this->k_luas_lahan->DbValue = $row['k_luas_lahan'];
        $this->pet_id->DbValue = $row['pet_id'];
        $this->koord_id->DbValue = $row['koord_id'];
        $this->kk_id->DbValue = $row['kk_id'];
        $this->prov_id->DbValue = $row['prov_id'];
        $this->kab_id->DbValue = $row['kab_id'];
        $this->kec_id->DbValue = $row['kec_id'];
        $this->desa_id->DbValue = $row['desa_id'];
        $this->blok_id->DbValue = $row['blok_id'];
        $this->sos_id->DbValue = $row['sos_id'];
        $this->var_id->DbValue = $row['var_id'];
        $this->co_id->DbValue = $row['co_id'];
        $this->k_jumlah_bibit->DbValue = $row['k_jumlah_bibit'];
        $this->k_asal_bibit->DbValue = $row['k_asal_bibit'];
        $this->k_tgl_tanam->DbValue = $row['k_tgl_tanam'];
        $this->k_es_tgl_panen->DbValue = $row['k_es_tgl_panen'];
        $this->k_ak_tgl_datang->DbValue = $row['k_ak_tgl_datang'];
        $this->k_es_qty->DbValue = $row['k_es_qty'];
        $this->k_ak_qty->DbValue = $row['k_ak_qty'];
        $this->k_es_perhektar->DbValue = $row['k_es_perhektar'];
        $this->k_ak_perhektar->DbValue = $row['k_ak_perhektar'];
        $this->k_skor->DbValue = $row['k_skor'];
        $this->k_ket->DbValue = $row['k_ket'];
        $this->k_cat->DbValue = $row['k_cat'];
        $this->k_titik_koordinat->DbValue = $row['k_titik_koordinat'];
        $this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
        $this->k_dok->Upload->DbValue = $row['k_dok'];
        $this->k_harga_bibit->DbValue = $row['k_harga_bibit'];
        $this->k_bayar_bibit->DbValue = $row['k_bayar_bibit'];
        $this->k_pinjaman->DbValue = $row['k_pinjaman'];
        $this->k_bayar_pinjaman->DbValue = $row['k_bayar_pinjaman'];
        $this->k_sisa_hutang->DbValue = $row['k_sisa_hutang'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->k_foto_lahan->OldUploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['k_foto_lahan']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['k_foto_lahan']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->k_foto_lahan->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->k_foto_lahan->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->k_dok->OldUploadPath = $this->k_dok->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['k_dok']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['k_dok']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->k_dok->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->k_dok->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`k_id` = @k_id@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->k_id->CurrentValue : $this->k_id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->k_id->CurrentValue = $keys[0];
            } else {
                $this->k_id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('k_id', $row) ? $row['k_id'] : null;
        } else {
            $val = !EmptyValue($this->k_id->OldValue) && !$current ? $this->k_id->OldValue : $this->k_id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@k_id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("KontrakList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "KontrakView") {
            return $Language->phrase("View");
        } elseif ($pageName == "KontrakEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "KontrakAdd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "KontrakView";
            case Config("API_ADD_ACTION"):
                return "KontrakAdd";
            case Config("API_EDIT_ACTION"):
                return "KontrakEdit";
            case Config("API_DELETE_ACTION"):
                return "KontrakDelete";
            case Config("API_LIST_ACTION"):
                return "KontrakList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "KontrakList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("KontrakView", $parm);
        } else {
            $url = $this->keyUrl("KontrakView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "KontrakAdd?" . $parm;
        } else {
            $url = "KontrakAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("KontrakEdit", $parm);
        } else {
            $url = $this->keyUrl("KontrakEdit", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("KontrakList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("KontrakAdd", $parm);
        } else {
            $url = $this->keyUrl("KontrakAdd", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("KontrakList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("KontrakDelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"k_id\":" . JsonEncode($this->k_id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->k_id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->k_id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("k_id") ?? Route("k_id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->k_id->CurrentValue = $key;
            } else {
                $this->k_id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->k_id->setDbValue($row['k_id']);
        $this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
        $this->k_id_lama->setDbValue($row['k_id_lama']);
        $this->k_no_kontrak->setDbValue($row['k_no_kontrak']);
        $this->k_luas_lahan->setDbValue($row['k_luas_lahan']);
        $this->pet_id->setDbValue($row['pet_id']);
        $this->koord_id->setDbValue($row['koord_id']);
        $this->kk_id->setDbValue($row['kk_id']);
        $this->prov_id->setDbValue($row['prov_id']);
        $this->kab_id->setDbValue($row['kab_id']);
        $this->kec_id->setDbValue($row['kec_id']);
        $this->desa_id->setDbValue($row['desa_id']);
        $this->blok_id->setDbValue($row['blok_id']);
        $this->sos_id->setDbValue($row['sos_id']);
        $this->var_id->setDbValue($row['var_id']);
        $this->co_id->setDbValue($row['co_id']);
        $this->k_jumlah_bibit->setDbValue($row['k_jumlah_bibit']);
        $this->k_asal_bibit->setDbValue($row['k_asal_bibit']);
        $this->k_tgl_tanam->setDbValue($row['k_tgl_tanam']);
        $this->k_es_tgl_panen->setDbValue($row['k_es_tgl_panen']);
        $this->k_ak_tgl_datang->setDbValue($row['k_ak_tgl_datang']);
        $this->k_es_qty->setDbValue($row['k_es_qty']);
        $this->k_ak_qty->setDbValue($row['k_ak_qty']);
        $this->k_es_perhektar->setDbValue($row['k_es_perhektar']);
        $this->k_ak_perhektar->setDbValue($row['k_ak_perhektar']);
        $this->k_skor->setDbValue($row['k_skor']);
        $this->k_ket->setDbValue($row['k_ket']);
        $this->k_cat->setDbValue($row['k_cat']);
        $this->k_titik_koordinat->setDbValue($row['k_titik_koordinat']);
        $this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
        $this->k_dok->Upload->DbValue = $row['k_dok'];
        $this->k_harga_bibit->setDbValue($row['k_harga_bibit']);
        $this->k_bayar_bibit->setDbValue($row['k_bayar_bibit']);
        $this->k_pinjaman->setDbValue($row['k_pinjaman']);
        $this->k_bayar_pinjaman->setDbValue($row['k_bayar_pinjaman']);
        $this->k_sisa_hutang->setDbValue($row['k_sisa_hutang']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "KontrakList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // k_id
        $this->k_id->CellCssStyle = "white-space: nowrap;";

        // k_id_kontrak

        // k_id_lama
        $this->k_id_lama->CellCssStyle = "white-space: nowrap;";

        // k_no_kontrak
        $this->k_no_kontrak->CellCssStyle = "white-space: nowrap;";

        // k_luas_lahan

        // pet_id

        // koord_id

        // kk_id

        // prov_id

        // kab_id

        // kec_id

        // desa_id

        // blok_id

        // sos_id

        // var_id

        // co_id

        // k_jumlah_bibit

        // k_asal_bibit

        // k_tgl_tanam

        // k_es_tgl_panen

        // k_ak_tgl_datang

        // k_es_qty

        // k_ak_qty

        // k_es_perhektar

        // k_ak_perhektar

        // k_skor

        // k_ket

        // k_cat

        // k_titik_koordinat

        // k_foto_lahan

        // k_dok

        // k_harga_bibit

        // k_bayar_bibit

        // k_pinjaman

        // k_bayar_pinjaman

        // k_sisa_hutang

        // k_id
        $this->k_id->ViewValue = $this->k_id->CurrentValue;

        // k_id_kontrak
        $this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;

        // k_id_lama
        $this->k_id_lama->ViewValue = $this->k_id_lama->CurrentValue;

        // k_no_kontrak
        $this->k_no_kontrak->ViewValue = $this->k_no_kontrak->CurrentValue;

        // k_luas_lahan
        $this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;

        // pet_id
        if ($this->pet_id->VirtualValue != "") {
            $this->pet_id->ViewValue = $this->pet_id->VirtualValue;
        } else {
            $this->pet_id->ViewValue = $this->pet_id->CurrentValue;
            $curVal = strval($this->pet_id->CurrentValue);
            if ($curVal != "") {
                $this->pet_id->ViewValue = $this->pet_id->lookupCacheOption($curVal);
                if ($this->pet_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`pet_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->pet_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pet_id->Lookup->renderViewRow($rswrk[0]);
                        $this->pet_id->ViewValue = $this->pet_id->displayValue($arwrk);
                    } else {
                        $this->pet_id->ViewValue = $this->pet_id->CurrentValue;
                    }
                }
            } else {
                $this->pet_id->ViewValue = null;
            }
        }

        // koord_id
        if ($this->koord_id->VirtualValue != "") {
            $this->koord_id->ViewValue = $this->koord_id->VirtualValue;
        } else {
            $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
            $curVal = strval($this->koord_id->CurrentValue);
            if ($curVal != "") {
                $this->koord_id->ViewValue = $this->koord_id->lookupCacheOption($curVal);
                if ($this->koord_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`koord_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->koord_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->koord_id->Lookup->renderViewRow($rswrk[0]);
                        $this->koord_id->ViewValue = $this->koord_id->displayValue($arwrk);
                    } else {
                        $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                    }
                }
            } else {
                $this->koord_id->ViewValue = null;
            }
        }

        // kk_id
        $curVal = strval($this->kk_id->CurrentValue);
        if ($curVal != "") {
            $this->kk_id->ViewValue = $this->kk_id->lookupCacheOption($curVal);
            if ($this->kk_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`kk_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->kk_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->kk_id->Lookup->renderViewRow($rswrk[0]);
                    $this->kk_id->ViewValue = $this->kk_id->displayValue($arwrk);
                } else {
                    $this->kk_id->ViewValue = $this->kk_id->CurrentValue;
                }
            }
        } else {
            $this->kk_id->ViewValue = null;
        }

        // prov_id
        if ($this->prov_id->VirtualValue != "") {
            $this->prov_id->ViewValue = $this->prov_id->VirtualValue;
        } else {
            $curVal = strval($this->prov_id->CurrentValue);
            if ($curVal != "") {
                $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
                if ($this->prov_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->prov_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->prov_id->Lookup->renderViewRow($rswrk[0]);
                        $this->prov_id->ViewValue = $this->prov_id->displayValue($arwrk);
                    } else {
                        $this->prov_id->ViewValue = $this->prov_id->CurrentValue;
                    }
                }
            } else {
                $this->prov_id->ViewValue = null;
            }
        }

        // kab_id
        if ($this->kab_id->VirtualValue != "") {
            $this->kab_id->ViewValue = $this->kab_id->VirtualValue;
        } else {
            $curVal = strval($this->kab_id->CurrentValue);
            if ($curVal != "") {
                $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
                if ($this->kab_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->kab_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->kab_id->Lookup->renderViewRow($rswrk[0]);
                        $this->kab_id->ViewValue = $this->kab_id->displayValue($arwrk);
                    } else {
                        $this->kab_id->ViewValue = $this->kab_id->CurrentValue;
                    }
                }
            } else {
                $this->kab_id->ViewValue = null;
            }
        }

        // kec_id
        if ($this->kec_id->VirtualValue != "") {
            $this->kec_id->ViewValue = $this->kec_id->VirtualValue;
        } else {
            $curVal = strval($this->kec_id->CurrentValue);
            if ($curVal != "") {
                $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
                if ($this->kec_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->kec_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->kec_id->Lookup->renderViewRow($rswrk[0]);
                        $this->kec_id->ViewValue = $this->kec_id->displayValue($arwrk);
                    } else {
                        $this->kec_id->ViewValue = $this->kec_id->CurrentValue;
                    }
                }
            } else {
                $this->kec_id->ViewValue = null;
            }
        }

        // desa_id
        if ($this->desa_id->VirtualValue != "") {
            $this->desa_id->ViewValue = $this->desa_id->VirtualValue;
        } else {
            $curVal = strval($this->desa_id->CurrentValue);
            if ($curVal != "") {
                $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
                if ($this->desa_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->desa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->desa_id->Lookup->renderViewRow($rswrk[0]);
                        $this->desa_id->ViewValue = $this->desa_id->displayValue($arwrk);
                    } else {
                        $this->desa_id->ViewValue = $this->desa_id->CurrentValue;
                    }
                }
            } else {
                $this->desa_id->ViewValue = null;
            }
        }

        // blok_id
        if ($this->blok_id->VirtualValue != "") {
            $this->blok_id->ViewValue = $this->blok_id->VirtualValue;
        } else {
            $this->blok_id->ViewValue = $this->blok_id->CurrentValue;
            $curVal = strval($this->blok_id->CurrentValue);
            if ($curVal != "") {
                $this->blok_id->ViewValue = $this->blok_id->lookupCacheOption($curVal);
                if ($this->blok_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`blok_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->blok_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->blok_id->Lookup->renderViewRow($rswrk[0]);
                        $this->blok_id->ViewValue = $this->blok_id->displayValue($arwrk);
                    } else {
                        $this->blok_id->ViewValue = $this->blok_id->CurrentValue;
                    }
                }
            } else {
                $this->blok_id->ViewValue = null;
            }
        }

        // sos_id
        if ($this->sos_id->VirtualValue != "") {
            $this->sos_id->ViewValue = $this->sos_id->VirtualValue;
        } else {
            $curVal = strval($this->sos_id->CurrentValue);
            if ($curVal != "") {
                $this->sos_id->ViewValue = $this->sos_id->lookupCacheOption($curVal);
                if ($this->sos_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`sos_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_id->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_id->ViewValue = $this->sos_id->displayValue($arwrk);
                    } else {
                        $this->sos_id->ViewValue = $this->sos_id->CurrentValue;
                    }
                }
            } else {
                $this->sos_id->ViewValue = null;
            }
        }

        // var_id
        $curVal = strval($this->var_id->CurrentValue);
        if ($curVal != "") {
            $this->var_id->ViewValue = $this->var_id->lookupCacheOption($curVal);
            if ($this->var_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->var_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->var_id->Lookup->renderViewRow($rswrk[0]);
                    $this->var_id->ViewValue = $this->var_id->displayValue($arwrk);
                } else {
                    $this->var_id->ViewValue = $this->var_id->CurrentValue;
                }
            }
        } else {
            $this->var_id->ViewValue = null;
        }

        // co_id
        $curVal = strval($this->co_id->CurrentValue);
        if ($curVal != "") {
            $this->co_id->ViewValue = $this->co_id->lookupCacheOption($curVal);
            if ($this->co_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->co_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->co_id->Lookup->renderViewRow($rswrk[0]);
                    $this->co_id->ViewValue = $this->co_id->displayValue($arwrk);
                } else {
                    $this->co_id->ViewValue = $this->co_id->CurrentValue;
                }
            }
        } else {
            $this->co_id->ViewValue = null;
        }

        // k_jumlah_bibit
        $this->k_jumlah_bibit->ViewValue = $this->k_jumlah_bibit->CurrentValue;

        // k_asal_bibit
        $this->k_asal_bibit->ViewValue = $this->k_asal_bibit->CurrentValue;

        // k_tgl_tanam
        $this->k_tgl_tanam->ViewValue = $this->k_tgl_tanam->CurrentValue;
        $this->k_tgl_tanam->ViewValue = FormatDateTime($this->k_tgl_tanam->ViewValue, $this->k_tgl_tanam->formatPattern());

        // k_es_tgl_panen
        $this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
        $this->k_es_tgl_panen->ViewValue = FormatDateTime($this->k_es_tgl_panen->ViewValue, $this->k_es_tgl_panen->formatPattern());

        // k_ak_tgl_datang
        $this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
        $this->k_ak_tgl_datang->ViewValue = FormatDateTime($this->k_ak_tgl_datang->ViewValue, $this->k_ak_tgl_datang->formatPattern());

        // k_es_qty
        $this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;

        // k_ak_qty
        $this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;

        // k_es_perhektar
        $this->k_es_perhektar->ViewValue = $this->k_es_perhektar->CurrentValue;

        // k_ak_perhektar
        $this->k_ak_perhektar->ViewValue = $this->k_ak_perhektar->CurrentValue;
        $this->k_ak_perhektar->ViewValue = FormatNumber($this->k_ak_perhektar->ViewValue, $this->k_ak_perhektar->formatPattern());

        // k_skor
        $this->k_skor->ViewValue = $this->k_skor->CurrentValue;
        $this->k_skor->ViewValue = FormatNumber($this->k_skor->ViewValue, $this->k_skor->formatPattern());

        // k_ket
        $this->k_ket->ViewValue = $this->k_ket->CurrentValue;

        // k_cat
        $this->k_cat->ViewValue = $this->k_cat->CurrentValue;

        // k_titik_koordinat
        $this->k_titik_koordinat->ViewValue = $this->k_titik_koordinat->CurrentValue;
        $this->k_titik_koordinat->CellCssStyle .= "text-align: left;";

        // k_foto_lahan
        $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
        if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
            $this->k_foto_lahan->ImageWidth = 40;
            $this->k_foto_lahan->ImageHeight = 30;
            $this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->alt();
            $this->k_foto_lahan->ImageCssClass = "ew-image";
            $this->k_foto_lahan->ViewValue = $this->k_foto_lahan->Upload->DbValue;
        } else {
            $this->k_foto_lahan->ViewValue = "";
        }
        $this->k_foto_lahan->CellCssStyle .= "text-align: left;";

        // k_dok
        $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
        if (!EmptyValue($this->k_dok->Upload->DbValue)) {
            $this->k_dok->ImageWidth = 42;
            $this->k_dok->ImageHeight = 70;
            $this->k_dok->ImageAlt = $this->k_dok->alt();
            $this->k_dok->ImageCssClass = "ew-image";
            $this->k_dok->ViewValue = $this->k_dok->Upload->DbValue;
        } else {
            $this->k_dok->ViewValue = "";
        }

        // k_harga_bibit
        $this->k_harga_bibit->ViewValue = $this->k_harga_bibit->CurrentValue;

        // k_bayar_bibit
        $this->k_bayar_bibit->ViewValue = $this->k_bayar_bibit->CurrentValue;

        // k_pinjaman
        $this->k_pinjaman->ViewValue = $this->k_pinjaman->CurrentValue;

        // k_bayar_pinjaman
        $this->k_bayar_pinjaman->ViewValue = $this->k_bayar_pinjaman->CurrentValue;

        // k_sisa_hutang
        $this->k_sisa_hutang->ViewValue = $this->k_sisa_hutang->CurrentValue;

        // k_id
        $this->k_id->HrefValue = "";
        $this->k_id->TooltipValue = "";

        // k_id_kontrak
        $this->k_id_kontrak->HrefValue = "";
        $this->k_id_kontrak->TooltipValue = "";

        // k_id_lama
        $this->k_id_lama->HrefValue = "";
        $this->k_id_lama->TooltipValue = "";

        // k_no_kontrak
        $this->k_no_kontrak->HrefValue = "";
        $this->k_no_kontrak->TooltipValue = "";

        // k_luas_lahan
        $this->k_luas_lahan->HrefValue = "";
        $this->k_luas_lahan->TooltipValue = "";

        // pet_id
        if (!EmptyValue($this->pet_id->CurrentValue)) {
            $this->pet_id->HrefValue = $this->pet_id->getLinkPrefix() . $this->pet_id->CurrentValue; // Add prefix/suffix
            $this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->pet_id->HrefValue = FullUrl($this->pet_id->HrefValue, "href");
            }
        } else {
            $this->pet_id->HrefValue = "";
        }
        $this->pet_id->TooltipValue = "";

        // koord_id
        if (!EmptyValue($this->koord_id->CurrentValue)) {
            $this->koord_id->HrefValue = $this->koord_id->getLinkPrefix() . $this->koord_id->CurrentValue; // Add prefix/suffix
            $this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->koord_id->HrefValue = FullUrl($this->koord_id->HrefValue, "href");
            }
        } else {
            $this->koord_id->HrefValue = "";
        }
        $this->koord_id->TooltipValue = "";

        // kk_id
        if (!EmptyValue($this->kk_id->CurrentValue)) {
            $this->kk_id->HrefValue = $this->kk_id->getLinkPrefix() . $this->kk_id->CurrentValue; // Add prefix/suffix
            $this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->kk_id->HrefValue = FullUrl($this->kk_id->HrefValue, "href");
            }
        } else {
            $this->kk_id->HrefValue = "";
        }
        $this->kk_id->TooltipValue = "";

        // prov_id
        $this->prov_id->HrefValue = "";
        $this->prov_id->TooltipValue = "";

        // kab_id
        $this->kab_id->HrefValue = "";
        $this->kab_id->TooltipValue = "";

        // kec_id
        $this->kec_id->HrefValue = "";
        $this->kec_id->TooltipValue = "";

        // desa_id
        $this->desa_id->HrefValue = "";
        $this->desa_id->TooltipValue = "";

        // blok_id
        $this->blok_id->HrefValue = "";
        $this->blok_id->TooltipValue = "";

        // sos_id
        $this->sos_id->HrefValue = "";
        $this->sos_id->TooltipValue = "";

        // var_id
        if (!EmptyValue($this->var_id->CurrentValue)) {
            $this->var_id->HrefValue = $this->var_id->getLinkPrefix() . $this->var_id->CurrentValue; // Add prefix/suffix
            $this->var_id->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->var_id->HrefValue = FullUrl($this->var_id->HrefValue, "href");
            }
        } else {
            $this->var_id->HrefValue = "";
        }
        $this->var_id->TooltipValue = "";

        // co_id
        if (!EmptyValue($this->co_id->CurrentValue)) {
            $this->co_id->HrefValue = $this->co_id->getLinkPrefix() . $this->co_id->CurrentValue; // Add prefix/suffix
            $this->co_id->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->co_id->HrefValue = FullUrl($this->co_id->HrefValue, "href");
            }
        } else {
            $this->co_id->HrefValue = "";
        }
        $this->co_id->TooltipValue = "";

        // k_jumlah_bibit
        $this->k_jumlah_bibit->HrefValue = "";
        $this->k_jumlah_bibit->TooltipValue = "";

        // k_asal_bibit
        $this->k_asal_bibit->HrefValue = "";
        $this->k_asal_bibit->TooltipValue = "";

        // k_tgl_tanam
        $this->k_tgl_tanam->HrefValue = "";
        $this->k_tgl_tanam->TooltipValue = "";

        // k_es_tgl_panen
        $this->k_es_tgl_panen->HrefValue = "";
        $this->k_es_tgl_panen->TooltipValue = "";

        // k_ak_tgl_datang
        $this->k_ak_tgl_datang->HrefValue = "";
        $this->k_ak_tgl_datang->TooltipValue = "";

        // k_es_qty
        $this->k_es_qty->HrefValue = "";
        $this->k_es_qty->TooltipValue = "";

        // k_ak_qty
        $this->k_ak_qty->HrefValue = "";
        $this->k_ak_qty->TooltipValue = "";

        // k_es_perhektar
        $this->k_es_perhektar->HrefValue = "";
        $this->k_es_perhektar->TooltipValue = "";

        // k_ak_perhektar
        $this->k_ak_perhektar->HrefValue = "";
        $this->k_ak_perhektar->TooltipValue = "";

        // k_skor
        $this->k_skor->HrefValue = "";
        $this->k_skor->TooltipValue = "";

        // k_ket
        $this->k_ket->HrefValue = "";
        $this->k_ket->TooltipValue = "";

        // k_cat
        $this->k_cat->HrefValue = "";
        $this->k_cat->TooltipValue = "";

        // k_titik_koordinat
        if (!EmptyValue($this->k_titik_koordinat->CurrentValue)) {
            $this->k_titik_koordinat->HrefValue = (!empty($this->k_titik_koordinat->ViewValue) && !is_array($this->k_titik_koordinat->ViewValue) ? RemoveHtml($this->k_titik_koordinat->ViewValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
            $this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->k_titik_koordinat->HrefValue = FullUrl($this->k_titik_koordinat->HrefValue, "href");
            }
        } else {
            $this->k_titik_koordinat->HrefValue = "";
        }
        $this->k_titik_koordinat->TooltipValue = "";

        // k_foto_lahan
        $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
        if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
            $this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
            $this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->k_foto_lahan->HrefValue = FullUrl($this->k_foto_lahan->HrefValue, "href");
            }
        } else {
            $this->k_foto_lahan->HrefValue = "";
        }
        $this->k_foto_lahan->ExportHrefValue = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;
        $this->k_foto_lahan->TooltipValue = "";
        if ($this->k_foto_lahan->UseColorbox) {
            if (EmptyValue($this->k_foto_lahan->TooltipValue)) {
                $this->k_foto_lahan->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->k_foto_lahan->LinkAttrs["data-rel"] = "kontrak_x_k_foto_lahan";
            $this->k_foto_lahan->LinkAttrs->appendClass("ew-lightbox");
        }

        // k_dok
        $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
        if (!EmptyValue($this->k_dok->Upload->DbValue)) {
            $this->k_dok->HrefValue = "%u"; // Add prefix/suffix
            $this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->k_dok->HrefValue = FullUrl($this->k_dok->HrefValue, "href");
            }
        } else {
            $this->k_dok->HrefValue = "";
        }
        $this->k_dok->ExportHrefValue = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;
        $this->k_dok->TooltipValue = "";
        if ($this->k_dok->UseColorbox) {
            if (EmptyValue($this->k_dok->TooltipValue)) {
                $this->k_dok->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->k_dok->LinkAttrs["data-rel"] = "kontrak_x_k_dok";
            $this->k_dok->LinkAttrs->appendClass("ew-lightbox");
        }

        // k_harga_bibit
        $this->k_harga_bibit->HrefValue = "";
        $this->k_harga_bibit->TooltipValue = "";

        // k_bayar_bibit
        $this->k_bayar_bibit->HrefValue = "";
        $this->k_bayar_bibit->TooltipValue = "";

        // k_pinjaman
        $this->k_pinjaman->HrefValue = "";
        $this->k_pinjaman->TooltipValue = "";

        // k_bayar_pinjaman
        $this->k_bayar_pinjaman->HrefValue = "";
        $this->k_bayar_pinjaman->TooltipValue = "";

        // k_sisa_hutang
        $this->k_sisa_hutang->HrefValue = "";
        $this->k_sisa_hutang->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // k_id
        $this->k_id->setupEditAttributes();
        $this->k_id->EditValue = $this->k_id->CurrentValue;

        // k_id_kontrak
        $this->k_id_kontrak->setupEditAttributes();
        if (!$this->k_id_kontrak->Raw) {
            $this->k_id_kontrak->CurrentValue = HtmlDecode($this->k_id_kontrak->CurrentValue);
        }
        $this->k_id_kontrak->EditValue = $this->k_id_kontrak->CurrentValue;
        $this->k_id_kontrak->PlaceHolder = RemoveHtml($this->k_id_kontrak->caption());

        // k_id_lama
        $this->k_id_lama->setupEditAttributes();
        if (!$this->k_id_lama->Raw) {
            $this->k_id_lama->CurrentValue = HtmlDecode($this->k_id_lama->CurrentValue);
        }
        $this->k_id_lama->EditValue = $this->k_id_lama->CurrentValue;
        $this->k_id_lama->PlaceHolder = RemoveHtml($this->k_id_lama->caption());

        // k_no_kontrak
        $this->k_no_kontrak->setupEditAttributes();
        if (!$this->k_no_kontrak->Raw) {
            $this->k_no_kontrak->CurrentValue = HtmlDecode($this->k_no_kontrak->CurrentValue);
        }
        $this->k_no_kontrak->EditValue = $this->k_no_kontrak->CurrentValue;
        $this->k_no_kontrak->PlaceHolder = RemoveHtml($this->k_no_kontrak->caption());

        // k_luas_lahan
        $this->k_luas_lahan->setupEditAttributes();
        $this->k_luas_lahan->EditValue = $this->k_luas_lahan->CurrentValue;
        $this->k_luas_lahan->PlaceHolder = RemoveHtml($this->k_luas_lahan->caption());
        if (strval($this->k_luas_lahan->EditValue) != "" && is_numeric($this->k_luas_lahan->EditValue)) {
            $this->k_luas_lahan->EditValue = $this->k_luas_lahan->EditValue;
        }

        // pet_id
        $this->pet_id->setupEditAttributes();
        $this->pet_id->EditValue = $this->pet_id->CurrentValue;
        $this->pet_id->PlaceHolder = RemoveHtml($this->pet_id->caption());

        // koord_id
        $this->koord_id->setupEditAttributes();
        $this->koord_id->EditValue = $this->koord_id->CurrentValue;
        $this->koord_id->PlaceHolder = RemoveHtml($this->koord_id->caption());

        // kk_id
        $this->kk_id->setupEditAttributes();
        $this->kk_id->PlaceHolder = RemoveHtml($this->kk_id->caption());

        // prov_id
        $this->prov_id->setupEditAttributes();
        $this->prov_id->PlaceHolder = RemoveHtml($this->prov_id->caption());

        // kab_id
        $this->kab_id->setupEditAttributes();
        $this->kab_id->PlaceHolder = RemoveHtml($this->kab_id->caption());

        // kec_id
        $this->kec_id->setupEditAttributes();
        $this->kec_id->PlaceHolder = RemoveHtml($this->kec_id->caption());

        // desa_id
        $this->desa_id->setupEditAttributes();
        $this->desa_id->PlaceHolder = RemoveHtml($this->desa_id->caption());

        // blok_id
        $this->blok_id->setupEditAttributes();
        if ($this->blok_id->VirtualValue != "") {
            $this->blok_id->EditValue = $this->blok_id->VirtualValue;
        } else {
            $this->blok_id->EditValue = $this->blok_id->CurrentValue;
            $curVal = strval($this->blok_id->CurrentValue);
            if ($curVal != "") {
                $this->blok_id->EditValue = $this->blok_id->lookupCacheOption($curVal);
                if ($this->blok_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`blok_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->blok_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->blok_id->Lookup->renderViewRow($rswrk[0]);
                        $this->blok_id->EditValue = $this->blok_id->displayValue($arwrk);
                    } else {
                        $this->blok_id->EditValue = $this->blok_id->CurrentValue;
                    }
                }
            } else {
                $this->blok_id->EditValue = null;
            }
        }

        // sos_id
        $this->sos_id->setupEditAttributes();
        $this->sos_id->PlaceHolder = RemoveHtml($this->sos_id->caption());

        // var_id
        $this->var_id->setupEditAttributes();
        $this->var_id->PlaceHolder = RemoveHtml($this->var_id->caption());

        // co_id
        $this->co_id->setupEditAttributes();
        $this->co_id->PlaceHolder = RemoveHtml($this->co_id->caption());

        // k_jumlah_bibit
        $this->k_jumlah_bibit->setupEditAttributes();
        $this->k_jumlah_bibit->EditValue = $this->k_jumlah_bibit->CurrentValue;
        $this->k_jumlah_bibit->PlaceHolder = RemoveHtml($this->k_jumlah_bibit->caption());
        if (strval($this->k_jumlah_bibit->EditValue) != "" && is_numeric($this->k_jumlah_bibit->EditValue)) {
            $this->k_jumlah_bibit->EditValue = $this->k_jumlah_bibit->EditValue;
        }

        // k_asal_bibit
        $this->k_asal_bibit->setupEditAttributes();
        if (!$this->k_asal_bibit->Raw) {
            $this->k_asal_bibit->CurrentValue = HtmlDecode($this->k_asal_bibit->CurrentValue);
        }
        $this->k_asal_bibit->EditValue = $this->k_asal_bibit->CurrentValue;
        $this->k_asal_bibit->PlaceHolder = RemoveHtml($this->k_asal_bibit->caption());

        // k_tgl_tanam
        $this->k_tgl_tanam->setupEditAttributes();
        $this->k_tgl_tanam->EditValue = FormatDateTime($this->k_tgl_tanam->CurrentValue, $this->k_tgl_tanam->formatPattern());
        $this->k_tgl_tanam->PlaceHolder = RemoveHtml($this->k_tgl_tanam->caption());

        // k_es_tgl_panen
        $this->k_es_tgl_panen->setupEditAttributes();
        $this->k_es_tgl_panen->EditValue = FormatDateTime($this->k_es_tgl_panen->CurrentValue, $this->k_es_tgl_panen->formatPattern());
        $this->k_es_tgl_panen->PlaceHolder = RemoveHtml($this->k_es_tgl_panen->caption());

        // k_ak_tgl_datang
        $this->k_ak_tgl_datang->setupEditAttributes();
        $this->k_ak_tgl_datang->EditValue = FormatDateTime($this->k_ak_tgl_datang->CurrentValue, $this->k_ak_tgl_datang->formatPattern());
        $this->k_ak_tgl_datang->PlaceHolder = RemoveHtml($this->k_ak_tgl_datang->caption());

        // k_es_qty
        $this->k_es_qty->setupEditAttributes();
        $this->k_es_qty->EditValue = $this->k_es_qty->CurrentValue;
        $this->k_es_qty->PlaceHolder = RemoveHtml($this->k_es_qty->caption());
        if (strval($this->k_es_qty->EditValue) != "" && is_numeric($this->k_es_qty->EditValue)) {
            $this->k_es_qty->EditValue = $this->k_es_qty->EditValue;
        }

        // k_ak_qty
        $this->k_ak_qty->setupEditAttributes();
        $this->k_ak_qty->EditValue = $this->k_ak_qty->CurrentValue;
        $this->k_ak_qty->PlaceHolder = RemoveHtml($this->k_ak_qty->caption());
        if (strval($this->k_ak_qty->EditValue) != "" && is_numeric($this->k_ak_qty->EditValue)) {
            $this->k_ak_qty->EditValue = $this->k_ak_qty->EditValue;
        }

        // k_es_perhektar
        $this->k_es_perhektar->setupEditAttributes();
        $this->k_es_perhektar->EditValue = $this->k_es_perhektar->CurrentValue;
        $this->k_es_perhektar->PlaceHolder = RemoveHtml($this->k_es_perhektar->caption());
        if (strval($this->k_es_perhektar->EditValue) != "" && is_numeric($this->k_es_perhektar->EditValue)) {
            $this->k_es_perhektar->EditValue = $this->k_es_perhektar->EditValue;
        }

        // k_ak_perhektar
        $this->k_ak_perhektar->setupEditAttributes();
        $this->k_ak_perhektar->EditValue = $this->k_ak_perhektar->CurrentValue;
        $this->k_ak_perhektar->PlaceHolder = RemoveHtml($this->k_ak_perhektar->caption());
        if (strval($this->k_ak_perhektar->EditValue) != "" && is_numeric($this->k_ak_perhektar->EditValue)) {
            $this->k_ak_perhektar->EditValue = FormatNumber($this->k_ak_perhektar->EditValue, null);
        }

        // k_skor
        $this->k_skor->setupEditAttributes();
        $this->k_skor->EditValue = $this->k_skor->CurrentValue;
        $this->k_skor->PlaceHolder = RemoveHtml($this->k_skor->caption());
        if (strval($this->k_skor->EditValue) != "" && is_numeric($this->k_skor->EditValue)) {
            $this->k_skor->EditValue = FormatNumber($this->k_skor->EditValue, null);
        }

        // k_ket
        $this->k_ket->setupEditAttributes();
        $this->k_ket->EditValue = $this->k_ket->CurrentValue;
        $this->k_ket->PlaceHolder = RemoveHtml($this->k_ket->caption());

        // k_cat
        $this->k_cat->setupEditAttributes();
        $this->k_cat->EditValue = $this->k_cat->CurrentValue;
        $this->k_cat->PlaceHolder = RemoveHtml($this->k_cat->caption());

        // k_titik_koordinat
        $this->k_titik_koordinat->setupEditAttributes();
        if (!$this->k_titik_koordinat->Raw) {
            $this->k_titik_koordinat->CurrentValue = HtmlDecode($this->k_titik_koordinat->CurrentValue);
        }
        $this->k_titik_koordinat->EditValue = $this->k_titik_koordinat->CurrentValue;
        $this->k_titik_koordinat->PlaceHolder = RemoveHtml($this->k_titik_koordinat->caption());

        // k_foto_lahan
        $this->k_foto_lahan->setupEditAttributes();
        $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
        if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
            $this->k_foto_lahan->ImageWidth = 40;
            $this->k_foto_lahan->ImageHeight = 30;
            $this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->alt();
            $this->k_foto_lahan->ImageCssClass = "ew-image";
            $this->k_foto_lahan->EditValue = $this->k_foto_lahan->Upload->DbValue;
        } else {
            $this->k_foto_lahan->EditValue = "";
        }
        if (!EmptyValue($this->k_foto_lahan->CurrentValue)) {
            $this->k_foto_lahan->Upload->FileName = $this->k_foto_lahan->CurrentValue;
        }

        // k_dok
        $this->k_dok->setupEditAttributes();
        $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
        if (!EmptyValue($this->k_dok->Upload->DbValue)) {
            $this->k_dok->ImageWidth = 42;
            $this->k_dok->ImageHeight = 70;
            $this->k_dok->ImageAlt = $this->k_dok->alt();
            $this->k_dok->ImageCssClass = "ew-image";
            $this->k_dok->EditValue = $this->k_dok->Upload->DbValue;
        } else {
            $this->k_dok->EditValue = "";
        }
        if (!EmptyValue($this->k_dok->CurrentValue)) {
            $this->k_dok->Upload->FileName = $this->k_dok->CurrentValue;
        }

        // k_harga_bibit
        $this->k_harga_bibit->setupEditAttributes();
        $this->k_harga_bibit->EditValue = $this->k_harga_bibit->CurrentValue;
        $this->k_harga_bibit->PlaceHolder = RemoveHtml($this->k_harga_bibit->caption());
        if (strval($this->k_harga_bibit->EditValue) != "" && is_numeric($this->k_harga_bibit->EditValue)) {
            $this->k_harga_bibit->EditValue = $this->k_harga_bibit->EditValue;
        }

        // k_bayar_bibit
        $this->k_bayar_bibit->setupEditAttributes();
        $this->k_bayar_bibit->EditValue = $this->k_bayar_bibit->CurrentValue;
        $this->k_bayar_bibit->PlaceHolder = RemoveHtml($this->k_bayar_bibit->caption());
        if (strval($this->k_bayar_bibit->EditValue) != "" && is_numeric($this->k_bayar_bibit->EditValue)) {
            $this->k_bayar_bibit->EditValue = $this->k_bayar_bibit->EditValue;
        }

        // k_pinjaman
        $this->k_pinjaman->setupEditAttributes();
        $this->k_pinjaman->EditValue = $this->k_pinjaman->CurrentValue;
        $this->k_pinjaman->PlaceHolder = RemoveHtml($this->k_pinjaman->caption());
        if (strval($this->k_pinjaman->EditValue) != "" && is_numeric($this->k_pinjaman->EditValue)) {
            $this->k_pinjaman->EditValue = $this->k_pinjaman->EditValue;
        }

        // k_bayar_pinjaman
        $this->k_bayar_pinjaman->setupEditAttributes();
        $this->k_bayar_pinjaman->EditValue = $this->k_bayar_pinjaman->CurrentValue;
        $this->k_bayar_pinjaman->PlaceHolder = RemoveHtml($this->k_bayar_pinjaman->caption());
        if (strval($this->k_bayar_pinjaman->EditValue) != "" && is_numeric($this->k_bayar_pinjaman->EditValue)) {
            $this->k_bayar_pinjaman->EditValue = $this->k_bayar_pinjaman->EditValue;
        }

        // k_sisa_hutang
        $this->k_sisa_hutang->setupEditAttributes();
        $this->k_sisa_hutang->EditValue = $this->k_sisa_hutang->CurrentValue;
        $this->k_sisa_hutang->PlaceHolder = RemoveHtml($this->k_sisa_hutang->caption());
        if (strval($this->k_sisa_hutang->EditValue) != "" && is_numeric($this->k_sisa_hutang->EditValue)) {
            $this->k_sisa_hutang->EditValue = $this->k_sisa_hutang->EditValue;
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->k_luas_lahan->CurrentValue)) {
                $this->k_luas_lahan->Total += $this->k_luas_lahan->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->k_luas_lahan->CurrentValue = $this->k_luas_lahan->Total;
            $this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
            $this->k_luas_lahan->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->k_id_kontrak);
                    $doc->exportCaption($this->k_luas_lahan);
                    $doc->exportCaption($this->pet_id);
                    $doc->exportCaption($this->koord_id);
                    $doc->exportCaption($this->kk_id);
                    $doc->exportCaption($this->prov_id);
                    $doc->exportCaption($this->kab_id);
                    $doc->exportCaption($this->kec_id);
                    $doc->exportCaption($this->desa_id);
                    $doc->exportCaption($this->blok_id);
                    $doc->exportCaption($this->sos_id);
                    $doc->exportCaption($this->var_id);
                    $doc->exportCaption($this->co_id);
                    $doc->exportCaption($this->k_jumlah_bibit);
                    $doc->exportCaption($this->k_asal_bibit);
                    $doc->exportCaption($this->k_tgl_tanam);
                    $doc->exportCaption($this->k_es_tgl_panen);
                    $doc->exportCaption($this->k_ak_tgl_datang);
                    $doc->exportCaption($this->k_es_qty);
                    $doc->exportCaption($this->k_ak_qty);
                    $doc->exportCaption($this->k_es_perhektar);
                    $doc->exportCaption($this->k_ak_perhektar);
                    $doc->exportCaption($this->k_skor);
                    $doc->exportCaption($this->k_ket);
                    $doc->exportCaption($this->k_cat);
                    $doc->exportCaption($this->k_titik_koordinat);
                    $doc->exportCaption($this->k_foto_lahan);
                    $doc->exportCaption($this->k_dok);
                    $doc->exportCaption($this->k_harga_bibit);
                    $doc->exportCaption($this->k_bayar_bibit);
                    $doc->exportCaption($this->k_pinjaman);
                    $doc->exportCaption($this->k_bayar_pinjaman);
                    $doc->exportCaption($this->k_sisa_hutang);
                } else {
                    $doc->exportCaption($this->k_id);
                    $doc->exportCaption($this->k_id_kontrak);
                    $doc->exportCaption($this->k_luas_lahan);
                    $doc->exportCaption($this->pet_id);
                    $doc->exportCaption($this->koord_id);
                    $doc->exportCaption($this->kk_id);
                    $doc->exportCaption($this->prov_id);
                    $doc->exportCaption($this->kab_id);
                    $doc->exportCaption($this->kec_id);
                    $doc->exportCaption($this->desa_id);
                    $doc->exportCaption($this->blok_id);
                    $doc->exportCaption($this->sos_id);
                    $doc->exportCaption($this->var_id);
                    $doc->exportCaption($this->co_id);
                    $doc->exportCaption($this->k_jumlah_bibit);
                    $doc->exportCaption($this->k_asal_bibit);
                    $doc->exportCaption($this->k_tgl_tanam);
                    $doc->exportCaption($this->k_es_tgl_panen);
                    $doc->exportCaption($this->k_ak_tgl_datang);
                    $doc->exportCaption($this->k_es_qty);
                    $doc->exportCaption($this->k_ak_qty);
                    $doc->exportCaption($this->k_es_perhektar);
                    $doc->exportCaption($this->k_ak_perhektar);
                    $doc->exportCaption($this->k_skor);
                    $doc->exportCaption($this->k_ket);
                    $doc->exportCaption($this->k_cat);
                    $doc->exportCaption($this->k_titik_koordinat);
                    $doc->exportCaption($this->k_foto_lahan);
                    $doc->exportCaption($this->k_dok);
                    $doc->exportCaption($this->k_harga_bibit);
                    $doc->exportCaption($this->k_bayar_bibit);
                    $doc->exportCaption($this->k_pinjaman);
                    $doc->exportCaption($this->k_bayar_pinjaman);
                    $doc->exportCaption($this->k_sisa_hutang);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->k_id_kontrak);
                        $doc->exportField($this->k_luas_lahan);
                        $doc->exportField($this->pet_id);
                        $doc->exportField($this->koord_id);
                        $doc->exportField($this->kk_id);
                        $doc->exportField($this->prov_id);
                        $doc->exportField($this->kab_id);
                        $doc->exportField($this->kec_id);
                        $doc->exportField($this->desa_id);
                        $doc->exportField($this->blok_id);
                        $doc->exportField($this->sos_id);
                        $doc->exportField($this->var_id);
                        $doc->exportField($this->co_id);
                        $doc->exportField($this->k_jumlah_bibit);
                        $doc->exportField($this->k_asal_bibit);
                        $doc->exportField($this->k_tgl_tanam);
                        $doc->exportField($this->k_es_tgl_panen);
                        $doc->exportField($this->k_ak_tgl_datang);
                        $doc->exportField($this->k_es_qty);
                        $doc->exportField($this->k_ak_qty);
                        $doc->exportField($this->k_es_perhektar);
                        $doc->exportField($this->k_ak_perhektar);
                        $doc->exportField($this->k_skor);
                        $doc->exportField($this->k_ket);
                        $doc->exportField($this->k_cat);
                        $doc->exportField($this->k_titik_koordinat);
                        $doc->exportField($this->k_foto_lahan);
                        $doc->exportField($this->k_dok);
                        $doc->exportField($this->k_harga_bibit);
                        $doc->exportField($this->k_bayar_bibit);
                        $doc->exportField($this->k_pinjaman);
                        $doc->exportField($this->k_bayar_pinjaman);
                        $doc->exportField($this->k_sisa_hutang);
                    } else {
                        $doc->exportField($this->k_id);
                        $doc->exportField($this->k_id_kontrak);
                        $doc->exportField($this->k_luas_lahan);
                        $doc->exportField($this->pet_id);
                        $doc->exportField($this->koord_id);
                        $doc->exportField($this->kk_id);
                        $doc->exportField($this->prov_id);
                        $doc->exportField($this->kab_id);
                        $doc->exportField($this->kec_id);
                        $doc->exportField($this->desa_id);
                        $doc->exportField($this->blok_id);
                        $doc->exportField($this->sos_id);
                        $doc->exportField($this->var_id);
                        $doc->exportField($this->co_id);
                        $doc->exportField($this->k_jumlah_bibit);
                        $doc->exportField($this->k_asal_bibit);
                        $doc->exportField($this->k_tgl_tanam);
                        $doc->exportField($this->k_es_tgl_panen);
                        $doc->exportField($this->k_ak_tgl_datang);
                        $doc->exportField($this->k_es_qty);
                        $doc->exportField($this->k_ak_qty);
                        $doc->exportField($this->k_es_perhektar);
                        $doc->exportField($this->k_ak_perhektar);
                        $doc->exportField($this->k_skor);
                        $doc->exportField($this->k_ket);
                        $doc->exportField($this->k_cat);
                        $doc->exportField($this->k_titik_koordinat);
                        $doc->exportField($this->k_foto_lahan);
                        $doc->exportField($this->k_dok);
                        $doc->exportField($this->k_harga_bibit);
                        $doc->exportField($this->k_bayar_bibit);
                        $doc->exportField($this->k_pinjaman);
                        $doc->exportField($this->k_bayar_pinjaman);
                        $doc->exportField($this->k_sisa_hutang);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = ROWTYPE_AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->k_id, '');
                $doc->exportAggregate($this->k_id_kontrak, '');
                $doc->exportAggregate($this->k_luas_lahan, 'TOTAL');
                $doc->exportAggregate($this->pet_id, '');
                $doc->exportAggregate($this->koord_id, '');
                $doc->exportAggregate($this->kk_id, '');
                $doc->exportAggregate($this->prov_id, '');
                $doc->exportAggregate($this->kab_id, '');
                $doc->exportAggregate($this->kec_id, '');
                $doc->exportAggregate($this->desa_id, '');
                $doc->exportAggregate($this->blok_id, '');
                $doc->exportAggregate($this->sos_id, '');
                $doc->exportAggregate($this->var_id, '');
                $doc->exportAggregate($this->co_id, '');
                $doc->exportAggregate($this->k_jumlah_bibit, '');
                $doc->exportAggregate($this->k_asal_bibit, '');
                $doc->exportAggregate($this->k_tgl_tanam, '');
                $doc->exportAggregate($this->k_es_tgl_panen, '');
                $doc->exportAggregate($this->k_ak_tgl_datang, '');
                $doc->exportAggregate($this->k_es_qty, '');
                $doc->exportAggregate($this->k_ak_qty, '');
                $doc->exportAggregate($this->k_es_perhektar, '');
                $doc->exportAggregate($this->k_ak_perhektar, '');
                $doc->exportAggregate($this->k_skor, '');
                $doc->exportAggregate($this->k_ket, '');
                $doc->exportAggregate($this->k_cat, '');
                $doc->exportAggregate($this->k_titik_koordinat, '');
                $doc->exportAggregate($this->k_foto_lahan, '');
                $doc->exportAggregate($this->k_dok, '');
                $doc->exportAggregate($this->k_harga_bibit, '');
                $doc->exportAggregate($this->k_bayar_bibit, '');
                $doc->exportAggregate($this->k_pinjaman, '');
                $doc->exportAggregate($this->k_bayar_pinjaman, '');
                $doc->exportAggregate($this->k_sisa_hutang, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'k_foto_lahan') {
            $fldName = "k_foto_lahan";
            $fileNameFld = "k_foto_lahan";
        } elseif ($fldparm == 'k_dok') {
            $fldName = "k_dok";
            $fileNameFld = "k_dok";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->k_id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DATATYPE_BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
