<?php

namespace PHPMaker2023\co;

// Page object
$KontrakKoordList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { kontrak_koord: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fkontrak_koordsrch" id="fkontrak_koordsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="on">
<div id="fkontrak_koordsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { kontrak_koord: currentTable } });
var currentForm;
var fkontrak_koordsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fkontrak_koordsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["kk_id", [], fields.kk_id.isInvalid],
            ["kk_no_kontrak", [], fields.kk_no_kontrak.isInvalid],
            ["koord_id", [], fields.koord_id.isInvalid],
            ["kk_tgl_mulai", [ew.Validators.datetime(fields.kk_tgl_mulai.clientFormatPattern)], fields.kk_tgl_mulai.isInvalid],
            ["y_kk_tgl_mulai", [ew.Validators.between], false],
            ["kk_tgl_akhir", [ew.Validators.datetime(fields.kk_tgl_akhir.clientFormatPattern)], fields.kk_tgl_akhir.isInvalid],
            ["y_kk_tgl_akhir", [ew.Validators.between], false],
            ["kk_periode", [], fields.kk_periode.isInvalid],
            ["var_id", [], fields.var_id.isInvalid],
            ["kk_harga", [], fields.kk_harga.isInvalid],
            ["kk_luas", [], fields.kk_luas.isInvalid],
            ["kk_dok", [], fields.kk_dok.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "koord_id": <?= $Page->koord_id->toClientList($Page) ?>,
            "var_id": <?= $Page->var_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->koord_id->Visible) { // koord_id ?>
<?php
if (!$Page->koord_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_koord_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->koord_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_koord_id" class="ew-search-caption ew-label"><?= $Page->koord_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_koord_id" id="z_koord_id" value="=">
</div>
        </div>
        <div id="el_kontrak_koord_koord_id" class="ew-search-field">
    <select
        id="x_koord_id"
        name="x_koord_id"
        class="form-select ew-select<?= $Page->koord_id->isInvalidClass() ?>"
        <?php if (!$Page->koord_id->IsNativeSelect) { ?>
        data-select2-id="fkontrak_koordsrch_x_koord_id"
        <?php } ?>
        data-table="kontrak_koord"
        data-field="x_koord_id"
        data-value-separator="<?= $Page->koord_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->koord_id->getPlaceHolder()) ?>"
        <?= $Page->koord_id->editAttributes() ?>>
        <?= $Page->koord_id->selectOptionListHtml("x_koord_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->koord_id->getErrorMessage(false) ?></div>
<?= $Page->koord_id->Lookup->getParamTag($Page, "p_x_koord_id") ?>
<?php if (!$Page->koord_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fkontrak_koordsrch", function() {
    var options = { name: "x_koord_id", selectId: "fkontrak_koordsrch_x_koord_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fkontrak_koordsrch.lists.koord_id?.lookupOptions.length) {
        options.data = { id: "x_koord_id", form: "fkontrak_koordsrch" };
    } else {
        options.ajax = { id: "x_koord_id", form: "fkontrak_koordsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.kontrak_koord.fields.koord_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->kk_tgl_mulai->Visible) { // kk_tgl_mulai ?>
<?php
if (!$Page->kk_tgl_mulai->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_kk_tgl_mulai" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->kk_tgl_mulai->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_kk_tgl_mulai" class="ew-search-caption ew-label"><?= $Page->kk_tgl_mulai->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_kk_tgl_mulai" id="z_kk_tgl_mulai" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->kk_tgl_mulai->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->kk_tgl_mulai->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_kontrak_koord_kk_tgl_mulai" class="ew-search-field">
<input type="<?= $Page->kk_tgl_mulai->getInputTextType() ?>" name="x_kk_tgl_mulai" id="x_kk_tgl_mulai" data-table="kontrak_koord" data-field="x_kk_tgl_mulai" value="<?= $Page->kk_tgl_mulai->EditValue ?>" placeholder="<?= HtmlEncode($Page->kk_tgl_mulai->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->kk_tgl_mulai->formatPattern()) ?>"<?= $Page->kk_tgl_mulai->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->kk_tgl_mulai->getErrorMessage(false) ?></div>
<?php if (!$Page->kk_tgl_mulai->ReadOnly && !$Page->kk_tgl_mulai->Disabled && !isset($Page->kk_tgl_mulai->EditAttrs["readonly"]) && !isset($Page->kk_tgl_mulai->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontrak_koordsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontrak_koordsrch", "x_kk_tgl_mulai", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_kontrak_koord_kk_tgl_mulai" class="ew-search-field2 d-none">
<input type="<?= $Page->kk_tgl_mulai->getInputTextType() ?>" name="y_kk_tgl_mulai" id="y_kk_tgl_mulai" data-table="kontrak_koord" data-field="x_kk_tgl_mulai" value="<?= $Page->kk_tgl_mulai->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->kk_tgl_mulai->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->kk_tgl_mulai->formatPattern()) ?>"<?= $Page->kk_tgl_mulai->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->kk_tgl_mulai->getErrorMessage(false) ?></div>
<?php if (!$Page->kk_tgl_mulai->ReadOnly && !$Page->kk_tgl_mulai->Disabled && !isset($Page->kk_tgl_mulai->EditAttrs["readonly"]) && !isset($Page->kk_tgl_mulai->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontrak_koordsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontrak_koordsrch", "y_kk_tgl_mulai", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->kk_tgl_akhir->Visible) { // kk_tgl_akhir ?>
<?php
if (!$Page->kk_tgl_akhir->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_kk_tgl_akhir" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->kk_tgl_akhir->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_kk_tgl_akhir" class="ew-search-caption ew-label"><?= $Page->kk_tgl_akhir->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_kk_tgl_akhir" id="z_kk_tgl_akhir" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->kk_tgl_akhir->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->kk_tgl_akhir->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_kontrak_koord_kk_tgl_akhir" class="ew-search-field">
<input type="<?= $Page->kk_tgl_akhir->getInputTextType() ?>" name="x_kk_tgl_akhir" id="x_kk_tgl_akhir" data-table="kontrak_koord" data-field="x_kk_tgl_akhir" value="<?= $Page->kk_tgl_akhir->EditValue ?>" placeholder="<?= HtmlEncode($Page->kk_tgl_akhir->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->kk_tgl_akhir->formatPattern()) ?>"<?= $Page->kk_tgl_akhir->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->kk_tgl_akhir->getErrorMessage(false) ?></div>
<?php if (!$Page->kk_tgl_akhir->ReadOnly && !$Page->kk_tgl_akhir->Disabled && !isset($Page->kk_tgl_akhir->EditAttrs["readonly"]) && !isset($Page->kk_tgl_akhir->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontrak_koordsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontrak_koordsrch", "x_kk_tgl_akhir", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_kontrak_koord_kk_tgl_akhir" class="ew-search-field2 d-none">
<input type="<?= $Page->kk_tgl_akhir->getInputTextType() ?>" name="y_kk_tgl_akhir" id="y_kk_tgl_akhir" data-table="kontrak_koord" data-field="x_kk_tgl_akhir" value="<?= $Page->kk_tgl_akhir->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->kk_tgl_akhir->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->kk_tgl_akhir->formatPattern()) ?>"<?= $Page->kk_tgl_akhir->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->kk_tgl_akhir->getErrorMessage(false) ?></div>
<?php if (!$Page->kk_tgl_akhir->ReadOnly && !$Page->kk_tgl_akhir->Disabled && !isset($Page->kk_tgl_akhir->EditAttrs["readonly"]) && !isset($Page->kk_tgl_akhir->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fkontrak_koordsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fkontrak_koordsrch", "y_kk_tgl_akhir", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->var_id->Visible) { // var_id ?>
<?php
if (!$Page->var_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_var_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->var_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_var_id" class="ew-search-caption ew-label"><?= $Page->var_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_var_id" id="z_var_id" value="=">
</div>
        </div>
        <div id="el_kontrak_koord_var_id" class="ew-search-field">
    <select
        id="x_var_id"
        name="x_var_id"
        class="form-select ew-select<?= $Page->var_id->isInvalidClass() ?>"
        <?php if (!$Page->var_id->IsNativeSelect) { ?>
        data-select2-id="fkontrak_koordsrch_x_var_id"
        <?php } ?>
        data-table="kontrak_koord"
        data-field="x_var_id"
        data-value-separator="<?= $Page->var_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->var_id->getPlaceHolder()) ?>"
        <?= $Page->var_id->editAttributes() ?>>
        <?= $Page->var_id->selectOptionListHtml("x_var_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->var_id->getErrorMessage(false) ?></div>
<?= $Page->var_id->Lookup->getParamTag($Page, "p_x_var_id") ?>
<?php if (!$Page->var_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fkontrak_koordsrch", function() {
    var options = { name: "x_var_id", selectId: "fkontrak_koordsrch_x_var_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fkontrak_koordsrch.lists.var_id?.lookupOptions.length) {
        options.data = { id: "x_var_id", form: "fkontrak_koordsrch" };
    } else {
        options.ajax = { id: "x_var_id", form: "fkontrak_koordsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.kontrak_koord.fields.var_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fkontrak_koordsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fkontrak_koordsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fkontrak_koordsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fkontrak_koordsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="on">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="kontrak_koord">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_kontrak_koord" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_kontrak_koordlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = ROWTYPE_HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->kk_id->Visible) { // kk_id ?>
        <th data-name="kk_id" class="<?= $Page->kk_id->headerCellClass() ?>"><div id="elh_kontrak_koord_kk_id" class="kontrak_koord_kk_id"><?= $Page->renderFieldHeader($Page->kk_id) ?></div></th>
<?php } ?>
<?php if ($Page->kk_no_kontrak->Visible) { // kk_no_kontrak ?>
        <th data-name="kk_no_kontrak" class="<?= $Page->kk_no_kontrak->headerCellClass() ?>"><div id="elh_kontrak_koord_kk_no_kontrak" class="kontrak_koord_kk_no_kontrak"><?= $Page->renderFieldHeader($Page->kk_no_kontrak) ?></div></th>
<?php } ?>
<?php if ($Page->koord_id->Visible) { // koord_id ?>
        <th data-name="koord_id" class="<?= $Page->koord_id->headerCellClass() ?>"><div id="elh_kontrak_koord_koord_id" class="kontrak_koord_koord_id"><?= $Page->renderFieldHeader($Page->koord_id) ?></div></th>
<?php } ?>
<?php if ($Page->kk_tgl_mulai->Visible) { // kk_tgl_mulai ?>
        <th data-name="kk_tgl_mulai" class="<?= $Page->kk_tgl_mulai->headerCellClass() ?>"><div id="elh_kontrak_koord_kk_tgl_mulai" class="kontrak_koord_kk_tgl_mulai"><?= $Page->renderFieldHeader($Page->kk_tgl_mulai) ?></div></th>
<?php } ?>
<?php if ($Page->kk_tgl_akhir->Visible) { // kk_tgl_akhir ?>
        <th data-name="kk_tgl_akhir" class="<?= $Page->kk_tgl_akhir->headerCellClass() ?>"><div id="elh_kontrak_koord_kk_tgl_akhir" class="kontrak_koord_kk_tgl_akhir"><?= $Page->renderFieldHeader($Page->kk_tgl_akhir) ?></div></th>
<?php } ?>
<?php if ($Page->kk_periode->Visible) { // kk_periode ?>
        <th data-name="kk_periode" class="<?= $Page->kk_periode->headerCellClass() ?>"><div id="elh_kontrak_koord_kk_periode" class="kontrak_koord_kk_periode"><?= $Page->renderFieldHeader($Page->kk_periode) ?></div></th>
<?php } ?>
<?php if ($Page->var_id->Visible) { // var_id ?>
        <th data-name="var_id" class="<?= $Page->var_id->headerCellClass() ?>"><div id="elh_kontrak_koord_var_id" class="kontrak_koord_var_id"><?= $Page->renderFieldHeader($Page->var_id) ?></div></th>
<?php } ?>
<?php if ($Page->kk_harga->Visible) { // kk_harga ?>
        <th data-name="kk_harga" class="<?= $Page->kk_harga->headerCellClass() ?>"><div id="elh_kontrak_koord_kk_harga" class="kontrak_koord_kk_harga"><?= $Page->renderFieldHeader($Page->kk_harga) ?></div></th>
<?php } ?>
<?php if ($Page->kk_luas->Visible) { // kk_luas ?>
        <th data-name="kk_luas" class="<?= $Page->kk_luas->headerCellClass() ?>"><div id="elh_kontrak_koord_kk_luas" class="kontrak_koord_kk_luas"><?= $Page->renderFieldHeader($Page->kk_luas) ?></div></th>
<?php } ?>
<?php if ($Page->kk_dok->Visible) { // kk_dok ?>
        <th data-name="kk_dok" class="<?= $Page->kk_dok->headerCellClass() ?>"><div id="elh_kontrak_koord_kk_dok" class="kontrak_koord_kk_dok"><?= $Page->renderFieldHeader($Page->kk_dok) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->kk_id->Visible) { // kk_id ?>
        <td data-name="kk_id"<?= $Page->kk_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_kk_id" class="el_kontrak_koord_kk_id">
<span<?= $Page->kk_id->viewAttributes() ?>>
<?= $Page->kk_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kk_no_kontrak->Visible) { // kk_no_kontrak ?>
        <td data-name="kk_no_kontrak"<?= $Page->kk_no_kontrak->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_kk_no_kontrak" class="el_kontrak_koord_kk_no_kontrak">
<span<?= $Page->kk_no_kontrak->viewAttributes() ?>>
<?= $Page->kk_no_kontrak->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->koord_id->Visible) { // koord_id ?>
        <td data-name="koord_id"<?= $Page->koord_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_koord_id" class="el_kontrak_koord_koord_id">
<span<?= $Page->koord_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->koord_id->getViewValue()) && $Page->koord_id->linkAttributes() != "") { ?>
<a<?= $Page->koord_id->linkAttributes() ?>><?= $Page->koord_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->koord_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kk_tgl_mulai->Visible) { // kk_tgl_mulai ?>
        <td data-name="kk_tgl_mulai"<?= $Page->kk_tgl_mulai->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_kk_tgl_mulai" class="el_kontrak_koord_kk_tgl_mulai">
<span<?= $Page->kk_tgl_mulai->viewAttributes() ?>>
<?= $Page->kk_tgl_mulai->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kk_tgl_akhir->Visible) { // kk_tgl_akhir ?>
        <td data-name="kk_tgl_akhir"<?= $Page->kk_tgl_akhir->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_kk_tgl_akhir" class="el_kontrak_koord_kk_tgl_akhir">
<span<?= $Page->kk_tgl_akhir->viewAttributes() ?>>
<?= $Page->kk_tgl_akhir->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kk_periode->Visible) { // kk_periode ?>
        <td data-name="kk_periode"<?= $Page->kk_periode->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_kk_periode" class="el_kontrak_koord_kk_periode">
<span<?= $Page->kk_periode->viewAttributes() ?>>
<?= $Page->kk_periode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->var_id->Visible) { // var_id ?>
        <td data-name="var_id"<?= $Page->var_id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_var_id" class="el_kontrak_koord_var_id">
<span<?= $Page->var_id->viewAttributes() ?>>
<?= $Page->var_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kk_harga->Visible) { // kk_harga ?>
        <td data-name="kk_harga"<?= $Page->kk_harga->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_kk_harga" class="el_kontrak_koord_kk_harga">
<span<?= $Page->kk_harga->viewAttributes() ?>>
<?= $Page->kk_harga->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kk_luas->Visible) { // kk_luas ?>
        <td data-name="kk_luas"<?= $Page->kk_luas->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_kk_luas" class="el_kontrak_koord_kk_luas">
<span<?= $Page->kk_luas->viewAttributes() ?>>
<?= $Page->kk_luas->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kk_dok->Visible) { // kk_dok ?>
        <td data-name="kk_dok"<?= $Page->kk_dok->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_kontrak_koord_kk_dok" class="el_kontrak_koord_kk_dok">
<span>
<?= GetFileViewTag($Page->kk_dok, $Page->kk_dok->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }
    if (
        $Page->Recordset &&
        !$Page->Recordset->EOF &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->Recordset->moveNext();
    }
    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Page->Recordset) {
    $Page->Recordset->close();
}
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("kontrak_koord");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
