<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class VerifikasiEdit extends Verifikasi
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "VerifikasiEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "VerifikasiEdit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ver_id->Visible = false;
        $this->qc_id->setVisibility();
        $this->datang_id->setVisibility();
        $this->ver_tgl->setVisibility();
        $this->ver_presentasi_rijek->setVisibility();
        $this->ver_hasil_id->setVisibility();
        $this->ver_foto->setVisibility();
        $this->ver_catatan->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'verifikasi';
        $this->TableName = 'verifikasi';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (verifikasi)
        if (!isset($GLOBALS["verifikasi"]) || get_class($GLOBALS["verifikasi"]) == PROJECT_NAMESPACE . "verifikasi") {
            $GLOBALS["verifikasi"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'verifikasi');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "VerifikasiView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ver_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ver_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->qc_id);
        $this->setupLookupOptions($this->datang_id);
        $this->setupLookupOptions($this->ver_hasil_id);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("ver_id") ?? Key(0) ?? Route(2)) !== null) {
                $this->ver_id->setQueryStringValue($keyValue);
                $this->ver_id->setOldValue($this->ver_id->QueryStringValue);
            } elseif (Post("ver_id") !== null) {
                $this->ver_id->setFormValue(Post("ver_id"));
                $this->ver_id->setOldValue($this->ver_id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("ver_id") ?? Route("ver_id")) !== null) {
                    $this->ver_id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->ver_id->CurrentValue = null;
                }
            }

            // Load recordset
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("VerifikasiList"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "VerifikasiList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) {
                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "VerifikasiList") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "VerifikasiList"; // Return list page content
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = ROWTYPE_EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->ver_foto->Upload->Index = $CurrentForm->Index;
        $this->ver_foto->Upload->uploadFile();
        $this->ver_foto->CurrentValue = $this->ver_foto->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'qc_id' first before field var 'x_qc_id'
        $val = $CurrentForm->hasValue("qc_id") ? $CurrentForm->getValue("qc_id") : $CurrentForm->getValue("x_qc_id");
        if (!$this->qc_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qc_id->Visible = false; // Disable update for API request
            } else {
                $this->qc_id->setFormValue($val);
            }
        }

        // Check field name 'datang_id' first before field var 'x_datang_id'
        $val = $CurrentForm->hasValue("datang_id") ? $CurrentForm->getValue("datang_id") : $CurrentForm->getValue("x_datang_id");
        if (!$this->datang_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_id->Visible = false; // Disable update for API request
            } else {
                $this->datang_id->setFormValue($val);
            }
        }

        // Check field name 'ver_tgl' first before field var 'x_ver_tgl'
        $val = $CurrentForm->hasValue("ver_tgl") ? $CurrentForm->getValue("ver_tgl") : $CurrentForm->getValue("x_ver_tgl");
        if (!$this->ver_tgl->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ver_tgl->Visible = false; // Disable update for API request
            } else {
                $this->ver_tgl->setFormValue($val, true, $validate);
            }
            $this->ver_tgl->CurrentValue = UnFormatDateTime($this->ver_tgl->CurrentValue, $this->ver_tgl->formatPattern());
        }

        // Check field name 'ver_presentasi_rijek' first before field var 'x_ver_presentasi_rijek'
        $val = $CurrentForm->hasValue("ver_presentasi_rijek") ? $CurrentForm->getValue("ver_presentasi_rijek") : $CurrentForm->getValue("x_ver_presentasi_rijek");
        if (!$this->ver_presentasi_rijek->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ver_presentasi_rijek->Visible = false; // Disable update for API request
            } else {
                $this->ver_presentasi_rijek->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ver_hasil_id' first before field var 'x_ver_hasil_id'
        $val = $CurrentForm->hasValue("ver_hasil_id") ? $CurrentForm->getValue("ver_hasil_id") : $CurrentForm->getValue("x_ver_hasil_id");
        if (!$this->ver_hasil_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ver_hasil_id->Visible = false; // Disable update for API request
            } else {
                $this->ver_hasil_id->setFormValue($val);
            }
        }

        // Check field name 'ver_catatan' first before field var 'x_ver_catatan'
        $val = $CurrentForm->hasValue("ver_catatan") ? $CurrentForm->getValue("ver_catatan") : $CurrentForm->getValue("x_ver_catatan");
        if (!$this->ver_catatan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ver_catatan->Visible = false; // Disable update for API request
            } else {
                $this->ver_catatan->setFormValue($val);
            }
        }

        // Check field name 'ver_id' first before field var 'x_ver_id'
        $val = $CurrentForm->hasValue("ver_id") ? $CurrentForm->getValue("ver_id") : $CurrentForm->getValue("x_ver_id");
        if (!$this->ver_id->IsDetailKey) {
            $this->ver_id->setFormValue($val);
        }
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ver_id->CurrentValue = $this->ver_id->FormValue;
        $this->qc_id->CurrentValue = $this->qc_id->FormValue;
        $this->datang_id->CurrentValue = $this->datang_id->FormValue;
        $this->ver_tgl->CurrentValue = $this->ver_tgl->FormValue;
        $this->ver_tgl->CurrentValue = UnFormatDateTime($this->ver_tgl->CurrentValue, $this->ver_tgl->formatPattern());
        $this->ver_presentasi_rijek->CurrentValue = $this->ver_presentasi_rijek->FormValue;
        $this->ver_hasil_id->CurrentValue = $this->ver_hasil_id->FormValue;
        $this->ver_catatan->CurrentValue = $this->ver_catatan->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ver_id->setDbValue($row['ver_id']);
        $this->qc_id->setDbValue($row['qc_id']);
        $this->datang_id->setDbValue($row['datang_id']);
        $this->ver_tgl->setDbValue($row['ver_tgl']);
        $this->ver_presentasi_rijek->setDbValue($row['ver_presentasi_rijek']);
        $this->ver_hasil_id->setDbValue($row['ver_hasil_id']);
        $this->ver_foto->Upload->DbValue = $row['ver_foto'];
        $this->ver_foto->setDbValue($this->ver_foto->Upload->DbValue);
        $this->ver_catatan->setDbValue($row['ver_catatan']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ver_id'] = $this->ver_id->DefaultValue;
        $row['qc_id'] = $this->qc_id->DefaultValue;
        $row['datang_id'] = $this->datang_id->DefaultValue;
        $row['ver_tgl'] = $this->ver_tgl->DefaultValue;
        $row['ver_presentasi_rijek'] = $this->ver_presentasi_rijek->DefaultValue;
        $row['ver_hasil_id'] = $this->ver_hasil_id->DefaultValue;
        $row['ver_foto'] = $this->ver_foto->DefaultValue;
        $row['ver_catatan'] = $this->ver_catatan->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ver_id
        $this->ver_id->RowCssClass = "row";

        // qc_id
        $this->qc_id->RowCssClass = "row";

        // datang_id
        $this->datang_id->RowCssClass = "row";

        // ver_tgl
        $this->ver_tgl->RowCssClass = "row";

        // ver_presentasi_rijek
        $this->ver_presentasi_rijek->RowCssClass = "row";

        // ver_hasil_id
        $this->ver_hasil_id->RowCssClass = "row";

        // ver_foto
        $this->ver_foto->RowCssClass = "row";

        // ver_catatan
        $this->ver_catatan->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // ver_id
            $this->ver_id->ViewValue = $this->ver_id->CurrentValue;

            // qc_id
            $curVal = strval($this->qc_id->CurrentValue);
            if ($curVal != "") {
                $this->qc_id->ViewValue = $this->qc_id->lookupCacheOption($curVal);
                if ($this->qc_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`qc_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->qc_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->qc_id->Lookup->renderViewRow($rswrk[0]);
                        $this->qc_id->ViewValue = $this->qc_id->displayValue($arwrk);
                    } else {
                        $this->qc_id->ViewValue = $this->qc_id->CurrentValue;
                    }
                }
            } else {
                $this->qc_id->ViewValue = null;
            }

            // datang_id
            $curVal = strval($this->datang_id->CurrentValue);
            if ($curVal != "") {
                $this->datang_id->ViewValue = $this->datang_id->lookupCacheOption($curVal);
                if ($this->datang_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`datang_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->datang_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->datang_id->Lookup->renderViewRow($rswrk[0]);
                        $this->datang_id->ViewValue = $this->datang_id->displayValue($arwrk);
                    } else {
                        $this->datang_id->ViewValue = $this->datang_id->CurrentValue;
                    }
                }
            } else {
                $this->datang_id->ViewValue = null;
            }

            // ver_tgl
            $this->ver_tgl->ViewValue = $this->ver_tgl->CurrentValue;
            $this->ver_tgl->ViewValue = FormatDateTime($this->ver_tgl->ViewValue, $this->ver_tgl->formatPattern());

            // ver_presentasi_rijek
            $this->ver_presentasi_rijek->ViewValue = $this->ver_presentasi_rijek->CurrentValue;

            // ver_hasil_id
            $curVal = strval($this->ver_hasil_id->CurrentValue);
            if ($curVal != "") {
                $this->ver_hasil_id->ViewValue = $this->ver_hasil_id->lookupCacheOption($curVal);
                if ($this->ver_hasil_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`vh_id`", "=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->ver_hasil_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ver_hasil_id->Lookup->renderViewRow($rswrk[0]);
                        $this->ver_hasil_id->ViewValue = $this->ver_hasil_id->displayValue($arwrk);
                    } else {
                        $this->ver_hasil_id->ViewValue = $this->ver_hasil_id->CurrentValue;
                    }
                }
            } else {
                $this->ver_hasil_id->ViewValue = null;
            }

            // ver_foto
            if (!EmptyValue($this->ver_foto->Upload->DbValue)) {
                $this->ver_foto->ImageWidth = 200;
                $this->ver_foto->ImageHeight = 100;
                $this->ver_foto->ImageAlt = $this->ver_foto->alt();
                $this->ver_foto->ImageCssClass = "ew-image";
                $this->ver_foto->ViewValue = $this->ver_foto->Upload->DbValue;
            } else {
                $this->ver_foto->ViewValue = "";
            }

            // ver_catatan
            $this->ver_catatan->ViewValue = $this->ver_catatan->CurrentValue;

            // qc_id
            $this->qc_id->HrefValue = "";

            // datang_id
            $this->datang_id->HrefValue = "";

            // ver_tgl
            $this->ver_tgl->HrefValue = "";

            // ver_presentasi_rijek
            $this->ver_presentasi_rijek->HrefValue = "";

            // ver_hasil_id
            $this->ver_hasil_id->HrefValue = "";

            // ver_foto
            if (!EmptyValue($this->ver_foto->Upload->DbValue)) {
                $this->ver_foto->HrefValue = "%u"; // Add prefix/suffix
                $this->ver_foto->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->ver_foto->HrefValue = FullUrl($this->ver_foto->HrefValue, "href");
                }
            } else {
                $this->ver_foto->HrefValue = "";
            }
            $this->ver_foto->ExportHrefValue = $this->ver_foto->UploadPath . $this->ver_foto->Upload->DbValue;

            // ver_catatan
            $this->ver_catatan->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // qc_id
            $this->qc_id->setupEditAttributes();
            $curVal = trim(strval($this->qc_id->CurrentValue));
            if ($curVal != "") {
                $this->qc_id->ViewValue = $this->qc_id->lookupCacheOption($curVal);
            } else {
                $this->qc_id->ViewValue = $this->qc_id->Lookup !== null && is_array($this->qc_id->lookupOptions()) && count($this->qc_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->qc_id->ViewValue !== null) { // Load from cache
                $this->qc_id->EditValue = array_values($this->qc_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`qc_id`", "=", $this->qc_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->qc_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->qc_id->EditValue = $arwrk;
            }
            $this->qc_id->PlaceHolder = RemoveHtml($this->qc_id->caption());

            // datang_id
            $this->datang_id->setupEditAttributes();
            $curVal = trim(strval($this->datang_id->CurrentValue));
            if ($curVal != "") {
                $this->datang_id->ViewValue = $this->datang_id->lookupCacheOption($curVal);
            } else {
                $this->datang_id->ViewValue = $this->datang_id->Lookup !== null && is_array($this->datang_id->lookupOptions()) && count($this->datang_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->datang_id->ViewValue !== null) { // Load from cache
                $this->datang_id->EditValue = array_values($this->datang_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`datang_id`", "=", $this->datang_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->datang_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->datang_id->EditValue = $arwrk;
            }
            $this->datang_id->PlaceHolder = RemoveHtml($this->datang_id->caption());

            // ver_tgl
            $this->ver_tgl->setupEditAttributes();
            $this->ver_tgl->EditValue = HtmlEncode(FormatDateTime($this->ver_tgl->CurrentValue, $this->ver_tgl->formatPattern()));
            $this->ver_tgl->PlaceHolder = RemoveHtml($this->ver_tgl->caption());

            // ver_presentasi_rijek
            $this->ver_presentasi_rijek->setupEditAttributes();
            $this->ver_presentasi_rijek->EditValue = HtmlEncode($this->ver_presentasi_rijek->CurrentValue);
            $this->ver_presentasi_rijek->PlaceHolder = RemoveHtml($this->ver_presentasi_rijek->caption());
            if (strval($this->ver_presentasi_rijek->EditValue) != "" && is_numeric($this->ver_presentasi_rijek->EditValue)) {
                $this->ver_presentasi_rijek->EditValue = $this->ver_presentasi_rijek->EditValue;
            }

            // ver_hasil_id
            $this->ver_hasil_id->setupEditAttributes();
            $curVal = trim(strval($this->ver_hasil_id->CurrentValue));
            if ($curVal != "") {
                $this->ver_hasil_id->ViewValue = $this->ver_hasil_id->lookupCacheOption($curVal);
            } else {
                $this->ver_hasil_id->ViewValue = $this->ver_hasil_id->Lookup !== null && is_array($this->ver_hasil_id->lookupOptions()) && count($this->ver_hasil_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ver_hasil_id->ViewValue !== null) { // Load from cache
                $this->ver_hasil_id->EditValue = array_values($this->ver_hasil_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`vh_id`", "=", $this->ver_hasil_id->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->ver_hasil_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ver_hasil_id->EditValue = $arwrk;
            }
            $this->ver_hasil_id->PlaceHolder = RemoveHtml($this->ver_hasil_id->caption());

            // ver_foto
            $this->ver_foto->setupEditAttributes();
            if (!EmptyValue($this->ver_foto->Upload->DbValue)) {
                $this->ver_foto->ImageWidth = 200;
                $this->ver_foto->ImageHeight = 100;
                $this->ver_foto->ImageAlt = $this->ver_foto->alt();
                $this->ver_foto->ImageCssClass = "ew-image";
                $this->ver_foto->EditValue = $this->ver_foto->Upload->DbValue;
            } else {
                $this->ver_foto->EditValue = "";
            }
            if (!EmptyValue($this->ver_foto->CurrentValue)) {
                $this->ver_foto->Upload->FileName = $this->ver_foto->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->ver_foto);
            }

            // ver_catatan
            $this->ver_catatan->setupEditAttributes();
            $this->ver_catatan->EditValue = HtmlEncode($this->ver_catatan->CurrentValue);
            $this->ver_catatan->PlaceHolder = RemoveHtml($this->ver_catatan->caption());

            // Edit refer script

            // qc_id
            $this->qc_id->HrefValue = "";

            // datang_id
            $this->datang_id->HrefValue = "";

            // ver_tgl
            $this->ver_tgl->HrefValue = "";

            // ver_presentasi_rijek
            $this->ver_presentasi_rijek->HrefValue = "";

            // ver_hasil_id
            $this->ver_hasil_id->HrefValue = "";

            // ver_foto
            if (!EmptyValue($this->ver_foto->Upload->DbValue)) {
                $this->ver_foto->HrefValue = "%u"; // Add prefix/suffix
                $this->ver_foto->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->ver_foto->HrefValue = FullUrl($this->ver_foto->HrefValue, "href");
                }
            } else {
                $this->ver_foto->HrefValue = "";
            }
            $this->ver_foto->ExportHrefValue = $this->ver_foto->UploadPath . $this->ver_foto->Upload->DbValue;

            // ver_catatan
            $this->ver_catatan->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->qc_id->Visible && $this->qc_id->Required) {
            if (!$this->qc_id->IsDetailKey && EmptyValue($this->qc_id->FormValue)) {
                $this->qc_id->addErrorMessage(str_replace("%s", $this->qc_id->caption(), $this->qc_id->RequiredErrorMessage));
            }
        }
        if ($this->datang_id->Visible && $this->datang_id->Required) {
            if (!$this->datang_id->IsDetailKey && EmptyValue($this->datang_id->FormValue)) {
                $this->datang_id->addErrorMessage(str_replace("%s", $this->datang_id->caption(), $this->datang_id->RequiredErrorMessage));
            }
        }
        if ($this->ver_tgl->Visible && $this->ver_tgl->Required) {
            if (!$this->ver_tgl->IsDetailKey && EmptyValue($this->ver_tgl->FormValue)) {
                $this->ver_tgl->addErrorMessage(str_replace("%s", $this->ver_tgl->caption(), $this->ver_tgl->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->ver_tgl->FormValue, $this->ver_tgl->formatPattern())) {
            $this->ver_tgl->addErrorMessage($this->ver_tgl->getErrorMessage(false));
        }
        if ($this->ver_presentasi_rijek->Visible && $this->ver_presentasi_rijek->Required) {
            if (!$this->ver_presentasi_rijek->IsDetailKey && EmptyValue($this->ver_presentasi_rijek->FormValue)) {
                $this->ver_presentasi_rijek->addErrorMessage(str_replace("%s", $this->ver_presentasi_rijek->caption(), $this->ver_presentasi_rijek->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ver_presentasi_rijek->FormValue)) {
            $this->ver_presentasi_rijek->addErrorMessage($this->ver_presentasi_rijek->getErrorMessage(false));
        }
        if ($this->ver_hasil_id->Visible && $this->ver_hasil_id->Required) {
            if (!$this->ver_hasil_id->IsDetailKey && EmptyValue($this->ver_hasil_id->FormValue)) {
                $this->ver_hasil_id->addErrorMessage(str_replace("%s", $this->ver_hasil_id->caption(), $this->ver_hasil_id->RequiredErrorMessage));
            }
        }
        if ($this->ver_foto->Visible && $this->ver_foto->Required) {
            if ($this->ver_foto->Upload->FileName == "" && !$this->ver_foto->Upload->KeepFile) {
                $this->ver_foto->addErrorMessage(str_replace("%s", $this->ver_foto->caption(), $this->ver_foto->RequiredErrorMessage));
            }
        }
        if ($this->ver_catatan->Visible && $this->ver_catatan->Required) {
            if (!$this->ver_catatan->IsDetailKey && EmptyValue($this->ver_catatan->FormValue)) {
                $this->ver_catatan->addErrorMessage(str_replace("%s", $this->ver_catatan->caption(), $this->ver_catatan->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
        }

        // Set new row
        $rsnew = [];

        // qc_id
        $this->qc_id->setDbValueDef($rsnew, $this->qc_id->CurrentValue, $this->qc_id->ReadOnly);

        // datang_id
        $this->datang_id->setDbValueDef($rsnew, $this->datang_id->CurrentValue, $this->datang_id->ReadOnly);

        // ver_tgl
        $this->ver_tgl->setDbValueDef($rsnew, UnFormatDateTime($this->ver_tgl->CurrentValue, $this->ver_tgl->formatPattern()), $this->ver_tgl->ReadOnly);

        // ver_presentasi_rijek
        $this->ver_presentasi_rijek->setDbValueDef($rsnew, $this->ver_presentasi_rijek->CurrentValue, $this->ver_presentasi_rijek->ReadOnly);

        // ver_hasil_id
        $this->ver_hasil_id->setDbValueDef($rsnew, $this->ver_hasil_id->CurrentValue, $this->ver_hasil_id->ReadOnly);

        // ver_foto
        if ($this->ver_foto->Visible && !$this->ver_foto->ReadOnly && !$this->ver_foto->Upload->KeepFile) {
            $this->ver_foto->Upload->DbValue = $rsold['ver_foto']; // Get original value
            if ($this->ver_foto->Upload->FileName == "") {
                $rsnew['ver_foto'] = null;
            } else {
                $rsnew['ver_foto'] = $this->ver_foto->Upload->FileName;
            }
            $this->ver_foto->ImageWidth = Config("THUMBNAIL_DEFAULT_WIDTH"); // Resize width
            $this->ver_foto->ImageHeight = Config("THUMBNAIL_DEFAULT_HEIGHT"); // Resize height
        }

        // ver_catatan
        $this->ver_catatan->setDbValueDef($rsnew, $this->ver_catatan->CurrentValue, $this->ver_catatan->ReadOnly);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->ver_foto->Visible && !$this->ver_foto->Upload->KeepFile) {
            $oldFiles = EmptyValue($this->ver_foto->Upload->DbValue) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->ver_foto->htmlDecode(strval($this->ver_foto->Upload->DbValue)));
            if (!EmptyValue($this->ver_foto->Upload->FileName)) {
                $newFiles = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), strval($this->ver_foto->Upload->FileName));
                $NewFileCount = count($newFiles);
                for ($i = 0; $i < $NewFileCount; $i++) {
                    if ($newFiles[$i] != "") {
                        $file = $newFiles[$i];
                        $tempPath = UploadTempPath($this->ver_foto, $this->ver_foto->Upload->Index);
                        if (file_exists($tempPath . $file)) {
                            if (Config("DELETE_UPLOADED_FILES")) {
                                $oldFileFound = false;
                                $oldFileCount = count($oldFiles);
                                for ($j = 0; $j < $oldFileCount; $j++) {
                                    $oldFile = $oldFiles[$j];
                                    if ($oldFile == $file) { // Old file found, no need to delete anymore
                                        array_splice($oldFiles, $j, 1);
                                        $oldFileFound = true;
                                        break;
                                    }
                                }
                                if ($oldFileFound) { // No need to check if file exists further
                                    continue;
                                }
                            }
                            $file1 = UniqueFilename($this->ver_foto->physicalUploadPath(), $file); // Get new file name
                            if ($file1 != $file) { // Rename temp file
                                while (file_exists($tempPath . $file1) || file_exists($this->ver_foto->physicalUploadPath() . $file1)) { // Make sure no file name clash
                                    $file1 = UniqueFilename([$this->ver_foto->physicalUploadPath(), $tempPath], $file1, true); // Use indexed name
                                }
                                rename($tempPath . $file, $tempPath . $file1);
                                $newFiles[$i] = $file1;
                            }
                        }
                    }
                }
                $this->ver_foto->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
                $this->ver_foto->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
                $this->ver_foto->setDbValueDef($rsnew, $this->ver_foto->Upload->FileName, $this->ver_foto->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->ver_foto->Visible && !$this->ver_foto->Upload->KeepFile) {
                    $oldFiles = EmptyValue($this->ver_foto->Upload->DbValue) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->ver_foto->htmlDecode(strval($this->ver_foto->Upload->DbValue)));
                    if (!EmptyValue($this->ver_foto->Upload->FileName)) {
                        $newFiles = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->ver_foto->Upload->FileName);
                        $newFiles2 = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->ver_foto->htmlDecode($rsnew['ver_foto']));
                        $newFileCount = count($newFiles);
                        for ($i = 0; $i < $newFileCount; $i++) {
                            if ($newFiles[$i] != "") {
                                $file = UploadTempPath($this->ver_foto, $this->ver_foto->Upload->Index) . $newFiles[$i];
                                if (file_exists($file)) {
                                    if (@$newFiles2[$i] != "") { // Use correct file name
                                        $newFiles[$i] = $newFiles2[$i];
                                    }
                                    if (!$this->ver_foto->Upload->ResizeAndSaveToFile($this->ver_foto->ImageWidth, $this->ver_foto->ImageHeight, 100, $newFiles[$i], true, $i)) {
                                        $this->setFailureMessage($Language->phrase("UploadError7"));
                                        return false;
                                    }
                                }
                            }
                        }
                    } else {
                        $newFiles = [];
                    }
                    if (Config("DELETE_UPLOADED_FILES")) {
                        foreach ($oldFiles as $oldFile) {
                            if ($oldFile != "" && !in_array($oldFile, $newFiles)) {
                                @unlink($this->ver_foto->oldPhysicalUploadPath() . $oldFile);
                            }
                        }
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("KontrakList");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("VerifikasiList"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_qc_id":
                    break;
                case "x_datang_id":
                    break;
                case "x_ver_hasil_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
