<?php
namespace PHPMaker2019\co;

/**
 * Page class (Kedatangan_Dan_Verifikasi_summary)
 */
class Kedatangan_Dan_Verifikasi_summary extends Kedatangan_Dan_Verifikasi
{

	// Page ID
	public $PageID = 'summary';

	// Project ID
	public $ProjectID = "{FAF953E4-B026-4CC4-8D1E-0CFAFEB15236}";

	// Page object name
	public $PageObjName = 'Kedatangan_Dan_Verifikasi_summary';
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Page headings
	public $Heading = '';
	public $Subheading = '';
	public $PageHeader;
	public $PageFooter;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportPdfUrl;
	public $ExportEmailUrl;

	// CSS
	public $ReportTableClass = "";
	public $ReportTableStyle = "";

	// Custom export
	public $ExportPrintCustom = FALSE;
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Page heading
	public function pageHeading()
	{
		global $ReportLanguage;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $ReportLanguage;
		if ($this->Subheading <> "")
			return $this->Subheading;
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$pageUrl = CurrentPageName() . "?";
		if ($this->UseTokenInUrl) $pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return @$_SESSION[SESSION_MESSAGE];
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($_SESSION[SESSION_MESSAGE], $v);
	}

	// Get failure message
	public function getFailureMessage()
	{
		return @$_SESSION[SESSION_FAILURE_MESSAGE];
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($_SESSION[SESSION_FAILURE_MESSAGE], $v);
	}

	// Get success message
	public function getSuccessMessage()
	{
		return @$_SESSION[SESSION_SUCCESS_MESSAGE];
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($_SESSION[SESSION_SUCCESS_MESSAGE], $v);
	}

	// Get warning message
	public function getWarningMessage()
	{
		return @$_SESSION[SESSION_WARNING_MESSAGE];
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($_SESSION[SESSION_WARNING_MESSAGE], $v);
	}

	// Clear message
	public function clearMessage()
	{
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$_SESSION[SESSION_MESSAGE] = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") // Fotoer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
	}

	// Validate page request
	public function isPageRequest()
	{
		if ($this->UseTokenInUrl) {
			if (IsPost())
				return ($this->TableVar == Post("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $ReportLanguage, $DashboardReport;
		global $UserTable, $UserTableConn;

		// Initialize
		if (!$DashboardReport)
			$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		$ReportLanguage = new ReportLanguage();
		if ($Language === NULL)
			$Language = $ReportLanguage;

		// Parent constuctor
		parent::__construct();

		// Table object (Kedatangan_Dan_Verifikasi)
		if (!isset($GLOBALS["Kedatangan_Dan_Verifikasi"])) {
			$GLOBALS["Kedatangan_Dan_Verifikasi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Kedatangan_Dan_Verifikasi"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportEmailUrl = $this->pageUrl() . "export=email";

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'summary');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'Kedatangan Dan Verifikasi');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees_base)
		if (!isset($UserTable)) {
			$UserTable = new employees_base();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Search options
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fKedatangan_Dan_Verifikasisummary";

		// Generate report options
		$this->GenerateOptions = new ListOptions();
		$this->GenerateOptions->Tag = "div";
		$this->GenerateOptions->TagClassName = "ew-generate-option";
	}

	// Get export HTML tag
	public function getExportTag($type, $custom = FALSE)
	{
		global $ReportLanguage;
		$exportId = session_id();
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportExcelUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("ExportToExcel") . "</a>";
			else
				return "<a class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportWordUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("ExportToWord") . "</a>";
			else
				return "<a class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "print")) {
			if ($custom)
				return "<a class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportPrintUrl . "', '" . $exportId . "');\">" . $ReportLanguage->phrase("PrinterFriendly") . "</a>";
			else
				return "<a class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly"), TRUE) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->phrase("PrinterFriendly") . "</a>";
		} elseif (SameText($type, "pdf")) {
			return "<a class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "email")) {
			return "<a class=\"ew-export-link ew-email\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToEmail", TRUE)) . "\" id=\"emf_Kedatangan_Dan_Verifikasi\" href=\"#\" onclick=\"ew.emailDialogShow({ lnk: 'emf_Kedatangan_Dan_Verifikasi', hdr: ew.language.phrase('ExportToEmail'), url: '$this->ExportEmailUrl', exportid: '$exportId', el: this }); return false;\">" . $ReportLanguage->phrase("ExportToEmail") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Security, $ReportLanguage, $ReportOptions;
		$exportId = session_id();
		$reportTypes = [];

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;
		$reportTypes["print"] = $item->Visible ? $ReportLanguage->phrase("ReportFormPrint") : "";

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;
		$reportTypes["excel"] = $item->Visible ? $ReportLanguage->phrase("ReportFormExcel") : "";

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = TRUE;
		$reportTypes["word"] = $item->Visible ? $ReportLanguage->phrase("ReportFormWord") : "";

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;
		$item->Visible = TRUE;
		$reportTypes["pdf"] = $item->Visible ? $ReportLanguage->phrase("ReportFormPdf") : "";

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;
		$reportTypes["email"] = $item->Visible ? $ReportLanguage->phrase("ReportFormEmail") : "";

		// Report types
		$ReportOptions["ReportTypes"] = $reportTypes;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fKedatangan_Dan_Verifikasisummary\" href=\"#\">" . $ReportLanguage->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fKedatangan_Dan_Verifikasisummary\" href=\"#\">" . $ReportLanguage->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up export options (extended)
		$this->setupExportOptionsExt();

		// Hide options for export
		if ($this->isExport()) {
			$this->ExportOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}

		// Set up table class
		if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf"))
			$this->ReportTableClass = "ew-table";
		else
			$this->ReportTableClass = "table ew-table";
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $ReportLanguage;

		// Filter panel button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = $this->FilterApplied ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $ReportLanguage->phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fKedatangan_Dan_Verifikasisummary\">" . $ReportLanguage->phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Reset filter
		$item = &$this->SearchOptions->add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlEncode($ReportLanguage->phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . CurrentPageName() . "?cmd=reset'\">" . $ReportLanguage->phrase("ResetAllFilter") . "</button>";
		$item->Visible = TRUE && $this->FilterApplied;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->isExport())
			$this->SearchOptions->hideAllOptions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ReportLanguage, $EXPORT_REPORT, $ExportFileName, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->isExport() && array_key_exists($this->Export, $EXPORT_REPORT)) {
			$content = ob_get_contents();
			if (ob_get_length())
				ob_end_clean();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $content, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$content = str_replace($divmatch[0], "", $content);
				}
			}
			$fn = $EXPORT_REPORT[$this->Export];
			$saveResponse = $this->$fn($content);
			if (ReportParam("generaterequest") === TRUE) { // Generate report request
				$this->writeGenResponse($saveResponse);
				$url = ""; // Avoid redirect
			}
		}

		// Close connection if not in dashboard
		if (!$DashboardReport)
			CloseConnections();

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			header("Location: " . $url);
		}
		if (!$DashboardReport)
			exit();
	}

	// Initialize common variables
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $FilterOptions; // Filter options

	// Recordset
	public $GroupRecordset = NULL;
	public $Recordset = NULL;
	public $DetailRecordCount = 0;

	// Paging variables
	public $RecordIndex = 0; // Record index
	public $RecordCount = 0; // Record count
	public $StartGroup = 0; // Start group
	public $StopGroup = 0; // Stop group
	public $TotalGroups = 0; // Total groups
	public $GroupCount = 0; // Group count
	public $GroupCounter = []; // Group counter
	public $DisplayGroups = 50; // Groups per page
	public $GroupRange = 10;
	public $Sort = "";
	public $Filter = "";
	public $PageFirstGroupFilter = "";
	public $UserIDFilter = "";
	public $DrillDown = FALSE;
	public $DrillDownInPanel = FALSE;
	public $DrillDownList = "";

	// Clear field for ext filter
	public $ExpiredExtendedFilter = "";
	public $PopupName = "";
	public $PopupValue = "";
	public $FilterApplied;
	public $SearchCommand = FALSE;
	public $ShowHeader;
	public $GroupColumnCount = 0;
	public $SubGroupColumnCount = 0;
	public $DetailColumnCount = 0;
	public $Counts;
	public $Columns;
	public $Values;
	public $Summaries;
	public $Minimums;
	public $Maximums;
	public $GrandCounts;
	public $GrandSummaries;
	public $GrandMinimums;
	public $GrandMaximums;
	public $TotalCount;
	public $GrandSummarySetup = FALSE;
	public $GroupIndexes;
	public $DetailRows = [];
	public $TopContentClass = "col-sm-12 ew-top";
	public $LeftContentClass = "ew-left";
	public $CenterContentClass = "col-sm-12 ew-center";
	public $RightContentClass = "ew-right";
	public $BottomContentClass = "col-sm-12 ew-bottom";

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $ExportFileName, $ReportLanguage, $Security, $UserProfile,
			$Security, $FormError, $DrillDownInPanel, $Breadcrumb, $ReportLanguage,
			$DashboardReport, $CustomExportType;
		global $ReportLanguage;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		if (!$Security->isLoggedIn()) $Security->autoLogin(); // Auto login
		$Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel($this->ProjectID . 'Kedatangan Dan Verifikasi');
		$Security->TablePermission_Loaded();
		if (!$Security->canList()) {
			$Security->saveLastUrl();
			$this->setFailureMessage(DeniedMessage()); // Set no permission
			$this->terminate(GetUrl("index.php"));
		}

		// Get export parameters
		if (ReportParam("export") !== NULL)
			$this->Export = strtolower(ReportParam("export"));
		$ExportType = $this->Export; // Get export parameter, used in header
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Setup placeholder
		$this->datang_tgl->PlaceHolder = $this->datang_tgl->caption();
		$this->k_es_tgl_panen->PlaceHolder = $this->k_es_tgl_panen->caption();
		$this->ver_tgl->PlaceHolder = $this->ver_tgl->caption();

		// Setup export options
		$this->setupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			echo $ReportLanguage->phrase("InvalidPostRequest");
			$this->terminate();
			exit();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->ds_nama);
		$this->setupLookupOptions($this->var_nama);
		$this->setupLookupOptions($this->sup_nama);
		$this->setupLookupOptions($this->pet_nama);
		$this->setupLookupOptions($this->co_nama);
		$this->setupLookupOptions($this->k_id_kontrak);
		$this->setupLookupOptions($this->ver_hasil_id);
		$this->setupLookupOptions($this->qc_nama);

		// Set field visibility for detail fields
		$this->datang_id->setVisibility();
		$this->datang_tgl->setVisibility();
		$this->datang_jumlah->setVisibility();
		$this->ds_nama->setVisibility();
		$this->datang_terpakai->setVisibility();
		$this->var_nama->setVisibility();
		$this->sup_nama->setVisibility();
		$this->pet_nama->setVisibility();
		$this->co_nama->setVisibility();
		$this->k_id_kontrak->setVisibility();
		$this->k_luas_lahan->setVisibility();
		$this->k_es_tgl_panen->setVisibility();
		$this->k_es_qty->setVisibility();
		$this->ver_tgl->setVisibility();
		$this->ver_presentasi_rijek->setVisibility();
		$this->ver_hasil_id->setVisibility();
		$this->qc_nama->setVisibility();
		$this->ver_catatan->setVisibility();

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$fieldCount = 19;
		$groupCount = 1;
		$this->Values = &InitArray($fieldCount, 0);
		$this->Counts = &Init2DArray($groupCount, $fieldCount, 0);
		$this->Summaries = &Init2DArray($groupCount, $fieldCount, 0);
		$this->Minimums = &Init2DArray($groupCount, $fieldCount, NULL);
		$this->Maximums = &Init2DArray($groupCount, $fieldCount, NULL);
		$this->GrandCounts = &InitArray($fieldCount, 0);
		$this->GrandSummaries = &InitArray($fieldCount, 0);
		$this->GrandMinimums = &InitArray($fieldCount, NULL);
		$this->GrandMaximums = &InitArray($fieldCount, NULL);

		// Set up array if accumulation required: [Accum, SkipNullOrZero]
		$this->Columns = [[FALSE, FALSE], [FALSE,FALSE], [FALSE,FALSE], [TRUE,FALSE], [FALSE,FALSE], [TRUE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [TRUE,FALSE], [FALSE,FALSE], [FALSE,FALSE], [FALSE,FALSE]];

		// Set up groups per page dynamically
		$this->setupDisplayGroups();

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();
		$this->qc_nama->SelectionList = "";
		$this->qc_nama->DefaultSelectionList = "";
		$this->qc_nama->ValueList = "";

		// Check if search command
		$this->SearchCommand = (Get("cmd", "") == "search");

		// Load default filter values
		$this->loadDefaultFilters();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->setupPopup();

		// Load group db values if necessary
		$this->loadGroupDbValues();

		// Extended filter
		$extendedFilter = "";

		// Restore filter list
		$this->restoreFilterList();

		// Build extended filter
		$extendedFilter = $this->getExtendedFilter();
		AddFilter($this->Filter, $extendedFilter);

		// Build popup filter
		$popupFilter = $this->getPopupFilter();
		AddFilter($this->Filter, $popupFilter);

		// Check if filter applied
		$this->FilterApplied = $this->checkFilter();

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);

		// Search options
		$this->setupSearchOptions();

		// Get sort
		$this->Sort = $this->getSort();

		// Get total count
		$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
		$this->TotalGroups = $this->getRecordCount($sql);
		if ($this->DisplayGroups <= 0 || $this->DrillDown || $DashboardReport) // Display all groups
			$this->DisplayGroups = $this->TotalGroups;
		$this->StartGroup = 1;

		// Show header
		$this->ShowHeader = TRUE;

		// Set up start position if not export all
		if ($this->ExportAll && $this->isExport())
			$this->DisplayGroups = $this->TotalGroups;
		else
			$this->setupStartGroup();

		// Set no record found message
		if ($this->TotalGroups == 0) {
			if ($Security->canList()) {
				if ($this->Filter == "0=101") {
					$this->setWarningMessage($ReportLanguage->phrase("EnterSearchCriteria"));
				} else {
					$this->setWarningMessage($ReportLanguage->phrase("NoRecord"));
				}
			} else {
				$this->setWarningMessage(DeniedMessage());
			}
		}

		// Hide export options if export/dashboard report
		if ($this->isExport() || $DashboardReport)
			$this->ExportOptions->hideAllOptions();

		// Hide search/filter options if export/drilldown/dashboard report
		if ($this->isExport() || $this->DrillDown || $DashboardReport) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
			$this->GenerateOptions->hideAllOptions();
		}

		// Get current page records
		$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $this->Filter, $this->Sort);
		$this->Recordset = $this->getRecordset($sql, $this->DisplayGroups, $this->StartGroup - 1);
		$this->setupFieldCount();
	}

	// Accummulate summary
	public function accumulateSummary()
	{
		$cntx = count($this->Summaries);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Summaries[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Columns[$iy][0]) { // Accumulate required
					$valwrk = $this->Values[$iy];
					if ($valwrk === NULL) {
						if (!$this->Columns[$iy][1])
							$this->Counts[$ix][$iy]++;
					} else {
						$accum = (!$this->Columns[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Counts[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Summaries[$ix][$iy] += $valwrk;
								if ($this->Minimums[$ix][$iy] === NULL) {
									$this->Minimums[$ix][$iy] = $valwrk;
									$this->Maximums[$ix][$iy] = $valwrk;
								} else {
									if ($this->Minimums[$ix][$iy] > $valwrk)
										$this->Minimums[$ix][$iy] = $valwrk;
									if ($this->Maximums[$ix][$iy] < $valwrk)
										$this->Maximums[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Summaries);
		for ($ix = 0; $ix < $cntx; $ix++)
			$this->Counts[$ix][0]++;
	}

	// Reset level summary
	public function resetLevelSummary($lvl)
	{

		// Clear summary values
		$cntx = count($this->Summaries);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Summaries[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Counts[$ix][$iy] = 0;
				if ($this->Columns[$iy][0]) {
					$this->Summaries[$ix][$iy] = 0;
					$this->Minimums[$ix][$iy] = NULL;
					$this->Maximums[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Summaries);
		for ($ix = $lvl; $ix < $cntx; $ix++)
			$this->Counts[$ix][0] = 0;

		// Reset record count
		$this->RecordCount = 0;
	}

	// Load row values
	public function loadRowValues($firstRow = FALSE)
	{
		if (!$this->Recordset)
			return;
		if ($firstRow) { // Get first row
				$this->FirstRowData = [];
				$this->FirstRowData["datang_id"] = $this->Recordset->fields('datang_id');
				$this->FirstRowData["datang_tgl"] = $this->Recordset->fields('datang_tgl');
				$this->FirstRowData["datang_jumlah"] = $this->Recordset->fields('datang_jumlah');
				$this->FirstRowData["ds_nama"] = $this->Recordset->fields('ds_nama');
				$this->FirstRowData["datang_terpakai"] = $this->Recordset->fields('datang_terpakai');
				$this->FirstRowData["var_nama"] = $this->Recordset->fields('var_nama');
				$this->FirstRowData["sup_nama"] = $this->Recordset->fields('sup_nama');
				$this->FirstRowData["pet_nama"] = $this->Recordset->fields('pet_nama');
				$this->FirstRowData["co_nama"] = $this->Recordset->fields('co_nama');
				$this->FirstRowData["k_id_kontrak"] = $this->Recordset->fields('k_id_kontrak');
				$this->FirstRowData["k_luas_lahan"] = $this->Recordset->fields('k_luas_lahan');
				$this->FirstRowData["k_es_tgl_panen"] = $this->Recordset->fields('k_es_tgl_panen');
				$this->FirstRowData["k_es_qty"] = $this->Recordset->fields('k_es_qty');
				$this->FirstRowData["ver_tgl"] = $this->Recordset->fields('ver_tgl');
				$this->FirstRowData["ver_presentasi_rijek"] = $this->Recordset->fields('ver_presentasi_rijek');
				$this->FirstRowData["ver_hasil_id"] = $this->Recordset->fields('ver_hasil_id');
				$this->FirstRowData["ver_foto"] = $this->Recordset->fields('ver_foto');
				$this->FirstRowData["qc_nama"] = $this->Recordset->fields('qc_nama');
		} else { // Get next row
			$this->Recordset->moveNext();
		}
		if (!$this->Recordset->EOF) {
			$this->datang_id->setDbValue($this->Recordset->fields('datang_id'));
			$this->datang_tgl->setDbValue($this->Recordset->fields('datang_tgl'));
			$this->datang_jumlah->setDbValue($this->Recordset->fields('datang_jumlah'));
			$this->ds_nama->setDbValue($this->Recordset->fields('ds_nama'));
			$this->datang_terpakai->setDbValue($this->Recordset->fields('datang_terpakai'));
			$this->var_nama->setDbValue($this->Recordset->fields('var_nama'));
			$this->sup_nama->setDbValue($this->Recordset->fields('sup_nama'));
			$this->pet_nama->setDbValue($this->Recordset->fields('pet_nama'));
			$this->co_nama->setDbValue($this->Recordset->fields('co_nama'));
			$this->k_id_kontrak->setDbValue($this->Recordset->fields('k_id_kontrak'));
			$this->k_luas_lahan->setDbValue($this->Recordset->fields('k_luas_lahan'));
			$this->k_es_tgl_panen->setDbValue($this->Recordset->fields('k_es_tgl_panen'));
			$this->k_es_qty->setDbValue($this->Recordset->fields('k_es_qty'));
			$this->ver_tgl->setDbValue($this->Recordset->fields('ver_tgl'));
			$this->ver_presentasi_rijek->setDbValue($this->Recordset->fields('ver_presentasi_rijek'));
			$this->ver_hasil_id->setDbValue($this->Recordset->fields('ver_hasil_id'));
			$this->ver_foto->setDbValue($this->Recordset->fields('ver_foto'));
			$this->qc_nama->setDbValue($this->Recordset->fields('qc_nama'));
			$this->ver_catatan->setDbValue($this->Recordset->fields('ver_catatan'));
			$this->Values[1] = $this->datang_id->CurrentValue;
			$this->Values[2] = $this->datang_tgl->CurrentValue;
			$this->Values[3] = $this->datang_jumlah->CurrentValue;
			$this->Values[4] = $this->ds_nama->CurrentValue;
			$this->Values[5] = $this->datang_terpakai->CurrentValue;
			$this->Values[6] = $this->var_nama->CurrentValue;
			$this->Values[7] = $this->sup_nama->CurrentValue;
			$this->Values[8] = $this->pet_nama->CurrentValue;
			$this->Values[9] = $this->co_nama->CurrentValue;
			$this->Values[10] = $this->k_id_kontrak->CurrentValue;
			$this->Values[11] = $this->k_luas_lahan->CurrentValue;
			$this->Values[12] = $this->k_es_tgl_panen->CurrentValue;
			$this->Values[13] = $this->k_es_qty->CurrentValue;
			$this->Values[14] = $this->ver_tgl->CurrentValue;
			$this->Values[15] = $this->ver_presentasi_rijek->CurrentValue;
			$this->Values[16] = $this->ver_hasil_id->CurrentValue;
			$this->Values[17] = $this->qc_nama->CurrentValue;
			$this->Values[18] = $this->ver_catatan->CurrentValue;
		} else {
			$this->datang_id->setDbValue("");
			$this->datang_tgl->setDbValue("");
			$this->datang_jumlah->setDbValue("");
			$this->ds_nama->setDbValue("");
			$this->datang_terpakai->setDbValue("");
			$this->var_nama->setDbValue("");
			$this->sup_nama->setDbValue("");
			$this->pet_nama->setDbValue("");
			$this->co_nama->setDbValue("");
			$this->k_id_kontrak->setDbValue("");
			$this->k_luas_lahan->setDbValue("");
			$this->k_es_tgl_panen->setDbValue("");
			$this->k_es_qty->setDbValue("");
			$this->ver_tgl->setDbValue("");
			$this->ver_presentasi_rijek->setDbValue("");
			$this->ver_hasil_id->setDbValue("");
			$this->ver_foto->setDbValue("");
			$this->qc_nama->setDbValue("");
			$this->ver_catatan->setDbValue("");
		}
	}

	// Render row
	public function renderRow()
	{
		global $Security, $ReportLanguage, $Language;
		$conn = &$this->getConnection();
		if (!$this->GrandSummarySetup) { // Get Grand total
			$hasCount = FALSE;
			$hasSummary = FALSE;

			// Get total count from SQL directly
			$sql = BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->execute($sql);
			if ($rstot) {
				$this->TotalCount = ($rstot->recordCount() > 1) ? $rstot->recordCount() : $rstot->fields[0];
				$rstot->close();
				$hasCount = TRUE;
			} else {
				$this->TotalCount = 0;
			}

			// Get total from SQL directly
			$sql = BuildReportSql($this->getSqlSelectAggregate(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$sql = $this->getSqlAggregatePrefix() . $sql . $this->getSqlAggregateSuffix();
			$rsagg = $conn->execute($sql);
			if ($rsagg) {
				$this->GrandCounts[1] = $this->TotalCount;
				$this->GrandCounts[2] = $this->TotalCount;
				$this->GrandCounts[3] = $this->TotalCount;
				$this->GrandSummaries[3] = $rsagg->fields("sum_datang_jumlah");
				$this->GrandCounts[4] = $this->TotalCount;
				$this->GrandCounts[5] = $this->TotalCount;
				$this->GrandSummaries[5] = $rsagg->fields("sum_datang_terpakai");
				$this->GrandCounts[6] = $this->TotalCount;
				$this->GrandCounts[7] = $this->TotalCount;
				$this->GrandCounts[8] = $this->TotalCount;
				$this->GrandCounts[9] = $this->TotalCount;
				$this->GrandCounts[10] = $this->TotalCount;
				$this->GrandCounts[11] = $this->TotalCount;
				$this->GrandCounts[12] = $this->TotalCount;
				$this->GrandCounts[13] = $this->TotalCount;
				$this->GrandCounts[14] = $this->TotalCount;
				$this->GrandCounts[15] = $this->TotalCount;
				$this->GrandSummaries[15] = $rsagg->fields("sum_ver_presentasi_rijek");
				$this->GrandCounts[16] = $this->TotalCount;
				$this->GrandCounts[17] = $this->TotalCount;
				$this->GrandCounts[18] = $this->TotalCount;
				$rsagg->close();
				$hasSummary = TRUE;
			}

			// Accumulate grand summary from detail records
			if (!$hasCount || !$hasSummary) {
				$sql = BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$this->Recordset = $conn->execute($sql);
				if ($this->Recordset) {
					$this->loadRowValues(TRUE);
					while (!$this->Recordset->EOF) {
						$this->accumulateGrandSummary();
						$this->loadRowValues();
					}
					$this->Recordset->close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();
		if ($this->RowType == ROWTYPE_SEARCH) { // Search row
			$ar = [];
			if (is_array($this->ds_nama->AdvancedFilters)) {
				foreach ($this->ds_nama->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->ds_nama->DropDownList)) {
				foreach ($this->ds_nama->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->ds_nama->EditValue = $ar;
			$this->ds_nama->AdvancedSearch->SearchValue = is_array($this->ds_nama->DropDownValue) ? implode(",", $this->ds_nama->DropDownValue) : $this->ds_nama->DropDownValue;
			$ar = [];
			if (is_array($this->var_nama->AdvancedFilters)) {
				foreach ($this->var_nama->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->var_nama->DropDownList)) {
				foreach ($this->var_nama->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->var_nama->EditValue = $ar;
			$this->var_nama->AdvancedSearch->SearchValue = is_array($this->var_nama->DropDownValue) ? implode(",", $this->var_nama->DropDownValue) : $this->var_nama->DropDownValue;
			$ar = [];
			if (is_array($this->sup_nama->AdvancedFilters)) {
				foreach ($this->sup_nama->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->sup_nama->DropDownList)) {
				foreach ($this->sup_nama->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->sup_nama->EditValue = $ar;
			$this->sup_nama->AdvancedSearch->SearchValue = is_array($this->sup_nama->DropDownValue) ? implode(",", $this->sup_nama->DropDownValue) : $this->sup_nama->DropDownValue;
			$ar = [];
			if (is_array($this->pet_nama->AdvancedFilters)) {
				foreach ($this->pet_nama->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->pet_nama->DropDownList)) {
				foreach ($this->pet_nama->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->pet_nama->EditValue = $ar;
			$this->pet_nama->AdvancedSearch->SearchValue = is_array($this->pet_nama->DropDownValue) ? implode(",", $this->pet_nama->DropDownValue) : $this->pet_nama->DropDownValue;
			$ar = [];
			if (is_array($this->co_nama->AdvancedFilters)) {
				foreach ($this->co_nama->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->co_nama->DropDownList)) {
				foreach ($this->co_nama->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->co_nama->EditValue = $ar;
			$this->co_nama->AdvancedSearch->SearchValue = is_array($this->co_nama->DropDownValue) ? implode(",", $this->co_nama->DropDownValue) : $this->co_nama->DropDownValue;
			$ar = [];
			if (is_array($this->k_id_kontrak->AdvancedFilters)) {
				foreach ($this->k_id_kontrak->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->k_id_kontrak->DropDownList)) {
				foreach ($this->k_id_kontrak->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->k_id_kontrak->EditValue = $ar;
			$this->k_id_kontrak->AdvancedSearch->SearchValue = is_array($this->k_id_kontrak->DropDownValue) ? implode(",", $this->k_id_kontrak->DropDownValue) : $this->k_id_kontrak->DropDownValue;
			$ar = [];
			if (is_array($this->ver_hasil_id->AdvancedFilters)) {
				foreach ($this->ver_hasil_id->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->ver_hasil_id->DropDownList)) {
				foreach ($this->ver_hasil_id->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->ver_hasil_id->EditValue = $ar;
			$this->ver_hasil_id->AdvancedSearch->SearchValue = is_array($this->ver_hasil_id->DropDownValue) ? implode(",", $this->ver_hasil_id->DropDownValue) : $this->ver_hasil_id->DropDownValue;
			$ar = [];
			if (is_array($this->qc_nama->AdvancedFilters)) {
				foreach ($this->qc_nama->AdvancedFilters as $filter)
					if ($filter->Enabled)
						$ar[] = [$filter->ID, $filter->Name];
			}
			if (is_array($this->qc_nama->DropDownList)) {
				foreach ($this->qc_nama->DropDownList as $val)
					$ar[] = [$val, GetDropDownDisplayValue($val, "", 0)];
			}
			$this->qc_nama->EditValue = $ar;
			$this->qc_nama->AdvancedSearch->SearchValue = is_array($this->qc_nama->DropDownValue) ? implode(",", $this->qc_nama->DropDownValue) : $this->qc_nama->DropDownValue;
		} elseif ($this->RowType == ROWTYPE_TOTAL && !($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER)) { // Summary row
			PrependClass($this->RowAttrs["class"], ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class

			// datang_jumlah
			$this->datang_jumlah->SumViewValue = $this->datang_jumlah->SumValue;
			$this->datang_jumlah->SumViewValue = FormatNumber($this->datang_jumlah->SumViewValue, 0, -1, -2, -2);
			$this->datang_jumlah->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// datang_terpakai
			$this->datang_terpakai->SumViewValue = $this->datang_terpakai->SumValue;
			$this->datang_terpakai->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->AvgViewValue = $this->ver_presentasi_rijek->AvgValue;
			$this->ver_presentasi_rijek->AvgViewValue = FormatNumber($this->ver_presentasi_rijek->AvgViewValue, $this->ver_presentasi_rijek->DefaultDecimalPrecision, -1, 0, 0);
			$this->ver_presentasi_rijek->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

			// datang_id
			$this->datang_id->HrefValue = "";

			// datang_tgl
			$this->datang_tgl->HrefValue = "";

			// datang_jumlah
			$this->datang_jumlah->HrefValue = "";

			// ds_nama
			$this->ds_nama->HrefValue = "";

			// datang_terpakai
			$this->datang_terpakai->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// sup_nama
			$this->sup_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";

			// co_nama
			$this->co_nama->HrefValue = "";

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->HrefValue = "";

			// k_es_qty
			$this->k_es_qty->HrefValue = "";

			// ver_tgl
			$this->ver_tgl->HrefValue = "";

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->HrefValue = "";

			// ver_hasil_id
			$this->ver_hasil_id->HrefValue = "";

			// qc_nama
			$this->qc_nama->HrefValue = "";

			// ver_catatan
			$this->ver_catatan->HrefValue = "";
		} else {
			if ($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER) {
			} else {
			}

			// datang_id
			$this->datang_id->ViewValue = $this->datang_id->CurrentValue;
			$this->datang_id->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// datang_tgl
			$this->datang_tgl->ViewValue = $this->datang_tgl->CurrentValue;
			$this->datang_tgl->ViewValue = FormatDateTime($this->datang_tgl->ViewValue, 0);
			$this->datang_tgl->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// datang_jumlah
			$this->datang_jumlah->ViewValue = $this->datang_jumlah->CurrentValue;
			$this->datang_jumlah->ViewValue = FormatNumber($this->datang_jumlah->ViewValue, 0, -1, -2, -2);
			$this->datang_jumlah->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// ds_nama
			$this->ds_nama->ViewValue = $this->ds_nama->CurrentValue;
			$this->ds_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// datang_terpakai
			$this->datang_terpakai->ViewValue = $this->datang_terpakai->CurrentValue;
			$this->datang_terpakai->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// var_nama
			$this->var_nama->ViewValue = $this->var_nama->CurrentValue;
			$this->var_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// sup_nama
			$this->sup_nama->ViewValue = $this->sup_nama->CurrentValue;
			$this->sup_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// pet_nama
			$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
			$this->pet_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// co_nama
			$this->co_nama->ViewValue = $this->co_nama->CurrentValue;
			$this->co_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_id_kontrak
			$this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;
			$this->k_id_kontrak->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_luas_lahan
			$this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
			$this->k_luas_lahan->ViewValue = FormatNumber($this->k_luas_lahan->ViewValue, 0, -1, -2, -2);
			$this->k_luas_lahan->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_es_tgl_panen
			$this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
			$this->k_es_tgl_panen->ViewValue = FormatDateTime($this->k_es_tgl_panen->ViewValue, 0);
			$this->k_es_tgl_panen->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// k_es_qty
			$this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;
			$this->k_es_qty->ViewValue = FormatNumber($this->k_es_qty->ViewValue, 0, -1, -2, -2);
			$this->k_es_qty->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// ver_tgl
			$this->ver_tgl->ViewValue = $this->ver_tgl->CurrentValue;
			$this->ver_tgl->ViewValue = FormatDateTime($this->ver_tgl->ViewValue, 0);
			$this->ver_tgl->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->ViewValue = $this->ver_presentasi_rijek->CurrentValue;
			$this->ver_presentasi_rijek->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// ver_hasil_id
			$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->CurrentValue;
			$this->ver_hasil_id->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// qc_nama
			$this->qc_nama->ViewValue = $this->qc_nama->CurrentValue;
			$this->qc_nama->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// ver_catatan
			$this->ver_catatan->ViewValue = $this->ver_catatan->CurrentValue;
			$this->ver_catatan->CellAttrs["class"] = ($this->RecordCount % 2 <> 1 ? "ew-table-alt-row" : "ew-table-row");

			// datang_id
			$this->datang_id->HrefValue = "";

			// datang_tgl
			$this->datang_tgl->HrefValue = "";

			// datang_jumlah
			$this->datang_jumlah->HrefValue = "";

			// ds_nama
			$this->ds_nama->HrefValue = "";

			// datang_terpakai
			$this->datang_terpakai->HrefValue = "";

			// var_nama
			$this->var_nama->HrefValue = "";

			// sup_nama
			$this->sup_nama->HrefValue = "";

			// pet_nama
			$this->pet_nama->HrefValue = "";

			// co_nama
			$this->co_nama->HrefValue = "";

			// k_id_kontrak
			$this->k_id_kontrak->HrefValue = "";

			// k_luas_lahan
			$this->k_luas_lahan->HrefValue = "";

			// k_es_tgl_panen
			$this->k_es_tgl_panen->HrefValue = "";

			// k_es_qty
			$this->k_es_qty->HrefValue = "";

			// ver_tgl
			$this->ver_tgl->HrefValue = "";

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->HrefValue = "";

			// ver_hasil_id
			$this->ver_hasil_id->HrefValue = "";

			// qc_nama
			$this->qc_nama->HrefValue = "";

			// ver_catatan
			$this->ver_catatan->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == ROWTYPE_TOTAL) { // Summary row

			// datang_jumlah
			$currentValue = $this->datang_jumlah->SumValue;
			$viewValue = &$this->datang_jumlah->SumViewValue;
			$viewAttrs = &$this->datang_jumlah->ViewAttrs;
			$cellAttrs = &$this->datang_jumlah->CellAttrs;
			$hrefValue = &$this->datang_jumlah->HrefValue;
			$linkAttrs = &$this->datang_jumlah->LinkAttrs;
			$this->Cell_Rendered($this->datang_jumlah, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// datang_terpakai
			$currentValue = $this->datang_terpakai->SumValue;
			$viewValue = &$this->datang_terpakai->SumViewValue;
			$viewAttrs = &$this->datang_terpakai->ViewAttrs;
			$cellAttrs = &$this->datang_terpakai->CellAttrs;
			$hrefValue = &$this->datang_terpakai->HrefValue;
			$linkAttrs = &$this->datang_terpakai->LinkAttrs;
			$this->Cell_Rendered($this->datang_terpakai, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// ver_presentasi_rijek
			$currentValue = $this->ver_presentasi_rijek->AvgValue;
			$viewValue = &$this->ver_presentasi_rijek->AvgViewValue;
			$viewAttrs = &$this->ver_presentasi_rijek->ViewAttrs;
			$cellAttrs = &$this->ver_presentasi_rijek->CellAttrs;
			$hrefValue = &$this->ver_presentasi_rijek->HrefValue;
			$linkAttrs = &$this->ver_presentasi_rijek->LinkAttrs;
			$this->Cell_Rendered($this->ver_presentasi_rijek, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
		} else {

			// datang_id
			$currentValue = $this->datang_id->CurrentValue;
			$viewValue = &$this->datang_id->ViewValue;
			$viewAttrs = &$this->datang_id->ViewAttrs;
			$cellAttrs = &$this->datang_id->CellAttrs;
			$hrefValue = &$this->datang_id->HrefValue;
			$linkAttrs = &$this->datang_id->LinkAttrs;
			$this->Cell_Rendered($this->datang_id, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// datang_tgl
			$currentValue = $this->datang_tgl->CurrentValue;
			$viewValue = &$this->datang_tgl->ViewValue;
			$viewAttrs = &$this->datang_tgl->ViewAttrs;
			$cellAttrs = &$this->datang_tgl->CellAttrs;
			$hrefValue = &$this->datang_tgl->HrefValue;
			$linkAttrs = &$this->datang_tgl->LinkAttrs;
			$this->Cell_Rendered($this->datang_tgl, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// datang_jumlah
			$currentValue = $this->datang_jumlah->CurrentValue;
			$viewValue = &$this->datang_jumlah->ViewValue;
			$viewAttrs = &$this->datang_jumlah->ViewAttrs;
			$cellAttrs = &$this->datang_jumlah->CellAttrs;
			$hrefValue = &$this->datang_jumlah->HrefValue;
			$linkAttrs = &$this->datang_jumlah->LinkAttrs;
			$this->Cell_Rendered($this->datang_jumlah, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// ds_nama
			$currentValue = $this->ds_nama->CurrentValue;
			$viewValue = &$this->ds_nama->ViewValue;
			$viewAttrs = &$this->ds_nama->ViewAttrs;
			$cellAttrs = &$this->ds_nama->CellAttrs;
			$hrefValue = &$this->ds_nama->HrefValue;
			$linkAttrs = &$this->ds_nama->LinkAttrs;
			$this->Cell_Rendered($this->ds_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// datang_terpakai
			$currentValue = $this->datang_terpakai->CurrentValue;
			$viewValue = &$this->datang_terpakai->ViewValue;
			$viewAttrs = &$this->datang_terpakai->ViewAttrs;
			$cellAttrs = &$this->datang_terpakai->CellAttrs;
			$hrefValue = &$this->datang_terpakai->HrefValue;
			$linkAttrs = &$this->datang_terpakai->LinkAttrs;
			$this->Cell_Rendered($this->datang_terpakai, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// var_nama
			$currentValue = $this->var_nama->CurrentValue;
			$viewValue = &$this->var_nama->ViewValue;
			$viewAttrs = &$this->var_nama->ViewAttrs;
			$cellAttrs = &$this->var_nama->CellAttrs;
			$hrefValue = &$this->var_nama->HrefValue;
			$linkAttrs = &$this->var_nama->LinkAttrs;
			$this->Cell_Rendered($this->var_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// sup_nama
			$currentValue = $this->sup_nama->CurrentValue;
			$viewValue = &$this->sup_nama->ViewValue;
			$viewAttrs = &$this->sup_nama->ViewAttrs;
			$cellAttrs = &$this->sup_nama->CellAttrs;
			$hrefValue = &$this->sup_nama->HrefValue;
			$linkAttrs = &$this->sup_nama->LinkAttrs;
			$this->Cell_Rendered($this->sup_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// pet_nama
			$currentValue = $this->pet_nama->CurrentValue;
			$viewValue = &$this->pet_nama->ViewValue;
			$viewAttrs = &$this->pet_nama->ViewAttrs;
			$cellAttrs = &$this->pet_nama->CellAttrs;
			$hrefValue = &$this->pet_nama->HrefValue;
			$linkAttrs = &$this->pet_nama->LinkAttrs;
			$this->Cell_Rendered($this->pet_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// co_nama
			$currentValue = $this->co_nama->CurrentValue;
			$viewValue = &$this->co_nama->ViewValue;
			$viewAttrs = &$this->co_nama->ViewAttrs;
			$cellAttrs = &$this->co_nama->CellAttrs;
			$hrefValue = &$this->co_nama->HrefValue;
			$linkAttrs = &$this->co_nama->LinkAttrs;
			$this->Cell_Rendered($this->co_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_id_kontrak
			$currentValue = $this->k_id_kontrak->CurrentValue;
			$viewValue = &$this->k_id_kontrak->ViewValue;
			$viewAttrs = &$this->k_id_kontrak->ViewAttrs;
			$cellAttrs = &$this->k_id_kontrak->CellAttrs;
			$hrefValue = &$this->k_id_kontrak->HrefValue;
			$linkAttrs = &$this->k_id_kontrak->LinkAttrs;
			$this->Cell_Rendered($this->k_id_kontrak, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_luas_lahan
			$currentValue = $this->k_luas_lahan->CurrentValue;
			$viewValue = &$this->k_luas_lahan->ViewValue;
			$viewAttrs = &$this->k_luas_lahan->ViewAttrs;
			$cellAttrs = &$this->k_luas_lahan->CellAttrs;
			$hrefValue = &$this->k_luas_lahan->HrefValue;
			$linkAttrs = &$this->k_luas_lahan->LinkAttrs;
			$this->Cell_Rendered($this->k_luas_lahan, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_es_tgl_panen
			$currentValue = $this->k_es_tgl_panen->CurrentValue;
			$viewValue = &$this->k_es_tgl_panen->ViewValue;
			$viewAttrs = &$this->k_es_tgl_panen->ViewAttrs;
			$cellAttrs = &$this->k_es_tgl_panen->CellAttrs;
			$hrefValue = &$this->k_es_tgl_panen->HrefValue;
			$linkAttrs = &$this->k_es_tgl_panen->LinkAttrs;
			$this->Cell_Rendered($this->k_es_tgl_panen, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// k_es_qty
			$currentValue = $this->k_es_qty->CurrentValue;
			$viewValue = &$this->k_es_qty->ViewValue;
			$viewAttrs = &$this->k_es_qty->ViewAttrs;
			$cellAttrs = &$this->k_es_qty->CellAttrs;
			$hrefValue = &$this->k_es_qty->HrefValue;
			$linkAttrs = &$this->k_es_qty->LinkAttrs;
			$this->Cell_Rendered($this->k_es_qty, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// ver_tgl
			$currentValue = $this->ver_tgl->CurrentValue;
			$viewValue = &$this->ver_tgl->ViewValue;
			$viewAttrs = &$this->ver_tgl->ViewAttrs;
			$cellAttrs = &$this->ver_tgl->CellAttrs;
			$hrefValue = &$this->ver_tgl->HrefValue;
			$linkAttrs = &$this->ver_tgl->LinkAttrs;
			$this->Cell_Rendered($this->ver_tgl, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// ver_presentasi_rijek
			$currentValue = $this->ver_presentasi_rijek->CurrentValue;
			$viewValue = &$this->ver_presentasi_rijek->ViewValue;
			$viewAttrs = &$this->ver_presentasi_rijek->ViewAttrs;
			$cellAttrs = &$this->ver_presentasi_rijek->CellAttrs;
			$hrefValue = &$this->ver_presentasi_rijek->HrefValue;
			$linkAttrs = &$this->ver_presentasi_rijek->LinkAttrs;
			$this->Cell_Rendered($this->ver_presentasi_rijek, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// ver_hasil_id
			$currentValue = $this->ver_hasil_id->CurrentValue;
			$viewValue = &$this->ver_hasil_id->ViewValue;
			$viewAttrs = &$this->ver_hasil_id->ViewAttrs;
			$cellAttrs = &$this->ver_hasil_id->CellAttrs;
			$hrefValue = &$this->ver_hasil_id->HrefValue;
			$linkAttrs = &$this->ver_hasil_id->LinkAttrs;
			$this->Cell_Rendered($this->ver_hasil_id, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// qc_nama
			$currentValue = $this->qc_nama->CurrentValue;
			$viewValue = &$this->qc_nama->ViewValue;
			$viewAttrs = &$this->qc_nama->ViewAttrs;
			$cellAttrs = &$this->qc_nama->CellAttrs;
			$hrefValue = &$this->qc_nama->HrefValue;
			$linkAttrs = &$this->qc_nama->LinkAttrs;
			$this->Cell_Rendered($this->qc_nama, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

			// ver_catatan
			$currentValue = $this->ver_catatan->CurrentValue;
			$viewValue = &$this->ver_catatan->ViewValue;
			$viewAttrs = &$this->ver_catatan->ViewAttrs;
			$cellAttrs = &$this->ver_catatan->CellAttrs;
			$hrefValue = &$this->ver_catatan->HrefValue;
			$linkAttrs = &$this->ver_catatan->LinkAttrs;
			$this->Cell_Rendered($this->ver_catatan, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->setupFieldCount();
	}

	// Accummulate grand summary
	protected function accumulateGrandSummary()
	{
		$this->TotalCount++;
		$cntgs = count($this->GrandSummaries);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Columns[$iy][0]) {
				$valwrk = $this->Values[$iy];
				if ($valwrk === NULL || !is_numeric($valwrk)) {
					if (!$this->Columns[$iy][1])
						$this->GrandCounts[$iy]++;
				} else {
					if (!$this->Columns[$iy][1] || $valwrk <> 0) {
						$this->GrandCounts[$iy]++;
						$this->GrandSummaries[$iy] += $valwrk;
						if ($this->GrandMinimums[$iy] === NULL) {
							$this->GrandMinimums[$iy] = $valwrk;
							$this->GrandMaximums[$iy] = $valwrk;
						} else {
							if ($this->GrandMinimums[$iy] > $valwrk)
								$this->GrandMinimums[$iy] = $valwrk;
							if ($this->GrandMaximums[$iy] < $valwrk)
								$this->GrandMaximums[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Load group db values if necessary
	protected function loadGroupDbValues()
	{
		$conn = &$this->getConnection();
	}

	// Set up popup
	protected function setupPopup()
	{
		global $ReportLanguage;
		$conn = &$this->getConnection();
		if ($this->DrillDown)
			return;

		// Process post back form
		if (IsPost()) {
			$name = Post("popup", ""); // Get popup form name
			if ($name <> "") {
				$arValues = Post("sel_$name");
				$cntValues = is_array($arValues) ? count($arValues) : 0;
				if ($cntValues > 0) {
					if (trim($arValues[0]) == "") // Select all
						$arValues = INIT_VALUE;
					$this->PopupName = $name;
					if (IsAdvancedFilterValue($arValues) || $arValues == INIT_VALUE)
						$this->PopupValue = $arValues;
					if (!MatchedArray($arValues, @$_SESSION["sel_$name"])) {
						if ($this->hasSessionFilterValues($name))
							$this->ExpiredExtendedFilter = $name; // Clear extended filter for this field
					}
					$_SESSION["sel_$name"] = $arValues;
					$_SESSION["rf_$name"] = Post("rf_$name", "");
					$_SESSION["rt_$name"] = Post("rt_$name", "");
					$this->resetPager();
				}
			}

		// Get 'reset' command
		} elseif (Get("cmd") !== NULL) {
			$cmd = Get("cmd");
			if (SameText($cmd, "reset")) {
				$this->clearSessionSelection("qc_nama");
				$this->resetPager();
			}
		}

		// Load selection criteria to array
		// Get qc_nama selected values

		if (is_array(@$_SESSION["sel_Kedatangan_Dan_Verifikasi_qc_nama"])) {
			$this->loadSelectionFromSession("qc_nama");
		} elseif (@$_SESSION["sel_Kedatangan_Dan_Verifikasi_qc_nama"] == INIT_VALUE) { // Select all
			$this->qc_nama->SelectionList = "";
		}
	}

	// Setup field count
	protected function setupFieldCount()
	{
		$this->GroupColumnCount = 0;
		$this->SubGroupColumnCount = 0;
		$this->DetailColumnCount = 0;
		if ($this->datang_id->Visible)
			$this->DetailColumnCount += 1;
		if ($this->datang_tgl->Visible)
			$this->DetailColumnCount += 1;
		if ($this->datang_jumlah->Visible)
			$this->DetailColumnCount += 1;
		if ($this->ds_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->datang_terpakai->Visible)
			$this->DetailColumnCount += 1;
		if ($this->var_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->sup_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->pet_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->co_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_id_kontrak->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_luas_lahan->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_es_tgl_panen->Visible)
			$this->DetailColumnCount += 1;
		if ($this->k_es_qty->Visible)
			$this->DetailColumnCount += 1;
		if ($this->ver_tgl->Visible)
			$this->DetailColumnCount += 1;
		if ($this->ver_presentasi_rijek->Visible)
			$this->DetailColumnCount += 1;
		if ($this->ver_hasil_id->Visible)
			$this->DetailColumnCount += 1;
		if ($this->qc_nama->Visible)
			$this->DetailColumnCount += 1;
		if ($this->ver_catatan->Visible)
			$this->DetailColumnCount += 1;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/") + 1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', "", $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("summary", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Set up export options (extended)
	protected function setupExportOptionsExt()
	{
		global $ReportLanguage, $ReportOptions;
		$reportTypes = $ReportOptions["ReportTypes"];
		$item = &$this->ExportOptions->getItem("pdf");
		$item->Visible = TRUE;
		if ($item->Visible)
			$reportTypes["pdf"] = $ReportLanguage->phrase("ReportFormPdf");
		$item->Body = "<a class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . HtmlEncode($ReportLanguage->phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ew.exportWithCharts(event, '" . $this->ExportPdfUrl . "', '" . session_id() . "');\">" . $ReportLanguage->phrase("ExportToPDF") . "</a>";
		$ReportOptions["ReportTypes"] = $reportTypes;
	}

	// Export to HTML
	public function exportHtml($html)
	{

		//global $ExportFileName;
		//header('Content-Type: text/html' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
		//header('Content-Disposition: attachment; filename=' . $ExportFileName . '.html');

		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";

		// Save generate file for print
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
			$baseTag = "<base href=\"" . BaseUrl() . "\">";
			$html = preg_replace('/<head>/', '<head>' . $baseTag, $html);
			SaveFile($folder, $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file")
			Write($html);
		return $saveToFile;
	}

	// Export to Word
	public function exportWord($html)
	{
		global $ExportFileName;
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	SaveFile(ServerMapPath($folder), $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			AddHeader('Content-Type', 'application/vnd.ms-word' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
			AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.doc');
			Write($html);
		}
		return $saveToFile;
	}

	// Export to Excel
	public function exportExcel($html)
	{
		global $ExportFileName;
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	SaveFile(ServerMapPath($folder), $fileName, $html);
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			AddHeader('Content-Type', 'application/vnd.ms-excel' . (PROJECT_CHARSET <> '' ? ';charset=' . PROJECT_CHARSET : ''));
			AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.xls');
			Write($html);
		}
		return $saveToFile;
	}

	// Export PDF
	public function exportPdf($html)
	{
		global $ExportFileName, $PDF_MEMORY_LIMIT, $PDF_TIME_LIMIT, $PDF_IMAGE_SCALE_FACTOR;
		@ini_set("memory_limit", $PDF_MEMORY_LIMIT);
		set_time_limit($PDF_TIME_LIMIT);
		$html = CheckHtml($html);
		if (DEBUG_ENABLED) // Add debug message
			$html = str_replace("</body>", GetDebugMessage() . "</body>", $html);
		$dompdf = new \Dompdf\Dompdf(["pdf_backend" => "Cpdf"]);
		$doc = new \DOMDocument("1.0", "utf-8");
		@$doc->loadHTML('<?xml encoding="uft-8">' . ConvertToUtf8($html)); // Convert to utf-8
		$spans = $doc->getElementsByTagName("span");
		foreach ($spans as $span) {
			$classNames = $span->getAttribute("class");
			if ($classNames == "ew-filter-caption") // Insert colon
				$span->parentNode->insertBefore($doc->createElement("span", ":&nbsp;"), $span->nextSibling);
			elseif (preg_match('/\bicon\-\w+\b/', $classNames)) // Remove icons
				$span->parentNode->removeChild($span);
		}
		$images = $doc->getElementsByTagName("img");
		$pageSize = "a4";
		$pageOrientation = "portrait";
		$this->ExportPageOrientation = $pageOrientation;
		$portrait = SameText($pageOrientation, "portrait");
		foreach ($images as $image) {
			$imagefn = $image->getAttribute("src");
			if (file_exists($imagefn)) {
				$imagefn = realpath($imagefn);
				$size = getimagesize($imagefn); // Get image size
				if ($size[0] <> 0) {
					if (SameText($pageSize, "letter")) { // Letter paper (8.5 in. by 11 in.)
						$w = $portrait ? 216 : 279;
					} elseif (SameText($pageSize, "legal")) { // Legal paper (8.5 in. by 14 in.)
						$w = $portrait ? 216 : 356;
					} else {
						$w = $portrait ? 210 : 297; // A4 paper (210 mm by 297 mm)
					}
					$w = min($size[0], ($w - 20 * 2) / 25.4 * 72 * $PDF_IMAGE_SCALE_FACTOR); // Resize image, adjust the scale factor if necessary
					$h = $w / $size[0] * $size[1];
					$image->setAttribute("width", $w);
					$image->setAttribute("height", $h);
				}
			}
		}
		$html = $doc->saveHTML();
		$html = ConvertFromUtf8($html);
		$dompdf->load_html($html);
		$dompdf->set_paper($pageSize, $pageOrientation);
		$dompdf->render();
		$folder = ReportParam("folder", "");
		$fileName = ReportParam("filename", "");
		$responseType = ReportParam("responsetype", "");
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && REPORT_SAVE_OUTPUT_ON_SERVER)) {
			SaveFile(ServerMapPath($folder), $fileName, $dompdf->output());
			$saveToFile = UploadPath(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			AddHeader('Set-Cookie', 'fileDownload=true; path=/');
			$exportFile = EndsText(".pdf", $ExportFileName) ? $ExportFileName : $ExportFileName . ".pdf";
			$dompdf->stream($exportFile, ["Attachment" => 1]); // 0 to open in browser, 1 to download
		}
		DeleteTempImages($html);
		return $saveToFile;
	}

	// Set up starting group
	protected function setupStartGroup()
	{

		// Exit if no groups
		if ($this->DisplayGroups == 0)
			return;
		$startGrp = ReportParam(TABLE_START_GROUP, "");
		$pageNo = ReportParam("pageno", "");

		// Check for a 'start' parameter
		if ($startGrp != "") {
			$this->StartGroup = $startGrp;
			$this->setStartGroup($this->StartGroup);
		} elseif ($pageNo != "") {
			if (is_numeric($pageNo)) {
				$this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
				if ($this->StartGroup <= 0) {
					$this->StartGroup = 1;
				} elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
					$this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
				}
				$this->setStartGroup($this->StartGroup);
			} else {
				$this->StartGroup = $this->getStartGroup();
			}
		} else {
			$this->StartGroup = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGroup) || $this->StartGroup == "") { // Avoid invalid start group counter
			$this->StartGroup = 1; // Reset start group counter
			$this->setStartGroup($this->StartGroup);
		} elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
			$this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
			$this->setStartGroup($this->StartGroup);
		} elseif (($this->StartGroup-1) % $this->DisplayGroups <> 0) {
			$this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
			$this->setStartGroup($this->StartGroup);
		}
	}

	// Reset pager
	protected function resetPager()
	{

		// Reset start position (reset command)
		$this->StartGroup = 1;
		$this->setStartGroup($this->StartGroup);
	}

	// Set up number of groups displayed per page
	protected function setupDisplayGroups()
	{
		if (ReportParam(TABLE_GROUP_PER_PAGE) !== NULL) {
			$wrk = ReportParam(TABLE_GROUP_PER_PAGE);
			if (is_numeric($wrk)) {
				$this->DisplayGroups = intval($wrk);
			} else {
				if (strtoupper($wrk) == "ALL") { // Display all groups
					$this->DisplayGroups = -1;
				} else {
					$this->DisplayGroups = 50; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGroups); // Save to session

			// Reset start position (reset command)
			$this->StartGroup = 1;
			$this->setStartGroup($this->StartGroup);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGroups = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGroups = 50; // Load default
			}
		}
	}

	// Get sort parameters based on sort links clicked
	protected function getSort()
	{
		if ($this->DrillDown)
			return "`datang_tgl` DESC, `ver_tgl` DESC";
		$resetSort = ReportParam("cmd") === "resetsort";
		$orderBy = ReportParam("order", "");
		$orderType = ReportParam("ordertype", "");

		// Check for a resetsort command
		if ($resetSort) {
			$this->setOrderBy("");
			$this->setStartGroup(1);
			$this->datang_id->setSort("");
			$this->datang_tgl->setSort("");
			$this->datang_jumlah->setSort("");
			$this->ds_nama->setSort("");
			$this->datang_terpakai->setSort("");
			$this->var_nama->setSort("");
			$this->sup_nama->setSort("");
			$this->pet_nama->setSort("");
			$this->co_nama->setSort("");
			$this->k_id_kontrak->setSort("");
			$this->k_luas_lahan->setSort("");
			$this->k_es_tgl_panen->setSort("");
			$this->k_es_qty->setSort("");
			$this->ver_tgl->setSort("");
			$this->ver_presentasi_rijek->setSort("");
			$this->ver_hasil_id->setSort("");
			$this->qc_nama->setSort("");
			$this->ver_catatan->setSort("");

		// Check for an Order parameter
		} elseif ($orderBy <> "") {
			$this->CurrentOrder = $orderBy;
			$this->CurrentOrderType = $orderType;
			$sortSql = $this->sortSql();
			$this->setOrderBy($sortSql);
			$this->setStartGroup(1);
		}

		// Set up default sort
		if ($this->getOrderBy() == "") {
			$this->setOrderBy("`datang_tgl` DESC, `ver_tgl` DESC");
			$this->datang_tgl->setSort("DESC");
			$this->ver_tgl->setSort("DESC");
		}
		return $this->getOrderBy();
	}

	// Return extended filter
	protected function getExtendedFilter()
	{
		global $FormError;
		$filter = "";
		if ($this->DrillDown)
			return "";
		$postBack = IsPost();
		$restoreSession = TRUE;
		$setupFilter = FALSE;

		// Reset extended filter if filter changed
		if ($postBack) {

			// Set/clear dropdown for field qc_nama
			if ($this->PopupName == "Kedatangan_Dan_Verifikasi_qc_nama" && $this->PopupValue <> "") {
				if ($this->PopupValue == INIT_VALUE)
					$this->qc_nama->DropDownValue = ALL_VALUE;
				else
					$this->qc_nama->DropDownValue = $this->PopupValue;
				$restoreSession = FALSE; // Do not restore
			} elseif ($this->ExpiredExtendedFilter == "Kedatangan_Dan_Verifikasi_qc_nama") {
				$this->setSessionDropDownValue(INIT_VALUE, "", "qc_nama");
			}

		// Reset search command
		} elseif (Get("cmd", "") == "reset") {

			// Load default values
			$this->setSessionFilterValues($this->datang_tgl->AdvancedSearch->SearchValue, $this->datang_tgl->AdvancedSearch->SearchOperator, $this->datang_tgl->AdvancedSearch->SearchCondition, $this->datang_tgl->AdvancedSearch->SearchValue2, $this->datang_tgl->AdvancedSearch->SearchOperator2, "datang_tgl"); // Field datang_tgl
			$this->setSessionDropDownValue($this->ds_nama->DropDownValue, $this->ds_nama->AdvancedSearch->SearchOperator, "ds_nama"); // Field ds_nama
			$this->setSessionDropDownValue($this->var_nama->DropDownValue, $this->var_nama->AdvancedSearch->SearchOperator, "var_nama"); // Field var_nama
			$this->setSessionDropDownValue($this->sup_nama->DropDownValue, $this->sup_nama->AdvancedSearch->SearchOperator, "sup_nama"); // Field sup_nama
			$this->setSessionDropDownValue($this->pet_nama->DropDownValue, $this->pet_nama->AdvancedSearch->SearchOperator, "pet_nama"); // Field pet_nama
			$this->setSessionDropDownValue($this->co_nama->DropDownValue, $this->co_nama->AdvancedSearch->SearchOperator, "co_nama"); // Field co_nama
			$this->setSessionDropDownValue($this->k_id_kontrak->DropDownValue, $this->k_id_kontrak->AdvancedSearch->SearchOperator, "k_id_kontrak"); // Field k_id_kontrak
			$this->setSessionFilterValues($this->k_es_tgl_panen->AdvancedSearch->SearchValue, $this->k_es_tgl_panen->AdvancedSearch->SearchOperator, $this->k_es_tgl_panen->AdvancedSearch->SearchCondition, $this->k_es_tgl_panen->AdvancedSearch->SearchValue2, $this->k_es_tgl_panen->AdvancedSearch->SearchOperator2, "k_es_tgl_panen"); // Field k_es_tgl_panen
			$this->setSessionFilterValues($this->ver_tgl->AdvancedSearch->SearchValue, $this->ver_tgl->AdvancedSearch->SearchOperator, $this->ver_tgl->AdvancedSearch->SearchCondition, $this->ver_tgl->AdvancedSearch->SearchValue2, $this->ver_tgl->AdvancedSearch->SearchOperator2, "ver_tgl"); // Field ver_tgl
			$this->setSessionDropDownValue($this->ver_hasil_id->DropDownValue, $this->ver_hasil_id->AdvancedSearch->SearchOperator, "ver_hasil_id"); // Field ver_hasil_id
			$this->setSessionDropDownValue($this->qc_nama->DropDownValue, $this->qc_nama->AdvancedSearch->SearchOperator, "qc_nama"); // Field qc_nama

			//$setupFilter = TRUE; // No need to set up, just use default
		} else {
			$restoreSession = !$this->SearchCommand;

			// Field datang_tgl
			if ($this->getFilterValues($this->datang_tgl)) {
				$setupFilter = TRUE;
			}

			// Field ds_nama
			if ($this->getDropDownValue($this->ds_nama)) {
				$setupFilter = TRUE;
			} elseif ($this->ds_nama->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Dan_Verifikasi_ds_nama"])) {
				$setupFilter = TRUE;
			}

			// Field var_nama
			if ($this->getDropDownValue($this->var_nama)) {
				$setupFilter = TRUE;
			} elseif ($this->var_nama->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Dan_Verifikasi_var_nama"])) {
				$setupFilter = TRUE;
			}

			// Field sup_nama
			if ($this->getDropDownValue($this->sup_nama)) {
				$setupFilter = TRUE;
			} elseif ($this->sup_nama->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Dan_Verifikasi_sup_nama"])) {
				$setupFilter = TRUE;
			}

			// Field pet_nama
			if ($this->getDropDownValue($this->pet_nama)) {
				$setupFilter = TRUE;
			} elseif ($this->pet_nama->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Dan_Verifikasi_pet_nama"])) {
				$setupFilter = TRUE;
			}

			// Field co_nama
			if ($this->getDropDownValue($this->co_nama)) {
				$setupFilter = TRUE;
			} elseif ($this->co_nama->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Dan_Verifikasi_co_nama"])) {
				$setupFilter = TRUE;
			}

			// Field k_id_kontrak
			if ($this->getDropDownValue($this->k_id_kontrak)) {
				$setupFilter = TRUE;
			} elseif ($this->k_id_kontrak->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Dan_Verifikasi_k_id_kontrak"])) {
				$setupFilter = TRUE;
			}

			// Field k_es_tgl_panen
			if ($this->getFilterValues($this->k_es_tgl_panen)) {
				$setupFilter = TRUE;
			}

			// Field ver_tgl
			if ($this->getFilterValues($this->ver_tgl)) {
				$setupFilter = TRUE;
			}

			// Field ver_hasil_id
			if ($this->getDropDownValue($this->ver_hasil_id)) {
				$setupFilter = TRUE;
			} elseif ($this->ver_hasil_id->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Dan_Verifikasi_ver_hasil_id"])) {
				$setupFilter = TRUE;
			}

			// Field qc_nama
			if ($this->getDropDownValue($this->qc_nama)) {
				$setupFilter = TRUE;
			} elseif ($this->qc_nama->DropDownValue <> INIT_VALUE && !isset($_SESSION["x_Kedatangan_Dan_Verifikasi_qc_nama"])) {
				$setupFilter = TRUE;
			}
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				return $filter;
			}
		}

		// Restore session
		if ($restoreSession) {
			$this->getSessionFilterValues($this->datang_tgl); // Field datang_tgl
			$this->getSessionDropDownValue($this->ds_nama); // Field ds_nama
			$this->getSessionDropDownValue($this->var_nama); // Field var_nama
			$this->getSessionDropDownValue($this->sup_nama); // Field sup_nama
			$this->getSessionDropDownValue($this->pet_nama); // Field pet_nama
			$this->getSessionDropDownValue($this->co_nama); // Field co_nama
			$this->getSessionDropDownValue($this->k_id_kontrak); // Field k_id_kontrak
			$this->getSessionFilterValues($this->k_es_tgl_panen); // Field k_es_tgl_panen
			$this->getSessionFilterValues($this->ver_tgl); // Field ver_tgl
			$this->getSessionDropDownValue($this->ver_hasil_id); // Field ver_hasil_id
			$this->getSessionDropDownValue($this->qc_nama); // Field qc_nama
		}

		// Call page filter validated event
		$this->Page_FilterValidated();

		// Build SQL
		$this->buildExtendedFilter($this->datang_tgl, $filter, FALSE, TRUE); // Field datang_tgl
		$this->buildDropDownFilter($this->ds_nama, $filter, $this->ds_nama->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field ds_nama
		$this->buildDropDownFilter($this->var_nama, $filter, $this->var_nama->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field var_nama
		$this->buildDropDownFilter($this->sup_nama, $filter, $this->sup_nama->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field sup_nama
		$this->buildDropDownFilter($this->pet_nama, $filter, $this->pet_nama->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field pet_nama
		$this->buildDropDownFilter($this->co_nama, $filter, $this->co_nama->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field co_nama
		$this->buildDropDownFilter($this->k_id_kontrak, $filter, $this->k_id_kontrak->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field k_id_kontrak
		$this->buildExtendedFilter($this->k_es_tgl_panen, $filter, FALSE, TRUE); // Field k_es_tgl_panen
		$this->buildExtendedFilter($this->ver_tgl, $filter, FALSE, TRUE); // Field ver_tgl
		$this->buildDropDownFilter($this->ver_hasil_id, $filter, $this->ver_hasil_id->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field ver_hasil_id
		$this->buildDropDownFilter($this->qc_nama, $filter, $this->qc_nama->AdvancedSearch->SearchOperator, FALSE, TRUE); // Field qc_nama

		// Save parms to session
		$this->setSessionFilterValues($this->datang_tgl->AdvancedSearch->SearchValue, $this->datang_tgl->AdvancedSearch->SearchOperator, $this->datang_tgl->AdvancedSearch->SearchCondition, $this->datang_tgl->AdvancedSearch->SearchValue2, $this->datang_tgl->AdvancedSearch->SearchOperator2, "datang_tgl"); // Field datang_tgl
		$this->setSessionDropDownValue($this->ds_nama->DropDownValue, $this->ds_nama->AdvancedSearch->SearchOperator, "ds_nama"); // Field ds_nama
		$this->setSessionDropDownValue($this->var_nama->DropDownValue, $this->var_nama->AdvancedSearch->SearchOperator, "var_nama"); // Field var_nama
		$this->setSessionDropDownValue($this->sup_nama->DropDownValue, $this->sup_nama->AdvancedSearch->SearchOperator, "sup_nama"); // Field sup_nama
		$this->setSessionDropDownValue($this->pet_nama->DropDownValue, $this->pet_nama->AdvancedSearch->SearchOperator, "pet_nama"); // Field pet_nama
		$this->setSessionDropDownValue($this->co_nama->DropDownValue, $this->co_nama->AdvancedSearch->SearchOperator, "co_nama"); // Field co_nama
		$this->setSessionDropDownValue($this->k_id_kontrak->DropDownValue, $this->k_id_kontrak->AdvancedSearch->SearchOperator, "k_id_kontrak"); // Field k_id_kontrak
		$this->setSessionFilterValues($this->k_es_tgl_panen->AdvancedSearch->SearchValue, $this->k_es_tgl_panen->AdvancedSearch->SearchOperator, $this->k_es_tgl_panen->AdvancedSearch->SearchCondition, $this->k_es_tgl_panen->AdvancedSearch->SearchValue2, $this->k_es_tgl_panen->AdvancedSearch->SearchOperator2, "k_es_tgl_panen"); // Field k_es_tgl_panen
		$this->setSessionFilterValues($this->ver_tgl->AdvancedSearch->SearchValue, $this->ver_tgl->AdvancedSearch->SearchOperator, $this->ver_tgl->AdvancedSearch->SearchCondition, $this->ver_tgl->AdvancedSearch->SearchValue2, $this->ver_tgl->AdvancedSearch->SearchOperator2, "ver_tgl"); // Field ver_tgl
		$this->setSessionDropDownValue($this->ver_hasil_id->DropDownValue, $this->ver_hasil_id->AdvancedSearch->SearchOperator, "ver_hasil_id"); // Field ver_hasil_id
		$this->setSessionDropDownValue($this->qc_nama->DropDownValue, $this->qc_nama->AdvancedSearch->SearchOperator, "qc_nama"); // Field qc_nama

		// Setup filter
		if ($setupFilter) {

			// Field qc_nama
			$wrk = "";
			$this->buildDropDownFilter($this->qc_nama, $wrk, $this->qc_nama->AdvancedSearch->SearchOperator);
			LoadSelectionFromFilter($this->qc_nama, $wrk, $this->qc_nama->SelectionList, $this->qc_nama->DropDownValue);
			$_SESSION["sel_Kedatangan_Dan_Verifikasi_qc_nama"] = ($this->qc_nama->SelectionList == "") ? INIT_VALUE : $this->qc_nama->SelectionList;
		}

		// Field ds_nama
		LoadDropDownList($this->ds_nama->DropDownList, $this->ds_nama->DropDownValue);

		// Field var_nama
		LoadDropDownList($this->var_nama->DropDownList, $this->var_nama->DropDownValue);

		// Field sup_nama
		LoadDropDownList($this->sup_nama->DropDownList, $this->sup_nama->DropDownValue);

		// Field pet_nama
		LoadDropDownList($this->pet_nama->DropDownList, $this->pet_nama->DropDownValue);

		// Field co_nama
		LoadDropDownList($this->co_nama->DropDownList, $this->co_nama->DropDownValue);

		// Field k_id_kontrak
		LoadDropDownList($this->k_id_kontrak->DropDownList, $this->k_id_kontrak->DropDownValue);

		// Field ver_hasil_id
		LoadDropDownList($this->ver_hasil_id->DropDownList, $this->ver_hasil_id->DropDownValue);

		// Field qc_nama
		LoadDropDownList($this->qc_nama->DropDownList, $this->qc_nama->DropDownValue);
		return $filter;
	}

	// Build dropdown filter
	protected function buildDropDownFilter(&$fld, &$filterClause, $fldOpr, $default = FALSE, $saveFilter = FALSE)
	{
		$fldVal = ($default) ? $fld->DefaultDropDownValue : $fld->DropDownValue;
		$sql = "";
		if (is_array($fldVal)) {
			foreach ($fldVal as $val) {
				$wrk = $this->getDropDownFilter($fld, $val, $fldOpr);

				// Call Page Filtering event
				if (!StartsString("@@", $val))
					$this->Page_Filtering($fld, $wrk, "dropdown", $fldOpr, $val);
				if ($wrk <> "") {
					if ($sql <> "")
						$sql .= " OR " . $wrk;
					else
						$sql = $wrk;
				}
			}
		} else {
			$sql = $this->getDropDownFilter($fld, $fldVal, $fldOpr);

			// Call Page Filtering event
			if (!StartsString("@@", $fldVal))
				$this->Page_Filtering($fld, $sql, "dropdown", $fldOpr, $fldVal);
		}
		if ($sql <> "") {
			AddFilter($filterClause, $sql);
			if ($saveFilter) $fld->CurrentFilter = $sql;
		}
	}

	// Get dropdown filter
	protected function getDropDownFilter(&$fld, $fldVal, $fldOpr)
	{
		$fldName = $fld->Name;
		$fldExpression = $fld->Expression;
		$fldDataType = $fld->DataType;
		$fldDelimiter = $fld->Delimiter;
		$fldVal = strval($fldVal);
		if ($fldOpr == "") $fldOpr = "=";
		$wrk = "";
		if (SameString($fldVal, NULL_VALUE)) {
			$wrk = $fldExpression . " IS NULL";
		} elseif (SameString($fldVal, NOT_NULL_VALUE)) {
			$wrk = $fldExpression . " IS NOT NULL";
		} elseif (SameString($fldVal, EMPTY_VALUE)) {
			$wrk = $fldExpression . " = ''";
		} elseif (SameString($fldVal, ALL_VALUE)) {
			$wrk = "1 = 1";
		} else {
			if (StartsString("@@", $fldVal)) {
				$wrk = $this->getCustomFilter($fld, $fldVal, $this->Dbid);
			} elseif ($fldDelimiter <> "" && trim($fldVal) <> "" && ($fldDataType == DATATYPE_STRING || $fldDataType == DATATYPE_MEMO)) {
				$wrk = GetMultiValueSearchSql($fldExpression, trim($fldVal), $this->Dbid);
			} else {
				if ($fldVal <> "" && $fldVal <> INIT_VALUE) {
					if ($fldDataType == DATATYPE_DATE && $fldOpr <> "") {
						$wrk = GetDateFilterSql($fldExpression, $fldOpr, $fldVal, $fldDataType, $this->Dbid);
					} else {
						$wrk = GetFilterSql($fldOpr, $fldVal, $fldDataType, $this->Dbid);
						if ($wrk <> "") $wrk = $fldExpression . $wrk;
					}
				}
			}
		}
		return $wrk;
	}

	// Get custom filter
	protected function getCustomFilter(&$fld, $fldVal, $dbid = 0)
	{
		$wrk = "";
		if (is_array($fld->AdvancedFilters)) {
			foreach ($fld->AdvancedFilters as $filter) {
				if ($filter->ID == $fldVal && $filter->Enabled) {
					$fldExpr = $fld->Expression;
					$fn = $filter->FunctionName;
					$wrkid = StartsString("@@", $filter->ID) ? substr($filter->ID, 2) : $filter->ID;
					if ($fn <> "") {
						$fn = PROJECT_NAMESPACE . $fn;
						$wrk = $fn($fldExpr, $dbid);
					} else
						$wrk = "";
					$this->Page_Filtering($fld, $wrk, "custom", $wrkid);
					break;
				}
			}
		}
		return $wrk;
	}

	// Build extended filter
	protected function buildExtendedFilter(&$fld, &$filterClause, $default = FALSE, $saveFilter = FALSE)
	{
		$wrk = GetExtendedFilter($fld, $default, $this->Dbid);
		if (!$default)
			$this->Page_Filtering($fld, $wrk, "extended", $fld->AdvancedSearch->SearchOperator, $fld->AdvancedSearch->SearchValue, $fld->AdvancedSearch->SearchCondition, $fld->AdvancedSearch->SearchOperator2, $fld->AdvancedSearch->SearchValue2);
		if ($wrk <> "") {
			AddFilter($filterClause, $wrk);
			if ($saveFilter) $fld->CurrentFilter = $wrk;
		}
	}

	// Get drop down value from querystring
	protected function getDropDownValue(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		if (IsPost())
			return FALSE; // Skip post back
		$opr = Get("z_$parm");
		if ($opr !== NULL)
			$fld->AdvancedSearch->SearchOperator = $opr;
		$val = Get("x_$parm");
		if ($val !== NULL) {
			if ($fld->isMultiSelect() && !is_array($val)) // Split values for modal lookup
				$fld->DropDownValue = explode(LOOKUP_FILTER_VALUE_SEPARATOR, $val);
			else
				$fld->DropDownValue = $val;
			return TRUE;
		}
		return FALSE;
	}

	// Get filter values from querystring
	protected function getFilterValues(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		if (IsPost())
			return; // Skip post back
		$got = FALSE;
		if (Get("x_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchValue = Get("x_$parm");
			$got = TRUE;
		}
		if (Get("z_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchOperator = Get("z_$parm");
			$got = TRUE;
		}
		if (Get("v_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchCondition = Get("v_$parm");
			$got = TRUE;
		}
		if (Get("y_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchValue2 = Get("y_$parm");
			$got = TRUE;
		}
		if (Get("w_$parm") !== NULL) {
			$fld->AdvancedSearch->SearchOperator2 = Get("w_$parm");
			$got = TRUE;
		}
		return $got;
	}

	// Set default ext filter
	protected function setDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
	{
		$fld->AdvancedSearch->SearchValueDefault = $sv1; // Default ext filter value 1
		$fld->AdvancedSearch->SearchValue2Default = $sv2; // Default ext filter value 2 (if operator 2 is enabled)
		$fld->AdvancedSearch->SearchOperatorDefault = $so1; // Default search operator 1
		$fld->AdvancedSearch->SearchOperator2Default = $so2; // Default search operator 2 (if operator 2 is enabled)
		$fld->AdvancedSearch->SearchConditionDefault = $sc; // Default search condition (if operator 2 is enabled)
	}

	// Apply default ext filter
	protected function applyDefaultExtFilter(&$fld)
	{
		$fld->AdvancedSearch->SearchValue = $fld->AdvancedSearch->SearchValueDefault;
		$fld->AdvancedSearch->SearchValue2 = $fld->AdvancedSearch->SearchValue2Default;
		$fld->AdvancedSearch->SearchOperator = $fld->AdvancedSearch->SearchOperatorDefault;
		$fld->AdvancedSearch->SearchOperator2 = $fld->AdvancedSearch->SearchOperator2Default;
		$fld->AdvancedSearch->SearchCondition = $fld->AdvancedSearch->SearchConditionDefault;
	}

	// Check if Text Filter applied
	protected function textFilterApplied(&$fld)
	{
		return (strval($fld->AdvancedSearch->SearchValue) <> strval($fld->AdvancedSearch->SearchValueDefault) ||
			strval($fld->AdvancedSearch->SearchValue2) <> strval($fld->AdvancedSearch->SearchValue2Default) ||
			(strval($fld->AdvancedSearch->SearchValue) <> "" &&
				strval($fld->AdvancedSearch->SearchOperator) <> strval($fld->AdvancedSearch->SearchOperatorDefault)) ||
			(strval($fld->AdvancedSearch->SearchValue2) <> "" &&
				strval($fld->AdvancedSearch->SearchOperator2) <> strval($fld->AdvancedSearch->SearchOperator2Default)) ||
			strval($fld->AdvancedSearch->SearchCondition) <> strval($fld->AdvancedSearch->SearchConditionDefault));
	}

	// Check if Non-Text Filter applied
	protected function nonTextFilterApplied(&$fld)
	{
		if (is_array($fld->DropDownValue)) {
			if (is_array($fld->DefaultDropDownValue)) {
				if (count($fld->DefaultDropDownValue) <> count($fld->DropDownValue))
					return TRUE;
				else
					return (count(array_diff($fld->DefaultDropDownValue, $fld->DropDownValue)) <> 0);
			} else {
				return TRUE;
			}
		} else {
			if (is_array($fld->DefaultDropDownValue))
				return TRUE;
			else
				$v1 = strval($fld->DefaultDropDownValue);
			if ($v1 == INIT_VALUE)
				$v1 = "";
			$v2 = strval($fld->DropDownValue);
			if ($v2 == INIT_VALUE || $v2 == ALL_VALUE)
				$v2 = "";
			return ($v1 <> $v2);
		}
	}

	// Get dropdown value from session
	protected function getSessionDropDownValue(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		$this->getSessionValue($fld->DropDownValue, 'x_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator, 'z_Kedatangan_Dan_Verifikasi_' . $parm);
	}

	// Get filter values from session
	protected function getSessionFilterValues(&$fld)
	{
		$parm = substr($fld->FieldVar, 2);
		$this->getSessionValue($fld->AdvancedSearch->SearchValue, 'x_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator, 'z_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchCondition, 'v_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchValue2, 'y_Kedatangan_Dan_Verifikasi_' . $parm);
		$this->getSessionValue($fld->AdvancedSearch->SearchOperator2, 'w_Kedatangan_Dan_Verifikasi_' . $parm);
	}

	// Get value from session
	protected function getSessionValue(&$sv, $sn)
	{
		if (array_key_exists($sn, $_SESSION))
			$sv = $_SESSION[$sn];
	}

	// Set dropdown value to session
	protected function setSessionDropDownValue($sv, $so, $parm)
	{
		$_SESSION['x_Kedatangan_Dan_Verifikasi_' . $parm] = $sv;
		$_SESSION['z_Kedatangan_Dan_Verifikasi_' . $parm] = $so;
	}

	// Set filter values to session
	protected function setSessionFilterValues($sv1, $so1, $sc, $sv2, $so2, $parm)
	{
		$_SESSION['x_Kedatangan_Dan_Verifikasi_' . $parm] = $sv1;
		$_SESSION['z_Kedatangan_Dan_Verifikasi_' . $parm] = $so1;
		$_SESSION['v_Kedatangan_Dan_Verifikasi_' . $parm] = $sc;
		$_SESSION['y_Kedatangan_Dan_Verifikasi_' . $parm] = $sv2;
		$_SESSION['w_Kedatangan_Dan_Verifikasi_' . $parm] = $so2;
	}

	// Check if has session filter values
	protected function hasSessionFilterValues($parm)
	{
		return (@$_SESSION['x_' . $parm] <> "" && @$_SESSION['x_' . $parm] <> INIT_VALUE ||
			@$_SESSION['x_' . $parm] <> "" && @$_SESSION['x_' . $parm] <> INIT_VALUE ||
			@$_SESSION['y_' . $parm] <> "" && @$_SESSION['y_' . $parm] <> INIT_VALUE);
	}

	// Dropdown filter exist
	protected function dropDownFilterExist(&$fld, $fldOpr)
	{
		$wrk = "";
		$this->buildDropDownFilter($fld, $wrk, $fldOpr);
		return ($wrk <> "");
	}

	// Extended filter exist
	protected function extendedFilterExist(&$fld)
	{
		$extWrk = "";
		$this->buildExtendedFilter($fld, $extWrk);
		return ($extWrk <> "");
	}

	// Validate form
	protected function validateForm()
	{
		global $ReportLanguage, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if (!CheckDate($this->datang_tgl->AdvancedSearch->SearchValue)) {
			AddMessage($FormError, $this->datang_tgl->errorMessage());
		}
		if (!CheckDate($this->k_es_tgl_panen->AdvancedSearch->SearchValue)) {
			AddMessage($FormError, $this->k_es_tgl_panen->errorMessage());
		}
		if (!CheckDate($this->ver_tgl->AdvancedSearch->SearchValue)) {
			AddMessage($FormError, $this->ver_tgl->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			$FormError .= ($FormError <> "") ? "<p>&nbsp;</p>" : "";
			$FormError .= $formCustomError;
		}
		return $validateForm;
	}

	// Clear selection stored in session
	protected function clearSessionSelection($parm)
	{
		$_SESSION["sel_Kedatangan_Dan_Verifikasi_$parm"] = "";
		$_SESSION["rf_Kedatangan_Dan_Verifikasi_$parm"] = "";
		$_SESSION["rt_Kedatangan_Dan_Verifikasi_$parm"] = "";
	}

	// Load selection from session
	protected function loadSelectionFromSession($parm)
	{
		foreach ($this->fields as $fld) {
			if ($fld->Param == $parm) {
				$fld->SelectionList = @$_SESSION["sel_Kedatangan_Dan_Verifikasi_$parm"];
				$fld->RangeFrom = @$_SESSION["rf_Kedatangan_Dan_Verifikasi_$parm"];
				$fld->RangeTo = @$_SESSION["rt_Kedatangan_Dan_Verifikasi_$parm"];
				break;
			}
		}
	}

	// Load default value for filters
	protected function loadDefaultFilters()
	{

		/**
		* Set up default values for non Text filters
		*/
		// Field ds_nama

		$this->ds_nama->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->ds_nama->DropDownValue = $this->ds_nama->DefaultDropDownValue;

		// Field var_nama
		$this->var_nama->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->var_nama->DropDownValue = $this->var_nama->DefaultDropDownValue;

		// Field sup_nama
		$this->sup_nama->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->sup_nama->DropDownValue = $this->sup_nama->DefaultDropDownValue;

		// Field pet_nama
		$this->pet_nama->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->pet_nama->DropDownValue = $this->pet_nama->DefaultDropDownValue;

		// Field co_nama
		$this->co_nama->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->co_nama->DropDownValue = $this->co_nama->DefaultDropDownValue;

		// Field k_id_kontrak
		$this->k_id_kontrak->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->k_id_kontrak->DropDownValue = $this->k_id_kontrak->DefaultDropDownValue;

		// Field ver_hasil_id
		$this->ver_hasil_id->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->ver_hasil_id->DropDownValue = $this->ver_hasil_id->DefaultDropDownValue;

		// Field qc_nama
		$this->qc_nama->DefaultDropDownValue = INIT_VALUE;
		if (!$this->SearchCommand)
			$this->qc_nama->DropDownValue = $this->qc_nama->DefaultDropDownValue;
		$wrk = "";
		$this->buildDropDownFilter($this->qc_nama, $wrk, $this->qc_nama->AdvancedSearch->SearchOperator, TRUE);
		LoadSelectionFromFilter($this->qc_nama, $wrk, $this->qc_nama->DefaultSelectionList);
		if (!$this->SearchCommand)
			$this->qc_nama->SelectionList = $this->qc_nama->DefaultSelectionList;

		/**
		* Set up default values for extended filters
		* function setDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
		* Parameters:
		* $fld - Field object
		* $so1 - Default search operator 1
		* $sv1 - Default ext filter value 1
		* $sc - Default search condition (if operator 2 is enabled)
		* $so2 - Default search operator 2 (if operator 2 is enabled)
		* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
		*/
		// Field datang_tgl

		$this->setDefaultExtFilter($this->datang_tgl, "=", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->datang_tgl);

		// Field k_es_tgl_panen
		$this->setDefaultExtFilter($this->k_es_tgl_panen, "=", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->k_es_tgl_panen);

		// Field ver_tgl
		$this->setDefaultExtFilter($this->ver_tgl, "=", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand)
			$this->applyDefaultExtFilter($this->ver_tgl);

		/**
		* Set up default values for popup filters
		*/
		// Field qc_nama
		// $this->qc_nama->DefaultSelectionList = ["val1", "val2"];

	}

	// Check if filter applied
	protected function checkFilter()
	{

		// Check datang_tgl text filter
		if ($this->textFilterApplied($this->datang_tgl))
			return TRUE;

		// Check ds_nama extended filter
		if ($this->nonTextFilterApplied($this->ds_nama))
			return TRUE;

		// Check var_nama extended filter
		if ($this->nonTextFilterApplied($this->var_nama))
			return TRUE;

		// Check sup_nama extended filter
		if ($this->nonTextFilterApplied($this->sup_nama))
			return TRUE;

		// Check pet_nama extended filter
		if ($this->nonTextFilterApplied($this->pet_nama))
			return TRUE;

		// Check co_nama extended filter
		if ($this->nonTextFilterApplied($this->co_nama))
			return TRUE;

		// Check k_id_kontrak extended filter
		if ($this->nonTextFilterApplied($this->k_id_kontrak))
			return TRUE;

		// Check k_es_tgl_panen text filter
		if ($this->textFilterApplied($this->k_es_tgl_panen))
			return TRUE;

		// Check ver_tgl text filter
		if ($this->textFilterApplied($this->ver_tgl))
			return TRUE;

		// Check ver_hasil_id extended filter
		if ($this->nonTextFilterApplied($this->ver_hasil_id))
			return TRUE;

		// Check qc_nama extended filter
		if ($this->nonTextFilterApplied($this->qc_nama))
			return TRUE;

		// Check qc_nama popup filter
		if (!MatchedArray($this->qc_nama->DefaultSelectionList, $this->qc_nama->SelectionList))
			return TRUE;
		return FALSE;
	}

	// Show list of filters
	public function showFilterList($showDate = FALSE)
	{
		global $ReportLanguage;

		// Initialize
		$filterList = "";
		$captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
		$captionSuffix = $this->isExport("email") ? ": " : "";

		// Field datang_tgl
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->datang_tgl, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->datang_tgl->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field ds_nama
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->ds_nama, $extWrk, $this->ds_nama->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ds_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field var_nama
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->var_nama, $extWrk, $this->var_nama->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->var_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field sup_nama
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->sup_nama, $extWrk, $this->sup_nama->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sup_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field pet_nama
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->pet_nama, $extWrk, $this->pet_nama->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pet_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field co_nama
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->co_nama, $extWrk, $this->co_nama->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->co_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field k_id_kontrak
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->k_id_kontrak, $extWrk, $this->k_id_kontrak->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_id_kontrak->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field k_es_tgl_panen
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->k_es_tgl_panen, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_es_tgl_panen->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field ver_tgl
		$extWrk = "";
		$wrk = "";
		$this->buildExtendedFilter($this->ver_tgl, $extWrk);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ver_tgl->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field ver_hasil_id
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->ver_hasil_id, $extWrk, $this->ver_hasil_id->AdvancedSearch->SearchOperator);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ver_hasil_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";

		// Field qc_nama
		$extWrk = "";
		$wrk = "";
		$this->buildDropDownFilter($this->qc_nama, $extWrk, $this->qc_nama->AdvancedSearch->SearchOperator);
		if (is_array($this->qc_nama->SelectionList))
			$wrk = JoinArray($this->qc_nama->SelectionList, ", ", DATATYPE_STRING, 0, $this->Dbid);
		$filter = "";
		if ($extWrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
		elseif ($wrk <> "")
			$filter .= "<span class=\"ew-filter-value\">$wrk</span>";
		if ($filter <> "")
			$filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->qc_nama->caption() . "</span>" . $captionSuffix . $filter . "</div>";
		$divdataclass = "";

		// Show Filters
		if ($filterList <> "" || $showDate) {
			$message = "<div" . $divdataclass . "><div id=\"ew-filter-list\" class=\"alert alert-info d-table\">";
			if ($showDate)
				$message .= "<div id=\"ew-current-date\">" . $ReportLanguage->phrase("ReportGeneratedDate") . FormatDateTime(date("Y-m-d H:i:s"), 1) . "</div>";
			if ($filterList <> "")
				$message .= "<div id=\"ew-current-filters\">" . $ReportLanguage->phrase("CurrentFilters") . "</div>" . $filterList;
			$message .= "</div></div>";
			$this->Message_Showing($message, "");
			Write($message);
		}
	}

	// Get list of filters
	public function getFilterList()
	{

		// Initialize
		$filterList = "";

		// Field datang_tgl
		$wrk = "";
		if ($this->datang_tgl->AdvancedSearch->SearchValue <> "" || $this->datang_tgl->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_datang_tgl\":\"" . JsEncode($this->datang_tgl->AdvancedSearch->SearchValue) . "\"," .
				"\"z_datang_tgl\":\"" . JsEncode($this->datang_tgl->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_datang_tgl\":\"" . JsEncode($this->datang_tgl->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_datang_tgl\":\"" . JsEncode($this->datang_tgl->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_datang_tgl\":\"" . JsEncode($this->datang_tgl->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field ds_nama
		$wrk = "";
		$wrk = ($this->ds_nama->DropDownValue <> INIT_VALUE) ? $this->ds_nama->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_ds_nama\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field var_nama
		$wrk = "";
		$wrk = ($this->var_nama->DropDownValue <> INIT_VALUE) ? $this->var_nama->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_var_nama\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field sup_nama
		$wrk = "";
		$wrk = ($this->sup_nama->DropDownValue <> INIT_VALUE) ? $this->sup_nama->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_sup_nama\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field pet_nama
		$wrk = "";
		$wrk = ($this->pet_nama->DropDownValue <> INIT_VALUE) ? $this->pet_nama->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_pet_nama\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field co_nama
		$wrk = "";
		$wrk = ($this->co_nama->DropDownValue <> INIT_VALUE) ? $this->co_nama->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_co_nama\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field k_id_kontrak
		$wrk = "";
		$wrk = ($this->k_id_kontrak->DropDownValue <> INIT_VALUE) ? $this->k_id_kontrak->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_k_id_kontrak\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field k_es_tgl_panen
		$wrk = "";
		if ($this->k_es_tgl_panen->AdvancedSearch->SearchValue <> "" || $this->k_es_tgl_panen->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_k_es_tgl_panen\":\"" . JsEncode($this->k_es_tgl_panen->AdvancedSearch->SearchValue) . "\"," .
				"\"z_k_es_tgl_panen\":\"" . JsEncode($this->k_es_tgl_panen->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_k_es_tgl_panen\":\"" . JsEncode($this->k_es_tgl_panen->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_k_es_tgl_panen\":\"" . JsEncode($this->k_es_tgl_panen->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_k_es_tgl_panen\":\"" . JsEncode($this->k_es_tgl_panen->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field ver_tgl
		$wrk = "";
		if ($this->ver_tgl->AdvancedSearch->SearchValue <> "" || $this->ver_tgl->AdvancedSearch->SearchValue2 <> "") {
			$wrk = "\"x_ver_tgl\":\"" . JsEncode($this->ver_tgl->AdvancedSearch->SearchValue) . "\"," .
				"\"z_ver_tgl\":\"" . JsEncode($this->ver_tgl->AdvancedSearch->SearchOperator) . "\"," .
				"\"v_ver_tgl\":\"" . JsEncode($this->ver_tgl->AdvancedSearch->SearchCondition) . "\"," .
				"\"y_ver_tgl\":\"" . JsEncode($this->ver_tgl->AdvancedSearch->SearchValue2) . "\"," .
				"\"w_ver_tgl\":\"" . JsEncode($this->ver_tgl->AdvancedSearch->SearchOperator2) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field ver_hasil_id
		$wrk = "";
		$wrk = ($this->ver_hasil_id->DropDownValue <> INIT_VALUE) ? $this->ver_hasil_id->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_ver_hasil_id\":\"" . JsEncode($wrk) . "\"";
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Field qc_nama
		$wrk = "";
		$wrk = ($this->qc_nama->DropDownValue <> INIT_VALUE) ? $this->qc_nama->DropDownValue : "";
		if (is_array($wrk))
			$wrk = implode("||", $wrk);
		if ($wrk <> "")
			$wrk = "\"x_qc_nama\":\"" . JsEncode($wrk) . "\"";
		if ($wrk == "") {
			$wrk = ($this->qc_nama->SelectionList <> INIT_VALUE) ? $this->qc_nama->SelectionList : "";
			if (is_array($wrk))
				$wrk = implode("||", $wrk);
			if ($wrk <> "")
				$wrk = "\"sel_qc_nama\":\"" . JsEncode($wrk) . "\"";
		}
		if ($wrk <> "") {
			if ($filterList <> "") $filterList .= ",";
			$filterList .= $wrk;
		}

		// Return filter list in json
		if ($filterList <> "")
			return "{\"data\":{" . $filterList . "}}";
		else
			return "null";
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd", "") <> "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter", ""), TRUE);
		return $this->setupFilterList($filter);
	}

	// Setup list of filters
	protected function setupFilterList($filter)
	{
		if (!is_array($filter))
			return FALSE;

		// Field datang_tgl
		$restoreFilter = FALSE;
		if (array_key_exists("x_datang_tgl", $filter) || array_key_exists("z_datang_tgl", $filter) ||
			array_key_exists("v_datang_tgl", $filter) ||
			array_key_exists("y_datang_tgl", $filter) || array_key_exists("w_datang_tgl", $filter)) {
			$this->setSessionFilterValues(@$filter["x_datang_tgl"], @$filter["z_datang_tgl"], @$filter["v_datang_tgl"], @$filter["y_datang_tgl"], @$filter["w_datang_tgl"], "datang_tgl");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "datang_tgl");
		}

		// Field ds_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_ds_nama", $filter)) {
			$wrk = $filter["x_ds_nama"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_ds_nama"], "ds_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "ds_nama");
		}

		// Field var_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_var_nama", $filter)) {
			$wrk = $filter["x_var_nama"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_var_nama"], "var_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "var_nama");
		}

		// Field sup_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_sup_nama", $filter)) {
			$wrk = $filter["x_sup_nama"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_sup_nama"], "sup_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "sup_nama");
		}

		// Field pet_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_pet_nama", $filter)) {
			$wrk = $filter["x_pet_nama"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_pet_nama"], "pet_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "pet_nama");
		}

		// Field co_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_co_nama", $filter)) {
			$wrk = $filter["x_co_nama"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_co_nama"], "co_nama");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "co_nama");
		}

		// Field k_id_kontrak
		$restoreFilter = FALSE;
		if (array_key_exists("x_k_id_kontrak", $filter)) {
			$wrk = $filter["x_k_id_kontrak"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_k_id_kontrak"], "k_id_kontrak");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "k_id_kontrak");
		}

		// Field k_es_tgl_panen
		$restoreFilter = FALSE;
		if (array_key_exists("x_k_es_tgl_panen", $filter) || array_key_exists("z_k_es_tgl_panen", $filter) ||
			array_key_exists("v_k_es_tgl_panen", $filter) ||
			array_key_exists("y_k_es_tgl_panen", $filter) || array_key_exists("w_k_es_tgl_panen", $filter)) {
			$this->setSessionFilterValues(@$filter["x_k_es_tgl_panen"], @$filter["z_k_es_tgl_panen"], @$filter["v_k_es_tgl_panen"], @$filter["y_k_es_tgl_panen"], @$filter["w_k_es_tgl_panen"], "k_es_tgl_panen");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "k_es_tgl_panen");
		}

		// Field ver_tgl
		$restoreFilter = FALSE;
		if (array_key_exists("x_ver_tgl", $filter) || array_key_exists("z_ver_tgl", $filter) ||
			array_key_exists("v_ver_tgl", $filter) ||
			array_key_exists("y_ver_tgl", $filter) || array_key_exists("w_ver_tgl", $filter)) {
			$this->setSessionFilterValues(@$filter["x_ver_tgl"], @$filter["z_ver_tgl"], @$filter["v_ver_tgl"], @$filter["y_ver_tgl"], @$filter["w_ver_tgl"], "ver_tgl");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionFilterValues("", "=", "AND", "", "=", "ver_tgl");
		}

		// Field ver_hasil_id
		$restoreFilter = FALSE;
		if (array_key_exists("x_ver_hasil_id", $filter)) {
			$wrk = $filter["x_ver_hasil_id"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_ver_hasil_id"], "ver_hasil_id");
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "ver_hasil_id");
		}

		// Field qc_nama
		$restoreFilter = FALSE;
		if (array_key_exists("x_qc_nama", $filter)) {
			$wrk = $filter["x_qc_nama"];
			if (strpos($wrk, "||") !== FALSE)
				$wrk = explode("||", $wrk);
			$this->setSessionDropDownValue($wrk, @$filter["z_qc_nama"], "qc_nama");
			$restoreFilter = TRUE;
		}
		if (array_key_exists("sel_qc_nama", $filter)) {
			$wrk = $filter["sel_qc_nama"];
			$wrk = explode("||", $wrk);
			$this->qc_nama->SelectionList = $wrk;
			$_SESSION["sel_Kedatangan_Dan_Verifikasi_qc_nama"] = $wrk;
			$this->setSessionDropDownValue(INIT_VALUE, "", "qc_nama"); // Clear drop down
			$restoreFilter = TRUE;
		}
		if (!$restoreFilter) { // Clear filter
			$this->setSessionDropDownValue(INIT_VALUE, "", "qc_nama");
			$this->qc_nama->SelectionList = "";
			$_SESSION["sel_Kedatangan_Dan_Verifikasi_qc_nama"] = "";
		}
		return TRUE;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Render lookup
					$this->RowType == ROWTYPE_VIEW;
					$fn = $fld->Lookup->RenderViewFunc;
					$render = method_exists($this, $fn);

					// Format the field values
					$fld->setDbValue($row[1]);
					if ($render) {
						$this->$fn();
						$row[1] = $fld->ViewValue;
						$row['df'] = $row[1];
					} elseif ($fld->isEncrypt()) {
						$row[1] = $fld->CurrentValue;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Return popup filter
	protected function getPopupFilter()
	{
		$wrk = "";
		if ($this->DrillDown)
			return "";
		if (!$this->dropDownFilterExist($this->qc_nama, $this->qc_nama->AdvancedSearch->SearchOperator)) {
			if (is_array($this->qc_nama->SelectionList)) {
				$filter = FilterSql($this->qc_nama, "`qc_nama`", DATATYPE_STRING, $this->Dbid);

				// Call Page Filtering event
				$this->Page_Filtering($this->qc_nama, $filter, "popup");
				$this->qc_nama->CurrentFilter = $filter;
				AddFilter($wrk, $filter);
			}
		}
		return $wrk;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>