<?php

namespace PHPMaker2023\co;

// Set up and run Grid object
$Grid = Container("PenggunaanPestisidaGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fpenggunaan_pestisidagrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { penggunaan_pestisida: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpenggunaan_pestisidagrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ID_Penggunan", [fields.ID_Penggunan.visible && fields.ID_Penggunan.required ? ew.Validators.required(fields.ID_Penggunan.caption) : null], fields.ID_Penggunan.isInvalid],
            ["ID_Kontrak", [fields.ID_Kontrak.visible && fields.ID_Kontrak.required ? ew.Validators.required(fields.ID_Kontrak.caption) : null, ew.Validators.integer], fields.ID_Kontrak.isInvalid],
            ["Jenis_Pestisida", [fields.Jenis_Pestisida.visible && fields.Jenis_Pestisida.required ? ew.Validators.required(fields.Jenis_Pestisida.caption) : null], fields.Jenis_Pestisida.isInvalid],
            ["Merek", [fields.Merek.visible && fields.Merek.required ? ew.Validators.required(fields.Merek.caption) : null], fields.Merek.isInvalid],
            ["Bahan_Aktif", [fields.Bahan_Aktif.visible && fields.Bahan_Aktif.required ? ew.Validators.required(fields.Bahan_Aktif.caption) : null], fields.Bahan_Aktif.isInvalid],
            ["Dosis_Pemakaian", [fields.Dosis_Pemakaian.visible && fields.Dosis_Pemakaian.required ? ew.Validators.required(fields.Dosis_Pemakaian.caption) : null], fields.Dosis_Pemakaian.isInvalid],
            ["Waktu_Aplikasi", [fields.Waktu_Aplikasi.visible && fields.Waktu_Aplikasi.required ? ew.Validators.required(fields.Waktu_Aplikasi.caption) : null], fields.Waktu_Aplikasi.isInvalid],
            ["Petugas_Update", [fields.Petugas_Update.visible && fields.Petugas_Update.required ? ew.Validators.required(fields.Petugas_Update.caption) : null], fields.Petugas_Update.isInvalid],
            ["Tanggal_Update", [fields.Tanggal_Update.visible && fields.Tanggal_Update.required ? ew.Validators.required(fields.Tanggal_Update.caption) : null], fields.Tanggal_Update.isInvalid],
            ["Petugas_Add", [fields.Petugas_Add.visible && fields.Petugas_Add.required ? ew.Validators.required(fields.Petugas_Add.caption) : null], fields.Petugas_Add.isInvalid],
            ["Tanggal_Add", [fields.Tanggal_Add.visible && fields.Tanggal_Add.required ? ew.Validators.required(fields.Tanggal_Add.caption) : null], fields.Tanggal_Add.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ID_Kontrak",false],["Jenis_Pestisida",false],["Merek",false],["Bahan_Aktif",false],["Dosis_Pemakaian",false],["Waktu_Aplikasi",false],["Petugas_Add",false],["Tanggal_Add",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Jenis_Pestisida": <?= $Grid->Jenis_Pestisida->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fpenggunaan_pestisidagrid" class="ew-form ew-list-form">
<div id="gmp_penggunaan_pestisida" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_penggunaan_pestisidagrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = ROWTYPE_HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->ID_Penggunan->Visible) { // ID_Penggunan ?>
        <th data-name="ID_Penggunan" class="<?= $Grid->ID_Penggunan->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_ID_Penggunan" class="penggunaan_pestisida_ID_Penggunan"><?= $Grid->renderFieldHeader($Grid->ID_Penggunan) ?></div></th>
<?php } ?>
<?php if ($Grid->ID_Kontrak->Visible) { // ID_Kontrak ?>
        <th data-name="ID_Kontrak" class="<?= $Grid->ID_Kontrak->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_ID_Kontrak" class="penggunaan_pestisida_ID_Kontrak"><?= $Grid->renderFieldHeader($Grid->ID_Kontrak) ?></div></th>
<?php } ?>
<?php if ($Grid->Jenis_Pestisida->Visible) { // Jenis_Pestisida ?>
        <th data-name="Jenis_Pestisida" class="<?= $Grid->Jenis_Pestisida->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_Jenis_Pestisida" class="penggunaan_pestisida_Jenis_Pestisida"><?= $Grid->renderFieldHeader($Grid->Jenis_Pestisida) ?></div></th>
<?php } ?>
<?php if ($Grid->Merek->Visible) { // Merek ?>
        <th data-name="Merek" class="<?= $Grid->Merek->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_Merek" class="penggunaan_pestisida_Merek"><?= $Grid->renderFieldHeader($Grid->Merek) ?></div></th>
<?php } ?>
<?php if ($Grid->Bahan_Aktif->Visible) { // Bahan_Aktif ?>
        <th data-name="Bahan_Aktif" class="<?= $Grid->Bahan_Aktif->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_Bahan_Aktif" class="penggunaan_pestisida_Bahan_Aktif"><?= $Grid->renderFieldHeader($Grid->Bahan_Aktif) ?></div></th>
<?php } ?>
<?php if ($Grid->Dosis_Pemakaian->Visible) { // Dosis_Pemakaian ?>
        <th data-name="Dosis_Pemakaian" class="<?= $Grid->Dosis_Pemakaian->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_Dosis_Pemakaian" class="penggunaan_pestisida_Dosis_Pemakaian"><?= $Grid->renderFieldHeader($Grid->Dosis_Pemakaian) ?></div></th>
<?php } ?>
<?php if ($Grid->Waktu_Aplikasi->Visible) { // Waktu_Aplikasi ?>
        <th data-name="Waktu_Aplikasi" class="<?= $Grid->Waktu_Aplikasi->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_Waktu_Aplikasi" class="penggunaan_pestisida_Waktu_Aplikasi"><?= $Grid->renderFieldHeader($Grid->Waktu_Aplikasi) ?></div></th>
<?php } ?>
<?php if ($Grid->Petugas_Update->Visible) { // Petugas_Update ?>
        <th data-name="Petugas_Update" class="<?= $Grid->Petugas_Update->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_Petugas_Update" class="penggunaan_pestisida_Petugas_Update"><?= $Grid->renderFieldHeader($Grid->Petugas_Update) ?></div></th>
<?php } ?>
<?php if ($Grid->Tanggal_Update->Visible) { // Tanggal_Update ?>
        <th data-name="Tanggal_Update" class="<?= $Grid->Tanggal_Update->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_Tanggal_Update" class="penggunaan_pestisida_Tanggal_Update"><?= $Grid->renderFieldHeader($Grid->Tanggal_Update) ?></div></th>
<?php } ?>
<?php if ($Grid->Petugas_Add->Visible) { // Petugas_Add ?>
        <th data-name="Petugas_Add" class="<?= $Grid->Petugas_Add->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_Petugas_Add" class="penggunaan_pestisida_Petugas_Add"><?= $Grid->renderFieldHeader($Grid->Petugas_Add) ?></div></th>
<?php } ?>
<?php if ($Grid->Tanggal_Add->Visible) { // Tanggal_Add ?>
        <th data-name="Tanggal_Add" class="<?= $Grid->Tanggal_Add->headerCellClass() ?>"><div id="elh_penggunaan_pestisida_Tanggal_Add" class="penggunaan_pestisida_Tanggal_Add"><?= $Grid->renderFieldHeader($Grid->Tanggal_Add) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->ID_Penggunan->Visible) { // ID_Penggunan ?>
        <td data-name="ID_Penggunan"<?= $Grid->ID_Penggunan->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_ID_Penggunan" class="el_penggunaan_pestisida_ID_Penggunan"></span>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_ID_Penggunan" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ID_Penggunan" id="o<?= $Grid->RowIndex ?>_ID_Penggunan" value="<?= HtmlEncode($Grid->ID_Penggunan->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_ID_Penggunan" class="el_penggunaan_pestisida_ID_Penggunan">
<span<?= $Grid->ID_Penggunan->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ID_Penggunan->getDisplayValue($Grid->ID_Penggunan->EditValue))) ?>"></span>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_ID_Penggunan" data-hidden="1" name="x<?= $Grid->RowIndex ?>_ID_Penggunan" id="x<?= $Grid->RowIndex ?>_ID_Penggunan" value="<?= HtmlEncode($Grid->ID_Penggunan->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_ID_Penggunan" class="el_penggunaan_pestisida_ID_Penggunan">
<span<?= $Grid->ID_Penggunan->viewAttributes() ?>>
<?= $Grid->ID_Penggunan->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_ID_Penggunan" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_ID_Penggunan" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_ID_Penggunan" value="<?= HtmlEncode($Grid->ID_Penggunan->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_ID_Penggunan" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_ID_Penggunan" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_ID_Penggunan" value="<?= HtmlEncode($Grid->ID_Penggunan->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="penggunaan_pestisida" data-field="x_ID_Penggunan" data-hidden="1" name="x<?= $Grid->RowIndex ?>_ID_Penggunan" id="x<?= $Grid->RowIndex ?>_ID_Penggunan" value="<?= HtmlEncode($Grid->ID_Penggunan->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->ID_Kontrak->Visible) { // ID_Kontrak ?>
        <td data-name="ID_Kontrak"<?= $Grid->ID_Kontrak->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($Grid->ID_Kontrak->getSessionValue() != "") { ?>
<span<?= $Grid->ID_Kontrak->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ID_Kontrak->getDisplayValue($Grid->ID_Kontrak->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ID_Kontrak" name="x<?= $Grid->RowIndex ?>_ID_Kontrak" value="<?= HtmlEncode($Grid->ID_Kontrak->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_ID_Kontrak" class="el_penggunaan_pestisida_ID_Kontrak">
<input type="<?= $Grid->ID_Kontrak->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ID_Kontrak" id="x<?= $Grid->RowIndex ?>_ID_Kontrak" data-table="penggunaan_pestisida" data-field="x_ID_Kontrak" value="<?= $Grid->ID_Kontrak->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->ID_Kontrak->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ID_Kontrak->formatPattern()) ?>"<?= $Grid->ID_Kontrak->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ID_Kontrak->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_ID_Kontrak" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ID_Kontrak" id="o<?= $Grid->RowIndex ?>_ID_Kontrak" value="<?= HtmlEncode($Grid->ID_Kontrak->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($Grid->ID_Kontrak->getSessionValue() != "") { ?>
<span<?= $Grid->ID_Kontrak->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ID_Kontrak->getDisplayValue($Grid->ID_Kontrak->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ID_Kontrak" name="x<?= $Grid->RowIndex ?>_ID_Kontrak" value="<?= HtmlEncode($Grid->ID_Kontrak->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_ID_Kontrak" class="el_penggunaan_pestisida_ID_Kontrak">
<input type="<?= $Grid->ID_Kontrak->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ID_Kontrak" id="x<?= $Grid->RowIndex ?>_ID_Kontrak" data-table="penggunaan_pestisida" data-field="x_ID_Kontrak" value="<?= $Grid->ID_Kontrak->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->ID_Kontrak->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ID_Kontrak->formatPattern()) ?>"<?= $Grid->ID_Kontrak->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ID_Kontrak->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_ID_Kontrak" class="el_penggunaan_pestisida_ID_Kontrak">
<span<?= $Grid->ID_Kontrak->viewAttributes() ?>>
<?= $Grid->ID_Kontrak->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_ID_Kontrak" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_ID_Kontrak" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_ID_Kontrak" value="<?= HtmlEncode($Grid->ID_Kontrak->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_ID_Kontrak" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_ID_Kontrak" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_ID_Kontrak" value="<?= HtmlEncode($Grid->ID_Kontrak->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Jenis_Pestisida->Visible) { // Jenis_Pestisida ?>
        <td data-name="Jenis_Pestisida"<?= $Grid->Jenis_Pestisida->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Jenis_Pestisida" class="el_penggunaan_pestisida_Jenis_Pestisida">
    <select
        id="x<?= $Grid->RowIndex ?>_Jenis_Pestisida"
        name="x<?= $Grid->RowIndex ?>_Jenis_Pestisida"
        class="form-select ew-select<?= $Grid->Jenis_Pestisida->isInvalidClass() ?>"
        <?php if (!$Grid->Jenis_Pestisida->IsNativeSelect) { ?>
        data-select2-id="fpenggunaan_pestisidagrid_x<?= $Grid->RowIndex ?>_Jenis_Pestisida"
        <?php } ?>
        data-table="penggunaan_pestisida"
        data-field="x_Jenis_Pestisida"
        data-value-separator="<?= $Grid->Jenis_Pestisida->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Jenis_Pestisida->getPlaceHolder()) ?>"
        <?= $Grid->Jenis_Pestisida->editAttributes() ?>>
        <?= $Grid->Jenis_Pestisida->selectOptionListHtml("x{$Grid->RowIndex}_Jenis_Pestisida") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Jenis_Pestisida->getErrorMessage() ?></div>
<?php if (!$Grid->Jenis_Pestisida->IsNativeSelect) { ?>
<script>
loadjs.ready("fpenggunaan_pestisidagrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Jenis_Pestisida", selectId: "fpenggunaan_pestisidagrid_x<?= $Grid->RowIndex ?>_Jenis_Pestisida" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpenggunaan_pestisidagrid.lists.Jenis_Pestisida?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Jenis_Pestisida", form: "fpenggunaan_pestisidagrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Jenis_Pestisida", form: "fpenggunaan_pestisidagrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.penggunaan_pestisida.fields.Jenis_Pestisida.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Jenis_Pestisida" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Jenis_Pestisida" id="o<?= $Grid->RowIndex ?>_Jenis_Pestisida" value="<?= HtmlEncode($Grid->Jenis_Pestisida->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Jenis_Pestisida" class="el_penggunaan_pestisida_Jenis_Pestisida">
    <select
        id="x<?= $Grid->RowIndex ?>_Jenis_Pestisida"
        name="x<?= $Grid->RowIndex ?>_Jenis_Pestisida"
        class="form-select ew-select<?= $Grid->Jenis_Pestisida->isInvalidClass() ?>"
        <?php if (!$Grid->Jenis_Pestisida->IsNativeSelect) { ?>
        data-select2-id="fpenggunaan_pestisidagrid_x<?= $Grid->RowIndex ?>_Jenis_Pestisida"
        <?php } ?>
        data-table="penggunaan_pestisida"
        data-field="x_Jenis_Pestisida"
        data-value-separator="<?= $Grid->Jenis_Pestisida->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Jenis_Pestisida->getPlaceHolder()) ?>"
        <?= $Grid->Jenis_Pestisida->editAttributes() ?>>
        <?= $Grid->Jenis_Pestisida->selectOptionListHtml("x{$Grid->RowIndex}_Jenis_Pestisida") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Jenis_Pestisida->getErrorMessage() ?></div>
<?php if (!$Grid->Jenis_Pestisida->IsNativeSelect) { ?>
<script>
loadjs.ready("fpenggunaan_pestisidagrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Jenis_Pestisida", selectId: "fpenggunaan_pestisidagrid_x<?= $Grid->RowIndex ?>_Jenis_Pestisida" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpenggunaan_pestisidagrid.lists.Jenis_Pestisida?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Jenis_Pestisida", form: "fpenggunaan_pestisidagrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Jenis_Pestisida", form: "fpenggunaan_pestisidagrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.penggunaan_pestisida.fields.Jenis_Pestisida.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Jenis_Pestisida" class="el_penggunaan_pestisida_Jenis_Pestisida">
<span<?= $Grid->Jenis_Pestisida->viewAttributes() ?>>
<?= $Grid->Jenis_Pestisida->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Jenis_Pestisida" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Jenis_Pestisida" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Jenis_Pestisida" value="<?= HtmlEncode($Grid->Jenis_Pestisida->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Jenis_Pestisida" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Jenis_Pestisida" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Jenis_Pestisida" value="<?= HtmlEncode($Grid->Jenis_Pestisida->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Merek->Visible) { // Merek ?>
        <td data-name="Merek"<?= $Grid->Merek->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Merek" class="el_penggunaan_pestisida_Merek">
<input type="<?= $Grid->Merek->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Merek" id="x<?= $Grid->RowIndex ?>_Merek" data-table="penggunaan_pestisida" data-field="x_Merek" value="<?= $Grid->Merek->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Merek->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Merek->formatPattern()) ?>"<?= $Grid->Merek->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Merek->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Merek" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Merek" id="o<?= $Grid->RowIndex ?>_Merek" value="<?= HtmlEncode($Grid->Merek->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Merek" class="el_penggunaan_pestisida_Merek">
<input type="<?= $Grid->Merek->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Merek" id="x<?= $Grid->RowIndex ?>_Merek" data-table="penggunaan_pestisida" data-field="x_Merek" value="<?= $Grid->Merek->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Merek->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Merek->formatPattern()) ?>"<?= $Grid->Merek->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Merek->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Merek" class="el_penggunaan_pestisida_Merek">
<span<?= $Grid->Merek->viewAttributes() ?>>
<?= $Grid->Merek->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Merek" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Merek" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Merek" value="<?= HtmlEncode($Grid->Merek->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Merek" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Merek" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Merek" value="<?= HtmlEncode($Grid->Merek->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Bahan_Aktif->Visible) { // Bahan_Aktif ?>
        <td data-name="Bahan_Aktif"<?= $Grid->Bahan_Aktif->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Bahan_Aktif" class="el_penggunaan_pestisida_Bahan_Aktif">
<input type="<?= $Grid->Bahan_Aktif->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Bahan_Aktif" id="x<?= $Grid->RowIndex ?>_Bahan_Aktif" data-table="penggunaan_pestisida" data-field="x_Bahan_Aktif" value="<?= $Grid->Bahan_Aktif->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Bahan_Aktif->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Bahan_Aktif->formatPattern()) ?>"<?= $Grid->Bahan_Aktif->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Bahan_Aktif->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Bahan_Aktif" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Bahan_Aktif" id="o<?= $Grid->RowIndex ?>_Bahan_Aktif" value="<?= HtmlEncode($Grid->Bahan_Aktif->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Bahan_Aktif" class="el_penggunaan_pestisida_Bahan_Aktif">
<input type="<?= $Grid->Bahan_Aktif->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Bahan_Aktif" id="x<?= $Grid->RowIndex ?>_Bahan_Aktif" data-table="penggunaan_pestisida" data-field="x_Bahan_Aktif" value="<?= $Grid->Bahan_Aktif->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Bahan_Aktif->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Bahan_Aktif->formatPattern()) ?>"<?= $Grid->Bahan_Aktif->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Bahan_Aktif->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Bahan_Aktif" class="el_penggunaan_pestisida_Bahan_Aktif">
<span<?= $Grid->Bahan_Aktif->viewAttributes() ?>>
<?= $Grid->Bahan_Aktif->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Bahan_Aktif" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Bahan_Aktif" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Bahan_Aktif" value="<?= HtmlEncode($Grid->Bahan_Aktif->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Bahan_Aktif" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Bahan_Aktif" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Bahan_Aktif" value="<?= HtmlEncode($Grid->Bahan_Aktif->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Dosis_Pemakaian->Visible) { // Dosis_Pemakaian ?>
        <td data-name="Dosis_Pemakaian"<?= $Grid->Dosis_Pemakaian->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Dosis_Pemakaian" class="el_penggunaan_pestisida_Dosis_Pemakaian">
<input type="<?= $Grid->Dosis_Pemakaian->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Dosis_Pemakaian" id="x<?= $Grid->RowIndex ?>_Dosis_Pemakaian" data-table="penggunaan_pestisida" data-field="x_Dosis_Pemakaian" value="<?= $Grid->Dosis_Pemakaian->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Dosis_Pemakaian->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Dosis_Pemakaian->formatPattern()) ?>"<?= $Grid->Dosis_Pemakaian->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Dosis_Pemakaian->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Dosis_Pemakaian" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Dosis_Pemakaian" id="o<?= $Grid->RowIndex ?>_Dosis_Pemakaian" value="<?= HtmlEncode($Grid->Dosis_Pemakaian->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Dosis_Pemakaian" class="el_penggunaan_pestisida_Dosis_Pemakaian">
<input type="<?= $Grid->Dosis_Pemakaian->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Dosis_Pemakaian" id="x<?= $Grid->RowIndex ?>_Dosis_Pemakaian" data-table="penggunaan_pestisida" data-field="x_Dosis_Pemakaian" value="<?= $Grid->Dosis_Pemakaian->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Dosis_Pemakaian->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Dosis_Pemakaian->formatPattern()) ?>"<?= $Grid->Dosis_Pemakaian->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Dosis_Pemakaian->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Dosis_Pemakaian" class="el_penggunaan_pestisida_Dosis_Pemakaian">
<span<?= $Grid->Dosis_Pemakaian->viewAttributes() ?>>
<?= $Grid->Dosis_Pemakaian->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Dosis_Pemakaian" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Dosis_Pemakaian" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Dosis_Pemakaian" value="<?= HtmlEncode($Grid->Dosis_Pemakaian->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Dosis_Pemakaian" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Dosis_Pemakaian" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Dosis_Pemakaian" value="<?= HtmlEncode($Grid->Dosis_Pemakaian->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Waktu_Aplikasi->Visible) { // Waktu_Aplikasi ?>
        <td data-name="Waktu_Aplikasi"<?= $Grid->Waktu_Aplikasi->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Waktu_Aplikasi" class="el_penggunaan_pestisida_Waktu_Aplikasi">
<input type="<?= $Grid->Waktu_Aplikasi->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Waktu_Aplikasi" id="x<?= $Grid->RowIndex ?>_Waktu_Aplikasi" data-table="penggunaan_pestisida" data-field="x_Waktu_Aplikasi" value="<?= $Grid->Waktu_Aplikasi->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Waktu_Aplikasi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Waktu_Aplikasi->formatPattern()) ?>"<?= $Grid->Waktu_Aplikasi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Waktu_Aplikasi->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Waktu_Aplikasi" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Waktu_Aplikasi" id="o<?= $Grid->RowIndex ?>_Waktu_Aplikasi" value="<?= HtmlEncode($Grid->Waktu_Aplikasi->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Waktu_Aplikasi" class="el_penggunaan_pestisida_Waktu_Aplikasi">
<input type="<?= $Grid->Waktu_Aplikasi->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Waktu_Aplikasi" id="x<?= $Grid->RowIndex ?>_Waktu_Aplikasi" data-table="penggunaan_pestisida" data-field="x_Waktu_Aplikasi" value="<?= $Grid->Waktu_Aplikasi->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Waktu_Aplikasi->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Waktu_Aplikasi->formatPattern()) ?>"<?= $Grid->Waktu_Aplikasi->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Waktu_Aplikasi->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Waktu_Aplikasi" class="el_penggunaan_pestisida_Waktu_Aplikasi">
<span<?= $Grid->Waktu_Aplikasi->viewAttributes() ?>>
<?= $Grid->Waktu_Aplikasi->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Waktu_Aplikasi" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Waktu_Aplikasi" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Waktu_Aplikasi" value="<?= HtmlEncode($Grid->Waktu_Aplikasi->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Waktu_Aplikasi" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Waktu_Aplikasi" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Waktu_Aplikasi" value="<?= HtmlEncode($Grid->Waktu_Aplikasi->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Petugas_Update->Visible) { // Petugas_Update ?>
        <td data-name="Petugas_Update"<?= $Grid->Petugas_Update->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Petugas_Update" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Petugas_Update" id="o<?= $Grid->RowIndex ?>_Petugas_Update" value="<?= HtmlEncode($Grid->Petugas_Update->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Petugas_Update" class="el_penggunaan_pestisida_Petugas_Update">
<span<?= $Grid->Petugas_Update->viewAttributes() ?>>
<?= $Grid->Petugas_Update->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Petugas_Update" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Petugas_Update" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Petugas_Update" value="<?= HtmlEncode($Grid->Petugas_Update->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Petugas_Update" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Petugas_Update" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Petugas_Update" value="<?= HtmlEncode($Grid->Petugas_Update->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Tanggal_Update->Visible) { // Tanggal_Update ?>
        <td data-name="Tanggal_Update"<?= $Grid->Tanggal_Update->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Tanggal_Update" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Tanggal_Update" id="o<?= $Grid->RowIndex ?>_Tanggal_Update" value="<?= HtmlEncode($Grid->Tanggal_Update->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Tanggal_Update" class="el_penggunaan_pestisida_Tanggal_Update">
<span<?= $Grid->Tanggal_Update->viewAttributes() ?>>
<?= $Grid->Tanggal_Update->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Tanggal_Update" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Tanggal_Update" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Tanggal_Update" value="<?= HtmlEncode($Grid->Tanggal_Update->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Tanggal_Update" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Tanggal_Update" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Tanggal_Update" value="<?= HtmlEncode($Grid->Tanggal_Update->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Petugas_Add->Visible) { // Petugas_Add ?>
        <td data-name="Petugas_Add"<?= $Grid->Petugas_Add->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Petugas_Add" class="el_penggunaan_pestisida_Petugas_Add">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Petugas_Add" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Petugas_Add" id="x<?= $Grid->RowIndex ?>_Petugas_Add" value="<?= HtmlEncode($Grid->Petugas_Add->CurrentValue) ?>">
</span>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Petugas_Add" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Petugas_Add" id="o<?= $Grid->RowIndex ?>_Petugas_Add" value="<?= HtmlEncode($Grid->Petugas_Add->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Petugas_Add" class="el_penggunaan_pestisida_Petugas_Add">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Petugas_Add" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Petugas_Add" id="x<?= $Grid->RowIndex ?>_Petugas_Add" value="<?= HtmlEncode($Grid->Petugas_Add->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Petugas_Add" class="el_penggunaan_pestisida_Petugas_Add">
<span<?= $Grid->Petugas_Add->viewAttributes() ?>>
<?= $Grid->Petugas_Add->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Petugas_Add" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Petugas_Add" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Petugas_Add" value="<?= HtmlEncode($Grid->Petugas_Add->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Petugas_Add" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Petugas_Add" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Petugas_Add" value="<?= HtmlEncode($Grid->Petugas_Add->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Tanggal_Add->Visible) { // Tanggal_Add ?>
        <td data-name="Tanggal_Add"<?= $Grid->Tanggal_Add->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Tanggal_Add" class="el_penggunaan_pestisida_Tanggal_Add">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Tanggal_Add" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Tanggal_Add" id="x<?= $Grid->RowIndex ?>_Tanggal_Add" value="<?= HtmlEncode($Grid->Tanggal_Add->CurrentValue) ?>">
</span>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Tanggal_Add" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Tanggal_Add" id="o<?= $Grid->RowIndex ?>_Tanggal_Add" value="<?= HtmlEncode($Grid->Tanggal_Add->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Tanggal_Add" class="el_penggunaan_pestisida_Tanggal_Add">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Tanggal_Add" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Tanggal_Add" id="x<?= $Grid->RowIndex ?>_Tanggal_Add" value="<?= HtmlEncode($Grid->Tanggal_Add->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_penggunaan_pestisida_Tanggal_Add" class="el_penggunaan_pestisida_Tanggal_Add">
<span<?= $Grid->Tanggal_Add->viewAttributes() ?>>
<?= $Grid->Tanggal_Add->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Tanggal_Add" data-hidden="1" name="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Tanggal_Add" id="fpenggunaan_pestisidagrid$x<?= $Grid->RowIndex ?>_Tanggal_Add" value="<?= HtmlEncode($Grid->Tanggal_Add->FormValue) ?>">
<input type="hidden" data-table="penggunaan_pestisida" data-field="x_Tanggal_Add" data-hidden="1" data-old name="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Tanggal_Add" id="fpenggunaan_pestisidagrid$o<?= $Grid->RowIndex ?>_Tanggal_Add" value="<?= HtmlEncode($Grid->Tanggal_Add->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == ROWTYPE_ADD || $Grid->RowType == ROWTYPE_EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fpenggunaan_pestisidagrid","load"], () => fpenggunaan_pestisidagrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking
    if (
        $Grid->Recordset &&
        !$Grid->Recordset->EOF &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->Recordset->moveNext();
    }
    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpenggunaan_pestisidagrid">
</div><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Grid->Recordset) {
    $Grid->Recordset->close();
}
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("penggunaan_pestisida");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
