<?php

namespace PHPMaker2023\co;

// Page object
$BibitList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bibit: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbibitsrch" id="fbibitsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="on">
<div id="fbibitsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { bibit: currentTable } });
var currentForm;
var fbibitsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbibitsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [], fields.id.isInvalid],
            ["tgl_tanam", [ew.Validators.datetime(fields.tgl_tanam.clientFormatPattern)], fields.tgl_tanam.isInvalid],
            ["y_tgl_tanam", [ew.Validators.between], false],
            ["jumlah_tanam", [], fields.jumlah_tanam.isInvalid],
            ["jumlah_panen_stek", [], fields.jumlah_panen_stek.isInvalid],
            ["ket", [], fields.ket.isInvalid],
            ["var_nama", [], fields.var_nama.isInvalid],
            ["id_gen", [], fields.id_gen.isInvalid],
            ["k_id_kontrak", [], fields.k_id_kontrak.isInvalid],
            ["co_nama", [], fields.co_nama.isInvalid],
            ["koord_nama", [], fields.koord_nama.isInvalid],
            ["pet_nama", [], fields.pet_nama.isInvalid],
            ["prov_nama", [], fields.prov_nama.isInvalid],
            ["kab_nama", [], fields.kab_nama.isInvalid],
            ["kec_nama", [], fields.kec_nama.isInvalid],
            ["desa_nama", [], fields.desa_nama.isInvalid],
            ["id_asal_bibit", [], fields.id_asal_bibit.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "var_nama": <?= $Page->var_nama->toClientList($Page) ?>,
            "id_gen": <?= $Page->id_gen->toClientList($Page) ?>,
            "k_id_kontrak": <?= $Page->k_id_kontrak->toClientList($Page) ?>,
            "co_nama": <?= $Page->co_nama->toClientList($Page) ?>,
            "koord_nama": <?= $Page->koord_nama->toClientList($Page) ?>,
            "pet_nama": <?= $Page->pet_nama->toClientList($Page) ?>,
            "prov_nama": <?= $Page->prov_nama->toClientList($Page) ?>,
            "kab_nama": <?= $Page->kab_nama->toClientList($Page) ?>,
            "kec_nama": <?= $Page->kec_nama->toClientList($Page) ?>,
            "desa_nama": <?= $Page->desa_nama->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = ROWTYPE_SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->tgl_tanam->Visible) { // tgl_tanam ?>
<?php
if (!$Page->tgl_tanam->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_tgl_tanam" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->tgl_tanam->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_tgl_tanam" class="ew-search-caption ew-label"><?= $Page->tgl_tanam->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_tgl_tanam" id="z_tgl_tanam" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->tgl_tanam->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->tgl_tanam->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_bibit_tgl_tanam" class="ew-search-field">
<input type="<?= $Page->tgl_tanam->getInputTextType() ?>" name="x_tgl_tanam" id="x_tgl_tanam" data-table="bibit" data-field="x_tgl_tanam" value="<?= $Page->tgl_tanam->EditValue ?>" placeholder="<?= HtmlEncode($Page->tgl_tanam->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tgl_tanam->formatPattern()) ?>"<?= $Page->tgl_tanam->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tgl_tanam->getErrorMessage(false) ?></div>
<?php if (!$Page->tgl_tanam->ReadOnly && !$Page->tgl_tanam->Disabled && !isset($Page->tgl_tanam->EditAttrs["readonly"]) && !isset($Page->tgl_tanam->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbibitsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fbibitsrch", "x_tgl_tanam", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_bibit_tgl_tanam" class="ew-search-field2 d-none">
<input type="<?= $Page->tgl_tanam->getInputTextType() ?>" name="y_tgl_tanam" id="y_tgl_tanam" data-table="bibit" data-field="x_tgl_tanam" value="<?= $Page->tgl_tanam->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->tgl_tanam->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tgl_tanam->formatPattern()) ?>"<?= $Page->tgl_tanam->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tgl_tanam->getErrorMessage(false) ?></div>
<?php if (!$Page->tgl_tanam->ReadOnly && !$Page->tgl_tanam->Disabled && !isset($Page->tgl_tanam->EditAttrs["readonly"]) && !isset($Page->tgl_tanam->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbibitsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.isDark() ? "dark" : "auto"
            }
        };
    ew.createDateTimePicker("fbibitsrch", "y_tgl_tanam", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->var_nama->Visible) { // var_nama ?>
<?php
if (!$Page->var_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_var_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->var_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_var_nama" class="ew-search-caption ew-label"><?= $Page->var_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_var_nama" id="z_var_nama" value="LIKE">
</div>
        </div>
        <div id="el_bibit_var_nama" class="ew-search-field">
    <select
        id="x_var_nama"
        name="x_var_nama"
        class="form-select ew-select<?= $Page->var_nama->isInvalidClass() ?>"
        <?php if (!$Page->var_nama->IsNativeSelect) { ?>
        data-select2-id="fbibitsrch_x_var_nama"
        <?php } ?>
        data-table="bibit"
        data-field="x_var_nama"
        data-value-separator="<?= $Page->var_nama->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->var_nama->getPlaceHolder()) ?>"
        <?= $Page->var_nama->editAttributes() ?>>
        <?= $Page->var_nama->selectOptionListHtml("x_var_nama") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->var_nama->getErrorMessage(false) ?></div>
<?= $Page->var_nama->Lookup->getParamTag($Page, "p_x_var_nama") ?>
<?php if (!$Page->var_nama->IsNativeSelect) { ?>
<script>
loadjs.ready("fbibitsrch", function() {
    var options = { name: "x_var_nama", selectId: "fbibitsrch_x_var_nama" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbibitsrch.lists.var_nama?.lookupOptions.length) {
        options.data = { id: "x_var_nama", form: "fbibitsrch" };
    } else {
        options.ajax = { id: "x_var_nama", form: "fbibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bibit.fields.var_nama.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->id_gen->Visible) { // id_gen ?>
<?php
if (!$Page->id_gen->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_id_gen" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->id_gen->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_id_gen" class="ew-search-caption ew-label"><?= $Page->id_gen->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_id_gen" id="z_id_gen" value="LIKE">
</div>
        </div>
        <div id="el_bibit_id_gen" class="ew-search-field">
    <select
        id="x_id_gen"
        name="x_id_gen"
        class="form-select ew-select<?= $Page->id_gen->isInvalidClass() ?>"
        <?php if (!$Page->id_gen->IsNativeSelect) { ?>
        data-select2-id="fbibitsrch_x_id_gen"
        <?php } ?>
        data-table="bibit"
        data-field="x_id_gen"
        data-value-separator="<?= $Page->id_gen->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->id_gen->getPlaceHolder()) ?>"
        <?= $Page->id_gen->editAttributes() ?>>
        <?= $Page->id_gen->selectOptionListHtml("x_id_gen") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->id_gen->getErrorMessage(false) ?></div>
<?= $Page->id_gen->Lookup->getParamTag($Page, "p_x_id_gen") ?>
<?php if (!$Page->id_gen->IsNativeSelect) { ?>
<script>
loadjs.ready("fbibitsrch", function() {
    var options = { name: "x_id_gen", selectId: "fbibitsrch_x_id_gen" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbibitsrch.lists.id_gen?.lookupOptions.length) {
        options.data = { id: "x_id_gen", form: "fbibitsrch" };
    } else {
        options.ajax = { id: "x_id_gen", form: "fbibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bibit.fields.id_gen.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { // k_id_kontrak ?>
<?php
if (!$Page->k_id_kontrak->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_k_id_kontrak" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->k_id_kontrak->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_k_id_kontrak" class="ew-search-caption ew-label"><?= $Page->k_id_kontrak->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_k_id_kontrak" id="z_k_id_kontrak" value="LIKE">
</div>
        </div>
        <div id="el_bibit_k_id_kontrak" class="ew-search-field">
    <select
        id="x_k_id_kontrak"
        name="x_k_id_kontrak"
        class="form-select ew-select<?= $Page->k_id_kontrak->isInvalidClass() ?>"
        <?php if (!$Page->k_id_kontrak->IsNativeSelect) { ?>
        data-select2-id="fbibitsrch_x_k_id_kontrak"
        <?php } ?>
        data-table="bibit"
        data-field="x_k_id_kontrak"
        data-value-separator="<?= $Page->k_id_kontrak->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->k_id_kontrak->getPlaceHolder()) ?>"
        <?= $Page->k_id_kontrak->editAttributes() ?>>
        <?= $Page->k_id_kontrak->selectOptionListHtml("x_k_id_kontrak") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->k_id_kontrak->getErrorMessage(false) ?></div>
<?= $Page->k_id_kontrak->Lookup->getParamTag($Page, "p_x_k_id_kontrak") ?>
<?php if (!$Page->k_id_kontrak->IsNativeSelect) { ?>
<script>
loadjs.ready("fbibitsrch", function() {
    var options = { name: "x_k_id_kontrak", selectId: "fbibitsrch_x_k_id_kontrak" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbibitsrch.lists.k_id_kontrak?.lookupOptions.length) {
        options.data = { id: "x_k_id_kontrak", form: "fbibitsrch" };
    } else {
        options.ajax = { id: "x_k_id_kontrak", form: "fbibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bibit.fields.k_id_kontrak.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->co_nama->Visible) { // co_nama ?>
<?php
if (!$Page->co_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_co_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->co_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_co_nama" class="ew-search-caption ew-label"><?= $Page->co_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_co_nama" id="z_co_nama" value="LIKE">
</div>
        </div>
        <div id="el_bibit_co_nama" class="ew-search-field">
    <select
        id="x_co_nama"
        name="x_co_nama"
        class="form-select ew-select<?= $Page->co_nama->isInvalidClass() ?>"
        <?php if (!$Page->co_nama->IsNativeSelect) { ?>
        data-select2-id="fbibitsrch_x_co_nama"
        <?php } ?>
        data-table="bibit"
        data-field="x_co_nama"
        data-value-separator="<?= $Page->co_nama->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->co_nama->getPlaceHolder()) ?>"
        <?= $Page->co_nama->editAttributes() ?>>
        <?= $Page->co_nama->selectOptionListHtml("x_co_nama") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->co_nama->getErrorMessage(false) ?></div>
<?= $Page->co_nama->Lookup->getParamTag($Page, "p_x_co_nama") ?>
<?php if (!$Page->co_nama->IsNativeSelect) { ?>
<script>
loadjs.ready("fbibitsrch", function() {
    var options = { name: "x_co_nama", selectId: "fbibitsrch_x_co_nama" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbibitsrch.lists.co_nama?.lookupOptions.length) {
        options.data = { id: "x_co_nama", form: "fbibitsrch" };
    } else {
        options.ajax = { id: "x_co_nama", form: "fbibitsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.bibit.fields.co_nama.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->koord_nama->Visible) { // koord_nama ?>
<?php
if (!$Page->koord_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_koord_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->koord_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->koord_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_koord_nama" id="z_koord_nama" value="LIKE">
</div>
        </div>
        <div id="el_bibit_koord_nama" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->koord_nama->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_koord_nama" class="ew-auto-suggest">
    <input type="<?= $Page->koord_nama->getInputTextType() ?>" class="form-control" name="sv_x_koord_nama" id="sv_x_koord_nama" value="<?= RemoveHtml($Page->koord_nama->EditValue) ?>" autocomplete="off" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->koord_nama->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->koord_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->koord_nama->formatPattern()) ?>"<?= $Page->koord_nama->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bibit" data-field="x_koord_nama" data-input="sv_x_koord_nama" data-value-separator="<?= $Page->koord_nama->displayValueSeparatorAttribute() ?>" name="x_koord_nama" id="x_koord_nama" value="<?= HtmlEncode($Page->koord_nama->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->koord_nama->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbibitsrch", function() {
    fbibitsrch.createAutoSuggest(Object.assign({"id":"x_koord_nama","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->koord_nama->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bibit.fields.koord_nama.autoSuggestOptions));
});
</script>
<?= $Page->koord_nama->Lookup->getParamTag($Page, "p_x_koord_nama") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pet_nama->Visible) { // pet_nama ?>
<?php
if (!$Page->pet_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pet_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pet_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->pet_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pet_nama" id="z_pet_nama" value="LIKE">
</div>
        </div>
        <div id="el_bibit_pet_nama" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->pet_nama->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_pet_nama" class="ew-auto-suggest">
    <input type="<?= $Page->pet_nama->getInputTextType() ?>" class="form-control" name="sv_x_pet_nama" id="sv_x_pet_nama" value="<?= RemoveHtml($Page->pet_nama->EditValue) ?>" autocomplete="off" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->pet_nama->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->pet_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pet_nama->formatPattern()) ?>"<?= $Page->pet_nama->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bibit" data-field="x_pet_nama" data-input="sv_x_pet_nama" data-value-separator="<?= $Page->pet_nama->displayValueSeparatorAttribute() ?>" name="x_pet_nama" id="x_pet_nama" value="<?= HtmlEncode($Page->pet_nama->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->pet_nama->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbibitsrch", function() {
    fbibitsrch.createAutoSuggest(Object.assign({"id":"x_pet_nama","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->pet_nama->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bibit.fields.pet_nama.autoSuggestOptions));
});
</script>
<?= $Page->pet_nama->Lookup->getParamTag($Page, "p_x_pet_nama") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->prov_nama->Visible) { // prov_nama ?>
<?php
if (!$Page->prov_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_prov_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->prov_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->prov_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_prov_nama" id="z_prov_nama" value="LIKE">
</div>
        </div>
        <div id="el_bibit_prov_nama" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->prov_nama->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_prov_nama" class="ew-auto-suggest">
    <input type="<?= $Page->prov_nama->getInputTextType() ?>" class="form-control" name="sv_x_prov_nama" id="sv_x_prov_nama" value="<?= RemoveHtml($Page->prov_nama->EditValue) ?>" autocomplete="off" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->prov_nama->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->prov_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->prov_nama->formatPattern()) ?>"<?= $Page->prov_nama->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bibit" data-field="x_prov_nama" data-input="sv_x_prov_nama" data-value-separator="<?= $Page->prov_nama->displayValueSeparatorAttribute() ?>" name="x_prov_nama" id="x_prov_nama" value="<?= HtmlEncode($Page->prov_nama->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->prov_nama->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbibitsrch", function() {
    fbibitsrch.createAutoSuggest(Object.assign({"id":"x_prov_nama","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->prov_nama->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bibit.fields.prov_nama.autoSuggestOptions));
});
</script>
<?= $Page->prov_nama->Lookup->getParamTag($Page, "p_x_prov_nama") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->kab_nama->Visible) { // kab_nama ?>
<?php
if (!$Page->kab_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_kab_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->kab_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->kab_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_kab_nama" id="z_kab_nama" value="LIKE">
</div>
        </div>
        <div id="el_bibit_kab_nama" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->kab_nama->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_kab_nama" class="ew-auto-suggest">
    <input type="<?= $Page->kab_nama->getInputTextType() ?>" class="form-control" name="sv_x_kab_nama" id="sv_x_kab_nama" value="<?= RemoveHtml($Page->kab_nama->EditValue) ?>" autocomplete="off" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->kab_nama->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->kab_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->kab_nama->formatPattern()) ?>"<?= $Page->kab_nama->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bibit" data-field="x_kab_nama" data-input="sv_x_kab_nama" data-value-separator="<?= $Page->kab_nama->displayValueSeparatorAttribute() ?>" name="x_kab_nama" id="x_kab_nama" value="<?= HtmlEncode($Page->kab_nama->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->kab_nama->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbibitsrch", function() {
    fbibitsrch.createAutoSuggest(Object.assign({"id":"x_kab_nama","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->kab_nama->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bibit.fields.kab_nama.autoSuggestOptions));
});
</script>
<?= $Page->kab_nama->Lookup->getParamTag($Page, "p_x_kab_nama") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->kec_nama->Visible) { // kec_nama ?>
<?php
if (!$Page->kec_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_kec_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->kec_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->kec_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_kec_nama" id="z_kec_nama" value="LIKE">
</div>
        </div>
        <div id="el_bibit_kec_nama" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->kec_nama->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_kec_nama" class="ew-auto-suggest">
    <input type="<?= $Page->kec_nama->getInputTextType() ?>" class="form-control" name="sv_x_kec_nama" id="sv_x_kec_nama" value="<?= RemoveHtml($Page->kec_nama->EditValue) ?>" autocomplete="off" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->kec_nama->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->kec_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->kec_nama->formatPattern()) ?>"<?= $Page->kec_nama->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bibit" data-field="x_kec_nama" data-input="sv_x_kec_nama" data-value-separator="<?= $Page->kec_nama->displayValueSeparatorAttribute() ?>" name="x_kec_nama" id="x_kec_nama" value="<?= HtmlEncode($Page->kec_nama->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->kec_nama->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbibitsrch", function() {
    fbibitsrch.createAutoSuggest(Object.assign({"id":"x_kec_nama","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->kec_nama->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bibit.fields.kec_nama.autoSuggestOptions));
});
</script>
<?= $Page->kec_nama->Lookup->getParamTag($Page, "p_x_kec_nama") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->desa_nama->Visible) { // desa_nama ?>
<?php
if (!$Page->desa_nama->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_desa_nama" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->desa_nama->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->desa_nama->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_desa_nama" id="z_desa_nama" value="LIKE">
</div>
        </div>
        <div id="el_bibit_desa_nama" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->desa_nama->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_desa_nama" class="ew-auto-suggest">
    <input type="<?= $Page->desa_nama->getInputTextType() ?>" class="form-control" name="sv_x_desa_nama" id="sv_x_desa_nama" value="<?= RemoveHtml($Page->desa_nama->EditValue) ?>" autocomplete="off" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->desa_nama->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->desa_nama->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->desa_nama->formatPattern()) ?>"<?= $Page->desa_nama->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="bibit" data-field="x_desa_nama" data-input="sv_x_desa_nama" data-value-separator="<?= $Page->desa_nama->displayValueSeparatorAttribute() ?>" name="x_desa_nama" id="x_desa_nama" value="<?= HtmlEncode($Page->desa_nama->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->desa_nama->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbibitsrch", function() {
    fbibitsrch.createAutoSuggest(Object.assign({"id":"x_desa_nama","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->desa_nama->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.bibit.fields.desa_nama.autoSuggestOptions));
});
</script>
<?= $Page->desa_nama->Lookup->getParamTag($Page, "p_x_desa_nama") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbibitsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbibitsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbibitsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbibitsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="on">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="bibit">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_bibit" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_bibitlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = ROWTYPE_HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_bibit_id" class="bibit_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->tgl_tanam->Visible) { // tgl_tanam ?>
        <th data-name="tgl_tanam" class="<?= $Page->tgl_tanam->headerCellClass() ?>"><div id="elh_bibit_tgl_tanam" class="bibit_tgl_tanam"><?= $Page->renderFieldHeader($Page->tgl_tanam) ?></div></th>
<?php } ?>
<?php if ($Page->jumlah_tanam->Visible) { // jumlah_tanam ?>
        <th data-name="jumlah_tanam" class="<?= $Page->jumlah_tanam->headerCellClass() ?>"><div id="elh_bibit_jumlah_tanam" class="bibit_jumlah_tanam"><?= $Page->renderFieldHeader($Page->jumlah_tanam) ?></div></th>
<?php } ?>
<?php if ($Page->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
        <th data-name="jumlah_panen_stek" class="<?= $Page->jumlah_panen_stek->headerCellClass() ?>"><div id="elh_bibit_jumlah_panen_stek" class="bibit_jumlah_panen_stek"><?= $Page->renderFieldHeader($Page->jumlah_panen_stek) ?></div></th>
<?php } ?>
<?php if ($Page->ket->Visible) { // ket ?>
        <th data-name="ket" class="<?= $Page->ket->headerCellClass() ?>"><div id="elh_bibit_ket" class="bibit_ket"><?= $Page->renderFieldHeader($Page->ket) ?></div></th>
<?php } ?>
<?php if ($Page->var_nama->Visible) { // var_nama ?>
        <th data-name="var_nama" class="<?= $Page->var_nama->headerCellClass() ?>"><div id="elh_bibit_var_nama" class="bibit_var_nama"><?= $Page->renderFieldHeader($Page->var_nama) ?></div></th>
<?php } ?>
<?php if ($Page->id_gen->Visible) { // id_gen ?>
        <th data-name="id_gen" class="<?= $Page->id_gen->headerCellClass() ?>"><div id="elh_bibit_id_gen" class="bibit_id_gen"><?= $Page->renderFieldHeader($Page->id_gen) ?></div></th>
<?php } ?>
<?php if ($Page->k_id_kontrak->Visible) { // k_id_kontrak ?>
        <th data-name="k_id_kontrak" class="<?= $Page->k_id_kontrak->headerCellClass() ?>"><div id="elh_bibit_k_id_kontrak" class="bibit_k_id_kontrak"><?= $Page->renderFieldHeader($Page->k_id_kontrak) ?></div></th>
<?php } ?>
<?php if ($Page->co_nama->Visible) { // co_nama ?>
        <th data-name="co_nama" class="<?= $Page->co_nama->headerCellClass() ?>"><div id="elh_bibit_co_nama" class="bibit_co_nama"><?= $Page->renderFieldHeader($Page->co_nama) ?></div></th>
<?php } ?>
<?php if ($Page->koord_nama->Visible) { // koord_nama ?>
        <th data-name="koord_nama" class="<?= $Page->koord_nama->headerCellClass() ?>"><div id="elh_bibit_koord_nama" class="bibit_koord_nama"><?= $Page->renderFieldHeader($Page->koord_nama) ?></div></th>
<?php } ?>
<?php if ($Page->pet_nama->Visible) { // pet_nama ?>
        <th data-name="pet_nama" class="<?= $Page->pet_nama->headerCellClass() ?>"><div id="elh_bibit_pet_nama" class="bibit_pet_nama"><?= $Page->renderFieldHeader($Page->pet_nama) ?></div></th>
<?php } ?>
<?php if ($Page->prov_nama->Visible) { // prov_nama ?>
        <th data-name="prov_nama" class="<?= $Page->prov_nama->headerCellClass() ?>"><div id="elh_bibit_prov_nama" class="bibit_prov_nama"><?= $Page->renderFieldHeader($Page->prov_nama) ?></div></th>
<?php } ?>
<?php if ($Page->kab_nama->Visible) { // kab_nama ?>
        <th data-name="kab_nama" class="<?= $Page->kab_nama->headerCellClass() ?>"><div id="elh_bibit_kab_nama" class="bibit_kab_nama"><?= $Page->renderFieldHeader($Page->kab_nama) ?></div></th>
<?php } ?>
<?php if ($Page->kec_nama->Visible) { // kec_nama ?>
        <th data-name="kec_nama" class="<?= $Page->kec_nama->headerCellClass() ?>"><div id="elh_bibit_kec_nama" class="bibit_kec_nama"><?= $Page->renderFieldHeader($Page->kec_nama) ?></div></th>
<?php } ?>
<?php if ($Page->desa_nama->Visible) { // desa_nama ?>
        <th data-name="desa_nama" class="<?= $Page->desa_nama->headerCellClass() ?>"><div id="elh_bibit_desa_nama" class="bibit_desa_nama"><?= $Page->renderFieldHeader($Page->desa_nama) ?></div></th>
<?php } ?>
<?php if ($Page->id_asal_bibit->Visible) { // id_asal_bibit ?>
        <th data-name="id_asal_bibit" class="<?= $Page->id_asal_bibit->headerCellClass() ?>"><div id="elh_bibit_id_asal_bibit" class="bibit_id_asal_bibit"><?= $Page->renderFieldHeader($Page->id_asal_bibit) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_id" class="el_bibit_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tgl_tanam->Visible) { // tgl_tanam ?>
        <td data-name="tgl_tanam"<?= $Page->tgl_tanam->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_tgl_tanam" class="el_bibit_tgl_tanam">
<span<?= $Page->tgl_tanam->viewAttributes() ?>>
<?= $Page->tgl_tanam->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jumlah_tanam->Visible) { // jumlah_tanam ?>
        <td data-name="jumlah_tanam"<?= $Page->jumlah_tanam->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_jumlah_tanam" class="el_bibit_jumlah_tanam">
<span<?= $Page->jumlah_tanam->viewAttributes() ?>>
<?= $Page->jumlah_tanam->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jumlah_panen_stek->Visible) { // jumlah_panen_stek ?>
        <td data-name="jumlah_panen_stek"<?= $Page->jumlah_panen_stek->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_jumlah_panen_stek" class="el_bibit_jumlah_panen_stek">
<span<?= $Page->jumlah_panen_stek->viewAttributes() ?>>
<?= $Page->jumlah_panen_stek->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ket->Visible) { // ket ?>
        <td data-name="ket"<?= $Page->ket->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_ket" class="el_bibit_ket">
<span<?= $Page->ket->viewAttributes() ?>>
<?= $Page->ket->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->var_nama->Visible) { // var_nama ?>
        <td data-name="var_nama"<?= $Page->var_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_var_nama" class="el_bibit_var_nama">
<span<?= $Page->var_nama->viewAttributes() ?>>
<?= $Page->var_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->id_gen->Visible) { // id_gen ?>
        <td data-name="id_gen"<?= $Page->id_gen->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_id_gen" class="el_bibit_id_gen">
<span<?= $Page->id_gen->viewAttributes() ?>>
<?= $Page->id_gen->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->k_id_kontrak->Visible) { // k_id_kontrak ?>
        <td data-name="k_id_kontrak"<?= $Page->k_id_kontrak->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_k_id_kontrak" class="el_bibit_k_id_kontrak">
<span<?= $Page->k_id_kontrak->viewAttributes() ?>>
<?= $Page->k_id_kontrak->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->co_nama->Visible) { // co_nama ?>
        <td data-name="co_nama"<?= $Page->co_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_co_nama" class="el_bibit_co_nama">
<span<?= $Page->co_nama->viewAttributes() ?>>
<?= $Page->co_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->koord_nama->Visible) { // koord_nama ?>
        <td data-name="koord_nama"<?= $Page->koord_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_koord_nama" class="el_bibit_koord_nama">
<span<?= $Page->koord_nama->viewAttributes() ?>>
<?= $Page->koord_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pet_nama->Visible) { // pet_nama ?>
        <td data-name="pet_nama"<?= $Page->pet_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_pet_nama" class="el_bibit_pet_nama">
<span<?= $Page->pet_nama->viewAttributes() ?>>
<?= $Page->pet_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->prov_nama->Visible) { // prov_nama ?>
        <td data-name="prov_nama"<?= $Page->prov_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_prov_nama" class="el_bibit_prov_nama">
<span<?= $Page->prov_nama->viewAttributes() ?>>
<?= $Page->prov_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kab_nama->Visible) { // kab_nama ?>
        <td data-name="kab_nama"<?= $Page->kab_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_kab_nama" class="el_bibit_kab_nama">
<span<?= $Page->kab_nama->viewAttributes() ?>>
<?= $Page->kab_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->kec_nama->Visible) { // kec_nama ?>
        <td data-name="kec_nama"<?= $Page->kec_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_kec_nama" class="el_bibit_kec_nama">
<span<?= $Page->kec_nama->viewAttributes() ?>>
<?= $Page->kec_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->desa_nama->Visible) { // desa_nama ?>
        <td data-name="desa_nama"<?= $Page->desa_nama->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_desa_nama" class="el_bibit_desa_nama">
<span<?= $Page->desa_nama->viewAttributes() ?>>
<?= $Page->desa_nama->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->id_asal_bibit->Visible) { // id_asal_bibit ?>
        <td data-name="id_asal_bibit"<?= $Page->id_asal_bibit->cellAttributes() ?>>
<span id="el<?= $Page->RowCount ?>_bibit_id_asal_bibit" class="el_bibit_id_asal_bibit">
<span<?= $Page->id_asal_bibit->viewAttributes() ?>>
<?= $Page->id_asal_bibit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }
    if (
        $Page->Recordset &&
        !$Page->Recordset->EOF &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->Recordset->moveNext();
    }
    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Page->Recordset) {
    $Page->Recordset->close();
}
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("bibit");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
