<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class TanamBibitEdit extends TanamBibit
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "TanamBibitEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "TanamBibitEdit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->tgl_tanam->setVisibility();
        $this->jenis_lahan->setVisibility();
        $this->varietas->setVisibility();
        $this->jumlah_tanam->setVisibility();
        $this->ket->setVisibility();
        $this->id_kontrak_tanam->setVisibility();
        $this->gen_bibit->setVisibility();
        $this->id_asal_bibit->setVisibility();
        $this->jumlah_panen_stek->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'tanam_bibit';
        $this->TableName = 'tanam_bibit';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (tanam_bibit)
        if (!isset($GLOBALS["tanam_bibit"]) || get_class($GLOBALS["tanam_bibit"]) == PROJECT_NAMESPACE . "tanam_bibit") {
            $GLOBALS["tanam_bibit"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'tanam_bibit');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "TanamBibitView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->jenis_lahan);
        $this->setupLookupOptions($this->varietas);
        $this->setupLookupOptions($this->id_kontrak_tanam);
        $this->setupLookupOptions($this->gen_bibit);
        $this->setupLookupOptions($this->id_asal_bibit);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load recordset
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("TanamBibitList"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "TanamBibitList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) {
                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "TanamBibitList") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "TanamBibitList"; // Return list page content
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = ROWTYPE_EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'tgl_tanam' first before field var 'x_tgl_tanam'
        $val = $CurrentForm->hasValue("tgl_tanam") ? $CurrentForm->getValue("tgl_tanam") : $CurrentForm->getValue("x_tgl_tanam");
        if (!$this->tgl_tanam->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tgl_tanam->Visible = false; // Disable update for API request
            } else {
                $this->tgl_tanam->setFormValue($val);
            }
            $this->tgl_tanam->CurrentValue = UnFormatDateTime($this->tgl_tanam->CurrentValue, $this->tgl_tanam->formatPattern());
        }

        // Check field name 'jenis_lahan' first before field var 'x_jenis_lahan'
        $val = $CurrentForm->hasValue("jenis_lahan") ? $CurrentForm->getValue("jenis_lahan") : $CurrentForm->getValue("x_jenis_lahan");
        if (!$this->jenis_lahan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jenis_lahan->Visible = false; // Disable update for API request
            } else {
                $this->jenis_lahan->setFormValue($val);
            }
        }

        // Check field name 'varietas' first before field var 'x_varietas'
        $val = $CurrentForm->hasValue("varietas") ? $CurrentForm->getValue("varietas") : $CurrentForm->getValue("x_varietas");
        if (!$this->varietas->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->varietas->Visible = false; // Disable update for API request
            } else {
                $this->varietas->setFormValue($val);
            }
        }

        // Check field name 'jumlah_tanam' first before field var 'x_jumlah_tanam'
        $val = $CurrentForm->hasValue("jumlah_tanam") ? $CurrentForm->getValue("jumlah_tanam") : $CurrentForm->getValue("x_jumlah_tanam");
        if (!$this->jumlah_tanam->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jumlah_tanam->Visible = false; // Disable update for API request
            } else {
                $this->jumlah_tanam->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ket' first before field var 'x_ket'
        $val = $CurrentForm->hasValue("ket") ? $CurrentForm->getValue("ket") : $CurrentForm->getValue("x_ket");
        if (!$this->ket->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ket->Visible = false; // Disable update for API request
            } else {
                $this->ket->setFormValue($val);
            }
        }

        // Check field name 'id_kontrak_tanam' first before field var 'x_id_kontrak_tanam'
        $val = $CurrentForm->hasValue("id_kontrak_tanam") ? $CurrentForm->getValue("id_kontrak_tanam") : $CurrentForm->getValue("x_id_kontrak_tanam");
        if (!$this->id_kontrak_tanam->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id_kontrak_tanam->Visible = false; // Disable update for API request
            } else {
                $this->id_kontrak_tanam->setFormValue($val);
            }
        }

        // Check field name 'gen_bibit' first before field var 'x_gen_bibit'
        $val = $CurrentForm->hasValue("gen_bibit") ? $CurrentForm->getValue("gen_bibit") : $CurrentForm->getValue("x_gen_bibit");
        if (!$this->gen_bibit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gen_bibit->Visible = false; // Disable update for API request
            } else {
                $this->gen_bibit->setFormValue($val);
            }
        }

        // Check field name 'id_asal_bibit' first before field var 'x_id_asal_bibit'
        $val = $CurrentForm->hasValue("id_asal_bibit") ? $CurrentForm->getValue("id_asal_bibit") : $CurrentForm->getValue("x_id_asal_bibit");
        if (!$this->id_asal_bibit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->id_asal_bibit->Visible = false; // Disable update for API request
            } else {
                $this->id_asal_bibit->setFormValue($val);
            }
        }

        // Check field name 'jumlah_panen_stek' first before field var 'x_jumlah_panen_stek'
        $val = $CurrentForm->hasValue("jumlah_panen_stek") ? $CurrentForm->getValue("jumlah_panen_stek") : $CurrentForm->getValue("x_jumlah_panen_stek");
        if (!$this->jumlah_panen_stek->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->jumlah_panen_stek->Visible = false; // Disable update for API request
            } else {
                $this->jumlah_panen_stek->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->tgl_tanam->CurrentValue = $this->tgl_tanam->FormValue;
        $this->tgl_tanam->CurrentValue = UnFormatDateTime($this->tgl_tanam->CurrentValue, $this->tgl_tanam->formatPattern());
        $this->jenis_lahan->CurrentValue = $this->jenis_lahan->FormValue;
        $this->varietas->CurrentValue = $this->varietas->FormValue;
        $this->jumlah_tanam->CurrentValue = $this->jumlah_tanam->FormValue;
        $this->ket->CurrentValue = $this->ket->FormValue;
        $this->id_kontrak_tanam->CurrentValue = $this->id_kontrak_tanam->FormValue;
        $this->gen_bibit->CurrentValue = $this->gen_bibit->FormValue;
        $this->id_asal_bibit->CurrentValue = $this->id_asal_bibit->FormValue;
        $this->jumlah_panen_stek->CurrentValue = $this->jumlah_panen_stek->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->tgl_tanam->setDbValue($row['tgl_tanam']);
        $this->jenis_lahan->setDbValue($row['jenis_lahan']);
        $this->varietas->setDbValue($row['varietas']);
        $this->jumlah_tanam->setDbValue($row['jumlah_tanam']);
        $this->ket->setDbValue($row['ket']);
        $this->id_kontrak_tanam->setDbValue($row['id_kontrak_tanam']);
        $this->gen_bibit->setDbValue($row['gen_bibit']);
        $this->id_asal_bibit->setDbValue($row['id_asal_bibit']);
        $this->jumlah_panen_stek->setDbValue($row['jumlah_panen_stek']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['tgl_tanam'] = $this->tgl_tanam->DefaultValue;
        $row['jenis_lahan'] = $this->jenis_lahan->DefaultValue;
        $row['varietas'] = $this->varietas->DefaultValue;
        $row['jumlah_tanam'] = $this->jumlah_tanam->DefaultValue;
        $row['ket'] = $this->ket->DefaultValue;
        $row['id_kontrak_tanam'] = $this->id_kontrak_tanam->DefaultValue;
        $row['gen_bibit'] = $this->gen_bibit->DefaultValue;
        $row['id_asal_bibit'] = $this->id_asal_bibit->DefaultValue;
        $row['jumlah_panen_stek'] = $this->jumlah_panen_stek->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // tgl_tanam
        $this->tgl_tanam->RowCssClass = "row";

        // jenis_lahan
        $this->jenis_lahan->RowCssClass = "row";

        // varietas
        $this->varietas->RowCssClass = "row";

        // jumlah_tanam
        $this->jumlah_tanam->RowCssClass = "row";

        // ket
        $this->ket->RowCssClass = "row";

        // id_kontrak_tanam
        $this->id_kontrak_tanam->RowCssClass = "row";

        // gen_bibit
        $this->gen_bibit->RowCssClass = "row";

        // id_asal_bibit
        $this->id_asal_bibit->RowCssClass = "row";

        // jumlah_panen_stek
        $this->jumlah_panen_stek->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // tgl_tanam
            $this->tgl_tanam->ViewValue = $this->tgl_tanam->CurrentValue;
            $this->tgl_tanam->ViewValue = FormatDateTime($this->tgl_tanam->ViewValue, $this->tgl_tanam->formatPattern());

            // jenis_lahan
            $curVal = strval($this->jenis_lahan->CurrentValue);
            if ($curVal != "") {
                $this->jenis_lahan->ViewValue = $this->jenis_lahan->lookupCacheOption($curVal);
                if ($this->jenis_lahan->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`jenis_lahan_bibit`", "=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->jenis_lahan->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->jenis_lahan->Lookup->renderViewRow($rswrk[0]);
                        $this->jenis_lahan->ViewValue = $this->jenis_lahan->displayValue($arwrk);
                    } else {
                        $this->jenis_lahan->ViewValue = $this->jenis_lahan->CurrentValue;
                    }
                }
            } else {
                $this->jenis_lahan->ViewValue = null;
            }

            // varietas
            $curVal = strval($this->varietas->CurrentValue);
            if ($curVal != "") {
                $this->varietas->ViewValue = $this->varietas->lookupCacheOption($curVal);
                if ($this->varietas->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->varietas->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->varietas->Lookup->renderViewRow($rswrk[0]);
                        $this->varietas->ViewValue = $this->varietas->displayValue($arwrk);
                    } else {
                        $this->varietas->ViewValue = $this->varietas->CurrentValue;
                    }
                }
            } else {
                $this->varietas->ViewValue = null;
            }

            // jumlah_tanam
            $this->jumlah_tanam->ViewValue = $this->jumlah_tanam->CurrentValue;
            $this->jumlah_tanam->ViewValue = FormatNumber($this->jumlah_tanam->ViewValue, $this->jumlah_tanam->formatPattern());

            // ket
            $this->ket->ViewValue = $this->ket->CurrentValue;

            // id_kontrak_tanam
            $curVal = strval($this->id_kontrak_tanam->CurrentValue);
            if ($curVal != "") {
                $this->id_kontrak_tanam->ViewValue = $this->id_kontrak_tanam->lookupCacheOption($curVal);
                if ($this->id_kontrak_tanam->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`k_id_kontrak`", "=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->id_kontrak_tanam->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_kontrak_tanam->Lookup->renderViewRow($rswrk[0]);
                        $this->id_kontrak_tanam->ViewValue = $this->id_kontrak_tanam->displayValue($arwrk);
                    } else {
                        $this->id_kontrak_tanam->ViewValue = $this->id_kontrak_tanam->CurrentValue;
                    }
                }
            } else {
                $this->id_kontrak_tanam->ViewValue = null;
            }

            // gen_bibit
            $curVal = strval($this->gen_bibit->CurrentValue);
            if ($curVal != "") {
                $this->gen_bibit->ViewValue = $this->gen_bibit->lookupCacheOption($curVal);
                if ($this->gen_bibit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`id_gen`", "=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->gen_bibit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->gen_bibit->Lookup->renderViewRow($rswrk[0]);
                        $this->gen_bibit->ViewValue = $this->gen_bibit->displayValue($arwrk);
                    } else {
                        $this->gen_bibit->ViewValue = $this->gen_bibit->CurrentValue;
                    }
                }
            } else {
                $this->gen_bibit->ViewValue = null;
            }

            // id_asal_bibit
            $curVal = strval($this->id_asal_bibit->CurrentValue);
            if ($curVal != "") {
                $this->id_asal_bibit->ViewValue = $this->id_asal_bibit->lookupCacheOption($curVal);
                if ($this->id_asal_bibit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->id_asal_bibit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->id_asal_bibit->Lookup->renderViewRow($rswrk[0]);
                        $this->id_asal_bibit->ViewValue = $this->id_asal_bibit->displayValue($arwrk);
                    } else {
                        $this->id_asal_bibit->ViewValue = $this->id_asal_bibit->CurrentValue;
                    }
                }
            } else {
                $this->id_asal_bibit->ViewValue = null;
            }

            // jumlah_panen_stek
            $this->jumlah_panen_stek->ViewValue = $this->jumlah_panen_stek->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // tgl_tanam
            $this->tgl_tanam->HrefValue = "";
            $this->tgl_tanam->TooltipValue = "";

            // jenis_lahan
            $this->jenis_lahan->HrefValue = "";
            $this->jenis_lahan->TooltipValue = "";

            // varietas
            $this->varietas->HrefValue = "";
            $this->varietas->TooltipValue = "";

            // jumlah_tanam
            $this->jumlah_tanam->HrefValue = "";

            // ket
            $this->ket->HrefValue = "";

            // id_kontrak_tanam
            $this->id_kontrak_tanam->HrefValue = "";

            // gen_bibit
            $this->gen_bibit->HrefValue = "";

            // id_asal_bibit
            $this->id_asal_bibit->HrefValue = "";

            // jumlah_panen_stek
            $this->jumlah_panen_stek->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // tgl_tanam
            $this->tgl_tanam->setupEditAttributes();
            $this->tgl_tanam->EditValue = $this->tgl_tanam->CurrentValue;
            $this->tgl_tanam->EditValue = FormatDateTime($this->tgl_tanam->EditValue, $this->tgl_tanam->formatPattern());

            // jenis_lahan
            $this->jenis_lahan->setupEditAttributes();
            $curVal = strval($this->jenis_lahan->CurrentValue);
            if ($curVal != "") {
                $this->jenis_lahan->EditValue = $this->jenis_lahan->lookupCacheOption($curVal);
                if ($this->jenis_lahan->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`jenis_lahan_bibit`", "=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->jenis_lahan->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->jenis_lahan->Lookup->renderViewRow($rswrk[0]);
                        $this->jenis_lahan->EditValue = $this->jenis_lahan->displayValue($arwrk);
                    } else {
                        $this->jenis_lahan->EditValue = $this->jenis_lahan->CurrentValue;
                    }
                }
            } else {
                $this->jenis_lahan->EditValue = null;
            }

            // varietas
            $this->varietas->setupEditAttributes();
            $curVal = strval($this->varietas->CurrentValue);
            if ($curVal != "") {
                $this->varietas->EditValue = $this->varietas->lookupCacheOption($curVal);
                if ($this->varietas->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->varietas->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->varietas->Lookup->renderViewRow($rswrk[0]);
                        $this->varietas->EditValue = $this->varietas->displayValue($arwrk);
                    } else {
                        $this->varietas->EditValue = $this->varietas->CurrentValue;
                    }
                }
            } else {
                $this->varietas->EditValue = null;
            }

            // jumlah_tanam
            $this->jumlah_tanam->setupEditAttributes();
            $this->jumlah_tanam->EditValue = HtmlEncode($this->jumlah_tanam->CurrentValue);
            $this->jumlah_tanam->PlaceHolder = RemoveHtml($this->jumlah_tanam->caption());
            if (strval($this->jumlah_tanam->EditValue) != "" && is_numeric($this->jumlah_tanam->EditValue)) {
                $this->jumlah_tanam->EditValue = FormatNumber($this->jumlah_tanam->EditValue, null);
            }

            // ket
            $this->ket->setupEditAttributes();
            $this->ket->EditValue = HtmlEncode($this->ket->CurrentValue);
            $this->ket->PlaceHolder = RemoveHtml($this->ket->caption());

            // id_kontrak_tanam
            $this->id_kontrak_tanam->setupEditAttributes();
            $curVal = trim(strval($this->id_kontrak_tanam->CurrentValue));
            if ($curVal != "") {
                $this->id_kontrak_tanam->ViewValue = $this->id_kontrak_tanam->lookupCacheOption($curVal);
            } else {
                $this->id_kontrak_tanam->ViewValue = $this->id_kontrak_tanam->Lookup !== null && is_array($this->id_kontrak_tanam->lookupOptions()) && count($this->id_kontrak_tanam->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->id_kontrak_tanam->ViewValue !== null) { // Load from cache
                $this->id_kontrak_tanam->EditValue = array_values($this->id_kontrak_tanam->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`k_id_kontrak`", "=", $this->id_kontrak_tanam->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->id_kontrak_tanam->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->id_kontrak_tanam->Lookup->renderViewRow($row);
                }
                $this->id_kontrak_tanam->EditValue = $arwrk;
            }
            $this->id_kontrak_tanam->PlaceHolder = RemoveHtml($this->id_kontrak_tanam->caption());

            // gen_bibit
            $this->gen_bibit->setupEditAttributes();
            $curVal = trim(strval($this->gen_bibit->CurrentValue));
            if ($curVal != "") {
                $this->gen_bibit->ViewValue = $this->gen_bibit->lookupCacheOption($curVal);
            } else {
                $this->gen_bibit->ViewValue = $this->gen_bibit->Lookup !== null && is_array($this->gen_bibit->lookupOptions()) && count($this->gen_bibit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->gen_bibit->ViewValue !== null) { // Load from cache
                $this->gen_bibit->EditValue = array_values($this->gen_bibit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`id_gen`", "=", $this->gen_bibit->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->gen_bibit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->gen_bibit->EditValue = $arwrk;
            }
            $this->gen_bibit->PlaceHolder = RemoveHtml($this->gen_bibit->caption());

            // id_asal_bibit
            $this->id_asal_bibit->setupEditAttributes();
            $curVal = trim(strval($this->id_asal_bibit->CurrentValue));
            if ($curVal != "") {
                $this->id_asal_bibit->ViewValue = $this->id_asal_bibit->lookupCacheOption($curVal);
            } else {
                $this->id_asal_bibit->ViewValue = $this->id_asal_bibit->Lookup !== null && is_array($this->id_asal_bibit->lookupOptions()) && count($this->id_asal_bibit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->id_asal_bibit->ViewValue !== null) { // Load from cache
                $this->id_asal_bibit->EditValue = array_values($this->id_asal_bibit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`id`", "=", $this->id_asal_bibit->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->id_asal_bibit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->id_asal_bibit->Lookup->renderViewRow($row);
                }
                $this->id_asal_bibit->EditValue = $arwrk;
            }
            $this->id_asal_bibit->PlaceHolder = RemoveHtml($this->id_asal_bibit->caption());

            // jumlah_panen_stek
            $this->jumlah_panen_stek->setupEditAttributes();
            $this->jumlah_panen_stek->EditValue = HtmlEncode($this->jumlah_panen_stek->CurrentValue);
            $this->jumlah_panen_stek->PlaceHolder = RemoveHtml($this->jumlah_panen_stek->caption());
            if (strval($this->jumlah_panen_stek->EditValue) != "" && is_numeric($this->jumlah_panen_stek->EditValue)) {
                $this->jumlah_panen_stek->EditValue = $this->jumlah_panen_stek->EditValue;
            }

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // tgl_tanam
            $this->tgl_tanam->HrefValue = "";
            $this->tgl_tanam->TooltipValue = "";

            // jenis_lahan
            $this->jenis_lahan->HrefValue = "";
            $this->jenis_lahan->TooltipValue = "";

            // varietas
            $this->varietas->HrefValue = "";
            $this->varietas->TooltipValue = "";

            // jumlah_tanam
            $this->jumlah_tanam->HrefValue = "";

            // ket
            $this->ket->HrefValue = "";

            // id_kontrak_tanam
            $this->id_kontrak_tanam->HrefValue = "";

            // gen_bibit
            $this->gen_bibit->HrefValue = "";

            // id_asal_bibit
            $this->id_asal_bibit->HrefValue = "";

            // jumlah_panen_stek
            $this->jumlah_panen_stek->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->id->Visible && $this->id->Required) {
            if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
            }
        }
        if ($this->tgl_tanam->Visible && $this->tgl_tanam->Required) {
            if (!$this->tgl_tanam->IsDetailKey && EmptyValue($this->tgl_tanam->FormValue)) {
                $this->tgl_tanam->addErrorMessage(str_replace("%s", $this->tgl_tanam->caption(), $this->tgl_tanam->RequiredErrorMessage));
            }
        }
        if ($this->jenis_lahan->Visible && $this->jenis_lahan->Required) {
            if ($this->jenis_lahan->FormValue == "") {
                $this->jenis_lahan->addErrorMessage(str_replace("%s", $this->jenis_lahan->caption(), $this->jenis_lahan->RequiredErrorMessage));
            }
        }
        if ($this->varietas->Visible && $this->varietas->Required) {
            if (!$this->varietas->IsDetailKey && EmptyValue($this->varietas->FormValue)) {
                $this->varietas->addErrorMessage(str_replace("%s", $this->varietas->caption(), $this->varietas->RequiredErrorMessage));
            }
        }
        if ($this->jumlah_tanam->Visible && $this->jumlah_tanam->Required) {
            if (!$this->jumlah_tanam->IsDetailKey && EmptyValue($this->jumlah_tanam->FormValue)) {
                $this->jumlah_tanam->addErrorMessage(str_replace("%s", $this->jumlah_tanam->caption(), $this->jumlah_tanam->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->jumlah_tanam->FormValue)) {
            $this->jumlah_tanam->addErrorMessage($this->jumlah_tanam->getErrorMessage(false));
        }
        if ($this->ket->Visible && $this->ket->Required) {
            if (!$this->ket->IsDetailKey && EmptyValue($this->ket->FormValue)) {
                $this->ket->addErrorMessage(str_replace("%s", $this->ket->caption(), $this->ket->RequiredErrorMessage));
            }
        }
        if ($this->id_kontrak_tanam->Visible && $this->id_kontrak_tanam->Required) {
            if (!$this->id_kontrak_tanam->IsDetailKey && EmptyValue($this->id_kontrak_tanam->FormValue)) {
                $this->id_kontrak_tanam->addErrorMessage(str_replace("%s", $this->id_kontrak_tanam->caption(), $this->id_kontrak_tanam->RequiredErrorMessage));
            }
        }
        if ($this->gen_bibit->Visible && $this->gen_bibit->Required) {
            if (!$this->gen_bibit->IsDetailKey && EmptyValue($this->gen_bibit->FormValue)) {
                $this->gen_bibit->addErrorMessage(str_replace("%s", $this->gen_bibit->caption(), $this->gen_bibit->RequiredErrorMessage));
            }
        }
        if ($this->id_asal_bibit->Visible && $this->id_asal_bibit->Required) {
            if (!$this->id_asal_bibit->IsDetailKey && EmptyValue($this->id_asal_bibit->FormValue)) {
                $this->id_asal_bibit->addErrorMessage(str_replace("%s", $this->id_asal_bibit->caption(), $this->id_asal_bibit->RequiredErrorMessage));
            }
        }
        if ($this->jumlah_panen_stek->Visible && $this->jumlah_panen_stek->Required) {
            if (!$this->jumlah_panen_stek->IsDetailKey && EmptyValue($this->jumlah_panen_stek->FormValue)) {
                $this->jumlah_panen_stek->addErrorMessage(str_replace("%s", $this->jumlah_panen_stek->caption(), $this->jumlah_panen_stek->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->jumlah_panen_stek->FormValue)) {
            $this->jumlah_panen_stek->addErrorMessage($this->jumlah_panen_stek->getErrorMessage(false));
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
        }

        // Set new row
        $rsnew = [];

        // jumlah_tanam
        $this->jumlah_tanam->setDbValueDef($rsnew, $this->jumlah_tanam->CurrentValue, $this->jumlah_tanam->ReadOnly);

        // ket
        $this->ket->setDbValueDef($rsnew, $this->ket->CurrentValue, $this->ket->ReadOnly);

        // id_kontrak_tanam
        $this->id_kontrak_tanam->setDbValueDef($rsnew, $this->id_kontrak_tanam->CurrentValue, $this->id_kontrak_tanam->ReadOnly);

        // gen_bibit
        $this->gen_bibit->setDbValueDef($rsnew, $this->gen_bibit->CurrentValue, $this->gen_bibit->ReadOnly);

        // id_asal_bibit
        $this->id_asal_bibit->setDbValueDef($rsnew, $this->id_asal_bibit->CurrentValue, $this->id_asal_bibit->ReadOnly);

        // jumlah_panen_stek
        $this->jumlah_panen_stek->setDbValueDef($rsnew, $this->jumlah_panen_stek->CurrentValue, $this->jumlah_panen_stek->ReadOnly);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("TanamBibitList"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_jenis_lahan":
                    break;
                case "x_varietas":
                    break;
                case "x_id_kontrak_tanam":
                    break;
                case "x_gen_bibit":
                    break;
                case "x_id_asal_bibit":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
