<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class SuplaiyerUbiEdit extends SuplaiyerUbi
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SuplaiyerUbiEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "SuplaiyerUbiEdit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->sup_id->Visible = false;
        $this->sup_nama->setVisibility();
        $this->tr_id->setVisibility();
        $this->prov_id->setVisibility();
        $this->kab_id->setVisibility();
        $this->kec_id->setVisibility();
        $this->desa_id->setVisibility();
        $this->alamat->setVisibility();
        $this->no_hp->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'suplaiyer_ubi';
        $this->TableName = 'suplaiyer_ubi';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (suplaiyer_ubi)
        if (!isset($GLOBALS["suplaiyer_ubi"]) || get_class($GLOBALS["suplaiyer_ubi"]) == PROJECT_NAMESPACE . "suplaiyer_ubi") {
            $GLOBALS["suplaiyer_ubi"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'suplaiyer_ubi');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "SuplaiyerUbiView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['sup_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->sup_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->tr_id);
        $this->setupLookupOptions($this->prov_id);
        $this->setupLookupOptions($this->kab_id);
        $this->setupLookupOptions($this->kec_id);
        $this->setupLookupOptions($this->desa_id);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("sup_id") ?? Key(0) ?? Route(2)) !== null) {
                $this->sup_id->setQueryStringValue($keyValue);
                $this->sup_id->setOldValue($this->sup_id->QueryStringValue);
            } elseif (Post("sup_id") !== null) {
                $this->sup_id->setFormValue(Post("sup_id"));
                $this->sup_id->setOldValue($this->sup_id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("sup_id") ?? Route("sup_id")) !== null) {
                    $this->sup_id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->sup_id->CurrentValue = null;
                }
            }

            // Load recordset
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("SuplaiyerUbiList"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "SuplaiyerUbiList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) {
                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "SuplaiyerUbiList") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "SuplaiyerUbiList"; // Return list page content
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = ROWTYPE_EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'sup_nama' first before field var 'x_sup_nama'
        $val = $CurrentForm->hasValue("sup_nama") ? $CurrentForm->getValue("sup_nama") : $CurrentForm->getValue("x_sup_nama");
        if (!$this->sup_nama->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sup_nama->Visible = false; // Disable update for API request
            } else {
                $this->sup_nama->setFormValue($val);
            }
        }

        // Check field name 'tr_id' first before field var 'x_tr_id'
        $val = $CurrentForm->hasValue("tr_id") ? $CurrentForm->getValue("tr_id") : $CurrentForm->getValue("x_tr_id");
        if (!$this->tr_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->tr_id->Visible = false; // Disable update for API request
            } else {
                $this->tr_id->setFormValue($val);
            }
        }

        // Check field name 'prov_id' first before field var 'x_prov_id'
        $val = $CurrentForm->hasValue("prov_id") ? $CurrentForm->getValue("prov_id") : $CurrentForm->getValue("x_prov_id");
        if (!$this->prov_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->prov_id->Visible = false; // Disable update for API request
            } else {
                $this->prov_id->setFormValue($val);
            }
        }

        // Check field name 'kab_id' first before field var 'x_kab_id'
        $val = $CurrentForm->hasValue("kab_id") ? $CurrentForm->getValue("kab_id") : $CurrentForm->getValue("x_kab_id");
        if (!$this->kab_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kab_id->Visible = false; // Disable update for API request
            } else {
                $this->kab_id->setFormValue($val);
            }
        }

        // Check field name 'kec_id' first before field var 'x_kec_id'
        $val = $CurrentForm->hasValue("kec_id") ? $CurrentForm->getValue("kec_id") : $CurrentForm->getValue("x_kec_id");
        if (!$this->kec_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->kec_id->Visible = false; // Disable update for API request
            } else {
                $this->kec_id->setFormValue($val);
            }
        }

        // Check field name 'desa_id' first before field var 'x_desa_id'
        $val = $CurrentForm->hasValue("desa_id") ? $CurrentForm->getValue("desa_id") : $CurrentForm->getValue("x_desa_id");
        if (!$this->desa_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->desa_id->Visible = false; // Disable update for API request
            } else {
                $this->desa_id->setFormValue($val);
            }
        }

        // Check field name 'alamat' first before field var 'x_alamat'
        $val = $CurrentForm->hasValue("alamat") ? $CurrentForm->getValue("alamat") : $CurrentForm->getValue("x_alamat");
        if (!$this->alamat->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->alamat->Visible = false; // Disable update for API request
            } else {
                $this->alamat->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'no_hp' first before field var 'x_no_hp'
        $val = $CurrentForm->hasValue("no_hp") ? $CurrentForm->getValue("no_hp") : $CurrentForm->getValue("x_no_hp");
        if (!$this->no_hp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->no_hp->Visible = false; // Disable update for API request
            } else {
                $this->no_hp->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sup_id' first before field var 'x_sup_id'
        $val = $CurrentForm->hasValue("sup_id") ? $CurrentForm->getValue("sup_id") : $CurrentForm->getValue("x_sup_id");
        if (!$this->sup_id->IsDetailKey) {
            $this->sup_id->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->sup_id->CurrentValue = $this->sup_id->FormValue;
        $this->sup_nama->CurrentValue = $this->sup_nama->FormValue;
        $this->tr_id->CurrentValue = $this->tr_id->FormValue;
        $this->prov_id->CurrentValue = $this->prov_id->FormValue;
        $this->kab_id->CurrentValue = $this->kab_id->FormValue;
        $this->kec_id->CurrentValue = $this->kec_id->FormValue;
        $this->desa_id->CurrentValue = $this->desa_id->FormValue;
        $this->alamat->CurrentValue = $this->alamat->FormValue;
        $this->no_hp->CurrentValue = $this->no_hp->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->sup_id->setDbValue($row['sup_id']);
        $this->sup_nama->setDbValue($row['sup_nama']);
        $this->tr_id->setDbValue($row['tr_id']);
        $this->prov_id->setDbValue($row['prov_id']);
        $this->kab_id->setDbValue($row['kab_id']);
        $this->kec_id->setDbValue($row['kec_id']);
        $this->desa_id->setDbValue($row['desa_id']);
        $this->alamat->setDbValue($row['alamat']);
        $this->no_hp->setDbValue($row['no_hp']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['sup_id'] = $this->sup_id->DefaultValue;
        $row['sup_nama'] = $this->sup_nama->DefaultValue;
        $row['tr_id'] = $this->tr_id->DefaultValue;
        $row['prov_id'] = $this->prov_id->DefaultValue;
        $row['kab_id'] = $this->kab_id->DefaultValue;
        $row['kec_id'] = $this->kec_id->DefaultValue;
        $row['desa_id'] = $this->desa_id->DefaultValue;
        $row['alamat'] = $this->alamat->DefaultValue;
        $row['no_hp'] = $this->no_hp->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // sup_id
        $this->sup_id->RowCssClass = "row";

        // sup_nama
        $this->sup_nama->RowCssClass = "row";

        // tr_id
        $this->tr_id->RowCssClass = "row";

        // prov_id
        $this->prov_id->RowCssClass = "row";

        // kab_id
        $this->kab_id->RowCssClass = "row";

        // kec_id
        $this->kec_id->RowCssClass = "row";

        // desa_id
        $this->desa_id->RowCssClass = "row";

        // alamat
        $this->alamat->RowCssClass = "row";

        // no_hp
        $this->no_hp->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // sup_id
            $this->sup_id->ViewValue = $this->sup_id->CurrentValue;

            // sup_nama
            $this->sup_nama->ViewValue = $this->sup_nama->CurrentValue;

            // tr_id
            $curVal = strval($this->tr_id->CurrentValue);
            if ($curVal != "") {
                $this->tr_id->ViewValue = $this->tr_id->lookupCacheOption($curVal);
                if ($this->tr_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`tr_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->tr_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->tr_id->Lookup->renderViewRow($rswrk[0]);
                        $this->tr_id->ViewValue = $this->tr_id->displayValue($arwrk);
                    } else {
                        $this->tr_id->ViewValue = $this->tr_id->CurrentValue;
                    }
                }
            } else {
                $this->tr_id->ViewValue = null;
            }

            // prov_id
            $curVal = strval($this->prov_id->CurrentValue);
            if ($curVal != "") {
                $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
                if ($this->prov_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->prov_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->prov_id->Lookup->renderViewRow($rswrk[0]);
                        $this->prov_id->ViewValue = $this->prov_id->displayValue($arwrk);
                    } else {
                        $this->prov_id->ViewValue = $this->prov_id->CurrentValue;
                    }
                }
            } else {
                $this->prov_id->ViewValue = null;
            }

            // kab_id
            $curVal = strval($this->kab_id->CurrentValue);
            if ($curVal != "") {
                $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
                if ($this->kab_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->kab_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->kab_id->Lookup->renderViewRow($rswrk[0]);
                        $this->kab_id->ViewValue = $this->kab_id->displayValue($arwrk);
                    } else {
                        $this->kab_id->ViewValue = $this->kab_id->CurrentValue;
                    }
                }
            } else {
                $this->kab_id->ViewValue = null;
            }

            // kec_id
            $curVal = strval($this->kec_id->CurrentValue);
            if ($curVal != "") {
                $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
                if ($this->kec_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->kec_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->kec_id->Lookup->renderViewRow($rswrk[0]);
                        $this->kec_id->ViewValue = $this->kec_id->displayValue($arwrk);
                    } else {
                        $this->kec_id->ViewValue = $this->kec_id->CurrentValue;
                    }
                }
            } else {
                $this->kec_id->ViewValue = null;
            }

            // desa_id
            $curVal = strval($this->desa_id->CurrentValue);
            if ($curVal != "") {
                $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
                if ($this->desa_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->desa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->desa_id->Lookup->renderViewRow($rswrk[0]);
                        $this->desa_id->ViewValue = $this->desa_id->displayValue($arwrk);
                    } else {
                        $this->desa_id->ViewValue = $this->desa_id->CurrentValue;
                    }
                }
            } else {
                $this->desa_id->ViewValue = null;
            }

            // alamat
            $this->alamat->ViewValue = $this->alamat->CurrentValue;

            // no_hp
            $this->no_hp->ViewValue = $this->no_hp->CurrentValue;

            // sup_nama
            $this->sup_nama->HrefValue = "";

            // tr_id
            $this->tr_id->HrefValue = "";

            // prov_id
            $this->prov_id->HrefValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";

            // alamat
            $this->alamat->HrefValue = "";

            // no_hp
            $this->no_hp->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // sup_nama
            $this->sup_nama->setupEditAttributes();
            if (!$this->sup_nama->Raw) {
                $this->sup_nama->CurrentValue = HtmlDecode($this->sup_nama->CurrentValue);
            }
            $this->sup_nama->EditValue = HtmlEncode($this->sup_nama->CurrentValue);
            $this->sup_nama->PlaceHolder = RemoveHtml($this->sup_nama->caption());

            // tr_id
            $curVal = trim(strval($this->tr_id->CurrentValue));
            if ($curVal != "") {
                $this->tr_id->ViewValue = $this->tr_id->lookupCacheOption($curVal);
            } else {
                $this->tr_id->ViewValue = $this->tr_id->Lookup !== null && is_array($this->tr_id->lookupOptions()) && count($this->tr_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->tr_id->ViewValue !== null) { // Load from cache
                $this->tr_id->EditValue = array_values($this->tr_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`tr_id`", "=", $this->tr_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->tr_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->tr_id->EditValue = $arwrk;
            }
            $this->tr_id->PlaceHolder = RemoveHtml($this->tr_id->caption());

            // prov_id
            $this->prov_id->setupEditAttributes();
            $curVal = trim(strval($this->prov_id->CurrentValue));
            if ($curVal != "") {
                $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
            } else {
                $this->prov_id->ViewValue = $this->prov_id->Lookup !== null && is_array($this->prov_id->lookupOptions()) && count($this->prov_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->prov_id->ViewValue !== null) { // Load from cache
                $this->prov_id->EditValue = array_values($this->prov_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`prov_id`", "=", $this->prov_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->prov_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->prov_id->EditValue = $arwrk;
            }
            $this->prov_id->PlaceHolder = RemoveHtml($this->prov_id->caption());

            // kab_id
            $this->kab_id->setupEditAttributes();
            $curVal = trim(strval($this->kab_id->CurrentValue));
            if ($curVal != "") {
                $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
            } else {
                $this->kab_id->ViewValue = $this->kab_id->Lookup !== null && is_array($this->kab_id->lookupOptions()) && count($this->kab_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->kab_id->ViewValue !== null) { // Load from cache
                $this->kab_id->EditValue = array_values($this->kab_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kab_id`", "=", $this->kab_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->kab_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->kab_id->EditValue = $arwrk;
            }
            $this->kab_id->PlaceHolder = RemoveHtml($this->kab_id->caption());

            // kec_id
            $this->kec_id->setupEditAttributes();
            $curVal = trim(strval($this->kec_id->CurrentValue));
            if ($curVal != "") {
                $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
            } else {
                $this->kec_id->ViewValue = $this->kec_id->Lookup !== null && is_array($this->kec_id->lookupOptions()) && count($this->kec_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->kec_id->ViewValue !== null) { // Load from cache
                $this->kec_id->EditValue = array_values($this->kec_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kec_id`", "=", $this->kec_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->kec_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->kec_id->EditValue = $arwrk;
            }
            $this->kec_id->PlaceHolder = RemoveHtml($this->kec_id->caption());

            // desa_id
            $this->desa_id->setupEditAttributes();
            $curVal = trim(strval($this->desa_id->CurrentValue));
            if ($curVal != "") {
                $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
            } else {
                $this->desa_id->ViewValue = $this->desa_id->Lookup !== null && is_array($this->desa_id->lookupOptions()) && count($this->desa_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->desa_id->ViewValue !== null) { // Load from cache
                $this->desa_id->EditValue = array_values($this->desa_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`desa_id`", "=", $this->desa_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->desa_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->desa_id->EditValue = $arwrk;
            }
            $this->desa_id->PlaceHolder = RemoveHtml($this->desa_id->caption());

            // alamat
            $this->alamat->setupEditAttributes();
            $this->alamat->EditValue = HtmlEncode($this->alamat->CurrentValue);
            $this->alamat->PlaceHolder = RemoveHtml($this->alamat->caption());
            if (strval($this->alamat->EditValue) != "" && is_numeric($this->alamat->EditValue)) {
                $this->alamat->EditValue = $this->alamat->EditValue;
            }

            // no_hp
            $this->no_hp->setupEditAttributes();
            $this->no_hp->EditValue = HtmlEncode($this->no_hp->CurrentValue);
            $this->no_hp->PlaceHolder = RemoveHtml($this->no_hp->caption());
            if (strval($this->no_hp->EditValue) != "" && is_numeric($this->no_hp->EditValue)) {
                $this->no_hp->EditValue = $this->no_hp->EditValue;
            }

            // Edit refer script

            // sup_nama
            $this->sup_nama->HrefValue = "";

            // tr_id
            $this->tr_id->HrefValue = "";

            // prov_id
            $this->prov_id->HrefValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";

            // alamat
            $this->alamat->HrefValue = "";

            // no_hp
            $this->no_hp->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->sup_nama->Visible && $this->sup_nama->Required) {
            if (!$this->sup_nama->IsDetailKey && EmptyValue($this->sup_nama->FormValue)) {
                $this->sup_nama->addErrorMessage(str_replace("%s", $this->sup_nama->caption(), $this->sup_nama->RequiredErrorMessage));
            }
        }
        if ($this->tr_id->Visible && $this->tr_id->Required) {
            if ($this->tr_id->FormValue == "") {
                $this->tr_id->addErrorMessage(str_replace("%s", $this->tr_id->caption(), $this->tr_id->RequiredErrorMessage));
            }
        }
        if ($this->prov_id->Visible && $this->prov_id->Required) {
            if (!$this->prov_id->IsDetailKey && EmptyValue($this->prov_id->FormValue)) {
                $this->prov_id->addErrorMessage(str_replace("%s", $this->prov_id->caption(), $this->prov_id->RequiredErrorMessage));
            }
        }
        if ($this->kab_id->Visible && $this->kab_id->Required) {
            if (!$this->kab_id->IsDetailKey && EmptyValue($this->kab_id->FormValue)) {
                $this->kab_id->addErrorMessage(str_replace("%s", $this->kab_id->caption(), $this->kab_id->RequiredErrorMessage));
            }
        }
        if ($this->kec_id->Visible && $this->kec_id->Required) {
            if (!$this->kec_id->IsDetailKey && EmptyValue($this->kec_id->FormValue)) {
                $this->kec_id->addErrorMessage(str_replace("%s", $this->kec_id->caption(), $this->kec_id->RequiredErrorMessage));
            }
        }
        if ($this->desa_id->Visible && $this->desa_id->Required) {
            if (!$this->desa_id->IsDetailKey && EmptyValue($this->desa_id->FormValue)) {
                $this->desa_id->addErrorMessage(str_replace("%s", $this->desa_id->caption(), $this->desa_id->RequiredErrorMessage));
            }
        }
        if ($this->alamat->Visible && $this->alamat->Required) {
            if (!$this->alamat->IsDetailKey && EmptyValue($this->alamat->FormValue)) {
                $this->alamat->addErrorMessage(str_replace("%s", $this->alamat->caption(), $this->alamat->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->alamat->FormValue)) {
            $this->alamat->addErrorMessage($this->alamat->getErrorMessage(false));
        }
        if ($this->no_hp->Visible && $this->no_hp->Required) {
            if (!$this->no_hp->IsDetailKey && EmptyValue($this->no_hp->FormValue)) {
                $this->no_hp->addErrorMessage(str_replace("%s", $this->no_hp->caption(), $this->no_hp->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->no_hp->FormValue)) {
            $this->no_hp->addErrorMessage($this->no_hp->getErrorMessage(false));
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
        }

        // Set new row
        $rsnew = [];

        // sup_nama
        $this->sup_nama->setDbValueDef($rsnew, $this->sup_nama->CurrentValue, $this->sup_nama->ReadOnly);

        // tr_id
        $this->tr_id->setDbValueDef($rsnew, $this->tr_id->CurrentValue, $this->tr_id->ReadOnly);

        // prov_id
        $this->prov_id->setDbValueDef($rsnew, $this->prov_id->CurrentValue, $this->prov_id->ReadOnly);

        // kab_id
        $this->kab_id->setDbValueDef($rsnew, $this->kab_id->CurrentValue, $this->kab_id->ReadOnly);

        // kec_id
        $this->kec_id->setDbValueDef($rsnew, $this->kec_id->CurrentValue, $this->kec_id->ReadOnly);

        // desa_id
        $this->desa_id->setDbValueDef($rsnew, $this->desa_id->CurrentValue, $this->desa_id->ReadOnly);

        // alamat
        $this->alamat->setDbValueDef($rsnew, $this->alamat->CurrentValue, $this->alamat->ReadOnly);

        // no_hp
        $this->no_hp->setDbValueDef($rsnew, $this->no_hp->CurrentValue, $this->no_hp->ReadOnly);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("SuplaiyerUbiList"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_tr_id":
                    break;
                case "x_prov_id":
                    break;
                case "x_kab_id":
                    break;
                case "x_kec_id":
                    break;
                case "x_desa_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
