<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class SosialisasiAdd extends Sosialisasi
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SosialisasiAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "SosialisasiAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->sos_id->Visible = false;
        $this->sos_tgl->setVisibility();
        $this->ts_id->setVisibility();
        $this->sos_co->setVisibility();
        $this->sos_peserta->setVisibility();
        $this->sos_prov->setVisibility();
        $this->sos_kab->setVisibility();
        $this->sos_kec->setVisibility();
        $this->sos_desa->setVisibility();
        $this->sos_alamat->setVisibility();
        $this->sos_pot_lahan->setVisibility();
        $this->sos_katinggian->setVisibility();
        $this->sos_biaya->setVisibility();
        $this->sos_kesimpulan->setVisibility();
        $this->sos_foto->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'sosialisasi';
        $this->TableName = 'sosialisasi';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (sosialisasi)
        if (!isset($GLOBALS["sosialisasi"]) || get_class($GLOBALS["sosialisasi"]) == PROJECT_NAMESPACE . "sosialisasi") {
            $GLOBALS["sosialisasi"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sosialisasi');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "SosialisasiView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->sos_foto->OldUploadPath = $this->sos_foto->getUploadPath(); // PHP
                $this->sos_foto->UploadPath = $this->sos_foto->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['sos_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->sos_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ts_id);
        $this->setupLookupOptions($this->sos_co);
        $this->setupLookupOptions($this->sos_peserta);
        $this->setupLookupOptions($this->sos_prov);
        $this->setupLookupOptions($this->sos_kab);
        $this->setupLookupOptions($this->sos_kec);
        $this->setupLookupOptions($this->sos_desa);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("sos_id") ?? Route("sos_id")) !== null) {
                $this->sos_id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("SosialisasiList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "SosialisasiList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "SosialisasiView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "SosialisasiList") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "SosialisasiList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->sos_foto->Upload->Index = $CurrentForm->Index;
        $this->sos_foto->Upload->uploadFile();
        $this->sos_foto->CurrentValue = $this->sos_foto->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'sos_tgl' first before field var 'x_sos_tgl'
        $val = $CurrentForm->hasValue("sos_tgl") ? $CurrentForm->getValue("sos_tgl") : $CurrentForm->getValue("x_sos_tgl");
        if (!$this->sos_tgl->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_tgl->Visible = false; // Disable update for API request
            } else {
                $this->sos_tgl->setFormValue($val, true, $validate);
            }
            $this->sos_tgl->CurrentValue = UnFormatDateTime($this->sos_tgl->CurrentValue, $this->sos_tgl->formatPattern());
        }

        // Check field name 'ts_id' first before field var 'x_ts_id'
        $val = $CurrentForm->hasValue("ts_id") ? $CurrentForm->getValue("ts_id") : $CurrentForm->getValue("x_ts_id");
        if (!$this->ts_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ts_id->Visible = false; // Disable update for API request
            } else {
                $this->ts_id->setFormValue($val);
            }
        }

        // Check field name 'sos_co' first before field var 'x_sos_co'
        $val = $CurrentForm->hasValue("sos_co") ? $CurrentForm->getValue("sos_co") : $CurrentForm->getValue("x_sos_co");
        if (!$this->sos_co->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_co->Visible = false; // Disable update for API request
            } else {
                $this->sos_co->setFormValue($val);
            }
        }

        // Check field name 'sos_peserta' first before field var 'x_sos_peserta'
        $val = $CurrentForm->hasValue("sos_peserta") ? $CurrentForm->getValue("sos_peserta") : $CurrentForm->getValue("x_sos_peserta");
        if (!$this->sos_peserta->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_peserta->Visible = false; // Disable update for API request
            } else {
                $this->sos_peserta->setFormValue($val);
            }
        }

        // Check field name 'sos_prov' first before field var 'x_sos_prov'
        $val = $CurrentForm->hasValue("sos_prov") ? $CurrentForm->getValue("sos_prov") : $CurrentForm->getValue("x_sos_prov");
        if (!$this->sos_prov->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_prov->Visible = false; // Disable update for API request
            } else {
                $this->sos_prov->setFormValue($val);
            }
        }

        // Check field name 'sos_kab' first before field var 'x_sos_kab'
        $val = $CurrentForm->hasValue("sos_kab") ? $CurrentForm->getValue("sos_kab") : $CurrentForm->getValue("x_sos_kab");
        if (!$this->sos_kab->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_kab->Visible = false; // Disable update for API request
            } else {
                $this->sos_kab->setFormValue($val);
            }
        }

        // Check field name 'sos_kec' first before field var 'x_sos_kec'
        $val = $CurrentForm->hasValue("sos_kec") ? $CurrentForm->getValue("sos_kec") : $CurrentForm->getValue("x_sos_kec");
        if (!$this->sos_kec->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_kec->Visible = false; // Disable update for API request
            } else {
                $this->sos_kec->setFormValue($val);
            }
        }

        // Check field name 'sos_desa' first before field var 'x_sos_desa'
        $val = $CurrentForm->hasValue("sos_desa") ? $CurrentForm->getValue("sos_desa") : $CurrentForm->getValue("x_sos_desa");
        if (!$this->sos_desa->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_desa->Visible = false; // Disable update for API request
            } else {
                $this->sos_desa->setFormValue($val);
            }
        }

        // Check field name 'sos_alamat' first before field var 'x_sos_alamat'
        $val = $CurrentForm->hasValue("sos_alamat") ? $CurrentForm->getValue("sos_alamat") : $CurrentForm->getValue("x_sos_alamat");
        if (!$this->sos_alamat->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_alamat->Visible = false; // Disable update for API request
            } else {
                $this->sos_alamat->setFormValue($val);
            }
        }

        // Check field name 'sos_pot_lahan' first before field var 'x_sos_pot_lahan'
        $val = $CurrentForm->hasValue("sos_pot_lahan") ? $CurrentForm->getValue("sos_pot_lahan") : $CurrentForm->getValue("x_sos_pot_lahan");
        if (!$this->sos_pot_lahan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_pot_lahan->Visible = false; // Disable update for API request
            } else {
                $this->sos_pot_lahan->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sos_katinggian' first before field var 'x_sos_katinggian'
        $val = $CurrentForm->hasValue("sos_katinggian") ? $CurrentForm->getValue("sos_katinggian") : $CurrentForm->getValue("x_sos_katinggian");
        if (!$this->sos_katinggian->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_katinggian->Visible = false; // Disable update for API request
            } else {
                $this->sos_katinggian->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sos_biaya' first before field var 'x_sos_biaya'
        $val = $CurrentForm->hasValue("sos_biaya") ? $CurrentForm->getValue("sos_biaya") : $CurrentForm->getValue("x_sos_biaya");
        if (!$this->sos_biaya->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_biaya->Visible = false; // Disable update for API request
            } else {
                $this->sos_biaya->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'sos_kesimpulan' first before field var 'x_sos_kesimpulan'
        $val = $CurrentForm->hasValue("sos_kesimpulan") ? $CurrentForm->getValue("sos_kesimpulan") : $CurrentForm->getValue("x_sos_kesimpulan");
        if (!$this->sos_kesimpulan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sos_kesimpulan->Visible = false; // Disable update for API request
            } else {
                $this->sos_kesimpulan->setFormValue($val);
            }
        }

        // Check field name 'sos_id' first before field var 'x_sos_id'
        $val = $CurrentForm->hasValue("sos_id") ? $CurrentForm->getValue("sos_id") : $CurrentForm->getValue("x_sos_id");
		$this->sos_foto->OldUploadPath = $this->sos_foto->getUploadPath(); // PHP
		$this->sos_foto->UploadPath = $this->sos_foto->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->sos_tgl->CurrentValue = $this->sos_tgl->FormValue;
        $this->sos_tgl->CurrentValue = UnFormatDateTime($this->sos_tgl->CurrentValue, $this->sos_tgl->formatPattern());
        $this->ts_id->CurrentValue = $this->ts_id->FormValue;
        $this->sos_co->CurrentValue = $this->sos_co->FormValue;
        $this->sos_peserta->CurrentValue = $this->sos_peserta->FormValue;
        $this->sos_prov->CurrentValue = $this->sos_prov->FormValue;
        $this->sos_kab->CurrentValue = $this->sos_kab->FormValue;
        $this->sos_kec->CurrentValue = $this->sos_kec->FormValue;
        $this->sos_desa->CurrentValue = $this->sos_desa->FormValue;
        $this->sos_alamat->CurrentValue = $this->sos_alamat->FormValue;
        $this->sos_pot_lahan->CurrentValue = $this->sos_pot_lahan->FormValue;
        $this->sos_katinggian->CurrentValue = $this->sos_katinggian->FormValue;
        $this->sos_biaya->CurrentValue = $this->sos_biaya->FormValue;
        $this->sos_kesimpulan->CurrentValue = $this->sos_kesimpulan->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->sos_id->setDbValue($row['sos_id']);
        $this->sos_tgl->setDbValue($row['sos_tgl']);
        $this->ts_id->setDbValue($row['ts_id']);
        $this->sos_co->setDbValue($row['sos_co']);
        $this->sos_peserta->setDbValue($row['sos_peserta']);
        $this->sos_prov->setDbValue($row['sos_prov']);
        $this->sos_kab->setDbValue($row['sos_kab']);
        $this->sos_kec->setDbValue($row['sos_kec']);
        $this->sos_desa->setDbValue($row['sos_desa']);
        $this->sos_alamat->setDbValue($row['sos_alamat']);
        $this->sos_pot_lahan->setDbValue($row['sos_pot_lahan']);
        $this->sos_katinggian->setDbValue($row['sos_katinggian']);
        $this->sos_biaya->setDbValue($row['sos_biaya']);
        $this->sos_kesimpulan->setDbValue($row['sos_kesimpulan']);
        $this->sos_foto->Upload->DbValue = $row['sos_foto'];
        $this->sos_foto->setDbValue($this->sos_foto->Upload->DbValue);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['sos_id'] = $this->sos_id->DefaultValue;
        $row['sos_tgl'] = $this->sos_tgl->DefaultValue;
        $row['ts_id'] = $this->ts_id->DefaultValue;
        $row['sos_co'] = $this->sos_co->DefaultValue;
        $row['sos_peserta'] = $this->sos_peserta->DefaultValue;
        $row['sos_prov'] = $this->sos_prov->DefaultValue;
        $row['sos_kab'] = $this->sos_kab->DefaultValue;
        $row['sos_kec'] = $this->sos_kec->DefaultValue;
        $row['sos_desa'] = $this->sos_desa->DefaultValue;
        $row['sos_alamat'] = $this->sos_alamat->DefaultValue;
        $row['sos_pot_lahan'] = $this->sos_pot_lahan->DefaultValue;
        $row['sos_katinggian'] = $this->sos_katinggian->DefaultValue;
        $row['sos_biaya'] = $this->sos_biaya->DefaultValue;
        $row['sos_kesimpulan'] = $this->sos_kesimpulan->DefaultValue;
        $row['sos_foto'] = $this->sos_foto->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // sos_id
        $this->sos_id->RowCssClass = "row";

        // sos_tgl
        $this->sos_tgl->RowCssClass = "row";

        // ts_id
        $this->ts_id->RowCssClass = "row";

        // sos_co
        $this->sos_co->RowCssClass = "row";

        // sos_peserta
        $this->sos_peserta->RowCssClass = "row";

        // sos_prov
        $this->sos_prov->RowCssClass = "row";

        // sos_kab
        $this->sos_kab->RowCssClass = "row";

        // sos_kec
        $this->sos_kec->RowCssClass = "row";

        // sos_desa
        $this->sos_desa->RowCssClass = "row";

        // sos_alamat
        $this->sos_alamat->RowCssClass = "row";

        // sos_pot_lahan
        $this->sos_pot_lahan->RowCssClass = "row";

        // sos_katinggian
        $this->sos_katinggian->RowCssClass = "row";

        // sos_biaya
        $this->sos_biaya->RowCssClass = "row";

        // sos_kesimpulan
        $this->sos_kesimpulan->RowCssClass = "row";

        // sos_foto
        $this->sos_foto->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // sos_id
            $this->sos_id->ViewValue = $this->sos_id->CurrentValue;

            // sos_tgl
            $this->sos_tgl->ViewValue = $this->sos_tgl->CurrentValue;
            $this->sos_tgl->ViewValue = FormatDateTime($this->sos_tgl->ViewValue, $this->sos_tgl->formatPattern());

            // ts_id
            $curVal = strval($this->ts_id->CurrentValue);
            if ($curVal != "") {
                $this->ts_id->ViewValue = $this->ts_id->lookupCacheOption($curVal);
                if ($this->ts_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`ts_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->ts_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ts_id->Lookup->renderViewRow($rswrk[0]);
                        $this->ts_id->ViewValue = $this->ts_id->displayValue($arwrk);
                    } else {
                        $this->ts_id->ViewValue = $this->ts_id->CurrentValue;
                    }
                }
            } else {
                $this->ts_id->ViewValue = null;
            }

            // sos_co
            $curVal = strval($this->sos_co->CurrentValue);
            if ($curVal != "") {
                $this->sos_co->ViewValue = $this->sos_co->lookupCacheOption($curVal);
                if ($this->sos_co->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_co->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_co->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_co->ViewValue = $this->sos_co->displayValue($arwrk);
                    } else {
                        $this->sos_co->ViewValue = $this->sos_co->CurrentValue;
                    }
                }
            } else {
                $this->sos_co->ViewValue = null;
            }

            // sos_peserta
            $curVal = strval($this->sos_peserta->CurrentValue);
            if ($curVal != "") {
                $this->sos_peserta->ViewValue = $this->sos_peserta->lookupCacheOption($curVal);
                if ($this->sos_peserta->ViewValue === null) { // Lookup from database
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= SearchFilter("`pes_id`", "=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->sos_peserta->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->sos_peserta->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->sos_peserta->Lookup->renderViewRow($row);
                            $this->sos_peserta->ViewValue->add($this->sos_peserta->displayValue($arwrk));
                        }
                    } else {
                        $this->sos_peserta->ViewValue = $this->sos_peserta->CurrentValue;
                    }
                }
            } else {
                $this->sos_peserta->ViewValue = null;
            }
            $this->sos_peserta->CellCssStyle .= "text-align: left;";

            // sos_prov
            $curVal = strval($this->sos_prov->CurrentValue);
            if ($curVal != "") {
                $this->sos_prov->ViewValue = $this->sos_prov->lookupCacheOption($curVal);
                if ($this->sos_prov->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_prov->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_prov->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_prov->ViewValue = $this->sos_prov->displayValue($arwrk);
                    } else {
                        $this->sos_prov->ViewValue = $this->sos_prov->CurrentValue;
                    }
                }
            } else {
                $this->sos_prov->ViewValue = null;
            }

            // sos_kab
            $curVal = strval($this->sos_kab->CurrentValue);
            if ($curVal != "") {
                $this->sos_kab->ViewValue = $this->sos_kab->lookupCacheOption($curVal);
                if ($this->sos_kab->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_kab->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_kab->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_kab->ViewValue = $this->sos_kab->displayValue($arwrk);
                    } else {
                        $this->sos_kab->ViewValue = $this->sos_kab->CurrentValue;
                    }
                }
            } else {
                $this->sos_kab->ViewValue = null;
            }

            // sos_kec
            $curVal = strval($this->sos_kec->CurrentValue);
            if ($curVal != "") {
                $this->sos_kec->ViewValue = $this->sos_kec->lookupCacheOption($curVal);
                if ($this->sos_kec->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_kec->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_kec->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_kec->ViewValue = $this->sos_kec->displayValue($arwrk);
                    } else {
                        $this->sos_kec->ViewValue = $this->sos_kec->CurrentValue;
                    }
                }
            } else {
                $this->sos_kec->ViewValue = null;
            }

            // sos_desa
            $curVal = strval($this->sos_desa->CurrentValue);
            if ($curVal != "") {
                $this->sos_desa->ViewValue = $this->sos_desa->lookupCacheOption($curVal);
                if ($this->sos_desa->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sos_desa->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sos_desa->Lookup->renderViewRow($rswrk[0]);
                        $this->sos_desa->ViewValue = $this->sos_desa->displayValue($arwrk);
                    } else {
                        $this->sos_desa->ViewValue = $this->sos_desa->CurrentValue;
                    }
                }
            } else {
                $this->sos_desa->ViewValue = null;
            }

            // sos_alamat
            $this->sos_alamat->ViewValue = $this->sos_alamat->CurrentValue;

            // sos_pot_lahan
            $this->sos_pot_lahan->ViewValue = $this->sos_pot_lahan->CurrentValue;
            $this->sos_pot_lahan->CellCssStyle .= "text-align: right;";

            // sos_katinggian
            $this->sos_katinggian->ViewValue = $this->sos_katinggian->CurrentValue;
            $this->sos_katinggian->CellCssStyle .= "text-align: right;";

            // sos_biaya
            $this->sos_biaya->ViewValue = $this->sos_biaya->CurrentValue;

            // sos_kesimpulan
            $this->sos_kesimpulan->ViewValue = $this->sos_kesimpulan->CurrentValue;

            // sos_foto
            $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
                $this->sos_foto->ImageWidth = 80;
                $this->sos_foto->ImageHeight = 60;
                $this->sos_foto->ImageAlt = $this->sos_foto->alt();
                $this->sos_foto->ImageCssClass = "ew-image";
                $this->sos_foto->ViewValue = $this->sos_foto->Upload->DbValue;
            } else {
                $this->sos_foto->ViewValue = "";
            }
            $this->sos_foto->CellCssStyle .= "text-align: center;";

            // sos_tgl
            $this->sos_tgl->HrefValue = "";

            // ts_id
            $this->ts_id->HrefValue = "";

            // sos_co
            $this->sos_co->HrefValue = "";

            // sos_peserta
            $this->sos_peserta->HrefValue = "";

            // sos_prov
            $this->sos_prov->HrefValue = "";

            // sos_kab
            $this->sos_kab->HrefValue = "";

            // sos_kec
            $this->sos_kec->HrefValue = "";

            // sos_desa
            $this->sos_desa->HrefValue = "";

            // sos_alamat
            $this->sos_alamat->HrefValue = "";

            // sos_pot_lahan
            $this->sos_pot_lahan->HrefValue = "";

            // sos_katinggian
            $this->sos_katinggian->HrefValue = "";

            // sos_biaya
            $this->sos_biaya->HrefValue = "";

            // sos_kesimpulan
            $this->sos_kesimpulan->HrefValue = "";

            // sos_foto
            $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
                $this->sos_foto->HrefValue = "%u"; // Add prefix/suffix
                $this->sos_foto->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->sos_foto->HrefValue = FullUrl($this->sos_foto->HrefValue, "href");
                }
            } else {
                $this->sos_foto->HrefValue = "";
            }
            $this->sos_foto->ExportHrefValue = $this->sos_foto->UploadPath . $this->sos_foto->Upload->DbValue;
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // sos_tgl
            $this->sos_tgl->setupEditAttributes();
            $this->sos_tgl->EditValue = HtmlEncode(FormatDateTime($this->sos_tgl->CurrentValue, $this->sos_tgl->formatPattern()));
            $this->sos_tgl->PlaceHolder = RemoveHtml($this->sos_tgl->caption());

            // ts_id
            $curVal = trim(strval($this->ts_id->CurrentValue));
            if ($curVal != "") {
                $this->ts_id->ViewValue = $this->ts_id->lookupCacheOption($curVal);
            } else {
                $this->ts_id->ViewValue = $this->ts_id->Lookup !== null && is_array($this->ts_id->lookupOptions()) && count($this->ts_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ts_id->ViewValue !== null) { // Load from cache
                $this->ts_id->EditValue = array_values($this->ts_id->lookupOptions());
                if ($this->ts_id->ViewValue == "") {
                    $this->ts_id->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`ts_id`", "=", $this->ts_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->ts_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ts_id->Lookup->renderViewRow($rswrk[0]);
                    $this->ts_id->ViewValue = $this->ts_id->displayValue($arwrk);
                } else {
                    $this->ts_id->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->ts_id->EditValue = $arwrk;
            }
            $this->ts_id->PlaceHolder = RemoveHtml($this->ts_id->caption());

            // sos_co
            $this->sos_co->setupEditAttributes();
            $curVal = trim(strval($this->sos_co->CurrentValue));
            if ($curVal != "") {
                $this->sos_co->ViewValue = $this->sos_co->lookupCacheOption($curVal);
            } else {
                $this->sos_co->ViewValue = $this->sos_co->Lookup !== null && is_array($this->sos_co->lookupOptions()) && count($this->sos_co->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sos_co->ViewValue !== null) { // Load from cache
                $this->sos_co->EditValue = array_values($this->sos_co->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`co_id`", "=", $this->sos_co->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sos_co->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->sos_co->EditValue = $arwrk;
            }
            $this->sos_co->PlaceHolder = RemoveHtml($this->sos_co->caption());

            // sos_peserta
            $curVal = trim(strval($this->sos_peserta->CurrentValue));
            if ($curVal != "") {
                $this->sos_peserta->ViewValue = $this->sos_peserta->lookupCacheOption($curVal);
            } else {
                $this->sos_peserta->ViewValue = $this->sos_peserta->Lookup !== null && is_array($this->sos_peserta->lookupOptions()) && count($this->sos_peserta->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sos_peserta->ViewValue !== null) { // Load from cache
                $this->sos_peserta->EditValue = array_values($this->sos_peserta->lookupOptions());
                if ($this->sos_peserta->ViewValue == "") {
                    $this->sos_peserta->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= SearchFilter("`pes_id`", "=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                }
                $sqlWrk = $this->sos_peserta->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->sos_peserta->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->sos_peserta->Lookup->renderViewRow($row);
                        $this->sos_peserta->ViewValue->add($this->sos_peserta->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->sos_peserta->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->sos_peserta->EditValue = $arwrk;
            }
            $this->sos_peserta->PlaceHolder = RemoveHtml($this->sos_peserta->caption());

            // sos_prov
            $this->sos_prov->setupEditAttributes();
            $curVal = trim(strval($this->sos_prov->CurrentValue));
            if ($curVal != "") {
                $this->sos_prov->ViewValue = $this->sos_prov->lookupCacheOption($curVal);
            } else {
                $this->sos_prov->ViewValue = $this->sos_prov->Lookup !== null && is_array($this->sos_prov->lookupOptions()) && count($this->sos_prov->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sos_prov->ViewValue !== null) { // Load from cache
                $this->sos_prov->EditValue = array_values($this->sos_prov->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`prov_id`", "=", $this->sos_prov->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sos_prov->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->sos_prov->EditValue = $arwrk;
            }
            $this->sos_prov->PlaceHolder = RemoveHtml($this->sos_prov->caption());

            // sos_kab
            $this->sos_kab->setupEditAttributes();
            $curVal = trim(strval($this->sos_kab->CurrentValue));
            if ($curVal != "") {
                $this->sos_kab->ViewValue = $this->sos_kab->lookupCacheOption($curVal);
            } else {
                $this->sos_kab->ViewValue = $this->sos_kab->Lookup !== null && is_array($this->sos_kab->lookupOptions()) && count($this->sos_kab->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sos_kab->ViewValue !== null) { // Load from cache
                $this->sos_kab->EditValue = array_values($this->sos_kab->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kab_id`", "=", $this->sos_kab->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sos_kab->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->sos_kab->EditValue = $arwrk;
            }
            $this->sos_kab->PlaceHolder = RemoveHtml($this->sos_kab->caption());

            // sos_kec
            $this->sos_kec->setupEditAttributes();
            $curVal = trim(strval($this->sos_kec->CurrentValue));
            if ($curVal != "") {
                $this->sos_kec->ViewValue = $this->sos_kec->lookupCacheOption($curVal);
            } else {
                $this->sos_kec->ViewValue = $this->sos_kec->Lookup !== null && is_array($this->sos_kec->lookupOptions()) && count($this->sos_kec->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sos_kec->ViewValue !== null) { // Load from cache
                $this->sos_kec->EditValue = array_values($this->sos_kec->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kec_id`", "=", $this->sos_kec->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sos_kec->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->sos_kec->EditValue = $arwrk;
            }
            $this->sos_kec->PlaceHolder = RemoveHtml($this->sos_kec->caption());

            // sos_desa
            $this->sos_desa->setupEditAttributes();
            $curVal = trim(strval($this->sos_desa->CurrentValue));
            if ($curVal != "") {
                $this->sos_desa->ViewValue = $this->sos_desa->lookupCacheOption($curVal);
            } else {
                $this->sos_desa->ViewValue = $this->sos_desa->Lookup !== null && is_array($this->sos_desa->lookupOptions()) && count($this->sos_desa->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sos_desa->ViewValue !== null) { // Load from cache
                $this->sos_desa->EditValue = array_values($this->sos_desa->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`desa_id`", "=", $this->sos_desa->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sos_desa->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->sos_desa->EditValue = $arwrk;
            }
            $this->sos_desa->PlaceHolder = RemoveHtml($this->sos_desa->caption());

            // sos_alamat
            $this->sos_alamat->setupEditAttributes();
            $this->sos_alamat->EditValue = HtmlEncode($this->sos_alamat->CurrentValue);
            $this->sos_alamat->PlaceHolder = RemoveHtml($this->sos_alamat->caption());

            // sos_pot_lahan
            $this->sos_pot_lahan->setupEditAttributes();
            $this->sos_pot_lahan->EditValue = HtmlEncode($this->sos_pot_lahan->CurrentValue);
            $this->sos_pot_lahan->PlaceHolder = RemoveHtml($this->sos_pot_lahan->caption());
            if (strval($this->sos_pot_lahan->EditValue) != "" && is_numeric($this->sos_pot_lahan->EditValue)) {
                $this->sos_pot_lahan->EditValue = $this->sos_pot_lahan->EditValue;
            }

            // sos_katinggian
            $this->sos_katinggian->setupEditAttributes();
            $this->sos_katinggian->EditValue = HtmlEncode($this->sos_katinggian->CurrentValue);
            $this->sos_katinggian->PlaceHolder = RemoveHtml($this->sos_katinggian->caption());
            if (strval($this->sos_katinggian->EditValue) != "" && is_numeric($this->sos_katinggian->EditValue)) {
                $this->sos_katinggian->EditValue = $this->sos_katinggian->EditValue;
            }

            // sos_biaya
            $this->sos_biaya->setupEditAttributes();
            $this->sos_biaya->EditValue = HtmlEncode($this->sos_biaya->CurrentValue);
            $this->sos_biaya->PlaceHolder = RemoveHtml($this->sos_biaya->caption());
            if (strval($this->sos_biaya->EditValue) != "" && is_numeric($this->sos_biaya->EditValue)) {
                $this->sos_biaya->EditValue = $this->sos_biaya->EditValue;
            }

            // sos_kesimpulan
            $this->sos_kesimpulan->setupEditAttributes();
            $this->sos_kesimpulan->EditValue = HtmlEncode($this->sos_kesimpulan->CurrentValue);
            $this->sos_kesimpulan->PlaceHolder = RemoveHtml($this->sos_kesimpulan->caption());

            // sos_foto
            $this->sos_foto->setupEditAttributes();
            $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
                $this->sos_foto->ImageWidth = 80;
                $this->sos_foto->ImageHeight = 60;
                $this->sos_foto->ImageAlt = $this->sos_foto->alt();
                $this->sos_foto->ImageCssClass = "ew-image";
                $this->sos_foto->EditValue = $this->sos_foto->Upload->DbValue;
            } else {
                $this->sos_foto->EditValue = "";
            }
            if (!EmptyValue($this->sos_foto->CurrentValue)) {
                $this->sos_foto->Upload->FileName = $this->sos_foto->CurrentValue;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->sos_foto);
            }

            // Add refer script

            // sos_tgl
            $this->sos_tgl->HrefValue = "";

            // ts_id
            $this->ts_id->HrefValue = "";

            // sos_co
            $this->sos_co->HrefValue = "";

            // sos_peserta
            $this->sos_peserta->HrefValue = "";

            // sos_prov
            $this->sos_prov->HrefValue = "";

            // sos_kab
            $this->sos_kab->HrefValue = "";

            // sos_kec
            $this->sos_kec->HrefValue = "";

            // sos_desa
            $this->sos_desa->HrefValue = "";

            // sos_alamat
            $this->sos_alamat->HrefValue = "";

            // sos_pot_lahan
            $this->sos_pot_lahan->HrefValue = "";

            // sos_katinggian
            $this->sos_katinggian->HrefValue = "";

            // sos_biaya
            $this->sos_biaya->HrefValue = "";

            // sos_kesimpulan
            $this->sos_kesimpulan->HrefValue = "";

            // sos_foto
            $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
            if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
                $this->sos_foto->HrefValue = "%u"; // Add prefix/suffix
                $this->sos_foto->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->sos_foto->HrefValue = FullUrl($this->sos_foto->HrefValue, "href");
                }
            } else {
                $this->sos_foto->HrefValue = "";
            }
            $this->sos_foto->ExportHrefValue = $this->sos_foto->UploadPath . $this->sos_foto->Upload->DbValue;
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Render add option
    public function renderAddOpt($row)
    {
        global $Security, $Language, $CurrentLanguage;

        // Set up CurrentValue
        $this->sos_tgl->CurrentValue = $row["sos_tgl"];
        $this->ts_id->CurrentValue = $row["ts_id"];
        $this->sos_co->CurrentValue = $row["sos_co"];
        $this->sos_peserta->CurrentValue = $row["sos_peserta"];
        $this->sos_prov->CurrentValue = $row["sos_prov"];
        $this->sos_kab->CurrentValue = $row["sos_kab"];
        $this->sos_kec->CurrentValue = $row["sos_kec"];
        $this->sos_desa->CurrentValue = $row["sos_desa"];
        $this->sos_alamat->CurrentValue = $row["sos_alamat"];
        $this->sos_pot_lahan->CurrentValue = $row["sos_pot_lahan"];
        $this->sos_katinggian->CurrentValue = $row["sos_katinggian"];
        $this->sos_biaya->CurrentValue = $row["sos_biaya"];
        $this->sos_kesimpulan->CurrentValue = $row["sos_kesimpulan"];
        $this->sos_foto->CurrentValue = $row["sos_foto"];

        // sos_tgl
        $this->sos_tgl->ViewValue = $this->sos_tgl->CurrentValue;
        $this->sos_tgl->ViewValue = FormatDateTime($this->sos_tgl->ViewValue, $this->sos_tgl->formatPattern());

        // ts_id
        $curVal = strval($this->ts_id->CurrentValue);
        if ($curVal != "") {
            $this->ts_id->ViewValue = $this->ts_id->lookupCacheOption($curVal);
            if ($this->ts_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`ts_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->ts_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ts_id->Lookup->renderViewRow($rswrk[0]);
                    $this->ts_id->ViewValue = $this->ts_id->displayValue($arwrk);
                } else {
                    $this->ts_id->ViewValue = $this->ts_id->CurrentValue;
                }
            }
        } else {
            $this->ts_id->ViewValue = null;
        }

        // sos_co
        $curVal = strval($this->sos_co->CurrentValue);
        if ($curVal != "") {
            $this->sos_co->ViewValue = $this->sos_co->lookupCacheOption($curVal);
            if ($this->sos_co->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_co->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_co->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_co->ViewValue = $this->sos_co->displayValue($arwrk);
                } else {
                    $this->sos_co->ViewValue = $this->sos_co->CurrentValue;
                }
            }
        } else {
            $this->sos_co->ViewValue = null;
        }

        // sos_peserta
        $curVal = strval($this->sos_peserta->CurrentValue);
        if ($curVal != "") {
            $this->sos_peserta->ViewValue = $this->sos_peserta->lookupCacheOption($curVal);
            if ($this->sos_peserta->ViewValue === null) { // Lookup from database
                $arwrk = explode(",", $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    if ($filterWrk != "") {
                        $filterWrk .= " OR ";
                    }
                    $filterWrk .= SearchFilter("`pes_id`", "=", trim($wrk), DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->sos_peserta->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->sos_peserta->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->sos_peserta->Lookup->renderViewRow($row);
                        $this->sos_peserta->ViewValue->add($this->sos_peserta->displayValue($arwrk));
                    }
                } else {
                    $this->sos_peserta->ViewValue = $this->sos_peserta->CurrentValue;
                }
            }
        } else {
            $this->sos_peserta->ViewValue = null;
        }
        $this->sos_peserta->CellCssStyle .= "text-align: left;";

        // sos_prov
        $curVal = strval($this->sos_prov->CurrentValue);
        if ($curVal != "") {
            $this->sos_prov->ViewValue = $this->sos_prov->lookupCacheOption($curVal);
            if ($this->sos_prov->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_prov->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_prov->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_prov->ViewValue = $this->sos_prov->displayValue($arwrk);
                } else {
                    $this->sos_prov->ViewValue = $this->sos_prov->CurrentValue;
                }
            }
        } else {
            $this->sos_prov->ViewValue = null;
        }

        // sos_kab
        $curVal = strval($this->sos_kab->CurrentValue);
        if ($curVal != "") {
            $this->sos_kab->ViewValue = $this->sos_kab->lookupCacheOption($curVal);
            if ($this->sos_kab->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_kab->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_kab->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_kab->ViewValue = $this->sos_kab->displayValue($arwrk);
                } else {
                    $this->sos_kab->ViewValue = $this->sos_kab->CurrentValue;
                }
            }
        } else {
            $this->sos_kab->ViewValue = null;
        }

        // sos_kec
        $curVal = strval($this->sos_kec->CurrentValue);
        if ($curVal != "") {
            $this->sos_kec->ViewValue = $this->sos_kec->lookupCacheOption($curVal);
            if ($this->sos_kec->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_kec->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_kec->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_kec->ViewValue = $this->sos_kec->displayValue($arwrk);
                } else {
                    $this->sos_kec->ViewValue = $this->sos_kec->CurrentValue;
                }
            }
        } else {
            $this->sos_kec->ViewValue = null;
        }

        // sos_desa
        $curVal = strval($this->sos_desa->CurrentValue);
        if ($curVal != "") {
            $this->sos_desa->ViewValue = $this->sos_desa->lookupCacheOption($curVal);
            if ($this->sos_desa->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->sos_desa->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->sos_desa->Lookup->renderViewRow($rswrk[0]);
                    $this->sos_desa->ViewValue = $this->sos_desa->displayValue($arwrk);
                } else {
                    $this->sos_desa->ViewValue = $this->sos_desa->CurrentValue;
                }
            }
        } else {
            $this->sos_desa->ViewValue = null;
        }

        // sos_alamat
        $this->sos_alamat->ViewValue = $this->sos_alamat->CurrentValue;

        // sos_pot_lahan
        $this->sos_pot_lahan->ViewValue = $this->sos_pot_lahan->CurrentValue;
        $this->sos_pot_lahan->CellCssStyle .= "text-align: right;";

        // sos_katinggian
        $this->sos_katinggian->ViewValue = $this->sos_katinggian->CurrentValue;
        $this->sos_katinggian->CellCssStyle .= "text-align: right;";

        // sos_biaya
        $this->sos_biaya->ViewValue = $this->sos_biaya->CurrentValue;

        // sos_kesimpulan
        $this->sos_kesimpulan->ViewValue = $this->sos_kesimpulan->CurrentValue;

        // sos_foto
        $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
        if (!EmptyValue($this->sos_foto->Upload->DbValue)) {
            $this->sos_foto->ImageWidth = 80;
            $this->sos_foto->ImageHeight = 60;
            $this->sos_foto->ImageAlt = $this->sos_foto->alt();
            $this->sos_foto->ImageCssClass = "ew-image";
            $this->sos_foto->ViewValue = $this->sos_foto->Upload->DbValue;
        } else {
            $this->sos_foto->ViewValue = "";
        }
        $this->sos_foto->CellCssStyle .= "text-align: center;";

        // Set up $row
        $row["sos_tgl"] = $this->sos_tgl->ViewValue;
        $row["ts_id"] = $this->ts_id->ViewValue;
        $row["sos_co"] = $this->sos_co->ViewValue;
        $row["sos_peserta"] = $this->sos_peserta->ViewValue;
        $row["sos_prov"] = $this->sos_prov->ViewValue;
        $row["sos_kab"] = $this->sos_kab->ViewValue;
        $row["sos_kec"] = $this->sos_kec->ViewValue;
        $row["sos_desa"] = $this->sos_desa->ViewValue;
        $row["sos_alamat"] = $this->sos_alamat->ViewValue;
        $row["sos_pot_lahan"] = $this->sos_pot_lahan->ViewValue;
        $row["sos_katinggian"] = $this->sos_katinggian->ViewValue;
        $row["sos_biaya"] = $this->sos_biaya->ViewValue;
        $row["sos_kesimpulan"] = $this->sos_kesimpulan->ViewValue;
        $row["sos_foto"] = $this->sos_foto->ViewValue;
        return $row;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->sos_tgl->Visible && $this->sos_tgl->Required) {
            if (!$this->sos_tgl->IsDetailKey && EmptyValue($this->sos_tgl->FormValue)) {
                $this->sos_tgl->addErrorMessage(str_replace("%s", $this->sos_tgl->caption(), $this->sos_tgl->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->sos_tgl->FormValue, $this->sos_tgl->formatPattern())) {
            $this->sos_tgl->addErrorMessage($this->sos_tgl->getErrorMessage(false));
        }
        if ($this->ts_id->Visible && $this->ts_id->Required) {
            if (!$this->ts_id->IsDetailKey && EmptyValue($this->ts_id->FormValue)) {
                $this->ts_id->addErrorMessage(str_replace("%s", $this->ts_id->caption(), $this->ts_id->RequiredErrorMessage));
            }
        }
        if ($this->sos_co->Visible && $this->sos_co->Required) {
            if (!$this->sos_co->IsDetailKey && EmptyValue($this->sos_co->FormValue)) {
                $this->sos_co->addErrorMessage(str_replace("%s", $this->sos_co->caption(), $this->sos_co->RequiredErrorMessage));
            }
        }
        if ($this->sos_peserta->Visible && $this->sos_peserta->Required) {
            if ($this->sos_peserta->FormValue == "") {
                $this->sos_peserta->addErrorMessage(str_replace("%s", $this->sos_peserta->caption(), $this->sos_peserta->RequiredErrorMessage));
            }
        }
        if ($this->sos_prov->Visible && $this->sos_prov->Required) {
            if (!$this->sos_prov->IsDetailKey && EmptyValue($this->sos_prov->FormValue)) {
                $this->sos_prov->addErrorMessage(str_replace("%s", $this->sos_prov->caption(), $this->sos_prov->RequiredErrorMessage));
            }
        }
        if ($this->sos_kab->Visible && $this->sos_kab->Required) {
            if (!$this->sos_kab->IsDetailKey && EmptyValue($this->sos_kab->FormValue)) {
                $this->sos_kab->addErrorMessage(str_replace("%s", $this->sos_kab->caption(), $this->sos_kab->RequiredErrorMessage));
            }
        }
        if ($this->sos_kec->Visible && $this->sos_kec->Required) {
            if (!$this->sos_kec->IsDetailKey && EmptyValue($this->sos_kec->FormValue)) {
                $this->sos_kec->addErrorMessage(str_replace("%s", $this->sos_kec->caption(), $this->sos_kec->RequiredErrorMessage));
            }
        }
        if ($this->sos_desa->Visible && $this->sos_desa->Required) {
            if (!$this->sos_desa->IsDetailKey && EmptyValue($this->sos_desa->FormValue)) {
                $this->sos_desa->addErrorMessage(str_replace("%s", $this->sos_desa->caption(), $this->sos_desa->RequiredErrorMessage));
            }
        }
        if ($this->sos_alamat->Visible && $this->sos_alamat->Required) {
            if (!$this->sos_alamat->IsDetailKey && EmptyValue($this->sos_alamat->FormValue)) {
                $this->sos_alamat->addErrorMessage(str_replace("%s", $this->sos_alamat->caption(), $this->sos_alamat->RequiredErrorMessage));
            }
        }
        if ($this->sos_pot_lahan->Visible && $this->sos_pot_lahan->Required) {
            if (!$this->sos_pot_lahan->IsDetailKey && EmptyValue($this->sos_pot_lahan->FormValue)) {
                $this->sos_pot_lahan->addErrorMessage(str_replace("%s", $this->sos_pot_lahan->caption(), $this->sos_pot_lahan->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->sos_pot_lahan->FormValue)) {
            $this->sos_pot_lahan->addErrorMessage($this->sos_pot_lahan->getErrorMessage(false));
        }
        if ($this->sos_katinggian->Visible && $this->sos_katinggian->Required) {
            if (!$this->sos_katinggian->IsDetailKey && EmptyValue($this->sos_katinggian->FormValue)) {
                $this->sos_katinggian->addErrorMessage(str_replace("%s", $this->sos_katinggian->caption(), $this->sos_katinggian->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->sos_katinggian->FormValue)) {
            $this->sos_katinggian->addErrorMessage($this->sos_katinggian->getErrorMessage(false));
        }
        if ($this->sos_biaya->Visible && $this->sos_biaya->Required) {
            if (!$this->sos_biaya->IsDetailKey && EmptyValue($this->sos_biaya->FormValue)) {
                $this->sos_biaya->addErrorMessage(str_replace("%s", $this->sos_biaya->caption(), $this->sos_biaya->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->sos_biaya->FormValue)) {
            $this->sos_biaya->addErrorMessage($this->sos_biaya->getErrorMessage(false));
        }
        if ($this->sos_kesimpulan->Visible && $this->sos_kesimpulan->Required) {
            if (!$this->sos_kesimpulan->IsDetailKey && EmptyValue($this->sos_kesimpulan->FormValue)) {
                $this->sos_kesimpulan->addErrorMessage(str_replace("%s", $this->sos_kesimpulan->caption(), $this->sos_kesimpulan->RequiredErrorMessage));
            }
        }
        if ($this->sos_foto->Visible && $this->sos_foto->Required) {
            if ($this->sos_foto->Upload->FileName == "" && !$this->sos_foto->Upload->KeepFile) {
                $this->sos_foto->addErrorMessage(str_replace("%s", $this->sos_foto->caption(), $this->sos_foto->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set new row
        $rsnew = [];

        // sos_tgl
        $this->sos_tgl->setDbValueDef($rsnew, UnFormatDateTime($this->sos_tgl->CurrentValue, $this->sos_tgl->formatPattern()), false);

        // ts_id
        $this->ts_id->setDbValueDef($rsnew, $this->ts_id->CurrentValue, false);

        // sos_co
        $this->sos_co->setDbValueDef($rsnew, $this->sos_co->CurrentValue, false);

        // sos_peserta
        $this->sos_peserta->setDbValueDef($rsnew, $this->sos_peserta->CurrentValue, false);

        // sos_prov
        $this->sos_prov->setDbValueDef($rsnew, $this->sos_prov->CurrentValue, false);

        // sos_kab
        $this->sos_kab->setDbValueDef($rsnew, $this->sos_kab->CurrentValue, false);

        // sos_kec
        $this->sos_kec->setDbValueDef($rsnew, $this->sos_kec->CurrentValue, false);

        // sos_desa
        $this->sos_desa->setDbValueDef($rsnew, $this->sos_desa->CurrentValue, false);

        // sos_alamat
        $this->sos_alamat->setDbValueDef($rsnew, $this->sos_alamat->CurrentValue, false);

        // sos_pot_lahan
        $this->sos_pot_lahan->setDbValueDef($rsnew, $this->sos_pot_lahan->CurrentValue, false);

        // sos_katinggian
        $this->sos_katinggian->setDbValueDef($rsnew, $this->sos_katinggian->CurrentValue, false);

        // sos_biaya
        $this->sos_biaya->setDbValueDef($rsnew, $this->sos_biaya->CurrentValue, false);

        // sos_kesimpulan
        $this->sos_kesimpulan->setDbValueDef($rsnew, $this->sos_kesimpulan->CurrentValue, false);

        // sos_foto
        if ($this->sos_foto->Visible && !$this->sos_foto->Upload->KeepFile) {
            $this->sos_foto->Upload->DbValue = ""; // No need to delete old file
            if ($this->sos_foto->Upload->FileName == "") {
                $rsnew['sos_foto'] = null;
            } else {
                $rsnew['sos_foto'] = $this->sos_foto->Upload->FileName;
            }
            $this->sos_foto->ImageWidth = 800; // Resize width
            $this->sos_foto->ImageHeight = 600; // Resize height
        }
        if ($this->sos_foto->Visible && !$this->sos_foto->Upload->KeepFile) {
            $this->sos_foto->UploadPath = $this->sos_foto->getUploadPath(); // PHP
            $oldFiles = EmptyValue($this->sos_foto->Upload->DbValue) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->sos_foto->htmlDecode(strval($this->sos_foto->Upload->DbValue)));
            if (!EmptyValue($this->sos_foto->Upload->FileName)) {
                $newFiles = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), strval($this->sos_foto->Upload->FileName));
                $NewFileCount = count($newFiles);
                for ($i = 0; $i < $NewFileCount; $i++) {
                    if ($newFiles[$i] != "") {
                        $file = $newFiles[$i];
                        $tempPath = UploadTempPath($this->sos_foto, $this->sos_foto->Upload->Index);
                        if (file_exists($tempPath . $file)) {
                            if (Config("DELETE_UPLOADED_FILES")) {
                                $oldFileFound = false;
                                $oldFileCount = count($oldFiles);
                                for ($j = 0; $j < $oldFileCount; $j++) {
                                    $oldFile = $oldFiles[$j];
                                    if ($oldFile == $file) { // Old file found, no need to delete anymore
                                        array_splice($oldFiles, $j, 1);
                                        $oldFileFound = true;
                                        break;
                                    }
                                }
                                if ($oldFileFound) { // No need to check if file exists further
                                    continue;
                                }
                            }
                            $file1 = UniqueFilename($this->sos_foto->physicalUploadPath(), $file); // Get new file name
                            if ($file1 != $file) { // Rename temp file
                                while (file_exists($tempPath . $file1) || file_exists($this->sos_foto->physicalUploadPath() . $file1)) { // Make sure no file name clash
                                    $file1 = UniqueFilename([$this->sos_foto->physicalUploadPath(), $tempPath], $file1, true); // Use indexed name
                                }
                                rename($tempPath . $file, $tempPath . $file1);
                                $newFiles[$i] = $file1;
                            }
                        }
                    }
                }
                $this->sos_foto->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
                $this->sos_foto->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
                $this->sos_foto->setDbValueDef($rsnew, $this->sos_foto->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->sos_foto->OldUploadPath = $this->sos_foto->getUploadPath(); // PHP
        $this->sos_foto->UploadPath = $this->sos_foto->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->sos_foto->Visible && !$this->sos_foto->Upload->KeepFile) {
                    $oldFiles = EmptyValue($this->sos_foto->Upload->DbValue) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->sos_foto->htmlDecode(strval($this->sos_foto->Upload->DbValue)));
                    if (!EmptyValue($this->sos_foto->Upload->FileName)) {
                        $newFiles = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->sos_foto->Upload->FileName);
                        $newFiles2 = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $this->sos_foto->htmlDecode($rsnew['sos_foto']));
                        $newFileCount = count($newFiles);
                        for ($i = 0; $i < $newFileCount; $i++) {
                            if ($newFiles[$i] != "") {
                                $file = UploadTempPath($this->sos_foto, $this->sos_foto->Upload->Index) . $newFiles[$i];
                                if (file_exists($file)) {
                                    if (@$newFiles2[$i] != "") { // Use correct file name
                                        $newFiles[$i] = $newFiles2[$i];
                                    }
                                    if (!$this->sos_foto->Upload->ResizeAndSaveToFile($this->sos_foto->ImageWidth, $this->sos_foto->ImageHeight, 100, $newFiles[$i], true, $i)) {
                                        $this->setFailureMessage($Language->phrase("UploadError7"));
                                        return false;
                                    }
                                }
                            }
                        }
                    } else {
                        $newFiles = [];
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            if (Post("addopt") == "1") { // Render for add option response
                $row = $this->renderAddOpt($row);
            }
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("SosialisasiList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ts_id":
                    break;
                case "x_sos_co":
                    break;
                case "x_sos_peserta":
                    break;
                case "x_sos_prov":
                    break;
                case "x_sos_kab":
                    break;
                case "x_sos_kec":
                    break;
                case "x_sos_desa":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
