<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class PenggunaanPestisidaEdit extends PenggunaanPestisida
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PenggunaanPestisidaEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "PenggunaanPestisidaEdit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ID_Penggunan->setVisibility();
        $this->ID_Kontrak->setVisibility();
        $this->Jenis_Pestisida->setVisibility();
        $this->Merek->setVisibility();
        $this->Bahan_Aktif->setVisibility();
        $this->Dosis_Pemakaian->setVisibility();
        $this->Waktu_Aplikasi->setVisibility();
        $this->Keterangan->setVisibility();
        $this->Petugas_Update->setVisibility();
        $this->Tanggal_Update->setVisibility();
        $this->Petugas_Add->setVisibility();
        $this->Tanggal_Add->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'penggunaan_pestisida';
        $this->TableName = 'penggunaan_pestisida';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (penggunaan_pestisida)
        if (!isset($GLOBALS["penggunaan_pestisida"]) || get_class($GLOBALS["penggunaan_pestisida"]) == PROJECT_NAMESPACE . "penggunaan_pestisida") {
            $GLOBALS["penggunaan_pestisida"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'penggunaan_pestisida');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "PenggunaanPestisidaView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ID_Penggunan'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ID_Penggunan->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Jenis_Pestisida);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("ID_Penggunan") ?? Key(0) ?? Route(2)) !== null) {
                $this->ID_Penggunan->setQueryStringValue($keyValue);
                $this->ID_Penggunan->setOldValue($this->ID_Penggunan->QueryStringValue);
            } elseif (Post("ID_Penggunan") !== null) {
                $this->ID_Penggunan->setFormValue(Post("ID_Penggunan"));
                $this->ID_Penggunan->setOldValue($this->ID_Penggunan->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("ID_Penggunan") ?? Route("ID_Penggunan")) !== null) {
                    $this->ID_Penggunan->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->ID_Penggunan->CurrentValue = null;
                }
            }

            // Set up master detail parameters
            $this->setupMasterParms();

            // Load recordset
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("PenggunaanPestisidaList"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "PenggunaanPestisidaList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) {
                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "PenggunaanPestisidaList") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "PenggunaanPestisidaList"; // Return list page content
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = ROWTYPE_EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ID_Penggunan' first before field var 'x_ID_Penggunan'
        $val = $CurrentForm->hasValue("ID_Penggunan") ? $CurrentForm->getValue("ID_Penggunan") : $CurrentForm->getValue("x_ID_Penggunan");
        if (!$this->ID_Penggunan->IsDetailKey) {
            $this->ID_Penggunan->setFormValue($val);
        }

        // Check field name 'ID_Kontrak' first before field var 'x_ID_Kontrak'
        $val = $CurrentForm->hasValue("ID_Kontrak") ? $CurrentForm->getValue("ID_Kontrak") : $CurrentForm->getValue("x_ID_Kontrak");
        if (!$this->ID_Kontrak->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ID_Kontrak->Visible = false; // Disable update for API request
            } else {
                $this->ID_Kontrak->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Jenis_Pestisida' first before field var 'x_Jenis_Pestisida'
        $val = $CurrentForm->hasValue("Jenis_Pestisida") ? $CurrentForm->getValue("Jenis_Pestisida") : $CurrentForm->getValue("x_Jenis_Pestisida");
        if (!$this->Jenis_Pestisida->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Jenis_Pestisida->Visible = false; // Disable update for API request
            } else {
                $this->Jenis_Pestisida->setFormValue($val);
            }
        }

        // Check field name 'Merek' first before field var 'x_Merek'
        $val = $CurrentForm->hasValue("Merek") ? $CurrentForm->getValue("Merek") : $CurrentForm->getValue("x_Merek");
        if (!$this->Merek->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Merek->Visible = false; // Disable update for API request
            } else {
                $this->Merek->setFormValue($val);
            }
        }

        // Check field name 'Bahan_Aktif' first before field var 'x_Bahan_Aktif'
        $val = $CurrentForm->hasValue("Bahan_Aktif") ? $CurrentForm->getValue("Bahan_Aktif") : $CurrentForm->getValue("x_Bahan_Aktif");
        if (!$this->Bahan_Aktif->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Bahan_Aktif->Visible = false; // Disable update for API request
            } else {
                $this->Bahan_Aktif->setFormValue($val);
            }
        }

        // Check field name 'Dosis_Pemakaian' first before field var 'x_Dosis_Pemakaian'
        $val = $CurrentForm->hasValue("Dosis_Pemakaian") ? $CurrentForm->getValue("Dosis_Pemakaian") : $CurrentForm->getValue("x_Dosis_Pemakaian");
        if (!$this->Dosis_Pemakaian->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Dosis_Pemakaian->Visible = false; // Disable update for API request
            } else {
                $this->Dosis_Pemakaian->setFormValue($val);
            }
        }

        // Check field name 'Waktu_Aplikasi' first before field var 'x_Waktu_Aplikasi'
        $val = $CurrentForm->hasValue("Waktu_Aplikasi") ? $CurrentForm->getValue("Waktu_Aplikasi") : $CurrentForm->getValue("x_Waktu_Aplikasi");
        if (!$this->Waktu_Aplikasi->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Waktu_Aplikasi->Visible = false; // Disable update for API request
            } else {
                $this->Waktu_Aplikasi->setFormValue($val);
            }
        }

        // Check field name 'Keterangan' first before field var 'x_Keterangan'
        $val = $CurrentForm->hasValue("Keterangan") ? $CurrentForm->getValue("Keterangan") : $CurrentForm->getValue("x_Keterangan");
        if (!$this->Keterangan->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Keterangan->Visible = false; // Disable update for API request
            } else {
                $this->Keterangan->setFormValue($val);
            }
        }

        // Check field name 'Petugas_Update' first before field var 'x_Petugas_Update'
        $val = $CurrentForm->hasValue("Petugas_Update") ? $CurrentForm->getValue("Petugas_Update") : $CurrentForm->getValue("x_Petugas_Update");
        if (!$this->Petugas_Update->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Petugas_Update->Visible = false; // Disable update for API request
            } else {
                $this->Petugas_Update->setFormValue($val);
            }
        }

        // Check field name 'Tanggal_Update' first before field var 'x_Tanggal_Update'
        $val = $CurrentForm->hasValue("Tanggal_Update") ? $CurrentForm->getValue("Tanggal_Update") : $CurrentForm->getValue("x_Tanggal_Update");
        if (!$this->Tanggal_Update->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Tanggal_Update->Visible = false; // Disable update for API request
            } else {
                $this->Tanggal_Update->setFormValue($val);
            }
            $this->Tanggal_Update->CurrentValue = UnFormatDateTime($this->Tanggal_Update->CurrentValue, $this->Tanggal_Update->formatPattern());
        }

        // Check field name 'Petugas_Add' first before field var 'x_Petugas_Add'
        $val = $CurrentForm->hasValue("Petugas_Add") ? $CurrentForm->getValue("Petugas_Add") : $CurrentForm->getValue("x_Petugas_Add");
        if (!$this->Petugas_Add->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Petugas_Add->Visible = false; // Disable update for API request
            } else {
                $this->Petugas_Add->setFormValue($val);
            }
        }

        // Check field name 'Tanggal_Add' first before field var 'x_Tanggal_Add'
        $val = $CurrentForm->hasValue("Tanggal_Add") ? $CurrentForm->getValue("Tanggal_Add") : $CurrentForm->getValue("x_Tanggal_Add");
        if (!$this->Tanggal_Add->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Tanggal_Add->Visible = false; // Disable update for API request
            } else {
                $this->Tanggal_Add->setFormValue($val);
            }
            $this->Tanggal_Add->CurrentValue = UnFormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ID_Penggunan->CurrentValue = $this->ID_Penggunan->FormValue;
        $this->ID_Kontrak->CurrentValue = $this->ID_Kontrak->FormValue;
        $this->Jenis_Pestisida->CurrentValue = $this->Jenis_Pestisida->FormValue;
        $this->Merek->CurrentValue = $this->Merek->FormValue;
        $this->Bahan_Aktif->CurrentValue = $this->Bahan_Aktif->FormValue;
        $this->Dosis_Pemakaian->CurrentValue = $this->Dosis_Pemakaian->FormValue;
        $this->Waktu_Aplikasi->CurrentValue = $this->Waktu_Aplikasi->FormValue;
        $this->Keterangan->CurrentValue = $this->Keterangan->FormValue;
        $this->Petugas_Update->CurrentValue = $this->Petugas_Update->FormValue;
        $this->Tanggal_Update->CurrentValue = $this->Tanggal_Update->FormValue;
        $this->Tanggal_Update->CurrentValue = UnFormatDateTime($this->Tanggal_Update->CurrentValue, $this->Tanggal_Update->formatPattern());
        $this->Petugas_Add->CurrentValue = $this->Petugas_Add->FormValue;
        $this->Tanggal_Add->CurrentValue = $this->Tanggal_Add->FormValue;
        $this->Tanggal_Add->CurrentValue = UnFormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ID_Penggunan->setDbValue($row['ID_Penggunan']);
        $this->ID_Kontrak->setDbValue($row['ID_Kontrak']);
        $this->Jenis_Pestisida->setDbValue($row['Jenis_Pestisida']);
        $this->Merek->setDbValue($row['Merek']);
        $this->Bahan_Aktif->setDbValue($row['Bahan_Aktif']);
        $this->Dosis_Pemakaian->setDbValue($row['Dosis_Pemakaian']);
        $this->Waktu_Aplikasi->setDbValue($row['Waktu_Aplikasi']);
        $this->Keterangan->setDbValue($row['Keterangan']);
        $this->Petugas_Update->setDbValue($row['Petugas_Update']);
        $this->Tanggal_Update->setDbValue($row['Tanggal_Update']);
        $this->Petugas_Add->setDbValue($row['Petugas_Add']);
        $this->Tanggal_Add->setDbValue($row['Tanggal_Add']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ID_Penggunan'] = $this->ID_Penggunan->DefaultValue;
        $row['ID_Kontrak'] = $this->ID_Kontrak->DefaultValue;
        $row['Jenis_Pestisida'] = $this->Jenis_Pestisida->DefaultValue;
        $row['Merek'] = $this->Merek->DefaultValue;
        $row['Bahan_Aktif'] = $this->Bahan_Aktif->DefaultValue;
        $row['Dosis_Pemakaian'] = $this->Dosis_Pemakaian->DefaultValue;
        $row['Waktu_Aplikasi'] = $this->Waktu_Aplikasi->DefaultValue;
        $row['Keterangan'] = $this->Keterangan->DefaultValue;
        $row['Petugas_Update'] = $this->Petugas_Update->DefaultValue;
        $row['Tanggal_Update'] = $this->Tanggal_Update->DefaultValue;
        $row['Petugas_Add'] = $this->Petugas_Add->DefaultValue;
        $row['Tanggal_Add'] = $this->Tanggal_Add->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ID_Penggunan
        $this->ID_Penggunan->RowCssClass = "row";

        // ID_Kontrak
        $this->ID_Kontrak->RowCssClass = "row";

        // Jenis_Pestisida
        $this->Jenis_Pestisida->RowCssClass = "row";

        // Merek
        $this->Merek->RowCssClass = "row";

        // Bahan_Aktif
        $this->Bahan_Aktif->RowCssClass = "row";

        // Dosis_Pemakaian
        $this->Dosis_Pemakaian->RowCssClass = "row";

        // Waktu_Aplikasi
        $this->Waktu_Aplikasi->RowCssClass = "row";

        // Keterangan
        $this->Keterangan->RowCssClass = "row";

        // Petugas_Update
        $this->Petugas_Update->RowCssClass = "row";

        // Tanggal_Update
        $this->Tanggal_Update->RowCssClass = "row";

        // Petugas_Add
        $this->Petugas_Add->RowCssClass = "row";

        // Tanggal_Add
        $this->Tanggal_Add->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // ID_Penggunan
            $this->ID_Penggunan->ViewValue = $this->ID_Penggunan->CurrentValue;

            // ID_Kontrak
            $this->ID_Kontrak->ViewValue = $this->ID_Kontrak->CurrentValue;
            $this->ID_Kontrak->ViewValue = FormatNumber($this->ID_Kontrak->ViewValue, $this->ID_Kontrak->formatPattern());

            // Jenis_Pestisida
            if (strval($this->Jenis_Pestisida->CurrentValue) != "") {
                $this->Jenis_Pestisida->ViewValue = $this->Jenis_Pestisida->optionCaption($this->Jenis_Pestisida->CurrentValue);
            } else {
                $this->Jenis_Pestisida->ViewValue = null;
            }

            // Merek
            $this->Merek->ViewValue = $this->Merek->CurrentValue;

            // Bahan_Aktif
            $this->Bahan_Aktif->ViewValue = $this->Bahan_Aktif->CurrentValue;

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->ViewValue = $this->Dosis_Pemakaian->CurrentValue;

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->ViewValue = $this->Waktu_Aplikasi->CurrentValue;

            // Keterangan
            $this->Keterangan->ViewValue = $this->Keterangan->CurrentValue;

            // Petugas_Update
            $this->Petugas_Update->ViewValue = $this->Petugas_Update->CurrentValue;

            // Tanggal_Update
            $this->Tanggal_Update->ViewValue = $this->Tanggal_Update->CurrentValue;
            $this->Tanggal_Update->ViewValue = FormatDateTime($this->Tanggal_Update->ViewValue, $this->Tanggal_Update->formatPattern());

            // Petugas_Add
            $this->Petugas_Add->ViewValue = $this->Petugas_Add->CurrentValue;

            // Tanggal_Add
            $this->Tanggal_Add->ViewValue = $this->Tanggal_Add->CurrentValue;
            $this->Tanggal_Add->ViewValue = FormatDateTime($this->Tanggal_Add->ViewValue, $this->Tanggal_Add->formatPattern());

            // ID_Penggunan
            $this->ID_Penggunan->HrefValue = "";

            // ID_Kontrak
            $this->ID_Kontrak->HrefValue = "";

            // Jenis_Pestisida
            $this->Jenis_Pestisida->HrefValue = "";

            // Merek
            $this->Merek->HrefValue = "";

            // Bahan_Aktif
            $this->Bahan_Aktif->HrefValue = "";

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->HrefValue = "";

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->HrefValue = "";

            // Keterangan
            $this->Keterangan->HrefValue = "";

            // Petugas_Update
            $this->Petugas_Update->HrefValue = "";

            // Tanggal_Update
            $this->Tanggal_Update->HrefValue = "";

            // Petugas_Add
            $this->Petugas_Add->HrefValue = "";

            // Tanggal_Add
            $this->Tanggal_Add->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // ID_Penggunan
            $this->ID_Penggunan->setupEditAttributes();
            $this->ID_Penggunan->EditValue = $this->ID_Penggunan->CurrentValue;

            // ID_Kontrak
            $this->ID_Kontrak->setupEditAttributes();
            if ($this->ID_Kontrak->getSessionValue() != "") {
                $this->ID_Kontrak->CurrentValue = GetForeignKeyValue($this->ID_Kontrak->getSessionValue());
                $this->ID_Kontrak->ViewValue = $this->ID_Kontrak->CurrentValue;
                $this->ID_Kontrak->ViewValue = FormatNumber($this->ID_Kontrak->ViewValue, $this->ID_Kontrak->formatPattern());
            } else {
                $this->ID_Kontrak->EditValue = HtmlEncode($this->ID_Kontrak->CurrentValue);
                $this->ID_Kontrak->PlaceHolder = RemoveHtml($this->ID_Kontrak->caption());
                if (strval($this->ID_Kontrak->EditValue) != "" && is_numeric($this->ID_Kontrak->EditValue)) {
                    $this->ID_Kontrak->EditValue = FormatNumber($this->ID_Kontrak->EditValue, null);
                }
            }

            // Jenis_Pestisida
            $this->Jenis_Pestisida->setupEditAttributes();
            $this->Jenis_Pestisida->EditValue = $this->Jenis_Pestisida->options(true);
            $this->Jenis_Pestisida->PlaceHolder = RemoveHtml($this->Jenis_Pestisida->caption());

            // Merek
            $this->Merek->setupEditAttributes();
            if (!$this->Merek->Raw) {
                $this->Merek->CurrentValue = HtmlDecode($this->Merek->CurrentValue);
            }
            $this->Merek->EditValue = HtmlEncode($this->Merek->CurrentValue);
            $this->Merek->PlaceHolder = RemoveHtml($this->Merek->caption());

            // Bahan_Aktif
            $this->Bahan_Aktif->setupEditAttributes();
            if (!$this->Bahan_Aktif->Raw) {
                $this->Bahan_Aktif->CurrentValue = HtmlDecode($this->Bahan_Aktif->CurrentValue);
            }
            $this->Bahan_Aktif->EditValue = HtmlEncode($this->Bahan_Aktif->CurrentValue);
            $this->Bahan_Aktif->PlaceHolder = RemoveHtml($this->Bahan_Aktif->caption());

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->setupEditAttributes();
            if (!$this->Dosis_Pemakaian->Raw) {
                $this->Dosis_Pemakaian->CurrentValue = HtmlDecode($this->Dosis_Pemakaian->CurrentValue);
            }
            $this->Dosis_Pemakaian->EditValue = HtmlEncode($this->Dosis_Pemakaian->CurrentValue);
            $this->Dosis_Pemakaian->PlaceHolder = RemoveHtml($this->Dosis_Pemakaian->caption());

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->setupEditAttributes();
            if (!$this->Waktu_Aplikasi->Raw) {
                $this->Waktu_Aplikasi->CurrentValue = HtmlDecode($this->Waktu_Aplikasi->CurrentValue);
            }
            $this->Waktu_Aplikasi->EditValue = HtmlEncode($this->Waktu_Aplikasi->CurrentValue);
            $this->Waktu_Aplikasi->PlaceHolder = RemoveHtml($this->Waktu_Aplikasi->caption());

            // Keterangan
            $this->Keterangan->setupEditAttributes();
            $this->Keterangan->EditValue = HtmlEncode($this->Keterangan->CurrentValue);
            $this->Keterangan->PlaceHolder = RemoveHtml($this->Keterangan->caption());

            // Petugas_Update

            // Tanggal_Update

            // Petugas_Add
            $this->Petugas_Add->setupEditAttributes();

            // Tanggal_Add
            $this->Tanggal_Add->setupEditAttributes();
            $this->Tanggal_Add->CurrentValue = FormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern());

            // Edit refer script

            // ID_Penggunan
            $this->ID_Penggunan->HrefValue = "";

            // ID_Kontrak
            $this->ID_Kontrak->HrefValue = "";

            // Jenis_Pestisida
            $this->Jenis_Pestisida->HrefValue = "";

            // Merek
            $this->Merek->HrefValue = "";

            // Bahan_Aktif
            $this->Bahan_Aktif->HrefValue = "";

            // Dosis_Pemakaian
            $this->Dosis_Pemakaian->HrefValue = "";

            // Waktu_Aplikasi
            $this->Waktu_Aplikasi->HrefValue = "";

            // Keterangan
            $this->Keterangan->HrefValue = "";

            // Petugas_Update
            $this->Petugas_Update->HrefValue = "";

            // Tanggal_Update
            $this->Tanggal_Update->HrefValue = "";

            // Petugas_Add
            $this->Petugas_Add->HrefValue = "";

            // Tanggal_Add
            $this->Tanggal_Add->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->ID_Penggunan->Visible && $this->ID_Penggunan->Required) {
            if (!$this->ID_Penggunan->IsDetailKey && EmptyValue($this->ID_Penggunan->FormValue)) {
                $this->ID_Penggunan->addErrorMessage(str_replace("%s", $this->ID_Penggunan->caption(), $this->ID_Penggunan->RequiredErrorMessage));
            }
        }
        if ($this->ID_Kontrak->Visible && $this->ID_Kontrak->Required) {
            if (!$this->ID_Kontrak->IsDetailKey && EmptyValue($this->ID_Kontrak->FormValue)) {
                $this->ID_Kontrak->addErrorMessage(str_replace("%s", $this->ID_Kontrak->caption(), $this->ID_Kontrak->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ID_Kontrak->FormValue)) {
            $this->ID_Kontrak->addErrorMessage($this->ID_Kontrak->getErrorMessage(false));
        }
        if ($this->Jenis_Pestisida->Visible && $this->Jenis_Pestisida->Required) {
            if (!$this->Jenis_Pestisida->IsDetailKey && EmptyValue($this->Jenis_Pestisida->FormValue)) {
                $this->Jenis_Pestisida->addErrorMessage(str_replace("%s", $this->Jenis_Pestisida->caption(), $this->Jenis_Pestisida->RequiredErrorMessage));
            }
        }
        if ($this->Merek->Visible && $this->Merek->Required) {
            if (!$this->Merek->IsDetailKey && EmptyValue($this->Merek->FormValue)) {
                $this->Merek->addErrorMessage(str_replace("%s", $this->Merek->caption(), $this->Merek->RequiredErrorMessage));
            }
        }
        if ($this->Bahan_Aktif->Visible && $this->Bahan_Aktif->Required) {
            if (!$this->Bahan_Aktif->IsDetailKey && EmptyValue($this->Bahan_Aktif->FormValue)) {
                $this->Bahan_Aktif->addErrorMessage(str_replace("%s", $this->Bahan_Aktif->caption(), $this->Bahan_Aktif->RequiredErrorMessage));
            }
        }
        if ($this->Dosis_Pemakaian->Visible && $this->Dosis_Pemakaian->Required) {
            if (!$this->Dosis_Pemakaian->IsDetailKey && EmptyValue($this->Dosis_Pemakaian->FormValue)) {
                $this->Dosis_Pemakaian->addErrorMessage(str_replace("%s", $this->Dosis_Pemakaian->caption(), $this->Dosis_Pemakaian->RequiredErrorMessage));
            }
        }
        if ($this->Waktu_Aplikasi->Visible && $this->Waktu_Aplikasi->Required) {
            if (!$this->Waktu_Aplikasi->IsDetailKey && EmptyValue($this->Waktu_Aplikasi->FormValue)) {
                $this->Waktu_Aplikasi->addErrorMessage(str_replace("%s", $this->Waktu_Aplikasi->caption(), $this->Waktu_Aplikasi->RequiredErrorMessage));
            }
        }
        if ($this->Keterangan->Visible && $this->Keterangan->Required) {
            if (!$this->Keterangan->IsDetailKey && EmptyValue($this->Keterangan->FormValue)) {
                $this->Keterangan->addErrorMessage(str_replace("%s", $this->Keterangan->caption(), $this->Keterangan->RequiredErrorMessage));
            }
        }
        if ($this->Petugas_Update->Visible && $this->Petugas_Update->Required) {
            if (!$this->Petugas_Update->IsDetailKey && EmptyValue($this->Petugas_Update->FormValue)) {
                $this->Petugas_Update->addErrorMessage(str_replace("%s", $this->Petugas_Update->caption(), $this->Petugas_Update->RequiredErrorMessage));
            }
        }
        if ($this->Tanggal_Update->Visible && $this->Tanggal_Update->Required) {
            if (!$this->Tanggal_Update->IsDetailKey && EmptyValue($this->Tanggal_Update->FormValue)) {
                $this->Tanggal_Update->addErrorMessage(str_replace("%s", $this->Tanggal_Update->caption(), $this->Tanggal_Update->RequiredErrorMessage));
            }
        }
        if ($this->Petugas_Add->Visible && $this->Petugas_Add->Required) {
            if (!$this->Petugas_Add->IsDetailKey && EmptyValue($this->Petugas_Add->FormValue)) {
                $this->Petugas_Add->addErrorMessage(str_replace("%s", $this->Petugas_Add->caption(), $this->Petugas_Add->RequiredErrorMessage));
            }
        }
        if ($this->Tanggal_Add->Visible && $this->Tanggal_Add->Required) {
            if (!$this->Tanggal_Add->IsDetailKey && EmptyValue($this->Tanggal_Add->FormValue)) {
                $this->Tanggal_Add->addErrorMessage(str_replace("%s", $this->Tanggal_Add->caption(), $this->Tanggal_Add->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
        }

        // Set new row
        $rsnew = [];

        // ID_Kontrak
        if ($this->ID_Kontrak->getSessionValue() != "") {
            $this->ID_Kontrak->ReadOnly = true;
        }
        $this->ID_Kontrak->setDbValueDef($rsnew, $this->ID_Kontrak->CurrentValue, $this->ID_Kontrak->ReadOnly);

        // Jenis_Pestisida
        $this->Jenis_Pestisida->setDbValueDef($rsnew, $this->Jenis_Pestisida->CurrentValue, $this->Jenis_Pestisida->ReadOnly);

        // Merek
        $this->Merek->setDbValueDef($rsnew, $this->Merek->CurrentValue, $this->Merek->ReadOnly);

        // Bahan_Aktif
        $this->Bahan_Aktif->setDbValueDef($rsnew, $this->Bahan_Aktif->CurrentValue, $this->Bahan_Aktif->ReadOnly);

        // Dosis_Pemakaian
        $this->Dosis_Pemakaian->setDbValueDef($rsnew, $this->Dosis_Pemakaian->CurrentValue, $this->Dosis_Pemakaian->ReadOnly);

        // Waktu_Aplikasi
        $this->Waktu_Aplikasi->setDbValueDef($rsnew, $this->Waktu_Aplikasi->CurrentValue, $this->Waktu_Aplikasi->ReadOnly);

        // Keterangan
        $this->Keterangan->setDbValueDef($rsnew, $this->Keterangan->CurrentValue, $this->Keterangan->ReadOnly);

        // Petugas_Update
        $this->Petugas_Update->CurrentValue = $this->Petugas_Update->getAutoUpdateValue(); // PHP
        $this->Petugas_Update->setDbValueDef($rsnew, $this->Petugas_Update->CurrentValue);

        // Tanggal_Update
        $this->Tanggal_Update->CurrentValue = $this->Tanggal_Update->getAutoUpdateValue(); // PHP
        $this->Tanggal_Update->setDbValueDef($rsnew, $this->Tanggal_Update->CurrentValue);

        // Petugas_Add
        $this->Petugas_Add->setDbValueDef($rsnew, $this->Petugas_Add->CurrentValue, $this->Petugas_Add->ReadOnly);

        // Tanggal_Add
        $this->Tanggal_Add->setDbValueDef($rsnew, UnFormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern()), $this->Tanggal_Add->ReadOnly);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "kontrak") {
                $validMaster = true;
                $masterTbl = Container("kontrak");
                if (($parm = Get("fk_k_id", Get("ID_Kontrak"))) !== null) {
                    $masterTbl->k_id->setQueryStringValue($parm);
                    $this->ID_Kontrak->QueryStringValue = $masterTbl->k_id->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->ID_Kontrak->setSessionValue($this->ID_Kontrak->QueryStringValue);
                    $foreignKeys["ID_Kontrak"] = $this->ID_Kontrak->QueryStringValue;
                    if (!is_numeric($masterTbl->k_id->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "kontrak") {
                $validMaster = true;
                $masterTbl = Container("kontrak");
                if (($parm = Post("fk_k_id", Post("ID_Kontrak"))) !== null) {
                    $masterTbl->k_id->setFormValue($parm);
                    $this->ID_Kontrak->FormValue = $masterTbl->k_id->FormValue;
                    $this->ID_Kontrak->setSessionValue($this->ID_Kontrak->FormValue);
                    $foreignKeys["ID_Kontrak"] = $this->ID_Kontrak->FormValue;
                    if (!is_numeric($masterTbl->k_id->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);
            $this->setSessionWhere($this->getDetailFilterFromSession());

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "kontrak") {
                if (!array_key_exists("ID_Kontrak", $foreignKeys)) { // Not current foreign key
                    $this->ID_Kontrak->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("PenggunaanPestisidaList"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Jenis_Pestisida":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
