<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Table class for penggunaan_pestisida
 */
class PenggunaanPestisida extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $ID_Penggunan;
    public $ID_Kontrak;
    public $Jenis_Pestisida;
    public $Merek;
    public $Bahan_Aktif;
    public $Dosis_Pemakaian;
    public $Waktu_Aplikasi;
    public $Keterangan;
    public $Petugas_Update;
    public $Tanggal_Update;
    public $Petugas_Add;
    public $Tanggal_Add;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("language");
        $this->TableVar = "penggunaan_pestisida";
        $this->TableName = 'penggunaan_pestisida';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "penggunaan_pestisida";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = true; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ID_Penggunan
        $this->ID_Penggunan = new DbField(
            $this, // Table
            'x_ID_Penggunan', // Variable name
            'ID_Penggunan', // Name
            '`ID_Penggunan`', // Expression
            '`ID_Penggunan`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ID_Penggunan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->ID_Penggunan->InputTextType = "text";
        $this->ID_Penggunan->IsAutoIncrement = true; // Autoincrement field
        $this->ID_Penggunan->IsPrimaryKey = true; // Primary key field
        $this->ID_Penggunan->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ID_Penggunan->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ID_Penggunan'] = &$this->ID_Penggunan;

        // ID_Kontrak
        $this->ID_Kontrak = new DbField(
            $this, // Table
            'x_ID_Kontrak', // Variable name
            'ID_Kontrak', // Name
            '`ID_Kontrak`', // Expression
            '`ID_Kontrak`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ID_Kontrak`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ID_Kontrak->InputTextType = "text";
        $this->ID_Kontrak->IsForeignKey = true; // Foreign key field
        $this->ID_Kontrak->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ID_Kontrak->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ID_Kontrak'] = &$this->ID_Kontrak;

        // Jenis_Pestisida
        $this->Jenis_Pestisida = new DbField(
            $this, // Table
            'x_Jenis_Pestisida', // Variable name
            'Jenis_Pestisida', // Name
            '`Jenis_Pestisida`', // Expression
            '`Jenis_Pestisida`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Jenis_Pestisida`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Jenis_Pestisida->InputTextType = "text";
        $this->Jenis_Pestisida->setSelectMultiple(false); // Select one
        $this->Jenis_Pestisida->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Jenis_Pestisida->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Jenis_Pestisida->Lookup = new Lookup('Jenis_Pestisida', 'penggunaan_pestisida', false, '', ["","","",""], '', '', [], [], [], [], [], [], '', '', "");
        $this->Jenis_Pestisida->OptionCount = 8;
        $this->Jenis_Pestisida->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Jenis_Pestisida'] = &$this->Jenis_Pestisida;

        // Merek
        $this->Merek = new DbField(
            $this, // Table
            'x_Merek', // Variable name
            'Merek', // Name
            '`Merek`', // Expression
            '`Merek`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Merek`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Merek->InputTextType = "text";
        $this->Merek->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Merek'] = &$this->Merek;

        // Bahan_Aktif
        $this->Bahan_Aktif = new DbField(
            $this, // Table
            'x_Bahan_Aktif', // Variable name
            'Bahan_Aktif', // Name
            '`Bahan_Aktif`', // Expression
            '`Bahan_Aktif`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Bahan_Aktif`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Bahan_Aktif->InputTextType = "text";
        $this->Bahan_Aktif->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Bahan_Aktif'] = &$this->Bahan_Aktif;

        // Dosis_Pemakaian
        $this->Dosis_Pemakaian = new DbField(
            $this, // Table
            'x_Dosis_Pemakaian', // Variable name
            'Dosis_Pemakaian', // Name
            '`Dosis_Pemakaian`', // Expression
            '`Dosis_Pemakaian`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Dosis_Pemakaian`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Dosis_Pemakaian->InputTextType = "text";
        $this->Dosis_Pemakaian->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Dosis_Pemakaian'] = &$this->Dosis_Pemakaian;

        // Waktu_Aplikasi
        $this->Waktu_Aplikasi = new DbField(
            $this, // Table
            'x_Waktu_Aplikasi', // Variable name
            'Waktu_Aplikasi', // Name
            '`Waktu_Aplikasi`', // Expression
            '`Waktu_Aplikasi`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Waktu_Aplikasi`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Waktu_Aplikasi->InputTextType = "text";
        $this->Waktu_Aplikasi->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Waktu_Aplikasi'] = &$this->Waktu_Aplikasi;

        // Keterangan
        $this->Keterangan = new DbField(
            $this, // Table
            'x_Keterangan', // Variable name
            'Keterangan', // Name
            '`Keterangan`', // Expression
            '`Keterangan`', // Basic search expression
            201, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Keterangan`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->Keterangan->InputTextType = "text";
        $this->Keterangan->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Keterangan'] = &$this->Keterangan;

        // Petugas_Update
        $this->Petugas_Update = new DbField(
            $this, // Table
            'x_Petugas_Update', // Variable name
            'Petugas_Update', // Name
            '`Petugas_Update`', // Expression
            '`Petugas_Update`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Petugas_Update`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Petugas_Update->addMethod("getAutoUpdateValue", fn() => CurrentUserName());
        $this->Petugas_Update->InputTextType = "text";
        $this->Petugas_Update->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Petugas_Update'] = &$this->Petugas_Update;

        // Tanggal_Update
        $this->Tanggal_Update = new DbField(
            $this, // Table
            'x_Tanggal_Update', // Variable name
            'Tanggal_Update', // Name
            '`Tanggal_Update`', // Expression
            CastDateFieldForLike("`Tanggal_Update`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`Tanggal_Update`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Tanggal_Update->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->Tanggal_Update->InputTextType = "text";
        $this->Tanggal_Update->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Tanggal_Update->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Tanggal_Update'] = &$this->Tanggal_Update;

        // Petugas_Add
        $this->Petugas_Add = new DbField(
            $this, // Table
            'x_Petugas_Add', // Variable name
            'Petugas_Add', // Name
            '`Petugas_Add`', // Expression
            '`Petugas_Add`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Petugas_Add`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Petugas_Add->addMethod("getDefault", fn() => CurrentUserName());
        $this->Petugas_Add->InputTextType = "text";
        $this->Petugas_Add->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Petugas_Add'] = &$this->Petugas_Add;

        // Tanggal_Add
        $this->Tanggal_Add = new DbField(
            $this, // Table
            'x_Tanggal_Add', // Variable name
            'Tanggal_Add', // Name
            '`Tanggal_Add`', // Expression
            CastDateFieldForLike("`Tanggal_Add`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`Tanggal_Add`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Tanggal_Add->addMethod("getDefault", fn() => CurrentDateTime());
        $this->Tanggal_Add->InputTextType = "text";
        $this->Tanggal_Add->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Tanggal_Add->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Tanggal_Add'] = &$this->Tanggal_Add;

        // Add Doctrine Cache
        $this->Cache = new ArrayCache();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "kontrak") {
            $masterTable = Container("kontrak");
            if ($this->ID_Kontrak->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->k_id, $this->ID_Kontrak->getSessionValue(), $masterTable->k_id->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "kontrak") {
            $masterTable = Container("kontrak");
            if ($this->ID_Kontrak->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->ID_Kontrak, $this->ID_Kontrak->getSessionValue(), $masterTable->k_id->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "kontrak":
                $key = $keys["ID_Kontrak"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->k_id->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->k_id, $keys["ID_Kontrak"], $this->ID_Kontrak->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "kontrak":
                return GetKeyFilter($this->ID_Kontrak, $masterTable->k_id->DbValue, $masterTable->k_id->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "penggunaan_pestisida";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            case "lookup":
                return (($allow & 256) == 256);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlwrk);
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $success = $this->insertSql($rs)->execute();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($success) {
            // Get insert id if necessary
            $this->ID_Penggunan->setDbValue($conn->lastInsertId());
            $rs['ID_Penggunan'] = $this->ID_Penggunan->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->execute();
            $success = ($success > 0) ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['ID_Penggunan']) && !EmptyValue($this->ID_Penggunan->CurrentValue)) {
                $rs['ID_Penggunan'] = $this->ID_Penggunan->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('ID_Penggunan', $rs)) {
                AddFilter($where, QuotedName('ID_Penggunan', $this->Dbid) . '=' . QuotedValue($rs['ID_Penggunan'], $this->ID_Penggunan->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->execute();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ID_Penggunan->DbValue = $row['ID_Penggunan'];
        $this->ID_Kontrak->DbValue = $row['ID_Kontrak'];
        $this->Jenis_Pestisida->DbValue = $row['Jenis_Pestisida'];
        $this->Merek->DbValue = $row['Merek'];
        $this->Bahan_Aktif->DbValue = $row['Bahan_Aktif'];
        $this->Dosis_Pemakaian->DbValue = $row['Dosis_Pemakaian'];
        $this->Waktu_Aplikasi->DbValue = $row['Waktu_Aplikasi'];
        $this->Keterangan->DbValue = $row['Keterangan'];
        $this->Petugas_Update->DbValue = $row['Petugas_Update'];
        $this->Tanggal_Update->DbValue = $row['Tanggal_Update'];
        $this->Petugas_Add->DbValue = $row['Petugas_Add'];
        $this->Tanggal_Add->DbValue = $row['Tanggal_Add'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`ID_Penggunan` = @ID_Penggunan@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->ID_Penggunan->CurrentValue : $this->ID_Penggunan->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->ID_Penggunan->CurrentValue = $keys[0];
            } else {
                $this->ID_Penggunan->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('ID_Penggunan', $row) ? $row['ID_Penggunan'] : null;
        } else {
            $val = !EmptyValue($this->ID_Penggunan->OldValue) && !$current ? $this->ID_Penggunan->OldValue : $this->ID_Penggunan->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@ID_Penggunan@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("PenggunaanPestisidaList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "PenggunaanPestisidaView") {
            return $Language->phrase("View");
        } elseif ($pageName == "PenggunaanPestisidaEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "PenggunaanPestisidaAdd") {
            return $Language->phrase("Add");
        }
        return "";
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "PenggunaanPestisidaView";
            case Config("API_ADD_ACTION"):
                return "PenggunaanPestisidaAdd";
            case Config("API_EDIT_ACTION"):
                return "PenggunaanPestisidaEdit";
            case Config("API_DELETE_ACTION"):
                return "PenggunaanPestisidaDelete";
            case Config("API_LIST_ACTION"):
                return "PenggunaanPestisidaList";
            default:
                return "";
        }
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "PenggunaanPestisidaList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("PenggunaanPestisidaView", $parm);
        } else {
            $url = $this->keyUrl("PenggunaanPestisidaView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "PenggunaanPestisidaAdd?" . $parm;
        } else {
            $url = "PenggunaanPestisidaAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("PenggunaanPestisidaEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("PenggunaanPestisidaList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("PenggunaanPestisidaAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("PenggunaanPestisidaList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("PenggunaanPestisidaDelete");
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "kontrak" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_k_id", $this->ID_Kontrak->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"ID_Penggunan\":" . JsonEncode($this->ID_Penggunan->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->ID_Penggunan->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->ID_Penggunan->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language, $Page;
        $sortUrl = "";
        $attrs = "";
        if ($fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") . '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;dashboard=true";
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("ID_Penggunan") ?? Route("ID_Penggunan")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->ID_Penggunan->CurrentValue = $key;
            } else {
                $this->ID_Penggunan->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter / sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ID_Penggunan->setDbValue($row['ID_Penggunan']);
        $this->ID_Kontrak->setDbValue($row['ID_Kontrak']);
        $this->Jenis_Pestisida->setDbValue($row['Jenis_Pestisida']);
        $this->Merek->setDbValue($row['Merek']);
        $this->Bahan_Aktif->setDbValue($row['Bahan_Aktif']);
        $this->Dosis_Pemakaian->setDbValue($row['Dosis_Pemakaian']);
        $this->Waktu_Aplikasi->setDbValue($row['Waktu_Aplikasi']);
        $this->Keterangan->setDbValue($row['Keterangan']);
        $this->Petugas_Update->setDbValue($row['Petugas_Update']);
        $this->Tanggal_Update->setDbValue($row['Tanggal_Update']);
        $this->Petugas_Add->setDbValue($row['Petugas_Add']);
        $this->Tanggal_Add->setDbValue($row['Tanggal_Add']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PenggunaanPestisidaList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ID_Penggunan

        // ID_Kontrak

        // Jenis_Pestisida

        // Merek

        // Bahan_Aktif

        // Dosis_Pemakaian

        // Waktu_Aplikasi

        // Keterangan

        // Petugas_Update

        // Tanggal_Update

        // Petugas_Add

        // Tanggal_Add

        // ID_Penggunan
        $this->ID_Penggunan->ViewValue = $this->ID_Penggunan->CurrentValue;

        // ID_Kontrak
        $this->ID_Kontrak->ViewValue = $this->ID_Kontrak->CurrentValue;
        $this->ID_Kontrak->ViewValue = FormatNumber($this->ID_Kontrak->ViewValue, $this->ID_Kontrak->formatPattern());

        // Jenis_Pestisida
        if (strval($this->Jenis_Pestisida->CurrentValue) != "") {
            $this->Jenis_Pestisida->ViewValue = $this->Jenis_Pestisida->optionCaption($this->Jenis_Pestisida->CurrentValue);
        } else {
            $this->Jenis_Pestisida->ViewValue = null;
        }

        // Merek
        $this->Merek->ViewValue = $this->Merek->CurrentValue;

        // Bahan_Aktif
        $this->Bahan_Aktif->ViewValue = $this->Bahan_Aktif->CurrentValue;

        // Dosis_Pemakaian
        $this->Dosis_Pemakaian->ViewValue = $this->Dosis_Pemakaian->CurrentValue;

        // Waktu_Aplikasi
        $this->Waktu_Aplikasi->ViewValue = $this->Waktu_Aplikasi->CurrentValue;

        // Keterangan
        $this->Keterangan->ViewValue = $this->Keterangan->CurrentValue;

        // Petugas_Update
        $this->Petugas_Update->ViewValue = $this->Petugas_Update->CurrentValue;

        // Tanggal_Update
        $this->Tanggal_Update->ViewValue = $this->Tanggal_Update->CurrentValue;
        $this->Tanggal_Update->ViewValue = FormatDateTime($this->Tanggal_Update->ViewValue, $this->Tanggal_Update->formatPattern());

        // Petugas_Add
        $this->Petugas_Add->ViewValue = $this->Petugas_Add->CurrentValue;

        // Tanggal_Add
        $this->Tanggal_Add->ViewValue = $this->Tanggal_Add->CurrentValue;
        $this->Tanggal_Add->ViewValue = FormatDateTime($this->Tanggal_Add->ViewValue, $this->Tanggal_Add->formatPattern());

        // ID_Penggunan
        $this->ID_Penggunan->HrefValue = "";
        $this->ID_Penggunan->TooltipValue = "";

        // ID_Kontrak
        $this->ID_Kontrak->HrefValue = "";
        $this->ID_Kontrak->TooltipValue = "";

        // Jenis_Pestisida
        $this->Jenis_Pestisida->HrefValue = "";
        $this->Jenis_Pestisida->TooltipValue = "";

        // Merek
        $this->Merek->HrefValue = "";
        $this->Merek->TooltipValue = "";

        // Bahan_Aktif
        $this->Bahan_Aktif->HrefValue = "";
        $this->Bahan_Aktif->TooltipValue = "";

        // Dosis_Pemakaian
        $this->Dosis_Pemakaian->HrefValue = "";
        $this->Dosis_Pemakaian->TooltipValue = "";

        // Waktu_Aplikasi
        $this->Waktu_Aplikasi->HrefValue = "";
        $this->Waktu_Aplikasi->TooltipValue = "";

        // Keterangan
        $this->Keterangan->HrefValue = "";
        $this->Keterangan->TooltipValue = "";

        // Petugas_Update
        $this->Petugas_Update->HrefValue = "";
        $this->Petugas_Update->TooltipValue = "";

        // Tanggal_Update
        $this->Tanggal_Update->HrefValue = "";
        $this->Tanggal_Update->TooltipValue = "";

        // Petugas_Add
        $this->Petugas_Add->HrefValue = "";
        $this->Petugas_Add->TooltipValue = "";

        // Tanggal_Add
        $this->Tanggal_Add->HrefValue = "";
        $this->Tanggal_Add->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ID_Penggunan
        $this->ID_Penggunan->setupEditAttributes();
        $this->ID_Penggunan->EditValue = $this->ID_Penggunan->CurrentValue;

        // ID_Kontrak
        $this->ID_Kontrak->setupEditAttributes();
        if ($this->ID_Kontrak->getSessionValue() != "") {
            $this->ID_Kontrak->CurrentValue = GetForeignKeyValue($this->ID_Kontrak->getSessionValue());
            $this->ID_Kontrak->ViewValue = $this->ID_Kontrak->CurrentValue;
            $this->ID_Kontrak->ViewValue = FormatNumber($this->ID_Kontrak->ViewValue, $this->ID_Kontrak->formatPattern());
        } else {
            $this->ID_Kontrak->EditValue = $this->ID_Kontrak->CurrentValue;
            $this->ID_Kontrak->PlaceHolder = RemoveHtml($this->ID_Kontrak->caption());
            if (strval($this->ID_Kontrak->EditValue) != "" && is_numeric($this->ID_Kontrak->EditValue)) {
                $this->ID_Kontrak->EditValue = FormatNumber($this->ID_Kontrak->EditValue, null);
            }
        }

        // Jenis_Pestisida
        $this->Jenis_Pestisida->setupEditAttributes();
        $this->Jenis_Pestisida->EditValue = $this->Jenis_Pestisida->options(true);
        $this->Jenis_Pestisida->PlaceHolder = RemoveHtml($this->Jenis_Pestisida->caption());

        // Merek
        $this->Merek->setupEditAttributes();
        if (!$this->Merek->Raw) {
            $this->Merek->CurrentValue = HtmlDecode($this->Merek->CurrentValue);
        }
        $this->Merek->EditValue = $this->Merek->CurrentValue;
        $this->Merek->PlaceHolder = RemoveHtml($this->Merek->caption());

        // Bahan_Aktif
        $this->Bahan_Aktif->setupEditAttributes();
        if (!$this->Bahan_Aktif->Raw) {
            $this->Bahan_Aktif->CurrentValue = HtmlDecode($this->Bahan_Aktif->CurrentValue);
        }
        $this->Bahan_Aktif->EditValue = $this->Bahan_Aktif->CurrentValue;
        $this->Bahan_Aktif->PlaceHolder = RemoveHtml($this->Bahan_Aktif->caption());

        // Dosis_Pemakaian
        $this->Dosis_Pemakaian->setupEditAttributes();
        if (!$this->Dosis_Pemakaian->Raw) {
            $this->Dosis_Pemakaian->CurrentValue = HtmlDecode($this->Dosis_Pemakaian->CurrentValue);
        }
        $this->Dosis_Pemakaian->EditValue = $this->Dosis_Pemakaian->CurrentValue;
        $this->Dosis_Pemakaian->PlaceHolder = RemoveHtml($this->Dosis_Pemakaian->caption());

        // Waktu_Aplikasi
        $this->Waktu_Aplikasi->setupEditAttributes();
        if (!$this->Waktu_Aplikasi->Raw) {
            $this->Waktu_Aplikasi->CurrentValue = HtmlDecode($this->Waktu_Aplikasi->CurrentValue);
        }
        $this->Waktu_Aplikasi->EditValue = $this->Waktu_Aplikasi->CurrentValue;
        $this->Waktu_Aplikasi->PlaceHolder = RemoveHtml($this->Waktu_Aplikasi->caption());

        // Keterangan
        $this->Keterangan->setupEditAttributes();
        $this->Keterangan->EditValue = $this->Keterangan->CurrentValue;
        $this->Keterangan->PlaceHolder = RemoveHtml($this->Keterangan->caption());

        // Petugas_Update

        // Tanggal_Update

        // Petugas_Add
        $this->Petugas_Add->setupEditAttributes();

        // Tanggal_Add
        $this->Tanggal_Add->setupEditAttributes();
        $this->Tanggal_Add->CurrentValue = FormatDateTime($this->Tanggal_Add->CurrentValue, $this->Tanggal_Add->formatPattern());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ID_Penggunan);
                    $doc->exportCaption($this->ID_Kontrak);
                    $doc->exportCaption($this->Jenis_Pestisida);
                    $doc->exportCaption($this->Merek);
                    $doc->exportCaption($this->Bahan_Aktif);
                    $doc->exportCaption($this->Dosis_Pemakaian);
                    $doc->exportCaption($this->Waktu_Aplikasi);
                    $doc->exportCaption($this->Keterangan);
                    $doc->exportCaption($this->Petugas_Update);
                    $doc->exportCaption($this->Tanggal_Update);
                    $doc->exportCaption($this->Petugas_Add);
                    $doc->exportCaption($this->Tanggal_Add);
                } else {
                    $doc->exportCaption($this->ID_Penggunan);
                    $doc->exportCaption($this->ID_Kontrak);
                    $doc->exportCaption($this->Jenis_Pestisida);
                    $doc->exportCaption($this->Merek);
                    $doc->exportCaption($this->Bahan_Aktif);
                    $doc->exportCaption($this->Dosis_Pemakaian);
                    $doc->exportCaption($this->Waktu_Aplikasi);
                    $doc->exportCaption($this->Petugas_Update);
                    $doc->exportCaption($this->Tanggal_Update);
                    $doc->exportCaption($this->Petugas_Add);
                    $doc->exportCaption($this->Tanggal_Add);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ID_Penggunan);
                        $doc->exportField($this->ID_Kontrak);
                        $doc->exportField($this->Jenis_Pestisida);
                        $doc->exportField($this->Merek);
                        $doc->exportField($this->Bahan_Aktif);
                        $doc->exportField($this->Dosis_Pemakaian);
                        $doc->exportField($this->Waktu_Aplikasi);
                        $doc->exportField($this->Keterangan);
                        $doc->exportField($this->Petugas_Update);
                        $doc->exportField($this->Tanggal_Update);
                        $doc->exportField($this->Petugas_Add);
                        $doc->exportField($this->Tanggal_Add);
                    } else {
                        $doc->exportField($this->ID_Penggunan);
                        $doc->exportField($this->ID_Kontrak);
                        $doc->exportField($this->Jenis_Pestisida);
                        $doc->exportField($this->Merek);
                        $doc->exportField($this->Bahan_Aktif);
                        $doc->exportField($this->Dosis_Pemakaian);
                        $doc->exportField($this->Waktu_Aplikasi);
                        $doc->exportField($this->Petugas_Update);
                        $doc->exportField($this->Tanggal_Update);
                        $doc->exportField($this->Petugas_Add);
                        $doc->exportField($this->Tanggal_Add);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
