<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class KontrakView extends Kontrak
{
    use MessagesTrait;

    // Page ID
    public $PageID = "view";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "KontrakView";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "KontrakView";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->k_id->setVisibility();
        $this->k_id_kontrak->setVisibility();
        $this->k_id_lama->setVisibility();
        $this->k_no_kontrak->setVisibility();
        $this->k_luas_lahan->setVisibility();
        $this->pet_id->setVisibility();
        $this->koord_id->setVisibility();
        $this->kk_id->setVisibility();
        $this->prov_id->setVisibility();
        $this->kab_id->setVisibility();
        $this->kec_id->setVisibility();
        $this->desa_id->setVisibility();
        $this->blok_id->setVisibility();
        $this->sos_id->setVisibility();
        $this->var_id->setVisibility();
        $this->co_id->setVisibility();
        $this->k_jumlah_bibit->setVisibility();
        $this->k_asal_bibit->setVisibility();
        $this->k_tgl_tanam->setVisibility();
        $this->k_es_tgl_panen->setVisibility();
        $this->k_ak_tgl_datang->setVisibility();
        $this->k_es_qty->setVisibility();
        $this->k_ak_qty->setVisibility();
        $this->k_es_perhektar->setVisibility();
        $this->k_ak_perhektar->setVisibility();
        $this->k_skor->setVisibility();
        $this->k_ket->setVisibility();
        $this->k_cat->setVisibility();
        $this->k_titik_koordinat->setVisibility();
        $this->k_foto_lahan->setVisibility();
        $this->k_dok->setVisibility();
        $this->k_harga_bibit->setVisibility();
        $this->k_bayar_bibit->setVisibility();
        $this->k_pinjaman->setVisibility();
        $this->k_bayar_pinjaman->setVisibility();
        $this->k_sisa_hutang->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'kontrak';
        $this->TableName = 'kontrak';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (kontrak)
        if (!isset($GLOBALS["kontrak"]) || get_class($GLOBALS["kontrak"]) == PROJECT_NAMESPACE . "kontrak") {
            $GLOBALS["kontrak"] = &$this;
        }

        // Set up record key
        if (($keyValue = Get("k_id") ?? Route("k_id")) !== null) {
            $this->RecKey["k_id"] = $keyValue;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'kontrak');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(["TagClassName" => "ew-export-option"]);

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(["TagClassName" => "ew-detail-option"]);
        // Actions
        $this->OtherOptions["action"] = new ListOptions(["TagClassName" => "ew-action-option"]);
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "KontrakView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->k_foto_lahan->OldUploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
                $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->OldUploadPath;
                $this->k_dok->OldUploadPath = $this->k_dok->getUploadPath(); // PHP
                $this->k_dok->UploadPath = $this->k_dok->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['k_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->k_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $ExportOptions; // Export options
    public $OtherOptions; // Other options
    public $DisplayRecords = 1;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecKey = [];
    public $IsModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->pet_id);
        $this->setupLookupOptions($this->koord_id);
        $this->setupLookupOptions($this->kk_id);
        $this->setupLookupOptions($this->prov_id);
        $this->setupLookupOptions($this->kab_id);
        $this->setupLookupOptions($this->kec_id);
        $this->setupLookupOptions($this->desa_id);
        $this->setupLookupOptions($this->blok_id);
        $this->setupLookupOptions($this->sos_id);
        $this->setupLookupOptions($this->var_id);
        $this->setupLookupOptions($this->co_id);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }

        // Load current record
        $loadCurrentRecord = false;
        $returnUrl = "";
        $matchRecord = false;
        if (($keyValue = Get("k_id") ?? Route("k_id")) !== null) {
            $this->k_id->setQueryStringValue($keyValue);
            $this->RecKey["k_id"] = $this->k_id->QueryStringValue;
        } elseif (Post("k_id") !== null) {
            $this->k_id->setFormValue(Post("k_id"));
            $this->RecKey["k_id"] = $this->k_id->FormValue;
        } elseif (IsApi() && ($keyValue = Key(0) ?? Route(2)) !== null) {
            $this->k_id->setQueryStringValue($keyValue);
            $this->RecKey["k_id"] = $this->k_id->QueryStringValue;
        } elseif (!$loadCurrentRecord) {
            $returnUrl = "KontrakList"; // Return to list
        }

        // Get action
        $this->CurrentAction = "show"; // Display
        switch ($this->CurrentAction) {
            case "show": // Get a record to display

                    // Load record based on key
                    if (IsApi()) {
                        $filter = $this->getRecordFilter();
                        $this->CurrentFilter = $filter;
                        $sql = $this->getCurrentSql();
                        $conn = $this->getConnection();
                        $this->Recordset = LoadRecordset($sql, $conn);
                        $res = $this->Recordset && !$this->Recordset->EOF;
                    } else {
                        $res = $this->loadRow();
                    }
                    if (!$res) { // Load record based on key
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $returnUrl = "KontrakList"; // No matching record, return to list
                    }
                break;
        }

        // Setup export options
        $this->setupExportOptions();
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->RowType = ROWTYPE_VIEW;
        $this->resetAttributes();
        $this->renderRow();

        // Set up detail parameters
        $this->setupDetailParms();

        // Normal return
        if (IsApi()) {
            if (!$this->isExport()) {
                $row = $this->getRecordsFromRecordset($this->Recordset, true); // Get current record only
                $this->Recordset->close();
                WriteJson(["success" => true, "action" => Config("API_VIEW_ACTION"), $this->TableVar => $row]);
                $this->terminate(true);
            }
            return;
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Disable Add/Edit/Copy/Delete for Modal and UseAjaxActions
        /*
        if ($this->IsModal && $this->UseAjaxActions) {
            $this->AddUrl = "";
            $this->EditUrl = "";
            $this->CopyUrl = "";
            $this->DeleteUrl = "";
        }
        */
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();

        // Edit
        $item = &$option->add("edit");
        $editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        }
        $item->Visible = $this->EditUrl != "" && $Security->canEdit();

        // Copy
        $item = &$option->add("copy");
        $copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        }
        $item->Visible = $this->CopyUrl != "" && $Security->canAdd();

        // Delete
        $item = &$option->add("delete");
        $url = GetUrl($this->DeleteUrl);
        $item->Body = "<a class=\"ew-action ew-delete\"" .
            ($this->InlineDelete || $this->IsModal ? " data-ew-action=\"inline-delete\"" : "") .
            " title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) .
            "\" href=\"" . HtmlEncode($url) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
        $item->Visible = $this->DeleteUrl != "" && $Security->canDelete();
        $option = $options["detail"];
        $detailTableLink = "";
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_penggunaan_pestisida"
        $item = &$option->add("detail_penggunaan_pestisida");
        $body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("penggunaan_pestisida", "TblCaption");
        $body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode(GetUrl("PenggunaanPestisidaList?" . Config("TABLE_SHOW_MASTER") . "=kontrak&" . GetForeignKeyUrl("fk_k_id", $this->k_id->CurrentValue) . "")) . "\">" . $body . "</a>";
        $links = "";
        $detailPageObj = Container("PenggunaanPestisidaGrid");
        if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'kontrak')) {
            $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=penggunaan_pestisida"))) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            if ($detailViewTblVar != "") {
                $detailViewTblVar .= ",";
            }
            $detailViewTblVar .= "penggunaan_pestisida";
        }
        if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'kontrak')) {
            $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=penggunaan_pestisida"))) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            if ($detailEditTblVar != "") {
                $detailEditTblVar .= ",";
            }
            $detailEditTblVar .= "penggunaan_pestisida";
        }
        if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'kontrak')) {
            $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=penggunaan_pestisida"))) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            if ($detailCopyTblVar != "") {
                $detailCopyTblVar .= ",";
            }
            $detailCopyTblVar .= "penggunaan_pestisida";
        }
        if ($links != "") {
            $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
            $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
        } else {
            $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
        }
        $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
        $item->Body = $body;
        $item->Visible = $Security->allowList(CurrentProjectID() . 'penggunaan_pestisida');
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "penggunaan_pestisida";
        }
        if ($this->ShowMultipleDetails) {
            $item->Visible = false;
        }

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode(GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar))) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode(GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar))) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode(GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar))) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-dropdown-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $item = &$option->add("details");
            $item->Body = $body;
        }

        // Set up detail default
        $option = $options["detail"];
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $ar = explode(",", $detailTableLink);
        $cnt = count($ar);
        $option->UseDropDownButton = ($cnt > 1);
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
        $option->UseDropDownButton = !IsJsonResponse() && false;
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->k_id->setDbValue($row['k_id']);
        $this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
        $this->k_id_lama->setDbValue($row['k_id_lama']);
        $this->k_no_kontrak->setDbValue($row['k_no_kontrak']);
        $this->k_luas_lahan->setDbValue($row['k_luas_lahan']);
        $this->pet_id->setDbValue($row['pet_id']);
        if (array_key_exists('EV__pet_id', $row)) {
            $this->pet_id->VirtualValue = $row['EV__pet_id']; // Set up virtual field value
        } else {
            $this->pet_id->VirtualValue = ""; // Clear value
        }
        $this->koord_id->setDbValue($row['koord_id']);
        if (array_key_exists('EV__koord_id', $row)) {
            $this->koord_id->VirtualValue = $row['EV__koord_id']; // Set up virtual field value
        } else {
            $this->koord_id->VirtualValue = ""; // Clear value
        }
        $this->kk_id->setDbValue($row['kk_id']);
        $this->prov_id->setDbValue($row['prov_id']);
        if (array_key_exists('EV__prov_id', $row)) {
            $this->prov_id->VirtualValue = $row['EV__prov_id']; // Set up virtual field value
        } else {
            $this->prov_id->VirtualValue = ""; // Clear value
        }
        $this->kab_id->setDbValue($row['kab_id']);
        if (array_key_exists('EV__kab_id', $row)) {
            $this->kab_id->VirtualValue = $row['EV__kab_id']; // Set up virtual field value
        } else {
            $this->kab_id->VirtualValue = ""; // Clear value
        }
        $this->kec_id->setDbValue($row['kec_id']);
        if (array_key_exists('EV__kec_id', $row)) {
            $this->kec_id->VirtualValue = $row['EV__kec_id']; // Set up virtual field value
        } else {
            $this->kec_id->VirtualValue = ""; // Clear value
        }
        $this->desa_id->setDbValue($row['desa_id']);
        if (array_key_exists('EV__desa_id', $row)) {
            $this->desa_id->VirtualValue = $row['EV__desa_id']; // Set up virtual field value
        } else {
            $this->desa_id->VirtualValue = ""; // Clear value
        }
        $this->blok_id->setDbValue($row['blok_id']);
        if (array_key_exists('EV__blok_id', $row)) {
            $this->blok_id->VirtualValue = $row['EV__blok_id']; // Set up virtual field value
        } else {
            $this->blok_id->VirtualValue = ""; // Clear value
        }
        $this->sos_id->setDbValue($row['sos_id']);
        if (array_key_exists('EV__sos_id', $row)) {
            $this->sos_id->VirtualValue = $row['EV__sos_id']; // Set up virtual field value
        } else {
            $this->sos_id->VirtualValue = ""; // Clear value
        }
        $this->var_id->setDbValue($row['var_id']);
        $this->co_id->setDbValue($row['co_id']);
        $this->k_jumlah_bibit->setDbValue($row['k_jumlah_bibit']);
        $this->k_asal_bibit->setDbValue($row['k_asal_bibit']);
        $this->k_tgl_tanam->setDbValue($row['k_tgl_tanam']);
        $this->k_es_tgl_panen->setDbValue($row['k_es_tgl_panen']);
        $this->k_ak_tgl_datang->setDbValue($row['k_ak_tgl_datang']);
        $this->k_es_qty->setDbValue($row['k_es_qty']);
        $this->k_ak_qty->setDbValue($row['k_ak_qty']);
        $this->k_es_perhektar->setDbValue($row['k_es_perhektar']);
        $this->k_ak_perhektar->setDbValue($row['k_ak_perhektar']);
        $this->k_skor->setDbValue($row['k_skor']);
        $this->k_ket->setDbValue($row['k_ket']);
        $this->k_cat->setDbValue($row['k_cat']);
        $this->k_titik_koordinat->setDbValue($row['k_titik_koordinat']);
        $this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
        $this->k_foto_lahan->setDbValue($this->k_foto_lahan->Upload->DbValue);
        $this->k_dok->Upload->DbValue = $row['k_dok'];
        $this->k_dok->setDbValue($this->k_dok->Upload->DbValue);
        $this->k_harga_bibit->setDbValue($row['k_harga_bibit']);
        $this->k_bayar_bibit->setDbValue($row['k_bayar_bibit']);
        $this->k_pinjaman->setDbValue($row['k_pinjaman']);
        $this->k_bayar_pinjaman->setDbValue($row['k_bayar_pinjaman']);
        $this->k_sisa_hutang->setDbValue($row['k_sisa_hutang']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['k_id'] = $this->k_id->DefaultValue;
        $row['k_id_kontrak'] = $this->k_id_kontrak->DefaultValue;
        $row['k_id_lama'] = $this->k_id_lama->DefaultValue;
        $row['k_no_kontrak'] = $this->k_no_kontrak->DefaultValue;
        $row['k_luas_lahan'] = $this->k_luas_lahan->DefaultValue;
        $row['pet_id'] = $this->pet_id->DefaultValue;
        $row['koord_id'] = $this->koord_id->DefaultValue;
        $row['kk_id'] = $this->kk_id->DefaultValue;
        $row['prov_id'] = $this->prov_id->DefaultValue;
        $row['kab_id'] = $this->kab_id->DefaultValue;
        $row['kec_id'] = $this->kec_id->DefaultValue;
        $row['desa_id'] = $this->desa_id->DefaultValue;
        $row['blok_id'] = $this->blok_id->DefaultValue;
        $row['sos_id'] = $this->sos_id->DefaultValue;
        $row['var_id'] = $this->var_id->DefaultValue;
        $row['co_id'] = $this->co_id->DefaultValue;
        $row['k_jumlah_bibit'] = $this->k_jumlah_bibit->DefaultValue;
        $row['k_asal_bibit'] = $this->k_asal_bibit->DefaultValue;
        $row['k_tgl_tanam'] = $this->k_tgl_tanam->DefaultValue;
        $row['k_es_tgl_panen'] = $this->k_es_tgl_panen->DefaultValue;
        $row['k_ak_tgl_datang'] = $this->k_ak_tgl_datang->DefaultValue;
        $row['k_es_qty'] = $this->k_es_qty->DefaultValue;
        $row['k_ak_qty'] = $this->k_ak_qty->DefaultValue;
        $row['k_es_perhektar'] = $this->k_es_perhektar->DefaultValue;
        $row['k_ak_perhektar'] = $this->k_ak_perhektar->DefaultValue;
        $row['k_skor'] = $this->k_skor->DefaultValue;
        $row['k_ket'] = $this->k_ket->DefaultValue;
        $row['k_cat'] = $this->k_cat->DefaultValue;
        $row['k_titik_koordinat'] = $this->k_titik_koordinat->DefaultValue;
        $row['k_foto_lahan'] = $this->k_foto_lahan->DefaultValue;
        $row['k_dok'] = $this->k_dok->DefaultValue;
        $row['k_harga_bibit'] = $this->k_harga_bibit->DefaultValue;
        $row['k_bayar_bibit'] = $this->k_bayar_bibit->DefaultValue;
        $row['k_pinjaman'] = $this->k_pinjaman->DefaultValue;
        $row['k_bayar_pinjaman'] = $this->k_bayar_pinjaman->DefaultValue;
        $row['k_sisa_hutang'] = $this->k_sisa_hutang->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // k_id

        // k_id_kontrak

        // k_id_lama

        // k_no_kontrak

        // k_luas_lahan

        // pet_id

        // koord_id

        // kk_id

        // prov_id

        // kab_id

        // kec_id

        // desa_id

        // blok_id

        // sos_id

        // var_id

        // co_id

        // k_jumlah_bibit

        // k_asal_bibit

        // k_tgl_tanam

        // k_es_tgl_panen

        // k_ak_tgl_datang

        // k_es_qty

        // k_ak_qty

        // k_es_perhektar

        // k_ak_perhektar

        // k_skor

        // k_ket

        // k_cat

        // k_titik_koordinat

        // k_foto_lahan

        // k_dok

        // k_harga_bibit

        // k_bayar_bibit

        // k_pinjaman

        // k_bayar_pinjaman

        // k_sisa_hutang

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // k_id
            $this->k_id->ViewValue = $this->k_id->CurrentValue;

            // k_id_kontrak
            $this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;

            // k_luas_lahan
            $this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;

            // pet_id
            if ($this->pet_id->VirtualValue != "") {
                $this->pet_id->ViewValue = $this->pet_id->VirtualValue;
            } else {
                $this->pet_id->ViewValue = $this->pet_id->CurrentValue;
                $curVal = strval($this->pet_id->CurrentValue);
                if ($curVal != "") {
                    $this->pet_id->ViewValue = $this->pet_id->lookupCacheOption($curVal);
                    if ($this->pet_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`pet_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->pet_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->pet_id->Lookup->renderViewRow($rswrk[0]);
                            $this->pet_id->ViewValue = $this->pet_id->displayValue($arwrk);
                        } else {
                            $this->pet_id->ViewValue = $this->pet_id->CurrentValue;
                        }
                    }
                } else {
                    $this->pet_id->ViewValue = null;
                }
            }

            // koord_id
            if ($this->koord_id->VirtualValue != "") {
                $this->koord_id->ViewValue = $this->koord_id->VirtualValue;
            } else {
                $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                $curVal = strval($this->koord_id->CurrentValue);
                if ($curVal != "") {
                    $this->koord_id->ViewValue = $this->koord_id->lookupCacheOption($curVal);
                    if ($this->koord_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`koord_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->koord_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->koord_id->Lookup->renderViewRow($rswrk[0]);
                            $this->koord_id->ViewValue = $this->koord_id->displayValue($arwrk);
                        } else {
                            $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                        }
                    }
                } else {
                    $this->koord_id->ViewValue = null;
                }
            }

            // kk_id
            $curVal = strval($this->kk_id->CurrentValue);
            if ($curVal != "") {
                $this->kk_id->ViewValue = $this->kk_id->lookupCacheOption($curVal);
                if ($this->kk_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kk_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->kk_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->kk_id->Lookup->renderViewRow($rswrk[0]);
                        $this->kk_id->ViewValue = $this->kk_id->displayValue($arwrk);
                    } else {
                        $this->kk_id->ViewValue = $this->kk_id->CurrentValue;
                    }
                }
            } else {
                $this->kk_id->ViewValue = null;
            }

            // prov_id
            if ($this->prov_id->VirtualValue != "") {
                $this->prov_id->ViewValue = $this->prov_id->VirtualValue;
            } else {
                $curVal = strval($this->prov_id->CurrentValue);
                if ($curVal != "") {
                    $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
                    if ($this->prov_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->prov_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->prov_id->Lookup->renderViewRow($rswrk[0]);
                            $this->prov_id->ViewValue = $this->prov_id->displayValue($arwrk);
                        } else {
                            $this->prov_id->ViewValue = $this->prov_id->CurrentValue;
                        }
                    }
                } else {
                    $this->prov_id->ViewValue = null;
                }
            }

            // kab_id
            if ($this->kab_id->VirtualValue != "") {
                $this->kab_id->ViewValue = $this->kab_id->VirtualValue;
            } else {
                $curVal = strval($this->kab_id->CurrentValue);
                if ($curVal != "") {
                    $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
                    if ($this->kab_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kab_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kab_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kab_id->ViewValue = $this->kab_id->displayValue($arwrk);
                        } else {
                            $this->kab_id->ViewValue = $this->kab_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kab_id->ViewValue = null;
                }
            }

            // kec_id
            if ($this->kec_id->VirtualValue != "") {
                $this->kec_id->ViewValue = $this->kec_id->VirtualValue;
            } else {
                $curVal = strval($this->kec_id->CurrentValue);
                if ($curVal != "") {
                    $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
                    if ($this->kec_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kec_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kec_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kec_id->ViewValue = $this->kec_id->displayValue($arwrk);
                        } else {
                            $this->kec_id->ViewValue = $this->kec_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kec_id->ViewValue = null;
                }
            }

            // desa_id
            if ($this->desa_id->VirtualValue != "") {
                $this->desa_id->ViewValue = $this->desa_id->VirtualValue;
            } else {
                $curVal = strval($this->desa_id->CurrentValue);
                if ($curVal != "") {
                    $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
                    if ($this->desa_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->desa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->desa_id->Lookup->renderViewRow($rswrk[0]);
                            $this->desa_id->ViewValue = $this->desa_id->displayValue($arwrk);
                        } else {
                            $this->desa_id->ViewValue = $this->desa_id->CurrentValue;
                        }
                    }
                } else {
                    $this->desa_id->ViewValue = null;
                }
            }

            // blok_id
            if ($this->blok_id->VirtualValue != "") {
                $this->blok_id->ViewValue = $this->blok_id->VirtualValue;
            } else {
                $this->blok_id->ViewValue = $this->blok_id->CurrentValue;
                $curVal = strval($this->blok_id->CurrentValue);
                if ($curVal != "") {
                    $this->blok_id->ViewValue = $this->blok_id->lookupCacheOption($curVal);
                    if ($this->blok_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`blok_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->blok_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->blok_id->Lookup->renderViewRow($rswrk[0]);
                            $this->blok_id->ViewValue = $this->blok_id->displayValue($arwrk);
                        } else {
                            $this->blok_id->ViewValue = $this->blok_id->CurrentValue;
                        }
                    }
                } else {
                    $this->blok_id->ViewValue = null;
                }
            }

            // sos_id
            if ($this->sos_id->VirtualValue != "") {
                $this->sos_id->ViewValue = $this->sos_id->VirtualValue;
            } else {
                $curVal = strval($this->sos_id->CurrentValue);
                if ($curVal != "") {
                    $this->sos_id->ViewValue = $this->sos_id->lookupCacheOption($curVal);
                    if ($this->sos_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`sos_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->sos_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->sos_id->Lookup->renderViewRow($rswrk[0]);
                            $this->sos_id->ViewValue = $this->sos_id->displayValue($arwrk);
                        } else {
                            $this->sos_id->ViewValue = $this->sos_id->CurrentValue;
                        }
                    }
                } else {
                    $this->sos_id->ViewValue = null;
                }
            }

            // var_id
            $curVal = strval($this->var_id->CurrentValue);
            if ($curVal != "") {
                $this->var_id->ViewValue = $this->var_id->lookupCacheOption($curVal);
                if ($this->var_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->var_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->var_id->Lookup->renderViewRow($rswrk[0]);
                        $this->var_id->ViewValue = $this->var_id->displayValue($arwrk);
                    } else {
                        $this->var_id->ViewValue = $this->var_id->CurrentValue;
                    }
                }
            } else {
                $this->var_id->ViewValue = null;
            }

            // co_id
            $curVal = strval($this->co_id->CurrentValue);
            if ($curVal != "") {
                $this->co_id->ViewValue = $this->co_id->lookupCacheOption($curVal);
                if ($this->co_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->co_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->co_id->Lookup->renderViewRow($rswrk[0]);
                        $this->co_id->ViewValue = $this->co_id->displayValue($arwrk);
                    } else {
                        $this->co_id->ViewValue = $this->co_id->CurrentValue;
                    }
                }
            } else {
                $this->co_id->ViewValue = null;
            }

            // k_jumlah_bibit
            $this->k_jumlah_bibit->ViewValue = $this->k_jumlah_bibit->CurrentValue;

            // k_asal_bibit
            $this->k_asal_bibit->ViewValue = $this->k_asal_bibit->CurrentValue;

            // k_tgl_tanam
            $this->k_tgl_tanam->ViewValue = $this->k_tgl_tanam->CurrentValue;
            $this->k_tgl_tanam->ViewValue = FormatDateTime($this->k_tgl_tanam->ViewValue, $this->k_tgl_tanam->formatPattern());

            // k_es_tgl_panen
            $this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
            $this->k_es_tgl_panen->ViewValue = FormatDateTime($this->k_es_tgl_panen->ViewValue, $this->k_es_tgl_panen->formatPattern());

            // k_ak_tgl_datang
            $this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
            $this->k_ak_tgl_datang->ViewValue = FormatDateTime($this->k_ak_tgl_datang->ViewValue, $this->k_ak_tgl_datang->formatPattern());

            // k_es_qty
            $this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;

            // k_ak_qty
            $this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;

            // k_es_perhektar
            $this->k_es_perhektar->ViewValue = $this->k_es_perhektar->CurrentValue;

            // k_ak_perhektar
            $this->k_ak_perhektar->ViewValue = $this->k_ak_perhektar->CurrentValue;
            $this->k_ak_perhektar->ViewValue = FormatNumber($this->k_ak_perhektar->ViewValue, $this->k_ak_perhektar->formatPattern());

            // k_skor
            $this->k_skor->ViewValue = $this->k_skor->CurrentValue;
            $this->k_skor->ViewValue = FormatNumber($this->k_skor->ViewValue, $this->k_skor->formatPattern());

            // k_ket
            $this->k_ket->ViewValue = $this->k_ket->CurrentValue;

            // k_cat
            $this->k_cat->ViewValue = $this->k_cat->CurrentValue;

            // k_titik_koordinat
            $this->k_titik_koordinat->ViewValue = $this->k_titik_koordinat->CurrentValue;
            $this->k_titik_koordinat->CellCssStyle .= "text-align: left;";

            // k_foto_lahan
            $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
                $this->k_foto_lahan->ImageWidth = 40;
                $this->k_foto_lahan->ImageHeight = 30;
                $this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->alt();
                $this->k_foto_lahan->ImageCssClass = "ew-image";
                $this->k_foto_lahan->ViewValue = $this->k_foto_lahan->Upload->DbValue;
            } else {
                $this->k_foto_lahan->ViewValue = "";
            }
            $this->k_foto_lahan->CellCssStyle .= "text-align: left;";

            // k_dok
            $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->k_dok->Upload->DbValue)) {
                $this->k_dok->ImageWidth = 42;
                $this->k_dok->ImageHeight = 70;
                $this->k_dok->ImageAlt = $this->k_dok->alt();
                $this->k_dok->ImageCssClass = "ew-image";
                $this->k_dok->ViewValue = $this->k_dok->Upload->DbValue;
            } else {
                $this->k_dok->ViewValue = "";
            }

            // k_harga_bibit
            $this->k_harga_bibit->ViewValue = $this->k_harga_bibit->CurrentValue;

            // k_bayar_bibit
            $this->k_bayar_bibit->ViewValue = $this->k_bayar_bibit->CurrentValue;

            // k_pinjaman
            $this->k_pinjaman->ViewValue = $this->k_pinjaman->CurrentValue;

            // k_bayar_pinjaman
            $this->k_bayar_pinjaman->ViewValue = $this->k_bayar_pinjaman->CurrentValue;

            // k_sisa_hutang
            $this->k_sisa_hutang->ViewValue = $this->k_sisa_hutang->CurrentValue;

            // k_id_kontrak
            $this->k_id_kontrak->HrefValue = "";
            $this->k_id_kontrak->TooltipValue = "";

            // k_luas_lahan
            $this->k_luas_lahan->HrefValue = "";
            $this->k_luas_lahan->TooltipValue = "";

            // pet_id
            if (!EmptyValue($this->pet_id->CurrentValue)) {
                $this->pet_id->HrefValue = $this->pet_id->getLinkPrefix() . $this->pet_id->CurrentValue; // Add prefix/suffix
                $this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->pet_id->HrefValue = FullUrl($this->pet_id->HrefValue, "href");
                }
            } else {
                $this->pet_id->HrefValue = "";
            }
            $this->pet_id->TooltipValue = "";

            // koord_id
            if (!EmptyValue($this->koord_id->CurrentValue)) {
                $this->koord_id->HrefValue = $this->koord_id->getLinkPrefix() . $this->koord_id->CurrentValue; // Add prefix/suffix
                $this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->koord_id->HrefValue = FullUrl($this->koord_id->HrefValue, "href");
                }
            } else {
                $this->koord_id->HrefValue = "";
            }
            $this->koord_id->TooltipValue = "";

            // kk_id
            if (!EmptyValue($this->kk_id->CurrentValue)) {
                $this->kk_id->HrefValue = $this->kk_id->getLinkPrefix() . $this->kk_id->CurrentValue; // Add prefix/suffix
                $this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->kk_id->HrefValue = FullUrl($this->kk_id->HrefValue, "href");
                }
            } else {
                $this->kk_id->HrefValue = "";
            }
            $this->kk_id->TooltipValue = "";

            // prov_id
            $this->prov_id->HrefValue = "";
            $this->prov_id->TooltipValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";
            $this->kab_id->TooltipValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";
            $this->kec_id->TooltipValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";
            $this->desa_id->TooltipValue = "";

            // blok_id
            $this->blok_id->HrefValue = "";
            $this->blok_id->TooltipValue = "";

            // sos_id
            $this->sos_id->HrefValue = "";
            $this->sos_id->TooltipValue = "";

            // var_id
            if (!EmptyValue($this->var_id->CurrentValue)) {
                $this->var_id->HrefValue = $this->var_id->getLinkPrefix() . $this->var_id->CurrentValue; // Add prefix/suffix
                $this->var_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->var_id->HrefValue = FullUrl($this->var_id->HrefValue, "href");
                }
            } else {
                $this->var_id->HrefValue = "";
            }
            $this->var_id->TooltipValue = "";

            // co_id
            if (!EmptyValue($this->co_id->CurrentValue)) {
                $this->co_id->HrefValue = $this->co_id->getLinkPrefix() . $this->co_id->CurrentValue; // Add prefix/suffix
                $this->co_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->co_id->HrefValue = FullUrl($this->co_id->HrefValue, "href");
                }
            } else {
                $this->co_id->HrefValue = "";
            }
            $this->co_id->TooltipValue = "";

            // k_jumlah_bibit
            $this->k_jumlah_bibit->HrefValue = "";
            $this->k_jumlah_bibit->TooltipValue = "";

            // k_asal_bibit
            $this->k_asal_bibit->HrefValue = "";
            $this->k_asal_bibit->TooltipValue = "";

            // k_tgl_tanam
            $this->k_tgl_tanam->HrefValue = "";
            $this->k_tgl_tanam->TooltipValue = "";

            // k_es_tgl_panen
            $this->k_es_tgl_panen->HrefValue = "";
            $this->k_es_tgl_panen->TooltipValue = "";

            // k_ak_tgl_datang
            $this->k_ak_tgl_datang->HrefValue = "";
            $this->k_ak_tgl_datang->TooltipValue = "";

            // k_es_qty
            $this->k_es_qty->HrefValue = "";
            $this->k_es_qty->TooltipValue = "";

            // k_ak_qty
            $this->k_ak_qty->HrefValue = "";
            $this->k_ak_qty->TooltipValue = "";

            // k_es_perhektar
            $this->k_es_perhektar->HrefValue = "";
            $this->k_es_perhektar->TooltipValue = "";

            // k_ak_perhektar
            $this->k_ak_perhektar->HrefValue = "";
            $this->k_ak_perhektar->TooltipValue = "";

            // k_skor
            $this->k_skor->HrefValue = "";
            $this->k_skor->TooltipValue = "";

            // k_ket
            $this->k_ket->HrefValue = "";
            $this->k_ket->TooltipValue = "";

            // k_cat
            $this->k_cat->HrefValue = "";
            $this->k_cat->TooltipValue = "";

            // k_titik_koordinat
            if (!EmptyValue($this->k_titik_koordinat->CurrentValue)) {
                $this->k_titik_koordinat->HrefValue = (!empty($this->k_titik_koordinat->ViewValue) && !is_array($this->k_titik_koordinat->ViewValue) ? RemoveHtml($this->k_titik_koordinat->ViewValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
                $this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_titik_koordinat->HrefValue = FullUrl($this->k_titik_koordinat->HrefValue, "href");
                }
            } else {
                $this->k_titik_koordinat->HrefValue = "";
            }
            $this->k_titik_koordinat->TooltipValue = "";

            // k_foto_lahan
            $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
                $this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
                $this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_foto_lahan->HrefValue = FullUrl($this->k_foto_lahan->HrefValue, "href");
                }
            } else {
                $this->k_foto_lahan->HrefValue = "";
            }
            $this->k_foto_lahan->ExportHrefValue = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;
            $this->k_foto_lahan->TooltipValue = "";
            if ($this->k_foto_lahan->UseColorbox) {
                if (EmptyValue($this->k_foto_lahan->TooltipValue)) {
                    $this->k_foto_lahan->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->k_foto_lahan->LinkAttrs["data-rel"] = "kontrak_x_k_foto_lahan";
                $this->k_foto_lahan->LinkAttrs->appendClass("ew-lightbox");
            }

            // k_dok
            $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->k_dok->Upload->DbValue)) {
                $this->k_dok->HrefValue = "%u"; // Add prefix/suffix
                $this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_dok->HrefValue = FullUrl($this->k_dok->HrefValue, "href");
                }
            } else {
                $this->k_dok->HrefValue = "";
            }
            $this->k_dok->ExportHrefValue = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;
            $this->k_dok->TooltipValue = "";
            if ($this->k_dok->UseColorbox) {
                if (EmptyValue($this->k_dok->TooltipValue)) {
                    $this->k_dok->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->k_dok->LinkAttrs["data-rel"] = "kontrak_x_k_dok";
                $this->k_dok->LinkAttrs->appendClass("ew-lightbox");
            }

            // k_harga_bibit
            $this->k_harga_bibit->HrefValue = "";
            $this->k_harga_bibit->TooltipValue = "";

            // k_bayar_bibit
            $this->k_bayar_bibit->HrefValue = "";
            $this->k_bayar_bibit->TooltipValue = "";

            // k_pinjaman
            $this->k_pinjaman->HrefValue = "";
            $this->k_pinjaman->TooltipValue = "";

            // k_bayar_pinjaman
            $this->k_bayar_pinjaman->HrefValue = "";
            $this->k_bayar_pinjaman->TooltipValue = "";

            // k_sisa_hutang
            $this->k_sisa_hutang->HrefValue = "";
            $this->k_sisa_hutang->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(true);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
            $exportUrl .= "?" . Config("API_KEY_NAME") . "=" . $this->getKey(true);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fkontrakview\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fkontrakview\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fkontrakview\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fkontrakview" data-ew-action="email" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-key="' . HtmlEncode(ArrayToJsonAttribute($this->RecKey)) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = false;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = true;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide options for export
        if ($this->isExport()) {
            $this->ExportOptions->hideAllOptions();
        }

        // Hide options if json response
        if (IsJsonResponse()) {
            $this->ExportOptions->hideAllOptions();
        }
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc, $keys)
    {
        global $Language;
        $utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");

        // Load recordset
        $rs = null;
        if (count($keys) >= 1) {
            $this->k_id->OldValue = $keys[0];
            $rsview = $this->loadRs($this->getRecordFilter());
            if ($rsview) {
                $rs = new Recordset($rsview);
            }
        }
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "view");

        // Export detail records (penggunaan_pestisida)
        if (Config("EXPORT_DETAIL_RECORDS") && in_array("penggunaan_pestisida", explode(",", $this->getCurrentDetailTable()))) {
            $penggunaan_pestisida = new PenggunaanPestisidaList();
            $rsdetail = $penggunaan_pestisida->loadRs($penggunaan_pestisida->getDetailFilterFromSession(), $penggunaan_pestisida->getSessionOrderBy()); // Load detail records
            if ($rsdetail) {
                $exportStyle = $doc->Style;
                $doc->setStyle("h"); // Change to horizontal
                if (!$this->isExport("csv") || Config("EXPORT_DETAIL_RECORDS_FOR_CSV")) {
                    $doc->exportEmptyRow();
                    $detailcnt = $rsdetail->rowCount();
                    $oldtbl = $doc->getTable();
                    $doc->setTable($penggunaan_pestisida);
                    $penggunaan_pestisida->exportDocument($doc, new Recordset($rsdetail), 1, $detailcnt);
                    $doc->setTable($oldtbl);
                }
                $doc->setStyle($exportStyle); // Restore
            }
        }

        // Close recordset
        $rs->close();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("penggunaan_pestisida", $detailTblVar)) {
                $detailPageObj = Container("PenggunaanPestisidaGrid");
                if ($detailPageObj->DetailView) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "view";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->ID_Kontrak->IsDetailKey = true;
                    $detailPageObj->ID_Kontrak->CurrentValue = $this->k_id->CurrentValue;
                    $detailPageObj->ID_Kontrak->setSessionValue($detailPageObj->ID_Kontrak->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("KontrakList"), "", $this->TableVar, true);
        $pageId = "view";
        $Breadcrumb->add("view", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_pet_id":
                    break;
                case "x_koord_id":
                    break;
                case "x_kk_id":
                    break;
                case "x_prov_id":
                    break;
                case "x_kab_id":
                    break;
                case "x_kec_id":
                    break;
                case "x_desa_id":
                    break;
                case "x_blok_id":
                    break;
                case "x_sos_id":
                    break;
                case "x_var_id":
                    break;
                case "x_co_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }
}
