<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class KontrakList extends Kontrak
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "KontrakList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fkontraklist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "KontrakList";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->k_id->Visible = false;
        $this->k_id_kontrak->setVisibility();
        $this->k_id_lama->Visible = false;
        $this->k_no_kontrak->Visible = false;
        $this->k_luas_lahan->setVisibility();
        $this->pet_id->setVisibility();
        $this->koord_id->setVisibility();
        $this->kk_id->setVisibility();
        $this->prov_id->setVisibility();
        $this->kab_id->setVisibility();
        $this->kec_id->setVisibility();
        $this->desa_id->setVisibility();
        $this->blok_id->setVisibility();
        $this->sos_id->setVisibility();
        $this->var_id->setVisibility();
        $this->co_id->setVisibility();
        $this->k_jumlah_bibit->setVisibility();
        $this->k_asal_bibit->setVisibility();
        $this->k_tgl_tanam->setVisibility();
        $this->k_es_tgl_panen->setVisibility();
        $this->k_ak_tgl_datang->setVisibility();
        $this->k_es_qty->setVisibility();
        $this->k_ak_qty->setVisibility();
        $this->k_es_perhektar->setVisibility();
        $this->k_ak_perhektar->setVisibility();
        $this->k_skor->setVisibility();
        $this->k_ket->setVisibility();
        $this->k_cat->setVisibility();
        $this->k_titik_koordinat->setVisibility();
        $this->k_foto_lahan->setVisibility();
        $this->k_dok->setVisibility();
        $this->k_harga_bibit->setVisibility();
        $this->k_bayar_bibit->setVisibility();
        $this->k_pinjaman->setVisibility();
        $this->k_bayar_pinjaman->setVisibility();
        $this->k_sisa_hutang->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'kontrak';
        $this->TableName = 'kontrak';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (kontrak)
        if (!isset($GLOBALS["kontrak"]) || get_class($GLOBALS["kontrak"]) == PROJECT_NAMESPACE . "kontrak") {
            $GLOBALS["kontrak"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "KontrakAdd?" . Config("TABLE_SHOW_DETAIL") . "=";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "KontrakDelete";
        $this->MultiUpdateUrl = "KontrakUpdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'kontrak');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(["Tag" => "td", "TableVar" => $this->TableVar]);

        // Export options
        $this->ExportOptions = new ListOptions(["TagClassName" => "ew-export-option"]);

        // Import options
        $this->ImportOptions = new ListOptions(["TagClassName" => "ew-import-option"]);

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions([
            "TagClassName" => "ew-add-edit-option",
            "UseDropDownButton" => false,
            "DropDownButtonPhrase" => $Language->phrase("ButtonAddEdit"),
            "UseButtonGroup" => true
        ]);

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(["TagClassName" => "ew-detail-option"]);
        // Actions
        $this->OtherOptions["action"] = new ListOptions(["TagClassName" => "ew-action-option"]);

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions([
            "TableVar" => $this->TableVar,
            "TagClassName" => "ew-column-option",
            "ButtonGroupClass" => "ew-column-dropdown",
            "UseDropDownButton" => true,
            "DropDownButtonPhrase" => $Language->phrase("Columns"),
            "DropDownAutoClose" => "outside",
            "UseButtonGroup" => false
        ]);

        // Filter options
        $this->FilterOptions = new ListOptions(["TagClassName" => "ew-filter-option"]);

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "KontrakView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $this->k_foto_lahan->OldUploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
                $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->OldUploadPath;
                $this->k_dok->OldUploadPath = $this->k_dok->getUploadPath(); // PHP
                $this->k_dok->UploadPath = $this->k_dok->OldUploadPath;
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['k_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->k_id->Visible = false;
        }
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 100;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $RowCount = 0;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load recordset from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load recordset
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new NumericPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport = $DashboardReport || ConvertToBool(Param(Config("PAGE_DASHBOARD"), false));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up custom action (compatible with old version)
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions->add($name, $action);
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->pet_id);
        $this->setupLookupOptions($this->koord_id);
        $this->setupLookupOptions($this->kk_id);
        $this->setupLookupOptions($this->prov_id);
        $this->setupLookupOptions($this->kab_id);
        $this->setupLookupOptions($this->kec_id);
        $this->setupLookupOptions($this->desa_id);
        $this->setupLookupOptions($this->blok_id);
        $this->setupLookupOptions($this->sos_id);
        $this->setupLookupOptions($this->var_id);
        $this->setupLookupOptions($this->co_id);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fkontrakgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $filter = ""; // Filter
        $query = ""; // Query builder

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 100; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        $filter = "";
        if (!$Security->canList()) {
            $filter = "(0=1)"; // Filter all records
        }
        AddFilter($filter, $this->DbDetailFilter);
        AddFilter($filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $filter;
        } else {
            $this->setSessionWhere($filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Allow) {
                if ($listaction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listaction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset->close();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new NumericPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 100; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";
        $filterList = Concat($filterList, $this->k_id->AdvancedSearch->toJson(), ","); // Field k_id
        $filterList = Concat($filterList, $this->k_id_kontrak->AdvancedSearch->toJson(), ","); // Field k_id_kontrak
        $filterList = Concat($filterList, $this->k_luas_lahan->AdvancedSearch->toJson(), ","); // Field k_luas_lahan
        $filterList = Concat($filterList, $this->pet_id->AdvancedSearch->toJson(), ","); // Field pet_id
        $filterList = Concat($filterList, $this->koord_id->AdvancedSearch->toJson(), ","); // Field koord_id
        $filterList = Concat($filterList, $this->kk_id->AdvancedSearch->toJson(), ","); // Field kk_id
        $filterList = Concat($filterList, $this->prov_id->AdvancedSearch->toJson(), ","); // Field prov_id
        $filterList = Concat($filterList, $this->kab_id->AdvancedSearch->toJson(), ","); // Field kab_id
        $filterList = Concat($filterList, $this->kec_id->AdvancedSearch->toJson(), ","); // Field kec_id
        $filterList = Concat($filterList, $this->desa_id->AdvancedSearch->toJson(), ","); // Field desa_id
        $filterList = Concat($filterList, $this->blok_id->AdvancedSearch->toJson(), ","); // Field blok_id
        $filterList = Concat($filterList, $this->sos_id->AdvancedSearch->toJson(), ","); // Field sos_id
        $filterList = Concat($filterList, $this->var_id->AdvancedSearch->toJson(), ","); // Field var_id
        $filterList = Concat($filterList, $this->co_id->AdvancedSearch->toJson(), ","); // Field co_id
        $filterList = Concat($filterList, $this->k_jumlah_bibit->AdvancedSearch->toJson(), ","); // Field k_jumlah_bibit
        $filterList = Concat($filterList, $this->k_asal_bibit->AdvancedSearch->toJson(), ","); // Field k_asal_bibit
        $filterList = Concat($filterList, $this->k_tgl_tanam->AdvancedSearch->toJson(), ","); // Field k_tgl_tanam
        $filterList = Concat($filterList, $this->k_es_tgl_panen->AdvancedSearch->toJson(), ","); // Field k_es_tgl_panen
        $filterList = Concat($filterList, $this->k_ak_tgl_datang->AdvancedSearch->toJson(), ","); // Field k_ak_tgl_datang
        $filterList = Concat($filterList, $this->k_es_qty->AdvancedSearch->toJson(), ","); // Field k_es_qty
        $filterList = Concat($filterList, $this->k_ak_qty->AdvancedSearch->toJson(), ","); // Field k_ak_qty
        $filterList = Concat($filterList, $this->k_es_perhektar->AdvancedSearch->toJson(), ","); // Field k_es_perhektar
        $filterList = Concat($filterList, $this->k_ak_perhektar->AdvancedSearch->toJson(), ","); // Field k_ak_perhektar
        $filterList = Concat($filterList, $this->k_skor->AdvancedSearch->toJson(), ","); // Field k_skor
        $filterList = Concat($filterList, $this->k_ket->AdvancedSearch->toJson(), ","); // Field k_ket
        $filterList = Concat($filterList, $this->k_cat->AdvancedSearch->toJson(), ","); // Field k_cat
        $filterList = Concat($filterList, $this->k_titik_koordinat->AdvancedSearch->toJson(), ","); // Field k_titik_koordinat
        $filterList = Concat($filterList, $this->k_foto_lahan->AdvancedSearch->toJson(), ","); // Field k_foto_lahan
        $filterList = Concat($filterList, $this->k_dok->AdvancedSearch->toJson(), ","); // Field k_dok
        $filterList = Concat($filterList, $this->k_harga_bibit->AdvancedSearch->toJson(), ","); // Field k_harga_bibit
        $filterList = Concat($filterList, $this->k_bayar_bibit->AdvancedSearch->toJson(), ","); // Field k_bayar_bibit
        $filterList = Concat($filterList, $this->k_pinjaman->AdvancedSearch->toJson(), ","); // Field k_pinjaman
        $filterList = Concat($filterList, $this->k_bayar_pinjaman->AdvancedSearch->toJson(), ","); // Field k_bayar_pinjaman
        $filterList = Concat($filterList, $this->k_sisa_hutang->AdvancedSearch->toJson(), ","); // Field k_sisa_hutang
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fkontraksrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field k_id
        $this->k_id->AdvancedSearch->SearchValue = @$filter["x_k_id"];
        $this->k_id->AdvancedSearch->SearchOperator = @$filter["z_k_id"];
        $this->k_id->AdvancedSearch->SearchCondition = @$filter["v_k_id"];
        $this->k_id->AdvancedSearch->SearchValue2 = @$filter["y_k_id"];
        $this->k_id->AdvancedSearch->SearchOperator2 = @$filter["w_k_id"];
        $this->k_id->AdvancedSearch->save();

        // Field k_id_kontrak
        $this->k_id_kontrak->AdvancedSearch->SearchValue = @$filter["x_k_id_kontrak"];
        $this->k_id_kontrak->AdvancedSearch->SearchOperator = @$filter["z_k_id_kontrak"];
        $this->k_id_kontrak->AdvancedSearch->SearchCondition = @$filter["v_k_id_kontrak"];
        $this->k_id_kontrak->AdvancedSearch->SearchValue2 = @$filter["y_k_id_kontrak"];
        $this->k_id_kontrak->AdvancedSearch->SearchOperator2 = @$filter["w_k_id_kontrak"];
        $this->k_id_kontrak->AdvancedSearch->save();

        // Field k_luas_lahan
        $this->k_luas_lahan->AdvancedSearch->SearchValue = @$filter["x_k_luas_lahan"];
        $this->k_luas_lahan->AdvancedSearch->SearchOperator = @$filter["z_k_luas_lahan"];
        $this->k_luas_lahan->AdvancedSearch->SearchCondition = @$filter["v_k_luas_lahan"];
        $this->k_luas_lahan->AdvancedSearch->SearchValue2 = @$filter["y_k_luas_lahan"];
        $this->k_luas_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_k_luas_lahan"];
        $this->k_luas_lahan->AdvancedSearch->save();

        // Field pet_id
        $this->pet_id->AdvancedSearch->SearchValue = @$filter["x_pet_id"];
        $this->pet_id->AdvancedSearch->SearchOperator = @$filter["z_pet_id"];
        $this->pet_id->AdvancedSearch->SearchCondition = @$filter["v_pet_id"];
        $this->pet_id->AdvancedSearch->SearchValue2 = @$filter["y_pet_id"];
        $this->pet_id->AdvancedSearch->SearchOperator2 = @$filter["w_pet_id"];
        $this->pet_id->AdvancedSearch->save();

        // Field koord_id
        $this->koord_id->AdvancedSearch->SearchValue = @$filter["x_koord_id"];
        $this->koord_id->AdvancedSearch->SearchOperator = @$filter["z_koord_id"];
        $this->koord_id->AdvancedSearch->SearchCondition = @$filter["v_koord_id"];
        $this->koord_id->AdvancedSearch->SearchValue2 = @$filter["y_koord_id"];
        $this->koord_id->AdvancedSearch->SearchOperator2 = @$filter["w_koord_id"];
        $this->koord_id->AdvancedSearch->save();

        // Field kk_id
        $this->kk_id->AdvancedSearch->SearchValue = @$filter["x_kk_id"];
        $this->kk_id->AdvancedSearch->SearchOperator = @$filter["z_kk_id"];
        $this->kk_id->AdvancedSearch->SearchCondition = @$filter["v_kk_id"];
        $this->kk_id->AdvancedSearch->SearchValue2 = @$filter["y_kk_id"];
        $this->kk_id->AdvancedSearch->SearchOperator2 = @$filter["w_kk_id"];
        $this->kk_id->AdvancedSearch->save();

        // Field prov_id
        $this->prov_id->AdvancedSearch->SearchValue = @$filter["x_prov_id"];
        $this->prov_id->AdvancedSearch->SearchOperator = @$filter["z_prov_id"];
        $this->prov_id->AdvancedSearch->SearchCondition = @$filter["v_prov_id"];
        $this->prov_id->AdvancedSearch->SearchValue2 = @$filter["y_prov_id"];
        $this->prov_id->AdvancedSearch->SearchOperator2 = @$filter["w_prov_id"];
        $this->prov_id->AdvancedSearch->save();

        // Field kab_id
        $this->kab_id->AdvancedSearch->SearchValue = @$filter["x_kab_id"];
        $this->kab_id->AdvancedSearch->SearchOperator = @$filter["z_kab_id"];
        $this->kab_id->AdvancedSearch->SearchCondition = @$filter["v_kab_id"];
        $this->kab_id->AdvancedSearch->SearchValue2 = @$filter["y_kab_id"];
        $this->kab_id->AdvancedSearch->SearchOperator2 = @$filter["w_kab_id"];
        $this->kab_id->AdvancedSearch->save();

        // Field kec_id
        $this->kec_id->AdvancedSearch->SearchValue = @$filter["x_kec_id"];
        $this->kec_id->AdvancedSearch->SearchOperator = @$filter["z_kec_id"];
        $this->kec_id->AdvancedSearch->SearchCondition = @$filter["v_kec_id"];
        $this->kec_id->AdvancedSearch->SearchValue2 = @$filter["y_kec_id"];
        $this->kec_id->AdvancedSearch->SearchOperator2 = @$filter["w_kec_id"];
        $this->kec_id->AdvancedSearch->save();

        // Field desa_id
        $this->desa_id->AdvancedSearch->SearchValue = @$filter["x_desa_id"];
        $this->desa_id->AdvancedSearch->SearchOperator = @$filter["z_desa_id"];
        $this->desa_id->AdvancedSearch->SearchCondition = @$filter["v_desa_id"];
        $this->desa_id->AdvancedSearch->SearchValue2 = @$filter["y_desa_id"];
        $this->desa_id->AdvancedSearch->SearchOperator2 = @$filter["w_desa_id"];
        $this->desa_id->AdvancedSearch->save();

        // Field blok_id
        $this->blok_id->AdvancedSearch->SearchValue = @$filter["x_blok_id"];
        $this->blok_id->AdvancedSearch->SearchOperator = @$filter["z_blok_id"];
        $this->blok_id->AdvancedSearch->SearchCondition = @$filter["v_blok_id"];
        $this->blok_id->AdvancedSearch->SearchValue2 = @$filter["y_blok_id"];
        $this->blok_id->AdvancedSearch->SearchOperator2 = @$filter["w_blok_id"];
        $this->blok_id->AdvancedSearch->save();

        // Field sos_id
        $this->sos_id->AdvancedSearch->SearchValue = @$filter["x_sos_id"];
        $this->sos_id->AdvancedSearch->SearchOperator = @$filter["z_sos_id"];
        $this->sos_id->AdvancedSearch->SearchCondition = @$filter["v_sos_id"];
        $this->sos_id->AdvancedSearch->SearchValue2 = @$filter["y_sos_id"];
        $this->sos_id->AdvancedSearch->SearchOperator2 = @$filter["w_sos_id"];
        $this->sos_id->AdvancedSearch->save();

        // Field var_id
        $this->var_id->AdvancedSearch->SearchValue = @$filter["x_var_id"];
        $this->var_id->AdvancedSearch->SearchOperator = @$filter["z_var_id"];
        $this->var_id->AdvancedSearch->SearchCondition = @$filter["v_var_id"];
        $this->var_id->AdvancedSearch->SearchValue2 = @$filter["y_var_id"];
        $this->var_id->AdvancedSearch->SearchOperator2 = @$filter["w_var_id"];
        $this->var_id->AdvancedSearch->save();

        // Field co_id
        $this->co_id->AdvancedSearch->SearchValue = @$filter["x_co_id"];
        $this->co_id->AdvancedSearch->SearchOperator = @$filter["z_co_id"];
        $this->co_id->AdvancedSearch->SearchCondition = @$filter["v_co_id"];
        $this->co_id->AdvancedSearch->SearchValue2 = @$filter["y_co_id"];
        $this->co_id->AdvancedSearch->SearchOperator2 = @$filter["w_co_id"];
        $this->co_id->AdvancedSearch->save();

        // Field k_jumlah_bibit
        $this->k_jumlah_bibit->AdvancedSearch->SearchValue = @$filter["x_k_jumlah_bibit"];
        $this->k_jumlah_bibit->AdvancedSearch->SearchOperator = @$filter["z_k_jumlah_bibit"];
        $this->k_jumlah_bibit->AdvancedSearch->SearchCondition = @$filter["v_k_jumlah_bibit"];
        $this->k_jumlah_bibit->AdvancedSearch->SearchValue2 = @$filter["y_k_jumlah_bibit"];
        $this->k_jumlah_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_k_jumlah_bibit"];
        $this->k_jumlah_bibit->AdvancedSearch->save();

        // Field k_asal_bibit
        $this->k_asal_bibit->AdvancedSearch->SearchValue = @$filter["x_k_asal_bibit"];
        $this->k_asal_bibit->AdvancedSearch->SearchOperator = @$filter["z_k_asal_bibit"];
        $this->k_asal_bibit->AdvancedSearch->SearchCondition = @$filter["v_k_asal_bibit"];
        $this->k_asal_bibit->AdvancedSearch->SearchValue2 = @$filter["y_k_asal_bibit"];
        $this->k_asal_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_k_asal_bibit"];
        $this->k_asal_bibit->AdvancedSearch->save();

        // Field k_tgl_tanam
        $this->k_tgl_tanam->AdvancedSearch->SearchValue = @$filter["x_k_tgl_tanam"];
        $this->k_tgl_tanam->AdvancedSearch->SearchOperator = @$filter["z_k_tgl_tanam"];
        $this->k_tgl_tanam->AdvancedSearch->SearchCondition = @$filter["v_k_tgl_tanam"];
        $this->k_tgl_tanam->AdvancedSearch->SearchValue2 = @$filter["y_k_tgl_tanam"];
        $this->k_tgl_tanam->AdvancedSearch->SearchOperator2 = @$filter["w_k_tgl_tanam"];
        $this->k_tgl_tanam->AdvancedSearch->save();

        // Field k_es_tgl_panen
        $this->k_es_tgl_panen->AdvancedSearch->SearchValue = @$filter["x_k_es_tgl_panen"];
        $this->k_es_tgl_panen->AdvancedSearch->SearchOperator = @$filter["z_k_es_tgl_panen"];
        $this->k_es_tgl_panen->AdvancedSearch->SearchCondition = @$filter["v_k_es_tgl_panen"];
        $this->k_es_tgl_panen->AdvancedSearch->SearchValue2 = @$filter["y_k_es_tgl_panen"];
        $this->k_es_tgl_panen->AdvancedSearch->SearchOperator2 = @$filter["w_k_es_tgl_panen"];
        $this->k_es_tgl_panen->AdvancedSearch->save();

        // Field k_ak_tgl_datang
        $this->k_ak_tgl_datang->AdvancedSearch->SearchValue = @$filter["x_k_ak_tgl_datang"];
        $this->k_ak_tgl_datang->AdvancedSearch->SearchOperator = @$filter["z_k_ak_tgl_datang"];
        $this->k_ak_tgl_datang->AdvancedSearch->SearchCondition = @$filter["v_k_ak_tgl_datang"];
        $this->k_ak_tgl_datang->AdvancedSearch->SearchValue2 = @$filter["y_k_ak_tgl_datang"];
        $this->k_ak_tgl_datang->AdvancedSearch->SearchOperator2 = @$filter["w_k_ak_tgl_datang"];
        $this->k_ak_tgl_datang->AdvancedSearch->save();

        // Field k_es_qty
        $this->k_es_qty->AdvancedSearch->SearchValue = @$filter["x_k_es_qty"];
        $this->k_es_qty->AdvancedSearch->SearchOperator = @$filter["z_k_es_qty"];
        $this->k_es_qty->AdvancedSearch->SearchCondition = @$filter["v_k_es_qty"];
        $this->k_es_qty->AdvancedSearch->SearchValue2 = @$filter["y_k_es_qty"];
        $this->k_es_qty->AdvancedSearch->SearchOperator2 = @$filter["w_k_es_qty"];
        $this->k_es_qty->AdvancedSearch->save();

        // Field k_ak_qty
        $this->k_ak_qty->AdvancedSearch->SearchValue = @$filter["x_k_ak_qty"];
        $this->k_ak_qty->AdvancedSearch->SearchOperator = @$filter["z_k_ak_qty"];
        $this->k_ak_qty->AdvancedSearch->SearchCondition = @$filter["v_k_ak_qty"];
        $this->k_ak_qty->AdvancedSearch->SearchValue2 = @$filter["y_k_ak_qty"];
        $this->k_ak_qty->AdvancedSearch->SearchOperator2 = @$filter["w_k_ak_qty"];
        $this->k_ak_qty->AdvancedSearch->save();

        // Field k_es_perhektar
        $this->k_es_perhektar->AdvancedSearch->SearchValue = @$filter["x_k_es_perhektar"];
        $this->k_es_perhektar->AdvancedSearch->SearchOperator = @$filter["z_k_es_perhektar"];
        $this->k_es_perhektar->AdvancedSearch->SearchCondition = @$filter["v_k_es_perhektar"];
        $this->k_es_perhektar->AdvancedSearch->SearchValue2 = @$filter["y_k_es_perhektar"];
        $this->k_es_perhektar->AdvancedSearch->SearchOperator2 = @$filter["w_k_es_perhektar"];
        $this->k_es_perhektar->AdvancedSearch->save();

        // Field k_ak_perhektar
        $this->k_ak_perhektar->AdvancedSearch->SearchValue = @$filter["x_k_ak_perhektar"];
        $this->k_ak_perhektar->AdvancedSearch->SearchOperator = @$filter["z_k_ak_perhektar"];
        $this->k_ak_perhektar->AdvancedSearch->SearchCondition = @$filter["v_k_ak_perhektar"];
        $this->k_ak_perhektar->AdvancedSearch->SearchValue2 = @$filter["y_k_ak_perhektar"];
        $this->k_ak_perhektar->AdvancedSearch->SearchOperator2 = @$filter["w_k_ak_perhektar"];
        $this->k_ak_perhektar->AdvancedSearch->save();

        // Field k_skor
        $this->k_skor->AdvancedSearch->SearchValue = @$filter["x_k_skor"];
        $this->k_skor->AdvancedSearch->SearchOperator = @$filter["z_k_skor"];
        $this->k_skor->AdvancedSearch->SearchCondition = @$filter["v_k_skor"];
        $this->k_skor->AdvancedSearch->SearchValue2 = @$filter["y_k_skor"];
        $this->k_skor->AdvancedSearch->SearchOperator2 = @$filter["w_k_skor"];
        $this->k_skor->AdvancedSearch->save();

        // Field k_ket
        $this->k_ket->AdvancedSearch->SearchValue = @$filter["x_k_ket"];
        $this->k_ket->AdvancedSearch->SearchOperator = @$filter["z_k_ket"];
        $this->k_ket->AdvancedSearch->SearchCondition = @$filter["v_k_ket"];
        $this->k_ket->AdvancedSearch->SearchValue2 = @$filter["y_k_ket"];
        $this->k_ket->AdvancedSearch->SearchOperator2 = @$filter["w_k_ket"];
        $this->k_ket->AdvancedSearch->save();

        // Field k_cat
        $this->k_cat->AdvancedSearch->SearchValue = @$filter["x_k_cat"];
        $this->k_cat->AdvancedSearch->SearchOperator = @$filter["z_k_cat"];
        $this->k_cat->AdvancedSearch->SearchCondition = @$filter["v_k_cat"];
        $this->k_cat->AdvancedSearch->SearchValue2 = @$filter["y_k_cat"];
        $this->k_cat->AdvancedSearch->SearchOperator2 = @$filter["w_k_cat"];
        $this->k_cat->AdvancedSearch->save();

        // Field k_titik_koordinat
        $this->k_titik_koordinat->AdvancedSearch->SearchValue = @$filter["x_k_titik_koordinat"];
        $this->k_titik_koordinat->AdvancedSearch->SearchOperator = @$filter["z_k_titik_koordinat"];
        $this->k_titik_koordinat->AdvancedSearch->SearchCondition = @$filter["v_k_titik_koordinat"];
        $this->k_titik_koordinat->AdvancedSearch->SearchValue2 = @$filter["y_k_titik_koordinat"];
        $this->k_titik_koordinat->AdvancedSearch->SearchOperator2 = @$filter["w_k_titik_koordinat"];
        $this->k_titik_koordinat->AdvancedSearch->save();

        // Field k_foto_lahan
        $this->k_foto_lahan->AdvancedSearch->SearchValue = @$filter["x_k_foto_lahan"];
        $this->k_foto_lahan->AdvancedSearch->SearchOperator = @$filter["z_k_foto_lahan"];
        $this->k_foto_lahan->AdvancedSearch->SearchCondition = @$filter["v_k_foto_lahan"];
        $this->k_foto_lahan->AdvancedSearch->SearchValue2 = @$filter["y_k_foto_lahan"];
        $this->k_foto_lahan->AdvancedSearch->SearchOperator2 = @$filter["w_k_foto_lahan"];
        $this->k_foto_lahan->AdvancedSearch->save();

        // Field k_dok
        $this->k_dok->AdvancedSearch->SearchValue = @$filter["x_k_dok"];
        $this->k_dok->AdvancedSearch->SearchOperator = @$filter["z_k_dok"];
        $this->k_dok->AdvancedSearch->SearchCondition = @$filter["v_k_dok"];
        $this->k_dok->AdvancedSearch->SearchValue2 = @$filter["y_k_dok"];
        $this->k_dok->AdvancedSearch->SearchOperator2 = @$filter["w_k_dok"];
        $this->k_dok->AdvancedSearch->save();

        // Field k_harga_bibit
        $this->k_harga_bibit->AdvancedSearch->SearchValue = @$filter["x_k_harga_bibit"];
        $this->k_harga_bibit->AdvancedSearch->SearchOperator = @$filter["z_k_harga_bibit"];
        $this->k_harga_bibit->AdvancedSearch->SearchCondition = @$filter["v_k_harga_bibit"];
        $this->k_harga_bibit->AdvancedSearch->SearchValue2 = @$filter["y_k_harga_bibit"];
        $this->k_harga_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_k_harga_bibit"];
        $this->k_harga_bibit->AdvancedSearch->save();

        // Field k_bayar_bibit
        $this->k_bayar_bibit->AdvancedSearch->SearchValue = @$filter["x_k_bayar_bibit"];
        $this->k_bayar_bibit->AdvancedSearch->SearchOperator = @$filter["z_k_bayar_bibit"];
        $this->k_bayar_bibit->AdvancedSearch->SearchCondition = @$filter["v_k_bayar_bibit"];
        $this->k_bayar_bibit->AdvancedSearch->SearchValue2 = @$filter["y_k_bayar_bibit"];
        $this->k_bayar_bibit->AdvancedSearch->SearchOperator2 = @$filter["w_k_bayar_bibit"];
        $this->k_bayar_bibit->AdvancedSearch->save();

        // Field k_pinjaman
        $this->k_pinjaman->AdvancedSearch->SearchValue = @$filter["x_k_pinjaman"];
        $this->k_pinjaman->AdvancedSearch->SearchOperator = @$filter["z_k_pinjaman"];
        $this->k_pinjaman->AdvancedSearch->SearchCondition = @$filter["v_k_pinjaman"];
        $this->k_pinjaman->AdvancedSearch->SearchValue2 = @$filter["y_k_pinjaman"];
        $this->k_pinjaman->AdvancedSearch->SearchOperator2 = @$filter["w_k_pinjaman"];
        $this->k_pinjaman->AdvancedSearch->save();

        // Field k_bayar_pinjaman
        $this->k_bayar_pinjaman->AdvancedSearch->SearchValue = @$filter["x_k_bayar_pinjaman"];
        $this->k_bayar_pinjaman->AdvancedSearch->SearchOperator = @$filter["z_k_bayar_pinjaman"];
        $this->k_bayar_pinjaman->AdvancedSearch->SearchCondition = @$filter["v_k_bayar_pinjaman"];
        $this->k_bayar_pinjaman->AdvancedSearch->SearchValue2 = @$filter["y_k_bayar_pinjaman"];
        $this->k_bayar_pinjaman->AdvancedSearch->SearchOperator2 = @$filter["w_k_bayar_pinjaman"];
        $this->k_bayar_pinjaman->AdvancedSearch->save();

        // Field k_sisa_hutang
        $this->k_sisa_hutang->AdvancedSearch->SearchValue = @$filter["x_k_sisa_hutang"];
        $this->k_sisa_hutang->AdvancedSearch->SearchOperator = @$filter["z_k_sisa_hutang"];
        $this->k_sisa_hutang->AdvancedSearch->SearchCondition = @$filter["v_k_sisa_hutang"];
        $this->k_sisa_hutang->AdvancedSearch->SearchValue2 = @$filter["y_k_sisa_hutang"];
        $this->k_sisa_hutang->AdvancedSearch->SearchOperator2 = @$filter["w_k_sisa_hutang"];
        $this->k_sisa_hutang->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->k_id, $default, false); // k_id
        $this->buildSearchSql($where, $this->k_id_kontrak, $default, false); // k_id_kontrak
        $this->buildSearchSql($where, $this->k_luas_lahan, $default, false); // k_luas_lahan
        $this->buildSearchSql($where, $this->pet_id, $default, false); // pet_id
        $this->buildSearchSql($where, $this->koord_id, $default, false); // koord_id
        $this->buildSearchSql($where, $this->kk_id, $default, false); // kk_id
        $this->buildSearchSql($where, $this->prov_id, $default, false); // prov_id
        $this->buildSearchSql($where, $this->kab_id, $default, false); // kab_id
        $this->buildSearchSql($where, $this->kec_id, $default, false); // kec_id
        $this->buildSearchSql($where, $this->desa_id, $default, false); // desa_id
        $this->buildSearchSql($where, $this->blok_id, $default, false); // blok_id
        $this->buildSearchSql($where, $this->sos_id, $default, false); // sos_id
        $this->buildSearchSql($where, $this->var_id, $default, false); // var_id
        $this->buildSearchSql($where, $this->co_id, $default, false); // co_id
        $this->buildSearchSql($where, $this->k_jumlah_bibit, $default, false); // k_jumlah_bibit
        $this->buildSearchSql($where, $this->k_asal_bibit, $default, false); // k_asal_bibit
        $this->buildSearchSql($where, $this->k_tgl_tanam, $default, false); // k_tgl_tanam
        $this->buildSearchSql($where, $this->k_es_tgl_panen, $default, false); // k_es_tgl_panen
        $this->buildSearchSql($where, $this->k_ak_tgl_datang, $default, false); // k_ak_tgl_datang
        $this->buildSearchSql($where, $this->k_es_qty, $default, false); // k_es_qty
        $this->buildSearchSql($where, $this->k_ak_qty, $default, false); // k_ak_qty
        $this->buildSearchSql($where, $this->k_es_perhektar, $default, false); // k_es_perhektar
        $this->buildSearchSql($where, $this->k_ak_perhektar, $default, false); // k_ak_perhektar
        $this->buildSearchSql($where, $this->k_skor, $default, false); // k_skor
        $this->buildSearchSql($where, $this->k_ket, $default, false); // k_ket
        $this->buildSearchSql($where, $this->k_cat, $default, false); // k_cat
        $this->buildSearchSql($where, $this->k_titik_koordinat, $default, false); // k_titik_koordinat
        $this->buildSearchSql($where, $this->k_foto_lahan, $default, false); // k_foto_lahan
        $this->buildSearchSql($where, $this->k_dok, $default, false); // k_dok
        $this->buildSearchSql($where, $this->k_harga_bibit, $default, false); // k_harga_bibit
        $this->buildSearchSql($where, $this->k_bayar_bibit, $default, false); // k_bayar_bibit
        $this->buildSearchSql($where, $this->k_pinjaman, $default, false); // k_pinjaman
        $this->buildSearchSql($where, $this->k_bayar_pinjaman, $default, false); // k_bayar_pinjaman
        $this->buildSearchSql($where, $this->k_sisa_hutang, $default, false); // k_sisa_hutang

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->k_id->AdvancedSearch->save(); // k_id
            $this->k_id_kontrak->AdvancedSearch->save(); // k_id_kontrak
            $this->k_luas_lahan->AdvancedSearch->save(); // k_luas_lahan
            $this->pet_id->AdvancedSearch->save(); // pet_id
            $this->koord_id->AdvancedSearch->save(); // koord_id
            $this->kk_id->AdvancedSearch->save(); // kk_id
            $this->prov_id->AdvancedSearch->save(); // prov_id
            $this->kab_id->AdvancedSearch->save(); // kab_id
            $this->kec_id->AdvancedSearch->save(); // kec_id
            $this->desa_id->AdvancedSearch->save(); // desa_id
            $this->blok_id->AdvancedSearch->save(); // blok_id
            $this->sos_id->AdvancedSearch->save(); // sos_id
            $this->var_id->AdvancedSearch->save(); // var_id
            $this->co_id->AdvancedSearch->save(); // co_id
            $this->k_jumlah_bibit->AdvancedSearch->save(); // k_jumlah_bibit
            $this->k_asal_bibit->AdvancedSearch->save(); // k_asal_bibit
            $this->k_tgl_tanam->AdvancedSearch->save(); // k_tgl_tanam
            $this->k_es_tgl_panen->AdvancedSearch->save(); // k_es_tgl_panen
            $this->k_ak_tgl_datang->AdvancedSearch->save(); // k_ak_tgl_datang
            $this->k_es_qty->AdvancedSearch->save(); // k_es_qty
            $this->k_ak_qty->AdvancedSearch->save(); // k_ak_qty
            $this->k_es_perhektar->AdvancedSearch->save(); // k_es_perhektar
            $this->k_ak_perhektar->AdvancedSearch->save(); // k_ak_perhektar
            $this->k_skor->AdvancedSearch->save(); // k_skor
            $this->k_ket->AdvancedSearch->save(); // k_ket
            $this->k_cat->AdvancedSearch->save(); // k_cat
            $this->k_titik_koordinat->AdvancedSearch->save(); // k_titik_koordinat
            $this->k_foto_lahan->AdvancedSearch->save(); // k_foto_lahan
            $this->k_dok->AdvancedSearch->save(); // k_dok
            $this->k_harga_bibit->AdvancedSearch->save(); // k_harga_bibit
            $this->k_bayar_bibit->AdvancedSearch->save(); // k_bayar_bibit
            $this->k_pinjaman->AdvancedSearch->save(); // k_pinjaman
            $this->k_bayar_pinjaman->AdvancedSearch->save(); // k_bayar_pinjaman
            $this->k_sisa_hutang->AdvancedSearch->save(); // k_sisa_hutang

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Parse query builder rule function
    protected function parseRules($group, $fieldName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $parts[] = "(" . " " . $this->parseRules($rule, $fieldName) . " " . ")" . " ";
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                if (!$fld) {
                    throw new \Exception("Failed to find field '" . $field . "'");
                }
                if ($fieldName == "" || $fld->Name == $fieldName) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && ($rule["value"] ?? false) || IsNullOrEmptyOperator($fldOpr)) {
                        $rule["value"] = !is_array($rule["value"]) ? [$rule["value"]] : $rule["value"];
                        $fldVal = $rule["value"][0];
                        if (is_array($fldVal)) {
                            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld->isMultiSelect()) {
                                $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                            } else {
                                $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                if (is_array($fldVal2)) {
                                    $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                }
                                $parts[] = GetSearchSql(
                                    $fld,
                                    ConvertSearchValue($fldVal, $fldOpr, $fld), // $fldVal
                                    $fldOpr,
                                    "", // $fldCond not used
                                    ConvertSearchValue($fldVal2, $fldOpr, $fld), // $fldVal2
                                    "", // $fldOpr2 not used
                                    $this->Dbid
                                );
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = implode(" " . $group["condition"] . " ", array_filter($parts));
        if ($group["not"] ?? false) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = Post("rules") ?? $this->getSessionRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field k_id_kontrak
        $filter = $this->queryBuilderWhere("k_id_kontrak");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_id_kontrak, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_id_kontrak->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_luas_lahan
        $filter = $this->queryBuilderWhere("k_luas_lahan");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_luas_lahan, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_luas_lahan->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field pet_id
        $filter = $this->queryBuilderWhere("pet_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->pet_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->pet_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field koord_id
        $filter = $this->queryBuilderWhere("koord_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->koord_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->koord_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field kk_id
        $filter = $this->queryBuilderWhere("kk_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->kk_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->kk_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field prov_id
        $filter = $this->queryBuilderWhere("prov_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->prov_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->prov_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field kab_id
        $filter = $this->queryBuilderWhere("kab_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->kab_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->kab_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field kec_id
        $filter = $this->queryBuilderWhere("kec_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->kec_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->kec_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field desa_id
        $filter = $this->queryBuilderWhere("desa_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->desa_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->desa_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field blok_id
        $filter = $this->queryBuilderWhere("blok_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->blok_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->blok_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field sos_id
        $filter = $this->queryBuilderWhere("sos_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->sos_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->sos_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field var_id
        $filter = $this->queryBuilderWhere("var_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->var_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->var_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field co_id
        $filter = $this->queryBuilderWhere("co_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->co_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->co_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_jumlah_bibit
        $filter = $this->queryBuilderWhere("k_jumlah_bibit");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_jumlah_bibit, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_jumlah_bibit->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_asal_bibit
        $filter = $this->queryBuilderWhere("k_asal_bibit");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_asal_bibit, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_asal_bibit->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_tgl_tanam
        $filter = $this->queryBuilderWhere("k_tgl_tanam");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_tgl_tanam, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_tgl_tanam->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_es_tgl_panen
        $filter = $this->queryBuilderWhere("k_es_tgl_panen");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_es_tgl_panen, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_es_tgl_panen->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_ak_tgl_datang
        $filter = $this->queryBuilderWhere("k_ak_tgl_datang");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_ak_tgl_datang, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_ak_tgl_datang->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_es_qty
        $filter = $this->queryBuilderWhere("k_es_qty");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_es_qty, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_es_qty->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_ak_qty
        $filter = $this->queryBuilderWhere("k_ak_qty");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_ak_qty, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_ak_qty->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_es_perhektar
        $filter = $this->queryBuilderWhere("k_es_perhektar");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_es_perhektar, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_es_perhektar->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_ak_perhektar
        $filter = $this->queryBuilderWhere("k_ak_perhektar");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_ak_perhektar, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_ak_perhektar->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_skor
        $filter = $this->queryBuilderWhere("k_skor");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_skor, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_skor->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_ket
        $filter = $this->queryBuilderWhere("k_ket");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_ket, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_ket->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_cat
        $filter = $this->queryBuilderWhere("k_cat");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_cat, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_cat->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_titik_koordinat
        $filter = $this->queryBuilderWhere("k_titik_koordinat");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_titik_koordinat, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_titik_koordinat->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_foto_lahan
        $filter = $this->queryBuilderWhere("k_foto_lahan");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_foto_lahan, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_foto_lahan->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_dok
        $filter = $this->queryBuilderWhere("k_dok");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_dok, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_dok->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_harga_bibit
        $filter = $this->queryBuilderWhere("k_harga_bibit");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_harga_bibit, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_harga_bibit->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_bayar_bibit
        $filter = $this->queryBuilderWhere("k_bayar_bibit");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_bayar_bibit, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_bayar_bibit->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_pinjaman
        $filter = $this->queryBuilderWhere("k_pinjaman");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_pinjaman, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_pinjaman->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_bayar_pinjaman
        $filter = $this->queryBuilderWhere("k_bayar_pinjaman");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_bayar_pinjaman, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_bayar_pinjaman->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field k_sisa_hutang
        $filter = $this->queryBuilderWhere("k_sisa_hutang");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->k_sisa_hutang, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->k_sisa_hutang->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->k_id_kontrak;
        $searchFlds[] = &$this->k_luas_lahan;
        $searchFlds[] = &$this->pet_id;
        $searchFlds[] = &$this->koord_id;
        $searchFlds[] = &$this->kk_id;
        $searchFlds[] = &$this->prov_id;
        $searchFlds[] = &$this->kab_id;
        $searchFlds[] = &$this->kec_id;
        $searchFlds[] = &$this->desa_id;
        $searchFlds[] = &$this->blok_id;
        $searchFlds[] = &$this->var_id;
        $searchFlds[] = &$this->co_id;
        $searchFlds[] = &$this->k_jumlah_bibit;
        $searchFlds[] = &$this->k_asal_bibit;
        $searchFlds[] = &$this->k_tgl_tanam;
        $searchFlds[] = &$this->k_es_tgl_panen;
        $searchFlds[] = &$this->k_ak_tgl_datang;
        $searchFlds[] = &$this->k_es_qty;
        $searchFlds[] = &$this->k_ak_qty;
        $searchFlds[] = &$this->k_es_perhektar;
        $searchFlds[] = &$this->k_ak_perhektar;
        $searchFlds[] = &$this->k_skor;
        $searchFlds[] = &$this->k_ket;
        $searchFlds[] = &$this->k_cat;
        $searchFlds[] = &$this->k_titik_koordinat;
        $searchFlds[] = &$this->k_foto_lahan;
        $searchFlds[] = &$this->k_dok;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->k_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_id_kontrak->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_luas_lahan->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->pet_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->koord_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->kk_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->prov_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->kab_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->kec_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->desa_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->blok_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->sos_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->var_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->co_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_jumlah_bibit->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_asal_bibit->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_tgl_tanam->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_es_tgl_panen->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_ak_tgl_datang->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_es_qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_ak_qty->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_es_perhektar->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_ak_perhektar->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_skor->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_ket->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_cat->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_titik_koordinat->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_foto_lahan->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_dok->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_harga_bibit->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_bayar_bibit->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_pinjaman->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_bayar_pinjaman->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->k_sisa_hutang->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->k_id->AdvancedSearch->unsetSession();
        $this->k_id_kontrak->AdvancedSearch->unsetSession();
        $this->k_luas_lahan->AdvancedSearch->unsetSession();
        $this->pet_id->AdvancedSearch->unsetSession();
        $this->koord_id->AdvancedSearch->unsetSession();
        $this->kk_id->AdvancedSearch->unsetSession();
        $this->prov_id->AdvancedSearch->unsetSession();
        $this->kab_id->AdvancedSearch->unsetSession();
        $this->kec_id->AdvancedSearch->unsetSession();
        $this->desa_id->AdvancedSearch->unsetSession();
        $this->blok_id->AdvancedSearch->unsetSession();
        $this->sos_id->AdvancedSearch->unsetSession();
        $this->var_id->AdvancedSearch->unsetSession();
        $this->co_id->AdvancedSearch->unsetSession();
        $this->k_jumlah_bibit->AdvancedSearch->unsetSession();
        $this->k_asal_bibit->AdvancedSearch->unsetSession();
        $this->k_tgl_tanam->AdvancedSearch->unsetSession();
        $this->k_es_tgl_panen->AdvancedSearch->unsetSession();
        $this->k_ak_tgl_datang->AdvancedSearch->unsetSession();
        $this->k_es_qty->AdvancedSearch->unsetSession();
        $this->k_ak_qty->AdvancedSearch->unsetSession();
        $this->k_es_perhektar->AdvancedSearch->unsetSession();
        $this->k_ak_perhektar->AdvancedSearch->unsetSession();
        $this->k_skor->AdvancedSearch->unsetSession();
        $this->k_ket->AdvancedSearch->unsetSession();
        $this->k_cat->AdvancedSearch->unsetSession();
        $this->k_titik_koordinat->AdvancedSearch->unsetSession();
        $this->k_foto_lahan->AdvancedSearch->unsetSession();
        $this->k_dok->AdvancedSearch->unsetSession();
        $this->k_harga_bibit->AdvancedSearch->unsetSession();
        $this->k_bayar_bibit->AdvancedSearch->unsetSession();
        $this->k_pinjaman->AdvancedSearch->unsetSession();
        $this->k_bayar_pinjaman->AdvancedSearch->unsetSession();
        $this->k_sisa_hutang->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->k_id->AdvancedSearch->load();
        $this->k_id_kontrak->AdvancedSearch->load();
        $this->k_luas_lahan->AdvancedSearch->load();
        $this->pet_id->AdvancedSearch->load();
        $this->koord_id->AdvancedSearch->load();
        $this->kk_id->AdvancedSearch->load();
        $this->prov_id->AdvancedSearch->load();
        $this->kab_id->AdvancedSearch->load();
        $this->kec_id->AdvancedSearch->load();
        $this->desa_id->AdvancedSearch->load();
        $this->blok_id->AdvancedSearch->load();
        $this->sos_id->AdvancedSearch->load();
        $this->var_id->AdvancedSearch->load();
        $this->co_id->AdvancedSearch->load();
        $this->k_jumlah_bibit->AdvancedSearch->load();
        $this->k_asal_bibit->AdvancedSearch->load();
        $this->k_tgl_tanam->AdvancedSearch->load();
        $this->k_es_tgl_panen->AdvancedSearch->load();
        $this->k_ak_tgl_datang->AdvancedSearch->load();
        $this->k_es_qty->AdvancedSearch->load();
        $this->k_ak_qty->AdvancedSearch->load();
        $this->k_es_perhektar->AdvancedSearch->load();
        $this->k_ak_perhektar->AdvancedSearch->load();
        $this->k_skor->AdvancedSearch->load();
        $this->k_ket->AdvancedSearch->load();
        $this->k_cat->AdvancedSearch->load();
        $this->k_titik_koordinat->AdvancedSearch->load();
        $this->k_foto_lahan->AdvancedSearch->load();
        $this->k_dok->AdvancedSearch->load();
        $this->k_harga_bibit->AdvancedSearch->load();
        $this->k_bayar_bibit->AdvancedSearch->load();
        $this->k_pinjaman->AdvancedSearch->load();
        $this->k_bayar_pinjaman->AdvancedSearch->load();
        $this->k_sisa_hutang->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->k_id_kontrak->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
            $defaultSortList = ($this->k_id_kontrak->VirtualExpression != "" ? $this->k_id_kontrak->VirtualExpression : $this->k_id_kontrak->Expression) . " DESC"; // Set up default sort
            if ($this->getSessionOrderByList() == "" && $defaultSortList != "") {
                $this->setSessionOrderByList($defaultSortList);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->k_id_kontrak); // k_id_kontrak
            $this->updateSort($this->k_luas_lahan); // k_luas_lahan
            $this->updateSort($this->pet_id); // pet_id
            $this->updateSort($this->koord_id); // koord_id
            $this->updateSort($this->kk_id); // kk_id
            $this->updateSort($this->prov_id); // prov_id
            $this->updateSort($this->kab_id); // kab_id
            $this->updateSort($this->kec_id); // kec_id
            $this->updateSort($this->desa_id); // desa_id
            $this->updateSort($this->blok_id); // blok_id
            $this->updateSort($this->sos_id); // sos_id
            $this->updateSort($this->var_id); // var_id
            $this->updateSort($this->co_id); // co_id
            $this->updateSort($this->k_jumlah_bibit); // k_jumlah_bibit
            $this->updateSort($this->k_asal_bibit); // k_asal_bibit
            $this->updateSort($this->k_tgl_tanam); // k_tgl_tanam
            $this->updateSort($this->k_es_tgl_panen); // k_es_tgl_panen
            $this->updateSort($this->k_ak_tgl_datang); // k_ak_tgl_datang
            $this->updateSort($this->k_es_qty); // k_es_qty
            $this->updateSort($this->k_ak_qty); // k_ak_qty
            $this->updateSort($this->k_es_perhektar); // k_es_perhektar
            $this->updateSort($this->k_ak_perhektar); // k_ak_perhektar
            $this->updateSort($this->k_skor); // k_skor
            $this->updateSort($this->k_ket); // k_ket
            $this->updateSort($this->k_cat); // k_cat
            $this->updateSort($this->k_titik_koordinat); // k_titik_koordinat
            $this->updateSort($this->k_foto_lahan); // k_foto_lahan
            $this->updateSort($this->k_dok); // k_dok
            $this->updateSort($this->k_harga_bibit); // k_harga_bibit
            $this->updateSort($this->k_bayar_bibit); // k_bayar_bibit
            $this->updateSort($this->k_pinjaman); // k_pinjaman
            $this->updateSort($this->k_bayar_pinjaman); // k_bayar_pinjaman
            $this->updateSort($this->k_sisa_hutang); // k_sisa_hutang
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->setSessionOrderByList($orderBy);
                $this->k_id->setSort("");
                $this->k_id_kontrak->setSort("");
                $this->k_id_lama->setSort("");
                $this->k_no_kontrak->setSort("");
                $this->k_luas_lahan->setSort("");
                $this->pet_id->setSort("");
                $this->koord_id->setSort("");
                $this->kk_id->setSort("");
                $this->prov_id->setSort("");
                $this->kab_id->setSort("");
                $this->kec_id->setSort("");
                $this->desa_id->setSort("");
                $this->blok_id->setSort("");
                $this->sos_id->setSort("");
                $this->var_id->setSort("");
                $this->co_id->setSort("");
                $this->k_jumlah_bibit->setSort("");
                $this->k_asal_bibit->setSort("");
                $this->k_tgl_tanam->setSort("");
                $this->k_es_tgl_panen->setSort("");
                $this->k_ak_tgl_datang->setSort("");
                $this->k_es_qty->setSort("");
                $this->k_ak_qty->setSort("");
                $this->k_es_perhektar->setSort("");
                $this->k_ak_perhektar->setSort("");
                $this->k_skor->setSort("");
                $this->k_ket->setSort("");
                $this->k_cat->setSort("");
                $this->k_titik_koordinat->setSort("");
                $this->k_foto_lahan->setSort("");
                $this->k_dok->setSort("");
                $this->k_harga_bibit->setSort("");
                $this->k_bayar_bibit->setSort("");
                $this->k_pinjaman->setSort("");
                $this->k_bayar_pinjaman->setSort("");
                $this->k_sisa_hutang->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "detail_penggunaan_pestisida"
        $item = &$this->ListOptions->add("detail_penggunaan_pestisida");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'penggunaan_pestisida');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$this->ListOptions->add("details");
            $item->CssClass = "text-nowrap";
            $item->Visible = $this->ShowMultipleDetails && $this->ListOptions->detailVisible();
            $item->OnLeft = true;
            $item->ShowInButtonGroup = false;
            $this->ListOptions->hideDetailItems();
        }

        // Set up detail pages
        $pages = new SubPages();
        $pages->add("penggunaan_pestisida");
        $this->DetailPages = $pages;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = false;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
            // Set up list options (to be implemented by extensions)
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm, $UserProfile;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"kontrak\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"kontrak\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"kontrak\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions->Items as $listaction) {
                $action = $listaction->Action;
                $allowed = $listaction->Allow;
                if ($listaction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
                    $link = "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . HtmlTitle($caption) . "\" data-ew-action=\"submit\" form=\"fkontraklist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listaction->toDataAttrs() . ">" . $icon . " " . $listaction->Caption . "</button></li>";
                    if ($link != "") {
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" data-ew-action=\"submit\" form=\"fkontraklist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listaction->toDataAttrs() . ">" . $icon . " " . $listaction->Caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_penggunaan_pestisida"
        $opt = $this->ListOptions["detail_penggunaan_pestisida"];
        if ($Security->allowList(CurrentProjectID() . 'penggunaan_pestisida')) {
            $body = $Language->phrase("DetailLink") . $Language->TablePhrase("penggunaan_pestisida", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("PenggunaanPestisidaList?" . Config("TABLE_SHOW_MASTER") . "=kontrak&" . GetForeignKeyUrl("fk_k_id", $this->k_id->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("PenggunaanPestisidaGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'kontrak')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=penggunaan_pestisida");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "penggunaan_pestisida";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'kontrak')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=penggunaan_pestisida");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "penggunaan_pestisida";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'kontrak')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=penggunaan_pestisida");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "penggunaan_pestisida";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode($this->GetCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-dropdown-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $opt = $this->ListOptions["details"];
            $opt->Body = $body;
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->k_id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"kontrak\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["detail"];
        $detailTableLink = "";
                $item = &$option->add("detailadd_penggunaan_pestisida");
                $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=penggunaan_pestisida");
                $detailPage = Container("PenggunaanPestisidaGrid");
                $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
                $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
                $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'kontrak') && $Security->canAdd());
                if ($item->Visible) {
                    if ($detailTableLink != "") {
                        $detailTableLink .= ",";
                    }
                    $detailTableLink .= "penggunaan_pestisida";
                }

        // Add multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$option->add("detailsadd");
            $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailTableLink);
            $caption = $Language->phrase("AddMasterDetailLink");
            $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
            $item->Visible = $detailTableLink != "" && $Security->canAdd();
            // Hide single master/detail items
            $ar = explode(",", $detailTableLink);
            $cnt = count($ar);
            for ($i = 0; $i < $cnt; $i++) {
                if ($item = $option["detailadd_" . $ar[$i]]) {
                    $item->Visible = false;
                }
            }
        }
        $option = $options["action"];

        // Add multi delete
        $item = &$option->add("multidelete");
        $item->Body = "<button type=\"button\" class=\"ew-action ew-multi-delete\" title=\"" .
            HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" data-caption=\"" .
            HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" form=\"fkontraklist\"" .
            " data-ew-action=\"" . ($this->UseAjaxActions ? "inline" : "submit") . "\"" .
            ($this->UseAjaxActions ? " data-action=\"delete\"" : "") .
            " data-url=\"" . GetUrl($this->MultiDeleteUrl) . "\"" .
            ($this->InlineDelete ? " data-msg=\"" . HtmlEncode($Language->phrase("DeleteConfirm")) . "\" data-data='{\"action\":\"delete\"}'" : " data-data='{\"action\":\"show\"}'") .
            ">" . $Language->phrase("DeleteSelectedLink") . "</button>";
        $item->Visible = $Security->canDelete();

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $option->add("k_id_kontrak", $this->createColumnOption("k_id_kontrak"));
            $option->add("k_luas_lahan", $this->createColumnOption("k_luas_lahan"));
            $option->add("pet_id", $this->createColumnOption("pet_id"));
            $option->add("koord_id", $this->createColumnOption("koord_id"));
            $option->add("kk_id", $this->createColumnOption("kk_id"));
            $option->add("prov_id", $this->createColumnOption("prov_id"));
            $option->add("kab_id", $this->createColumnOption("kab_id"));
            $option->add("kec_id", $this->createColumnOption("kec_id"));
            $option->add("desa_id", $this->createColumnOption("desa_id"));
            $option->add("blok_id", $this->createColumnOption("blok_id"));
            $option->add("sos_id", $this->createColumnOption("sos_id"));
            $option->add("var_id", $this->createColumnOption("var_id"));
            $option->add("co_id", $this->createColumnOption("co_id"));
            $option->add("k_jumlah_bibit", $this->createColumnOption("k_jumlah_bibit"));
            $option->add("k_asal_bibit", $this->createColumnOption("k_asal_bibit"));
            $option->add("k_tgl_tanam", $this->createColumnOption("k_tgl_tanam"));
            $option->add("k_es_tgl_panen", $this->createColumnOption("k_es_tgl_panen"));
            $option->add("k_ak_tgl_datang", $this->createColumnOption("k_ak_tgl_datang"));
            $option->add("k_es_qty", $this->createColumnOption("k_es_qty"));
            $option->add("k_ak_qty", $this->createColumnOption("k_ak_qty"));
            $option->add("k_es_perhektar", $this->createColumnOption("k_es_perhektar"));
            $option->add("k_ak_perhektar", $this->createColumnOption("k_ak_perhektar"));
            $option->add("k_skor", $this->createColumnOption("k_skor"));
            $option->add("k_ket", $this->createColumnOption("k_ket"));
            $option->add("k_cat", $this->createColumnOption("k_cat"));
            $option->add("k_titik_koordinat", $this->createColumnOption("k_titik_koordinat"));
            $option->add("k_foto_lahan", $this->createColumnOption("k_foto_lahan"));
            $option->add("k_dok", $this->createColumnOption("k_dok"));
            $option->add("k_harga_bibit", $this->createColumnOption("k_harga_bibit"));
            $option->add("k_bayar_bibit", $this->createColumnOption("k_bayar_bibit"));
            $option->add("k_pinjaman", $this->createColumnOption("k_pinjaman"));
            $option->add("k_bayar_pinjaman", $this->createColumnOption("k_bayar_pinjaman"));
            $option->add("k_sisa_hutang", $this->createColumnOption("k_sisa_hutang"));
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = false;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fkontraksrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fkontraksrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Create new column option
    public function createColumnOption($name)
    {
        $field = $this->Fields[$name] ?? false;
        if ($field && $field->Visible) {
            $item = new ListOption($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
            return $item;
        }
        return null;
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listaction->Action);
                $caption = $listaction->Caption;
                $icon = ($listaction->Icon != "") ? '<i class="' . HtmlEncode($listaction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fkontraklist"' . $listaction->toDataAttrs() . '>' . $icon . '</button>';
                $item->Visible = $listaction->Allow;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $userlist = "";
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            if (array_key_exists($userAction, $this->ListActions->Items)) {
                $this->UserAction = $userAction;
                $actionCaption = $this->ListActions[$userAction]->Caption;
                if (!$this->ListActions[$userAction]->Allow) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            }
            $this->CurrentFilter = $filter;
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rows = ExecuteRows($sql, $conn);
            $count = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($count > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedCount = $count;
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        $conn->commit();
                    }
                    if ($this->getSuccessMessage() == "" && !ob_get_length() && !$Response->getBody()->getSize()) { // No output
                        $this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        $conn->rollback();
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if ($this->getSuccessMessage() != "") {
                    echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                    $this->clearSuccessMessage(); // Clear message
                }
                if ($this->getFailureMessage() != "") {
                    echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                    $this->clearFailureMessage(); // Clear message
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->Recordset && !$this->Recordset->EOF) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = ROWTYPE_AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_kontrak", "data-rowtype" => ROWTYPE_ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = ROWTYPE_ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->Recordset); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = ROWTYPE_VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = ROWTYPE_ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == ROWTYPE_ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == ROWTYPE_EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_kontrak",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == ROWTYPE_ADD || $this->isEdit() && $this->RowType == ROWTYPE_EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // k_id
        if ($this->k_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_id->AdvancedSearch->SearchValue != "" || $this->k_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_id_kontrak
        if ($this->k_id_kontrak->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_id_kontrak->AdvancedSearch->SearchValue != "" || $this->k_id_kontrak->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_luas_lahan
        if ($this->k_luas_lahan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_luas_lahan->AdvancedSearch->SearchValue != "" || $this->k_luas_lahan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // pet_id
        if ($this->pet_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->pet_id->AdvancedSearch->SearchValue != "" || $this->pet_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // koord_id
        if ($this->koord_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->koord_id->AdvancedSearch->SearchValue != "" || $this->koord_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // kk_id
        if ($this->kk_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->kk_id->AdvancedSearch->SearchValue != "" || $this->kk_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // prov_id
        if ($this->prov_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->prov_id->AdvancedSearch->SearchValue != "" || $this->prov_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // kab_id
        if ($this->kab_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->kab_id->AdvancedSearch->SearchValue != "" || $this->kab_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // kec_id
        if ($this->kec_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->kec_id->AdvancedSearch->SearchValue != "" || $this->kec_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // desa_id
        if ($this->desa_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->desa_id->AdvancedSearch->SearchValue != "" || $this->desa_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // blok_id
        if ($this->blok_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->blok_id->AdvancedSearch->SearchValue != "" || $this->blok_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // sos_id
        if ($this->sos_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->sos_id->AdvancedSearch->SearchValue != "" || $this->sos_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // var_id
        if ($this->var_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->var_id->AdvancedSearch->SearchValue != "" || $this->var_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // co_id
        if ($this->co_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->co_id->AdvancedSearch->SearchValue != "" || $this->co_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_jumlah_bibit
        if ($this->k_jumlah_bibit->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_jumlah_bibit->AdvancedSearch->SearchValue != "" || $this->k_jumlah_bibit->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_asal_bibit
        if ($this->k_asal_bibit->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_asal_bibit->AdvancedSearch->SearchValue != "" || $this->k_asal_bibit->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_tgl_tanam
        if ($this->k_tgl_tanam->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_tgl_tanam->AdvancedSearch->SearchValue != "" || $this->k_tgl_tanam->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_es_tgl_panen
        if ($this->k_es_tgl_panen->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_es_tgl_panen->AdvancedSearch->SearchValue != "" || $this->k_es_tgl_panen->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_ak_tgl_datang
        if ($this->k_ak_tgl_datang->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_ak_tgl_datang->AdvancedSearch->SearchValue != "" || $this->k_ak_tgl_datang->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_es_qty
        if ($this->k_es_qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_es_qty->AdvancedSearch->SearchValue != "" || $this->k_es_qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_ak_qty
        if ($this->k_ak_qty->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_ak_qty->AdvancedSearch->SearchValue != "" || $this->k_ak_qty->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_es_perhektar
        if ($this->k_es_perhektar->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_es_perhektar->AdvancedSearch->SearchValue != "" || $this->k_es_perhektar->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_ak_perhektar
        if ($this->k_ak_perhektar->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_ak_perhektar->AdvancedSearch->SearchValue != "" || $this->k_ak_perhektar->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_skor
        if ($this->k_skor->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_skor->AdvancedSearch->SearchValue != "" || $this->k_skor->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_ket
        if ($this->k_ket->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_ket->AdvancedSearch->SearchValue != "" || $this->k_ket->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_cat
        if ($this->k_cat->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_cat->AdvancedSearch->SearchValue != "" || $this->k_cat->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_titik_koordinat
        if ($this->k_titik_koordinat->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_titik_koordinat->AdvancedSearch->SearchValue != "" || $this->k_titik_koordinat->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_foto_lahan
        if ($this->k_foto_lahan->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_foto_lahan->AdvancedSearch->SearchValue != "" || $this->k_foto_lahan->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_dok
        if ($this->k_dok->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_dok->AdvancedSearch->SearchValue != "" || $this->k_dok->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_harga_bibit
        if ($this->k_harga_bibit->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_harga_bibit->AdvancedSearch->SearchValue != "" || $this->k_harga_bibit->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_bayar_bibit
        if ($this->k_bayar_bibit->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_bayar_bibit->AdvancedSearch->SearchValue != "" || $this->k_bayar_bibit->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_pinjaman
        if ($this->k_pinjaman->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_pinjaman->AdvancedSearch->SearchValue != "" || $this->k_pinjaman->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_bayar_pinjaman
        if ($this->k_bayar_pinjaman->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_bayar_pinjaman->AdvancedSearch->SearchValue != "" || $this->k_bayar_pinjaman->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // k_sisa_hutang
        if ($this->k_sisa_hutang->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->k_sisa_hutang->AdvancedSearch->SearchValue != "" || $this->k_sisa_hutang->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        $rs = new Recordset($result, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    // Load records as associative array
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->execute();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->k_id->setDbValue($row['k_id']);
        $this->k_id_kontrak->setDbValue($row['k_id_kontrak']);
        $this->k_id_lama->setDbValue($row['k_id_lama']);
        $this->k_no_kontrak->setDbValue($row['k_no_kontrak']);
        $this->k_luas_lahan->setDbValue($row['k_luas_lahan']);
        $this->pet_id->setDbValue($row['pet_id']);
        if (array_key_exists('EV__pet_id', $row)) {
            $this->pet_id->VirtualValue = $row['EV__pet_id']; // Set up virtual field value
        } else {
            $this->pet_id->VirtualValue = ""; // Clear value
        }
        $this->koord_id->setDbValue($row['koord_id']);
        if (array_key_exists('EV__koord_id', $row)) {
            $this->koord_id->VirtualValue = $row['EV__koord_id']; // Set up virtual field value
        } else {
            $this->koord_id->VirtualValue = ""; // Clear value
        }
        $this->kk_id->setDbValue($row['kk_id']);
        $this->prov_id->setDbValue($row['prov_id']);
        if (array_key_exists('EV__prov_id', $row)) {
            $this->prov_id->VirtualValue = $row['EV__prov_id']; // Set up virtual field value
        } else {
            $this->prov_id->VirtualValue = ""; // Clear value
        }
        $this->kab_id->setDbValue($row['kab_id']);
        if (array_key_exists('EV__kab_id', $row)) {
            $this->kab_id->VirtualValue = $row['EV__kab_id']; // Set up virtual field value
        } else {
            $this->kab_id->VirtualValue = ""; // Clear value
        }
        $this->kec_id->setDbValue($row['kec_id']);
        if (array_key_exists('EV__kec_id', $row)) {
            $this->kec_id->VirtualValue = $row['EV__kec_id']; // Set up virtual field value
        } else {
            $this->kec_id->VirtualValue = ""; // Clear value
        }
        $this->desa_id->setDbValue($row['desa_id']);
        if (array_key_exists('EV__desa_id', $row)) {
            $this->desa_id->VirtualValue = $row['EV__desa_id']; // Set up virtual field value
        } else {
            $this->desa_id->VirtualValue = ""; // Clear value
        }
        $this->blok_id->setDbValue($row['blok_id']);
        if (array_key_exists('EV__blok_id', $row)) {
            $this->blok_id->VirtualValue = $row['EV__blok_id']; // Set up virtual field value
        } else {
            $this->blok_id->VirtualValue = ""; // Clear value
        }
        $this->sos_id->setDbValue($row['sos_id']);
        if (array_key_exists('EV__sos_id', $row)) {
            $this->sos_id->VirtualValue = $row['EV__sos_id']; // Set up virtual field value
        } else {
            $this->sos_id->VirtualValue = ""; // Clear value
        }
        $this->var_id->setDbValue($row['var_id']);
        $this->co_id->setDbValue($row['co_id']);
        $this->k_jumlah_bibit->setDbValue($row['k_jumlah_bibit']);
        $this->k_asal_bibit->setDbValue($row['k_asal_bibit']);
        $this->k_tgl_tanam->setDbValue($row['k_tgl_tanam']);
        $this->k_es_tgl_panen->setDbValue($row['k_es_tgl_panen']);
        $this->k_ak_tgl_datang->setDbValue($row['k_ak_tgl_datang']);
        $this->k_es_qty->setDbValue($row['k_es_qty']);
        $this->k_ak_qty->setDbValue($row['k_ak_qty']);
        $this->k_es_perhektar->setDbValue($row['k_es_perhektar']);
        $this->k_ak_perhektar->setDbValue($row['k_ak_perhektar']);
        $this->k_skor->setDbValue($row['k_skor']);
        $this->k_ket->setDbValue($row['k_ket']);
        $this->k_cat->setDbValue($row['k_cat']);
        $this->k_titik_koordinat->setDbValue($row['k_titik_koordinat']);
        $this->k_foto_lahan->Upload->DbValue = $row['k_foto_lahan'];
        $this->k_foto_lahan->setDbValue($this->k_foto_lahan->Upload->DbValue);
        $this->k_dok->Upload->DbValue = $row['k_dok'];
        $this->k_dok->setDbValue($this->k_dok->Upload->DbValue);
        $this->k_harga_bibit->setDbValue($row['k_harga_bibit']);
        $this->k_bayar_bibit->setDbValue($row['k_bayar_bibit']);
        $this->k_pinjaman->setDbValue($row['k_pinjaman']);
        $this->k_bayar_pinjaman->setDbValue($row['k_bayar_pinjaman']);
        $this->k_sisa_hutang->setDbValue($row['k_sisa_hutang']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['k_id'] = $this->k_id->DefaultValue;
        $row['k_id_kontrak'] = $this->k_id_kontrak->DefaultValue;
        $row['k_id_lama'] = $this->k_id_lama->DefaultValue;
        $row['k_no_kontrak'] = $this->k_no_kontrak->DefaultValue;
        $row['k_luas_lahan'] = $this->k_luas_lahan->DefaultValue;
        $row['pet_id'] = $this->pet_id->DefaultValue;
        $row['koord_id'] = $this->koord_id->DefaultValue;
        $row['kk_id'] = $this->kk_id->DefaultValue;
        $row['prov_id'] = $this->prov_id->DefaultValue;
        $row['kab_id'] = $this->kab_id->DefaultValue;
        $row['kec_id'] = $this->kec_id->DefaultValue;
        $row['desa_id'] = $this->desa_id->DefaultValue;
        $row['blok_id'] = $this->blok_id->DefaultValue;
        $row['sos_id'] = $this->sos_id->DefaultValue;
        $row['var_id'] = $this->var_id->DefaultValue;
        $row['co_id'] = $this->co_id->DefaultValue;
        $row['k_jumlah_bibit'] = $this->k_jumlah_bibit->DefaultValue;
        $row['k_asal_bibit'] = $this->k_asal_bibit->DefaultValue;
        $row['k_tgl_tanam'] = $this->k_tgl_tanam->DefaultValue;
        $row['k_es_tgl_panen'] = $this->k_es_tgl_panen->DefaultValue;
        $row['k_ak_tgl_datang'] = $this->k_ak_tgl_datang->DefaultValue;
        $row['k_es_qty'] = $this->k_es_qty->DefaultValue;
        $row['k_ak_qty'] = $this->k_ak_qty->DefaultValue;
        $row['k_es_perhektar'] = $this->k_es_perhektar->DefaultValue;
        $row['k_ak_perhektar'] = $this->k_ak_perhektar->DefaultValue;
        $row['k_skor'] = $this->k_skor->DefaultValue;
        $row['k_ket'] = $this->k_ket->DefaultValue;
        $row['k_cat'] = $this->k_cat->DefaultValue;
        $row['k_titik_koordinat'] = $this->k_titik_koordinat->DefaultValue;
        $row['k_foto_lahan'] = $this->k_foto_lahan->DefaultValue;
        $row['k_dok'] = $this->k_dok->DefaultValue;
        $row['k_harga_bibit'] = $this->k_harga_bibit->DefaultValue;
        $row['k_bayar_bibit'] = $this->k_bayar_bibit->DefaultValue;
        $row['k_pinjaman'] = $this->k_pinjaman->DefaultValue;
        $row['k_bayar_pinjaman'] = $this->k_bayar_pinjaman->DefaultValue;
        $row['k_sisa_hutang'] = $this->k_sisa_hutang->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // k_id
        $this->k_id->CellCssStyle = "white-space: nowrap;";

        // k_id_kontrak

        // k_id_lama
        $this->k_id_lama->CellCssStyle = "white-space: nowrap;";

        // k_no_kontrak
        $this->k_no_kontrak->CellCssStyle = "white-space: nowrap;";

        // k_luas_lahan

        // pet_id

        // koord_id

        // kk_id

        // prov_id

        // kab_id

        // kec_id

        // desa_id

        // blok_id

        // sos_id

        // var_id

        // co_id

        // k_jumlah_bibit

        // k_asal_bibit

        // k_tgl_tanam

        // k_es_tgl_panen

        // k_ak_tgl_datang

        // k_es_qty

        // k_ak_qty

        // k_es_perhektar

        // k_ak_perhektar

        // k_skor

        // k_ket

        // k_cat

        // k_titik_koordinat

        // k_foto_lahan

        // k_dok

        // k_harga_bibit

        // k_bayar_bibit

        // k_pinjaman

        // k_bayar_pinjaman

        // k_sisa_hutang

        // Accumulate aggregate value
        if ($this->RowType != ROWTYPE_AGGREGATEINIT && $this->RowType != ROWTYPE_AGGREGATE && $this->RowType != ROWTYPE_PREVIEW_FIELD) {
            if (is_numeric($this->k_luas_lahan->CurrentValue)) {
                $this->k_luas_lahan->Total += $this->k_luas_lahan->CurrentValue; // Accumulate total
            }
        }

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // k_id
            $this->k_id->ViewValue = $this->k_id->CurrentValue;

            // k_id_kontrak
            $this->k_id_kontrak->ViewValue = $this->k_id_kontrak->CurrentValue;

            // k_luas_lahan
            $this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;

            // pet_id
            if ($this->pet_id->VirtualValue != "") {
                $this->pet_id->ViewValue = $this->pet_id->VirtualValue;
            } else {
                $this->pet_id->ViewValue = $this->pet_id->CurrentValue;
                $curVal = strval($this->pet_id->CurrentValue);
                if ($curVal != "") {
                    $this->pet_id->ViewValue = $this->pet_id->lookupCacheOption($curVal);
                    if ($this->pet_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`pet_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->pet_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->pet_id->Lookup->renderViewRow($rswrk[0]);
                            $this->pet_id->ViewValue = $this->pet_id->displayValue($arwrk);
                        } else {
                            $this->pet_id->ViewValue = $this->pet_id->CurrentValue;
                        }
                    }
                } else {
                    $this->pet_id->ViewValue = null;
                }
            }

            // koord_id
            if ($this->koord_id->VirtualValue != "") {
                $this->koord_id->ViewValue = $this->koord_id->VirtualValue;
            } else {
                $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                $curVal = strval($this->koord_id->CurrentValue);
                if ($curVal != "") {
                    $this->koord_id->ViewValue = $this->koord_id->lookupCacheOption($curVal);
                    if ($this->koord_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`koord_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->koord_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->koord_id->Lookup->renderViewRow($rswrk[0]);
                            $this->koord_id->ViewValue = $this->koord_id->displayValue($arwrk);
                        } else {
                            $this->koord_id->ViewValue = $this->koord_id->CurrentValue;
                        }
                    }
                } else {
                    $this->koord_id->ViewValue = null;
                }
            }

            // kk_id
            $curVal = strval($this->kk_id->CurrentValue);
            if ($curVal != "") {
                $this->kk_id->ViewValue = $this->kk_id->lookupCacheOption($curVal);
                if ($this->kk_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`kk_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->kk_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->kk_id->Lookup->renderViewRow($rswrk[0]);
                        $this->kk_id->ViewValue = $this->kk_id->displayValue($arwrk);
                    } else {
                        $this->kk_id->ViewValue = $this->kk_id->CurrentValue;
                    }
                }
            } else {
                $this->kk_id->ViewValue = null;
            }

            // prov_id
            if ($this->prov_id->VirtualValue != "") {
                $this->prov_id->ViewValue = $this->prov_id->VirtualValue;
            } else {
                $curVal = strval($this->prov_id->CurrentValue);
                if ($curVal != "") {
                    $this->prov_id->ViewValue = $this->prov_id->lookupCacheOption($curVal);
                    if ($this->prov_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`prov_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->prov_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->prov_id->Lookup->renderViewRow($rswrk[0]);
                            $this->prov_id->ViewValue = $this->prov_id->displayValue($arwrk);
                        } else {
                            $this->prov_id->ViewValue = $this->prov_id->CurrentValue;
                        }
                    }
                } else {
                    $this->prov_id->ViewValue = null;
                }
            }

            // kab_id
            if ($this->kab_id->VirtualValue != "") {
                $this->kab_id->ViewValue = $this->kab_id->VirtualValue;
            } else {
                $curVal = strval($this->kab_id->CurrentValue);
                if ($curVal != "") {
                    $this->kab_id->ViewValue = $this->kab_id->lookupCacheOption($curVal);
                    if ($this->kab_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kab_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kab_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kab_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kab_id->ViewValue = $this->kab_id->displayValue($arwrk);
                        } else {
                            $this->kab_id->ViewValue = $this->kab_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kab_id->ViewValue = null;
                }
            }

            // kec_id
            if ($this->kec_id->VirtualValue != "") {
                $this->kec_id->ViewValue = $this->kec_id->VirtualValue;
            } else {
                $curVal = strval($this->kec_id->CurrentValue);
                if ($curVal != "") {
                    $this->kec_id->ViewValue = $this->kec_id->lookupCacheOption($curVal);
                    if ($this->kec_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`kec_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->kec_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->kec_id->Lookup->renderViewRow($rswrk[0]);
                            $this->kec_id->ViewValue = $this->kec_id->displayValue($arwrk);
                        } else {
                            $this->kec_id->ViewValue = $this->kec_id->CurrentValue;
                        }
                    }
                } else {
                    $this->kec_id->ViewValue = null;
                }
            }

            // desa_id
            if ($this->desa_id->VirtualValue != "") {
                $this->desa_id->ViewValue = $this->desa_id->VirtualValue;
            } else {
                $curVal = strval($this->desa_id->CurrentValue);
                if ($curVal != "") {
                    $this->desa_id->ViewValue = $this->desa_id->lookupCacheOption($curVal);
                    if ($this->desa_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`desa_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->desa_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->desa_id->Lookup->renderViewRow($rswrk[0]);
                            $this->desa_id->ViewValue = $this->desa_id->displayValue($arwrk);
                        } else {
                            $this->desa_id->ViewValue = $this->desa_id->CurrentValue;
                        }
                    }
                } else {
                    $this->desa_id->ViewValue = null;
                }
            }

            // blok_id
            if ($this->blok_id->VirtualValue != "") {
                $this->blok_id->ViewValue = $this->blok_id->VirtualValue;
            } else {
                $this->blok_id->ViewValue = $this->blok_id->CurrentValue;
                $curVal = strval($this->blok_id->CurrentValue);
                if ($curVal != "") {
                    $this->blok_id->ViewValue = $this->blok_id->lookupCacheOption($curVal);
                    if ($this->blok_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`blok_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->blok_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->blok_id->Lookup->renderViewRow($rswrk[0]);
                            $this->blok_id->ViewValue = $this->blok_id->displayValue($arwrk);
                        } else {
                            $this->blok_id->ViewValue = $this->blok_id->CurrentValue;
                        }
                    }
                } else {
                    $this->blok_id->ViewValue = null;
                }
            }

            // sos_id
            if ($this->sos_id->VirtualValue != "") {
                $this->sos_id->ViewValue = $this->sos_id->VirtualValue;
            } else {
                $curVal = strval($this->sos_id->CurrentValue);
                if ($curVal != "") {
                    $this->sos_id->ViewValue = $this->sos_id->lookupCacheOption($curVal);
                    if ($this->sos_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`sos_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->sos_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->sos_id->Lookup->renderViewRow($rswrk[0]);
                            $this->sos_id->ViewValue = $this->sos_id->displayValue($arwrk);
                        } else {
                            $this->sos_id->ViewValue = $this->sos_id->CurrentValue;
                        }
                    }
                } else {
                    $this->sos_id->ViewValue = null;
                }
            }

            // var_id
            $curVal = strval($this->var_id->CurrentValue);
            if ($curVal != "") {
                $this->var_id->ViewValue = $this->var_id->lookupCacheOption($curVal);
                if ($this->var_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->var_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->var_id->Lookup->renderViewRow($rswrk[0]);
                        $this->var_id->ViewValue = $this->var_id->displayValue($arwrk);
                    } else {
                        $this->var_id->ViewValue = $this->var_id->CurrentValue;
                    }
                }
            } else {
                $this->var_id->ViewValue = null;
            }

            // co_id
            $curVal = strval($this->co_id->CurrentValue);
            if ($curVal != "") {
                $this->co_id->ViewValue = $this->co_id->lookupCacheOption($curVal);
                if ($this->co_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`co_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->co_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->co_id->Lookup->renderViewRow($rswrk[0]);
                        $this->co_id->ViewValue = $this->co_id->displayValue($arwrk);
                    } else {
                        $this->co_id->ViewValue = $this->co_id->CurrentValue;
                    }
                }
            } else {
                $this->co_id->ViewValue = null;
            }

            // k_jumlah_bibit
            $this->k_jumlah_bibit->ViewValue = $this->k_jumlah_bibit->CurrentValue;

            // k_asal_bibit
            $this->k_asal_bibit->ViewValue = $this->k_asal_bibit->CurrentValue;

            // k_tgl_tanam
            $this->k_tgl_tanam->ViewValue = $this->k_tgl_tanam->CurrentValue;
            $this->k_tgl_tanam->ViewValue = FormatDateTime($this->k_tgl_tanam->ViewValue, $this->k_tgl_tanam->formatPattern());

            // k_es_tgl_panen
            $this->k_es_tgl_panen->ViewValue = $this->k_es_tgl_panen->CurrentValue;
            $this->k_es_tgl_panen->ViewValue = FormatDateTime($this->k_es_tgl_panen->ViewValue, $this->k_es_tgl_panen->formatPattern());

            // k_ak_tgl_datang
            $this->k_ak_tgl_datang->ViewValue = $this->k_ak_tgl_datang->CurrentValue;
            $this->k_ak_tgl_datang->ViewValue = FormatDateTime($this->k_ak_tgl_datang->ViewValue, $this->k_ak_tgl_datang->formatPattern());

            // k_es_qty
            $this->k_es_qty->ViewValue = $this->k_es_qty->CurrentValue;

            // k_ak_qty
            $this->k_ak_qty->ViewValue = $this->k_ak_qty->CurrentValue;

            // k_es_perhektar
            $this->k_es_perhektar->ViewValue = $this->k_es_perhektar->CurrentValue;

            // k_ak_perhektar
            $this->k_ak_perhektar->ViewValue = $this->k_ak_perhektar->CurrentValue;
            $this->k_ak_perhektar->ViewValue = FormatNumber($this->k_ak_perhektar->ViewValue, $this->k_ak_perhektar->formatPattern());

            // k_skor
            $this->k_skor->ViewValue = $this->k_skor->CurrentValue;
            $this->k_skor->ViewValue = FormatNumber($this->k_skor->ViewValue, $this->k_skor->formatPattern());

            // k_ket
            $this->k_ket->ViewValue = $this->k_ket->CurrentValue;

            // k_cat
            $this->k_cat->ViewValue = $this->k_cat->CurrentValue;

            // k_titik_koordinat
            $this->k_titik_koordinat->ViewValue = $this->k_titik_koordinat->CurrentValue;
            $this->k_titik_koordinat->CellCssStyle .= "text-align: left;";

            // k_foto_lahan
            $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
                $this->k_foto_lahan->ImageWidth = 40;
                $this->k_foto_lahan->ImageHeight = 30;
                $this->k_foto_lahan->ImageAlt = $this->k_foto_lahan->alt();
                $this->k_foto_lahan->ImageCssClass = "ew-image";
                $this->k_foto_lahan->ViewValue = $this->k_foto_lahan->Upload->DbValue;
            } else {
                $this->k_foto_lahan->ViewValue = "";
            }
            $this->k_foto_lahan->CellCssStyle .= "text-align: left;";

            // k_dok
            $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->k_dok->Upload->DbValue)) {
                $this->k_dok->ImageWidth = 42;
                $this->k_dok->ImageHeight = 70;
                $this->k_dok->ImageAlt = $this->k_dok->alt();
                $this->k_dok->ImageCssClass = "ew-image";
                $this->k_dok->ViewValue = $this->k_dok->Upload->DbValue;
            } else {
                $this->k_dok->ViewValue = "";
            }

            // k_harga_bibit
            $this->k_harga_bibit->ViewValue = $this->k_harga_bibit->CurrentValue;

            // k_bayar_bibit
            $this->k_bayar_bibit->ViewValue = $this->k_bayar_bibit->CurrentValue;

            // k_pinjaman
            $this->k_pinjaman->ViewValue = $this->k_pinjaman->CurrentValue;

            // k_bayar_pinjaman
            $this->k_bayar_pinjaman->ViewValue = $this->k_bayar_pinjaman->CurrentValue;

            // k_sisa_hutang
            $this->k_sisa_hutang->ViewValue = $this->k_sisa_hutang->CurrentValue;

            // k_id_kontrak
            $this->k_id_kontrak->HrefValue = "";
            $this->k_id_kontrak->TooltipValue = "";

            // k_luas_lahan
            $this->k_luas_lahan->HrefValue = "";
            $this->k_luas_lahan->TooltipValue = "";

            // pet_id
            if (!EmptyValue($this->pet_id->CurrentValue)) {
                $this->pet_id->HrefValue = $this->pet_id->getLinkPrefix() . $this->pet_id->CurrentValue; // Add prefix/suffix
                $this->pet_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->pet_id->HrefValue = FullUrl($this->pet_id->HrefValue, "href");
                }
            } else {
                $this->pet_id->HrefValue = "";
            }
            $this->pet_id->TooltipValue = "";

            // koord_id
            if (!EmptyValue($this->koord_id->CurrentValue)) {
                $this->koord_id->HrefValue = $this->koord_id->getLinkPrefix() . $this->koord_id->CurrentValue; // Add prefix/suffix
                $this->koord_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->koord_id->HrefValue = FullUrl($this->koord_id->HrefValue, "href");
                }
            } else {
                $this->koord_id->HrefValue = "";
            }
            $this->koord_id->TooltipValue = "";

            // kk_id
            if (!EmptyValue($this->kk_id->CurrentValue)) {
                $this->kk_id->HrefValue = $this->kk_id->getLinkPrefix() . $this->kk_id->CurrentValue; // Add prefix/suffix
                $this->kk_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->kk_id->HrefValue = FullUrl($this->kk_id->HrefValue, "href");
                }
            } else {
                $this->kk_id->HrefValue = "";
            }
            $this->kk_id->TooltipValue = "";

            // prov_id
            $this->prov_id->HrefValue = "";
            $this->prov_id->TooltipValue = "";

            // kab_id
            $this->kab_id->HrefValue = "";
            $this->kab_id->TooltipValue = "";

            // kec_id
            $this->kec_id->HrefValue = "";
            $this->kec_id->TooltipValue = "";

            // desa_id
            $this->desa_id->HrefValue = "";
            $this->desa_id->TooltipValue = "";

            // blok_id
            $this->blok_id->HrefValue = "";
            $this->blok_id->TooltipValue = "";

            // sos_id
            $this->sos_id->HrefValue = "";
            $this->sos_id->TooltipValue = "";

            // var_id
            if (!EmptyValue($this->var_id->CurrentValue)) {
                $this->var_id->HrefValue = $this->var_id->getLinkPrefix() . $this->var_id->CurrentValue; // Add prefix/suffix
                $this->var_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->var_id->HrefValue = FullUrl($this->var_id->HrefValue, "href");
                }
            } else {
                $this->var_id->HrefValue = "";
            }
            $this->var_id->TooltipValue = "";

            // co_id
            if (!EmptyValue($this->co_id->CurrentValue)) {
                $this->co_id->HrefValue = $this->co_id->getLinkPrefix() . $this->co_id->CurrentValue; // Add prefix/suffix
                $this->co_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->co_id->HrefValue = FullUrl($this->co_id->HrefValue, "href");
                }
            } else {
                $this->co_id->HrefValue = "";
            }
            $this->co_id->TooltipValue = "";

            // k_jumlah_bibit
            $this->k_jumlah_bibit->HrefValue = "";
            $this->k_jumlah_bibit->TooltipValue = "";

            // k_asal_bibit
            $this->k_asal_bibit->HrefValue = "";
            $this->k_asal_bibit->TooltipValue = "";

            // k_tgl_tanam
            $this->k_tgl_tanam->HrefValue = "";
            $this->k_tgl_tanam->TooltipValue = "";

            // k_es_tgl_panen
            $this->k_es_tgl_panen->HrefValue = "";
            $this->k_es_tgl_panen->TooltipValue = "";

            // k_ak_tgl_datang
            $this->k_ak_tgl_datang->HrefValue = "";
            $this->k_ak_tgl_datang->TooltipValue = "";

            // k_es_qty
            $this->k_es_qty->HrefValue = "";
            $this->k_es_qty->TooltipValue = "";

            // k_ak_qty
            $this->k_ak_qty->HrefValue = "";
            $this->k_ak_qty->TooltipValue = "";

            // k_es_perhektar
            $this->k_es_perhektar->HrefValue = "";
            $this->k_es_perhektar->TooltipValue = "";

            // k_ak_perhektar
            $this->k_ak_perhektar->HrefValue = "";
            $this->k_ak_perhektar->TooltipValue = "";

            // k_skor
            $this->k_skor->HrefValue = "";
            $this->k_skor->TooltipValue = "";

            // k_ket
            $this->k_ket->HrefValue = "";
            $this->k_ket->TooltipValue = "";

            // k_cat
            $this->k_cat->HrefValue = "";
            $this->k_cat->TooltipValue = "";

            // k_titik_koordinat
            if (!EmptyValue($this->k_titik_koordinat->CurrentValue)) {
                $this->k_titik_koordinat->HrefValue = (!empty($this->k_titik_koordinat->ViewValue) && !is_array($this->k_titik_koordinat->ViewValue) ? RemoveHtml($this->k_titik_koordinat->ViewValue) : $this->k_titik_koordinat->CurrentValue); // Add prefix/suffix
                $this->k_titik_koordinat->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_titik_koordinat->HrefValue = FullUrl($this->k_titik_koordinat->HrefValue, "href");
                }
            } else {
                $this->k_titik_koordinat->HrefValue = "";
            }
            $this->k_titik_koordinat->TooltipValue = "";

            // k_foto_lahan
            $this->k_foto_lahan->UploadPath = $this->k_foto_lahan->getUploadPath(); // PHP
            if (!EmptyValue($this->k_foto_lahan->Upload->DbValue)) {
                $this->k_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
                $this->k_foto_lahan->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_foto_lahan->HrefValue = FullUrl($this->k_foto_lahan->HrefValue, "href");
                }
            } else {
                $this->k_foto_lahan->HrefValue = "";
            }
            $this->k_foto_lahan->ExportHrefValue = $this->k_foto_lahan->UploadPath . $this->k_foto_lahan->Upload->DbValue;
            $this->k_foto_lahan->TooltipValue = "";
            if ($this->k_foto_lahan->UseColorbox) {
                if (EmptyValue($this->k_foto_lahan->TooltipValue)) {
                    $this->k_foto_lahan->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->k_foto_lahan->LinkAttrs["data-rel"] = "kontrak_x" . $this->RowCount . "_k_foto_lahan";
                $this->k_foto_lahan->LinkAttrs->appendClass("ew-lightbox");
            }

            // k_dok
            $this->k_dok->UploadPath = $this->k_dok->getUploadPath(); // PHP
            if (!EmptyValue($this->k_dok->Upload->DbValue)) {
                $this->k_dok->HrefValue = "%u"; // Add prefix/suffix
                $this->k_dok->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->k_dok->HrefValue = FullUrl($this->k_dok->HrefValue, "href");
                }
            } else {
                $this->k_dok->HrefValue = "";
            }
            $this->k_dok->ExportHrefValue = $this->k_dok->UploadPath . $this->k_dok->Upload->DbValue;
            $this->k_dok->TooltipValue = "";
            if ($this->k_dok->UseColorbox) {
                if (EmptyValue($this->k_dok->TooltipValue)) {
                    $this->k_dok->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->k_dok->LinkAttrs["data-rel"] = "kontrak_x" . $this->RowCount . "_k_dok";
                $this->k_dok->LinkAttrs->appendClass("ew-lightbox");
            }

            // k_harga_bibit
            $this->k_harga_bibit->HrefValue = "";
            $this->k_harga_bibit->TooltipValue = "";

            // k_bayar_bibit
            $this->k_bayar_bibit->HrefValue = "";
            $this->k_bayar_bibit->TooltipValue = "";

            // k_pinjaman
            $this->k_pinjaman->HrefValue = "";
            $this->k_pinjaman->TooltipValue = "";

            // k_bayar_pinjaman
            $this->k_bayar_pinjaman->HrefValue = "";
            $this->k_bayar_pinjaman->TooltipValue = "";

            // k_sisa_hutang
            $this->k_sisa_hutang->HrefValue = "";
            $this->k_sisa_hutang->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_SEARCH) {
            // k_id_kontrak
            $this->k_id_kontrak->setupEditAttributes();
            if (!$this->k_id_kontrak->Raw) {
                $this->k_id_kontrak->AdvancedSearch->SearchValue = HtmlDecode($this->k_id_kontrak->AdvancedSearch->SearchValue);
            }
            $this->k_id_kontrak->EditValue = HtmlEncode($this->k_id_kontrak->AdvancedSearch->SearchValue);
            $this->k_id_kontrak->PlaceHolder = RemoveHtml($this->k_id_kontrak->caption());

            // k_luas_lahan
            $this->k_luas_lahan->setupEditAttributes();
            $this->k_luas_lahan->EditValue = HtmlEncode($this->k_luas_lahan->AdvancedSearch->SearchValue);
            $this->k_luas_lahan->PlaceHolder = RemoveHtml($this->k_luas_lahan->caption());

            // pet_id
            $this->pet_id->setupEditAttributes();
            $this->pet_id->EditValue = HtmlEncode($this->pet_id->AdvancedSearch->SearchValue);
            $this->pet_id->PlaceHolder = RemoveHtml($this->pet_id->caption());

            // koord_id
            $this->koord_id->setupEditAttributes();
            $this->koord_id->EditValue = HtmlEncode($this->koord_id->AdvancedSearch->SearchValue);
            $this->koord_id->PlaceHolder = RemoveHtml($this->koord_id->caption());

            // kk_id
            $this->kk_id->setupEditAttributes();
            $this->kk_id->PlaceHolder = RemoveHtml($this->kk_id->caption());

            // prov_id
            $this->prov_id->setupEditAttributes();
            $curVal = trim(strval($this->prov_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->prov_id->AdvancedSearch->ViewValue = $this->prov_id->lookupCacheOption($curVal);
            } else {
                $this->prov_id->AdvancedSearch->ViewValue = $this->prov_id->Lookup !== null && is_array($this->prov_id->lookupOptions()) && count($this->prov_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->prov_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->prov_id->EditValue = array_values($this->prov_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`prov_id`", "=", $this->prov_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->prov_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->prov_id->EditValue = $arwrk;
            }
            $this->prov_id->PlaceHolder = RemoveHtml($this->prov_id->caption());

            // kab_id
            $this->kab_id->setupEditAttributes();
            $curVal = trim(strval($this->kab_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->kab_id->AdvancedSearch->ViewValue = $this->kab_id->lookupCacheOption($curVal);
            } else {
                $this->kab_id->AdvancedSearch->ViewValue = $this->kab_id->Lookup !== null && is_array($this->kab_id->lookupOptions()) && count($this->kab_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->kab_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->kab_id->EditValue = array_values($this->kab_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kab_id`", "=", $this->kab_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->kab_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->kab_id->EditValue = $arwrk;
            }
            $this->kab_id->PlaceHolder = RemoveHtml($this->kab_id->caption());

            // kec_id
            $this->kec_id->setupEditAttributes();
            $curVal = trim(strval($this->kec_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->kec_id->AdvancedSearch->ViewValue = $this->kec_id->lookupCacheOption($curVal);
            } else {
                $this->kec_id->AdvancedSearch->ViewValue = $this->kec_id->Lookup !== null && is_array($this->kec_id->lookupOptions()) && count($this->kec_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->kec_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->kec_id->EditValue = array_values($this->kec_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`kec_id`", "=", $this->kec_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->kec_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->kec_id->EditValue = $arwrk;
            }
            $this->kec_id->PlaceHolder = RemoveHtml($this->kec_id->caption());

            // desa_id
            $this->desa_id->setupEditAttributes();
            $curVal = trim(strval($this->desa_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->desa_id->AdvancedSearch->ViewValue = $this->desa_id->lookupCacheOption($curVal);
            } else {
                $this->desa_id->AdvancedSearch->ViewValue = $this->desa_id->Lookup !== null && is_array($this->desa_id->lookupOptions()) && count($this->desa_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->desa_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->desa_id->EditValue = array_values($this->desa_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`desa_id`", "=", $this->desa_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->desa_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->desa_id->EditValue = $arwrk;
            }
            $this->desa_id->PlaceHolder = RemoveHtml($this->desa_id->caption());

            // blok_id
            $this->blok_id->setupEditAttributes();
            $this->blok_id->EditValue = HtmlEncode($this->blok_id->AdvancedSearch->SearchValue);
            $this->blok_id->PlaceHolder = RemoveHtml($this->blok_id->caption());

            // sos_id
            $this->sos_id->setupEditAttributes();
            $this->sos_id->EditValue = HtmlEncode($this->sos_id->AdvancedSearch->SearchValue);
            $this->sos_id->PlaceHolder = RemoveHtml($this->sos_id->caption());

            // var_id
            $this->var_id->setupEditAttributes();
            $curVal = trim(strval($this->var_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->var_id->AdvancedSearch->ViewValue = $this->var_id->lookupCacheOption($curVal);
            } else {
                $this->var_id->AdvancedSearch->ViewValue = $this->var_id->Lookup !== null && is_array($this->var_id->lookupOptions()) && count($this->var_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->var_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->var_id->EditValue = array_values($this->var_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`var_id`", "=", $this->var_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->var_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->var_id->EditValue = $arwrk;
            }
            $this->var_id->PlaceHolder = RemoveHtml($this->var_id->caption());

            // co_id
            $this->co_id->setupEditAttributes();
            $curVal = trim(strval($this->co_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->co_id->AdvancedSearch->ViewValue = $this->co_id->lookupCacheOption($curVal);
            } else {
                $this->co_id->AdvancedSearch->ViewValue = $this->co_id->Lookup !== null && is_array($this->co_id->lookupOptions()) && count($this->co_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->co_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->co_id->EditValue = array_values($this->co_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`co_id`", "=", $this->co_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->co_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->co_id->EditValue = $arwrk;
            }
            $this->co_id->PlaceHolder = RemoveHtml($this->co_id->caption());

            // k_jumlah_bibit
            $this->k_jumlah_bibit->setupEditAttributes();
            $this->k_jumlah_bibit->EditValue = HtmlEncode($this->k_jumlah_bibit->AdvancedSearch->SearchValue);
            $this->k_jumlah_bibit->PlaceHolder = RemoveHtml($this->k_jumlah_bibit->caption());

            // k_asal_bibit
            $this->k_asal_bibit->setupEditAttributes();
            if (!$this->k_asal_bibit->Raw) {
                $this->k_asal_bibit->AdvancedSearch->SearchValue = HtmlDecode($this->k_asal_bibit->AdvancedSearch->SearchValue);
            }
            $this->k_asal_bibit->EditValue = HtmlEncode($this->k_asal_bibit->AdvancedSearch->SearchValue);
            $this->k_asal_bibit->PlaceHolder = RemoveHtml($this->k_asal_bibit->caption());

            // k_tgl_tanam
            $this->k_tgl_tanam->setupEditAttributes();
            $this->k_tgl_tanam->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->k_tgl_tanam->AdvancedSearch->SearchValue, $this->k_tgl_tanam->formatPattern()), $this->k_tgl_tanam->formatPattern()));
            $this->k_tgl_tanam->PlaceHolder = RemoveHtml($this->k_tgl_tanam->caption());
            $this->k_tgl_tanam->setupEditAttributes();
            $this->k_tgl_tanam->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->k_tgl_tanam->AdvancedSearch->SearchValue2, $this->k_tgl_tanam->formatPattern()), $this->k_tgl_tanam->formatPattern()));
            $this->k_tgl_tanam->PlaceHolder = RemoveHtml($this->k_tgl_tanam->caption());

            // k_es_tgl_panen
            $this->k_es_tgl_panen->setupEditAttributes();
            $this->k_es_tgl_panen->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->k_es_tgl_panen->AdvancedSearch->SearchValue, $this->k_es_tgl_panen->formatPattern()), $this->k_es_tgl_panen->formatPattern()));
            $this->k_es_tgl_panen->PlaceHolder = RemoveHtml($this->k_es_tgl_panen->caption());
            $this->k_es_tgl_panen->setupEditAttributes();
            $this->k_es_tgl_panen->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->k_es_tgl_panen->AdvancedSearch->SearchValue2, $this->k_es_tgl_panen->formatPattern()), $this->k_es_tgl_panen->formatPattern()));
            $this->k_es_tgl_panen->PlaceHolder = RemoveHtml($this->k_es_tgl_panen->caption());

            // k_ak_tgl_datang
            $this->k_ak_tgl_datang->setupEditAttributes();
            $this->k_ak_tgl_datang->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->k_ak_tgl_datang->AdvancedSearch->SearchValue, $this->k_ak_tgl_datang->formatPattern()), $this->k_ak_tgl_datang->formatPattern()));
            $this->k_ak_tgl_datang->PlaceHolder = RemoveHtml($this->k_ak_tgl_datang->caption());
            $this->k_ak_tgl_datang->setupEditAttributes();
            $this->k_ak_tgl_datang->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->k_ak_tgl_datang->AdvancedSearch->SearchValue2, $this->k_ak_tgl_datang->formatPattern()), $this->k_ak_tgl_datang->formatPattern()));
            $this->k_ak_tgl_datang->PlaceHolder = RemoveHtml($this->k_ak_tgl_datang->caption());

            // k_es_qty
            $this->k_es_qty->setupEditAttributes();
            $this->k_es_qty->EditValue = HtmlEncode($this->k_es_qty->AdvancedSearch->SearchValue);
            $this->k_es_qty->PlaceHolder = RemoveHtml($this->k_es_qty->caption());

            // k_ak_qty
            $this->k_ak_qty->setupEditAttributes();
            $this->k_ak_qty->EditValue = HtmlEncode($this->k_ak_qty->AdvancedSearch->SearchValue);
            $this->k_ak_qty->PlaceHolder = RemoveHtml($this->k_ak_qty->caption());

            // k_es_perhektar
            $this->k_es_perhektar->setupEditAttributes();
            $this->k_es_perhektar->EditValue = HtmlEncode($this->k_es_perhektar->AdvancedSearch->SearchValue);
            $this->k_es_perhektar->PlaceHolder = RemoveHtml($this->k_es_perhektar->caption());

            // k_ak_perhektar
            $this->k_ak_perhektar->setupEditAttributes();
            $this->k_ak_perhektar->EditValue = HtmlEncode($this->k_ak_perhektar->AdvancedSearch->SearchValue);
            $this->k_ak_perhektar->PlaceHolder = RemoveHtml($this->k_ak_perhektar->caption());

            // k_skor
            $this->k_skor->setupEditAttributes();
            $this->k_skor->EditValue = HtmlEncode($this->k_skor->AdvancedSearch->SearchValue);
            $this->k_skor->PlaceHolder = RemoveHtml($this->k_skor->caption());

            // k_ket
            $this->k_ket->setupEditAttributes();
            $this->k_ket->EditValue = HtmlEncode($this->k_ket->AdvancedSearch->SearchValue);
            $this->k_ket->PlaceHolder = RemoveHtml($this->k_ket->caption());

            // k_cat
            $this->k_cat->setupEditAttributes();
            $this->k_cat->EditValue = HtmlEncode($this->k_cat->AdvancedSearch->SearchValue);
            $this->k_cat->PlaceHolder = RemoveHtml($this->k_cat->caption());

            // k_titik_koordinat
            $this->k_titik_koordinat->setupEditAttributes();
            if (!$this->k_titik_koordinat->Raw) {
                $this->k_titik_koordinat->AdvancedSearch->SearchValue = HtmlDecode($this->k_titik_koordinat->AdvancedSearch->SearchValue);
            }
            $this->k_titik_koordinat->EditValue = HtmlEncode($this->k_titik_koordinat->AdvancedSearch->SearchValue);
            $this->k_titik_koordinat->PlaceHolder = RemoveHtml($this->k_titik_koordinat->caption());

            // k_foto_lahan
            $this->k_foto_lahan->setupEditAttributes();
            if (!$this->k_foto_lahan->Raw) {
                $this->k_foto_lahan->AdvancedSearch->SearchValue = HtmlDecode($this->k_foto_lahan->AdvancedSearch->SearchValue);
            }
            $this->k_foto_lahan->EditValue = HtmlEncode($this->k_foto_lahan->AdvancedSearch->SearchValue);
            $this->k_foto_lahan->PlaceHolder = RemoveHtml($this->k_foto_lahan->caption());

            // k_dok
            $this->k_dok->setupEditAttributes();
            if (!$this->k_dok->Raw) {
                $this->k_dok->AdvancedSearch->SearchValue = HtmlDecode($this->k_dok->AdvancedSearch->SearchValue);
            }
            $this->k_dok->EditValue = HtmlEncode($this->k_dok->AdvancedSearch->SearchValue);
            $this->k_dok->PlaceHolder = RemoveHtml($this->k_dok->caption());

            // k_harga_bibit
            $this->k_harga_bibit->setupEditAttributes();
            $this->k_harga_bibit->EditValue = HtmlEncode($this->k_harga_bibit->AdvancedSearch->SearchValue);
            $this->k_harga_bibit->PlaceHolder = RemoveHtml($this->k_harga_bibit->caption());

            // k_bayar_bibit
            $this->k_bayar_bibit->setupEditAttributes();
            $this->k_bayar_bibit->EditValue = HtmlEncode($this->k_bayar_bibit->AdvancedSearch->SearchValue);
            $this->k_bayar_bibit->PlaceHolder = RemoveHtml($this->k_bayar_bibit->caption());

            // k_pinjaman
            $this->k_pinjaman->setupEditAttributes();
            $this->k_pinjaman->EditValue = HtmlEncode($this->k_pinjaman->AdvancedSearch->SearchValue);
            $this->k_pinjaman->PlaceHolder = RemoveHtml($this->k_pinjaman->caption());

            // k_bayar_pinjaman
            $this->k_bayar_pinjaman->setupEditAttributes();
            $this->k_bayar_pinjaman->EditValue = HtmlEncode($this->k_bayar_pinjaman->AdvancedSearch->SearchValue);
            $this->k_bayar_pinjaman->PlaceHolder = RemoveHtml($this->k_bayar_pinjaman->caption());

            // k_sisa_hutang
            $this->k_sisa_hutang->setupEditAttributes();
            $this->k_sisa_hutang->EditValue = HtmlEncode($this->k_sisa_hutang->AdvancedSearch->SearchValue);
            $this->k_sisa_hutang->PlaceHolder = RemoveHtml($this->k_sisa_hutang->caption());
        } elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
                    $this->k_luas_lahan->Total = 0; // Initialize total
        } elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
            $this->k_luas_lahan->CurrentValue = $this->k_luas_lahan->Total;
            $this->k_luas_lahan->ViewValue = $this->k_luas_lahan->CurrentValue;
            $this->k_luas_lahan->HrefValue = ""; // Clear href value
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->k_luas_lahan->AdvancedSearch->SearchValue)) {
            $this->k_luas_lahan->addErrorMessage($this->k_luas_lahan->getErrorMessage(false));
        }
        if (!CheckDate($this->k_tgl_tanam->AdvancedSearch->SearchValue, $this->k_tgl_tanam->formatPattern())) {
            $this->k_tgl_tanam->addErrorMessage($this->k_tgl_tanam->getErrorMessage(false));
        }
        if (!CheckDate($this->k_tgl_tanam->AdvancedSearch->SearchValue2, $this->k_tgl_tanam->formatPattern())) {
            $this->k_tgl_tanam->addErrorMessage($this->k_tgl_tanam->getErrorMessage(false));
        }
        if (!CheckDate($this->k_es_tgl_panen->AdvancedSearch->SearchValue, $this->k_es_tgl_panen->formatPattern())) {
            $this->k_es_tgl_panen->addErrorMessage($this->k_es_tgl_panen->getErrorMessage(false));
        }
        if (!CheckDate($this->k_es_tgl_panen->AdvancedSearch->SearchValue2, $this->k_es_tgl_panen->formatPattern())) {
            $this->k_es_tgl_panen->addErrorMessage($this->k_es_tgl_panen->getErrorMessage(false));
        }
        if (!CheckDate($this->k_ak_tgl_datang->AdvancedSearch->SearchValue, $this->k_ak_tgl_datang->formatPattern())) {
            $this->k_ak_tgl_datang->addErrorMessage($this->k_ak_tgl_datang->getErrorMessage(false));
        }
        if (!CheckDate($this->k_ak_tgl_datang->AdvancedSearch->SearchValue2, $this->k_ak_tgl_datang->formatPattern())) {
            $this->k_ak_tgl_datang->addErrorMessage($this->k_ak_tgl_datang->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->k_id->AdvancedSearch->load();
        $this->k_id_kontrak->AdvancedSearch->load();
        $this->k_luas_lahan->AdvancedSearch->load();
        $this->pet_id->AdvancedSearch->load();
        $this->koord_id->AdvancedSearch->load();
        $this->kk_id->AdvancedSearch->load();
        $this->prov_id->AdvancedSearch->load();
        $this->kab_id->AdvancedSearch->load();
        $this->kec_id->AdvancedSearch->load();
        $this->desa_id->AdvancedSearch->load();
        $this->blok_id->AdvancedSearch->load();
        $this->sos_id->AdvancedSearch->load();
        $this->var_id->AdvancedSearch->load();
        $this->co_id->AdvancedSearch->load();
        $this->k_jumlah_bibit->AdvancedSearch->load();
        $this->k_asal_bibit->AdvancedSearch->load();
        $this->k_tgl_tanam->AdvancedSearch->load();
        $this->k_es_tgl_panen->AdvancedSearch->load();
        $this->k_ak_tgl_datang->AdvancedSearch->load();
        $this->k_es_qty->AdvancedSearch->load();
        $this->k_ak_qty->AdvancedSearch->load();
        $this->k_es_perhektar->AdvancedSearch->load();
        $this->k_ak_perhektar->AdvancedSearch->load();
        $this->k_skor->AdvancedSearch->load();
        $this->k_ket->AdvancedSearch->load();
        $this->k_cat->AdvancedSearch->load();
        $this->k_titik_koordinat->AdvancedSearch->load();
        $this->k_foto_lahan->AdvancedSearch->load();
        $this->k_dok->AdvancedSearch->load();
        $this->k_harga_bibit->AdvancedSearch->load();
        $this->k_bayar_bibit->AdvancedSearch->load();
        $this->k_pinjaman->AdvancedSearch->load();
        $this->k_bayar_pinjaman->AdvancedSearch->load();
        $this->k_sisa_hutang->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fkontraklist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fkontraklist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fkontraklist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fkontraklist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = false;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(["TagClassName" => "ew-search-option"]);

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fkontraksrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");

        // Load recordset
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");

        // Close recordset
        $rs->close();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_pet_id":
                    break;
                case "x_koord_id":
                    break;
                case "x_kk_id":
                    break;
                case "x_prov_id":
                    break;
                case "x_kab_id":
                    break;
                case "x_kec_id":
                    break;
                case "x_desa_id":
                    break;
                case "x_blok_id":
                    break;
                case "x_sos_id":
                    break;
                case "x_var_id":
                    break;
                case "x_co_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->Add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->MoveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
