<?php

namespace PHPMaker2023\co;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\FetchMode;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

/**
 * Page class
 */
class KedatanganAdd extends Kedatangan
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "KedatanganAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "KedatanganAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->datang_id->setVisibility();
        $this->datang_tgl->setVisibility();
        $this->datang_sumber->setVisibility();
        $this->k_id->setVisibility();
        $this->sup_id->setVisibility();
        $this->var_id->setVisibility();
        $this->datang_jumlah->setVisibility();
        $this->datang_terpakai->setVisibility();
        $this->po_id->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'kedatangan';
        $this->TableName = 'kedatangan';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Table object (kedatangan)
        if (!isset($GLOBALS["kedatangan"]) || get_class($GLOBALS["kedatangan"]) == PROJECT_NAMESPACE . "kedatangan") {
            $GLOBALS["kedatangan"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'kedatangan');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response (Assume return to modal for simplicity)
            if ($this->IsModal) { // Show as modal
                $result = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page => View page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = $pageName == "KedatanganView"; // If View page, no primary button
                } else { // List page
                    // $result["list"] = $this->PageID == "search"; // Refresh List page if current page is Search page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['datang_id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup($ar = null)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $ar["field"] ?? Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        $name = $ar["name"] ?? Post("name");
        $isQuery = ContainsString($name, "query_builder_rule");
        if ($isQuery) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $ar["ajax"] ?? Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $ar["q"] ?? Param("q") ?? $ar["sv"] ?? Post("sv", "");
            $pageSize = $ar["n"] ?? Param("n") ?? $ar["recperpage"] ?? Post("recperpage", 10);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $ar["q"] ?? Param("q", "");
            $pageSize = $ar["n"] ?? Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $ar["start"] ?? Param("start", -1);
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $ar["page"] ?? Param("page", -1);
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($ar["s"] ?? Post("s", ""));
        $userFilter = Decrypt($ar["f"] ?? Post("f", ""));
        $userOrderBy = Decrypt($ar["o"] ?? Post("o", ""));
        $keys = $ar["keys"] ?? Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $ar["v0"] ?? $ar["lookupValue"] ?? Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $ar["v" . $i] ?? Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, !is_array($ar)); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $UserProfile, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->datang_sumber);
        $this->setupLookupOptions($this->k_id);
        $this->setupLookupOptions($this->sup_id);
        $this->setupLookupOptions($this->var_id);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("datang_id") ?? Route("datang_id")) !== null) {
                $this->datang_id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("KedatanganList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "KedatanganList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "KedatanganView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "KedatanganList") {
                            Container("flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "KedatanganList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([ "success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage() ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'datang_id' first before field var 'x_datang_id'
        $val = $CurrentForm->hasValue("datang_id") ? $CurrentForm->getValue("datang_id") : $CurrentForm->getValue("x_datang_id");
        if (!$this->datang_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_id->Visible = false; // Disable update for API request
            } else {
                $this->datang_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'datang_tgl' first before field var 'x_datang_tgl'
        $val = $CurrentForm->hasValue("datang_tgl") ? $CurrentForm->getValue("datang_tgl") : $CurrentForm->getValue("x_datang_tgl");
        if (!$this->datang_tgl->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_tgl->Visible = false; // Disable update for API request
            } else {
                $this->datang_tgl->setFormValue($val, true, $validate);
            }
            $this->datang_tgl->CurrentValue = UnFormatDateTime($this->datang_tgl->CurrentValue, $this->datang_tgl->formatPattern());
        }

        // Check field name 'datang_sumber' first before field var 'x_datang_sumber'
        $val = $CurrentForm->hasValue("datang_sumber") ? $CurrentForm->getValue("datang_sumber") : $CurrentForm->getValue("x_datang_sumber");
        if (!$this->datang_sumber->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_sumber->Visible = false; // Disable update for API request
            } else {
                $this->datang_sumber->setFormValue($val);
            }
        }

        // Check field name 'k_id' first before field var 'x_k_id'
        $val = $CurrentForm->hasValue("k_id") ? $CurrentForm->getValue("k_id") : $CurrentForm->getValue("x_k_id");
        if (!$this->k_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->k_id->Visible = false; // Disable update for API request
            } else {
                $this->k_id->setFormValue($val);
            }
        }

        // Check field name 'sup_id' first before field var 'x_sup_id'
        $val = $CurrentForm->hasValue("sup_id") ? $CurrentForm->getValue("sup_id") : $CurrentForm->getValue("x_sup_id");
        if (!$this->sup_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sup_id->Visible = false; // Disable update for API request
            } else {
                $this->sup_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'var_id' first before field var 'x_var_id'
        $val = $CurrentForm->hasValue("var_id") ? $CurrentForm->getValue("var_id") : $CurrentForm->getValue("x_var_id");
        if (!$this->var_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->var_id->Visible = false; // Disable update for API request
            } else {
                $this->var_id->setFormValue($val);
            }
        }

        // Check field name 'datang_jumlah' first before field var 'x_datang_jumlah'
        $val = $CurrentForm->hasValue("datang_jumlah") ? $CurrentForm->getValue("datang_jumlah") : $CurrentForm->getValue("x_datang_jumlah");
        if (!$this->datang_jumlah->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_jumlah->Visible = false; // Disable update for API request
            } else {
                $this->datang_jumlah->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'datang_terpakai' first before field var 'x_datang_terpakai'
        $val = $CurrentForm->hasValue("datang_terpakai") ? $CurrentForm->getValue("datang_terpakai") : $CurrentForm->getValue("x_datang_terpakai");
        if (!$this->datang_terpakai->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datang_terpakai->Visible = false; // Disable update for API request
            } else {
                $this->datang_terpakai->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'po_id' first before field var 'x_po_id'
        $val = $CurrentForm->hasValue("po_id") ? $CurrentForm->getValue("po_id") : $CurrentForm->getValue("x_po_id");
        if (!$this->po_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_id->Visible = false; // Disable update for API request
            } else {
                $this->po_id->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->datang_id->CurrentValue = $this->datang_id->FormValue;
        $this->datang_tgl->CurrentValue = $this->datang_tgl->FormValue;
        $this->datang_tgl->CurrentValue = UnFormatDateTime($this->datang_tgl->CurrentValue, $this->datang_tgl->formatPattern());
        $this->datang_sumber->CurrentValue = $this->datang_sumber->FormValue;
        $this->k_id->CurrentValue = $this->k_id->FormValue;
        $this->sup_id->CurrentValue = $this->sup_id->FormValue;
        $this->var_id->CurrentValue = $this->var_id->FormValue;
        $this->datang_jumlah->CurrentValue = $this->datang_jumlah->FormValue;
        $this->datang_terpakai->CurrentValue = $this->datang_terpakai->FormValue;
        $this->po_id->CurrentValue = $this->po_id->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }
        if (!$row) {
            return;
        }

        // Call Row Selected event
        $this->rowSelected($row);
        $this->datang_id->setDbValue($row['datang_id']);
        $this->datang_tgl->setDbValue($row['datang_tgl']);
        $this->datang_sumber->setDbValue($row['datang_sumber']);
        $this->k_id->setDbValue($row['k_id']);
        if (array_key_exists('EV__k_id', $row)) {
            $this->k_id->VirtualValue = $row['EV__k_id']; // Set up virtual field value
        } else {
            $this->k_id->VirtualValue = ""; // Clear value
        }
        $this->sup_id->setDbValue($row['sup_id']);
        $this->var_id->setDbValue($row['var_id']);
        $this->datang_jumlah->setDbValue($row['datang_jumlah']);
        $this->datang_terpakai->setDbValue($row['datang_terpakai']);
        $this->po_id->setDbValue($row['po_id']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['datang_id'] = $this->datang_id->DefaultValue;
        $row['datang_tgl'] = $this->datang_tgl->DefaultValue;
        $row['datang_sumber'] = $this->datang_sumber->DefaultValue;
        $row['k_id'] = $this->k_id->DefaultValue;
        $row['sup_id'] = $this->sup_id->DefaultValue;
        $row['var_id'] = $this->var_id->DefaultValue;
        $row['datang_jumlah'] = $this->datang_jumlah->DefaultValue;
        $row['datang_terpakai'] = $this->datang_terpakai->DefaultValue;
        $row['po_id'] = $this->po_id->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn);
            if ($rs && ($row = $rs->fields)) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // datang_id
        $this->datang_id->RowCssClass = "row";

        // datang_tgl
        $this->datang_tgl->RowCssClass = "row";

        // datang_sumber
        $this->datang_sumber->RowCssClass = "row";

        // k_id
        $this->k_id->RowCssClass = "row";

        // sup_id
        $this->sup_id->RowCssClass = "row";

        // var_id
        $this->var_id->RowCssClass = "row";

        // datang_jumlah
        $this->datang_jumlah->RowCssClass = "row";

        // datang_terpakai
        $this->datang_terpakai->RowCssClass = "row";

        // po_id
        $this->po_id->RowCssClass = "row";

        // View row
        if ($this->RowType == ROWTYPE_VIEW) {
            // datang_id
            $this->datang_id->ViewValue = $this->datang_id->CurrentValue;

            // datang_tgl
            $this->datang_tgl->ViewValue = $this->datang_tgl->CurrentValue;
            $this->datang_tgl->ViewValue = FormatDateTime($this->datang_tgl->ViewValue, $this->datang_tgl->formatPattern());

            // datang_sumber
            $curVal = strval($this->datang_sumber->CurrentValue);
            if ($curVal != "") {
                $this->datang_sumber->ViewValue = $this->datang_sumber->lookupCacheOption($curVal);
                if ($this->datang_sumber->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`ds_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->datang_sumber->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->datang_sumber->Lookup->renderViewRow($rswrk[0]);
                        $this->datang_sumber->ViewValue = $this->datang_sumber->displayValue($arwrk);
                    } else {
                        $this->datang_sumber->ViewValue = $this->datang_sumber->CurrentValue;
                    }
                }
            } else {
                $this->datang_sumber->ViewValue = null;
            }

            // k_id
            if ($this->k_id->VirtualValue != "") {
                $this->k_id->ViewValue = $this->k_id->VirtualValue;
            } else {
                $this->k_id->ViewValue = $this->k_id->CurrentValue;
                $curVal = strval($this->k_id->CurrentValue);
                if ($curVal != "") {
                    $this->k_id->ViewValue = $this->k_id->lookupCacheOption($curVal);
                    if ($this->k_id->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter("`k_id`", "=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->k_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCacheImpl($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->k_id->Lookup->renderViewRow($rswrk[0]);
                            $this->k_id->ViewValue = $this->k_id->displayValue($arwrk);
                        } else {
                            $this->k_id->ViewValue = $this->k_id->CurrentValue;
                        }
                    }
                } else {
                    $this->k_id->ViewValue = null;
                }
            }

            // sup_id
            $this->sup_id->ViewValue = $this->sup_id->CurrentValue;
            $curVal = strval($this->sup_id->CurrentValue);
            if ($curVal != "") {
                $this->sup_id->ViewValue = $this->sup_id->lookupCacheOption($curVal);
                if ($this->sup_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`sup_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sup_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sup_id->Lookup->renderViewRow($rswrk[0]);
                        $this->sup_id->ViewValue = $this->sup_id->displayValue($arwrk);
                    } else {
                        $this->sup_id->ViewValue = $this->sup_id->CurrentValue;
                    }
                }
            } else {
                $this->sup_id->ViewValue = null;
            }

            // var_id
            $curVal = strval($this->var_id->CurrentValue);
            if ($curVal != "") {
                $this->var_id->ViewValue = $this->var_id->lookupCacheOption($curVal);
                if ($this->var_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`var_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->var_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->var_id->Lookup->renderViewRow($rswrk[0]);
                        $this->var_id->ViewValue = $this->var_id->displayValue($arwrk);
                    } else {
                        $this->var_id->ViewValue = $this->var_id->CurrentValue;
                    }
                }
            } else {
                $this->var_id->ViewValue = null;
            }

            // datang_jumlah
            $this->datang_jumlah->ViewValue = $this->datang_jumlah->CurrentValue;

            // datang_terpakai
            $this->datang_terpakai->ViewValue = $this->datang_terpakai->CurrentValue;

            // po_id
            $this->po_id->ViewValue = $this->po_id->CurrentValue;
            $this->po_id->ViewValue = FormatNumber($this->po_id->ViewValue, $this->po_id->formatPattern());

            // datang_id
            $this->datang_id->HrefValue = "";

            // datang_tgl
            $this->datang_tgl->HrefValue = "";

            // datang_sumber
            $this->datang_sumber->HrefValue = "";

            // k_id
            $this->k_id->HrefValue = "";

            // sup_id
            $this->sup_id->HrefValue = "";

            // var_id
            $this->var_id->HrefValue = "";

            // datang_jumlah
            $this->datang_jumlah->HrefValue = "";

            // datang_terpakai
            $this->datang_terpakai->HrefValue = "";

            // po_id
            $this->po_id->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // datang_id
            $this->datang_id->setupEditAttributes();
            $this->datang_id->EditValue = HtmlEncode($this->datang_id->CurrentValue);
            $this->datang_id->PlaceHolder = RemoveHtml($this->datang_id->caption());
            if (strval($this->datang_id->EditValue) != "" && is_numeric($this->datang_id->EditValue)) {
                $this->datang_id->EditValue = $this->datang_id->EditValue;
            }

            // datang_tgl
            $this->datang_tgl->setupEditAttributes();
            $this->datang_tgl->EditValue = HtmlEncode(FormatDateTime($this->datang_tgl->CurrentValue, $this->datang_tgl->formatPattern()));
            $this->datang_tgl->PlaceHolder = RemoveHtml($this->datang_tgl->caption());

            // datang_sumber
            $curVal = trim(strval($this->datang_sumber->CurrentValue));
            if ($curVal != "") {
                $this->datang_sumber->ViewValue = $this->datang_sumber->lookupCacheOption($curVal);
            } else {
                $this->datang_sumber->ViewValue = $this->datang_sumber->Lookup !== null && is_array($this->datang_sumber->lookupOptions()) && count($this->datang_sumber->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->datang_sumber->ViewValue !== null) { // Load from cache
                $this->datang_sumber->EditValue = array_values($this->datang_sumber->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`ds_id`", "=", $this->datang_sumber->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->datang_sumber->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->datang_sumber->EditValue = $arwrk;
            }
            $this->datang_sumber->PlaceHolder = RemoveHtml($this->datang_sumber->caption());

            // k_id
            $this->k_id->setupEditAttributes();
            $this->k_id->EditValue = HtmlEncode($this->k_id->CurrentValue);
            $this->k_id->PlaceHolder = RemoveHtml($this->k_id->caption());

            // sup_id
            $this->sup_id->setupEditAttributes();
            $this->sup_id->EditValue = HtmlEncode($this->sup_id->CurrentValue);
            $curVal = strval($this->sup_id->CurrentValue);
            if ($curVal != "") {
                $this->sup_id->EditValue = $this->sup_id->lookupCacheOption($curVal);
                if ($this->sup_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter("`sup_id`", "=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->sup_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCacheImpl($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->sup_id->Lookup->renderViewRow($rswrk[0]);
                        $this->sup_id->EditValue = $this->sup_id->displayValue($arwrk);
                    } else {
                        $this->sup_id->EditValue = HtmlEncode($this->sup_id->CurrentValue);
                    }
                }
            } else {
                $this->sup_id->EditValue = null;
            }
            $this->sup_id->PlaceHolder = RemoveHtml($this->sup_id->caption());

            // var_id
            $this->var_id->setupEditAttributes();
            $curVal = trim(strval($this->var_id->CurrentValue));
            if ($curVal != "") {
                $this->var_id->ViewValue = $this->var_id->lookupCacheOption($curVal);
            } else {
                $this->var_id->ViewValue = $this->var_id->Lookup !== null && is_array($this->var_id->lookupOptions()) && count($this->var_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->var_id->ViewValue !== null) { // Load from cache
                $this->var_id->EditValue = array_values($this->var_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter("`var_id`", "=", $this->var_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->var_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCacheImpl($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->var_id->EditValue = $arwrk;
            }
            $this->var_id->PlaceHolder = RemoveHtml($this->var_id->caption());

            // datang_jumlah
            $this->datang_jumlah->setupEditAttributes();
            $this->datang_jumlah->EditValue = HtmlEncode($this->datang_jumlah->CurrentValue);
            $this->datang_jumlah->PlaceHolder = RemoveHtml($this->datang_jumlah->caption());
            if (strval($this->datang_jumlah->EditValue) != "" && is_numeric($this->datang_jumlah->EditValue)) {
                $this->datang_jumlah->EditValue = $this->datang_jumlah->EditValue;
            }

            // datang_terpakai
            $this->datang_terpakai->setupEditAttributes();
            $this->datang_terpakai->EditValue = HtmlEncode($this->datang_terpakai->CurrentValue);
            $this->datang_terpakai->PlaceHolder = RemoveHtml($this->datang_terpakai->caption());
            if (strval($this->datang_terpakai->EditValue) != "" && is_numeric($this->datang_terpakai->EditValue)) {
                $this->datang_terpakai->EditValue = $this->datang_terpakai->EditValue;
            }

            // po_id
            $this->po_id->setupEditAttributes();
            $this->po_id->EditValue = HtmlEncode($this->po_id->CurrentValue);
            $this->po_id->PlaceHolder = RemoveHtml($this->po_id->caption());
            if (strval($this->po_id->EditValue) != "" && is_numeric($this->po_id->EditValue)) {
                $this->po_id->EditValue = FormatNumber($this->po_id->EditValue, null);
            }

            // Add refer script

            // datang_id
            $this->datang_id->HrefValue = "";

            // datang_tgl
            $this->datang_tgl->HrefValue = "";

            // datang_sumber
            $this->datang_sumber->HrefValue = "";

            // k_id
            $this->k_id->HrefValue = "";

            // sup_id
            $this->sup_id->HrefValue = "";

            // var_id
            $this->var_id->HrefValue = "";

            // datang_jumlah
            $this->datang_jumlah->HrefValue = "";

            // datang_terpakai
            $this->datang_terpakai->HrefValue = "";

            // po_id
            $this->po_id->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->datang_id->Visible && $this->datang_id->Required) {
            if (!$this->datang_id->IsDetailKey && EmptyValue($this->datang_id->FormValue)) {
                $this->datang_id->addErrorMessage(str_replace("%s", $this->datang_id->caption(), $this->datang_id->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->datang_id->FormValue)) {
            $this->datang_id->addErrorMessage($this->datang_id->getErrorMessage(false));
        }
        if ($this->datang_tgl->Visible && $this->datang_tgl->Required) {
            if (!$this->datang_tgl->IsDetailKey && EmptyValue($this->datang_tgl->FormValue)) {
                $this->datang_tgl->addErrorMessage(str_replace("%s", $this->datang_tgl->caption(), $this->datang_tgl->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->datang_tgl->FormValue, $this->datang_tgl->formatPattern())) {
            $this->datang_tgl->addErrorMessage($this->datang_tgl->getErrorMessage(false));
        }
        if ($this->datang_sumber->Visible && $this->datang_sumber->Required) {
            if ($this->datang_sumber->FormValue == "") {
                $this->datang_sumber->addErrorMessage(str_replace("%s", $this->datang_sumber->caption(), $this->datang_sumber->RequiredErrorMessage));
            }
        }
        if ($this->k_id->Visible && $this->k_id->Required) {
            if (!$this->k_id->IsDetailKey && EmptyValue($this->k_id->FormValue)) {
                $this->k_id->addErrorMessage(str_replace("%s", $this->k_id->caption(), $this->k_id->RequiredErrorMessage));
            }
        }
        if ($this->sup_id->Visible && $this->sup_id->Required) {
            if (!$this->sup_id->IsDetailKey && EmptyValue($this->sup_id->FormValue)) {
                $this->sup_id->addErrorMessage(str_replace("%s", $this->sup_id->caption(), $this->sup_id->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->sup_id->FormValue)) {
            $this->sup_id->addErrorMessage($this->sup_id->getErrorMessage(false));
        }
        if ($this->var_id->Visible && $this->var_id->Required) {
            if (!$this->var_id->IsDetailKey && EmptyValue($this->var_id->FormValue)) {
                $this->var_id->addErrorMessage(str_replace("%s", $this->var_id->caption(), $this->var_id->RequiredErrorMessage));
            }
        }
        if ($this->datang_jumlah->Visible && $this->datang_jumlah->Required) {
            if (!$this->datang_jumlah->IsDetailKey && EmptyValue($this->datang_jumlah->FormValue)) {
                $this->datang_jumlah->addErrorMessage(str_replace("%s", $this->datang_jumlah->caption(), $this->datang_jumlah->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->datang_jumlah->FormValue)) {
            $this->datang_jumlah->addErrorMessage($this->datang_jumlah->getErrorMessage(false));
        }
        if ($this->datang_terpakai->Visible && $this->datang_terpakai->Required) {
            if (!$this->datang_terpakai->IsDetailKey && EmptyValue($this->datang_terpakai->FormValue)) {
                $this->datang_terpakai->addErrorMessage(str_replace("%s", $this->datang_terpakai->caption(), $this->datang_terpakai->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->datang_terpakai->FormValue)) {
            $this->datang_terpakai->addErrorMessage($this->datang_terpakai->getErrorMessage(false));
        }
        if ($this->po_id->Visible && $this->po_id->Required) {
            if (!$this->po_id->IsDetailKey && EmptyValue($this->po_id->FormValue)) {
                $this->po_id->addErrorMessage(str_replace("%s", $this->po_id->caption(), $this->po_id->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->po_id->FormValue)) {
            $this->po_id->addErrorMessage($this->po_id->getErrorMessage(false));
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set new row
        $rsnew = [];

        // datang_id
        $this->datang_id->setDbValueDef($rsnew, $this->datang_id->CurrentValue, false);

        // datang_tgl
        $this->datang_tgl->setDbValueDef($rsnew, UnFormatDateTime($this->datang_tgl->CurrentValue, $this->datang_tgl->formatPattern()), false);

        // datang_sumber
        $this->datang_sumber->setDbValueDef($rsnew, $this->datang_sumber->CurrentValue, false);

        // k_id
        $this->k_id->setDbValueDef($rsnew, $this->k_id->CurrentValue, false);

        // sup_id
        $this->sup_id->setDbValueDef($rsnew, $this->sup_id->CurrentValue, false);

        // var_id
        $this->var_id->setDbValueDef($rsnew, $this->var_id->CurrentValue, false);

        // datang_jumlah
        $this->datang_jumlah->setDbValueDef($rsnew, $this->datang_jumlah->CurrentValue, false);

        // datang_terpakai
        $this->datang_terpakai->setDbValueDef($rsnew, $this->datang_terpakai->CurrentValue, false);

        // po_id
        $this->po_id->setDbValueDef($rsnew, $this->po_id->CurrentValue, false);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->datang_id->CurrentValue != "") { // Check field with unique index
            $filter = "(`datang_id` = " . AdjustSql($this->datang_id->CurrentValue, $this->Dbid) . ")";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->datang_id->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->datang_id->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);

        // Check if key value entered
        if ($insertRow && $this->ValidateKey && strval($rsnew['datang_id']) == "") {
            $this->setFailureMessage($Language->phrase("InvalidKeyValue"));
            $insertRow = false;
        }

        // Check for duplicate key
        if ($insertRow && $this->ValidateKey) {
            $filter = $this->getRecordFilter($rsnew);
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
                $this->setFailureMessage($keyErrMsg);
                $insertRow = false;
            }
        }
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("KedatanganList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_datang_sumber":
                    break;
                case "x_k_id":
                    break;
                case "x_sup_id":
                    break;
                case "x_var_id":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
