<?php

// Global variable for table object
$verifikasi = NULL;

//
// Table class for verifikasi
//
class cverifikasi extends cTable {
	var $ver_id;
	var $qc_id;
	var $datang_id;
	var $ver_tgl;
	var $ver_presentasi_rijek;
	var $ver_hasil_id;
	var $ver_foto;
	var $ver_catatan;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'verifikasi';
		$this->TableName = 'verifikasi';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`verifikasi`";
		$this->DBID = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PHPExcel only)
		$this->ExportExcelPageSize = ""; // Page size (PHPExcel only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// ver_id
		$this->ver_id = new cField('verifikasi', 'verifikasi', 'x_ver_id', 'ver_id', '`ver_id`', '`ver_id`', 3, -1, FALSE, '`ver_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->ver_id->Sortable = TRUE; // Allow sort
		$this->ver_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['ver_id'] = &$this->ver_id;

		// qc_id
		$this->qc_id = new cField('verifikasi', 'verifikasi', 'x_qc_id', 'qc_id', '`qc_id`', '`qc_id`', 3, -1, FALSE, '`qc_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->qc_id->Sortable = TRUE; // Allow sort
		$this->qc_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->qc_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->qc_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['qc_id'] = &$this->qc_id;

		// datang_id
		$this->datang_id = new cField('verifikasi', 'verifikasi', 'x_datang_id', 'datang_id', '`datang_id`', '`datang_id`', 3, -1, FALSE, '`datang_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->datang_id->Sortable = TRUE; // Allow sort
		$this->datang_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->datang_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->datang_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['datang_id'] = &$this->datang_id;

		// ver_tgl
		$this->ver_tgl = new cField('verifikasi', 'verifikasi', 'x_ver_tgl', 'ver_tgl', '`ver_tgl`', ew_CastDateFieldForLike('`ver_tgl`', 0, "DB"), 135, 0, FALSE, '`ver_tgl`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ver_tgl->Sortable = TRUE; // Allow sort
		$this->ver_tgl->FldDefaultErrMsg = str_replace("%s", $GLOBALS["EW_DATE_FORMAT"], $Language->Phrase("IncorrectDate"));
		$this->fields['ver_tgl'] = &$this->ver_tgl;

		// ver_presentasi_rijek
		$this->ver_presentasi_rijek = new cField('verifikasi', 'verifikasi', 'x_ver_presentasi_rijek', 'ver_presentasi_rijek', '`ver_presentasi_rijek`', '`ver_presentasi_rijek`', 3, -1, FALSE, '`ver_presentasi_rijek`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ver_presentasi_rijek->Sortable = TRUE; // Allow sort
		$this->ver_presentasi_rijek->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['ver_presentasi_rijek'] = &$this->ver_presentasi_rijek;

		// ver_hasil_id
		$this->ver_hasil_id = new cField('verifikasi', 'verifikasi', 'x_ver_hasil_id', 'ver_hasil_id', '`ver_hasil_id`', '`ver_hasil_id`', 200, -1, FALSE, '`ver_hasil_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ver_hasil_id->Sortable = TRUE; // Allow sort
		$this->ver_hasil_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ver_hasil_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->fields['ver_hasil_id'] = &$this->ver_hasil_id;

		// ver_foto
		$this->ver_foto = new cField('verifikasi', 'verifikasi', 'x_ver_foto', 'ver_foto', '`ver_foto`', '`ver_foto`', 200, -1, TRUE, '`ver_foto`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->ver_foto->Sortable = TRUE; // Allow sort
		$this->ver_foto->ImageResize = TRUE;
		$this->ver_foto->UploadMultiple = TRUE;
		$this->ver_foto->Upload->UploadMultiple = TRUE;
		$this->ver_foto->UploadMaxFileCount = 0;
		$this->fields['ver_foto'] = &$this->ver_foto;

		// ver_catatan
		$this->ver_catatan = new cField('verifikasi', 'verifikasi', 'x_ver_catatan', 'ver_catatan', '`ver_catatan`', '`ver_catatan`', 201, -1, FALSE, '`ver_catatan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->ver_catatan->Sortable = TRUE; // Allow sort
		$this->fields['ver_catatan'] = &$this->ver_catatan;
	}

	// Field Visibility
	function GetFieldVisibility($fldparm) {
		global $Security;
		return $this->$fldparm->Visible; // Returns original value
	}

	// Column CSS classes
	var $LeftColumnClass = "col-sm-2 control-label ewLabel";
	var $RightColumnClass = "col-sm-10";
	var $OffsetColumnClass = "col-sm-10 col-sm-offset-2";

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function SetLeftColumnClass($class) {
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " control-label ewLabel";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - intval($match[2]));
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace($match[1], $match[1] + "-offset", $class);
		}
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Table level SQL
	var $_SqlFrom = "";

	function getSqlFrom() { // From
		return ($this->_SqlFrom <> "") ? $this->_SqlFrom : "`verifikasi`";
	}

	function SqlFrom() { // For backward compatibility
		return $this->getSqlFrom();
	}

	function setSqlFrom($v) {
		$this->_SqlFrom = $v;
	}
	var $_SqlSelect = "";

	function getSqlSelect() { // Select
		return ($this->_SqlSelect <> "") ? $this->_SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}

	function SqlSelect() { // For backward compatibility
		return $this->getSqlSelect();
	}

	function setSqlSelect($v) {
		$this->_SqlSelect = $v;
	}
	var $_SqlWhere = "";

	function getSqlWhere() { // Where
		$sWhere = ($this->_SqlWhere <> "") ? $this->_SqlWhere : "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlWhere() { // For backward compatibility
		return $this->getSqlWhere();
	}

	function setSqlWhere($v) {
		$this->_SqlWhere = $v;
	}
	var $_SqlGroupBy = "";

	function getSqlGroupBy() { // Group By
		return ($this->_SqlGroupBy <> "") ? $this->_SqlGroupBy : "";
	}

	function SqlGroupBy() { // For backward compatibility
		return $this->getSqlGroupBy();
	}

	function setSqlGroupBy($v) {
		$this->_SqlGroupBy = $v;
	}
	var $_SqlHaving = "";

	function getSqlHaving() { // Having
		return ($this->_SqlHaving <> "") ? $this->_SqlHaving : "";
	}

	function SqlHaving() { // For backward compatibility
		return $this->getSqlHaving();
	}

	function setSqlHaving($v) {
		$this->_SqlHaving = $v;
	}
	var $_SqlOrderBy = "";

	function getSqlOrderBy() { // Order By
		return ($this->_SqlOrderBy <> "") ? $this->_SqlOrderBy : "";
	}

	function SqlOrderBy() { // For backward compatibility
		return $this->getSqlOrderBy();
	}

	function setSqlOrderBy($v) {
		$this->_SqlOrderBy = $v;
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = EW_USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$filter = $this->CurrentFilter;
		$filter = $this->ApplyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->GetSQL($filter, $sort);
	}

	// Table SQL with List page filter
	var $UseSessionForListSQL = TRUE;

	function ListSQL() {
		$sFilter = $this->UseSessionForListSQL ? $this->getSessionWhere() : "";
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$this->Recordset_Selecting($sFilter);
		$sSelect = $this->getSqlSelect();
		$sSort = $this->UseSessionForListSQL ? $this->getSessionOrderBy() : "";
		return ew_BuildSelectSql($sSelect, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sSort);
	}

	// Try to get record count
	function TryGetRecordCount($sql) {
		$cnt = -1;
		$pattern = "/^SELECT \* FROM/i";
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') && preg_match($pattern, $sql)) {
			$sql = "SELECT COUNT(*) FROM" . preg_replace($pattern, "", $sql);
		} else {
			$sql = "SELECT COUNT(*) FROM (" . $sql . ") EW_COUNT_TABLE";
		}
		$conn = &$this->Connection();
		if ($rs = $conn->Execute($sql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($filter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = ew_BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function ListRecordCount() {
		$filter = $this->getSessionWhere();
		ew_AddFilter($filter, $this->CurrentFilter);
		$filter = $this->ApplyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = ew_BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->TryGetRecordCount($sql);
		if ($cnt == -1) {
			$conn = &$this->Connection();
			if ($rs = $conn->Execute($sql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// INSERT statement
	function InsertSQL(&$rs) {
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		$conn = &$this->Connection();
		$bInsert = $conn->Execute($this->InsertSQL($rs));
		if ($bInsert) {

			// Get insert id if necessary
			$this->ver_id->setDbValue($conn->Insert_ID());
			$rs['ver_id'] = $this->ver_id->DbValue;
		}
		return $bInsert;
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE) {
		$conn = &$this->Connection();
		$bUpdate = $conn->Execute($this->UpdateSQL($rs, $where, $curfilter));
		return $bUpdate;
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		if ($rs) {
			if (array_key_exists('ver_id', $rs))
				ew_AddFilter($where, ew_QuotedName('ver_id', $this->DBID) . '=' . ew_QuotedValue($rs['ver_id'], $this->ver_id->FldDataType, $this->DBID));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "", $curfilter = TRUE) {
		$bDelete = TRUE;
		$conn = &$this->Connection();
		if ($bDelete)
			$bDelete = $conn->Execute($this->DeleteSQL($rs, $where, $curfilter));
		return $bDelete;
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "`ver_id` = @ver_id@";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		if (!is_numeric($this->ver_id->CurrentValue))
			return "0=1"; // Invalid key
		if (is_null($this->ver_id->CurrentValue))
			return "0=1"; // Invalid key
		else
			$sKeyFilter = str_replace("@ver_id@", ew_AdjustSql($this->ver_id->CurrentValue, $this->DBID), $sKeyFilter); // Replace key value
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "verifikasilist.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	function GetModalCaption($pageName) {
		global $Language;
		if ($pageName == "verifikasiview.php")
			return $Language->Phrase("View");
		elseif ($pageName == "verifikasiedit.php")
			return $Language->Phrase("Edit");
		elseif ($pageName == "verifikasiadd.php")
			return $Language->Phrase("Add");
		else
			return "";
	}

	// List URL
	function GetListUrl() {
		return "verifikasilist.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			$url = $this->KeyUrl("verifikasiview.php", $this->UrlParm($parm));
		else
			$url = $this->KeyUrl("verifikasiview.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
		return $this->AddMasterUrl($url);
	}

	// Add URL
	function GetAddUrl($parm = "") {
		if ($parm <> "")
			$url = "verifikasiadd.php?" . $this->UrlParm($parm);
		else
			$url = "verifikasiadd.php";
		return $this->AddMasterUrl($url);
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		$url = $this->KeyUrl("verifikasiedit.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
		return $this->AddMasterUrl($url);
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		$url = $this->KeyUrl("verifikasiadd.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
		return $this->AddMasterUrl($url);
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("verifikasidelete.php", $this->UrlParm());
	}

	// Add master url
	function AddMasterUrl($url) {
		return $url;
	}

	function KeyToJson() {
		$json = "";
		$json .= "ver_id:" . ew_VarToJson($this->ver_id->CurrentValue, "number", "'");
		return "{" . $json . "}";
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->ver_id->CurrentValue)) {
			$sUrl .= "ver_id=" . urlencode($this->ver_id->CurrentValue);
		} else {
			return "javascript:ew_Alert(ewLanguage.Phrase('InvalidRecord'));";
		}
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&amp;ordertype=" . $fld->ReverseSort());
			return $this->AddMasterUrl(ew_CurrentPage() . "?" . $sUrlParm);
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = $_POST["key_m"];
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = $_GET["key_m"];
			$cnt = count($arKeys);
		} elseif (!empty($_GET) || !empty($_POST)) {
			$isPost = ew_IsPost();
			if ($isPost && isset($_POST["ver_id"]))
				$arKeys[] = $_POST["ver_id"];
			elseif (isset($_GET["ver_id"]))
				$arKeys[] = $_GET["ver_id"];
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$this->ver_id->CurrentValue = $key;
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($filter) {

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $filter;
		//$sql = $this->SQL();

		$sql = $this->GetSQL($filter, "");
		$conn = &$this->Connection();
		$rs = $conn->Execute($sql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->ver_id->setDbValue($rs->fields('ver_id'));
		$this->qc_id->setDbValue($rs->fields('qc_id'));
		$this->datang_id->setDbValue($rs->fields('datang_id'));
		$this->ver_tgl->setDbValue($rs->fields('ver_tgl'));
		$this->ver_presentasi_rijek->setDbValue($rs->fields('ver_presentasi_rijek'));
		$this->ver_hasil_id->setDbValue($rs->fields('ver_hasil_id'));
		$this->ver_foto->Upload->DbValue = $rs->fields('ver_foto');
		$this->ver_catatan->setDbValue($rs->fields('ver_catatan'));
	}

	// Render list row values
	function RenderListRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

	// Common render codes
		// ver_id
		// qc_id
		// datang_id
		// ver_tgl
		// ver_presentasi_rijek
		// ver_hasil_id
		// ver_foto

		$this->ver_foto->CellCssStyle = "width: 200px;";

		// ver_catatan
		// ver_id

		$this->ver_id->ViewValue = $this->ver_id->CurrentValue;
		$this->ver_id->ViewCustomAttributes = "";

		// qc_id
		if (strval($this->qc_id->CurrentValue) <> "") {
			$sFilterWrk = "`qc_id`" . ew_SearchString("=", $this->qc_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `qc_id`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `qc`";
		$sWhereWrk = "";
		$this->qc_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->qc_id->ViewValue = $this->qc_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->qc_id->ViewValue = $this->qc_id->CurrentValue;
			}
		} else {
			$this->qc_id->ViewValue = NULL;
		}
		$this->qc_id->ViewCustomAttributes = "";

		// datang_id
		if (strval($this->datang_id->CurrentValue) <> "") {
			$sFilterWrk = "`datang_id`" . ew_SearchString("=", $this->datang_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `datang_id`, `datang_id` AS `DispFld`, `datang_jumlah` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kedatangan`";
		$sWhereWrk = "";
		$this->datang_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->datang_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `datang_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->datang_id->ViewValue = $this->datang_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->datang_id->ViewValue = $this->datang_id->CurrentValue;
			}
		} else {
			$this->datang_id->ViewValue = NULL;
		}
		$this->datang_id->ViewCustomAttributes = "";

		// ver_tgl
		$this->ver_tgl->ViewValue = $this->ver_tgl->CurrentValue;
		$this->ver_tgl->ViewValue = ew_FormatDateTime($this->ver_tgl->ViewValue, 0);
		$this->ver_tgl->ViewCustomAttributes = "";

		// ver_presentasi_rijek
		$this->ver_presentasi_rijek->ViewValue = $this->ver_presentasi_rijek->CurrentValue;
		$this->ver_presentasi_rijek->ViewCustomAttributes = "";

		// ver_hasil_id
		if (strval($this->ver_hasil_id->CurrentValue) <> "") {
			$sFilterWrk = "`vh_id`" . ew_SearchString("=", $this->ver_hasil_id->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `vh_id`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `verifikasi_hasil`";
		$sWhereWrk = "";
		$this->ver_hasil_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `vh_id` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->CurrentValue;
			}
		} else {
			$this->ver_hasil_id->ViewValue = NULL;
		}
		$this->ver_hasil_id->ViewCustomAttributes = "";

		// ver_foto
		if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
			$this->ver_foto->ImageWidth = 200;
			$this->ver_foto->ImageHeight = 100;
			$this->ver_foto->ImageAlt = $this->ver_foto->FldAlt();
			$this->ver_foto->ViewValue = $this->ver_foto->Upload->DbValue;
		} else {
			$this->ver_foto->ViewValue = "";
		}
		$this->ver_foto->ViewCustomAttributes = "";

		// ver_catatan
		$this->ver_catatan->ViewValue = $this->ver_catatan->CurrentValue;
		$this->ver_catatan->ViewCustomAttributes = "";

		// ver_id
		$this->ver_id->LinkCustomAttributes = "";
		$this->ver_id->HrefValue = "";
		$this->ver_id->TooltipValue = "";

		// qc_id
		$this->qc_id->LinkCustomAttributes = "";
		$this->qc_id->HrefValue = "";
		$this->qc_id->TooltipValue = "";

		// datang_id
		$this->datang_id->LinkCustomAttributes = "";
		$this->datang_id->HrefValue = "";
		$this->datang_id->TooltipValue = "";

		// ver_tgl
		$this->ver_tgl->LinkCustomAttributes = "";
		$this->ver_tgl->HrefValue = "";
		$this->ver_tgl->TooltipValue = "";

		// ver_presentasi_rijek
		$this->ver_presentasi_rijek->LinkCustomAttributes = "";
		$this->ver_presentasi_rijek->HrefValue = "";
		$this->ver_presentasi_rijek->TooltipValue = "";

		// ver_hasil_id
		$this->ver_hasil_id->LinkCustomAttributes = "";
		$this->ver_hasil_id->HrefValue = "";
		$this->ver_hasil_id->TooltipValue = "";

		// ver_foto
		$this->ver_foto->LinkCustomAttributes = "";
		if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
			$this->ver_foto->HrefValue = "%u"; // Add prefix/suffix
			$this->ver_foto->LinkAttrs["target"] = ""; // Add target
			if ($this->Export <> "") $this->ver_foto->HrefValue = ew_FullUrl($this->ver_foto->HrefValue, "href");
		} else {
			$this->ver_foto->HrefValue = "";
		}
		$this->ver_foto->HrefValue2 = $this->ver_foto->UploadPath . $this->ver_foto->Upload->DbValue;
		$this->ver_foto->TooltipValue = "";
		if ($this->ver_foto->UseColorbox) {
			if (ew_Empty($this->ver_foto->TooltipValue))
				$this->ver_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
			$this->ver_foto->LinkAttrs["data-rel"] = "verifikasi_x_ver_foto";
			ew_AppendClass($this->ver_foto->LinkAttrs["class"], "ewLightbox");
		}

		// ver_catatan
		$this->ver_catatan->LinkCustomAttributes = "";
		$this->ver_catatan->HrefValue = "";
		$this->ver_catatan->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->CustomTemplateFieldValues();
	}

	// Render edit row values
	function RenderEditRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// ver_id
		$this->ver_id->EditAttrs["class"] = "form-control";
		$this->ver_id->EditCustomAttributes = "";
		$this->ver_id->EditValue = $this->ver_id->CurrentValue;
		$this->ver_id->ViewCustomAttributes = "";

		// qc_id
		$this->qc_id->EditAttrs["class"] = "form-control";
		$this->qc_id->EditCustomAttributes = "";

		// datang_id
		$this->datang_id->EditAttrs["class"] = "form-control";
		$this->datang_id->EditCustomAttributes = "";

		// ver_tgl
		$this->ver_tgl->EditAttrs["class"] = "form-control";
		$this->ver_tgl->EditCustomAttributes = "";
		$this->ver_tgl->EditValue = ew_FormatDateTime($this->ver_tgl->CurrentValue, 8);
		$this->ver_tgl->PlaceHolder = ew_RemoveHtml($this->ver_tgl->FldCaption());

		// ver_presentasi_rijek
		$this->ver_presentasi_rijek->EditAttrs["class"] = "form-control";
		$this->ver_presentasi_rijek->EditCustomAttributes = "";
		$this->ver_presentasi_rijek->EditValue = $this->ver_presentasi_rijek->CurrentValue;
		$this->ver_presentasi_rijek->PlaceHolder = ew_RemoveHtml($this->ver_presentasi_rijek->FldCaption());

		// ver_hasil_id
		$this->ver_hasil_id->EditAttrs["class"] = "form-control";
		$this->ver_hasil_id->EditCustomAttributes = "";

		// ver_foto
		$this->ver_foto->EditAttrs["class"] = "form-control";
		$this->ver_foto->EditCustomAttributes = "";
		if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
			$this->ver_foto->ImageWidth = 200;
			$this->ver_foto->ImageHeight = 100;
			$this->ver_foto->ImageAlt = $this->ver_foto->FldAlt();
			$this->ver_foto->EditValue = $this->ver_foto->Upload->DbValue;
		} else {
			$this->ver_foto->EditValue = "";
		}
		if (!ew_Empty($this->ver_foto->CurrentValue))
				$this->ver_foto->Upload->FileName = $this->ver_foto->CurrentValue;

		// ver_catatan
		$this->ver_catatan->EditAttrs["class"] = "form-control";
		$this->ver_catatan->EditCustomAttributes = "";
		$this->ver_catatan->EditValue = $this->ver_catatan->CurrentValue;
		$this->ver_catatan->PlaceHolder = ew_RemoveHtml($this->ver_catatan->FldCaption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {

		// Call Row Rendered event
		$this->Row_Rendered();
	}
	var $ExportDoc;

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;
		if (!$Doc->ExportCustom) {

			// Write header
			$Doc->ExportTableHeader();
			if ($Doc->Horizontal) { // Horizontal format, write header
				$Doc->BeginExportRow();
				if ($ExportPageType == "view") {
					if ($this->ver_id->Exportable) $Doc->ExportCaption($this->ver_id);
					if ($this->qc_id->Exportable) $Doc->ExportCaption($this->qc_id);
					if ($this->datang_id->Exportable) $Doc->ExportCaption($this->datang_id);
					if ($this->ver_tgl->Exportable) $Doc->ExportCaption($this->ver_tgl);
					if ($this->ver_presentasi_rijek->Exportable) $Doc->ExportCaption($this->ver_presentasi_rijek);
					if ($this->ver_hasil_id->Exportable) $Doc->ExportCaption($this->ver_hasil_id);
					if ($this->ver_foto->Exportable) $Doc->ExportCaption($this->ver_foto);
					if ($this->ver_catatan->Exportable) $Doc->ExportCaption($this->ver_catatan);
				} else {
					if ($this->ver_id->Exportable) $Doc->ExportCaption($this->ver_id);
					if ($this->qc_id->Exportable) $Doc->ExportCaption($this->qc_id);
					if ($this->datang_id->Exportable) $Doc->ExportCaption($this->datang_id);
					if ($this->ver_tgl->Exportable) $Doc->ExportCaption($this->ver_tgl);
					if ($this->ver_presentasi_rijek->Exportable) $Doc->ExportCaption($this->ver_presentasi_rijek);
					if ($this->ver_hasil_id->Exportable) $Doc->ExportCaption($this->ver_hasil_id);
					if ($this->ver_foto->Exportable) $Doc->ExportCaption($this->ver_foto);
					if ($this->ver_catatan->Exportable) $Doc->ExportCaption($this->ver_catatan);
				}
				$Doc->EndExportRow();
			}
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				if (!$Doc->ExportCustom) {
					$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
					if ($ExportPageType == "view") {
						if ($this->ver_id->Exportable) $Doc->ExportField($this->ver_id);
						if ($this->qc_id->Exportable) $Doc->ExportField($this->qc_id);
						if ($this->datang_id->Exportable) $Doc->ExportField($this->datang_id);
						if ($this->ver_tgl->Exportable) $Doc->ExportField($this->ver_tgl);
						if ($this->ver_presentasi_rijek->Exportable) $Doc->ExportField($this->ver_presentasi_rijek);
						if ($this->ver_hasil_id->Exportable) $Doc->ExportField($this->ver_hasil_id);
						if ($this->ver_foto->Exportable) $Doc->ExportField($this->ver_foto);
						if ($this->ver_catatan->Exportable) $Doc->ExportField($this->ver_catatan);
					} else {
						if ($this->ver_id->Exportable) $Doc->ExportField($this->ver_id);
						if ($this->qc_id->Exportable) $Doc->ExportField($this->qc_id);
						if ($this->datang_id->Exportable) $Doc->ExportField($this->datang_id);
						if ($this->ver_tgl->Exportable) $Doc->ExportField($this->ver_tgl);
						if ($this->ver_presentasi_rijek->Exportable) $Doc->ExportField($this->ver_presentasi_rijek);
						if ($this->ver_hasil_id->Exportable) $Doc->ExportField($this->ver_hasil_id);
						if ($this->ver_foto->Exportable) $Doc->ExportField($this->ver_foto);
						if ($this->ver_catatan->Exportable) $Doc->ExportField($this->ver_catatan);
					}
					$Doc->EndExportRow($RowCnt);
				}
			}

			// Call Row Export server event
			if ($Doc->ExportCustom)
				$this->Row_Export($Recordset->fields);
			$Recordset->MoveNext();
		}
		if (!$Doc->ExportCustom) {
			$Doc->ExportTableFooter();
		}
	}

	// Get auto fill value
	function GetAutoFill($id, $val) {
		$rsarr = array();
		$rowcnt = 0;

		// Output
		if (is_array($rsarr) && $rowcnt > 0) {
			$fldcnt = count($rsarr[0]);
			for ($i = 0; $i < $rowcnt; $i++) {
				for ($j = 0; $j < $fldcnt; $j++) {
					$str = strval($rsarr[$i][$j]);
					$str = ew_ConvertToUtf8($str);
					if (isset($post["keepCRLF"])) {
						$str = str_replace(array("\r", "\n"), array("\\r", "\\n"), $str);
					} else {
						$str = str_replace(array("\r", "\n"), array(" ", " "), $str);
					}
					$rsarr[$i][$j] = $str;
				}
			}
			return ew_ArrayToJson($rsarr);
		} else {
			return FALSE;
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->FldName, $fld->LookupFilters, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
