<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "verifikasiinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$verifikasi_add = NULL; // Initialize page object first

class cverifikasi_add extends cverifikasi {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'verifikasi';

	// Page object name
	var $PageObjName = 'verifikasi_add';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (verifikasi)
		if (!isset($GLOBALS["verifikasi"]) || get_class($GLOBALS["verifikasi"]) == "cverifikasi") {
			$GLOBALS["verifikasi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["verifikasi"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'verifikasi', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("verifikasilist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->qc_id->SetVisibility();
		$this->datang_id->SetVisibility();
		$this->ver_tgl->SetVisibility();
		$this->ver_presentasi_rijek->SetVisibility();
		$this->ver_hasil_id->SetVisibility();
		$this->ver_foto->SetVisibility();
		$this->ver_catatan->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $verifikasi;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($verifikasi);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "verifikasiview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewAddForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;
		global $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewAddForm form-horizontal";

		// Set up current action
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["ver_id"] != "") {
				$this->ver_id->setQueryStringValue($_GET["ver_id"]);
				$this->setKey("ver_id", $this->ver_id->CurrentValue); // Set up key
			} else {
				$this->setKey("ver_id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->LoadOldRecord();

		// Load form values
		if (@$_POST["a_add"] <> "") {
			$this->LoadFormValues(); // Load form values
		}

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Blank record
				break;
			case "C": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("verifikasilist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "verifikasilist.php")
						$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
					elseif (ew_GetPageName($sReturnUrl) == "verifikasiview.php")
						$sReturnUrl = $this->GetViewUrl(); // View page, return to View page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD; // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->ver_foto->Upload->Index = $objForm->Index;
		$this->ver_foto->Upload->UploadFile();
		$this->ver_foto->CurrentValue = $this->ver_foto->Upload->FileName;
	}

	// Load default values
	function LoadDefaultValues() {
		$this->ver_id->CurrentValue = NULL;
		$this->ver_id->OldValue = $this->ver_id->CurrentValue;
		$this->qc_id->CurrentValue = NULL;
		$this->qc_id->OldValue = $this->qc_id->CurrentValue;
		$this->datang_id->CurrentValue = NULL;
		$this->datang_id->OldValue = $this->datang_id->CurrentValue;
		$this->ver_tgl->CurrentValue = NULL;
		$this->ver_tgl->OldValue = $this->ver_tgl->CurrentValue;
		$this->ver_presentasi_rijek->CurrentValue = NULL;
		$this->ver_presentasi_rijek->OldValue = $this->ver_presentasi_rijek->CurrentValue;
		$this->ver_hasil_id->CurrentValue = NULL;
		$this->ver_hasil_id->OldValue = $this->ver_hasil_id->CurrentValue;
		$this->ver_foto->Upload->DbValue = NULL;
		$this->ver_foto->OldValue = $this->ver_foto->Upload->DbValue;
		$this->ver_foto->CurrentValue = NULL; // Clear file related field
		$this->ver_catatan->CurrentValue = NULL;
		$this->ver_catatan->OldValue = $this->ver_catatan->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->qc_id->FldIsDetailKey) {
			$this->qc_id->setFormValue($objForm->GetValue("x_qc_id"));
		}
		if (!$this->datang_id->FldIsDetailKey) {
			$this->datang_id->setFormValue($objForm->GetValue("x_datang_id"));
		}
		if (!$this->ver_tgl->FldIsDetailKey) {
			$this->ver_tgl->setFormValue($objForm->GetValue("x_ver_tgl"));
			$this->ver_tgl->CurrentValue = ew_UnFormatDateTime($this->ver_tgl->CurrentValue, 0);
		}
		if (!$this->ver_presentasi_rijek->FldIsDetailKey) {
			$this->ver_presentasi_rijek->setFormValue($objForm->GetValue("x_ver_presentasi_rijek"));
		}
		if (!$this->ver_hasil_id->FldIsDetailKey) {
			$this->ver_hasil_id->setFormValue($objForm->GetValue("x_ver_hasil_id"));
		}
		if (!$this->ver_catatan->FldIsDetailKey) {
			$this->ver_catatan->setFormValue($objForm->GetValue("x_ver_catatan"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->qc_id->CurrentValue = $this->qc_id->FormValue;
		$this->datang_id->CurrentValue = $this->datang_id->FormValue;
		$this->ver_tgl->CurrentValue = $this->ver_tgl->FormValue;
		$this->ver_tgl->CurrentValue = ew_UnFormatDateTime($this->ver_tgl->CurrentValue, 0);
		$this->ver_presentasi_rijek->CurrentValue = $this->ver_presentasi_rijek->FormValue;
		$this->ver_hasil_id->CurrentValue = $this->ver_hasil_id->FormValue;
		$this->ver_catatan->CurrentValue = $this->ver_catatan->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->ver_id->setDbValue($row['ver_id']);
		$this->qc_id->setDbValue($row['qc_id']);
		$this->datang_id->setDbValue($row['datang_id']);
		$this->ver_tgl->setDbValue($row['ver_tgl']);
		$this->ver_presentasi_rijek->setDbValue($row['ver_presentasi_rijek']);
		$this->ver_hasil_id->setDbValue($row['ver_hasil_id']);
		$this->ver_foto->Upload->DbValue = $row['ver_foto'];
		$this->ver_foto->setDbValue($this->ver_foto->Upload->DbValue);
		$this->ver_catatan->setDbValue($row['ver_catatan']);
	}

	// Return a row with default values
	function NewRow() {
		$this->LoadDefaultValues();
		$row = array();
		$row['ver_id'] = $this->ver_id->CurrentValue;
		$row['qc_id'] = $this->qc_id->CurrentValue;
		$row['datang_id'] = $this->datang_id->CurrentValue;
		$row['ver_tgl'] = $this->ver_tgl->CurrentValue;
		$row['ver_presentasi_rijek'] = $this->ver_presentasi_rijek->CurrentValue;
		$row['ver_hasil_id'] = $this->ver_hasil_id->CurrentValue;
		$row['ver_foto'] = $this->ver_foto->Upload->DbValue;
		$row['ver_catatan'] = $this->ver_catatan->CurrentValue;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->ver_id->DbValue = $row['ver_id'];
		$this->qc_id->DbValue = $row['qc_id'];
		$this->datang_id->DbValue = $row['datang_id'];
		$this->ver_tgl->DbValue = $row['ver_tgl'];
		$this->ver_presentasi_rijek->DbValue = $row['ver_presentasi_rijek'];
		$this->ver_hasil_id->DbValue = $row['ver_hasil_id'];
		$this->ver_foto->Upload->DbValue = $row['ver_foto'];
		$this->ver_catatan->DbValue = $row['ver_catatan'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("ver_id")) <> "")
			$this->ver_id->CurrentValue = $this->getKey("ver_id"); // ver_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// ver_id
		// qc_id
		// datang_id
		// ver_tgl
		// ver_presentasi_rijek
		// ver_hasil_id
		// ver_foto
		// ver_catatan

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// ver_id
		$this->ver_id->ViewValue = $this->ver_id->CurrentValue;
		$this->ver_id->ViewCustomAttributes = "";

		// qc_id
		if (strval($this->qc_id->CurrentValue) <> "") {
			$sFilterWrk = "`qc_id`" . ew_SearchString("=", $this->qc_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `qc_id`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `qc`";
		$sWhereWrk = "";
		$this->qc_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->qc_id->ViewValue = $this->qc_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->qc_id->ViewValue = $this->qc_id->CurrentValue;
			}
		} else {
			$this->qc_id->ViewValue = NULL;
		}
		$this->qc_id->ViewCustomAttributes = "";

		// datang_id
		if (strval($this->datang_id->CurrentValue) <> "") {
			$sFilterWrk = "`datang_id`" . ew_SearchString("=", $this->datang_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `datang_id`, `datang_id` AS `DispFld`, `datang_jumlah` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kedatangan`";
		$sWhereWrk = "";
		$this->datang_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->datang_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `datang_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->datang_id->ViewValue = $this->datang_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->datang_id->ViewValue = $this->datang_id->CurrentValue;
			}
		} else {
			$this->datang_id->ViewValue = NULL;
		}
		$this->datang_id->ViewCustomAttributes = "";

		// ver_tgl
		$this->ver_tgl->ViewValue = $this->ver_tgl->CurrentValue;
		$this->ver_tgl->ViewValue = ew_FormatDateTime($this->ver_tgl->ViewValue, 0);
		$this->ver_tgl->ViewCustomAttributes = "";

		// ver_presentasi_rijek
		$this->ver_presentasi_rijek->ViewValue = $this->ver_presentasi_rijek->CurrentValue;
		$this->ver_presentasi_rijek->ViewCustomAttributes = "";

		// ver_hasil_id
		if (strval($this->ver_hasil_id->CurrentValue) <> "") {
			$sFilterWrk = "`vh_id`" . ew_SearchString("=", $this->ver_hasil_id->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `vh_id`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `verifikasi_hasil`";
		$sWhereWrk = "";
		$this->ver_hasil_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `vh_id` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ver_hasil_id->ViewValue = $this->ver_hasil_id->CurrentValue;
			}
		} else {
			$this->ver_hasil_id->ViewValue = NULL;
		}
		$this->ver_hasil_id->ViewCustomAttributes = "";

		// ver_foto
		if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
			$this->ver_foto->ImageWidth = 200;
			$this->ver_foto->ImageHeight = 100;
			$this->ver_foto->ImageAlt = $this->ver_foto->FldAlt();
			$this->ver_foto->ViewValue = $this->ver_foto->Upload->DbValue;
		} else {
			$this->ver_foto->ViewValue = "";
		}
		$this->ver_foto->ViewCustomAttributes = "";

		// ver_catatan
		$this->ver_catatan->ViewValue = $this->ver_catatan->CurrentValue;
		$this->ver_catatan->ViewCustomAttributes = "";

			// qc_id
			$this->qc_id->LinkCustomAttributes = "";
			$this->qc_id->HrefValue = "";
			$this->qc_id->TooltipValue = "";

			// datang_id
			$this->datang_id->LinkCustomAttributes = "";
			$this->datang_id->HrefValue = "";
			$this->datang_id->TooltipValue = "";

			// ver_tgl
			$this->ver_tgl->LinkCustomAttributes = "";
			$this->ver_tgl->HrefValue = "";
			$this->ver_tgl->TooltipValue = "";

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->LinkCustomAttributes = "";
			$this->ver_presentasi_rijek->HrefValue = "";
			$this->ver_presentasi_rijek->TooltipValue = "";

			// ver_hasil_id
			$this->ver_hasil_id->LinkCustomAttributes = "";
			$this->ver_hasil_id->HrefValue = "";
			$this->ver_hasil_id->TooltipValue = "";

			// ver_foto
			$this->ver_foto->LinkCustomAttributes = "";
			if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
				$this->ver_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->ver_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->ver_foto->HrefValue = ew_FullUrl($this->ver_foto->HrefValue, "href");
			} else {
				$this->ver_foto->HrefValue = "";
			}
			$this->ver_foto->HrefValue2 = $this->ver_foto->UploadPath . $this->ver_foto->Upload->DbValue;
			$this->ver_foto->TooltipValue = "";
			if ($this->ver_foto->UseColorbox) {
				if (ew_Empty($this->ver_foto->TooltipValue))
					$this->ver_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->ver_foto->LinkAttrs["data-rel"] = "verifikasi_x_ver_foto";
				ew_AppendClass($this->ver_foto->LinkAttrs["class"], "ewLightbox");
			}

			// ver_catatan
			$this->ver_catatan->LinkCustomAttributes = "";
			$this->ver_catatan->HrefValue = "";
			$this->ver_catatan->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// qc_id
			$this->qc_id->EditAttrs["class"] = "form-control";
			$this->qc_id->EditCustomAttributes = "";
			if (trim(strval($this->qc_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`qc_id`" . ew_SearchString("=", $this->qc_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `qc_id`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `qc`";
			$sWhereWrk = "";
			$this->qc_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->qc_id->EditValue = $arwrk;

			// datang_id
			$this->datang_id->EditAttrs["class"] = "form-control";
			$this->datang_id->EditCustomAttributes = "";
			if (trim(strval($this->datang_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`datang_id`" . ew_SearchString("=", $this->datang_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `datang_id`, `datang_id` AS `DispFld`, `datang_jumlah` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kedatangan`";
			$sWhereWrk = "";
			$this->datang_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->datang_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `datang_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->datang_id->EditValue = $arwrk;

			// ver_tgl
			$this->ver_tgl->EditAttrs["class"] = "form-control";
			$this->ver_tgl->EditCustomAttributes = "";
			$this->ver_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->ver_tgl->CurrentValue, 8));
			$this->ver_tgl->PlaceHolder = ew_RemoveHtml($this->ver_tgl->FldCaption());

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->EditAttrs["class"] = "form-control";
			$this->ver_presentasi_rijek->EditCustomAttributes = "";
			$this->ver_presentasi_rijek->EditValue = ew_HtmlEncode($this->ver_presentasi_rijek->CurrentValue);
			$this->ver_presentasi_rijek->PlaceHolder = ew_RemoveHtml($this->ver_presentasi_rijek->FldCaption());

			// ver_hasil_id
			$this->ver_hasil_id->EditAttrs["class"] = "form-control";
			$this->ver_hasil_id->EditCustomAttributes = "";
			if (trim(strval($this->ver_hasil_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`vh_id`" . ew_SearchString("=", $this->ver_hasil_id->CurrentValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `vh_id`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `verifikasi_hasil`";
			$sWhereWrk = "";
			$this->ver_hasil_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `vh_id` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ver_hasil_id->EditValue = $arwrk;

			// ver_foto
			$this->ver_foto->EditAttrs["class"] = "form-control";
			$this->ver_foto->EditCustomAttributes = "";
			if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
				$this->ver_foto->ImageWidth = 200;
				$this->ver_foto->ImageHeight = 100;
				$this->ver_foto->ImageAlt = $this->ver_foto->FldAlt();
				$this->ver_foto->EditValue = $this->ver_foto->Upload->DbValue;
			} else {
				$this->ver_foto->EditValue = "";
			}
			if (!ew_Empty($this->ver_foto->CurrentValue))
					$this->ver_foto->Upload->FileName = $this->ver_foto->CurrentValue;
			if (($this->CurrentAction == "I" || $this->CurrentAction == "C") && !$this->EventCancelled) ew_RenderUploadField($this->ver_foto);

			// ver_catatan
			$this->ver_catatan->EditAttrs["class"] = "form-control";
			$this->ver_catatan->EditCustomAttributes = "";
			$this->ver_catatan->EditValue = ew_HtmlEncode($this->ver_catatan->CurrentValue);
			$this->ver_catatan->PlaceHolder = ew_RemoveHtml($this->ver_catatan->FldCaption());

			// Add refer script
			// qc_id

			$this->qc_id->LinkCustomAttributes = "";
			$this->qc_id->HrefValue = "";

			// datang_id
			$this->datang_id->LinkCustomAttributes = "";
			$this->datang_id->HrefValue = "";

			// ver_tgl
			$this->ver_tgl->LinkCustomAttributes = "";
			$this->ver_tgl->HrefValue = "";

			// ver_presentasi_rijek
			$this->ver_presentasi_rijek->LinkCustomAttributes = "";
			$this->ver_presentasi_rijek->HrefValue = "";

			// ver_hasil_id
			$this->ver_hasil_id->LinkCustomAttributes = "";
			$this->ver_hasil_id->HrefValue = "";

			// ver_foto
			$this->ver_foto->LinkCustomAttributes = "";
			if (!ew_Empty($this->ver_foto->Upload->DbValue)) {
				$this->ver_foto->HrefValue = "%u"; // Add prefix/suffix
				$this->ver_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->ver_foto->HrefValue = ew_FullUrl($this->ver_foto->HrefValue, "href");
			} else {
				$this->ver_foto->HrefValue = "";
			}
			$this->ver_foto->HrefValue2 = $this->ver_foto->UploadPath . $this->ver_foto->Upload->DbValue;

			// ver_catatan
			$this->ver_catatan->LinkCustomAttributes = "";
			$this->ver_catatan->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->qc_id->FldIsDetailKey && !is_null($this->qc_id->FormValue) && $this->qc_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->qc_id->FldCaption(), $this->qc_id->ReqErrMsg));
		}
		if (!$this->datang_id->FldIsDetailKey && !is_null($this->datang_id->FormValue) && $this->datang_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->datang_id->FldCaption(), $this->datang_id->ReqErrMsg));
		}
		if (!$this->ver_tgl->FldIsDetailKey && !is_null($this->ver_tgl->FormValue) && $this->ver_tgl->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->ver_tgl->FldCaption(), $this->ver_tgl->ReqErrMsg));
		}
		if (!ew_CheckDateDef($this->ver_tgl->FormValue)) {
			ew_AddMessage($gsFormError, $this->ver_tgl->FldErrMsg());
		}
		if (!ew_CheckInteger($this->ver_presentasi_rijek->FormValue)) {
			ew_AddMessage($gsFormError, $this->ver_presentasi_rijek->FldErrMsg());
		}
		if (!$this->ver_hasil_id->FldIsDetailKey && !is_null($this->ver_hasil_id->FormValue) && $this->ver_hasil_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->ver_hasil_id->FldCaption(), $this->ver_hasil_id->ReqErrMsg));
		}
		if ($this->ver_foto->Upload->FileName == "" && !$this->ver_foto->Upload->KeepFile) {
			ew_AddMessage($gsFormError, str_replace("%s", $this->ver_foto->FldCaption(), $this->ver_foto->ReqErrMsg));
		}
		if (!$this->ver_catatan->FldIsDetailKey && !is_null($this->ver_catatan->FormValue) && $this->ver_catatan->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->ver_catatan->FldCaption(), $this->ver_catatan->ReqErrMsg));
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;
		$conn = &$this->Connection();

		// Load db values from rsold
		$this->LoadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = array();

		// qc_id
		$this->qc_id->SetDbValueDef($rsnew, $this->qc_id->CurrentValue, NULL, FALSE);

		// datang_id
		$this->datang_id->SetDbValueDef($rsnew, $this->datang_id->CurrentValue, NULL, FALSE);

		// ver_tgl
		$this->ver_tgl->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->ver_tgl->CurrentValue, 0), NULL, FALSE);

		// ver_presentasi_rijek
		$this->ver_presentasi_rijek->SetDbValueDef($rsnew, $this->ver_presentasi_rijek->CurrentValue, NULL, FALSE);

		// ver_hasil_id
		$this->ver_hasil_id->SetDbValueDef($rsnew, $this->ver_hasil_id->CurrentValue, NULL, FALSE);

		// ver_foto
		if ($this->ver_foto->Visible && !$this->ver_foto->Upload->KeepFile) {
			$this->ver_foto->Upload->DbValue = ""; // No need to delete old file
			if ($this->ver_foto->Upload->FileName == "") {
				$rsnew['ver_foto'] = NULL;
			} else {
				$rsnew['ver_foto'] = $this->ver_foto->Upload->FileName;
			}
			$this->ver_foto->ImageWidth = EW_THUMBNAIL_DEFAULT_WIDTH; // Resize width
			$this->ver_foto->ImageHeight = EW_THUMBNAIL_DEFAULT_HEIGHT; // Resize height
		}

		// ver_catatan
		$this->ver_catatan->SetDbValueDef($rsnew, $this->ver_catatan->CurrentValue, NULL, FALSE);
		if ($this->ver_foto->Visible && !$this->ver_foto->Upload->KeepFile) {
			$OldFiles = ew_Empty($this->ver_foto->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->ver_foto->Upload->DbValue));
			if (!ew_Empty($this->ver_foto->Upload->FileName)) {
				$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->ver_foto->Upload->FileName));
				$NewFileCount = count($NewFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					$fldvar = ($this->ver_foto->Upload->Index < 0) ? $this->ver_foto->FldVar : substr($this->ver_foto->FldVar, 0, 1) . $this->ver_foto->Upload->Index . substr($this->ver_foto->FldVar, 1);
					if ($NewFiles[$i] <> "") {
						$file = $NewFiles[$i];
						if (file_exists(ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $file)) {
							$OldFileFound = FALSE;
							$OldFileCount = count($OldFiles);
							for ($j = 0; $j < $OldFileCount; $j++) {
								$file1 = $OldFiles[$j];
								if ($file1 == $file) { // Old file found, no need to delete anymore
									unset($OldFiles[$j]);
									$OldFileFound = TRUE;
									break;
								}
							}
							if ($OldFileFound) // No need to check if file exists further
								continue;
							$file1 = ew_UploadFileNameEx($this->ver_foto->PhysicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $file1) || file_exists($this->ver_foto->PhysicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = ew_UniqueFilename($this->ver_foto->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $file, ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $file1);
								$NewFiles[$i] = $file1;
							}
						}
					}
				}
				$this->ver_foto->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
				$this->ver_foto->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
				$this->ver_foto->SetDbValueDef($rsnew, $this->ver_foto->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
				if ($this->ver_foto->Visible && !$this->ver_foto->Upload->KeepFile) {
					$OldFiles = ew_Empty($this->ver_foto->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->ver_foto->Upload->DbValue));
					if (!ew_Empty($this->ver_foto->Upload->FileName)) {
						$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $this->ver_foto->Upload->FileName);
						$NewFiles2 = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $rsnew['ver_foto']);
						$NewFileCount = count($NewFiles);
						for ($i = 0; $i < $NewFileCount; $i++) {
							$fldvar = ($this->ver_foto->Upload->Index < 0) ? $this->ver_foto->FldVar : substr($this->ver_foto->FldVar, 0, 1) . $this->ver_foto->Upload->Index . substr($this->ver_foto->FldVar, 1);
							if ($NewFiles[$i] <> "") {
								$file = ew_UploadTempPath($fldvar, $this->ver_foto->TblVar) . $NewFiles[$i];
								if (file_exists($file)) {
									if (@$NewFiles2[$i] <> "") // Use correct file name
										$NewFiles[$i] = $NewFiles2[$i];
									if (!$this->ver_foto->Upload->ResizeAndSaveToFile($this->ver_foto->ImageWidth, $this->ver_foto->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$NewFiles = array();
					}
					$OldFileCount = count($OldFiles);
					for ($i = 0; $i < $OldFileCount; $i++) {
						if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
							@unlink($this->ver_foto->OldPhysicalUploadPath() . $OldFiles[$i]);
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}

		// ver_foto
		ew_CleanUploadTempPath($this->ver_foto, $this->ver_foto->Upload->Index);
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("verifikasilist.php"), "", $this->TableVar, TRUE);
		$PageId = ($this->CurrentAction == "C") ? "Copy" : "Add";
		$Breadcrumb->Add("add", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_qc_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `qc_id` AS `LinkFld`, `qc_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `qc`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`qc_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->qc_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `qc_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_datang_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `datang_id` AS `LinkFld`, `datang_id` AS `DispFld`, `datang_jumlah` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kedatangan`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`datang_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->datang_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `datang_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_ver_hasil_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `vh_id` AS `LinkFld`, `vh_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `verifikasi_hasil`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`vh_id` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->ver_hasil_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `vh_id` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($verifikasi_add)) $verifikasi_add = new cverifikasi_add();

// Page init
$verifikasi_add->Page_Init();

// Page main
$verifikasi_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$verifikasi_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "add";
var CurrentForm = fverifikasiadd = new ew_Form("fverifikasiadd", "add");

// Validate form
fverifikasiadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_qc_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->qc_id->FldCaption(), $verifikasi->qc_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_datang_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->datang_id->FldCaption(), $verifikasi->datang_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_ver_tgl");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->ver_tgl->FldCaption(), $verifikasi->ver_tgl->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_ver_tgl");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($verifikasi->ver_tgl->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_ver_presentasi_rijek");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($verifikasi->ver_presentasi_rijek->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_ver_hasil_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->ver_hasil_id->FldCaption(), $verifikasi->ver_hasil_id->ReqErrMsg)) ?>");
			felm = this.GetElements("x" + infix + "_ver_foto");
			elm = this.GetElements("fn_x" + infix + "_ver_foto");
			if (felm && elm && !ew_HasValue(elm))
				return this.OnError(felm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->ver_foto->FldCaption(), $verifikasi->ver_foto->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_ver_catatan");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $verifikasi->ver_catatan->FldCaption(), $verifikasi->ver_catatan->ReqErrMsg)) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fverifikasiadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fverifikasiadd.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fverifikasiadd.Lists["x_qc_id"] = {"LinkField":"x_qc_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_qc_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"qc"};
fverifikasiadd.Lists["x_qc_id"].Data = "<?php echo $verifikasi_add->qc_id->LookupFilterQuery(FALSE, "add") ?>";
fverifikasiadd.Lists["x_datang_id"] = {"LinkField":"x_datang_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_datang_id","x_datang_jumlah","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kedatangan"};
fverifikasiadd.Lists["x_datang_id"].Data = "<?php echo $verifikasi_add->datang_id->LookupFilterQuery(FALSE, "add") ?>";
fverifikasiadd.Lists["x_ver_hasil_id"] = {"LinkField":"x_vh_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_vh_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"verifikasi_hasil"};
fverifikasiadd.Lists["x_ver_hasil_id"].Data = "<?php echo $verifikasi_add->ver_hasil_id->LookupFilterQuery(FALSE, "add") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $verifikasi_add->ShowPageHeader(); ?>
<?php
$verifikasi_add->ShowMessage();
?>
<form name="fverifikasiadd" id="fverifikasiadd" class="<?php echo $verifikasi_add->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($verifikasi_add->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $verifikasi_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="verifikasi">
<input type="hidden" name="a_add" id="a_add" value="A">
<input type="hidden" name="modal" value="<?php echo intval($verifikasi_add->IsModal) ?>">
<div class="ewAddDiv"><!-- page* -->
<?php if ($verifikasi->qc_id->Visible) { // qc_id ?>
	<div id="r_qc_id" class="form-group">
		<label id="elh_verifikasi_qc_id" for="x_qc_id" class="<?php echo $verifikasi_add->LeftColumnClass ?>"><?php echo $verifikasi->qc_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_add->RightColumnClass ?>"><div<?php echo $verifikasi->qc_id->CellAttributes() ?>>
<span id="el_verifikasi_qc_id">
<select data-table="verifikasi" data-field="x_qc_id" data-value-separator="<?php echo $verifikasi->qc_id->DisplayValueSeparatorAttribute() ?>" id="x_qc_id" name="x_qc_id"<?php echo $verifikasi->qc_id->EditAttributes() ?>>
<?php echo $verifikasi->qc_id->SelectOptionListHtml("x_qc_id") ?>
</select>
</span>
<?php echo $verifikasi->qc_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->datang_id->Visible) { // datang_id ?>
	<div id="r_datang_id" class="form-group">
		<label id="elh_verifikasi_datang_id" for="x_datang_id" class="<?php echo $verifikasi_add->LeftColumnClass ?>"><?php echo $verifikasi->datang_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_add->RightColumnClass ?>"><div<?php echo $verifikasi->datang_id->CellAttributes() ?>>
<span id="el_verifikasi_datang_id">
<select data-table="verifikasi" data-field="x_datang_id" data-value-separator="<?php echo $verifikasi->datang_id->DisplayValueSeparatorAttribute() ?>" id="x_datang_id" name="x_datang_id"<?php echo $verifikasi->datang_id->EditAttributes() ?>>
<?php echo $verifikasi->datang_id->SelectOptionListHtml("x_datang_id") ?>
</select>
</span>
<?php echo $verifikasi->datang_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->ver_tgl->Visible) { // ver_tgl ?>
	<div id="r_ver_tgl" class="form-group">
		<label id="elh_verifikasi_ver_tgl" for="x_ver_tgl" class="<?php echo $verifikasi_add->LeftColumnClass ?>"><?php echo $verifikasi->ver_tgl->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_add->RightColumnClass ?>"><div<?php echo $verifikasi->ver_tgl->CellAttributes() ?>>
<span id="el_verifikasi_ver_tgl">
<input type="text" data-table="verifikasi" data-field="x_ver_tgl" name="x_ver_tgl" id="x_ver_tgl" placeholder="<?php echo ew_HtmlEncode($verifikasi->ver_tgl->getPlaceHolder()) ?>" value="<?php echo $verifikasi->ver_tgl->EditValue ?>"<?php echo $verifikasi->ver_tgl->EditAttributes() ?>>
<?php if (!$verifikasi->ver_tgl->ReadOnly && !$verifikasi->ver_tgl->Disabled && !isset($verifikasi->ver_tgl->EditAttrs["readonly"]) && !isset($verifikasi->ver_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fverifikasiadd", "x_ver_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $verifikasi->ver_tgl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->ver_presentasi_rijek->Visible) { // ver_presentasi_rijek ?>
	<div id="r_ver_presentasi_rijek" class="form-group">
		<label id="elh_verifikasi_ver_presentasi_rijek" for="x_ver_presentasi_rijek" class="<?php echo $verifikasi_add->LeftColumnClass ?>"><?php echo $verifikasi->ver_presentasi_rijek->FldCaption() ?></label>
		<div class="<?php echo $verifikasi_add->RightColumnClass ?>"><div<?php echo $verifikasi->ver_presentasi_rijek->CellAttributes() ?>>
<span id="el_verifikasi_ver_presentasi_rijek">
<input type="text" data-table="verifikasi" data-field="x_ver_presentasi_rijek" name="x_ver_presentasi_rijek" id="x_ver_presentasi_rijek" size="30" placeholder="<?php echo ew_HtmlEncode($verifikasi->ver_presentasi_rijek->getPlaceHolder()) ?>" value="<?php echo $verifikasi->ver_presentasi_rijek->EditValue ?>"<?php echo $verifikasi->ver_presentasi_rijek->EditAttributes() ?>>
</span>
<?php echo $verifikasi->ver_presentasi_rijek->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->ver_hasil_id->Visible) { // ver_hasil_id ?>
	<div id="r_ver_hasil_id" class="form-group">
		<label id="elh_verifikasi_ver_hasil_id" for="x_ver_hasil_id" class="<?php echo $verifikasi_add->LeftColumnClass ?>"><?php echo $verifikasi->ver_hasil_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_add->RightColumnClass ?>"><div<?php echo $verifikasi->ver_hasil_id->CellAttributes() ?>>
<span id="el_verifikasi_ver_hasil_id">
<select data-table="verifikasi" data-field="x_ver_hasil_id" data-value-separator="<?php echo $verifikasi->ver_hasil_id->DisplayValueSeparatorAttribute() ?>" id="x_ver_hasil_id" name="x_ver_hasil_id"<?php echo $verifikasi->ver_hasil_id->EditAttributes() ?>>
<?php echo $verifikasi->ver_hasil_id->SelectOptionListHtml("x_ver_hasil_id") ?>
</select>
</span>
<?php echo $verifikasi->ver_hasil_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->ver_foto->Visible) { // ver_foto ?>
	<div id="r_ver_foto" class="form-group">
		<label id="elh_verifikasi_ver_foto" class="<?php echo $verifikasi_add->LeftColumnClass ?>"><?php echo $verifikasi->ver_foto->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_add->RightColumnClass ?>"><div<?php echo $verifikasi->ver_foto->CellAttributes() ?>>
<span id="el_verifikasi_ver_foto">
<div id="fd_x_ver_foto">
<span title="<?php echo $verifikasi->ver_foto->FldTitle() ? $verifikasi->ver_foto->FldTitle() : $Language->Phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($verifikasi->ver_foto->ReadOnly || $verifikasi->ver_foto->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="verifikasi" data-field="x_ver_foto" name="x_ver_foto" id="x_ver_foto" multiple="multiple"<?php echo $verifikasi->ver_foto->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_ver_foto" id= "fn_x_ver_foto" value="<?php echo $verifikasi->ver_foto->Upload->FileName ?>">
<input type="hidden" name="fa_x_ver_foto" id= "fa_x_ver_foto" value="0">
<input type="hidden" name="fs_x_ver_foto" id= "fs_x_ver_foto" value="100">
<input type="hidden" name="fx_x_ver_foto" id= "fx_x_ver_foto" value="<?php echo $verifikasi->ver_foto->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_ver_foto" id= "fm_x_ver_foto" value="<?php echo $verifikasi->ver_foto->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_ver_foto" id= "fc_x_ver_foto" value="<?php echo $verifikasi->ver_foto->UploadMaxFileCount ?>">
</div>
<table id="ft_x_ver_foto" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $verifikasi->ver_foto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($verifikasi->ver_catatan->Visible) { // ver_catatan ?>
	<div id="r_ver_catatan" class="form-group">
		<label id="elh_verifikasi_ver_catatan" for="x_ver_catatan" class="<?php echo $verifikasi_add->LeftColumnClass ?>"><?php echo $verifikasi->ver_catatan->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $verifikasi_add->RightColumnClass ?>"><div<?php echo $verifikasi->ver_catatan->CellAttributes() ?>>
<span id="el_verifikasi_ver_catatan">
<textarea data-table="verifikasi" data-field="x_ver_catatan" name="x_ver_catatan" id="x_ver_catatan" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($verifikasi->ver_catatan->getPlaceHolder()) ?>"<?php echo $verifikasi->ver_catatan->EditAttributes() ?>><?php echo $verifikasi->ver_catatan->EditValue ?></textarea>
</span>
<?php echo $verifikasi->ver_catatan->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$verifikasi_add->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $verifikasi_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $verifikasi_add->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fverifikasiadd.Init();
</script>
<?php
$verifikasi_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$verifikasi_add->Page_Terminate();
?>
