<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "suplaiyer_ubiinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$suplaiyer_ubi_list = NULL; // Initialize page object first

class csuplaiyer_ubi_list extends csuplaiyer_ubi {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'suplaiyer_ubi';

	// Page object name
	var $PageObjName = 'suplaiyer_ubi_list';

	// Grid form hidden field names
	var $FormName = 'fsuplaiyer_ubilist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (suplaiyer_ubi)
		if (!isset($GLOBALS["suplaiyer_ubi"]) || get_class($GLOBALS["suplaiyer_ubi"]) == "csuplaiyer_ubi") {
			$GLOBALS["suplaiyer_ubi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["suplaiyer_ubi"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "suplaiyer_ubiadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "suplaiyer_ubidelete.php";
		$this->MultiUpdateUrl = "suplaiyer_ubiupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'suplaiyer_ubi', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fsuplaiyer_ubilistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->sup_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->sup_id->Visible = FALSE;
		$this->sup_nama->SetVisibility();
		$this->tr_id->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->alamat->SetVisibility();
		$this->no_hp->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $suplaiyer_ubi;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($suplaiyer_ubi);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->sup_id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->sup_id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->sup_id->AdvancedSearch->ToJson(), ","); // Field sup_id
		$sFilterList = ew_Concat($sFilterList, $this->sup_nama->AdvancedSearch->ToJson(), ","); // Field sup_nama
		$sFilterList = ew_Concat($sFilterList, $this->tr_id->AdvancedSearch->ToJson(), ","); // Field tr_id
		$sFilterList = ew_Concat($sFilterList, $this->prov_id->AdvancedSearch->ToJson(), ","); // Field prov_id
		$sFilterList = ew_Concat($sFilterList, $this->kab_id->AdvancedSearch->ToJson(), ","); // Field kab_id
		$sFilterList = ew_Concat($sFilterList, $this->kec_id->AdvancedSearch->ToJson(), ","); // Field kec_id
		$sFilterList = ew_Concat($sFilterList, $this->desa_id->AdvancedSearch->ToJson(), ","); // Field desa_id
		$sFilterList = ew_Concat($sFilterList, $this->alamat->AdvancedSearch->ToJson(), ","); // Field alamat
		$sFilterList = ew_Concat($sFilterList, $this->no_hp->AdvancedSearch->ToJson(), ","); // Field no_hp
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "fsuplaiyer_ubilistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field sup_id
		$this->sup_id->AdvancedSearch->SearchValue = @$filter["x_sup_id"];
		$this->sup_id->AdvancedSearch->SearchOperator = @$filter["z_sup_id"];
		$this->sup_id->AdvancedSearch->SearchCondition = @$filter["v_sup_id"];
		$this->sup_id->AdvancedSearch->SearchValue2 = @$filter["y_sup_id"];
		$this->sup_id->AdvancedSearch->SearchOperator2 = @$filter["w_sup_id"];
		$this->sup_id->AdvancedSearch->Save();

		// Field sup_nama
		$this->sup_nama->AdvancedSearch->SearchValue = @$filter["x_sup_nama"];
		$this->sup_nama->AdvancedSearch->SearchOperator = @$filter["z_sup_nama"];
		$this->sup_nama->AdvancedSearch->SearchCondition = @$filter["v_sup_nama"];
		$this->sup_nama->AdvancedSearch->SearchValue2 = @$filter["y_sup_nama"];
		$this->sup_nama->AdvancedSearch->SearchOperator2 = @$filter["w_sup_nama"];
		$this->sup_nama->AdvancedSearch->Save();

		// Field tr_id
		$this->tr_id->AdvancedSearch->SearchValue = @$filter["x_tr_id"];
		$this->tr_id->AdvancedSearch->SearchOperator = @$filter["z_tr_id"];
		$this->tr_id->AdvancedSearch->SearchCondition = @$filter["v_tr_id"];
		$this->tr_id->AdvancedSearch->SearchValue2 = @$filter["y_tr_id"];
		$this->tr_id->AdvancedSearch->SearchOperator2 = @$filter["w_tr_id"];
		$this->tr_id->AdvancedSearch->Save();

		// Field prov_id
		$this->prov_id->AdvancedSearch->SearchValue = @$filter["x_prov_id"];
		$this->prov_id->AdvancedSearch->SearchOperator = @$filter["z_prov_id"];
		$this->prov_id->AdvancedSearch->SearchCondition = @$filter["v_prov_id"];
		$this->prov_id->AdvancedSearch->SearchValue2 = @$filter["y_prov_id"];
		$this->prov_id->AdvancedSearch->SearchOperator2 = @$filter["w_prov_id"];
		$this->prov_id->AdvancedSearch->Save();

		// Field kab_id
		$this->kab_id->AdvancedSearch->SearchValue = @$filter["x_kab_id"];
		$this->kab_id->AdvancedSearch->SearchOperator = @$filter["z_kab_id"];
		$this->kab_id->AdvancedSearch->SearchCondition = @$filter["v_kab_id"];
		$this->kab_id->AdvancedSearch->SearchValue2 = @$filter["y_kab_id"];
		$this->kab_id->AdvancedSearch->SearchOperator2 = @$filter["w_kab_id"];
		$this->kab_id->AdvancedSearch->Save();

		// Field kec_id
		$this->kec_id->AdvancedSearch->SearchValue = @$filter["x_kec_id"];
		$this->kec_id->AdvancedSearch->SearchOperator = @$filter["z_kec_id"];
		$this->kec_id->AdvancedSearch->SearchCondition = @$filter["v_kec_id"];
		$this->kec_id->AdvancedSearch->SearchValue2 = @$filter["y_kec_id"];
		$this->kec_id->AdvancedSearch->SearchOperator2 = @$filter["w_kec_id"];
		$this->kec_id->AdvancedSearch->Save();

		// Field desa_id
		$this->desa_id->AdvancedSearch->SearchValue = @$filter["x_desa_id"];
		$this->desa_id->AdvancedSearch->SearchOperator = @$filter["z_desa_id"];
		$this->desa_id->AdvancedSearch->SearchCondition = @$filter["v_desa_id"];
		$this->desa_id->AdvancedSearch->SearchValue2 = @$filter["y_desa_id"];
		$this->desa_id->AdvancedSearch->SearchOperator2 = @$filter["w_desa_id"];
		$this->desa_id->AdvancedSearch->Save();

		// Field alamat
		$this->alamat->AdvancedSearch->SearchValue = @$filter["x_alamat"];
		$this->alamat->AdvancedSearch->SearchOperator = @$filter["z_alamat"];
		$this->alamat->AdvancedSearch->SearchCondition = @$filter["v_alamat"];
		$this->alamat->AdvancedSearch->SearchValue2 = @$filter["y_alamat"];
		$this->alamat->AdvancedSearch->SearchOperator2 = @$filter["w_alamat"];
		$this->alamat->AdvancedSearch->Save();

		// Field no_hp
		$this->no_hp->AdvancedSearch->SearchValue = @$filter["x_no_hp"];
		$this->no_hp->AdvancedSearch->SearchOperator = @$filter["z_no_hp"];
		$this->no_hp->AdvancedSearch->SearchCondition = @$filter["v_no_hp"];
		$this->no_hp->AdvancedSearch->SearchValue2 = @$filter["y_no_hp"];
		$this->no_hp->AdvancedSearch->SearchOperator2 = @$filter["w_no_hp"];
		$this->no_hp->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->sup_id, $Default, FALSE); // sup_id
		$this->BuildSearchSql($sWhere, $this->sup_nama, $Default, FALSE); // sup_nama
		$this->BuildSearchSql($sWhere, $this->tr_id, $Default, FALSE); // tr_id
		$this->BuildSearchSql($sWhere, $this->prov_id, $Default, FALSE); // prov_id
		$this->BuildSearchSql($sWhere, $this->kab_id, $Default, FALSE); // kab_id
		$this->BuildSearchSql($sWhere, $this->kec_id, $Default, FALSE); // kec_id
		$this->BuildSearchSql($sWhere, $this->desa_id, $Default, FALSE); // desa_id
		$this->BuildSearchSql($sWhere, $this->alamat, $Default, FALSE); // alamat
		$this->BuildSearchSql($sWhere, $this->no_hp, $Default, FALSE); // no_hp

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->sup_id->AdvancedSearch->Save(); // sup_id
			$this->sup_nama->AdvancedSearch->Save(); // sup_nama
			$this->tr_id->AdvancedSearch->Save(); // tr_id
			$this->prov_id->AdvancedSearch->Save(); // prov_id
			$this->kab_id->AdvancedSearch->Save(); // kab_id
			$this->kec_id->AdvancedSearch->Save(); // kec_id
			$this->desa_id->AdvancedSearch->Save(); // desa_id
			$this->alamat->AdvancedSearch->Save(); // alamat
			$this->no_hp->AdvancedSearch->Save(); // no_hp
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->sup_nama, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->sup_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->sup_nama->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->tr_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->prov_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kab_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->kec_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->desa_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->alamat->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->no_hp->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->sup_id->AdvancedSearch->UnsetSession();
		$this->sup_nama->AdvancedSearch->UnsetSession();
		$this->tr_id->AdvancedSearch->UnsetSession();
		$this->prov_id->AdvancedSearch->UnsetSession();
		$this->kab_id->AdvancedSearch->UnsetSession();
		$this->kec_id->AdvancedSearch->UnsetSession();
		$this->desa_id->AdvancedSearch->UnsetSession();
		$this->alamat->AdvancedSearch->UnsetSession();
		$this->no_hp->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->sup_id->AdvancedSearch->Load();
		$this->sup_nama->AdvancedSearch->Load();
		$this->tr_id->AdvancedSearch->Load();
		$this->prov_id->AdvancedSearch->Load();
		$this->kab_id->AdvancedSearch->Load();
		$this->kec_id->AdvancedSearch->Load();
		$this->desa_id->AdvancedSearch->Load();
		$this->alamat->AdvancedSearch->Load();
		$this->no_hp->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->sup_id); // sup_id
			$this->UpdateSort($this->sup_nama); // sup_nama
			$this->UpdateSort($this->tr_id); // tr_id
			$this->UpdateSort($this->prov_id); // prov_id
			$this->UpdateSort($this->kab_id); // kab_id
			$this->UpdateSort($this->kec_id); // kec_id
			$this->UpdateSort($this->desa_id); // desa_id
			$this->UpdateSort($this->alamat); // alamat
			$this->UpdateSort($this->no_hp); // no_hp
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->sup_id->setSort("");
				$this->sup_nama->setSort("");
				$this->tr_id->setSort("");
				$this->prov_id->setSort("");
				$this->kab_id->setSort("");
				$this->kec_id->setSort("");
				$this->desa_id->setSort("");
				$this->alamat->setSort("");
				$this->no_hp->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		$viewcaption = ew_HtmlTitle($Language->Phrase("ViewLink"));
		if ($Security->CanView()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		$editcaption = ew_HtmlTitle($Language->Phrase("EditLink"));
		if ($Security->CanEdit()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		$copycaption = ew_HtmlTitle($Language->Phrase("CopyLink"));
		if ($Security->CanAdd()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ewMultiSelect\" value=\"" . ew_HtmlEncode($this->sup_id->CurrentValue) . "\" onclick=\"ew_ClickMultiCheckbox(event);\">";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("AddLink"));
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.fsuplaiyer_ubilist,url:'" . $this->MultiDeleteUrl . "'});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fsuplaiyer_ubilistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fsuplaiyer_ubilistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fsuplaiyer_ubilist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fsuplaiyer_ubilistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// sup_id

		$this->sup_id->AdvancedSearch->SearchValue = @$_GET["x_sup_id"];
		if ($this->sup_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sup_id->AdvancedSearch->SearchOperator = @$_GET["z_sup_id"];

		// sup_nama
		$this->sup_nama->AdvancedSearch->SearchValue = @$_GET["x_sup_nama"];
		if ($this->sup_nama->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->sup_nama->AdvancedSearch->SearchOperator = @$_GET["z_sup_nama"];

		// tr_id
		$this->tr_id->AdvancedSearch->SearchValue = @$_GET["x_tr_id"];
		if ($this->tr_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->tr_id->AdvancedSearch->SearchOperator = @$_GET["z_tr_id"];

		// prov_id
		$this->prov_id->AdvancedSearch->SearchValue = @$_GET["x_prov_id"];
		if ($this->prov_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->prov_id->AdvancedSearch->SearchOperator = @$_GET["z_prov_id"];

		// kab_id
		$this->kab_id->AdvancedSearch->SearchValue = @$_GET["x_kab_id"];
		if ($this->kab_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kab_id->AdvancedSearch->SearchOperator = @$_GET["z_kab_id"];

		// kec_id
		$this->kec_id->AdvancedSearch->SearchValue = @$_GET["x_kec_id"];
		if ($this->kec_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->kec_id->AdvancedSearch->SearchOperator = @$_GET["z_kec_id"];

		// desa_id
		$this->desa_id->AdvancedSearch->SearchValue = @$_GET["x_desa_id"];
		if ($this->desa_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->desa_id->AdvancedSearch->SearchOperator = @$_GET["z_desa_id"];

		// alamat
		$this->alamat->AdvancedSearch->SearchValue = @$_GET["x_alamat"];
		if ($this->alamat->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->alamat->AdvancedSearch->SearchOperator = @$_GET["z_alamat"];

		// no_hp
		$this->no_hp->AdvancedSearch->SearchValue = @$_GET["x_no_hp"];
		if ($this->no_hp->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->no_hp->AdvancedSearch->SearchOperator = @$_GET["z_no_hp"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->sup_id->setDbValue($row['sup_id']);
		$this->sup_nama->setDbValue($row['sup_nama']);
		$this->tr_id->setDbValue($row['tr_id']);
		$this->prov_id->setDbValue($row['prov_id']);
		$this->kab_id->setDbValue($row['kab_id']);
		$this->kec_id->setDbValue($row['kec_id']);
		$this->desa_id->setDbValue($row['desa_id']);
		$this->alamat->setDbValue($row['alamat']);
		$this->no_hp->setDbValue($row['no_hp']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['sup_id'] = NULL;
		$row['sup_nama'] = NULL;
		$row['tr_id'] = NULL;
		$row['prov_id'] = NULL;
		$row['kab_id'] = NULL;
		$row['kec_id'] = NULL;
		$row['desa_id'] = NULL;
		$row['alamat'] = NULL;
		$row['no_hp'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->sup_id->DbValue = $row['sup_id'];
		$this->sup_nama->DbValue = $row['sup_nama'];
		$this->tr_id->DbValue = $row['tr_id'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->alamat->DbValue = $row['alamat'];
		$this->no_hp->DbValue = $row['no_hp'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("sup_id")) <> "")
			$this->sup_id->CurrentValue = $this->getKey("sup_id"); // sup_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// sup_id
		// sup_nama
		// tr_id
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// alamat
		// no_hp

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// sup_id
		$this->sup_id->ViewValue = $this->sup_id->CurrentValue;
		$this->sup_id->ViewCustomAttributes = "";

		// sup_nama
		$this->sup_nama->ViewValue = $this->sup_nama->CurrentValue;
		$this->sup_nama->ViewCustomAttributes = "";

		// tr_id
		if (strval($this->tr_id->CurrentValue) <> "") {
			$sFilterWrk = "`tr_id`" . ew_SearchString("=", $this->tr_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `tr_id`, `tr_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tingkat_resiko`";
		$sWhereWrk = "";
		$this->tr_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->tr_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `tr_id` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->tr_id->ViewValue = $this->tr_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->tr_id->ViewValue = $this->tr_id->CurrentValue;
			}
		} else {
			$this->tr_id->ViewValue = NULL;
		}
		$this->tr_id->ViewCustomAttributes = "";

		// prov_id
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		$this->desa_id->ViewCustomAttributes = "";

		// alamat
		$this->alamat->ViewValue = $this->alamat->CurrentValue;
		$this->alamat->ViewCustomAttributes = "";

		// no_hp
		$this->no_hp->ViewValue = $this->no_hp->CurrentValue;
		$this->no_hp->ViewCustomAttributes = "";

			// sup_id
			$this->sup_id->LinkCustomAttributes = "";
			$this->sup_id->HrefValue = "";
			$this->sup_id->TooltipValue = "";

			// sup_nama
			$this->sup_nama->LinkCustomAttributes = "";
			$this->sup_nama->HrefValue = "";
			$this->sup_nama->TooltipValue = "";

			// tr_id
			$this->tr_id->LinkCustomAttributes = "";
			$this->tr_id->HrefValue = "";
			$this->tr_id->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// alamat
			$this->alamat->LinkCustomAttributes = "";
			$this->alamat->HrefValue = "";
			$this->alamat->TooltipValue = "";

			// no_hp
			$this->no_hp->LinkCustomAttributes = "";
			$this->no_hp->HrefValue = "";
			$this->no_hp->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// sup_id
			$this->sup_id->EditAttrs["class"] = "form-control";
			$this->sup_id->EditCustomAttributes = "";
			$this->sup_id->EditValue = ew_HtmlEncode($this->sup_id->AdvancedSearch->SearchValue);
			$this->sup_id->PlaceHolder = ew_RemoveHtml($this->sup_id->FldCaption());

			// sup_nama
			$this->sup_nama->EditAttrs["class"] = "form-control";
			$this->sup_nama->EditCustomAttributes = "";
			$this->sup_nama->EditValue = ew_HtmlEncode($this->sup_nama->AdvancedSearch->SearchValue);
			$this->sup_nama->PlaceHolder = ew_RemoveHtml($this->sup_nama->FldCaption());

			// tr_id
			$this->tr_id->EditCustomAttributes = "";
			if (trim(strval($this->tr_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`tr_id`" . ew_SearchString("=", $this->tr_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `tr_id`, `tr_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `tingkat_resiko`";
			$sWhereWrk = "";
			$this->tr_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->tr_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `tr_id` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->tr_id->EditValue = $arwrk;

			// prov_id
			$this->prov_id->EditAttrs["class"] = "form-control";
			$this->prov_id->EditCustomAttributes = "";
			if (trim(strval($this->prov_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `prov`";
			$sWhereWrk = "";
			$this->prov_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->prov_id->EditValue = $arwrk;

			// kab_id
			$this->kab_id->EditAttrs["class"] = "form-control";
			$this->kab_id->EditCustomAttributes = "";
			if (trim(strval($this->kab_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kab_prov_id` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kab`";
			$sWhereWrk = "";
			$this->kab_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kab_id->EditValue = $arwrk;

			// kec_id
			$this->kec_id->EditAttrs["class"] = "form-control";
			$this->kec_id->EditCustomAttributes = "";
			if (trim(strval($this->kec_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kec_prov_id` AS `SelectFilterFld`, `kec_kab_id` AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kec`";
			$sWhereWrk = "";
			$this->kec_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kec_id->EditValue = $arwrk;

			// desa_id
			$this->desa_id->EditAttrs["class"] = "form-control";
			$this->desa_id->EditCustomAttributes = "";
			if (trim(strval($this->desa_id->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `desa_prov_id` AS `SelectFilterFld`, `desa_kab_id` AS `SelectFilterFld2`, `desa_kec_id` AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `desa`";
			$sWhereWrk = "";
			$this->desa_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->desa_id->EditValue = $arwrk;

			// alamat
			$this->alamat->EditAttrs["class"] = "form-control";
			$this->alamat->EditCustomAttributes = "";
			$this->alamat->EditValue = ew_HtmlEncode($this->alamat->AdvancedSearch->SearchValue);
			$this->alamat->PlaceHolder = ew_RemoveHtml($this->alamat->FldCaption());

			// no_hp
			$this->no_hp->EditAttrs["class"] = "form-control";
			$this->no_hp->EditCustomAttributes = "";
			$this->no_hp->EditValue = ew_HtmlEncode($this->no_hp->AdvancedSearch->SearchValue);
			$this->no_hp->PlaceHolder = ew_RemoveHtml($this->no_hp->FldCaption());
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->sup_id->AdvancedSearch->Load();
		$this->sup_nama->AdvancedSearch->Load();
		$this->tr_id->AdvancedSearch->Load();
		$this->prov_id->AdvancedSearch->Load();
		$this->kab_id->AdvancedSearch->Load();
		$this->kec_id->AdvancedSearch->Load();
		$this->desa_id->AdvancedSearch->Load();
		$this->alamat->AdvancedSearch->Load();
		$this->no_hp->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_suplaiyer_ubi\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_suplaiyer_ubi',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.fsuplaiyer_ubilist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
		case "x_tr_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `tr_id` AS `LinkFld`, `tr_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tingkat_resiko`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`tr_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->tr_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `tr_id` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_prov_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `prov_id` AS `LinkFld`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`prov_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kab_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kab_id` AS `LinkFld`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kab_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kab_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kec_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `kec_id` AS `LinkFld`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kec_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kec_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`kec_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_desa_id":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `desa_id` AS `LinkFld`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`desa_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`desa_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`desa_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "", "f3" => '`desa_kec_id` IN ({filter_value})', "t3" => "3", "fn3" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($suplaiyer_ubi_list)) $suplaiyer_ubi_list = new csuplaiyer_ubi_list();

// Page init
$suplaiyer_ubi_list->Page_Init();

// Page main
$suplaiyer_ubi_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$suplaiyer_ubi_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($suplaiyer_ubi->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fsuplaiyer_ubilist = new ew_Form("fsuplaiyer_ubilist", "list");
fsuplaiyer_ubilist.FormKeyCountName = '<?php echo $suplaiyer_ubi_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsuplaiyer_ubilist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fsuplaiyer_ubilist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsuplaiyer_ubilist.Lists["x_tr_id"] = {"LinkField":"x_tr_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_tr_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"tingkat_resiko"};
fsuplaiyer_ubilist.Lists["x_tr_id"].Data = "<?php echo $suplaiyer_ubi_list->tr_id->LookupFilterQuery(FALSE, "list") ?>";
fsuplaiyer_ubilist.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fsuplaiyer_ubilist.Lists["x_prov_id"].Data = "<?php echo $suplaiyer_ubi_list->prov_id->LookupFilterQuery(FALSE, "list") ?>";
fsuplaiyer_ubilist.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":["x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fsuplaiyer_ubilist.Lists["x_kab_id"].Data = "<?php echo $suplaiyer_ubi_list->kab_id->LookupFilterQuery(FALSE, "list") ?>";
fsuplaiyer_ubilist.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":["x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fsuplaiyer_ubilist.Lists["x_kec_id"].Data = "<?php echo $suplaiyer_ubi_list->kec_id->LookupFilterQuery(FALSE, "list") ?>";
fsuplaiyer_ubilist.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fsuplaiyer_ubilist.Lists["x_desa_id"].Data = "<?php echo $suplaiyer_ubi_list->desa_id->LookupFilterQuery(FALSE, "list") ?>";

// Form object for search
var CurrentSearchForm = fsuplaiyer_ubilistsrch = new ew_Form("fsuplaiyer_ubilistsrch");

// Validate function for search
fsuplaiyer_ubilistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fsuplaiyer_ubilistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fsuplaiyer_ubilistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsuplaiyer_ubilistsrch.Lists["x_tr_id"] = {"LinkField":"x_tr_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_tr_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"tingkat_resiko"};
fsuplaiyer_ubilistsrch.Lists["x_tr_id"].Data = "<?php echo $suplaiyer_ubi_list->tr_id->LookupFilterQuery(FALSE, "extbs") ?>";
fsuplaiyer_ubilistsrch.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fsuplaiyer_ubilistsrch.Lists["x_prov_id"].Data = "<?php echo $suplaiyer_ubi_list->prov_id->LookupFilterQuery(FALSE, "extbs") ?>";
fsuplaiyer_ubilistsrch.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":["x_prov_id"],"ChildFields":["x_kec_id","x_desa_id"],"FilterFields":["x_kab_prov_id"],"Options":[],"Template":"","LinkTable":"kab"};
fsuplaiyer_ubilistsrch.Lists["x_kab_id"].Data = "<?php echo $suplaiyer_ubi_list->kab_id->LookupFilterQuery(FALSE, "extbs") ?>";
fsuplaiyer_ubilistsrch.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":["x_prov_id","x_kab_id"],"ChildFields":["x_desa_id"],"FilterFields":["x_kec_prov_id","x_kec_kab_id"],"Options":[],"Template":"","LinkTable":"kec"};
fsuplaiyer_ubilistsrch.Lists["x_kec_id"].Data = "<?php echo $suplaiyer_ubi_list->kec_id->LookupFilterQuery(FALSE, "extbs") ?>";
fsuplaiyer_ubilistsrch.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":["x_prov_id","x_kab_id","x_kec_id"],"ChildFields":[],"FilterFields":["x_desa_prov_id","x_desa_kab_id","x_desa_kec_id"],"Options":[],"Template":"","LinkTable":"desa"};
fsuplaiyer_ubilistsrch.Lists["x_desa_id"].Data = "<?php echo $suplaiyer_ubi_list->desa_id->LookupFilterQuery(FALSE, "extbs") ?>";

// Init search panel as collapsed
if (fsuplaiyer_ubilistsrch) fsuplaiyer_ubilistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($suplaiyer_ubi->Export == "") { ?>
<div class="ewToolbar">
<?php if ($suplaiyer_ubi_list->TotalRecs > 0 && $suplaiyer_ubi_list->ExportOptions->Visible()) { ?>
<?php $suplaiyer_ubi_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($suplaiyer_ubi_list->SearchOptions->Visible()) { ?>
<?php $suplaiyer_ubi_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($suplaiyer_ubi_list->FilterOptions->Visible()) { ?>
<?php $suplaiyer_ubi_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $suplaiyer_ubi_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($suplaiyer_ubi_list->TotalRecs <= 0)
			$suplaiyer_ubi_list->TotalRecs = $suplaiyer_ubi->ListRecordCount();
	} else {
		if (!$suplaiyer_ubi_list->Recordset && ($suplaiyer_ubi_list->Recordset = $suplaiyer_ubi_list->LoadRecordset()))
			$suplaiyer_ubi_list->TotalRecs = $suplaiyer_ubi_list->Recordset->RecordCount();
	}
	$suplaiyer_ubi_list->StartRec = 1;
	if ($suplaiyer_ubi_list->DisplayRecs <= 0 || ($suplaiyer_ubi->Export <> "" && $suplaiyer_ubi->ExportAll)) // Display all records
		$suplaiyer_ubi_list->DisplayRecs = $suplaiyer_ubi_list->TotalRecs;
	if (!($suplaiyer_ubi->Export <> "" && $suplaiyer_ubi->ExportAll))
		$suplaiyer_ubi_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$suplaiyer_ubi_list->Recordset = $suplaiyer_ubi_list->LoadRecordset($suplaiyer_ubi_list->StartRec-1, $suplaiyer_ubi_list->DisplayRecs);

	// Set no record found message
	if ($suplaiyer_ubi->CurrentAction == "" && $suplaiyer_ubi_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$suplaiyer_ubi_list->setWarningMessage(ew_DeniedMsg());
		if ($suplaiyer_ubi_list->SearchWhere == "0=101")
			$suplaiyer_ubi_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$suplaiyer_ubi_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$suplaiyer_ubi_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($suplaiyer_ubi->Export == "" && $suplaiyer_ubi->CurrentAction == "") { ?>
<form name="fsuplaiyer_ubilistsrch" id="fsuplaiyer_ubilistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($suplaiyer_ubi_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="fsuplaiyer_ubilistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="suplaiyer_ubi">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$suplaiyer_ubi_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$suplaiyer_ubi->RowType = EW_ROWTYPE_SEARCH;

// Render row
$suplaiyer_ubi->ResetAttrs();
$suplaiyer_ubi_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($suplaiyer_ubi->tr_id->Visible) { // tr_id ?>
	<div id="xsc_tr_id" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $suplaiyer_ubi->tr_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_tr_id" id="z_tr_id" value="="></span>
		<span class="ewSearchField">
<div id="tp_x_tr_id" class="ewTemplate"><input type="radio" data-table="suplaiyer_ubi" data-field="x_tr_id" data-value-separator="<?php echo $suplaiyer_ubi->tr_id->DisplayValueSeparatorAttribute() ?>" name="x_tr_id" id="x_tr_id" value="{value}"<?php echo $suplaiyer_ubi->tr_id->EditAttributes() ?>></div>
<div id="dsl_x_tr_id" data-repeatcolumn="5" class="ewItemList" style="display: none;"><div>
<?php echo $suplaiyer_ubi->tr_id->RadioButtonListHtml(FALSE, "x_tr_id") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($suplaiyer_ubi->prov_id->Visible) { // prov_id ?>
	<div id="xsc_prov_id" class="ewCell form-group">
		<label for="x_prov_id" class="ewSearchCaption ewLabel"><?php echo $suplaiyer_ubi->prov_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_prov_id" id="z_prov_id" value="="></span>
		<span class="ewSearchField">
<?php $suplaiyer_ubi->prov_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$suplaiyer_ubi->prov_id->EditAttrs["onchange"]; ?>
<select data-table="suplaiyer_ubi" data-field="x_prov_id" data-value-separator="<?php echo $suplaiyer_ubi->prov_id->DisplayValueSeparatorAttribute() ?>" id="x_prov_id" name="x_prov_id"<?php echo $suplaiyer_ubi->prov_id->EditAttributes() ?>>
<?php echo $suplaiyer_ubi->prov_id->SelectOptionListHtml("x_prov_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($suplaiyer_ubi->kab_id->Visible) { // kab_id ?>
	<div id="xsc_kab_id" class="ewCell form-group">
		<label for="x_kab_id" class="ewSearchCaption ewLabel"><?php echo $suplaiyer_ubi->kab_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_kab_id" id="z_kab_id" value="="></span>
		<span class="ewSearchField">
<?php $suplaiyer_ubi->kab_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$suplaiyer_ubi->kab_id->EditAttrs["onchange"]; ?>
<select data-table="suplaiyer_ubi" data-field="x_kab_id" data-value-separator="<?php echo $suplaiyer_ubi->kab_id->DisplayValueSeparatorAttribute() ?>" id="x_kab_id" name="x_kab_id"<?php echo $suplaiyer_ubi->kab_id->EditAttributes() ?>>
<?php echo $suplaiyer_ubi->kab_id->SelectOptionListHtml("x_kab_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($suplaiyer_ubi->kec_id->Visible) { // kec_id ?>
	<div id="xsc_kec_id" class="ewCell form-group">
		<label for="x_kec_id" class="ewSearchCaption ewLabel"><?php echo $suplaiyer_ubi->kec_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_kec_id" id="z_kec_id" value="="></span>
		<span class="ewSearchField">
<?php $suplaiyer_ubi->kec_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$suplaiyer_ubi->kec_id->EditAttrs["onchange"]; ?>
<select data-table="suplaiyer_ubi" data-field="x_kec_id" data-value-separator="<?php echo $suplaiyer_ubi->kec_id->DisplayValueSeparatorAttribute() ?>" id="x_kec_id" name="x_kec_id"<?php echo $suplaiyer_ubi->kec_id->EditAttributes() ?>>
<?php echo $suplaiyer_ubi->kec_id->SelectOptionListHtml("x_kec_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($suplaiyer_ubi->desa_id->Visible) { // desa_id ?>
	<div id="xsc_desa_id" class="ewCell form-group">
		<label for="x_desa_id" class="ewSearchCaption ewLabel"><?php echo $suplaiyer_ubi->desa_id->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_desa_id" id="z_desa_id" value="="></span>
		<span class="ewSearchField">
<select data-table="suplaiyer_ubi" data-field="x_desa_id" data-value-separator="<?php echo $suplaiyer_ubi->desa_id->DisplayValueSeparatorAttribute() ?>" id="x_desa_id" name="x_desa_id"<?php echo $suplaiyer_ubi->desa_id->EditAttributes() ?>>
<?php echo $suplaiyer_ubi->desa_id->SelectOptionListHtml("x_desa_id") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($suplaiyer_ubi_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($suplaiyer_ubi_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $suplaiyer_ubi_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($suplaiyer_ubi_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($suplaiyer_ubi_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($suplaiyer_ubi_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($suplaiyer_ubi_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $suplaiyer_ubi_list->ShowPageHeader(); ?>
<?php
$suplaiyer_ubi_list->ShowMessage();
?>
<?php if ($suplaiyer_ubi_list->TotalRecs > 0 || $suplaiyer_ubi->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($suplaiyer_ubi_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> suplaiyer_ubi">
<?php if ($suplaiyer_ubi->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($suplaiyer_ubi->CurrentAction <> "gridadd" && $suplaiyer_ubi->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($suplaiyer_ubi_list->Pager)) $suplaiyer_ubi_list->Pager = new cNumericPager($suplaiyer_ubi_list->StartRec, $suplaiyer_ubi_list->DisplayRecs, $suplaiyer_ubi_list->TotalRecs, $suplaiyer_ubi_list->RecRange, $suplaiyer_ubi_list->AutoHidePager) ?>
<?php if ($suplaiyer_ubi_list->Pager->RecordCount > 0 && $suplaiyer_ubi_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($suplaiyer_ubi_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $suplaiyer_ubi_list->PageUrl() ?>start=<?php echo $suplaiyer_ubi_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($suplaiyer_ubi_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $suplaiyer_ubi_list->PageUrl() ?>start=<?php echo $suplaiyer_ubi_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($suplaiyer_ubi_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $suplaiyer_ubi_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($suplaiyer_ubi_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $suplaiyer_ubi_list->PageUrl() ?>start=<?php echo $suplaiyer_ubi_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($suplaiyer_ubi_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $suplaiyer_ubi_list->PageUrl() ?>start=<?php echo $suplaiyer_ubi_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($suplaiyer_ubi_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $suplaiyer_ubi_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $suplaiyer_ubi_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $suplaiyer_ubi_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($suplaiyer_ubi_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsuplaiyer_ubilist" id="fsuplaiyer_ubilist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($suplaiyer_ubi_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $suplaiyer_ubi_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="suplaiyer_ubi">
<div id="gmp_suplaiyer_ubi" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($suplaiyer_ubi_list->TotalRecs > 0 || $suplaiyer_ubi->CurrentAction == "gridedit") { ?>
<table id="tbl_suplaiyer_ubilist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$suplaiyer_ubi_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$suplaiyer_ubi_list->RenderListOptions();

// Render list options (header, left)
$suplaiyer_ubi_list->ListOptions->Render("header", "left");
?>
<?php if ($suplaiyer_ubi->sup_id->Visible) { // sup_id ?>
	<?php if ($suplaiyer_ubi->SortUrl($suplaiyer_ubi->sup_id) == "") { ?>
		<th data-name="sup_id" class="<?php echo $suplaiyer_ubi->sup_id->HeaderCellClass() ?>"><div id="elh_suplaiyer_ubi_sup_id" class="suplaiyer_ubi_sup_id"><div class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->sup_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sup_id" class="<?php echo $suplaiyer_ubi->sup_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $suplaiyer_ubi->SortUrl($suplaiyer_ubi->sup_id) ?>',1);"><div id="elh_suplaiyer_ubi_sup_id" class="suplaiyer_ubi_sup_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->sup_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($suplaiyer_ubi->sup_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($suplaiyer_ubi->sup_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($suplaiyer_ubi->sup_nama->Visible) { // sup_nama ?>
	<?php if ($suplaiyer_ubi->SortUrl($suplaiyer_ubi->sup_nama) == "") { ?>
		<th data-name="sup_nama" class="<?php echo $suplaiyer_ubi->sup_nama->HeaderCellClass() ?>"><div id="elh_suplaiyer_ubi_sup_nama" class="suplaiyer_ubi_sup_nama"><div class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->sup_nama->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sup_nama" class="<?php echo $suplaiyer_ubi->sup_nama->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $suplaiyer_ubi->SortUrl($suplaiyer_ubi->sup_nama) ?>',1);"><div id="elh_suplaiyer_ubi_sup_nama" class="suplaiyer_ubi_sup_nama">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->sup_nama->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($suplaiyer_ubi->sup_nama->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($suplaiyer_ubi->sup_nama->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($suplaiyer_ubi->tr_id->Visible) { // tr_id ?>
	<?php if ($suplaiyer_ubi->SortUrl($suplaiyer_ubi->tr_id) == "") { ?>
		<th data-name="tr_id" class="<?php echo $suplaiyer_ubi->tr_id->HeaderCellClass() ?>"><div id="elh_suplaiyer_ubi_tr_id" class="suplaiyer_ubi_tr_id"><div class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->tr_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tr_id" class="<?php echo $suplaiyer_ubi->tr_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $suplaiyer_ubi->SortUrl($suplaiyer_ubi->tr_id) ?>',1);"><div id="elh_suplaiyer_ubi_tr_id" class="suplaiyer_ubi_tr_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->tr_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($suplaiyer_ubi->tr_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($suplaiyer_ubi->tr_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($suplaiyer_ubi->prov_id->Visible) { // prov_id ?>
	<?php if ($suplaiyer_ubi->SortUrl($suplaiyer_ubi->prov_id) == "") { ?>
		<th data-name="prov_id" class="<?php echo $suplaiyer_ubi->prov_id->HeaderCellClass() ?>"><div id="elh_suplaiyer_ubi_prov_id" class="suplaiyer_ubi_prov_id"><div class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->prov_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="prov_id" class="<?php echo $suplaiyer_ubi->prov_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $suplaiyer_ubi->SortUrl($suplaiyer_ubi->prov_id) ?>',1);"><div id="elh_suplaiyer_ubi_prov_id" class="suplaiyer_ubi_prov_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->prov_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($suplaiyer_ubi->prov_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($suplaiyer_ubi->prov_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($suplaiyer_ubi->kab_id->Visible) { // kab_id ?>
	<?php if ($suplaiyer_ubi->SortUrl($suplaiyer_ubi->kab_id) == "") { ?>
		<th data-name="kab_id" class="<?php echo $suplaiyer_ubi->kab_id->HeaderCellClass() ?>"><div id="elh_suplaiyer_ubi_kab_id" class="suplaiyer_ubi_kab_id"><div class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->kab_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kab_id" class="<?php echo $suplaiyer_ubi->kab_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $suplaiyer_ubi->SortUrl($suplaiyer_ubi->kab_id) ?>',1);"><div id="elh_suplaiyer_ubi_kab_id" class="suplaiyer_ubi_kab_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->kab_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($suplaiyer_ubi->kab_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($suplaiyer_ubi->kab_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($suplaiyer_ubi->kec_id->Visible) { // kec_id ?>
	<?php if ($suplaiyer_ubi->SortUrl($suplaiyer_ubi->kec_id) == "") { ?>
		<th data-name="kec_id" class="<?php echo $suplaiyer_ubi->kec_id->HeaderCellClass() ?>"><div id="elh_suplaiyer_ubi_kec_id" class="suplaiyer_ubi_kec_id"><div class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->kec_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="kec_id" class="<?php echo $suplaiyer_ubi->kec_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $suplaiyer_ubi->SortUrl($suplaiyer_ubi->kec_id) ?>',1);"><div id="elh_suplaiyer_ubi_kec_id" class="suplaiyer_ubi_kec_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->kec_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($suplaiyer_ubi->kec_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($suplaiyer_ubi->kec_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($suplaiyer_ubi->desa_id->Visible) { // desa_id ?>
	<?php if ($suplaiyer_ubi->SortUrl($suplaiyer_ubi->desa_id) == "") { ?>
		<th data-name="desa_id" class="<?php echo $suplaiyer_ubi->desa_id->HeaderCellClass() ?>"><div id="elh_suplaiyer_ubi_desa_id" class="suplaiyer_ubi_desa_id"><div class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->desa_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="desa_id" class="<?php echo $suplaiyer_ubi->desa_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $suplaiyer_ubi->SortUrl($suplaiyer_ubi->desa_id) ?>',1);"><div id="elh_suplaiyer_ubi_desa_id" class="suplaiyer_ubi_desa_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->desa_id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($suplaiyer_ubi->desa_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($suplaiyer_ubi->desa_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($suplaiyer_ubi->alamat->Visible) { // alamat ?>
	<?php if ($suplaiyer_ubi->SortUrl($suplaiyer_ubi->alamat) == "") { ?>
		<th data-name="alamat" class="<?php echo $suplaiyer_ubi->alamat->HeaderCellClass() ?>"><div id="elh_suplaiyer_ubi_alamat" class="suplaiyer_ubi_alamat"><div class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->alamat->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="alamat" class="<?php echo $suplaiyer_ubi->alamat->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $suplaiyer_ubi->SortUrl($suplaiyer_ubi->alamat) ?>',1);"><div id="elh_suplaiyer_ubi_alamat" class="suplaiyer_ubi_alamat">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->alamat->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($suplaiyer_ubi->alamat->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($suplaiyer_ubi->alamat->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($suplaiyer_ubi->no_hp->Visible) { // no_hp ?>
	<?php if ($suplaiyer_ubi->SortUrl($suplaiyer_ubi->no_hp) == "") { ?>
		<th data-name="no_hp" class="<?php echo $suplaiyer_ubi->no_hp->HeaderCellClass() ?>"><div id="elh_suplaiyer_ubi_no_hp" class="suplaiyer_ubi_no_hp"><div class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->no_hp->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no_hp" class="<?php echo $suplaiyer_ubi->no_hp->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $suplaiyer_ubi->SortUrl($suplaiyer_ubi->no_hp) ?>',1);"><div id="elh_suplaiyer_ubi_no_hp" class="suplaiyer_ubi_no_hp">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $suplaiyer_ubi->no_hp->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($suplaiyer_ubi->no_hp->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($suplaiyer_ubi->no_hp->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$suplaiyer_ubi_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($suplaiyer_ubi->ExportAll && $suplaiyer_ubi->Export <> "") {
	$suplaiyer_ubi_list->StopRec = $suplaiyer_ubi_list->TotalRecs;
} else {

	// Set the last record to display
	if ($suplaiyer_ubi_list->TotalRecs > $suplaiyer_ubi_list->StartRec + $suplaiyer_ubi_list->DisplayRecs - 1)
		$suplaiyer_ubi_list->StopRec = $suplaiyer_ubi_list->StartRec + $suplaiyer_ubi_list->DisplayRecs - 1;
	else
		$suplaiyer_ubi_list->StopRec = $suplaiyer_ubi_list->TotalRecs;
}
$suplaiyer_ubi_list->RecCnt = $suplaiyer_ubi_list->StartRec - 1;
if ($suplaiyer_ubi_list->Recordset && !$suplaiyer_ubi_list->Recordset->EOF) {
	$suplaiyer_ubi_list->Recordset->MoveFirst();
	$bSelectLimit = $suplaiyer_ubi_list->UseSelectLimit;
	if (!$bSelectLimit && $suplaiyer_ubi_list->StartRec > 1)
		$suplaiyer_ubi_list->Recordset->Move($suplaiyer_ubi_list->StartRec - 1);
} elseif (!$suplaiyer_ubi->AllowAddDeleteRow && $suplaiyer_ubi_list->StopRec == 0) {
	$suplaiyer_ubi_list->StopRec = $suplaiyer_ubi->GridAddRowCount;
}

// Initialize aggregate
$suplaiyer_ubi->RowType = EW_ROWTYPE_AGGREGATEINIT;
$suplaiyer_ubi->ResetAttrs();
$suplaiyer_ubi_list->RenderRow();
while ($suplaiyer_ubi_list->RecCnt < $suplaiyer_ubi_list->StopRec) {
	$suplaiyer_ubi_list->RecCnt++;
	if (intval($suplaiyer_ubi_list->RecCnt) >= intval($suplaiyer_ubi_list->StartRec)) {
		$suplaiyer_ubi_list->RowCnt++;

		// Set up key count
		$suplaiyer_ubi_list->KeyCount = $suplaiyer_ubi_list->RowIndex;

		// Init row class and style
		$suplaiyer_ubi->ResetAttrs();
		$suplaiyer_ubi->CssClass = "";
		if ($suplaiyer_ubi->CurrentAction == "gridadd") {
		} else {
			$suplaiyer_ubi_list->LoadRowValues($suplaiyer_ubi_list->Recordset); // Load row values
		}
		$suplaiyer_ubi->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$suplaiyer_ubi->RowAttrs = array_merge($suplaiyer_ubi->RowAttrs, array('data-rowindex'=>$suplaiyer_ubi_list->RowCnt, 'id'=>'r' . $suplaiyer_ubi_list->RowCnt . '_suplaiyer_ubi', 'data-rowtype'=>$suplaiyer_ubi->RowType));

		// Render row
		$suplaiyer_ubi_list->RenderRow();

		// Render list options
		$suplaiyer_ubi_list->RenderListOptions();
?>
	<tr<?php echo $suplaiyer_ubi->RowAttributes() ?>>
<?php

// Render list options (body, left)
$suplaiyer_ubi_list->ListOptions->Render("body", "left", $suplaiyer_ubi_list->RowCnt);
?>
	<?php if ($suplaiyer_ubi->sup_id->Visible) { // sup_id ?>
		<td data-name="sup_id"<?php echo $suplaiyer_ubi->sup_id->CellAttributes() ?>>
<span id="el<?php echo $suplaiyer_ubi_list->RowCnt ?>_suplaiyer_ubi_sup_id" class="suplaiyer_ubi_sup_id">
<span<?php echo $suplaiyer_ubi->sup_id->ViewAttributes() ?>>
<?php echo $suplaiyer_ubi->sup_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($suplaiyer_ubi->sup_nama->Visible) { // sup_nama ?>
		<td data-name="sup_nama"<?php echo $suplaiyer_ubi->sup_nama->CellAttributes() ?>>
<span id="el<?php echo $suplaiyer_ubi_list->RowCnt ?>_suplaiyer_ubi_sup_nama" class="suplaiyer_ubi_sup_nama">
<span<?php echo $suplaiyer_ubi->sup_nama->ViewAttributes() ?>>
<?php echo $suplaiyer_ubi->sup_nama->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($suplaiyer_ubi->tr_id->Visible) { // tr_id ?>
		<td data-name="tr_id"<?php echo $suplaiyer_ubi->tr_id->CellAttributes() ?>>
<span id="el<?php echo $suplaiyer_ubi_list->RowCnt ?>_suplaiyer_ubi_tr_id" class="suplaiyer_ubi_tr_id">
<span<?php echo $suplaiyer_ubi->tr_id->ViewAttributes() ?>>
<?php echo $suplaiyer_ubi->tr_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($suplaiyer_ubi->prov_id->Visible) { // prov_id ?>
		<td data-name="prov_id"<?php echo $suplaiyer_ubi->prov_id->CellAttributes() ?>>
<span id="el<?php echo $suplaiyer_ubi_list->RowCnt ?>_suplaiyer_ubi_prov_id" class="suplaiyer_ubi_prov_id">
<span<?php echo $suplaiyer_ubi->prov_id->ViewAttributes() ?>>
<?php echo $suplaiyer_ubi->prov_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($suplaiyer_ubi->kab_id->Visible) { // kab_id ?>
		<td data-name="kab_id"<?php echo $suplaiyer_ubi->kab_id->CellAttributes() ?>>
<span id="el<?php echo $suplaiyer_ubi_list->RowCnt ?>_suplaiyer_ubi_kab_id" class="suplaiyer_ubi_kab_id">
<span<?php echo $suplaiyer_ubi->kab_id->ViewAttributes() ?>>
<?php echo $suplaiyer_ubi->kab_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($suplaiyer_ubi->kec_id->Visible) { // kec_id ?>
		<td data-name="kec_id"<?php echo $suplaiyer_ubi->kec_id->CellAttributes() ?>>
<span id="el<?php echo $suplaiyer_ubi_list->RowCnt ?>_suplaiyer_ubi_kec_id" class="suplaiyer_ubi_kec_id">
<span<?php echo $suplaiyer_ubi->kec_id->ViewAttributes() ?>>
<?php echo $suplaiyer_ubi->kec_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($suplaiyer_ubi->desa_id->Visible) { // desa_id ?>
		<td data-name="desa_id"<?php echo $suplaiyer_ubi->desa_id->CellAttributes() ?>>
<span id="el<?php echo $suplaiyer_ubi_list->RowCnt ?>_suplaiyer_ubi_desa_id" class="suplaiyer_ubi_desa_id">
<span<?php echo $suplaiyer_ubi->desa_id->ViewAttributes() ?>>
<?php echo $suplaiyer_ubi->desa_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($suplaiyer_ubi->alamat->Visible) { // alamat ?>
		<td data-name="alamat"<?php echo $suplaiyer_ubi->alamat->CellAttributes() ?>>
<span id="el<?php echo $suplaiyer_ubi_list->RowCnt ?>_suplaiyer_ubi_alamat" class="suplaiyer_ubi_alamat">
<span<?php echo $suplaiyer_ubi->alamat->ViewAttributes() ?>>
<?php echo $suplaiyer_ubi->alamat->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($suplaiyer_ubi->no_hp->Visible) { // no_hp ?>
		<td data-name="no_hp"<?php echo $suplaiyer_ubi->no_hp->CellAttributes() ?>>
<span id="el<?php echo $suplaiyer_ubi_list->RowCnt ?>_suplaiyer_ubi_no_hp" class="suplaiyer_ubi_no_hp">
<span<?php echo $suplaiyer_ubi->no_hp->ViewAttributes() ?>>
<?php echo $suplaiyer_ubi->no_hp->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$suplaiyer_ubi_list->ListOptions->Render("body", "right", $suplaiyer_ubi_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($suplaiyer_ubi->CurrentAction <> "gridadd")
		$suplaiyer_ubi_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($suplaiyer_ubi->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($suplaiyer_ubi_list->Recordset)
	$suplaiyer_ubi_list->Recordset->Close();
?>
<?php if ($suplaiyer_ubi->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($suplaiyer_ubi->CurrentAction <> "gridadd" && $suplaiyer_ubi->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($suplaiyer_ubi_list->Pager)) $suplaiyer_ubi_list->Pager = new cNumericPager($suplaiyer_ubi_list->StartRec, $suplaiyer_ubi_list->DisplayRecs, $suplaiyer_ubi_list->TotalRecs, $suplaiyer_ubi_list->RecRange, $suplaiyer_ubi_list->AutoHidePager) ?>
<?php if ($suplaiyer_ubi_list->Pager->RecordCount > 0 && $suplaiyer_ubi_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($suplaiyer_ubi_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $suplaiyer_ubi_list->PageUrl() ?>start=<?php echo $suplaiyer_ubi_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($suplaiyer_ubi_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $suplaiyer_ubi_list->PageUrl() ?>start=<?php echo $suplaiyer_ubi_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($suplaiyer_ubi_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $suplaiyer_ubi_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($suplaiyer_ubi_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $suplaiyer_ubi_list->PageUrl() ?>start=<?php echo $suplaiyer_ubi_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($suplaiyer_ubi_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $suplaiyer_ubi_list->PageUrl() ?>start=<?php echo $suplaiyer_ubi_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($suplaiyer_ubi_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $suplaiyer_ubi_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $suplaiyer_ubi_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $suplaiyer_ubi_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($suplaiyer_ubi_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($suplaiyer_ubi_list->TotalRecs == 0 && $suplaiyer_ubi->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($suplaiyer_ubi_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($suplaiyer_ubi->Export == "") { ?>
<script type="text/javascript">
fsuplaiyer_ubilistsrch.FilterList = <?php echo $suplaiyer_ubi_list->GetFilterList() ?>;
fsuplaiyer_ubilistsrch.Init();
fsuplaiyer_ubilist.Init();
</script>
<?php } ?>
<?php
$suplaiyer_ubi_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($suplaiyer_ubi->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$suplaiyer_ubi_list->Page_Terminate();
?>
