<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "poinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$po_edit = NULL; // Initialize page object first

class cpo_edit extends cpo {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'po';

	// Page object name
	var $PageObjName = 'po_edit';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (po)
		if (!isset($GLOBALS["po"]) || get_class($GLOBALS["po"]) == "cpo") {
			$GLOBALS["po"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["po"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'po', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("polist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->po_id->SetVisibility();
		$this->po_tanggal->SetVisibility();
		$this->sup_id->SetVisibility();
		$this->var_id->SetVisibility();
		$this->po_qty->SetVisibility();
		$this->po_harga->SetVisibility();
		$this->po_tempat_kirim->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $po;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($po);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "poview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter;
	var $DbDetailFilter;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewEditForm form-horizontal";
		$sReturnUrl = "";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			if ($this->CurrentAction <> "I") // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($objForm->HasValue("x_po_id")) {
				$this->po_id->setFormValue($objForm->GetValue("x_po_id"));
			}
		} else {
			$this->CurrentAction = "I"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (isset($_GET["po_id"])) {
				$this->po_id->setQueryStringValue($_GET["po_id"]);
				$loadByQuery = TRUE;
			} else {
				$this->po_id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->LoadRow();

		// Process form if post back
		if ($postBack) {
			$this->LoadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("polist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "polist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->po_id->FldIsDetailKey) {
			$this->po_id->setFormValue($objForm->GetValue("x_po_id"));
		}
		if (!$this->po_tanggal->FldIsDetailKey) {
			$this->po_tanggal->setFormValue($objForm->GetValue("x_po_tanggal"));
			$this->po_tanggal->CurrentValue = ew_UnFormatDateTime($this->po_tanggal->CurrentValue, 2);
		}
		if (!$this->sup_id->FldIsDetailKey) {
			$this->sup_id->setFormValue($objForm->GetValue("x_sup_id"));
		}
		if (!$this->var_id->FldIsDetailKey) {
			$this->var_id->setFormValue($objForm->GetValue("x_var_id"));
		}
		if (!$this->po_qty->FldIsDetailKey) {
			$this->po_qty->setFormValue($objForm->GetValue("x_po_qty"));
		}
		if (!$this->po_harga->FldIsDetailKey) {
			$this->po_harga->setFormValue($objForm->GetValue("x_po_harga"));
		}
		if (!$this->po_tempat_kirim->FldIsDetailKey) {
			$this->po_tempat_kirim->setFormValue($objForm->GetValue("x_po_tempat_kirim"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->po_id->CurrentValue = $this->po_id->FormValue;
		$this->po_tanggal->CurrentValue = $this->po_tanggal->FormValue;
		$this->po_tanggal->CurrentValue = ew_UnFormatDateTime($this->po_tanggal->CurrentValue, 2);
		$this->sup_id->CurrentValue = $this->sup_id->FormValue;
		$this->var_id->CurrentValue = $this->var_id->FormValue;
		$this->po_qty->CurrentValue = $this->po_qty->FormValue;
		$this->po_harga->CurrentValue = $this->po_harga->FormValue;
		$this->po_tempat_kirim->CurrentValue = $this->po_tempat_kirim->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->po_id->setDbValue($row['po_id']);
		$this->po_tanggal->setDbValue($row['po_tanggal']);
		$this->sup_id->setDbValue($row['sup_id']);
		if (array_key_exists('EV__sup_id', $rs->fields)) {
			$this->sup_id->VirtualValue = $rs->fields('EV__sup_id'); // Set up virtual field value
		} else {
			$this->sup_id->VirtualValue = ""; // Clear value
		}
		$this->var_id->setDbValue($row['var_id']);
		$this->po_qty->setDbValue($row['po_qty']);
		$this->po_harga->setDbValue($row['po_harga']);
		$this->po_tempat_kirim->setDbValue($row['po_tempat_kirim']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['po_id'] = NULL;
		$row['po_tanggal'] = NULL;
		$row['sup_id'] = NULL;
		$row['var_id'] = NULL;
		$row['po_qty'] = NULL;
		$row['po_harga'] = NULL;
		$row['po_tempat_kirim'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->po_id->DbValue = $row['po_id'];
		$this->po_tanggal->DbValue = $row['po_tanggal'];
		$this->sup_id->DbValue = $row['sup_id'];
		$this->var_id->DbValue = $row['var_id'];
		$this->po_qty->DbValue = $row['po_qty'];
		$this->po_harga->DbValue = $row['po_harga'];
		$this->po_tempat_kirim->DbValue = $row['po_tempat_kirim'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("po_id")) <> "")
			$this->po_id->CurrentValue = $this->getKey("po_id"); // po_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// po_id
		// po_tanggal
		// sup_id
		// var_id
		// po_qty
		// po_harga
		// po_tempat_kirim

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// po_id
		$this->po_id->ViewValue = $this->po_id->CurrentValue;
		$this->po_id->ViewCustomAttributes = "";

		// po_tanggal
		$this->po_tanggal->ViewValue = $this->po_tanggal->CurrentValue;
		$this->po_tanggal->ViewValue = ew_FormatDateTime($this->po_tanggal->ViewValue, 2);
		$this->po_tanggal->ViewCustomAttributes = "";

		// sup_id
		if ($this->sup_id->VirtualValue <> "") {
			$this->sup_id->ViewValue = $this->sup_id->VirtualValue;
		} else {
			$this->sup_id->ViewValue = $this->sup_id->CurrentValue;
		if (strval($this->sup_id->CurrentValue) <> "") {
			$sFilterWrk = "`sup_id`" . ew_SearchString("=", $this->sup_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sup_id`, `sup_nama` AS `DispFld`, `alamat` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `suplaiyer_ubi`";
		$sWhereWrk = "";
		$this->sup_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->sup_id->ViewValue = $this->sup_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sup_id->ViewValue = $this->sup_id->CurrentValue;
			}
		} else {
			$this->sup_id->ViewValue = NULL;
		}
		}
		$this->sup_id->ViewCustomAttributes = "";

		// var_id
		if (strval($this->var_id->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->var_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->var_id->ViewValue = $this->var_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->var_id->ViewValue = $this->var_id->CurrentValue;
			}
		} else {
			$this->var_id->ViewValue = NULL;
		}
		$this->var_id->ViewCustomAttributes = "";

		// po_qty
		$this->po_qty->ViewValue = $this->po_qty->CurrentValue;
		$this->po_qty->ViewCustomAttributes = "";

		// po_harga
		$this->po_harga->ViewValue = $this->po_harga->CurrentValue;
		$this->po_harga->ViewCustomAttributes = "";

		// po_tempat_kirim
		$this->po_tempat_kirim->ViewValue = $this->po_tempat_kirim->CurrentValue;
		$this->po_tempat_kirim->ViewCustomAttributes = "";

			// po_id
			$this->po_id->LinkCustomAttributes = "";
			$this->po_id->HrefValue = "";
			$this->po_id->TooltipValue = "";

			// po_tanggal
			$this->po_tanggal->LinkCustomAttributes = "";
			$this->po_tanggal->HrefValue = "";
			$this->po_tanggal->TooltipValue = "";

			// sup_id
			$this->sup_id->LinkCustomAttributes = "";
			$this->sup_id->HrefValue = "";
			$this->sup_id->TooltipValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			$this->var_id->HrefValue = "";
			$this->var_id->TooltipValue = "";

			// po_qty
			$this->po_qty->LinkCustomAttributes = "";
			$this->po_qty->HrefValue = "";
			$this->po_qty->TooltipValue = "";

			// po_harga
			$this->po_harga->LinkCustomAttributes = "";
			$this->po_harga->HrefValue = "";
			$this->po_harga->TooltipValue = "";

			// po_tempat_kirim
			$this->po_tempat_kirim->LinkCustomAttributes = "";
			$this->po_tempat_kirim->HrefValue = "";
			$this->po_tempat_kirim->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// po_id
			$this->po_id->EditAttrs["class"] = "form-control";
			$this->po_id->EditCustomAttributes = "";
			$this->po_id->EditValue = $this->po_id->CurrentValue;
			$this->po_id->ViewCustomAttributes = "";

			// po_tanggal
			$this->po_tanggal->EditAttrs["class"] = "form-control";
			$this->po_tanggal->EditCustomAttributes = "";
			$this->po_tanggal->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->po_tanggal->CurrentValue, 2));
			$this->po_tanggal->PlaceHolder = ew_RemoveHtml($this->po_tanggal->FldCaption());

			// sup_id
			$this->sup_id->EditAttrs["class"] = "form-control";
			$this->sup_id->EditCustomAttributes = "";
			$this->sup_id->EditValue = ew_HtmlEncode($this->sup_id->CurrentValue);
			$this->sup_id->PlaceHolder = ew_RemoveHtml($this->sup_id->FldCaption());

			// var_id
			$this->var_id->EditAttrs["class"] = "form-control";
			$this->var_id->EditCustomAttributes = "";
			if (trim(strval($this->var_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->var_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->var_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `var_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->var_id->EditValue = $arwrk;

			// po_qty
			$this->po_qty->EditAttrs["class"] = "form-control";
			$this->po_qty->EditCustomAttributes = "";
			$this->po_qty->EditValue = ew_HtmlEncode($this->po_qty->CurrentValue);
			$this->po_qty->PlaceHolder = ew_RemoveHtml($this->po_qty->FldCaption());

			// po_harga
			$this->po_harga->EditAttrs["class"] = "form-control";
			$this->po_harga->EditCustomAttributes = "";
			$this->po_harga->EditValue = ew_HtmlEncode($this->po_harga->CurrentValue);
			$this->po_harga->PlaceHolder = ew_RemoveHtml($this->po_harga->FldCaption());

			// po_tempat_kirim
			$this->po_tempat_kirim->EditAttrs["class"] = "form-control";
			$this->po_tempat_kirim->EditCustomAttributes = "";
			$this->po_tempat_kirim->EditValue = ew_HtmlEncode($this->po_tempat_kirim->CurrentValue);
			$this->po_tempat_kirim->PlaceHolder = ew_RemoveHtml($this->po_tempat_kirim->FldCaption());

			// Edit refer script
			// po_id

			$this->po_id->LinkCustomAttributes = "";
			$this->po_id->HrefValue = "";

			// po_tanggal
			$this->po_tanggal->LinkCustomAttributes = "";
			$this->po_tanggal->HrefValue = "";

			// sup_id
			$this->sup_id->LinkCustomAttributes = "";
			$this->sup_id->HrefValue = "";

			// var_id
			$this->var_id->LinkCustomAttributes = "";
			$this->var_id->HrefValue = "";

			// po_qty
			$this->po_qty->LinkCustomAttributes = "";
			$this->po_qty->HrefValue = "";

			// po_harga
			$this->po_harga->LinkCustomAttributes = "";
			$this->po_harga->HrefValue = "";

			// po_tempat_kirim
			$this->po_tempat_kirim->LinkCustomAttributes = "";
			$this->po_tempat_kirim->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->po_id->FldIsDetailKey && !is_null($this->po_id->FormValue) && $this->po_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->po_id->FldCaption(), $this->po_id->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->po_id->FormValue)) {
			ew_AddMessage($gsFormError, $this->po_id->FldErrMsg());
		}
		if (!$this->po_tanggal->FldIsDetailKey && !is_null($this->po_tanggal->FormValue) && $this->po_tanggal->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->po_tanggal->FldCaption(), $this->po_tanggal->ReqErrMsg));
		}
		if (!ew_CheckDateDef($this->po_tanggal->FormValue)) {
			ew_AddMessage($gsFormError, $this->po_tanggal->FldErrMsg());
		}
		if (!$this->sup_id->FldIsDetailKey && !is_null($this->sup_id->FormValue) && $this->sup_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->sup_id->FldCaption(), $this->sup_id->ReqErrMsg));
		}
		if (!$this->var_id->FldIsDetailKey && !is_null($this->var_id->FormValue) && $this->var_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->var_id->FldCaption(), $this->var_id->ReqErrMsg));
		}
		if (!$this->po_qty->FldIsDetailKey && !is_null($this->po_qty->FormValue) && $this->po_qty->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->po_qty->FldCaption(), $this->po_qty->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->po_qty->FormValue)) {
			ew_AddMessage($gsFormError, $this->po_qty->FldErrMsg());
		}
		if (!ew_CheckInteger($this->po_harga->FormValue)) {
			ew_AddMessage($gsFormError, $this->po_harga->FldErrMsg());
		}
		if (!$this->po_tempat_kirim->FldIsDetailKey && !is_null($this->po_tempat_kirim->FormValue) && $this->po_tempat_kirim->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->po_tempat_kirim->FldCaption(), $this->po_tempat_kirim->ReqErrMsg));
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// po_id
			// po_tanggal

			$this->po_tanggal->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->po_tanggal->CurrentValue, 2), NULL, $this->po_tanggal->ReadOnly);

			// sup_id
			$this->sup_id->SetDbValueDef($rsnew, $this->sup_id->CurrentValue, NULL, $this->sup_id->ReadOnly);

			// var_id
			$this->var_id->SetDbValueDef($rsnew, $this->var_id->CurrentValue, NULL, $this->var_id->ReadOnly);

			// po_qty
			$this->po_qty->SetDbValueDef($rsnew, $this->po_qty->CurrentValue, NULL, $this->po_qty->ReadOnly);

			// po_harga
			$this->po_harga->SetDbValueDef($rsnew, $this->po_harga->CurrentValue, NULL, $this->po_harga->ReadOnly);

			// po_tempat_kirim
			$this->po_tempat_kirim->SetDbValueDef($rsnew, $this->po_tempat_kirim->CurrentValue, NULL, $this->po_tempat_kirim->ReadOnly);

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("polist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_sup_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `sup_id` AS `LinkFld`, `sup_nama` AS `DispFld`, `alamat` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `suplaiyer_ubi`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`sup_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_var_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `var_id` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->var_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `var_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_sup_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `sup_id`, `sup_nama` AS `DispFld`, `alamat` AS `Disp2Fld` FROM `suplaiyer_ubi`";
			$sWhereWrk = "`sup_nama` LIKE '{query_value}%' OR CONCAT(COALESCE(`sup_nama`, ''),'" . ew_ValueSeparator(1, $this->sup_id) . "',COALESCE(`alamat`,'')) LIKE '{query_value}%'";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sup_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sup_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($po_edit)) $po_edit = new cpo_edit();

// Page init
$po_edit->Page_Init();

// Page main
$po_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fpoedit = new ew_Form("fpoedit", "edit");

// Validate form
fpoedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_po_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $po->po_id->FldCaption(), $po->po_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_po_id");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($po->po_id->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_po_tanggal");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $po->po_tanggal->FldCaption(), $po->po_tanggal->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_po_tanggal");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($po->po_tanggal->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_sup_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $po->sup_id->FldCaption(), $po->sup_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_var_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $po->var_id->FldCaption(), $po->var_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_po_qty");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $po->po_qty->FldCaption(), $po->po_qty->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_po_qty");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($po->po_qty->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_po_harga");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($po->po_harga->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_po_tempat_kirim");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $po->po_tempat_kirim->FldCaption(), $po->po_tempat_kirim->ReqErrMsg)) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpoedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fpoedit.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpoedit.Lists["x_sup_id"] = {"LinkField":"x_sup_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_sup_nama","x_alamat","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"suplaiyer_ubi"};
fpoedit.Lists["x_sup_id"].Data = "<?php echo $po_edit->sup_id->LookupFilterQuery(FALSE, "edit") ?>";
fpoedit.AutoSuggests["x_sup_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $po_edit->sup_id->LookupFilterQuery(TRUE, "edit"))) ?>;
fpoedit.Lists["x_var_id"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
fpoedit.Lists["x_var_id"].Data = "<?php echo $po_edit->var_id->LookupFilterQuery(FALSE, "edit") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $po_edit->ShowPageHeader(); ?>
<?php
$po_edit->ShowMessage();
?>
<form name="fpoedit" id="fpoedit" class="<?php echo $po_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($po_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $po_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<input type="hidden" name="modal" value="<?php echo intval($po_edit->IsModal) ?>">
<div class="ewEditDiv"><!-- page* -->
<?php if ($po->po_id->Visible) { // po_id ?>
	<div id="r_po_id" class="form-group">
		<label id="elh_po_po_id" for="x_po_id" class="<?php echo $po_edit->LeftColumnClass ?>"><?php echo $po->po_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $po_edit->RightColumnClass ?>"><div<?php echo $po->po_id->CellAttributes() ?>>
<span id="el_po_po_id">
<span<?php echo $po->po_id->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $po->po_id->EditValue ?></p></span>
</span>
<input type="hidden" data-table="po" data-field="x_po_id" name="x_po_id" id="x_po_id" value="<?php echo ew_HtmlEncode($po->po_id->CurrentValue) ?>">
<?php echo $po->po_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->po_tanggal->Visible) { // po_tanggal ?>
	<div id="r_po_tanggal" class="form-group">
		<label id="elh_po_po_tanggal" for="x_po_tanggal" class="<?php echo $po_edit->LeftColumnClass ?>"><?php echo $po->po_tanggal->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $po_edit->RightColumnClass ?>"><div<?php echo $po->po_tanggal->CellAttributes() ?>>
<span id="el_po_po_tanggal">
<input type="text" data-table="po" data-field="x_po_tanggal" data-format="2" name="x_po_tanggal" id="x_po_tanggal" placeholder="<?php echo ew_HtmlEncode($po->po_tanggal->getPlaceHolder()) ?>" value="<?php echo $po->po_tanggal->EditValue ?>"<?php echo $po->po_tanggal->EditAttributes() ?>>
<?php if (!$po->po_tanggal->ReadOnly && !$po->po_tanggal->Disabled && !isset($po->po_tanggal->EditAttrs["readonly"]) && !isset($po->po_tanggal->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fpoedit", "x_po_tanggal", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $po->po_tanggal->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->sup_id->Visible) { // sup_id ?>
	<div id="r_sup_id" class="form-group">
		<label id="elh_po_sup_id" class="<?php echo $po_edit->LeftColumnClass ?>"><?php echo $po->sup_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $po_edit->RightColumnClass ?>"><div<?php echo $po->sup_id->CellAttributes() ?>>
<span id="el_po_sup_id">
<?php
$wrkonchange = trim(" " . @$po->sup_id->EditAttrs["onchange"]);
if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ew_JsEncode2($wrkonchange) . "\"";
$po->sup_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_sup_id" style="white-space: nowrap; z-index: 8970">
	<input type="text" name="sv_x_sup_id" id="sv_x_sup_id" value="<?php echo $po->sup_id->EditValue ?>" size="30" placeholder="<?php echo ew_HtmlEncode($po->sup_id->getPlaceHolder()) ?>" data-placeholder="<?php echo ew_HtmlEncode($po->sup_id->getPlaceHolder()) ?>"<?php echo $po->sup_id->EditAttributes() ?>>
</span>
<input type="hidden" data-table="po" data-field="x_sup_id" data-value-separator="<?php echo $po->sup_id->DisplayValueSeparatorAttribute() ?>" name="x_sup_id" id="x_sup_id" value="<?php echo ew_HtmlEncode($po->sup_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script type="text/javascript">
fpoedit.CreateAutoSuggest({"id":"x_sup_id","forceSelect":false});
</script>
</span>
<?php echo $po->sup_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->var_id->Visible) { // var_id ?>
	<div id="r_var_id" class="form-group">
		<label id="elh_po_var_id" for="x_var_id" class="<?php echo $po_edit->LeftColumnClass ?>"><?php echo $po->var_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $po_edit->RightColumnClass ?>"><div<?php echo $po->var_id->CellAttributes() ?>>
<span id="el_po_var_id">
<select data-table="po" data-field="x_var_id" data-value-separator="<?php echo $po->var_id->DisplayValueSeparatorAttribute() ?>" id="x_var_id" name="x_var_id"<?php echo $po->var_id->EditAttributes() ?>>
<?php echo $po->var_id->SelectOptionListHtml("x_var_id") ?>
</select>
</span>
<?php echo $po->var_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->po_qty->Visible) { // po_qty ?>
	<div id="r_po_qty" class="form-group">
		<label id="elh_po_po_qty" for="x_po_qty" class="<?php echo $po_edit->LeftColumnClass ?>"><?php echo $po->po_qty->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $po_edit->RightColumnClass ?>"><div<?php echo $po->po_qty->CellAttributes() ?>>
<span id="el_po_po_qty">
<input type="text" data-table="po" data-field="x_po_qty" name="x_po_qty" id="x_po_qty" size="30" placeholder="<?php echo ew_HtmlEncode($po->po_qty->getPlaceHolder()) ?>" value="<?php echo $po->po_qty->EditValue ?>"<?php echo $po->po_qty->EditAttributes() ?>>
</span>
<?php echo $po->po_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->po_harga->Visible) { // po_harga ?>
	<div id="r_po_harga" class="form-group">
		<label id="elh_po_po_harga" for="x_po_harga" class="<?php echo $po_edit->LeftColumnClass ?>"><?php echo $po->po_harga->FldCaption() ?></label>
		<div class="<?php echo $po_edit->RightColumnClass ?>"><div<?php echo $po->po_harga->CellAttributes() ?>>
<span id="el_po_po_harga">
<input type="text" data-table="po" data-field="x_po_harga" name="x_po_harga" id="x_po_harga" size="30" placeholder="<?php echo ew_HtmlEncode($po->po_harga->getPlaceHolder()) ?>" value="<?php echo $po->po_harga->EditValue ?>"<?php echo $po->po_harga->EditAttributes() ?>>
</span>
<?php echo $po->po_harga->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po->po_tempat_kirim->Visible) { // po_tempat_kirim ?>
	<div id="r_po_tempat_kirim" class="form-group">
		<label id="elh_po_po_tempat_kirim" for="x_po_tempat_kirim" class="<?php echo $po_edit->LeftColumnClass ?>"><?php echo $po->po_tempat_kirim->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $po_edit->RightColumnClass ?>"><div<?php echo $po->po_tempat_kirim->CellAttributes() ?>>
<span id="el_po_po_tempat_kirim">
<input type="text" data-table="po" data-field="x_po_tempat_kirim" name="x_po_tempat_kirim" id="x_po_tempat_kirim" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($po->po_tempat_kirim->getPlaceHolder()) ?>" value="<?php echo $po->po_tempat_kirim->EditValue ?>"<?php echo $po->po_tempat_kirim->EditAttributes() ?>>
</span>
<?php echo $po->po_tempat_kirim->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_edit->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $po_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $po_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fpoedit.Init();
</script>
<?php
$po_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_edit->Page_Terminate();
?>
