<?php

// Global variable for table object
$petani = NULL;

//
// Table class for petani
//
class cpetani extends cTable {
	var $pet_id;
	var $pet_nama;
	var $pet_hp;
	var $prov_id;
	var $kab_id;
	var $kec_id;
	var $desa_id;
	var $pet_alamat;
	var $pet_foto;
	var $co_id;
	var $koord_id;
	var $tr_id;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'petani';
		$this->TableName = 'petani';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`petani`";
		$this->DBID = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PHPExcel only)
		$this->ExportExcelPageSize = ""; // Page size (PHPExcel only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// pet_id
		$this->pet_id = new cField('petani', 'petani', 'x_pet_id', 'pet_id', '`pet_id`', '`pet_id`', 3, -1, FALSE, '`pet_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pet_id->Sortable = TRUE; // Allow sort
		$this->pet_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['pet_id'] = &$this->pet_id;

		// pet_nama
		$this->pet_nama = new cField('petani', 'petani', 'x_pet_nama', 'pet_nama', '`pet_nama`', '`pet_nama`', 200, -1, FALSE, '`pet_nama`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pet_nama->Sortable = TRUE; // Allow sort
		$this->fields['pet_nama'] = &$this->pet_nama;

		// pet_hp
		$this->pet_hp = new cField('petani', 'petani', 'x_pet_hp', 'pet_hp', '`pet_hp`', '`pet_hp`', 200, -1, FALSE, '`pet_hp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pet_hp->Sortable = TRUE; // Allow sort
		$this->pet_hp->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['pet_hp'] = &$this->pet_hp;

		// prov_id
		$this->prov_id = new cField('petani', 'petani', 'x_prov_id', 'prov_id', '`prov_id`', '`prov_id`', 3, -1, FALSE, '`prov_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->prov_id->Sortable = TRUE; // Allow sort
		$this->prov_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->prov_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->prov_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['prov_id'] = &$this->prov_id;

		// kab_id
		$this->kab_id = new cField('petani', 'petani', 'x_kab_id', 'kab_id', '`kab_id`', '`kab_id`', 3, -1, FALSE, '`kab_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->kab_id->Sortable = TRUE; // Allow sort
		$this->kab_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->kab_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->kab_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['kab_id'] = &$this->kab_id;

		// kec_id
		$this->kec_id = new cField('petani', 'petani', 'x_kec_id', 'kec_id', '`kec_id`', '`kec_id`', 3, -1, FALSE, '`kec_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->kec_id->Sortable = TRUE; // Allow sort
		$this->kec_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->kec_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->kec_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['kec_id'] = &$this->kec_id;

		// desa_id
		$this->desa_id = new cField('petani', 'petani', 'x_desa_id', 'desa_id', '`desa_id`', '`desa_id`', 3, -1, FALSE, '`desa_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->desa_id->Sortable = TRUE; // Allow sort
		$this->desa_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->desa_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->desa_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['desa_id'] = &$this->desa_id;

		// pet_alamat
		$this->pet_alamat = new cField('petani', 'petani', 'x_pet_alamat', 'pet_alamat', '`pet_alamat`', '`pet_alamat`', 200, -1, FALSE, '`pet_alamat`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pet_alamat->Sortable = TRUE; // Allow sort
		$this->fields['pet_alamat'] = &$this->pet_alamat;

		// pet_foto
		$this->pet_foto = new cField('petani', 'petani', 'x_pet_foto', 'pet_foto', '`pet_foto`', '`pet_foto`', 200, -1, TRUE, '`pet_foto`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->pet_foto->Sortable = TRUE; // Allow sort
		$this->pet_foto->ImageResize = TRUE;
		$this->fields['pet_foto'] = &$this->pet_foto;

		// co_id
		$this->co_id = new cField('petani', 'petani', 'x_co_id', 'co_id', '`co_id`', '`co_id`', 3, -1, FALSE, '`co_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->co_id->Sortable = TRUE; // Allow sort
		$this->co_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->co_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->co_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['co_id'] = &$this->co_id;

		// koord_id
		$this->koord_id = new cField('petani', 'petani', 'x_koord_id', 'koord_id', '`koord_id`', '`koord_id`', 3, -1, FALSE, '`EV__koord_id`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->koord_id->Sortable = TRUE; // Allow sort
		$this->koord_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['koord_id'] = &$this->koord_id;

		// tr_id
		$this->tr_id = new cField('petani', 'petani', 'x_tr_id', 'tr_id', '`tr_id`', '`tr_id`', 3, -1, FALSE, '`tr_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->tr_id->Sortable = TRUE; // Allow sort
		$this->tr_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->tr_id->PleaseSelectText = $Language->Phrase("PleaseSelect"); // PleaseSelect text
		$this->tr_id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['tr_id'] = &$this->tr_id;
	}

	// Field Visibility
	function GetFieldVisibility($fldparm) {
		global $Security;
		return $this->$fldparm->Visible; // Returns original value
	}

	// Column CSS classes
	var $LeftColumnClass = "col-sm-2 control-label ewLabel";
	var $RightColumnClass = "col-sm-10";
	var $OffsetColumnClass = "col-sm-10 col-sm-offset-2";

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function SetLeftColumnClass($class) {
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " control-label ewLabel";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - intval($match[2]));
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace($match[1], $match[1] + "-offset", $class);
		}
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
			$sSortFieldList = ($ofld->FldVirtualExpression <> "") ? $ofld->FldVirtualExpression : $sSortField;
			$this->setSessionOrderByList($sSortFieldList . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Session ORDER BY for List page
	function getSessionOrderByList() {
		return @$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_ORDER_BY_LIST];
	}

	function setSessionOrderByList($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	var $_SqlFrom = "";

	function getSqlFrom() { // From
		return ($this->_SqlFrom <> "") ? $this->_SqlFrom : "`petani`";
	}

	function SqlFrom() { // For backward compatibility
		return $this->getSqlFrom();
	}

	function setSqlFrom($v) {
		$this->_SqlFrom = $v;
	}
	var $_SqlSelect = "";

	function getSqlSelect() { // Select
		return ($this->_SqlSelect <> "") ? $this->_SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}

	function SqlSelect() { // For backward compatibility
		return $this->getSqlSelect();
	}

	function setSqlSelect($v) {
		$this->_SqlSelect = $v;
	}
	var $_SqlSelectList = "";

	function getSqlSelectList() { // Select for List page
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT CONCAT(COALESCE(`koord_nama`, ''),'" . ew_ValueSeparator(1, $this->koord_id) . "',COALESCE(`koord_alamat`,'')) FROM `koord` `EW_TMP_LOOKUPTABLE` WHERE `EW_TMP_LOOKUPTABLE`.`koord_id` = `petani`.`koord_id` LIMIT 1) AS `EV__koord_id` FROM `petani`" .
			") `EW_TMP_TABLE`";
		return ($this->_SqlSelectList <> "") ? $this->_SqlSelectList : $select;
	}

	function SqlSelectList() { // For backward compatibility
		return $this->getSqlSelectList();
	}

	function setSqlSelectList($v) {
		$this->_SqlSelectList = $v;
	}
	var $_SqlWhere = "";

	function getSqlWhere() { // Where
		$sWhere = ($this->_SqlWhere <> "") ? $this->_SqlWhere : "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlWhere() { // For backward compatibility
		return $this->getSqlWhere();
	}

	function setSqlWhere($v) {
		$this->_SqlWhere = $v;
	}
	var $_SqlGroupBy = "";

	function getSqlGroupBy() { // Group By
		return ($this->_SqlGroupBy <> "") ? $this->_SqlGroupBy : "";
	}

	function SqlGroupBy() { // For backward compatibility
		return $this->getSqlGroupBy();
	}

	function setSqlGroupBy($v) {
		$this->_SqlGroupBy = $v;
	}
	var $_SqlHaving = "";

	function getSqlHaving() { // Having
		return ($this->_SqlHaving <> "") ? $this->_SqlHaving : "";
	}

	function SqlHaving() { // For backward compatibility
		return $this->getSqlHaving();
	}

	function setSqlHaving($v) {
		$this->_SqlHaving = $v;
	}
	var $_SqlOrderBy = "";

	function getSqlOrderBy() { // Order By
		return ($this->_SqlOrderBy <> "") ? $this->_SqlOrderBy : "";
	}

	function SqlOrderBy() { // For backward compatibility
		return $this->getSqlOrderBy();
	}

	function setSqlOrderBy($v) {
		$this->_SqlOrderBy = $v;
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = EW_USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$filter = $this->CurrentFilter;
		$filter = $this->ApplyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->GetSQL($filter, $sort);
	}

	// Table SQL with List page filter
	var $UseSessionForListSQL = TRUE;

	function ListSQL() {
		$sFilter = $this->UseSessionForListSQL ? $this->getSessionWhere() : "";
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$this->Recordset_Selecting($sFilter);
		if ($this->UseVirtualFields()) {
			$sSelect = $this->getSqlSelectList();
			$sSort = $this->UseSessionForListSQL ? $this->getSessionOrderByList() : "";
		} else {
			$sSelect = $this->getSqlSelect();
			$sSort = $this->UseSessionForListSQL ? $this->getSessionOrderBy() : "";
		}
		return ew_BuildSelectSql($sSelect, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = ($this->UseVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sSort);
	}

	// Check if virtual fields is used in SQL
	function UseVirtualFields() {
		$sWhere = $this->UseSessionForListSQL ? $this->getSessionWhere() : $this->CurrentFilter;
		$sOrderBy = $this->UseSessionForListSQL ? $this->getSessionOrderByList() : "";
		if ($sWhere <> "")
			$sWhere = " " . str_replace(array("(",")"), array("",""), $sWhere) . " ";
		if ($sOrderBy <> "")
			$sOrderBy = " " . str_replace(array("(",")"), array("",""), $sOrderBy) . " ";
		if ($this->koord_id->AdvancedSearch->SearchValue <> "" ||
			$this->koord_id->AdvancedSearch->SearchValue2 <> "" ||
			strpos($sWhere, " " . $this->koord_id->FldVirtualExpression . " ") !== FALSE)
			return TRUE;
		if (strpos($sOrderBy, " " . $this->koord_id->FldVirtualExpression . " ") !== FALSE)
			return TRUE;
		return FALSE;
	}

	// Try to get record count
	function TryGetRecordCount($sql) {
		$cnt = -1;
		$pattern = "/^SELECT \* FROM/i";
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') && preg_match($pattern, $sql)) {
			$sql = "SELECT COUNT(*) FROM" . preg_replace($pattern, "", $sql);
		} else {
			$sql = "SELECT COUNT(*) FROM (" . $sql . ") EW_COUNT_TABLE";
		}
		$conn = &$this->Connection();
		if ($rs = $conn->Execute($sql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($filter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = ew_BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function ListRecordCount() {
		$filter = $this->getSessionWhere();
		ew_AddFilter($filter, $this->CurrentFilter);
		$filter = $this->ApplyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->UseVirtualFields())
			$sql = ew_BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = ew_BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->TryGetRecordCount($sql);
		if ($cnt == -1) {
			$conn = &$this->Connection();
			if ($rs = $conn->Execute($sql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// INSERT statement
	function InsertSQL(&$rs) {
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		$conn = &$this->Connection();
		$bInsert = $conn->Execute($this->InsertSQL($rs));
		if ($bInsert) {

			// Get insert id if necessary
			$this->pet_id->setDbValue($conn->Insert_ID());
			$rs['pet_id'] = $this->pet_id->DbValue;
		}
		return $bInsert;
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE) {
		$conn = &$this->Connection();
		$bUpdate = $conn->Execute($this->UpdateSQL($rs, $where, $curfilter));
		return $bUpdate;
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		if ($rs) {
			if (array_key_exists('pet_id', $rs))
				ew_AddFilter($where, ew_QuotedName('pet_id', $this->DBID) . '=' . ew_QuotedValue($rs['pet_id'], $this->pet_id->FldDataType, $this->DBID));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "", $curfilter = TRUE) {
		$bDelete = TRUE;
		$conn = &$this->Connection();
		if ($bDelete)
			$bDelete = $conn->Execute($this->DeleteSQL($rs, $where, $curfilter));
		return $bDelete;
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "`pet_id` = @pet_id@";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		if (!is_numeric($this->pet_id->CurrentValue))
			return "0=1"; // Invalid key
		if (is_null($this->pet_id->CurrentValue))
			return "0=1"; // Invalid key
		else
			$sKeyFilter = str_replace("@pet_id@", ew_AdjustSql($this->pet_id->CurrentValue, $this->DBID), $sKeyFilter); // Replace key value
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "petanilist.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	function GetModalCaption($pageName) {
		global $Language;
		if ($pageName == "petaniview.php")
			return $Language->Phrase("View");
		elseif ($pageName == "petaniedit.php")
			return $Language->Phrase("Edit");
		elseif ($pageName == "petaniadd.php")
			return $Language->Phrase("Add");
		else
			return "";
	}

	// List URL
	function GetListUrl() {
		return "petanilist.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			$url = $this->KeyUrl("petaniview.php", $this->UrlParm($parm));
		else
			$url = $this->KeyUrl("petaniview.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
		return $this->AddMasterUrl($url);
	}

	// Add URL
	function GetAddUrl($parm = "") {
		if ($parm <> "")
			$url = "petaniadd.php?" . $this->UrlParm($parm);
		else
			$url = "petaniadd.php";
		return $this->AddMasterUrl($url);
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		$url = $this->KeyUrl("petaniedit.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
		return $this->AddMasterUrl($url);
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		$url = $this->KeyUrl("petaniadd.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
		return $this->AddMasterUrl($url);
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("petanidelete.php", $this->UrlParm());
	}

	// Add master url
	function AddMasterUrl($url) {
		return $url;
	}

	function KeyToJson() {
		$json = "";
		$json .= "pet_id:" . ew_VarToJson($this->pet_id->CurrentValue, "number", "'");
		return "{" . $json . "}";
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->pet_id->CurrentValue)) {
			$sUrl .= "pet_id=" . urlencode($this->pet_id->CurrentValue);
		} else {
			return "javascript:ew_Alert(ewLanguage.Phrase('InvalidRecord'));";
		}
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&amp;ordertype=" . $fld->ReverseSort());
			return $this->AddMasterUrl(ew_CurrentPage() . "?" . $sUrlParm);
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = $_POST["key_m"];
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = $_GET["key_m"];
			$cnt = count($arKeys);
		} elseif (!empty($_GET) || !empty($_POST)) {
			$isPost = ew_IsPost();
			if ($isPost && isset($_POST["pet_id"]))
				$arKeys[] = $_POST["pet_id"];
			elseif (isset($_GET["pet_id"]))
				$arKeys[] = $_GET["pet_id"];
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$this->pet_id->CurrentValue = $key;
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($filter) {

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $filter;
		//$sql = $this->SQL();

		$sql = $this->GetSQL($filter, "");
		$conn = &$this->Connection();
		$rs = $conn->Execute($sql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->pet_id->setDbValue($rs->fields('pet_id'));
		$this->pet_nama->setDbValue($rs->fields('pet_nama'));
		$this->pet_hp->setDbValue($rs->fields('pet_hp'));
		$this->prov_id->setDbValue($rs->fields('prov_id'));
		$this->kab_id->setDbValue($rs->fields('kab_id'));
		$this->kec_id->setDbValue($rs->fields('kec_id'));
		$this->desa_id->setDbValue($rs->fields('desa_id'));
		$this->pet_alamat->setDbValue($rs->fields('pet_alamat'));
		$this->pet_foto->Upload->DbValue = $rs->fields('pet_foto');
		$this->co_id->setDbValue($rs->fields('co_id'));
		$this->koord_id->setDbValue($rs->fields('koord_id'));
		$this->tr_id->setDbValue($rs->fields('tr_id'));
	}

	// Render list row values
	function RenderListRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

	// Common render codes
		// pet_id
		// pet_nama
		// pet_hp
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// pet_alamat
		// pet_foto
		// co_id
		// koord_id
		// tr_id
		// pet_id

		$this->pet_id->ViewValue = $this->pet_id->CurrentValue;
		$this->pet_id->ViewCustomAttributes = "";

		// pet_nama
		$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
		$this->pet_nama->ViewCustomAttributes = "";

		// pet_hp
		$this->pet_hp->ViewValue = $this->pet_hp->CurrentValue;
		$this->pet_hp->ViewCustomAttributes = "";

		// prov_id
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		$this->desa_id->ViewCustomAttributes = "";

		// pet_alamat
		$this->pet_alamat->ViewValue = $this->pet_alamat->CurrentValue;
		$this->pet_alamat->ViewCustomAttributes = "";

		// pet_foto
		$this->pet_foto->UploadPath = "foto_petani";
		if (!ew_Empty($this->pet_foto->Upload->DbValue)) {
			$this->pet_foto->ImageWidth = 30;
			$this->pet_foto->ImageHeight = 40;
			$this->pet_foto->ImageAlt = $this->pet_foto->FldAlt();
			$this->pet_foto->ViewValue = $this->pet_foto->Upload->DbValue;
		} else {
			$this->pet_foto->ViewValue = "";
		}
		$this->pet_foto->ViewCustomAttributes = "";

		// co_id
		if (strval($this->co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_id->ViewValue = $this->co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_id->ViewValue = $this->co_id->CurrentValue;
			}
		} else {
			$this->co_id->ViewValue = NULL;
		}
		$this->co_id->ViewCustomAttributes = "";

		// koord_id
		if ($this->koord_id->VirtualValue <> "") {
			$this->koord_id->ViewValue = $this->koord_id->VirtualValue;
		} else {
			$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
		if (strval($this->koord_id->CurrentValue) <> "") {
			$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, `koord_alamat` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->koord_id->ViewValue = $this->koord_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
			}
		} else {
			$this->koord_id->ViewValue = NULL;
		}
		}
		$this->koord_id->ViewCustomAttributes = "";

		// tr_id
		if (strval($this->tr_id->CurrentValue) <> "") {
			$sFilterWrk = "`tr_id`" . ew_SearchString("=", $this->tr_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `tr_id`, `tr_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tingkat_resiko`";
		$sWhereWrk = "";
		$this->tr_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->tr_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `tr_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->tr_id->ViewValue = $this->tr_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->tr_id->ViewValue = $this->tr_id->CurrentValue;
			}
		} else {
			$this->tr_id->ViewValue = NULL;
		}
		$this->tr_id->ViewCustomAttributes = "";

		// pet_id
		$this->pet_id->LinkCustomAttributes = "";
		$this->pet_id->HrefValue = "";
		$this->pet_id->TooltipValue = "";

		// pet_nama
		$this->pet_nama->LinkCustomAttributes = "";
		$this->pet_nama->HrefValue = "";
		$this->pet_nama->TooltipValue = "";

		// pet_hp
		$this->pet_hp->LinkCustomAttributes = "";
		$this->pet_hp->HrefValue = "";
		$this->pet_hp->TooltipValue = "";

		// prov_id
		$this->prov_id->LinkCustomAttributes = "";
		$this->prov_id->HrefValue = "";
		$this->prov_id->TooltipValue = "";

		// kab_id
		$this->kab_id->LinkCustomAttributes = "";
		$this->kab_id->HrefValue = "";
		$this->kab_id->TooltipValue = "";

		// kec_id
		$this->kec_id->LinkCustomAttributes = "";
		$this->kec_id->HrefValue = "";
		$this->kec_id->TooltipValue = "";

		// desa_id
		$this->desa_id->LinkCustomAttributes = "";
		$this->desa_id->HrefValue = "";
		$this->desa_id->TooltipValue = "";

		// pet_alamat
		$this->pet_alamat->LinkCustomAttributes = "";
		$this->pet_alamat->HrefValue = "";
		$this->pet_alamat->TooltipValue = "";

		// pet_foto
		$this->pet_foto->LinkCustomAttributes = "";
		$this->pet_foto->UploadPath = "foto_petani";
		if (!ew_Empty($this->pet_foto->Upload->DbValue)) {
			$this->pet_foto->HrefValue = ew_GetFileUploadUrl($this->pet_foto, $this->pet_foto->Upload->DbValue); // Add prefix/suffix
			$this->pet_foto->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->Export <> "") $this->pet_foto->HrefValue = ew_FullUrl($this->pet_foto->HrefValue, "href");
		} else {
			$this->pet_foto->HrefValue = "";
		}
		$this->pet_foto->HrefValue2 = $this->pet_foto->UploadPath . $this->pet_foto->Upload->DbValue;
		$this->pet_foto->TooltipValue = "";
		if ($this->pet_foto->UseColorbox) {
			if (ew_Empty($this->pet_foto->TooltipValue))
				$this->pet_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
			$this->pet_foto->LinkAttrs["data-rel"] = "petani_x_pet_foto";
			ew_AppendClass($this->pet_foto->LinkAttrs["class"], "ewLightbox");
		}

		// co_id
		$this->co_id->LinkCustomAttributes = "";
		$this->co_id->HrefValue = "";
		$this->co_id->TooltipValue = "";

		// koord_id
		$this->koord_id->LinkCustomAttributes = "";
		$this->koord_id->HrefValue = "";
		$this->koord_id->TooltipValue = "";

		// tr_id
		$this->tr_id->LinkCustomAttributes = "";
		$this->tr_id->HrefValue = "";
		$this->tr_id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->CustomTemplateFieldValues();
	}

	// Render edit row values
	function RenderEditRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// pet_id
		$this->pet_id->EditAttrs["class"] = "form-control";
		$this->pet_id->EditCustomAttributes = "";
		$this->pet_id->EditValue = $this->pet_id->CurrentValue;
		$this->pet_id->ViewCustomAttributes = "";

		// pet_nama
		$this->pet_nama->EditAttrs["class"] = "form-control";
		$this->pet_nama->EditCustomAttributes = "";
		$this->pet_nama->EditValue = $this->pet_nama->CurrentValue;
		$this->pet_nama->PlaceHolder = ew_RemoveHtml($this->pet_nama->FldCaption());

		// pet_hp
		$this->pet_hp->EditAttrs["class"] = "form-control";
		$this->pet_hp->EditCustomAttributes = "";
		$this->pet_hp->EditValue = $this->pet_hp->CurrentValue;
		$this->pet_hp->PlaceHolder = ew_RemoveHtml($this->pet_hp->FldCaption());

		// prov_id
		$this->prov_id->EditAttrs["class"] = "form-control";
		$this->prov_id->EditCustomAttributes = "";

		// kab_id
		$this->kab_id->EditAttrs["class"] = "form-control";
		$this->kab_id->EditCustomAttributes = "";

		// kec_id
		$this->kec_id->EditAttrs["class"] = "form-control";
		$this->kec_id->EditCustomAttributes = "";

		// desa_id
		$this->desa_id->EditAttrs["class"] = "form-control";
		$this->desa_id->EditCustomAttributes = "";

		// pet_alamat
		$this->pet_alamat->EditAttrs["class"] = "form-control";
		$this->pet_alamat->EditCustomAttributes = "";
		$this->pet_alamat->EditValue = $this->pet_alamat->CurrentValue;
		$this->pet_alamat->PlaceHolder = ew_RemoveHtml($this->pet_alamat->FldCaption());

		// pet_foto
		$this->pet_foto->EditAttrs["class"] = "form-control";
		$this->pet_foto->EditCustomAttributes = "";
		$this->pet_foto->UploadPath = "foto_petani";
		if (!ew_Empty($this->pet_foto->Upload->DbValue)) {
			$this->pet_foto->ImageWidth = 30;
			$this->pet_foto->ImageHeight = 40;
			$this->pet_foto->ImageAlt = $this->pet_foto->FldAlt();
			$this->pet_foto->EditValue = $this->pet_foto->Upload->DbValue;
		} else {
			$this->pet_foto->EditValue = "";
		}
		if (!ew_Empty($this->pet_foto->CurrentValue))
				$this->pet_foto->Upload->FileName = $this->pet_foto->CurrentValue;

		// co_id
		$this->co_id->EditAttrs["class"] = "form-control";
		$this->co_id->EditCustomAttributes = "";

		// koord_id
		$this->koord_id->EditAttrs["class"] = "form-control";
		$this->koord_id->EditCustomAttributes = "";
		$this->koord_id->EditValue = $this->koord_id->CurrentValue;
		$this->koord_id->PlaceHolder = ew_RemoveHtml($this->koord_id->FldCaption());

		// tr_id
		$this->tr_id->EditAttrs["class"] = "form-control";
		$this->tr_id->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {

		// Call Row Rendered event
		$this->Row_Rendered();
	}
	var $ExportDoc;

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;
		if (!$Doc->ExportCustom) {

			// Write header
			$Doc->ExportTableHeader();
			if ($Doc->Horizontal) { // Horizontal format, write header
				$Doc->BeginExportRow();
				if ($ExportPageType == "view") {
					if ($this->pet_id->Exportable) $Doc->ExportCaption($this->pet_id);
					if ($this->pet_nama->Exportable) $Doc->ExportCaption($this->pet_nama);
					if ($this->pet_hp->Exportable) $Doc->ExportCaption($this->pet_hp);
					if ($this->prov_id->Exportable) $Doc->ExportCaption($this->prov_id);
					if ($this->kab_id->Exportable) $Doc->ExportCaption($this->kab_id);
					if ($this->kec_id->Exportable) $Doc->ExportCaption($this->kec_id);
					if ($this->desa_id->Exportable) $Doc->ExportCaption($this->desa_id);
					if ($this->pet_alamat->Exportable) $Doc->ExportCaption($this->pet_alamat);
					if ($this->pet_foto->Exportable) $Doc->ExportCaption($this->pet_foto);
					if ($this->co_id->Exportable) $Doc->ExportCaption($this->co_id);
					if ($this->koord_id->Exportable) $Doc->ExportCaption($this->koord_id);
					if ($this->tr_id->Exportable) $Doc->ExportCaption($this->tr_id);
				} else {
					if ($this->pet_id->Exportable) $Doc->ExportCaption($this->pet_id);
					if ($this->pet_nama->Exportable) $Doc->ExportCaption($this->pet_nama);
					if ($this->pet_hp->Exportable) $Doc->ExportCaption($this->pet_hp);
					if ($this->prov_id->Exportable) $Doc->ExportCaption($this->prov_id);
					if ($this->kab_id->Exportable) $Doc->ExportCaption($this->kab_id);
					if ($this->kec_id->Exportable) $Doc->ExportCaption($this->kec_id);
					if ($this->desa_id->Exportable) $Doc->ExportCaption($this->desa_id);
					if ($this->pet_alamat->Exportable) $Doc->ExportCaption($this->pet_alamat);
					if ($this->pet_foto->Exportable) $Doc->ExportCaption($this->pet_foto);
					if ($this->co_id->Exportable) $Doc->ExportCaption($this->co_id);
					if ($this->koord_id->Exportable) $Doc->ExportCaption($this->koord_id);
					if ($this->tr_id->Exportable) $Doc->ExportCaption($this->tr_id);
				}
				$Doc->EndExportRow();
			}
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				if (!$Doc->ExportCustom) {
					$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
					if ($ExportPageType == "view") {
						if ($this->pet_id->Exportable) $Doc->ExportField($this->pet_id);
						if ($this->pet_nama->Exportable) $Doc->ExportField($this->pet_nama);
						if ($this->pet_hp->Exportable) $Doc->ExportField($this->pet_hp);
						if ($this->prov_id->Exportable) $Doc->ExportField($this->prov_id);
						if ($this->kab_id->Exportable) $Doc->ExportField($this->kab_id);
						if ($this->kec_id->Exportable) $Doc->ExportField($this->kec_id);
						if ($this->desa_id->Exportable) $Doc->ExportField($this->desa_id);
						if ($this->pet_alamat->Exportable) $Doc->ExportField($this->pet_alamat);
						if ($this->pet_foto->Exportable) $Doc->ExportField($this->pet_foto);
						if ($this->co_id->Exportable) $Doc->ExportField($this->co_id);
						if ($this->koord_id->Exportable) $Doc->ExportField($this->koord_id);
						if ($this->tr_id->Exportable) $Doc->ExportField($this->tr_id);
					} else {
						if ($this->pet_id->Exportable) $Doc->ExportField($this->pet_id);
						if ($this->pet_nama->Exportable) $Doc->ExportField($this->pet_nama);
						if ($this->pet_hp->Exportable) $Doc->ExportField($this->pet_hp);
						if ($this->prov_id->Exportable) $Doc->ExportField($this->prov_id);
						if ($this->kab_id->Exportable) $Doc->ExportField($this->kab_id);
						if ($this->kec_id->Exportable) $Doc->ExportField($this->kec_id);
						if ($this->desa_id->Exportable) $Doc->ExportField($this->desa_id);
						if ($this->pet_alamat->Exportable) $Doc->ExportField($this->pet_alamat);
						if ($this->pet_foto->Exportable) $Doc->ExportField($this->pet_foto);
						if ($this->co_id->Exportable) $Doc->ExportField($this->co_id);
						if ($this->koord_id->Exportable) $Doc->ExportField($this->koord_id);
						if ($this->tr_id->Exportable) $Doc->ExportField($this->tr_id);
					}
					$Doc->EndExportRow($RowCnt);
				}
			}

			// Call Row Export server event
			if ($Doc->ExportCustom)
				$this->Row_Export($Recordset->fields);
			$Recordset->MoveNext();
		}
		if (!$Doc->ExportCustom) {
			$Doc->ExportTableFooter();
		}
	}

	// Get auto fill value
	function GetAutoFill($id, $val) {
		$rsarr = array();
		$rowcnt = 0;

		// Output
		if (is_array($rsarr) && $rowcnt > 0) {
			$fldcnt = count($rsarr[0]);
			for ($i = 0; $i < $rowcnt; $i++) {
				for ($j = 0; $j < $fldcnt; $j++) {
					$str = strval($rsarr[$i][$j]);
					$str = ew_ConvertToUtf8($str);
					if (isset($post["keepCRLF"])) {
						$str = str_replace(array("\r", "\n"), array("\\r", "\\n"), $str);
					} else {
						$str = str_replace(array("\r", "\n"), array(" ", " "), $str);
					}
					$rsarr[$i][$j] = $str;
				}
			}
			return ew_ArrayToJson($rsarr);
		} else {
			return FALSE;
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->FldName, $fld->LookupFilters, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
