<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "petaniinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$petani_delete = NULL; // Initialize page object first

class cpetani_delete extends cpetani {

	// Page ID
	var $PageID = 'delete';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'petani';

	// Page object name
	var $PageObjName = 'petani_delete';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (petani)
		if (!isset($GLOBALS["petani"]) || get_class($GLOBALS["petani"]) == "cpetani") {
			$GLOBALS["petani"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["petani"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'delete', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'petani', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanDelete()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("petanilist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 

		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->pet_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->pet_id->Visible = FALSE;
		$this->pet_nama->SetVisibility();
		$this->pet_hp->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->pet_alamat->SetVisibility();
		$this->pet_foto->SetVisibility();
		$this->co_id->SetVisibility();
		$this->koord_id->SetVisibility();
		$this->tr_id->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $petani;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($petani);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $TotalRecs = 0;
	var $RecCnt;
	var $RecKeys = array();
	var $Recordset;
	var $StartRowCnt = 1;
	var $RowCnt = 0;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->GetRecordKeys(); // Load record keys
		$sFilter = $this->GetKeyFilter();
		if ($sFilter == "")
			$this->Page_Terminate("petanilist.php"); // Prevent SQL injection, return to list

		// Set up filter (SQL WHHERE clause) and get return SQL
		// SQL constructor in petani class, petaniinfo.php

		$this->CurrentFilter = $sFilter;

		// Get action
		if (@$_POST["a_delete"] <> "") {
			$this->CurrentAction = $_POST["a_delete"];
		} elseif (@$_GET["a_delete"] == "1") {
			$this->CurrentAction = "D"; // Delete record directly
		} else {
			$this->CurrentAction = "I"; // Display record
		}
		if ($this->CurrentAction == "D") {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->DeleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->Phrase("DeleteSuccess")); // Set up success message
				$this->Page_Terminate($this->getReturnUrl()); // Return to caller
			} else { // Delete failed
				$this->CurrentAction = "I"; // Display record
			}
		}
		if ($this->CurrentAction == "I") { // Load records for display
			if ($this->Recordset = $this->LoadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->Close();
				$this->Page_Terminate("petanilist.php"); // Return to list
			}
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->pet_id->setDbValue($row['pet_id']);
		$this->pet_nama->setDbValue($row['pet_nama']);
		$this->pet_hp->setDbValue($row['pet_hp']);
		$this->prov_id->setDbValue($row['prov_id']);
		$this->kab_id->setDbValue($row['kab_id']);
		$this->kec_id->setDbValue($row['kec_id']);
		$this->desa_id->setDbValue($row['desa_id']);
		$this->pet_alamat->setDbValue($row['pet_alamat']);
		$this->pet_foto->Upload->DbValue = $row['pet_foto'];
		$this->pet_foto->setDbValue($this->pet_foto->Upload->DbValue);
		$this->co_id->setDbValue($row['co_id']);
		$this->koord_id->setDbValue($row['koord_id']);
		if (array_key_exists('EV__koord_id', $rs->fields)) {
			$this->koord_id->VirtualValue = $rs->fields('EV__koord_id'); // Set up virtual field value
		} else {
			$this->koord_id->VirtualValue = ""; // Clear value
		}
		$this->tr_id->setDbValue($row['tr_id']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['pet_id'] = NULL;
		$row['pet_nama'] = NULL;
		$row['pet_hp'] = NULL;
		$row['prov_id'] = NULL;
		$row['kab_id'] = NULL;
		$row['kec_id'] = NULL;
		$row['desa_id'] = NULL;
		$row['pet_alamat'] = NULL;
		$row['pet_foto'] = NULL;
		$row['co_id'] = NULL;
		$row['koord_id'] = NULL;
		$row['tr_id'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->pet_id->DbValue = $row['pet_id'];
		$this->pet_nama->DbValue = $row['pet_nama'];
		$this->pet_hp->DbValue = $row['pet_hp'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->pet_alamat->DbValue = $row['pet_alamat'];
		$this->pet_foto->Upload->DbValue = $row['pet_foto'];
		$this->co_id->DbValue = $row['co_id'];
		$this->koord_id->DbValue = $row['koord_id'];
		$this->tr_id->DbValue = $row['tr_id'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// pet_id
		// pet_nama
		// pet_hp
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// pet_alamat
		// pet_foto
		// co_id
		// koord_id
		// tr_id

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// pet_id
		$this->pet_id->ViewValue = $this->pet_id->CurrentValue;
		$this->pet_id->ViewCustomAttributes = "";

		// pet_nama
		$this->pet_nama->ViewValue = $this->pet_nama->CurrentValue;
		$this->pet_nama->ViewCustomAttributes = "";

		// pet_hp
		$this->pet_hp->ViewValue = $this->pet_hp->CurrentValue;
		$this->pet_hp->ViewCustomAttributes = "";

		// prov_id
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		$this->desa_id->ViewCustomAttributes = "";

		// pet_alamat
		$this->pet_alamat->ViewValue = $this->pet_alamat->CurrentValue;
		$this->pet_alamat->ViewCustomAttributes = "";

		// pet_foto
		$this->pet_foto->UploadPath = "foto_petani";
		if (!ew_Empty($this->pet_foto->Upload->DbValue)) {
			$this->pet_foto->ImageWidth = 30;
			$this->pet_foto->ImageHeight = 40;
			$this->pet_foto->ImageAlt = $this->pet_foto->FldAlt();
			$this->pet_foto->ViewValue = $this->pet_foto->Upload->DbValue;
		} else {
			$this->pet_foto->ViewValue = "";
		}
		$this->pet_foto->ViewCustomAttributes = "";

		// co_id
		if (strval($this->co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `co_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_id->ViewValue = $this->co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_id->ViewValue = $this->co_id->CurrentValue;
			}
		} else {
			$this->co_id->ViewValue = NULL;
		}
		$this->co_id->ViewCustomAttributes = "";

		// koord_id
		if ($this->koord_id->VirtualValue <> "") {
			$this->koord_id->ViewValue = $this->koord_id->VirtualValue;
		} else {
			$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
		if (strval($this->koord_id->CurrentValue) <> "") {
			$sFilterWrk = "`koord_id`" . ew_SearchString("=", $this->koord_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `koord_id`, `koord_nama` AS `DispFld`, `koord_alamat` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `koord`";
		$sWhereWrk = "";
		$this->koord_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->koord_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->koord_id->ViewValue = $this->koord_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
			}
		} else {
			$this->koord_id->ViewValue = NULL;
		}
		}
		$this->koord_id->ViewCustomAttributes = "";

		// tr_id
		if (strval($this->tr_id->CurrentValue) <> "") {
			$sFilterWrk = "`tr_id`" . ew_SearchString("=", $this->tr_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `tr_id`, `tr_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tingkat_resiko`";
		$sWhereWrk = "";
		$this->tr_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->tr_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `tr_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->tr_id->ViewValue = $this->tr_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->tr_id->ViewValue = $this->tr_id->CurrentValue;
			}
		} else {
			$this->tr_id->ViewValue = NULL;
		}
		$this->tr_id->ViewCustomAttributes = "";

			// pet_id
			$this->pet_id->LinkCustomAttributes = "";
			$this->pet_id->HrefValue = "";
			$this->pet_id->TooltipValue = "";

			// pet_nama
			$this->pet_nama->LinkCustomAttributes = "";
			$this->pet_nama->HrefValue = "";
			$this->pet_nama->TooltipValue = "";

			// pet_hp
			$this->pet_hp->LinkCustomAttributes = "";
			$this->pet_hp->HrefValue = "";
			$this->pet_hp->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// pet_alamat
			$this->pet_alamat->LinkCustomAttributes = "";
			$this->pet_alamat->HrefValue = "";
			$this->pet_alamat->TooltipValue = "";

			// pet_foto
			$this->pet_foto->LinkCustomAttributes = "";
			$this->pet_foto->UploadPath = "foto_petani";
			if (!ew_Empty($this->pet_foto->Upload->DbValue)) {
				$this->pet_foto->HrefValue = ew_GetFileUploadUrl($this->pet_foto, $this->pet_foto->Upload->DbValue); // Add prefix/suffix
				$this->pet_foto->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->pet_foto->HrefValue = ew_FullUrl($this->pet_foto->HrefValue, "href");
			} else {
				$this->pet_foto->HrefValue = "";
			}
			$this->pet_foto->HrefValue2 = $this->pet_foto->UploadPath . $this->pet_foto->Upload->DbValue;
			$this->pet_foto->TooltipValue = "";
			if ($this->pet_foto->UseColorbox) {
				if (ew_Empty($this->pet_foto->TooltipValue))
					$this->pet_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->pet_foto->LinkAttrs["data-rel"] = "petani_x_pet_foto";
				ew_AppendClass($this->pet_foto->LinkAttrs["class"], "ewLightbox");
			}

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			$this->co_id->HrefValue = "";
			$this->co_id->TooltipValue = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			$this->koord_id->HrefValue = "";
			$this->koord_id->TooltipValue = "";

			// tr_id
			$this->tr_id->LinkCustomAttributes = "";
			$this->tr_id->HrefValue = "";
			$this->tr_id->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	//
	// Delete records based on current filter
	//
	function DeleteRows() {
		global $Language, $Security;
		if (!$Security->CanDelete()) {
			$this->setFailureMessage($Language->Phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$DeleteRows = TRUE;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
			$rs->Close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->GetRows() : array();
		$conn->BeginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->Close();

		// Call row deleting event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$DeleteRows = $this->Row_Deleting($row);
				if (!$DeleteRows) break;
			}
		}
		if ($DeleteRows) {
			$sKey = "";
			foreach ($rsold as $row) {
				$sThisKey = "";
				if ($sThisKey <> "") $sThisKey .= $GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"];
				$sThisKey .= $row['pet_id'];

				// Delete old files
				$this->LoadDbValues($row);
				$this->pet_foto->OldUploadPath = "foto_petani";
				$OldFiles = ew_Empty($row['pet_foto']) ? array() : array($row['pet_foto']);
				$OldFileCount = count($OldFiles);
				for ($i = 0; $i < $OldFileCount; $i++) {
					if (file_exists($this->pet_foto->OldPhysicalUploadPath() . $OldFiles[$i]))
						@unlink($this->pet_foto->OldPhysicalUploadPath() . $OldFiles[$i]);
				}
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				$DeleteRows = $this->Delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($DeleteRows === FALSE)
					break;
				if ($sKey <> "") $sKey .= ", ";
				$sKey .= $sThisKey;
			}
		}
		if (!$DeleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("DeleteCancelled"));
			}
		}
		if ($DeleteRows) {
			$conn->CommitTrans(); // Commit the changes
		} else {
			$conn->RollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}
		return $DeleteRows;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("petanilist.php"), "", $this->TableVar, TRUE);
		$PageId = "delete";
		$Breadcrumb->Add("delete", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($petani_delete)) $petani_delete = new cpetani_delete();

// Page init
$petani_delete->Page_Init();

// Page main
$petani_delete->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$petani_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "delete";
var CurrentForm = fpetanidelete = new ew_Form("fpetanidelete", "delete");

// Form_CustomValidate event
fpetanidelete.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fpetanidelete.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpetanidelete.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fpetanidelete.Lists["x_prov_id"].Data = "<?php echo $petani_delete->prov_id->LookupFilterQuery(FALSE, "delete") ?>";
fpetanidelete.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":[],"ChildFields":["x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kab"};
fpetanidelete.Lists["x_kab_id"].Data = "<?php echo $petani_delete->kab_id->LookupFilterQuery(FALSE, "delete") ?>";
fpetanidelete.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":["x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fpetanidelete.Lists["x_kec_id"].Data = "<?php echo $petani_delete->kec_id->LookupFilterQuery(FALSE, "delete") ?>";
fpetanidelete.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"desa"};
fpetanidelete.Lists["x_desa_id"].Data = "<?php echo $petani_delete->desa_id->LookupFilterQuery(FALSE, "delete") ?>";
fpetanidelete.Lists["x_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fpetanidelete.Lists["x_co_id"].Data = "<?php echo $petani_delete->co_id->LookupFilterQuery(FALSE, "delete") ?>";
fpetanidelete.Lists["x_koord_id"] = {"LinkField":"x_koord_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_koord_nama","x_koord_alamat","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"koord"};
fpetanidelete.Lists["x_koord_id"].Data = "<?php echo $petani_delete->koord_id->LookupFilterQuery(FALSE, "delete") ?>";
fpetanidelete.AutoSuggests["x_koord_id"] = <?php echo json_encode(array("data" => "ajax=autosuggest&" . $petani_delete->koord_id->LookupFilterQuery(TRUE, "delete"))) ?>;
fpetanidelete.Lists["x_tr_id"] = {"LinkField":"x_tr_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_tr_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"tingkat_resiko"};
fpetanidelete.Lists["x_tr_id"].Data = "<?php echo $petani_delete->tr_id->LookupFilterQuery(FALSE, "delete") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $petani_delete->ShowPageHeader(); ?>
<?php
$petani_delete->ShowMessage();
?>
<form name="fpetanidelete" id="fpetanidelete" class="form-inline ewForm ewDeleteForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($petani_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $petani_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="petani">
<input type="hidden" name="a_delete" id="a_delete" value="D">
<?php foreach ($petani_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($EW_COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo ew_HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="box ewBox ewGrid">
<div class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<table class="table ewTable">
	<thead>
	<tr class="ewTableHeader">
<?php if ($petani->pet_id->Visible) { // pet_id ?>
		<th class="<?php echo $petani->pet_id->HeaderCellClass() ?>"><span id="elh_petani_pet_id" class="petani_pet_id"><?php echo $petani->pet_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->pet_nama->Visible) { // pet_nama ?>
		<th class="<?php echo $petani->pet_nama->HeaderCellClass() ?>"><span id="elh_petani_pet_nama" class="petani_pet_nama"><?php echo $petani->pet_nama->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->pet_hp->Visible) { // pet_hp ?>
		<th class="<?php echo $petani->pet_hp->HeaderCellClass() ?>"><span id="elh_petani_pet_hp" class="petani_pet_hp"><?php echo $petani->pet_hp->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->prov_id->Visible) { // prov_id ?>
		<th class="<?php echo $petani->prov_id->HeaderCellClass() ?>"><span id="elh_petani_prov_id" class="petani_prov_id"><?php echo $petani->prov_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->kab_id->Visible) { // kab_id ?>
		<th class="<?php echo $petani->kab_id->HeaderCellClass() ?>"><span id="elh_petani_kab_id" class="petani_kab_id"><?php echo $petani->kab_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->kec_id->Visible) { // kec_id ?>
		<th class="<?php echo $petani->kec_id->HeaderCellClass() ?>"><span id="elh_petani_kec_id" class="petani_kec_id"><?php echo $petani->kec_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->desa_id->Visible) { // desa_id ?>
		<th class="<?php echo $petani->desa_id->HeaderCellClass() ?>"><span id="elh_petani_desa_id" class="petani_desa_id"><?php echo $petani->desa_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->pet_alamat->Visible) { // pet_alamat ?>
		<th class="<?php echo $petani->pet_alamat->HeaderCellClass() ?>"><span id="elh_petani_pet_alamat" class="petani_pet_alamat"><?php echo $petani->pet_alamat->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->pet_foto->Visible) { // pet_foto ?>
		<th class="<?php echo $petani->pet_foto->HeaderCellClass() ?>"><span id="elh_petani_pet_foto" class="petani_pet_foto"><?php echo $petani->pet_foto->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->co_id->Visible) { // co_id ?>
		<th class="<?php echo $petani->co_id->HeaderCellClass() ?>"><span id="elh_petani_co_id" class="petani_co_id"><?php echo $petani->co_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->koord_id->Visible) { // koord_id ?>
		<th class="<?php echo $petani->koord_id->HeaderCellClass() ?>"><span id="elh_petani_koord_id" class="petani_koord_id"><?php echo $petani->koord_id->FldCaption() ?></span></th>
<?php } ?>
<?php if ($petani->tr_id->Visible) { // tr_id ?>
		<th class="<?php echo $petani->tr_id->HeaderCellClass() ?>"><span id="elh_petani_tr_id" class="petani_tr_id"><?php echo $petani->tr_id->FldCaption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$petani_delete->RecCnt = 0;
$i = 0;
while (!$petani_delete->Recordset->EOF) {
	$petani_delete->RecCnt++;
	$petani_delete->RowCnt++;

	// Set row properties
	$petani->ResetAttrs();
	$petani->RowType = EW_ROWTYPE_VIEW; // View

	// Get the field contents
	$petani_delete->LoadRowValues($petani_delete->Recordset);

	// Render row
	$petani_delete->RenderRow();
?>
	<tr<?php echo $petani->RowAttributes() ?>>
<?php if ($petani->pet_id->Visible) { // pet_id ?>
		<td<?php echo $petani->pet_id->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_pet_id" class="petani_pet_id">
<span<?php echo $petani->pet_id->ViewAttributes() ?>>
<?php echo $petani->pet_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->pet_nama->Visible) { // pet_nama ?>
		<td<?php echo $petani->pet_nama->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_pet_nama" class="petani_pet_nama">
<span<?php echo $petani->pet_nama->ViewAttributes() ?>>
<?php echo $petani->pet_nama->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->pet_hp->Visible) { // pet_hp ?>
		<td<?php echo $petani->pet_hp->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_pet_hp" class="petani_pet_hp">
<span<?php echo $petani->pet_hp->ViewAttributes() ?>>
<?php echo $petani->pet_hp->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->prov_id->Visible) { // prov_id ?>
		<td<?php echo $petani->prov_id->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_prov_id" class="petani_prov_id">
<span<?php echo $petani->prov_id->ViewAttributes() ?>>
<?php echo $petani->prov_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->kab_id->Visible) { // kab_id ?>
		<td<?php echo $petani->kab_id->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_kab_id" class="petani_kab_id">
<span<?php echo $petani->kab_id->ViewAttributes() ?>>
<?php echo $petani->kab_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->kec_id->Visible) { // kec_id ?>
		<td<?php echo $petani->kec_id->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_kec_id" class="petani_kec_id">
<span<?php echo $petani->kec_id->ViewAttributes() ?>>
<?php echo $petani->kec_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->desa_id->Visible) { // desa_id ?>
		<td<?php echo $petani->desa_id->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_desa_id" class="petani_desa_id">
<span<?php echo $petani->desa_id->ViewAttributes() ?>>
<?php echo $petani->desa_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->pet_alamat->Visible) { // pet_alamat ?>
		<td<?php echo $petani->pet_alamat->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_pet_alamat" class="petani_pet_alamat">
<span<?php echo $petani->pet_alamat->ViewAttributes() ?>>
<?php echo $petani->pet_alamat->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->pet_foto->Visible) { // pet_foto ?>
		<td<?php echo $petani->pet_foto->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_pet_foto" class="petani_pet_foto">
<span>
<?php echo ew_GetFileViewTag($petani->pet_foto, $petani->pet_foto->ListViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($petani->co_id->Visible) { // co_id ?>
		<td<?php echo $petani->co_id->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_co_id" class="petani_co_id">
<span<?php echo $petani->co_id->ViewAttributes() ?>>
<?php echo $petani->co_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->koord_id->Visible) { // koord_id ?>
		<td<?php echo $petani->koord_id->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_koord_id" class="petani_koord_id">
<span<?php echo $petani->koord_id->ViewAttributes() ?>>
<?php echo $petani->koord_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($petani->tr_id->Visible) { // tr_id ?>
		<td<?php echo $petani->tr_id->CellAttributes() ?>>
<span id="el<?php echo $petani_delete->RowCnt ?>_petani_tr_id" class="petani_tr_id">
<span<?php echo $petani->tr_id->ViewAttributes() ?>>
<?php echo $petani->tr_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$petani_delete->Recordset->MoveNext();
}
$petani_delete->Recordset->Close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("DeleteBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $petani_delete->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
</div>
</form>
<script type="text/javascript">
fpetanidelete.Init();
</script>
<?php
$petani_delete->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$petani_delete->Page_Terminate();
?>
