<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "pesertainfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$peserta_edit = NULL; // Initialize page object first

class cpeserta_edit extends cpeserta {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'peserta';

	// Page object name
	var $PageObjName = 'peserta_edit';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (peserta)
		if (!isset($GLOBALS["peserta"]) || get_class($GLOBALS["peserta"]) == "cpeserta") {
			$GLOBALS["peserta"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["peserta"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'peserta', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Is modal
		$this->IsModal = (@$_GET["modal"] == "1" || @$_POST["modal"] == "1");

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanEdit()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("pesertalist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->pes_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->pes_id->Visible = FALSE;
		$this->pes_nama->SetVisibility();
		$this->sos_id->SetVisibility();
		$this->co_id->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->pes_alamat->SetVisibility();
		$this->pes_hp->SetVisibility();
		$this->pes_foto->SetVisibility();
		$this->pes_luas_lahan->SetVisibility();
		$this->pes_r_tanam_tgl->SetVisibility();
		$this->pes_foto_lahan->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $peserta;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($peserta);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = ew_GetPageName($url);
				if ($pageName != $this->GetListUrl()) { // Not List page
					$row["caption"] = $this->GetModalCaption($pageName);
					if ($pageName == "pesertaview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				header("Content-Type: application/json; charset=utf-8");
				echo ew_ConvertToUtf8(ew_ArrayToJson(array($row)));
			} else {
				ew_SaveDebugMsg();
				header("Location: " . $url);
			}
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewEditForm";
	var $IsModal = FALSE;
	var $IsMobileOrModal = FALSE;
	var $DbMasterFilter;
	var $DbDetailFilter;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gbSkipHeaderFooter;

		// Check modal
		if ($this->IsModal)
			$gbSkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = ew_IsMobile() || $this->IsModal;
		$this->FormClassName = "ewForm ewEditForm form-horizontal";
		$sReturnUrl = "";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			if ($this->CurrentAction <> "I") // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($objForm->HasValue("x_pes_id")) {
				$this->pes_id->setFormValue($objForm->GetValue("x_pes_id"));
			}
		} else {
			$this->CurrentAction = "I"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (isset($_GET["pes_id"])) {
				$this->pes_id->setQueryStringValue($_GET["pes_id"]);
				$loadByQuery = TRUE;
			} else {
				$this->pes_id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->LoadRow();

		// Process form if post back
		if ($postBack) {
			$this->LoadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("pesertalist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$sReturnUrl = $this->getReturnUrl();
				if (ew_GetPageName($sReturnUrl) == "pesertalist.php")
					$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} elseif ($this->getFailureMessage() == $Language->Phrase("NoRecord")) {
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->pes_foto->Upload->Index = $objForm->Index;
		$this->pes_foto->Upload->UploadFile();
		$this->pes_foto->CurrentValue = $this->pes_foto->Upload->FileName;
		$this->pes_foto_lahan->Upload->Index = $objForm->Index;
		$this->pes_foto_lahan->Upload->UploadFile();
		$this->pes_foto_lahan->CurrentValue = $this->pes_foto_lahan->Upload->FileName;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->pes_id->FldIsDetailKey)
			$this->pes_id->setFormValue($objForm->GetValue("x_pes_id"));
		if (!$this->pes_nama->FldIsDetailKey) {
			$this->pes_nama->setFormValue($objForm->GetValue("x_pes_nama"));
		}
		if (!$this->sos_id->FldIsDetailKey) {
			$this->sos_id->setFormValue($objForm->GetValue("x_sos_id"));
		}
		if (!$this->co_id->FldIsDetailKey) {
			$this->co_id->setFormValue($objForm->GetValue("x_co_id"));
		}
		if (!$this->prov_id->FldIsDetailKey) {
			$this->prov_id->setFormValue($objForm->GetValue("x_prov_id"));
		}
		if (!$this->kab_id->FldIsDetailKey) {
			$this->kab_id->setFormValue($objForm->GetValue("x_kab_id"));
		}
		if (!$this->kec_id->FldIsDetailKey) {
			$this->kec_id->setFormValue($objForm->GetValue("x_kec_id"));
		}
		if (!$this->desa_id->FldIsDetailKey) {
			$this->desa_id->setFormValue($objForm->GetValue("x_desa_id"));
		}
		if (!$this->pes_alamat->FldIsDetailKey) {
			$this->pes_alamat->setFormValue($objForm->GetValue("x_pes_alamat"));
		}
		if (!$this->pes_hp->FldIsDetailKey) {
			$this->pes_hp->setFormValue($objForm->GetValue("x_pes_hp"));
		}
		if (!$this->pes_luas_lahan->FldIsDetailKey) {
			$this->pes_luas_lahan->setFormValue($objForm->GetValue("x_pes_luas_lahan"));
		}
		if (!$this->pes_r_tanam_tgl->FldIsDetailKey) {
			$this->pes_r_tanam_tgl->setFormValue($objForm->GetValue("x_pes_r_tanam_tgl"));
			$this->pes_r_tanam_tgl->CurrentValue = ew_UnFormatDateTime($this->pes_r_tanam_tgl->CurrentValue, 0);
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->pes_id->CurrentValue = $this->pes_id->FormValue;
		$this->pes_nama->CurrentValue = $this->pes_nama->FormValue;
		$this->sos_id->CurrentValue = $this->sos_id->FormValue;
		$this->co_id->CurrentValue = $this->co_id->FormValue;
		$this->prov_id->CurrentValue = $this->prov_id->FormValue;
		$this->kab_id->CurrentValue = $this->kab_id->FormValue;
		$this->kec_id->CurrentValue = $this->kec_id->FormValue;
		$this->desa_id->CurrentValue = $this->desa_id->FormValue;
		$this->pes_alamat->CurrentValue = $this->pes_alamat->FormValue;
		$this->pes_hp->CurrentValue = $this->pes_hp->FormValue;
		$this->pes_luas_lahan->CurrentValue = $this->pes_luas_lahan->FormValue;
		$this->pes_r_tanam_tgl->CurrentValue = $this->pes_r_tanam_tgl->FormValue;
		$this->pes_r_tanam_tgl->CurrentValue = ew_UnFormatDateTime($this->pes_r_tanam_tgl->CurrentValue, 0);
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->pes_id->setDbValue($row['pes_id']);
		$this->pes_nama->setDbValue($row['pes_nama']);
		$this->sos_id->setDbValue($row['sos_id']);
		$this->co_id->setDbValue($row['co_id']);
		$this->prov_id->setDbValue($row['prov_id']);
		if (array_key_exists('EV__prov_id', $rs->fields)) {
			$this->prov_id->VirtualValue = $rs->fields('EV__prov_id'); // Set up virtual field value
		} else {
			$this->prov_id->VirtualValue = ""; // Clear value
		}
		$this->kab_id->setDbValue($row['kab_id']);
		if (array_key_exists('EV__kab_id', $rs->fields)) {
			$this->kab_id->VirtualValue = $rs->fields('EV__kab_id'); // Set up virtual field value
		} else {
			$this->kab_id->VirtualValue = ""; // Clear value
		}
		$this->kec_id->setDbValue($row['kec_id']);
		if (array_key_exists('EV__kec_id', $rs->fields)) {
			$this->kec_id->VirtualValue = $rs->fields('EV__kec_id'); // Set up virtual field value
		} else {
			$this->kec_id->VirtualValue = ""; // Clear value
		}
		$this->desa_id->setDbValue($row['desa_id']);
		if (array_key_exists('EV__desa_id', $rs->fields)) {
			$this->desa_id->VirtualValue = $rs->fields('EV__desa_id'); // Set up virtual field value
		} else {
			$this->desa_id->VirtualValue = ""; // Clear value
		}
		$this->pes_alamat->setDbValue($row['pes_alamat']);
		$this->pes_hp->setDbValue($row['pes_hp']);
		$this->pes_foto->Upload->DbValue = $row['pes_foto'];
		$this->pes_foto->setDbValue($this->pes_foto->Upload->DbValue);
		$this->pes_luas_lahan->setDbValue($row['pes_luas_lahan']);
		$this->pes_r_tanam_tgl->setDbValue($row['pes_r_tanam_tgl']);
		$this->pes_foto_lahan->Upload->DbValue = $row['pes_foto_lahan'];
		$this->pes_foto_lahan->setDbValue($this->pes_foto_lahan->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['pes_id'] = NULL;
		$row['pes_nama'] = NULL;
		$row['sos_id'] = NULL;
		$row['co_id'] = NULL;
		$row['prov_id'] = NULL;
		$row['kab_id'] = NULL;
		$row['kec_id'] = NULL;
		$row['desa_id'] = NULL;
		$row['pes_alamat'] = NULL;
		$row['pes_hp'] = NULL;
		$row['pes_foto'] = NULL;
		$row['pes_luas_lahan'] = NULL;
		$row['pes_r_tanam_tgl'] = NULL;
		$row['pes_foto_lahan'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->pes_id->DbValue = $row['pes_id'];
		$this->pes_nama->DbValue = $row['pes_nama'];
		$this->sos_id->DbValue = $row['sos_id'];
		$this->co_id->DbValue = $row['co_id'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->pes_alamat->DbValue = $row['pes_alamat'];
		$this->pes_hp->DbValue = $row['pes_hp'];
		$this->pes_foto->Upload->DbValue = $row['pes_foto'];
		$this->pes_luas_lahan->DbValue = $row['pes_luas_lahan'];
		$this->pes_r_tanam_tgl->DbValue = $row['pes_r_tanam_tgl'];
		$this->pes_foto_lahan->Upload->DbValue = $row['pes_foto_lahan'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("pes_id")) <> "")
			$this->pes_id->CurrentValue = $this->getKey("pes_id"); // pes_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// pes_id
		// pes_nama
		// sos_id
		// co_id
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// pes_alamat
		// pes_hp
		// pes_foto
		// pes_luas_lahan
		// pes_r_tanam_tgl
		// pes_foto_lahan

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// pes_id
		$this->pes_id->ViewValue = $this->pes_id->CurrentValue;
		$this->pes_id->ViewCustomAttributes = "";

		// pes_nama
		$this->pes_nama->ViewValue = $this->pes_nama->CurrentValue;
		$this->pes_nama->ViewCustomAttributes = "";

		// sos_id
		if (strval($this->sos_id->CurrentValue) <> "") {
			$sFilterWrk = "`sos_id`" . ew_SearchString("=", $this->sos_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `sos_id`, `sos_tgl` AS `DispFld`, `sos_kab` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sosialisasi`";
		$sWhereWrk = "";
		$this->sos_id->LookupFilters = array("df1" => "0");
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `sos_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = ew_FormatDateTime($rswrk->fields('DispFld'), 0);
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->sos_id->ViewValue = $this->sos_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->sos_id->ViewValue = $this->sos_id->CurrentValue;
			}
		} else {
			$this->sos_id->ViewValue = NULL;
		}
		$this->sos_id->ViewCustomAttributes = "";

		// co_id
		if (strval($this->co_id->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->co_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->co_id->ViewValue = $this->co_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->co_id->ViewValue = $this->co_id->CurrentValue;
			}
		} else {
			$this->co_id->ViewValue = NULL;
		}
		$this->co_id->ViewCustomAttributes = "";

		// prov_id
		if ($this->prov_id->VirtualValue <> "") {
			$this->prov_id->ViewValue = $this->prov_id->VirtualValue;
		} else {
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if ($this->kab_id->VirtualValue <> "") {
			$this->kab_id->ViewValue = $this->kab_id->VirtualValue;
		} else {
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if ($this->kec_id->VirtualValue <> "") {
			$this->kec_id->ViewValue = $this->kec_id->VirtualValue;
		} else {
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		}
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		if ($this->desa_id->VirtualValue <> "") {
			$this->desa_id->ViewValue = $this->desa_id->VirtualValue;
		} else {
		if (strval($this->desa_id->CurrentValue) <> "") {
			$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
		$sWhereWrk = "";
		$this->desa_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->desa_id->ViewValue = $this->desa_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
			}
		} else {
			$this->desa_id->ViewValue = NULL;
		}
		}
		$this->desa_id->ViewCustomAttributes = "";

		// pes_alamat
		$this->pes_alamat->ViewValue = $this->pes_alamat->CurrentValue;
		$this->pes_alamat->ViewCustomAttributes = "";

		// pes_hp
		$this->pes_hp->ViewValue = $this->pes_hp->CurrentValue;
		$this->pes_hp->ViewCustomAttributes = "";

		// pes_foto
		$this->pes_foto->UploadPath = "foto_peserta";
		if (!ew_Empty($this->pes_foto->Upload->DbValue)) {
			$this->pes_foto->ImageWidth = 60;
			$this->pes_foto->ImageHeight = 60;
			$this->pes_foto->ImageAlt = $this->pes_foto->FldAlt();
			$this->pes_foto->ViewValue = $this->pes_foto->Upload->DbValue;
		} else {
			$this->pes_foto->ViewValue = "";
		}
		$this->pes_foto->ViewCustomAttributes = "";

		// pes_luas_lahan
		$this->pes_luas_lahan->ViewValue = $this->pes_luas_lahan->CurrentValue;
		$this->pes_luas_lahan->CellCssStyle .= "text-align: right;";
		$this->pes_luas_lahan->ViewCustomAttributes = "";

		// pes_r_tanam_tgl
		$this->pes_r_tanam_tgl->ViewValue = $this->pes_r_tanam_tgl->CurrentValue;
		$this->pes_r_tanam_tgl->ViewValue = ew_FormatDateTime($this->pes_r_tanam_tgl->ViewValue, 0);
		$this->pes_r_tanam_tgl->ViewCustomAttributes = "";

		// pes_foto_lahan
		$this->pes_foto_lahan->UploadPath = "foto_potensi_lahan";
		if (!ew_Empty($this->pes_foto_lahan->Upload->DbValue)) {
			$this->pes_foto_lahan->ImageWidth = 80;
			$this->pes_foto_lahan->ImageHeight = 60;
			$this->pes_foto_lahan->ImageAlt = $this->pes_foto_lahan->FldAlt();
			$this->pes_foto_lahan->ViewValue = $this->pes_foto_lahan->Upload->DbValue;
		} else {
			$this->pes_foto_lahan->ViewValue = "";
		}
		$this->pes_foto_lahan->ViewCustomAttributes = "";

			// pes_id
			$this->pes_id->LinkCustomAttributes = "";
			$this->pes_id->HrefValue = "";
			$this->pes_id->TooltipValue = "";

			// pes_nama
			$this->pes_nama->LinkCustomAttributes = "";
			$this->pes_nama->HrefValue = "";
			$this->pes_nama->TooltipValue = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";
			$this->sos_id->TooltipValue = "";

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			$this->co_id->HrefValue = "";
			$this->co_id->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// pes_alamat
			$this->pes_alamat->LinkCustomAttributes = "";
			$this->pes_alamat->HrefValue = "";
			$this->pes_alamat->TooltipValue = "";

			// pes_hp
			$this->pes_hp->LinkCustomAttributes = "";
			$this->pes_hp->HrefValue = "";
			$this->pes_hp->TooltipValue = "";

			// pes_foto
			$this->pes_foto->LinkCustomAttributes = "";
			$this->pes_foto->UploadPath = "foto_peserta";
			if (!ew_Empty($this->pes_foto->Upload->DbValue)) {
				$this->pes_foto->HrefValue = ew_GetFileUploadUrl($this->pes_foto, $this->pes_foto->Upload->DbValue); // Add prefix/suffix
				$this->pes_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->pes_foto->HrefValue = ew_FullUrl($this->pes_foto->HrefValue, "href");
			} else {
				$this->pes_foto->HrefValue = "";
			}
			$this->pes_foto->HrefValue2 = $this->pes_foto->UploadPath . $this->pes_foto->Upload->DbValue;
			$this->pes_foto->TooltipValue = "";
			if ($this->pes_foto->UseColorbox) {
				if (ew_Empty($this->pes_foto->TooltipValue))
					$this->pes_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->pes_foto->LinkAttrs["data-rel"] = "peserta_x_pes_foto";
				ew_AppendClass($this->pes_foto->LinkAttrs["class"], "ewLightbox");
			}

			// pes_luas_lahan
			$this->pes_luas_lahan->LinkCustomAttributes = "";
			$this->pes_luas_lahan->HrefValue = "";
			$this->pes_luas_lahan->TooltipValue = "";

			// pes_r_tanam_tgl
			$this->pes_r_tanam_tgl->LinkCustomAttributes = "";
			$this->pes_r_tanam_tgl->HrefValue = "";
			$this->pes_r_tanam_tgl->TooltipValue = "";

			// pes_foto_lahan
			$this->pes_foto_lahan->LinkCustomAttributes = "";
			$this->pes_foto_lahan->UploadPath = "foto_potensi_lahan";
			if (!ew_Empty($this->pes_foto_lahan->Upload->DbValue)) {
				$this->pes_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
				$this->pes_foto_lahan->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->pes_foto_lahan->HrefValue = ew_FullUrl($this->pes_foto_lahan->HrefValue, "href");
			} else {
				$this->pes_foto_lahan->HrefValue = "";
			}
			$this->pes_foto_lahan->HrefValue2 = $this->pes_foto_lahan->UploadPath . $this->pes_foto_lahan->Upload->DbValue;
			$this->pes_foto_lahan->TooltipValue = "";
			if ($this->pes_foto_lahan->UseColorbox) {
				if (ew_Empty($this->pes_foto_lahan->TooltipValue))
					$this->pes_foto_lahan->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->pes_foto_lahan->LinkAttrs["data-rel"] = "peserta_x_pes_foto_lahan";
				ew_AppendClass($this->pes_foto_lahan->LinkAttrs["class"], "ewLightbox");
			}
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// pes_id
			$this->pes_id->EditAttrs["class"] = "form-control";
			$this->pes_id->EditCustomAttributes = "";
			$this->pes_id->EditValue = $this->pes_id->CurrentValue;
			$this->pes_id->ViewCustomAttributes = "";

			// pes_nama
			$this->pes_nama->EditAttrs["class"] = "form-control";
			$this->pes_nama->EditCustomAttributes = "";
			$this->pes_nama->EditValue = ew_HtmlEncode($this->pes_nama->CurrentValue);
			$this->pes_nama->PlaceHolder = ew_RemoveHtml($this->pes_nama->FldCaption());

			// sos_id
			$this->sos_id->EditAttrs["class"] = "form-control";
			$this->sos_id->EditCustomAttributes = "";
			if (trim(strval($this->sos_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`sos_id`" . ew_SearchString("=", $this->sos_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `sos_id`, `sos_tgl` AS `DispFld`, `sos_kab` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `sosialisasi`";
			$sWhereWrk = "";
			$this->sos_id->LookupFilters = array("df1" => "0");
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sos_id` DESC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$rowswrk = count($arwrk);
			for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
				$arwrk[$rowcntwrk][1] = ew_FormatDateTime($arwrk[$rowcntwrk][1], 0);
			}
			$this->sos_id->EditValue = $arwrk;

			// co_id
			$this->co_id->EditAttrs["class"] = "form-control";
			$this->co_id->EditCustomAttributes = "";
			if (trim(strval($this->co_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->co_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->co_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->co_id->EditValue = $arwrk;

			// prov_id
			$this->prov_id->EditAttrs["class"] = "form-control";
			$this->prov_id->EditCustomAttributes = "";
			if (trim(strval($this->prov_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `prov`";
			$sWhereWrk = "";
			$this->prov_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->prov_id->EditValue = $arwrk;

			// kab_id
			$this->kab_id->EditAttrs["class"] = "form-control";
			$this->kab_id->EditCustomAttributes = "";
			if (trim(strval($this->kab_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kab_prov_id` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kab`";
			$sWhereWrk = "";
			$this->kab_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kab_id->EditValue = $arwrk;

			// kec_id
			$this->kec_id->EditAttrs["class"] = "form-control";
			$this->kec_id->EditCustomAttributes = "";
			if (trim(strval($this->kec_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kec_prov_id` AS `SelectFilterFld`, `kec_kab_id` AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kec`";
			$sWhereWrk = "";
			$this->kec_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kec_id->EditValue = $arwrk;

			// desa_id
			$this->desa_id->EditAttrs["class"] = "form-control";
			$this->desa_id->EditCustomAttributes = "";
			if (trim(strval($this->desa_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`desa_id`" . ew_SearchString("=", $this->desa_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `desa_id`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `desa_prov_id` AS `SelectFilterFld`, `desa_kab_id` AS `SelectFilterFld2`, `desa_kec_id` AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `desa`";
			$sWhereWrk = "";
			$this->desa_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->desa_id->EditValue = $arwrk;

			// pes_alamat
			$this->pes_alamat->EditAttrs["class"] = "form-control";
			$this->pes_alamat->EditCustomAttributes = "";
			$this->pes_alamat->EditValue = ew_HtmlEncode($this->pes_alamat->CurrentValue);
			$this->pes_alamat->PlaceHolder = ew_RemoveHtml($this->pes_alamat->FldCaption());

			// pes_hp
			$this->pes_hp->EditAttrs["class"] = "form-control";
			$this->pes_hp->EditCustomAttributes = "";
			$this->pes_hp->EditValue = ew_HtmlEncode($this->pes_hp->CurrentValue);
			$this->pes_hp->PlaceHolder = ew_RemoveHtml($this->pes_hp->FldCaption());

			// pes_foto
			$this->pes_foto->EditAttrs["class"] = "form-control";
			$this->pes_foto->EditCustomAttributes = "";
			$this->pes_foto->UploadPath = "foto_peserta";
			if (!ew_Empty($this->pes_foto->Upload->DbValue)) {
				$this->pes_foto->ImageWidth = 60;
				$this->pes_foto->ImageHeight = 60;
				$this->pes_foto->ImageAlt = $this->pes_foto->FldAlt();
				$this->pes_foto->EditValue = $this->pes_foto->Upload->DbValue;
			} else {
				$this->pes_foto->EditValue = "";
			}
			if (!ew_Empty($this->pes_foto->CurrentValue))
					$this->pes_foto->Upload->FileName = $this->pes_foto->CurrentValue;
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->pes_foto);

			// pes_luas_lahan
			$this->pes_luas_lahan->EditAttrs["class"] = "form-control";
			$this->pes_luas_lahan->EditCustomAttributes = "";
			$this->pes_luas_lahan->EditValue = ew_HtmlEncode($this->pes_luas_lahan->CurrentValue);
			$this->pes_luas_lahan->PlaceHolder = ew_RemoveHtml($this->pes_luas_lahan->FldCaption());

			// pes_r_tanam_tgl
			$this->pes_r_tanam_tgl->EditAttrs["class"] = "form-control";
			$this->pes_r_tanam_tgl->EditCustomAttributes = "";
			$this->pes_r_tanam_tgl->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->pes_r_tanam_tgl->CurrentValue, 8));
			$this->pes_r_tanam_tgl->PlaceHolder = ew_RemoveHtml($this->pes_r_tanam_tgl->FldCaption());

			// pes_foto_lahan
			$this->pes_foto_lahan->EditAttrs["class"] = "form-control";
			$this->pes_foto_lahan->EditCustomAttributes = "";
			$this->pes_foto_lahan->UploadPath = "foto_potensi_lahan";
			if (!ew_Empty($this->pes_foto_lahan->Upload->DbValue)) {
				$this->pes_foto_lahan->ImageWidth = 80;
				$this->pes_foto_lahan->ImageHeight = 60;
				$this->pes_foto_lahan->ImageAlt = $this->pes_foto_lahan->FldAlt();
				$this->pes_foto_lahan->EditValue = $this->pes_foto_lahan->Upload->DbValue;
			} else {
				$this->pes_foto_lahan->EditValue = "";
			}
			if (!ew_Empty($this->pes_foto_lahan->CurrentValue))
					$this->pes_foto_lahan->Upload->FileName = $this->pes_foto_lahan->CurrentValue;
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->pes_foto_lahan);

			// Edit refer script
			// pes_id

			$this->pes_id->LinkCustomAttributes = "";
			$this->pes_id->HrefValue = "";

			// pes_nama
			$this->pes_nama->LinkCustomAttributes = "";
			$this->pes_nama->HrefValue = "";

			// sos_id
			$this->sos_id->LinkCustomAttributes = "";
			$this->sos_id->HrefValue = "";

			// co_id
			$this->co_id->LinkCustomAttributes = "";
			$this->co_id->HrefValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";

			// pes_alamat
			$this->pes_alamat->LinkCustomAttributes = "";
			$this->pes_alamat->HrefValue = "";

			// pes_hp
			$this->pes_hp->LinkCustomAttributes = "";
			$this->pes_hp->HrefValue = "";

			// pes_foto
			$this->pes_foto->LinkCustomAttributes = "";
			$this->pes_foto->UploadPath = "foto_peserta";
			if (!ew_Empty($this->pes_foto->Upload->DbValue)) {
				$this->pes_foto->HrefValue = ew_GetFileUploadUrl($this->pes_foto, $this->pes_foto->Upload->DbValue); // Add prefix/suffix
				$this->pes_foto->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->pes_foto->HrefValue = ew_FullUrl($this->pes_foto->HrefValue, "href");
			} else {
				$this->pes_foto->HrefValue = "";
			}
			$this->pes_foto->HrefValue2 = $this->pes_foto->UploadPath . $this->pes_foto->Upload->DbValue;

			// pes_luas_lahan
			$this->pes_luas_lahan->LinkCustomAttributes = "";
			$this->pes_luas_lahan->HrefValue = "";

			// pes_r_tanam_tgl
			$this->pes_r_tanam_tgl->LinkCustomAttributes = "";
			$this->pes_r_tanam_tgl->HrefValue = "";

			// pes_foto_lahan
			$this->pes_foto_lahan->LinkCustomAttributes = "";
			$this->pes_foto_lahan->UploadPath = "foto_potensi_lahan";
			if (!ew_Empty($this->pes_foto_lahan->Upload->DbValue)) {
				$this->pes_foto_lahan->HrefValue = "%u"; // Add prefix/suffix
				$this->pes_foto_lahan->LinkAttrs["target"] = ""; // Add target
				if ($this->Export <> "") $this->pes_foto_lahan->HrefValue = ew_FullUrl($this->pes_foto_lahan->HrefValue, "href");
			} else {
				$this->pes_foto_lahan->HrefValue = "";
			}
			$this->pes_foto_lahan->HrefValue2 = $this->pes_foto_lahan->UploadPath . $this->pes_foto_lahan->Upload->DbValue;
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->pes_nama->FldIsDetailKey && !is_null($this->pes_nama->FormValue) && $this->pes_nama->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->pes_nama->FldCaption(), $this->pes_nama->ReqErrMsg));
		}
		if (!$this->sos_id->FldIsDetailKey && !is_null($this->sos_id->FormValue) && $this->sos_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->sos_id->FldCaption(), $this->sos_id->ReqErrMsg));
		}
		if (!$this->co_id->FldIsDetailKey && !is_null($this->co_id->FormValue) && $this->co_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->co_id->FldCaption(), $this->co_id->ReqErrMsg));
		}
		if (!$this->prov_id->FldIsDetailKey && !is_null($this->prov_id->FormValue) && $this->prov_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->prov_id->FldCaption(), $this->prov_id->ReqErrMsg));
		}
		if (!$this->kab_id->FldIsDetailKey && !is_null($this->kab_id->FormValue) && $this->kab_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->kab_id->FldCaption(), $this->kab_id->ReqErrMsg));
		}
		if (!$this->kec_id->FldIsDetailKey && !is_null($this->kec_id->FormValue) && $this->kec_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->kec_id->FldCaption(), $this->kec_id->ReqErrMsg));
		}
		if (!$this->desa_id->FldIsDetailKey && !is_null($this->desa_id->FormValue) && $this->desa_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->desa_id->FldCaption(), $this->desa_id->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->pes_luas_lahan->FormValue)) {
			ew_AddMessage($gsFormError, $this->pes_luas_lahan->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->pes_r_tanam_tgl->FormValue)) {
			ew_AddMessage($gsFormError, $this->pes_r_tanam_tgl->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$conn = &$this->Connection();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$this->pes_foto->OldUploadPath = "foto_peserta";
			$this->pes_foto->UploadPath = $this->pes_foto->OldUploadPath;
			$this->pes_foto_lahan->OldUploadPath = "foto_potensi_lahan";
			$this->pes_foto_lahan->UploadPath = $this->pes_foto_lahan->OldUploadPath;
			$rsnew = array();

			// pes_nama
			$this->pes_nama->SetDbValueDef($rsnew, $this->pes_nama->CurrentValue, NULL, $this->pes_nama->ReadOnly);

			// sos_id
			$this->sos_id->SetDbValueDef($rsnew, $this->sos_id->CurrentValue, NULL, $this->sos_id->ReadOnly);

			// co_id
			$this->co_id->SetDbValueDef($rsnew, $this->co_id->CurrentValue, NULL, $this->co_id->ReadOnly);

			// prov_id
			$this->prov_id->SetDbValueDef($rsnew, $this->prov_id->CurrentValue, NULL, $this->prov_id->ReadOnly);

			// kab_id
			$this->kab_id->SetDbValueDef($rsnew, $this->kab_id->CurrentValue, NULL, $this->kab_id->ReadOnly);

			// kec_id
			$this->kec_id->SetDbValueDef($rsnew, $this->kec_id->CurrentValue, NULL, $this->kec_id->ReadOnly);

			// desa_id
			$this->desa_id->SetDbValueDef($rsnew, $this->desa_id->CurrentValue, NULL, $this->desa_id->ReadOnly);

			// pes_alamat
			$this->pes_alamat->SetDbValueDef($rsnew, $this->pes_alamat->CurrentValue, NULL, $this->pes_alamat->ReadOnly);

			// pes_hp
			$this->pes_hp->SetDbValueDef($rsnew, $this->pes_hp->CurrentValue, NULL, $this->pes_hp->ReadOnly);

			// pes_foto
			if ($this->pes_foto->Visible && !$this->pes_foto->ReadOnly && !$this->pes_foto->Upload->KeepFile) {
				$this->pes_foto->Upload->DbValue = $rsold['pes_foto']; // Get original value
				if ($this->pes_foto->Upload->FileName == "") {
					$rsnew['pes_foto'] = NULL;
				} else {
					$rsnew['pes_foto'] = $this->pes_foto->Upload->FileName;
				}
				$this->pes_foto->ImageWidth = 600; // Resize width
				$this->pes_foto->ImageHeight = 600; // Resize height
			}

			// pes_luas_lahan
			$this->pes_luas_lahan->SetDbValueDef($rsnew, $this->pes_luas_lahan->CurrentValue, NULL, $this->pes_luas_lahan->ReadOnly);

			// pes_r_tanam_tgl
			$this->pes_r_tanam_tgl->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->pes_r_tanam_tgl->CurrentValue, 0), NULL, $this->pes_r_tanam_tgl->ReadOnly);

			// pes_foto_lahan
			if ($this->pes_foto_lahan->Visible && !$this->pes_foto_lahan->ReadOnly && !$this->pes_foto_lahan->Upload->KeepFile) {
				$this->pes_foto_lahan->Upload->DbValue = $rsold['pes_foto_lahan']; // Get original value
				if ($this->pes_foto_lahan->Upload->FileName == "") {
					$rsnew['pes_foto_lahan'] = NULL;
				} else {
					$rsnew['pes_foto_lahan'] = $this->pes_foto_lahan->Upload->FileName;
				}
				$this->pes_foto_lahan->ImageWidth = 800; // Resize width
				$this->pes_foto_lahan->ImageHeight = 600; // Resize height
			}
			if ($this->pes_foto->Visible && !$this->pes_foto->Upload->KeepFile) {
				$this->pes_foto->UploadPath = "foto_peserta";
				$OldFiles = ew_Empty($this->pes_foto->Upload->DbValue) ? array() : array($this->pes_foto->Upload->DbValue);
				if (!ew_Empty($this->pes_foto->Upload->FileName)) {
					$NewFiles = array($this->pes_foto->Upload->FileName);
					$NewFileCount = count($NewFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						$fldvar = ($this->pes_foto->Upload->Index < 0) ? $this->pes_foto->FldVar : substr($this->pes_foto->FldVar, 0, 1) . $this->pes_foto->Upload->Index . substr($this->pes_foto->FldVar, 1);
						if ($NewFiles[$i] <> "") {
							$file = $NewFiles[$i];
							if (file_exists(ew_UploadTempPath($fldvar, $this->pes_foto->TblVar) . $file)) {
								$OldFileFound = FALSE;
								$OldFileCount = count($OldFiles);
								for ($j = 0; $j < $OldFileCount; $j++) {
									$file1 = $OldFiles[$j];
									if ($file1 == $file) { // Old file found, no need to delete anymore
										unset($OldFiles[$j]);
										$OldFileFound = TRUE;
										break;
									}
								}
								if ($OldFileFound) // No need to check if file exists further
									continue;
								$file1 = ew_UploadFileNameEx($this->pes_foto->PhysicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(ew_UploadTempPath($fldvar, $this->pes_foto->TblVar) . $file1) || file_exists($this->pes_foto->PhysicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = ew_UniqueFilename($this->pes_foto->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(ew_UploadTempPath($fldvar, $this->pes_foto->TblVar) . $file, ew_UploadTempPath($fldvar, $this->pes_foto->TblVar) . $file1);
									$NewFiles[$i] = $file1;
								}
							}
						}
					}
					$this->pes_foto->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
					$this->pes_foto->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
					$this->pes_foto->SetDbValueDef($rsnew, $this->pes_foto->Upload->FileName, NULL, $this->pes_foto->ReadOnly);
				}
			}
			if ($this->pes_foto_lahan->Visible && !$this->pes_foto_lahan->Upload->KeepFile) {
				$this->pes_foto_lahan->UploadPath = "foto_potensi_lahan";
				$OldFiles = ew_Empty($this->pes_foto_lahan->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->pes_foto_lahan->Upload->DbValue));
				if (!ew_Empty($this->pes_foto_lahan->Upload->FileName)) {
					$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->pes_foto_lahan->Upload->FileName));
					$NewFileCount = count($NewFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						$fldvar = ($this->pes_foto_lahan->Upload->Index < 0) ? $this->pes_foto_lahan->FldVar : substr($this->pes_foto_lahan->FldVar, 0, 1) . $this->pes_foto_lahan->Upload->Index . substr($this->pes_foto_lahan->FldVar, 1);
						if ($NewFiles[$i] <> "") {
							$file = $NewFiles[$i];
							if (file_exists(ew_UploadTempPath($fldvar, $this->pes_foto_lahan->TblVar) . $file)) {
								$OldFileFound = FALSE;
								$OldFileCount = count($OldFiles);
								for ($j = 0; $j < $OldFileCount; $j++) {
									$file1 = $OldFiles[$j];
									if ($file1 == $file) { // Old file found, no need to delete anymore
										unset($OldFiles[$j]);
										$OldFileFound = TRUE;
										break;
									}
								}
								if ($OldFileFound) // No need to check if file exists further
									continue;
								$file1 = ew_UploadFileNameEx($this->pes_foto_lahan->PhysicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(ew_UploadTempPath($fldvar, $this->pes_foto_lahan->TblVar) . $file1) || file_exists($this->pes_foto_lahan->PhysicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = ew_UniqueFilename($this->pes_foto_lahan->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(ew_UploadTempPath($fldvar, $this->pes_foto_lahan->TblVar) . $file, ew_UploadTempPath($fldvar, $this->pes_foto_lahan->TblVar) . $file1);
									$NewFiles[$i] = $file1;
								}
							}
						}
					}
					$this->pes_foto_lahan->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
					$this->pes_foto_lahan->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
					$this->pes_foto_lahan->SetDbValueDef($rsnew, $this->pes_foto_lahan->Upload->FileName, NULL, $this->pes_foto_lahan->ReadOnly);
				}
			}

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
					if ($this->pes_foto->Visible && !$this->pes_foto->Upload->KeepFile) {
						$OldFiles = ew_Empty($this->pes_foto->Upload->DbValue) ? array() : array($this->pes_foto->Upload->DbValue);
						if (!ew_Empty($this->pes_foto->Upload->FileName)) {
							$NewFiles = array($this->pes_foto->Upload->FileName);
							$NewFiles2 = array($rsnew['pes_foto']);
							$NewFileCount = count($NewFiles);
							for ($i = 0; $i < $NewFileCount; $i++) {
								$fldvar = ($this->pes_foto->Upload->Index < 0) ? $this->pes_foto->FldVar : substr($this->pes_foto->FldVar, 0, 1) . $this->pes_foto->Upload->Index . substr($this->pes_foto->FldVar, 1);
								if ($NewFiles[$i] <> "") {
									$file = ew_UploadTempPath($fldvar, $this->pes_foto->TblVar) . $NewFiles[$i];
									if (file_exists($file)) {
										if (@$NewFiles2[$i] <> "") // Use correct file name
											$NewFiles[$i] = $NewFiles2[$i];
										if (!$this->pes_foto->Upload->ResizeAndSaveToFile($this->pes_foto->ImageWidth, $this->pes_foto->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$NewFiles = array();
						}
						$OldFileCount = count($OldFiles);
						for ($i = 0; $i < $OldFileCount; $i++) {
							if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
								@unlink($this->pes_foto->OldPhysicalUploadPath() . $OldFiles[$i]);
						}
					}
					if ($this->pes_foto_lahan->Visible && !$this->pes_foto_lahan->Upload->KeepFile) {
						$OldFiles = ew_Empty($this->pes_foto_lahan->Upload->DbValue) ? array() : explode(EW_MULTIPLE_UPLOAD_SEPARATOR, strval($this->pes_foto_lahan->Upload->DbValue));
						if (!ew_Empty($this->pes_foto_lahan->Upload->FileName)) {
							$NewFiles = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $this->pes_foto_lahan->Upload->FileName);
							$NewFiles2 = explode(EW_MULTIPLE_UPLOAD_SEPARATOR, $rsnew['pes_foto_lahan']);
							$NewFileCount = count($NewFiles);
							for ($i = 0; $i < $NewFileCount; $i++) {
								$fldvar = ($this->pes_foto_lahan->Upload->Index < 0) ? $this->pes_foto_lahan->FldVar : substr($this->pes_foto_lahan->FldVar, 0, 1) . $this->pes_foto_lahan->Upload->Index . substr($this->pes_foto_lahan->FldVar, 1);
								if ($NewFiles[$i] <> "") {
									$file = ew_UploadTempPath($fldvar, $this->pes_foto_lahan->TblVar) . $NewFiles[$i];
									if (file_exists($file)) {
										if (@$NewFiles2[$i] <> "") // Use correct file name
											$NewFiles[$i] = $NewFiles2[$i];
										if (!$this->pes_foto_lahan->Upload->ResizeAndSaveToFile($this->pes_foto_lahan->ImageWidth, $this->pes_foto_lahan->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$NewFiles = array();
						}
						$OldFileCount = count($OldFiles);
						for ($i = 0; $i < $OldFileCount; $i++) {
							if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
								@unlink($this->pes_foto_lahan->OldPhysicalUploadPath() . $OldFiles[$i]);
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();

		// pes_foto
		ew_CleanUploadTempPath($this->pes_foto, $this->pes_foto->Upload->Index);

		// pes_foto_lahan
		ew_CleanUploadTempPath($this->pes_foto_lahan, $this->pes_foto_lahan->Upload->Index);
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("pesertalist.php"), "", $this->TableVar, TRUE);
		$PageId = "edit";
		$Breadcrumb->Add("edit", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_sos_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `sos_id` AS `LinkFld`, `sos_tgl` AS `DispFld`, `sos_kab` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `sosialisasi`";
			$sWhereWrk = "";
			$fld->LookupFilters = array("df1" => "0");
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`sos_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->sos_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `sos_id` DESC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_co_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->co_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_prov_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `prov_id` AS `LinkFld`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`prov_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `prov_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kab_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kab_id` AS `LinkFld`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kab_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kab_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kec_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kec_id` AS `LinkFld`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kec_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kec_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`kec_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_desa_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `desa_id` AS `LinkFld`, `desa_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `desa`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`desa_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`desa_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "", "f2" => '`desa_kab_id` IN ({filter_value})', "t2" => "3", "fn2" => "", "f3" => '`desa_kec_id` IN ({filter_value})', "t3" => "3", "fn3" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->desa_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `desa_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($peserta_edit)) $peserta_edit = new cpeserta_edit();

// Page init
$peserta_edit->Page_Init();

// Page main
$peserta_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$peserta_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "edit";
var CurrentForm = fpesertaedit = new ew_Form("fpesertaedit", "edit");

// Validate form
fpesertaedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_pes_nama");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $peserta->pes_nama->FldCaption(), $peserta->pes_nama->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_sos_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $peserta->sos_id->FldCaption(), $peserta->sos_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_co_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $peserta->co_id->FldCaption(), $peserta->co_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_prov_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $peserta->prov_id->FldCaption(), $peserta->prov_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_kab_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $peserta->kab_id->FldCaption(), $peserta->kab_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_kec_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $peserta->kec_id->FldCaption(), $peserta->kec_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_desa_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $peserta->desa_id->FldCaption(), $peserta->desa_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_pes_luas_lahan");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($peserta->pes_luas_lahan->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_pes_r_tanam_tgl");
			if (elm && !ew_CheckDateDef(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($peserta->pes_r_tanam_tgl->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpesertaedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fpesertaedit.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpesertaedit.Lists["x_sos_id"] = {"LinkField":"x_sos_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_sos_tgl","x_sos_kab","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"sosialisasi"};
fpesertaedit.Lists["x_sos_id"].Data = "<?php echo $peserta_edit->sos_id->LookupFilterQuery(FALSE, "edit") ?>";
fpesertaedit.Lists["x_co_id"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
fpesertaedit.Lists["x_co_id"].Data = "<?php echo $peserta_edit->co_id->LookupFilterQuery(FALSE, "edit") ?>";
fpesertaedit.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id","x_kec_id","x_desa_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fpesertaedit.Lists["x_prov_id"].Data = "<?php echo $peserta_edit->prov_id->LookupFilterQuery(FALSE, "edit") ?>";
fpesertaedit.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":["x_prov_id"],"ChildFields":["x_kec_id","x_desa_id"],"FilterFields":["x_kab_prov_id"],"Options":[],"Template":"","LinkTable":"kab"};
fpesertaedit.Lists["x_kab_id"].Data = "<?php echo $peserta_edit->kab_id->LookupFilterQuery(FALSE, "edit") ?>";
fpesertaedit.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":["x_prov_id","x_kab_id"],"ChildFields":["x_desa_id"],"FilterFields":["x_kec_prov_id","x_kec_kab_id"],"Options":[],"Template":"","LinkTable":"kec"};
fpesertaedit.Lists["x_kec_id"].Data = "<?php echo $peserta_edit->kec_id->LookupFilterQuery(FALSE, "edit") ?>";
fpesertaedit.Lists["x_desa_id"] = {"LinkField":"x_desa_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_desa_nama","","",""],"ParentFields":["x_prov_id","x_kab_id","x_kec_id"],"ChildFields":[],"FilterFields":["x_desa_prov_id","x_desa_kab_id","x_desa_kec_id"],"Options":[],"Template":"","LinkTable":"desa"};
fpesertaedit.Lists["x_desa_id"].Data = "<?php echo $peserta_edit->desa_id->LookupFilterQuery(FALSE, "edit") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $peserta_edit->ShowPageHeader(); ?>
<?php
$peserta_edit->ShowMessage();
?>
<form name="fpesertaedit" id="fpesertaedit" class="<?php echo $peserta_edit->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($peserta_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $peserta_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="peserta">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<input type="hidden" name="modal" value="<?php echo intval($peserta_edit->IsModal) ?>">
<div class="ewEditDiv"><!-- page* -->
<?php if ($peserta->pes_id->Visible) { // pes_id ?>
	<div id="r_pes_id" class="form-group">
		<label id="elh_peserta_pes_id" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->pes_id->FldCaption() ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->pes_id->CellAttributes() ?>>
<span id="el_peserta_pes_id">
<span<?php echo $peserta->pes_id->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $peserta->pes_id->EditValue ?></p></span>
</span>
<input type="hidden" data-table="peserta" data-field="x_pes_id" name="x_pes_id" id="x_pes_id" value="<?php echo ew_HtmlEncode($peserta->pes_id->CurrentValue) ?>">
<?php echo $peserta->pes_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->pes_nama->Visible) { // pes_nama ?>
	<div id="r_pes_nama" class="form-group">
		<label id="elh_peserta_pes_nama" for="x_pes_nama" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->pes_nama->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->pes_nama->CellAttributes() ?>>
<span id="el_peserta_pes_nama">
<input type="text" data-table="peserta" data-field="x_pes_nama" name="x_pes_nama" id="x_pes_nama" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($peserta->pes_nama->getPlaceHolder()) ?>" value="<?php echo $peserta->pes_nama->EditValue ?>"<?php echo $peserta->pes_nama->EditAttributes() ?>>
</span>
<?php echo $peserta->pes_nama->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->sos_id->Visible) { // sos_id ?>
	<div id="r_sos_id" class="form-group">
		<label id="elh_peserta_sos_id" for="x_sos_id" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->sos_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->sos_id->CellAttributes() ?>>
<span id="el_peserta_sos_id">
<select data-table="peserta" data-field="x_sos_id" data-value-separator="<?php echo $peserta->sos_id->DisplayValueSeparatorAttribute() ?>" id="x_sos_id" name="x_sos_id"<?php echo $peserta->sos_id->EditAttributes() ?>>
<?php echo $peserta->sos_id->SelectOptionListHtml("x_sos_id") ?>
</select>
</span>
<?php echo $peserta->sos_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->co_id->Visible) { // co_id ?>
	<div id="r_co_id" class="form-group">
		<label id="elh_peserta_co_id" for="x_co_id" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->co_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->co_id->CellAttributes() ?>>
<span id="el_peserta_co_id">
<select data-table="peserta" data-field="x_co_id" data-value-separator="<?php echo $peserta->co_id->DisplayValueSeparatorAttribute() ?>" id="x_co_id" name="x_co_id"<?php echo $peserta->co_id->EditAttributes() ?>>
<?php echo $peserta->co_id->SelectOptionListHtml("x_co_id") ?>
</select>
</span>
<?php echo $peserta->co_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->prov_id->Visible) { // prov_id ?>
	<div id="r_prov_id" class="form-group">
		<label id="elh_peserta_prov_id" for="x_prov_id" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->prov_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->prov_id->CellAttributes() ?>>
<span id="el_peserta_prov_id">
<?php $peserta->prov_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$peserta->prov_id->EditAttrs["onchange"]; ?>
<select data-table="peserta" data-field="x_prov_id" data-value-separator="<?php echo $peserta->prov_id->DisplayValueSeparatorAttribute() ?>" id="x_prov_id" name="x_prov_id"<?php echo $peserta->prov_id->EditAttributes() ?>>
<?php echo $peserta->prov_id->SelectOptionListHtml("x_prov_id") ?>
</select>
</span>
<?php echo $peserta->prov_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->kab_id->Visible) { // kab_id ?>
	<div id="r_kab_id" class="form-group">
		<label id="elh_peserta_kab_id" for="x_kab_id" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->kab_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->kab_id->CellAttributes() ?>>
<span id="el_peserta_kab_id">
<?php $peserta->kab_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$peserta->kab_id->EditAttrs["onchange"]; ?>
<select data-table="peserta" data-field="x_kab_id" data-value-separator="<?php echo $peserta->kab_id->DisplayValueSeparatorAttribute() ?>" id="x_kab_id" name="x_kab_id"<?php echo $peserta->kab_id->EditAttributes() ?>>
<?php echo $peserta->kab_id->SelectOptionListHtml("x_kab_id") ?>
</select>
</span>
<?php echo $peserta->kab_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->kec_id->Visible) { // kec_id ?>
	<div id="r_kec_id" class="form-group">
		<label id="elh_peserta_kec_id" for="x_kec_id" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->kec_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->kec_id->CellAttributes() ?>>
<span id="el_peserta_kec_id">
<?php $peserta->kec_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$peserta->kec_id->EditAttrs["onchange"]; ?>
<select data-table="peserta" data-field="x_kec_id" data-value-separator="<?php echo $peserta->kec_id->DisplayValueSeparatorAttribute() ?>" id="x_kec_id" name="x_kec_id"<?php echo $peserta->kec_id->EditAttributes() ?>>
<?php echo $peserta->kec_id->SelectOptionListHtml("x_kec_id") ?>
</select>
</span>
<?php echo $peserta->kec_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->desa_id->Visible) { // desa_id ?>
	<div id="r_desa_id" class="form-group">
		<label id="elh_peserta_desa_id" for="x_desa_id" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->desa_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->desa_id->CellAttributes() ?>>
<span id="el_peserta_desa_id">
<select data-table="peserta" data-field="x_desa_id" data-value-separator="<?php echo $peserta->desa_id->DisplayValueSeparatorAttribute() ?>" id="x_desa_id" name="x_desa_id"<?php echo $peserta->desa_id->EditAttributes() ?>>
<?php echo $peserta->desa_id->SelectOptionListHtml("x_desa_id") ?>
</select>
</span>
<?php echo $peserta->desa_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->pes_alamat->Visible) { // pes_alamat ?>
	<div id="r_pes_alamat" class="form-group">
		<label id="elh_peserta_pes_alamat" for="x_pes_alamat" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->pes_alamat->FldCaption() ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->pes_alamat->CellAttributes() ?>>
<span id="el_peserta_pes_alamat">
<input type="text" data-table="peserta" data-field="x_pes_alamat" name="x_pes_alamat" id="x_pes_alamat" size="30" maxlength="200" placeholder="<?php echo ew_HtmlEncode($peserta->pes_alamat->getPlaceHolder()) ?>" value="<?php echo $peserta->pes_alamat->EditValue ?>"<?php echo $peserta->pes_alamat->EditAttributes() ?>>
</span>
<?php echo $peserta->pes_alamat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->pes_hp->Visible) { // pes_hp ?>
	<div id="r_pes_hp" class="form-group">
		<label id="elh_peserta_pes_hp" for="x_pes_hp" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->pes_hp->FldCaption() ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->pes_hp->CellAttributes() ?>>
<span id="el_peserta_pes_hp">
<input type="text" data-table="peserta" data-field="x_pes_hp" name="x_pes_hp" id="x_pes_hp" size="30" maxlength="20" placeholder="<?php echo ew_HtmlEncode($peserta->pes_hp->getPlaceHolder()) ?>" value="<?php echo $peserta->pes_hp->EditValue ?>"<?php echo $peserta->pes_hp->EditAttributes() ?>>
</span>
<?php echo $peserta->pes_hp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->pes_foto->Visible) { // pes_foto ?>
	<div id="r_pes_foto" class="form-group">
		<label id="elh_peserta_pes_foto" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->pes_foto->FldCaption() ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->pes_foto->CellAttributes() ?>>
<span id="el_peserta_pes_foto">
<div id="fd_x_pes_foto">
<span title="<?php echo $peserta->pes_foto->FldTitle() ? $peserta->pes_foto->FldTitle() : $Language->Phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($peserta->pes_foto->ReadOnly || $peserta->pes_foto->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="peserta" data-field="x_pes_foto" name="x_pes_foto" id="x_pes_foto"<?php echo $peserta->pes_foto->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_pes_foto" id= "fn_x_pes_foto" value="<?php echo $peserta->pes_foto->Upload->FileName ?>">
<?php if (@$_POST["fa_x_pes_foto"] == "0") { ?>
<input type="hidden" name="fa_x_pes_foto" id= "fa_x_pes_foto" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_pes_foto" id= "fa_x_pes_foto" value="1">
<?php } ?>
<input type="hidden" name="fs_x_pes_foto" id= "fs_x_pes_foto" value="100">
<input type="hidden" name="fx_x_pes_foto" id= "fx_x_pes_foto" value="<?php echo $peserta->pes_foto->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_pes_foto" id= "fm_x_pes_foto" value="<?php echo $peserta->pes_foto->UploadMaxFileSize ?>">
</div>
<table id="ft_x_pes_foto" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $peserta->pes_foto->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->pes_luas_lahan->Visible) { // pes_luas_lahan ?>
	<div id="r_pes_luas_lahan" class="form-group">
		<label id="elh_peserta_pes_luas_lahan" for="x_pes_luas_lahan" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->pes_luas_lahan->FldCaption() ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->pes_luas_lahan->CellAttributes() ?>>
<span id="el_peserta_pes_luas_lahan">
<input type="text" data-table="peserta" data-field="x_pes_luas_lahan" name="x_pes_luas_lahan" id="x_pes_luas_lahan" size="30" placeholder="<?php echo ew_HtmlEncode($peserta->pes_luas_lahan->getPlaceHolder()) ?>" value="<?php echo $peserta->pes_luas_lahan->EditValue ?>"<?php echo $peserta->pes_luas_lahan->EditAttributes() ?>>
</span>
<?php echo $peserta->pes_luas_lahan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->pes_r_tanam_tgl->Visible) { // pes_r_tanam_tgl ?>
	<div id="r_pes_r_tanam_tgl" class="form-group">
		<label id="elh_peserta_pes_r_tanam_tgl" for="x_pes_r_tanam_tgl" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->pes_r_tanam_tgl->FldCaption() ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->pes_r_tanam_tgl->CellAttributes() ?>>
<span id="el_peserta_pes_r_tanam_tgl">
<input type="text" data-table="peserta" data-field="x_pes_r_tanam_tgl" name="x_pes_r_tanam_tgl" id="x_pes_r_tanam_tgl" placeholder="<?php echo ew_HtmlEncode($peserta->pes_r_tanam_tgl->getPlaceHolder()) ?>" value="<?php echo $peserta->pes_r_tanam_tgl->EditValue ?>"<?php echo $peserta->pes_r_tanam_tgl->EditAttributes() ?>>
<?php if (!$peserta->pes_r_tanam_tgl->ReadOnly && !$peserta->pes_r_tanam_tgl->Disabled && !isset($peserta->pes_r_tanam_tgl->EditAttrs["readonly"]) && !isset($peserta->pes_r_tanam_tgl->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("fpesertaedit", "x_pes_r_tanam_tgl", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $peserta->pes_r_tanam_tgl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($peserta->pes_foto_lahan->Visible) { // pes_foto_lahan ?>
	<div id="r_pes_foto_lahan" class="form-group">
		<label id="elh_peserta_pes_foto_lahan" class="<?php echo $peserta_edit->LeftColumnClass ?>"><?php echo $peserta->pes_foto_lahan->FldCaption() ?></label>
		<div class="<?php echo $peserta_edit->RightColumnClass ?>"><div<?php echo $peserta->pes_foto_lahan->CellAttributes() ?>>
<span id="el_peserta_pes_foto_lahan">
<div id="fd_x_pes_foto_lahan">
<span title="<?php echo $peserta->pes_foto_lahan->FldTitle() ? $peserta->pes_foto_lahan->FldTitle() : $Language->Phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($peserta->pes_foto_lahan->ReadOnly || $peserta->pes_foto_lahan->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="peserta" data-field="x_pes_foto_lahan" name="x_pes_foto_lahan" id="x_pes_foto_lahan" multiple="multiple"<?php echo $peserta->pes_foto_lahan->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_pes_foto_lahan" id= "fn_x_pes_foto_lahan" value="<?php echo $peserta->pes_foto_lahan->Upload->FileName ?>">
<?php if (@$_POST["fa_x_pes_foto_lahan"] == "0") { ?>
<input type="hidden" name="fa_x_pes_foto_lahan" id= "fa_x_pes_foto_lahan" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_pes_foto_lahan" id= "fa_x_pes_foto_lahan" value="1">
<?php } ?>
<input type="hidden" name="fs_x_pes_foto_lahan" id= "fs_x_pes_foto_lahan" value="100">
<input type="hidden" name="fx_x_pes_foto_lahan" id= "fx_x_pes_foto_lahan" value="<?php echo $peserta->pes_foto_lahan->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_pes_foto_lahan" id= "fm_x_pes_foto_lahan" value="<?php echo $peserta->pes_foto_lahan->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_pes_foto_lahan" id= "fc_x_pes_foto_lahan" value="<?php echo $peserta->pes_foto_lahan->UploadMaxFileCount ?>">
</div>
<table id="ft_x_pes_foto_lahan" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $peserta->pes_foto_lahan->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$peserta_edit->IsModal) { ?>
<div class="form-group"><!-- buttons .form-group -->
	<div class="<?php echo $peserta_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("SaveBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $peserta_edit->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<script type="text/javascript">
fpesertaedit.Init();
</script>
<?php
$peserta_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$peserta_edit->Page_Terminate();
?>
