<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "order_bibitinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$order_bibit_list = NULL; // Initialize page object first

class corder_bibit_list extends corder_bibit {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'order_bibit';

	// Page object name
	var $PageObjName = 'order_bibit_list';

	// Grid form hidden field names
	var $FormName = 'forder_bibitlist';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (order_bibit)
		if (!isset($GLOBALS["order_bibit"]) || get_class($GLOBALS["order_bibit"]) == "corder_bibit") {
			$GLOBALS["order_bibit"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["order_bibit"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "order_bibitadd.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "order_bibitdelete.php";
		$this->MultiUpdateUrl = "order_bibitupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'order_bibit', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption forder_bibitlistsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			$this->Page_Terminate(ew_GetUrl("index.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Get export parameters

		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} elseif (@$_GET["cmd"] == "json") {
			$this->Export = $_GET["cmd"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();

		// Setup export options
		$this->SetupExportOptions();
		$this->ob_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->ob_id->Visible = FALSE;
		$this->ob_co->SetVisibility();
		$this->ob_k_tanam->SetVisibility();
		$this->ob_pembeli->SetVisibility();
		$this->ob_tgl_kirim->SetVisibility();
		$this->ob_var->SetVisibility();
		$this->ob_jumlah->SetVisibility();
		$this->status->SetVisibility();
		$this->ob_tgl_real_kirim->SetVisibility();
		$this->ob_jumlah_real_kirim->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $order_bibit;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($order_bibit);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 100;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $AutoHidePager = EW_AUTO_HIDE_PAGER;
	var $AutoHidePageSizeSelector = EW_AUTO_HIDE_PAGE_SIZE_SELECTOR;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security, $EW_EXPORT;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));
			ew_AddFilter($this->DefaultSearchWhere, $this->AdvancedSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->LoadSearchValues(); // Get search values

			// Process filter list
			$this->ProcessFilterList();
			if (!$this->ValidateSearch())
				$this->setFailureMessage($gsSearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetupSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Get search criteria for advanced search
			if ($gsSearchError == "")
				$sSrchAdvanced = $this->AdvancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 100; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();

			// Load advanced search from default
			if ($this->LoadAdvancedSearchDefault()) {
				$sSrchAdvanced = $this->AdvancedSearchWhere();
			}
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		if (!$Security->CanList())
			$sFilter = "(0=1)"; // Filter all records
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSQL = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $sFilter;
		} else {
			$this->setSessionWhere($sFilter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if ($this->CustomExport == "" && in_array($this->Export, array_keys($EW_EXPORT))) {
			$this->ExportData();
			$this->Page_Terminate(); // Terminate response
			exit();
		}

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->ListRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->ob_id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->ob_id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {
		global $UserProfile;

		// Initialize
		$sFilterList = "";
		$sSavedFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->ob_id->AdvancedSearch->ToJson(), ","); // Field ob_id
		$sFilterList = ew_Concat($sFilterList, $this->ob_co->AdvancedSearch->ToJson(), ","); // Field ob_co
		$sFilterList = ew_Concat($sFilterList, $this->ob_k_tanam->AdvancedSearch->ToJson(), ","); // Field ob_k_tanam
		$sFilterList = ew_Concat($sFilterList, $this->ob_pembeli->AdvancedSearch->ToJson(), ","); // Field ob_pembeli
		$sFilterList = ew_Concat($sFilterList, $this->ob_tgl_kirim->AdvancedSearch->ToJson(), ","); // Field ob_tgl_kirim
		$sFilterList = ew_Concat($sFilterList, $this->ob_var->AdvancedSearch->ToJson(), ","); // Field ob_var
		$sFilterList = ew_Concat($sFilterList, $this->ob_jumlah->AdvancedSearch->ToJson(), ","); // Field ob_jumlah
		$sFilterList = ew_Concat($sFilterList, $this->status->AdvancedSearch->ToJson(), ","); // Field status
		$sFilterList = ew_Concat($sFilterList, $this->ob_tgl_real_kirim->AdvancedSearch->ToJson(), ","); // Field ob_tgl_real_kirim
		$sFilterList = ew_Concat($sFilterList, $this->ob_jumlah_real_kirim->AdvancedSearch->ToJson(), ","); // Field ob_jumlah_real_kirim
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}
		$sFilterList = preg_replace('/,$/', "", $sFilterList);

		// Return filter list in json
		if ($sFilterList <> "")
			$sFilterList = "\"data\":{" . $sFilterList . "}";
		if ($sSavedFilterList <> "") {
			if ($sFilterList <> "")
				$sFilterList .= ",";
			$sFilterList .= "\"filters\":" . $sSavedFilterList;
		}
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Process filter list
	function ProcessFilterList() {
		global $UserProfile;
		if (@$_POST["ajax"] == "savefilters") { // Save filter request (Ajax)
			$filters = @$_POST["filters"];
			$UserProfile->SetSearchFilters(CurrentUserName(), "forder_bibitlistsrch", $filters);

			// Clean output buffer
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			echo ew_ArrayToJson(array(array("success" => TRUE))); // Success
			$this->Page_Terminate();
			exit();
		} elseif (@$_POST["cmd"] == "resetfilter") {
			$this->RestoreFilterList();
		}
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(@$_POST["filter"], TRUE);
		$this->Command = "search";

		// Field ob_id
		$this->ob_id->AdvancedSearch->SearchValue = @$filter["x_ob_id"];
		$this->ob_id->AdvancedSearch->SearchOperator = @$filter["z_ob_id"];
		$this->ob_id->AdvancedSearch->SearchCondition = @$filter["v_ob_id"];
		$this->ob_id->AdvancedSearch->SearchValue2 = @$filter["y_ob_id"];
		$this->ob_id->AdvancedSearch->SearchOperator2 = @$filter["w_ob_id"];
		$this->ob_id->AdvancedSearch->Save();

		// Field ob_co
		$this->ob_co->AdvancedSearch->SearchValue = @$filter["x_ob_co"];
		$this->ob_co->AdvancedSearch->SearchOperator = @$filter["z_ob_co"];
		$this->ob_co->AdvancedSearch->SearchCondition = @$filter["v_ob_co"];
		$this->ob_co->AdvancedSearch->SearchValue2 = @$filter["y_ob_co"];
		$this->ob_co->AdvancedSearch->SearchOperator2 = @$filter["w_ob_co"];
		$this->ob_co->AdvancedSearch->Save();

		// Field ob_k_tanam
		$this->ob_k_tanam->AdvancedSearch->SearchValue = @$filter["x_ob_k_tanam"];
		$this->ob_k_tanam->AdvancedSearch->SearchOperator = @$filter["z_ob_k_tanam"];
		$this->ob_k_tanam->AdvancedSearch->SearchCondition = @$filter["v_ob_k_tanam"];
		$this->ob_k_tanam->AdvancedSearch->SearchValue2 = @$filter["y_ob_k_tanam"];
		$this->ob_k_tanam->AdvancedSearch->SearchOperator2 = @$filter["w_ob_k_tanam"];
		$this->ob_k_tanam->AdvancedSearch->Save();

		// Field ob_pembeli
		$this->ob_pembeli->AdvancedSearch->SearchValue = @$filter["x_ob_pembeli"];
		$this->ob_pembeli->AdvancedSearch->SearchOperator = @$filter["z_ob_pembeli"];
		$this->ob_pembeli->AdvancedSearch->SearchCondition = @$filter["v_ob_pembeli"];
		$this->ob_pembeli->AdvancedSearch->SearchValue2 = @$filter["y_ob_pembeli"];
		$this->ob_pembeli->AdvancedSearch->SearchOperator2 = @$filter["w_ob_pembeli"];
		$this->ob_pembeli->AdvancedSearch->Save();

		// Field ob_tgl_kirim
		$this->ob_tgl_kirim->AdvancedSearch->SearchValue = @$filter["x_ob_tgl_kirim"];
		$this->ob_tgl_kirim->AdvancedSearch->SearchOperator = @$filter["z_ob_tgl_kirim"];
		$this->ob_tgl_kirim->AdvancedSearch->SearchCondition = @$filter["v_ob_tgl_kirim"];
		$this->ob_tgl_kirim->AdvancedSearch->SearchValue2 = @$filter["y_ob_tgl_kirim"];
		$this->ob_tgl_kirim->AdvancedSearch->SearchOperator2 = @$filter["w_ob_tgl_kirim"];
		$this->ob_tgl_kirim->AdvancedSearch->Save();

		// Field ob_var
		$this->ob_var->AdvancedSearch->SearchValue = @$filter["x_ob_var"];
		$this->ob_var->AdvancedSearch->SearchOperator = @$filter["z_ob_var"];
		$this->ob_var->AdvancedSearch->SearchCondition = @$filter["v_ob_var"];
		$this->ob_var->AdvancedSearch->SearchValue2 = @$filter["y_ob_var"];
		$this->ob_var->AdvancedSearch->SearchOperator2 = @$filter["w_ob_var"];
		$this->ob_var->AdvancedSearch->Save();

		// Field ob_jumlah
		$this->ob_jumlah->AdvancedSearch->SearchValue = @$filter["x_ob_jumlah"];
		$this->ob_jumlah->AdvancedSearch->SearchOperator = @$filter["z_ob_jumlah"];
		$this->ob_jumlah->AdvancedSearch->SearchCondition = @$filter["v_ob_jumlah"];
		$this->ob_jumlah->AdvancedSearch->SearchValue2 = @$filter["y_ob_jumlah"];
		$this->ob_jumlah->AdvancedSearch->SearchOperator2 = @$filter["w_ob_jumlah"];
		$this->ob_jumlah->AdvancedSearch->Save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->Save();

		// Field ob_tgl_real_kirim
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchValue = @$filter["x_ob_tgl_real_kirim"];
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchOperator = @$filter["z_ob_tgl_real_kirim"];
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchCondition = @$filter["v_ob_tgl_real_kirim"];
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchValue2 = @$filter["y_ob_tgl_real_kirim"];
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchOperator2 = @$filter["w_ob_tgl_real_kirim"];
		$this->ob_tgl_real_kirim->AdvancedSearch->Save();

		// Field ob_jumlah_real_kirim
		$this->ob_jumlah_real_kirim->AdvancedSearch->SearchValue = @$filter["x_ob_jumlah_real_kirim"];
		$this->ob_jumlah_real_kirim->AdvancedSearch->SearchOperator = @$filter["z_ob_jumlah_real_kirim"];
		$this->ob_jumlah_real_kirim->AdvancedSearch->SearchCondition = @$filter["v_ob_jumlah_real_kirim"];
		$this->ob_jumlah_real_kirim->AdvancedSearch->SearchValue2 = @$filter["y_ob_jumlah_real_kirim"];
		$this->ob_jumlah_real_kirim->AdvancedSearch->SearchOperator2 = @$filter["w_ob_jumlah_real_kirim"];
		$this->ob_jumlah_real_kirim->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	function AdvancedSearchWhere($Default = FALSE) {
		global $Security;
		$sWhere = "";
		if (!$Security->CanSearch()) return "";
		$this->BuildSearchSql($sWhere, $this->ob_id, $Default, FALSE); // ob_id
		$this->BuildSearchSql($sWhere, $this->ob_co, $Default, FALSE); // ob_co
		$this->BuildSearchSql($sWhere, $this->ob_k_tanam, $Default, FALSE); // ob_k_tanam
		$this->BuildSearchSql($sWhere, $this->ob_pembeli, $Default, FALSE); // ob_pembeli
		$this->BuildSearchSql($sWhere, $this->ob_tgl_kirim, $Default, FALSE); // ob_tgl_kirim
		$this->BuildSearchSql($sWhere, $this->ob_var, $Default, FALSE); // ob_var
		$this->BuildSearchSql($sWhere, $this->ob_jumlah, $Default, FALSE); // ob_jumlah
		$this->BuildSearchSql($sWhere, $this->status, $Default, FALSE); // status
		$this->BuildSearchSql($sWhere, $this->ob_tgl_real_kirim, $Default, FALSE); // ob_tgl_real_kirim
		$this->BuildSearchSql($sWhere, $this->ob_jumlah_real_kirim, $Default, FALSE); // ob_jumlah_real_kirim

		// Set up search parm
		if (!$Default && $sWhere <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->ob_id->AdvancedSearch->Save(); // ob_id
			$this->ob_co->AdvancedSearch->Save(); // ob_co
			$this->ob_k_tanam->AdvancedSearch->Save(); // ob_k_tanam
			$this->ob_pembeli->AdvancedSearch->Save(); // ob_pembeli
			$this->ob_tgl_kirim->AdvancedSearch->Save(); // ob_tgl_kirim
			$this->ob_var->AdvancedSearch->Save(); // ob_var
			$this->ob_jumlah->AdvancedSearch->Save(); // ob_jumlah
			$this->status->AdvancedSearch->Save(); // status
			$this->ob_tgl_real_kirim->AdvancedSearch->Save(); // ob_tgl_real_kirim
			$this->ob_jumlah_real_kirim->AdvancedSearch->Save(); // ob_jumlah_real_kirim
		}
		return $sWhere;
	}

	// Build search SQL
	function BuildSearchSql(&$Where, &$Fld, $Default, $MultiValue) {
		$FldParm = $Fld->FldParm();
		$FldVal = ($Default) ? $Fld->AdvancedSearch->SearchValueDefault : $Fld->AdvancedSearch->SearchValue; // @$_GET["x_$FldParm"]
		$FldOpr = ($Default) ? $Fld->AdvancedSearch->SearchOperatorDefault : $Fld->AdvancedSearch->SearchOperator; // @$_GET["z_$FldParm"]
		$FldCond = ($Default) ? $Fld->AdvancedSearch->SearchConditionDefault : $Fld->AdvancedSearch->SearchCondition; // @$_GET["v_$FldParm"]
		$FldVal2 = ($Default) ? $Fld->AdvancedSearch->SearchValue2Default : $Fld->AdvancedSearch->SearchValue2; // @$_GET["y_$FldParm"]
		$FldOpr2 = ($Default) ? $Fld->AdvancedSearch->SearchOperator2Default : $Fld->AdvancedSearch->SearchOperator2; // @$_GET["w_$FldParm"]
		$sWrk = "";
		if (is_array($FldVal)) $FldVal = implode(",", $FldVal);
		if (is_array($FldVal2)) $FldVal2 = implode(",", $FldVal2);
		$FldOpr = strtoupper(trim($FldOpr));
		if ($FldOpr == "") $FldOpr = "=";
		$FldOpr2 = strtoupper(trim($FldOpr2));
		if ($FldOpr2 == "") $FldOpr2 = "=";
		if (EW_SEARCH_MULTI_VALUE_OPTION == 1)
			$MultiValue = FALSE;
		if ($MultiValue) {
			$sWrk1 = ($FldVal <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr, $FldVal, $this->DBID) : ""; // Field value 1
			$sWrk2 = ($FldVal2 <> "") ? ew_GetMultiSearchSql($Fld, $FldOpr2, $FldVal2, $this->DBID) : ""; // Field value 2
			$sWrk = $sWrk1; // Build final SQL
			if ($sWrk2 <> "")
				$sWrk = ($sWrk <> "") ? "($sWrk) $FldCond ($sWrk2)" : $sWrk2;
		} else {
			$FldVal = $this->ConvertSearchValue($Fld, $FldVal);
			$FldVal2 = $this->ConvertSearchValue($Fld, $FldVal2);
			$sWrk = ew_GetSearchSql($Fld, $FldVal, $FldOpr, $FldCond, $FldVal2, $FldOpr2, $this->DBID);
		}
		ew_AddFilter($Where, $sWrk);
	}

	// Convert search value
	function ConvertSearchValue(&$Fld, $FldVal) {
		if ($FldVal == EW_NULL_VALUE || $FldVal == EW_NOT_NULL_VALUE)
			return $FldVal;
		$Value = $FldVal;
		if ($Fld->FldDataType == EW_DATATYPE_BOOLEAN) {
			if ($FldVal <> "") $Value = ($FldVal == "1" || strtolower(strval($FldVal)) == "y" || strtolower(strval($FldVal)) == "t") ? $Fld->TrueValue : $Fld->FalseValue;
		} elseif ($Fld->FldDataType == EW_DATATYPE_DATE || $Fld->FldDataType == EW_DATATYPE_TIME) {
			if ($FldVal <> "") $Value = ew_UnFormatDateTime($FldVal, $Fld->FldDateTimeFormat);
		}
		return $Value;
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->ob_id, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ob_co, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ob_k_tanam, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ob_pembeli, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ob_tgl_kirim, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ob_var, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ob_jumlah, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->status, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ob_tgl_real_kirim, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->ob_jumlah_real_kirim, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSQL(&$Where, &$Fld, $arKeywords, $type) {
		global $EW_BASIC_SEARCH_IGNORE_PATTERN;
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if ($EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace($EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .= "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		if (!$Security->CanSearch()) return "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($sSearchKeyword <> "") {
			$ar = $this->BasicSearch->KeywordList($Default);

			// Search keyword in any fields
			if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $sKeyword) {
					if ($sKeyword <> "") {
						if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
						$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
					}
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
			}
			if (!$Default && in_array($this->Command, array("", "reset", "resetall"))) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		if ($this->ob_id->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ob_co->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ob_k_tanam->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ob_pembeli->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ob_tgl_kirim->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ob_var->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ob_jumlah->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ob_tgl_real_kirim->AdvancedSearch->IssetSession())
			return TRUE;
		if ($this->ob_jumlah_real_kirim->AdvancedSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();

		// Clear advanced search parameters
		$this->ResetAdvancedSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Clear all advanced search parameters
	function ResetAdvancedSearchParms() {
		$this->ob_id->AdvancedSearch->UnsetSession();
		$this->ob_co->AdvancedSearch->UnsetSession();
		$this->ob_k_tanam->AdvancedSearch->UnsetSession();
		$this->ob_pembeli->AdvancedSearch->UnsetSession();
		$this->ob_tgl_kirim->AdvancedSearch->UnsetSession();
		$this->ob_var->AdvancedSearch->UnsetSession();
		$this->ob_jumlah->AdvancedSearch->UnsetSession();
		$this->status->AdvancedSearch->UnsetSession();
		$this->ob_tgl_real_kirim->AdvancedSearch->UnsetSession();
		$this->ob_jumlah_real_kirim->AdvancedSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();

		// Restore advanced search values
		$this->ob_id->AdvancedSearch->Load();
		$this->ob_co->AdvancedSearch->Load();
		$this->ob_k_tanam->AdvancedSearch->Load();
		$this->ob_pembeli->AdvancedSearch->Load();
		$this->ob_tgl_kirim->AdvancedSearch->Load();
		$this->ob_var->AdvancedSearch->Load();
		$this->ob_jumlah->AdvancedSearch->Load();
		$this->status->AdvancedSearch->Load();
		$this->ob_tgl_real_kirim->AdvancedSearch->Load();
		$this->ob_jumlah_real_kirim->AdvancedSearch->Load();
	}

	// Set up sort parameters
	function SetupSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = @$_GET["order"];
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->ob_id); // ob_id
			$this->UpdateSort($this->ob_co); // ob_co
			$this->UpdateSort($this->ob_k_tanam); // ob_k_tanam
			$this->UpdateSort($this->ob_pembeli); // ob_pembeli
			$this->UpdateSort($this->ob_tgl_kirim); // ob_tgl_kirim
			$this->UpdateSort($this->ob_var); // ob_var
			$this->UpdateSort($this->ob_jumlah); // ob_jumlah
			$this->UpdateSort($this->status); // status
			$this->UpdateSort($this->ob_tgl_real_kirim); // ob_tgl_real_kirim
			$this->UpdateSort($this->ob_jumlah_real_kirim); // ob_jumlah_real_kirim
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
				$this->ob_id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->ob_id->setSort("");
				$this->ob_co->setSort("");
				$this->ob_k_tanam->setSort("");
				$this->ob_pembeli->setSort("");
				$this->ob_tgl_kirim->setSort("");
				$this->ob_var->setSort("");
				$this->ob_jumlah->setSort("");
				$this->status->setSort("");
				$this->ob_tgl_real_kirim->setSort("");
				$this->ob_jumlah_real_kirim->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->CanAdd();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = $Security->CanDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->MoveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		$viewcaption = ew_HtmlTitle($Language->Phrase("ViewLink"));
		if ($Security->CanView()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		$editcaption = ew_HtmlTitle($Language->Phrase("EditLink"));
		if ($Security->CanEdit()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		$copycaption = ew_HtmlTitle($Language->Phrase("CopyLink"));
		if ($Security->CanAdd()) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ewMultiSelect\" value=\"" . ew_HtmlEncode($this->ob_id->CurrentValue) . "\" onclick=\"ew_ClickMultiCheckbox(event);\">";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$addcaption = ew_HtmlTitle($Language->Phrase("AddLink"));
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());
		$option = $options["action"];

		// Add multi delete
		$item = &$option->Add("multidelete");
		$item->Body = "<a class=\"ewAction ewMultiDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteSelectedLink")) . "\" href=\"\" onclick=\"ew_SubmitAction(event,{f:document.forder_bibitlist,url:'" . $this->MultiDeleteUrl . "'});return false;\">" . $Language->Phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = ($Security->CanDelete());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"forder_bibitlistsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"forder_bibitlistsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.forder_bibitlist}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"forder_bibitlistsrch\">" . $Language->Phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
		global $Security;
		if (!$Security->CanSearch()) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetupStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load search values for validation
	function LoadSearchValues() {
		global $objForm;

		// Load search values
		// ob_id

		$this->ob_id->AdvancedSearch->SearchValue = @$_GET["x_ob_id"];
		if ($this->ob_id->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_id->AdvancedSearch->SearchOperator = @$_GET["z_ob_id"];

		// ob_co
		$this->ob_co->AdvancedSearch->SearchValue = @$_GET["x_ob_co"];
		if ($this->ob_co->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_co->AdvancedSearch->SearchOperator = @$_GET["z_ob_co"];

		// ob_k_tanam
		$this->ob_k_tanam->AdvancedSearch->SearchValue = @$_GET["x_ob_k_tanam"];
		if ($this->ob_k_tanam->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_k_tanam->AdvancedSearch->SearchOperator = @$_GET["z_ob_k_tanam"];

		// ob_pembeli
		$this->ob_pembeli->AdvancedSearch->SearchValue = @$_GET["x_ob_pembeli"];
		if ($this->ob_pembeli->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_pembeli->AdvancedSearch->SearchOperator = @$_GET["z_ob_pembeli"];

		// ob_tgl_kirim
		$this->ob_tgl_kirim->AdvancedSearch->SearchValue = @$_GET["x_ob_tgl_kirim"];
		if ($this->ob_tgl_kirim->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_tgl_kirim->AdvancedSearch->SearchOperator = @$_GET["z_ob_tgl_kirim"];
		$this->ob_tgl_kirim->AdvancedSearch->SearchCondition = @$_GET["v_ob_tgl_kirim"];
		$this->ob_tgl_kirim->AdvancedSearch->SearchValue2 = @$_GET["y_ob_tgl_kirim"];
		if ($this->ob_tgl_kirim->AdvancedSearch->SearchValue2 <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_tgl_kirim->AdvancedSearch->SearchOperator2 = @$_GET["w_ob_tgl_kirim"];

		// ob_var
		$this->ob_var->AdvancedSearch->SearchValue = @$_GET["x_ob_var"];
		if ($this->ob_var->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_var->AdvancedSearch->SearchOperator = @$_GET["z_ob_var"];

		// ob_jumlah
		$this->ob_jumlah->AdvancedSearch->SearchValue = @$_GET["x_ob_jumlah"];
		if ($this->ob_jumlah->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_jumlah->AdvancedSearch->SearchOperator = @$_GET["z_ob_jumlah"];

		// status
		$this->status->AdvancedSearch->SearchValue = @$_GET["x_status"];
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->status->AdvancedSearch->SearchOperator = @$_GET["z_status"];

		// ob_tgl_real_kirim
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchValue = @$_GET["x_ob_tgl_real_kirim"];
		if ($this->ob_tgl_real_kirim->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchOperator = @$_GET["z_ob_tgl_real_kirim"];
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchCondition = @$_GET["v_ob_tgl_real_kirim"];
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchValue2 = @$_GET["y_ob_tgl_real_kirim"];
		if ($this->ob_tgl_real_kirim->AdvancedSearch->SearchValue2 <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_tgl_real_kirim->AdvancedSearch->SearchOperator2 = @$_GET["w_ob_tgl_real_kirim"];

		// ob_jumlah_real_kirim
		$this->ob_jumlah_real_kirim->AdvancedSearch->SearchValue = @$_GET["x_ob_jumlah_real_kirim"];
		if ($this->ob_jumlah_real_kirim->AdvancedSearch->SearchValue <> "" && $this->Command == "") $this->Command = "search";
		$this->ob_jumlah_real_kirim->AdvancedSearch->SearchOperator = @$_GET["z_ob_jumlah_real_kirim"];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->ListSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->ob_id->setDbValue($row['ob_id']);
		$this->ob_co->setDbValue($row['ob_co']);
		$this->ob_k_tanam->setDbValue($row['ob_k_tanam']);
		$this->ob_pembeli->setDbValue($row['ob_pembeli']);
		$this->ob_tgl_kirim->setDbValue($row['ob_tgl_kirim']);
		$this->ob_var->setDbValue($row['ob_var']);
		$this->ob_jumlah->setDbValue($row['ob_jumlah']);
		$this->status->setDbValue($row['status']);
		$this->ob_tgl_real_kirim->setDbValue($row['ob_tgl_real_kirim']);
		$this->ob_jumlah_real_kirim->setDbValue($row['ob_jumlah_real_kirim']);
	}

	// Return a row with default values
	function NewRow() {
		$row = array();
		$row['ob_id'] = NULL;
		$row['ob_co'] = NULL;
		$row['ob_k_tanam'] = NULL;
		$row['ob_pembeli'] = NULL;
		$row['ob_tgl_kirim'] = NULL;
		$row['ob_var'] = NULL;
		$row['ob_jumlah'] = NULL;
		$row['status'] = NULL;
		$row['ob_tgl_real_kirim'] = NULL;
		$row['ob_jumlah_real_kirim'] = NULL;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->ob_id->DbValue = $row['ob_id'];
		$this->ob_co->DbValue = $row['ob_co'];
		$this->ob_k_tanam->DbValue = $row['ob_k_tanam'];
		$this->ob_pembeli->DbValue = $row['ob_pembeli'];
		$this->ob_tgl_kirim->DbValue = $row['ob_tgl_kirim'];
		$this->ob_var->DbValue = $row['ob_var'];
		$this->ob_jumlah->DbValue = $row['ob_jumlah'];
		$this->status->DbValue = $row['status'];
		$this->ob_tgl_real_kirim->DbValue = $row['ob_tgl_real_kirim'];
		$this->ob_jumlah_real_kirim->DbValue = $row['ob_jumlah_real_kirim'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("ob_id")) <> "")
			$this->ob_id->CurrentValue = $this->getKey("ob_id"); // ob_id
		else
			$bValidKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
		}
		$this->LoadRowValues($this->OldRecordset); // Load row values
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// ob_id
		// ob_co
		// ob_k_tanam
		// ob_pembeli
		// ob_tgl_kirim
		// ob_var
		// ob_jumlah
		// status
		// ob_tgl_real_kirim
		// ob_jumlah_real_kirim
		// Accumulate aggregate value

		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT && $this->RowType <> EW_ROWTYPE_AGGREGATE) {
			if (is_numeric($this->ob_jumlah->CurrentValue))
				$this->ob_jumlah->Total += $this->ob_jumlah->CurrentValue; // Accumulate total
			if (is_numeric($this->ob_jumlah_real_kirim->CurrentValue))
				$this->ob_jumlah_real_kirim->Total += $this->ob_jumlah_real_kirim->CurrentValue; // Accumulate total
		}
		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// ob_id
		$this->ob_id->ViewValue = $this->ob_id->CurrentValue;
		$this->ob_id->ViewCustomAttributes = "";

		// ob_co
		if (strval($this->ob_co->CurrentValue) <> "") {
			$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->ob_co->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
		$sWhereWrk = "";
		$this->ob_co->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ob_co, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->ob_co->ViewValue = $this->ob_co->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ob_co->ViewValue = $this->ob_co->CurrentValue;
			}
		} else {
			$this->ob_co->ViewValue = NULL;
		}
		$this->ob_co->ViewCustomAttributes = "";

		// ob_k_tanam
		if (strval($this->ob_k_tanam->CurrentValue) <> "") {
			$sFilterWrk = "`k_id`" . ew_SearchString("=", $this->ob_k_tanam->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `k_id`, `k_id_kontrak` AS `DispFld`, `k_luas_lahan` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
		$sWhereWrk = "";
		$this->ob_k_tanam->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ob_k_tanam, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$arwrk[2] = $rswrk->fields('Disp2Fld');
				$this->ob_k_tanam->ViewValue = $this->ob_k_tanam->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ob_k_tanam->ViewValue = $this->ob_k_tanam->CurrentValue;
			}
		} else {
			$this->ob_k_tanam->ViewValue = NULL;
		}
		$this->ob_k_tanam->ViewCustomAttributes = "";

		// ob_pembeli
		$this->ob_pembeli->ViewValue = $this->ob_pembeli->CurrentValue;
		$this->ob_pembeli->ViewCustomAttributes = "";

		// ob_tgl_kirim
		$this->ob_tgl_kirim->ViewValue = $this->ob_tgl_kirim->CurrentValue;
		$this->ob_tgl_kirim->ViewValue = ew_FormatDateTime($this->ob_tgl_kirim->ViewValue, 0);
		$this->ob_tgl_kirim->ViewCustomAttributes = "";

		// ob_var
		if (strval($this->ob_var->CurrentValue) <> "") {
			$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->ob_var->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
		$sWhereWrk = "";
		$this->ob_var->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->ob_var, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->ob_var->ViewValue = $this->ob_var->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->ob_var->ViewValue = $this->ob_var->CurrentValue;
			}
		} else {
			$this->ob_var->ViewValue = NULL;
		}
		$this->ob_var->ViewCustomAttributes = "";

		// ob_jumlah
		$this->ob_jumlah->ViewValue = $this->ob_jumlah->CurrentValue;
		$this->ob_jumlah->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$sFilterWrk = "`status_order_bibit`" . ew_SearchString("=", $this->status->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `status_order_bibit`, `status_order_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `status_order_bibit`";
		$sWhereWrk = "";
		$this->status->LookupFilters = array("dx1" => '`status_order_bibit`');
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->status, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->status->ViewValue = $this->status->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->status->ViewValue = $this->status->CurrentValue;
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// ob_tgl_real_kirim
		$this->ob_tgl_real_kirim->ViewValue = $this->ob_tgl_real_kirim->CurrentValue;
		$this->ob_tgl_real_kirim->ViewValue = ew_FormatDateTime($this->ob_tgl_real_kirim->ViewValue, 0);
		$this->ob_tgl_real_kirim->ViewCustomAttributes = "";

		// ob_jumlah_real_kirim
		$this->ob_jumlah_real_kirim->ViewValue = $this->ob_jumlah_real_kirim->CurrentValue;
		$this->ob_jumlah_real_kirim->ViewCustomAttributes = "";

			// ob_id
			$this->ob_id->LinkCustomAttributes = "";
			$this->ob_id->HrefValue = "";
			$this->ob_id->TooltipValue = "";

			// ob_co
			$this->ob_co->LinkCustomAttributes = "";
			$this->ob_co->HrefValue = "";
			$this->ob_co->TooltipValue = "";

			// ob_k_tanam
			$this->ob_k_tanam->LinkCustomAttributes = "";
			$this->ob_k_tanam->HrefValue = "";
			$this->ob_k_tanam->TooltipValue = "";

			// ob_pembeli
			$this->ob_pembeli->LinkCustomAttributes = "";
			$this->ob_pembeli->HrefValue = "";
			$this->ob_pembeli->TooltipValue = "";

			// ob_tgl_kirim
			$this->ob_tgl_kirim->LinkCustomAttributes = "";
			$this->ob_tgl_kirim->HrefValue = "";
			$this->ob_tgl_kirim->TooltipValue = "";

			// ob_var
			$this->ob_var->LinkCustomAttributes = "";
			$this->ob_var->HrefValue = "";
			$this->ob_var->TooltipValue = "";

			// ob_jumlah
			$this->ob_jumlah->LinkCustomAttributes = "";
			$this->ob_jumlah->HrefValue = "";
			$this->ob_jumlah->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// ob_tgl_real_kirim
			$this->ob_tgl_real_kirim->LinkCustomAttributes = "";
			$this->ob_tgl_real_kirim->HrefValue = "";
			$this->ob_tgl_real_kirim->TooltipValue = "";

			// ob_jumlah_real_kirim
			$this->ob_jumlah_real_kirim->LinkCustomAttributes = "";
			$this->ob_jumlah_real_kirim->HrefValue = "";
			$this->ob_jumlah_real_kirim->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_SEARCH) { // Search row

			// ob_id
			$this->ob_id->EditAttrs["class"] = "form-control";
			$this->ob_id->EditCustomAttributes = "";
			$this->ob_id->EditValue = ew_HtmlEncode($this->ob_id->AdvancedSearch->SearchValue);
			$this->ob_id->PlaceHolder = ew_RemoveHtml($this->ob_id->FldCaption());

			// ob_co
			$this->ob_co->EditAttrs["class"] = "form-control";
			$this->ob_co->EditCustomAttributes = "";
			if (trim(strval($this->ob_co->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`co_id`" . ew_SearchString("=", $this->ob_co->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `co_id`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `co`";
			$sWhereWrk = "";
			$this->ob_co->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ob_co, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ob_co->EditValue = $arwrk;

			// ob_k_tanam
			$this->ob_k_tanam->EditAttrs["class"] = "form-control";
			$this->ob_k_tanam->EditCustomAttributes = "";
			if (trim(strval($this->ob_k_tanam->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`k_id`" . ew_SearchString("=", $this->ob_k_tanam->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `k_id`, `k_id_kontrak` AS `DispFld`, `k_luas_lahan` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kontrak`";
			$sWhereWrk = "";
			$this->ob_k_tanam->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ob_k_tanam, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ob_k_tanam->EditValue = $arwrk;

			// ob_pembeli
			$this->ob_pembeli->EditAttrs["class"] = "form-control";
			$this->ob_pembeli->EditCustomAttributes = "";
			$this->ob_pembeli->EditValue = ew_HtmlEncode($this->ob_pembeli->AdvancedSearch->SearchValue);
			$this->ob_pembeli->PlaceHolder = ew_RemoveHtml($this->ob_pembeli->FldCaption());

			// ob_tgl_kirim
			$this->ob_tgl_kirim->EditAttrs["class"] = "form-control";
			$this->ob_tgl_kirim->EditCustomAttributes = "";
			$this->ob_tgl_kirim->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->ob_tgl_kirim->AdvancedSearch->SearchValue, 0), 8));
			$this->ob_tgl_kirim->PlaceHolder = ew_RemoveHtml($this->ob_tgl_kirim->FldCaption());
			$this->ob_tgl_kirim->EditAttrs["class"] = "form-control";
			$this->ob_tgl_kirim->EditCustomAttributes = "";
			$this->ob_tgl_kirim->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->ob_tgl_kirim->AdvancedSearch->SearchValue2, 0), 8));
			$this->ob_tgl_kirim->PlaceHolder = ew_RemoveHtml($this->ob_tgl_kirim->FldCaption());

			// ob_var
			$this->ob_var->EditAttrs["class"] = "form-control";
			$this->ob_var->EditCustomAttributes = "";
			if (trim(strval($this->ob_var->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`var_id`" . ew_SearchString("=", $this->ob_var->AdvancedSearch->SearchValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `var_id`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `varietas`";
			$sWhereWrk = "";
			$this->ob_var->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->ob_var, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->ob_var->EditValue = $arwrk;

			// ob_jumlah
			$this->ob_jumlah->EditAttrs["class"] = "form-control";
			$this->ob_jumlah->EditCustomAttributes = "";
			$this->ob_jumlah->EditValue = ew_HtmlEncode($this->ob_jumlah->AdvancedSearch->SearchValue);
			$this->ob_jumlah->PlaceHolder = ew_RemoveHtml($this->ob_jumlah->FldCaption());

			// status
			$this->status->EditCustomAttributes = "";
			if (trim(strval($this->status->AdvancedSearch->SearchValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`status_order_bibit`" . ew_SearchString("=", $this->status->AdvancedSearch->SearchValue, EW_DATATYPE_STRING, "");
			}
			$sSqlWrk = "SELECT `status_order_bibit`, `status_order_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `status_order_bibit`";
			$sWhereWrk = "";
			$this->status->LookupFilters = array("dx1" => '`status_order_bibit`');
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->status, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = ew_HtmlEncode($rswrk->fields('DispFld'));
				$this->status->AdvancedSearch->ViewValue = $this->status->DisplayValue($arwrk);
			} else {
				$this->status->AdvancedSearch->ViewValue = $Language->Phrase("PleaseSelect");
			}
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->status->EditValue = $arwrk;

			// ob_tgl_real_kirim
			$this->ob_tgl_real_kirim->EditAttrs["class"] = "form-control";
			$this->ob_tgl_real_kirim->EditCustomAttributes = "";
			$this->ob_tgl_real_kirim->EditValue = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->ob_tgl_real_kirim->AdvancedSearch->SearchValue, 0), 8));
			$this->ob_tgl_real_kirim->PlaceHolder = ew_RemoveHtml($this->ob_tgl_real_kirim->FldCaption());
			$this->ob_tgl_real_kirim->EditAttrs["class"] = "form-control";
			$this->ob_tgl_real_kirim->EditCustomAttributes = "";
			$this->ob_tgl_real_kirim->EditValue2 = ew_HtmlEncode(ew_FormatDateTime(ew_UnFormatDateTime($this->ob_tgl_real_kirim->AdvancedSearch->SearchValue2, 0), 8));
			$this->ob_tgl_real_kirim->PlaceHolder = ew_RemoveHtml($this->ob_tgl_real_kirim->FldCaption());

			// ob_jumlah_real_kirim
			$this->ob_jumlah_real_kirim->EditAttrs["class"] = "form-control";
			$this->ob_jumlah_real_kirim->EditCustomAttributes = "";
			$this->ob_jumlah_real_kirim->EditValue = ew_HtmlEncode($this->ob_jumlah_real_kirim->AdvancedSearch->SearchValue);
			$this->ob_jumlah_real_kirim->PlaceHolder = ew_RemoveHtml($this->ob_jumlah_real_kirim->FldCaption());
		} elseif ($this->RowType == EW_ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->ob_jumlah->Total = 0; // Initialize total
			$this->ob_jumlah_real_kirim->Total = 0; // Initialize total
		} elseif ($this->RowType == EW_ROWTYPE_AGGREGATE) { // Aggregate row
			$this->ob_jumlah->CurrentValue = $this->ob_jumlah->Total;
			$this->ob_jumlah->ViewValue = $this->ob_jumlah->CurrentValue;
			$this->ob_jumlah->ViewCustomAttributes = "";
			$this->ob_jumlah->HrefValue = ""; // Clear href value
			$this->ob_jumlah_real_kirim->CurrentValue = $this->ob_jumlah_real_kirim->Total;
			$this->ob_jumlah_real_kirim->ViewValue = $this->ob_jumlah_real_kirim->CurrentValue;
			$this->ob_jumlah_real_kirim->ViewCustomAttributes = "";
			$this->ob_jumlah_real_kirim->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	function ValidateSearch() {
		global $gsSearchError;

		// Initialize
		$gsSearchError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return TRUE;
		if (!ew_CheckDateDef($this->ob_tgl_kirim->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->ob_tgl_kirim->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->ob_tgl_kirim->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->ob_tgl_kirim->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->ob_tgl_real_kirim->AdvancedSearch->SearchValue)) {
			ew_AddMessage($gsSearchError, $this->ob_tgl_real_kirim->FldErrMsg());
		}
		if (!ew_CheckDateDef($this->ob_tgl_real_kirim->AdvancedSearch->SearchValue2)) {
			ew_AddMessage($gsSearchError, $this->ob_tgl_real_kirim->FldErrMsg());
		}

		// Return validate result
		$ValidateSearch = ($gsSearchError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateSearch = $ValidateSearch && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsSearchError, $sFormCustomError);
		}
		return $ValidateSearch;
	}

	// Load advanced search
	function LoadAdvancedSearch() {
		$this->ob_id->AdvancedSearch->Load();
		$this->ob_co->AdvancedSearch->Load();
		$this->ob_k_tanam->AdvancedSearch->Load();
		$this->ob_pembeli->AdvancedSearch->Load();
		$this->ob_tgl_kirim->AdvancedSearch->Load();
		$this->ob_var->AdvancedSearch->Load();
		$this->ob_jumlah->AdvancedSearch->Load();
		$this->status->AdvancedSearch->Load();
		$this->ob_tgl_real_kirim->AdvancedSearch->Load();
		$this->ob_jumlah_real_kirim->AdvancedSearch->Load();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = "";
		$item->Body = "<button id=\"emf_order_bibit\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_order_bibit',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.forder_bibitlist,sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->ListRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EW_EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->SetupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($bSelectLimit)
			$rs = $this->LoadRecordset($this->StartRec-1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "h");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
		case "x_ob_co":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `co_id` AS `LinkFld`, `co_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `co`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`co_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->ob_co, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_ob_k_tanam":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `k_id` AS `LinkFld`, `k_id_kontrak` AS `DispFld`, `k_luas_lahan` AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kontrak`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`k_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->ob_k_tanam, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_ob_var":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `var_id` AS `LinkFld`, `var_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `varietas`";
				$sWhereWrk = "";
				$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`var_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->ob_var, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_status":
			$sSqlWrk = "";
				$sSqlWrk = "SELECT `status_order_bibit` AS `LinkFld`, `status_order_bibit` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `status_order_bibit`";
				$sWhereWrk = "{filter}";
				$fld->LookupFilters = array("dx1" => '`status_order_bibit`');
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`status_order_bibit` IN ({filter_value})', "t0" => "200", "fn0" => "");
			$sSqlWrk = "";
				$this->Lookup_Selecting($this->status, $sWhereWrk); // Call Lookup Selecting
				if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
			}
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		if ($pageId == "list") {
			switch ($fld->FldVar) {
			}
		} elseif ($pageId == "extbs") {
			switch ($fld->FldVar) {
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($order_bibit_list)) $order_bibit_list = new corder_bibit_list();

// Page init
$order_bibit_list->Page_Init();

// Page main
$order_bibit_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$order_bibit_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($order_bibit->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = forder_bibitlist = new ew_Form("forder_bibitlist", "list");
forder_bibitlist.FormKeyCountName = '<?php echo $order_bibit_list->FormKeyCountName ?>';

// Form_CustomValidate event
forder_bibitlist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
forder_bibitlist.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
forder_bibitlist.Lists["x_ob_co"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
forder_bibitlist.Lists["x_ob_co"].Data = "<?php echo $order_bibit_list->ob_co->LookupFilterQuery(FALSE, "list") ?>";
forder_bibitlist.Lists["x_ob_k_tanam"] = {"LinkField":"x_k_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","x_k_luas_lahan","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
forder_bibitlist.Lists["x_ob_k_tanam"].Data = "<?php echo $order_bibit_list->ob_k_tanam->LookupFilterQuery(FALSE, "list") ?>";
forder_bibitlist.Lists["x_ob_var"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
forder_bibitlist.Lists["x_ob_var"].Data = "<?php echo $order_bibit_list->ob_var->LookupFilterQuery(FALSE, "list") ?>";
forder_bibitlist.Lists["x_status"] = {"LinkField":"x_status_order_bibit","Ajax":true,"AutoFill":false,"DisplayFields":["x_status_order_bibit","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"status_order_bibit"};
forder_bibitlist.Lists["x_status"].Data = "<?php echo $order_bibit_list->status->LookupFilterQuery(FALSE, "list") ?>";

// Form object for search
var CurrentSearchForm = forder_bibitlistsrch = new ew_Form("forder_bibitlistsrch");

// Validate function for search
forder_bibitlistsrch.Validate = function(fobj) {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	fobj = fobj || this.Form;
	var infix = "";
	elm = this.GetElements("x" + infix + "_ob_tgl_kirim");
	if (elm && !ew_CheckDateDef(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($order_bibit->ob_tgl_kirim->FldErrMsg()) ?>");
	elm = this.GetElements("x" + infix + "_ob_tgl_real_kirim");
	if (elm && !ew_CheckDateDef(elm.value))
		return this.OnError(elm, "<?php echo ew_JsEncode2($order_bibit->ob_tgl_real_kirim->FldErrMsg()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
forder_bibitlistsrch.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
forder_bibitlistsrch.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
forder_bibitlistsrch.Lists["x_ob_co"] = {"LinkField":"x_co_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_co_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"co"};
forder_bibitlistsrch.Lists["x_ob_co"].Data = "<?php echo $order_bibit_list->ob_co->LookupFilterQuery(FALSE, "extbs") ?>";
forder_bibitlistsrch.Lists["x_ob_k_tanam"] = {"LinkField":"x_k_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_k_id_kontrak","x_k_luas_lahan","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kontrak"};
forder_bibitlistsrch.Lists["x_ob_k_tanam"].Data = "<?php echo $order_bibit_list->ob_k_tanam->LookupFilterQuery(FALSE, "extbs") ?>";
forder_bibitlistsrch.Lists["x_ob_var"] = {"LinkField":"x_var_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_var_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"varietas"};
forder_bibitlistsrch.Lists["x_ob_var"].Data = "<?php echo $order_bibit_list->ob_var->LookupFilterQuery(FALSE, "extbs") ?>";
forder_bibitlistsrch.Lists["x_status"] = {"LinkField":"x_status_order_bibit","Ajax":true,"AutoFill":false,"DisplayFields":["x_status_order_bibit","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"status_order_bibit"};
forder_bibitlistsrch.Lists["x_status"].Data = "<?php echo $order_bibit_list->status->LookupFilterQuery(FALSE, "extbs") ?>";

// Init search panel as collapsed
if (forder_bibitlistsrch) forder_bibitlistsrch.InitSearchPanel = true;
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($order_bibit->Export == "") { ?>
<div class="ewToolbar">
<?php if ($order_bibit_list->TotalRecs > 0 && $order_bibit_list->ExportOptions->Visible()) { ?>
<?php $order_bibit_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($order_bibit_list->SearchOptions->Visible()) { ?>
<?php $order_bibit_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($order_bibit_list->FilterOptions->Visible()) { ?>
<?php $order_bibit_list->FilterOptions->Render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
	$bSelectLimit = $order_bibit_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($order_bibit_list->TotalRecs <= 0)
			$order_bibit_list->TotalRecs = $order_bibit->ListRecordCount();
	} else {
		if (!$order_bibit_list->Recordset && ($order_bibit_list->Recordset = $order_bibit_list->LoadRecordset()))
			$order_bibit_list->TotalRecs = $order_bibit_list->Recordset->RecordCount();
	}
	$order_bibit_list->StartRec = 1;
	if ($order_bibit_list->DisplayRecs <= 0 || ($order_bibit->Export <> "" && $order_bibit->ExportAll)) // Display all records
		$order_bibit_list->DisplayRecs = $order_bibit_list->TotalRecs;
	if (!($order_bibit->Export <> "" && $order_bibit->ExportAll))
		$order_bibit_list->SetupStartRec(); // Set up start record position
	if ($bSelectLimit)
		$order_bibit_list->Recordset = $order_bibit_list->LoadRecordset($order_bibit_list->StartRec-1, $order_bibit_list->DisplayRecs);

	// Set no record found message
	if ($order_bibit->CurrentAction == "" && $order_bibit_list->TotalRecs == 0) {
		if (!$Security->CanList())
			$order_bibit_list->setWarningMessage(ew_DeniedMsg());
		if ($order_bibit_list->SearchWhere == "0=101")
			$order_bibit_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$order_bibit_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$order_bibit_list->RenderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if ($order_bibit->Export == "" && $order_bibit->CurrentAction == "") { ?>
<form name="forder_bibitlistsrch" id="forder_bibitlistsrch" class="form-inline ewForm ewExtSearchForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($order_bibit_list->SearchWhere <> "") ? " in" : ""; ?>
<div id="forder_bibitlistsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="order_bibit">
	<div class="ewBasicSearch">
<?php
if ($gsSearchError == "")
	$order_bibit_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$order_bibit->RowType = EW_ROWTYPE_SEARCH;

// Render row
$order_bibit->ResetAttrs();
$order_bibit_list->RenderRow();
?>
<div id="xsr_1" class="ewRow">
<?php if ($order_bibit->ob_co->Visible) { // ob_co ?>
	<div id="xsc_ob_co" class="ewCell form-group">
		<label for="x_ob_co" class="ewSearchCaption ewLabel"><?php echo $order_bibit->ob_co->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_ob_co" id="z_ob_co" value="="></span>
		<span class="ewSearchField">
<select data-table="order_bibit" data-field="x_ob_co" data-value-separator="<?php echo $order_bibit->ob_co->DisplayValueSeparatorAttribute() ?>" id="x_ob_co" name="x_ob_co"<?php echo $order_bibit->ob_co->EditAttributes() ?>>
<?php echo $order_bibit->ob_co->SelectOptionListHtml("x_ob_co") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ewRow">
<?php if ($order_bibit->ob_k_tanam->Visible) { // ob_k_tanam ?>
	<div id="xsc_ob_k_tanam" class="ewCell form-group">
		<label for="x_ob_k_tanam" class="ewSearchCaption ewLabel"><?php echo $order_bibit->ob_k_tanam->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_ob_k_tanam" id="z_ob_k_tanam" value="="></span>
		<span class="ewSearchField">
<select data-table="order_bibit" data-field="x_ob_k_tanam" data-value-separator="<?php echo $order_bibit->ob_k_tanam->DisplayValueSeparatorAttribute() ?>" id="x_ob_k_tanam" name="x_ob_k_tanam"<?php echo $order_bibit->ob_k_tanam->EditAttributes() ?>>
<?php echo $order_bibit->ob_k_tanam->SelectOptionListHtml("x_ob_k_tanam") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ewRow">
<?php if ($order_bibit->ob_pembeli->Visible) { // ob_pembeli ?>
	<div id="xsc_ob_pembeli" class="ewCell form-group">
		<label for="x_ob_pembeli" class="ewSearchCaption ewLabel"><?php echo $order_bibit->ob_pembeli->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("LIKE") ?><input type="hidden" name="z_ob_pembeli" id="z_ob_pembeli" value="LIKE"></span>
		<span class="ewSearchField">
<input type="text" data-table="order_bibit" data-field="x_ob_pembeli" name="x_ob_pembeli" id="x_ob_pembeli" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_pembeli->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_pembeli->EditValue ?>"<?php echo $order_bibit->ob_pembeli->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ewRow">
<?php if ($order_bibit->ob_tgl_kirim->Visible) { // ob_tgl_kirim ?>
	<div id="xsc_ob_tgl_kirim" class="ewCell form-group">
		<label for="x_ob_tgl_kirim" class="ewSearchCaption ewLabel"><?php echo $order_bibit->ob_tgl_kirim->FldCaption() ?></label>
		<span class="ewSearchOperator"><select name="z_ob_tgl_kirim" id="z_ob_tgl_kirim" class="form-control" onchange="ewForms(this).SrchOprChanged(this);"><option value="="<?php echo ($order_bibit->ob_tgl_kirim->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->Phrase("EQUAL") ?></option><option value="<>"<?php echo ($order_bibit->ob_tgl_kirim->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->Phrase("<>") ?></option><option value="<"<?php echo ($order_bibit->ob_tgl_kirim->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->Phrase("<") ?></option><option value="<="<?php echo ($order_bibit->ob_tgl_kirim->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->Phrase("<=") ?></option><option value=">"<?php echo ($order_bibit->ob_tgl_kirim->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->Phrase(">") ?></option><option value=">="<?php echo ($order_bibit->ob_tgl_kirim->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->Phrase(">=") ?></option><option value="IS NULL"<?php echo ($order_bibit->ob_tgl_kirim->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($order_bibit->ob_tgl_kirim->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($order_bibit->ob_tgl_kirim->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->Phrase("BETWEEN") ?></option></select></span>
		<span class="ewSearchField">
<input type="text" data-table="order_bibit" data-field="x_ob_tgl_kirim" name="x_ob_tgl_kirim" id="x_ob_tgl_kirim" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_tgl_kirim->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_tgl_kirim->EditValue ?>"<?php echo $order_bibit->ob_tgl_kirim->EditAttributes() ?>>
<?php if (!$order_bibit->ob_tgl_kirim->ReadOnly && !$order_bibit->ob_tgl_kirim->Disabled && !isset($order_bibit->ob_tgl_kirim->EditAttrs["readonly"]) && !isset($order_bibit->ob_tgl_kirim->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("forder_bibitlistsrch", "x_ob_tgl_kirim", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_ob_tgl_kirim" style="display: none">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_ob_tgl_kirim" style="display: none">
<input type="text" data-table="order_bibit" data-field="x_ob_tgl_kirim" name="y_ob_tgl_kirim" id="y_ob_tgl_kirim" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_tgl_kirim->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_tgl_kirim->EditValue2 ?>"<?php echo $order_bibit->ob_tgl_kirim->EditAttributes() ?>>
<?php if (!$order_bibit->ob_tgl_kirim->ReadOnly && !$order_bibit->ob_tgl_kirim->Disabled && !isset($order_bibit->ob_tgl_kirim->EditAttrs["readonly"]) && !isset($order_bibit->ob_tgl_kirim->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("forder_bibitlistsrch", "y_ob_tgl_kirim", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ewRow">
<?php if ($order_bibit->ob_var->Visible) { // ob_var ?>
	<div id="xsc_ob_var" class="ewCell form-group">
		<label for="x_ob_var" class="ewSearchCaption ewLabel"><?php echo $order_bibit->ob_var->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_ob_var" id="z_ob_var" value="="></span>
		<span class="ewSearchField">
<select data-table="order_bibit" data-field="x_ob_var" data-value-separator="<?php echo $order_bibit->ob_var->DisplayValueSeparatorAttribute() ?>" id="x_ob_var" name="x_ob_var"<?php echo $order_bibit->ob_var->EditAttributes() ?>>
<?php echo $order_bibit->ob_var->SelectOptionListHtml("x_ob_var") ?>
</select>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ewRow">
<?php if ($order_bibit->status->Visible) { // status ?>
	<div id="xsc_status" class="ewCell form-group">
		<label class="ewSearchCaption ewLabel"><?php echo $order_bibit->status->FldCaption() ?></label>
		<span class="ewSearchOperator"><?php echo $Language->Phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ewSearchField">
<span class="ewLookupList">
	<span onclick="jQuery(this).parent().next(":not([disabled])").click();" tabindex="-1" class="form-control ewLookupText" id="lu_x_status"><?php echo (strval($order_bibit->status->AdvancedSearch->ViewValue) == "" ? $Language->Phrase("PleaseSelect") : $order_bibit->status->AdvancedSearch->ViewValue); ?></span>
</span>
<button type="button" title="<?php echo ew_HtmlEncode(str_replace("%s", ew_RemoveHtml($order_bibit->status->FldCaption()), $Language->Phrase("LookupLink", TRUE))) ?>" onclick="ew_ModalLookupShow({lnk:this,el:'x_status',m:0,n:10});" class="ewLookupBtn btn btn-default btn-sm"<?php echo (($order_bibit->status->ReadOnly || $order_bibit->status->Disabled) ? " disabled" : "")?>><span class="glyphicon glyphicon-search ewIcon"></span></button>
<input type="hidden" data-table="order_bibit" data-field="x_status" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $order_bibit->status->DisplayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?php echo $order_bibit->status->AdvancedSearch->SearchValue ?>"<?php echo $order_bibit->status->EditAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_7" class="ewRow">
<?php if ($order_bibit->ob_tgl_real_kirim->Visible) { // ob_tgl_real_kirim ?>
	<div id="xsc_ob_tgl_real_kirim" class="ewCell form-group">
		<label for="x_ob_tgl_real_kirim" class="ewSearchCaption ewLabel"><?php echo $order_bibit->ob_tgl_real_kirim->FldCaption() ?></label>
		<span class="ewSearchOperator"><select name="z_ob_tgl_real_kirim" id="z_ob_tgl_real_kirim" class="form-control" onchange="ewForms(this).SrchOprChanged(this);"><option value="="<?php echo ($order_bibit->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->Phrase("EQUAL") ?></option><option value="<>"<?php echo ($order_bibit->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->Phrase("<>") ?></option><option value="<"<?php echo ($order_bibit->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->Phrase("<") ?></option><option value="<="<?php echo ($order_bibit->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->Phrase("<=") ?></option><option value=">"<?php echo ($order_bibit->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->Phrase(">") ?></option><option value=">="<?php echo ($order_bibit->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->Phrase(">=") ?></option><option value="IS NULL"<?php echo ($order_bibit->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($order_bibit->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->Phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($order_bibit->ob_tgl_real_kirim->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->Phrase("BETWEEN") ?></option></select></span>
		<span class="ewSearchField">
<input type="text" data-table="order_bibit" data-field="x_ob_tgl_real_kirim" name="x_ob_tgl_real_kirim" id="x_ob_tgl_real_kirim" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_tgl_real_kirim->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_tgl_real_kirim->EditValue ?>"<?php echo $order_bibit->ob_tgl_real_kirim->EditAttributes() ?>>
<?php if (!$order_bibit->ob_tgl_real_kirim->ReadOnly && !$order_bibit->ob_tgl_real_kirim->Disabled && !isset($order_bibit->ob_tgl_real_kirim->EditAttrs["readonly"]) && !isset($order_bibit->ob_tgl_real_kirim->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("forder_bibitlistsrch", "x_ob_tgl_real_kirim", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ewSearchCond btw1_ob_tgl_real_kirim" style="display: none">&nbsp;<?php echo $Language->Phrase("AND") ?>&nbsp;</span>
		<span class="ewSearchField btw1_ob_tgl_real_kirim" style="display: none">
<input type="text" data-table="order_bibit" data-field="x_ob_tgl_real_kirim" name="y_ob_tgl_real_kirim" id="y_ob_tgl_real_kirim" placeholder="<?php echo ew_HtmlEncode($order_bibit->ob_tgl_real_kirim->getPlaceHolder()) ?>" value="<?php echo $order_bibit->ob_tgl_real_kirim->EditValue2 ?>"<?php echo $order_bibit->ob_tgl_real_kirim->EditAttributes() ?>>
<?php if (!$order_bibit->ob_tgl_real_kirim->ReadOnly && !$order_bibit->ob_tgl_real_kirim->Disabled && !isset($order_bibit->ob_tgl_real_kirim->EditAttrs["readonly"]) && !isset($order_bibit->ob_tgl_real_kirim->EditAttrs["disabled"])) { ?>
<script type="text/javascript">
ew_CreateDateTimePicker("forder_bibitlistsrch", "y_ob_tgl_real_kirim", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_8" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($order_bibit_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($order_bibit_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $order_bibit_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($order_bibit_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($order_bibit_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($order_bibit_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($order_bibit_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("SearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $order_bibit_list->ShowPageHeader(); ?>
<?php
$order_bibit_list->ShowMessage();
?>
<?php if ($order_bibit_list->TotalRecs > 0 || $order_bibit->CurrentAction <> "") { ?>
<div class="box ewBox ewGrid<?php if ($order_bibit_list->IsAddOrEdit()) { ?> ewGridAddEdit<?php } ?> order_bibit">
<?php if ($order_bibit->Export == "") { ?>
<div class="box-header ewGridUpperPanel">
<?php if ($order_bibit->CurrentAction <> "gridadd" && $order_bibit->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="form-inline ewForm ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($order_bibit_list->Pager)) $order_bibit_list->Pager = new cNumericPager($order_bibit_list->StartRec, $order_bibit_list->DisplayRecs, $order_bibit_list->TotalRecs, $order_bibit_list->RecRange, $order_bibit_list->AutoHidePager) ?>
<?php if ($order_bibit_list->Pager->RecordCount > 0 && $order_bibit_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($order_bibit_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $order_bibit_list->PageUrl() ?>start=<?php echo $order_bibit_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($order_bibit_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $order_bibit_list->PageUrl() ?>start=<?php echo $order_bibit_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($order_bibit_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $order_bibit_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($order_bibit_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $order_bibit_list->PageUrl() ?>start=<?php echo $order_bibit_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($order_bibit_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $order_bibit_list->PageUrl() ?>start=<?php echo $order_bibit_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($order_bibit_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $order_bibit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $order_bibit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $order_bibit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($order_bibit_list->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="forder_bibitlist" id="forder_bibitlist" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($order_bibit_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $order_bibit_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="order_bibit">
<div id="gmp_order_bibit" class="<?php if (ew_IsResponsiveLayout()) { ?>table-responsive <?php } ?>ewGridMiddlePanel">
<?php if ($order_bibit_list->TotalRecs > 0 || $order_bibit->CurrentAction == "gridedit") { ?>
<table id="tbl_order_bibitlist" class="table ewTable">
<thead>
	<tr class="ewTableHeader">
<?php

// Header row
$order_bibit_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$order_bibit_list->RenderListOptions();

// Render list options (header, left)
$order_bibit_list->ListOptions->Render("header", "left");
?>
<?php if ($order_bibit->ob_id->Visible) { // ob_id ?>
	<?php if ($order_bibit->SortUrl($order_bibit->ob_id) == "") { ?>
		<th data-name="ob_id" class="<?php echo $order_bibit->ob_id->HeaderCellClass() ?>"><div id="elh_order_bibit_ob_id" class="order_bibit_ob_id"><div class="ewTableHeaderCaption"><?php echo $order_bibit->ob_id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ob_id" class="<?php echo $order_bibit->ob_id->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->ob_id) ?>',1);"><div id="elh_order_bibit_ob_id" class="order_bibit_ob_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->ob_id->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->ob_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->ob_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($order_bibit->ob_co->Visible) { // ob_co ?>
	<?php if ($order_bibit->SortUrl($order_bibit->ob_co) == "") { ?>
		<th data-name="ob_co" class="<?php echo $order_bibit->ob_co->HeaderCellClass() ?>"><div id="elh_order_bibit_ob_co" class="order_bibit_ob_co"><div class="ewTableHeaderCaption"><?php echo $order_bibit->ob_co->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ob_co" class="<?php echo $order_bibit->ob_co->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->ob_co) ?>',1);"><div id="elh_order_bibit_ob_co" class="order_bibit_ob_co">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->ob_co->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->ob_co->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->ob_co->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($order_bibit->ob_k_tanam->Visible) { // ob_k_tanam ?>
	<?php if ($order_bibit->SortUrl($order_bibit->ob_k_tanam) == "") { ?>
		<th data-name="ob_k_tanam" class="<?php echo $order_bibit->ob_k_tanam->HeaderCellClass() ?>"><div id="elh_order_bibit_ob_k_tanam" class="order_bibit_ob_k_tanam"><div class="ewTableHeaderCaption"><?php echo $order_bibit->ob_k_tanam->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ob_k_tanam" class="<?php echo $order_bibit->ob_k_tanam->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->ob_k_tanam) ?>',1);"><div id="elh_order_bibit_ob_k_tanam" class="order_bibit_ob_k_tanam">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->ob_k_tanam->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->ob_k_tanam->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->ob_k_tanam->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($order_bibit->ob_pembeli->Visible) { // ob_pembeli ?>
	<?php if ($order_bibit->SortUrl($order_bibit->ob_pembeli) == "") { ?>
		<th data-name="ob_pembeli" class="<?php echo $order_bibit->ob_pembeli->HeaderCellClass() ?>"><div id="elh_order_bibit_ob_pembeli" class="order_bibit_ob_pembeli"><div class="ewTableHeaderCaption"><?php echo $order_bibit->ob_pembeli->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ob_pembeli" class="<?php echo $order_bibit->ob_pembeli->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->ob_pembeli) ?>',1);"><div id="elh_order_bibit_ob_pembeli" class="order_bibit_ob_pembeli">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->ob_pembeli->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->ob_pembeli->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->ob_pembeli->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($order_bibit->ob_tgl_kirim->Visible) { // ob_tgl_kirim ?>
	<?php if ($order_bibit->SortUrl($order_bibit->ob_tgl_kirim) == "") { ?>
		<th data-name="ob_tgl_kirim" class="<?php echo $order_bibit->ob_tgl_kirim->HeaderCellClass() ?>"><div id="elh_order_bibit_ob_tgl_kirim" class="order_bibit_ob_tgl_kirim"><div class="ewTableHeaderCaption"><?php echo $order_bibit->ob_tgl_kirim->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ob_tgl_kirim" class="<?php echo $order_bibit->ob_tgl_kirim->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->ob_tgl_kirim) ?>',1);"><div id="elh_order_bibit_ob_tgl_kirim" class="order_bibit_ob_tgl_kirim">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->ob_tgl_kirim->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->ob_tgl_kirim->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->ob_tgl_kirim->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($order_bibit->ob_var->Visible) { // ob_var ?>
	<?php if ($order_bibit->SortUrl($order_bibit->ob_var) == "") { ?>
		<th data-name="ob_var" class="<?php echo $order_bibit->ob_var->HeaderCellClass() ?>"><div id="elh_order_bibit_ob_var" class="order_bibit_ob_var"><div class="ewTableHeaderCaption"><?php echo $order_bibit->ob_var->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ob_var" class="<?php echo $order_bibit->ob_var->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->ob_var) ?>',1);"><div id="elh_order_bibit_ob_var" class="order_bibit_ob_var">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->ob_var->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->ob_var->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->ob_var->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($order_bibit->ob_jumlah->Visible) { // ob_jumlah ?>
	<?php if ($order_bibit->SortUrl($order_bibit->ob_jumlah) == "") { ?>
		<th data-name="ob_jumlah" class="<?php echo $order_bibit->ob_jumlah->HeaderCellClass() ?>"><div id="elh_order_bibit_ob_jumlah" class="order_bibit_ob_jumlah"><div class="ewTableHeaderCaption"><?php echo $order_bibit->ob_jumlah->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ob_jumlah" class="<?php echo $order_bibit->ob_jumlah->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->ob_jumlah) ?>',1);"><div id="elh_order_bibit_ob_jumlah" class="order_bibit_ob_jumlah">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->ob_jumlah->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->ob_jumlah->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->ob_jumlah->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($order_bibit->status->Visible) { // status ?>
	<?php if ($order_bibit->SortUrl($order_bibit->status) == "") { ?>
		<th data-name="status" class="<?php echo $order_bibit->status->HeaderCellClass() ?>"><div id="elh_order_bibit_status" class="order_bibit_status"><div class="ewTableHeaderCaption"><?php echo $order_bibit->status->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $order_bibit->status->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->status) ?>',1);"><div id="elh_order_bibit_status" class="order_bibit_status">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->status->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->status->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->status->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($order_bibit->ob_tgl_real_kirim->Visible) { // ob_tgl_real_kirim ?>
	<?php if ($order_bibit->SortUrl($order_bibit->ob_tgl_real_kirim) == "") { ?>
		<th data-name="ob_tgl_real_kirim" class="<?php echo $order_bibit->ob_tgl_real_kirim->HeaderCellClass() ?>"><div id="elh_order_bibit_ob_tgl_real_kirim" class="order_bibit_ob_tgl_real_kirim"><div class="ewTableHeaderCaption"><?php echo $order_bibit->ob_tgl_real_kirim->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ob_tgl_real_kirim" class="<?php echo $order_bibit->ob_tgl_real_kirim->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->ob_tgl_real_kirim) ?>',1);"><div id="elh_order_bibit_ob_tgl_real_kirim" class="order_bibit_ob_tgl_real_kirim">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->ob_tgl_real_kirim->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->ob_tgl_real_kirim->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->ob_tgl_real_kirim->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($order_bibit->ob_jumlah_real_kirim->Visible) { // ob_jumlah_real_kirim ?>
	<?php if ($order_bibit->SortUrl($order_bibit->ob_jumlah_real_kirim) == "") { ?>
		<th data-name="ob_jumlah_real_kirim" class="<?php echo $order_bibit->ob_jumlah_real_kirim->HeaderCellClass() ?>"><div id="elh_order_bibit_ob_jumlah_real_kirim" class="order_bibit_ob_jumlah_real_kirim"><div class="ewTableHeaderCaption"><?php echo $order_bibit->ob_jumlah_real_kirim->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ob_jumlah_real_kirim" class="<?php echo $order_bibit->ob_jumlah_real_kirim->HeaderCellClass() ?>"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $order_bibit->SortUrl($order_bibit->ob_jumlah_real_kirim) ?>',1);"><div id="elh_order_bibit_ob_jumlah_real_kirim" class="order_bibit_ob_jumlah_real_kirim">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $order_bibit->ob_jumlah_real_kirim->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($order_bibit->ob_jumlah_real_kirim->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($order_bibit->ob_jumlah_real_kirim->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$order_bibit_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($order_bibit->ExportAll && $order_bibit->Export <> "") {
	$order_bibit_list->StopRec = $order_bibit_list->TotalRecs;
} else {

	// Set the last record to display
	if ($order_bibit_list->TotalRecs > $order_bibit_list->StartRec + $order_bibit_list->DisplayRecs - 1)
		$order_bibit_list->StopRec = $order_bibit_list->StartRec + $order_bibit_list->DisplayRecs - 1;
	else
		$order_bibit_list->StopRec = $order_bibit_list->TotalRecs;
}
$order_bibit_list->RecCnt = $order_bibit_list->StartRec - 1;
if ($order_bibit_list->Recordset && !$order_bibit_list->Recordset->EOF) {
	$order_bibit_list->Recordset->MoveFirst();
	$bSelectLimit = $order_bibit_list->UseSelectLimit;
	if (!$bSelectLimit && $order_bibit_list->StartRec > 1)
		$order_bibit_list->Recordset->Move($order_bibit_list->StartRec - 1);
} elseif (!$order_bibit->AllowAddDeleteRow && $order_bibit_list->StopRec == 0) {
	$order_bibit_list->StopRec = $order_bibit->GridAddRowCount;
}

// Initialize aggregate
$order_bibit->RowType = EW_ROWTYPE_AGGREGATEINIT;
$order_bibit->ResetAttrs();
$order_bibit_list->RenderRow();
while ($order_bibit_list->RecCnt < $order_bibit_list->StopRec) {
	$order_bibit_list->RecCnt++;
	if (intval($order_bibit_list->RecCnt) >= intval($order_bibit_list->StartRec)) {
		$order_bibit_list->RowCnt++;

		// Set up key count
		$order_bibit_list->KeyCount = $order_bibit_list->RowIndex;

		// Init row class and style
		$order_bibit->ResetAttrs();
		$order_bibit->CssClass = "";
		if ($order_bibit->CurrentAction == "gridadd") {
		} else {
			$order_bibit_list->LoadRowValues($order_bibit_list->Recordset); // Load row values
		}
		$order_bibit->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$order_bibit->RowAttrs = array_merge($order_bibit->RowAttrs, array('data-rowindex'=>$order_bibit_list->RowCnt, 'id'=>'r' . $order_bibit_list->RowCnt . '_order_bibit', 'data-rowtype'=>$order_bibit->RowType));

		// Render row
		$order_bibit_list->RenderRow();

		// Render list options
		$order_bibit_list->RenderListOptions();
?>
	<tr<?php echo $order_bibit->RowAttributes() ?>>
<?php

// Render list options (body, left)
$order_bibit_list->ListOptions->Render("body", "left", $order_bibit_list->RowCnt);
?>
	<?php if ($order_bibit->ob_id->Visible) { // ob_id ?>
		<td data-name="ob_id"<?php echo $order_bibit->ob_id->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_ob_id" class="order_bibit_ob_id">
<span<?php echo $order_bibit->ob_id->ViewAttributes() ?>>
<?php echo $order_bibit->ob_id->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($order_bibit->ob_co->Visible) { // ob_co ?>
		<td data-name="ob_co"<?php echo $order_bibit->ob_co->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_ob_co" class="order_bibit_ob_co">
<span<?php echo $order_bibit->ob_co->ViewAttributes() ?>>
<?php echo $order_bibit->ob_co->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($order_bibit->ob_k_tanam->Visible) { // ob_k_tanam ?>
		<td data-name="ob_k_tanam"<?php echo $order_bibit->ob_k_tanam->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_ob_k_tanam" class="order_bibit_ob_k_tanam">
<span<?php echo $order_bibit->ob_k_tanam->ViewAttributes() ?>>
<?php echo $order_bibit->ob_k_tanam->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($order_bibit->ob_pembeli->Visible) { // ob_pembeli ?>
		<td data-name="ob_pembeli"<?php echo $order_bibit->ob_pembeli->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_ob_pembeli" class="order_bibit_ob_pembeli">
<span<?php echo $order_bibit->ob_pembeli->ViewAttributes() ?>>
<?php echo $order_bibit->ob_pembeli->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($order_bibit->ob_tgl_kirim->Visible) { // ob_tgl_kirim ?>
		<td data-name="ob_tgl_kirim"<?php echo $order_bibit->ob_tgl_kirim->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_ob_tgl_kirim" class="order_bibit_ob_tgl_kirim">
<span<?php echo $order_bibit->ob_tgl_kirim->ViewAttributes() ?>>
<?php echo $order_bibit->ob_tgl_kirim->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($order_bibit->ob_var->Visible) { // ob_var ?>
		<td data-name="ob_var"<?php echo $order_bibit->ob_var->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_ob_var" class="order_bibit_ob_var">
<span<?php echo $order_bibit->ob_var->ViewAttributes() ?>>
<?php echo $order_bibit->ob_var->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($order_bibit->ob_jumlah->Visible) { // ob_jumlah ?>
		<td data-name="ob_jumlah"<?php echo $order_bibit->ob_jumlah->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_ob_jumlah" class="order_bibit_ob_jumlah">
<span<?php echo $order_bibit->ob_jumlah->ViewAttributes() ?>>
<?php echo $order_bibit->ob_jumlah->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($order_bibit->status->Visible) { // status ?>
		<td data-name="status"<?php echo $order_bibit->status->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_status" class="order_bibit_status">
<span<?php echo $order_bibit->status->ViewAttributes() ?>>
<?php echo $order_bibit->status->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($order_bibit->ob_tgl_real_kirim->Visible) { // ob_tgl_real_kirim ?>
		<td data-name="ob_tgl_real_kirim"<?php echo $order_bibit->ob_tgl_real_kirim->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_ob_tgl_real_kirim" class="order_bibit_ob_tgl_real_kirim">
<span<?php echo $order_bibit->ob_tgl_real_kirim->ViewAttributes() ?>>
<?php echo $order_bibit->ob_tgl_real_kirim->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($order_bibit->ob_jumlah_real_kirim->Visible) { // ob_jumlah_real_kirim ?>
		<td data-name="ob_jumlah_real_kirim"<?php echo $order_bibit->ob_jumlah_real_kirim->CellAttributes() ?>>
<span id="el<?php echo $order_bibit_list->RowCnt ?>_order_bibit_ob_jumlah_real_kirim" class="order_bibit_ob_jumlah_real_kirim">
<span<?php echo $order_bibit->ob_jumlah_real_kirim->ViewAttributes() ?>>
<?php echo $order_bibit->ob_jumlah_real_kirim->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$order_bibit_list->ListOptions->Render("body", "right", $order_bibit_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($order_bibit->CurrentAction <> "gridadd")
		$order_bibit_list->Recordset->MoveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$order_bibit->RowType = EW_ROWTYPE_AGGREGATE;
$order_bibit->ResetAttrs();
$order_bibit_list->RenderRow();
?>
<?php if ($order_bibit_list->TotalRecs > 0 && ($order_bibit->CurrentAction <> "gridadd" && $order_bibit->CurrentAction <> "gridedit")) { ?>
<tfoot><!-- Table footer -->
	<tr class="ewTableFooter">
<?php

// Render list options
$order_bibit_list->RenderListOptions();

// Render list options (footer, left)
$order_bibit_list->ListOptions->Render("footer", "left");
?>
	<?php if ($order_bibit->ob_id->Visible) { // ob_id ?>
		<td data-name="ob_id" class="<?php echo $order_bibit->ob_id->FooterCellClass() ?>"><span id="elf_order_bibit_ob_id" class="order_bibit_ob_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($order_bibit->ob_co->Visible) { // ob_co ?>
		<td data-name="ob_co" class="<?php echo $order_bibit->ob_co->FooterCellClass() ?>"><span id="elf_order_bibit_ob_co" class="order_bibit_ob_co">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($order_bibit->ob_k_tanam->Visible) { // ob_k_tanam ?>
		<td data-name="ob_k_tanam" class="<?php echo $order_bibit->ob_k_tanam->FooterCellClass() ?>"><span id="elf_order_bibit_ob_k_tanam" class="order_bibit_ob_k_tanam">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($order_bibit->ob_pembeli->Visible) { // ob_pembeli ?>
		<td data-name="ob_pembeli" class="<?php echo $order_bibit->ob_pembeli->FooterCellClass() ?>"><span id="elf_order_bibit_ob_pembeli" class="order_bibit_ob_pembeli">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($order_bibit->ob_tgl_kirim->Visible) { // ob_tgl_kirim ?>
		<td data-name="ob_tgl_kirim" class="<?php echo $order_bibit->ob_tgl_kirim->FooterCellClass() ?>"><span id="elf_order_bibit_ob_tgl_kirim" class="order_bibit_ob_tgl_kirim">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($order_bibit->ob_var->Visible) { // ob_var ?>
		<td data-name="ob_var" class="<?php echo $order_bibit->ob_var->FooterCellClass() ?>"><span id="elf_order_bibit_ob_var" class="order_bibit_ob_var">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($order_bibit->ob_jumlah->Visible) { // ob_jumlah ?>
		<td data-name="ob_jumlah" class="<?php echo $order_bibit->ob_jumlah->FooterCellClass() ?>"><span id="elf_order_bibit_ob_jumlah" class="order_bibit_ob_jumlah">
<span class="ewAggregate"><?php echo $Language->Phrase("TOTAL") ?></span><span class="ewAggregateValue">
<?php echo $order_bibit->ob_jumlah->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($order_bibit->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $order_bibit->status->FooterCellClass() ?>"><span id="elf_order_bibit_status" class="order_bibit_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($order_bibit->ob_tgl_real_kirim->Visible) { // ob_tgl_real_kirim ?>
		<td data-name="ob_tgl_real_kirim" class="<?php echo $order_bibit->ob_tgl_real_kirim->FooterCellClass() ?>"><span id="elf_order_bibit_ob_tgl_real_kirim" class="order_bibit_ob_tgl_real_kirim">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($order_bibit->ob_jumlah_real_kirim->Visible) { // ob_jumlah_real_kirim ?>
		<td data-name="ob_jumlah_real_kirim" class="<?php echo $order_bibit->ob_jumlah_real_kirim->FooterCellClass() ?>"><span id="elf_order_bibit_ob_jumlah_real_kirim" class="order_bibit_ob_jumlah_real_kirim">
<span class="ewAggregate"><?php echo $Language->Phrase("TOTAL") ?></span><span class="ewAggregateValue">
<?php echo $order_bibit->ob_jumlah_real_kirim->ViewValue ?></span>
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$order_bibit_list->ListOptions->Render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table>
<?php } ?>
<?php if ($order_bibit->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($order_bibit_list->Recordset)
	$order_bibit_list->Recordset->Close();
?>
<?php if ($order_bibit->Export == "") { ?>
<div class="box-footer ewGridLowerPanel">
<?php if ($order_bibit->CurrentAction <> "gridadd" && $order_bibit->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($order_bibit_list->Pager)) $order_bibit_list->Pager = new cNumericPager($order_bibit_list->StartRec, $order_bibit_list->DisplayRecs, $order_bibit_list->TotalRecs, $order_bibit_list->RecRange, $order_bibit_list->AutoHidePager) ?>
<?php if ($order_bibit_list->Pager->RecordCount > 0 && $order_bibit_list->Pager->Visible) { ?>
<div class="ewPager">
<div class="ewNumericPage"><ul class="pagination">
	<?php if ($order_bibit_list->Pager->FirstButton->Enabled) { ?>
	<li><a href="<?php echo $order_bibit_list->PageUrl() ?>start=<?php echo $order_bibit_list->Pager->FirstButton->Start ?>"><?php echo $Language->Phrase("PagerFirst") ?></a></li>
	<?php } ?>
	<?php if ($order_bibit_list->Pager->PrevButton->Enabled) { ?>
	<li><a href="<?php echo $order_bibit_list->PageUrl() ?>start=<?php echo $order_bibit_list->Pager->PrevButton->Start ?>"><?php echo $Language->Phrase("PagerPrevious") ?></a></li>
	<?php } ?>
	<?php foreach ($order_bibit_list->Pager->Items as $PagerItem) { ?>
		<li<?php if (!$PagerItem->Enabled) { echo " class=\" active\""; } ?>><a href="<?php if ($PagerItem->Enabled) { echo $order_bibit_list->PageUrl() . "start=" . $PagerItem->Start; } else { echo "#"; } ?>"><?php echo $PagerItem->Text ?></a></li>
	<?php } ?>
	<?php if ($order_bibit_list->Pager->NextButton->Enabled) { ?>
	<li><a href="<?php echo $order_bibit_list->PageUrl() ?>start=<?php echo $order_bibit_list->Pager->NextButton->Start ?>"><?php echo $Language->Phrase("PagerNext") ?></a></li>
	<?php } ?>
	<?php if ($order_bibit_list->Pager->LastButton->Enabled) { ?>
	<li><a href="<?php echo $order_bibit_list->PageUrl() ?>start=<?php echo $order_bibit_list->Pager->LastButton->Start ?>"><?php echo $Language->Phrase("PagerLast") ?></a></li>
	<?php } ?>
</ul></div>
</div>
<?php } ?>
<?php if ($order_bibit_list->Pager->RecordCount > 0) { ?>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $order_bibit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $order_bibit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $order_bibit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($order_bibit_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<?php } ?>
<?php if ($order_bibit_list->TotalRecs == 0 && $order_bibit->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($order_bibit_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if ($order_bibit->Export == "") { ?>
<script type="text/javascript">
forder_bibitlistsrch.FilterList = <?php echo $order_bibit_list->GetFilterList() ?>;
forder_bibitlistsrch.Init();
forder_bibitlist.Init();
</script>
<?php } ?>
<?php
$order_bibit_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($order_bibit->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$order_bibit_list->Page_Terminate();
?>
