<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start();
?>
<?php include_once "phprptinc/ewrcfg10.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "phprptinc/ewmysql.php") ?>
<?php include_once "phprptinc/ewrfn10.php" ?>
<?php include_once "phprptinc/ewrusrfn10.php" ?>
<?php include_once "luasviewrptinfo.php" ?>
<?php

//
// Page class
//

$luasview_rpt = NULL; // Initialize page object first

class crluasview_rpt extends crluasview {

	// Page ID
	var $PageID = 'rpt';

	// Project ID
	var $ProjectID = "{FAF953E4-B026-4CC4-8D1E-0CFAFEB15236}";

	// Page object name
	var $PageObjName = 'luasview_rpt';

	// Page name
	function PageName() {
		return ewr_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ewr_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Export URLs
	var $ExportPrintUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportPdfUrl;
	var $ReportTableClass;
	var $ReportTableStyle = "";

	// Custom export
	var $ExportPrintCustom = FALSE;
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Message
	function getMessage() {
		return @$_SESSION[EWR_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EWR_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EWR_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EWR_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_WARNING_MESSAGE], $v);
	}

		// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EWR_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EWR_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EWR_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EWR_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog ewDisplayTable\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") // Header exists, display
			echo $sHeader;
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") // Fotoer exists, display
			echo $sFooter;
	}

	// Validate page request
	function IsPageRequest() {
		if ($this->UseTokenInUrl) {
			if (ewr_IsHttpPost())
				return ($this->TableVar == @$_POST("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == @$_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $CheckToken = EWR_CHECK_TOKEN;
	var $CheckTokenFn = "ewr_CheckToken";
	var $CreateTokenFn = "ewr_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ewr_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EWR_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EWR_TOKEN_NAME]);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $ReportLanguage;
		global $UserTable, $UserTableConn;

		// Language object
		$ReportLanguage = new crLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (luasview)
		if (!isset($GLOBALS["luasview"])) {
			$GLOBALS["luasview"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["luasview"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";

		// Page ID
		if (!defined("EWR_PAGE_ID"))
			define("EWR_PAGE_ID", 'rpt', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EWR_TABLE_NAME"))
			define("EWR_TABLE_NAME", 'luasview', TRUE);

		// Start timer
		$GLOBALS["gsTimer"] = new crTimer();

		// Open connection
		if (!isset($conn)) $conn = ewr_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cremployees();
			$UserTableConn = ReportConn($UserTable->DBID);
		}

		// Export options
		$this->ExportOptions = new crListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Search options
		$this->SearchOptions = new crListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Filter options
		$this->FilterOptions = new crListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fluasviewrpt";

		// Generate report options
		$this->GenerateOptions = new crListOptions();
		$this->GenerateOptions->Tag = "div";
		$this->GenerateOptions->TagClassName = "ewGenerateOption";
	}

	//
	// Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $gsEmailContentType, $ReportLanguage, $Security;
		global $gsCustomExport;

		// Security
		$Security = new crAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin(); // Auto login
		$Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . 'luasview');
		$Security->TablePermission_Loaded();
		if (!$Security->CanList()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($ReportLanguage->Phrase("NoPermission")); // Set no permission
			$this->Page_Terminate(ewr_GetUrl("index.php"));
		}

		// Get export parameters
		if (@$_GET["export"] <> "")
			$this->Export = strtolower($_GET["export"]);
		elseif (@$_POST["export"] <> "")
			$this->Export = strtolower($_POST["export"]);
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$gsEmailContentType = @$_POST["contenttype"]; // Get email content type

		// Setup placeholder
		// Setup export options

		$this->SetupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $ReportLanguage->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Security, $ReportLanguage, $ReportOptions;
		$exportid = session_id();
		$ReportTypes = array();

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = TRUE;
		$ReportTypes["print"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormPrint") : "";

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;
		$ReportTypes["excel"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormExcel") : "";

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->Phrase("ExportToWord") . "</a>";

		//$item->Visible = TRUE;
		$item->Visible = TRUE;
		$ReportTypes["word"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormWord") : "";

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Uncomment codes below to show export to Pdf link
//		$item->Visible = TRUE;

		$ReportTypes["pdf"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormPdf") : "";

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = $this->PageUrl() . "export=email";
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" id=\"emf_luasview\" href=\"javascript:void(0);\" onclick=\"ewr_EmailDialogShow({lnk:'emf_luasview',hdr:ewLanguage.Phrase('ExportToEmail'),url:'$url',exportid:'$exportid',el:this});\">" . $ReportLanguage->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;
		$ReportTypes["email"] = $item->Visible ? $ReportLanguage->Phrase("ReportFormEmail") : "";
		$ReportOptions["ReportTypes"] = $ReportTypes;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fluasviewrpt\" href=\"#\">" . $ReportLanguage->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fluasviewrpt\" href=\"#\">" . $ReportLanguage->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up options (extended)
		$this->SetupExportOptionsExt();

		// Hide options for export
		if ($this->Export <> "") {
			$this->ExportOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Set up table class
		if ($this->Export == "word" || $this->Export == "excel" || $this->Export == "pdf")
			$this->ReportTableClass = "ewTable";
		else
			$this->ReportTableClass = "table ewTable";
	}

	// Set up search options
	function SetupSearchOptions() {
		global $ReportLanguage;

		// Filter panel button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = $this->FilterApplied ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fluasviewrpt\">" . $ReportLanguage->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Reset filter
		$item = &$this->SearchOptions->Add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . ewr_CurrentPage() . "?cmd=reset'\">" . $ReportLanguage->Phrase("ResetAllFilter") . "</button>";
		$item->Visible = TRUE && $this->FilterApplied;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->SearchOptions->HideAllOptions();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $ReportLanguage, $EWR_EXPORT, $gsExportFile;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->Export <> "" && array_key_exists($this->Export, $EWR_EXPORT)) {
			$sContent = ob_get_contents();
			if (ob_get_length())
				ob_end_clean();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $sContent, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$sContent = str_replace($divmatch[0], '', $sContent);
				}
			}
			$fn = $EWR_EXPORT[$this->Export];
			if ($this->Export == "email") { // Email
				if (@$this->GenOptions["reporttype"] == "email") {
					$saveResponse = $this->$fn($sContent, $this->GenOptions);
					$this->WriteGenResponse($saveResponse);
				} else {
					echo $this->$fn($sContent, array());
				}
				$url = ""; // Avoid redirect
			} else {
				$saveToFile = $this->$fn($sContent, $this->GenOptions);
				if (@$this->GenOptions["reporttype"] <> "") {
					$saveUrl = ($saveToFile <> "") ? ewr_ConvertFullUrl($saveToFile) : $ReportLanguage->Phrase("GenerateSuccess");
					$this->WriteGenResponse($saveUrl);
					$url = ""; // Avoid redirect
				}
			}
		}

		 // Close connection
		ewr_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EWR_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Initialize common variables
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $FilterOptions; // Filter options

	// Paging variables
	var $RecIndex = 0; // Record index
	var $RecCount = 0; // Record count
	var $StartGrp = 0; // Start group
	var $StopGrp = 0; // Stop group
	var $TotalGrps = 0; // Total groups
	var $GrpCount = 0; // Group count
	var $GrpCounter = array(); // Group counter
	var $DisplayGrps = 50; // Groups per page
	var $GrpRange = 10;
	var $Sort = "";
	var $Filter = "";
	var $PageFirstGroupFilter = "";
	var $UserIDFilter = "";
	var $DrillDown = FALSE;
	var $DrillDownInPanel = FALSE;
	var $DrillDownList = "";

	// Clear field for ext filter
	var $ClearExtFilter = "";
	var $PopupName = "";
	var $PopupValue = "";
	var $FilterApplied;
	var $SearchCommand = FALSE;
	var $ShowHeader;
	var $GrpColumnCount = 0;
	var $SubGrpColumnCount = 0;
	var $DtlColumnCount = 0;
	var $Cnt, $Col, $Val, $Smry, $Mn, $Mx, $GrandCnt, $GrandSmry, $GrandMn, $GrandMx;
	var $TotCount;
	var $GrandSummarySetup = FALSE;
	var $GrpIdx;
	var $DetailRows = array();

	//
	// Page main
	//
	function Page_Main() {
		global $rs;
		global $rsgrp;
		global $Security;
		global $gsFormError;
		global $gbDrillDownInPanel;
		global $ReportBreadcrumb;
		global $ReportLanguage;

		// Set field visibility for detail fields
		$this->Pic->SetVisibility();
		$this->varietas->SetVisibility();
		$this->Provinsi->SetVisibility();
		$this->Kabupaten->SetVisibility();
		$this->Koordinator->SetVisibility();
		$this->Tahun->SetVisibility();
		$this->Bulan->SetVisibility();
		$this->Luas->SetVisibility();
		$this->Estimasi_Panen->SetVisibility();
		$this->Aktual_Panen->SetVisibility();
		$this->Rata_rata_Skor->SetVisibility();

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$nDtls = 12;
		$nGrps = 1;
		$this->Val = &ewr_InitArray($nDtls, 0);
		$this->Cnt = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Smry = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Mn = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->Mx = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->GrandCnt = &ewr_InitArray($nDtls, 0);
		$this->GrandSmry = &ewr_InitArray($nDtls, 0);
		$this->GrandMn = &ewr_InitArray($nDtls, NULL);
		$this->GrandMx = &ewr_InitArray($nDtls, NULL);

		// Set up array if accumulation required: array(Accum, SkipNullOrZero)
		$this->Col = array(array(FALSE, FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(TRUE,FALSE), array(TRUE,FALSE), array(TRUE,FALSE), array(TRUE,FALSE));

		// Set up groups per page dynamically
		$this->SetUpDisplayGrps();

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();

		// Check if search command
		$this->SearchCommand = (@$_GET["cmd"] == "search");

		// Load default filter values
		$this->LoadDefaultFilters();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->SetupPopup();

		// Load group db values if necessary
		$this->LoadGroupDbValues();

		// Handle Ajax popup
		$this->ProcessAjaxPopup();

		// Extended filter
		$sExtendedFilter = "";

		// Restore filter list
		$this->RestoreFilterList();

		// Build extended filter
		$sExtendedFilter = $this->GetExtendedFilter();
		ewr_AddFilter($this->Filter, $sExtendedFilter);

		// Build popup filter
		$sPopupFilter = $this->GetPopupFilter();

		//ewr_SetDebugMsg("popup filter: " . $sPopupFilter);
		ewr_AddFilter($this->Filter, $sPopupFilter);

		// Check if filter applied
		$this->FilterApplied = $this->CheckFilter();

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);

		// Search options
		$this->SetupSearchOptions();

		// Get sort
		$this->Sort = $this->GetSort($this->GenOptions);

		// Get total count
		$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $this->Filter, $this->Sort);
		$this->TotalGrps = $this->GetCnt($sSql);
		if ($this->DisplayGrps <= 0 || $this->DrillDown) // Display all groups
			$this->DisplayGrps = $this->TotalGrps;
		$this->StartGrp = 1;

		// Show header
		$this->ShowHeader = ($this->TotalGrps > 0);

		// Set up start position if not export all
		if ($this->ExportAll && $this->Export <> "")
			$this->DisplayGrps = $this->TotalGrps;
		else
			$this->SetUpStartGroup($this->GenOptions);

		// Set no record found message
		if ($this->TotalGrps == 0) {
			if ($Security->CanList()) {
				if ($this->Filter == "0=101") {
					$this->setWarningMessage($ReportLanguage->Phrase("EnterSearchCriteria"));
				} else {
					$this->setWarningMessage($ReportLanguage->Phrase("NoRecord"));
				}
			} else {
				$this->setWarningMessage($ReportLanguage->Phrase("NoPermission"));
			}
		}

		// Hide export options if export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();

		// Hide search/filter options if export/drilldown
		if ($this->Export <> "" || $this->DrillDown) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
			$this->GenerateOptions->HideAllOptions();
		}

		// Get current page records
		$rs = $this->GetRs($sSql, $this->StartGrp, $this->DisplayGrps);
		$this->SetupFieldCount();
	}

	// Accummulate summary
	function AccumulateSummary() {
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Col[$iy][0]) { // Accumulate required
					$valwrk = $this->Val[$iy];
					if (is_null($valwrk)) {
						if (!$this->Col[$iy][1])
							$this->Cnt[$ix][$iy]++;
					} else {
						$accum = (!$this->Col[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Cnt[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Smry[$ix][$iy] += $valwrk;
								if (is_null($this->Mn[$ix][$iy])) {
									$this->Mn[$ix][$iy] = $valwrk;
									$this->Mx[$ix][$iy] = $valwrk;
								} else {
									if ($this->Mn[$ix][$iy] > $valwrk) $this->Mn[$ix][$iy] = $valwrk;
									if ($this->Mx[$ix][$iy] < $valwrk) $this->Mx[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0]++;
		}
	}

	// Reset level summary
	function ResetLevelSummary($lvl) {

		// Clear summary values
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Cnt[$ix][$iy] = 0;
				if ($this->Col[$iy][0]) {
					$this->Smry[$ix][$iy] = 0;
					$this->Mn[$ix][$iy] = NULL;
					$this->Mx[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0] = 0;
		}

		// Reset record count
		$this->RecCount = 0;
	}

	// Accummulate grand summary
	function AccumulateGrandSummary() {
		$this->TotCount++;
		$cntgs = count($this->GrandSmry);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Col[$iy][0]) {
				$valwrk = $this->Val[$iy];
				if (is_null($valwrk) || !is_numeric($valwrk)) {
					if (!$this->Col[$iy][1])
						$this->GrandCnt[$iy]++;
				} else {
					if (!$this->Col[$iy][1] || $valwrk <> 0) {
						$this->GrandCnt[$iy]++;
						$this->GrandSmry[$iy] += $valwrk;
						if (is_null($this->GrandMn[$iy])) {
							$this->GrandMn[$iy] = $valwrk;
							$this->GrandMx[$iy] = $valwrk;
						} else {
							if ($this->GrandMn[$iy] > $valwrk) $this->GrandMn[$iy] = $valwrk;
							if ($this->GrandMx[$iy] < $valwrk) $this->GrandMx[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Get count
	function GetCnt($sql) {
		$conn = &$this->Connection();
		$rscnt = $conn->Execute($sql);
		$cnt = ($rscnt) ? $rscnt->RecordCount() : 0;
		if ($rscnt) $rscnt->Close();
		return $cnt;
	}

	// Get recordset
	function GetRs($wrksql, $start, $grps) {
		$conn = &$this->Connection();
		$conn->raiseErrorFn = $GLOBALS["EWR_ERROR_FN"];
		$rswrk = $conn->SelectLimit($wrksql, $grps, $start - 1);
		$conn->raiseErrorFn = '';
		return $rswrk;
	}

	// Get row values
	function GetRow($opt) {
		global $rs;
		if (!$rs)
			return;
		if ($opt == 1) { // Get first row
				$this->FirstRowData = array();
				$this->FirstRowData['Pic'] = ewr_Conv($rs->fields('Pic'), 200);
				$this->FirstRowData['varietas'] = ewr_Conv($rs->fields('varietas'), 200);
				$this->FirstRowData['Provinsi'] = ewr_Conv($rs->fields('Provinsi'), 200);
				$this->FirstRowData['Kabupaten'] = ewr_Conv($rs->fields('Kabupaten'), 200);
				$this->FirstRowData['Koordinator'] = ewr_Conv($rs->fields('Koordinator'), 200);
				$this->FirstRowData['Tahun'] = ewr_Conv($rs->fields('Tahun'), 3);
				$this->FirstRowData['Bulan'] = ewr_Conv($rs->fields('Bulan'), 3);
				$this->FirstRowData['Luas'] = ewr_Conv($rs->fields('Luas'), 131);
				$this->FirstRowData['Estimasi_Panen'] = ewr_Conv($rs->fields('Estimasi_Panen'), 131);
				$this->FirstRowData['Aktual_Panen'] = ewr_Conv($rs->fields('Aktual_Panen'), 131);
				$this->FirstRowData['Rata_rata_Skor'] = ewr_Conv($rs->fields('Rata_rata_Skor'), 5);
		} else { // Get next row
			$rs->MoveNext();
		}
		if (!$rs->EOF) {
			$this->Pic->setDbValue($rs->fields('Pic'));
			$this->varietas->setDbValue($rs->fields('varietas'));
			$this->Provinsi->setDbValue($rs->fields('Provinsi'));
			$this->Kabupaten->setDbValue($rs->fields('Kabupaten'));
			$this->Koordinator->setDbValue($rs->fields('Koordinator'));
			$this->Tahun->setDbValue($rs->fields('Tahun'));
			$this->Bulan->setDbValue($rs->fields('Bulan'));
			$this->Luas->setDbValue($rs->fields('Luas'));
			$this->Estimasi_Panen->setDbValue($rs->fields('Estimasi_Panen'));
			$this->Aktual_Panen->setDbValue($rs->fields('Aktual_Panen'));
			$this->Rata_rata_Skor->setDbValue($rs->fields('Rata_rata_Skor'));
			$this->Val[1] = $this->Pic->CurrentValue;
			$this->Val[2] = $this->varietas->CurrentValue;
			$this->Val[3] = $this->Provinsi->CurrentValue;
			$this->Val[4] = $this->Kabupaten->CurrentValue;
			$this->Val[5] = $this->Koordinator->CurrentValue;
			$this->Val[6] = $this->Tahun->CurrentValue;
			$this->Val[7] = $this->Bulan->CurrentValue;
			$this->Val[8] = $this->Luas->CurrentValue;
			$this->Val[9] = $this->Estimasi_Panen->CurrentValue;
			$this->Val[10] = $this->Aktual_Panen->CurrentValue;
			$this->Val[11] = $this->Rata_rata_Skor->CurrentValue;
		} else {
			$this->Pic->setDbValue("");
			$this->varietas->setDbValue("");
			$this->Provinsi->setDbValue("");
			$this->Kabupaten->setDbValue("");
			$this->Koordinator->setDbValue("");
			$this->Tahun->setDbValue("");
			$this->Bulan->setDbValue("");
			$this->Luas->setDbValue("");
			$this->Estimasi_Panen->setDbValue("");
			$this->Aktual_Panen->setDbValue("");
			$this->Rata_rata_Skor->setDbValue("");
		}
	}

	// Set up starting group
	function SetUpStartGroup($options = array()) {

		// Exit if no groups
		if ($this->DisplayGrps == 0)
			return;
		$startGrp = (@$options["start"] <> "") ? $options["start"] : @$_GET[EWR_TABLE_START_GROUP];
		$pageNo = (@$options["pageno"] <> "") ? $options["pageno"] : @$_GET["pageno"];

		// Check for a 'start' parameter
		if ($startGrp != "") {
			$this->StartGrp = $startGrp;
			$this->setStartGroup($this->StartGrp);
		} elseif ($pageNo != "") {
			$nPageNo = $pageNo;
			if (is_numeric($nPageNo)) {
				$this->StartGrp = ($nPageNo-1)*$this->DisplayGrps+1;
				if ($this->StartGrp <= 0) {
					$this->StartGrp = 1;
				} elseif ($this->StartGrp >= intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1) {
					$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1;
				}
				$this->setStartGroup($this->StartGrp);
			} else {
				$this->StartGrp = $this->getStartGroup();
			}
		} else {
			$this->StartGrp = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGrp) || $this->StartGrp == "") { // Avoid invalid start group counter
			$this->StartGrp = 1; // Reset start group counter
			$this->setStartGroup($this->StartGrp);
		} elseif (intval($this->StartGrp) > intval($this->TotalGrps)) { // Avoid starting group > total groups
			$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to last page first group
			$this->setStartGroup($this->StartGrp);
		} elseif (($this->StartGrp-1) % $this->DisplayGrps <> 0) {
			$this->StartGrp = intval(($this->StartGrp-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to page boundary
			$this->setStartGroup($this->StartGrp);
		}
	}

	// Load group db values if necessary
	function LoadGroupDbValues() {
		$conn = &$this->Connection();
	}

	// Process Ajax popup
	function ProcessAjaxPopup() {
		global $ReportLanguage;
		$conn = &$this->Connection();
		$fld = NULL;
		if (@$_GET["popup"] <> "") {
			$popupname = $_GET["popup"];

			// Check popup name
			// Output data as Json

			if (!is_null($fld)) {
				$jsdb = ewr_GetJsDb($fld, $fld->FldType);
				if (ob_get_length())
					ob_end_clean();
				echo $jsdb;
				exit();
			}
		}
	}

	// Set up popup
	function SetupPopup() {
		global $ReportLanguage;
		$conn = &$this->Connection();
		if ($this->DrillDown)
			return;

		// Process post back form
		if (ewr_IsHttpPost()) {
			$sName = @$_POST["popup"]; // Get popup form name
			if ($sName <> "") {
				$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
				if ($cntValues > 0) {
					$arValues = ewr_StripSlashes($_POST["sel_$sName"]);
					if (trim($arValues[0]) == "") // Select all
						$arValues = EWR_INIT_VALUE;
					$this->PopupName = $sName;
					if (ewr_IsAdvancedFilterValue($arValues) || $arValues == EWR_INIT_VALUE)
						$this->PopupValue = $arValues;
					if (!ewr_MatchedArray($arValues, $_SESSION["sel_$sName"])) {
						if ($this->HasSessionFilterValues($sName))
							$this->ClearExtFilter = $sName; // Clear extended filter for this field
					}
					$_SESSION["sel_$sName"] = $arValues;
					$_SESSION["rf_$sName"] = ewr_StripSlashes(@$_POST["rf_$sName"]);
					$_SESSION["rt_$sName"] = ewr_StripSlashes(@$_POST["rt_$sName"]);
					$this->ResetPager();
				}
			}

		// Get 'reset' command
		} elseif (@$_GET["cmd"] <> "") {
			$sCmd = $_GET["cmd"];
			if (strtolower($sCmd) == "reset") {
				$this->ResetPager();
			}
		}

		// Load selection criteria to array
	}

	// Reset pager
	function ResetPager() {

		// Reset start position (reset command)
		$this->StartGrp = 1;
		$this->setStartGroup($this->StartGrp);
	}

	// Set up number of groups displayed per page
	function SetUpDisplayGrps() {
		$sWrk = @$_GET[EWR_TABLE_GROUP_PER_PAGE];
		if ($sWrk <> "") {
			if (is_numeric($sWrk)) {
				$this->DisplayGrps = intval($sWrk);
			} else {
				if (strtoupper($sWrk) == "ALL") { // Display all groups
					$this->DisplayGrps = -1;
				} else {
					$this->DisplayGrps = 50; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGrps); // Save to session

			// Reset start position (reset command)
			$this->StartGrp = 1;
			$this->setStartGroup($this->StartGrp);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGrps = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGrps = 50; // Load default
			}
		}
	}

	// Render row
	function RenderRow() {
		global $rs, $Security, $ReportLanguage;
		$conn = &$this->Connection();
		if (!$this->GrandSummarySetup) { // Get Grand total
			$bGotCount = FALSE;
			$bGotSummary = FALSE;

			// Get total count from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->Execute($sSql);
			if ($rstot) {
				$this->TotCount = ($rstot->RecordCount()>1) ? $rstot->RecordCount() : $rstot->fields[0];
				$rstot->Close();
				$bGotCount = TRUE;
			} else {
				$this->TotCount = 0;
			}

			// Get total from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectAgg(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$sSql = $this->getSqlAggPfx() . $sSql . $this->getSqlAggSfx();
			$rsagg = $conn->Execute($sSql);
			if ($rsagg) {
				$this->GrandCnt[1] = $this->TotCount;
				$this->GrandCnt[2] = $this->TotCount;
				$this->GrandCnt[3] = $this->TotCount;
				$this->GrandCnt[4] = $this->TotCount;
				$this->GrandCnt[5] = $this->TotCount;
				$this->GrandCnt[6] = $this->TotCount;
				$this->GrandCnt[7] = $this->TotCount;
				$this->GrandCnt[8] = $this->TotCount;
				$this->GrandSmry[8] = $rsagg->fields("sum_luas");
				$this->GrandCnt[9] = $this->TotCount;
				$this->GrandSmry[9] = $rsagg->fields("sum_estimasi_panen");
				$this->GrandCnt[10] = $this->TotCount;
				$this->GrandSmry[10] = $rsagg->fields("sum_aktual_panen");
				$this->GrandCnt[11] = $this->TotCount;
				$this->GrandSmry[11] = $rsagg->fields("sum_rata_rata_skor");
				$rsagg->Close();
				$bGotSummary = TRUE;
			}

			// Accumulate grand summary from detail records
			if (!$bGotCount || !$bGotSummary) {
				$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$rs = $conn->Execute($sSql);
				if ($rs) {
					$this->GetRow(1);
					while (!$rs->EOF) {
						$this->AccumulateGrandSummary();
						$this->GetRow(2);
					}
					$rs->Close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();

		//
		// Render view codes
		//

		if ($this->RowType == EWR_ROWTYPE_TOTAL && !($this->RowTotalType == EWR_ROWTOTAL_GROUP && $this->RowTotalSubType == EWR_ROWTOTAL_HEADER)) { // Summary row
			ewr_PrependClass($this->RowAttrs["class"], ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel); // Set up row class

			// Luas
			$this->Luas->SumViewValue = $this->Luas->SumValue;
			$this->Luas->SumViewValue = ewr_FormatNumber($this->Luas->SumViewValue, 0, -2, -2, 0);
			$this->Luas->CellAttrs["style"] = "text-align:right;";
			$this->Luas->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// Estimasi_Panen
			$this->Estimasi_Panen->SumViewValue = $this->Estimasi_Panen->SumValue;
			$this->Estimasi_Panen->SumViewValue = ewr_FormatNumber($this->Estimasi_Panen->SumViewValue, 0, -2, -2, -1);
			$this->Estimasi_Panen->CellAttrs["style"] = "text-align:right;";
			$this->Estimasi_Panen->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// Aktual_Panen
			$this->Aktual_Panen->SumViewValue = $this->Aktual_Panen->SumValue;
			$this->Aktual_Panen->SumViewValue = ewr_FormatNumber($this->Aktual_Panen->SumViewValue, 0, -2, -2, -1);
			$this->Aktual_Panen->CellAttrs["style"] = "text-align:right;";
			$this->Aktual_Panen->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// Rata_rata_Skor
			$this->Rata_rata_Skor->AvgViewValue = $this->Rata_rata_Skor->AvgValue;
			$this->Rata_rata_Skor->AvgViewValue = ewr_FormatNumber($this->Rata_rata_Skor->AvgViewValue, -2, -2, -2, -2);
			$this->Rata_rata_Skor->CellAttrs["style"] = "text-align:right;";
			$this->Rata_rata_Skor->CellAttrs["class"] = ($this->RowTotalType == EWR_ROWTOTAL_PAGE || $this->RowTotalType == EWR_ROWTOTAL_GRAND) ? "ewRptGrpAggregate" : "ewRptGrpSummary" . $this->RowGroupLevel;

			// Pic
			$this->Pic->HrefValue = "";

			// varietas
			$this->varietas->HrefValue = "";

			// Provinsi
			$this->Provinsi->HrefValue = "";

			// Kabupaten
			$this->Kabupaten->HrefValue = "";

			// Koordinator
			$this->Koordinator->HrefValue = "";

			// Tahun
			$this->Tahun->HrefValue = "";

			// Bulan
			$this->Bulan->HrefValue = "";

			// Luas
			$this->Luas->HrefValue = "";

			// Estimasi_Panen
			$this->Estimasi_Panen->HrefValue = "";

			// Aktual_Panen
			$this->Aktual_Panen->HrefValue = "";

			// Rata_rata_Skor
			$this->Rata_rata_Skor->HrefValue = "";
		} else {
			if ($this->RowTotalType == EWR_ROWTOTAL_GROUP && $this->RowTotalSubType == EWR_ROWTOTAL_HEADER) {
			} else {
			}

			// Pic
			$this->Pic->ViewValue = $this->Pic->CurrentValue;
			$this->Pic->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// varietas
			$this->varietas->ViewValue = $this->varietas->CurrentValue;
			$this->varietas->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Provinsi
			$this->Provinsi->ViewValue = $this->Provinsi->CurrentValue;
			$this->Provinsi->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Kabupaten
			$this->Kabupaten->ViewValue = $this->Kabupaten->CurrentValue;
			$this->Kabupaten->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Koordinator
			$this->Koordinator->ViewValue = $this->Koordinator->CurrentValue;
			$this->Koordinator->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Tahun
			$this->Tahun->ViewValue = $this->Tahun->CurrentValue;
			$this->Tahun->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Bulan
			$this->Bulan->ViewValue = $this->Bulan->CurrentValue;
			$this->Bulan->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Luas
			$this->Luas->ViewValue = $this->Luas->CurrentValue;
			$this->Luas->ViewValue = ewr_FormatNumber($this->Luas->ViewValue, 0, -2, -2, 0);
			$this->Luas->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";
			$this->Luas->CellAttrs["style"] = "text-align:right;";

			// Estimasi_Panen
			$this->Estimasi_Panen->ViewValue = $this->Estimasi_Panen->CurrentValue;
			$this->Estimasi_Panen->ViewValue = ewr_FormatNumber($this->Estimasi_Panen->ViewValue, 0, -2, -2, -1);
			$this->Estimasi_Panen->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";
			$this->Estimasi_Panen->CellAttrs["style"] = "text-align:right;";

			// Aktual_Panen
			$this->Aktual_Panen->ViewValue = $this->Aktual_Panen->CurrentValue;
			$this->Aktual_Panen->ViewValue = ewr_FormatNumber($this->Aktual_Panen->ViewValue, 0, -2, -2, -1);
			$this->Aktual_Panen->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";
			$this->Aktual_Panen->CellAttrs["style"] = "text-align:right;";

			// Rata_rata_Skor
			$this->Rata_rata_Skor->ViewValue = $this->Rata_rata_Skor->CurrentValue;
			$this->Rata_rata_Skor->ViewValue = ewr_FormatNumber($this->Rata_rata_Skor->ViewValue, -2, -2, -2, -2);
			$this->Rata_rata_Skor->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";
			$this->Rata_rata_Skor->CellAttrs["style"] = "text-align:right;";

			// Pic
			$this->Pic->HrefValue = "";

			// varietas
			$this->varietas->HrefValue = "";

			// Provinsi
			$this->Provinsi->HrefValue = "";

			// Kabupaten
			$this->Kabupaten->HrefValue = "";

			// Koordinator
			$this->Koordinator->HrefValue = "";

			// Tahun
			$this->Tahun->HrefValue = "";

			// Bulan
			$this->Bulan->HrefValue = "";

			// Luas
			$this->Luas->HrefValue = "";

			// Estimasi_Panen
			$this->Estimasi_Panen->HrefValue = "";

			// Aktual_Panen
			$this->Aktual_Panen->HrefValue = "";

			// Rata_rata_Skor
			$this->Rata_rata_Skor->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row

			// Luas
			$CurrentValue = $this->Luas->SumValue;
			$ViewValue = &$this->Luas->SumViewValue;
			$ViewAttrs = &$this->Luas->ViewAttrs;
			$CellAttrs = &$this->Luas->CellAttrs;
			$HrefValue = &$this->Luas->HrefValue;
			$LinkAttrs = &$this->Luas->LinkAttrs;
			$this->Cell_Rendered($this->Luas, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Estimasi_Panen
			$CurrentValue = $this->Estimasi_Panen->SumValue;
			$ViewValue = &$this->Estimasi_Panen->SumViewValue;
			$ViewAttrs = &$this->Estimasi_Panen->ViewAttrs;
			$CellAttrs = &$this->Estimasi_Panen->CellAttrs;
			$HrefValue = &$this->Estimasi_Panen->HrefValue;
			$LinkAttrs = &$this->Estimasi_Panen->LinkAttrs;
			$this->Cell_Rendered($this->Estimasi_Panen, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Aktual_Panen
			$CurrentValue = $this->Aktual_Panen->SumValue;
			$ViewValue = &$this->Aktual_Panen->SumViewValue;
			$ViewAttrs = &$this->Aktual_Panen->ViewAttrs;
			$CellAttrs = &$this->Aktual_Panen->CellAttrs;
			$HrefValue = &$this->Aktual_Panen->HrefValue;
			$LinkAttrs = &$this->Aktual_Panen->LinkAttrs;
			$this->Cell_Rendered($this->Aktual_Panen, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Rata_rata_Skor
			$CurrentValue = $this->Rata_rata_Skor->AvgValue;
			$ViewValue = &$this->Rata_rata_Skor->AvgViewValue;
			$ViewAttrs = &$this->Rata_rata_Skor->ViewAttrs;
			$CellAttrs = &$this->Rata_rata_Skor->CellAttrs;
			$HrefValue = &$this->Rata_rata_Skor->HrefValue;
			$LinkAttrs = &$this->Rata_rata_Skor->LinkAttrs;
			$this->Cell_Rendered($this->Rata_rata_Skor, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		} else {

			// Pic
			$CurrentValue = $this->Pic->CurrentValue;
			$ViewValue = &$this->Pic->ViewValue;
			$ViewAttrs = &$this->Pic->ViewAttrs;
			$CellAttrs = &$this->Pic->CellAttrs;
			$HrefValue = &$this->Pic->HrefValue;
			$LinkAttrs = &$this->Pic->LinkAttrs;
			$this->Cell_Rendered($this->Pic, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// varietas
			$CurrentValue = $this->varietas->CurrentValue;
			$ViewValue = &$this->varietas->ViewValue;
			$ViewAttrs = &$this->varietas->ViewAttrs;
			$CellAttrs = &$this->varietas->CellAttrs;
			$HrefValue = &$this->varietas->HrefValue;
			$LinkAttrs = &$this->varietas->LinkAttrs;
			$this->Cell_Rendered($this->varietas, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Provinsi
			$CurrentValue = $this->Provinsi->CurrentValue;
			$ViewValue = &$this->Provinsi->ViewValue;
			$ViewAttrs = &$this->Provinsi->ViewAttrs;
			$CellAttrs = &$this->Provinsi->CellAttrs;
			$HrefValue = &$this->Provinsi->HrefValue;
			$LinkAttrs = &$this->Provinsi->LinkAttrs;
			$this->Cell_Rendered($this->Provinsi, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Kabupaten
			$CurrentValue = $this->Kabupaten->CurrentValue;
			$ViewValue = &$this->Kabupaten->ViewValue;
			$ViewAttrs = &$this->Kabupaten->ViewAttrs;
			$CellAttrs = &$this->Kabupaten->CellAttrs;
			$HrefValue = &$this->Kabupaten->HrefValue;
			$LinkAttrs = &$this->Kabupaten->LinkAttrs;
			$this->Cell_Rendered($this->Kabupaten, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Koordinator
			$CurrentValue = $this->Koordinator->CurrentValue;
			$ViewValue = &$this->Koordinator->ViewValue;
			$ViewAttrs = &$this->Koordinator->ViewAttrs;
			$CellAttrs = &$this->Koordinator->CellAttrs;
			$HrefValue = &$this->Koordinator->HrefValue;
			$LinkAttrs = &$this->Koordinator->LinkAttrs;
			$this->Cell_Rendered($this->Koordinator, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Tahun
			$CurrentValue = $this->Tahun->CurrentValue;
			$ViewValue = &$this->Tahun->ViewValue;
			$ViewAttrs = &$this->Tahun->ViewAttrs;
			$CellAttrs = &$this->Tahun->CellAttrs;
			$HrefValue = &$this->Tahun->HrefValue;
			$LinkAttrs = &$this->Tahun->LinkAttrs;
			$this->Cell_Rendered($this->Tahun, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Bulan
			$CurrentValue = $this->Bulan->CurrentValue;
			$ViewValue = &$this->Bulan->ViewValue;
			$ViewAttrs = &$this->Bulan->ViewAttrs;
			$CellAttrs = &$this->Bulan->CellAttrs;
			$HrefValue = &$this->Bulan->HrefValue;
			$LinkAttrs = &$this->Bulan->LinkAttrs;
			$this->Cell_Rendered($this->Bulan, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Luas
			$CurrentValue = $this->Luas->CurrentValue;
			$ViewValue = &$this->Luas->ViewValue;
			$ViewAttrs = &$this->Luas->ViewAttrs;
			$CellAttrs = &$this->Luas->CellAttrs;
			$HrefValue = &$this->Luas->HrefValue;
			$LinkAttrs = &$this->Luas->LinkAttrs;
			$this->Cell_Rendered($this->Luas, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Estimasi_Panen
			$CurrentValue = $this->Estimasi_Panen->CurrentValue;
			$ViewValue = &$this->Estimasi_Panen->ViewValue;
			$ViewAttrs = &$this->Estimasi_Panen->ViewAttrs;
			$CellAttrs = &$this->Estimasi_Panen->CellAttrs;
			$HrefValue = &$this->Estimasi_Panen->HrefValue;
			$LinkAttrs = &$this->Estimasi_Panen->LinkAttrs;
			$this->Cell_Rendered($this->Estimasi_Panen, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Aktual_Panen
			$CurrentValue = $this->Aktual_Panen->CurrentValue;
			$ViewValue = &$this->Aktual_Panen->ViewValue;
			$ViewAttrs = &$this->Aktual_Panen->ViewAttrs;
			$CellAttrs = &$this->Aktual_Panen->CellAttrs;
			$HrefValue = &$this->Aktual_Panen->HrefValue;
			$LinkAttrs = &$this->Aktual_Panen->LinkAttrs;
			$this->Cell_Rendered($this->Aktual_Panen, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Rata_rata_Skor
			$CurrentValue = $this->Rata_rata_Skor->CurrentValue;
			$ViewValue = &$this->Rata_rata_Skor->ViewValue;
			$ViewAttrs = &$this->Rata_rata_Skor->ViewAttrs;
			$CellAttrs = &$this->Rata_rata_Skor->CellAttrs;
			$HrefValue = &$this->Rata_rata_Skor->HrefValue;
			$LinkAttrs = &$this->Rata_rata_Skor->LinkAttrs;
			$this->Cell_Rendered($this->Rata_rata_Skor, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->SetupFieldCount();
	}

	// Setup field count
	function SetupFieldCount() {
		$this->GrpColumnCount = 0;
		$this->SubGrpColumnCount = 0;
		$this->DtlColumnCount = 0;
		if ($this->Pic->Visible) $this->DtlColumnCount += 1;
		if ($this->varietas->Visible) $this->DtlColumnCount += 1;
		if ($this->Provinsi->Visible) $this->DtlColumnCount += 1;
		if ($this->Kabupaten->Visible) $this->DtlColumnCount += 1;
		if ($this->Koordinator->Visible) $this->DtlColumnCount += 1;
		if ($this->Tahun->Visible) $this->DtlColumnCount += 1;
		if ($this->Bulan->Visible) $this->DtlColumnCount += 1;
		if ($this->Luas->Visible) $this->DtlColumnCount += 1;
		if ($this->Estimasi_Panen->Visible) $this->DtlColumnCount += 1;
		if ($this->Aktual_Panen->Visible) $this->DtlColumnCount += 1;
		if ($this->Rata_rata_Skor->Visible) $this->DtlColumnCount += 1;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $ReportBreadcrumb;
		$ReportBreadcrumb = new crBreadcrumb();
		$url = substr(ewr_CurrentUrl(), strrpos(ewr_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$ReportBreadcrumb->Add("rpt", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	function SetupExportOptionsExt() {
		global $ReportLanguage, $ReportOptions;
		$ReportTypes = $ReportOptions["ReportTypes"];
		$item =& $this->ExportOptions->GetItem("pdf");
		$item->Visible = TRUE;
		if ($item->Visible)
			$ReportTypes["pdf"] = $ReportLanguage->Phrase("ReportFormPdf");
		$exportid = session_id();
		$url = $this->ExportPdfUrl;
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ewr_ExportCharts(this, '" . $url . "', '" . $exportid . "');\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$ReportOptions["ReportTypes"] = $ReportTypes;
	}

	// Return extended filter
	function GetExtendedFilter() {
		global $gsFormError;
		$sFilter = "";
		if ($this->DrillDown)
			return "";
		$bPostBack = ewr_IsHttpPost();
		$bRestoreSession = TRUE;
		$bSetupFilter = FALSE;

		// Reset extended filter if filter changed
		if ($bPostBack) {

		// Reset search command
		} elseif (@$_GET["cmd"] == "reset") {

			// Load default values
			$this->SetSessionDropDownValue($this->Pic->DropDownValue, $this->Pic->SearchOperator, 'Pic'); // Field Pic
			$this->SetSessionDropDownValue($this->varietas->DropDownValue, $this->varietas->SearchOperator, 'varietas'); // Field varietas
			$this->SetSessionDropDownValue($this->Provinsi->DropDownValue, $this->Provinsi->SearchOperator, 'Provinsi'); // Field Provinsi
			$this->SetSessionDropDownValue($this->Kabupaten->DropDownValue, $this->Kabupaten->SearchOperator, 'Kabupaten'); // Field Kabupaten
			$this->SetSessionDropDownValue($this->Koordinator->DropDownValue, $this->Koordinator->SearchOperator, 'Koordinator'); // Field Koordinator
			$this->SetSessionDropDownValue($this->Tahun->DropDownValue, $this->Tahun->SearchOperator, 'Tahun'); // Field Tahun
			$this->SetSessionDropDownValue($this->Bulan->DropDownValue, $this->Bulan->SearchOperator, 'Bulan'); // Field Bulan

			//$bSetupFilter = TRUE; // No need to set up, just use default
		} else {
			$bRestoreSession = !$this->SearchCommand;

			// Field Pic
			if ($this->GetDropDownValue($this->Pic)) {
				$bSetupFilter = TRUE;
			} elseif ($this->Pic->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_luasview_Pic'])) {
				$bSetupFilter = TRUE;
			}

			// Field varietas
			if ($this->GetDropDownValue($this->varietas)) {
				$bSetupFilter = TRUE;
			} elseif ($this->varietas->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_luasview_varietas'])) {
				$bSetupFilter = TRUE;
			}

			// Field Provinsi
			if ($this->GetDropDownValue($this->Provinsi)) {
				$bSetupFilter = TRUE;
			} elseif ($this->Provinsi->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_luasview_Provinsi'])) {
				$bSetupFilter = TRUE;
			}

			// Field Kabupaten
			if ($this->GetDropDownValue($this->Kabupaten)) {
				$bSetupFilter = TRUE;
			} elseif ($this->Kabupaten->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_luasview_Kabupaten'])) {
				$bSetupFilter = TRUE;
			}

			// Field Koordinator
			if ($this->GetDropDownValue($this->Koordinator)) {
				$bSetupFilter = TRUE;
			} elseif ($this->Koordinator->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_luasview_Koordinator'])) {
				$bSetupFilter = TRUE;
			}

			// Field Tahun
			if ($this->GetDropDownValue($this->Tahun)) {
				$bSetupFilter = TRUE;
			} elseif ($this->Tahun->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_luasview_Tahun'])) {
				$bSetupFilter = TRUE;
			}

			// Field Bulan
			if ($this->GetDropDownValue($this->Bulan)) {
				$bSetupFilter = TRUE;
			} elseif ($this->Bulan->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_luasview_Bulan'])) {
				$bSetupFilter = TRUE;
			}
			if (!$this->ValidateForm()) {
				$this->setFailureMessage($gsFormError);
				return $sFilter;
			}
		}

		// Restore session
		if ($bRestoreSession) {
			$this->GetSessionDropDownValue($this->Pic); // Field Pic
			$this->GetSessionDropDownValue($this->varietas); // Field varietas
			$this->GetSessionDropDownValue($this->Provinsi); // Field Provinsi
			$this->GetSessionDropDownValue($this->Kabupaten); // Field Kabupaten
			$this->GetSessionDropDownValue($this->Koordinator); // Field Koordinator
			$this->GetSessionDropDownValue($this->Tahun); // Field Tahun
			$this->GetSessionDropDownValue($this->Bulan); // Field Bulan
		}

		// Call page filter validated event
		$this->Page_FilterValidated();

		// Build SQL
		$this->BuildDropDownFilter($this->Pic, $sFilter, $this->Pic->SearchOperator, FALSE, TRUE); // Field Pic
		$this->BuildDropDownFilter($this->varietas, $sFilter, $this->varietas->SearchOperator, FALSE, TRUE); // Field varietas
		$this->BuildDropDownFilter($this->Provinsi, $sFilter, $this->Provinsi->SearchOperator, FALSE, TRUE); // Field Provinsi
		$this->BuildDropDownFilter($this->Kabupaten, $sFilter, $this->Kabupaten->SearchOperator, FALSE, TRUE); // Field Kabupaten
		$this->BuildDropDownFilter($this->Koordinator, $sFilter, $this->Koordinator->SearchOperator, FALSE, TRUE); // Field Koordinator
		$this->BuildDropDownFilter($this->Tahun, $sFilter, $this->Tahun->SearchOperator, FALSE, TRUE); // Field Tahun
		$this->BuildDropDownFilter($this->Bulan, $sFilter, $this->Bulan->SearchOperator, FALSE, TRUE); // Field Bulan

		// Save parms to session
		$this->SetSessionDropDownValue($this->Pic->DropDownValue, $this->Pic->SearchOperator, 'Pic'); // Field Pic
		$this->SetSessionDropDownValue($this->varietas->DropDownValue, $this->varietas->SearchOperator, 'varietas'); // Field varietas
		$this->SetSessionDropDownValue($this->Provinsi->DropDownValue, $this->Provinsi->SearchOperator, 'Provinsi'); // Field Provinsi
		$this->SetSessionDropDownValue($this->Kabupaten->DropDownValue, $this->Kabupaten->SearchOperator, 'Kabupaten'); // Field Kabupaten
		$this->SetSessionDropDownValue($this->Koordinator->DropDownValue, $this->Koordinator->SearchOperator, 'Koordinator'); // Field Koordinator
		$this->SetSessionDropDownValue($this->Tahun->DropDownValue, $this->Tahun->SearchOperator, 'Tahun'); // Field Tahun
		$this->SetSessionDropDownValue($this->Bulan->DropDownValue, $this->Bulan->SearchOperator, 'Bulan'); // Field Bulan

		// Setup filter
		if ($bSetupFilter) {
		}

		// Field Pic
		ewr_LoadDropDownList($this->Pic->DropDownList, $this->Pic->DropDownValue);

		// Field varietas
		ewr_LoadDropDownList($this->varietas->DropDownList, $this->varietas->DropDownValue);

		// Field Provinsi
		ewr_LoadDropDownList($this->Provinsi->DropDownList, $this->Provinsi->DropDownValue);

		// Field Kabupaten
		ewr_LoadDropDownList($this->Kabupaten->DropDownList, $this->Kabupaten->DropDownValue);

		// Field Koordinator
		ewr_LoadDropDownList($this->Koordinator->DropDownList, $this->Koordinator->DropDownValue);

		// Field Tahun
		ewr_LoadDropDownList($this->Tahun->DropDownList, $this->Tahun->DropDownValue);

		// Field Bulan
		ewr_LoadDropDownList($this->Bulan->DropDownList, $this->Bulan->DropDownValue);
		return $sFilter;
	}

	// Build dropdown filter
	function BuildDropDownFilter(&$fld, &$FilterClause, $FldOpr, $Default = FALSE, $SaveFilter = FALSE) {
		$FldVal = ($Default) ? $fld->DefaultDropDownValue : $fld->DropDownValue;
		$sSql = "";
		if (is_array($FldVal)) {
			foreach ($FldVal as $val) {
				$sWrk = $this->GetDropDownFilter($fld, $val, $FldOpr);

				// Call Page Filtering event
				if (substr($val, 0, 2) <> "@@") $this->Page_Filtering($fld, $sWrk, "dropdown", $FldOpr, $val);
				if ($sWrk <> "") {
					if ($sSql <> "")
						$sSql .= " OR " . $sWrk;
					else
						$sSql = $sWrk;
				}
			}
		} else {
			$sSql = $this->GetDropDownFilter($fld, $FldVal, $FldOpr);

			// Call Page Filtering event
			if (substr($FldVal, 0, 2) <> "@@") $this->Page_Filtering($fld, $sSql, "dropdown", $FldOpr, $FldVal);
		}
		if ($sSql <> "") {
			ewr_AddFilter($FilterClause, $sSql);
			if ($SaveFilter) $fld->CurrentFilter = $sSql;
		}
	}

	function GetDropDownFilter(&$fld, $FldVal, $FldOpr) {
		$FldName = $fld->FldName;
		$FldExpression = $fld->FldExpression;
		$FldDataType = $fld->FldDataType;
		$FldDelimiter = $fld->FldDelimiter;
		$FldVal = strval($FldVal);
		if ($FldOpr == "") $FldOpr = "=";
		$sWrk = "";
		if (ewr_SameStr($FldVal, EWR_NULL_VALUE)) {
			$sWrk = $FldExpression . " IS NULL";
		} elseif (ewr_SameStr($FldVal, EWR_NOT_NULL_VALUE)) {
			$sWrk = $FldExpression . " IS NOT NULL";
		} elseif (ewr_SameStr($FldVal, EWR_EMPTY_VALUE)) {
			$sWrk = $FldExpression . " = ''";
		} elseif (ewr_SameStr($FldVal, EWR_ALL_VALUE)) {
			$sWrk = "1 = 1";
		} else {
			if (substr($FldVal, 0, 2) == "@@") {
				$sWrk = $this->GetCustomFilter($fld, $FldVal, $this->DBID);
			} elseif ($FldDelimiter <> "" && trim($FldVal) <> "" && ($FldDataType == EWR_DATATYPE_STRING || $FldDataType == EWR_DATATYPE_MEMO)) {
				$sWrk = ewr_GetMultiSearchSql($FldExpression, trim($FldVal), $this->DBID);
			} else {
				if ($FldVal <> "" && $FldVal <> EWR_INIT_VALUE) {
					if ($FldDataType == EWR_DATATYPE_DATE && $FldOpr <> "") {
						$sWrk = ewr_DateFilterString($FldExpression, $FldOpr, $FldVal, $FldDataType, $this->DBID);
					} else {
						$sWrk = ewr_FilterString($FldOpr, $FldVal, $FldDataType, $this->DBID);
						if ($sWrk <> "") $sWrk = $FldExpression . $sWrk;
					}
				}
			}
		}
		return $sWrk;
	}

	// Get custom filter
	function GetCustomFilter(&$fld, $FldVal, $dbid = 0) {
		$sWrk = "";
		if (is_array($fld->AdvancedFilters)) {
			foreach ($fld->AdvancedFilters as $filter) {
				if ($filter->ID == $FldVal && $filter->Enabled) {
					$sFld = $fld->FldExpression;
					$sFn = $filter->FunctionName;
					$wrkid = (substr($filter->ID,0,2) == "@@") ? substr($filter->ID,2) : $filter->ID;
					if ($sFn <> "")
						$sWrk = $sFn($sFld, $dbid);
					else
						$sWrk = "";
					$this->Page_Filtering($fld, $sWrk, "custom", $wrkid);
					break;
				}
			}
		}
		return $sWrk;
	}

	// Build extended filter
	function BuildExtendedFilter(&$fld, &$FilterClause, $Default = FALSE, $SaveFilter = FALSE) {
		$sWrk = ewr_GetExtendedFilter($fld, $Default, $this->DBID);
		if (!$Default)
			$this->Page_Filtering($fld, $sWrk, "extended", $fld->SearchOperator, $fld->SearchValue, $fld->SearchCondition, $fld->SearchOperator2, $fld->SearchValue2);
		if ($sWrk <> "") {
			ewr_AddFilter($FilterClause, $sWrk);
			if ($SaveFilter) $fld->CurrentFilter = $sWrk;
		}
	}

	// Get drop down value from querystring
	function GetDropDownValue(&$fld) {
		$parm = substr($fld->FldVar, 2);
		if (ewr_IsHttpPost())
			return FALSE; // Skip post back
		if (isset($_GET["so_$parm"]))
			$fld->SearchOperator = ewr_StripSlashes(@$_GET["so_$parm"]);
		if (isset($_GET["sv_$parm"])) {
			$fld->DropDownValue = ewr_StripSlashes(@$_GET["sv_$parm"]);
			return TRUE;
		}
		return FALSE;
	}

	// Get filter values from querystring
	function GetFilterValues(&$fld) {
		$parm = substr($fld->FldVar, 2);
		if (ewr_IsHttpPost())
			return; // Skip post back
		$got = FALSE;
		if (isset($_GET["sv_$parm"])) {
			$fld->SearchValue = ewr_StripSlashes(@$_GET["sv_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["so_$parm"])) {
			$fld->SearchOperator = ewr_StripSlashes(@$_GET["so_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["sc_$parm"])) {
			$fld->SearchCondition = ewr_StripSlashes(@$_GET["sc_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["sv2_$parm"])) {
			$fld->SearchValue2 = ewr_StripSlashes(@$_GET["sv2_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["so2_$parm"])) {
			$fld->SearchOperator2 = ewr_StripSlashes($_GET["so2_$parm"]);
			$got = TRUE;
		}
		return $got;
	}

	// Set default ext filter
	function SetDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2) {
		$fld->DefaultSearchValue = $sv1; // Default ext filter value 1
		$fld->DefaultSearchValue2 = $sv2; // Default ext filter value 2 (if operator 2 is enabled)
		$fld->DefaultSearchOperator = $so1; // Default search operator 1
		$fld->DefaultSearchOperator2 = $so2; // Default search operator 2 (if operator 2 is enabled)
		$fld->DefaultSearchCondition = $sc; // Default search condition (if operator 2 is enabled)
	}

	// Apply default ext filter
	function ApplyDefaultExtFilter(&$fld) {
		$fld->SearchValue = $fld->DefaultSearchValue;
		$fld->SearchValue2 = $fld->DefaultSearchValue2;
		$fld->SearchOperator = $fld->DefaultSearchOperator;
		$fld->SearchOperator2 = $fld->DefaultSearchOperator2;
		$fld->SearchCondition = $fld->DefaultSearchCondition;
	}

	// Check if Text Filter applied
	function TextFilterApplied(&$fld) {
		return (strval($fld->SearchValue) <> strval($fld->DefaultSearchValue) ||
			strval($fld->SearchValue2) <> strval($fld->DefaultSearchValue2) ||
			(strval($fld->SearchValue) <> "" &&
				strval($fld->SearchOperator) <> strval($fld->DefaultSearchOperator)) ||
			(strval($fld->SearchValue2) <> "" &&
				strval($fld->SearchOperator2) <> strval($fld->DefaultSearchOperator2)) ||
			strval($fld->SearchCondition) <> strval($fld->DefaultSearchCondition));
	}

	// Check if Non-Text Filter applied
	function NonTextFilterApplied(&$fld) {
		if (is_array($fld->DropDownValue)) {
			if (is_array($fld->DefaultDropDownValue)) {
				if (count($fld->DefaultDropDownValue) <> count($fld->DropDownValue))
					return TRUE;
				else
					return (count(array_diff($fld->DefaultDropDownValue, $fld->DropDownValue)) <> 0);
			} else {
				return TRUE;
			}
		} else {
			if (is_array($fld->DefaultDropDownValue))
				return TRUE;
			else
				$v1 = strval($fld->DefaultDropDownValue);
			if ($v1 == EWR_INIT_VALUE)
				$v1 = "";
			$v2 = strval($fld->DropDownValue);
			if ($v2 == EWR_INIT_VALUE || $v2 == EWR_ALL_VALUE)
				$v2 = "";
			return ($v1 <> $v2);
		}
	}

	// Get dropdown value from session
	function GetSessionDropDownValue(&$fld) {
		$parm = substr($fld->FldVar, 2);
		$this->GetSessionValue($fld->DropDownValue, 'sv_luasview_' . $parm);
		$this->GetSessionValue($fld->SearchOperator, 'so_luasview_' . $parm);
	}

	// Get filter values from session
	function GetSessionFilterValues(&$fld) {
		$parm = substr($fld->FldVar, 2);
		$this->GetSessionValue($fld->SearchValue, 'sv_luasview_' . $parm);
		$this->GetSessionValue($fld->SearchOperator, 'so_luasview_' . $parm);
		$this->GetSessionValue($fld->SearchCondition, 'sc_luasview_' . $parm);
		$this->GetSessionValue($fld->SearchValue2, 'sv2_luasview_' . $parm);
		$this->GetSessionValue($fld->SearchOperator2, 'so2_luasview_' . $parm);
	}

	// Get value from session
	function GetSessionValue(&$sv, $sn) {
		if (array_key_exists($sn, $_SESSION))
			$sv = $_SESSION[$sn];
	}

	// Set dropdown value to session
	function SetSessionDropDownValue($sv, $so, $parm) {
		$_SESSION['sv_luasview_' . $parm] = $sv;
		$_SESSION['so_luasview_' . $parm] = $so;
	}

	// Set filter values to session
	function SetSessionFilterValues($sv1, $so1, $sc, $sv2, $so2, $parm) {
		$_SESSION['sv_luasview_' . $parm] = $sv1;
		$_SESSION['so_luasview_' . $parm] = $so1;
		$_SESSION['sc_luasview_' . $parm] = $sc;
		$_SESSION['sv2_luasview_' . $parm] = $sv2;
		$_SESSION['so2_luasview_' . $parm] = $so2;
	}

	// Check if has Session filter values
	function HasSessionFilterValues($parm) {
		return ((@$_SESSION['sv_' . $parm] <> "" && @$_SESSION['sv_' . $parm] <> EWR_INIT_VALUE) ||
			(@$_SESSION['sv_' . $parm] <> "" && @$_SESSION['sv_' . $parm] <> EWR_INIT_VALUE) ||
			(@$_SESSION['sv2_' . $parm] <> "" && @$_SESSION['sv2_' . $parm] <> EWR_INIT_VALUE));
	}

	// Dropdown filter exist
	function DropDownFilterExist(&$fld, $FldOpr) {
		$sWrk = "";
		$this->BuildDropDownFilter($fld, $sWrk, $FldOpr);
		return ($sWrk <> "");
	}

	// Extended filter exist
	function ExtendedFilterExist(&$fld) {
		$sExtWrk = "";
		$this->BuildExtendedFilter($fld, $sExtWrk);
		return ($sExtWrk <> "");
	}

	// Validate form
	function ValidateForm() {
		global $ReportLanguage, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EWR_SERVER_VALIDATE)
			return ($gsFormError == "");

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			$gsFormError .= ($gsFormError <> "") ? "<p>&nbsp;</p>" : "";
			$gsFormError .= $sFormCustomError;
		}
		return $ValidateForm;
	}

	// Clear selection stored in session
	function ClearSessionSelection($parm) {
		$_SESSION["sel_luasview_$parm"] = "";
		$_SESSION["rf_luasview_$parm"] = "";
		$_SESSION["rt_luasview_$parm"] = "";
	}

	// Load selection from session
	function LoadSelectionFromSession($parm) {
		$fld = &$this->FieldByParm($parm);
		$fld->SelectionList = @$_SESSION["sel_luasview_$parm"];
		$fld->RangeFrom = @$_SESSION["rf_luasview_$parm"];
		$fld->RangeTo = @$_SESSION["rt_luasview_$parm"];
	}

	// Load default value for filters
	function LoadDefaultFilters() {
		/**
		* Set up default values for non Text filters
		*/

		// Field Pic
		$this->Pic->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->Pic->DropDownValue = $this->Pic->DefaultDropDownValue;

		// Field varietas
		$this->varietas->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->varietas->DropDownValue = $this->varietas->DefaultDropDownValue;

		// Field Provinsi
		$this->Provinsi->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->Provinsi->DropDownValue = $this->Provinsi->DefaultDropDownValue;

		// Field Kabupaten
		$this->Kabupaten->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->Kabupaten->DropDownValue = $this->Kabupaten->DefaultDropDownValue;

		// Field Koordinator
		$this->Koordinator->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->Koordinator->DropDownValue = $this->Koordinator->DefaultDropDownValue;

		// Field Tahun
		$this->Tahun->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->Tahun->DropDownValue = $this->Tahun->DefaultDropDownValue;

		// Field Bulan
		$this->Bulan->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->Bulan->DropDownValue = $this->Bulan->DefaultDropDownValue;
		/**
		* Set up default values for extended filters
		* function SetDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
		* Parameters:
		* $fld - Field object
		* $so1 - Default search operator 1
		* $sv1 - Default ext filter value 1
		* $sc - Default search condition (if operator 2 is enabled)
		* $so2 - Default search operator 2 (if operator 2 is enabled)
		* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
		*/
		/**
		* Set up default values for popup filters
		*/
	}

	// Check if filter applied
	function CheckFilter() {

		// Check Pic extended filter
		if ($this->NonTextFilterApplied($this->Pic))
			return TRUE;

		// Check varietas extended filter
		if ($this->NonTextFilterApplied($this->varietas))
			return TRUE;

		// Check Provinsi extended filter
		if ($this->NonTextFilterApplied($this->Provinsi))
			return TRUE;

		// Check Kabupaten extended filter
		if ($this->NonTextFilterApplied($this->Kabupaten))
			return TRUE;

		// Check Koordinator extended filter
		if ($this->NonTextFilterApplied($this->Koordinator))
			return TRUE;

		// Check Tahun extended filter
		if ($this->NonTextFilterApplied($this->Tahun))
			return TRUE;

		// Check Bulan extended filter
		if ($this->NonTextFilterApplied($this->Bulan))
			return TRUE;
		return FALSE;
	}

	// Show list of filters
	function ShowFilterList($showDate = FALSE) {
		global $ReportLanguage;

		// Initialize
		$sFilterList = "";

		// Field Pic
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->Pic, $sExtWrk, $this->Pic->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Pic->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field varietas
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->varietas, $sExtWrk, $this->varietas->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->varietas->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field Provinsi
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->Provinsi, $sExtWrk, $this->Provinsi->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Provinsi->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field Kabupaten
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->Kabupaten, $sExtWrk, $this->Kabupaten->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Kabupaten->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field Koordinator
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->Koordinator, $sExtWrk, $this->Koordinator->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Koordinator->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field Tahun
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->Tahun, $sExtWrk, $this->Tahun->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Tahun->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field Bulan
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->Bulan, $sExtWrk, $this->Bulan->SearchOperator);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Bulan->FldCaption() . "</span>" . $sFilter . "</div>";
		$divstyle = "";
		$divdataclass = "";

		// Show Filters
		if ($sFilterList <> "" || $showDate) {
			$sMessage = "<div" . $divstyle . $divdataclass . "><div id=\"ewrFilterList\" class=\"alert alert-info ewDisplayTable\">";
			if ($showDate)
				$sMessage .= "<div id=\"ewrCurrentDate\">" . $ReportLanguage->Phrase("ReportGeneratedDate") . ewr_FormatDateTime(date("Y-m-d H:i:s"), 1) . "</div>";
			if ($sFilterList <> "")
				$sMessage .= "<div id=\"ewrCurrentFilters\">" . $ReportLanguage->Phrase("CurrentFilters") . "</div>" . $sFilterList;
			$sMessage .= "</div></div>";
			$this->Message_Showing($sMessage, "");
			echo $sMessage;
		}
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";

		// Field Pic
		$sWrk = "";
		$sWrk = ($this->Pic->DropDownValue <> EWR_INIT_VALUE) ? $this->Pic->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_Pic\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field varietas
		$sWrk = "";
		$sWrk = ($this->varietas->DropDownValue <> EWR_INIT_VALUE) ? $this->varietas->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_varietas\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field Provinsi
		$sWrk = "";
		$sWrk = ($this->Provinsi->DropDownValue <> EWR_INIT_VALUE) ? $this->Provinsi->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_Provinsi\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field Kabupaten
		$sWrk = "";
		$sWrk = ($this->Kabupaten->DropDownValue <> EWR_INIT_VALUE) ? $this->Kabupaten->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_Kabupaten\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field Koordinator
		$sWrk = "";
		$sWrk = ($this->Koordinator->DropDownValue <> EWR_INIT_VALUE) ? $this->Koordinator->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_Koordinator\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field Tahun
		$sWrk = "";
		$sWrk = ($this->Tahun->DropDownValue <> EWR_INIT_VALUE) ? $this->Tahun->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_Tahun\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field Bulan
		$sWrk = "";
		$sWrk = ($this->Bulan->DropDownValue <> EWR_INIT_VALUE) ? $this->Bulan->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_Bulan\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Return filter list in json
		if ($sFilterList <> "")
			return "{" . $sFilterList . "}";
		else
			return "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ewr_StripSlashes(@$_POST["filter"]), TRUE);
		return $this->SetupFilterList($filter);
	}

	// Setup list of filters
	function SetupFilterList($filter) {
		if (!is_array($filter))
			return FALSE;

		// Field Pic
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_Pic", $filter)) {
			$sWrk = $filter["sv_Pic"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_Pic"], "Pic");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "Pic");
		}

		// Field varietas
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_varietas", $filter)) {
			$sWrk = $filter["sv_varietas"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_varietas"], "varietas");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "varietas");
		}

		// Field Provinsi
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_Provinsi", $filter)) {
			$sWrk = $filter["sv_Provinsi"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_Provinsi"], "Provinsi");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "Provinsi");
		}

		// Field Kabupaten
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_Kabupaten", $filter)) {
			$sWrk = $filter["sv_Kabupaten"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_Kabupaten"], "Kabupaten");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "Kabupaten");
		}

		// Field Koordinator
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_Koordinator", $filter)) {
			$sWrk = $filter["sv_Koordinator"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_Koordinator"], "Koordinator");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "Koordinator");
		}

		// Field Tahun
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_Tahun", $filter)) {
			$sWrk = $filter["sv_Tahun"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_Tahun"], "Tahun");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "Tahun");
		}

		// Field Bulan
		$bRestoreFilter = FALSE;
		if (array_key_exists("sv_Bulan", $filter)) {
			$sWrk = $filter["sv_Bulan"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, @$filter["so_Bulan"], "Bulan");
			$bRestoreFilter = TRUE;
		}
		if (!$bRestoreFilter) { // Clear filter
			$this->SetSessionDropDownValue(EWR_INIT_VALUE, "", "Bulan");
		}
		return TRUE;
	}

	// Return popup filter
	function GetPopupFilter() {
		$sWrk = "";
		if ($this->DrillDown)
			return "";
		return $sWrk;
	}

	//-------------------------------------------------------------------------------
	// Function GetSort
	// - Return Sort parameters based on Sort Links clicked
	// - Variables setup: Session[EWR_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
	function GetSort($options = array()) {
		if ($this->DrillDown)
			return "";
		$bResetSort = @$options["resetsort"] == "1" || @$_GET["cmd"] == "resetsort";
		$orderBy = (@$options["order"] <> "") ? @$options["order"] : ewr_StripSlashes(@$_GET["order"]);
		$orderType = (@$options["ordertype"] <> "") ? @$options["ordertype"] : ewr_StripSlashes(@$_GET["ordertype"]);

		// Check for a resetsort command
		if ($bResetSort) {
			$this->setOrderBy("");
			$this->setStartGroup(1);
			$this->Pic->setSort("");
			$this->varietas->setSort("");
			$this->Provinsi->setSort("");
			$this->Kabupaten->setSort("");
			$this->Koordinator->setSort("");
			$this->Tahun->setSort("");
			$this->Bulan->setSort("");
			$this->Luas->setSort("");
			$this->Estimasi_Panen->setSort("");
			$this->Aktual_Panen->setSort("");
			$this->Rata_rata_Skor->setSort("");

		// Check for an Order parameter
		} elseif ($orderBy <> "") {
			$this->CurrentOrder = $orderBy;
			$this->CurrentOrderType = $orderType;
			$sSortSql = $this->SortSql();
			$this->setOrderBy($sSortSql);
			$this->setStartGroup(1);
		}
		return $this->getOrderBy();
	}

	// Export to HTML
	function ExportHtml($html, $options = array()) {

		//global $gsExportFile;
		//header('Content-Type: text/html' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		//header('Content-Disposition: attachment; filename=' . $gsExportFile . '.html');

		$folder = @$this->GenOptions["folder"];
		$fileName = @$this->GenOptions["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";

		// Save generate file for print
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
			$baseTag = "<base href=\"" . ewr_BaseUrl() . "\">";
			$html = preg_replace('/<head>/', '<head>' . $baseTag, $html);
			ewr_SaveFile($folder, $fileName, $html);
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file")
			echo $html;
		return $saveToFile;
	}

	// Export to WORD
	function ExportWord($html, $options = array()) {
		global $gsExportFile;
		$folder = @$options["folder"];
		$fileName = @$options["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	ewr_SaveFile(ewr_PathCombine(ewr_AppRoot(), $folder, TRUE), $fileName, $html);
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			header('Content-Type: application/vnd.ms-word' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
			header('Content-Disposition: attachment; filename=' . $gsExportFile . '.doc');
			echo $html;
		}
		return $saveToFile;
	}

	// Export to EXCEL
	function ExportExcel($html, $options = array()) {
		global $gsExportFile;
		$folder = @$options["folder"];
		$fileName = @$options["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
		 	ewr_SaveFile(ewr_PathCombine(ewr_AppRoot(), $folder, TRUE), $fileName, $html);
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			header('Content-Type: application/vnd.ms-excel' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
			header('Content-Disposition: attachment; filename=' . $gsExportFile . '.xls');
			echo $html;
		}
		return $saveToFile;
	}

	// Export PDF
	function ExportPdf($html, $options = array()) {
		global $gsExportFile;
		@ini_set("memory_limit", EWR_PDF_MEMORY_LIMIT);
		set_time_limit(EWR_PDF_TIME_LIMIT);
		if (EWR_DEBUG_ENABLED) // Add debug message
			$html = str_replace("</body>", ewr_DebugMsg() . "</body>", $html);
		$dompdf = new \Dompdf\Dompdf(array("pdf_backend" => "Cpdf"));
		$doc = new DOMDocument();
		@$doc->loadHTML('<?xml encoding="uft-8">' . ewr_ConvertToUtf8($html)); // Convert to utf-8
		$spans = $doc->getElementsByTagName("span");
		foreach ($spans as $span) {
			if ($span->getAttribute("class") == "ewFilterCaption")
				$span->parentNode->insertBefore($doc->createElement("span", ":&nbsp;"), $span->nextSibling);
		}
		$html = $doc->saveHTML();
		$html = ewr_ConvertFromUtf8($html);
		$dompdf->load_html($html);
		$dompdf->set_paper("a4", "portrait");
		$dompdf->render();
		$folder = @$options["folder"];
		$fileName = @$options["filename"];
		$responseType = @$options["responsetype"];
		$saveToFile = "";
		if ($folder <> "" && $fileName <> "" && ($responseType == "json" || $responseType == "file" && EWR_REPORT_SAVE_OUTPUT_ON_SERVER)) {
			ewr_SaveFile(ewr_PathCombine(ewr_AppRoot(), $folder, TRUE), $fileName, $dompdf->output());
			$saveToFile = ewr_UploadPathEx(FALSE, $folder) . $fileName;
		}
		if ($saveToFile == "" || $responseType == "file") {
			$sExportFile = strtolower(substr($gsExportFile, -4)) == ".pdf" ? $gsExportFile : $gsExportFile . ".pdf";
			$dompdf->stream($sExportFile, array("Attachment" => 1)); // 0 to open in browser, 1 to download
		}
		ewr_DeleteTmpImages($html);
		return $saveToFile;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ewr_Header(FALSE) ?>
<?php

// Create page object
if (!isset($luasview_rpt)) $luasview_rpt = new crluasview_rpt();
if (isset($Page)) $OldPage = $Page;
$Page = &$luasview_rpt;

// Page init
$Page->Page_Init();

// Page main
$Page->Page_Main();

// Global Page Rendering event (in ewrusrfn*.php)
Page_Rendering();

// Page Rendering event
$Page->Page_Render();
?>
<?php include_once "header.php" ?>
<?php include_once "phprptinc/header.php" ?>
<?php if ($Page->Export == "" || $Page->Export == "print" || $Page->Export == "email" && @$gsEmailContentType == "url") { ?>
<script type="text/javascript">

// Create page object
var luasview_rpt = new ewr_Page("luasview_rpt");

// Page properties
luasview_rpt.PageID = "rpt"; // Page ID
var EWR_PAGE_ID = luasview_rpt.PageID;

// Extend page with Chart_Rendering function
luasview_rpt.Chart_Rendering = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }

// Extend page with Chart_Rendered function
luasview_rpt.Chart_Rendered = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Form object
var CurrentForm = fluasviewrpt = new ewr_Form("fluasviewrpt");

// Validate method
fluasviewrpt.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);

	// Call Form Custom Validate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate method
fluasviewrpt.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }
<?php if (EWR_CLIENT_VALIDATE) { ?>
fluasviewrpt.ValidateRequired = true; // Uses JavaScript validation
<?php } else { ?>
fluasviewrpt.ValidateRequired = false; // No JavaScript validation
<?php } ?>

// Use Ajax
fluasviewrpt.Lists["sv_Pic[]"] = {"LinkField":"sv_Pic","Ajax":true,"DisplayFields":["sv_Pic","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fluasviewrpt.Lists["sv_varietas[]"] = {"LinkField":"sv_varietas","Ajax":true,"DisplayFields":["sv_varietas","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fluasviewrpt.Lists["sv_Provinsi"] = {"LinkField":"sv_Provinsi","Ajax":true,"DisplayFields":["sv_Provinsi","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fluasviewrpt.Lists["sv_Kabupaten"] = {"LinkField":"sv_Kabupaten","Ajax":true,"DisplayFields":["sv_Kabupaten","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fluasviewrpt.Lists["sv_Koordinator"] = {"LinkField":"sv_Koordinator","Ajax":true,"DisplayFields":["sv_Koordinator","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fluasviewrpt.Lists["sv_Tahun"] = {"LinkField":"sv_Tahun","Ajax":true,"DisplayFields":["sv_Tahun","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
fluasviewrpt.Lists["sv_Bulan"] = {"LinkField":"sv_Bulan","Ajax":true,"DisplayFields":["sv_Bulan","","",""],"ParentFields":[],"FilterFields":[],"Options":[],"Template":""};
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($Page->Export == "") { ?>
<!-- container (begin) -->
<div id="ewContainer" class="ewContainer">
<!-- top container (begin) -->
<div id="ewTop" class="ewTop">
<a id="top"></a>
<?php } ?>
<?php if (@$Page->GenOptions["showfilter"] == "1") { ?>
<?php $Page->ShowFilterList(TRUE) ?>
<?php } ?>
<!-- top slot -->
<div class="ewToolbar">
<?php
if (!$Page->DrillDownInPanel) {
	$Page->ExportOptions->Render("body");
	$Page->SearchOptions->Render("body");
	$Page->FilterOptions->Render("body");
	$Page->GenerateOptions->Render("body");
}
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php echo $ReportLanguage->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php $Page->ShowPageHeader(); ?>
<?php $Page->ShowMessage(); ?>
<?php if ($Page->Export == "") { ?>
</div>
<!-- top container (end) -->
	<!-- left container (begin) -->
	<div id="ewLeft" class="ewLeft">
<?php } ?>
	<!-- Left slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- left container (end) -->
	<!-- center container - report (begin) -->
	<div id="ewCenter" class="ewCenter">
<?php } ?>
	<!-- center slot -->
<!-- summary report starts -->
<?php if ($Page->Export <> "pdf") { ?>
<div id="report_summary">
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<!-- Search form (begin) -->
<form name="fluasviewrpt" id="fluasviewrpt" class="form-inline ewForm ewExtFilterForm" action="<?php echo ewr_CurrentPage() ?>">
<?php $SearchPanelClass = ($Page->Filter <> "") ? " in" : " in"; ?>
<div id="fluasviewrpt_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<div id="r_1" class="ewRow">
<div id="c_Pic" class="ewCell form-group">
	<label class="ewSearchCaption ewLabel"><?php echo $Page->Pic->FldCaption() ?></label>
	<span class="ewSearchField">
<div id="tp_sv_Pic" class="<?php echo EWR_ITEM_TEMPLATE_CLASSNAME; ?>"><input type="checkbox" data-table="luasview" data-field="x_Pic" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->Pic->DisplayValueSeparator) ? json_encode($Page->Pic->DisplayValueSeparator) : $Page->Pic->DisplayValueSeparator) ?>" name="sv_Pic[]" id="sv_Pic[]" value="{value}"<?php echo $Page->Pic->EditAttributes() ?>></div>
<div id="dsl_sv_Pic" data-repeatcolumn="10" class="ewItemList"><div>
<?php
	$cntf = is_array($Page->Pic->AdvancedFilters) ? count($Page->Pic->AdvancedFilters) : 0;
	$cntd = is_array($Page->Pic->DropDownList) ? count($Page->Pic->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->Pic->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->Pic->DropDownValue, $filter->ID) ? " checked" : "";
?>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 10, 1) ?>
<label class="checkbox-inline"><input type="checkbox" data-table="luasview" data-field="x_Pic" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->Pic->DisplayValueSeparator) ? json_encode($Page->Pic->DisplayValueSeparator) : $Page->Pic->DisplayValueSeparator) ?>" name="sv_Pic[]" value="<?php echo $filter->ID ?>"<?php echo $selwrk ?><?php echo $Page->Pic->EditAttributes() ?>><?php echo $filter->Name ?></label>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 10, 2) ?>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " checked";
?>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 10, 1) ?>
<label class="checkbox-inline"><input type="checkbox" data-table="luasview" data-field="x_Pic" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->Pic->DisplayValueSeparator) ? json_encode($Page->Pic->DisplayValueSeparator) : $Page->Pic->DisplayValueSeparator) ?>" name="sv_Pic[]" value="<?php echo $Page->Pic->DropDownList[$i] ?>"<?php echo $selwrk ?><?php echo $Page->Pic->EditAttributes() ?>><?php echo ewr_DropDownDisplayValue($Page->Pic->DropDownList[$i], "", 0) ?></label>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 10, 2) ?>
<?php
		$wrkcnt += 1;
	}
?>
</div></div>
<input type="hidden" name="s_sv_Pic" id="s_sv_Pic" value="<?php echo $Page->Pic->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_2" class="ewRow">
<div id="c_varietas" class="ewCell form-group">
	<label class="ewSearchCaption ewLabel"><?php echo $Page->varietas->FldCaption() ?></label>
	<span class="ewSearchField">
<div id="tp_sv_varietas" class="<?php echo EWR_ITEM_TEMPLATE_CLASSNAME; ?>"><input type="checkbox" data-table="luasview" data-field="x_varietas" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->varietas->DisplayValueSeparator) ? json_encode($Page->varietas->DisplayValueSeparator) : $Page->varietas->DisplayValueSeparator) ?>" name="sv_varietas[]" id="sv_varietas[]" value="{value}"<?php echo $Page->varietas->EditAttributes() ?>></div>
<div id="dsl_sv_varietas" data-repeatcolumn="10" class="ewItemList"><div>
<?php
	$cntf = is_array($Page->varietas->AdvancedFilters) ? count($Page->varietas->AdvancedFilters) : 0;
	$cntd = is_array($Page->varietas->DropDownList) ? count($Page->varietas->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->varietas->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->varietas->DropDownValue, $filter->ID) ? " checked" : "";
?>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 10, 1) ?>
<label class="checkbox-inline"><input type="checkbox" data-table="luasview" data-field="x_varietas" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->varietas->DisplayValueSeparator) ? json_encode($Page->varietas->DisplayValueSeparator) : $Page->varietas->DisplayValueSeparator) ?>" name="sv_varietas[]" value="<?php echo $filter->ID ?>"<?php echo $selwrk ?><?php echo $Page->varietas->EditAttributes() ?>><?php echo $filter->Name ?></label>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 10, 2) ?>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " checked";
?>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 10, 1) ?>
<label class="checkbox-inline"><input type="checkbox" data-table="luasview" data-field="x_varietas" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->varietas->DisplayValueSeparator) ? json_encode($Page->varietas->DisplayValueSeparator) : $Page->varietas->DisplayValueSeparator) ?>" name="sv_varietas[]" value="<?php echo $Page->varietas->DropDownList[$i] ?>"<?php echo $selwrk ?><?php echo $Page->varietas->EditAttributes() ?>><?php echo ewr_DropDownDisplayValue($Page->varietas->DropDownList[$i], "", 0) ?></label>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 10, 2) ?>
<?php
		$wrkcnt += 1;
	}
?>
</div></div>
<input type="hidden" name="s_sv_varietas" id="s_sv_varietas" value="<?php echo $Page->varietas->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_3" class="ewRow">
<div id="c_Provinsi" class="ewCell form-group">
	<label for="sv_Provinsi" class="ewSearchCaption ewLabel"><?php echo $Page->Provinsi->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->Provinsi->EditAttrs["class"], "form-control"); ?>
<select data-table="luasview" data-field="x_Provinsi" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->Provinsi->DisplayValueSeparator) ? json_encode($Page->Provinsi->DisplayValueSeparator) : $Page->Provinsi->DisplayValueSeparator) ?>" id="sv_Provinsi" name="sv_Provinsi"<?php echo $Page->Provinsi->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->Provinsi->AdvancedFilters) ? count($Page->Provinsi->AdvancedFilters) : 0;
	$cntd = is_array($Page->Provinsi->DropDownList) ? count($Page->Provinsi->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->Provinsi->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->Provinsi->DropDownValue, $filter->ID) ? " selected" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected";
?>
<option value="<?php echo $Page->Provinsi->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->Provinsi->DropDownList[$i], "", 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<input type="hidden" name="s_sv_Provinsi" id="s_sv_Provinsi" value="<?php echo $Page->Provinsi->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_4" class="ewRow">
<div id="c_Kabupaten" class="ewCell form-group">
	<label for="sv_Kabupaten" class="ewSearchCaption ewLabel"><?php echo $Page->Kabupaten->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->Kabupaten->EditAttrs["class"], "form-control"); ?>
<select data-table="luasview" data-field="x_Kabupaten" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->Kabupaten->DisplayValueSeparator) ? json_encode($Page->Kabupaten->DisplayValueSeparator) : $Page->Kabupaten->DisplayValueSeparator) ?>" id="sv_Kabupaten" name="sv_Kabupaten"<?php echo $Page->Kabupaten->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->Kabupaten->AdvancedFilters) ? count($Page->Kabupaten->AdvancedFilters) : 0;
	$cntd = is_array($Page->Kabupaten->DropDownList) ? count($Page->Kabupaten->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->Kabupaten->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->Kabupaten->DropDownValue, $filter->ID) ? " selected" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected";
?>
<option value="<?php echo $Page->Kabupaten->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->Kabupaten->DropDownList[$i], "", 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<input type="hidden" name="s_sv_Kabupaten" id="s_sv_Kabupaten" value="<?php echo $Page->Kabupaten->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_5" class="ewRow">
<div id="c_Koordinator" class="ewCell form-group">
	<label for="sv_Koordinator" class="ewSearchCaption ewLabel"><?php echo $Page->Koordinator->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->Koordinator->EditAttrs["class"], "form-control"); ?>
<select data-table="luasview" data-field="x_Koordinator" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->Koordinator->DisplayValueSeparator) ? json_encode($Page->Koordinator->DisplayValueSeparator) : $Page->Koordinator->DisplayValueSeparator) ?>" id="sv_Koordinator" name="sv_Koordinator"<?php echo $Page->Koordinator->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->Koordinator->AdvancedFilters) ? count($Page->Koordinator->AdvancedFilters) : 0;
	$cntd = is_array($Page->Koordinator->DropDownList) ? count($Page->Koordinator->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->Koordinator->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->Koordinator->DropDownValue, $filter->ID) ? " selected" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected";
?>
<option value="<?php echo $Page->Koordinator->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->Koordinator->DropDownList[$i], "", 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<input type="hidden" name="s_sv_Koordinator" id="s_sv_Koordinator" value="<?php echo $Page->Koordinator->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_6" class="ewRow">
<div id="c_Tahun" class="ewCell form-group">
	<label for="sv_Tahun" class="ewSearchCaption ewLabel"><?php echo $Page->Tahun->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->Tahun->EditAttrs["class"], "form-control"); ?>
<select data-table="luasview" data-field="x_Tahun" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->Tahun->DisplayValueSeparator) ? json_encode($Page->Tahun->DisplayValueSeparator) : $Page->Tahun->DisplayValueSeparator) ?>" id="sv_Tahun" name="sv_Tahun"<?php echo $Page->Tahun->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->Tahun->AdvancedFilters) ? count($Page->Tahun->AdvancedFilters) : 0;
	$cntd = is_array($Page->Tahun->DropDownList) ? count($Page->Tahun->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->Tahun->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->Tahun->DropDownValue, $filter->ID) ? " selected" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected";
?>
<option value="<?php echo $Page->Tahun->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->Tahun->DropDownList[$i], "", 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<input type="hidden" name="s_sv_Tahun" id="s_sv_Tahun" value="<?php echo $Page->Tahun->LookupFilterQuery() ?>"></span>
</div>
</div>
<div id="r_7" class="ewRow">
<div id="c_Bulan" class="ewCell form-group">
	<label for="sv_Bulan" class="ewSearchCaption ewLabel"><?php echo $Page->Bulan->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->Bulan->EditAttrs["class"], "form-control"); ?>
<select data-table="luasview" data-field="x_Bulan" data-value-separator="<?php echo ewr_HtmlEncode(is_array($Page->Bulan->DisplayValueSeparator) ? json_encode($Page->Bulan->DisplayValueSeparator) : $Page->Bulan->DisplayValueSeparator) ?>" id="sv_Bulan" name="sv_Bulan"<?php echo $Page->Bulan->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->Bulan->AdvancedFilters) ? count($Page->Bulan->AdvancedFilters) : 0;
	$cntd = is_array($Page->Bulan->DropDownList) ? count($Page->Bulan->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->Bulan->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->Bulan->DropDownValue, $filter->ID) ? " selected" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected";
?>
<option value="<?php echo $Page->Bulan->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->Bulan->DropDownList[$i], "", 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<input type="hidden" name="s_sv_Bulan" id="s_sv_Bulan" value="<?php echo $Page->Bulan->LookupFilterQuery() ?>"></span>
</div>
</div>
<div class="ewRow"><input type="submit" name="btnsubmit" id="btnsubmit" class="btn btn-primary" value="<?php echo $ReportLanguage->Phrase("Search") ?>">
<input type="reset" name="btnreset" id="btnreset" class="btn hide" value="<?php echo $ReportLanguage->Phrase("Reset") ?>"></div>
</div>
</form>
<script type="text/javascript">
fluasviewrpt.Init();
fluasviewrpt.FilterList = <?php echo $Page->GetFilterList() ?>;
</script>
<!-- Search form (end) -->
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->ShowFilterList() ?>
<?php } ?>
<?php

// Set the last group to display if not export all
if ($Page->ExportAll && $Page->Export <> "") {
	$Page->StopGrp = $Page->TotalGrps;
} else {
	$Page->StopGrp = $Page->StartGrp + $Page->DisplayGrps - 1;
}

// Stop group <= total number of groups
if (intval($Page->StopGrp) > intval($Page->TotalGrps))
	$Page->StopGrp = $Page->TotalGrps;
$Page->RecCount = 0;
$Page->RecIndex = 0;

// Get first row
if ($Page->TotalGrps > 0) {
	$Page->GetRow(1);
	$Page->GrpCount = 1;
}
$Page->GrpIdx = ewr_InitArray(2, -1);
$Page->GrpIdx[0] = -1;
$Page->GrpIdx[1] = $Page->StopGrp - $Page->StartGrp + 1;
while ($rs && !$rs->EOF && $Page->GrpCount <= $Page->DisplayGrps || $Page->ShowHeader) {

	// Show dummy header for custom template
	// Show header

	if ($Page->ShowHeader) {
?>
<?php if ($Page->Export <> "pdf") { ?>
<?php if ($Page->Export == "word" || $Page->Export == "excel") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } else { ?>
<div class="panel panel-default ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<thead>
	<!-- Table header -->
	<tr class="ewTableHeader">
<?php if ($Page->Pic->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Pic"><div class="luasview_Pic"><span class="ewTableHeaderCaption"><?php echo $Page->Pic->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Pic">
<?php if ($Page->SortUrl($Page->Pic) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Pic">
			<span class="ewTableHeaderCaption"><?php echo $Page->Pic->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Pic" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Pic) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Pic->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Pic->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Pic->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->varietas->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="varietas"><div class="luasview_varietas"><span class="ewTableHeaderCaption"><?php echo $Page->varietas->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="varietas">
<?php if ($Page->SortUrl($Page->varietas) == "") { ?>
		<div class="ewTableHeaderBtn luasview_varietas">
			<span class="ewTableHeaderCaption"><?php echo $Page->varietas->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_varietas" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->varietas) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->varietas->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->varietas->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->varietas->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Provinsi->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Provinsi"><div class="luasview_Provinsi"><span class="ewTableHeaderCaption"><?php echo $Page->Provinsi->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Provinsi">
<?php if ($Page->SortUrl($Page->Provinsi) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Provinsi">
			<span class="ewTableHeaderCaption"><?php echo $Page->Provinsi->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Provinsi" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Provinsi) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Provinsi->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Provinsi->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Provinsi->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Kabupaten->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Kabupaten"><div class="luasview_Kabupaten"><span class="ewTableHeaderCaption"><?php echo $Page->Kabupaten->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Kabupaten">
<?php if ($Page->SortUrl($Page->Kabupaten) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Kabupaten">
			<span class="ewTableHeaderCaption"><?php echo $Page->Kabupaten->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Kabupaten" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Kabupaten) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Kabupaten->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Kabupaten->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Kabupaten->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Koordinator->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Koordinator"><div class="luasview_Koordinator"><span class="ewTableHeaderCaption"><?php echo $Page->Koordinator->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Koordinator">
<?php if ($Page->SortUrl($Page->Koordinator) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Koordinator">
			<span class="ewTableHeaderCaption"><?php echo $Page->Koordinator->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Koordinator" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Koordinator) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Koordinator->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Koordinator->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Koordinator->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Tahun->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Tahun"><div class="luasview_Tahun"><span class="ewTableHeaderCaption"><?php echo $Page->Tahun->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Tahun">
<?php if ($Page->SortUrl($Page->Tahun) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Tahun">
			<span class="ewTableHeaderCaption"><?php echo $Page->Tahun->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Tahun" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Tahun) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Tahun->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Tahun->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Tahun->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Bulan->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Bulan"><div class="luasview_Bulan"><span class="ewTableHeaderCaption"><?php echo $Page->Bulan->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Bulan">
<?php if ($Page->SortUrl($Page->Bulan) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Bulan">
			<span class="ewTableHeaderCaption"><?php echo $Page->Bulan->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Bulan" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Bulan) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Bulan->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Bulan->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Bulan->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Luas->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Luas"><div class="luasview_Luas" style="text-align: right;"><span class="ewTableHeaderCaption"><?php echo $Page->Luas->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Luas">
<?php if ($Page->SortUrl($Page->Luas) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Luas" style="text-align: right;">
			<span class="ewTableHeaderCaption"><?php echo $Page->Luas->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Luas" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Luas) ?>',0);" style="text-align: right;">
			<span class="ewTableHeaderCaption"><?php echo $Page->Luas->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Luas->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Luas->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Estimasi_Panen->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Estimasi_Panen"><div class="luasview_Estimasi_Panen" style="text-align: right;"><span class="ewTableHeaderCaption"><?php echo $Page->Estimasi_Panen->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Estimasi_Panen">
<?php if ($Page->SortUrl($Page->Estimasi_Panen) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Estimasi_Panen" style="text-align: right;">
			<span class="ewTableHeaderCaption"><?php echo $Page->Estimasi_Panen->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Estimasi_Panen" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Estimasi_Panen) ?>',0);" style="text-align: right;">
			<span class="ewTableHeaderCaption"><?php echo $Page->Estimasi_Panen->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Estimasi_Panen->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Estimasi_Panen->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Aktual_Panen->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Aktual_Panen"><div class="luasview_Aktual_Panen" style="text-align: right;"><span class="ewTableHeaderCaption"><?php echo $Page->Aktual_Panen->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Aktual_Panen">
<?php if ($Page->SortUrl($Page->Aktual_Panen) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Aktual_Panen" style="text-align: right;">
			<span class="ewTableHeaderCaption"><?php echo $Page->Aktual_Panen->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Aktual_Panen" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Aktual_Panen) ?>',0);" style="text-align: right;">
			<span class="ewTableHeaderCaption"><?php echo $Page->Aktual_Panen->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Aktual_Panen->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Aktual_Panen->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Rata_rata_Skor->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Rata_rata_Skor"><div class="luasview_Rata_rata_Skor" style="text-align: right;"><span class="ewTableHeaderCaption"><?php echo $Page->Rata_rata_Skor->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Rata_rata_Skor">
<?php if ($Page->SortUrl($Page->Rata_rata_Skor) == "") { ?>
		<div class="ewTableHeaderBtn luasview_Rata_rata_Skor" style="text-align: right;">
			<span class="ewTableHeaderCaption"><?php echo $Page->Rata_rata_Skor->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer luasview_Rata_rata_Skor" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Rata_rata_Skor) ?>',0);" style="text-align: right;">
			<span class="ewTableHeaderCaption"><?php echo $Page->Rata_rata_Skor->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Rata_rata_Skor->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Rata_rata_Skor->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
	</tr>
</thead>
<tbody>
<?php
		if ($Page->TotalGrps == 0) break; // Show header only
		$Page->ShowHeader = FALSE;
	}
	$Page->RecCount++;
	$Page->RecIndex++;
?>
<?php

		// Render detail row
		$Page->ResetAttrs();
		$Page->RowType = EWR_ROWTYPE_DETAIL;
		$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->Pic->Visible) { ?>
		<td data-field="Pic"<?php echo $Page->Pic->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Pic"<?php echo $Page->Pic->ViewAttributes() ?>><?php echo $Page->Pic->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->varietas->Visible) { ?>
		<td data-field="varietas"<?php echo $Page->varietas->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_varietas"<?php echo $Page->varietas->ViewAttributes() ?>><?php echo $Page->varietas->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Provinsi->Visible) { ?>
		<td data-field="Provinsi"<?php echo $Page->Provinsi->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Provinsi"<?php echo $Page->Provinsi->ViewAttributes() ?>><?php echo $Page->Provinsi->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Kabupaten->Visible) { ?>
		<td data-field="Kabupaten"<?php echo $Page->Kabupaten->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Kabupaten"<?php echo $Page->Kabupaten->ViewAttributes() ?>><?php echo $Page->Kabupaten->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Koordinator->Visible) { ?>
		<td data-field="Koordinator"<?php echo $Page->Koordinator->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Koordinator"<?php echo $Page->Koordinator->ViewAttributes() ?>><?php echo $Page->Koordinator->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Tahun->Visible) { ?>
		<td data-field="Tahun"<?php echo $Page->Tahun->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Tahun"<?php echo $Page->Tahun->ViewAttributes() ?>><?php echo $Page->Tahun->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Bulan->Visible) { ?>
		<td data-field="Bulan"<?php echo $Page->Bulan->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Bulan"<?php echo $Page->Bulan->ViewAttributes() ?>><?php echo $Page->Bulan->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Luas->Visible) { ?>
		<td data-field="Luas"<?php echo $Page->Luas->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Luas"<?php echo $Page->Luas->ViewAttributes() ?>><?php echo $Page->Luas->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Estimasi_Panen->Visible) { ?>
		<td data-field="Estimasi_Panen"<?php echo $Page->Estimasi_Panen->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Estimasi_Panen"<?php echo $Page->Estimasi_Panen->ViewAttributes() ?>><?php echo $Page->Estimasi_Panen->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Aktual_Panen->Visible) { ?>
		<td data-field="Aktual_Panen"<?php echo $Page->Aktual_Panen->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Aktual_Panen"<?php echo $Page->Aktual_Panen->ViewAttributes() ?>><?php echo $Page->Aktual_Panen->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Rata_rata_Skor->Visible) { ?>
		<td data-field="Rata_rata_Skor"<?php echo $Page->Rata_rata_Skor->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_luasview_Rata_rata_Skor"<?php echo $Page->Rata_rata_Skor->ViewAttributes() ?>><?php echo $Page->Rata_rata_Skor->ListViewValue() ?></span></td>
<?php } ?>
	</tr>
<?php

		// Accumulate page summary
		$Page->AccumulateSummary();

		// Get next record
		$Page->GetRow(2);
	$Page->GrpCount++;
} // End while
?>
<?php if ($Page->TotalGrps > 0) { ?>
</tbody>
<tfoot>
	</tfoot>
<?php } elseif (!$Page->ShowHeader && FALSE) { // No header displayed ?>
<?php if ($Page->Export <> "pdf") { ?>
<?php if ($Page->Export == "word" || $Page->Export == "excel") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } else { ?>
<div class="panel panel-default ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<?php } ?>
<?php if ($Page->TotalGrps > 0 || FALSE) { // Show footer ?>
</table>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export == "" && !($Page->DrillDown && $Page->TotalGrps > 0)) { ?>
<div class="panel-footer ewGridLowerPanel">
<?php include "luasviewrptpager.php" ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<!-- Summary Report Ends -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- center container - report (end) -->
	<!-- right container (begin) -->
	<div id="ewRight" class="ewRight">
<?php } ?>
	<!-- Right slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- right container (end) -->
<div class="clearfix"></div>
<!-- bottom container (begin) -->
<div id="ewBottom" class="ewBottom">
<?php } ?>
	<!-- Bottom slot -->
<a id="cht_luasview_Chart1"></a>
<div class="">
<div id="div_ctl_luasview_Chart1" class="ewChart">
<div id="div_luasview_Chart1" class="ewChartDiv"></div>
<!-- grid component -->
<div id="div_luasview_Chart1_grid" class="ewChartGrid"></div>
</div>
</div>
<?php

// Set up chart object
$Chart = &$Table->Chart1;

// Set up chart SQL
$SqlSelect = $Table->getSqlSelect();
$SqlChartSelect = $Chart->SqlSelect;
$sSqlChartBase = $Table->getSqlFrom();

// Load chart data from sql directly
$sSql = $SqlChartSelect . $sSqlChartBase;
$sChartFilter = $Chart->SqlWhere;
ewr_AddFilter($sChartFilter, $Table->getSqlWhere());
$sSql = ewr_BuildReportSql($sSql, $sChartFilter, $Chart->SqlGroupBy, "", $Chart->SqlOrderBy, $Page->Filter, "");
$Chart->ChartSql = $sSql;
$Chart->DrillDownInPanel = $Page->DrillDownInPanel;

// Set up page break
if (($Page->Export == "print" || $Page->Export == "pdf" || $Page->Export == "email" || $Page->Export == "excel" && defined("EWR_USE_PHPEXCEL") || $Page->Export == "word" && defined("EWR_USE_PHPWORD")) && $Page->ExportChartPageBreak) {

	// Page_Breaking server event
	$Page->Page_Breaking($Page->ExportChartPageBreak, $Page->PageBreakContent);
	$Chart->PageBreakType = "before";
	$Chart->PageBreak = $Table->ExportChartPageBreak;
	$Chart->PageBreakContent = $Table->PageBreakContent;
}

// Set up show temp image
$Chart->ShowChart = ($Page->Export == "" || ($Page->Export == "print" && $Page->CustomExport == "") || ($Page->Export == "email" && @$_POST["contenttype"] == "url"));
$Chart->ShowTempImage = ($Page->Export == "pdf" || $Page->CustomExport <> "" || $Page->Export == "email" || $Page->Export == "excel" && defined("EWR_USE_PHPEXCEL") || $Page->Export == "word" && defined("EWR_USE_PHPWORD"));
?>
<?php include_once "luasview_Chart1chart.php" ?>
<?php if ($Page->Export <> "email" && !$Page->DrillDown) { ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<a href="javascript:void(0);" class="ewTopLink" onclick="$(document).scrollTop($('#top').offset().top);"><?php echo $ReportLanguage->Phrase("Top") ?></a>
<?php } ?>
<?php } ?>
<a id="cht_luasview_Chart2"></a>
<div class="">
<div id="div_ctl_luasview_Chart2" class="ewChart">
<div id="div_luasview_Chart2" class="ewChartDiv"></div>
<!-- grid component -->
<div id="div_luasview_Chart2_grid" class="ewChartGrid"></div>
</div>
</div>
<?php

// Set up chart object
$Chart = &$Table->Chart2;

// Set up chart SQL
$SqlSelect = $Table->getSqlSelect();
$SqlChartSelect = $Chart->SqlSelect;
$sSqlChartBase = $Table->getSqlFrom();
$Chart->Series[] = array($Table->Estimasi_Panen->FldCaption(), "P");
$Chart->Series[] = array($Table->Aktual_Panen->FldCaption(), "P");

// Load chart data from sql directly
$sSql = $SqlChartSelect . $sSqlChartBase;
$sChartFilter = $Chart->SqlWhere;
ewr_AddFilter($sChartFilter, $Table->getSqlWhere());
$sSql = ewr_BuildReportSql($sSql, $sChartFilter, $Chart->SqlGroupBy, "", $Chart->SqlOrderBy, $Page->Filter, "");
$Chart->ChartSql = $sSql;
$Chart->DrillDownInPanel = $Page->DrillDownInPanel;

// Set up page break
if (($Page->Export == "print" || $Page->Export == "pdf" || $Page->Export == "email" || $Page->Export == "excel" && defined("EWR_USE_PHPEXCEL") || $Page->Export == "word" && defined("EWR_USE_PHPWORD")) && $Page->ExportChartPageBreak) {

	// Page_Breaking server event
	$Page->Page_Breaking($Page->ExportChartPageBreak, $Page->PageBreakContent);
	$Chart->PageBreakType = "before";
	$Chart->PageBreak = $Table->ExportChartPageBreak;
	$Chart->PageBreakContent = $Table->PageBreakContent;
}

// Set up show temp image
$Chart->ShowChart = ($Page->Export == "" || ($Page->Export == "print" && $Page->CustomExport == "") || ($Page->Export == "email" && @$_POST["contenttype"] == "url"));
$Chart->ShowTempImage = ($Page->Export == "pdf" || $Page->CustomExport <> "" || $Page->Export == "email" || $Page->Export == "excel" && defined("EWR_USE_PHPEXCEL") || $Page->Export == "word" && defined("EWR_USE_PHPWORD"));
?>
<?php include_once "luasview_Chart2chart.php" ?>
<?php if ($Page->Export <> "email" && !$Page->DrillDown) { ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<a href="javascript:void(0);" class="ewTopLink" onclick="$(document).scrollTop($('#top').offset().top);"><?php echo $ReportLanguage->Phrase("Top") ?></a>
<?php } ?>
<?php } ?>
<a id="cht_luasview_Chart3"></a>
<div class="">
<div id="div_ctl_luasview_Chart3" class="ewChart">
<div id="div_luasview_Chart3" class="ewChartDiv"></div>
<!-- grid component -->
<div id="div_luasview_Chart3_grid" class="ewChartGrid"></div>
</div>
</div>
<?php

// Set up chart object
$Chart = &$Table->Chart3;

// Set up chart SQL
$SqlSelect = $Table->getSqlSelect();
$SqlChartSelect = $Chart->SqlSelect;
$sSqlChartBase = $Table->getSqlFrom();

// Load chart data from sql directly
$sSql = $SqlChartSelect . $sSqlChartBase;
$sChartFilter = $Chart->SqlWhere;
ewr_AddFilter($sChartFilter, $Table->getSqlWhere());
$sSql = ewr_BuildReportSql($sSql, $sChartFilter, $Chart->SqlGroupBy, "", $Chart->SqlOrderBy, $Page->Filter, "");
$Chart->ChartSql = $sSql;
$Chart->DrillDownInPanel = $Page->DrillDownInPanel;

// Set up page break
if (($Page->Export == "print" || $Page->Export == "pdf" || $Page->Export == "email" || $Page->Export == "excel" && defined("EWR_USE_PHPEXCEL") || $Page->Export == "word" && defined("EWR_USE_PHPWORD")) && $Page->ExportChartPageBreak) {

	// Page_Breaking server event
	$Page->Page_Breaking($Page->ExportChartPageBreak, $Page->PageBreakContent);
	$Chart->PageBreakType = "before";
	$Chart->PageBreak = $Table->ExportChartPageBreak;
	$Chart->PageBreakContent = $Table->PageBreakContent;
}

// Set up show temp image
$Chart->ShowChart = ($Page->Export == "" || ($Page->Export == "print" && $Page->CustomExport == "") || ($Page->Export == "email" && @$_POST["contenttype"] == "url"));
$Chart->ShowTempImage = ($Page->Export == "pdf" || $Page->CustomExport <> "" || $Page->Export == "email" || $Page->Export == "excel" && defined("EWR_USE_PHPEXCEL") || $Page->Export == "word" && defined("EWR_USE_PHPWORD"));
?>
<?php include_once "luasview_Chart3chart.php" ?>
<?php if ($Page->Export <> "email" && !$Page->DrillDown) { ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<a href="javascript:void(0);" class="ewTopLink" onclick="$(document).scrollTop($('#top').offset().top);"><?php echo $ReportLanguage->Phrase("Top") ?></a>
<?php } ?>
<?php } ?>
<?php if ($Page->Export == "") { ?>
	</div>
<!-- Bottom Container (End) -->
</div>
<!-- Table Container (End) -->
<?php } ?>
<?php $Page->ShowPageFooter(); ?>
<?php if (EWR_DEBUG_ENABLED) echo ewr_DebugMsg(); ?>
<?php

// Close recordsets
if ($rsgrp) $rsgrp->Close();
if ($rs) $rs->Close();
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "phprptinc/footer.php" ?>
<?php include_once "footer.php" ?>
<?php
$Page->Page_Terminate();
if (isset($OldPage)) $Page = $OldPage;
?>
