<?php
if (session_id() == "") session_start(); // Init session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg14.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql14.php") ?>
<?php include_once "phpfn14.php" ?>
<?php include_once "koordinfo.php" ?>
<?php include_once "employeesinfo.php" ?>
<?php include_once "userfn14.php" ?>
<?php

//
// Page class
//

$koord_addopt = NULL; // Initialize page object first

class ckoord_addopt extends ckoord {

	// Page ID
	var $PageID = 'addopt';

	// Project ID
	var $ProjectID = '{CC60B42B-604B-412A-B014-2315920AF6AA}';

	// Table name
	var $TableName = 'koord';

	// Page object name
	var $PageObjName = 'koord_addopt';

	// Page headings
	var $Heading = '';
	var $Subheading = '';

	// Page heading
	function PageHeading() {
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "TableCaption"))
			return $this->TableCaption();
		return "";
	}

	// Page subheading
	function PageSubheading() {
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->Phrase($this->PageID);
		return "";
	}

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (koord)
		if (!isset($GLOBALS["koord"]) || get_class($GLOBALS["koord"]) == "ckoord") {
			$GLOBALS["koord"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["koord"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees'])) $GLOBALS['employees'] = new cemployees();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'addopt', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'koord', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"]))
			$GLOBALS["gTimer"] = new cTimer();

		// Debug message
		ew_LoadDebugMsg();

		// Open connection
		if (!isset($conn))
			$conn = ew_Connect($this->DBID);

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new cemployees();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	//
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("koordlist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// NOTE: Security object may be needed in other part of the script, skip set to Nothing
		// 
		// Security = null;
		// 
		// Create form object

		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action
		$this->koord_id->SetVisibility();
		if ($this->IsAdd() || $this->IsCopy() || $this->IsGridAdd())
			$this->koord_id->Visible = FALSE;
		$this->koord_nama->SetVisibility();
		$this->prov_id->SetVisibility();
		$this->kab_id->SetVisibility();
		$this->kec_id->SetVisibility();
		$this->desa_id->SetVisibility();
		$this->koord_alamat->SetVisibility();
		$this->koord_hp->SetVisibility();
		$this->koord_foto->SetVisibility();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $koord;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($koord);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		// Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			ew_SaveDebugMsg();
			header("Location: " . $url);
		}
		exit();
	}

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;
		set_error_handler("ew_ErrorHandler");

		// Set up Breadcrumb
		//$this->SetupBreadcrumb(); // Not used

		$this->LoadRowValues(); // Load default values

		// Process form if post back
		if ($objForm->GetValue("a_addopt") <> "") {
			$this->CurrentAction = $objForm->GetValue("a_addopt"); // Get form action
			$this->LoadFormValues(); // Load form values

			// Validate form
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->setFailureMessage($gsFormError);
			}
		} else { // Not post back
			$this->CurrentAction = "I"; // Display blank record
		}

		// Perform action based on action code
		switch ($this->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow()) { // Add successful
					$row = array();
					$row["x_koord_id"] = $this->koord_id->DbValue;
					$row["x_koord_nama"] = ew_ConvertToUtf8($this->koord_nama->DbValue);
					$row["x_prov_id"] = $this->prov_id->DbValue;
					$row["x_kab_id"] = $this->kab_id->DbValue;
					$row["x_kec_id"] = $this->kec_id->DbValue;
					$row["x_desa_id"] = $this->desa_id->DbValue;
					$row["x_koord_alamat"] = ew_ConvertToUtf8($this->koord_alamat->DbValue);
					$row["x_koord_hp"] = ew_ConvertToUtf8($this->koord_hp->DbValue);
					$row["x_koord_foto"] = ew_ConvertToUtf8($this->koord_foto->DbValue);
					if (!EW_DEBUG_ENABLED && ob_get_length())
						ob_end_clean();
					ew_Header(FALSE, "utf-8", TRUE);
					echo ew_ArrayToJson(array($row));
				} else {
					$this->ShowMessage();
				}
				$this->Page_Terminate();
				exit();
		}

		// Render row
		$this->RowType = EW_ROWTYPE_ADD; // Render add type
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
		$this->koord_foto->Upload->Index = $objForm->Index;
		$this->koord_foto->Upload->UploadFile();
		$this->koord_foto->CurrentValue = $this->koord_foto->Upload->FileName;
	}

	// Load default values
	function LoadDefaultValues() {
		$this->koord_id->CurrentValue = NULL;
		$this->koord_id->OldValue = $this->koord_id->CurrentValue;
		$this->koord_nama->CurrentValue = NULL;
		$this->koord_nama->OldValue = $this->koord_nama->CurrentValue;
		$this->prov_id->CurrentValue = NULL;
		$this->prov_id->OldValue = $this->prov_id->CurrentValue;
		$this->kab_id->CurrentValue = NULL;
		$this->kab_id->OldValue = $this->kab_id->CurrentValue;
		$this->kec_id->CurrentValue = NULL;
		$this->kec_id->OldValue = $this->kec_id->CurrentValue;
		$this->desa_id->CurrentValue = NULL;
		$this->desa_id->OldValue = $this->desa_id->CurrentValue;
		$this->koord_alamat->CurrentValue = NULL;
		$this->koord_alamat->OldValue = $this->koord_alamat->CurrentValue;
		$this->koord_hp->CurrentValue = NULL;
		$this->koord_hp->OldValue = $this->koord_hp->CurrentValue;
		$this->koord_foto->Upload->DbValue = NULL;
		$this->koord_foto->OldValue = $this->koord_foto->Upload->DbValue;
		$this->koord_foto->CurrentValue = NULL; // Clear file related field
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->koord_nama->FldIsDetailKey) {
			$this->koord_nama->setFormValue(ew_ConvertFromUtf8($objForm->GetValue("x_koord_nama")));
		}
		if (!$this->prov_id->FldIsDetailKey) {
			$this->prov_id->setFormValue(ew_ConvertFromUtf8($objForm->GetValue("x_prov_id")));
		}
		if (!$this->kab_id->FldIsDetailKey) {
			$this->kab_id->setFormValue(ew_ConvertFromUtf8($objForm->GetValue("x_kab_id")));
		}
		if (!$this->kec_id->FldIsDetailKey) {
			$this->kec_id->setFormValue(ew_ConvertFromUtf8($objForm->GetValue("x_kec_id")));
		}
		if (!$this->desa_id->FldIsDetailKey) {
			$this->desa_id->setFormValue(ew_ConvertFromUtf8($objForm->GetValue("x_desa_id")));
		}
		if (!$this->koord_alamat->FldIsDetailKey) {
			$this->koord_alamat->setFormValue(ew_ConvertFromUtf8($objForm->GetValue("x_koord_alamat")));
		}
		if (!$this->koord_hp->FldIsDetailKey) {
			$this->koord_hp->setFormValue(ew_ConvertFromUtf8($objForm->GetValue("x_koord_hp")));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->koord_nama->CurrentValue = ew_ConvertToUtf8($this->koord_nama->FormValue);
		$this->prov_id->CurrentValue = ew_ConvertToUtf8($this->prov_id->FormValue);
		$this->kab_id->CurrentValue = ew_ConvertToUtf8($this->kab_id->FormValue);
		$this->kec_id->CurrentValue = ew_ConvertToUtf8($this->kec_id->FormValue);
		$this->desa_id->CurrentValue = ew_ConvertToUtf8($this->desa_id->FormValue);
		$this->koord_alamat->CurrentValue = ew_ConvertToUtf8($this->koord_alamat->FormValue);
		$this->koord_hp->CurrentValue = ew_ConvertToUtf8($this->koord_hp->FormValue);
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues($rs = NULL) {
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->NewRow(); 

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->koord_id->setDbValue($row['koord_id']);
		$this->koord_nama->setDbValue($row['koord_nama']);
		$this->prov_id->setDbValue($row['prov_id']);
		$this->kab_id->setDbValue($row['kab_id']);
		$this->kec_id->setDbValue($row['kec_id']);
		$this->desa_id->setDbValue($row['desa_id']);
		$this->koord_alamat->setDbValue($row['koord_alamat']);
		$this->koord_hp->setDbValue($row['koord_hp']);
		$this->koord_foto->Upload->DbValue = $row['koord_foto'];
		$this->koord_foto->setDbValue($this->koord_foto->Upload->DbValue);
	}

	// Return a row with default values
	function NewRow() {
		$this->LoadDefaultValues();
		$row = array();
		$row['koord_id'] = $this->koord_id->CurrentValue;
		$row['koord_nama'] = $this->koord_nama->CurrentValue;
		$row['prov_id'] = $this->prov_id->CurrentValue;
		$row['kab_id'] = $this->kab_id->CurrentValue;
		$row['kec_id'] = $this->kec_id->CurrentValue;
		$row['desa_id'] = $this->desa_id->CurrentValue;
		$row['koord_alamat'] = $this->koord_alamat->CurrentValue;
		$row['koord_hp'] = $this->koord_hp->CurrentValue;
		$row['koord_foto'] = $this->koord_foto->Upload->DbValue;
		return $row;
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->koord_id->DbValue = $row['koord_id'];
		$this->koord_nama->DbValue = $row['koord_nama'];
		$this->prov_id->DbValue = $row['prov_id'];
		$this->kab_id->DbValue = $row['kab_id'];
		$this->kec_id->DbValue = $row['kec_id'];
		$this->desa_id->DbValue = $row['desa_id'];
		$this->koord_alamat->DbValue = $row['koord_alamat'];
		$this->koord_hp->DbValue = $row['koord_hp'];
		$this->koord_foto->Upload->DbValue = $row['koord_foto'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// koord_id
		// koord_nama
		// prov_id
		// kab_id
		// kec_id
		// desa_id
		// koord_alamat
		// koord_hp
		// koord_foto

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// koord_id
		$this->koord_id->ViewValue = $this->koord_id->CurrentValue;
		$this->koord_id->ViewCustomAttributes = "";

		// koord_nama
		$this->koord_nama->ViewValue = $this->koord_nama->CurrentValue;
		$this->koord_nama->ViewCustomAttributes = "";

		// prov_id
		if (strval($this->prov_id->CurrentValue) <> "") {
			$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
		$sWhereWrk = "";
		$this->prov_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->prov_id->ViewValue = $this->prov_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->prov_id->ViewValue = $this->prov_id->CurrentValue;
			}
		} else {
			$this->prov_id->ViewValue = NULL;
		}
		$this->prov_id->ViewCustomAttributes = "";

		// kab_id
		if (strval($this->kab_id->CurrentValue) <> "") {
			$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
		$sWhereWrk = "";
		$this->kab_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kab_id->ViewValue = $this->kab_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kab_id->ViewValue = $this->kab_id->CurrentValue;
			}
		} else {
			$this->kab_id->ViewValue = NULL;
		}
		$this->kab_id->ViewCustomAttributes = "";

		// kec_id
		if (strval($this->kec_id->CurrentValue) <> "") {
			$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
		$sWhereWrk = "";
		$this->kec_id->LookupFilters = array();
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
		$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->kec_id->ViewValue = $this->kec_id->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->kec_id->ViewValue = $this->kec_id->CurrentValue;
			}
		} else {
			$this->kec_id->ViewValue = NULL;
		}
		$this->kec_id->CssStyle = "font-weight: bold;";
		$this->kec_id->ViewCustomAttributes = "";

		// desa_id
		$this->desa_id->ViewValue = $this->desa_id->CurrentValue;
		$this->desa_id->ViewCustomAttributes = "";

		// koord_alamat
		$this->koord_alamat->ViewValue = $this->koord_alamat->CurrentValue;
		$this->koord_alamat->ViewCustomAttributes = "";

		// koord_hp
		$this->koord_hp->ViewValue = $this->koord_hp->CurrentValue;
		$this->koord_hp->ViewCustomAttributes = "";

		// koord_foto
		$this->koord_foto->UploadPath = "foto_koordinator";
		if (!ew_Empty($this->koord_foto->Upload->DbValue)) {
			$this->koord_foto->ImageWidth = 30;
			$this->koord_foto->ImageHeight = 40;
			$this->koord_foto->ImageAlt = $this->koord_foto->FldAlt();
			$this->koord_foto->ViewValue = $this->koord_foto->Upload->DbValue;
		} else {
			$this->koord_foto->ViewValue = "";
		}
		$this->koord_foto->ViewCustomAttributes = "";

			// koord_id
			$this->koord_id->LinkCustomAttributes = "";
			$this->koord_id->HrefValue = "";
			$this->koord_id->TooltipValue = "";

			// koord_nama
			$this->koord_nama->LinkCustomAttributes = "";
			$this->koord_nama->HrefValue = "";
			$this->koord_nama->TooltipValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";
			$this->prov_id->TooltipValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";
			$this->kab_id->TooltipValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";
			$this->kec_id->TooltipValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";
			$this->desa_id->TooltipValue = "";

			// koord_alamat
			$this->koord_alamat->LinkCustomAttributes = "";
			$this->koord_alamat->HrefValue = "";
			$this->koord_alamat->TooltipValue = "";

			// koord_hp
			$this->koord_hp->LinkCustomAttributes = "";
			$this->koord_hp->HrefValue = "";
			$this->koord_hp->TooltipValue = "";

			// koord_foto
			$this->koord_foto->LinkCustomAttributes = "";
			$this->koord_foto->UploadPath = "foto_koordinator";
			if (!ew_Empty($this->koord_foto->Upload->DbValue)) {
				$this->koord_foto->HrefValue = ew_GetFileUploadUrl($this->koord_foto, $this->koord_foto->Upload->DbValue); // Add prefix/suffix
				$this->koord_foto->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_foto->HrefValue = ew_FullUrl($this->koord_foto->HrefValue, "href");
			} else {
				$this->koord_foto->HrefValue = "";
			}
			$this->koord_foto->HrefValue2 = $this->koord_foto->UploadPath . $this->koord_foto->Upload->DbValue;
			$this->koord_foto->TooltipValue = "";
			if ($this->koord_foto->UseColorbox) {
				if (ew_Empty($this->koord_foto->TooltipValue))
					$this->koord_foto->LinkAttrs["title"] = $Language->Phrase("ViewImageGallery");
				$this->koord_foto->LinkAttrs["data-rel"] = "koord_x_koord_foto";
				ew_AppendClass($this->koord_foto->LinkAttrs["class"], "ewLightbox");
			}
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// koord_id
			// koord_nama

			$this->koord_nama->EditAttrs["class"] = "form-control";
			$this->koord_nama->EditCustomAttributes = "";
			$this->koord_nama->EditValue = ew_HtmlEncode($this->koord_nama->CurrentValue);
			$this->koord_nama->PlaceHolder = ew_RemoveHtml($this->koord_nama->FldCaption());

			// prov_id
			$this->prov_id->EditAttrs["class"] = "form-control";
			$this->prov_id->EditCustomAttributes = "";
			if (trim(strval($this->prov_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`prov_id`" . ew_SearchString("=", $this->prov_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `prov_id`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `prov`";
			$sWhereWrk = "";
			$this->prov_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->prov_id->EditValue = $arwrk;

			// kab_id
			$this->kab_id->EditAttrs["class"] = "form-control";
			$this->kab_id->EditCustomAttributes = "";
			if (trim(strval($this->kab_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kab_id`" . ew_SearchString("=", $this->kab_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kab_id`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, `kab_prov_id` AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kab`";
			$sWhereWrk = "";
			$this->kab_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kab_id->EditValue = $arwrk;

			// kec_id
			$this->kec_id->EditAttrs["class"] = "form-control";
			$this->kec_id->EditCustomAttributes = "";
			if (trim(strval($this->kec_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`kec_id`" . ew_SearchString("=", $this->kec_id->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `kec_id`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `kec`";
			$sWhereWrk = "";
			$this->kec_id->LookupFilters = array();
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			$this->kec_id->EditValue = $arwrk;

			// desa_id
			$this->desa_id->EditAttrs["class"] = "form-control";
			$this->desa_id->EditCustomAttributes = "";
			$this->desa_id->EditValue = ew_HtmlEncode($this->desa_id->CurrentValue);
			$this->desa_id->PlaceHolder = ew_RemoveHtml($this->desa_id->FldCaption());

			// koord_alamat
			$this->koord_alamat->EditAttrs["class"] = "form-control";
			$this->koord_alamat->EditCustomAttributes = "";
			$this->koord_alamat->EditValue = ew_HtmlEncode($this->koord_alamat->CurrentValue);
			$this->koord_alamat->PlaceHolder = ew_RemoveHtml($this->koord_alamat->FldCaption());

			// koord_hp
			$this->koord_hp->EditAttrs["class"] = "form-control";
			$this->koord_hp->EditCustomAttributes = "";
			$this->koord_hp->EditValue = ew_HtmlEncode($this->koord_hp->CurrentValue);
			$this->koord_hp->PlaceHolder = ew_RemoveHtml($this->koord_hp->FldCaption());

			// koord_foto
			$this->koord_foto->EditAttrs["class"] = "form-control";
			$this->koord_foto->EditCustomAttributes = "";
			$this->koord_foto->UploadPath = "foto_koordinator";
			if (!ew_Empty($this->koord_foto->Upload->DbValue)) {
				$this->koord_foto->ImageWidth = 30;
				$this->koord_foto->ImageHeight = 40;
				$this->koord_foto->ImageAlt = $this->koord_foto->FldAlt();
				$this->koord_foto->EditValue = $this->koord_foto->Upload->DbValue;
			} else {
				$this->koord_foto->EditValue = "";
			}
			if (!ew_Empty($this->koord_foto->CurrentValue))
					$this->koord_foto->Upload->FileName = $this->koord_foto->CurrentValue;
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->koord_foto);

			// Add refer script
			// koord_id

			$this->koord_id->LinkCustomAttributes = "";
			$this->koord_id->HrefValue = "";

			// koord_nama
			$this->koord_nama->LinkCustomAttributes = "";
			$this->koord_nama->HrefValue = "";

			// prov_id
			$this->prov_id->LinkCustomAttributes = "";
			$this->prov_id->HrefValue = "";

			// kab_id
			$this->kab_id->LinkCustomAttributes = "";
			$this->kab_id->HrefValue = "";

			// kec_id
			$this->kec_id->LinkCustomAttributes = "";
			$this->kec_id->HrefValue = "";

			// desa_id
			$this->desa_id->LinkCustomAttributes = "";
			$this->desa_id->HrefValue = "";

			// koord_alamat
			$this->koord_alamat->LinkCustomAttributes = "";
			$this->koord_alamat->HrefValue = "";

			// koord_hp
			$this->koord_hp->LinkCustomAttributes = "";
			$this->koord_hp->HrefValue = "";

			// koord_foto
			$this->koord_foto->LinkCustomAttributes = "";
			$this->koord_foto->UploadPath = "foto_koordinator";
			if (!ew_Empty($this->koord_foto->Upload->DbValue)) {
				$this->koord_foto->HrefValue = ew_GetFileUploadUrl($this->koord_foto, $this->koord_foto->Upload->DbValue); // Add prefix/suffix
				$this->koord_foto->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->Export <> "") $this->koord_foto->HrefValue = ew_FullUrl($this->koord_foto->HrefValue, "href");
			} else {
				$this->koord_foto->HrefValue = "";
			}
			$this->koord_foto->HrefValue2 = $this->koord_foto->UploadPath . $this->koord_foto->Upload->DbValue;
		}
		if ($this->RowType == EW_ROWTYPE_ADD || $this->RowType == EW_ROWTYPE_EDIT || $this->RowType == EW_ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->SetupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ew_CheckInteger($this->koord_id->FormValue)) {
			ew_AddMessage($gsFormError, $this->koord_id->FldErrMsg());
		}
		if (!$this->prov_id->FldIsDetailKey && !is_null($this->prov_id->FormValue) && $this->prov_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->prov_id->FldCaption(), $this->prov_id->ReqErrMsg));
		}
		if (!$this->kab_id->FldIsDetailKey && !is_null($this->kab_id->FormValue) && $this->kab_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->kab_id->FldCaption(), $this->kab_id->ReqErrMsg));
		}
		if (!$this->kec_id->FldIsDetailKey && !is_null($this->kec_id->FormValue) && $this->kec_id->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->kec_id->FldCaption(), $this->kec_id->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->desa_id->FormValue)) {
			ew_AddMessage($gsFormError, $this->desa_id->FldErrMsg());
		}
		if (!$this->koord_alamat->FldIsDetailKey && !is_null($this->koord_alamat->FormValue) && $this->koord_alamat->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->koord_alamat->FldCaption(), $this->koord_alamat->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->koord_hp->FormValue)) {
			ew_AddMessage($gsFormError, $this->koord_hp->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;
		$conn = &$this->Connection();

		// Load db values from rsold
		$this->LoadDbValues($rsold);
		if ($rsold) {
			$this->koord_foto->OldUploadPath = "foto_koordinator";
			$this->koord_foto->UploadPath = $this->koord_foto->OldUploadPath;
		}
		$rsnew = array();

		// koord_nama
		$this->koord_nama->SetDbValueDef($rsnew, $this->koord_nama->CurrentValue, NULL, FALSE);

		// prov_id
		$this->prov_id->SetDbValueDef($rsnew, $this->prov_id->CurrentValue, NULL, FALSE);

		// kab_id
		$this->kab_id->SetDbValueDef($rsnew, $this->kab_id->CurrentValue, NULL, FALSE);

		// kec_id
		$this->kec_id->SetDbValueDef($rsnew, $this->kec_id->CurrentValue, NULL, FALSE);

		// desa_id
		$this->desa_id->SetDbValueDef($rsnew, $this->desa_id->CurrentValue, NULL, FALSE);

		// koord_alamat
		$this->koord_alamat->SetDbValueDef($rsnew, $this->koord_alamat->CurrentValue, NULL, FALSE);

		// koord_hp
		$this->koord_hp->SetDbValueDef($rsnew, $this->koord_hp->CurrentValue, NULL, FALSE);

		// koord_foto
		if ($this->koord_foto->Visible && !$this->koord_foto->Upload->KeepFile) {
			$this->koord_foto->Upload->DbValue = ""; // No need to delete old file
			if ($this->koord_foto->Upload->FileName == "") {
				$rsnew['koord_foto'] = NULL;
			} else {
				$rsnew['koord_foto'] = $this->koord_foto->Upload->FileName;
			}
			$this->koord_foto->ImageWidth = 300; // Resize width
			$this->koord_foto->ImageHeight = 400; // Resize height
		}
		if ($this->koord_foto->Visible && !$this->koord_foto->Upload->KeepFile) {
			$this->koord_foto->UploadPath = "foto_koordinator";
			$OldFiles = ew_Empty($this->koord_foto->Upload->DbValue) ? array() : array($this->koord_foto->Upload->DbValue);
			if (!ew_Empty($this->koord_foto->Upload->FileName)) {
				$NewFiles = array($this->koord_foto->Upload->FileName);
				$NewFileCount = count($NewFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					$fldvar = ($this->koord_foto->Upload->Index < 0) ? $this->koord_foto->FldVar : substr($this->koord_foto->FldVar, 0, 1) . $this->koord_foto->Upload->Index . substr($this->koord_foto->FldVar, 1);
					if ($NewFiles[$i] <> "") {
						$file = $NewFiles[$i];
						if (file_exists(ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $file)) {
							$OldFileFound = FALSE;
							$OldFileCount = count($OldFiles);
							for ($j = 0; $j < $OldFileCount; $j++) {
								$file1 = $OldFiles[$j];
								if ($file1 == $file) { // Old file found, no need to delete anymore
									unset($OldFiles[$j]);
									$OldFileFound = TRUE;
									break;
								}
							}
							if ($OldFileFound) // No need to check if file exists further
								continue;
							$file1 = ew_UploadFileNameEx($this->koord_foto->PhysicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $file1) || file_exists($this->koord_foto->PhysicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = ew_UniqueFilename($this->koord_foto->PhysicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $file, ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $file1);
								$NewFiles[$i] = $file1;
							}
						}
					}
				}
				$this->koord_foto->Upload->DbValue = empty($OldFiles) ? "" : implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $OldFiles);
				$this->koord_foto->Upload->FileName = implode(EW_MULTIPLE_UPLOAD_SEPARATOR, $NewFiles);
				$this->koord_foto->SetDbValueDef($rsnew, $this->koord_foto->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
				if ($this->koord_foto->Visible && !$this->koord_foto->Upload->KeepFile) {
					$OldFiles = ew_Empty($this->koord_foto->Upload->DbValue) ? array() : array($this->koord_foto->Upload->DbValue);
					if (!ew_Empty($this->koord_foto->Upload->FileName)) {
						$NewFiles = array($this->koord_foto->Upload->FileName);
						$NewFiles2 = array($rsnew['koord_foto']);
						$NewFileCount = count($NewFiles);
						for ($i = 0; $i < $NewFileCount; $i++) {
							$fldvar = ($this->koord_foto->Upload->Index < 0) ? $this->koord_foto->FldVar : substr($this->koord_foto->FldVar, 0, 1) . $this->koord_foto->Upload->Index . substr($this->koord_foto->FldVar, 1);
							if ($NewFiles[$i] <> "") {
								$file = ew_UploadTempPath($fldvar, $this->koord_foto->TblVar) . $NewFiles[$i];
								if (file_exists($file)) {
									if (@$NewFiles2[$i] <> "") // Use correct file name
										$NewFiles[$i] = $NewFiles2[$i];
									if (!$this->koord_foto->Upload->ResizeAndSaveToFile($this->koord_foto->ImageWidth, $this->koord_foto->ImageHeight, EW_THUMBNAIL_DEFAULT_QUALITY, $NewFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->Phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$NewFiles = array();
					}
					$OldFileCount = count($OldFiles);
					for ($i = 0; $i < $OldFileCount; $i++) {
						if ($OldFiles[$i] <> "" && !in_array($OldFiles[$i], $NewFiles))
							@unlink($this->koord_foto->OldPhysicalUploadPath() . $OldFiles[$i]);
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}

		// koord_foto
		ew_CleanUploadTempPath($this->koord_foto, $this->koord_foto->Upload->Index);
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("koordlist.php"), "", $this->TableVar, TRUE);
		$PageId = "addopt";
		$Breadcrumb->Add("addopt", $PageId, $url);
	}

	// Setup lookup filters of a field
	function SetupLookupFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		case "x_prov_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `prov_id` AS `LinkFld`, `prov_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `prov`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`prov_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->prov_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kab_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kab_id` AS `LinkFld`, `kab_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kab`";
			$sWhereWrk = "{filter}";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kab_id` IN ({filter_value})', "t0" => "3", "fn0" => "", "f1" => '`kab_prov_id` IN ({filter_value})', "t1" => "3", "fn1" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kab_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kab_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		case "x_kec_id":
			$sSqlWrk = "";
			$sSqlWrk = "SELECT `kec_id` AS `LinkFld`, `kec_nama` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `kec`";
			$sWhereWrk = "";
			$fld->LookupFilters = array();
			$fld->LookupFilters += array("s" => $sSqlWrk, "d" => "", "f0" => '`kec_id` IN ({filter_value})', "t0" => "3", "fn0" => "");
			$sSqlWrk = "";
			$this->Lookup_Selecting($this->kec_id, $sWhereWrk); // Call Lookup Selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$sSqlWrk .= " ORDER BY `kec_nama` ASC";
			if ($sSqlWrk <> "")
				$fld->LookupFilters["s"] .= $sSqlWrk;
			break;
		}
	}

	// Setup AutoSuggest filters of a field
	function SetupAutoSuggestFilters($fld, $pageId = null) {
		global $gsLanguage;
		$pageId = $pageId ?: $this->PageID;
		switch ($fld->FldVar) {
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Custom validate event
	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($koord_addopt)) $koord_addopt = new ckoord_addopt();

// Page init
$koord_addopt->Page_Init();

// Page main
$koord_addopt->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$koord_addopt->Page_Render();
?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "addopt";
var CurrentForm = fkoordaddopt = new ew_Form("fkoordaddopt", "addopt");

// Validate form
fkoordaddopt.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_koord_id");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($koord->koord_id->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_prov_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $koord->prov_id->FldCaption(), $koord->prov_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_kab_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $koord->kab_id->FldCaption(), $koord->kab_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_kec_id");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $koord->kec_id->FldCaption(), $koord->kec_id->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_desa_id");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($koord->desa_id->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_koord_alamat");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $koord->koord_alamat->FldCaption(), $koord->koord_alamat->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_koord_hp");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($koord->koord_hp->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fkoordaddopt.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid.
 	return true;
 }

// Use JavaScript validation or not
fkoordaddopt.ValidateRequired = <?php echo json_encode(EW_CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fkoordaddopt.Lists["x_prov_id"] = {"LinkField":"x_prov_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_prov_nama","","",""],"ParentFields":[],"ChildFields":["x_kab_id"],"FilterFields":[],"Options":[],"Template":"","LinkTable":"prov"};
fkoordaddopt.Lists["x_prov_id"].Data = "<?php echo $koord_addopt->prov_id->LookupFilterQuery(FALSE, "addopt") ?>";
fkoordaddopt.Lists["x_kab_id"] = {"LinkField":"x_kab_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kab_nama","","",""],"ParentFields":["x_prov_id"],"ChildFields":[],"FilterFields":["x_kab_prov_id"],"Options":[],"Template":"","LinkTable":"kab"};
fkoordaddopt.Lists["x_kab_id"].Data = "<?php echo $koord_addopt->kab_id->LookupFilterQuery(FALSE, "addopt") ?>";
fkoordaddopt.Lists["x_kec_id"] = {"LinkField":"x_kec_id","Ajax":true,"AutoFill":false,"DisplayFields":["x_kec_nama","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":"","LinkTable":"kec"};
fkoordaddopt.Lists["x_kec_id"].Data = "<?php echo $koord_addopt->kec_id->LookupFilterQuery(FALSE, "addopt") ?>";

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php
$koord_addopt->ShowMessage();
?>
<form name="fkoordaddopt" id="fkoordaddopt" class="ewForm form-horizontal" action="koordaddopt.php" method="post">
<?php if ($koord_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $koord_addopt->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="koord">
<input type="hidden" name="a_addopt" id="a_addopt" value="A">
<?php if ($koord->koord_id->Visible) { // koord_id ?>
<?php } ?>
<?php if ($koord->koord_nama->Visible) { // koord_nama ?>
	<div class="form-group">
		<label class="col-sm-2 control-label ewLabel" for="x_koord_nama"><?php echo $koord->koord_nama->FldCaption() ?></label>
		<div class="col-sm-10">
<input type="text" data-table="koord" data-field="x_koord_nama" name="x_koord_nama" id="x_koord_nama" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($koord->koord_nama->getPlaceHolder()) ?>" value="<?php echo $koord->koord_nama->EditValue ?>"<?php echo $koord->koord_nama->EditAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($koord->prov_id->Visible) { // prov_id ?>
	<div class="form-group">
		<label class="col-sm-2 control-label ewLabel" for="x_prov_id"><?php echo $koord->prov_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10">
<?php $koord->prov_id->EditAttrs["onchange"] = "ew_UpdateOpt.call(this); " . @$koord->prov_id->EditAttrs["onchange"]; ?>
<select data-table="koord" data-field="x_prov_id" data-value-separator="<?php echo $koord->prov_id->DisplayValueSeparatorAttribute() ?>" id="x_prov_id" name="x_prov_id"<?php echo $koord->prov_id->EditAttributes() ?>>
<?php echo $koord->prov_id->SelectOptionListHtml("x_prov_id") ?>
</select>
</div>
	</div>
<?php } ?>
<?php if ($koord->kab_id->Visible) { // kab_id ?>
	<div class="form-group">
		<label class="col-sm-2 control-label ewLabel" for="x_kab_id"><?php echo $koord->kab_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10">
<select data-table="koord" data-field="x_kab_id" data-value-separator="<?php echo $koord->kab_id->DisplayValueSeparatorAttribute() ?>" id="x_kab_id" name="x_kab_id"<?php echo $koord->kab_id->EditAttributes() ?>>
<?php echo $koord->kab_id->SelectOptionListHtml("x_kab_id") ?>
</select>
</div>
	</div>
<?php } ?>
<?php if ($koord->kec_id->Visible) { // kec_id ?>
	<div class="form-group">
		<label class="col-sm-2 control-label ewLabel" for="x_kec_id"><?php echo $koord->kec_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10">
<select data-table="koord" data-field="x_kec_id" data-value-separator="<?php echo $koord->kec_id->DisplayValueSeparatorAttribute() ?>" id="x_kec_id" name="x_kec_id"<?php echo $koord->kec_id->EditAttributes() ?>>
<?php echo $koord->kec_id->SelectOptionListHtml("x_kec_id") ?>
</select>
</div>
	</div>
<?php } ?>
<?php if ($koord->desa_id->Visible) { // desa_id ?>
	<div class="form-group">
		<label class="col-sm-2 control-label ewLabel" for="x_desa_id"><?php echo $koord->desa_id->FldCaption() ?></label>
		<div class="col-sm-10">
<input type="text" data-table="koord" data-field="x_desa_id" name="x_desa_id" id="x_desa_id" size="30" placeholder="<?php echo ew_HtmlEncode($koord->desa_id->getPlaceHolder()) ?>" value="<?php echo $koord->desa_id->EditValue ?>"<?php echo $koord->desa_id->EditAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($koord->koord_alamat->Visible) { // koord_alamat ?>
	<div class="form-group">
		<label class="col-sm-2 control-label ewLabel" for="x_koord_alamat"><?php echo $koord->koord_alamat->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10">
<input type="text" data-table="koord" data-field="x_koord_alamat" name="x_koord_alamat" id="x_koord_alamat" size="30" maxlength="200" placeholder="<?php echo ew_HtmlEncode($koord->koord_alamat->getPlaceHolder()) ?>" value="<?php echo $koord->koord_alamat->EditValue ?>"<?php echo $koord->koord_alamat->EditAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($koord->koord_hp->Visible) { // koord_hp ?>
	<div class="form-group">
		<label class="col-sm-2 control-label ewLabel" for="x_koord_hp"><?php echo $koord->koord_hp->FldCaption() ?></label>
		<div class="col-sm-10">
<input type="text" data-table="koord" data-field="x_koord_hp" name="x_koord_hp" id="x_koord_hp" size="30" placeholder="<?php echo ew_HtmlEncode($koord->koord_hp->getPlaceHolder()) ?>" value="<?php echo $koord->koord_hp->EditValue ?>"<?php echo $koord->koord_hp->EditAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($koord->koord_foto->Visible) { // koord_foto ?>
	<div class="form-group">
		<label class="col-sm-2 control-label ewLabel"><?php echo $koord->koord_foto->FldCaption() ?></label>
		<div class="col-sm-10">
<div id="fd_x_koord_foto">
<span title="<?php echo $koord->koord_foto->FldTitle() ? $koord->koord_foto->FldTitle() : $Language->Phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ewTooltip<?php if ($koord->koord_foto->ReadOnly || $koord->koord_foto->Disabled) echo " hide"; ?>" data-trigger="hover">
	<span><?php echo $Language->Phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="koord" data-field="x_koord_foto" name="x_koord_foto" id="x_koord_foto"<?php echo $koord->koord_foto->EditAttributes() ?>>
</span>
<input type="hidden" name="fn_x_koord_foto" id= "fn_x_koord_foto" value="<?php echo $koord->koord_foto->Upload->FileName ?>">
<input type="hidden" name="fa_x_koord_foto" id= "fa_x_koord_foto" value="0">
<input type="hidden" name="fs_x_koord_foto" id= "fs_x_koord_foto" value="50">
<input type="hidden" name="fx_x_koord_foto" id= "fx_x_koord_foto" value="<?php echo $koord->koord_foto->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_koord_foto" id= "fm_x_koord_foto" value="<?php echo $koord->koord_foto->UploadMaxFileSize ?>">
</div>
<table id="ft_x_koord_foto" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</div>
	</div>
<?php } ?>
</form>
<script type="text/javascript">
fkoordaddopt.Init();
</script>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$koord_addopt->Page_Terminate();
?>
